 MAST    CAT                   -CATALOG040                  ABSTRACT040   B	

        CATALOG DOC   &            CLEANUP COM                   HEXDUMP ASM   E        /       DOC                   ALLOC   DOC                   DI      ASM   n !"#$%&'()*+,   DI      COM   -.               PGEN    ASM   "/0123            PBOOT   ASM   45               BOOTER  ASM   6789:;<=>?@ABCDE BOOTER  ASM  FGHIJKLMNOPQRSTU BOOTER  ASM  "VWXYZ            DU      ASM   [\]^_`abcdefghij SPASCAL DOC   7          CK-FIX  DOC                   CV      DOC                   D       DOC                   DU      DOC                   EJECT   ASM                  (ASM.COM
DDT.COM
LOAD.COM
PIP.COM
SID.COM
STAT.COM
SUB.COM
SUBMIT.COM)
VOLUME 40

Various utilities, disk cataloging system, modem programs.

NUMBER	SIZE	NAME		COMMENTS

		-CATALOG.040	CONTENTS OF CP/M VOL. 40
		ABSTRACT.040	Abstract on some of the files.
40.1	1K	/.COM		Quickie submit; Example:
40.2	1K	/.DOC		/ asm foo.bbz;load b:foo
40.3	1K	ALLOC.COM	Prints bit map of disk usage..
40.4	1K	ALLOC.DOC	..(update of prev 1.3 only one)
40.5	37K	BOOTER.ASM	Pascal boot for Tarbell & Delta
40.6	1K	CAT.COM		Part of master cataloging sys.
40.7	1K	CAT2.COM	Part of master ca18	14K	DI.ASM		Directory listing program.
				(req's MACRO.LIB from disk 38)
40.19	2K	DI.COM		COM of above
40.20	26K	DU.ASM		Disk utility: scan, patch, etc.
40.21	4K	DU.COM		COM of above.
40.22	1K	DU.DOC		DOC of above
40.23	1K	EJECT.ASM	"EJECT n" pages on CPM list dev
40.24	1K	FMAP.COM	File map (standalone, and part
40.25	1K	FMAP.DOC		of cataloging system)
40.26	9K	HEXDUMP.ASM	Binary to Hex (RequiresTDL asm)
40.27	1K	MAST.CAT	Sample master catalog
40.28	40K	MODEM4.ASM	Checksummed blocked file xfe DU      ASM  Nklmnopqrst       DU      COM    uvwx             CV      ASM   ?yz{|}~         CV      COM                   VDMSAVE ASM                 ALLOC   COM                   D       COM                   CAT     COM                   UCAT    COM                  FMAP    COM                  COMPARE ASM                COMPARE COM   
               /       COM                   CK-FIX  COM                   FMAP    DOC                  CAT2    COM                  taloging sys.
40.8	5K	CATALOG.DOC	Doc on master cataloging system
40.9	1K	CK-FIX.COM	File checksum program
40.10	1K	CK-FIX.DOC	DOC on above
40.11	4K	COMPARE.ASM	See if two files match exactly
				(Uses MAC and MAC's SEQIO)
40.12	2K	COMPARE.COM	COM of above 'cause many macros
40.13	8K	CV.ASM		Split screen VDM 2 file compare
40.14	1K	CV.COM		..(requires MAC for assembly)
40.15	1K	CV.DOC		DOC on above
40.16	1K	D.COM		Shows what files are different
40.17	1K	D.DOC		..on a disk from some prev time
40.r
40.29	7K	MODEM4.DOC	DOC on above.  PMMI/Hayes/serl
40.30	3K	NSBOOT.ASM	Boot for National Semi 8221
40.31	12K	NSCBIOS.ASM	CBIOS for National Semi 8221
40.32	3K	PBOOT.ASM	Pascal boot loader for Tarbell
40.33	5K	PGEN.ASM	Boot mods for 512 long sectors
40.34	17K	PMMIBYE3.ASM	Dial in remote console prog.
40.35	7K	SPASCAL.DOC	Sam Singer's PASCAL mods
40.36	2K	UCAT.COM	Update catalog program
40.37	3K	VDMSAVE.ASM	Write VDM lines to a file
-------------------- VOLUME 40 ABSTRACTS ----------------------

TITLE:  UTILITIES, MODEM FILE TRANSFER, ADAPTABLE PASCAL

/.COM by Ward Christensen, is an 'on-line' submit command.  It
is used to build a command file without having to edit a .SUB
file.  For example, typing / ED FOO.ASM;ASM FOO.BBZ;LOAD
B:FOO will cause CP/M to execute ED, ASM, and LOAD.  This
should be useful to anyone who regularly uses submit.  Source
code cannot be provided, but documentation is contained in
/.DOC. Works only use with disks other than standard
single density IBM format.  Using a disk formatted for 512
byte sectors can speed up Pascal disk I/O significantly.
This code is still under development and may contain some
bugs.  It is provided for use by tinkerers.  What documentation
there is is in SPASCAL.DOC.  Reviewed by Robert A. Van Valzah.

CLEANUP.COM helps clean up a full disk by typing each
selected name, and allowing you to erase the file, skip
the file, type the file, or quit out of CLEANUP.COM.
Ale.  Reviewed by Robert A. Van Valzah.

CV.ASM contains source for a split screen video file 
comparison utility.  It requires a VDM or SOL like display
for operation.  One file is displayed on the top 8 lines of the
screen and the other is displayed on the bottom 8 lines.
Either half may be independently scrolled 1, 4, or 7 lines,
or continuously.  A compare mode compares the files byte-by-
byte while scrolling.  Once a miscomparison is found, each
half screen can be scrolled independently until th a disk in a three column format with the size
of each file indicated in K bytes.  It is useful to those
who keep a large number files on a disk or those who have
a video terminal with a limited number of lines per screen.
This program currently reads the directory by bypassing
the BDOS and may not work with some double density 
or with mini floppy systems.  The file name has been changed
to DI.ASM from D.ASM so as not to conflict with D.ASM as
written by Ward Christensen.  DI.ASM requires MAC and t individually ADD or DEL names in D.COM, or
re-set it with D SET.  This is just the thing if you use the
'system disk' concept and are forever trying to keep it
'clean'.  Reviewed by Robert A. Van Valzah.  Mod. by WLC

DU.ASM contains the source for a Disk Utility.  It has commands
to read a disk a sector at a time by track, sector, and group
number.  It can also search for ASCII strings, map the disk
(what file occupies what group) etc.  Data may be patched
in ASCII or hex.  It might almost be saiwith CP/M 1.4. Reviewed by Robert A.
Van Valzah. 

ALLOC.COM by Ward Christensen is a utility which prints the bit
map used by CP/M to allocate free space on the disk.  This is a
revision of a previously released version which worked only
with CP/M 1.3. The new ALLOC.COM works with CP/M 1.4.  This
utility would be useful to a hacker was curious how the disk
space was allocated.  Reviewed by Robert A. Van Valzah. 

BOOTER.ASM, PBOOT.ASM, and PGEN.ASM are source files used to
adapt UCSD Pascal for lows ambiguous file names, such as *.ASM.  A generally
useful utility.  Reviewed by its author, Ward Christensen.
 
FMAP.COM, UCAT.COM, CAT.COM, and CAT2.COM by Ward Christensen,
comprise a master disk cataloging system.  This system is
useful if you have a large number of disks and have a hard time
keeping track of what file you left where.  Earlier versions
the components of this system have appeared in earlier
releases.  The complete system is collected here in its current
version for convienence files are
'in sync' again.  This utility is most useful to those who
have a tendency to have 5 copies of the same file sitting
around wondering what is differnt about them.  CV.COM contains
the assembled object code.  What little documentation there is
can be found at the start of the .ASM file.  CV requires MAC
for assembly.  The source code is weak on comments but is
fairly well structured.  Reviewed by Robert A. Van Valzah.

DI.ASM contains source for a utility which displays the
directory ofhe file
MACRO.LIB for assembly.  The code is well written and should
be easy to modify.  Reviewed by Robert A. Van Valzah.

D.COM by Ward Christensen is a utility which prints the
directory of a disk without printing files which are ever
present (like PIP and STAT).  The idea is that you put D.COM on
to a disk and type D SET.  It then re-writes itself and thus
remembers the current directory.  As files are added to and
removed from the disk, these changes will be shown by executing
D.COM.  You mayd to suffer from
"rampant-feature-itis".  This is most useful if you have to re-
create blown directories very often.  DU probably won't work
correctly if you have anything other than a standard CP/M
system because it has to do hard I/O calls to the CBIOS.  In
order to use the utility correctly you would have to be a
'hacker' and have a fairly good understanding of the directory
structure used by CP/M.  Documentation is provided at the start
of the .ASM file (definitly not a tutorial) and there is a good
'help' function built into the .COM file if you forget any of
it.  The source code is weak on on-line comments but is well
structured.  Reviewed by Robert A. Van Valzah. Mod. by WLC

HEXDUMP.ASM contatins source for a transient which takes an
object file (say .COM) and produces an Intel hex format file
(.HEX).  Perhaps a more appropriate name would be UNLOAD, as it
performs the inverse operation of LOAD.COM.  No documentation
has been provided, but it appears that it can send the hex to
diskransfered in a blocked format with checksums and automatic
retry on block failure.  It is very useful for software
exchange and also for conversion from CP/M on one media to
CP/M on another.  Modes are provided for terminal like
communication with another computer.  This is an extension
and rewrite of the earlier CP/M U.G. MODEM program.  It
supports the S-100 modem boards made by PMMI and D. C. Hays
with variable baud rate and disconnect control.  It can be
used with modems interfaced with just a self.  BYE effectively connects the modem as the
CP/M console device and monitors for loss of carrier etc.
Reviewed by Robert A. Van Valzah.

NSCBIOS.ASM contains a CBIOS to put CP/M up on the National
Semiconductor BLC 8221 disk controller.  NSBOOT.ASM contains
a companion cold boot loader.  Both are based on the equivalent
software distributed with CP/M and published in the CP/M System
Alteration Guide.  These files would be useful to anyone with
the aformentioned disk controller or with a Starplentation is provided in PTSRCNVT.DOC.  The source code
is a little light on comments but shouldn't have to be
modified.  In order to assemble PTSRCNVT.ASM, you will need
MAC and MACRO.LIB from volume 24.  Reviewed by
Robert A. Van Valzah.
This document describes a system for cataloging all of a users
CP/M diskettes.  Written by Ward Christensen.

Pieces have been previously distributed.  All are included
here for convenience.  Some changes have been made.

The master cataloging system consists of the following:
 
	MAST.CAT	The catalog itself 
 
	FMAP.COM	Used to create NAMES.SUB, the 
			"transaction file" for catalog update 
 
	CAT.COM		Like DIR, i.e. the lookup program 

	CAT2.COM	Quick kludge program, lists entire
			catal or to the list device.  The source is in TDL macro
assembler format and does use some Z-80 opcodes.  Comments are
a bit sparse.  This program is most useful to those who wish
to send 8-bit object code over the phone lines (say to a
timesharing service) or other 7-bit medium.  Reviewed by
Robert A. Van Valzah.

MODEM.ASM (version 4) contains the source for a modem com-
munications utility.  It has the ability to transfer any CP/M
file to or from another machine also using MODEM.COM.  The file
is terial port too.
Assembly switches provide for use with Heathkit CP/M.
Documentation is provided in MODEM.DOC.  The source is well
written and easy to modify.  Reviewed by Robert A. Van Valzah.

PMMIBYE3.ASM contains source for a utility which allows remote
access to your CP/M system.  It requires the PMMI modem for
operation, although it could be adapted for other modems.
The source is fairly well commented.  BYE requires a small
amount of memory above the normal CP/M system in which to
locate itsx system
which, I believe, uses the same controller.  Both files may
be assembled with ASM.COM.  The code is fairly well written
and commented and should be fairly easy to adapt as needed.
Reviewed by Robert A. Van Valzah.

PTSRCNVT is used to convert files that were used
with Processor Technology Software Package 1 and ALS8
assemblers to a format that is CP/M assembler compatible.
Input is read from disk so you must have a way to load the
PT format source into memory at 0100H and save it.
Documeog, printing each filename only
			once, & stringing disk names out after.
 
	UCAT.COM	The update program, merges NAMES.SUB 
			into MAST.CAT 
 
	UCAT.COM   is   slightly   modified  from  the  version
distributed in CP/M user's group disk 25: it  now  catalogs the
"volume  serial"  (-name.nnn)  whereas  the version in vol.  25
threw this name away.

	The format of MAST.CAT is:

	First, a list of names of files not to be cataloged, in
parentheses.  The list supplied with the sample is:

	(ASM.COM
	DDT.COM
	LOAD.COM
	PIP.COM
	SID.COM
	STAT.COM
	SUB.COM		<-- I renamed SUBMIT on most disks
	SUBMIT.COM)

	Then a list of all cataloged files, in the form:

	filename.type diskname.serial

For example: ALLOC.COM SYSRES.802

			--------
	A disk must have a special filename on it, which is the
volume indentifier: -diskname.serial,  such  as  "-SYSRES.801".
This may be done via:

	save 0 b:-sysres.801

	NOTE  that  the  SAP  (sort and pack directory) program
previously  distributed is  a  "belts  and  suspenders"  type
program,  i. e.  it  creates NEW.CAT, and merges NAMES.SUB with
MAST.CAT and puts it there.  It then does:

	era mast.bak
	ren mast.bak=mast.cat
	ren mast.cat=new.cat

	This means that unless you era mast.bak, there will  be
3  copies  of  the  master  catalog on the disk during the ucat
execution. If you  don't  have  sufficient  space  for  it, era
mast.bak first.
			-------- 
	CAT works just like DIR, i.e.  "*" and "?" are allowed.
However,  it  takes .*

	but other than this one file entry, the "-"  characters
are  eliminated  from  the  directory, i.e.  the disk names are
stored as 7 characters (or less).
			------ 
	FMAP has some additional options:

			FMAP 
displays a sorted listing on the console 
			FMAP specs 
displays a selective listing.  Specs mean *.asm, etc just 
like DIR. 
			FMAP specs D 
writes the names to NAMES.SUB with $1 $2 before the name, 
and $3 after: 
 
	$1 $2FOO.COM $3 
 
Thus $1 may be substituted with a comm<-- SEND THEM NAMES.SUB 
        SUBMIT NAMES MODEM SO.600 B: <-- SUBMIT THE SEND 

MODEM gets substituted for $1, SO.600 for $2, and B: for $3.
			FMAP specs UNN
creates CP/M users group catalog volume "nn".  Not generally
useful, but thought you might like to know how it was done.

	NOTE  that  I  have  found  the  FIND   program   (also
distributed  on  this  users group disk) to be very useful when
used  with  MAST.CAT  -  suppose  you  have  the   following in
MAST.CAT:
 
	BIOS1.ASM 
	BVI͢CLEANUP AS OF 01/20/80

For each name, type one character:
 E	to erase the file
 T	to type the file
 N	to not erase the file
 Q	to quit out of CLEANUP
$	 !  9"1͊mڮ2| 2h  _ETNʵQʮmþ\  	 ø ++ERASED++
$m!"!  "\  !<ʾ_  9 þ
  
  :]  ª͠??????????? ] 1\  \  Ɓ_ * 1"û*6!"*~7  by  the CP/M U.G. deletes all 0-length
file entries, so  if  you  use this utility, do a save 1, not a
save 0.

	To  update  the  catalog for a disk, use FMAP to create
the NAMES.SUB file (which  contains  a  sorted  listing  of the
files   on   the   particular   disk).    Filename   $$$.SUB is
automatically skipped, as I recall.

	FMAP B: Q

	will write NAMES.SUB to the logged in disk.  Then  type
UCAT  which  will  merge  NAMES.SUB  with  MAST.CAT,  and erase
NAMES.SUB.
	Note  that  UCAT  a second operand (after the filename/type)
which is  the  disk  information,  in  the  form  NAME.SERIAL -
without the dash.  Sample queries:

	CAT		<-- ALL FILES
	CAT *.* WORK.*	<-- ALL FILES ON ANY "WORK" DISK
	CAT *.ASM	<-- ALL .ASM FILES
	CAT *.* *.8*	<-- ALL FILES ON DISKS WITH SERIAL
			    NUMBERS 8xx

	Note that the "-diskname.serial" file is written to the
disk  (it  wasn't  under  the  earlier  UCAT  in the CP/M users
group). Thus you can get a list of all disk serials via:

	CAT -*and name, $2 with 
a disk name, and $3 if the program takes options (only 
my programs do, as far as I know) 
			FMAP specs Q 
writes the sorted names, without any "$", to NAMES.SUB. 
			FMAP specs M 
writes the names to NAMES.SUB with $1 $2 $3  before the name, 
and $4 after: 

	$1 $2 $3FOO.COM $4 

This is specifically for use with the modem program.  For 
example, to send all .ASM files from the B: disk to another 
person: 

	FMAP B: M		<-- MAKE NAMES.SUB 
        MODEM SO.600 NAMES.SUB  OS.ASM 
	CBIOS.ASM 
	M2BIOS.ASM 
 
It's ovbious that CAT cannot find all your BIOS related files -
but if you type:
 
	FIND MAST.CAT IOS 
 
You will find them all
]  1"!] ^ #   ~#x1^#V#N#Fx#~G#~#fo>  }ƀo| gR+~+w+++<#~g}o|g~+p+q  \ 	 * \  Ɓ_ * 1"û*6!"         
        .TITLE "BINARY TO HEX-ASCII FORMATTER"
        .PABS
        .LADDR
        .LALL
        .LIMAGE
;
;       SYSTEM EQUATES
;
READBL  =       20      ;READ SECTOR
FCB     =       5CH     ;INPUT FILE FCB
COFN    =       2       ;CONSOLE CHARACTER WRITE
BDOS    =       5       ;DOS ENTRY POINT
SDMA    =       26      ;SET DMA FUNCTION
DWRIT   =       21      ;WRITE SECTOR FUNCTION
BUFF    =       80H     ;READ BUFFER ADDRESS
WTFN    =       9       ;CONSOLE BUFFERED WRITE
WBOOT   =        D,FCBH
        LDIR
        LXI     B,3     ;MOVE HEX EXT.
        LXI     H,HEXT
        LXI     D,FCBH+9
        LDIR
        MVI     B,8
        LXI     H,FCB+17;CHECH FOR CONSOLE
AGAIN:  MOV     A,M     ;OR FILE OPERATION
        CPI     ' '
        JRNZ    AFORT
        INX     H
        DJNZ    AGAIN
        JMPR    RDOPEN
AFORT:  XRA     A
        STA     CONTST  ;SET FLAG FOR HEX FILE
;
;       SET UP HEX FILE
;
        LDA     FCBH    ;GET DRIVE
        DCR     A       ;ANDD
        MVI     C,WTFN
        CALL    BDOS
        JP      WBOOT
OPENZ:  LXI     D,FCBH
        CALL    SETUP
        XRA     A
        STA     FCBH+32 ;INIT. SECTOR COUNT
        STA     WTPTR   ;INIT. POINTER
;
;       OPEN READ FILE
;
RDOPEN: LXI     D,FCB
        CALL    SETUP
        XRA     A
        STA     FCB+32  ;INIT. SECTOR COUNT
        MVI     A,80H
        STA     RIBP    ;INIT POINTER
;
;       BINARY TO HEX-ASCII CONVERSION
;
        LXI     Y,START
WRITE:  CALL        WRITE   ;GET NEXT RECORD
        CALL    CRLF
        MVI     C,':'
        CALL    PRINT
        MVI     B,10
SST:    MVI     C,'0'
        CALL    PRINT
        DJNZ    SST
        CALL    CRLF
        JMP     CLOSE   ;FINISHED
PIMP:   MVI     D,0     ;INIT CHECKSUM
        MVI     B,24    ;24 BYTES PER RECORD
        MOV     A,B     ;FILE LENGTH
        CALL    PBYTE   ;PRINT IT
        PUSH    Y
        POP     H       ;GET ADDRESS
        MOV     A,H
        CALL    PBYTE   ;HIGH B      RRC
        RRC
        CALL    CONV
        CALL    PRINT   ;PRINT IT
        POP     PSW     ;NEXT NIBBLE
        PUSH    PSW     ;SAVE FOR CHECKSUM
        CALL    CONV
        CALL    PRINT   ;PRINT IT
        POP     PSW
        ADD     D       ;ADD TO CHECKSUM
        MOV     D,A     ;UPDATE CHECKSUM
        RET
;
;       CONVERT ASCII TO HEX
;
CONV:   ANI     0FH     ;LOW NIBBLE ONLY
        ADI     90H
        DAA
        ACI     40H
        DAA
        MOV     C,A
           0       ;WARM BOOT
CONZ    =       26      ;EOF MARKER
CLSFN   =       16      ;CLOSE FILE
LOGIN   =       14      ;LOG-IN DISK
SEARCH  =       17      ;SEARCH FOR FILE
DELETE  =       19      ;DELETE FILE
MAKEF   =       22      ;CREATE FILE
OPENF   =       15      ;OPEN FILE
START   =       100H    ;WORK FILE START ADDRESS
;
;
        .LOC    100H
        LXI     SP,STKTOP
;
;       GET PARAMETERS
;
        LXI     B,33    ;GET HEX FCB
        LXI     H,FCB+16;AND MOVE IT
        LXI LOG-IN DISK
        MVI     D,0
        MOV     E,A
        MVI     C,LOGIN
        CALL    BDOS
        LXI     D,FCBH  ;SEARCH FOR FILE
        MVI     C,SEARCH
        CALL    BDOS
        CPI     255
        JRZ     MAKE    ;SEE IF FILE EXISTS
        LXI     D,FCBH
        MVI     C,DELETE
        CALL    BDOS    ;ERASE FILE
MAKE:   LXI     D,FCBH
        MVI     C,MAKEF ;CREATE FILE
        CALL    BDOS
        CPI     255
        JRNZ    OPENZ
        LXI     D,DIREM ;ERROR DETECTECRLF    ;WRITE CRLF
        MVI     C,11    ;TEST TO ABORT
        CALL    BDOS
        ANI     1
        JRZ     OKNOW
        MVI     C,1
        CALL    BDOS
        ANI     127
        CPI     3       ;ABORT
        JRNZ    OKNOW
        LXI     D,ABORT
        MVI     C,WTFN
        CALL    BDOS
        JMP     WBOOT
OKNOW:  MVI     C,':'   ;START OF RECORD CUE
        CALL    PRINT   ;PRINT IT
        CALL    PIMP
        LDA     EOFLG   ;CHECK FOR EOF
        CPI     0
        JRZ YTE FIRST
        MOV     A,L
        CALL    PBYTE   ;LOW BYTE NEXT
        XRA     A       ;FILE TYPE=0
        CALL    PBYTE   ;PRINT IT
..W3:   CALL    READ    ;GET DATA BYTE
        CALL    PBYTE   ;PRINT IT
        INX     Y       ;ADVANCE ADDRESS
        DJNZ    ..W3    ;DEC FILE COUNT
        XRA     A
        SUB     D       ;CALC. CHECKSUM
        JMP     PBYTE   ;PRINT IT, RETURN
;
;       WRITE A SINGLE BYTE
;
PBYTE:  PUSH    PSW     ;NIBBLE AT A TIME
        RRC
        RRC
   RET
;
;       CRLF
;
CRLF:   MVI     C,0DH
        CALL    PRINT
        MVI     C,0AH
;
;       CONSOLE AND FILE
;       CHARACTER WRITE
;
PRINT:  PUSH    PSW     ;SAVE ENVIRONMENT
        PUSH    B
        PUSH    D
        PUSH    H
        LDA     CONTST  ;TEST FLAG
        CPI     0
        JRZ     DISKWR  ;FILE ACCESS
        MVI     D,0
        MOV     E,C     ;CHAR. IN C
        MVI     C,COFN
        CALL    BDOS    ;PRINT TO CRT
PREXIT: POP     H       ;RESTORE ENVIRONMENT
        POP     D
        POP     B
        POP     PSW
        RET
DISKWR: LDA     WTPTR   ;GET POINTER
        CPI     80H     ;CHECK FOR ROLLOVER
        JRNZ    WTBYT
        CALL    DISKCR
        XRA     A
WTBYT:  MOV     E,A     ;WRITE BYTE AT
        MVI     D,0     ;BUFF+A
        INR     A
        STA     WTPTR   ;UPDATE POINTER
        LXI     H,WTBUF
        DAD     D
        MOV     M,C     ;WRITE CHAR TO BUFF
        JMPR    PREXIT  ;DONE
;
;       WRITE   SECTOR
;
DISKCR:    B
        RET
;
;       CLOSE THE FILE
;
CLOSE:  LDA     CONTST  ;TEST FLAG
        CPI     0
        JNZ     WBOOT   ;DONE IF CONSOLE
        MVI     B,10    ;WRITE EOF MARKER
OVAGN:  MVI     C,CONZ
        CALL    PRINT
        DJNZ    OVAGN
        CALL    DISKCR  ;FINAL SECTOR
        LXI     D,FCBH
        MVI     C,CLSFN ;CLOSE FILE
        CALL    BDOS
        CPI     255     ;CHECK FOR ERRORS
        JNZ     WBOOT   ;NO ERROR, DONE.
        LXI     D,CLEER
        MVI     C,WTF
        LXI     D,FCB
        MVI     C,READBL
        CALL    BDOS    ;READ NEW SECTOR
        CPI     0
        JRZ     BNC1
        CPI     1       ;ERROR DETECTED
        JRNZ    ALTER   ;EOF?
        MVI     A,1     ;YES, SET FLAG
        STA     EOFLG
        JMPR    OUT
ALTER:  LXI     D,RDERRM
        MVI     C,WTFN
        CALL    BDOS
        JMP     WBOOT
BNC1:   XRA     A
TEMP:   MOV     E,A     ;READ BYTE FROM
        MVI     D,0     ;BUFF+A
        INR     A
        STA     TACK AREA
STKTOP  =       .
;
;       ERROR MESSAGES
;
WEMS1:  .ASCII  [^H0D] [^H0A] "ERROR ON CLOSING FILE" [^H0D] [^H0A] "$"
CLEER:  .ASCII  [^H0D] [^H0A] "ERROR ON CLOSING FILE" [^H0D] [^H0A] "$"
RDERRM: .ASCII  [^H0D] [^H0A] "ERROR ON READING FILE" [^H0D] [^H0A] "$"
DIREM:  .ASCII  [^H0D] [^H0A] "NO MORE DIRECTORY SPACE" [^H0D] [^H0A] "$
"
OPNM:   .ASCII  [^H0D] [^H0A] "ERROR ON OPENING FILE" [^H0D] [^H0A] "$"
ABORT:  .ASCII  [^H0D] [^H0A] "...ABORTED" [^H0D] [^H0A] "$"
        .END
A>

!Documentation of various original programs written
by Ward Christensen

		----/.COM----
OVERVIEW:
	/.COM is a command "stacker" - allows executing
a small list of commands without having to edit a .SUB file.

USAGE:
	Type /, then space, then a string of commands,
separated by ";".  For example, suppose you were using
my catalog program to catalog the B: disk, you would
normally type:

	FMAP B: Q
	UCAT

But with /.COM, just type:

	/ FMAP B: Q;UCAT

Another example, instead of:

	ASM FPUSH    B
        LXI     D,WTBUF
        MVI     C,SDMA
        CALL    BDOS    ;SET WRITE DMA
        LXI     D,FCBH
        MVI     C,DWRIT ;WRITE SECTOR
        CALL    BDOS
        PUSH    PSW
        LXI     D,BUFF  ;RESET DMA ADDRESS
        MVI     C,SDMA
        CALL    BDOS
        POP     PSW
        CPI     0       ;CHECK FOR ERROR
        JRZ     BNC2
        LXI     D,WEMS1
        MVI     C,WTFN
        CALL    BDOS    ;WRITE ERROR MESSAGE
        JMP     WBOOT
BNC2:   POP  N
        CALL    BDOS
        JMP     WBOOT
;
;       SET UP FILES TO OPEN
;
SETUP:  MVI     C,OPENF
        CALL    BDOS
        CPI     255     ;CHECK FOR ERRORS
        RNZ
        LXI     D,OPNM
        MVI     C,WTFN
        CALL    BDOS
        JMP     WBOOT
;
;       READ A CHARACTER
;
READ:   PUSH    H
        PUSH    D
        PUSH    B
        LDA     EOFLG
        CPI     0
        JRNZ    OUT
        LDA     RIBP    ;GET POINTER
        CPI     80H
        JRNZ    TEMP
RIBP    ;UPDATE POINTER
        LXI     H,BUFF
        DAD     D
        MOV     A,M     ;GET BYTE
OUT:    POP     B
        POP     D
        POP     H
        RET
;
;       STORAGE AND BUFFER
;
RIBP:   .BYTE   80H     ;READ POINTER
EOFLG:  .BYTE   0       ;EOF FLAG
CONTST: .BYTE   1       ;CONSOLE FLAG
WTPTR:  .BYTE   0       ;WRITE POINTER
WTBUF:  .BLKB   128     ;WRITE BUFFER
FCBH:   .BLKB   33      ;FCB FOR HEX FILE
HEXT:   .ASCII  "HEX"   ;DEFAULT EXTENSION
STACK:  .BLKB   64      ;S

!@v <@  a@IF
	O@"HCϩIIBD@JKA@PP @8J`BOO.BBZ
	LOAD B:FOO
	B:
	FOO

just:

	/ ASM FOO.BBZ;LOAD B:FOO;B:;FOO

DEPENDENCIES:
	CP/M 1.4 only.  /.COM creates the $$$.SUB file which
is normally created by the SUBMIT command.  I am not including
the .ASM file as it is a real kludge - designed to work with
a remote console to stack a series of commands.  I'll try to
"pretty it up" then distribute the .ASM in a future CP/M U.G.

Documentation of various original programs written
by Ward Christensen

		----ALLOC.COM----
OVERVIEW:
	Prints a picture of the "bit map" which CP/M uses
to allocate disks.

USAGE:
	ALLOC
or	ALLOC x:		x=A, B, C, D

DEPENDENCIES:
	The ALLOC shipped in previous user's group disks
worked only for CP/M 1.3, since the manner in which data
was passed back from the "inquire allocation vector" changed
(or at least my usage of it changed) from 1.3 to 1.4.

;			-  D -
;					BY S J SINGER
;
;	D IS A CPM UTILITY THAT DISPLAYS A DISK DIRECTORY IN A MORE
;READABLE FORM. THE DIRECTORY IS READ FROM THE SPECIFIED DISK, SORTED
;THEN DISPLAYED IN A 3 COLUMN FORMAT. BOTH THE FILE NAMES AND FILE SIZES 
;IN 1 K GROUPS ARE DISPLAYED.
;	THE PRESENT VERSION OF D HAS CERTAIN MINOR LIMITATIONS WHICH
;MAY BE EASILY REMOVED IF THEY CAUSE PROBLEMS.
;
;	1.  ONLY 54 FILES ARE DISPLAYED. THIS LIMIT IS SUFFICIENT FOR
;	    ALMOST ALL DISKS AND LEAVES ROOM ON THE SCREEN FORHE DISK WILL NOT AGREE WITH THAT REPORTED
;BY THE STAT UTILITY. THIS ALMOST ALWAYS MEANS THE DISK DIRECTORY HAS BEEN
;MESSED UP SOMEHOW. USUALLY THE PROBLEM CAN BE CORRECTED BY COPYING ALL THE
;FILES TO ANOTHER DISK USING PIP.
;	D WAS ASSEMBLED USING THE NEW CP/M MACRO ASSEMBLER AND USES A LARGE
;NUMBER OF MACROS. THESE ARE CONTAINED IN A LIBRARY CALLED MACRO.LIB WHICH
;IS REQUIRED IF THE PROGRAM IS TO BE REASSEMBLED.
;	THE STANDARD VERSION OF 'D' IS CONFIGURED FOR A DISPLAY SCREEN OF
;24 BY 80 CHARIB	MACRO		;INCLUDE MACRO LIBRARY
	ORG	100H		;SET PROG START
	LXI	H,0
	DAD	SP		;GET OLD STACK POINTER
	SHLD	OLDSTK		;SAVE IT
	LXI	SP,NEWSTK	;LOAD NEW STACK POINTER
	JMP	DIR
;
;   GRPTS  CONVERT CPM GROUP AND SECTOR NUMBER TO TRK AND SEC
;	   GROUP NO IN G, TRT NO RETURNED TO TRACK, SEC TO BSEC AND ESEC
;
GRPTS:	LDA	DENCODE		;CHECK DENSITY
	CPI	0DDH		;DOUBLE?
	JZ	GRPTSD
	JMP	GRPTSS		;ELSE SINGLE DENSITY
;
GRPTSD:	MVI	A,2
	STA	TRACK		;DIRECTORY IS ON TRACK 2
	LDA	S		;SECTOR NO
	INR	A		;INCR NO
	MOV	A,M		;GET SECTOR NO
	STA	BSEC		;SAVE IN BEGINNING SECTOR
	STA	ESEC		;SAVE IN END SECTOR TOO
	RET
;
;    START OF DIRECTORY ROUTINE READ IN GROUPS 0 AND 1 AND STORE
;    DIRECTORY FILE NAMES NOT FLAGGED E5.  IF EXTENT NOT ZERO STORE
;    OVER PREVIOUS FILE NAME. TABLE OF POINTERS WILL BE BUILT IN PDIR
;
DIR:	DISKIO	?DRIVE
	STA	NEWDRV
	LDA	81H
	ORA	A		;CHECK IF INPUT BUFFER EMPTY
	JZ	DIR2
	LXI	H,82H		;POINT TO INPUT BUFFER
	CALL	GETDRV
	JNC	DSKERR		;ERROR OF NO DRIVE FOUND
	STA	NEWDR EDITING.
;	    TO CHANGE THE NO OF LINES DISPLAYED, CHANGE THE LINES VARIABLE
;	    IN THE DATA ALLOCATION SECTION OF THE PROGRAM. FOR EXAMPLE
;	    TO DISPLAY A MAXIMUM OF 54 FILES CHANGE LINES TO 18.
;	2.  THE PRESENT VERSION READS GROUPS 0 AND 1 DIRECTLY FOR SPEED.
;	    IF A DISK IS SET UP FOR MORE THAN 64 FILES OR THE BLOCK FORMAT
;	    IS CHANGED THE READ ROUTINE WILL HAVE TO BE MODIFIED.
;
;	OCCASIONALLY THE FILE NAMES WILL BE DISPLAYED WITH THE FORMAT
;SCRAMBLED OR THE SPACE REMAINING ON TACTERS. A CONDITIONAL ASSEMBLY SWITCH IS INCLUDED TO CONFIGURE
;THE DISPLAY FOR A 16 BY 64 SIZE SCREEN WITH A SMALLER MAXIMUM NUMBER OF
;FILES. SET THE SWITCH TO TRUE FOR SMALLER SCREENS.
;	VDM	EQU	0FFH
;
;
;
;		COMMAND FORMAT
;
;	D			DISPLAY DIRECTORY OF LOGGED DISK
;	D A:			DISPLAY DIRECTORY OF DISK A
;	D B:			DISPLAY DIRECTORY OF DISK B
;	D C:			DISPLAY DIRECTORY OF C
;	D D:			DISPLAY DIRECTORY OF D
;
;
VDM:	EQU	0H		;CONDITIONAL ASSEMBLY SWITCH SET TRUE IF
;				 16 BY 64 SCREEN
;
	MACLBY 1
	MOV	B,A		;TO B
	LDA	G		;GROUP NO
	ADD	A
	ADD	A
	ADD	A
	ADD	A		;SHIFT LEFT 4 BITS
	ADD	B		;ADD IN GROUP NO
	STA	BSEC
	STA	ESEC
	RET
;
GRPTSS:	MVI	H,0		;ZERO H
	LDA	G		;GROUP NO
	MOV	L,A		;TO L
	MOV	D,H		;ZERO	D
	DAD	H
	DAD	H
	DAD	H		;SHIFT LEFT 3
	LDA	S		;GET SECTOR NO
	MOV	E,A		;TO DE
	DAD	D		;HL HAS G*8+S
	LXI	D,-26		;DIVISOR
	MVI	A,1		;CONTAINS DIVIDEND
DIV:	DAD	D		;SUB 26
	INR	A
	JC	DIV		;LOOP TILL MINUS
	LXI	D,TABLE+26	;INDEX INTO TABLE
	DAD	D
	STA	TRACK		;STORE TRACK V		;STORE DRIVE CODE
DIR2:	XRA	A
	STA	S		;SECTOR COUNT
	STA	G		;GROUP 0 = DIRECTORY
	STA	COUNT		;COUNT OF DIRECTORY ENTRIES
	LXI	H,PDIR		;ZERO DIRECTORY POINTER TABLE
	MVI	B,0
	XRA	A
DIR3:	MOV	M,A		;STORE A ZERO
	INX	H
	DCR	B
	JNZ	DIR3		;LOOP FOR 256 ITERATIONS
	LXI	H,DIRBUF	;POINTS TO DIRECTORY BUFFER
	SHLD	OUTB
	LXI	H,PDIR		;POINTER TABLE
	SHLD	IPOINT
	LDA	NEWDRV
	MOV	E,A
	DISKIO	LOGIN		;LOG IN NEW DRIVE NO
	CALL	GETDEN
DIR4:	LXI	H,80H		;POINTS TO INPUT BUFFER
	SHLD	INB
	CALL	GRPTS		;COMPUTE TRACK AND SECTOR NO FROM G AND S
	SETSEC	BSEC		;SET SECTOR
	SETTRK	TRACK		;SET TRACK
	CALLBIOS DREAD		;READ DIRECT
DIR6:	LHLD	OUTB		;LOAD DESTINATION POINTER
	XCHG			;PUT IT IN DE
	LHLD	INB		;LOAD SOURCE POINTER
	MVI	A,0E5H		;FLAG BYTE
	CMP	M		;TEST FIRST BYTE
	JNZ	DIR8
	INX	H
	CMP	M		;TEST SECOND BYTE
	JZ	SORT		;SORT DIRECTORY
	JMP	DIR12
DIR8:	INX	H
	SAVE	H,D
	LXI	D,11		;EXTENSION OFFSET
	DAD	D
	MOV	A,M
	ORA	A
	JZ	DIR10		;IF EXTENT ZERO CONTINUE
	LXI	H,0		;ELSE, SEARCH FOR SAMHLD	OUTB
	DSTORE	0,IPOINT	;INDEXED STORE HL
	INDEX	OUTB,16
	INDEX	IPOINT,2
DIR12:	INDEX	INB,32		;INCR POINTERS
	LXI	D,100H
	CPHL			;LIMIT OF 4 ENTRIES
	JNZ	DIR6
	LDA	S
	INR	A
	STA	S		;INCR DIRECTORY SECTOR COUNT
	JMP	DIR4		;READ ANOTHER BLOCK FROM DIRECTORY
;
;    THIS ROUTINE PRINTS THE DIRECTORY IN 3 COLUMNS. NO OF LINES
;    PRINTED IS CONTROLED BY VARIABLE LINES. ALL DIRECTORY NAMES
;    ARE PRESENT IN TABLE BUT ONLY A MAXIMUM OF 3*LINES WILL BE
;    PRINTED.
;
DIR14:	LXI	H,0
	SHLD	W	
	DLOAD	PDIR+LINES*4+12,I
	JMP	DIR17D
DIR17C:	DLOAD	PDIR+LINES*4,I	;POINTER COL 3
DIR17D:	DJZ	DIR18
	CALL	DIR20		;CALL PRINT ROUTINE
DIR18:	INDEX	I,2		;INCR INDEX BY 2
	LXI	D,LINES*2	;CHECK INDEX LIMIT
	LDA	COUNT
	CPI	58
	JM	DIR19
	LXI	D,LINES*2+6
DIR19:	CPHL
	JZ	ENDFIL		;EXIT WHEN INDEX 32
	PRINT	CRLF,$
	JMP	DIR16		;PRINT SOME MORE
;
;    SUBROUTINE TO PRINT A SINGLE DIRECTORY ENTRY
;
DIR20:	MVI	C,11		;NAME LENGTH
DIR22:	SAVE	B,H		;SAVE REGISTERS
	MVI	C,2
	MOV	E,M		;CHAR TO BE PRINTER
	DIR26
	INX	H
DIR26:	LDA	DENCODE		;CHECK DENSITY CODE
	CPI	0DDH		;DOUBLE DENSITY
	JNZ	DIR26A		;SINGLE DENSITY
	INX	H
	MOV	A,L
	ANI	0FEH
	MOV	L,A		;ROUND UP ONE BIT (2K GROUPS)
DIR26A:	MOV	A,L
	ADD	B
	MOV	L,A
	PUSH	H
	LXI	D,10
	CPHL
	JM	DIR28
	POP	H
	PUSH	H
	LXI	D,100
	CPHL
	JM	DIR27
	PRINT	' '
	JMP	DIR30
DIR27:	PRINT	'  '
	JMP	DIR30
DIR28:	PRINT	'   '
DIR30:	POP	H
	PUSH	H
	XCHG
	LHLD	W
	DAD	D
	SHLD	W
	POP	H
	DECOUT
	PRINT	'K'
	RET
;
;
;    GET DENSITY CODE FROM TRACK ZE
	CPI	58
	JP	END0
	PRINT	CRLF,$
	IF	VDM
END0:	PRINT	<CR,LF,'        '>
	ELSE
END0:	PRINT	<CR,LF,'              '>
	ENDIF
	LXI	H,0
	LDA	COUNT
	MOV	L,A
	DECOUT
	PRINT	' FILES    '
	LHLD	W
	MOV	A,L		;CHECK FOR ZERO
	ORA	H
	JZ	END1
	XRA	A
	SUB	L
	MOV	L,A		;MOVE IT BACK
	MVI	A,00H
	SBB	H
	MOV	H,A		;TWOS COMPLIMENT IN HL
END1:	LDA	DENCODE		;CHECK DENSITY
	CPI	0DDH
	LXI	D,478		;DOUBLE DENSITY SPACE
	JZ	END2
	LXI	D,241		;SINGLE DENSITY SPACE
END2:	DAD	D		;SUBTRACT FROM TOTAL
	DECOUT
	PE NAME AND SWITCH
	SHLD	J		;INITIALIZE INDEX
DIR9:	DLOAD	PDIR,J
	MOV	A,H
	ORA	L
	JZ	DIR10		;ERROR TABLE EMPTY
	XCHG
	LHLD	INB		;POINTER TO NEW DIR ENTRY
	SAVE	D,H
	INX	H
	MATCH	,,11		;COMPARE 11 CHARAACTERS
	RESTORE	H,D
	JZ	SWITCH		;STORE NEW ENTRY OVER OLD
	INDEX	J,2		;INCR INDEX BY 2
	JMP	DIR9
SWITCH:	INX	H
	MOVE	,,15		;OVERWRITE OLD ENTRY
	RESTORE	H
	JMP	DIR12
DIR10:	RESTORE	D,H
	MOVE	,,15		;MOVE THE DIRECTORY ENTRY
	LDA	COUNT
	INR	A
	STA	COUNT		;INCR COUNT OF DIRECTORY ENTRIES
	L	;INITIALIZE ALLOCATION
	SHLD	I		;INITIALIZE INDEX
DIR16:	DLOAD	PDIR,I		;INDEX LOAD POINTER
	DJZ	ENDFIL		;EXIT IF POINTER ZERO
	CALL	DIR20		;CALL PRINT ROUTINE
	IF	VDM
	PRINT	'      '
	ELSE
	PRINT	'         '
	ENDIF
	LDA	COUNT
	CPI	58
	JM	DIR17A
	DLOAD	PDIR+LINES*2+6,I	;POINTER COL 2
	JMP	DIR17B
DIR17A:	DLOAD	PDIR+LINES*2,I	;POINTER COL 2
DIR17B:	DJZ	DIR18		;NO PRINT IF ZERO
	CALL	DIR20		;PRINT IT
	IF	VDM
	PRINT	'      '
	ELSE
	PRINT	'         '
	ENDIF
	LDA	COUNT
	CPI	58
	JM	DIR17C
	CALL	5		;CALL BDOS
	RESTORE	H,B		;RESTORE THE REGISTERS
	INX	H		;INCR NAME POINTER
	DCR	C		;DECR CHAR COUNT
	JZ	DIR24		;PRINT SIZE
	JMP	DIR22		;LOOP TILL COUNT 0
DIR24:	MOV	A,M		;EXTENSION TO A
	ADD	A
	ADD	A
	ADD	A
	ADD	A		;MULTIPLY BY 16
	MOV	B,A		;SAVE IN B
	INX	H
	INX	H
	INX	H		;ADD 3
	XRA	A		;CLEAR CARRY
	MOV	A,M		;GET RECORD COUNT
	RRC
	RRC
	RRC			;SHIFT RIGHT 3  (DIVIDE BY 8)
	PUSH	PSW
	ANI	1FH		;EXTRACT
	LXI	H,0
	MOV	L,A		;NO TO HL TO PRINT
	POP	PSW
	ANI	0E0H		;EXTRACT
	JZRO SECTOR 1 BYTE 128
;
GETDEN:	XRA	A
	STA	TNUM		;SELECT TRACK ZERO
	INR	A		;SELECT SECTOR 1
	STA	SNUM
	SETSEC	SNUM
	SETTRK	TNUM
	CALLBIOS DHOME		;HOME DRIVES
	CALLBIOS DREAD		;READ TRACK ZERO DIRECT
	LDA	0FFH
	CPI	0DDH		;DOUBLE DENSITY CODE
	JZ	GDEN1
	LDA	0FEH		;TRY NEXT TO LAST BYTE ALSO
	CPI	0DDH
	RNZ
GDEN1:	STA	DENCODE
	RET
;
;    THIS IS THE EXIT POINT FROM THE PROGRAM. PRINT NO OF FILES AND
;    SPACE REMAINING, RELOAD OLD STACK POINTER AND RETURN BACK TO CCP.
;
ENDFIL:	LDA	COUNT
RINT	<'K BYTES REMAINING ON DISK '>
	LDA	NEWDRV		;DRIVE NUMBER
	CALL	PRNDRV		;PRINT DRIVE NAME
EF1:	LHLD	OLDSTK
	SPHL			;RELOAD OLD STACK POINTER
	RET			;RETURN TO CCP WITHOUT REBOOT
;
DSKERR:	PRINT	<CR,LF,'ERROR - SELECT DRIVE A,B,C, OR D'>
	JMP	EF1		;EXIT
;
;    THIS SECTION DOES THE ACTUAL SORTING OF THE DIRECTORY. DURING THE
;    INPUT OF THE DIRECTORY NAMES, A TABLE OF ADDRESS POINTERS PDIR
;    WAS CONSTRUCTED. THE SORT ROUTINE SORTS THE ADDRESS POINTERS
;    RATHER THAN THE ACTUAL DIRECTORY. 
;    THIS IS AN IMPLEMENTATION OF C. A. R. HOARE'S QUICKSORT ALGORITHM.
;    THE ALGORITHM IS VERY FAST AND GENERALLY USEFUL, HOWEVER CAUTION
;    SHOULD BE USED WITH LARGE FILES. THE ALGORITHM IS RECURSIVE AND
;    THE STACK SPACE REQUIRED IS PROPORTIONAL TO THE NO OF ITEMS TO BE
;    SORTED.
;
SORT:	LDA	COUNT		;CHECK FOR EXTENDED PRINT
	CPI	58
	JP	SORT1
	IF	NOT VDM
	PRINT	<CR,LF,LF,'                        DIRECTORY DRIVE - '>
	LDA	NEWDRV		;LOGGED DISK
	CALL	PRNDRV		;PRINT DRIVE NAME (AINT ROUTINE
	SHLD	J
	SHLD	LAST
	POP	H
	SHLD	I
	SHLD	FIRST
	CALL	SPLIT
	LHLD	I
	XCHG
	LHLD	FIRST
	CPHL
	JZ	SORT4
	PUSH	H		;I ON STACK
	DCX	D
	DCX	D
	PUSH	D		;J ON STACK
SORT4:	LHLD	J
	XCHG
	LHLD	LAST
	CPHL
	JZ	SORT8
	INX	D
	INX	D
	PUSH	D		;NEW I ON STACK
	PUSH	H		;NEW J ON STACK
SORT8:	JMP	SORT2
;
;    SPLIT SUBROUTINE DOES A SINGLE PARTITION ON AN ARRAY OF POINTERS
;
SPLIT:	HALF	I
	XCHG
	HALF	J
	DAD	D
	MOV	A,L
	ANI	0FEH
	MOV	L,A
	SHLD	K		;K=I+J/2
	DLOAD	PDIR,K
	SHLD	W		
	RESTORE	H
	DSTORE	PDIR,J
	JMP	SPLIT2
;
;
;    GETDRV  SEARCH COMMAND STRING FOR DRIVE NAME AND RETURN CODE
;    A:=0 B:=1 C:=2 D:=3   CARRY SET IF DRIVE PRESENT
;    GETDRV IS CALLED WITH HL POINTING TO STARTING POSITION FOR SEARCH
;
GETDRV:	SAVE			;SAVE REGS
	LXI	D,DSKNAME	;POINT TO NAME TABLE
	MVI	C,0		;DRIVE NUMBER
GD1:	SAVE
	MVI	B,40H		;STRING LENGTH
	MVI	C,2		;SUBSTRING LENGTH
	INSTR	
	RESTORE
	JC	GD3		;FOUND NAME ON CARRY
	MOV	A,C		;DRIVE NO TO A
	CPI	3		;CHECK LIMIT
	JZ	GD3
	I	JMP	PRDR1
;
;
;   DATA ALLOCATIONS
;
	IF	VDM
LINES	EQU	13
	ELSE
LINES	EQU	19		;LINES PER PAGE ON DISPLAY
	ENDIF
FCB	EQU	5CH		;FILE CONTROL BLOCK
SPACE:	DB	' $'		;ASCII SPACE
CRLF:	DB	0DH,0AH,24H	;ASCII CR LF
CRLF2:	DB	0DH,0AH,0AH,'$'	;ASCII CR LF LF
I:	DW	0		;PSEUDO INDEX REGISTER
J:	DW	0		;PSEUDO INDEX REGISTER
K:	DW	0		;PSEUDO INDEX REGISTER
FIRST:	DW	0		;START OF ARRAY
LAST:	DW	0		;END OF ARRAY
W:	DW	0		;STORAGE FOR PARTITION INDEX
LINE:	DW	0		;LINE NUMBER FOR LISTING
IPOINT:	DW	00	NO WITHIN GROUP G
COUNT:	DB	0		;COUNT OF DIRECTORY ENTRIES
OLDSTK:	DW	0		;STORAGE FOR OLD STACK POINTER
INB:	DW	0		;STORES POINTER TO INPUT BUFFER AREA
OUTB:	DW	0		;STORES POINTER TO DIRECTORY BUFFER AREA
DENCODE:DB	0		;DENSITY CODE  DD=DOUBLE  4D=QUAD
TABLE:	DB	01H		;SECTOR LOOK UP TABLE
	DB	07H
	DB	0DH
	DB	13H
	DB	19H
	DB	05H
	DB	0BH
	DB	11H
	DB	17H
	DB	03H
	DB	09H
	DB	0FH
	DB	15H
	DB	02H
	DB	08H
	DB	0EH
	DB	14H
	DB	1AH
	DB	06H
	DB	0CH
	DB	12H
	DB	18H
	DB	04H
	DB	0AH
	DB	10H
 - C)
	PRINT	CRLF2,$		;PRINT CR AND LF
	ENDIF
SORT1:	LDA	COUNT		;NO OF ENTRIES IN DIR
	ORA	A
	JZ	ENDFIL		;EXIT IF DIRECTORY EMPTY
	DCR	A
	LXI	H,0		;ZERO HL
	MOV	L,A
	DAD	H
	SHLD	LAST		;END OF ARRAY
	LXI	H,0
	SHLD	FIRST		;START OF ARRAY
	LXI	H,0FFFFH
	PUSH	H		;FLAG FOR STACK EMPTY
	LHLD	FIRST
	PUSH	H
	LHLD	LAST
	PUSH	H		;STACK CONTAINS FIRST AND LAST INDICES
;
;    NOW POP STACK AND KEEP CALLING SPLIT RECURSIVELY TILL STACK EMPTY
;
SORT2:	POP	H
	MOV	A,H
	CPI	0FFH
	JZ	DIR14		;GO TO PR;W IS POINTER TO PARTITION ELEMENT OF PDIR
SPLIT2:	DLOAD	PDIR,I		;GET ITEM FROM LEFT
	XCHG
	LHLD	W		;PARTITION ELEMENT
	MATCH	,,11		;CONPARE KEYS
	JP	SPLIT4
	INDEX	I,2		;INCR I
	JMP	SPLIT2
SPLIT4:	DLOAD	PDIR,J		;GET ITEM FROM RIGHT
	XCHG
	LHLD	W		;PARTITION ELEMENT
	XCHG
	MATCH	,,11		;COMPARE KEYS
	JP	SPLIT6
	INDEX	J,-2
	JMP	SPLIT4		;LOOP BACK
SPLIT6:	LHLD	I
	XCHG
	LHLD	J
	CPHL			;COMPARE I AND J
	RZ			;RET IF I = J
	DLOAD	PDIR,I		;SWITCH POINTERS
	SAVE	H
	DLOAD	PDIR,J
	DSTORE	PDIR,INR	C		;INCR DRIVE NO
	INX	D
	INX	D		;POINT TO NEXT NAME
	JMP	GD1		;LOOP FOR 4 DRIVES
GD3:	MOV	A,C		;DRIVE NO TO A
	RESTORE
	RET
;
DSKNAME:DB	'A:'		;TABLE OF DISK NAMES
	DB	'B:'
	DB	'C:'
	DB	'D:'
;
;    PRNDRV  PRINT DRIVE NAME CORRESPONDING TO CODE IN A REG
;    0=A 1=B 2=C 3=D  >3 ERROR
;
PRNDRV:	SAVE
	CPI	4		;CHECK RANGE
	JP	PRDR3		;ERROR IF > 3
	ADI	'A'		;CALC LETTER TO PRINT
	CHAROUT			;PRINT IT
PRDR1:	RESTORE
	RET
PRDR3:	PRINT	<CR,LF,'ERROR - DRIVE NUMBER GREATER THAN 3',CR,LF>
	;VARIABLE BUFFER POINTER
INBUF:	DS	10		;USED AS CONSOLE INPUT BUFFER
LASTIN:	DB	0		;LAST CONSOLE INPUT CHAR
INFLAG:	DB	0		;FLAG, RET FOR MORE CONSOLE INPUT
DRVNO:	DB	0		;STORAGE FOR ORIGINALLY LOGGED DRIVE
NEWDRV:	DB	0		;STORAGE FOR NEW DRIVE NO
TRACK:	DB	0		;SELECTED TRACK
BSEC:	DB	0		;SELECTED BEGINNING SECTOR
ESEC:	DB	0		;SELECTED ENDING SECTOR
TNUM:	DB	0		;TRACK NO FOR VALIDATE
SNUM:	DB	0		;SECTOR NO FOR VALIDATE
VALFLG:	DB	0		;VALIDATION ERROR FLAG
G:	DB	0		;CPM GROUP NO
S:	DB	0		;SECTOR 
	DB	16H
ENDSTK:	DS	100		;STORAGE FOR NEW STACK
NEWSTK:	DS	0		;NEW STACK
PDIR	DS	256		;POINTER TABLE TO DIRECTORY (128 ENTRIES MAX)
DIRBUF:	EQU	PDIR+258	;START OF AREA USED TO STORE AND SORT DIRECTORY
	END
!  9"1/Y:1>2:<G:22& :oT))):_><E2~22 2: t! >2222!/ w#!1	"!/":_ L! "
:75?O* .!"  :M?O* ."  * .'"  **>#oÔ# ~a!  "*/^#V|a*#1
#'&H* "#Wx~#L LÔ L:<2**!  s#r* "* "*  " |¨}:<2â!  ""*/^#V|ʠz         $	 ::*[^#V*	 +K BYTES REMAINING ON DISK $	 :0*d
ERROR - SELECT DRIVE A,B,C, OR D$A	 9::è

                        DIRECTORY DRIVE - $z	 :0	 :ʠ=!  o)"!  "!**|ʵ""""$**|}**|}!/|g}o*'*'}o"*/^#V"*/^#V*&v* "R*/^#V*&*"v**|©}*/^#V*/^#V*!/s#r*!/s#rR( @x?G&;		NEW PASCAL BOOT MAINTENENCE PROGRAM
;
;	THIS VERSION SUPPORTS THE DOUBLE DENSITY 512 BYTE SECTOR FORMAT
;VERSION OF THE UCSD PASCAL SYSTEM. PGEN NOW CONTAINS THE BOOTER FOR
;BOTH THE OLD AND NEW VERSIONS OF THE TARBELL FLOPPY DISK CONTROLLERS
;AS WELL AS THE DELTA CONTROLLER. THE PASCAL SYSTEM SUPPORTS 4 SEPARATE
;DISK FORMATS.
;
;  A.	SINGLE SIDE, SINGLE DENSITY, 26 128 BYTE SECTORS PER TRACK
;  B.	SINGLE SIDE, SINGLE DENSITY,  8 512 BYTE SECTORS PER TRACK
;  C.	SINGLE SIDE, DOUBLE DENSITY, 16UF	EQU	9
START	EQU	900H
ENDPT	EQU	START+128+256+768+BIOSSZ	;BOOT+PINIT+SPARE+BIOS
NSECTS	EQU	20
FSTSCT	EQU	1
;
CR	EQU	0DH
LF	EQU	0AH
EOM	EQU	'$'
;
;
;
	ORG	TPA
;
;
	LXI	SP,STACK
MAIN:
	CALL	SAY$TITLE
	CALL	GET$BOOTER
	CALL	PUT$BOOTER
	JMP	REBOOT
;
;
HOME:				;HOME DISK
	LHLD	BOOT+1
	MVI	L,18H
	PCHL
;
SELDSK:				;SELECT DISK
	LHLD	BOOT+1
	MVI	L,1BH
	PCHL
;
SETTRK:				;SET TRACK
	LHLD	BOOT+1
	MVI	L,1EH
	PCHL
;
SETSEC:				;SET SECTOR
	LHLD	BOOT+1
	MVI	L,21H
	PCHL
;
SENE
;
;
PUT$BOOTER:			;DOES THE BOOTER GO OUT?
	MVI	C,WRBUF		;ASK
	LXI	D,PUT$MSG
	CALL	BDOS
	CALL	CK$YES		;IF THE ANSWER IS NOT YES
	RC			;LEAVE
PUT$AGAIN:			;ELSE START TO PUT
	MVI	C,WRBUF
	LXI	D,WRITE$MSG
	CALL	BDOS		;DO ANOTHER CONFIRM MSG
	CALL	WAIT$FOR$RET	;AND HOLD UP
	CALL	DO$WRITE	;NOW PUT IT OUT
	MVI	C,WRBUF		;IS THIS A LOOP?
	LXI	D,AGAIN$MSG
	CALL	BDOS
	CALL	CK$YES
	JNC	PUT$AGAIN	;GUESS SO
	RET			;ALL DONE
;
;
REBOOT:				;PULL BACK CP/M
	MVI	C,WRBUF
	LXI	D,REBOOT$MSG
	CALLU^#V|Mz         $	 :::*^#VE*{^#V|Mz* "& ::e, |l}ʠ|	 þ^ #
ʎ|~G###~!  oʪ#:·#}o}o
 |}d |} $	   $	    $	 *";	
 	|{0__ CK$A	 ɯ2<2:7n5?nO* .!"l  :M?ڃO* ."  * ."  * .'"  : 2::|	 
              $	 !  :o FILES    $	 *}o> g:	# 	7#y#yA:B:C:D:DA_ o
ERROR - DRIVE NUMBER GREATER THAN 3
$G	 @ $
$

$                "v*                    
	
                                                      512 BYTE SECTORS PER TRACK
;  D.	DOUBLE SIDE, DOUBLE DENSITY, 16 512 BYTE SECTORS PER TRACK
;	THESE FORMATS GIVE THE FOLLOWING NUMBER OF BLOCKS PER DISK
;
;		A  -  494 BLOCKS
;		B  -  608 BLOCKS
;		C  - 1216 BLOCKS
;		D  - 2448 BLOCKS
;
BIOSSZ	EQU	1536
;
TPA	EQU	100H
;
;
;
;		BOOTER MAY BE READ IN FROM CURRENT PASCAL DISK AND MOVED
;		ONTO ANY NUMBER OF NEW DISKETTES
;
;	THIS PROGRAM PROVIDED COURTESY OF NORTHWEST MICROCOMPUTER SYSTEMS, INC.
;
;
BOOT	EQU	0
BDOS	EQU	5
RDCON	EQU	1
WRBTDMA:				;SET DMA ADDRESS
	LHLD	BOOT+1
	MVI	L,24H
	PCHL
;
READ:				;READ A SECTOR
	LHLD	BOOT+1
	MVI	L,27H
	PCHL
;
WRITE:				;WRITE A SECTOR
	LHLD	BOOT+1
	MVI	L,2AH
	PCHL
;
;
SAY$TITLE:			;JUST SAY WHO WE ARE
	MVI	C,WRBUF
	LXI	D,HELLO$MSG
	CALL	BDOS
	RET
;
;
GET$BOOTER:			;MAYBE A BOOTER COMES IN
	MVI	C,WRBUF
	LXI	D,GET$MSG
	CALL	BDOS
	CALL	CK$YES
	RC			;THAT'S ALL FOR HERE
	MVI	C,WRBUF
	LXI	D,READ$MSG	;SAY HEY
	CALL	BDOS
	CALL	WAIT$FOR$RET	;AND WAIT
	CALL	DO$READ
	RET			;DO	BDOS
	CALL	WAIT$FOR$RET
	JMP	BOOT
;
;
CK$YES:				;CHECK FOR A YES RESPONSE
	MVI	C,RDCON
	CALL	BDOS
	CPI	03H		;DON'T FORGET ^C
	JZ	BOOT
	CPI	'Y'		;UPPER CASE
	RZ
	CPI	79H		;AND LOWER
	RZ
	STC			;NOT THERE
	RET
;
;
WAIT$FOR$RET:			;HANG AROUND
	MVI	C,RDCON
	CALL	BDOS
	CPI	03H		;TEST FOR REBOOT REQUEST
	JZ	BOOT
	CPI	CR		;LEAVE WHEN READY
	JNZ	WAIT$FOR$RET
	RET
;
;
DO$READ:			;READ IN THE BOOTER
	MVI	C,0		;SELECT DISK
	CALL	SELDSK
	CALL	TIME
	CALL	HOME		;MAKE SURE IT'S INITIALIZED
	LXI	B,START		;SET WHERE WE START IN RAM
	LXI	D,NSECTS SHL 8 + FSTSCT ;SIZE AND THE FIRST SECTOR
DR$LOOP:				;THEN PUT IT OUT
	PUSH	B
	PUSH	D
	CALL	SETDMA
	POP	D
	MOV	C,E
	PUSH	D
	CALL	SETSEC
	CALL	READ
	POP	D
	POP	B
	LXI	H,128
	DAD	B
	MOV	B,H
	MOV	C,L
	INR	E
	DCR	D
	JNZ	DR$LOOP
	RET
;
;
DO$WRITE:			;WRITE OUT THE BOOTER
	MVI	C,1		;SELECT THE DISK
	CALL	SELDSK
	CALL	TIME
	CALL	HOME
	CALL	TIME
	LXI	B,START
	LXI	D,NSECTS SHL 8 + FSTSCT
DW$LOOP:			;ALL PARAMS SET - RUN IT OUT Booter to drive B, type return ',eom
AGAIN$MSG:	DB	CR,LF,'Again?(y/n)',eom
REBOOT$MSG:	DB	CR,LF,LF,'Rebooting CP/M, type return ',eom
;
;
	DS	256
STACK	EQU	$
;
;
;
	END	TPA
;		PASCAL BOOT LOADER
;
;				S.J.SINGER (714)-780-8853
;				GEORGE BOLTHOFF
;
;This is a modification of TARBELL'S cold start loader.
;It loads in the PASCAL bios and PINIT ,the PASCAL init
;program.
;   The program runs at 0000h and loads 20 sectors from
;the disk,starting with sector 2.
;
;
FALSE	EQU	00		;LOGICAL FALSE
TRUE	EQU	NOT FALSE
;
;	THESE SWITCHES SET TO FORMAT CODE IN LOCATION 7FH
DBLDEN	EQU	FALSE
SEC512	EQU	FALSE
QUAD	EQU	FALSE
;
;
MSIZE	EQU	64		;MEMORY SIZE IN DECIMAL KB.
	;SEEK TRACK 0
	IN	WAIT
	ORA	A
	MVI	A,1
	JM	ERROR
	IN	DSTAT
	ANI	91H
	JNZ	ERROR
	MOV	A,C
	CALL	READ
RBLK1:	JNZ	ERROR
	DCR	D
HALT:	JZ	LOADP
	INR	C
RBLK2:	MOV	A,C
	CALL	READ1
	JMP	RBLK1
;
;
READ1:	OUT	SECT
	IN	DSTAT
	RRC
	MVI	A,1
	JC	RERR
	MVI	A,88H
	JMP	READE
;
READ:	OUT	SECT
	IN	DSTAT
	RRC
	MVI	A,1
	JC	RERR
	MVI	A,8CH
READE:	OUT	DCOM
RLOOP:	IN	WAIT
	ORA	A
	JP	RDONE
	IN	DDATA
	MOV	M,A
	INX	H
	JMP	RLOOP
;
RDONE:	IN	DSTAT
RERR:	ANI	9DH
	RET
;
;
ERROR:	CMA
	OUT	0F;		--- PASCAL BOOTER PROGRAM ---
;
;						S. J. SINGER  (714)-780-8853
;						GEORGE BOLTHOFF
;
;
;	THIS PROGRAM IS A COMBINATION OF PINIT THE PASCAL INITIALIZATION
;PROGRAM AND A BIOS THAT SUPPORTS BOTH STANDARD IBM 3740 FORMAT DISKS AS WELL
;AS DISKS FORMATTED INTO 512 BYTE BLOCKS SINGLE AND DOUBLE DENSITY. THE PROGRAM
;HAS CONDITIONAL ASSEMBLIES FOR 3 DIFFERENT DISK CONTROLLERS, THE OLD TARBELL
;1771 CONTROLLER, THE NEW TARBELL DOUBLE DENSITY CONTROLLER AND THE DELTA
;DOUBLE DENSITY CONTROLLER
	PUSH	B
	PUSH	D
	CALL	SETDMA
	POP	D
	MOV	C,E
	PUSH	D
	CALL	SETSEC
	CALL	WRITE
	POP	D
	POP	B
	LXI	H,128
	DAD	B
	MOV	B,H
	MOV	C,L
	INR	E
	DCR	D
	JNZ	DW$LOOP
	RET
;
TIME:	LXI	B,8000H		;TIMING DELAY
DELAY:	DCX	B
	MOV	A,B
	ORA	C
	JNZ	DELAY
	RET
;
;
;
;
HELLO$MSG:	DB	CR,LF,'Pgen Version 1.0',CR,LF,EOM
GET$MSG:	DB	CR,LF,'Get Booter?(y/n)',eom
READ$MSG:	DB	CR,LF,'Reading Booter from drive A, type return ',eom
PUT$MSG:	DB	CR,LF,LF,'Put Booter?(y/n)',eom
WRITE$MSG:	DB	CR,LF,'Writing
DISK	EQU	0F8H		;BASE ADDR FOR DISK I/O PORTS
DCOM    EQU	DISK
DSTAT   EQU	DISK
TRACK   EQU	DISK+1
SECT    EQU	DISK+2
DDATA   EQU	DISK+3
WAIT    EQU	DISK+4
BIOSSZ	EQU	1536		;12 SECTORS
PINITSZ	EQU	1024		;8 SECTORS
LOADP	EQU	MSIZE*1024-BIOSSZ-PINITSZ
NSECTS	EQU	20		;NUMBER OF SECTORS TO LOAD
;
;
	ORG	0
;
BOOT:   LXI	SP,100H
BOOT1:	LXI	B,2		;B=TRACK, C=SECTOR
	MVI	D,NSECTS	;D CONTAINS SECTOR COUNT
	LXI	H,LOADP		;STARTING LOAD ADDR FOR PROGRAM
RBLK	MOV	A,B
	OUT	DDATA
	MVI	A,13H
	OUT	DCOM	FH
	HLT
;
;
	ORG	7DH
	RST	0
;
	IF	SEC512
	ORG	7FH
	DB	22H
	ENDIF
;
	IF	DBLDEN
	ORG	7FH
	DB	12H
	ENDIF
;
	IF	QUAD
	ORG	7FH
	DB	92H
	ENDIF
;
	IF	NOT DBLDEN AND NOT SEC512 AND NOT QUAD
	ORG	7FH
	DB	20H
	ENDIF
;
	END
.
;	THE INITIALIZATION SECTION POLLS UP TO 4 DRIVES AND INITIALIZES THE
;SYSTEM FOR THE DRIVES WHICH ARE READY. DRIVES 0 AND 1 CORRESPOND TO PASCAL
;LOGICAL UNITS 4 AND 5 RESPECTIVELY WHILE DRIVES 2 AND 3 CORRESPOND TO PASCAL
;LOGICAL UNITS 9 AND 10. AT LEAST ONE DRIVE UNIT 4 MUST BE READY.
;	THE PROGRAM THEN READS TRACK ZERO SECTOR ONE FOR EACH UNIT THAT IS
;READY AND EXAMINES THE FORMAT BYTE 7FH TO DETERMINE THE PROPER INITIALIZATION
;FOR EACH DISK. AT PRESENT FOUR DIFFERENT FORMATS ARE SUPPORTED.
;
;	FMT CODE			DISK FORMAT			BLOCKS
;	  20H	  SNGL DENSITY, SNGL SIDED, 26 SECTORS/TRK 128 BYTES      494
;	  22H	  SNGL DENSITY, SNGL SIDED,  8 SECTORS/TRK 512 BYTES      608
;	  12H	  DBL  DENSITY, SNGL SIDED, 16 SECTORS/TRK 512 BYTES     1216
;	  92H	  DBL  DENSITY, DBL  SIDED, 16 SECTORS/TRK 512 BYTES     2448
;
;
;IF AN IMPROPER FORMAT CODE IS READ SUCH AS ANY DOUBLE DENSITY CODE WITH
;A SINGLE DENSITY TARBELL CONTROLLER THE PROGRAM WILL HALT WITH AN ERROR MESSAGE
;A FORMAT CODE OF 0DDH IS A A 1771 CONTROLLER) AND ASK YOU TO REBOOT.
;
;  OFFSET FOR 64K SYSTEM IS 1380H IF BIOS STARTS AT 0FA00H
; 
FALSE	EQU	00H	;LOGICAL FALSE
TRUE	EQU	NOT FALSE
;
DELTA	EQU	FALSE	;CONDITIONAL ASSMEBLY FOR DELTA CONTROLLER
TARBELL	EQU	FALSE	;CONDITIONAL ASSEMBLY FOR NEW TARBELL CONTROLLER
ISIO2	EQU	TRUE	;CONDITIONAL FOR IMSAI SIO-2 SERIAL BOARD (8251'S)
PT3PLUS	EQU	FALSE	;CONDITIONAL FOR PROCESSOR TECH 3P+S BOARD
TUART	EQU	FALSE	;CONDITIONAL FOR CROMEMCO TUART SERIAL BOARD
ADM3A	EQU	TRUE	;CONDITIONAL FIF	ISIO2
TSTAT	EQU	3H	;STATUS AND COMMAND PORT
PORT01	EQU	2H	;SERIAL PORT 1
IMSK01	EQU	02H	;RX READY PORT 1
OMSK01	EQU	01H	;TX READY PORT 1
	ENDIF
;
	IF	PT3PLUS
TSTAT	EQU	00H	;TERMINAL STATUS AND COMMAND PORT
PORT01	EQU	01H	;TERMINAL DATA PORT
IMSK01	EQU	01H	;RX READY PORT 1
OMSK01	EQU	80H	;TX READY PORT 1
	ENDIF
;
CTRLS	EQU	19	;CONTROL S USED TO STOP DISPLAY ON TERMINAL
CR	EQU	13	;ASCII CARRIAGE RETURN
;
;   ----- DISK DRIVER EQUATES -----
;  
DISK	EQU  0F8H	;DISK BASE ADDRESS.
DCOM	EQUQU	UBLK+2
URTN	EQU	UASY+2
ERRFLG	EQU	URTN+2
;
BIOSTEM:EQU	70H		;ADDITIONAL TEMPORARIES FOR BIOS VARIABLES
SECLEN	EQU	BIOSTEM		;SECTOR LENGTH CODE 0=128 BYTES 2=512 BYTES
DSKDR	EQU	SECLEN+1	;CURRENTLY SELECTED DISK DRIVE
NUMSEC	EQU	DSKDR+1		;NUMBER OF SECTORS PER TRACK (8 OR 16 FOR 512)
NUMDSK	EQU	NUMSEC+1	;NUMBER OF DISKS ON LINE  1 TO 4
DBLSID	EQU	NUMDSK+1	;FLAG TRUE IF DOUBLE SIDED DISK
ERCNT	EQU	DBLSID+1	;ERROR COUNT FOR DISK I/O OPERATIONS
DMAADD	EQU	ERCNT+1		;MEMORY ADDRESS FOR DISK I/O TRAN  
;
	MACLIB Z80	;INCLUDE Z-80 MICROS
;
BIOS$PAGE	EQU	2H		;bios page pointer
BIOS		EQU	MSIZE*1024-BIOSSZ
IBASE		EQU	BIOS-1024	;1024 byte allowed
;
; 8251 USART INIT. EQUATES,7 BIT CHAR-NO PARITY
; 1 STOP BIT-BAUD RATE 16X...COMMAND WORD = 4AH
;
CMMND		EQU	4AH		;USART COMMAND AS ABOVE
; 
INTERP$BASE	EQU	100H		;first loc used by inte
PBEGIN		EQU	INTERP$BASE+100H
FIRSTSP		EQU	INTERP$BASE+103H
DENTSZ		EQU	1AH		;dir entry size,bytes
DTITLE		EQU	06H
NBLOCKS		EQU	19		;size of SYSTEM.MICRO
DIRTOPSSUMED TO BE DOUBLE DENSITY 128 BYTE SECTORS AND
;ANY OTHER CODE IS ASSUMED TO IDENTIFY A STANDARD IBM 3740 DISKETTE.
;IF THE DISK FORMATTING PROGRAM 'DFOCO' IS USED TO FORMAT THE DISKS THE
;PROPER FORMAT BYTE IS AUTOMATICALLY PLACED ON TRACK ZERO SECTOR ONE.
;SYSTEM VARIABLES ARE INITIALIZED FOR ALL DRIVES THAT ARE READY. IF FORMATS
;ARE DETERMINED TO BE INCOMPATABLE THE SYSTEM WILL HALT WITH AN ERROR MESSAGE
;IDENTIFYING THE DRIVE HAVING THE INCORRECT FORMAT (FOR EXAMPLE A DOUBLE
;DENSITY DISK WITHOR ADM-3A TERMINAL
SOROC	EQU	FALSE	;CONDITIONAL FOR SOROC OR OTHER TERM NO SOFTWARE DRV
PERSCI	EQU	FALSE	;CONDITIONAL FOR FAST SEEK ON DUAL PERSCI DRIVES
STEP	EQU	1	;STEP RATE 1791  0=3 MSEC, 1=6 MSEC, 2=10 MSEC
MSIZE	EQU	64	;MEMORY SIZE IN DECIMAL KB
BIOSSZ	EQU	1536	;BYTES IN THIS BIOS
LOADP	EQU	MSIZE*1024-BIOSSZ	;LOAD POINT
;
;  ---- LIST (PRINTER) EQUATES ----
;
LSTAT	EQU	4	;LIST STATUS PORT.
LDATA	EQU	4	;LIST DATA PORT.
LMASK	EQU	1	;LIST DATA READY MASK
;
; -----  TERMINAL EQUATES -----
	  DISK	;DISK COMMAND PORT.
DSTAT	EQU  DISK	;DISK STATUS PORT.
TRACK	EQU  DISK+1	;DISK TRACK PORT.
SECTP	EQU  DISK+2	;DISK SECTOR PORT.
DDATA	EQU  DISK+3	;DISK DATA PORT.
WAIT	EQU  DISK+4	;DISK WAIT PORT.
DCONT	EQU  DISK+4	;DISK CONTROL PORT.
RTCNT	EQU  10		;RETRY COUNT.
;
;---- PASCAL IO TEMPORARIES ---
;---- PBIOS TEMPORARIES ---
;
BIOSADR:EQU	40H		;CONTAINS HEX ADDR OF START OF BIOS
UPTR	EQU	BIOSADR+2
UREQ	EQU	UPTR+2
UNIT	EQU	UREQ+1
UBUF	EQU	UNIT+1
ULEN	EQU	UBUF+2
UBLK	EQU	ULEN+2
UASY	ESFERS
TRKTBL	EQU	DMAADD+2	;CONTAINS PARAMETERS FOR ALL DISK DRIVES
;
;	FOR FLOPPY DISKS TRKTBL CONTAINS TRACK SECTOR SIZE AND DENSITY FOR EACH
;	DISK DRIVE (MAX OF FOUR FLOPPY DISK DRIVES AT PRESENT)
;
;DRIVE	ADDR		TRACK		DENSITY		SECSIZ
;  4	TRKTBL		0 - 76		1 OR 2		0 OR 2
;  5	TRKTBL+3
;  9	TRKTBL+6
; 10	TRKTBL+9
;
;
ASNCBIT	EQU	01H
DRCTBIT	EQU	02H
ASYBIT	EQU	01H
DSKBIT	EQU	02H
EOFBIT	EQU	04H
DLEBIT	EQU	04H
CRLFBIT	EQU	08H
INBIT	EQU	01H
OUTBIT	EQU	02H
CLRBIT	EQU	04H
ALLBIT	EQU	07H
;		EQU	IBASE-1000H
BUFFER		EQU	DIRTOP		;USED FOR DENSITY DETERMINATION
;
	ORG	IBASE
;
	LXI	SP,100H			;INITIALIZE STACK POINTER
	JMP	INIT$IO
MAIN:	LXI	H,DIRTOP
	CALL	READ$DIR	;read dir into dirtop
	LXI	H,DIRTOP	;set dir entry pointer
	LXI	D,DENTSZ	;to firet entry after volume
	DAD	D
	SHLD	DENTP
;
	CALL	FIND$INTERP	;find the interpreter
	LXI	H,LDMSG
	CALL	MSG
	CALL	READ$INTERP	;then read it in
;
	JMP	PBEGIN		;boot in SYSTEM.PASCAL
;
; ---- INITIALIZE I/O -----
;All terminal,UART,etc initializing to be done here
;Initialize terminal first,in case error message needed
	IF	PT3PLUS
INIT$IO:NOP
	ENDIF
;
;
	IF	ISIO2		;INITIALIZE 8251
INIT$IO:MVI	A,80H
	OUT	TSTAT		;DO A SOFTWARE RESET
	MVI	A,80H		;KILL SOME TIME !
	OUT	TSTAT
	MVI	A,40H		;HERE'S THE RESET
	OUT	TSTAT
	MVI	A,CMMND		;INIT 8251
	OUT	TSTAT
	MVI	A,27H
	OUT	TSTAT
	ENDIF
;
	IF	TUART		;INITIALIZE CROMEMCO TUART
BAUDRS:	DB	94H,0CEH,0A2H,92H,88H,84H,82H,1
INIT$IO:MVI	A,1		;SET A = 1.
	OUT	54H		;SELECT DEVICE A.
	OUT	52; DEFAULT FOR BOOT IS STANDARD 3740 FORMAT. PROGRAM CHECKS DENSITY FMT CODE
; TRK 0 SEC 1 BYTE 128 FOR OTHER FORMATS
;
INIT01:	LXI	H,BIOS		;ADDR OF BIOS
	SHLD	BIOSADR		;SET ADDR VECTOR FOR INTERPRETER
	XRA	A		;DEFAULT TO 128 BYTE SECTORS
	STA	SECLEN
	MVI	A,8		;SECTORS PER TRACK
	STA	NUMSEC
	LXI	H,TRKTBL	;POINT TO DISK PARAMETER TABLE
	MVI	B,12		;LIMIT
	XRA	A
INIT02:	MOV	M,A		;STORE A ZERO
	INX	H		;INCR MEMORY POINTER
	DCR	B		;DECR COUNT
	JNZ	INIT02		;LOOP TILL DONE
;
;		CHECK WHICH DRIVES A	CALL	SELECT		;SELECTS DENSITY ALSO
	ENDIF
;
	LXI	H,ONMSG3
	CALL	MSG
	POP	PSW
	LXI	H,ONMSG5
	CPI	1
	JZ	IND15
	LXI	H,ONMSG4
IND15:	CALL	MSG
	LXI	H,TRKTBL+2	;POINT TO SECTOR SIZE CODE
	MOV	A,M
	ORA	A		;SET FLAGS
	LXI	H,ONMSG6
	JZ	IND18
	LXI	H,ONMSG7
IND18:	CALL	MSG		;PRINT THE MESSAGE
	LXI	D,TRKTBL+4	;DENSITY CODE UNIT 5
	LDAX	D		;PICK UP THE CODE
	ORA	A
	JZ	MAIN		;EXIT IF ONLY ONE DRIVE
	LXI	H,ONMSG8
	CALL	MSG
	LDAX	D		;DENSITY CODE
	LXI	H,ONMSG4
	CPI	2		;SINGLE DENSITY ?
	JZ	IND20STA	UREQ		;READ REQUEST
	MVI	C,0		;SELECT DRIVE 0
	CALL	BIOS		;READ IN DIRECTORY
	RET
;
FIND$INTERP:			;FIND 'SYSTEM.MICRO'
	MVI	C,77		;STOP AFTER THE 77'TH ENTRY
	LHLD	DENTP		;GET STARTING ENTRY
FI$SCH$LP:
	LXI	D,DTITLE	;ADVANCE TO TITLE STRING
	DAD	D
	LXI	D,SYSTLE	;SET DE-REG TO COMPARISON STRING
	MVI	B,LENGTH+1	;COMPARISON LENGTH
FI$CMP$LP:			;START COMPARING
	LDAX	D
	CMP	M
	JNZ	FI$CONT		;IT'S NOT THIS ONE
	INX	D		;HEY, WE'VE STILL GOT A CHANCE
	INX	H
	DCR	B		;IS THIS THE END OF THE STG
	SHLD	UBLK		;STARTING BLOCK
	LXI	H,INTERP$BASE	;DMA LOAD POINT
	SHLD	UBUF
	LXI	H,NBLOCKS*512
	SHLD	ULEN
	MVI	C,0		;SELECT DRIVE 0
	CALL	BIOS		;READ IN INTERP
	RET
;
;
DENTP	DS	2
;
;--------- CHARACTER DRIVERS ---------------
;
; --- MESSAGE HANDLER -----
;
MSG:	MOV	A,M		;GET BYTE
	ORA	A		;IS IT ZERO
	RZ			;RETURN IF SO
	MOV	C,A
	PUSH	H		;SAVE POINTER
	CALL	COUT		;GIVE BYTE TO TERMINAL
	POP	H
	INX	H
	JMP	MSG
;
;		LOTS OF MESSAGES FOR INITIALIZE
;
NOMICRO:DB	0DH,0AH,'No SYSTEM.MH		;RESET DEVICE B.
	LXI	H,BAUDRS		;GET ADR OF BAUD RATE TABLE.
	MVI	A,11H		;OCTUPLE THE CLOCK.
IT1:	OUT	02H		;& RESET CURRENT DEV.
	MOV	A,M		;GET BAUD RATE FROM TABLE.
	INX	H		;INCREMENT POINTER.
	OUT	0		;SET BAUD RATE.
	CALL	CIN		;READ KEYBOARD.
	CALL	CIN		;READ KEYBOARD AGAIN.
	CPI	CR		;IF NOT CARRIAGE-RETURN,
	MVI	A,1		;SLOW THE CLOCK.
	JNZ	IT1		;UNTIL A CARRIAGE-RETURN.
	ENDIF


;
SCRCLR:	LXI	H,CLRSCR	;CLEAR TERMINAL
	CALL	MSG
;
; INITIALIZE ALL VARIABLES, POINTERS ETC. AS REQUIRED
RE ON LINE AND INITIALIZE THEM
;
	CALL	DSKINT
	LXI	H,ONMSG
	CALL	MSG
	LDA	NUMDSK		;NUMBER OF DRIVES ON LINE
	ADI	48		;CONVERT TO ASCII
	MOV	C,A
	CALL	COUT		;PRINT IT
	LXI	H,ONMSG1
	LDA	NUMDSK
	CPI	1
	JNZ	IND11
	LXI	H,ONMSG2
IND11:	CALL	MSG		;DISK INITIALIZATION MESSAGE
	LXI	H,TRKTBL+1	;POINT TO DENSITY CODE UNIT #4
	MOV	A,M		;GET IT
	PUSH	PSW
;
	IF	DELTA		;(1791)
	CALL	DENSEL1		;SELECT DENSITY FOR READING SYSTEM.MICRO
	ENDIF
;
	IF	TARBELL		;(1791)
	MVI	C,0		;SELECT DRIVE 0 (UNIT 4)

	LXI	H,ONMSG5
IND20:	CALL	MSG
	LXI	H,TRKTBL+5	;POINT AT SECSIZ UNIT 5
	MOV	A,M		;PICK IT UP
	ORA	A
	LXI	H,ONMSG6
	JZ	IND23
	LXI	H,ONMSG7
IND23:	CALL	MSG
	JMP	MAIN		;RETURN WITH JUMP 
;
;---- READ DIRECTORY AND LOAD IN SYSTEM.MICRO ----
;
READ$DIR:			;read dir 4 blocks into buffer
				;buffer adr in HL reg
	SHLD	UBUF		;DMA  DIRECTORY LOAD POINT
	LXI	H,800H		;LENGTH=2048 BYTES  800H
	SHLD	ULEN
	LXI	H,0002H		;STARTING BLOCK
	SHLD	UBLK
	XRA	A		;ZERO REG A
	STA	UNIT
	STA	UASY
	MVI	A,1
	RING
	JNZ	FI$CMP$LP
	JMP	FI$FOUND	;I THINK WE FOUND IT
FI$CONT:
	LHLD	DENTP		;ON TO THE NEXT ENTRY
	LXI	D,DENTSZ
	DAD	D
	SHLD	DENTP
	DCR	C		;WAIT, IS THERE ANY DIR LEFT?
	JNZ	FI$SCH$LP
FI$HANG:			;INTERPRETER NOT THERE, GO DUMB
	LXI	H,NOMICRO
	CALL	MSG
HANG:	JMP	HANG

FI$FOUND:			;WE'VE GOT IT
	RET
;
LENGTH	EQU	12		;TITLE LENGTH
SYSTLE	DB	LENGTH,'SYSTEM.MICRO'
;
;
READ$INTERP:			;PUT INTERP IN ITS PLACE
	LHLD	DENTP		;GET STARTING BLOCK
	MOV	E,M		;  INTO HL-REG
	INX	H
	MOV	D,M
	XCHICRO .....',0
LDMSG:	DB	0DH,0AH,0AH,'	Loading PASCAL system.....',0
RDMSG:	DB	0DH,0AH,' ERROR ATTEMPTING TO READ DENSITY CODES ',0
BADFMT:	DB	0DH,0AH,'UNSUPPORTED DISK FORMAT UNIT ',0
BADFM1:	DB	' .... PLEASE REBOOT',0DH,0AH,0AH,0
QUITMSG:DB	0DH,0AH,'UNIT #4 NOT READY .... PLEASE REBOOT',0DH,0AH,0AH,0
ONMSG:	DB	0DH,0AH,0AH,'PASCAL SYSTEM INITIALIZED FOR ',0
ONMSG1:	DB	' DISK DRIVES',0DH,0AH,0
ONMSG2:	DB	' DISK DRIVE',0DH,0AH,0
ONMSG3:	DB	'UNIT NUMBER FOUR IS',0
ONMSG4:	DB	' SINGLE DENSITY',0
ONMSG5:	DB	' DOUBLE DENSITY',0
ONMSG6:	DB	' WITH 128 BYTE SECTORS',0DH,0AH,0
ONMSG7:	DB	' WITH 512 BYTE SECTORS',0DH,0AH,0
ONMSG8:	DB	'UNIT NUMBER FIVE IS',0
CLRSCR:	DB	27,42,26,0	;CLEARSCREEN FOR ADM-3A AND SOROC
;
;
;---------- DISK ROUTINES -----------
;
; HOME ALL DRIVES THAT ARE READY, THEN READ FORMAT CODE FROM TRACK
; ZERO AND INITIALIZE TRKTBL ENTRIES. FINALLY BOOT SYSTEM FROM DRIVE 0
;
DSKINT:	MVI	A,2		;MAX NUMBER OF FLOPPY DRIVES
	STA	NUMDSK		;CHECK FOR UP TO 4 DRIVES
IDSK01:	DCR	A
	STA;UNIT 4 NOT READY
	CALL	MSG
	JMP	HANG		;PROCESSOR HALT - MUST REBOOT
IDSK03:	LDA	DSKDR		;GET CURRENT DRIVE NO
	CALL	INDEX		;GET DISK PARAMETER TABLE POINTER
	XRA	A
	MOV	M,A		;SET TRACK TO ZERO
	PUSH	H		;SAVE FOR LATER
	CALL	HOME		;home this drive
	CALL	RDSEC1		;READ IN SECTOR ONE
	CALL	LONGDEL		;JUST WAIT
	LDA	BUFFER+7FH	;GET DENSITY CODE FROM BUFFER
;
	IF	NOT DELTA AND NOT TARBELL
	CPI	12H		;SINGLE SIDE DD
	JZ	IDSK04
	CPI	92H		;DOUBLE SIDE DD
	JZ	IDSK04
	ENDIF
;
	CPI	0DDH		;CHECK FOR DD		;3740 DISK
	CPI	3
	JP	IDSK09		;SHOULDN'T BE > 2 EITHER
	MOV	M,A		;STORE DENSITY
	INX	H		;POINT TO SECTOR LENGTH CODE
	LDA	BUFFER+7FH	;DISK ID CODE
	ANI	0FH		;EXTRACT LENGTH
	MOV	M,A		;STORE IN TABLE
IDSK09:	LDA	DSKDR		;check if done yet
	ORA	A
	JNZ	IDSK01		;not done,continue
	LDA	TRKTBL+2	;SECTOR SIZE UNIT 4
	CPI	2		;2 = 512 BYTE SECTORS
	RNZ			;ASSUME DEFAULT 128
	LXI	H,NUMSEC	;POINT TO NUMBER OF SECTORS UNIT 4
	STA	SECLEN		;SET SECTOR LENGTH TO 2 (512 BYTES)
	LDA	TRKTBL+1	;GET DENSITY FLT SECTOR ONE
	CALL	READ
	LDA	ERRFLG		;CHECK ERROR FLAG
	ORA	A
	RZ
	LXI	H,RDMSG
	CALL	MSG
	JMP	HANG
;
;
;Delay loop gives drive 11 mill sec to settle
;
DELAY:	LXI	B,700H
DELAY1:	DCX	B
	MOV	A,B
	ORA	C
	JNZ	DELAY1
	RET
;
;
;  LONGDEL  LONG DELAY FOR HOME COMMAND
;
LONGDEL:LXI	H,5000H
	LXI	D,0001H
	XRA	A
LD01:	DAD	D
	JNC	LD01
	RET

; ***********************************************************
;
;  BIOS ROUTINES START HERE.
;
; ****************************************************R DRIVERS ******************
;
CHDRVR:	LDA	UREQ
	ANI	CLRBIT
	JRZ	CH01
	XRA	A
	STA	CLAST
	JMP	CHX
CH01:	LHLD	ULEN
	XCHG
	LHLD	UBUF
CH02:	MOV	A,E		;SET UP LOOP
	ORA	D
	JZ	CHX
	DCX	D
	LDA	UREQ		;WHICH DIRECTION
	ANI	OUTBIT
	JRZ	CH03
	MOV	C,M		;DO OUTPUT
	CALL	ECHO
	JR	CH06
CH03:	CALL	CIN		;DO INPUT
	MOV	C,A
	MOV	M,A
	LDA	UASY
	ANI	EOFBIT
	JRNZ	CH05
	MVI	A,03H
	CMP	M
	JRNZ	CH05
	LDA	UNIT
	CPI	01H
	JRNZ	CHX
	INX	D
CH04:	MVI	M,0		;LOOP,PUTING ZERO'S IN BUFFER
	DCX	D
	INX	H
	MO	DSKDR		;SAVE FOR LATER
	MOV	C,A		;TO C ALSO FOR SELECT ROUTINES
	LXI	H,TRKTBL+1	;DENSITY UNIT 4 (WILL ALWAYS BE SINGLE)
	CALL	SELECT		;SELECT THE DRIVE
	MVI	A,0DH
	OUT	DCOM		;INTERRUPT CONTROLLER
	XTHL
	XTHL
	XTHL
	XTHL			;SHORT WAIT FOR STATUS
	IN	DSTAT		;READ DISK STATUS
	ANI	80H		;CHECK DRIVE READY
	JZ	IDSK03		;CONTINUE IF READY
	LDA	NUMDSK		;NUMBER OF DISKS
	DCR	A
	STA	NUMDSK		;REDUCE NO OF DRIVES ON LINE BY ONE
	LDA	DSKDR		;LOAD DRIVE NO
	JP	IDSK01		;LOOP IF UNIT 4 OK
	LXI	H,QUITMSG	 DISK WITH 128 BYTE SECTORS
	JNZ	IDSK05
IDSK04:	LXI	H,BADFMT	;PRINT ERROR MESSAGE
	CALL	MSG
	LDA	DSKDR		;DRIVE NO
	ADI	52		;COMPUTE UNIT NO
	MOV	C,A
	CALL	COUT		;PRINT IT
	LXI	H,BADFM1
	CALL	MSG		;PRINT REST OF MESSAGE
	JMP	HANG		;AND QUIT
IDSK05:	RRC
	RRC
	RRC
	RRC			;SHIFT RIGHT 4
	ANI	0FH		;EXTRACT DENSITY (1=DBL, 2=SNGL)
	POP	H		;get back trktab pointer
	INX	H		;POINT TO DENSITY
	MVI	B,2		;DENSITY CODE FOR SINGLE DENSITY
	MOV	M,B		;DEFAULT FOR DISKS WITH NO ID CODE
	ORA	A
	JZ	IDSK09AG
	CPI	1		;1 = DOUBLE DENSITY
	MVI	A,8		;8 SECTORS PER TRACK (SINGLE DENSITY)
	MOV	M,A		;SELECT SINGLE
	RNZ			;RETURN IF NOT DOUBLE
	ADD	A		;16 SECTORS PER TRACK (DOUBLE DENSITY)
	MOV	M,A		;SELECT DOUBLE
	RET			;exit DSKINT
;
;    READ SECTOR ONE TRACK ZERO INTO BUFFER
;
RDSEC1:	LXI	H,BUFFER
	SHLD	DMAADD		;MEMORY ADDR FOR READ
	LXI	H,128
	SHLD	ULEN		;NUMBER OF BYTES TO READ
	XRA	A
	STA	ERRFLG		;ZERO DISK I/O ERROR FLAG
	MVI	C,0
	CALL	SETTRK		;SET TRACK TO ZERO
	MVI	A,1
	STA	SECT		;SELEC*******
;
;
;  PBIOS  PASCAL I-O ROUTINES       28-JULY-79
;  MODIFIED FOR DOUBLE DENSITY	    15-NOV-79
	ORG	LOADP
; 
; I/O JUMP VECTOR
BEGIN:	JMP	DSKIO	;ENTRY POINT FOR DISK DRIVERS
	JMP 	CHDRVR	;ENTRY FOR CHARACTER DRIVERS
	JMP	REMIN	;REMOTE IN
	JMP	REMOUT	;REMOTE OUT
;
IOXIT:	RET
;----- PBIOS SCRATCH AREA ------
TRK:	DB	0	;CURRENT TRACK
SECT:	DB	0	;CURRENT SECTOR
DSCT0:	DB	0	
DSCT:	DB	0
DTRK:	DB	0
CLAST:	DB	0
LATCH:	DB	0	;LATCH FOR CURRENT DRIVE SELECT
;
;***************** CHARACTEV	A,E
	ORA	D
	JRNZ	CH04
	JR	CHX
CH05:	LDA	UNIT
	CPI	01H
	CZ	ECHO
CH06:	INX	H
	JR	CH02
CHX:	JP	IOXIT
;CHAR IN REG C IS INTERPRETED AND OUTPUT
ECHO:	LDA	UASY
	ANI	DLEBIT
	JRNZ	ECH03
ECH01:	LDA	CLAST
	CPI	10H
	JRNZ	ECH03
	MOV	A,C
	SUI	20H
	STA	CLAST
ECH02:	LDA	CLAST
	DCR	A
	JM	ECH05
	STA	CLAST
	MVI	C,32		;ASCII SPACE
	CALL	COUT
	JR	ECH02
ECH03:	MOV	A,C
	STA	CLAST
	CPI	10H
	JRNZ	ECH04
	LDA	UASY
	ANI	DLEBIT
	JRZ	ECH05
	MVI	A,20H
	STA	CLAST
ECH04:	CALL	COUT
	LDA	UASY
	ANI	CRLFBIT
	JRNZ	ECH05
	LDA	CLAST
	CPI	CR
	JRNZ	ECH05
	MVI	A,0AH
	STA	CLAST
	MOV	C,A
	CALL	COUT
ECH05:	RET

REMIN:	RET
REMOUT:	RET
;
;------------- DISK DRIVERS -------------------
DSKIO:	CALL	SELDSK		;SELECT DRIVE IN REG C
	LDA	UREQ
	ANI	CLRBIT
	JRZ	CHK00
;     DONT ALLOW PASCAL TO CLEAR (HOME) DRIVES
	JP	XDSK
CHK00:	LDA	UASY
	ANI	DSKBIT		;DONT ALLOW SECTOR ACCESS
	JRZ	CHKDSK
	JMP	IOERR
CHKDSK:	LHLD	UBUF		;INIT
	SHLD	DMAADD
	LHLD	ULEN		;CHECK FOR NO BYTES
	MOV	A,H
	ORA	L
	JZ	XDSK
CDA	DTRK		;TRACK BEFORE ADJUSTMENT
	MOV	E,A		;PUT INTO REG DE
	MVI	D,0
	LXI	H,0000H
	LDA	NUMSEC		;GET COUNTER
	MOV	B,A
MULT:	DAD	D
	DJNZ	MULT		;MULTIPLY LOOP
	XCHG			;REG DE=TRK*NUMSEC
	LHLD	UBLK		;SET UP FOR SUBTRACTION
	ANA	A		;RESET CARRY FLAG
	DSBC	DE		;SUBTRACT  HL-DE
	MOV	A,L		;REG L =SECTOR
	INR	A		;ADJUST FOR NO SECTOR 0
	STA	SECT		;SAVE SECTOR
	LDA	DTRK		;UPDATE TRACK COUNTER
	INR	A
	STA	DTRK
;------------------------------------------------
;    LOOP ON BYTES (IN ULEN)
;--------NTINUE
NEWTRK:	LDA	DTRK		;GET OLD TRACK
	INR	A		;ADD ONE
	STA	DTRK
	MOV	C,A
	CALL	SETTRK		;SEEK NEW TRACK
	MVI	A,1		;UPDATE SECTOR COUNTER
	STA	SECT
	JMP	NEW01
TRKERR:	MVI	A,4		;MUST BE BAD ERROR HERE
	STA	ERRFLG
	JMP	IOXIT
;
;
;******** STANDARD MAPPING ROUTINES ************
;
;------- START INITIALIZING FOR THE LOOP --------
DSK03:	LHLD	UBLK
	DAD	H
	DAD	H
	LXI	B,1AH
	CALL	DIVPOS
	PUSH	H
	PUSH	D
	MOV	A,E
	INR	A	
	STA	DTRK
	MOV	C,A
	CALL	SETTRK
	POP	D
	MVI	A,06H
	LXI	H,0000H
 POINTERS
	SDED	ULEN
	MOV	A,D	
	ORA	E		;CHECK IF DONE YET
	JZ	XDSK		;EXIT IF ULEN=0
;------ CALCULATE NEXT SECTOR -------
	LDA	DSCT
	ADI	02H
	CPI	1BH
	JC	DSK14
	SUI	1AH
DSK14:	LXI	H,DSCT0
	CMP	M
	JRNZ	DSK17
	INR	A
	RRC
	RAL
	JNC	DSK16
	ADI	04H
	CPI	1AH+1
	JC	DSK15
	SUI	1AH
DSK15:	PUSH	PSW
	LDA	DTRK
	INR	A
	STA	DTRK
	MOV	C,A
	CALL	SETTRK
	POP	PSW
DSK16:	STA	DSCT0
DSK17:	STA	DSCT
	STA	SECT
	JMP	DSK07
XDSK:	JMP	IOXIT
;  
;DIVPOS - DIVIDES 2 POSITIVE INTERGERS
;     ENTRY  BCAR
	RZ		;RETURN IF FF
LSTLP:	IN	LSTAT
	ANI	LMASK
	JRNZ	LSTLP
	MOV	A,C	;GET CHAR
	OUT	LDATA
	RET
;
;
	IF	ADM3A
;  ---------------------------------------------------------
;  ADM-3A DRIVER THIS CODE SIMULATES THE CLEAR TO END OF LINE
;  AND CLEAR TO END OF SCREEN FUNCTIONS FOR THE ADM-3A
;  ---------------------------------------------------------
;	CHARACTER EQUATES
;
NULL	EQU	0		; NULL
OTHER	EQU	0		; NULL CHARACTER
HOMCRT	EQU	30		; HOME CURSOR
RIGHT	EQU	12		; MOVE RIGHT 1 SPACE
LEFT	EQHK01:	LDA	SECLEN		;CHECK WHICH MAP TO USE
	ANI	03H		;LOOK AT ONLY 2 LSB'S
	CPI	02H
	JRZ	NEWMAP
	ORA	A		;CHECK IF ZERO
	JZ	DSK03
	JMP	IOERR		;FORMAT ERROR
;
;************ MAP FOR 512 BYTE SECTORS ************
;
NEWMAP:	LHLD	UBLK		;TRACK=BLOCK DIV NUMSEC
	LDA	NUMSEC		;GET NUMBER OF SECTORS/TRACK
	MOV	C,A		;AND PUT INTO REG BC
	MVI	B,0
	CALL	DIVPOS
	MOV	A,E		;REG E = TRACK
	STA	DTRK
	INR	A		;ADJUST FOR NO TRACK 0
	MOV	C,A
	CALL	SETTRK		;SEEK FIRST TRACK
; SECTOR = (BLOCK-TRACK*NUMSEC)+1
	L----------------------------------------
NEW01:	LDA	UREQ		;READ/WRITE
	ANI	OUTBIT		;LOOP ON BYTES IN ULEN
	JRZ	NEW02
	CALL	WRITE		;DO WRITE
	JR	NEW03
NEW02:	CALL	READ		;DO READ
NEW03:	SHLD	DMAADD		;SAVE COUNTERS AND POINTERS
	SDED	ULEN
	MOV	A,D		;CHECK FOR DONE
	ORA	E
	JZ	XDSK		;LEAVE IF DONE
;--- SECTOR MAP -----
	LXI	H,NUMSEC	;SETUP MEMORY POINTER
	LDA	SECT		;GET LAST SECTOR
	CMP	M		;END OF TRACK YET
	JRZ	NEWTRK		
	INR	A		;ADD ONE TO SECTOR
	STA	SECT		;NO,SAVE NEW SECTOR
	JMP	NEW01		;CODSK04:	DAD	D
	DCR	A
	JRNZ	DSK04
	LXI	B,1AH
	CALL	DIVPOS
	INX	H
	POP	D
	MOV	A,E
	CPI	0CH+1
	JC	DSK05
	INX	H
DSK05:	MOV	A,L
	STA	DSCT0
	ADD	E
	ADD	E
	DCR	A
DSK06:	SUI	1AH
	JNC	DSK06
	ADI	1AH+1
	STA	DSCT
	STA	SECT
;
;----------------------------------------------
;   LOOP ON BYTES (IN ULEN)
;----------------------------------------------
DSK07:	LDA	UREQ		;DO THE INPUT/OUTPUT NOW
	ANI	OUTBIT
	JRZ	DSK08
	CALL	WRITE
	JR	DSK09
DSK08:	CALL	READ
DSK09:	SHLD	DMAADD		;UPDATE COUNTERS AND=DIVISOR  HL=DIVIDEND
;     EXIT   BC=DIVISOR  HL=REMAINDER  DE=QUOTIENT
;
DIVPOS:	LXI	D,0000H
	MVI	A,01H
DIV01:	INR	A
	SLAR	C
	RALR	B
	JP	DIV01
DIV02:	STC
	RALR	E
	RALR	D
	DSBC	BC
	JNC	DIV03
	DAD	B
	DCX	D
DIV03:	SRLR	B
	RARR	C
	DCR	A
	JRNZ	DIV02
	RALR	C
	RALR	B
	RET
;
;---------- CHARACTER DRIVER PRIMATIVES -------------
;
;  DRIVER FOR CENTRONICS PRINTER  (HARDWARE STROBE)
; V-G "BIT STREAMER" WITH ADDED ONE SHOT FOR STROBE
;   CHARACTER IN REG C
LIST:	MOV	A,C
	CPI	0CH	;FF CHU	8		; MOVE LEFT 1 SPACE
UP	EQU	11		; MOVE UP 1 ROW
DOWN	EQU	10		; MOVE DOWN 1 ROW
CR	EQU	13		; CARRIAGE RETURN
EOLN	EQU	28		; CLEAR TO END OF LINE
EOSN	EQU	25		; CLEAR TO END OF SCREEN
ERASE	EQU	26		; ERASE SCREEN
SETXY	EQU	29		; SET X-Y CURSOR ADDRESS
TAB	EQU	9		; HORIZONTAL TAB
CTLF	EQU	6		; FLUSH CHARS TO SCREEN (TOGGLE)
CTLS	EQU	19		; FREEZE CRT (TOGGLE)

;
;	CODES FOR CURSOR ACTION CONTROL TABLE (TBL1)
;
DCOL	EQU	0		; COL = COL-1
ECOL	EQU	1		; COL = COL
ICOL	EQU	2		; COL = COL + 1
ZCOL	EQU	3		; COL = 0


;
;	CONSOLE CHARACTER INPUT ROUTINE
;
CIN:	XRA	A
	STA	FFLG		; RESET FLUSH FLAG
	JMP	CONIN		; GO TO CONSOLE INPUT



;
;	CONSOLE OUTPUT DRIVER FOR PASCAL SYSTEM
;
COUT:	PUSH	H		; SAVE ENVIRONMENT
	PUSH	D
	PUSH	B
	LDA	COL
	MOV	E,A		; E = CURRENT COLUMN ADDRESS
	LXI	H,XYFLG
	MOV	A,M
	ORA	A
	JRZ	COUT1		; JUMP IF NOT PROCESSING X-Y CURSOR
	DCR	M
	JRNZ	DOROW		; ROW ADDRESS
	MOV	A,C		; GET NEW COL POSITION
	SUI	32		; REMOVE ASCII BIAS
	MOV	E,A		; UPDATE COL POSITIO
	XRA	A
	MOV	E,A
YC1:	ADD	E		; ADD IN COLUMN OFFSET
	MOV	E,A
	LXI	H,TBL2
	DAD	B
	DAD	B
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A		; H/L = ADR OF PROCESSING ROUTINE FOR CHARACTER
	POP	B		; CHAR RESTORED TO C REG
	PCHL			; BYE
;
;	PROCESS X-Y CURSOR POSITIONING REQUEST
;
GOXY:	LXI	H,XYFLG
	MVI	M,2		; COUNT FOR X, Y ADR BYTES
	MVI	C,1BH		; ESCAPE
	CALL	CONOUT
	MVI	C,'='		; ESCAPE EQUALS SEQUENCE LOADS CURSOR
	JR	PUT
;
;	PROCESS TAB EXPANSION TO BLANKS
;
TABOUT:	MVI	C,RIGHT
XT0:	CALL	CONOUT
	SITION FROM REG E
;
EXIT0:	MOV	A,E
	ORA	A		;CHECK IF MOVED TO HIGHER LINE
	JP	YE0
	XRA	A		;FORM CURSOR ADDR 0..79
YE0:	CPI	80		;CHECK IF MOVED TO LOWER LINE
	JRC	XE1
	MVI	A,79		; NO AUTO LINE FEED
XE1:	STA	COL		; SAVE COL ADDRESS
;
;	RESTORE REGISTERS AND EXIT
;
EXIT1:	POP	B
	POP	D
	POP	H
	MOV	A,C
	RET
;
;
RESET:	CALL	CLRLN		; CALL CLEAR TO END OF LINE
	JR	EXIT0
;
CLRLN:	MVI	C,' '		; SPACE TO CLEAR END OF LINE
	MVI	A,80		; COL LIMIT
	SUB	E
	JRZ	XR1		; CONTINUE IF COL 80
	MOV	B,A		
	JZ	EXIT0		; EXIT IF ALREADY ON LAST ROW
	MOV	B,A		; COUNT OF ROWS TO CLEAR
	MVI	C,0DH		; CARRIAGE RET
	CALL	CONOUT		; PRINT IT
	MOV	C,E		; SAVE COL INDEX IN C
	MVI	E,0		; SET COL TO ZERO
CLRS2:	PUSH	B		; SAVE INDICES
	MVI	C,0AH		; LINE FEED
	CALL	CONOUT
	CALL	CLRLN		; CLEAR THE LINE
	POP	B		; RESTORE INDICES
	DJNZ	CLRS2		; LOOP TILL B IS ZERO
	MOV	E,C		; RESTORE COL INDEX
	MVI	C,1BH		; ESCAPE
	CALL	CONOUT
	MVI	C,'='		; EQUALS
	CALL	CONOUT
	LDA	ROW
	MOV	C,A
	CALL	CONOUT		; PRINT ROW
	MOB	SETXY		; SET CURSOR ADDRESS
CTBLND:	DB	TAB		; MOVE TO NEXT TAB STOP
CTBLSZ	EQU	$-CHRTBL	; NUMBER OF ENTRIES IN TABLE
;
;	CURSOR MOTION AND LEAD IN TABLE
;
TBL1:	DB	ICOL		; NOTHING SPECIAL
	DB	ECOL		; NULL
	DB	ZCOL		; HOME
	DB	ICOL		; RIGHT
	DB	DCOL		; LEFT
	DB	ECOL		; UP
	DB	ECOL		; DOWN
	DB	ZCOL		; CR
	DB	ECOL		; EOLN
	DB	ECOL		; EOSN
	DB	ZCOL		; ERASE
	DB	ECOL		; SET X-Y ADDRESS
	DB	ECOL		; TAB (PROCESSING ROUTINE HANDLES COLUMN)
;
;	CHARACTER DISPATCH TABLE
;
TBL2:	DW	PUT		; NON-SN
DOXY:	CALL	CONOUT		; POSITION CURSOR
	JR	EXIT0
DOROW:	MOV	A,C		; ROW INDEX
	SUI	32		; ASCII BIAS
	CPI	24		; LIMIT
	JM	DOROW1		; DO NOT ALLOW SCREEN WRAP AROUND
	MVI	C,'7'		; ROW 23
	MVI	A,23
DOROW1:	STA	ROW		; SAVE ROW INDEX
	JR	DOXY
;
COUT1:	PUSH	B		; SAVE CHARACTER
	MOV	A,C
	LXI	H,CTBLND
	LXI	B,CTBLSZ
	CCDR			; SEARCH CHARACTER TABLE
	LXI	H,TBL1
	DAD	B		; H/L =ADR IN CHARACTER ACTION TABLE
	MOV	A,M		; A = ACTION BYTE
	ANI	3
	DCR	A
	CPI	ZCOL-1		; ZERO COLUMN IF NECESSARY
	JRNZ	YC1
INR	E		; INCREMENT COL, STOP AT NEXT TAB STOP
	MOV	A,E
	ANI	7
	JRNZ	XT0
	JR	EXIT0
;
;	OUTPUT CHAR IN C WITH ROW PROCESSING
;
PUTH:	XRA	A		; ZERO
	JR	PUTLF1		; ROW ZERO FOR HOME
PUTRLF:	LDA	ROW
	DCR	A		; DECR ROW INDEX
	JP	PUTRLF1
	XRA	A		; SET ROW TO ZERO IF PAST TOP OF SCREEN
PUTRLF1:JR	PUTLF1
PUTLF:	LDA	ROW
	INR	A		; INCR ROW INDEX
	CPI	24		; MAX ROW IS 23
	JM	PUTLF1
	MVI	A,23
PUTLF1:	STA	ROW		; SAVE ROW INDEX
;
;	OUTPUT CHAR IN REG C
;
PUT:	CALL	CONOUT
;
;	TEST AND UPDATE COL PO; SPACE COUNT TO B
XR0:	CALL	CONOUT		; PRINT A SPACE
	DJNZ	XR0		; LOOP TILL END OF LINE
XR1:	MVI	C,0DH
	CALL	CONOUT		; REPOSITION CURSOR ON ORIGINAL LINE
	MVI	C,RIGHT		; FORWARD SPACE
	MOV	B,E		; COL POSITION TO B
	MOV	A,B
	ORA	A
	RZ			; EXIT IF AT COL 0
XR2:	CALL	CONOUT
	DJNZ	XR2		; FORWARD SPACE TILL BACK TO ORIG POSITION
	RET
;
;	CLEAR TO END OF SCREEN 
;
CLRS:	CALL	CLRLN		; CLEAR TO END OF FIRST LINE
	LXI	H,ROW		; POINT TO ROW INDEX
	MVI	A,23		; ROW LIMIT
	SUB	M		; SUBTRACT ROW INDEX
V	A,E		; COL INDEX
	ADI	32		; ASCII BIAS
	MOV	C,A
	CALL	CONOUT		; PRINT COL
	JMP	EXIT0
;
;	SPECIAL CHARACTER TABLE
;
CHRTBL:	DB	OTHER		; NON-SPECIAL CHARACTER
	DB	NULL		; NULL CHARACTER
	DB	HOMCRT		; HOME CURSOR
	DB	RIGHT		; MOVE CURSOR RIGHT 1 SPACE
	DB	LEFT		; MOVE CURSOR LEFT 1 SPACE
	DB	UP		; MOVE CURSOR UP 1 SPACE
	DB	DOWN		; MOVE CURSOR DOWN 1 SPACE
	DB	CR		; CARRIAGE RETURN
	DB	EOLN		; ERASE TO END OF LINE
	DB	EOSN		; ERASE TO END OF SCREEN
	DB	ERASE		; ERASE SCREEN, HOME CURSOR
	DPECIAL CHARACTER
	DW	PUT		; NULL
	DW	PUTH		; HOME
	DW	PUT		; RIGHT
	DW	PUT		; LEFT
	DW	PUTRLF		; UP
	DW	PUTLF		; DOWN
	DW	PUT		; CR
	DW	RESET		; EOLN
	DW	CLRS		; EOSN
	DW	PUTH		; ERASE
	DW	GOXY		; SET X-Y ADDRESS
	DW	TABOUT		; TAB
;
;	STORAGE LOCATIONS
;
COL:	DB	0		; CURRENT COLUMN
ROW:	DB	0		; CURRENT ROW
FFLG:	DB	0		; FLUSH FLAG
XYFLG:	DB	0		; X-Y FLAG (INITIALLY RESET)
ATOGL:	DB	20H		; UPPER-LOWER CASE TOGGLE ON ^A
PFLG:	DB	0		; PRINT (ECHO) FLAG

CONST:	IN	3
	ANI	2
	RZ
	MVI	A,0FFH
	RET

CONIN:	IN	3
	ANI	2
	JRZ	CONIN
	IN	2
	ANI	7FH	; REMOVE PARITY BIT
	CPI	1	; CONTROL A
	JRNZ	CONIN4
	LDA	ATOGL	; TOGGLE LOWER CASE SWITCH
	XRI	20H
	STA	ATOGL
	MVI	A,1	; RETURN A CONTROL A
	RET
CONIN4:	MOV	C,A	; SAVE CHAR IN C
	CPI	61H	; LOWER CASE A
	JM	CONIN6	; EXIT IF < A
	CPI	7BH	; LOWER CASE Z + 1
	JP	CONIN6	; EXIT IF > Z
	LDA	ATOGL	; LOAD LOWER CASE SWITCH
	XRA	C	; EXCLUSIVE OR WITH CHAR
	RET
CONIN6:	MOV	A,C	; RESTORE CHAR TO A
	RET

CONOUT:	IN	3
	ANI	1
	JRZ	CONOUT
	A	UNIT
	CPI	06H
	JRZ	LIST
	MOV	A,C
	CPI	CR	;IS IT A CR
	JRZ	CURET	;YES,THEN CHECK IF TO FREEZE VIDEO
CHOUT:	IN	TSTAT	; GIVE CHAR TO TERMINAL
	ANI	OMSK01
	JRZ	CHOUT	;WAIT FOR 8251
	MOV	A,C	;GET CHAR
	OUT	PORT01
	RET
;
; CARRAGE RETURN- CHECK IF CRT IS TO BE STOPPED - CTRL S
;
CURET:	IN	TSTAT
	ANI	IMSK01
	JRZ	CHOUT
	IN	PORT01
	ANI	7FH
	CPI	CTRLS
	JRNZ	CHOUT
CRLOOP	CALL	CIN
	CPI	CTRLS
	JRZ	CHOUT
	JR	CRLOOP
	ENDIF
;
;************************************************************
;
;  ERRORS,SET ERROR FLAG
;
IOERR:	MVI	A,4		;DISK ERROR FLAG
	STA	ERRFLG		;PUT IN FLAG
	RET
;
	IF	PERSCI		;DON'T UPDATE TRACK POSITION, SAME FOR ALL
SELMOR:	MOV	A,C		;NEW DRIVE NO
	STA	DSKDR		;SAVE IT
	CALL	INDEX		;POINT TO DRIVE PARAMETERS
	ELSE
SELMOR:	LDA	DSKDR		;UP DATE TRACK TABLE
	CALL	INDEX		;FIND TABLE ENTRY FOR DRIVE PARAMETERS
	IN	TRACK
	MOV	M,A		;SAVE IT IN TABLE
	MOV	A,C		;GET NEW DRIVE
	STA	DSKDR		;SAVE IN DISKDR
	CALL	INDEX		;FIND PARAMETERS FOR NEW DRIVE
	MOV	A,M		;GET LAST TRA	CALL	SELECT
	ENDIF
;
	CALL	TIME		;ALLOW STEPPER SETTLE TIME
	CALL	IDREAD
	LDA	IDTAB3		;SECTOR LENGTH CODE FROM ADDR FIELD
	STA	SECLEN
	MVI	A,8		;512 BYTE SECTORS SINGLE DENSITY
	STA	NUMSEC		;SET IT
	RET
;
;
;  INDEX PUTS ADDR OF START OF DISK DRIVE PARAMETER BLOCK IN HL
;  INDEX IS CALLED WITH THE DRIVE NUMBER IN A
;
INDEX:	LXI	H,TRKTBL
	MOV	E,A		;SAVE A COPY OF REG A
	ADD	A		;FIGURE OFFSET INTO TABLE
	ADD	E
	MOV	E,A		;ADD OFFSET TO BASE
	MVI	D,00
	DAD	D
	RET
;
;  SELECT WILL SELECTNSITY BIT
	ORA	A		;CHECK FOR ZERO (SINGLE DENSITY)
	RZ
	MVI	A,2		;IF NOT SET SECLEN AND NUMSEC
	STA	SECLEN
	MVI	A,16
	STA	NUMSEC		;16 SECTORS PER TRACK DOUBLE DENSITY
	RET
	ENDIF
;
	IF	NOT DELTA AND NOT TARBELL	;(1771)
SELECT:	MOV	A,C		;GET DRIVE NO
	CMA			;COMPLIMENT IT
	ADD	A
	ADD	A
	ADD	A
	ADD	A		;SHIFT LEFT FOUR
	ORI	02H
	STA	LATCH		;SAVE IN LATCH
	OUT	DCONT		;ISSUE COMMAND
	RET
	ENDIF
;
;  DENSEL SELECTS DENSITY, CODE IN (HL) 1=DOUBLE DENSITY 2=SINGLE DENSITY
;
	IF	DELTA
DENSEMOV	A,C	; GET OUTPUT CHAR
	OUT	2
	RET
	ENDIF
;
	IF	SOROC
; ************************************************************
;
; SOROC AND OTHER TERMINALS NOT REQUIRING COMPLEX SOFTWARE 
; DRIVERS USE THIS CODE
;
; *************************************************************
;
;   ---- READ A CHARACTER FROM KEYBOARD ----
CIN:	IN	TSTAT	;READ STATUS
	ANI	IMSK01
	JRZ	CIN
	IN	PORT01	;GET CHAR
	ANI	7FH	;REMOVE BIT 7
	RET
; 
;   ----- WRITE CHARACTER IN REG C TO SOROC TERMINAL  -----
;
COUT:	LD  DISK DRIVERS     TARBELL AND DELTA CONTROLLERS
;
;************************************************************
;
;   ----- SELECT DISK ,NUMBER IN REG. C -----
;
SELDSK:	MOV	A,C		;GET NEW DISK NUMBER.
	ANI	3		;ONLY LOOK AT 2 LSBS
	MOV	C,A
	LDA	DSKDR		;CURRENTLY SELECTED DRIVE
	CMP	C		;COMPARE WITH NEW DRIVE
	RZ			;IF SAME, RETURN.
	LDA	NUMDSK		;NUMBER OF DRIVES ON LINE
	DCR	A		;SUBTRACT 1 TO GET MAXIMUM DR CODE
	CMP	C		;NEWDRIVE > NUMDISKS ?
	JP	SELMOR
;
;IO ERROR EXIT FOR UNRECOVERABLE IOCK POSITION
	OUT	TRACK		;UPDATE 1791 TRACK REGISTER
	ENDIF
;
	IF	DELTA		;(1791)
	INX	H		;POINT TO DENSITY
	CALL	SELECT		;DRIVE NO IS IN C
	CALL	DENSEL		;SELECT IT AND SET SECLEN
	MOV	A,M		;GET DENSITY CODE 
	CPI	1		;IS IT DOUBLE
	RZ			;RETURN IF DOUBLE
	ENDIF
;
	IF	TARBELL		;(1791)
	INX	H		;POINT TO DENSITY
	CALL	SELECT		;SELECT BOTH DRIVE AND DENSITY FOR TARBELL
	ORA	A		;A CONTAINS A ZERO IF SINGLE DENSITY
	RNZ			;RETURN IF DOUBLE DENSITY
	ENDIF
;
	IF	NOT DELTA AND NOT TARBELL	;(1771)
 THE DISK IN C FOR APPROPRIATE CONTROLLER
;
	IF	DELTA		;(1791)
SELECT:	MOV	A,C		;DRIVE NO TO A
	CMA			;COMPLIMENT IT
	OUT	DCONT		;ISSUE COMMAND
	RET
	ENDIF
;
	IF	TARBELL		;(1791)
SELECT:	MOV	A,M		;PICK UP DENSITY CODE
	ADD	A
	ADD	A
	ADD	A		;SHIFT LEFT 3 BITS
	ANI	8		;MASK OFF TARBELL DD BIT
	MOV	B,A		;SAVE IN B FOR LATER
	MOV	A,C		;GET DRIVE NUMBER
	ADD	A
	ADD	A
	ADD	A
	ADD	A		;SHIFT LEFT 4
	ORA	B		;ADD IN THE SINGLE/DOUBLE DENSITY BIT
	OUT	DCONT		;ISSUE COMMAND
	MOV	A,B		;GET BACK DEL:	MOV	A,M		;GET THE DENSITY CODE
DENSEL1:OUT	WAIT+1		;SENT CODE TO DENSITY PORT
	CPI	2		;IS IT SINGLE DENSITY
	RZ			;IF SO RETURN
	MVI	A,2		;IF NOT SET SECLEN AND NUMSEC
	STA	SECLEN
	MVI	A,16
	STA	NUMSEC		;16 SECTORS PER TRACK DOUBLE DENSITY
	RET
	ENDIF
;
;
;READ  READ THE SECTOR IN (SECT),FROM PRESENT TRACK
;USE STARTING ADDRESS IN (DMAADD).
;
READ:	MVI	A,RTCNT
RRETRY:	STA	ERCNT	;STORE IN ERROR CTR.
	MVI	A,0D0H
	OUT	DCOM	;INTERRUPT CONTROLLER
	LXI	H,RDDONE
	PUSH	H	;SET UP RETURN ADDR
	LHLD	DMAADD	;GET STARTING ADR.
	LDED	ULEN	;BYTES TO DO
	MVI	C,DDATA	;DISK DATA PORT
	XTHL
	XTHL		;SHORT DELAY
	IN	DSTAT	;READ STATUS.
	ANI	20H	;LOOK AT HLD BIT.
	LDA	SECT	;GET SECTOR NUMBER.
	OUT	SECTP	;SET SECTOR INTO 1771.
	MVI	A,8CH	;READ WITH HEAD LOAD
	JRZ	READE	;HEAD NOT LOADED.
	MVI	A,88H	;CODE FOR READ W/O HD LD.
READE:	OUT	DCOM	;SEND COMMAND TO 1771.
RLOOP:	IN	WAIT	;WAIT FOR DRQ OR INTRQ.
	ORA	A		;SET FLAGS.
	RP		;DONE IF INTRQ.
	INI		;READ FROM DISK INTO (HL)
	DCX	D	;DECREASE BYTT SEEK ERROR
	CALL	IDREAD	;READ TRACK ADDRESS
	LDA	IDTAB
	MOV	C,A	;SAVE TRACK
	IN	TRACK	;CHECK 1771 TRACK REG
	CMP	C	;IF SAME,NO ERROR
	RZ
	MOV	A,C	;PUT CORRECT TRACK IN 1771
	OUT	TRACK
	LDA	TRK	;GET TRACK WANTED
	MOV	C,A
	CALL	SEEK	;AND GO TO IT
	RET
;
;WRITE  WRITE THE SECTOR IN (SECT),FROM PRESENT TRACK
;USE STARTING ADDRESS IN (DMAADD)
;
WRITE:	MVI	A,RTCNT
WRETRY:	STA	ERCNT	;STORE IN ERROR COUNTER.
	MVI	A,0D0H	;CAUSE INTERUPT
	OUT	DCOM
	LXI	H,WDONE
	PUSH	H	;SET UP RETURN ADDR
	LHLOUNTER
	MOV	A,D	;AND CHECK FOR 0
	ORA	E
	JNZ	WLOOP	;KEEP WRITING.
	POP	B	;FIX UP STACK
WRT02:	CALL	BUSY
	ANI	18H	;DONT LOOK AT LOST DATA BIT
	JRNZ	PROCER
	RET
WDONE:	IN	DSTAT	;READ DISK STATUS.
	ANI	0FDH	;LOOK AT THESE BITS.
	RZ		;RETURN IF NO ERRORS
PROCER:	CALL	ERCHK	;CHECK/CORRECT SEEK ERROR
	LDA	ERCNT	;GET ERROR COUNT.
	DCR	A	;DECREMENT COUNT.
	JNZ	WRETRY	;TRY TO WRITE AGAIN.
	JMP	IOERR	;WRITE DISK ERROR
;
;HOME  MOVES HEAD TO TRACK ZERO.USES RESTORE COMMAND,NO HDL
;
HOME:	MVI	A,0D0HA	TRK		;DO UPDATING WHILE WAITING FOR 1791
	CALL	BUSY		;WAIT UNTIL 1791 NOT BUSY
	MVI	A,18H+STEP
	OUT	DCOM		;SEEK COMMAND,NO VERIFY,WITH HDL
	IN	WAIT
	RET
	ENDIF
;
	IF	PERSCI
SEEK:	MVI	A,48H+STEP	;STEP IN WITH HEAD LOAD
	JC	SDIR		;STEP IN IF MINUS
	MVI	A,68H+STEP	;STEP OUT WITH HEAD LOAD
SDIR:	OUT	DCOM		;ISSUE STEP COMMAND
	MVI	A,20
DLOOP:	DCR	A		;SHORT DELAY LOOP
	JNZ	DLOOP
	MOV	A,B		;GET PRESENT TRACK
	SUB	C		;CALC REQUIRED NUMBER OF STEPS
	JP	STEP0		;CHECK PLUS OR MINUS
	CMA			;COMPLIMLATCH CODE
	RET
	ENDIF
;
;BUSY  CHECKS 1791 FOR BUSY,RETURNS WHEN NOT BUSY
;
BUSY:	MVI	A,6		;ALLOW 12 MICRO SEC SETTLE TIME
BUSY1:	DCR	A
	JNZ	BUSY1
BUSY2:	IN	DSTAT		;GET 1791 STATUS
	RRC			;CHECK BIT 0
	JC	BUSY2		;not done, continue
	RAL			;PUT BITS BACK
	RET
;
; DELAY LOOP,APPROX 1.8 MILL/SEC  ALLOW TIME FOR DRIVE TO SETTLE
;
TIME:	LXI	B,2000H
DEL:	DCX	B
	MOV	A,B
	ORA	C
	JRNZ	DEL
	RET
;
;
;ID READ  READS THE ID FIELD ON CURRENT TRACK,AND PUTS DATA
;INTO IDTAB. USED TO DETERMINE SEE COUNTER
	MOV	A,D	;AND CHECK FOR 0
	ORA	E
	JNZ	RLOOP	;KEEP READING
	POP	B	;FIX UP STACK
RDLP02:	CALL	BUSY
	ANI	18H
	JRNZ	CHECK
	RET
RDDONE:	IN	DSTAT	;READ DISK STATUS
	ANI	9DH	;LOOK AT ERROR BITS.
	RZ		;RETURN IF NONE.
CHECK:	CALL	ERCHK	;CHECK FOR SEEK ERROR.
	LDA	ERCNT	;GET ERROR COUNT.
	DCR	A	;DECREMENT COUNT.
	JRNZ	RRETRY	;TRY TO READ AGAIN.
	JMP	IOERR	;READ DISK ERROR
;
;ERROR CHECK  CHECK FOR RECORD NOT FOUND ERROR,AND SEEK TO
;CORRECT TRACK IF REQUIRED.
;
ERCHK:	ANI	10H
	RZ		;NOD	DMAADD	;GET STARTING ADR
	LDED	ULEN	;BYTES TO DO
	MVI	C,DDATA	;DISK DATA PORT
	XTHL
	XTHL		;SHORT DELAY
	IN	DSTAT	;GET 1771 STATUS.
	ANI	20H	;CHECK FOR HEAD LOAD.
	LDA	SECT	;GET SECTOR NUMBER.
WRITE1:	OUT	SECTP	;SET THE SECTOR INTO 1771.
	MVI	A,0ACH	;SET UP 1771 FOR WRITE.
	JRZ	WRITE2	;HEAD IS NOT LOADED
	MVI	A,0A8H	;CODE FOR WRITE W/O HD LD.
WRITE2:	OUT	DCOM
WLOOP:	IN	WAIT	;WAIT FOR READY.
	ORA	A	;SET FLAGS.
	RP		;HOP OUT WHEN DONE.
	OUTI		;WRITE TO DISK FROM (HL)
	DCX	D	;DECREASE BYTE C		;CAUSE INTERUPT
	OUT	DCOM	
	CALL	BUSY
	MVI	A,01H		;RESTORE,NO HDL,NO VERIFY
	OUT	DCOM
	CALL	BUSY
	IN	DSTAT
	ANI	04H		;MAKE SURE IT'S HOMED
	JRZ	HOME
	RET
;
;
;SET TRACK  CHECK IF TRACK IN REG C IS EQUAL TO PRESENT
;TRACK,AND MOVE TO NEW TRACK IF NOT.
;CALLABLE ROUTINES:
;SEEK:MOVES HEAD TO TRACK IN REG A
;
SETTRK:	IN	TRACK
	MOV	B,A		;SAVE PRESENT TRACK IN B
	CMP	C		;COMPARE WITH NEW TRACK
	RZ			;GO BACK IF SAME
;
	IF	NOT PERSCI
	MOV	A,C		;MOVE TRACK TO SEEK TO 
SEEK:	OUT	DDATA
	STENT IF MINUS
	INR	A		;TWO'S COMP
STEP0:	MOV	B,A		;STEPS TO B
	MVI	A,1		;PERSCI STEP COMMAND
STEP1:	OUT	DCONT		;ISSUE PERSCI STEP
	DCR	B		;COUNT DOWN NO OF STEPS
	JNZ	STEP1		;LOOP TILL STEPS DOWN TO ZERO
	IN	WAIT		;CLEAR 1791
	IN	DSTAT		;READ STATUS
	MOV	A,C		;GET DESTINATION TRACK
	OUT	TRACK		;UPDATE TRACK REGISTER
	LDA	LATCH		;SELECT LATCH CODE
	ANI	72H		;MAKE SEEK COMPLETE COMMAND
	OUT	DCONT		;ISSUE IT
	IN	WAIT		;WAIT TILL SEEK COMPLETE
	LDA	LATCH		;GET BACK LATCH
	OUT	DCONT		;RESTORE OLD CTOR LENGTH,AND CURRENT TRACK
;
IDREAD:	IN	TRACK
	ORA	A		;MAY HAVE DIFFERENT FORMAT
	JRNZ	IDRD00
	INR	A		;MOVE TO TRACK 1
	CALL	SEEK
IDRD00:	MVI	A,RTCNT
IDRD01:	STA	IDECNT
	MVI	A,0D0H
	OUT	DCOM
	LXI	H,IDTAB
	CALL	BUSY
	MVI	A,0C4H		;READ ADDRESS COMMAND
	OUT	DCOM
IDRD02:	IN	WAIT		;WAIT FOR DATA OR INTER
	ORA	A
	JP	IDRD03
	IN	DDATA
	MOV	M,A		;PUT BYTE IN TO TABLE
	INX	H
	JMP	IDRD02
IDRD03:	IN	DSTAT
	ANI	08H
	RZ
	LDA	IDECNT
	DCR	A
	JRNZ	IDRD01		;TRY AGAIN
	JMP	IOERR		;ID READ ERROR


IDECNT:	DB	0		;RETRY COUNTER
IDTAB:	DB	0
IDTAB1:	DB	0		;ZERO
IDTAB2:	DB	0		;SECTOR ADDRESS
IDTAB3:	DB	0
IDTAB4:	DB	0		;CRC
IDTAB5:	DB	0		;CRC
;
         END
;DISK UTILITY -	By Ward Christensen
;DU.ASM	V3.0	EDIT 10
;
;	8/6/78
;ORIGINALLY WRITTEN TO RECONSTRUCT BLOWN
;DISKS ON CBBS VIA REMOTE ACCESS
;
;		----------------
;Sorry for the lack of comments in the code 
;portion of this program - it was just hacked
;together to satisfy my needs, but lots of
;other people found it useful.  Its external
;documentation is good, but its sadly lacking
;comments on the instructions.
;		----------------
;
;	11/12/78 WLC
;ADD LOGIN COMMAND
;
;	11/26/78 WLC
 G0;D;G2;=OK<D><A><1A>;D
;
;Functions supported:
;
;	Tnn	Seek to track nn (no read)
;	Snn	Position to sector nn, and read
;	Gnn	Position to group nn and read.
;	G	Shows current position
;	V	Views the current sector.
;		(assumes ASCII data)
;	Vnn	Views nn sectors
;	Fname	print directory for file "name",
;		then positions to it's directory 
;		sector.
;
;	=string	Ascii search, starting at current
;		sector.  <xx> hex may be imbedded,
;		or used alone:  To find "IN 0FEH":
;		=<db><fe>
;
;	Lddress:
;	D0,7F  is the same as just D
;	D3,5
;	A20,3F
;
;	CHaddr,val,val,val... change hex in sector
;	CAaddr,char string... change ASCII in sector
;		NOTE that <xx> may be hex imbedded
;		in the Ascii:  ca0,OK<d><a><1a>
;
;		----> Use W to write changes to disk.
;		Note that the C command echoes
;		the overlaid data for verification.
;
;	CHaddr-addr,byte
; or	CAaddr-addr,byte	repeats a change
;
;	#	(Used by Ward to set the sector
;		order table to 1,2,3,4,5...
;		for my strange disks)
positioned to
;		into memory.  Note R (Read) is implicit in
;		the G, +, and - commands, but N-O-T in the
;		S and T commands (I did it because I was
;		tired of disk reading after T command before
;		I had a chance to issue the S command)
;
;	W	Write back the current sector (N-O-T-E may
;		not be used after an F command, as CP/M was
;		used to find the file in the directory
;
;	X	Exit back to CP/M (Must press return).  Ctl-c
;		was too easy to hit over modem lines, so I
;		decided on 2-byte (X
;ADD DISK # TO LOGIN COMMAND
;
;	02/25/79 WLC
;PUT SECTOR READ INTO "S" COMMAND
;
;	10/10/79 WLC
;SAVE REGS IN BIOS CALLS
;TRANSLATE INPUT TO UPPER CASE
;ADD COMMANDS: 	< SAVE SECTOR
;		> RESTORE SECT
;		/ REPEAT
;ALLOW CHANGE FROM-THRU
;
;	01/06/80 WLC
;REWRITE "F" COMMAND
;
;	01/07/79
;ADD VIEW COMMAND
;
;	01/08/80
;REPOSITION AFTER "M" COMMAND
;
CR	EQU	0DH
LF	EQU	0AH
TAB	EQU	09H
;
;Any valid command string may be placed as an
;operand of the original DU command, i.e.:
;
;	DU	Re-logs in the current disk. You may pull
;		out a disk, put in a new, and "L" just
;		to log it in (prevents 	CP/M 1.4
;		from getting R/O errors). (hmmm, on second
;		thought, I'm not doing any BDOS calls
;		anyway, so no R/O errors COULD occur..
;		owell, better safe than sorry)
;
;	Lx	Logs in disk 'x', such as: LB
;
;	D	Dump sector, hex + ASCII
;	A	Dump sector, ASCII only
;	H	Dump sector, hex only
;
;note all dump commands (D, A, H) may be optionally
;	followed by a starting and ending a;
;	+	advance 1 sector (if below track 2,
;		this advances to next numerical, if
;		2 or >, advances based on CP/M's normal
;		sector scrambling algorithm, i.e. so +
;		will get the next logical sector of the file
;
;	-	backs up 1 logical sector
;
;		note + and - may take an amount:
;		for example, +F steps in 15 sectors
;
;	?	Gives command summary
;
;	M	Dumps a map of the group allocations
;		for files.
;	Mn	Shows which file is allocated to
;		group "n".
;
;	R	Reads the sector currently , CR) to exit.
;
;	P	Toggle printer switch on/off
;
;	Z	Sleep - causes the program to pause, such
;		as to look at a dump.  Z is 1 sec.  Znn
;		is nn tenths of a second on a 2 MHz 8080.
;
;	<	Saves current sector in a save buffer
;
;	>	Gets saved buffer.  < and > may be used
;		to move a sector to another place.
;
;	/	Repeats entire command.  Defaults
; or	/nn	to "forever".  NN may be 2 to 254
;
;multiple commands may be separated by ";"
;
;Example: the following commands will erase the
;	b disk directory to all E5's:
;
;	lb			log in b drive
;	g0			position to dir.
;	ch0-7f,e5		fill with e5
;	<			save the sector
;	>;w;+;/16		restore, write, next,
;				repeat 16       
;
;----This could be shortened to:
;
;	lb;g0;ch0-7f,e5;<
;	>;w;+;/16
;
	ORG	100H
	LXI	SP,STACK ;EXITS VIA JMP 0
;SET UP LOCAL JMPS TO BIOS
	LHLD	1	;WARM BOOT POINTER
	LXI	D,3
	DAD	D	
	SHLD	VCONST+1
	DAD	D
	SHLD	VCONIN+1
	DAD	D
	SHLD	VCONOUT+1
	DAD	D	;LIST
	SHLD	VLIST+1
	DAD	D	;PUNCH
	DAD	D	;RDR
	DA
	STAX	D
	LXI	H,INBUF
	JMP	PROMPTI
;
PROMPTR	CALL	RDBUF
PROMPTI	MVI	A,255
	STA	TOGO	;LOOP COUNT FOR "/"
PROMPT	LXI	SP,STACK
	XRA	A	;ZERO 2-UP PRINT
	STA	TWOUP	;..SWITCH
	MVI	A,1
	STA	FTSW	;TELL SEARCH NOT TO INCR
	PUSH	H
	LXI	H,100H
	SHLD	BUFAD	;FOR RDBYTE
	POP	H
	CALL	CTLCS	;ABORT?
	JZ	PROMPTR	;..YES, READ BUFFER
;DO WE HAVE TO POSITION IN DIRECTORY AFTER FIND?
	LDA	FINDFLG
	ORA	A
	JNZ	POSDIR	;POSITION IN DIRECTORY
	MOV	A,M
	CPI	CR
	JZ	PROMPTR
	CPI	';'	;LOGICAL CR?
	INX	H
	JZ	PRX'	! JZ 0
	CPI	'Z'	! JZ SLEEP
	CPI	'/'	! JZ REPEAT
;
WHAT	CALL	ILPRT
	DB	'?',0
	JMP	PROMPTR
;
;REPEAT BUFFER CONTENTS
;
REPEAT	CALL	DECIN	;NN SPECIFIED?
	MOV	A,E
	ORA	A
	JZ	NNN	;NO.
	LDA	TOGO	;FIRST TIME?
	CPI	0FFH	;WAS IT 0FFH?
	JNZ	NNN	;NO:  COUNTING
	MOV	A,E	;GET COUNT
	STA	TOGO	;SET COUNT
NNN	LXI	H,INBUF	;READY TO REPEAT
	LDA	TOGO
	CPI	0FFH
	JZ	PROMPT	;CONTINUOUS
	DCR	A	;COUNT DOWN
	STA	TOGO
	JNZ	PROMPT
	JMP	PROMPTR	;RESET
;
;TOGGLE PRINT FLAG
;
PRINTFF	LDA	PFLAG
	XRI	1
	
	PUSH	H
	CALL	BDOS
	POP	H
	MOV	A,M	;DISK REQ?
	LXI	D,0
	CPI	CR
	JZ	LGNODK
	CPI	';'
	JZ	LGNODK
	CALL	UPCASE
	INX	H
	SUI	'A'
	MOV	E,A
LGNODK	MVI	C,SELDK
	PUSH	H
	CALL	BDOS
	POP	H
	CALL	NOWRITE
	JMP	PROMPT
;
;READ IN THE DISK DIRECTORY
;
READDIR	PUSH	H
	CALL	NOWRITE	;POSITIONING LOST
	MVI	A,2
	STA	CURTRK
	MVI	A,1
	STA	CURSEC
	MVI	B,16	;# OF SECTORS
	LXI	D,DIRECT ;DMA ADDR
RDIRLP	PUSH	B
	PUSH	D
	MOV	B,D
	MOV	C,E
	CALL	VSETDMA
	LDA	CURTRK
	CALL	SETTRK
	LDA	CURSEC
	CALL	SETS
	CALL	CTLCS
	JZ	MAPEND2
	MOV	A,D
	CMP	H
	JNZ	MAPDIFF
	MOV	A,E
	CMP	L
	JNZ	MAPDIFF
;SAME, CONTINUE
	JMP	MAPCONT
;
;DIFFERENT FILE ENCOUNTERED
;
MAPDIFF	MOV	A,C
	DCR	A
	CALL	HEX
	XCHG
	CALL	MAPNAME
	JMP	MAPDF
;
;END
;
MAPEND	MOV	A,C	;GET LAST
	DCR	A
	CALL	HEX
	CALL	MAPNAME
	POP	H
	CALL	CRLF
;
;END OF MAP - REPOSITION TO PREVIOUS GROUP
;
MAPEND2	LDA	GROUP
	PUSH	H
	MOV	L,A
	JMP	POSGRP2
;
;PRINT FILE NAME POINTED TO BY HL
;
MAPNAME	CALL	SPACE
	MOV	A,H
	ORA	L	;NONE?
	JZ	D	D
	SHLD	VHOME+1
	DAD	D	;SEL DISK
	DAD	D
	SHLD	VSETTRK+1
	DAD	D
	SHLD	VSETSEC+1
	DAD	D
	SHLD	VSETDMA+1
	DAD	D
	SHLD	VREAD+1
	DAD	D
	SHLD	VWRITE+1
	CALL	ILPRT
	DB	'DISK UTILITY (DU) V3.0 01/07/80',CR,LF
	DB	CR,LF,'Type ? for help'
	DB	CR,LF,'Type X to exit'
	DB	CR,LF,0
	LXI	H,80H	;TO INPUT BUFF
	MOV	A,M
	ORA	A
	JZ	PROMPTR	;NO COMMAND
;
;GOT INITIAL COMMAND, SET IT UP
;
	MOV	B,A	;SAVE LENGTH
	DCR	B
	JZ	PROMPTR
	LXI	D,INBUF
	INX	H	;SKIP LEN
	INX	H	;SKIP ' '
	CALL	MOVE
	MVI	A,CROMPT
	CALL	UPCASE
	STA	DUMTYPE	;TYPE OF DUMP (A,D,H)
	CPI	'!'	! JZ WARDSK ;<----DON'T USE
	CPI	'+'	! JZ PLUS
	CPI	'-'	! JZ MINUS
	CPI	'='	! JZ SEARCH
	CPI	'<'	! JZ SAVE
	CPI	'>'	! JZ RESTORE
	CPI	'?'	! JZ HELP
	CPI	'A'	! JZ DUMP
	CPI	'C'	! JZ CHG
	CPI	'D'	! JZ DUMP
	CPI	'F'	! JZ POSFIL
	CPI	'G'	! JZ POS
	CPI	'H'	! JZ DUMP
	CPI	'L'	! JZ LOGIN
	CPI	'M'	! JZ MAP
	CPI	'P'	! JZ PRINTFF
	CPI	'R'	! JZ DOREAD
	CPI	'S'	! JZ POS
	CPI	'T'	! JZ POS
	CPI	'V'	! JZ VIEW
	CPI	'W'	! JZ DOWRITE
	CPI	'STA	PFLAG
	JMP	PROMPT
;
;SLEEP ROUTINE, IN TENTHS OF A SEC
;
SLEEP	CALL	HEXIN	;GET COUNT IF ANY
	MOV	A,E	;ANY?
	ORA	A
	JNZ	SLEEPLP
	MVI	E,10
SLEEPLP	LXI	B,8000	;APPROX .1 SEC @ 2MHz
SLEEP2	DCX	B
	MOV	A,B
	ORA	C
	JNZ	SLEEP2
	PUSH	D
	CALL	CTLCS
	POP	D
	JZ	PROMPTR
	DCR	E
	JNZ	SLEEPLP
	JMP	PROMPT
;
;CHECK FOR CONTROL-C OR S
;
CTLCS	CALL	CONST
	INR	A
	RNZ		;NO CHAR
	CALL	CONIN
	ANI	1FH	;ALLOW ASCII
	CPI	'S'-40H
	CZ	CONIN
	CPI	'C'-40H
	RET		;0 SET IF CTL-C
;
LOGIN	MVI	C,RESETDK
EC
	CALL	READ
	CALL	NEXTSEC
	POP	D
	POP	B
	LXI	H,80H
	DAD	D
	XCHG
	DCR	B
	JNZ	RDIRLP
	LXI	B,80H
	CALL	VSETDMA
	POP	H
	RET
;
;MAP THE DIRECTORY
;
MAP	CALL	READDIR	;READ IN DIRECTORY
	MVI	C,2	;DFLT START
	CALL	HEXIN
	PUSH	H	;SAVE INBUF PTR
	MOV	A,E	;GET START
	ORA	A	;NOTHING?
	JZ	MAPDF	;..YES, DFLT
	MOV	C,E
MAPDF	MOV	A,C
	CALL	HEX
	MVI	A,'-'
	CALL	TYPE
	CALL	GETGRP	;GET GRP(C) TO HL
MAPCONT	INR	C	;NEXT GRP
	JZ	MAPEND	;DONE
	PUSH	H
	CALL	GETGRP	;GET ANOTHER
	POP	D	;SEE IF SAMENONAME
	MOV	A,M	;SEE IF ALLOC
	ORA	A	;ZERO?
	MVI	A,' '
	JZ	MAPNSP1
	MVI	A,'('
MAPNSP1	CALL	TYPE
	PUSH	H	;SAVE POINTER
	INX	H	;SKIP ALLOC BYTE
	MVI	B,8
	CALL	MAPN2
	MVI	A,'.'
	CALL	TYPE
	MVI	B,3
	CALL	MAPN2
	CALL	SPACE
	MOV	A,M	;GET EXT
	ORI	'0'
	CALL	TYPE
	POP	H
	MOV	A,M
	ORA	A
	MVI	A,' '
	JZ	MAPNSP2
	MVI	A,')'
MAPNSP2	CALL	TYPE	;")" IF ERASED FILE
	LDA	TWOUP
	XRI	1
	STA	TWOUP
	JZ	CRLF
	JMP	DELIM
;
NONAME	CALL	ILPRT
	DB	'++FREE++        ',0
	LDA	TWOUP
	XRI	1
	STA	TWOUP
	JZ	CRLF
DELIM	MVI	A,':'
	JMP	TYPE
;
;PRINT NAME, LENGTH IN B
;
MAPN2	MOV	A,M
	INX	H
	CPI	' '	;PRINTABLE?
	JC	MAPN2H	;..NO, IN HEX
	CPI	7FH	
	JC	MAPN2A
MAPN2H	CALL	BHEX
	JMP	MAPN2Z
MAPN2A	CALL	TYPE
MAPN2Z	DCR	B
	JNZ	MAPN2
	RET
;
;FIND WHICH FILE GROUP(C) BELONGS TO
;
GETGRP	LXI	H,DIRECT
	MVI	A,64	;# OF FILES
	STA	FILECT
GETGLP	PUSH	H	;SAVE POINTER
	LXI	D,15	;DISP TO LENGTH
	DAD	D
	MOV	A,M	;GET LENGTH
	ORA	A	;ZERO?
	JZ	GETGNF	;NO FILE
	CPI	0E5H	;UNUSED, FOMATTED DISK?
	JZ	GETGNFI	B,128
	CALL	MOVE
	MVI	A,1	;..SHOW
	STA	SAVEFLG	;..SAVED EXISTS
	POP	H
	JMP	PROMPT
;
;RESTORE THE CURRENT SECTOR
;
RESTORE	LDA	SAVEFLG
	ORA	A
	JZ	NOSAVE ;NONE TO SAVE
	PUSH	H
	LXI	H,SAVEBUF
	LXI	D,80H
	MVI	B,128
	CALL	MOVE
	POP	H
	JMP	PROMPT
;
NOSAVE	CALL	ILPRT
	DB	'++NO "<" SAVE COMMAND ISSUED'
	DB	CR,LF,0
	JMP	PROMPTR
;
;MOVE (HL) TO (DE) LENGTH IN B
;
MOVE	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVE
	RET
;
NOWRITE	XRA	A	;GET 0
	STA	WRFLG	;CAN'T WRITE NOW
	RET
;
RLF
	JMP	CALCGRP
;
;GET VALUE FROM INPUT BUFFER
;
GETVAL	MOV	A,M
	CPI	'<'	;HEX ESCAPE?
	RNZ		;NO, RETURN
;"<<" MEANS ONE "<"
	INX	H
	MOV	A,M
	CPI	'<'
	RZ
;GOT HEX
	PUSH	D
	CALL	HEXIN	;GET VALUE
	CPI	'>'	;PROPER DELIM?
	MOV	A,E	;GET VALUE
	POP	D
	JNZ	WHAT	;ERROR
	RET
;
;READ A BYTE AT A TIME
;
RDBYTE	PUSH	H
	LDA	FTSW	;FIRST READ?
	ORA	A
	JNZ	READ1
	LHLD	BUFAD
	MOV	A,H
	ORA	A	;AT 100?
	JZ	NORD	;NO, NO READ
;HAVE TO READ
	CALL	NEXTSEC
READ1	XRA	A
	STA	FTSW	;NOT FIRST READ
	LNT
	CALL	NEXTSEC
	LDA	CURSEC
	CALL	SETSEC	
	LDA	CURTRK
	CALL	SETTRK
	CALL	READ
	POP	D	;RESTORE COUNT
	JMP	VIEWLP
;
VIEWEOF	CALL	ILPRT
	DB	CR,LF,TAB,'++EOF++',CR,LF,0
;
VIEWEND	POP	H
	CALL	CRLF
	JMP	CALCGRP
;
;DUMP IN HEX OR ASCII
;
DUMP	LDA	WRFLG
	ORA	A
	JNZ	DUMPOK
	CALL	ILPRT
BADDMP	DB	'++Can''t dump, no sector read.',CR,LF,0
EXPL	CALL	ILPRT
	DB	'Use G command following F,',CR,LF
	DB	'or R or S following T',CR,LF,0
	JMP	PROMPTR
;
DUMPOK	MOV	A,M
	CPI	';'
	JZ	DUMPDF	;DFLT
	CPIDPOP
	INX	H
	MOV	A,L
	ANI	0FH
	JNZ	DHEX
DPOP	CALL	CTLCS
	JZ	PROMPTR
	LDA	DUMTYPE
	CPI	'H'
	JZ	DNOAS	;HEX ONLY
	POP	H	;GET START ADDR
DUMPAS	CALL	ASTER
DCHR	MOV	A,M
	CPI	' '
	JC	DPER
	CPI	7FH
	JC	DOK
DPER	MVI	A,'.'
DOK	CALL	TYPE
	MOV	A,E
	CMP	L
	JZ	DEND
	INX	H
	MOV	A,L
	ANI	0FH
	JNZ	DCHR
DEND	CALL	ASTER
	CALL	CRLF
	PUSH	D
	CALL	CTLCS
	POP	D
	JZ	PROMPTR
	MOV	A,E
	CMP	L
	JNZ	DUMPLP
	POP	H
	JMP	PROMPT
;
DNOAS	POP	B
	CALL	CRLF
	MOV	A,E
	CMP	L
	JNZ	DUMPLP
	POP	H
	JMP	PR
	MOV	B,A	;SAVE COUNT
	DCR	B	;ALLOW JP BELOW
GETGL2	INX	H	;TO NEXT
	MOV	A,M	;GET GRP
	CMP	C	;CORRECT ONE?
	JZ	GETGOT	;YES, GOT IT.
	MOV	A,B	;GET REC COUNT
	SUI	8
	MOV	B,A
	JP	GETGL2
;NO FILE
GETGNF	POP	H
	LXI	D,32
	DAD	D	;TO NEXT ENTRY
	LDA	FILECT
	DCR	A
	STA	FILECT
	JNZ	GETGLP	;MORE?
	LXI	H,0	;NO, NOT FOUND
	RET
;
;GOT THE FILE
;
GETGOT	POP	H	;POINT TO NAME
	RET
;
;SAVE THE CURRENT SECTOR
;
SAVE	LDA	WRFLG
	ORA	A
	JZ	BADW	;NONE TO SAVE
	PUSH	H
	LXI	H,80H
	LXI	D,SAVEBUF
	MV;NO MATCH IN SEARCH, TRY NEXT CHAR
;
SRNOMAT	POP	H
	CALL	CTLCS	;ABORT?
	JNZ	SEARCH	;..YES
	LXI	H,INBUF
	MVI	M,CR
	JMP	CALCGRP	;SHOW WHERE STOPPED
;
;SEARCH FOR CHARACTER STRING
;
SEARCH	PUSH	H	;SAVE STRING POINTER
SRCHL	CALL	RDBYTE	;GET A BYTE
	PUSH	PSW
	CALL	GETVAL	;GET SEARCH VALUE
	MOV	B,A
	POP	PSW
	CMP	B	;MATCH?
	JNZ	SRNOMAT	;NO MATCH
	INX	H
	MOV	A,M	;DONE?
	CPI	CR
	JZ	SREQU
	CPI	';'
	JNZ	SRCHL
;GOT MATCH
SREQU	CALL	ILPRT
	DB	'= AT ',0
	LDA	BUFAD
	ANI	7FH
	CALL	HEX
	CALL	CDA	CURSEC
	CALL	SETSEC
	LDA	CURTRK
	CALL	SETTRK
	CALL	READ
	CALL	CALCSUB
	LXI	H,80H
NORD	MOV	A,M
	INX	H
	SHLD	BUFAD
	POP	H
	RET
;
;VIEW THE FILE IN ASCII STARTING AT
;CURRENT SECTOR, STEPPING THRU THE DISK
;
VIEW	LDA	WRFLG
	ORA	A
	JZ	BADDMP
	CALL	HEXIN	;GET DISPL IF ANY
	PUSH	H
	MOV	A,E
	ORA	A
	JNZ	VIEWLP
	INR	E	;DFLT=1
VIEWLP	LXI	H,80H	;TO DATA
VIEWCHR	CALL	CTLCS
	JZ	VIEWEND
	MOV	A,M
	CPI	1AH
	JZ	VIEWEOF
	CALL	TYPE
	INR	L
	JNZ	VIEWCHR
	DCR	E
	JZ	VIEWEND
	PUSH	D	;SAVE COU	CR
	JNZ	DUMPNDF
;USE DEFAULT
DUMPDF	LXI	B,80H
	LXI	D,0FFH
	JMP	DUMP1
DUMPNDF	CALL	DISP
	MOV	B,D
	MOV	C,E
	CPI	CR
	JZ	DUMP1
	CPI	';'
	JZ	DUMP1
	INX	H	;SKIP ','
	CALL	DISP
;
;BC = START, DE = END
;
DUMP1	PUSH	H	;SAVE COMMAND POINTER
	MOV	H,B
	MOV	L,C
DUMPLP	MOV	A,L
	ANI	7FH
	CALL	HEX
	CALL	SPACE
	CALL	SPACE
	LDA	DUMTYPE
	CPI	'A'
	JZ	DUMPAS
	PUSH	H	;SAVE START
DHEX	MOV	A,M
	CALL	HEX
	MOV	A,L
	ANI	3
	CPI	3
	CZ	SPACE
	MOV	A,L
	ANI	7
	CPI	7
	CZ	SPACE
	MOV	A,E
	CMP	L
	JZ	OMPT
;
;POSITION
;
POS	PUSH	PSW
	MOV	A,M
	CPI	';'
	JZ	POSINQ
	CPI	CR
	JNZ	POSOK
POSINQ	POP	PSW
	JMP	INQ
;
POSOK	CALL	HEXIN
	POP	PSW
	CPI	'T'
	JZ	POSTRK
	CPI	'S'
	JZ	POSSEC
	CPI	'G'
	JZ	POSGRP
	JMP	WHAT
;
POSTRK	MOV	A,E
	CALL	SETTRK
	CALL	NOWRITE	;TRACK DOESN'T READ
	JMP	CALCGRP
;
POSSEC	MOV	A,E
	ORA	A
	JZ	WHAT
	CPI	27
	JNC	WHAT
	CALL	SETSEC
	CALL	READ
;
CALCGRP	CALL	CALCSUB
	JMP	INQ
;
CALCSUB	PUSH	H
	LDA	CURTRK
	SUI	2	;GRP 0 IS TRK 2
	MOV	L,A
	MVI	H,0
	MOV	D,H
	MOV	E,L
	DAD	H	;X2
	DAD	D	;X3
	DAD	H	;X6
	DAD	H	;X12
	DAD	D	;X13
	DAD	H	;X26
	LDA	CURSEC
	DCR	A
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	MOV	A,L
	ANI	7
	STA	GRPDISP
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	MOV	A,H
	STA	GROUP
	POP	H
	RET
;
;POSITION IN THE DIRECTORY AFTER A FIND
;
POSDIR	PUSH	H	;SAVE INBUF
	XRA	A
	STA	FINDFLG	;CANCEL POS REQ
	LDA	DIRPOS	;GET POSITION
	RAR
	RAR
	PUSH	PSW
	ANI	7	;GET GRP DISPLACEMENT
	STA	GRPDISP
	POP	PSW
	RAR
	RAR
	RAR
	ANI	1	;GET GROUP
	NQ
;
POSFIL	CALL	NOWRITE
	MVI	A,1
	STA	FINDFLG	;SO WE POSITION LATER
	LXI	D,FCB
	XRA	A	;LOGGED IN DISK
	STAX	D
	INX	D
	MVI	B,8
	CALL	MVNAME
	MVI	B,3
	CALL	MVNAME
	LXI	D,FCB
	MVI	C,SRCHF
	PUSH	H
	CALL	BDOS
	INR	A
	JNZ	FLOK
	STA	DIRPOS	;GRP 0 IF NOT FOUND
	CALL	ILPRT
	DB	'++FILE NOT FOUND',CR,LF,0
	POP	H
	JMP	PROMPT
;
FLOK	DCR	A
	STA	DIRPOS	;SAVE POS. IN DIR
	ANI	3
	MOV	L,A
	MVI	H,0
	DAD	H	;X32 BYTES/ENTRY
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,80H
	DAD	D	;HL POINTS TO ENTRY
	 #
	MOV	A,E
	ORA	A
	JZ	WHAT
PLUSGO	CALL	NEXTSEC
	DCR	E	;MORE TO GO?
	JNZ	PLUSGO	;..YES
;
;OK, INCREMENTED TO SECTOR.  SETUP AND READ
;
PLUSMI	LDA	CURSEC
	CALL	SETSEC	
	LDA	CURTRK
	CALL	SETTRK
	CALL	READ
	JMP	CALCGRP
;
MINUS	LXI	D,1	;SET DFLT
	MOV	A,M	;GET CHAR
	CPI	CR	;CR?
	JZ	MINGO	;..YES, DFLT=1
	CPI	';'
	JZ	MINGO
	CALL	HEXIN	;..NO, GET ##
	MOV	A,E
	ORA	A
	JZ	WHAT
MINGO	LDA	CURSEC	;GET CURR
	DCR	A	;BACK UP
	JNZ	MINOK	;TO 0?
	LDA	CURTRK	;..YES, BACK..
	DCR	A	;..UP 1..
	STA	CLL	ILPRT
	DB	'G=',0
	LDA	GROUP
	CALL	HEX
	MVI	A,':'
	CALL	TYPE
	LDA	GRPDISP
	ORI	'0'
	CALL	TYPE
	MVI	A,','
	CALL	TYPE
NOGRP	CALL	ILPRT
	DB	' T=',0
	LDA	CURTRK
	CALL	HEX
	CALL	ILPRT
	DB	', S=',0
	LDA	CURSEC
	CALL	HEX
	CALL	ILPRT
	DB	', PS=',0
	LDA	PHYSEC
	CALL	HEX
	CALL	CRLF
	RET
;
CHG	MOV	A,M	;GET TYPE (HEX, ASCII)
	CALL	UPCASE
	PUSH	PSW	;SAVE "H" OR "A"
	INX	H
	CALL	DISP	;GET, VALIDATE DISP TO DE
	INX	H
	LXI	B,0	;SHOW NO 'THRU' ADDR
	CPI	'-'	;TEST DELIM FR. DISP
	JNZ	CHGNT	A
	JZ	CHGANTH
	CMP	E	;DONE?
	JZ	PROMPT
	DCX	H	;..NO: MORE.
CHGANTH	INR	E
	JNZ	CHGALP
	MOV	A,M
	CPI	CR
	JZ	PROMPT
	CPI	';'
	JZ	PROMPT
	JMP	WHAT
;
;CHANGE HEX
;
CHGHCOM	INX	H
CHGHEX	MOV	A,M
	CPI	CR
	JZ	PROMPT
	CPI	';'
	JZ	PROMPT
	CPI	','	;DELIM?
	JZ	CHGHCOM
	PUSH	D
	SHLD	HEXAD	;IN CASE 'THRU'
	CALL	HEXIN	;POSITIONS TO DELIM
	MOV	A,E	;GET VALUE
	POP	D	;..ADDR
	PUSH	PSW	;SAVE VALUE
	LDAX	D	;GET OLD
	CALL	HEX	;ECHO IN HEX
	POP	PSW	;GET NEW
	STAX	D	;SAVE NEW
;
	MOV	A,C	;SEE IF STA	GROUP
	MOV	L,A	;SETUP FOR POSGRP2
	JMP	POSGRP2	;POSITION TO IT
;
POSGRP	MOV	A,E
	STA	GROUP
	XRA	A
	STA	GRPDISP
	PUSH	H
	MOV	L,E	;MULTIPLY
POSGRP2	MVI	H,0	;BY 8
	DAD	H
	DAD	H
	DAD	H
	LDA	GRPDISP	;MAY BE >0 IF "F" CMD.
	ADD	L	;CAN'T CARRY
	MOV	L,A
;DIVIDE BY 26, QUOTIENT = TRK, REMAINDER = SECTOR
	LXI	D,-26
	MVI	B,0	;TRK
DIVLP	INR	B
	DAD	D
	JC	DIVLP
	DCR	B
	LXI	D,26
	DAD	D
	MOV	A,B
	ADI	2	;GROUP 0 IS TRK 2
	CALL	SETTRK
	MOV	A,L
	INR	A
	CALL	SETSEC
	CALL	READ
	POP	H
	JMP	ILXI	D,32
	XCHG
	DAD	D
	XCHG
	MVI	A,'D'
	STA	DUMTYPE
	JMP	DUMPLP	;WHICH POPS H
;
MVNAME	MOV	A,M
	CPI	'.'
	JZ	MVIPAD
	CPI	CR
	JZ	PAD
	CPI	';'
	JZ	PAD
	CALL	UPCASE
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MVNAME
	MOV	A,M
	CPI	CR
	RZ
	CPI	';'
	RZ
	INX	H
	CPI	'.'
	RZ
	JMP	WHAT
;
MVIPAD	INX	H
;
PAD	MVI	A,' '
	STAX	D
	INX	D
	DCR	B
	JNZ	PAD
	RET
;
PLUS	LXI	D,1	;DFLT TO 1 SECT
	MOV	A,M	;GET NEXT CHAR
	CPI	CR	;CR?
	JZ	PLUSGO	;..YES, DFLT TO 1
	CPI	';'
	JZ	PLUSGO
	CALL	HEXIN	;GETURTRK	;..TRACK
	MVI	A,26	;
MINOK	STA	CURSEC
	DCR	E
	JNZ	MINGO
	JMP	PLUSMI
;
;GO TO NEXT SECTOR
;
NEXTSEC	LDA	CURSEC	;GET CURRENT
	INR	A	;BUMP IT
	CPI	27	;NEXT TRACK?
	JNZ	NEXTOK	;NO, CONI
	LDA	CURTRK	;BUMP..
	INR	A	;..CURR..
	STA	CURTRK	;..TRK
	MVI	A,1	;SECT=1
NEXTOK	STA	CURSEC
	RET
;
;TELL WHAT GRP, DISPLACEMENT, TRK, SECT, PHY SECT
;
INQ	CALL	INQSUB
	JMP	PROMPT
;
;POSITION INQUIRY SUBROUTINE
;	EXECUTED VIA: G S OR T (WITH NO OPERANDS)
;
INQSUB	LDA	CURTRK
	CPI	2
	JC	NOGRP
	CAH	;NO THRU
	PUSH	D	;SAVE FROM
	CALL	DISP	;GET THRU
	MOV	B,D
	MOV	C,E	;BC = THRU
	POP	D	;GET FROM
	JMP	CHGAH
CHGNTH	CPI	','
	JNZ	WHAT
CHGAH	POP	PSW
	CPI	'H'
	JZ	CHGHEX
	CPI	'A'
	JNZ	WHAT
;CHANGE ASCII
CHGALP	MOV	A,M
	CPI	CR
	JZ	PROMPT
	CPI	';'
	JZ	PROMPT
	LDAX	D
	CPI	' '
	JC	CHGAHX
	CPI	7FH
	JNC	CHGAHX
	JMP	CHGA2
CHGAHX	CALL	BHEX
	JMP	CHGA3
CHGA2	CALL	TYPE
CHGA3	CALL	GETVAL	;ASCII OR <HEX>
	STAX	D	;UPDATE CHAR
	INX	H	;TO NEXT INPUT CHAR
;SEE IF 'THRU' REQUESTED
	MOV	A,C
	ORA'THRU'
	ORA	A
	JZ	CHGHNTH	;..NO.
	CMP	E	;..YES, DONE?
	JZ	PROMPT
	LHLD	HEXAD	;..NO: MORE
CHGHNTH	INR	E
	JNZ	CHGHEX
	MOV	A,M
	CPI	CR
	JZ	PROMPT
	CPI	';'
	JZ	PROMPT
	JMP	WHAT
;
DOREAD	CALL	READ
	JMP	PROMPT
;
DOWRITE	CALL	WRITE
	JMP	PROMPT
;
BHEX	PUSH	PSW
	MVI	A,'<'
	CALL	TYPE
	POP	PSW
	CALL	HEX
	MVI	A,'>'
	CALL	TYPE
	RET
;
HEX	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	NIBBL
	POP	PSW
NIBBL	ANI	0FH
	CPI	10
	JC	HEXNU
	ADI	7
HEXNU	ADI	'0'
	JMP	TYPE
;
SPACE	MVI	A,' '
	JMP	TYPE
ASTER	MVI	A,'*'
	JMP	TYPE
;
ILPRT	XTHL
ILPLP	CALL	CTLCS	;ABORT?
	JZ	PROMPTR
	MOV	A,M
	CALL	TYPE
	INX	H
	MOV	A,M
	ORA	A
	JNZ	ILPLP
	INX	H
	XTHL
	RET
;
;DISP CALLS HEXIN, AND VALIDATES A SECTOR
;DISPLACEMENT, THEN CONVERTS IT TO AN ADDRESS
;
DISP	CALL	HEXIN
	PUSH	PSW	;SAVE DELIMITER
	MOV	A,D
	ORA	A
	JNZ	BADISP
	MOV	A,E
	ORA	A
	JM	BADISP
	ADI	80H	;TO POINT TO BUFFER AT 80
	MOV	E,A
	POP	PSW	;GET DELIM
	RET
;
BADISP	CALL	ILPRT
	DB	'++BAD DISPLACEMENT (NOT 0-7F)'
	DB	CR,LF,0
	'	;'THRU'?
	RZ
	INX	H
	CPI	'0'
	JC	WHAT
	CPI	'9'+1
	JNC	WHAT
	SUI	'0'
	PUSH	H
	MOV	H,D
	MOV	L,E
	DAD	H	;X2
	DAD	H	;X4
	DAD	D	;X5
	DAD	H	;X10
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	XCHG
	POP	H
	JMP	DINLP
;
;READ IN A CONSOLE BUFFER FULL
;
RDBUF	CALL	ILPRT
	DB	CR,LF,':',0
	LXI	H,INBUF
	MVI	B,0
RDBLP	CALL	CONIN
	MOV	C,A	;SAVE FOR BS TEST
	CPI	'U'-40H
	JZ	RDCTLU
	CPI	CR
	JZ	RDCR
	CPI	8
	JZ	RDBS
	CPI	7FH
	JZ	RDBS
	CPI	'R'-40H
	JZ	RDCTLR
	MOV	M,A
	INX	H
	INR	B
	JM	FCTLR	MVI	M,CR
	CALL	CRLF
	LXI	H,INBUF
	MVI	B,0
RDCRL	MOV	A,M
	CPI	CR
	JZ	RDBLP
	CALL	TYPE
	INR	B
	INX	H
	JMP	RDCRL
;
;GOT CTL-U OR BACKUP TO BEG. OF LINE.
;
RDCTLU	MVI	A,'^'
	CALL	TYPE
	MVI	A,'U'
	CALL	TYPE
	JMP	RDBUF
;
CRLF	MVI	A,CR
	CALL	TYPE
	MVI	A,LF
	JMP	TYPE
;
UPCASE	CPI	60H
	RC
	ANI	5FH	;MAKE UPPER CASE
	RET
;
CONST	PUSH	B
	PUSH	D
	PUSH	H
VCONST	CALL	$-$
	POP	H
	POP	D
	POP	B
	RET
;
CONIN	PUSH	B
	PUSH	D
	PUSH	H
VCONIN	CALL	$-$
	POP	H
	POP	D
	POP	B
	RET
;
M C REG.
TYPERET	POP	H
	POP	D
	POP	B
	RET
;
LIST:			;TYPE SAVED REGS
VLIST	JMP	$-$
;
HOME	PUSH	H
VHOME	CALL	$-$
	POP	H
	RET
;
SETTRK	CPI	77
	JC	TRKOK
	CALL	ILPRT
	DB	'++not in tracks 0-76++'
	DB	CR,LF,0
	CALL	NOWRITE
	JMP	PROMPTR
;
TRKOK	STA	CURTRK
	MOV	C,A
	PUSH	H
VSETTRK	CALL	$-$
	POP	H
	RET
;
SETSEC	STA	CURSEC	;LOGICAL
	MOV	C,A
	LDA	CURTRK
	CPI	2
	JC	GSETSEC	;DON'T SCRAMBLE TRK'S 0-1
	PUSH	H
	LXI	H,SECTBL-1
	MOV	A,C
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	MOV	Aailed++',CR,LF,0
WRITEOK	POP	H
	RET
;
;'SCUSE THIS KLUDGE - IT'S TO SET THE SCRAMBLE
;TABLE TO 1,2,3,4,5.. FOR MY 3600 RPM "FLOPPY"..
;
WARDSK	PUSH	H
	LXI	H,SECTBL
	MVI	B,1
	MVI	C,26
WARDLP	MOV	M,B
	INR	B
	DCR	C
	INX	H
	JNZ	WARDLP
	POP	H
	JMP	PROMPT
;
;HELP
;
HELP	CALL	ILPRT
	DB	'Operands in brackets [...] are optional'
	DB	CR,LF
	DB	CR,LF
	DB	'+[n]	step in [n] sectors;'
	DB	CR,LF
	DB	'-[n]	step out [n] sectors'
	DB	CR,LF
	DB	'=xxx	search for ASCII xxx from curr sector.'
	DB	CRJMP	PROMPTR
;
HEXIN	LXI	D,0
	MOV	A,M
	CPI	'#'	;DECIMAL?
	JZ	HDIN	;MAKE DECIMAL
HINLP	MOV	A,M
	CALL	UPCASE
	CPI	CR
	RZ
	CPI	';'
	RZ
	CPI	','
	RZ
	CPI	'-'	;'THRU'?
	RZ
	CPI	'>'
	RZ
	INX	H
	CPI	'0'
	JC	WHAT
	CPI	'9'+1
	JC	HINNUM
	CPI	'A'
	JC	WHAT
	CPI	'F'+1
	JNC	WHAT
	SUI	7
HINNUM	SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	JMP	HINLP
;
HDIN	INX	H	;SKIP '.'
DECIN	LXI	D,0
DINLP	MOV	A,M
	CALL	UPCASE
	CPI	CR
	RZ
	CPI	';'
	RZ
	CPI	','
	RZ
	CPI	'-ULL
	CALL	TYPE
	JMP	RDBLP
;
FULL	DCR	B
	DCX	H
	MVI	A,7	;'DING'
	CALL	TYPE
	JMP	RDBLP
;
;GOT CR
;
RDCR	MOV	M,A	;SAVE IT
	CALL	TYPE	;ECHO IT
	MVI	A,LF	;ECHO..
	CALL	TYPE	;..LF
	LXI	H,INBUF
	RET
;
;GOT DELETE OR BS, ECHO IF BS
;
RDBS	XRA	A	;AT FRONT..
	ORA	B	;..OF LINE?
	JZ	RDCTLU	;..YES, ECHO ^U
	DCX	H
	DCR	B
	MOV	A,C
	CPI	8	;BS?
	JZ	BACKUP	;ECHO THE BS
	MOV	A,M	;ECHO..
	CALL	TYPE	;..DELETED CHAR
	JMP	RDBLP
;
BACKUP	MVI	A,8
	CALL	TYPE
	JMP	RDBLP
;
;GOT CTL-R, RETYPE
;
RD
;CONSOLE OUT WITH TAB EXPANSION
;
TYPE	PUSH	B
	PUSH	D
	PUSH	H
	MOV	C,A	;FOR OUTPUT ROUTINE
	CPI	TAB
	JNZ	VCONOUT
TYPETAB	MVI	A,' '
	CALL	TYPE
	LDA	TABCOL
	ANI	7
	JNZ	TYPETAB
	JMP	TYPERET
;
VCONOUT	CALL	$-$	;ADDR FILLED IN BY 'INIT'
;
;UPDATE COLUMN USED IN TAB EXPANSION
;
	MOV	A,C	;GET CHAR
	CPI	CR
	JNZ	TYPENCR
	MVI	A,0
	STA	TABCOL
	JMP	TYPELST
;
TYPENCR	CPI	' '	;CTL CHAR?
	JC	TYPERET	;..NO CHANGE IN COL
	LDA	TABCOL
	INR	A
	STA	TABCOL
TYPELST	LDA	PFLAG
	ANI	1
	CNZ	LIST	;FRO,M
	POP	H
	MOV	C,A
GSETSEC	PUSH	H
	MOV	A,C	;GET PHYSICAL SECTOR
	STA	PHYSEC
VSETSEC	CALL	$-$
	POP	H
	RET
;
SETDMA:
VSETDMA	JMP	$-$
;
READ	MVI	A,1
	STA	WRFLG
	PUSH	H
VREAD	CALL	$-$
	ORA	A
	JZ	READOK
	CALL	ILPRT
	DB	'++READ failed, sector may be invalid++'
	DB	CR,LF,0
READOK	POP	H
	RET
;
WRITE	LDA	WRFLG
	ORA	A
	JNZ	PWRITE
BADW	CALL	ILPRT
	DB	'++CANNOT WRITE UNLESS READ ISSUED'
	DB	CR,LF,0
	JMP	EXPL
PWRITE	PUSH	H
VWRITE	CALL	$-$
	ORA	A
	JZ	WRITEOK
	CALL	ILPRT
	DB	'++WRITE f,LF
	DB	'	Caution: upper/lower case matters'
	DB	CR,LF
	DB	'	<nn> for hex: "IN 0" is: =<db><0>'
	DB	CR,LF
	DB	'	"(tab)H,0(CR)(LF)" is: =<9>H,0<D><A>'
	DB	CR,LF
	DB	'<	save current sector'
	DB	CR,LF
	DB	'>	restore saved sector'
	DB	CR,LF
	DB	'?	give help'
	DB	CR,LF
	DB	'A[ff,tt] ASCII dump'
	DB	CR,LF
	DB	'C	Change:'
	DB	CR,LF
	DB	'	CHaddr,byte,byte... (hex)'
	DB	CR,LF
	DB	'  or	CAaddr,data  (Ascii)'
	DB	CR,LF
	DB	'	<xx> Allowed for imbedded hex.'
	DB	CR,LF
	DB	'  or	CHfrom-thru,byte  e.g. ch0-7f,e5'
	DB	CR,LF
	DB	'  or	CAfrom-thru,byte'
	DB	CR,LF
	DB	'D[ff,tt] Dump (hex+ASCII)'
	DB	CR,LF
	DB	'Fn.t	Find file'
	DB	CR,LF
	DB	'Gnn	CP/M Allocation Group nn'
	DB	CR,LF
	DB	'H[ff,tt]	hex dump'
	DB	CR,LF
	DB	'L	Log in drive'
	DB	CR,LF
	DB	'Lx	Log in drive x'
	DB	CR,LF
	DB	'M[nn]	Map [from group nn]'
	DB	CR,LF
	DB	'P	Toggle printer switch'
	DB	CR,LF
	DB	'R	Read current sector'
	DB	CR,LF
	DB	'Snn	Sector nn'
	DB	CR,LF
	DB	'Tnn	Track nn'
	DB	CR,LF
	DB	'V[nn]	View [nn] ASCII 17,23,3,09,15,21
	DB	2,8,14,20,26,6,12,18,24,4,10,16,22
;
BUFAD	DW	100H	;FORCES INITIAL READ
HEXAD	DW	0	;TO RE-FETCH A VALUE
TOGO	DB	0FFH	;REPEAT COUNT (FF=CONT)
TWOUP	DB	0
PFLAG	DB	0	;1=PRINT
GROUP	DB	0
GRPDISP	DB	0
SAVEFLG	DB	0
CURTRK	DB	0
CURSEC	DB	1
PHYSEC	DB	1
TABCOL	DB	0
FILECT	DB	0
DIRPOS	DB	0
FINDFLG	DB	0	;1=MUST POSITION AFTER FIND
FTSW	DB	1	;SEARCH W/O INCREMENT
WRFLG	DB	0	;MAY NOT WRITE UNTIL '+', '-',
;			 OR 'G' COMMAND
	DS	100	;STACK SPACE
STACK:
DUMTYPE	DS	1
SAVEBUF	DS1*  "
""7"`"d""""".ͬ	DISK UTILITY (DU) V3.0 01/07/80

Type ? for help
Type X to exit
 ! ~ʚGʚo##͖>
!oÝl
>2{12|>2! "wͫʚ:~
ʚ;#ʢ2!L+-!=ʳ<>>Z?_AʅCDʅF^GʚHʅLʽM%P~Ro	SʚTʚV,Wu	X  Zʉ/Uͬ	? Ú:
{i:{i{2{!o:{ʢ=2{¢Ú:}2}â	{
@xͫʚâ	<
 ~  
;#A_ ͟â͟>2>2BKͽ*w|%Q2:͙:h! ~#"w:ʏ	{=! ͫ~~n,@~Q:͙:h=ͬ	
	++EOF++
 
:ͬ	++Can't dump, no sector read.
 ͬ	Use G command following F,
or R or S following T
 Ú~;
  	BK
;#	`i}͋	͢	͢	:AW~͋	}̢	}̢	{H#}(ͫʚ:Hʍͧ	~ eg>.{v#}Zͧ	
ͫʚ{â
{â~;ʦ
ªg	TSG)M{h͟{MM͙g:o& T])))):=o| g}2		{		#y	ʢ+~
ʢ;ʢM#~
ʢ;ʢ,0	"y	{͋	y]	ʢ*y1	~
ʢ;ʢMââ><͋	>>͔	
ڝ	0> >*ͫʚ~#~­	#	z	{	ƀ_ͬ	++BAD DISPLACEMENT (NOT 0-7F)
 Ú  ~#9
~
;,->#0M:,
AMGM0))))o
#  ~
;,-#0M:M0bk)))o| g=
ͬ	
: !o O

ʫ
ʸ
ʸ

w#
x
+>x
w>
!oɯ
+y
~x
>x
6
!o ~
x
#
>^>Ul
>
>
sectors'
	DB	CR,LF
	DB	'W	Write current sector'
	DB	CR,LF
	DB	'X	Exit program'
	DB	CR,LF
	DB	'Z[nn]	Sleep [nn tenths]'
	DB	CR,LF
	DB	'/[nn]	Repeat [nn (decimal) times]'
	DB	CR,LF,CR,LF
	DB	'Cancel a function with C or Ctl-C.'
	DB	CR,LF
	DB	'Suspend output with S or Ctl-S.'
	DB	CR,LF
	DB	'Separate commands with ";".'
	DB	CR,LF
	DB	'All "nn" usage except "/" are '
	DB	'HEX.  Use #nn for decimal.'
	DB	CR,LF,0
	JMP	PROMPT
;
;DISK SECTOR ORDER - standard CP/M
;
SECTBL	DB	1,7,13,19,25,5,11,	128
INBUF	DS	128
;
;DIRECTORY READ IN HERE; ALSO SEARCH WORKAREA
;
WORK:
DIRECT	DS	32*64
;
FCB	EQU	5CH
BDOS	EQU	5
RESETDK	EQU	13
SELDK	EQU	14
SRCHF	EQU	17	;SEARCH FIRST
:h:͙Q!  ͽ	{4Ky͋	>-hͫtz\{\@y=͋	|4y=͋	|
:~o3͢	|~> ʍ>(#>.͢	~0~> ʴ>):|2|
ͬ	++FREE++         :|2|
>:~# {	!>@2 ~))G#~<xG  :=2!  :! ͖>2â:q! ͖âͬ	++NO "<" SAVE COMMAND ISSUED
 Ú~#ɯ2ͫ³!o6
G¤#~
;´ͬ	= AT  :w͋	
~<#~<	>{M:)))))|2~2:22~o3{2~2k& ))):o B xh}<͙g͟>2\ \  < 2ͬ	++FILE NOT FOUND
 â=2o& )))))   >D2~.
;#~
;#.M#>  ~
;	{MQ:͙:h ~
7;7	{M:=G:=2>27:<c:<2>2mâ:ړͬ	G= :~͋	>::0>,ͬ	 T= :͋	ͬ	, S= :͋	ͬ	, PS= :͋	
~#	#  -	BK,MH1	AM~
ʢ;ʢ 	`_    O	6> :&[  y
G> 2S [:<2:}_    Mڏͬ	++not in tracks 0-76++
 ͟Ú2O  2O:ڳ!\yo| g~Oy2    >2  ͬ	++READ failed, sector may be invalid++
 :,ͬ	++CANNOT WRITE UNLESS READ ISSUED
 ï  Jͬ	++WRITE failed++
 !]p
#Tâͬ	Operands in brackets [...] are optional

+[n]	step in [n] sectors;
-[n]	step out [n] sectors
=xxx	search for ASCII xxx from curr sector.
	Caution: upper/lower case matters
	<nn> for hex: "IN 0" is: =<db><0>
	"(tab)H,0(CR)(LF)" is: =<9>H,0<D><A>
<	save current sector
>	restore saved sector
?	give help
A[ff,tt] ASCII dump
C	Change:
	CHaddr,byte,byte... (hex)
  or	CAaddr,data  (Ascii)
	<xx> Allowed for imbedded hex.
  or	CHfrom-thru,byte  e.g. ch0-7f,e5
  or	CAfrom-thru,byte
D[ff,tt] Dump (hex+ASCII)
Fn.t	Find file
Gnn	CP/M Allocation Group nn
H[ff,tt]	hex dump
L	Log in drive
Lx	Log in drive x
M[nn]	Map [from group nn]
P	Toggle printer swit;CV.ASM - DUAL SCROLLING COMPARE ROUTINE FOR VDM
;
;05/06/79 BY WARD CHRISTENSEN
;07/09/79 MODIFY FOR VDM AT 0CC00H
;10/04/79 PUT IN CP/M DIRECT I/O
;	ADD PRINTING HEX FOR NON-PRINTABLES
;
;PROGRAM TO SCROLL 2 FILES AT ONCE, 1, 4, OR 7
;LINES AT A TIME.  ALSO CAN COMPARE THE FILES
;WITH CONTINUOUS SCROLLING UNTIL A DIFFERENCE
;IS FOUND
;
;COMMAND FORMAT: CV NAME1 NAME2
;
;NAME1 WILL BE SCROLLED ON THE TOP HALF OF THE VDM
;NAME2 WILL BE SCROLLED ON THE BOTTOM HALF OF THE VDM
;
;   TOP CHAR  EQ ''''
	LOCAL	?B,?Z
	CALL	?Z
?B	DB	?F
?Z	POP	H	;GET FROM
	LXI	B,?Z-?B	;GET LEN
	ELSE
	LXI	H,?F
	ENDIF
	ENDIF
	IF	NOT NUL ?T
	LXI	D,?T
	ENDIF
	IF	NOT NUL ?L
	LXI	B,?L
	ENDIF
	CALL	MOVER
MF	SET	-1	;;SHOW EXPANSION
	ENDM


;
;DEFINE CP/M MACRO - CPM FNC,PARM
;
CPM	MACRO	?F,?P
	PUSH	B
	PUSH	D
	PUSH	H
	IF	NOT NUL ?F
	MVI	C,?F
	ENDIF
	IF	NOT NUL ?P
	LXI	D,?P
	ENDIF
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	ENDM
;
	ORG	100H
	CALL	START
	DB	'CV.COM'
	DB	' AS OF 05/06/79'
	DB	0DH,E UPPER CASE
	CPI	'Y'
	JZ	TOPCONT
	CPI	'H'
	JZ	BOTCONT
	CPI	'U'
	JZ	TOP1
	CPI	'J'
	JZ	BOT1
	CPI	'I'
	JZ	TOP4
	CPI	'K'
	JZ	BOT4
	CPI	'O'
	JZ	TOP7
	CPI	'L'
	JZ	BOT7
	CPI	'C'
	JZ	COMPARE
	CPI	'Q'
	JZ	EXIT
	JMP	LOOP
;
TOP	CALL	RDTOP
	PUSH	PSW
	CALL	SCRTOP
	POP	PSW
	CPI	1AH
	RZ
	CPI	0AH
	JNZ	TOP
	RET
;
BOT	CALL	RDBOT
	PUSH	PSW
	CALL	SCRBOT
	POP	PSW
	CPI	1AH
	RZ
	CPI	0AH
	JNZ	BOT
	RET
;
TOP1	CALL	TOP
	JMP	LOOP
;
BOT1	CALL	BOT
	JMP	LOOP
;
TOP7	MVI	B,7
	JMP	TOP4LP
E
	CALL	RDBOT	;GET BOTTOM
	PUSH	PSW
	CALL	SCRBOT
	POP	PSW
	POP	B
	CPI	1AH
	JZ	LOOP
	CMP	B
	JZ	COMPARE
	CALL	PRTOP
	CALL	PRBOT
	JMP	LOOP
;
;READBYTE FOR TOP FILE
;
RDTOP	LXI	H,TOPFCB
	CALL	RDBYTE
	RET
;
;RDBYTE FROM BOTTOM FILE
;
RDBOT	LXI	H,BOTFCB
	CALL	RDBYTE
	RET
;
OPENER1	CALL	ERXIT
	DB	'++CAN''T OPEN FILE 1++$'
OPENER2	CALL	ERXIT
	DB	'++CAN''T OPEN FILE 2++$'
;
;SCROLL TOP HALF OF SCREEN
;
SCRTOP	PUSH	H
	LHLD	TOPLPTR
	MOV	M,A
	INX	H
	SHLD	TOPLPTR
	LXI	H,TOPLCT
	INRch
R	Read current sector
Snn	Sector nn
Tnn	Track nn
V[nn]	View [nn] ASCII sectors
W	Write current sector
X	Exit program
Z[nn]	Sleep [nn tenths]
/[nn]	Repeat [nn (decimal) times]

Cancel a function with C or Ctl-C.
Suspend output with S or Ctl-S.
Separate commands with ";".
All "nn" usage except "/" are HEX.  Use #nn for decimal.
 â
	
                                                                                                                                    BOT CHAR	FUNCTION
;
;	Y	H		CONTINUOUS SCROLL
;	U	J		1 LINE SCROLL
;	I	K		4 LINE SCROLL
;	O	L		7 LINE SCROLL
;
;	C SCROLLS CONTINUOUSLY, COMPARING THE FILES
;		STOPS ON A MIS-COMPARE.
;
VDM	EQU	0CC00H
;
MF	SET	0	;SHOW MOVE NOT REQUESTED
;
;(FROM EQU8.LIB...)
;DEFINE SOME MACROS TO MAKE THINGS EASIER
;
;DEFINE DATA MOVE MACRO: MOVE from,to,length
;	from may be addr, or quoted string
;
MOVE	MACRO	?F,?T,?L
	IF	NOT NUL ?F
	IRPC	?C,?F
?Q	SET	'&?C&?C' ;;TEST FOR QUOTE
	EXITM
	ENDM
	IF	?Q 0AH,'$'
START	POP	D	;GET ID
	MVI	C,PRINT
	CALL	BDOS	;PRINT ID
;
;INIT LOCAL STACK
;
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
	CALL	INIT	;GET CONST, CONIN
;
;START OF PROGRAM EXECUTION
;
	MOVE	FCB2,MYFCB,12 ;SAVE FILENAME
	CPM	OPEN,FCB
	INR	A
	JZ	OPENER1
	CPM	OPEN,MYFCB
	INR	A
	JZ	OPENER2
	LXI	H,VDM
	MVI	B,4	;# PAGES
	MVI	A,' '	;CLEAR CHR
CLRLP	MOV	M,A
	INR	L
	JNZ	CLRLP
	INR	H
	DCR	B
	JNZ	CLRLP
	CALL	TOP	;SHOW FIRST..
	CALL	BOT	;..TWO LINES
;
LOOP	CALL	KEYIN
	ANI	5FH	;MAKTOP4	MVI	B,4
TOP4LP	PUSH	B
	CALL	TOP
	POP	B
	DCR	B
	JNZ	TOP4LP
	JMP	LOOP
;
BOT7	MVI	B,7
	JMP	BOT4LP
BOT4	MVI	B,4
BOT4LP	PUSH	B
	CALL	BOT
	POP	B
	DCR	B
	JNZ	BOT4LP
	JMP	LOOP
;
TOPCONT	CALL	TOP
	CALL	STAT
	JZ	TOPCONT
	JMP	LOOP
;
BOTCONT	CALL	BOT
	CALL	STAT
	JZ	BOTCONT
	JMP	LOOP
;
;COMPARE FILES, SCROLLING, STOP AT DIFFERENCE
;
COMPARE	CALL	STAT
	JNZ	LOOP
	CALL	RDTOP	;GET TOP BYTE
	PUSH	PSW
	CALL	SCRTOP	;SCROLL IT
	POP	PSW
	CPI	1AH	;EOF?
	JZ	LOOP
	PUSH	PSW	;SAVE FOR COMPAR	M
	POP	H
	CPI	0AH
	JZ	PRTOP
	LDA	TOPLCT
	ORA	A
	RP
PRTOP	PUSH	H
	LDA	TOPLCT
	MOV	B,A
	INR	B
	INR	B
	INR	B
	LXI	H,TOPL
	CALL	PRLINE
	LXI	H,TOPLINE
	SHLD	TOPLPTR
	XRA	A
	STA	TOPLCT
	POP	H
	RET
;
;SCROLL BOTTOM HALF OF SCREEN
;
SCRBOT	PUSH	H
	LHLD	BOTLPTR
	MOV	M,A
	INX	H
	SHLD	BOTLPTR
	POP	H
	CPI	0AH
	JZ	PRBOT
	LDA	BOTLCT
	INR	A
	STA	BOTLCT
	RP
PRBOT	PUSH	H
	LDA	BOTLCT
	MOV	B,A
	INR	B
	INR	B
	INR	B
	LXI	H,BOTL
	CALL	PRLINE
	LXI	H,BOTLINE
	SHLD	BOTLPTR
	XRA	A
	STA	BOTLCT
	POP	H
	RET
;
;PRINT LINE POINTED TO BY HL, B=COUNT
;
PRLINE	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	PRLINE
	DCX	H
	MOV	A,M	;WAS IT LF?
	CPI	0AH
	RZ
	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
	CALL	TYPE
	RET
;
;TYPE ROUTINE.  PRINTS [HEX] IF NOT PRINTABLE
;
TYPE	CPI	9
	JZ	TYPEIT
	CPI	0DH
	JZ	TYPEIT
	CPI	0AH
	JZ	TYPEIT
	CPI	' '
	JC	DOHEX
	CPI	7FH
	JC	TYPEIT
DOHEX	PUSH	PSW
	MVI	A,'['
	CALL	TYPE
	POP	PSW
	PUSH	PSW
	CALL	LNIB
	CALL	TYPE
	POP	PSW
	CALL	RNIB
	CALL	TYPE
	MVI	,B	;GET COUNT
	ORA	C
	JNZ	RDBNORD	;NO READ
;
	INX	H	;TO BUFFER SIZE
	MOV	A,M	;GET COUNT
	ADD	A	;MULTIPLY BY 2
	MOV	B,A	;SECTOR COUNT IN B
	INX	H	;TO FCB
	PUSH	H	;SAVE FCB POINTER
	MOV	A,M	;GET..
	INX	H	;..FCB..
	MOV	H,M	;..ADDR..
	MOV	L,A	;..TO HL
;
RDBLP	MVI	A,1AH	;GET EOF CHAR
	STAX	D	;SAVE IN CASE EOF
	PUSH	D	;SAVE DMA ADDR
	PUSH	H	;SAVE FCB ADDR
	CPM	STDMA	;SET DMA ADDR
	POP	D	;GET FCB
	CPM	READ
	ORA	A
	POP	H	;HL=DMA, DE=FCB
	JNZ	RDBRET	;GOT EOF
	MOV	A,L
	ADI	80H	;TO NEXT BUFF

	MOV	A,M	;GET BYTE
	XCHG		;EFCB BACK TO HL
	CPI	1AH	;EOF?
	RZ		;YES, LEAVE POINTERS
	DCX	B	;DECR COUNT
	DCX	H	;BACK TO "BYTES LEFT"
	MOV	M,B
	DCX	H
	MOV	M,C	;STORE BACK COUNT
	RET
;
;---->	INIT	GETS CP/M CONSOLE STATUS AND CONSOLE
;		OUT VECTORS
;
INIT	LHLD	1	;GET WARM BOOT ADDR
	LXI	D,3	;LENGTH OF 1 "JMP"
	DAD	D	;POINT TO CONS. STAT
	SHLD	VSTAT+1
	DAD	D
	SHLD	VKEYIN+1
	RET
;
;CP/M CONSOLE STATUS VIA DIRECT BIOS CALL
;
STAT	PUSH	B
	PUSH	D
	PUSH	H
VSTAT	CALL	$-$	;ADDR MOD. BY "INT, RESTORING STACK AND RETURN
EXIT	LHLD	STACK
	SPHL
	RET		;TO CCP
	DS	40H	;STACK AREA
STACK	DS	2
;
TOPFCB	DW	TOPBUF	;BUFFER ADDR
	DW	0	;CHARS IN BUFFER
	DB	16	;BUFF SIZE IN SECTORS
	DW	FCB	;FCB ADDR
BOTFCB	DW	BOTBUF	;BUFFER ADDR
	DW	0	;CHARS IN BUFFER
	DB	16	;BUFF SIZE IN SECTORS
	DW	MYFCB	;FCB ADDR
;
MYFCB	DB	0,'XXXXXXXXYYY',0
	DS	19
	DB	0
;
TOPLPTR	DW	TOPLINE
BOTLPTR	DW	BOTLINE
TOPLCT	DB	0
BOTLCT	DB	0
TOPL	DB	'1:	'	;COLON TAB
TOPLINE	DS	128
BOTL	DB	'2:	'	;COLON TAB
BOTLINE	DS	12CV.COM AS OF 05/06/79
$	 !  9"1J!l  n\  <R <k! > w,e$eͯd_YHUJIKOLCQuD̈́
¯K.
ͯuuͯuuͯYuYuYuD̈́uK.uu!!y++CAN'T OPEN FILE 1++$y++CAN'T OPEN FILE 2++$*,|g

	  ک>[̈́̈́̈́>]̈́w#|",~w~w}o~w@ ! @w#w#zA,']'
	CALL	TYPE
	RET
;
TYPEIT	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A
	MVI	C,2
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET



;
LNIB	RAR
	RAR
	RAR
	RAR
RNIB	ANI	0FH
	ADI	90H
	DAA
	ACI	40H
	DAA
	RET
;
;	FROM EQU8.LIB:
;
;RDBYTE, HL POINTS TO EXTENDED FCB:
;
;	2 BYTE BUFFER ADDR
;	2 BYTE "BYTES LEFT" (INIT TO 0)
;	1 BYTE BUFFER SIZE (IN PAGES)
;	2 BYTE FCB ADDRESS (33 BYTES)
;
RDBYTE	MOV	E,M
	INX	H
	MOV	D,M	;GET BUFFER ADDR
	INX	H
	MOV	C,M
	INX	H
	MOV	B,M	;BC = BYTES LEFT
	MOV	A
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	XCHG		;DMA TO DE, FCB TO HL
	DCR	B	;MORE SECTORS?
	JNZ	RDBLP	;YES, MORE
RDBRET	POP	H	;GET FCB POINTER
	DCX	H	;TO LENGTH
	MOV	A,M	;GET LENGTH
	DCX	H	;TO COUNT
	MOV	M,A	;SET PAGE COUNT
	DCX	H	;TO LO COUNT
	DCX	H	;TO HI FCB
	DCX	H	;TO EFCB START
	JMP	RDBYTE	;LOOP THRU AGAIN
;
RDBNORD	INX	H	;TO LENGTH
	MOV	A,M	;GET LENGTH (PAGES)
	XCHG		;BUFF TO HL
	ADD	H
	MOV	H,A	;HL = END OF BUFF
	MOV	A,L
	SUB	C
	MOV	L,A
	MOV	A,H
	SBB	B
	MOV	H,A	;HL = DATA POINTERIT"
	POP	H
	POP	D
	POP	B
	ORA	A
	RET
;
;CP/M CONSOLE INPUT VIA DIRECT BIOS CALL
;
KEYIN	PUSH	B
	PUSH	D
	PUSH	H
VKEYIN	CALL	$-$	;ADDR MOD. BY "INIT"
	POP	H
	POP	D
	POP	B
	RET
;
;FOLLOWING FROM 'EQU8.LIB'---->
;
;MOVE, COMPARE SUBROUTINES
;
	IF	MF	;MACRO EXPANSION FLAG SET?
MOVER	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVER
	RET
	ENDIF
;
;EXIT WITH ERROR MESSAGE
MSGEXIT	EQU	$	;EXIT W/"INFORMATIONAL" MSG
ERXIT	POP	D	;GET MSG
	MVI	C,PRINT
	CALL	BDOS
;EXI8
TOPBUF	DS	16*256	;4K BUFFER
BOTBUF	DS	16*256	;4K BUFFER
;
;BDOS/CBIOS EQUATES (VERSION 8)
;
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
CONST	EQU	11
OPEN	EQU	15
CLOSE	EQU	16
SRCHF	EQU	17
SRCHN	EQU	18
ERASE	EQU	19
READ	EQU	20
WRITE	EQU	21
MAKE	EQU	22
REN	EQU	23
STDMA	EQU	26
BDOS	EQU	5
FCB	EQU	5CH 
FCB2	EQU	6CH
FCBEXT	EQU	FCB+12
FCBRNO	EQU	FCB+32
|6 #}?6 #}  *|g
ʀ
ʋ	 So>[...>].w#|ʘ"~w~w}ow~w@ q! @w#w#z |¼w6 #}?6 #}q Ɛ'@'^#V#N#Fx4#~G#~#fo>  )}ƀo| g+~+w+++#~g}o|g~+p+q*  "]"h    ~#xn	 *}ow~w@ q! @w#w#z |¼w6 #}?  \    XXXXXXXXYYY @'^#V#N#Fx4#~            ;VDMSAVE.ASM 10/25/79 BY WARD CHRISTENSEN
;
;Write an image of the current VDM screen to disk.
;Scans for end of lines, puts in CR/LF where appropriate.
;
;	VDMSAVE fn.ft
;
;DEPENDENCIES:
;	Written for a VDM screen using a scroll routine
;which does not do hardware scrolling.  Therefore, the first
;line written is the lowest memory address line of the VDM.
;May work for other contiguous memory mapped displays.
;
;
LINES	EQU	16  	;<----CHANGE
COLUMNS	EQU	64  	;<----THESE
ADDRESS	EQU	0CC00H 	;<--
	CALL	BDOS
	INR	A
	RNZ
	CALL	ERXIT
	DB	'++MAKE FAILED++$'
;
;---->	TEST A LINE.
;	RETURNS ZERO IF LINE IS BLANK
;	DE POINTS TO LAST NON BLANK CHAR.
;
TESTL	LHLD	LINEPTR
	LXI	D,0
	MVI	B,COLUMNS ;LINE LENGTH
TESTLP	MOV	A,M	;GET CHAR
	ANI	7FH	;DELETE CURSOR
	CPI	' '
	JZ	TESTB
	MOV	D,H	;SAVE POSITION IN DE
	MOV	E,L	
TESTB	INX	H
	DCR	B
	JNZ	TESTLP
;SET ZERO BASED ON HAVING FOUND A CHAR
	MOV	A,D
	ORA	E
	RET
;
;---->	WRITE A LINE (BUT NOT C/R L/F)
;
WRLINE	INX	D	;FACILITATE TESTINRBYTE
	LDA	BUFPTR	;FULL SECTOR?
	CPI	80H
	JNZ	WREOF
	LXI	D,FCB
	MVI	C,CLOSE
	CALL	BDOS
	INR	A
	RNZ
	CALL	ERXIT
	DB	'++CLOSE ERROR++$'
;
;---->	WRITE A BYTE TO THE FILE
;
WRBYTE	PUSH	H
	LHLD	BUFPTR
	MOV	M,A
	INR	L	;AT 100?
	JNZ	NOWRITE
;
;HAVE TO WRITE A SECTOR
;
	PUSH	B
	PUSH	D
	LXI	D,FCB
	MVI	C,WRITE
	CALL	BDOS
	ORA	A
	JNZ	WRERR
	POP	D
	POP	B
	LXI	H,80H
NOWRITE	SHLD	BUFPTR
	POP	H
	RET
;
WRERR	CALL	ERXIT
	DB	'++WRITE ERROR++$'
;
;FOLLOWING FROM 'EQU8.LIB'---->
;
;EXIALLOC 11/14/77
$	 :\ (=_  DM 
>0;<h{_Pz3{3zaza1>
h>
_            D.COM AS OF 11/23/78
$	 !  9"u1u!] ;ADD         ['!m  >\!] lDEL         '\*++NAME NOT IN TABLE++$!] ͦSET         ½>2w>2yN:]  2xN:\ =_  \  <h=o& ))))) :w:xC!y~<C ?#
)6 	~#
F>,>
>
:w :x :\  !y ~ʴ< ͸~#>,
>
>
ÃÅ:<2!~#~
----> NOT FOUND:
   >_<----EQUATES
;
	ORG	100H
;
;INIT LOCAL STACK
;
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
;
;START OF PROGRAM EXECUTION
;
	CALL	MAKEFIL	;MAKE THE FILE
LINE	CALL	TESTL	;TEST THE LINE
	CNZ	WRLINE	;WRITE NON-BLANK LINE
	CALL	WRCRLF
	CALL	NEXTL	;MORE?
	JNZ	LINE	;YES.
	CALL	WREOF	;NO, END
	CALL	ERXIT	;ALL DONE
	DB	'++DONE++$'
;
;---------------- SUBROUTINES ----------------
;
;---->	ERASE, THEN MAKE, THE FILE
;
MAKEFIL	LXI	D,FCB
	MVI	C,ERASE	;<--
	CALL	BDOS
	LXI	D,FCB
	MVI	C,MAKE	;G
	LHLD	LINEPTR
WRLP	MOV	A,M
	INX	H
	ANI	7FH	;DELETE CURSOR BIT
	CALL	WRBYTE
	MOV	A,L
	CMP	E
	JNZ	WRLP
	MOV	A,H
	CMP	D
	JNZ	WRLP
	RET
;
;---->	WRITE A CR/LF TO THE FILE
;
WRCRLF	MVI	A,0DH
	CALL	WRBYTE
	MVI	A,0AH
	CALL	WRBYTE
	RET
;
;---->	POINT TO NEXT LINE, RETURN ZERO
;	IF END OF SCREEN
;
NEXTL	LHLD	LINEPTR
	LXI	D,COLUMNS
	DAD	D
	SHLD	LINEPTR
	LDA	NLINES
	DCR	A
	STA	NLINES	;ZERO SET..
	RET		;..IF DONE
;
;---->	WRITE CTL-Z TO THE FILE, CLOSE IT
;
WREOF	MVI	A,1AH
	CALL	WT WITH ERROR MESSAGE
;MSGEXIT	EQU	$	
;EXIT W/"INFORMATIONAL" MSG
ERXIT	POP	D	;GET MSG
	MVI	C,PRINT
	CALL	BDOS
;
;EXIT, RESTORING STACK AND RETURN
;
EXIT	LHLD	STACK
	SPHL
	RET		;TO CCP;
LINEPTR	DW	ADDRESS
NLINES	DB	LINES
BUFPTR	DW	80H
;
	DS	100	;STACK AREA
STACK	DS	2
;
;BDOS/CBIOS EQUATES (VERSION 8)	
;
PRINT	EQU	9
CLOSE	EQU	16
ERASE	EQU	19
WRITE	EQU	21
MAKE	EQU	22
BDOS	EQU	5
FCB	EQU	5CH
 ~#x#x!y~#<+!y~7m  ?	*!w#<D!] >?w#U] mD       COM \  \  2wD  \  ! zڜ\  <*++DONE++$*++WRITE ERROR++$*++BAD CLOSE, D.COM CLOBBERED!!++$ 0:w0\	 *u?	*!w#<D!] >?w#U] mD       C  xc X          Y          Z          PIP     COMSPEED   COMFMAP    COMWM      COMSUB     COMSTAT    COMCV      COMALLOC   COMD       COMLLCAT.COM 2/2/80
$	 !  9"212] !4m !?J!]  !_G6$\  <͊++UNABLE TO OPEN MAST.CAT$	 *2͈)͈͈ë>	 Y	 >2 =ʐ!4?0?0!??0?0!~#:V<2V0:<2:06æ6͈
6͈R#?͈.r,r
r~?G> #g7~?} g> #r*W|=¿\  ʼ͊++READ ERROR OR EARLY EOF$! ~#"W>
>
_  w#6?#͊
$"11 MAST    CAT v;:0w 
á*-*/}|ڊ!  "/*-{z|*+ 
 v */"/H*/"-  !  "/*+*-}>*/#"/ɯ22*! "-"/
 <	 
NO MASTIN FILE$ NAMES   SUB H USE FACTOR
 !/w  "s**}|\!  "*{zN*  H *"*"  !  "**}>*#"ɯ22! "" <ª	 
NO NAMES FILE$ NEW     CAT 	 
NO Mw4 N Y**}|I!  "*{z;*OR IGNORE NAMES.
MAY BE MISSING ) AFTER LAST NAME.$4
4JW:[:B!88ڝE!,8ʋ8!Q/J!8JDEL: $!Q/!MADD: $8!Q/G!6.#6,v!~ )
#:J
.B
BJw#26 #B6#J>2!8d6,#dr6.#r:µ4
{,ʭ.ʭ
ʭʵw#r426 #­6#µ2!~ >0<w:60+!Q~ #>
>
	 FMAP-U 02/20/80
$	 !  9"1!m ^~#
-!] ~ G6?#@>?2h \  <2j<++NOT FOUND$:^Bw D͟:ùFILENAME TYP EX RC #K -----EXTENT-----$\  <=! o*Xw#"X:[<2[í:[!	 s#r#	=:[2\=/2]:\=22\/!͵##:=2:]!"X:^ ʽBʽ:^U~!jx~#
R:_22:2S2:`22;2T2:\ 2ww w <­<++CAN'T MAKE NAMES FILE$:^U½!b͍ =ʪ*X^#V#"X! ~2Z:^DP`:^M`y:^UG!gR:[=7*X++^#V#N#F
7#!:[=2[*X##"X	 * :^ vBv:Zv*u~l> w#"u%xw ʗ<++WRITE ERROR$! "u>.GÚ>
G>
GÚ^#V#N#F
#ʾ>2]N#F#^q#Vpr+s:^BB<
BIT MAP:
11000000000000000000000000000000
00000000000000000000000000000000
00000000000000000000000000000000
00000000000000000000000000000000
00000000000000000000000000000000
00000000000000000000000000000000
00000000000000000000000000000000
000000000000000000
$VOLUME~__
!~#:V<2V0:<2:06æ6  ͈
6͈R#MAST    CAT     NAME           DISK           NAME           DISK
$............   ............     FILES:                                                                              *"	& 
DISK FULL: MASTOUT$  !  "**#"ɯ22! "!  "  <£	 
NO DIR SPACE: MASTOUT$ MAST    BAK    CAT 	 !j8:-b:] -&:g  
++SERIAL MUST BE 3 DIGITS$^ !,/e !5/x++NO "-NAME.NNN" IN NAMES.SUB
++REISSUE: UCAT -name.nnn$ !,/(!5/4(!v 4w#)4x++TOO MANY IGNORE NAMES FOR TABLE$++NO IGNORE NAMES IN MAST.CAT$++EOF READING F~ _ #>
_ >
_ w#/#8>*}S">G <	t Ë
CANNOT CLOSE MASTOUT$  ò 	w#
£ !
͞!
͞MAST.CAT HAS      ENTRIES.$	   >
>
	 ~ _ #>
  XXXXXXXX.YYY,        .   XXXXXXXX.YYY,XXXXXXXX.YYYXXXXXXXX.YYY,XXXXXXXX.YYY$$$     .SUB)         !_͍!cR͍͠͍:^D,P/yͨ~###~=<G~~# ~y!_ _4y̚#M:W<'2W͟:[=2[½:^ ʠBʠ>F2^:W:^Bʸ ʸ>$2D:^ B2Z>Gxw FILES,     K$GI
'Ú
&0_:^F=B=  	 !R~0<w:60+R>$G>1G> J>$G>2G:^P> J>$G>3G~G(#> (>
(>
( :^ BBBw   !e͍!e6 #6 #60*X++^#V! ~
DESCRIPTION:

NUMBER	SIZE	NAME		COMMENTS

		CATALOG.__	CONTENTS~OF~CP/M~VOL.~__
 	       . 1	000K	CATALOG 00   NAMES   SUB 0000000000000000000                                                                                                         ;COMPARE.ASM
;11/??/77 ORIGINALLY WRITTEN BY WARD CHRISTENSEN
;12/31/77 ADD PICKUP OF SECOND FILENAME IF BLANK
;01/08/77 ADD SEQIO MACLIB TO READ BIG BLOCKS
BSIZE	EQU	4096	;DISK BUFFER SIZE (TIMES 2)
	ORG	100H
	MACLIB	SEQIO
MOVE	MACRO	?F,?T,?L
	MVI	B,?L
	LXI	D,?F
	LXI	H,?T
	CALL	MOVER
	ENDM
;TYPE SINGLE CHAR OR CHAR IN A
TYPE	MACRO	?C
	IF	NOT NUL ?C
	MVI	A,?C
	ENDIF
	PUSH	B
	PUSH	D
	PUSH	H
	PUT	CON
	POP	H
	POP	D
	POP	B
	ENDM
PRINT	MACRO	?L
	LOCAL	Z
	CALL	Z
	IRP	?M,<?L>
	DB	?M
' BOTH FCB'S
;
MOVE2	FILE	INFILE,FILE1,,1,,BSIZE
	FILE	INFILE,FILE2,,2,,BSIZE
;
;COMPARE THE 2 FILES 1 BYTE AT A TIME
;
COMP	CALL	READ1
	MOV	B,A	;SAVE CHAR
	PUSH	B
	CALL	READ2
	POP	B
	CMP	B
	JZ	COMP
;
;FILES UNEQUAL
;
UNEQUAL	PRINT	'FILES UNEQUAL AFTER '
PRBYTES	LXI	D,BYTES
	MVI	C,@MSG
	CALL	@BDOS
	PRINT	<'LAST DATA READ FROM FILE 1:',0DH,0AH>
	LHLD	PRTPTR
	DCR	L
	MVI	B,0
PRTLP	INR	L
	MOV	A,M
	CPI	0DH
	JZ	GOTCR
	CPI	0AH
	JZ	TYPEIT
	CPI	9	;TAB
	JZ	TYPEIT
	CPI	' '
	JC	HEX
	CSHLD	PRTPTR
	PUSH	PSW	;SAVE CHAR
	LXI	H,BYTES+5
READI	MOV	A,M
	ORI	'0'	;IN CASE IT WAS BLANK
	INR	A
	MOV	M,A
	CPI	'9'+1	;TIME TO CARRY?
	JNZ	READNC
	MVI	M,'0'
	DCX	H
	JMP	READI
READNC	POP	PSW
	RET
;
;EOF ON FILE 1 - SET FLAG, READ 2
;
EOF1	MVI	A,'Y'
	STA	EOFLG
	CALL	READ2
	PRINT	<'EOF FILE 1, NOT FILE 2',0DH,0AH>
	JMP	UNEQUAL
;
READ2	GET	FILE2
	RNZ		;NO EOF
;

;GOT EOF ON FILE 2, MUST HAVE GOTTEN IT ON FILE 1
;
EOF2	LDA	EOFLG
	CPI	'Y'
	JZ	AOK
	PRINT	<'EOF FILE 2 BEFORE FILE 1	B
	JNZ	MOVER
	RET
EOFLG	DB	'N'
COL	DB	0
BYTES	DB	'        BYTES',0DH,0AH,'$'
PRTPTR	DW	BUFF
	DS	30	;STACK
STACK	EQU	$
;ORG TO PAGE BECAUSE 'INR L' USED TO LOOP THRU IT
	ORG	($+255) AND 0FF00H ;TO PAGE
BUFF	EQU	$
	REPT	16
	DB	'                '
	ENDM
BUFFERS	EQU	$
MEMSIZE	EQU	BUFFERS+@NXTB
	END
COMPARE.COM 1/8/78
$	 "1:m  8] !m ͶD~#
;!\ R;y!ͼ  G:6QxJ  S*u*w}|!  "w*u{z*s R ¾ *w"wÐ*w"u  !  "w*s*u}>*w#"wɯ2^2r! "u"wR < 	   
NO FILE1 FILE$!l .;U] !m ͶD ~#
;!\ R;  *Q*S}|ڮ!  "S*Q{zҠ*O .  *S"Sl*S"Q  !  "S*O*Q}>*S#"Sɯ2:2N! "Q"S. <	   
NO FILE2 FILE$G	ENDM
	DB	'$'
Z	POP	D
	MVI	C,@MSG
	CALL	@BDOS
	ENDM
;
;COMPARE.ASM - COMPARES 2 FILES
;
;COMMAND FORMAT: COMPARE NAME1 NAME2
;	IF NAME2 = NAME1 BUT IS ON B DISK,
;	JUST TYPE: COMPARE NAME1 B:
;
	PRINT	<'COMPARE.COM 1/8/78',0DH,0AH>
;
;INIT STACK
;
	POP	H	;GET CP/M RET ADDR
	SHLD	EXIT+1	;MODIFY RETURN ADDR
	LXI	SP,STACK	;GET MY STACK
;
;IF THE SECOND FCB IS BLANK,
;MOVE IN THE NAME FROM THE FIRST
;
	LDA	@TFCB+17
	CPI	' '
	JNZ	MOVE2	;NOT BLANK
	MOVE	@TFCB+1,@TFCB+17,11
;
;'DECLAREPI	7FH
	JNC	HEX
TYPEIT	TYPE
	LDA	COL
	INR	A
	STA	COL
	CPI	60
	JC	NEXT
	XRA	A
	STA	COL
	PUSH	B
	PUSH	H
	PRINT	<0DH,0AH>
	POP	H
	POP	B
	JMP	NEXT
GOTCR	XRA	A
	STA	COL
	MVI	A,0DH
	JMP	TYPEIT
HEX	PUSH	PSW	;SAVE CHAR
	TYPE	'('
	POP	PSW
	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	NIBBL
	POP	PSW
	CALL	NIBBL
	LDA	COL
	ADI	3
	STA	COL
	MVI	A,')'
	JMP	TYPEIT
NEXT	DCR	B
	JNZ	PRTLP
	JMP	EXIT
;
;READ BYTE FROM FILE 1
;
READ1	GET	FILE1
	JZ	EOF1	;GOT EOF?
	LHLD	PRTPTR
	MOV	M,A
	INR	L
	',0DH,0AH>
	JMP	UNEQUAL
;
;A-OK - FILES MATCH
;
AOK	PRINT	'FILES MATCH, LENGTH IS '
	LXI	D,BYTES
	MVI	C,@MSG
	CALL	@BDOS
;NOTE THE FOLLOWING DOES NOT RESTORE CP/M'S
;STACK POINTER, BUT THAT IS 'OK' BECAUSE THE
;FIRST INSTRUCTION IN CP/M IS A LXI SP
EXIT	JMP	$-$	;CP/M RET ADDR (MODIFIED)
ERXIT	POP	D	;GET MESSAGE
	MVI	C,@MSG
	CALL	@BDOS
	JMP	EXIT
NIBBL	ANI	0FH
	CPI	10
	JC	NUM
	ADI	7
NUM	ADI	'0'
	TYPE
	RET
;MOVE FROM (DE) TO (HL) LENGTH IN B
MOVER	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR4!FILES UNEQUAL AFTER $	 	 PLAST DATA READ FROM FILE 1:
$	 *- ,~
ʨ
w	w ڱұ_ :<2<2͝
$	 2>
w>(_ ͜͜:2>)w\Ð|*w,"!~0<w:60+>Y24+EOF FILE 1, NOT FILE 2
$	 	X:Yg^EOF FILE 2 BEFORE FILE 1
$	 	͂FILES MATCH, LENGTH IS $	 	   	 Ð
ڥ0_ w#¶N         BYTES
$ 2>)w\Ð|*w,"!~0<w:6                                                                                                                                                                                                                                                                > 2~22+2.(/.COM AS OF 10/16/79
$	 U!  9"1>>! ~ʐ2Q#~ O ~ʐ~;ss#bx:Q<2Q> ~#Y"Rô*Rv~ʤ!Q4Ð*R++(w#0 0 <7:QG=2Q!^  0 #0 <    ++CLOSE FAILED++$++WRITE ERROR$++$++CAN'T MAKE SUBMIT FILE++$^k>:j*R# ^O
ʵw#jÂ+>jÂ6 j>
j#"Rpɯ+y~jÂ>jÂ6
# ~
ʂj#>^j>CK AS OF 10/29/78
$	 !  9"1:m 2m]  ʝ <_T++FILE NOT FOUND$	 *b! ,m.*ko| g"ka:m _>
U>
U_»T++MUST CK A: OR CK B:$=G * 0 "!   xT++DONE++$=T
*++DISK READ ERROR$>
U>
U:l8:k8T= FILE CKSUM
$:m ,JJ> U
S0_ \                       =N#Fy} 80*z{¯ #z+++
¥ 
z #½ # 
· 
9 !`͠ 
y9 !rͷ 		----FMAP.COM----
AUTHOR:
	Ward Christensen

OVERVIEW:
	Prints a sorted list of files on disk, with their
size in records and K, and a map of the allocation groups
where the file resides.  Optionally writes the selected
names to a file.  Improvement over earlier FMAP in that
the additional extents after the 1st are printed, and also
for the new options: B, M, P, U.

USAGE:
	FMAP			Maps the logged in disk
	FMAP A:			Maps disk A (Etc)

Ambiguous references are allowed:
	
	FMAP A:*.ASM		etc.q"uiet i.e. no list)
FMAP A: D
	$1 $2fn.ft $3	  e.g. submit names type b:
					    $1   $2
FMAP A: M
	$1 $2 $3fn.ft (for use with SUBMIT and my MODEM
	 program)  e.g. submit names modem so.600 b: 
				     $1    $2     $3
FMAP A: P
	$1 $2fn.ft$3 (for use with submit, and PIP, where $2 is
	the disk, and $3 is typically the "[V]" option).
FMAP B: Unn
	Creates "CATALOG.nn" on the B: disk, which is the
	skeletal CP/M Users Group catalog, with headings,
	serial numbers, the # of K, and alphabeticalUjv>
j>
j	   *A: /  $$$     SUB AN'T MAKE SUBMIT FI                                             

FMAP can also produce a bit map of disk allocation.  Each
bit is printed as a 0 if no file is allocated to that 1K
block or a 1 if a file is allocated, or even a 2 or more if
due to disk errors more than 1 file are allocated to the
same block.  This is a B option:

	FMAP A: B

	The following all create a file called "NAMES.SUB" ON
the logged in disk.  The comments after the command show what
is written to NAMES.SUB

FMAP A: F
	fn.ft to NAMES.SUB (also lists to console)
FMAP A: Q
	fn.ft ("ly sorted
	names.  (Just thought you might be interested)

DEPENDENCIES:
	64 directory entries.  1.3 or 1.4 only.  Probably
gets mixed up by the high bits on in the filenames in 2.0.
CAT2.ASM 1/20/80
$	 !  9"1e͠!1#!/A!?#!1? ͬ;!?1 ͡5sMAST    CAT ] ͡\  <++NO MAST.CAT++$ʻ) ʻ
­++EARLY EOF++$!(͸#.,7w#6 #ɯ2M^  3# #:M~:M<2Mʻ
l_ P,  	 2M
             $~#x¡#x¬^#V#N#Fx#~G#~#fo>  }ƀo| g+~+The text which follows was excerpted from a personal letter
written by Sam Singer describing the changes he has made to
UCSD pascal.  It is was the only documentation available at
the time users group disks were released.  The software
described herein is still under development by Mr. Singer and
he was understandably reluctant to release it as it is not
'polished' at this time.  It is the opinion of this reviewer
that it is more important to get these ideas out into the
public domain than to shelte'M GOING TO MODIFY PGEN SOON SO THAT PBOOT IS PART OF IT AND
YOU WON'T HAVE TO MAKE A LOT OF SEPARATE ASSEMBLIES. THERE ARE COMMENTS
AT THE BEGINNING OF BOOTER THAT DESCRIBE THE SYSTEM BUT NOT IN MUCH
DETAIL YET. BASICALLY THE SYSTEM SUPPORTS 4 FORMATS AND UP TO 4 DRIVES
ON LINE. (ITS EASY TO ADD MORE IF YOU LIKE)
	THE KEY TO MAKING THE THING AUTOMATIC OR SEMI ANYWAY IS THE
FORMAT CODE ON THE DISK WHICH LETS THE SYSTEM FIGURE OUT WHAT KIND
OF DISK YOU HAVE. BY THE WAY I'D SURE LIKE TO GET A STANDARD POSSIBLY OH HARD OR SOFT SECTOR, 5" OR 8" BUT THESE ARE
NOT REALLY NECESSARY AND GET TOO COMPLICATED. THE NUMBER OF SECTORS
PER TRACK IS GENERALLY SET TO THE MAXIMUM YOU CAN GET ON A DISK RELIABLY
SO THIS REALLY SHOULDN'T BE A VARIABLE (BUT IT IS).

	ALL DISKS AR WRITTEN WITH TRACK 0 SIDE 1 IN STANDARD IBM 3740
FORMAT. THE REST OF THE DISK IS UP FOR GRABS. SINCE THE FIRST SECTOR
ON TRACK 0 IS NORMALLY A BOOT LOADER I RESERVED THE LAST BYTE FOR THE
FORMAT CODE. ACTUALLY THE LAST TWO BYTES ARE AVAILAB MORE CONVENIENT FOR ONE CONTROLLER IS A LITTLE
LESS FOR THE OTHERS BUT NOT MUCH. TO INDICATE A DOUBLE SIDED DISK I JUST
TURNED ON THE HIGHEST BIT IN THE FORMAT BYTE. SO....

	20H	STANDARD IBM 3740 FORMAT
	10H	128 BYTE SECTORS DOUBLE DENSITY (NOT SUPPORTED BY PASCAL)
	22H	512 BYTE SECTOR SINGLE DENSITY
	12H	512 BYTE SECTORS DOUBLE DENSITY
	92H	512 BYTE SECTORS DOUBLE DENSITY DOUBLE SIDED

	TOSS IT AROUND A BIT, WHAT DO THE CHICAGO PEOPLE THINK?

	ANYWAY TO CONTINUE, THE BOOTER PROGRAM PINIT PARTw+++ø#~g}o|g~+p+q	 *ɴ  \ 
        .             .                                                        r them until they are perfected.
Unfortunatly, at present they are most usefull to tinkerers.

	I'M WORKING ON GETTING PASCAL RUNNING MORE EASILY ON DIFFERENT
SYSTEMS. I'TS
FAR FROM COMPLETE BUT THE SYSTEM RUNS WELL AS IT IS AND THE IDEAS SHOULD
BE USEFUL TO THOSE WHO LIKE TO TINKER. THERE ARE THREE FILES.

	PGEN.ASM    THIS IS THE OLD PGEN WITH JUST SOME COMMENTS ADDED
	PBOOT.ASM   A BOOT LOADER FOR TARBELL OR DELTA CONTROLLERS
	BOOTER.ASM  THIS IS A COMBINATION OF THE OLD PINIT AND A BIOS.

	IESTABLISHED
FOR THESE CODES. I'VE GOT DELTA TO GO ALONG WITH MY CODES. REMEMBER
CP/M 2.0 WILL SUPPORT ANY NUMBER OF FORMATS JUST LIKE PASCAL WILL SO
ITS BECOMMING INCREASINGLY IMPORTANT. THERE IS NOTHING MAGIC ABOUT THE
CODE I USED AND I'M NOT EMOTIONALLY TIED TO IT BUT WE DO NEED A STANDARD.
THE CODE MUST SPECIFY THREE THINGS.
	1. THE SECTOR SIZE
	2. THE DENSITY
	3. THE TYPE OF DISK IE. SINGLE OR DOUBLE SIDED

THE STANDARD MIGHT ALSO INCLUDE OTHER THINGS LIKE THE NUMBER OF SECTORS
PER TRACK AND LE. THE LITTLE BOOT
PROM ON THE TARBELL AND DELTA CONTROLLERS JUMPS TO 7DH WHEN ITS DONE
SO YOU HAVE THE LAST TWO BYTES LEFT.
	I MADE THE RIGHT 4 BITS THE SECTOR SIZE CODE AND JUST USED THE
CODES THE 1771 AND 1791 ALREADY USE. 0=128 BYTES, 1=256 BYTES 2=512 BYTES
ETC. THE LEFT 4 BITS ARE THE DENSITY CODE 1=DOUBLE AND 2=SINGLE. THESE
ARE THE CODES ALREADY USED BY THE DELTA CONTROLLER. THE TARBELL CONTROLLER
DOES ITS DENSITY SELECT DIFFERENTLY. IT DOESN'T MUCH MATTER WHAT THE
CODE IS. WHAT IS A LITTLE POLLS ALL THE
DRIVES. A DRIVE NOT READY (OR NOT THERE) WILL NOT BE INCLUDED.
IF A DRIVE IS READY TRACK ZERO SECTOR 1 IS READ AND THE FORMAT CODE IS
CHECKED. TABLES ARE INITIALIZED APPROPRIATELY. THE SYSTEM PRINTS
A MESSAGE INDICATING THE NUMBER OF DRIVES BEING USED AND THE DISK FORMAT
OF EACH DRIVE AND THEN LOADS THE INTERPRETER AND TAKES OFF AS BEFORE.
	I'V BEEN RUNNING IT DOUBLE DENSITY RECENTLY AND ITS VERY FAST.
I CAN TRANSFER 48K BYTES PER SECOND (6 TRACKS). COMPILATION SPEED
ON A LARGE PROGRAM IS ABOUT 675 LINES A MINUTE. 4MHZ Z-80.
YOU ESPECIALLY NOTICE IT COPYING FILES OR LOADING PROGRAMS. FOR INSTANCE
THE FILER LOADS IN LESS THAN A SECOND. BY THE WAY THE PASCAL MICRO ENGINE
HAS MUCH FASTER INTERNAL COMPUTATION SPEED BUT MUCH SLOWER I/O. SINCE
MOST OPERATIONS ARE I/O BOUND ANYWAY THE ADVERTIZED 5 TO 6 SPEED INCREASE
IS A BUNCH OF CRAP. I HAVEN'T ACTUALLY TIMED COMPILATION TIME FOR A LARGE
PROGRAM ON IT BUT IT TAKES THE SYSTEM ABOUT 4 SECONDS TO LOAD THE FILER.
THERE IS NO EASY SOLUTIONTHE SWITCHES
IN PBOOT FOR SINGLE DENSITY 128 BYTE SECTORS AND REASSEMBLE IT. SET THE
SIZE OF THS SYSTEM IN PGEN AND REASSEMBLE THEN PUT IT ALL TOGETHER WITH
DDT OR SID. THE SEQUENCE GOES SOMETHING LIKE:

	DDT PGEN.COM
	IPBOOT.HEX
	R900
	IBOOTER.HEX
	R1380
	^C
	SAVE 32 PGEN128.COM

	THE OFFSET OF 1380 IS FOR A 64K SYSTEM WITH THE BIOS STARTING
AT 0FA00H. YOU WILL HAVE TO FIGURE OUT THE PROPER OFFSETS FOR OTHER SIZES.
YOU CAN DO IT BY TRIAL AND ERROR EVEN SINCE THE BOOTER-PINIT CODE STARTS
AT G THE SWITCHES IN THE INCLUDE FILE.
AFTER ASSEMBLY YOU HAVE TO RELOCATE THE PROGRAM TO 100H WITH THE RELOCATOR
RELOC.CODE. PUT THIS INTERPRETER RENAMED SYSTEM.MICRO ON A PASCAL DISK
WRITE THE BOOTER ON IT WITH PGEN128 AND OFF YOU GO. ONCE YOU HAVE A 128 BYTE
SYSTEM RUNNING FORMAT A DISK WITH 512 BYTE SECTORS AND JUST COPY THE
FILES TO IT WITH PASCAL . THE ONLY REQUIREMENT IS THE PROPER FORMAT CODE
AND THE SYSTEM IS TRANSPARENT.
	KNOWN ERRORS. I DON'T HAVE THE CODE COMPLETED FOR DOUBLE SIDED
DRIVES. Documentation of various original programs written
by Ward Christensen

		----CK-FIX.COM----
OVERVIEW:
	Program to print a checksum of a file - used to
tell if two files are the same.  N-O-T-E the previous version
distributed to many people had a BUG whereby it didn't really
work.  Something like an ADD L instead of an ADD M (??).  

USAGE:
	Suggest renaming this back to just CK.COM after you
have properly disposed of any earlier versions.

	CK fn.ft		to produce a total file cksum.

	CK fn.fDocumentation of various original programs written
by Ward Christensen

		----CV.ASM----
OVERVIEW:
	A split screen video compare program for use with
the VDM or other memory mapped video boards.  Consists of
two hard-coded scroll routines, one for each half (top/bottom)
of the VDM.  Allows independently scrolling each half, or
doing a "full speed" file-file compare.

USAGE:
	CV fn1.ft1 fn2.ft2

Chars to press to run:

	TOP	BOTT	----Function----

	Y	H	CONTINUOUS SCROLL
	U	J	1 LINE SCROLL
 TO THE PROBLEM EITHER. THEY DO ALL THERE I/O
USING PASCAL AND ITS JUST NOT FAST ENOUGH.
	DFOCO ALREADY PUTS THE FORMAT CODES I MENTIONED ON THE DISK. IF
THE PASCAL SYSTEM DOESN'T RECOGNIZE A CODE IT DEFAULTS TO STANDARD 3740
FORMAT SO YOU STAY COMPATABLE. TO BRING UP THE SYSTEM FIRST SET THE
CONDITIONAL ASSEMBLY SWITCHES FOR YOUR SYSTEM IN BOOTER AND ASSEMBLE IT.
I'M PRETTY SURE THE PERSCI STUFF WON'T WORK YET, I HAVEN'T FINISHED DEBUGGING
IT BUT I WILL BECAUSE MY CURRENT CUSTOMER HAS A PERSCI. SET 980H WHEN PROPERLY LOADED WITH DDT. JUST CLEAR MEMORY LOAD BOOTER WITH
DDT AND SEE WHERE IT GOES! THE BOOT ALWAYS GOES TO 900H AS BEFORE.
	YOU ALSO NEED ANOTHER INTERPRETER (Sorry, not available
at users group release time -- ed.).
BECAUSE THIS ONE IS A LITTLE
DIFFERENT. THE SYSTEM VARIABLES STORED BELOW 100H ARE IN A DIFFERENT PLACE.
THE BIOS ALSO USES THIS AREA FOR TEMPORARY STORAGE TO SAVE MEMORY.
YOU CAN ASSEMBLE AN INTERPRETER WITH OR WITHOUT FLOATING POINT AND
TRANCENDENTAL FUNCTIONS BY SETTINTREATING THEM LIKE MULTIPLE SINGLE SIDED DRIVES WON'T WORK SINCE
THE TRACK POSITION TABLE WON'T GET SET RIGHT. ITS AN EASY FIX BUT I HAVEN'T
DONE IT YET. I HAVE RUN THREE FORMATS (NO DOUBLE SIDE) WITH THREE DIFFERENT
CONTROLLERS WITH NO PROBLEMS AT ALL.

t d		to see a detailed (sector-by-
				sector) cksum and the total.

Ex:

A>ck-fix b:ck-fix.doc d
CK AS OF 10/29/78
F3 98 D7 56 6F
03 27 = FILE CKSUM

A>
	I	K	4 LINE SCROLL
	O	L	7 LINE SCROLL

	    C		SCROLLS CONTINUOUSLY,
			COMPARING THE FILES
			STOPS ON A MIS-COMPARE.
	
	    Q		QUITS (EXITS) THE PROGRAM.
			(MUST BE USED.  CTL-Z IN THE
			FILE COULD BE AN ERROR, SO CV
			STOPS BUT YOU MUST EXPLICITLY Q)

DEPENDENCIES:
	VDM or other memory mapped video board.  "Could"
be modified for 24x80.  Works as is if you have a VDM
at CC00H.


Documentation of various original programs written
by Ward Christensen

		-----D.COM-----
OVERVIEW:
	Tells what's different in the directory from when it
was last set.

USAGE:
D		Lists what has been added or deleted since
			last D SET.
D SET		"Registers" all current file names into D.COM
D ADD fn.ft	"Registers" a single name
D DEL fn.ft	Deletes a single name

	D.COM usage: For example, if you have a "system" disk,
you might like to "keep it clean", but it has a way of filling
up, and it's Documentation of various original programs written
by Ward Christensen

		----DU.ASM----
OVERVIEW:
	Originally written to reconstruct erased directories,
or directories where info was overlaid.  Thus allows dumping,
by group, track, sector, filename, etc. and patching.  Allows
ascii or hex scan of the disk.  Maps the location of files
on the disk by group.  You should know the format of a CP/M
disk if you're going to diddle with DU.

USAGE:
	DU.ASM provides an overview of the file.  DU has a
b;PRINTER EJECT ROUTINE	1/20/80 BY WARD CHRISTENSEN
;
;	To eject 1 or more pages of paper in your printer
;assuming that a control-L will eject a page.
;
;	EJECT		to eject 1 page.
;	EJECT n		to eject 1 to 9 pages
;
;DEPENDENCIES:
;	Uses the CP/M list device call - the list device
;must eject a page when a control-L (form feed) is received.
;
	ORG	0100H
;
FFCHR	EQU	'L'-40H	;FORM FEED CHAR
BDOS	EQU	5
FCB	EQU	5CH	;PICK UP PARM FROM FCB+1
;
	LDA	FCB+1	;A NUMBER REQUESTED?
	CPI	' '
	JZ	NEWPAGEnot trivial to tell what's different, when just 
doing a directory listing.  If you do a D SET on your disk
when it's the way you want it, then a week later, do "D"
(no operands) D.COM will tell you what's been added, and
what's been erase since the last setting.

DEPENDENCIES:
	You may NOT rename D.COM to something else because
D.COM erases itself ahd writes itself back, in order to not
have to use a separate file for the registered names.

uilt in help function ? which tells the format of all
commands.

DEPENDENCIES:
	"Standard CP/M 8" disks" - i.e. 77 tracks,
directory at track 2.  Standard CP/M scramble factor
(but could be changed in the .ASM file) etc.  It also works
on such disks as Northstar CP/M 1.4 which the excellent
Lifeboat BIOS make "look" like full sized disks in terms of
sector/track etc.

	;NO, JUST DO ONE, RET TO CP/M
	ANI	0FH	;HACK BACK TO NUMBER
	MOV	B,A	;B = # OF PAGES
	JNZ	PAGELP	;MAKE SURE NOT 0
	MVI	B,1	;DEFAULT TO 1 PAGE
PAGELP	CALL	NEWPAGE	;EJECT ONE PAGE
	DCR	B	;MORE PAGES?
	JNZ	PAGELP	;..YES, LOOP
	RET		;..NO, RETURN TO CP/M
;
;HERE IS AN EJECT ROUTINE FOR 1 PAGE. 
;	WAITS FOR PRINTER READY FIRST.
;
NEWPAGE	PUSH	B
	MVI	E,FFCHR	;CTL-L (FORMS FEED)
	MVI	C,5	;WRITE LIST DEV
	CALL	BDOS	;SEND IT
	POP	B
	RET		;RET TO CALLER (CP/M OR PAGELP)
