 POW     ASM   	

 POW     ASM  <         POWCMDS POW   "            POWTEXT POW                   SCRAMBLEASM   0!"#$%&           SCRAMBLEDOC   '(               TED     DOC   )*+,-./012345678 TED     DOC  79:;<=>?          TED     COM   @ABCDEFGHIJKLMNO TED     COM  P                TOP     AZM   MQRSTUVWXYZ       TOP     TOP   [\]              TOP     PRN   "^_`ab            XREF    ASM   cdefghijklmnopqr XREF    ASM  )stuvwx           UGFORM        !yz{|}           ;
;POW FROM DR. DOBBS JOURNAL NO. 29, PAGE 20
;
;....POW....
;30 JULY 79....MODS FOR CP/M
;BY BOTTER REEVES...LOY NAVA CO. LTD.
;1229/27 NEW ROAD, BANGKOK 5, THAILAND
;233-4193


;DEC 16-30,  1977 :
;MODIIED FOR FDOS JUN 3,1978
;SELECTRIC MODS JUNE 15,1978
;TOTAL JUSTIFICATION FIXED JULY 20, 1978
;
;
;BY HERMAN WATSON
;P.O. BOX 341401
;CORAL GABLES, FLA 33134
;
;
;
;THE FOLLOWING IS THE JAZZED UP VERSION FOR FDOS
;WITH INSTRUCTION PRINTOUT AT THE BEGINNING
;
	ORG	100H	;START LOC FORM NUMBER 0-15

RAND	LXI	H,RNDV
RND1	MOV	A,M
	RLC
	INR	A
	RLC
	RLC
	XRA	M
	MOV	M,A
	ANI	0FH
	RET


;CONVERT TABS TO CORRECT POSITION

TBST	LDA	LPOS
	MOV	C,A
	LXI	D,TTAB
;SEARCH TTAB FOR NEXT GREATEST LOCATION
TBLP	LDAX	D
	INX	D
	CMP	C
	JZ	TBLP
	JNC	GOTB
	CPI	0
	JNZ	TBLP
;NO MORE TABS IN TABLE
	JMP	CLOS
;GOT GOOD TAB, UPDATE POINTERS
GOTB	LXI	H,RMAR
	CMP	M
	JNC	CLOS
PUTB	STA	LPOS
	LXI	H,OBUF
	CALL	ADAH
	SHLD	LADR
	RET


;CONVERT ASCII NUMBER TO BINARY
;ADDRESS IN HL ON	MOV	M,A
	INX	H
	DCR	C
	JNZ	NEWA
	LXI	H,OBUF	;COMPUTE LEFT MARGIN ADDR
	LDA	LMAR
	CALL	ADAH
	SHLD	LADR
	LDA	LMAR	;SET POSITION COUNTER
	STA	LPOS
	LXI	H,OBUF	;COMPUTE RIGHT MARGIN ADDR
	LDA	RMAR
	CALL	ADAH
	SHLD	LEND
	MVI	M,CR	;EOL AT RIGHT
	RET


;FORMATTED OUTPUT
;CALL WITH LETTER IN A
;HANDLES LEFT OR TOTAL JUSTIFICATION

FMAT	CPI	9	;TEST TAB
	JZ	TBST
	CPI	CR	;TEST CARG RETRN
	JNZ	LFTS
	MVI	A,' '	;REPLACE CR WITH SPACE
LFTS	CPI	LF	;IGNORE LINE FEEDS
	RZ
	CPI	' '
	JNZ	RFMT

 COM FILE
START	LXI	SP,STACK
	LXI	H,STMSG
	CALL	TXTYP
	JMP	MAIN


STMSG	DB	'...PROCESSOR OF WORDS FOR 8080',0DH,0AH
	DB	'THE COMMANDS ARE AS FOLLOWS',0DH,0AH
	DB	'  "P" = PRINT',0DH,0AH
	DB	'  "L" = LOAD',0DH,0AH
	DB	'  "Q" = QUIT',0DH,0AH
	DB	'  CTRL C WILL ABORT',0DH,0AH
	DB	'ENTER COMMAND $'


;UTILITY ROUTINES

;ADD A TO HL

ADAH	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET

;TEST DE .EQ. HL
;RETURN ZERO IF SO

TDHE	MOV	A,D
	CMP	H
	RNZ
	MOV	A,E
	CMP	L
	RET


;GENERATE PSEUDORANDO ENTRY, SAVED IN APNT ON EXIT
;RETURN WITH VALUE IN HL

ADEC	PUSH	H
	POP	B
	LXI	H,0
ADE1	LDAX	B
	CALL	NMCK	;CHECK FOR DECIMAL NUMBER
	JC	ADE2
	INX	B
	MOV	D,H
	MOV	E,L
	DAD	H
	DAD	H
	DAD	D
	DAD	H
	SUI	48
	MOV	E,A
	MVI	D,0
	DAD	D
	JMP	ADE1
	ADE2	PUSH	B
	XTHL
	SHLD	APNT
	POP	H
	RET


;CHECK FOR DECIMAL NUMBER IN ASCII

NMCK	CPI	'0'
	RC
	CPI	'9'+1
	CMC
	RET



;INITIALIZE OBUF FOR NEW FORMATTED LINE

NEWL	LXI	H,OBUF	;FILL WITH SPACES
	LDA	MAXL
	MOV	C,A
	MVI	A,' '
NEWA;IF HERE, EITHER LEFT OR TOTAL JUST. SO ALLOW
;NO SPACES AT THE LEFT OF THE LINE
	LXI	H,LMAR
	LDA	LPOS
	CMP	M
	RZ		;AT START, SO STAY THERE
	MVI	A,' '	;OK TO KEEP SPACE
RFMT	LHLD	LADR	;NOW PLACE LETTER IN OBUF
	MOV	M,A
	INX	H
	SHLD	LADR
	LXI	H,RMAR	;CHECK IF OBU FULL
	LDA	LPOS
	INR	A
	STA	LPOS
	CMP	M
	RC


;OBUF FULL. ASSUME LEFT JUST.
;BACK UP TO SPACE AND SAVE OVERFLOW
;DE=TEMP ADDRESS
;C=CHAR COUNT
;HL=OBUF ADDRESS

	MVI	B,30	;MAX AMOUNT TEML CAN HOLD
	MVI	C,0	;TEML CHAR COUNT
	LXI	D,TEML
	LHLD	LADR
	MVI	M,CR	;EOL IN CASE NOT POSSIBLE
;LOOP BACK TO FIRST SPACE (WITHIN 30 LETTERS
;AND WITHOUT HITTING LEFT MARGIN)

LJBU	DCX	H
	MOV	A,M
	CPI	' '
	JZ	LJFN
LJRT	STAX	D
	INX	D
	INR	C
	DCR	B
	JZ	OUTL
	JMP	LJBU
LJFN	DCX	H
	MOV	A,M
	INX	H
	CPI	' '
	JZ	LJRT
	MOV	A,C
	STA	TCNT	;SAVE CHAR COUNT
	LDA	LPOS	;BACK UP LPOS
	SUB	C
	STA	LPOS
	MOV	C,A	;DON'T GO PAST NEW PARA TAB
	LDA	BRTB	;FOR UNMODIFIED INDENTION
	SUB	C	;TO THAT TAB POSITION
	JNC	OUTL	;TERMS NOT MET
	SHLS RANDOM) AND CONTINUE
;PADDING EACH OCCURRANCE OF A GROUP
;OF SPACES UNTIL THE TWO POINTERS ARE EQUAL
;TO EACH OTHER


TOTL	CALL	RAND	;INIT SFLP
	STA	SFLP
	LHLD	LEND
	XCHG
	LHLD	LADR
	LDA	LPOS
	MOV	C,A
	MVI	B,0	;MAKE SURE SP IS FOUND
;DE .EQ. HL MEANS PAD DONE


	CALL	TDHE
	JZ	OUTL

;RIGHT AND PAD

RITE	MOV	A,M	;PICK UP FROM LEFT
	STAX	D	;STORE AT RIGHT
	CPI	' '	;TEST PICKED UP CHAR
	JNZ	WORD
	MVI	B,1	;NOTE THAT SP WAS FOUND
	LDA	SFLP	;TST IF WE CAN INSERT YET
	ORA	A	;TEST FOR Z
	CPI	CR
	JNZ	LEFT
	XRA	A	;TEST IF ONE SP FOUND
	ORA	B
	JZ	OUTL	;NOPE, NOT ONE SP FOUND
	JMP	RITE

;OUTPUT A COMPLETE FORMATTED LINE FROM OBUF

OUTL	LXI	H,OBUF	;OUT TO CR
OUTM	MOV	A,M
	INX	H
	CPI	CR
	JZ	EOL
	CALL	OUTC
	JMP	OUTM
EOL	CALL	NEWL	;CLEAN OBUF
	LDA	SPAS	;PROCESS SPACING
	MOV	C,A
EOLP	CALL	CRLF
	LDA	PPOS	;UPDATE TEXT PAGE POSITION
	INR	A
	STA	PPOS
	LXI	H,PLEN
	CMP	M
	JNC	EOXP
	DCR	C
	JNZ	EOLP
	JMP	RSTR
EOXP	CALL	NEXP	;NEED A NEW PAGE!

;RESTORE OVERFLOW FROM TEML
;IFMT	CPI	9	;TEST TAB
	JZ	TBST
	CPI	LF	;IGNORE LINE FEEDS
	RZ
	CPI	CR	;TEST CARG RETURN
	LHLD	LADR
	MOV	M,A	;INSERT AS EOL
	JZ	OUTL
	INX	H
	SHLD	LADR
	LXI	H,RMAR	;TEST IF FULL
	LDA	LPOS
	INR	A
	STA	LPOS
	DCR	A
	CMP	M
	RC


;HERE, OBUF IS FULL SO FORCE CR AND CONTINUE

	LHLD	LADR
	MVI	M,CR
	JMP	OUTL


;OUTPUT OBUF IF ANYTHING IN IT

CLOS	LXI	H,LMAR
	LDA	LPOS
	CMP	M
	RZ
	RC
	LHLD	LADR
	MVI	M,CR
	JMP	OUTL

;OUTPUT BOTTOM OF PAGE, THE DIVIDER, AND
;THE TOP OF THE NEXT PAGE

OPN	;EQUAL LINE FOR MSG OUTPUT?
	CMP	C
	CZ	TMSG	;YES, PRINT IT
	CALL	CRLF
	DCR	C
	JNZ	NPTL
NPXT	XRA	A
	STA	PPOS
	RET
BMSG	LDA	PAGN	;NO MSG ON FIRST PAGE
	CPI	2
	RC
	MOV	A,C
	STA	TSTG	;SAVE PRESENT LINE COUNT
	LHLD	BOTA	;GET BOTM MSG ADDRESS
	LDA	BOTT	;AND TAB POSITION

;DIRECTLY OUTPUT MESSAGE LINE TO PRINTER
;DOES NOT USE OR DESTROY OBUF AND ITS CONTENTS

TNTR	MOV	C,A
	LDA	CASE
	PUSH	PSW
BMAL	MVI	A,' '	;SPACE OVER TO TAB
	CALL	OUTC
	DCR	C
	JNZ	BMAL
BMSL	MOV	A,M	;OUTPUT THE MESSAGD	LADR
	MVI	M,CR	;NEW EOL


;TEST HERE IF LEFT JUST. OR TOTAL JUST.
;0=NO JUST.
;1=LEFT ONLY
;2=TOTAL JUST.
;BY THE WAY, AT THIS POINT LEFT JUST.
;IS COMPLETE ALREADY

	LDA	JFLG
	CPI	1
	JZ	OUTL
	CPI	2
	JNZ	OUTL

;TOTAL JUST. AT THIS POINT
;MOVE LINE TO RIGHT, AND PAD
;IF LMAR REACHED, PUSH LINE LEFT AND
;PAD AGAIN UNTIL DONE
;(HL) .GE. (DE), SO DE IS RIGHT OF HL, AND WHEN
;DE .EQ. HL, THE PADDING IS DONE

;BEGIN AT LAST CHAR AND SHOVE RIGHT
;START PADDING AT THE SFLP SPACE
;(SFLP IERO
	JZ	PADD	;CAN'T INSERT YET
	DCR	A
	STA	SFLP
	JMP	WORD	;NOT YET
PADD	LDA	LCHR	;CHECK IF GROUP OF SPACES
	CPI	' '	;DON'T ALLOW THIS COND.
	JZ	WRD1
	MVI	A,' '	;PADDING DONE HERE
	DCX	D
	STAX	D
	CALL	TDHE
	JZ	OUTL
WORD	MOV	A,M
	STA	LCHR
WRD1	DCX	D	;REST OF RIGHT AND PAD LOOP
	DCX	H
	DCR	C
	LDA	BRTB	;ALLOWS INDENTION
	CMP	C
	JZ	LEFT	;HIT INDENTATION
	LDA	LMAR	;OR LEFT MARGIN
	CMP	C
	JNZ	RITE	;CAN STILL PROCEED

;PUSH LEFT AND TRY AGAIN

LEFT	INX	D
	INX	H
	INR	C
	LDAX	D
	MOV	M,ANTO OBUF STARTING AT LMAR
RSTR	LXI	D,TCNT
	LDAX	D
	ORA	A
	RZ
	LXI	H,TEML-1
	MOV	C,A
	DCR	C
	CALL	ADAH
	MOV	A,M
	CPI	' '	;PREVENT FIRST BEING SPACE
	MOV	A,C
	STAX	D
	JZ	RSTR

;FIRST NOT SPACE

	INR	C
	LDA	LMAR
	ADD	C
	STA	LPOS
	XCHG
	LHLD	LADR
RSTL	LDAX	D
	MOV	M,A
	DCX	D
	INX	H
	DCR	C
	JNZ	RSTL
	SHLD	LADR
	XRA	A
	STA	TCNT
	RET


;UNFORMATTED OUTPUT ROUTINE
;EQUIVALENT TO FMAT, BUT NO JUSTIFICATION
;IF TEXT EXCEEDS RMAR, THEN A CR IS FORCED AND A
;NEW LINE IS STARTED

U
NEXP	LDA	BLEN	;GET BOTTOM LENGTH
	ORA	A
	JZ	DVDR	;NO BOTTOM PLEASE
	MOV	C,A
NPBL	LDA	BOTN	;CHECK IF AT LINE FOR MSG OUT
	CMP	C
	CZ	BMSG	;YES, OUTPUT IT
	CALL	CRLF
	DCR	C
JNZ	NPBL

;DETERMINE IF LAST PAGE IN FILE

	LDA	EOT
	ORA	A
	RZ		;ZERO SAYS EOF ENCOUNTERED

;START A NEW PAGE NOW

;OUTPUT WARNING TO CONSOLE AND WAIT FOR "GO"

DVDR	LXI	H,PAGMS
	CALL	TXTYP
	CALL	ECHO1
	CALL	CI
	LXI	H,PAGN
	INR	M
NEWP	LDA	TLEN	;GET TOP LENGTH
	ORA	A
	JZ	NPXT	;NO TOP PLEASE
	MOV	C,A
NPTL	LDA	TE
	INX	H
	CALL	CAPR	;DO CASE PROCESSING
	JC	BMSL	;IGNORE LAST CHAR
	CPI	':'	;SUBSTITUTE THE PAGE NUMBER
	CZ	BIND	;AT OCCURANCE OF COLON
	CPI	CR
	JZ	BMXT
	CALL	OUTC
	JMP	BMSL
BMXT	STA	PPOS
	POP	PSW
	STA	CASE
	LDA	TSTG	;RESTORE LINE COUNT
	MOV	C,A
	RET


;OUTPUT TOP OF PAGE MESSAGE (SEE BMSG)

TMSG	LDA	PAGN
	CPI	2
	RC
	MOV	A,C
	STA	TSTG
	LHLD	TOPA
	LDA	TOPT
	JMP	TNTR

;BINARY TO DECIMAL CONVERT CONTNTS OF A REG
;DIRECT OUTPUT TO PRINTER,COMPLETE WITH ZERO
;SUPPRESSION

BIND	MVI	E,0
	LDA	PAGN
	MVI	C,100
	CALL	BIDA
	MVI	C,10
	CALL	BIDA
	ADI	'0'
	RET
BIDA	MVI	B,'0'-1
	INR	B
	SUB	C
	JNC	BIDA+2
	ADD	C
	MOV	D,A
	MOV	A,B
	CPI	'0'
	JNZ	BINZ
	MOV	A,E
	ORA	A
	MOV	A,D
	RZ
BINZ	INR	E
	MOV	A,B
	CALL	OUTC
	MOV	A,D
	RET

;COMMAND DECODER AND PRINT LOOP
;THIS IS THE MAIN TEXT AND WORD PROCESSING LOOP
;HERE, WE GET THE NEXT CHAR FROM TEXT AND SEE
;IF A COMMAND, OR PROCESSED TEXT

PRIN	LHLD	APNT	;SOURCE TEXT POINTER
PRLP	MOV	A,M
	INX	H
	CPI	3
	JC	EOF
	CPI	':'	E PROCESSING SUBROUTINE
;RETURN WITH CARRY SET IF CHAR IS TO BE
;IGNORED. (IE WAS A SHIFT COMMAND)

;CHECK IF SHIFT OR UNSHIFT COMMAND

CAPR	CPI	5EH	;CONTROL N
	JZ	UCAS
	CPI	5CH	;CONTROL L
	JZ	LCAS

;CHECK AND PROCESS UPPER AND LOWER CASE

	MOV	B,A
	LDA	CASE
	CPI	3
	JZ	CASX	;ZERO	SAYS SHIFT LOCKED UP

;LAND HERE, EITHER SINGLE SHIFT OR LOWER CASE
;TEST FOR SINGLE SHIFT

	CPI	1	;1=SINGLE SHIFT
	MVI	A,0	;Z FLAG STILL PRESERVED
	STA	CASE	;CLEAR IT ANYWAY
	JZ	CASX	;ZERO SAYS SINGLE SHIFT


;COLON WAS ENCOUNTERED IN TEXT
;THIS TESTS NEXT TWO CHARACTERS
;AGAINST ALL COMMANDS TO FIND COMMAND
;AND CALL IT

CMND	MOV	B,M
	INX	H
	MOV	C,M
	INX	H
	SHLD	CEPT	;POINTS TO DELIMITER
	LXI	H,CTAB

;LOOP TO FIND MATCH

CLOP	MOV	A,M
	INX	H
	ORA	A
	JZ	CRTN
	CMP	B
	JZ	ONEM
;HERE FIRST LETTER FAIL
	INX	H
	INX	H
	INX	H
	JMP	CLOP
;HERE FIRST LETTER MATCH
ONEM	MOV	A,M
	INX	H
	CMP	C
	JZ	TWOM
;HERE SECOND LETTER FAIL
	INX	H
	INX	H
	JMP	CLOP
;COMMAND MATCH

TWOM	MOV	E,M	;LOAD ADNTERACTIVE PORTION OTHER THAN DIALOG
;ADDED FOR FDOS. ALLOWS 'L' OR 'P' OR 'Q' ONLY
;LOAD OR PRINT OR QUIT

MAIN	CALL	ECHO1
	LXI	H,PROMPT
	CALL	TXTYP
	CALL	CI	;GET CHAR FROM CONSOLE
	MOV	C,A
	CALL	ECHO1
	MOV	A,C
	CPI	'L'
	JNZ	MAIF

;LOAD FROM DISC OR TAPE

	JMP	FDIN

PROMPT	DB	'...$'

MAIF	CPI	'P'
	JNZ	MAIQ

;PROCESS TEXT AND EMBEDDED COMMANDS

	LXI	H,TEXT
	SHLD	APNT
	CALL	CLOS
	CALL	NEWL
	JMP	PRIN

MAIQ	CPI	'Q'
	JNZ	MAIN	;IF NOT L,P,OR Q LOOP

;RETURN TO MONITOR

	JMP	REDB'
	DW	DBRK
	DW	'BP'
	DW	BRKP
	DW	'NP'
	DW	NPAG
	DW	'CM'
	DW	MIDC
	DW	'PN'
	DW	SETP
	DW	'SP'
	DW	SPAZ
	DW	'PT'
	DW	PGTP
	DW	'PB'
	DW	PGBT
	DW	'TM'
	DW	TMES
	DW	'BM'
	DW	BMES
	DW	'PG'
	DW	FPAG
	DW	'CC'
	DW	CEND
	DW	'OF'
	DW	OPOF
	DW	'ON'
	DW	OPON
	DB	0

;TERMINATE A COMMAND
;CR,COMMA,SPACE, OR NOTHING ARE OK

CTRM	LHLD	APNT
	MOV	A,M
	INX	H
	SHLD	APNT
	CPI	CR
	RZ
	CPI	' '
	RZ
	CPI	','
	RZ
	DCX	H
	SHLD	APNT
	RET

;FIND DELIMITER WITHIN A COMMAND
;SPACE AND COMMA;COLON=BEGINNING OF COMMAND
	JZ	CMND
	CALL	CAPR	;DO CASE PROCESSING
	JC	PRLP	;LETTER WAS TO BE IGNORED
	MOV	B,A

;TEST IF DIRECT OUTPUT OF NEXT CHAR

	CPI	5BH	;CONTROL K?
	JNZ	PROC	;NO
	MOV	B,M	;OUTPUT WITHOUT QUESTION
	INX	H
PROC	LDA	JFLG	;PROCESS A LETTER
	ORA	A
	MOV	A,B
	SHLD	APNT
	JZ	NOFM
	CALL	FMAT	;EITHER LEFT OR TOTAL JUST.
	JMP	PRIN
NOFM	CALL	UFMT	;NO JUSTIFICATION
	JMP	PRIN
EOF	CALL	CLOS	;CLOSE PENDING LINE
	XRA	A
	STA	EOT
	CALL	NPAG
	MVI	A,0FFH
	STA	EOT
	JMP	MAIN

;CAS

;LAND HERE, LOWER CASE COND
;TEST IF IT IS ALPHA

	MOV	A,B
	CPI	'A'
	JC	CASX	;NOT ALPHA
	CPI	'Z'+1
	JNC	CASX	;NOT ALPHA

;LAND HERE, CONVERT TO LOWER CASE
	MVI	A,20H
	ORA	B
	MOV	B,A

;EXIT WITH CARRY BIT CLEAR

CASX	ORA	A
	MOV	A,B
	RET
;PROCESS UNSHIFT OR LOWER CASE MODE

LCAS	XRA	A
	JMP	NOLCK 

;PROCESS SHIFT (EITHER SINGLE OR SHIFT LOCK)

UCAS	LDA	CASE
	CPI	1
	JZ	LOCK
	MVI	A,1	;SINGLE SHIFT
	JMP	NOLCK
LOCK	MVI	A,3
NOLCK	STA	CASE
	STC		;SET CARRY, IGNORE LETTER
	RET

DR
	INX	H
	MOV	D,M
	LHLD	CEPT
	SHLD	APNT	;POINTING AT DELIMITER
	LXI	H,PRIN	;SET UP RETURN
	PUSH	H
	XCHG
	PCHL		;GO TO COMMAND ROUTINE


;FAILED TO MATCH A COMMAND, SO PRINT TEXT

CRTN	LHLD	APNT
	MOV	B,M
	INX	H
	JMP	PROC

;TAPE INPUT ROUTINE

FDIN	CALL	INIR
	LXI	H,TEXT
TPLP	CALL	GBYT
	MOV	M,A
	INX	H
	JNC	TPLP	;NO EOF FOR FDOS

;FOR TAPE, I WOULD CHECK FOR VALUE LESS THAN 3
;IE BINARY 1=EOF FOR TAPE
;AND CARRY SET = EOF FROM FDOS

	DCX	H
	MVI	M,1
	JMP	MAIN


;THIS IS THE ISTRT

;ECHOS ON CONSOLE AND OUTS CRLF

ECHO	CALL	CO
ECHO1	PUSH	B
	MVI	C,CR
	CALL	CO
	MVI	C,LF
	CALL	CO
	POP	B
	RET

;OUTPUT CARG RTRN AND LINE FEED TO PRINTER
;RETURNS WITH CR IN A

CRLF	MVI	A,CR
	CALL	OUTW
	MVI	A,LF
	CALL	OUTW
	MVI	A,CR
	RET

;THE COMMAND TABLE IN SYS-8 FORMAT
;IE TEXT LETTERS HAVE REVERSED ORDER

CTAB	DW	'DM'
	DW	DMAR
	DW	'DT'
	DW	DTAB
	DW	'PL'
	DW	DPAG
	DW	'JT'
	DW	TOTJ
	DW	'JE'
	DW	ENDJ
	DW	'JL'
	DW	LEFJ
	DW	'CT'
	DW	CENT
	DW	'LF'
	DW	LNFD
	DW	' ARE ACCEPTED

CDEL	LHLD	APNT
	MOV	A,M
	INX	H
	CPI	','
	RZ
	CPI	' '
	RZ
	DCX	H
	RET

;CLOSE OR END CENTER TAB COMMAND

CEND	CALL	OUTL
	JMP	CTRM

;IMMEDIATELY FORCE A PAGE START

FPAG	CALL	DVDR
	JMP	CTRM

;DEFINE MARGINS. LEFT, RIGHT

DMAR	CALL	GARG
	STA	LMAR
	STA	BRTB	;SET THAT TOO
		CALL	GARG
	STA	RMAR
	CALL	CLOS
	CALL	NEWL
	JMP	CTRM

;DEFINE TABS. TAB1,TAB2,TAB3, ETC. TO 14

DTAB	LXI	H,TTAB
	SHLD	TBAD
DTBL	CALL	CDEL
	JNZ	DTBX
	CALL	ADEC
	MOV	A,L
	LHLD	TBAD
	MOV	M,A
	INX	H
	SHLD	TBAD
	JMP	DTBL
DTBX	LHLD	TBAD
	MVI	M,0
	JMP	CTRM

;SET TOTAL JUSTIFICATION MODE

TOTJ	MVI	A,2
	STA	JFLG
	JMP	CTRM

;SET LEFT JUSTIFICATION MODE

LEFJ	MVI	A,1
	STA	JFLG
	JMP	CTRM

;CLOSE PRESENT LINE AND SET TO NO JUST. MODE

ENDJ	XRA	A
	STA	JFLG
	CALL	CLOS
	JMP	CTRM

;CENTER TAB, TAB, MESSAGE TO BE CENTERED

CENT	CALL	GARG	;GET TAB
CENA	STA	CETM
	CALL	CDEL
	JNZ	CTRM
	SHLD	CEPT
	CALL	CLOS
CENP	MVI	C,0
	LHLD	CEPT

;COUNT CHARS IN MESSAGE

CECC	MOV	A,M
	IPAG	CALL	GARG
	STA	PLEN
	JMP	CTRM

;LINE FEED COMMAND (IGNORE ZERO LF'S)

LNFD	CALL	GARG
	STA	CETM
	CALL	LFDO
	JMP	CTRM

;DO LINE FEEDS AND KEEP TRACK OF POSITION ON PAGE.
;IF NEW PAGE, REST OF LF COMMAND IS FORGOTTEN

LFDO	CALL	CLOS
	LDA	CETM
	ORA	A
	RZ
	MOV	C,A
LFLP	CALL	CRLF
	LDA	PPOS
	INR	A
	STA	PPOS
	LXI	H,PLEN
	CMP	M
	JNC	NEXP
	DCR	C
	RZ
	JMP	LFLP

;DEFINE A PARAGRAPH BREAK.  LF'S, TAB

DBRK	CALL	GARG
	STA	BRLF
	CALL	GARG
	STA	BRTB
	JMP	CTRM

;BREAK FOR A NEW PARATA	PAGN
	JMP	CTRM

;SET SPACING

SPAZ	CALL	GARG
	STA	SPAS
	JMP	CTRM

;DEFINE TOP OF PAGE LENGTH AND ITS LINE OF OCCUPANCE

PGTP	CALL	GARG
	STA	TLEN
	CALL	GARG
	STA	TOPN
	JMP	CTRM

;DEFINE BOTTOM SAME AS ABOVE

PGBT	CALL	GARG
	STA	BLEN
	CALL	GARG
	STA	BOTN
	JMP	CTRM

;SET TOP MESSAGE ADDRESS AND THE MESSAGE TAB

TMES	CALL	GARG
	STA	TOPT
	CALL	CDEL
	JNZ	CTRM
	SHLD	TOPA
TMLP	MOV	A,M
	INX	H
	CPI	CR
	JNZ	TMLP
	SHLD	APNT
	RET


;SET BOTTOM MSG ADDRESS AND MESSAGE TAB

BMECALL	BDOS
	POP B! POP D! POP H
	RET

;SEND A CHARACTER TO THE PRINTER

PO	PUSH H! PUSH D! PUSH B
	MOV	E,C
	MVI	C,5	;LIST OUT FUNCTION
	CALL	BDOS
	POP B! POP D! POP H
	RET

;GET CHAR FROM CONSOLE

CI	PUSH H! PUSH D! PUSH B

	MVI	C,1
	CALL	BDOS
	POP B! POP D! POP H
	RET

;TYPE A LINE OF TEXT ON CONSOLE

TXTYP	PUSH H! PUSH D! PUSH B
	XCHG
	MVI	C,9
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET

;INPUT A LINE OF TEXT FROM CONSOLE

TXTIN	PUSH H! PUSH D! PUSH B
	LXI	D,CONBUF+65
	MVI	C,6ALL	ECHO1	;CRLF TO CONSOLE
	LXI	H,GREET
	CALL	TXTYP
	CALL	TXTIN
	CALL	ECHO1	;CRLF TO CONSOLE
	LXI	H,CONBUF+2	;+2 FOR COUNTS
	LXI	D,INFCB		;  A LA CP/M FORMAT
	CALL	MTFCB	;LIB ROUTINE TO MAKE FCB
	JC	INIR	;ERROR, TRY AGAIN
	CALL	OPENF	;FCB OK, OPEN IT
	JC	INIR	;ERROR, TRY AGAIN
	LXI	H,INBUF+128	;INIT. FOR DISKIN
	SHLD	INPTR
	RET

GREET	DB	'ENTER FILE NAME  ',0DH,0AH,'$'


;PRINTER OUTPUT

OUTC	CPI	CR
	JZ	CRLF
OUTW	PUSH	B
	ANI	7FH
	MOV	C,A
	LDA	OPST	;TEST IF OUTPUT ON
	ORA	A
	CNZ	PONX	H
	CALL	CAPR	;DO CASE PROCESSING
	JC	CECC	;LETTER IS TO BE IGNORED
	INR	C
	CPI	CR
	JNZ	CECC

;COMPUTE POSN OF FIRST LETTER OF MESSAGE

	MOV	A,C
	ORA	A
	RAR
	MOV	C,A
	LDA	CETM
	SUB	C

	SHLD	APNT	;POINTS PAST MESSAGE
MOVL	LXI	H,OBUF	;COMPUTE LADR FOR MESSAGE
	CALL	ADAH
	XCHG
	LHLD	CEPT	;START OF MESSAGE ADDRESS
CEMV	MOV	A,M	;MOVE IT TO OBUF
	INX	H
	CALL	CAPR	;DO CASE PROCESSING AGAIN
	JC	CEMV	;LETTER TO BE IGNORED
	CPI	CR
	RZ
	STAX	D
	INX	D
	JMP	CEMV

;DEFINE PAGE LENGTH

DGRAPH

BRKP	CALL	CLOS	;CLEAR LINE
	LDA	PPOS	;GET PAGE POSITION
	ORA	A
	JZ	BRKT	;NO LF AT TOP OF PAGE
	LDA	BRLF
	STA	CETM
	CALL	LFDO
BRKT	LDA	BRTB
	CALL	PUTB
	JMP	CTRM

;FORCE BOTTOM PRESENT PAGE AND START NEW ONE

NPAG	LDA	PAGN
	ORA	A
	JZ	DVDR
	CALL	CLOS
	CALL	NEWL
	LDA	PLEN
	STA	CETM
	CALL	LFDO
	JMP	CTRM

;CENTER MIDDLE (BETWEEN MARGINS), MESSAGE

MIDC	LDA	RMAR
	LXI	H,LMAR
	SUB	M
	RAR		;DIVIDE BY TWO
	ADD	M
	CALL	CENA
	STAX	D
	JMP	OUTL

;PAGE NUMBER

SETP	CALL	GARG
	SS	CALL	GARG
	STA	BOTT
	CALL	CDEL
	JNZ	CTRM
	SHLD	BOTA
	JMP	TMLP

;TURN OFF PRINTER OUTPUT

OPOF	XRA	A	;ZERO TURNS OFF OUTPUT
	STA	OPST	;MARK AT OUTPUT SYATUS
	JMP	CTRM

;TURN ON PRINTER

OPON	MVI	A,0FFH	;NON-ZERO MEANS ON
	STA	OPST	;MARK AT STATUS
	JMP	CTRM

;GET THE NEXT ARGUMENT

GARG	CALL	CDEL
	JNZ	GARE
	CALL	ADEC
	MOV	A,H
	ORA	A
	MOV	A,L
	RZ
GARE	POP	H
	JMP	CTRM

;
;I/O ROUTINES

;CONSOLE INPUT OF CHARACTER (ECHOS TOO)

CO	PUSH H! PUSH D! PUSH	B
	MOV	E,C
	MVI	C,2
	5	;CLEAR BUFFER TO SPACES
	MVI	A,' '
TXTN1	STAX	D
	DCX	D
	DCR	C
	JNZ	TXTN1
	MVI	C,10
	CALL	BDOS
	POP B! POP D! POP H
	RET

;OPEN FILE

OPENF	LXI	D,INFCB
	MVI	C,15	;CPM FUNCTION FOR OPEN
	CALL	BDOS
	CPI	255	;FAILED TO OPEN IF = 255
	CMC
	RNZ
	LXI	H,NOFMS	;FILE NOT FOUND MSG
	CALL	TXTYP
	STC
	RET

NOFMS	DB	'FILE NOT FOUND$'

;GET A CHARACTER FROM DISK FILE

GBYT	PUSH	H
	CALL	DISKIN	;LIB ROUTINE TO GET BYTE
	POP	H	;   FROM DISK FILE
	RET

;INITIALIZE TO READ DISK FILE

INIR	C	;ON IF NON-ZERO
	CALL	CSTS
	ORA	A
	CNZ	ABTST	;KEY PRESSED ON CONSOLE
	MOV	A,C
	POP	B
	RET

;TEST FOR ABORT (CNTRL C)

ABTST	CALL	CI
	CPI	3
	RNZ		;NOPE
	JMP	RESTRT	;RETURN TO CP/M

;CONSOLE STATUS CHECK...RETURNS A NON-ZERO
;   IF KEY PRESSED AT CONSOLE

CSTS	PUSH H! PUSH D! PUSH B
	MVI	C,11
	CALL	BDOS
	POP B! POP D! POP H
	RET
;++++++++++++++++++++++++++++++++++++++++++++++
;
; MAKE CP/M FILE CONTROL BLOCK
;
; MAKEFCB.LIB  -  VERSION 0.2  -  28 OCT 77
;
; JEFFREY W. SHOOK
; P.O. BOX 185
; ROCKY POINT, NEW YORK 11778
; (516) 744 7133
;
;++++++++++++++++++++++++++++++++++++++++++++++


; CREATE A CP/M FILE CONTROL BLOCK  FROM
; A COMMAND STRING AT THE ADDRESS IN HL
; AND PLACE IT AT THE ADDRESS IN DE.  RETURN
; WITH THE CARRY SET IF AN ERROR OCCURS.


; DEFINITIONS

FCBSIZ:	EQU	33
FNMLEN:	EQU	11	; FILE NAME LENGTH


MTFCB:	PUSH	H	; SAVE CMD STRING PTR
	PUSH	D	; SAVE FCB ADDRESS
	
	LXI	B,FCBSIZ; CLEAR ENTIRE FCB AREA
	MVI	A,0	;
	CALL	FILLB	;

	POP	D	; FILLV	A,M	; TEST FOR FILE TYPE SEPARATOR
	INX	H	;
	CPI	'.'	;
	JNZ	MTFCB2	;

	MVI	C,3	; PROCESS FILE TYPE FIELD
	CALL	GETNAM	;
	MOV	A,M	;
	INX	H	;

MTFCB2:	CALL	TERMT	; TEST FOR CORECT TERMINATOR

	RET


; PROCESS NAME FIELD

GETNAM:	MOV	A,M	; GET CHAR FROM CMD STR
	INX	H	;

	CPI	'?'	; ALLOW AMBIG REFERENCE CHAR
	JZ	GETNA1	;

	CPI	'*'	; FILL REST WITH ?
	JZ	GETNA2	;

	CALL	VALCHR	; TEST FOR ALLOWED CHAR IN NAME
	JC	GETNA3	;

GETNA1:	STAX	D	; STORE CHAR IN TFCB
	INX	D	;

	DCR	C	; CRY SET IF INVALID.

TERMT:	CPI	' '
	RZ

	CPI	','
	RZ

	CPI	CR
	RZ

	CPI	';'
	RZ

	STC
	RET


; SKIP SPACES IN CMD STRING

SKIPS:	MVI	A,' '
SKIPS1:	CMP	M
	RNZ
	INX	H
	JMP	SKIPS1


; FILL BLOCK WITH VALUE

; ENTER WITH:
; A  = VALUE FOR FILL
; DE = START OF BLOCK
; BC = LENGTH OF BLOCK

CLRB:	MVI	A,0

FILLB:	INR	B
	DCR	B
	JNZ	FILLB1
	INR	C
	DCR	C
	RZ

FILLB1:	STAX	D

	INX	D
	DCX	B
	JMP	FILLB



;++++++++++++++++++++++++++++++++++++++++++++++
;
; SEQUENTIAL  POINTER IN
;	   THE FILE CONTROL BLOCK MUST BE
;	   SET TO ZERO.
;	5) THE WORD AT LOCATION INPTR
;	   MUST BE SET TO INBUF+128 TO
;	   MARK THE BUFFER AS EMPTY.
;	6) TO READ A FILE AGAIN, JUST SET
;	   NEXT RECORD TO ZERO, AND
;	   RESET INPTR.

; READ CHARACTER FROM FILE

DISKIN:	LHLD	INPTR	; TEST BUFFER POINTER
	LXI	D,-(INBUF+128)
	DAD	D
	MOV	A,H
	ORA	L
	CZ	RDREC	; IF EMPTY, READ NEXT RECORD
	RC		; RETURN ON BAD READ
	LHLD	INPTR	; GET CHAR FROM BUFFER
	MOV	A,M
	INX	H	; MOVE BUFFER POCP/M SET DMA ADDRESS FUNCTION
CR	EQU	13
LF	EQU	10
EOT	DB	0FFH	;LAST PAGE PRINTED IF ZERO
OPST	DB	0FFH	;OUTPUT ON OR OFF STATUS
TSTG	DB	0	;TEMP STORAGE FOR BMSG
CASE	DB	3	;UPPER CASE LOCK INITIALLY
SFLP	DB	0	;FLOP FOR EVERY RND SPACE
RNDV	DB	5AH	;SEED FOR RANDOM NUMBER
LCHR	DB	0	;LAST CHAR FOR TOTAL JUST.
CETM	DS	1	;CENTR TAB OR CHAR COUNT
CEPT	DS	2	;CENTR TEXT POINTER
LMAR	DB	10	;LEFT MARGIN
RMAR	DB	70	;RIGHT MARGIN
TTAB	DB	15	;TAB TABLE
	DB	22
	DB	30
	DB	45
	DB	0
	DS	10	;UP TO 15 TABS
T FILE NAME WITH SPACES
	PUSH	D	;
	INX	D	;
	LXI	B,FNMLEN;
	MVI	A,' '	;
	CALL	FILLB	;

	POP	D	; RESTORE POINTERS
	POP	H	;

	CALL	SKIPS	; SKIP LEADING SPACES

	INX	H	; CHECK FOR DISK CODE
	MOV	A,M	;
	DCX	H	;
	CPI	':'	;
	JNZ	MTFCB1	; JUMP ON NO CODE

	MOV	A,M	; TEST IF DISK CODE GOOD
	INX	H	;
	INX	H	;
	SBI	'@'	;
	RC		; MAKE ERROR RETURN IF BAD
	CPI	'Z'+1	;
	CMC		;
	RC		;

	STAX	D	; STORE DISK CODE AT FCB + 0
MTFCB1:	INX	D	;

	MVI	C,8	; PROCESS FILE NAME FIELD
	CALL	GETNAM	;

	MOHECK NAME SIZE
	JNZ	GETNAM	;
	RET		;


GETNA2:	MVI	A,'?'	; FILL REST OF FIELD WITH ?
	MVI	B,0	;
	JMP	FILLB	;

GETNA3:	INX	D	; MOVE FCB PTR TO END OF FIELD
	DCR	C	;
	JNZ	GETNA3	;
	DCX	H	;
	RET		;


; TEST FOR VALID CHAR IN  NAME FIELD
; RETURN WITH CARRY SET IF INVALID.

VALCHR:	CPI	'*'
	CMC
	RZ

	CPI	','
	CMC
	RZ

	CPI	'.'
	CMC
	RZ

	CPI	' '
	RC

	CPI	'^'+1
	CMC
	RC

	CPI	':'
	CMC
	RNC

	CPI	'@'
	RET


; TEST FOR VALID FILENAME TERMINATOR CHAR
; RETURN WITH CARDISK CHARACTER INPUT
;
; DISKIN.LIB  -  VERSION 1.0  -  18 SEP 77
;
; J.W. SHOOK, P.O. BOX 185, ROCKY POINT, NY 11778
;
;++++++++++++++++++++++++++++++++++++++++++++++

; BEFORE READING A FILE SEQUENTIALLY 
; THE FOLLOWING INITIAL CONDITIONS
; MUST BE ESTABLISHED.

;	1) A CP/M FILE CONTROL BLOCK
;	   CONTAINING THE FILE NAME MUST
;	   START AT LOCATION INFCB.
;	2) A 128 BYTE BUFFER AREA MUST
;	   START AT LOCATION INBUF.
;	3) THE FILE MUST BE SUCCESSFULLY
;	   OPENED.
;	4) THE NEXT RECORDINTER
	SHLD	INPTR
	RET


; REFILL DISK INPUT BUFFER

RDREC:	LXI	D,INBUF	; SET DMA ADDRESS
	MVI	C,SDMA
	CALL	BDOS
	LXI	D,INFCB	; READ A RECORD
	MVI	C,READ
	CALL	BDOS
	RAR		; SET CARRY ON BAD READ
	LXI	H,INBUF	; SET POINTER TO BUFFER START
	SHLD	INPTR
	RET

;MESSAGE FOR TELLING OPERATOR ABOUT NEW PAGE

PAGMS	DB	'PRESS ANY KEY WHEN READY FOR NEW PAGE$'

;DEFINE VARIABLES

RESTRT	EQU	0	;CPM REBOOT
BDOS	EQU	5	;CP/M ENTRY FOR I/O
READ	EQU	20	;CP/M READ NEXT RECORD FUNCTION
SDMA	EQU	26	;BAD	DS	2	;TAB TABLE POINTER
SPAS	DB	1	;SPACING
PLEN	DB	45	;PAGE LENGTH
BRLF	DB	1	;NEW PARAGRAPH LF'S
BRTB	DB	15	;NEW PARAGRAPH TAB
TLEN	DB	10	;TOP LENGTH
PAGN	DB	0	;PAGE NUMBER
TOPN	DB	0	;MSG LINE NUMBER
BOTN	DB	0	;MESSAGE LINE NUMBE
TOPA	DS	2	;MSG ADDR
BOTA	DS	2	;MSG ADDR
TOPT	DB	10	;TOP TAB
BOTT	DB	10	;BOTTOM TAB
BLEN	DB	10	;BOTTOM LENGTH
LPOS	DB	1	;LINE POSITION
PPOS	DB	1	;PAGE POSITION
JFLG	DB	0	;NO JUST. INITIALLY
LADR	DS	2	;LPOS ADDR
LEND	DS	2	;RIGHT MARGIN ADDRESS
APNT	DS	2	;INPUT POINTER
MAXL	DB	135	;MAXIMUM LINE LENGTH
TCNT	DB	0	;OVERFLOW CHAR COUNT
TEML	DS	30	;OVERFLOW BUFFER
OBUF	DS	136	;OUTPUT BUFFER
INBUF	DS	128	;DISK FILE INPUT BUFFER
INFCB	DS	33	;FILE CONTROL BLOCK
CONBUF	DB	64	;CONSOLE INPUT BUFFER
	DB	0
	DS	64
INPTR	DS	2	;POINTER FOR DISKIN0V
	DS	32
STACK
TEXT	END		;TEXT BUFFER STARTS HERE

MOV	C,A
	LDA	CASE
	PUSH	PSW
BMAL	MVI	A,' '	;SPACE OVER TO TAB
	CALL	OUTC
	DCR	C
	JNZ	BMAL
BMSL	MOV	A,M	;OUTPUT THE MESSAG:PN,0
:DM,15,65
:DB,1,15
:PT,5,0
:PB,5,0
:PL,55
:JT
:PG
:CM,^^"POW"  SPECIAL CHARACTERS FOR CONTROL\
:BP
^CONTROL ^K PRECEDING A CHARACTER CAUSES THAT CHARACTER TO BE
PRINTED AS IT APPEARS WITH NO DECODING. ^THIS IS USED FOR EXAMPLE
TO PRINT A COLON WHICH IS NORMALLY USED TO INDICATE A COMMAND
FOLLOWING AND THUS IS NOT PRINTED. ^SO, ^^CNTRL K\: WOULD CAUSE
THE PRINTING OF THE COLON.
:BP
^ (^^ASCII 5E)\ IS USED TO INDICATE UPPER CASE SHIFT. ^IF
ONLY ONE IS USED THEN ONLY THE CHARACTER IMME5\
:BP,^DEFINE PAGE LENGTH (^THE TEXT PORTION) TO BE 45 LINES LONG.
:BP
:CM,^^:JT\
:BP,^BEGIN TOTAL JUSTIFICATION MODE WITH AUTOMATIC SPACE FILLING.
:BP
:CM,^^:JE\
:BP,^CLOSE PRESENT LINE AND END ALL JUSTIFICATION.
:BP
:CM,^^:JL\
:BP,^BEGIN LEFT ONLY JUSTIFICATION MODE.
:BP :CM,^^:CT,POSITION,TEXT\
:BP,^CENTER THE TEXT ABOUT THE POSITION (COUNTING FROM THE LEFT
OF THE PAGE, NOT THE MARGIN) THAT IS SPECIFIED. ^NOTE: ^THE LINE
IS NOT PRINTED UNTIL THE :^^CC\ COMMAND IS ENCOUNTERED.
:BP :CM,:^TH THIS COMMAND. ^THE PROGRAM CLOSES THE PRESENT LINE,
THEN DOES THE SPECIFIED NUMBER OF LINE FEEDS, AND THEN 
INDENTS TO THE SPECIFIED POSITION.(^SEE COMMAND :^^DB\ BELOW.)
:BP :CM,^^:DB,1,15\
:BP,^DEFINE THE PARAGRAPH BREAK TO BE A NUMBER OF LINE FEED'S
(DEFAULT = 1) AND AN INDENTION TO THE POSITION SPECIFIED.
(^DEFAULT = LEFT MARGIN.) ^THE INDENTION CAN BE SET AT ANY
POSITION EITHER TO RIGHT OR LEFT OF THE LEFT MARGIN.
:BP
:CM,^^:NP\
:BP,^NEW ^PAGE. ^FORCES THE CLOSE OF THE PRESENT PAGE,FEEDS
ES LONG, WITH THE TITLE ON  LINE ^N. ^IF ^N IS ZERO,
THEN NO TITLE IS PRINTED.^^ LF\ CAN ALSO BE ZERO FOR A 
COMPLETELY FILLED PAGE.
:BP :CM,^^:PB,LF,N\
:BP,^DEFINE THE PAGE BOTTOM. ^SEE :^^PT\ ABOVE.
:BP :CM,^^:TM,POS,TEXT\
:BP,^DEFINE THE TOP OF PAGE MESSAGE (IE THE TITLE). ^IT WILL
BE PRINTED AT ^^POS\ AND ^^TEXT\ WILL BE THE MESSAGE.
FOR PAGE NUMBERING, A COLON WILL BE REPLACED BY THE CURRENT
PAGE NUMBER WHEN FOUND IN THE ^^TEXT\. :BP
^EXAMPLE:":^^TM,45,PAGE\-:-" WOULD CAUSE THE TOP MESSAGDIATELY
AFTER IT IS UPPER CASE. ^IF TWO ARE USED, THEN ALL ALPHABETIC 
CHARACTERS ARE UPPER CASE UNTIL THE DOWNSHIFT CHARACTER
\ (^^ASCII 5C)\ IS ENCOUNTERED ARE UPPER CASE. ^THERE IS NO
EFFECT ON NON-ALPHABETIC CHARACTERS.
:BP
:CM,^^"POW" COMMANDS AND DEFAULT VALUES\
:BP
:CM,^^:DM,10,70\
:BP,^DEFINE MARGINS, LEFT MARGIN, RIGHT MARGIN
:BP
:CM,:^^DT,15,22,30,45\
:BP,^DEFINE TABS UP TO A MAXIMUM OF 14 TABS. ^TABS MUST BE
IN ASCENDING ORDER AND NO ERROR CHECKING IS DONE ON THEM.
:BP
:CM,^^:PL,4^CC\
:BP,^CLOSE CENTERING COMMAND. ^THIS COMMAND ^^MUST\ BE
ISSUED AFTER THE LAST :^^CT\ COMMAND.
^THIS CLOSES THE OUTPUT LINE.
:BP
:CM,^^:LF,"N"\
:BP,^LINE ^FEED THE PAGE UP "N" TIMES. ^THIS IS ACTUALLY A
^^CR-LF\ SEQUENCE TO THE PRINTER "N" TIMES.
:BP :CM,^^:BP\
:BP,^BREAK FOR A NEW PARAGRAPH. ^SINCE CARRIAGE RETURNS ARE 
CONVERTED TO SPACES DURING EITHER TOTAL OR LEFT
JUSTIFICATION, IT IS NECESSARY TO BE ABLE TO SPECIFY THE
BEGINNING OF A NEW PARAGRAPH WHILE IN THESE MODES. ^THIS IS
DONE WI
IT OUT OF THE PRINTER, AND THEN BEGINS A NEW PAGE.
:BP :CM,^^:CM,TEXT\
:BP,^AUTOMATICALLY CENTERS THE TEXT BETWEEN THE LEFT
MARGIN AND RIGHT MARGIN. ^THIS COMMAND DOES ^^NOT\ NEED TO BE
CLOSED WITH A :^^CC\ COMMAND.
:BP
:CM,^^:PN,0\
:BP,^SETA THE PAGE NUMBER TO THE SPECIFIED VALUE. (MAXIMUM
IS 256)
:BP :CM,^^:SP,1\
:BP,^SET THE SPACING. 1 = SINGLE SPACE, 2 = DOUBLE SPACE,
ETC. ^DEFAULT IS 1 OR SINGLE SPACING.
:BP :CM,^^:PT,LF,N\
:BP,^DEFINE THE TOP OF THE PAGE TO BE ^^LF\ (^DEFAULT = 10)
LINE
TO BE PRINTED 45 SPACES FROM THE LEFT OF THE PAGE AS
"^^PAGE-4-"\ WHEN PAGE 4 IS PRINTED.
:BP :CM,^^:BM,POS,TEXT\
:BP,^DEFINES THE BOTTOM OF PAGE MESSAGE.^SEE :^^TM\ ABOVE.
:BP :CM,^^:PG\
:BP,^IMMEDIATELY FORCES THE BEGINNING OF A NEW PAGE (IT WILL
NOT FINISH THE PRESENT PAGE). ^THIS COMMAND SHOULD BE ALWAYS
GIVEN AT THE BEGINNING OF A NEW TEXT FILE.
:BP :CM,^^:OF\
:BP,^TURNS OFF THE PRINTER. ^THE PROGRAM CONTINUES TO
PROCESS TEXT AS IF IT WERE ON, BUT THERE IS NO OUTPUT.
:BP,:CM,^^:ON\
:BP,^THIS COMMAND WILL TURN ON THE PRINTER AGAIN AFTER
IT WAS TURNED OFF BY THE :^^OF\ COMMAND. ^THIS ALLOWS
A SECTION OF THE TEXT INPUT TO BE SKIPPED OVER WITHOUT
PRINTING.
:JE
:DM,10,75
:DB,2,15
:PT,10,5:PB,10,0
:TM,48,^^POW...-:-
:JT
:PG
:CM,^^....POW....\
:LF,3
:BP,^^POW\ IS A PROGRAM THAT IS A "^PROCESSOR ^OF ^WORDS"
FOR THE 8080 COMPUTER.
^^POW\ MOST CLOSELY
RESEMBLES A PROGRAM CALLED ^^PRINTER\ WRITTEN BY
^CLYDE ^ROBY. ^^POW\ HAS THE ABILITY TO SET MARGINS, TABS,
SPACING, JUSTIFICATION, AND INDENTATION AND IN ADDITION
PROVIDES AUTOMATIC CENTERING, AND AUTOMATIC PAGING WITH TITLES
AND NUMBERING.
:BP,^THIS PROGRAM WORKS ON AN EXISTING FILE THAT HAS BEEN
PREPARMANDS WHEN IT ENCOUNTERS THEM WHILE
PRINTING OUT THE FILE. 
^COMMANDS ALL CONSIST OF THE SAME FORMAT WHICH IS
A COLON IMMEDIATELY FOLLOWED BY A TWO LETTER
COMMAND NAME, THEN A DELIMITER WITH OPTIONAL DATA
FOR THE COMMAND, AND/OR A TERMINATOR. ^DELIMITERS
ARE EITHER A COMMA, OR A SPACE, AND A TERMINATOR
CAN BE EITHER A COMMA, A SPACE, OR NOTHING. ^THIS ALLOWS MAXIMUM
FREEDOM FROM RIGID COMMAND SYNTAX. ^A SAMPLE
OF THE COMMAND FORMAT IS SHOWN BY THE DEFINITION
OF MARGINS::LF,1
:CM,:^^DM\,10,70
:BP;
;Scramble.asm - program to scramble CP/M files
;using an 8 byte password
;
month	equ	3	;last..
day	equ	14	;..modification..
year	equ	79	;..date
;
;Scrambling is done in place, i.e. the file is
;modified on top of itself.  The same password
;used to scramble the file is used to unscramble
;it, using the exact same command.  This is because
;the scrambling code is exclusive-or'ed with the
;data file, and two same exclusive ors result
;in the original value being returned.
;
;Command format:
	DB	?F
?Z	POP	H	;GET FROM
	LXI	B,?Z-?B	;GET LEN
	ELSE
	LXI	H,?F
	ENDIF
	ENDIF
	IF	NOT NUL ?T
	LXI	D,?T
	ENDIF
	IF	NOT NUL ?L
	LXI	B,?L
	ENDIF
	CALL	MOVER
MF	SET	-1	;;SHOW EXPANSION
	ENDM
;
;DEFINE CP/M MACRO - CPM FNC,PARM
;
CPM	MACRO	?F,?P
	PUSH	B
	PUSH	D
	PUSH	H
	IF	NOT NUL ?F
	MVI	C,?F
	ENDIF
	IF	NOT NUL ?P
	LXI	D,?P
	ENDIF
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	ENDM
;
	ORG	100H
	CALL	START
	DB	'SCRAMBLE.COM AS OF '
	DB	'0'+MONTH/10
	DB	'0'+MONTH MOD 10,'/'
	DB	'0'+DAY/1ED WITH SOME TYPE OF EDITOR AND SAVED ON A MASS
STORAGE DEVICE. ^I AM CURRENTLY USING A MODIFIED VERSION
OF ^F. ^J. ^GREEB'S EDITOR THAT WAS PUBLISHED IN ^^DDJ \
^JUNE-^JULY 1976, ALONG WITH ^PERIPHERAL ^VISION'S
FLOPPY DISC OPERATING SYSTEM.
^^POW\ HAS BEEN USED WITH CASSETTE TAPE, AND BY
SUBSTITUTING THE CASSETTE ^^I/O\ ROUTINES FOR THE
^^FDOS I/O\ ROUTINES, IT CAN EASILY BE CONVERTED BACK.
:BP,^COMMANDS ARE FREELY INSERTED INTO THE SOURCE
TEXT WHEN IT IS PREPARED. ^^POW\ WILL REACT TO
THOSE COM,^IN ADDITION TO THE LIST OF COMMANDS, ^^POW\ ALSO
HAS THE ABILITY TO ALLOW THE USE OF AN UPPER AND LOWER
CASE PRINTER WITH AN UPPER CASE ONLY INPUT FILE.
:JE

;
;	scramble filename.type password
;
;where password is any 8 character string which
;is allowable as a file name (i.e. no '.', etc).
;
MF	SET	0	;SHOW MOVE NOT REQUESTED
CF	SET	0	;SHOW COMP NOT REQUESTED
;
;(FROM EQU8.LIB...)
;DEFINE SOME MACROS TO MAKE THINGS EASIER
;
;DEFINE DATA MOVE MACRO: MOVE from,to,length
;	from may be addr, or quoted string
;
MOVE	MACRO	?F,?T,?L
	IF	NOT NUL ?F
	IRPC	?C,?F
?Q	SET	'&?C&?C' ;;TEST FOR QUOTE
	EXITM
	ENDM
	IF	?Q EQ ''''
	LOCAL	?B,?Z
	CALL	?Z
?B0
	DB	'0'+DAY MOD 10,'/'
	DB	'0'+YEAR/10
	DB	'0'+YEAR MOD 10
	DB	0DH,0AH,'$'
START	POP	D	;GET ID
	MVI	C,PRINT
	CALL	BDOS	;PRINT ID
;
;INIT LOCAL STACK
;
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
;
;START OF PROGRAM EXECUTION
;
;SCRAMBLE A WHILE TO MIX UP THE SEED
;
	MVI	H,0	;GET 256 #'S
MIXUP	CALL	PSEURAN	;GET A #
	DCR	H	;MORE?
	JNZ	MIXUP	;LOOP IF SO
;
;SEE THAT THE PASSWORD IS 8 CHARACTERS
;	
	LDA	FCB2+8
	CPI	' '
	JNZ	PWIS8
	CALL	ERXIT
	DB	'++ PASSWORD NOT 8 BYTES ++$'
;
;SAVE THE PASSWORD
;
PWIS8	MOVE	FCB2+1,PASSWD,8
;
;PASSWORD IS 8 BYTES, NOW MAKE SURE NO CHARACTER
;IS REPEATED MORE THAN 2 TIMES
;
	LXI	H,PASSWD
	MVI	B,8	;8 CHARS TO TEST
DUPTEST	CALL	CKDUP	;ABORTS IF 3 = CHARS
	INX	H	;TO NEXT CHAR
	DCR	B
	JNZ	DUPTEST
;
;SEE THAT THE INPUT FILE EXISTS
;
	CPM	OPEN,FCB
	INR	A	;OK?
	JNZ	SCRAMLP	;YES, SCRAMBLE IT
	CALL	ERXIT
	DB	'++NO SUCH FILE++$'
;
;READ THE FILE, SCRAMBLE A SECTOR, RE-WRITE IT.
;
SCRAMLP	CALL	RDSECT	;READ A SECTOR
	JC	FINISH	;EXIT LOER WORK..
	JNZ	EXIT
	DB	'++ CLOSE ERROR - FILE LEFT IN '
	DB	'UNKNOWN CONDITION ++$'
;
;SECTOR READ ROUTINE
;
RDSECT	CPM	READ,FCB
	ORA	A
	RZ		;ALL OK
;
;READ ERROR OR EOF
;
	CPI	1	;EOF?
	STC		;CARRY SHOWS EOF
	RZ		;RET, CARRY SET
	CALL	ERXIT
	DB	'++ READ ERROR - FILE MAY BE '
	DB	'DESTROYED ++$'
;
;SCRAMBLE THE SECTOR
;
SCRAMBL	LXI	H,80H	;POINT TO SECTOR
SCRLP	CALL	PSEURAN	;GET PSEUDO RANDOM #
	XRA	M	;SCRAMBLE
	MOV	M,A
	INR	L	;MORE IN SECTOR?
	JNZ	SCRLP
	RET
;
;BACKUP THE FILE TE ERROR - FILE CLOBBERED ++$'
;
;GET A PSEUDO-RANDOM 8 BIT NUMBER USING THE PASSWORD
;AS A SEED
;
;	FOR SPEED, THIS ROUTINE DOES NO REGISTER
;	PUSHES AND POPS, HOWEVER HL AREN'T USED.
;
PSEURAN	MVI	C,4	;GRAB EVERY 4TH PSEU. #
PSEULP0	MVI	B,8	;SHIFT THRU 8 BYTES
	LXI	D,PASSWD
	ORA	A	;CLEAR INITIAL CARRY
PSEULP1	LDAX	D	;GET A CHAR
	RAR		;SHIFT
	STAX	D
	INX	D
	DCR	B
	JNZ	PSEULP1
;EXCLUSIVE-OR THE LAST FEW BITS INTO THE FIRST ONE
	DCX	D	;BACK UP TO LAST
	RAR
	RAR		;SHIFT A FEW MORE
	XCHG
ER MAY APPEAR MORE '
	DB	'THAN TWICE IN THE PASSWORD.  ',0DH,0AH
	DB	''''
DUPCHAR	DB	$-$,''' DOES IN YOURS ++$'
CKNDUP	INX	D
	POP	PSW	;GET COUNT
	DCR	A
	JNZ	CKDLP
	RET		;OK, NOT 3 DUP
;
;FOLLOWING FROM 'EQU7.LIB'---->
;
;MOVE SUBROUTINES
;
	IF	MF	;MACRO EXPANSION FLAG SET?
MOVER	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVER
	RET
	ENDIF
;
;EXIT WITH ERROR MESSAGE
MSGEXIT	EQU	$	;EXIT W/"INFORMATIONAL" MSG
ERXIT	POP	D	;GET MSG
	MVI	C,PRINT
	CALL	BDOS
;EXIT, RESTSCRAMBLE is a command used to encode a CP/M file.

The format of the command is:
	SCRAMBLE filename.type password
where "password" is an 8 character password made of characters
perissible in a file name (i.e. no ".", etc).  To obtain a good
"initial seed" for the scrambling process, no character in the
password may appear more than twice.

The requested file is scrambled, and re-written in place.
To un-scramble the file, the IDENTICAL command is issued,
i.e. SCRAMBLE filename.type password.  ThisOP IF EOF
	CALL	SCRAMBL	;SCRAMBLE IT
	CALL	BACKUP	;RE-POSITION FOR WRITE
	CALL	WRSECT	;RE-WRITE THE SECTOR
	JMP	SCRAMLP	;LOOP UNTIL EOF
;
;ALL DONE - ON A "NORMAL" CP/M SYSTEM, WE WOULDN'T
;HAVE TO DO ANYTHING, BECAUSE WE RE-WROTE IN PLACE.
;
;HOWEVER, FOR SUCH SYSTEMS AS THE NORTHSTAR CP/M,
;WE MUST EXPLICITLY CLOSE THE FILE, BECAUSE THE WRITE
;TO THE DIRECTORY WILL CAUSE THE CLEVER LIFEBOAT-
;DESIGNED BIOS TO FLUSH IT'S MEMORY-RESIDENT DISK
;BUFFERS
;
FINISH	CPM	CLOSE,FCB
	INR	A	;THIS BETTPOINTER FOR THE RE-WRITE
;
BACKUP	LDA	FCBRNO	;GET SECTOR #
	DCR	A	;BACK UP
	STA	FCBRNO
	RP		;RETURN IF OK
;
;WE BACKED UP INTO PREVIOUS EXTENT, WILL HAVE
;TO RE-OPEN IT
;
	LDA	FCBEXT	;GET EXTENT
	DCR	A	;BACK UP 1
	STA	FCBEXT
	CPM	OPEN,FCB ;RE-OPEN
	INR	A
	JNZ	OPEN2OK
	CALL	ERXIT
	DB	'++ RE-OPENING EXTENT FAILED',0DH,0AH
	DB	'++ FILE IS CLOBBERED $'
OPEN2OK	MVI	A,7FH	;GET HI SECTOR
	STA	FCBRNO
	RET
;
;WRITE BACK THE SECTOR
;
WRSECT	CPM	WRITE,FCB
	ORA	A
	RZ
	CALL	ERXIT
	DB	'++ WRI
	XRA	M
	RRC		;SHIFT LO BIT INTO HI
	ANI	80H	;ISOLATE SINGLE BIT
	LXI	H,PASSWD ;GET FIRST BYTE
	ORA	M	;'OR' IN THE BIT
	MOV	M,A	;MOVE IT BACK
	XCHG		;RESTORE HL
	DCR	C
	JNZ	PSEULP0	;LOOP IF MORE PASSES
	RET
;
;ROUTINE TO CHECK FOR DUPLICATE CHARS IN PASSWORD
;
CKDUP	MVI	C,3	;DUP CHAR COUNTER
	LXI	D,PASSWD
	MVI	A,8	;CHAR COUNT
CKDLP	PUSH	PSW	;SAVE COUNT
	LDAX	D	;GET CHAR
	CMP	M	;DUP?
	JNZ	CKNDUP
	DCR	C	;COUNT DUPS
	JNZ	CKNDUP
	STA	DUPCHAR	;SAVE FOR PRINT
	CALL	ERXIT
	DB	'++ NO CHARACTORING STACK AND RETURN
EXIT	LHLD	STACK
	SPHL
	RET		;TO CCP
PASSWD	DS	8	;PASSWORD KEPT HERE
	DS	40H	;STACK AREA
STACK	DS	2
;BDOS/CBIOS EQUATES (VERSION 7)	
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
CONST	EQU	11
OPEN	EQU	15
CLOSE	EQU	16
SRCHF	EQU	17
SRCHN	EQU	18
ERASE	EQU	19
READ	EQU	20
WRITE	EQU	21
MAKE	EQU	22
REN	EQU	23
STDMA	EQU	26
BDOS	EQU	5
FCB	EQU	5CH 
FCB2	EQU	6CH
FCBEXT	EQU	FCB+12
FCBRNO	EQU	FCB+32
 is because
SCRAMBLE does an "exclusive-or" type modification to the file,
and doing two identical exclusive-or's to data result
in the same data being retuned. 

I feel a scrambled file is quite secure.  Given that a file
was scrambled and the password forgotten, I know of no way to
determine what the original file was.  Even a file which
is all binary-0's, is sufficiently scrambled to defy finding
out what the password or original data was.  ...But I assume
no responsibility for the "security" of files scrambled
with SCRAMBLE as I am not a "student of cryptology".

Note also, that if an attempt is made to unscramble a scrambled
file, using the WRONG password, then the file is technically
"double scrambled" and SCRAMBLE would then have to be executed
TWICE, once with the original password, and once with the
erroniously-used password.  Because of the exclusive or-ing
process, either password may be used either time.

03/11/79 Ward Christensen








                                    TED USER'S MANUAL

                                     CP/M VERSION 1.1





                   INTRODUCTION . . . . . . . . . . . . . . . . . . . 2

                   INFORMATION REQUEST. . . . . . . . . . . . . . . . 4

                   APPEND . . . . . . . . . . . . . . . . . . . . . . 5

                   DELETE LINES . . . . . . . . . . . . . . . . . . . 6

                   INSERT . . . . . . . . . . . . . . . . . . . . . . 7

 . . . .15

                   ERROR MESSAGE'S. . . . . . . . . . . . . . . . . .16

                   ACKNOWLEDGEMENTS . . . . . . . . . . . . . . . . .18



















                                              1                            








                                                          TED USER'S MANUAL


                                       INTRODUCTION

                    TED  is  a  simple,  easy-to-use, and yet powerful text

                  TED is "self-helping"  and  may  be  used  productively

               without further reference to this documentation!

                    TED is line-oriented, meaning that lines of text within

               the  file  may  be  referenced  by absolute or relative line

               numbers. Additionally, pattern search may be used to  locate

               a line and for global substition within a specified range of

               lines.  The  size of the file to be editeessor  for formatting textual information. This document

               was developed using both TED and PRO. PRO  commands  may  be

               referenced via the self-helping feature of TED.



                                              2                            








                                                          TED USER'S MANUAL




                    All   the  edit  commands,  including  the  information

               request,  will  be  briefly  ex
                   COPY LINE. . . . . . . . . . . . . . . . . . . . . 8

                   LOCATE LINE. . . . . . . . . . . . . . . . . . . . 9

                   MOVE LINE. . . . . . . . . . . . . . . . . . . . .10

                   PRINT LINE . . . . . . . . . . . . . . . . . . . .11

                   QUIT . . . . . . . . . . . . . . . . . . . . . . .12

                   SUBSTITUTE . . . . . . . . . . . . . . . . . . . .13

                   WRITE FILE . . . . . . . . . . . . . . . .           editor designed for use with any standard CP/M  system  with

               24K bytes or more of memory. To use TED type:

                                      TED <filename>

                                            or

                                TED <filename>.<filetype>

               where <filename> specifies a standard CP/M file to be edited

               or  created.  An  omitted  file  name  is considered to be a

               filename of all blanks.

      d is not limited to

               internal buffer size. TED creates temporary  disk  files  to

               extend  the available buffer space. Version 1.1 limits files

               to 2048 lines of up to 128  characters  per  line  (slightly

               larger than the capacity of a standard 8-inch diskette).

                   Although  TED  is  a  general  purpose  editor, it has a

               companion  program  called  PRO.  PRO  is  a  powerful  test

               procplained  in   the   following

               paragraphs.  Arguments  depicted  by  n1  and  n2 are signed

               integer numbers.

                 n1 or n2        meaning

                   25            line number 25

                   -10           line number ten prior to the current line.

                   +5            line  number  five relative to the current 

                                 line.



































                                              3                            








                                                          TED USER'S MANUAL


                                   INFORMATION REQUEST

               Format:

                 ?[char]



               Operand:

               char...........Char is one of TED's command characters.



               Description:

                 The information request command provides  instructions  on

                  insert info
                 ?k              copy line info
                 ?l              locate line info
                 ?m              move line info
                 ?p              print lines info
                 ?q              quit info
                 ?s              substitute substring info
                 ?t              text processor commands list info
                 ?w              write file info

               A question mark '?' should appear in the first col          a
                 <text>
                 .



               Description:

                 The  APPEND command is used to change the edit mode to the

               input mode. This command consists of an ASCII character  'a'

               followed  immediately  by a carriage return. TED will give a

               response: 'APPEND:' and a carriage return. Then TED is ready

               to accept input text.  New  lines  are  appended  after  the

               current only,
                      like the line below
                      .
                 EDIT:
                 ====>












                                              5                            








                                                          TED USER'S MANUAL


                                       DELETE LINES

               Format:

                 [n1][,n2]d



               Operands:

                 n1............Beginning line The  delete  command  is used to delete a line or group of

               lines in the  buffer.  The  line  following  the  last  line

               deleted becomes the current line.



               Example:

                 3d              deletes line number three.

                 3,6d            deletes lines number three through six.

                 ,+5d            deletes the current line through next 

                                 five lines.

                 d               the  use  of  TED  commands.  The  information  command  '?'

               followed by a carriage return,  prints  an  introduction  to

               TED,   and   instructions   for   obtaining   more  detailed

               information. The following is a list of information  command

               options.


                 ?               general information
                 ?a              append info
                 ?d              delete lines info
                 ?i    umn of the

               line.  Blank  characters  or  tab  characters separating the

               question mark and the command character  are  ignored.  Only

               the first displayable character of a command is checked.





                                              4                            








                                                          TED USER'S MANUAL


                                          APPEND

               Format:
         line. When a line containing only a period is typed

               the user is returned to the  EDIT  mode.  TED  will  give  a

               prompt  with 'EDIT:' followed by a carriage return, and edit

               level indicator '====>'.



               Example:

                 ====>a
                 APPEND:
                      This text is appended to the
                      current line. The input mode will be
                      ended by a line that contains a periodnumber to be deleted. If  not

                               specified,  the  current line is assumed. If

                               preceded by a plus  or  minus  sign,  n1  is

                               added  to,  or  subtracted from, the current

                               line.

                 n2............Ending line number to  be  deleted.  If  not

                               specified, only one line is deleted.



               Description:

                        deletes the current line.







                                              6                            








                                                          TED USER'S MANUAL


                                          INSERT

               Format:
                 i
                 <text>
                 .



               Description:

                 The INSERT command is used to insert an additional line or

               lines  before  the  current line. The input text is ended by

               typing a period alone at the beginning of a  line,  followed

               by  a  carriage return. This command differs from the APPEND

               command only in the placement of the input text.



               Example:

                 ====>i
                 INSERT:
                      This text is inserted prior to
                      the current line.
                      .
                 EDIT:
                to,  or

                               subtracted from, the current line.

                 n2............The  destination  to  where the line must be

                               copied. If preceded by a plus or minus sign,

                               n2 is added  to,  or  subtracted  from,  the

                               current line.



               Description:

                 The  COPY  command  is used to copy the line specified, to

               the line destinat                            TED USER'S MANUAL


                                       LOCATE LINE

               Format:

                 l/pattern/



               Operands:

                 /.............A  delimiter  of  the pattern specified. Any

                               displayable character may be used instead of

                               a slash.



                 pattern.......The string pattern to be searched for.



               Description:

     


               Example:

                 ====>l;ofrmat;
                   23 Each command has its own ofrmat.
                 ====>









                                              9                            








                                                          TED USER'S MANUAL


                                        MOVE LINE

               Format:

                 n1,n2 m



               Operands:

                 n1............The   The  MOVE command is used to move a line from one location

               to another. The new location of the line becomes the current

               line. This line is removed from the old location.



               Example:

                 ====>11,20m
                   20 (the moved line is displayed here).
                 ====>











                                             10                            








                                             ====>






















                                              7                            








                                                          TED USER'S MANUAL


                                        COPY LINE

               Format:

                 n1,n2 k



               Operands:

                 n1............The line number to be copied. If preceded by

                               a plus or minus sign, n1  is  added ion. This  new  line  becomes  the  current

               line.  If the destination line is greater than the last line

               number, this line will be appended to the last line  in  the

               file.



               Example:

                 ====>3,8k
                   8 (the copied line is displayed here).
                 ====>









                                              8                            








                                          The LOCATE command is  used  to  locate  the  first  line,

               starting with the line following the current line, which has

               the  occurance of the pattern specified. If the last line is

               reached and no pattern is matched, TED will  prompt  with  a

               message  - 'CANNOT FIND:' followed by the pattern specified.

               If locate is successful, the line  will  be  displayed,  and

               becomes the current line.

line to be moved. If preceded by a plus

                               or minus sign, n1 is added to, or subtracted

                               from, the current line.



                 n2............The new  location  of  the  moved  line.  If

                               preceded  by  a  plus  or  minus sign, n2 is

                               added to, or subtracted  from,  the  current

                               line.



               Description:

                               TED USER'S MANUAL


                                       PRINT LINES



               Format:

                 [n1] [,n2]|+|-|:



               Operands:

                 n1............The beginning line to be displayed.

                 n2............The last line to be displayed.

                 +.............The line after the current line.

                 -.............The line prior to the current line.

                 :.............Displays 16 lines starting from the  current

                               line.



               Description:

                 The  print  lines command requests TED to type out a group

               of  one  or  more  lines.  A  carriage  return  without  any

               character preceding it, prints the current line.



               Example:

                 ====>1,5           prints line one through line five.

                 ====>,+9           prints 10 lines starting from the currentut

               altering the source file. All current editting is lost. As a

               precaution, TED will prompt with  the  message  "WRITE?????"

               whenever the first entry of the quit command is requested. A

               subsequent quit command ends the edit session.



               Example:

                 ====>q
                 WRITE????
                 ====>q
                 A>
























                          of substitution.  If  not

                               specified the current line is assumed.

                 n2............the  ending  line of substitution. n2 should

                               be greater than n1

                 pattern.......the pattern to be replaced.

                 repl..........the replacement string. The null  string  is

                               included.

                 g.............global replacement indicator.



               Descriptioed.  Line length is truncated to 128 if the

               resulting replacement makes the line length overflow.



                                             13                            








                                                          TED USER'S MANUAL




               Example:

                 ====>16,40s;change;replace;g

















































                                       
               system.



               Example:

                 ====>w
                 A>




























                                             15                            








                                                          TED USER'S MANUAL


                                      ERROR MESSAGES



               DESCRIPTION:

                 TED's error messages are self-explanatory, for example: if

        

                                    line.

                 ====>25            prints line number 25.









                                             11                            








                                                          TED USER'S MANUAL


                                           QUIT



               Format:

                 q



               Description:

                 The  quit command is used to exit the edit session witho                   12                            








                                                          TED USER'S MANUAL


                                        SUBSTITUTE



               Format:

                 [n1] [,n2] s/pattern/repl/[g]



               Operands:

                 /.............delimiter,  any displayable character may be

                               used instead of a slash character.

                 n1............the beginning line n:

                 The  substitute command is used to search for an occurance

               of  the  specified  pattern,  and  replace   it   with   the

               replacement  string. If the replacement is made, the line is

               displayed. If no occurance is found, TED  gives  a  message:

               "CANNOT   FIND:   'pattern'."   If  the  global  replacement

               indicator is used, all occurances of  the  pattern  in  each

               line  are  replac      14                            








                                                          TED USER'S MANUAL


                                        WRITE FILE



               Format:

                 w



               Description:

                 The write file command writes the updated  disk  file  and

               deletes  temporary  files.  No backup file is created. After

               the file is written, control is returned  to  the  operating

       you attempt to write to a disk which already has 256 records

               on it TED will respond with the message 'DISK FULL'. If your

               directory   is  full  TED  will  respond  with  the  message

               'DIRECTORY SPACE FULL'. These types of errors are considered

               fatal, and in the case of fatal errors TED  will  print  the

               error  message  and  return  to CP/M. If this occurs you may

               find you have two working files on your  disk,  NEW.$$$  and

               REV.$$$.  Since  these  files  take up disk space during the

               edit session you may run out of disk space much sooner  then

               you  might have imagined! It is recommended that you have at

               least 2.5 times as much space on the disk as the size of the

               file you are intending to edit. If  you  have  made  several

               changes to your file and you get a 'DISK FULL' error you may

     DISK ERROR
                      CLOSE NEWFILE ERROR
                      CLOSE REVFILE ERROR
                      CLOSE OLDFILE ERROR


                                             16                            








                                                          TED USER'S MANUAL


                      MEMORY OVERFLOW(CP/M SYSTEM IS TOO SMALL FOR TED)

                 In  addition  to the fatal errors there are various errors

               in command format. These



































                                             17                            








                                                          TED USER'S MANUAL


                                     ACKNOWLEDGEMENTS



                 TED is a modified version of ED  an  editor  designed  and

               implemented  by  LTCOL  Triyono  at  the  Naval Postgraduate

               School as part of his thesis resbuted  his  guidance   and   experience   during   the

               development  of  the  original  system. Alterations to ED to

               allow TED to run on CP/M were made by LT Mark Moranville and

               LCDR Frank Burkhead.  Further  information  on  TED  may  be

               obtained from:-


                    LT Mark Moranville(code 52mi)
                    Naval Postgraduate School
                    Monterey, Calif 93940
                    ph 408-646-2253

 
TED VERS 1.1
$1 ͉3evCLOSE OLDFILE ERROR
$CLOSE NEWFILE ERROR
$CLOSE NEWFILE ERROR
$CLOSE REVFILE ERROR
$MISSING OPERAND
$NO SUCH LINE
$INVALID COMMAND
$INVALID NUMBER
$INVALID NUMBER
$APPEND:
$INSERT:
$     $INVALID COMMAND
$WRITE??????
$INVALID COMMAND
$NEED INFORMATION - TYPE: "?"
$RUBOUT KEY = BACKSPACE
$ 5f8ͼ:Bp%͉:  _88_*8*86*8#"88*8DM*8z8ͼ:B;͉f8- f88  8ͼ:BQ          be  able  to  recover  some  of the changes you have made by

               inspecting the first part of your NEW.$$$ file.  It  may  or

               may not contain the latest changes made. If it does, you may

               combine it with the original file using the PIP command.

                 The following errors are fatal errors:-


                      FILE EXTENSION ERROR
                      DISK FULL
                      DIRECTORY SPACE FULL
                       are not considered fatal errors and

               TED  will  wait  for  further  input   after   printing   an

               appropriate  error message. The non-fatal errors include the

               following:-


                      MISSING OPERAND
                      NO SUCH LINE(ON DELETE COMMANDS)
                      INVALID COMMAND
                      INVALID NUMBER(ANY NUMBER >2048 OR EQUAL TO 0)
                      INVALID LOCATE
                      INVALID SUBSTITUTEearch. ED  was  designed  to

               run  on  the ISIS-II operating system and was part of a TEXT

               processing  system  entered  in  the  Intel  Insite  library

               contest which eventually won the grand prize.

                 Many  of  the  data  structures  used  in  ED and TED were

               originally designed by professor Gary  Kildall.  LCDR  Frank

               Burkhead  served  as  LTCOL  Triyono's  thesis  advisor  and

               contri                   LCDR Frank Burkhead(code 52bg)
                    Naval Postgraduate School
                    Monterey, Calif 93940
                    ph 408-646-2449












                                             18                            



                                                                                                   8:`Af88ͼ:B)g͉8e!eA6 !fA6 !A 6 +6 +6 !  "8"8"8! "8!B 6 #6!bA6 	:cA}͉=͉:cA:bAڎ%!\A6 @@̓:bAҩͩ:@Q:@qH!= 6 :@?	!> 6 !  "^A:> 
2D !B !C :D }:\A=O !@	~2I 
L!J 6:fA!eAT!J 6 *gADM_!eA6 !fA6 ê:? m!? 6 +6}͉ê:@ !A Ҫ>!8!A Ғ*8+DM_:@ Ң*8#DM_!A 6 +6 :aA(!aA6 !> 6> 88gAͺ/!J 8^Aͺ8^Aͺ"G !  "E G E ͺ+ *E "E +$͉F,8^AͺF*8#DM_,+!> 6:I ,:A !@ +/Hҁ!? 6:eA{*8"gAÀ!eA6 :A !@ !eA!fA/:I +:I -HH:I +½!@ 6!A 6!? 6 #6 #6 !eA6 !fA6 !> 6͉N"K > ͦ͉!A 6 +6 +6 !eA6 !fA6 !> 6Ñ:A !@ ґ:@ <!@ 6 *K *8"K ~!A 6 K 8ͺ"K ! [*8ͩ"M !K > H~! "K :? ڑ*K "gA!eA6:? !? 6 gAK ͺҸ*K "^A!> 6 *8*8ͩ"M *K "^AM *M "^A!fA6:fA!eA!eA6*K "gA!eA 	!P 4*P & @	~
#	!aA6.	͉!> 6	:O q:O QH:@
Hz	:= o	!= 6͉!> 6w	! 6 V	:O w:O WH:@
Hҩ	! 6V	!A 6 +6 +6 !eA6 !fA6 ͉!> 6 adiklmpqswt!46*4& @	~ ~	H	!44	*4& @	~

o)͉*4& @	~24*4M
24*4M !
		^#Ve4͉
"͉
#͉
$͉
3͉
v%͉
[3͉
S ͉
j&͉
@'͉
(͉
,͉a
³
V0͉
<
E
N
W
`
i
r
{




!4q!46>!4*4& 		:4~ !4H\A4:4=*4w*\A& @	:4!
> >!4s+p+q:iA24=24!4:4
:424:424*4& *4*4& iA	{
!45~ t
:4!45L
*4& *4N !
B	~24!4:4#~H~ HҶ
:4<24þ
:4!4w6
>:\A=O !@	N
d
͉ *8*8ͩ"~5*8#"z5"x5~5x5ͺڞ*8#DM_*88	~=2}5!|56 *88	~=!|5Qͻ!|5:}5O !4	Hq!|54%!|56 *88	~=!|5z*|5& 4	N!|54V*88	^4$
ʑ, *x5"x5
"͉*iA& "~5>LͦҺ!L "~5*~5jA	6
*~5	6
*~5	6$jA͉!66 :\A=O !@	Nd!eA6 !fA6 A26!64*88	~==:iA!6OZ{2	6q:	B4!66U:6 k!66 *88	~=!6h*6& 5	N!64D> :6~Ҿ:626*88	~!6ھ*6& 5	*6& 
6	w!64~~ڷ*88	~26!64y!66 :6=!6*6& 
6	N!64

:6<<*88	w,>NO DIRECTORY SPACE$MEMORY OVERFLOWNEW FILE
$   0 
$EDIT:
$INDEX TABLE FULL
$     $!  "8:]A2688ͺ+N#F*8	~26Hү!64*8#"8:6
¬*8#"88	:6w!66 a:6*8+*8~
*8++*8~
H

:6<<*8#"88	w> :8#"8!66*88	~!6(UO!64> 8?,͉!76*88	~27!7rͻ!7:7O !6	Hq!74D*8DM*76!76 :7=!7ڨ*7& 6	N!74:@.:@
H!bA6 4͉$*8#"88<͉!cA6 $*88	:@w!76 *88	~=!7$*7& @	N!74 O͉*88	~27*8+"88W:78+s#rs!76:7!7sͻ27!74\ 8Ϳ҈*8#DM_DISK ERROR$FILE EXTENSION ERROR$DISK FULL$DIRECTORY SPACE FULL$!7s+p+q+p+q:7=27*7*7
w*7#"7*7#"7!6 !fA6 ͉!> 6:\A=O !@	~2O a:O AH:O IH:O iH:@
HҪ!bA6!> 6:O a:O AH҆͉à͉> !8Ҡ*8+DM_͉	:O m:O MH:O kH:O KH!fA!\A5!fA6 !> 6	:O ::@
HZ *8*8ͩ"Q  *8"^AQ 4*Q "^A,^A8ͺR*8#DM_,7!> 6	:O l:O LH:@ !A !? !eA!fA/Hҕ
!> 6	:O s:O SH:@ !A !? /H!> 6	:O d:O DH:@ !A !? /H1	:\A2P *P & @	~:4!44
> INVALID LOCATE
$CANNOT FIND:
$INVALID SUBSTITUTE
$CANNOT FIND:
$CANNOT FIND:
$:iA24!46 >!4ڌ*4& 
B	:4w!44o*4& iA	N !
B	6 :4=24:4 *4& iA	N !
B	:4!4:4N !iA	N !
B	w!45å!4q*\A& @	~24!\A4*4MiA͹:iA HҶ:4l:4LHD*\A& @	~
>>> ö!\A4N !@	~
X> *4MA͹ҳ*\A& @	~
x>*\A& @	~g~GH*\A& @	~
HҰ!	B6>> > > !4r+s+q!46*\A& @	:4~
H
*\A& @	*4& *4w!44!1͉:fA/!eAm:eA"*gADM_!eA6 gF͉*iA& " 6>LͦJ!L " 6* 6jA	6
* 6	6
* 6	6$jA͉!	B6 :fA!fA6 *gADM_*8"6" 6^A 6ͺڸҢ!66*8#DM_ * 6" 6Ҋ:6U͉*iA& " 6>Lͦ!L " 6* 6jA	6
* 6	6
* 6	6$jA͉!	B6 *88	~=26!66 *88	~=!6;ͻ!6:6O !5	Hq!64!66 #6 !66 *88	~==2	6:6~:6H7*6& 5	DM*	6$
26:64!66:6!6*6& 5	*6& 
6	w!64+4#~~:626!64:6~4!66:A!6*6& A	*6& 
6	w!64~~:62]A>!  "8"8"8! "8!86 !86 !86 *B~2828!]A6 *BBͿ͚!8s{\͉e!66:8!6v:626a:628o&  ͂"8"8!B"8*8	"8*Bf8f8ͩ:Bf8:B͉!cA6 !͉!`A6!`A6 888:B8:B͉!cA6 ^:`A^f8*8DM*8U!cA^8*8DM*8zf8*8DM*80!6p+q *8*8ͩ"6!6҆*6"686ͺ86ͺ!66*88	~!6ͻOͷ!64£*88	*8+"8	w*8+"8Ò+86ͺ+*88	*8#"8	w*%7r+s+p+q+p+q!  "&7$7&7ͺy*&7*"7DM5* 7DM2B l:BU͉!cA6 h7*&7*"7DMv *&7"&7!-7r+s+p+q+p+q!  ".7,7.7ͺ*.7**7DM5*(7DM2B  *.7".7:B͉:B͉͉eÑ*\A& @	~ !\A4!\A4~=O !@	~ #>:\A=O !@	~07>:\A=O !@	>9K> >:\A=o& "07
 cX!  "27:\A=07ҳ*27)))*27)	*07@	^ >0Ͱ"27*07#"07 !27Ұ!  i!\A5*27*8+"8ͩ:8 !85 58ͩ!86!8:8247288*8DM*8:4728*8+"8*8*8~!57q*8*8:57w*8#"88T8*8DM*8z!  "8*8+"8ͩ­:8 !85 58ͩ!86!8:8267288*8DM*8:6728*8+"8*8*8~!77q*8*8:77w*8#"888*8DM*8z!  "8INVALID COMMAND
$*gADM_*88	~=27!76 *88	~=!7Fͻ!7:7O !:7	Hq!74:97~!976 !76 *88	~=!7{*7& :7	N!74WÕ!876 > !8ҕ*8+"8 *8*8ͩ"7^Aں*^ADM_*^A+DM_!76 :7!7*7& :7	N!74*8#"8:7<8	w,*\A8![86:\8![8"!]85*]8M,![84*]8& 7	~	6nP!]85*]8M, n*]8M,Xn:_8 Ҫ:_8	¢*^8& *7:_8w!^84+N !7	6	]8F2[8:]8=O !7	:[8wçn*^8& *7:_8w!^84+N !7	:_8w!]84*_8MnÚ~*^8& *76
*^8&  	*76
:^8<<*7w!b8s+p+q!d86 +6 :b8=!c8`:d8+n~*c8& *`8~	Gd8F2e8Y*c8& *`8Nn!d84!c84N!m*B!Bq*B& K
n
n!Bp+q*B	K!Bp+q*B
K!Bp+q*BK2B!Bp+q*BK2B!Bp+q*BK2B!Bp+q*BK!Bp+q*BKR, SPECIFIES
A LINE NUMBER RELATIVE TO THE CURRENT LINE. + OR -  ALONE
MEANS +1 OR -1 FROM THE CURRENT LINE. IF NUMBER NOT SPECIFIED
THE CURRENT LINE IS ASSUMED. COLON (:) DISPLAYS 16 LINES
STARTING FROM THE CURRENT LINE.
THE LAST LINE DISPLAYED BECOMES THE CURRENT LINE.
3,8              DISPLAYS LINE 3 THROUGHOUT 8
+ 9              DISPLAY LINE 9 AFTER THE CURRENT LINE
:                DISPLAYS 16 LINES START FROM THE CURRENT LINE
$APPEND COMMAND
FORMAT
A
<TEXT>
.
  THE APPEND COMMAND READS IXT BEFORE THE CURRENT LINE.
THIS COMMAND DIFFERS FROM THE APPEND COMMAND ONLY IN THE
PLACEMENT OF THE INPUT TEXT.
$LOCATE COMMAND
FORMAT:
L/PATTERN/
  THIS COMMAND LOCATES THE FIRST LINE WHICH HAS THE OCCURANCE OF
THE SPECIFIED PATTERN. SEARCH STARTS FROM THE CURRENT LINE. SLASH
(/) OR ANY DISPLAYABLE CHARACTER
MAY BE USED AS THE PATTERN DELIMETER.
$QUIT COMMAND
FORMAT:
Q
 THE FIRST QUIT COMMAND RESPONDS WITH -WRITE??????- AS A
REMINDER TO SAVE EDITED TEXT IF DESIRED.  THE SECOND
REQUEST TO Q
  THE WRITE COMMAND CAUSES THE EDITOR TO WRITE THE EDITED
FILE AND THEN EXIT. NO BACKUP FILE IS CREATED. 
$INTRODUCTION
ED IS DESIGNED TO CREATE OR UPDATE A TEXT FILE.
THE FOLLOWING LIST OF EDITOR COMMANDS ARE AVAILABLE.
  #  COMMAND             FORMAT

  1  APPEND              A
  2  DELETE              [n1][,n2]D
  3  INSERT              I
  4  COPY                n1,n2K
  5  LOCATE              L/PATTERN/
  6  MOVE                n1,n2M
  7  QUIT                Q
  8  SUBSTITUTE          & @	~27m:7MH:7kH:7KHv!\A4*\A& @	~
v:7k:7KHm!976r!876͉====>$!7p+q!76> !7:7<O> H*7!
 c!7s{7e"7:70*7& 7	w!75Î!7p+q77ͺ!76 >!7*7& 7	6 !74*7DM̓*7"77͉}͉!7q:7J@nEn!7p+q*7^ ! cyͦ!7s#s:7 w n!75c*7:7w:7!7r+s+p+q!]86 #6 !76 a2_8
:7/H:]8~/:_8Hn:_8[> !]8S!^85N *7	~	9:]8=O !7	~2\!Bp+q*BK!Bp+q*BK2B!Bq*B& K!Bp+q*BKn *  _ ogDM!  >))덑o|g|	=jDM!  >))ґ	=^#V|g}o
_ {ozgO {ozgi`N#Fogo& og_ {_z#W                                                                                                                     PRINT LINES COMMAND
FORMAT
[n1][,n2]<CR>
+<CR>
-<CR>
:
 n1 AND n2 ARE THE INTEGER NUMBERS WHICH SPECIFY THE RANGE OF
LINES TO BE DISPLAYED. + OR - PRECEDING THE NUMBENPUT TEXT AND APPENDS IT AFTER
THE CURRENT LINE. THE INPUT TEXT IS ENDED BY TYPING A PERIOD
ALONE AT THE BEGINNING OF THE LINE.
$DELETE COMMAND
FORMAT:
[n1][,n2]D
  THE DELETE COMMAND DELETES THE ADDRESSED LINES FROM THE BUFFER.
THE LINE  AFTER THE LAST LINE DELETED BECOMES THE
CURRENT LINE. IF THE LINES DELETED WERE  AT THE END,
THE NEW LAST LINE BECOMES THE CURRENT LINE.
n1 AND n2 ARE SIGNED OR UNSIGNED INTEGER NUMBERS.
$INSERT COMMAND
FORMAT:
I
<TEXT>
.
  THIS COMMAND INSERTS THE GIVEN TEUIT TERMINATES THE EDIT SESSION AND RETURNS
CONTROL TO CP/M.
$SUBSTITUTE COMMAND
FORMAT:
[n1][,n2]S/PATTERN/REPL/[G]
  THE SUBSTITUTE COMMAND SEARCHES EACH LINE FOR THE OCCURANCE OF
THE SPECIFIED PATTERN. IF  FOUND, THE LINE IS
DISPLAYED WITH THE REPLACEMENT SPECIFIED. GLOBAL REPLACEMENT
INDICATOR (G) MEANS CHANGE ALL OF THE OCCURANCES OF THE PATTERN.
ANY DISPLAYABLE CHARACTER MAY BE USED AS A DELIMETER INSTEAD
OF SLASH.
n1 and n2 ARE SIGNED OR UNSIGNED INTEGER NUMBERS
$WRITE COMMAND
FORMAT:
W[n1][,n2]S/PATTERN/REPL/[G]
  9  WRITE FILE          W
 10  PRINT LINES         [n1][,n2]
                         +
                         -
                         :
DETAILED INFO ON EACH COMMAND CAN BE SEEN BY TYPING A QUESTION
MARK -?- FOLLOWED BY THE COMMAND ABBREVIATION.  
-?T- SUMMARIZES THE TEXT PROCESSOR COMMANDS. COMMANDS MAY
MAY BE SPECIFIED IN UPPER OR LOWER CASE.  n1, n2 REPRESENT
SIGNED OR UNSIGNED INTEGERS.

$TEXT PROCESSOR COMMAND SUMMARY

 #  COMMAND       CAUSE       DEFAULT       NOTE
    & ARGUMENT    BREAK?      VALUE       

 1  .FI            YES         -            FILL MODE
 2  .NF            YES         -            NO FILL MODE
 3  .BR            YES         -            BREAK
 4  .LS N          NO          N = 1        LINE SPACING
 5  .BP N          YES         N = +1       BEGIN PAGE
 6  .SP N          YES         N = 1        SPACE N LINES
 7  .IN N          NO          N = 0        INDENT N SPACES
 8  .RM N          NO          N = 72       RIGHT MARUST
17  .NO            NO          -            NO RIGHT ADJUST
18  .NE N          YES         N = 2        NEED LINES
19  .PP            YES         -            NEW PARAGRAPH
20  .FN N          NO          N = 1        FOOTNOTE
21  .TA N1 N2...   YES         N = 4 4 ...  TABULATION
22  .DL CHAR       NO          CHAR = ;     TAB SYMBOL/DELIMETER
23  .TM N          NO          N = 4        TOP MARGIN INCLUDING HEADER
24  .TS N          NO          N = 2        TOP SPACE
25  .BM N          NO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      GIN
 9  .TI N          YES         N = 1        TEMPORARY INDENT
10  .CE N          YES         N = 1        CENTER
11  .UL N          NO          N = 1        UNDERLINE
12  .HE |L|M|R|    NO          EMPTY        HEADER TITLE
13  .PN N          NO          N = +1       NEXT PAGE NUMBER

ENTER CARRIAGE RETURN FOR NEXT INFORMATION.
$
14  .FO |L|M|R|    NO          EMPTY        FOOTER TITLE
15  .PL N          NO          N = 66       PAGE LENGTH
16  .AD            NO          -            RIGHT ADJ    N = 4        BOTTOM MARGIN
26  .BS N          NO          N = 2        BOTTOM SPACE
$MOVE COMMAND
FORMAT:
n1,n2M
  THIS COMMAND MOVES LINE n1 TO LINE n2. BOTH ARGUMENT NUMBERS
ARE SIGNED OR UNSIGNED INTEGER. n2 BECOMES CURRENT LINE.
$COPY COMMAND
FORMAT:
n1,n2K
  THIS COMMAND COPIES LINE n1 TO LINE n2. THIS LINE BECOMES
THE CURRENT LINE.
$UNRECOGNIZED REQUEST
VALID REQUEST ARE: ?A,  ?D, ?I, ?K, ?L, ?M, ?P, ?Q, ?S,
?W, ?T (FOR TEXT PROCESSOR COMMAND LIST), ?
$                                                                                                                                                                                                                               0 $                                                                                                                                                                                                   NEW     $$$                      REV     $$$                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        \ .TITLE "CP/M DISK I/O DRIVERS FOR TDL'S TEXT OUTPUT PROCESSOR VER. 1.0"
;
; MIKE FAVITTA
; 2 JANET LANE
; ALBANY, NY 12203
;
; THIS PROGRAM ADAPTS THE TDL TEXT OUTPUT PROCESSOR
; TO WORK UNDER CP/M.
;
; SEE TOP.DOC FOR DETAILS
;
;***********************************
;	CP/M STANDARD EQUATES
;***********************************

BOOT = 0000H	;WARM START ADDRESS
TFCB = 005CH	;DEFAULT FCB ADDRESS
TBUF = 0080H	;DEFAULT BUFFER ADDRESS
TBASE = 0100H	;TRANSIENT PROGRAM BASE
BDOS = 0005H	;BDOS ENTRN FILE
CLOSE = 16	;CLOSE FILE
SFRST = 17	;SEARCH FIRST
SNEXT = 18	;SEARCH NEXT
FDELT = 19	;DELETE FILE
READ = 20	;READ RECORD
WRITE = 21	;WRITE RECORD
CREATE = 22	;CREATE FILE
RENAM = 23	;RENAME FILE
LOGIN = 24	;GET LOGIN
IDISK = 25	;GET DISK NUMBER
SDMA = 26	;SET DMA VECTOR
IALLOC = 27	;GET ALLOCATION VECTOR
;
EOF = 1AH	; CP/M END OF FILE CHAR
CR = 0DH
LF = 0AH
;
.PABS		; USE INTEL HEX FORMAT
.LOC 100H	; USE CP/M RUN ADDRESS
;
START:	JMP TOPDK
;
;
; TRANSIENT PROGRAM STORAGE
; DEFI
	INX H	 	; AREAS
	DCX B
	CMP C	
	JRNZ CLEAR
	CMP B
	JRNZ CLEAR
	LDA TFCB+17	; SAVE OPTIONS
	STA OPT
	LDA TFCB+18
	STA OPT+1
	MVI C,IDISK	; GET ACTIVE DRIVE #
	CALL BDOS
	MOV C,A
	MVI A,'S'	; IS THE
	CALL OPTS	; S OPTION SET
	MOV A,C
	JRNZ DUAL 	; NO,SET UP FOR 2 DRIVES
	STA SDSK	; SET UP FOR 1 DRIVE
	STA ODSK
	JMPR SKIP
DUAL:	BIT 0,A		; IS SOURCE ON A
	JRZ SKIP
	STA SDSK	; SOURCE ON B
	MVI A,0
	STA ODSK
SKIP:	LXI H,TOP 	; INSERT FILETYPE
	CALL CKFIL
	CPI 0FFH	; FILE EXIST?
	JRNDISK
	CALL BDOS
	LXI D,LSTFCB	; CREATE LISTING FILE
	LXI B,PRN
	CALL MAKEF
..SKP:	JMP TOPST	; GO ASSEMBLE
;
; TABLE OF FILETYPES
;
TOP:	.ASCII 'TOP'
DOC:	.ASCII 'DOC'
PRN:	.ASCII 'PRN'
;
; CHECK IF FILE EXISTS WITH
; EXT POINTED TO BY HL
;
CKFIL:	LXI D,TFCB+9
	LXI B,3		; IN TRANSIENT FCB
	LDIR		; MOVE FILETYPE
	LXI D,TFCB	; CHECK DIRECTORY
	MVI C,SFRST	; TO SEE IF FILE EXISTS
	CALL BDOS
	RET
;
; TEXT OUTPUT PROCESSOR IS DONE
; MUST WRAP UP LOOSE ENDS
;
TRPSIM:	MVI A,'D'	; DON'T CLY POINT

;***********************************
;	CP/M FUNCTION CODES
;***********************************
 
SRSET = 00	;SYSTEM RESET
RCON = 01	;READ CONSOLE
WCON = 02	;WRITE CONSOLE
RRDR = 03	;READ READER
WPUN = 04	;WRITE PUNCH
WLST = 05	;WRITE LIST
ISTAT = 07	;GET IOSTATUS
SSTAT = 08	;SET IOSTATUS
WCONB = 09	;WRITE CONSOLE BUFFER
RCONB = 10	;READ CONSOLE BUFFER
CSTAT = 11	;CHECK CONSOLE STATUS
LHEAD = 12	;LIFT DISK HEAD
RSDSK = 13	;RESET DISK SYSTEM
SDISK = 14	;SELECT DISK
OPEN = 15	;OPENITIONS
;
SDSK:	.WORD 0		; SOURCE DRIVE
ODSK:	.WORD 1		; OUTPUT DRIVE
OPT:	.WORD 0		; SAVE OPTIONS HERE
SRCPTR:	.WORD SRCBUF+128; SOURCE BUFFER POINTER
LSTPTR:	.WORD LSTBUF	; LISTING BUFFER POINTER
SRCFCB:	.BLKB 36	; SOURCE FILE CONTROL BLOCK
SRCBUF:	.BLKB 128	; SOURCE FILE BUFFER
LSTFCB:	.BLKB 36	; LISTING FILE CONTROL BLOCK
LSTBUF:	.BLKB 128	; LISTING FILE BUFFER
;
;
TOPDK:	LXI SP,TOPST+16EH	; SET TEMP STACK
	LXI H,SRCFCB	
	LXI B,TOPDK-SRCFCB
	MVI A,0
CLEAR:	MOV M,A		; ZERO FCB AND BUFFERZ GOTFIL	; YES
	LXI H,DOC	; NO, TRY DOC EXT
	CALL CKFIL
	MVI C,0		; ERROR 0
	CPI 0FFH	; FILE EXIST?
	CZ ERROR	; NO, ERROR
GOTFIL:	LXI H,TFCB	; MOVE FILE NAME TO SRCFCB
	LXI D,SRCFCB
	LXI B,12
	LDIR		; MOVE BLOCK
	LXI D,SRCBUF	; MAKE SURE SRCBUF
	MVI C,SDMA	; IS USED
	CALL BDOS
	LXI D,SRCFCB	; OPEN SOURCE FILE
	MVI C,OPEN
	CALL BDOS
	MVI C,1		; ERROR 1
	CPI 0FFH
	CZ ERROR
	MVI A,'D'	; ONLY WANT LIST FILE
	CALL OPTS	; IF D OPT IS SET
	JRNZ ..SKP
	LDED ODSK	; LOG IN OUTPUT DRIVE
	MVI C,SOSE IF
	CALL OPTS	; D OPT ISN'T SET
	JRNZ DONE
	MVI C,EOF	; FILL WITH EOF'S
LOOP:	CALL OUTSIM	; AND EMPTY BUFFER
	JRNC LOOP
	MVI C,CLOSE	; CLOSE FILE
	LXI D,LSTFCB
	CALL BDOS
DONE:	JMP BOOT
;
; IF CHAR IN A MATCHES 1 OF THE
; OPTIONS, SET THE ZERO FLAG
;
OPTS:	PUSH H
	LXI H,OPT	; POINT TO OPTIONS
	CMP M		; MATCH ?
	JRZ ..SKP 	; YES,RETURN
	INX H 		; NO,TRY NEXT ONE
	CMP M
..SKP:	POP H
	RET
;
; SIMULATE CONSOLE INPUT
;
CISIM:	PUSH H	; SAVE ASSEMBLER REGISTERS
	PUSH D
	PUSH B
	MVI C,RCON	; READ A CHAR FROM
	CALL BDOS	; CP/M CONSOLE
	POP B
	POP D
	POP H
	RET
;
; CHARACTER INPUT SUBROUTINE
;
; CREATE A SOURCE BUFFER AND LOAD
; IT FROM THE DISK. AT EACH CALL
; SUPPLY ONE CHARCTER IN A REG.
; IF BUFFER EMPTY, CALL BDOS TO
; FILL IT. SET CARRY IF EOF IS
; FOUND IN FILE.
;
RISIM:	PUSH H		; SAVE ASSM HL,DE
	PUSH D
	LXI D,SRCFCB	; GET FCB ADDRESS
	LHLD SRCPTR	; GET BUFFER POINTER
	CALL BUFIN	; READ A BYTE
	SHLD SRCPTR	; SAVE BUFFER POINTER
	POP D		; RESTORE HL,DE
	POP OUTPUT
; SIMILAR TO LIST OUTPUT BUT CHAR
; GOES TO A DISK FILE
;
POSIM:	LHLD LSTPTR
	LXI D,LSTFCB
	CALL BUFOUT
	SHLD LSTPTR
	POP H
	POP D
	RET
;
; SOURCE BUFFER CONTROL
; REFILL BUFFER IF EMPTY, PUT NEXT CHARACTER IN A
; ENTER WITH FCB ADDRESS IN DE, BUFFER POINTER IN HL
; SAVES BC, RETURNS WITH CHAR IN A, BUFFER POINTER IN HL
;
BUFIN:	MOV A,E		; COMPUTE END OF BUFFER
	ADI SRCBUF+128-SRCFCB
	CMP L
	JRNZ SRCB1
	PUSH B
	MVI C,READ
	CALL REFILL
	ANI 0FEH	; CHECK FOR GOOD READ
	CPI 0
	
	CPI 0		; GOOD WRITE?
	MVI C,3		; ERROR 3
	CNZ ERROR
	POP B
	STC		; MARK REFILL
BUFOU1:	MOV M,C		; STORE CHAR IN BUFFER
	INX H		; MOVE PTR TO NEXT CHAR
	RET
;
;
; BUFFER I/O ROUTINE
;
; ENTER WITH CP/M READ OR WRITE CODE
; IN BC AND FCB ADDRESS IN DE.
; RETURN WITH INITIALIZED BUFFER
; POINTER IN HL.
;
REFILL:	PUSH D
	PUSH B
	BIT 0,C		; IN OR OUT DRIVE
	JRZ SEL
	LDED ODSK	; OUTPUT DRIVE
	JMPR CONT
SEL:	LDED SDSK	; SOURCE DRIVE
CONT:	MVI C,SDISK	; LOG IN DRIVE
	CALL BDOS
	POP B
	P	LDIR		; MOVE FILENAME
	POP H
	LXI B,3
	LDIR		; MOVE FILETYPE
	MVI C,FDELT
	POP D
	PUSH D
	CALL BDOS	; DELETE FILE
	MVI C,CREATE
	POP D
	PUSH D
	CALL BDOS	; CREATE FILE
	MVI C,4		; ERROR 4
	CPI 0FFH
	CZ ERROR
	MVI C,OPEN
	POP D
	CALL BDOS	; OPEN FILE
	MVI C,5		; ERROR 5
	CPI 0FFH
	CZ ERROR
	RET
;
; MEMORY SIZE TEST
;
MEMSIM:	PUSH H
	LHLD BDOS+1
	DCX H
	MOV A,L
	MOV B,H
	POP H
	RET
;
; CONSOLE STATUS CHECK

CSTSIM:	PUSH B		; SAVE REGISTERS
	PUSH D
	PUSH H
	MVI C,CSTAT	; CRLF
	CALL PRTMES
	POP D 		; GET ERROR INDEX
	MVI D,0		; CLEAR HIGH ORDER BYTE
	SLAR E		; MULTIPLY BY 2
	LXI H,MESLST	; POINT TO MES ADDR
	DAD D
	MOV E,M		; LOAD IT IN DE
	INX H
	MOV D,M
	CALL PRTMES	; PRINT IT
	LXI D,CRLF
	CALL PRTMES
	JMP BOOT
;
PRTMES:	MVI C,WCONB	; PRINT A LINE
	CALL BDOS
	RET
;
;
ERMES1:	.ASCII [CR][LF]'TEXT OUTPUT PROCESSOR DISK ERROR '
	.ASCII 'AT ADDRESS $'
ERMES2:	.ASCII [CR][LF]'CP/M RETURNED A STATUS OF $'
CRLF:	.ASCII [CR][LF]'$'
;
MESLST:	.WORD EMES0
	H
	CPI EOF		; CHECK FOR EOF CHAR
	STC		; SET EOF FLAG IN CARRY
	RZ
	CMC		; NOT EOF, ERASE MARK
	RET
;
; DETERMINE WHERE OUTPUT 
; SHOULD GO
;
OUTSIM:	PUSH D		; SAVE TOP'S REGISTERS
	PUSH H
	MVI A,'D'	; D OPT SET ?
	CALL OPTS
	JRZ POSIM	; YES, DISK FILE
	JMPR LOSIM	; NO, LIST DEVICE
;
; LIST DEVICE CHARACTER OUTPUT
;
; WRITE TOP OUTPUT TO THE
; LIST DEVICE
;
LOSIM:	PUSH B
	MOV E,C
	MVI C,WLST	; OUTPUT 1 CHAR
	CALL BDOS
	POP B
	POP H
	POP D
	MOV A,C
	RET
;
;
; PUNCH CHARACTER MVI C,2		; ERROR 2
	CNZ ERROR
	POP B
SRCB1:	MOV A,M
	INX H
	RET
;
;
; OUTPUT BUFFER CONTROL
;
; IF BUFFER FULL, WRITE CONTENTS TO DISK,
; PUT CHAR FROM C IN BUFFER.
;
; ENTER WITH FCB ADDR IN DE, BUFFER PTR IN HL,
; AND CHAR IN C.
; RETURN WITH BUFFER PTR IN HL,SAVE BC,SET CARRY AFTER
; BUFFER REFILL.
;
BUFOUT:	MOV A,E		; COMPUTE END OF BUFFER
	ADI 164
	CMP L 		; FULL?
	STC		; CLEAR CARRY
	CMC
	JRNZ BUFOU1	; NOT FULL, STORE CHAR
	PUSH B		; FULL, SAVE CHAR
	MVI C,WRITE
	CALL REFILL
OP D
	LXI H,36	; CALC START OF BUFFER
	DAD D
	PUSH H		; SAVE START OF BUFFER
	PUSH D 		; SAVE FCB ADDRESS
	XCHG
	PUSH B		; SAVE CP/M CODE
	MVI C,SDMA
	CALL BDOS	; SET DMA ADDRESS
	POP B		; GET CP/M CODE
	POP D 		; GET FCB ADDRESS
	CALL BDOS	; READ OR WRITE BUFFER
	POP H		; SET PTR TO START OF BUFFER
	RET
;
;
; CREATE AND OPEN A FILE WITH SAME NAME AS DEFAULT FCB
;
; ENTER WITH ADDRESS OF FCB IN DE, AND
; ADDRESS OF FILETYPE STRING IN BC.
;
MAKEF:	LXI H,TFCB
	PUSH D
	PUSH B
	LXI B,9
SEE IF CHAR WAITING
	CALL BDOS
	ANI 1		; YES IF TRUE
	MVI A,0
	JRZ ..SKP 	; NO
	CMA
..SKP:	POP H 		; YES, A=0FFH
	POP D
	POP B
	RET

; IOCHECK
;
IOSIM:	MVI A,0A5H
	RET
;
; ERROR HANDLER
;
ERROR:	PUSH B		; SAVE ERROR INDEX
	PUSH PSW
	LXI D,ERMES1
	CALL PRTMES
	POP PSW
	POP B
	POP H 		; CALLER'S ADDRESS
	PUSH B
	ORA A		; CLEAR CARRY
	LXI D,3		; ADJUST ADDRESS
	DSBC D
	PUSH PSW
	CALL OUTHHL 	; PRINT IT
	LXI D,ERMES2
	CALL PRTMES
	POP PSW
	CALL OUT2H	; PRINT ERR STATUS
	LXI D,.WORD EMES1
	.WORD EMES2
	.WORD EMES3
	.WORD EMES4
	.WORD EMES5
;
EMES0:	.ASCII 'INPUT FILE NOT FOUND$'
EMES1:	.ASCII 'CAN NOT OPEN INPUT FILE$'
EMES2:	.ASCII '** BAD READ **$'
EMES3:	.ASCII '** BAD WRITE **$'
EMES4:	.ASCII 'CAN NOT CREATE OUTPUT FILE$'
EMES5:	.ASCII 'CAN NOT OPEN OUTPUT FILE$'
;
;
;	OUT2H PRINT 2 HEX DIGITS FROM A
;	OUTHHL PRINT HL

OUTHHL:	MOV A,H		; PRINT HL
	CALL OUT2H
	MOV A,L

OUT2H:	PUSH PSW
	CALL OUTHL
	POP PSW
	JMPR OUTHR

OUTHL:	RRC
	RRC
	RRC
	RRC
OUTHR:	ANI 0FH
	ADI '0'
	CPI '9'+1
	JRC OUTCH
	ADI '@'-'9'
	JMPR OUTCH
COSIM:	MOV A,C
OUTCH:	PUSH PSW
	PUSH B
	PUSH D
	PUSH H
	MVI C,WCON
	MOV E,A
	CALL BDOS
	POP H
	POP D
	POP B
	POP PSW
	RET
TEND:


; NEW TEXT OUTPUT PROCESSOR I/O VECTOR TABLE
; TO OVERWRITE PRESENT VECTOR TABLE

.BLKB 500H-(TEND-START)
OFFSET = .	; OFFSET=TOP LOAD ADDR - 100H

TOPST:	JMP OFFSET + 34AH
	JMP OFFSET + 34EH
	JMP CISIM
	JMP RISIM
	JMP COSIM
	JMP OUTSIM
	JMP CSTSIM
	JMP IOSIM
	JMP MEMSIM
	JMP .PI 10
.NF
		* * * *  TOP.DOC  * * * *

		MIKE FAVITTA - 9/12/79
		2 JANET LANE
		ALBANY, N.Y.  12203


.FO
THIS PROGRAM ADAPTS THE TDL TEXT OUTPUT PROCESSOR (TOP) TO RUN
UNDER CP/M. IT ALLOWS TOP TO USE A DISK FILE FOR INPUT AND
EITHER THE LIST DEVICE OR A DISK FILE FOR OUTPUT.
.BL 2
	 * FEATURES PRESENT IN TOP.AZM *
.BL 2
1.   DIAGNOSTIC ERROR MESSAGES ARE PRINTED ON DISK ERRORS.
.BL
2.   FOR USERS WITH DUAL DRIVE SYSTEMS THE EFFICIENCY OF
.IN 5
PROCESSING HAS
BEEN INCREASED BY AUTOMAL
.IN 5
A.   CREATE A FILE CALLED TDL.COM THAT CONTAINS THE TDL
.IN 10
TEXT OUTPUT PROCESSOR SET TO RUN AT 600H.   
.BL
- USE TDL'S RELOCATING LOADER TO LOAD THE ASSEMBLER
AT 600H (R,600). RELOC.AZM CAN ALSO BE USED.
.BL
- ENTER OR BOOT CP/M AND TYPE
  SAVE 20 TDL.COM (CR)
.BL 2
.IN 5
B.   ASSEMBLE THE PROGRAM TOP.AZM USING TDL'S
.IN 10
ASSEMBLER.
.BL 2
.IN 5
C.   RENAME THE OBJECT FILE TOP.HEX
.BL
.IN 10
- REN TOP.HEX=TOP.HXR
.BL
.IN 5
.CP 12
D.  USING DDT MERGE THE FILES TDL.COM A
.BL
S - USE THE CURRANTLY LOGGED IN DRIVE FOR ALL FILES
(SINGLE DRIVE MODE)
.BR
.BL
D - ALL OUTPUT IS TO BE PLACED IN A DISK FILE WITH THE
EXTENSION PRN. (OUTPUT NORMALLY GOES TO THE LIST
DEVICE)
.BL
.IN 5
- ANY COMBINATION OF OPTIONS IS LEGAL BUT S BY ITSELF
IS MEANINGLESS.
.BL
.IN 0
2.   SAMPLE TOP CALLS:
.BL
.IN 5
- TOP TEST
.BR
- TOP TEST D
.BR
- TOP TEST SD
.BL
.IN 0
3.   WHEN A DISK ERROR OCCURS THE FOLLOWING INFORMATION IS
.IN 5
PROVIDED:
.BL
- THE ADDRESS IN THE PROGRAM 

          
          

                   * * * *  TOP.DOC  * * * *  
          
                   MIKE FAVITTA - 9/12/79  
                   2 JANET LANE  
                   ALBANY, N.Y.  12203  
          
          
          THIS PROGRAM ADAPTS THE  TDL TEXT OUTPUT  PROCESSOR (TOP) TO
          RUN UNDER CP/M. IT ALLOWS  TOP TO USE A  DISK FILE FOR INPUT
          AND EITHER THE LIST DEVICE OR A DISK FILE FOR OUTPUT.  
          
          
               * FEATURES PRESENT IN TOP.TRPSIM

	.END
TICALLY PLACING THE OUTPUT FILE ON THE
DRIVE THAT DOES NOT CONTAIN THE INPUT FILE. THIS GREATLY
REDUCES THE AMOUNT OF HEAD REPOSITIONING NECESSARY. IF YOU
ONLY HAVE A SINGLE DRIVE SYSTEM OR WANT TO OVER RIDE THIS FILE
PLACEMENT SCHEME, AN OPTION IS AVAILABLE TO FORCE ALL FILE I/O
TO THE CURRANTLY LOGGED IN DRIVE ONLY.
.BL
.IN 0
3.   TOP.AZM IS WRITTEN USING TDL'S MACRO ASSEMBLER
.IN 5
MNEMONICS AND WILL NOT RUN ON 8080 BASED SYSTEMS.
.BL 2
	* GENERATION NOTES *
.BL 2
.IN 0
1.   PROCEDURE:
.BND TOP.HEX
.BL
.IN 10
- ENTER DDT AND TYPE THE FOLLOWING COMMANDS
.BL
  ITDL.COM (CR)
  R (CR)
  ITOP.HEX (CR)
  R (CR)
  ^C (^C = CONTROL C)
  SAVE 20 TOP.COM
.BL
- THE TDL.COM FILE MUST BE READ IN FIRST AS PART OF TOP.HEX
OVERLAYS IT.
.BL 2
.IN 0
	* NOTES ON OPERATION *
.BL 2
1.   FORMAT OF TOP CALL:	TOP FILENAME OPTIONS
.BL
.IN 5
- FILENAME NEVER HAS THE EXTENSION. IT IS ALWAYS ASSUMED TO BE TOP
OR DOC. THE EXTENSION TOP IS ALWAYS TRIED FIRST.
.BL
- OPTIONS AVAILIBLE ARE:
.IN 10
AT WHICH THE ERROR OCCURED
- THE STATUS RETURNED BY CP/M
- THE TYPE OF DISK FUNCTION THAT WAS ATTEMPTED
.BL
.IN 0
4.   THIS PROGRAM HAS BEEN EXTENSIVELY TESTED, BUT IF ANY
.IN 5
ERRORS ARE FOUND I WOULD APPRECIATE BEING NOTIFIED.

.EN
AZM * 
          
          
          1.   DIAGNOSTIC ERROR MESSAGES ARE PRINTED ON DISK ERRORS.  
          
          2.   FOR USERS WITH DUAL DRIVE SYSTEMS THE EFFICIENCY OF 
               PROCESSING HAS BEEN INCREASED  BY AUTOMATICALLY PLACING
               THE OUTPUT FILE ON THE DRIVE  THAT DOES NOT CONTAIN THE
               INPUT FILE. THIS  GREATLY  REDUCES  THE  AMOUNT OF HEAD
               REPOSITIONING NECESSARY.  IF  YOU  ONLY  HAVE  A SINGLE
               DRIVE SYSTEM OR WANT  TO OVER RIDE  THIS FILE PLACEMENT
               SCHEME, AN OPTION IS AVAILABLE TO FORCE ALL FILE I/O TO
               THE CURRANTLY LOGGED IN DRIVE ONLY.  
          
          3.   TOP.AZM IS WRITTEN USING TDL'S MACRO ASSEMBLER 
               MNEMONICS AND WILL NOT RUN ON 8080 BASED SYSTEMS.  
          
          
                   * GENERATION NOTES * 
          
          
          1.   PROCEDURE: 
          
               A.   CREATE A FILE CALLED TDL.COM THAT CONTAINS THE TDL 
       C.   RENAME THE OBJECT FILE TOP.HEX 
          
                    - REN TOP.HEX=TOP.HXR 
          









                                                              Page 2
          

               D.  USING DDT MERGE THE FILES TDL.COM AND TOP.HEX 
          
                    - ENTER DDT AND TYPE THE FOLLOWING COMMANDS 
          
                      ITDL.COM (CR) 
                      R (CR) 
                      ITOP.HEX (CR) 
                      R (CR) 
                       TRIED FIRST.  
          
               - OPTIONS AVAILIBLE ARE: 
          
                    S - USE  THE  CURRANTLY  LOGGED  IN  DRIVE FOR ALL
                    FILES (SINGLE DRIVE MODE) 
          
                    D - ALL OUTPUT IS TO BE PLACED IN A DISK FILE WITH
                    THE EXTENSION  PRN. (OUTPUT  NORMALLY GOES  TO THE
                    LIST DEVICE) 
          
               - ANY COMBINATION OF  OPTIONS IS LEGAL  BUT S BY ITSELF
               IS ME HAS BEEN EXTENSIVELY TESTED, BUT IF ANY 
               ERRORS ARE FOUND I WOULD APPRECIATE BEING NOTIFIED.  
               









	TITLE	'XREF.ASM	8/28/79'
	PAGE	0

;Modifications 4/5/79, 4/26/79, 5/3/79, 8/28/79 by SAN:
;Suppress initial page eject, add page eject at completion
;Automatically convert lower case in source file to UPPER
;Abort execution if ^C typed, but ignore other typed chars
;Add ELSE, PAGE to reserved word table
;Number of lines per output page set by LPAGE EQUate
;Number of symbol refs per table entry set by NREFS EQUate
;Number of symbol refs per output line set by LREFS EQUate
;Output sent to CON or L              TEXT OUTPUT PROCESSOR SET TO RUN AT 600H.  
          
                    -  USE  TDL'S   RELOCATING  LOADER   TO  LOAD  THE
                    ASSEMBLER AT 600H  (R,600). RELOC.AZM  CAN ALSO BE
                    USED.  
          
                    - ENTER OR BOOT CP/M AND TYPE 
                      SAVE 20 TDL.COM (CR) 
          
          
               B.   ASSEMBLE THE PROGRAM TOP.AZM USING TDL'S 
                    ASSEMBLER.  
          
          
                            ^C (^C = CONTROL C) 
                      SAVE 20 TOP.COM 
          
                    - THE TDL.COM FILE  MUST BE READ  IN FIRST AS PART
                    OF TOP.HEX OVERLAYS IT.  
          
          
              * NOTES ON OPERATION * 
          
          
          1.   FORMAT OF TOP CALL:     TOP FILENAME OPTIONS 
          
               - FILENAME  NEVER  HAS  THE  EXTENSION.  IT  IS  ALWAYS
               ASSUMED TO BE TOP  OR DOC. THE  EXTENSION TOP IS ALWAYS
ANINGLESS.  
          
          2.   SAMPLE TOP CALLS: 
          
               - TOP TEST 
               - TOP TEST D 
               - TOP TEST SD 
          
          3.   WHEN A DISK ERROR OCCURS THE FOLLOWING INFORMATION IS 
               PROVIDED: 
          
               - THE ADDRESS IN THE PROGRAM AT WHICH THE ERROR OCCURED
               - THE STATUS  RETURNED  BY  CP/M  -  THE  TYPE  OF DISK
               FUNCTION THAT WAS ATTEMPTED 
          
          4.   THIS PROGRAMST device according to CONOUT EQUate
;Graceful exit after error message if file not found

LPAGE	EQU	0		;LINES PER PAGE, 0 TO SUPPRESS EJECTS
NREFS	EQU	6
LREFS	EQU	24		;REFERENCES PER OUTPUT LINE
CONOUT	EQU	0		;OUTPUT TO LST IF 0, CON IF NONZERO

;********************************;
;
;          INTEL ASSEMBLER
;       CROSS REFERENCE PROGRAM  
;
;           VERSION 1.0
;
;         JEFF KRAVITZ 
;
;********************************;

;********************************;
;
;          MAIN LOOP
;
;********************************;
	ORG	100H		;ORIGIN ADDRESS
XREF:	LXI	SP,STACK	;SET STACK POINTER
	CALL	SETUP		;INITIALIZE
MAIN:	CALL	GETBT		;GET A BYTE FROM SOURCE FILE
	CALL	SAVBT		;SAVE BYTE IN PRINT BUFFER
MAIN2:	CALL	CKNUM		;TEST FOR NUMERIC
	JNC	LNUM		;YES, FOUND A NUMBER, PROCESS
	CALL	CKALP		;TEST FOR ALPHABETIC
	JNC	LALPH		;YES, PROCESS
	LXI	H,CTAB1		;POINT TO CHARACTER TABLE
	CALL	LOOK		;LOOK UP CHAR IN CHAR TABLE
	JC	LIGN		;NOT FOUND, IGNORE
	PCHL			;EXECUTE ROUTINE

;*****S
	LHLD	SYM		;GET SYMBOL TABLE POINTER
	LXI	D,SSIZ		;SIZE OF SYM TABLE ENTRY
	DAD	D
	SHLD	SYM
	MOV	A,M		;GET BYTE
	CPI	0FFH		;END OF TABLE?
	JNZ	DLP1		;LOOP
	CALL	EJECT		;PAGE EJECT
	JMP	BOOT		;AND RETURN TO CP/M

;********************************;
;
;     SYMBOL PRINT ROUTINE
;
;********************************;
PSYM:	MVI	B,5		;SYMBOL SIZE
PSYM2:	MOV	E,M		;GET BYTE
	CALL	PBYT		;PRINT BYTE
	INX	H
	DCR	B
	JNZ	PSYM2
	MVI	E,' '
	CALL	PBYT		;PRINT 2 SPACES
	CALL	PBYT
	RET

;**********UM IN HL
	CALL	DECOT		;CONVERT
	LXI	H,DEC		;POINT TO DEC STRING
	MVI	M,' '		;BLANK LEADING ZERO
	MVI	B,5
PREF2:	MOV	E,M
	CALL	PBYT		;PRINT BYTE
	INX	H
	DCR	B
	JNZ	PREF2		;PRINT REFERENCE NUMBER
	LHLD	TEMP		;GET REF SLOT ADDR
	INX	H
	INX	H		;BUMP TO NEXT SLOT
	SHLD	TEMP
	LDA	SYMCT		;GET COUNT
	DCR	A		;DECREMENT
	STA	SYMCT
	JNZ	PREF
	LHLD	REF		;GET REF BLOCK ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M		;GET LINK TO NEXT BLOCK
	LXI	H,0000
	CALL	CPHL		;ANY MORE BLOCKS?
	JZ	CRLF		;NO, EXIT
	XCHG			BUFFER
	LXI	H,SBUF
	SHLD	SYMPT
	MVI	A,00
	STA	SYMCT		;RESET SYMBOL POINTER+COUNT
	LDA	CHAR		;GET CHARACTER AGAIN
	CALL	GTSYM		;COLLECT IDENTIFIER
LALC:	CALL	GETBT		;GET A BYTE FROM SOURCE FILE
	CALL	SAVBT		;SAVE BYTE IN PRINT BUFFER
	CALL	CKNUM		;TEST FOR NUMBER
	JNC	LAL3		;YES, CONTINUE
	CALL	CKALP		;TEST FOR ALPHABETIC
	JNC	LAL3		;YES, CONTINUE
	CALL	CRES		;TEST FOR RESERVED WORD
	JC	LAL1		;NO, CONTINUE
LAL0:	LDA	CHAR		;GET CHARACTER THAT ENDED ID
	JMP	MAIN2		;CONTINUE SCAN
LAL1:	CALL	FINA BYTE
	CALL	SAVBT		;SAVE BYTE IN PRINTER BUFFER
	CPI	''''		;SEE IF STRING QUOTE
	JNZ	LQUOT		;NO, KEEP LOOPING
	CALL	GETBT		;GET NEXT BYTE
	CALL	SAVBT		;SAVE BYTE
	CPI	''''		;TEST FOR DOUBLES
	JZ	LQUOT		;YES, START SCAN AGAIN
	JMP	MAIN2		;NO, CONTINUE IN MAIN SCAN

LSEMI:	CALL	GETBT		;GET A BYTE
	CALL	SAVBT		;SAVE BYTE
	CPI	0DH		;WAIT FOR CR
	JNZ	LSEMI		;CONTINUE
	JMP	MAIN2		;ENTER MAIN LOOP

LCR:	CALL	PLINE		;PRINT LINE
	LHLD	LCNT		;GET LINE NUMBER
	INX	H		;BUMP LINE NUMBER
	SHLD	LCNT		;***************************;
;
;      FINAL SYMBOL TABLE PRINT
;
;********************************;
DONE:	CALL	EJECT		;ISSUE PAGE EJECT
	LHLD	SYMBT		;GET SYMBOL TABLE BOTTOM
	SHLD	SYM		;SET SYMBOL POINTER
	LHLD	SYMTP		;GET SYMBOL TABLE TOP
	MVI	M,0FFH		;END OFF SYMBOL TABLE
DLP1:	LHLD	SYM		;GET SYMBOL TABLE POINTER
	CALL	PSYM		;PRINT SYMBOL
	LHLD	SYM
	LXI	D,6		;OFFSET TO REF LINK
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M		;GET REF BLOCK ADDR
	XCHG			;INTO HL
	SHLD	REF
	CALL	PREFS		;PRINT REFERENCE**********************;
;
;     REFERENCE PRINT ROUTINE
;
;********************************;
PREFS:	MVI	A,LREFS/NREFS	;NUMBER OF BLOCKS TO PRINT ON ONE LINE
	STA	NLINS		;TO NLINS
PREF0:	LHLD	REF		;GET REF BLOCK ADDR
	INX	H
	INX	H		;BUMP TO FIRST REF NUMBER
	SHLD	TEMP		;SAVE REF NUM ADDR
	MVI	A,(REFSZ-2)/2	;NUMBER OF REF SLOTS
	STA	SYMCT		;SAVE IN SYMCT
PREF:	LHLD	TEMP		;GET REF SLOT ADDR
	MOV	E,M
	INX	H
	MOV	D,M		;GET REF
	LXI	H,0000		;ZERO?
	CALL	CPHL
	JZ	CRLF		;YES, DONE
	XCHG			;GET N;YES, SET NEXT BLOCK POINTER IN REF
	SHLD	REF
	LDA	NLINS
	DCR	A		;DECREMENT LINES COUNT
	STA	NLINS
	JNZ	PREF0		;AND PRINT MORE ON SAME LINE
	CALL	CRLF		;PRINT CR,LF
	MVI	B,07
PREF3:	MVI	E,' '
	CALL	PBYT		;PRINT SPACES
	DCR	B
	JNZ	PREF3		;PRINT 6 SPACES
	JMP	PREFS

;********************************;
;
;   CHARACTER PARSING ROUTINES
;
;********************************;
LALPH:	LXI	H,SBUF		;POINT TO SYMBOL BUFFER
	MVI	C,05
	MVI	A,' '
LALX:	MOV	M,A
	INX	H
	DCR	C
	JNZ	LALX		;CLEAR SYMBOL D		;SEE IF DEFINED
	JC	LAL2		;NO, CONTINUE
	CALL	ADDRF		;YES, ADD REFERENCE
	JMP	LAL0		;DONE
LAL2:	CALL	ENSYM		;ENTER SYMBOL DEFINITION
	CALL	ADDRF		;ADD REFERENCE
	JMP	LAL0		;CONTINUE
LAL3:	CALL	GTSYM		;COLLECT IDENTIFIER
	JMP	LALC		;CONTINUE

LNUM:	CALL	GETBT		;GET BYTE
	CALL	SAVBT		;SAVE BYTE IN PRINTER BUFFER
	CALL	CKNUM		;TEST FOR NUMERIC
	JNC	LNUM		;YES, CONTINUE
	CALL	CKALP		;TEST FOR ALPHABETIC
	JNC	LNUM		;YES, CONTINUE
	JMP	MAIN2		;CONTINUE WITH MAIN SCAN

LQUOT:	CALL	GETBT		;GET STORE
	JMP	MAIN		;CONTINUE

LIGN:	JMP	MAIN		;RE-ENTER MAIN LOOP

LLF	EQU	LIGN
LSPC	EQU	LIGN
LTAB	EQU	LIGN
LDOL	EQU	LIGN
LDEL	EQU	LIGN

;********************************;
;
;          SUBROUTINES
;
;********************************;

;********************************;
;
;         INITIALIZATION
;
;********************************;
SETUP:	LXI	D,TFCB		;POINT TO FCB
	CALL	FOPEN		;OPEN FCB
	LXI	H,PBUF
	SHLD	LPNT		;SET PRINT POINTER
	LXI	H,00001
	SHLD	LCNT
	LXI	H,SYMT		;GET ADDRESS OF SYMBOL TABLE
	SHLD	SYM
	SHLD	SYMBT
	SHLD	SYMTP		;SET SYMBOL TABLE POINTERS
	LHLD	MEMSZ		;GET AVAILABLE MEMORY ADDRESS
	DCX	H
	SHLD	REF
	SHLD	REFBT
	SHLD	REFTP		;SET REFERENCE TABLE POINTERS
	RET

;********************************;
;
;    CHECK FOR RESERVED WORD
;
;********************************;
CRES:	LXI	H,RTAB		;POINT TO RESERVED WORD TABLE
	SHLD	TEMP		;SAVE IN TEMP WORD
CRES1:	LHLD	TEMP		;GET TABLE POINTER
	LXI	D,SBUF		;POINT TO SYMBOL
	MVI	B,5		;SYMBOL SIZE
CRES2:	LDAX	D		;GET SYM*************************;
;
;     FIND SYMBOL IN TABLE
;
;********************************;
FIND:	LHLD	SYMBT		;GET BEGIN OF SYM TABLE
	SHLD	SYM		;SET TEMP POINTER
FIND1:	LHLD	SYM		;GET TEMP POINTER
	LXI	D,SBUF		;POINT TO CURRENT SYMBOL
	MVI	B,5		;SYMBOL SIZE
FIND2:	LDAX	D		;GET BYTE FROM SBUF
	CMP	M		;COMPARE TO SYM TABLE BYTE
	RC			;GREATER, NOT IN TABLE
	JNZ	FIND3		;LESS, GET NEXT TABLE ENTRY
	INX	D		;BUMP POINTER
	INX	H		;BUMP POINTER
	DCR	B		;DECREMENT BYTE COUNT
	JNZ	FIND2		;LOOP
	REE
FERR1:	MVI	C,09		;WRITE CONSOLE
	CALL	CPM		;ISSUE ERROR MESSAGE
	JMP	BOOT		;EXIT

;********************************;
;
;   ADD REFERENCE TO REF TABLE
;
;********************************;
ADDRF:	LHLD	SYM		;GET SYMBOL POINTER
	LXI	D,6		;OFFSET PAST SYMBOL&FLAGS
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M		;GET REFERENCE POINTER
	LXI	H,0000
	CALL	CPHL		;TEST FOR ZERO REF PTR
	JZ	BLDRF		;YES, BUILD REFERENCE ENTRY
LINK:	XCHG			;REF PTR IN HL
	MOV	E,M		;GET REF LINK
	INX	H
	MOV	D,M		;INTO DE
	DCX	H	Z	LINK3		;TRY AGAIN AT NEXT SLOT
	CALL	ADBLK		;ADD NEW REF BLOCK
	LHLD	REF		;GET REF POINTER
	INX	H
	INX	H		;SKIP TO FIRST REF SLOT
ENREF:	PUSH	H		;SAVE REF SLOT ADDR
	LHLD	LCNT		;GET LINE NUMBER
	XCHG			;INTO DE
	POP	H		;GET REF SLOT ADDR
	MOV	M,E
	INX	H
	MOV	M,D		;STORE LINE REF
	RET			;DONE
;********************************;
;
;     BUILD REF TABLE BLOCK
;
;********************************;
BLDRF:	LHLD	SYM		;GET SYMBOL POINTER
	LXI	D,6		;OFFSET TO REF POINTER
	DAD	D
	SHLD	REF		;SET TPOINTER
	MOV	M,E		;SET LINK
	INX	H
	MOV	M,D		;TO NEW REF BLOCK
	LHLD	TEMP		;GET NEW REF BLOCK ADDR
	SHLD	REF		;STORE IN REF
	MVI	B,REFSZ		;SIZE OF REF BLOCK
	MVI	A,00
ADB2:	MOV	M,A		;ZERO THE REF BLOCK
	INX	H
	DCR	B
	JNZ	ADB2
	LHLD	TEMP		;GET NEW REF BOTTOM
	SHLD	REFBT		;SET REFBT
	RET

;********************************;
;
;     ENTER SYMBOL IN SYM TABLE
;
;********************************;
ENSYM:	LHLD	SYM		;GET SYMBOL POINTER
	XCHG			;INTO DE
	LHLD	SYMTP		;GET SYMBOL TABLE TOP
	CALLBOL BYTE
	CMP	M		;COMPARE AGAINST TABLE ENTRY
	RC			;LESS, NOT IN TABLE
	JNZ	CRES3		;GREATER, GET NEXT TABLE ENTRY
	INX	D		;BUMP POINTERS
	INX	H
	DCR	B		;DECREMENT BYTE COUNT
	JNZ	CRES2		;KEEP TESTING
	JMP	CRES4		;FOUND
CRES3:	LHLD	TEMP		;GET TABLE POINTER
	LXI	D,RSIZ		;SIZE OF ENTRY
	DAD	D		;BUMP POINTER
	SHLD	TEMP		;STORE NEW POINTER
	MOV	A,M		;GET TABLE BYTE
	CPI	0FFH		;END OF TABLE?
	JNZ	CRES1		;NO, LOOP
	STC			;SET CARRY (NOT IN TABLE)
	RET
CRES4:	ORA	A		;RESET CARRY
	RET

;*******T			;TRUE ZERO, FOUND
FIND3:	LHLD	SYM		;GET CURRENT POINTER
	LXI	D,SSIZ		;SYMBOL TABLE ENTRY SIZE
	DAD	D		;BUMP POINTER
	XCHG			;INTO DE
	LHLD	SYMTP		;GET TOP OF SYMBOL TABLE
	CALL	CPHL		;TEST FOR END OF TABLE
	JZ	FIND4		;YES, DONE
	JC	FERR		;TABLE OVERFLOW, ERROR
	XCHG			;CURRENT POINTER INTO HL
	SHLD	SYM		;SET CURRENT POINTER
	JMP	FIND1		;LOOP
FIND4:	STC			;SET CARRY FOR NOT FOUND
	LHLD	SYMTP		;GET CURRENT TOP
	SHLD	SYM		;SET CURRENT POINTER
	RET
FERR:	LXI	D,EMSG1		;POINTER TO ERROR MESSAG	;REPOSITION HL
	PUSH	H		;SAVE REF PTR
	LXI	H,0000
	CALL	CPHL		;IF LINK IS ZERO
	POP	H
	JNZ	LINK		;NON ZERO, GET NEXT LINK
	SHLD	REF		;SAVE REF POINTER
	INX	H
	INX	H		;SKIP TO FIRST REF NUMBER
	MVI	B,(REFSZ-2)/2	;NUMBER OF REF NUMBERS/ENTRY
LINK3:	MOV	E,M		;GET REF NUMBER
	INX	H
	MOV	D,M
	DCX	H		;REPOSITION
	PUSH	H		;SAVE REF NUM ADDR
	LXI	H,0000
	CALL	CPHL		;SEE IF REF NUM IS ZERO
	POP	H
	JZ	ENREF		;YES, ENTER REFERENCE
	INX	H
	INX	H		;SKIP TO NEXT REF NUM
	DCR	B		;DECREMENT COUNT
	JNEMP REF POINTER TO HERE
	CALL	ADBLK		;ADD BLOCK
	LHLD	REF		;GET REAL REF POINTER
	INX	H
	INX	H		;POSITION TO FIRST REF SLOT
	JMP	ENREF		;ADD REFERENCE
ADBLK:	LHLD	REFBT		;GET REF BOTTOM
	LXI	D,REFSZ		;SUBTRACT REF SIZE
	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	SHLD	TEMP		;SAVE NEW REF BOTTOM
	XCHG			;INTO DE ALSO
	LHLD	SYMTP		;GET SYMBOL TOP
	CALL	CPHL		;CHECK FOR BUMP
	JZ	FERR		;YES, NO ROOM
	JNC	FERR		;NO ROOM
	LHLD	TEMP		;GET REF BOTTOM
	XCHG			;INTO DE
	LHLD	REF		;GET REF 	CPHL		;CHECK FOR END OF TABLE
	JZ	NWSYM		;YES, ADD SYMBOL AT END
	LXI	D,SSIZ		;SYMBOL TABLE ENTRY SIZE
	DAD	D		;CALCULATE NEW END OF TABLE
	XCHG			;INTO DE
	LHLD	REFBT		;REFERENCE TABLE BOTTOM
	CALL	CPHL		;TEST FOR TABLE OVERFLOW
	JZ	FERR		;FULL, ERROR
	JC	FERR		;YES, ERROR
	LHLD	SYMTP		;GET TABLE TOP
	LXI	D,SSIZ-1	;BUMP TO END OF ENTRY
	DAD	D
	SHLD	TO		;STORE IN TO ADDRESS
	LXI	D,SSIZ
	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A		;SUBTRACT SIZE OF ONE ENTRY
	SHLD	FROM		;STORE AS FROM ADDRESS
	LHLD	SYM		;GET CURRENT POINTER
	SHLD	LIMIT		;STORE AS LIMIT ADDRESS
	CALL	MVUP		;MOVE TABLE UP IN MEMORY
NWSYM:	LHLD	SYM		;GET CURRENT POINTER
	LXI	D,SBUF		;POINT TO SYMBOL
	MVI	B,5		;SIZE OF SYMBOL
	CALL	MOVE		;COPY SYMBOL TO TABLE
	MVI	A,0
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A		;SET POINTERS TO 0000
	LHLD	SYMTP		;GET SYMBOL TABLE TOP
	LXI	D,SSIZ		;GET SYMBOL ENTRY SIZE
	DAD	D		;BUMP
	SHLD	SYMTP		;STORE EW TOP
	RET

;********************************;
;
;    MOVE SYMBOLYTE
	MOV	M,A		;STORE BYTE
	INX	D
	INX	H		;BUMP POINTERS
	DCR	B		;DECREMENT COUNT
	JNZ	MOVE		;LOOP
	RET

;********************************;
;
;    BINARY TO DECIMAL CONVERSION
;
;********************************;
DECOT:	LXI	D,DEC
	XCHG
	LXI	B,10000
	CALL	DIG
	LXI	B,1000
	CALL	DIG
	LXI	B,100
	CALL	DIG
	LXI	B,10
	CALL	DIG
	LXI	B,1
	CALL	DIG
	RET

DIG:	MVI	M,'0'
DI0:	MOV	A,E
	SUB	C
	MOV	E,A
	MOV	A,D
	SBB	B
	MOV	D,A
	JM	DI2
	INR	M
	JMP	DI0
DI2:	MOV	A,E
	ADD	C
	MOV	E,A
	MOVENTRY SIZE
	MOV	B,A		;ARGUMENT BYTE IN B
LOOK2:	MOV	A,M		;GET TABLE BYTE
	CPI	0FFH		;END OF TABLE?
	JZ	LOOKN		;YES, NOT FOUND
	CMP	B		;COMPARE
	JZ	LOOKY		;FOUND
	DAD	D		;BUMP POINTER
	JMP	LOOK2		;LOOP
LOOKN:	STC			;CARRY = NOT FOUND
	RET

LOOKY:	INX	H		;SKIP TO TABLE BYTE
	MOV	E,M
	INX	H
	MOV	D,M		;TABLE ENTRY IN DE
	XCHG			;INTO HL
	RET

;********************************;
;
;    SAVE BYTE IN LINE BUFFER
;
;********************************;
SAVBT:	STA	CHAR		;SAVE CHAR IN CHAR
	LHLD	PBYT		;PRINT ' '
	CALL	PBYT		;PRINT SPACE
	LXI	H,PBUF		;POINT TO PRINT BUFFER
PL4:	MVI	A,00
	STA	COL		;SET COLUMN COUNT
PL41:	MOV	E,M		;GET BYTE
	MOV	A,E
	CPI	0DH		;DONE?
	JZ	PL5
	CPI	0AH		;LF?
	JZ	PL4A		;YES, IGNORE
	CPI	09H		;TAB?
	JNZ	PL42		;NO, CONTINUE
	PUSH	H		;SAVE HL
PL43:	MVI	E,' '
	CALL	PBYT		;PRINT SPACE
	LXI	H,COL
	INR	M
	MOV	A,M
	ANI	07H		;MODULO 8
	JNZ	PL43
	POP	H
	JMP	PL4A
PL42:	LDA	COL
	INR	A
	STA	COL
	CALL	PBYT		;PRINT BYTE
PL4A:	INX	H
	JMP	PL41
PL5:	CALL	CRLF		
;
;       PRINT A SINGLE BYTE
;
;********************************;
PBYT:	PUSH	B
	PUSH	D
	PUSH	H
	IF	CONOUT
	MVI	C,2
	ELSE
	MVI	C,05
	ENDIF
	CALL	CPM
	MVI	C,11		;CHECK CONSOLE STATUS
	CALL	CPM
	ORA	A		;IF ZERO, OK
	JZ	PBYTX		;EXIT
	MVI	C,1
	CALL	CPM		;READ CONSOLE CHAR
	CPI	3
	JZ	BOOT		;ABORT IF ^C, OTHERWISE IGNORE
PBYTX:	POP	H
	POP	D
	POP	B
	RET

;*********************************;
;
;      ISSUE PAGE EJECT
;
;*********************************;
EJECT:	MVI	E,0CH
	CALL	PBYT
 TABLE UP
;
;********************************;
MVUP:	LHLD	TO		;GET TO POINTER
	MOV	B,H
	MOV	C,L		;INTO BC
	LHLD	FROM		;GET FROM POINTER
	XCHG			;INTO DE
	LHLD	LIMIT		;GET LIMIT ADDRESS
MVUP2:	LDAX	D		;GET FROM BYTE
	STAX	B		;STORE AT TO ADDRESS
	CALL	CPHL		;COMPARE FROM TO LIMIT
	RZ			;EXIT IF DONE
	DCX	B		;DECREMENT TO
	DCX	D		;DECRMENT FROM
	JMP	MVUP2		;LOOP

;********************************;
;
;  GENERAL PURPOSE MOVE ROUTINE
;
;********************************;
MOVE:	LDAX	D		;GET B	A,D
	ADC	B
	MOV	D,A
	INX	H
	RET

;********************************;
;
;    TEST FOR ALPHABETIC CHAR.
;
;********************************;
CKALP:	CPI	'A'		;ASCII 'A'
	RC			;NO, EXIT
	CPI	'Z'+1
	CMC
	RET

;********************************;
;
;       TEST FOR NUMERIC CHAR
;
;********************************;
CKNUM:	CPI	'0'
	RC
	CPI	'9'+1
	CMC
	RET

;********************************;
;
;  LOOK UP CHAR IN PARSE TABLE
;
;********************************;
LOOK:	LXI	D,0003		;TABLE LPNT		;GET LINE POINTER
	MOV	M,A		;SAVE BYTE
	INX	H		;BUMP POINTER
	SHLD	LPNT		;SAVE POINTER
	RET

;********************************;
;
;  PRINT SOURCE LINE WITH NUMBER
;
;********************************;
PLINE:	LHLD	LCNT		;GET LINE NUMBER
	CALL	DECOT		;CONVERT TO DECIMAL
	LXI	H,DEC		;POINT TO DEC STRING
PL2:	MOV	E,M		;GET STRING BYTE
	MOV	A,E
	CPI	0DH		;DONE?
	JZ	PL3		;YES
	CALL	PBYT		;PRINT BYTE
	INX	H		;BUMP POINTER
	JMP	PL2
PL3:	MVI	E,':'
	CALL	PBYT		;PRINT ':'
	MVI	E,' '
	CALL	;PRINT CR,LF
	LXI	H,PBUF
	SHLD	LPNT		;RESET LINE POINTER
	RET

;********************************;
;
;      COLLECT SYMBOL IN SYM BUF
;
;********************************;
GTSYM:	MOV	B,A		;SAVE CHAR
	LDA	SYMCT		;GET SYMBOL COUNT
	CPI	05		;MAX?
	RNC			;YES, DONE 
	INR	A
	STA	SYMCT
	LHLD	SYMPT
	MOV	M,B
	INX	H		;BUMP SYMBOL POINTER
	SHLD	SYMPT
	RET

;********************************;
;
;       PRINTER INTERFACES
;
;********************************;

;********************************;
	MVI	E,00H
	MVI	B,10
EJECT2:	CALL	PBYT		;PRINT 10 NULLS
	DCR	B
	JNZ	EJECT2
	MVI	A,00
	STA	LINES		;SET LINE COUNT
	RET

;********************************;
;
;      ISSUE CR, LF & TEST PAGE
;
;********************************;
CRLF:	MVI	E,0DH
	CALL	PBYT
	MVI	E,0AH
	CALL	PBYT
	MVI	E,00
	CALL	PBYT
	CALL	PBYT		;PRINT 2 NULLS
	LDA	LINES
	INR	A
	STA	LINES		;INCREMENT LINE COUNT
	IF	LPAGE NE 0
	CPI	LPAGE		;TEST LINE COUNT
	CZ	EJECT		;IF 56 THEN NEW PAGE
	ENDIF
	RET


;********************************;
;
;       CHARACTER PARSING TABLE
;
;********************************;
CTAB1:	DB	0DH
	DW	LCR
	DB	0AH
	DW	LLF
	DB	''''
	DW	LQUOT
	DB	';'
	DW	LSEMI
	DB	' '
	DW	LSPC
	DB	09H
	DW	LTAB
	DB	'$'
	DW	LDOL
	DB	'('
	DW	LDEL
	DB	')'
	DW	LDEL
	DB	'+'
	DW	LDEL
	DB	'-'
	DW	LDEL
	DB	'*'
	DW	LDEL
	DB	'/'
	DW	LDEL
	DB	','
	DW	LDEL
	DB	':'
	DW	LDEL
	DB	EOF
	DW	DONE
	DB	0FFH
	DW	0000H
EOF	EQU	1AH		;EOF CODE

;********************************;
;
;     RESERVED WORD TD  '
	DB	'ENDIF'
	DB	'ENDM '
	DB	'EQU  '
	DB	'H    '
	DB	'HLT  '
	DB	'IF   '
	DB	'IN   '
	DB	'INR  '
	DB	'INX  '
	DB	'JC   '
	DB	'JM   '
	DB	'JMP  '
	DB	'JNC  '
	DB	'JNZ  '
	DB	'JP   '
	DB	'JPE  '
	DB	'JPO  '
	DB	'JZ   '
	DB	'L    '
	DB	'LDA  '
	DB	'LDAX '
	DB	'LHLD '
	DB	'LXI  '
	DB	'M    '
	DB	'MACRO'
	DB	'MOD  '
	DB	'MOV  '
	DB	'MVI  '
	DB	'NOP  '
	DB	'NOT  '
	DB	'OR   '
	DB	'ORA  '
	DB	'ORG  '
	DB	'ORI  '
	DB	'OUT  '
	DB	'PAGE '
	DB	'PCHL '
	DB	'POP  '
	DB	'PSW  '
TRY

;********************************;
;
;       MISCELLANEOUS DATA
;
;********************************;

EMSG0:	DB	'OPEN FAILED', 0DH, 0AH, '$'
EMSG1:	DB	'SYMBOL TABLE ERROR',0DH,0AH,'$'
SSIZ	EQU	8		;SYMBOL TABLE ENTRY SIZE
SYMBT:	DS	2		;SYMBOL TABLE BOTTOM ADDRESS
SYMTP:	DS	2		;SYMBOL TABLE TOP ADDRESS
REFBT:	DS	2		;REFERENCE TABLE BOTTOM ADDRESS
REFTP:	DS	2		;REFERENCE TABLE TOP ADDRESS
SYM:	DS	2		;CURRENT SYMBOL TABLE ADDRESS
REFSZ	EQU	2+(NREFS*2)	;NUMBER OF BYTES IN REF BLOCK
REF:	DS	MSZ	EQU	0006H	;END OF MEMORY POINTER
TBUF	EQU	0080H	;TRANS. BUFFER
TFCB	EQU	005CH	;TRANS. FCB

OPEN	EQU	15	;OPEN FUNCTION CODE
READ	EQU	20	;READ FUNCTION CODE



;********************************;
;           F O P E N            ;
;  ROUTINE TO OPEN A DISK FILE   ;
;                                ;
;  INPUT:     DE=A(FCB)          ;
;********************************;

FOPEN:	MVI	C,OPEN	;OPNE CODE
	CALL	CPM	;ISSUE OPEN
	CPI	0FFH	;ERROR?
	RNZ		;NO ERROR
	LXI	D,EMSG0
	JMP	FERR1



;*	CMC
	RNC		;NOT LOWER CASE, RETURN CARRY RESET
	CPI	'Z'+21H
	RNC		;NOT LOWER CASE
	SUI	20H	;CONVERT LOWER TO UPPER
	RET		;RETURN CARRY RESET
GETB2:	MVI	C,READ	;READ CODE
	LXI	D,TFCB	;FCB ADDRESS
	CALL	CPM	;ISSUE READ
	CPI	00	;ERROR?
	JNZ	IERR	;YES
	LXI	H,TBUF	;RESET BUFFER POINTER
	SHLD	INPTR
	JMP	GETB1	;CONTINUE
IERR:	STC
	RET

;********************************;
;   MISCELLANEOUS SUBROUTINES    ;
;********************************;


;********************************;
;             C ABLE
;
;********************************;
RTAB:	DB	'A    '
	DB	'ACI  '
	DB	'ADC  '
	DB	'ADD  '
	DB	'ADI  '
	DB	'ANA  '
	DB	'AND  '
	DB	'ANI  '
	DB	'B    '
	DB	'C    '
	DB	'CALL '
	DB	'CC   '
	DB	'CM   '
	DB	'CMA  '
	DB	'CMC  '
	DB	'CMP  '
	DB	'CNC  '
	DB	'CNZ  '
	DB	'CP   '
	DB	'CPE  '
	DB	'CPI  '
	DB	'CPO  '
	DB	'CZ   '
	DB	'D    '
	DB	'DAA  '
	DB	'DAD  '
	DB	'DB   '
	DB	'DCR  '
	DB	'DCX  '
	DB	'DI   '
	DB	'DS   '
	DB	'DW   '
	DB	'E    '
	DB	'EI   '
	DB	'ELSE '
	DB	'EN
	DB	'PUSH '
	DB	'RAL  '
	DB	'RAR  '
	DB	'RC   '
	DB	'RET  '
	DB	'RLC  '
	DB	'RM   '
	DB	'RNC  '
	DB	'RNZ  '
	DB	'RP   '
	DB	'RPE  '
	DB	'RPO  '
	DB	'RRC  '
	DB	'RST  '
	DB	'RZ   '
	DB	'SBB  '
	DB	'SBI  '
	DB	'SET  '
	DB	'SHL  '
	DB	'SHLD '
	DB	'SHR  '
	DB	'SP   '
	DB	'SPHL '
	DB	'STA  '
	DB	'STAX '
	DB	'STC  '
	DB	'SUB  '
	DB	'SUI  '
	DB	'TITLE'
	DB	'XCHG '
	DB	'XOR  '
	DB	'XRA  '
	DB	'XRI  '
	DB	'XTHL '
	DB	0FFH		;END OF RESERVED WORD TABLE
RSIZ	EQU	05		;SIZE OF TABLE EN2		;CURRENT REFERENCE TABLE ADDRESS
FROM:	DS	2		;MOVE POINTER
TO:	DS	2		;TO POINTER
LIMIT:	DS	2		;LIMIT POINTER
COL:	DS	1
CHAR:	DS	1
LCNT:	DS	2		;LINE COUNTER
LPNT:	DS	2
DEC:	DS	5
	DB	0DH
PBUF:	DS	132
SYMCT:	DS	1
SYMPT:	DS	2
SBUF:	DS	5
NLINS:	DB	0		;BUFFERS TO PRINT ON LINE
LINES:	DB	0		;PRINT LINE COUNT
 
;********************************;
;
;       OPERATING SYSTEM EQUATES
;
;********************************;
 
BOOT	EQU	0000H	;REBOOT ENTRY POINT
CPM	EQU	0005H	;CPM ENTRY POINT

ME*******************************;
;            G E T B T           ;
;   ROUTINE TO READ A BYTE       ;
;                                ;
;  OUTPUTS:     A=BYTE           ;
;               CARRY=ERROR      ;
;********************************;

GETBT:	LXI	H,TBUF+128
	XCHG		;BUFFER END ADDR. IN DE
	LHLD	INPTR	;CURRENT POINTER IN HL
	CALL	CPHL	;TEST FOR END OF BUFFER
	JZ	GETB2	;YES, READ
GETB1:	MOV	A,M	;GET BYTE
	INX	H	;BUMP POINTER
	SHLD	INPTR	;SAVE POINTER
	CPI	'A'+20H	;CHECK FOR LOWER CASE
P H L            ;
;  ROUTINE TO COMPARE HL VS DE   ;
;********************************;

CPHL:	MOV	A,H
	CMP	D
	RNZ
	MOV	A,L
	CMP	E
	RET

;********************************;
;             D A T A            ;
;********************************;

TEMP:	DS	2	;TEMP SAVE WORD

INPTR:	DW	TBUF+128;INPUT POINTER

	DS	64
STACK	EQU	$

;***********************************;
;         SYMBOL TABLE AREA
;
;    THE SYMBOL TABLE MUST BE
;    THE LAST BYTE OF THE PROGRAM
;
;***********************************;
	ORG	($ AND 0FFF0H) + 10H	;FORCE 16 BYTE BOUNDARY
SYMT:	DB	0FFH
	END
.pl 72
.mb 8
.mt 8
.cw 8
.lh 7
.po 7
.op
                               Nationa CP/ User Grou - Progra Submitta Form

** I yo hav an comment o thi form pleas 
**forwar the t th CP/ User Group.
**
**Pleas fil ou thi for fo al materia sub
**mitte t th CP/ User Group  I wil assis 
**u i preparin you contributio fo circulatio 
**an i helpin peopl selec programs 
**
**Sen th contribution wit th complete form 
**to:
*eas 
cross-referenc an rewrite o bug-fixe t prio 
distributions.
**
**I i intende tha thi for b fille ou wit 
**a editor an lef o th submitte dis fo 
**eac program  (Yo ma grou simila program 
**together) Al line startin * ar comment 
**whic shoul b delete fro th form  Remembe 
**t kee a origina o th for aroun fo sub
**mittin mor tha on program.
**
**(I yo don' mind ther ar stil  lo o u 
**o.
* MORSE.AS   Send Mors cod fro ASCI fil t 
**             port.
**SAMPLE.DA  Sampl dat fil fo MORSE.
.cp 7
.po 67


Author: 
**Pleas includ addres an phon number I ei
**the i no t b published s indicate bu 
**includ the fo th User Grou dis catalogin 
**process i cas ther ar questions.

Submitted by: 
**(i differen tha author)  Als includ addres 
**an phone i different.

This program is public domain because: 
**e.g S**disk Wa anythin publishe i  magazine etc 
**I thi  modificatio o  previou User Grou 
**program an i so wha wa it "name (e.g 
**23.05)

Hardware dependencies: 
**e.g specifi processor dis controller plot
**ter printer modem vide board etc.

Software dependencies: 
**e.g I/Ϡ vi PRO calls o hard-code ports 
**JMPS/CALLӠ t specifi machine-siz BIOS othe 
**softwar require whic i NO o thi disk Tim
**in dependencies*
**CP/ User Group
**165 Thir Avenue
**Ne York N 10028
**
Softwar contribution ar receive fo inclusio 
int th librar wit th understandin tha th 
contributo i authorize t mak th materia a
vailabl t other fo thei individua non-commer
cia use Th User Grou make n representation 
a t th utilit o th materia i th librar fo 
an purpose Contribution shoul b submitte o 8 
singl densit diskette i CP/ fil form Plu her wit 6 wid displays  W woul appre
**ciat you limitin you line t 6 characters  
**<<thanks>>)
**
**Thi for i mos easil fille ou wit  ful 
**scree editor  Yo ma d  "macr nex colon 
**(mn:$v t locat th field whic hav t b 
**fille in.
**
** Sav thi fil a "filename.CPM"
**
**Yo ca the delet al comment line via.. 
**bmn**$0ltk

Date:

File name: 
**(o names) Includ   lin descriptio o each
** Examples ..ubmitte b author author' approval ap
**prova fro magazin i whic i wa published 
**etc.

To whom would this program be useful: 
**e.g "Al CP/ users o "Peopl wit Tarbel 
**flopp controllers o "Peopl wit one-dis sys
**tems etc.

Briefly describe the program function: 
**Includ ru instruction onl i no include i 
**som othe .DO fil o thi disk.

Where is further documentation available: 
**e.g nam th appropriat .DO file o thi 
 "STANDAR CP/M mean i run 
**wit 8 disk (o similarl behavin one lik 
**Northstar) 24 o mor memory CP/ 1.4 D yo 
**think/kno i work with CP/ 2.0?

Source processor: 
**i.e i thi i  sourc program wha d yo 
**"ru i with".. MAC ASM Microsof BASI ver
**sio x.y TD AS etc.

Does the software "drop in": 
**i.e wha typ o modification ar require t 
**mak i run?

How easy is the code to modify: 
**e.g "CO͠ fil only" "Wel commente .AS 
**file";"Poorl commente .AS file"

**02/22/8 WLC
