 TBASIC  11                 TBASIC  13  r 	               TBASIC  TOC : 	               TBASIC  1    	
              TBASIC  J   " 
               TBASIC  12                  TBASIC  14   
               TBASIC  E   r               TBASIC  10  \               TBASIC  B2  o               TBASIC  4                  TBASIC  5   \                TBASIC  D1  y 
!"               TBASIC  2    #$               CATALOG 31  , 
%&               TBASIC  7   w '()*             TBASIC  COM  &abcde           INP(<numeric expression>)
Performs a read from the input port <numeric expression>.
Returns the value of the input port <numeric expression>.

INT(<numeric expression>)
Returns the largest integer which is less than or equal to
<numeric expression>.  Examples:  INT(-3.5)  INT(0)  INT(3.14159)

LEFT$(<string expression>,<numeric expression>)
Returns the leftmost <numeric expression> characters of 
<string expression>.  Examples:  LEFT$(ANS$,3)    LEFT$(A$+B$,N-M)

LEN(<string expression>)
Returnssion>,<string expression>,numeric expression>)
Returns the position of the first occurance of the first string
expression in the second string expression, starting with the
character position indicated by the numeric expression.  A
zero will be returned if no match is found.  The following pattern
matching features are implemented:

	1)  A pound sign(#) will match any digit (0-9).
	2)  An exclamation mark (!) will match any upper
	or lower case letter.
	3)  A question mark (?) will match any charned by the first numeric expression.
Examples:  MID$(A$,5)    MID$(STRING$,POSITION,LENGTH)





			   10




 TBASIC  8   7 +,-              TBASIC  A   ' ./0              TBASIC  15  m 12               TBASIC  I   t 345              TBASIC  3    678              TBASIC  CPM  9:;              TBASIC  H   q <                TBASIC  9    
=>               TBASIC  B1  a ?@A              TBASIC  C   M BCD              TBASIC  D2  2 	EF               TBASIC  6   , GHI              TBASIC  AD   JKL              TBASIC  K   a M                TBASIC  IND ` NOP              TBASIC  COM   QRSTUVWXYZ[\]^_`s the length of <string expression>.
Examples:  LEN(A$+B$)    LEN(ALPHABET$)    LEN("ABC"+STRING$)

* LOC(<variable name>)
Returns the decimal address of the location in memory
of the variable's value.  Useful for passing addresses
to routines which are accessed via the CALL function.
Examples:  LOC(ARRAY$(N))   LOC(N)   LOC(A$)

LOG(<numeric expression>)
Returns the natural logarithm (base e) of <numeric expression>.
Examples:  LOG(1)    LOG(X^2 +Y/5)    LOG(.5*SIN(X+Y))

* MATCH(<string expreacter.
Examples:  MATCH("DEF","ABCDEFGHIJ",1)   (returns 4)
	   MATCH(PATTERN$,OBJECT$,START)

MID$(<string expression>,<numeric expression>[,<numeric expression>])
Without the optional second numeric expression, returns rightmost
characters of <string expression> starting with the first
<numeric expression>.  With the second numeric expression, returns
a string whose length is determined by the second numeric expression,
starting with the character of <string expression> whose position
is determiTAB(<numeric expression>)
Spaces to column <numeric expression> on the PRINT device.
If tabbed column is less than the present position, the next
output from PRINT will go on the next line in the correct
position.
Examples:  TAB(20)    TAB(30)    TAB(N*2)    TAB(POSITION)

TAN(<numeric expression>)
Returns the tangent of angle <numeric expression>, which is in radians.
Examples:  TAN(DEGREES*3.14/180)    TAN(.25)    TAN(X^2/Y)

USR(<expression>)
Calls a user subroutine at the address in the loca  13




TARBELL BASIC	Table of Contents		August 21, 1978

Page	Description

1	Introduction & Modes of Operation

2	Line Descriptors

    Commands:

3	BYE, CADD, CLEAR, CLOAD, CONT, CSAVE

4	CSAVE!, DELETE, ENTER, LIST, NEW, RUN, SYMBOL

5	EDIT

    Statements:

6	ASSIGN, BGET, BLOAD, BPUT, BSAVE, CHANNEL, DATA, DEF, DIM

7	DROP, END, FOR, GOPROC, GOSUB, GOTO, IF, INPUT

8	LET, NEXT, ON, OUT, POKE, PRINT, PROCEDURE, READ

9	RECEIVE, REM, RESTORE, RETURN, STOP, WAIT

    Intrinsic Functions:Related Publications

	Index



















		TARBELL CASSETTE BASIC

Written by Tom Dilatush of REAL TIME MICROSYSTEMS, 2240 Main St.
No. 18, Chula Vista, CA 92011 for Don Tarbell of TARBELL ELECTRONICS,
950 Dovlen Place, Suite B, Carson, CA 90746.

This manual describes TARBELL BASIC in such a way as to be
understood by those having previous experience with other BASIC's.
It is not intended as a tutorial, as there are several good 
BASIC texts (see Appendix K).  Where reasonable it is
upward compatible from ALTAIR* 8800 BASIC release 4.0 tions FPRAA+6
and FPRAA+7 (see Appendix E).  The <numeric expression> is
evaluated and placed in registers D&E.  The USR function
returns with the value that is returned in D&E.
Example:   USR(0)   USR(N)   USR(N*M)   USR(ARG)

VAL(<string expression>)
Returns the numerical value of the string <string expression>.
If the first character is not "-", ".", or a digit, 0 is returned.
Examples:  VAL(FIELD4$)    VAL(COST$)    VAL(A$)

































			 

10	ABS, ASC, ATN, CALL, CHR$, COS, EXP, FRE, HEX, HEX$

11	INP, INT, LEFT$, LEN, LOC, LOG, MATCH, MID$

12	OCT$, PEEK, POS, RIGHT$, RND, SGN, SIN, SPACE$, SPC, SQR, STR$

13	TAB, TAN, USR, VAL

    Operators:

14	Arithmetic & String

15	Logical

    Appendixes:

A	Error Code Explanations
B	Definitions of Terms
C	Memory Usage
D	Internal Formats
E	Input/Ouput Section
F	Sample Run
G	Program Examples
H	Reserved Words
I	Known Bugs, Limitations, & Peculiarities
J	How to Load BASIC
K	8k version.
Items which differ significantly from that version are marked
with an asterisk.  Items enclosed in angles (<item>) are defined
in Appendix B.  Items enclosed in brackets ([item]) are optional.

Control Characters are rubout to delete a character, Ctl-U to
delete the line being entered, Ctl-C to stop the program or listing,
carriage-return for end of entry, Ctl-I to tab 8 spaces, and
Ctl-S to cause the program or printing to stop temporarily.

Modes of Operation:

    Direct Mode:
	Most TARBELL BASIC statements may be entered and executed while
	in command level.  This statement may be only one line, but
	may be any length up to the limits of memory.  Statements which
	would modify allocated memory, such as DIM & LET, are not allowed
	in direct mode entries.  Statement names are not allowed.
	Multiple statements per line may be seperated by colons (:).

    Entry Mode:
	This mode is entered by typing "ENTER" or ":", and is
	used for creating lines of program text from the keybrun in Appendix F.







* ALTAIR is a trademark/tradename of MITS, Inc.




				1






		How to Load Tarbell BASIC

If you have Tarbell BASIC on a CP/M disk, simply put the disk
into the drive, and type TBASIC.

If you have Tarbell BASIC on cassette (Tarbell, of course),
first examine the listing of the I/O section in Appendix E
of the Tarbell BASIC manual.  

Compare the console and cassette I/O routines to the ones you 
normally use in your system, to determine if there are any 
differences.  If there are, mark the necessary changes on
the listing.

Using either the bootstrap lly
in CP/M systems, but may need changing for other systems.

Start your computer running at the starting address specified
on the cassette, by doing an examine and run at that location,
or by using your ROM monitor to jump to it.

You should now get the opening message.


















				J













* OCT$(<numeric expression>)
Returns a string which represents the octal value of the numeric
expression.  Examples:  OCT$(10)    OCT$(X+Y)    OCT$(DECIMAL)

PEEK(<numeric expression>)
Returns the value of the byte in memory address <numeric expression>.
Examples:  PEEK(0)    PEEK(1024+OFFSET)    PEEK(DECIMALADDRESS)

POS(<expression>)
Returns the position of the printer.  Used only in PRINT statements.
Examples:  POS(0)    POS("")    POS(anything)

RIGHT$(<string expression>,<numeric expressionoard.
	it is also used for inserting lines.  See ENTER command.

    Edit Mode:
	This mode is entered by typing "EDIT" and a line descriptor.
	It is used for making changes to existing lines without
	having to retype the whole line.  See EDIT command.

    Run Mode:
	This is the normal, programmed mode.  The stored TARBELL
	BASIC program begins executing when a "RUN" command is entered.

To acquire a better feel for the modes of operation, and for using
TARBELL BASIC in general, see the sample program or input program in the
Tarbell cassette interface manual, or the Read-Only-Memory
Program, or other monitor, read the Tarbell BASIC interpreter
from the cassette into your main memory, using the starting
address and length which is specified on the cassette.

If you need to make changes in the I/O section, now is the
time to do it, using either your front panel DEPOSIT button
or suitable monitor in ROM.  Note that the top of memory
address which is put into location SSSS is done automatica>)
Returns the rightmost <numeric expression> characters of
<string expression>.    Examples:  RIGHT$(SENT$,1)    RIGHT$(S$,NUM)

RND(<numeric expression>)
If <numeric expression> is less than zero, starts a new sequence of
random numbers.  If it's equal to zero, returns the same number as
the last RND returned.  If it's greater than zero, returns the next
random number in the sequence. 
Examples:    RND(-1)    RND(0)    RND(1)    RND(X)

SGN(<numeric expression>)
If <numeric expression> is greater than zero, returns 1.
If it's equal to zero, returns 0; if less than zero, returns -1.
Examples:  SGN(-2.57)    SGN(0)    SGN(353.2)    SGN(X^3+Z)

SIN(<numeric expression>)
Returns the sine of angle <numeric expression>, which is in radians.
Examples:  SIN(DEG*PI/180)    SIN(.256)    SIN(X/Y)

SPACE$(<numeric expression>)
Returns a string of <numeric expression> spaces.
Examples:  SPACES$(BUFFERSIZE)    SPACES$(4+LEN(LINE$))

SPC(<numeric expression>)
Prints <numeric expression> spaces on 			OPERATORS

Arithmetic Operators (in order of precedence)

1.  expressions enclosed in parenthesis
2.  ^		exponentiation
3.  -		negation
4.  *  /	multiplication and division
5.  +  -	addition and subtraction
6.  relational operators (same for all)
	=	equal
	<>	not equal
	<	less than
	>	greater than
	<=	less than or equal
	>=	greater than or equal
7.  NOT		inversion of all bits
8.  AND		logical multiplication of each bit
9.  OR		logical addition of each bit






String Operators
h, the strings are of equal value.  If one string is
    shorter than the other, the longer string is considered greater.

2.  +		Concatenates (hooks together) two strings end-to-end.







				14














		INPUT/OUTPUT

The input and output facilities of TARBELL BASIC were designed
to create a new standard of flexibility.  Essentially, commands
are provided to allow any output statement to transfer data
to most output devices, and any input statement to transfer data
from most input devices.  In order to do this, devices are
grouped into logical devices and physical devices.  Logical
devices are those that are activated by the input and output
commands, and are listed in the table on the left.  Phyefault assignments for TARBELL CASSETTE BASIC:

Logical Device	Number		Physical Device		Number

INPUT		0		Console Keyboard	0
PRINT		1		Console Printer		1
CLOAD		2		Cassette Input		2
CSAVE		3		Cassette Output		3
BGET & BLOAD	4		Cassette Input		2
BPUT & BSAVE	5		Cassette Output		3
Spare		6		Spare Input/Output	4
Spare		7		Listing Device Output	5
				Reader Input		6
				Punch Output		7
				Disk Input		8
				Disk Output		9

The current assignments may be viewed by entering the
CHANNEL statementthe console.
Examples:  SPC(20)    SPC(N/3)    SPC(INT(X*2))

SQR(<numeric expression>)
Returns the square root of <numeric expression>.  An error message
will result if <numeric expression> evaluates to a negative number.
Examples:  SQR(B*B-4*A*C)    SQR(2)    SQR(X)

STR$(<numeric expression>)
Returns the string representation of <numeric expression>,
without leading or trailing spaces.
Examples:  STR$(3052.67)    STR$(NUMBER)    STR$(X*Y/Z)









			   12





1.  Comparison Operators

	=	equals
	>	greater than
	<	less than
	<=	less than or equal
	>=	greater than or equal
	<>	not equal

    Comparison is made by comparing the ASCII codes of each character
    of each string, starting with the first character of each string.
    The comparison continues with each set of corresponding characters
    until there is a mismatch, at which time the string with the code
    having the higher ASCII value is declared the greater.  If there
    is no mismatcsical
devices are actual pieces of hardware, such as a CRT, printer,
cassette, and disk.  There is a table, called the MODES table,
which remembers the assignment of physical devices to logical
devices.  The MODES table has ten bytes, numbered from 0 to 9.
Each byte represents a corresponding I/O device driver in the
I/O section.  Each bit in each byte corresponds to one of the
eight possible logical devices, numbered from 0 to 7.  The
table below shows the logical and physical devices, and their
d.  Every place an X occurs, an assignment
exists between the physical device to the left and the logical
device above.  The ASSIGN and DROP statements can be used to
set and reset bits in the table, respectively.

To get an idea of how this works, just type DROP 1,1.
This will drop the console output device as the PRINT device.
Don't worry!  Nothing's wrong.  Your keyboard is still feeding
commands to the console INPUT device, you just can't see the 
echo.  Now simply say ASSIGN 1,1 and you'll be back in business.

Note that the I/O section (see seperate listing)
creates the default assignments by transfering ten bytes
to the MODES table.  If you wish to change the default
assignments, just change these ten bytes (at IMODES).



				E









		INTRINSIC (BUILT-IN) FUNCTIONS

A FUNCTION, built-in or otherwise, can be used anywhere that
an expression can be used.  It can be a part of an expression,
and it can have an expression as it's argument.  It returns a
single value, which is defined by the descriptions below.
Some functions return string values, and some return numeric ones.

ABS(<numeric expression>)
Returns the absolute value of <numeric expression>.  In other words,
the expression is evaluated;  if the result is minus, the minlls a machine language subroutine at the address indicated by
the first <numeric expression>, with the value of the second
<numeric expression> in registers D&E.  The CALL function
evaluates to the number which is returned in registers D&E.
Example:   PRINT CALL(PLOT,X)

CHR$(<numeric expression>)
Returns a single character string whose ASCII code is <numeric expression>.
Examples:  CHR$(7)    CHR$(48+NUM)    CHR$(CONTROL)

COS(<numeric expression>)
Returns the cosine of the angle <numeric expresadecimal string representation of the decimal
value of <numeric expression>.
Examples:   PRINT HEX$(ADR+OFFSET)   PRINT HEX$(N)



			   9









<variable list>
A sequence of variable names, seperated by commas or semicolons.

<logical constant>
A constant which has the value of either -1 (true) or 0 (false).
Notice that in some systems, any integer other than zero is 
considered true.  This can produce an ambiguity, however, in
that a NOT TRUE operation could produce a TRUE value.

<logical operator>
AND, OR, and NOT are the logical operators.  When the AND
operator is between two logical constants, the combination
is true if both valueus
sign is removed to make it positive.
Examples:  ABS(X-5*SIN(Y))    ABS(B^2-4*A*C)

ASC(<string expression>)
Returns the ASCII code of the first character of <string expression>.
(i.e. the number which corresponds with the ASCII character)
Examples:  ASC("A")    ASC(ANS$)    ASC(A$(N))

ATN(<numeric expression>)
Returns the arctangent of <numeric expression>, which is in radians.
Examples:  ATN(RADIANS)    ATN(DEGREES*PI/180)    ATN(.053)

* CALL(<numeric expression>,<numeric expression>)
Casion>, which
is in radians.  Example:  COS(DEG*3.14159/180)

EXP(<numeric expression>)
Returns the constant e (2.718282) to the <numeric expression> power.
Examples:  EXP(1)    EXP(0)    EXP(X+Y*2)

FRE(<expression>)
Returns the amount of free (unused) space in memory.
Examples:  FRE("")    FRE(0)    FRE(1)

* HEX(<hexadecimal string>)
Returns the decimal equivalent of the <hexadecimal string>.
Examples:   LET ADDR=HEX(HADDR)    FOR N=0 TO HEX(A)

* HEX$(<numeric expression>)
Returns the hexs are true.  When the OR operator is
between two logical expressions, the combination is
true if either value is true.  When the NOT operator is 
before a logical expression, the combination produces a TRUE
value if the expression were FALSE, and a FALSE value if the
expression were TRUE.  The logical operators all perform
as if they were operating on each bit of a 16-bit
binary number, with all bits operated on in parallel.
Examples:  2 AND 3 produces 3
	   1 OR 4  produces 5
	   NOT 0 produces -1



<logical variable>
A variable whose value is either -1 (true) or 0 (false).

<logical expression>
An expression which evaluates to either a -1 (true) or 0 (false).

Examples:  

	LET TRUE=-1:LET FALSE=0
	TRUE AND TRUE  produces TRUE
	TRUE AND FALSE produces FALSE
	FALSE AND TRUE produces FALSE
	FALSE AND FALSE produces FALSE
	TRUE OR TRUE produces TRUE
	TRUE OR FALSE produces TRUE
	FALSE OR TRUE produces TRUE
	FALSE OR FALSE produces FALSE
	NOT TRUE produces FALSE
	NOT FALSE produ








* CSAVE!
Causes TARBELL BASIC to write itself and optionally,  system monitor
onto cassette tape.  This is handy for making patches.
Example:	CSAVE!

* DELETE <line descriptor> [<line descriptor>]
Eliminates the line(s) indicated from the stored program.  If only
the first <line descriptor> is present, only that one line is deleted.
If both <line descriptor>'s are present, both those lines, and
all lines in between are deleted.  If there is no such line
descriptor, an error message is issued.
Exathe line indicated.  Entry mode is terminated by two carriage returns 
in a row.  Multiple statements per line are allowed if separated by a colon.
The colon shown in the command format above, however, is a shorthand
form of ENTER, the same way that "?" is a shorthand form of PRINT.
The first line in a program should always have a label.
If any of the following commands are invoked from entry mode, they
will be performed, then command mode will be reentered:
  LIST,DELETE,EDIT,RUN.
Examples:	ENTER	   Example:   NEW

RUN [<line descriptor>]
If the line descriptor is included, starts execution of the BASIC
program at the line specified.  If the line descriptor is ommitted,
execution begins at the first line in memory.  In either case, a
CLEAR is automatically executed first.
Examples:   RUN		RUN COMD	RUN SUBROUTINE+1

* SYMBOL
Types a table of variable names, line descriptors, their types and
their locations.  Example:	SYMBOL







			    4










ces TRUE

<line descriptor>
A sequence of numerals and letters (not punctuation), which
starts with the first character position (left-hand margin)
in a TARBELL BASIC statement line, and which is terminated
by either a space or a tab (ctl-I), and which is not one of
the reserved words in Appendix H.  If the descriptor is in
a statement referencing another statement, a + or - offset
may be included.

<line descriptor list>
A sequence of line descriptors, seperated by commas.




				B-2


mples:	DELETE START+4	    DELETE LOOP LOOP+5

* ENTER [<line descriptor>]  or  :[<line descriptor>]
Causes TARBELL BASIC to go to program entry mode.  Any input after
this statement is interpreted as program statements.  A carriage
return delimits each line.  The "ENTER" statement is provided to
allow statements without names to be entered.  If <line descriptor>
is ommitted, entry begins after the last statement currently in
memory.  If <line descriptor> is present, entry begins immediately before
   ENTER ADDC+3     ENTER LOOP     : START+1

LIST [<line descriptor>] [<line descriptor>]
Lists the program starting from the statement corresponding with
the first <line descriptor>, until the end is reached, if there is no
second <line descriptor>, or until a control/C is entered.
If neither <line descriptor> is present, the whole program is listed.
Examples:	LIST     LIST START+10     LIST LOOP END1

NEW
Deletes the program in memory, clears all variables, releases all
string and array space.* EDIT <line descriptor>
Causes the interpreter to enter the edit mode on the line described.  The 
line will be printed.  Once in edit mode, single letter commands of
the form nXs are used, where n is the iteration constant (1 if ommitted),
X is the command (detailed below), and s is the search string (if required).
Note that if it is desired to use a command without the search string,
a carriage-return should be entered immediately after the command letter.

Commands:

 U   Prints the line up toe buffer.
 A   Appends characters to the end of the line until a carriage
     return is entered.
nL   Lists n lines starting with the present line, and enters edit
     mode on the last line listed.
 T   Type the rest of the line past the pointer, then the line up
     to the pointer.
 R   Replace the edited line in source with the current edit buffer.
     ***** IMPORTANT NOTE *****
     Until this command is executed, the source line is not changed.
     Prints out the new line, then enters edit about what you typed, hit rubout and start over.

The rubout key functions on insert/change commands as a delete key.











				5






		INTERNAL FORMATS

Symbol Table Format:  ASCII, last character has bit 7 set=1.

Symbol Directory Format:
Bytes 0&1 are pointer to location (0 if inactive dummy).
Byte 2 bits have meanings as follows:
  0-statement name	1-variable	2-function
  3-channel name	4-array		5-unused
  6-has been stored to	7-trace on

Numeric Array Format:
bytes n,n+1 = back pointer
bytes 2+n to n+x+1 = number of elements per dimension
where n=(table pointer), and x=number of dimensions
bytes 2+n+x to 1+n+x+(6*E) = to n+1+m=number of elements per dimension.
  bytes m+n+2 to n+1+(2E)+m=string pointers.
  Where m=number of dimensions, and E=number of elements.
  2 Bytes per pointer, same organization as elements of
  numeric arrays.  If (pointer)=0, string is (null).
  Otherwise, points to first address of (string).

String Format:
  bytes n,n+1=back pointer.
  n+2 to n+1+m=ASCII data.
  Where m=number of characters.  Last character as bit 7=1.
  All other characters have bit 7=0.




			    D-1




 the present pointer position.
nD   Deletes n characters starting with the present pointer position.
 K   Kills (deletes) a whole line, then enters insert mode.
nSs  Moves the pointer to the n'th occurance of string s.
 Is  Performs command S first, then inserts characters at the 
     pointer position until a carriage return is entered.
nCs  Changes the nth occurance of string following C to the
     string inserted from keyboard.
 Q   Returns to command level.
 P   Prints the line in the edit lint mode on next line.
nF   Move forward n lines and enter edit mode there.
nB   Move backward n lines and enter edit mode there.
 Ms  Move to (line descriptor) and enter edit mode there (search
     string s is used for line descriptor).
nX   Move pointer back n characters.
n<space>   Move pointer forward n characters.

A rubout during command entry will cause it to start all over with
the command entry.

Commands are not echoed -- this makes it much easier to see what you
are editing--if in doubnumber storage
where E=total number of elements
To locate an element within an array, location=base+offset,
where base=2+n+x, and offset computed by:
	N=1
	OFFSET=S(N)
LOOP	N=N+1
	OFFSET=(OFFSET)(D(N))+S(N)
	IF N<>LAST DIMENSION GOTO LOOP
	OFFSET=OFFSET*6
	END
Where S is subscript, D cements in a dimension, () mean contents of.
Example:  Array dimensioned 3,4,5; Get element 2,1,4.
	N	Offset
	1	2
	2	2*4+1=9
	3	9*5+4=49
	3	49*6=294

String Locator:
  bytes n,n+1=back pointer.
  bytes n+2 



* Line Descriptors:
    In TARBELL BASIC, line descriptors may not only be line
    numbers, as in conventional BASIC'S, but also may be any
    alphanumeric string of characters (including numbers),
    except spaces or punctuation.  If the descriptor is in a
    statement that is referencing another statement, it may
    have an offset appended.  The offset is indicated by the
    symbol "+" or "-".  This feature may be used to greatly
    increase readability, and thus increase maintainability ofame of a particular line or subroutine.

    See Appendix G for more examples of the use of line descriptors.

	Examples:

	SORT A=B+6	"SORT" is the descriptor, in this case, the
			name of the statement.
	GOTO SORT+1	"SORT+1" is the descriptor, indicating a
			transfer to the statement following "SORT". That
			statement may or may not have a name of it's own.
	GOSUB SORT - 5	"SORT - 5" is the descriptor, indicating a transfer
			subroutine call to the statement 5 lines before
			the statementVOLUME 31

TARBELL BASIC MANUAL AND ASSEMBLER SOURCE
(OBTAIN VOLUME 32 ALSO FOR COMPLETE PACKAGE)

NUMBER	SIZE	NAME		COMMENTS

31.1	2K	TBASIC.TOC	TABLE OF CONTENTS
31.2	3K	TBASIC.1	CHAPTER 1
31.3	2K	TBASIC.2	CHAPTER 2
31.4	3K	TBASIC.3	CHAPTER 3
31.5	3K	TBASIC.4	CHAPTER 4
31.6	3K	TBASIC.5	CHAPTER 5
31.7	3K	TBASIC.6	CHAPTER 6
31.8	4K	TBASIC.7	CHAPTER 7
31.9	3K	TBASIC.8	CHAPTER 8
31.10	2K	TBASIC.9	CHAPTER 9
31.11	3K	TBASIC.10	CHAPTER 10
31.12	3K	TBASIC.11	CHAPTER 11
31.13	2K	TBASIC.12	CHAPTECT DESCRIPTION
31.30	3K	TBASIC.CPM	SPECIAL INSTRUCTIONS
31.31	21K	TBASIC.COM	EXECUTABLE MODULE
31.32	43K	TBASICA4.ASM	SOURCE MODULE
31.33	55K	TBASICA5.ASM	SOURCE MODULE
31.34	26K	TBASICA6.ASM	SOURCE MODULE
* DROP <numeric expression>,<numeric expression>
Drops the assignment of the logical device selected by the first
expression to the physical device selected by the second expression.
Examples:   DROP 1,1     DROP LOGICAL,PHYSICAL    DROP PRINTD,TTY

END
Puts BASIC back in command mode.  Normally the last statement in
a program.  Not required.  Example:    END

FOR <variable name> = <expr1> TO <expr2> [STEP <expr3>]
Execution sets <variable name> = <expr1>.  The program then proceeds
until a "NEXT
    programs.

    Line descriptors need only be used on lines which are referred
    to by another statement, such as a GOTO, GOSUB, GOPROC, RESTORE,
    etc.  Line descriptors are used in a similar fashion to the
    labels in assembly language.  A line descriptor may be a number,
    just as in normal BASIC's, but need not be in any order.  Line
    descriptors usually are chosen with names that mean something
    in the program, so that it will be easy for the programmer to
    remember the n named "SORT".
	10 FOR N=1 TO 5		Line numbers can still be used, but need
	05 PRINT N,SQR(N)	not be in order, and are not used to
	20 NEXT N		edit in the same manner as other BASIC's.





















				2






R 12
31.14	2K	TBASIC.13	CHAPTER 13
31.15	2K	TBASIC.14	CHAPTER 14
31.16	2K	TBASIC.15	CHAPTER 15
31.17	3K	TBASIC.A	APPENDIX A
31.18	3K	TBASIC.B1	APPENDIX B PAGE 1
31.19	3K	TBASIC.B2	APPENDIX B PAGE 2
31.20	3K	TBASIC.C	APPENDIX C
31.21	2K	TBASIC.D1	APPENDIX D PAGE 1
31.22	2K	TBASIC.D2	APPENDIX D PAGE 2
31.23	3K	TBASIC.E	APPENDIX E
31.24	1K	TBASIC.H	APPENDIX H
31.25	3K	TBASIC.I	APPENDIX I
31.26	2K	TBASIC.J	APPENDIX J
31.27	1K	TBASIC.K	APPENDIX K
31.28	3K	TBASIC.IND	INDEX
31.29	3K	TBASIC.AD	PRODU" statement is encountered.  <expr3> (or 1 if STEP <expr3>
is omitted) is then added to <variable name>.  If <expr3> < 0 and
<variable name> >= <expr2>, or if <expr3> >0 and <variable name> <= <expr3>,
then the program continues with the statement following the "FOR" statement.
Otherwise, the program continues after the "NEXT" statement.
Example:  FOR N=1 TO 5        Example:  FOR IND=START TO FINISH STEP INCR

* GOPROC <line descriptor>[,<variable list>]
Calls the statement <line descriptor>, passing the variables on the
list.  Similar to GOSUB, except it allows the subroutine to have
local variables, which are not affected by assignments outside
the procedure.  Also allows passing variables to the subroutine.
The subroutine need not contain a PROCEDURE statement.
Example:    GOPROC SEARCH,STR1$,STR2$,POSITION


GOSUB <line descriptor>
A subroutine call is made to the line indicated.  That is,
execution continues at <line descriptor> until a RETURN statement
is encountered, at which time einues
with the line following the IF statement.  The logical connectives
allowed in <logical expression> are:  AND, OR, NOT, >, <, = .
See Appendix B for explanation of logical expressions.
Examples:  IF X<128 AND X>31 GOTO EXTRA    IF STR$<>"NO" GOTO 100

* IF <logical expression> THEN <statement> [ELSE <statement>]
If the value of <logical expression> = -1 (true), then the first
<statement> is executed.  Otherwise, it is not.  If the ELSE option is
used, the second statement is executed if the vaA carriage return must be used to terminate string input.
Examples:  INPUT A,B$    INPUT "FILENAME";NAM$

			    7









[LET] <variable name>=<expression>
Assigns the value of <expression> to <variable name>.  The word
"LET" is optional.  Examples:  LET X$=Y$+Z$    LET INDEX=5

NEXT [<variable list]
Terminates a "FOR" loop.  Without the optional variable list,
it terminates the most recent loop.  See the "FOR" statement.
Examples:  NEXT        NEXT N        NEXT I,J,K

ON <numeric expression> GOTO <line descriptor list>
Transfers execution (branches) to the line in the list corresponding
to the value of INT(<numerith the next statement.  If
it's less than zero, an error results.
Examples:  ON I GOSUB 20,5,100,10     ON 2*I GOSUB TEST+2,SUBR5

OUT <expression1>,<expression2>
Sends byte resulting from <expression2> to port <expression1>.
Examples:  OUT 1,7    OUT PORT,DATA    OUT X-5,Z+2

POKE <expression1>,<expression2>
Stores byte <expression2> in memory location <expression1>.
Examples:  POKE 4096,255    POKE ADDRESS,BYTE    POKE A+256,48+N

PRINT <expression list>  or   ?<expression list>
Prints the vxecution is continued at the
statement following the GOSUB statement.
Examples:  GOSUB CALC    GOSUB 10570    GOSUB GET+1

GOTO <line descriptor>
An unconditional branch is made to the line indicated.  That is,
execution continues at <line descriptor> instead of the next
statement.  Examples:  GOTO 100    GOTO LOOP+2    GOTO LAST-5

* IF <logical expression> GOTO <line descriptor>
If the value of <logical expression> = -1, then execution
continues at the line indicated.  Otherwise, execution contlue of <logical
expression> is false.  See Appendix B for def. of logical expression.
Examples:  IF ANS$="YES" THEN GOSUB INSTR        IF 3*Y=4 THEN PRINT "OK"
	   IF ARRAY(N)=0 THEN GOTO LOOP ELSE STOP

INPUT <variable list>
Assigns entries from the console device to the variables on the list.
Prompts may be included by enclosing a string expression in quotes,
separated from the variables by semicolons.  Prompts are printed in
the order they appear on the list.  With no prompt, a "?" is printed.
ic expression>).  If <numeric expression>=0 or
if it's greater than the number of line descriptors, execution
continues with the next statement.  If it's <0 an error results.
Examples:  ON N GOTO 10,20,30,40    ON N-2 GOTO FIRST,CALC,LAST

ON <integer expression> GOSUB <line descriptor list>
Calls a subroutine at the line in the list corresponding to
the value of <integer expression>.  If <integer expression>
equals zero, or if it's greater than the number of line
descriptors, execution continues walue of each expression on the expression list
onto the console device.  Spacing between elements is defined
by punctuation.  A comma starts the following element at the
next 14 column field.  A semicolon starts the following
element immediately after the preceeding element.  If the last
character of the list is a comma or a semicolon, no carriage
return will be printed at the end of the statement.  Otherwise,
a carriage return will be printed at the end of the statement.
Examples:  PRINT "X=",X    PRINT 33*X,A$,CHR$(7)

* PROCEDURE <variable list>
Used to declare local variables.  The variables on the list can be
used without disturbing their original values.  The original value
of each variable will be restored by the next RETURN statement.
See RECEIVE and RETURN statements.
Examples:  PROCEDURE ANS$,X    PROCEDURE A,B,RESULT

READ <variable list>
Assigns the value of each expression of a "DATA" statement to
a variable on the variable list, starting with the first element
of the first "D		ERROR CODE EXPLANATIONS

The system of programming error detection and reporting
in TARBELL BASIC is a compromise between the need for
clear error reporting, and the memory required for error
detection and messages.  Some systems use error code numbers,
or 1 or 2 code letters.  These usually have to be looked up
in the reference manual, so they waste time.  Some use long
english explanations, which are nice, but take up a lot of
memory space.  TARBELL BASIC uses abbreviated messages, which
are hable name used as statement name.
10   SYNTAX		The statement was not properly formed.
11   VRBL NM		Illegal variable name.
12   >>)		Too many right parenthesis.
13   >>(		Too many left parenthesis.
14   2 OPERS		Two operators in a row.
15   2 OPANDS		Two operands in a row.
16   ILGL FUNC		Illegal user defined function.
17   STATE AS VRBL	Statement name used as variable.
18   NEW SYMB		New symbol when in command mode.
19   NO TO		No "TO" in "FOR" statement.
20   DUPL STATE		Statement name used twi NUM		A string is used where a number is needed.
33   NUM AS STR		A number is used where a string is needed.
34   CNTRL STCK		Control Stack error.
35   ON GOTO		ON...GOTO, GOSUB index out of limits.
36   <<DATA		Out of Data.
37   RCV DATA		Receive data error.
39   -SQR		The square root of a minus number is illegal.
40   LOGICAL		A true (-1) or false (0) was expected.

The message BASIC IS CRASHED indicates that the BASIC interpreter
has be written into, thus making the interpreter unreliable.  ThiLogical Operators:

OR, AND, and NOT are used as logical operators in IF statements.
OR and AND operate on the logical expressions between which
they are placed, while NOT operates on the logical expression
following it.  Remember that the value of a logical expression
must be either -1 (true) or 0 (false).

OR
When OR is placed between two logical expressions, the total
expression is true if either or both of the two logical expressions
are true.

AND
When AND is placed between two logical exATA" statement.  Expressions of the "DATA"
statement(s) are evaluated when the first element of the "DATA"
statement is read.  Examples:  READ X,Y,z$    READ TABLE(N)


			   8









opefully easy to remember after they're looked up the first
time.

No.  Mnemonic		Description

1    OVRFLW		Arithmetic Overflow (too large a number).
2    UNDRFLW		Arithmetic Underflow (too small a number).
3    /0			A division by zero was attempted.
4    EX>>		Exponent was too large (EXP function).
5    BIN CON >>		Number too large to convert to binary.
6    -LOG		Attempted to take log of a minus number.
7    STATE NM		Illegal statement name.
8    COMM		Illegal command.
9    VRBL AS STATE	Varice (duplicate).
21   DUPL DEF		A function was defined twice.
22   CAN'T CONT		Can't continue 'cause program was modified.
23   TAPE		An error was detected on a tape read.
24   STRING		Illegal string usage.
25   COMMA		Illegal comma or semicolon.
26   OPRND		Illegal Operand.
27   <*mem*>		Out of memory.
28   UNDIM		Undimensioned array referenced.
29   SUBSCPT>>		An array subscript was too large.
30   SUBSCPT OVFLW	Subscript overflow.
31   ASSIGN		An assignment to a non-variable (4=4).
32   STR ASs
message may be inhibited by making a slight change in BASIC.

			    A






pressions, the total
expression is true if and only if both of the two logical
expressions are true.

NOT
When NOT is placed before a logical expression, the total
expression is true if the logical expression is false,
and the total expression is false if the logical expression
is true.

Below are truth tables for the three logical operators, where
T stands for TRUE (-1), F stands for FALSE (0),
and A and B are logical expressions:

    A    B    A OR B    A AND B    NOT A

    F    F      F          F         T
    F    T      T          F         T
    T    F      T          F         F
    T    T      T          T         F

Examples:

0 AND 1 equals 0
1 AND 1 equals 1
2 AND 1 equals 0
2 AND 3 equals 2

0 OR 1 equals 1
1 OR 1 equals 1
2 OR 1 equals 3
2 OR 3 equals 3

NOT 0 equals -1
NOT -1 equals 0
NOT 1 equals -2






				15















	Known Bugs, Limitations, and Peculiarities

Hopefully this section will remain small.  We have, however,
decided to not ignore the fact, like some manufacturers do,
that there will be forever bugs and other strange things in
the system.  To expect us to be perfect is asking too much,
but we will at least work toward that objective.  In that
direction, we have already spent several months searching
for these vermin, and exterminating them as quickly as
possible.  But we know that our customers will  will evaluate to 0, since integer mode
is retained until a floating point value is seen.  Use the
expression  1./2  or  1/2.  to get the correct answer of .5 .

The LET statement name gets put in if you don't use it.

Parentheses may get rearranged to an equivalent sequence.
This is a product of the way expressions are represented internally.

Tabs are not allowed in the middle of a statement.

Random numbers evidently always end in the digit 5.

If an array is DIMensioned to size n, an attems, it backs up.

Negative offset to line descriptor doesn't always work right.

HEX$ returns with leading zeroes.



				I




Commands:

* BYE
Causes a jump to location 0000 in memory.  Example:  BYE

* CADD <variable name>
Causes the program on cassette tape designated by the first character 
of <string expression> to be loaded into memory in addition to any
programs already in memory.  This will allow the user to build a
library of subroutines and use them in various programs without
forever having to re-enter them.  Other features, such as procedures,
assist in this function.  Example:  CADD T

CLEAR [<expression>] find some for
us, so we'd appreciate it if you would let us know, preferably
in writing, when you see any of these creatures creeping about.
This page of the manual will change from one release to the
next, with an effort to make the page match the release.


CTL STK ERROR message is somewhat obscure.

A space is required after all statements.

Assignments of values to variables are not allowed in command
mode unless the variable has been previously defined in a
program.

The expression  1/2pt to print array(n+1)
will print garbage instead of giving an error message.

Two colons in a row in a statement line will cause a crash.

When entering a number in exponential (E) format, always put either
a space, minus sign, or plus sign after the E, then two digits.

The logical expression  NOT -1  produces an error message.

Sometimes goes into ENTRY mode at the wrong time.

After filling up memory with statements, error messages
are incorrect.

In EDIT, if you delete too many character
Sets all program variables to zero.  Sets all strings to nulls.
Releases all string and array space.  In ALTAIR BASIC,
"CLEAR <<expression>>" defines the amount of space to allot
for strings.  TARBELL BASIC will automatically allot all space not
being used for actual programs to strings and arrays.  To maintain
compatability with ALTAIR BASIC, "CLEAR <expression>" will be
processed identically to the CLEAR command.
Examples:  CLEAR		CLEAR 2000  (does the same thing)

CLOAD <variable name>
If TARBELL BASIC is in command mode, the program on tape defined
by the first letter of <variable name> is loaded into memory.  A
"NEW" command is automatically issued before the program is loaded.
If TARBELL BASIC is in the program mode, that is, a program is
running, this command causes the data comming from the recorder
to be assigned to <variable name>.  The type of the variable
name must match the type of data being read.
Examples:  CLOAD I	CLOAD PROGRAM		CLOAD DATA
NOTE:  If a syntax error is discovllowing the break, unless an input
from the terminal was interrupted.  In the latter case, execution
resumes with the interrupted statement.  Execution cannot be
continued if the program or variables were modified by direct
mode entries.  Example:    CONT

CSAVE <variable name>
If TARBELL BASIC is in command mode, this command saves the
program currently in memory, on cassette tape, under the name
specified by the first character of <variable name>.  If TARBELL
BASIC is running a program, the valuSPECIAL INSTRUCTIONS FOR USE OF CP/M VERSION OF TARBELL CASSETTE BASIC

The CP/M version of TARBELL CASSETTE BASIC is not only set up to run
on CP/M, but also has some CP/M disk I/O capability.  This includes
writing and reading TARBELL BASIC programs to and from CP/M disk,
and writing and reading string and numeric data to and from CP/M disk.
It does not include, however, the capability of accessing random files,
or of having more than one disk file open at a time.  Of course if you
bought the sourgram, and don't want the number typed, you
    can use LET <variable name> = USR(LOC("filename")) instead.

2.  To close the current CP/M file, use  ?USR(0) .  Again, the
    LET statement may be used instead of the PRINT statement (?).

3.  To open the current CP/M file without changing the name in
    the file control block, for example after naming the file
    after the TBASIC in CP/M, use  ?USR(1).  This will open
    the file without putting a name into the file control block.

4.  To writer
    either saving or loading a program.

7.  To write data from main memory onto disk (only during a program),
    first open the file as shown in 1 or 3 above, then use CSAVE x,
    where x is the name of the variable you want saved.  More than
    one variable may be saved onto one file, but be sure to close
    the file after saving all the variables required.

8.  To read data from disk into main memory (only during a program),
    first open the file as shown in 1 or 3 above, then use CLOADered in a line being read in
       from cassette, the line will be stored as a REMark.

CLOAD? <variable name>
Compares the program or data in memory with the program or data
on cassette tape with the same name.  If they are the same, 
"FILE OK" is printed.  If not, "BAD FILE" is printed.
Examples:  CLOAD? I	CLOAD? PROGRAM		CLOAD? DATA

CONT
Continues program execution after a control/C has been input or
after a "STOP" or "END" statement has been executed.  Execution
resumes at the statement foe of <variable name> is saved.
Examples:	CSAVE I		CSAVE PROGRAM	CSAVE DATA


			    3






ce, you are encouraged to try implementing these features
and sharing your experience with others.

The normal sequence to access CP/M files is as follows:

1.  To open a CP/M file from TARBELL CASSETTE BASIC, type
	?USR(LOC("filename"))
    where filename is the name of the file you wish to open.
    This filename can be any string expression, including a
    string variable name.  If you use the leading question mark,
    a number will be typed which has no meaning.  If you are
    within a pro the BASIC program from main memory onto disk, first
    open the file as shown in 1 or 3 above, then type
	CSAVE x
    where x is a one-letter code which gets put at the top of the
    program, and which must be used in any later CLOAD.

5.  To read a BASIC program from disk into main memory, first open
    the file as shown in 1 or 3 above, then type
	CLOAD x
    where x is the same one-letter code which was used in the CSAVE.

6.  Be sure to remember to close the file as shown in 2 above, afte x,
    where x is the name of the variable you want to read.  More than
    one variable may be loaded from the file, but be sure to load
    them in the same order they were saved, and close the file after
    all variables have been loaded.
		Reserved Word List

These words should not be used as statement identifiers or
variable names:

ABS  AND  ASC  ASSIGN  ATN  BGET  BLOAD  BPUT  BSAVE  CADD 

CALL  CHANNEL  CHR$  CLEAR  CLOAD

CONT  COS  CSAVE  CSAVE!  DATA  DEF  DELETE  DIM  DROP

EDIT  ELSE  END  ENTER  EXP  FOR  FRE  GOPROC  GOSUB  GOTO

HEX  HEX$  IF  INP  INPUT  INT  LEFT$  LEN  LET  LIST  LOC  LOG

MATCH  MID$  NEW  NEXT  NOT  OCT$

ON  OR  OUT  PEEK  POKE  POS  PRINT  PROCEDURE  READ  RECEIVE

REM  RESTORE  RETURN* RECEIVE <variable list>
Transfers values of variables from "GOPROC" or "RETURN" statement
to <variable list>.  The variables on the list are filled in
the same order that the variables appear on the GOPROC or RETURN
statement.  Examples:  RECEIVE X    RECEIVE RES$,ANSWER

REM[anything]
Allows insertion of remarks in the program text.  The remarks
must follow the REM statement on the same line.
Examples:  REM   THIS PROGRAM CALCULATES TRIG TABLES
           REMARK   READ THE FILE FROM CASSETTE.
f the variables on the list to
the variables on the list of a "RECEIVE" statement.
Examples:  RETURN    RETURN N    RETURN X$,ANSWER,RESULT$

STOP
Terminates execution of the BASIC program, and returns
back to the command mode.  Example:  STOP

WAIT <expr1>,<expr2>,<expr3>
An input from port <expr1> is performed.  The byte received
is XOR'd with <expr3> if included, and AND'ed with <expr2>.
The above operation is repeated until a non-zero result is
obtained, upon which the next statement is exec		DEFINITIONS OF TERMS USED IN THIS MANUAL

<numeral>
Any of the following:  0  1  2  3  4  5  6  7  8  9

<letter>
Any of the following:  A  B  C  D  E  F  G  H  I  J  K  L  M
		       N  O  P  Q  R  S  T  U  V  W  X  Y  Z

<character>  or  <alphanumeric character>
A <numeral>, a <letter>, a space, or any of the following:  
! # $ % & ' ( ) = - ^ ~|~^| \ @ { } [ ] + ; * : < > , . ? /

<numeric constant>
A number, represented by a series of numerals, preceeded by
an optional plus (+) or minus
There is no limit to the length of any string constant (literal), variable,
or array element.  Any alphanumeric character is legal.  The second quote
enclosing the string constant is optional at the end of a line.
Examples:  "ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789 !"    "#$%&'()"

<constant>
A value which is named as such explicity in the program.  May be 
either a <string constant> or a <numeric constant>.
Examples:    "DON TARBELL"    3.14159    2    "ABCDEFG"

<expression>
A sequence of consta  RIGHT$  RND  RUN  SGN  SIN  SPACE$  SPC  SQR

STEP  STOP  STR$  SYMBOL  TAB  TAN  THEN  TO  USR  VAL  WAIT







				H






RESTORE [<line identifier>]
Sets the READ DATA pointer to the first data statement, or,
optionally, to the statement <line identifier>.  This allows
reading seperate tables or seperate portions of a table without
having to read through all DATA statements.
Examples:  RESTORE      RESTORE TABLE2       RESTORE START+5

RETURN [<variable list>]
Causes execution to continue at the statement following the last
"GOSUB" statement executed.  If the optional variable list is
included, passes the values outed.
Example:  WAIT 0,1    WAIT PORT,MASK,INVERT





















			   9









 (-) sign, including an optional decimal
point (.), and ending with an optional "E" followed by a power of ten.
The range of a floating point number (one with a decimal point) is
from 9.9999999E99 to 9.9999999E-99, plus and minus.  The range of
a integer number is from 0 to 9999999999, plus and minus.  Expressions
evaluate to integers if and only if every element of the expression
evaluates to an integer.

<string constant>
A string constant is a sequence of any characters, enclosed by quotes (").
nts and/or variables, separated by operators
according to certain rules (see pages 14&15) and optionally grouped
by parenthesis.
Examples:  1    X    "ABC"+REST$    3*(X/Y)    SQR(B^2-4*A*C)

<numeric expression>
An expression which evaluates to a number.
Examples:  1+1   2*(3+5)   N/2   4*LEN(STRING$)   SIN(X)

<string expression>
An expression which evaluates to a string.
Examples:  LEFT$("ABCDEFG",3)   "123"+"ABC"+A$   CHR$(N+64)

<expression list>
A sequence of expressions normally separated by commas or semicolons.
Examples:  "THE COST IS ";COST;" DOLLARS.",TOTAL,X*5/Y    X,Y    X

<variable>
An entity which can assume different values, either string or numeric.

<variable name>
A sequence of numerals or letters, beginning with a letter,
which is used to identify a particular variable.  If a variable
name ends with a dollar sign ($), it is forced to a string.

			    B-1






			MEMORY USAGE

Address Range	Description
(hexadecimal)

0000 - 00FF	Unused, available space for your stuff.
0100 - 04FF	Standard Input/Output Routines (Listing Included).
0500 - 0502	A jump instruction into TARBELL BASIC.
0503 - 0504	CHANL - Contains the address of the Channel Table.
0505 - 0506	TRMNL - Contains the address of the Terminal Table.
0507 - 0508	SSSS - Defines the end of useable memory.  If zero,
		causes BASIC to use all available memory.
0509 - 050A	CNVRA - Defines the number ofints to token to be scanned next.
0519 - 051A	CHCK - Points to checksum routine.
051B - 051C	INFL - Integer to Floating, (HL) to (DE).
051D - 051E	FLIN - Floating to Integer, (HL) to (DE).
051F - 0520	STNM - String at (HL) to number at (DE).
0521 - 0522	NMST - Number at (HL) to string at (DE).
0523 - 0524	CMPR - Zero and carry set as for (HL)-(DE).
0525 - 0526	SINE - Sine(HL) to (DE).
0527 - 0528	SICO - Cosine(HL) to (DE).
0529 - 052A	TANG - tangent(HL) to (DE).
052B - 052C	ATAN - Arctangent(HL) tmay be in ROM.
		Note that these addresses may change with versions.
53C6 - XXXX	Interpreter Workspace, must be in RAM. (fixed length)
XXXX - XXXX	Program Source, in internal form. Fixed at RUN time.
XXXX - XXXX	Variables and Array Pointers.  Fixed at RUN time.
XXXX - XXXX	FOR/NEXT and local variable stack.  Dynamic.
XXXX - XXXX	Input Line Space.  Dynamic.
XXXX - XXXX	Array and String Space.  Dynamic.
XXXX - XXXX	Symbol Directory.  Fixed at RUN time.
XXXX - XXXX	Symbol Table.  Fixed at RUN time.
	INTERNAL FORMATS (continued)

String Array Pointer Format:
  Byte 0:  bit 0-not used, bit 1=0, bit 2=0, bit 3=1, bit 4=0,
	   bit 5=0, bit 6=0 if not array,=1 if array, bit 7 not used.
  Byte 1 = number of dimensions.
  Bytes 2&3 is a pointer to string locator or string.
  Bytes 4&5 are not used.
String variables are treated internally as single dimension arrays.

Numeric Array Pointer Format:
  Byte 0:  bit 0=0 if integer, 1 if floating point.
	   bit 1=0, bit 2=1, bit 3=0, bit 4=0, bit 5=0,
  digits that will be printed
		in normal (as opposed to scientific) notation.
050B - 050C	FPRAA+6 - Contains the address of a location which contains
		the address of a user routine accessed by the USR function.
050D - 050E	MODES - Contains the address of the MODES Table.
050F - 0510	FSRC - Address of pointer to start of source.
0511 - 0512	ESRC - Address of pointer to end of source.
0513 - 0514	ERROR - Pointer to error routine.
0515 - 0516	TSCN - Points to token just scanned.
0517 - 0518	NSCN - Poo (DE).
052D - 052E	BCDB - Number at (HL) to binary in HL.
052F - 0530	BBCD - Binary number in HL to number at (DE).
0531 - 0532	ETOX - E to the (HL) power to (DE).
0533 - 0534	LOGX - Log base E (HL) to (DE).
0535 - 0536	SQUR - (HL) to 1/2 to (DE).
0537 - 0538	PWRS - (HL) to the (DE) power to (BC).
0539 - 053A	ADDER - (HL)+(DE) to (BC)
053B - 053C	SUBER - (HL)-(DE) to (BC)
053D - 053E	MULER - (HL)*(DE) to (BC)
053F - 0540	DIVER - (HL)/(DE) to (BC)
0541 - 53C5	The TARBELL BASIC interpreter, which 	End of Specified Memory.

Allocation Notes:
Before runtime, will consist only of moving the symbol directory
as the symbol table grows.  At runtime, variable and array pointers
fished out of symbol directory and space assigned.  As local variables
are encountered, they are assigned on the stack.  Arrays and strings
are assigned by sequential assignment-random release- clean up garbage
when full.

			    C







          bits 6&7 are unused.
  Byte 1 = number of dimensions.
  Bytes 2&3 is a pointer to table location.
  Bytes 4&5 are not used.

Numeric Format (constants and variables)
  Byte 0:  bit 0=0 if integer, 1 if floating point.
	   bit 1=1, bit 2=0, bit 3=0, bit 4=0, bit 5=0,
	   bit 6 is sign of exponent, bit 7 sign of mantissa.
  Byte 1 = BCD exponent if floating point, MSD, MSD-1 if integer.
  Byte 2 = LSD+7, LSD+6
  Byte 3 = LSD+5, LSD+4
  Byte 4 = LSD+3, LSD+2
  Byte 5 = LSD+1, LSD



























			    D-2









Statements:

* ASSIGN <logical device number>,<physical device number>
Assigns a physical device to a logical device.  Internally,
this command sets a bit in the MODES table.  See Appendix E
for a list of the logical and physical devices.
Examples:  ASSIGN 3,1   ASSIGN PR,CRT   ASSIGN LOGICAL,PHYSICAL

* BGET <variable name>
Reads from Binary Input logical device into named variable.
Example:   BGET ITEM(N)   BGET X   BGET ARRAY(X,Y)

* BLOAD <string expression>
Reads a program named <string exable of the assignments of physical to logical
devices.  See Appendix E for the default assignments.

DATA <expression list>
Specifies data to be read by a "READ" statement.  Expressions
are allowed.  String constants must be enclosed by quotes.
Example:  DATA 1,3,5,7,X+Y,Z^2,"DON"+"TARBELL"

DEF FN<function name>(<variable list>)=<expression>
Defines a function.  The function name can be any legal variable
name.  The variable list is a list of dummy variables representing
the variables in the fuaximum subscript permissible.  The smallest is 0.  If no "DIM"
statement is encountered before a reference to an array,
an error message is given.  Multiple arrays may be dimensioned.
Arrays are cleared to zero (numeric) or null (string).  Real
subscripts are allowed in array references, and if used, the
integer part of the subscript will be used for the reference.
Examples:  DIM PARTNO$(100),X(3,10),VERYLONGNAMESAREALLOWED(5)




			    6






		******* TARBELL BASIC *******

TARBELL CASSETTE BASIC is now being delivered to customers.
The retail price is $36, including manual, for Tarbell Cassette
Basic either on cassette or CP/M disk.  The CP/M version is
capable of limited disk interaction, including saving and
loading programs and data.  Disk accesses are limited to one
sequential file at a time.  The interpreter occupies 21k of
RAM, implements most of the features of ALTAIR* Extended BASIC
plus assignment of I/O, long variable names,pression> into memory from the
binary input logical device.  All characters of string are used.
Examples:   BLOAD "PAYROLL"   BLOAD PROGNAME$

* BPUT <variable name>
Writes the named variable onto the binary output logical device.
Examples:   BPUT ITEM(N)   BPUT X   BPUT ARRAY(X,Y)

* BSAVE <string expression>
Writes a program named <string expression> onto the binary output
logical device.  All characters of the string are used.
Example:  BSAVE "PAYROLL"    BSAVE PROGNAME$

CHANNEL
Prints a tnction call.  The value of the function is
determined by substituting the values of the variables into the
expression.  Functions may be nested to any depth, and string
functions are legal.  Any number of variables can be used.
Examples:   DEF FNCUBE(X)=X*X*X   DEF FNL3(S$)=LEFT$(S$,3)
	    DEF FNRMS(X,Y) = SQR(X^2+Y^2)

DIM <array name>(integer)[,<array name>(integer)]...
Allocates space for array variables.  Any number of dimensions
per array are allowed. The value of each expression gives the
m cassette data save,
procedures with local variables, and alphanumeric line labels.
The source listing is available on paper or disk for $25.

The commands that are implemented are BYE, CADD, CLEAR, CLOAD,
CONT, CSAVE, CSAVE!, DELETE, ENTER, LIST, NEW, RUN, SYMBOL, and
EDIT (with 17 one-letter editing commands).

The statements are ASSIGN, BGET, BLOAD, BPUT, BSAVE, CHANNEL,
DATA, DEF, DIM, DROP, END, FOR, GOPROC, GOSUB, GOTO, IF, INPUT,
LET, NEXT, ON..GOTO, ON..GOSUB, OUT, POKE, PRINT, PROCEDURE,
READ, RECEIVE, REM, RESTORE, RETURN, STOP, and WAIT.

The intrinsic functions are ABS, ASC, ATN, CALL, CHR$, COS, EXP,
FRE, HEX, HEX$, INP, INT, LEFT$, LEN, LOC, LOG, MATCH, MID$,
OCT$, PEEK, POS, RIGHT$, RND, SGN, SIN, SPACE$, SPC, SQR, STR$,
TAB, TAN, USR, and VAL.

TARBELL BASIC has several features not found in other BASIC's.
With the use of the ASSIGN and DROP statements, up to ten physical
devices may be assigned or de-assigned to 6 different logical
I/O devices.  To improve readability and's needs.  Good access to a
user's machine-language subroutines are provided by the CALL function,
which has two arguments:  the address of the subroutine, and the
number which is to be passed to the subroutine in registers D&E.
The passing of string arguments to CALL'ed subroutines is facilitated
by the LOC function, which returns the location of the value of any
variable.  Of course, the usual USR, PEEK, and POKE are included.

Be sure to specify whether you are ordering TARBELL CASSETTE BASIC
on		RELATED PUBLICATIONS

USER'S GUIDE FOR BASIC-E by John K. Jacobs, JEM COMPANY,
Suite 301, 2555 Leavenworth St., San Francisco, CA 94133

BASIC PROGRAMMING by John G. Kemeny, Thomas E. Kurtz, 1967 and
BASIC, by Albrecht, Finkel, and Brown, 1973 and
101 BASIC GAMES, Ed. David Ahl, 1974 and
WHAT TO DO AFTER YOU HIT RETURN and
COMPUTER LIB & DREAM MACHINES, Theodore H. Nelson, 1974
all available from People's Computer Company,
P.O. Box 310, Menlo Park, California 94025

A GUIDED TOUR OF COMPUTER INDEX

ABS  10
Altair BASIC  1
AND  15, B-2
angles  1
append
   from cassette  3
   in edit mode  5
ASC  10
ASSIGN  6
ATN  10
BASIC texts  K
BGET  6
BLOAD  6
BPUT  6
brackets  1
branch  7
BSAVE  6
bugs  I
CADD  3
CALL  10
Cassette  3, 4, 6, E, J
change  5
CHANNEL  6
CHR$  10
CLEAR  3
CLOAD  3
colon  1, 4
commands  3, 4, 5
CONT  3
Control Characters  1, E-3
COS  10
CSAVE  3
CSAVE!  3
DATA  6, 8
DEF  6
definitions  B
delete characters  5
DELETE lines  4
DIM  6
Direct Mmitations  I
line descriptors  2
LIST  4
loading BASIC  J
LOC  11
LOG  11
logical
   device  6, E-2
   operations  7
   operators  15, B-2
loop  7, 8
machine language
   input/output  8, 9, 11, E
   memory access  8, 11, 12
   subroutines  6, 10, 13
MATCH  11
memory usage  C
MID$  11
Modes of Operation  1
multiple statements  1, 4
NEW  4, 3
NEXT  8
NOT  15, B-2
OCT$  12
ON  7
operators
   arithmetic  14
   string  14
   logical  15
OR  15, B-2
OUT  8
peculiarities  I
PEEK  12 maintainability, long
variable names are allowed, and alphanumeric line descriptors may
be used in place of the usual line numbers.  The use of procedures
allows arguments to be passed to subroutines, and local variables
may be declared so that subroutine libraries can be developed and
used efficiently.  These subroutines may then be appended to Tarbell
Basic programs using the CADD command.

The I/O section listing is included with the documentation, and may
be easily modified to fit the customer cassette or CP/M disk, and whether you want the source listing
on paper (about 200 pages) or CP/M disks (2).  The I/O sections
are the only thing that is different between the two implementations.


















PROGRAMMING IN BASIC by Thomas A. Dwyer
and Michael S. Kaufman; Boston: Houghton Mifflin Co., 1973

CBASIC a REFERENCE MANUAL by Software Systems, 1977
P.O. Box 1705, Vallejo, California, 94590































				K









ode  1
DROP  7
EDIT  5
Edit Mode  1, 5
ELSE  7
END  7, 3
ENTER  4
Entry Mode  1, 4
error codes  A
execution  4
EXP  10
expression
   definition  B-1
   list  B-1
   logical  B-2
   string  B-1
FOR  7, 8
functions  6, 10, 11, 12, 13
FRE  10
GOPROC  7
GOSUB  7
GOTO  7
HEX  10
HEX$  10
IF  7
INP  11
INPUT  7
input/output  3, 4, 6, 7
   8, 9, 11, E
insert
   characters  5
   lines  4
INT  11
internal formats  D
intrinsic functions  10, 11, 12, 13
LEFT$  11
LEN  11
LET  8
li
physical device  6, E-2
pointer
   edit  5
   internal  D
POKE  8
POS  12
power  10, 14
PRINT  8
PROCEDURE  8
program examples  G
publications  K
question mark  4, 7
READ  8, 6
RECEIVE  8, 9
REM  9
reserved words  H
RESTORE  9
return from edit mode  5
RETURN  9
RIGHT$  12
RND  12
rubout  1, 5
RUN  4
Run Mode  1
sample runs  F
search  5,  11
semicolon  7, 8
SGN  12
SIN  12
SPACE$  12
SPC  12
SQR  12
statements  6, 7, 8, 9
STEP  7
STOP  9, 3
STR$  12
string
   commands  5
   definition  B-1
   functions  10, 11, 12, 13
   internal format  D
   operators  14
   statements  6, 7, 8, 9
   subroutine  7, 9
SYMBOL  4
tab  1
TAB  13
TAN  13
THEN  7
TO  7
user defined
   functions  6
   subroutines  10, 13
USR  13
VAL  13
variable
   assignment  6, 7, 8, 9
   definition  B-1
   list  B-2
   local  8
   location  11
   name  B-1
   representation  D  
WAIT  9
$úÚ      `Ò$ï2* +*s#r*	6
!!*s#r*s͇*

͇*###6H##6
 6H#6 #6 	w#      (±>	> 	>	/^ #* O:P͑7 x!Q"N*NN#"N=2PyQ*:GFw#"x2[x[!X!"2f!y66 *~#"!4 6x *w#">2!4E[z{  =
!\ ͇!] w#
:M\  <> 2| \ ATT@BT=ET@UT%TTh6l&C&*f+#m$rV%H&V&d&r&1>U>2PUh2uU:So>2S!  "iU2kU͐*|ʂ*Ϳw*q!>2So>
TARBELL CASSETTE BASIC
BY REAL TIME MICROSYSTEMS, CHULA VISTA, CA
FOR TARBELL ELECTRONICS, CARSON, CA
RELEASE 5.2  AUGUST 16, 1978}o|g?|}b. U)-)2)7)<)A)F)K)P)T])~#x`		+~xwo\ ~G
¬=#
ʕ


ÿ{a_͐x=PY#\
	2S!S>͎A	'	 S\##>2SF#NV#^>@Gz_{/gxgz/@o		y		S## \ʚ	:Sʚ	>Gy͹##S>O:S2S2SS	x@G濰w#q \z@	 \ 	 ~ 	!$'"W  $(26*W}  %05@EW? $06BHT¥` !(5BIVc{z $2@HVdr} 	'6ETcr
  yʝ
oxʝ
!	қ
$o^xʼ
oyʼ
!	ҳ
$o~'_Ҽ
))))y
ox
!	
$o~'_
xoy!	
$o:S=G,
.
#
:SG+'

}o5
${_

>2SS!2T !T
\
>O!T
i
>O!T
v
>O!&T

>Oʒ
q<#	K


2SK
g>
2S2S2S2S>!S͎S##~
6>#͎##S \!SS?
F#NV#^>@G:S@xGw#q#21T>!:T
A
?w> +9!1T~R#X~##
X>2SS \>w2S2S!S>͎~£S \#>2S#S>Ow#!S \:S2S#2S+  _<                :<**6E2\  M\  7\  ! "2v><̓z[>̓ >̓x̓x~̓#yyn oO!Q̓̓ >n͸͸GO͸w#
©K͸n¸o_!
 ͷ 
y͓ Gþ!ͷ  ͓ Q!ͷ  ͓ Q͌ Q!.ͷ 6y#G͙ Qà!2ͷ Q͌ ͓ Q !>ͷ q
eg͙ Q:zJEËCEQyQxQRQ* * {zҷ* ~#" <AO GƐ'@'O xƐ'@'O N #   #|6 )|9|g7xG
{ X57hɧ#ž#>
>oY$)+F+N!Sᯆ#Gzxu> '/f7'?6 #=+~#V+GzWx
£w#++p=ÿ͖xO~wx@y'Ox<2S7ɠC̀ O/f'O@ 0x'G0x'G>  ><#͖H@ V#^+2SO 			S \+'+w
lO:S!S>¡>¦#>Pè> 'Һ+~'wڱ+~6 #O:S+qɯ
>~/fw#
7+~ 'w
##~++S ͯz''Wz'GK  S \S\!S:SO:SGv
q+p+:SO:SGv
q+p+:SO:SGv
q+p+:SO:SGv
q+p##:SO:SG:SO:SG#:SO:SG:SO:SG#:SO:SG:SO:SG:SO:SG:SO:SG#:SO:SG:SO:SG#:SO:SG:SO:SGv
y'w+x'w :S>P>!S'w+>!S>͎S	V#^2S :S!Sgx@w#q# \~++!͆~9%\T ͆C!\TbT]Td&bTYPV&bTi`r&bTi`\Tr&$\TbTi`H&Í!\T ~w͆~Oy#!SS~'+3~.#	FNv
!S~'w+~'w+++3>2S!S \+@>2S>2S#q_>2Sɯ2S2S>!S͎S##S \!S T&T!2T ¸6 #ëi&  T2 \!2TA+
6 x_ >
RS ! T
yO!T
yO!T
yO!$T
 yOq#<!2TXS#>
͎!S	~\>'G#L xXT ͆~~@¶#~G>	Ր#S \͹ \:T!ZMMDV&#>͎æ>2SGOOx~T#~>!T ͆~l \~# \~-:.::70>2<T2=T>!S͎2>TS ~-ʒ.tEʞ0:0:S> :>T<2>T#WÈ>OÈ#~- <O2?TG:?T2=T#>Aí#~0
7x>Oyʍ:=Tf:<Tmy@:<TG:=T==(:>TG:=TG:<T/<<Sy!S~G#
:!SXѯo& 
}ɯ2=Tx2<T:S2>T>@O>Ox2<TÈy>
O!S}_| Wʮw+á
ʺ6 +
î!SXѯɯ2@T2<TFx>-x##~+6 +6~O2?Tx2@T>2>T:Br&!\TbTDMH&ͯͯ!DTVTDMd&2bTh:bTP!DT \!JT \!\T \>2bT*nT&tT^!nTtTr&DT \bkVTd&!VTC(!"\T \!JT \>2CT:DTG!\T~w!DTBKr&VTBKr&!DTJTbTr&!JTDMH&!DTDMVTd&!\TDMbTH&         pyc!VTzTH&!zTT]rzTDTr&!DTT]VTd&!PT \tT\!\T\JT\!tTDThTd&!JTnTH&!hTnTDMr&!hTPTbTr&$!\TbTDMH&!JTDMH&!tTJTDMd&ͯ!DTVTDMd&s!\T \tT!tT;Cn!  wT
oO:TMʹT4c@
Yw	4 w#:TH+~#͹ Ϳ+A+za7~\w#6 :T͊zH>͹+w>
͹͊Ϳ]̀͚ɯ2T>2T    > s#ں%2pU:pU=2pU> >
#A*@U"gU2T4ڴ "lU`i"nU*nUMD*lU 4"gU*T,6#6#"iU*gUͯ2*iU+~w!  "iU*T."HU"FU"tT!  "DTʹL:}0}
*DT!  oR"DTR !=*DT|#"DT*T6#6yʳʳʳʹL
w#ó+~w!		^#VL>?͹tLUDICSQRKFBAMLT XPtLkU"T*gU"T2T*tT+,>
͹*FU>
͹*FU"HU*DT*lU"lU2kU	*DT*lU"lU	T*FU#"HUO*T"T2Tͥ>
͹Jʩ*gUͯ2*lU#"lU*nUMD 4"gU*Tҩ|TtT~#"HU͹J¶T*FU~"HU͹J>?͹<*HU~+~wß+*TDM*T*T:T#:MU#&ú%			++V+^~Wz:Tº%*T*T*TDM͆"T*T*T#DM*T͆"T*T#DM͆*T#"TDM*T+6 2T:T7*T"T#"T<2T~# ~"T, #"T~$0{a[A:*T6 #w	!#6#"T*T:T¨!*T|W}_*T"T*T 6	#ͥ)#ʝ"U)ʝ"})}!))#*T~K"ͽ$"͗!ú%
!:?U>
!?)#ʮ! ʮ!w#Ö!*T8!w#B!>6*T>"A"*T~F!#~N+ʶ!ͥ"?*T~"*T+6 "T>"*T>{ں%6#q#p#6#B!A"6zT ͆	6#"x

ʺ%GA"?*T?6 #"t"wc"#+~}"#> w#6#"T~">2T6ͥ" "!#
"¶">¾">@"
"O" ""<<="w#""ú%yB!

#T32@Tx@%:?T<2>T3#>
2>T62>T:?T=2<T#>2ATGS
!S~0w#
H:ATO!SR+~0i+
\	y2=T!S  :>T:ATʊ:=T>.:=T:<TʫO>0
 2<T~0¶
ʹ#:ATt:=TG:>TG>0:@T@>E> >-:?TG0x0:AT>.:CTG!bTwx2CT*\TLE*bT\}@W:dT7x@y?hTV&!iT~Y#N:hT bSbCښbDTr&!DTT]!DTbDMd&DTBKV&DTd&         !JTDMH&!JTPTBKd&ɯ2CT \T!\!JT\PT\!DTT]VTd&!DTPTbT))T])))DM)	
_ ?:tT!  |G9|/g}/o#>#>͎+>BK  d _R}i`S=Jú%!T	Wyʡ~#xi`)T^#V	Tdɯ> sç 
	
:pU<2pU>s-9
W#4+~#6 >
>
>  Ϳ:pU6(
>
 ÿ##~+H>@5>!+~#w>!#6 !
p> s~yc>
] > sÄ >s´ #ں%G>xÀ>Ú:TG~Wz͹#]2T>2T  >i-@Qfw*iU|4
1w#"iU1z~͹#8*DT+"DT|*FU*HU+"HU*FU6"HUO>
͹*FU*HU*FU8>\͹*HUT! *HU~͹kb#yʺ͆J>\͹*HU*FUN+~w#"HUy͹ù~ʹ6͹ù*HU"JTT*T#~*T*JT~G*?~*#*JT~͹~#"JTJ**JT"HUʹ
ʙTm~w#6"HU*HUKB]T͆	+~+~ww͹*HU#"HUO! "DT*HU+"HU~´+"HU~w͋O+~wù*T#"DT͋O>2Tß+*T"FU"BU"HU6*FU6 *DU>2~,#
+&#~,8 &#~8 &+~w>2T~9>2T:TU*T~R#Iw*T"T+~]
]#~ g"T:T2TѺ75w+6 +6 *T~{һaҼ[A:07*T~.:70zT&+??~w"Tͥͥ*TA   y5   <<& Gx:?U>" >" >><=OANNO><<NOި==>ͥ͗ں%>*T{	ں%*T6#q#p#6#"Tͥʛ ʥ  ?*T6#"T!ú%ͥ*T~  ú%ͥ*d ?͹  *T:T?>5͏)!>6#>4> "ʺ% "w##B# ʺ%w#,#6	+~	"T##"T8d6868 65W566,    U6 '( saTYP)x)`'b5U8pDT~2CT h$!nT \!r#x#nTBKd&>RxG#!DTtTDMV& \!JT\\T\PT!$(\!DTPTbTr&$J$ͯ!tTDTBKd&!bT\TBKH&$!\TnTDMd&:CT!\Td$r&ú%Cʺ%DT \Q% #!DTCڬ$DMr&yO xGґ$i& hT+!\T \!DTtTV&DMH&DMtTr&T]VTd&!JT \!DTJTbTr&$;%!JTBKH&!DTVTDMd&!\TbTDMH&%!\TBKd&!hT\TH&ú%Cʦ'"9Cگ'zTm$!zTDMd&!zT͢#~%7ʙ%T6!T:Sں%ò%!&x#	&:LU	&:T	&*DU"T>͏)>5͏)*T*vU%?%?1>U!M,2>U*vU!2S2LU2T2kU!  "iUx!&=0&=$&͊!&`82MU͇%	ԃê%͇%pê%͇%ê%͇%ܝ
Nê% ERROR INOVRFLUNDRFL/EX >BIN CON >-LOSTATE NCOMVRBL AS STATSYNTAVRBL N>> >> 2 OPER2 OPANDILGL FUNSTATE AS VRBNTLELOMIDOCTPEEPORIGHTRNSGSISPACESPSQSTRTATAUSVAMATCHEXCALLOHE*T(! ͥڴ *T~´ ?>?
*T~ʌ)>
>*Tw#"TƟ2?U͏)ͥ)?!)GOTTSTETHEΧGOSUELSŉ*T)
 y:T)J,J,J,* *
*	*ô x͏)ͥڴ )------=.@.-3*:T)͹-)H*>2?U͏)_ !*[i`OGOPROFOGOTGOSUIRECHANNEORESTORREMARCLOACSAVASSIGDATDEDIDROINPULEENNEXOUPOKPRINPROCEDURREARECEIVBSAVRETURSTOWAICLEABLOABPUBGET*T~-####xʟ+:pU 0-> ͹ -##~I-~O-!SR-!SR-!"S+V+^DT+*DU!DT+~w*DU͊-*T!)ʜ-´ +6 )͹-)})
º%!)d >2?U!)º%!))!)͹-)-!)J,´ ͥڴ .+:>Uʩ(?*T~+. ".#~=+.+#=.À,ͥ>͏)?2>U- !) r.=i.d.d.  +~i.#~r.*BU#*Tʠ.*Tʠ.~.F.À."BU*@U+.*T*DU+.*T*T"BUú%*BU+~.F..*T6*T*T##>/+6 +6 #
A0A0+> A0~F.MD͆A0+~#;0+4060@(1 (1(1(1A0r1~F.~	^1ɬ~46چ1!*֠Ö1ڠ1!^*ր1_2!^2@ڭ1!(@_2/ں1!)/_211111!A _2
1!o1
_22#!9!9k2!^2!A _2!^2;2:T(2*|U+2*T#+~wk2#N#F*TxP2C2~V2#
ɠO
k2`2~F.~	o2&0#r1~F.*T~#!4o2~#ä2~222r1~3ր!_3RN#F#!3#ï2#́2!3ï2!3#º%?º%ͥ5  *T~)5Q5ͥں%ͽں%!zT5z/W{/_5?5*@U"FU*T:LU2T"HU4ڨ5 4"FU4ڨ5 4"BU~|.ʁ5ʁ5ʁ5ʁ5ʁ5ʁ5"HU*FU*HU5ڴ ͯ2ͦʟ+é5:LUʟ+!^32LU2T7<]ß+*T2T"T4> 2Tڟ+ 4"Tß+4ں% 4"FU"HU46 4"HU~|.666~D6D6J6|.6*T|v6MD*FU͆	"T2T:kUʟ+1>U-*FU"Td6*T*@Uʟ+*4*@U"YU!  "[U"]U*T"T*DU"|U"WU*@Uڹ6 4:T¥?.\/>2T*DU"|Uå?:T6*zU*T6å?"ú%6ß+! "T*EW SYMNO TDUPL STATDUPL DECAN'T CONTAPSTRINCOMMOPRN<*MEM*UNDISUBSCPT >SUBSCPT OVFLASSIGSTR AS NUNUM AS STCNTRL STCON GOT<< DATRCV DAT- SQLOGICA ͆TTCp%!ZMDT ͆JT͆!JTC(!DTDMd&!JTZMMDV&'!DT Æ |!()+(CP*T*DU(*T*Tʚ(*T*T*TMD*T͆*T*T͆"T6"DU*T"T*DU*TMD*T͆	"T7(*T"T6"DU"T:T½(*(:kUé++*|U"xU*T"|U"WU*T:T("Tå?ABASATCHRCOEXFRININLEFhG:uU!++:T*DU*|UBASIC IS CRASHED*T"vU*T2>U~>ʘ)* yʘ)*T^* yA*>2>UCADCLEACLOACONCSAVDELETENTELISNERUEDISYMBOBY:LU+͊1>U:LU+:Tʿ+>>+>:͹+d 6#6#:LU2T+>2T:LU+7Ϳ2LUß+2T+e "T"Tͥͥ*T~ #,f+
 J,!R#PY:T?,y
?,	J,J,[`i>2T.+:>UW,é(*T~,?*T~ʔ, z,#~=,+#=f,>!M,!>U6 2?U͏)é):Tº%ͥ͗ں%>͏)>͏)*T>{ں%yi`"nU͏)x͏)>͏)ͥڴ J,>͏)ͥJ,!R:T,.\/*TDM*###z.*@U"BU~(/C/*T|./##N#F
|/!BU ͆"/##~º%#N#F
|/5/ *T"T*T
ʇ//PY*Ti/"DU*Tx/+~/+r+s>###! ͏;66###s#r##v/+r+s>6#=/v// !0"//!!0"/>
͹!tT6#q#p!tTr1 DUP STATE N DUP DEƺ*T:T80*|U;0*T >	+~F.#~	\11ʣ0
ʣ0O@040 00 ҃0=0ʝ0+~ #ʝ0=06 #>!q#A0+~#;°0+B0w#6 #I0^0P0L0\0>!A0+~#
A0+(1w#06;#6;#0+~#2#~	3o2*T-3~5-3!\3###"FU~N34ͤ2~*FUʯ2!^3!%0*FU#ï2 s333333'3343o2!333́2~	3![333́23o2!3o2~	3!33o2!3ͯ2 ELSE GOTO TO STEP THEŃ2~3!o13:MU4.
*T#ڻ4*@U+һ4"BU~º%84xa4*T4*T4]484844~|.g4g4g4~44444~|.ʎ4ʎ4444ʎ4Ì4ú%#"BUg44Î4.~4 &!4Q3\ú%o2!4z3 GOSUBͥ*TT"T6+6 +6 +6 "T2T*JU"@U"T"DU!;QU ͆*6!7Ϳͥں%*Tͳ*T~H7#*T~H7>2LU2T*T"Tß+!7Ϳ*DUͳҀ77<Ϳ!7ß+
FILE OREADING...CHECKING...WRITING...WRITING BASIC!7]ͥ*T~2{T>2zT>2|T!zT>2LUW5!7̀*JU! $8*|ʟ+*$8ß+"qUDM!  Rx28!  "sU~Ͳ#7?J87̀:MU9*BU  *BU*@U9*DU9.~n8n8n8n8n8n8#!9r1|8!@tT+>2sT<2zT!sTr1"BU67*T~37ͥv7*T~7ͥ7ʅ8!9ù8 *!9ENTR    ~F.BK*|U	*T'ں%\	"|U*|U+~F.#"|U~y9MD#N#F
DMW9~ʡ9ʼ9ʿ9	ʅ9&ú%#^#V~ʼ9>99&ú%#7#~9###^#V7?#^#V^#V> zTͅ9
<<9ͅ9
<< :::$ú%7*|U#MD79MD+*|U6 6#"|UU:! \5:!; \5:9o:C͐:{ozg/::{ozg/::y/ox/g/:b:?E:b:E:E:7E:b:?E:E:b:E:b:7E:?E::_U:?Ub:7E:?E:79V&5:79r&5:79d&5:7=*@T E>=*@TT*>T++r+s5:~3=###^#Vg>*|U"<T"HU! ">T+"@Tͅ9$ں%#*HUs#r#"HU*>TE>">T*@T#"@TW9~
F=#^#V*T*T"zT^#V##*zT=+~2zT*>T :zTʵ= E>*@T E>:zT=>=>͏;s#r++*@Tr+s+:zT=6=6H*@T E>DM*<T͆	*>TDM:zT,>D>s#r#x!>! ͆	x,>   DMQ"P"{g0ں%Y"{gں%+++~w1>U! "T*@|>!}U#6 ~ʃ>+"T+6"T+6 +6 +6 "T2S2LU2T2MU2kU<2T!  "iU!~U"T"@U"JU6>2 !+"ß+2_U*|U#~	b?9?\?@'?4?6##^#Vg>:hTtA>͏;͆s#r~<º%@6####A#~TA2G#^#V@3eA#^#V^#VA:?U2hTú%*HU"|U*TA> 2LU2TLB~	9B
	BA:SªA~H:SA͈9A*|U:LUvB6 #6*|U~F.ÍA͈9A~Ͳ#AAͲ~Ͳ~#AA:SA:LU)C:pUo& >A*|U6 #=,B+6A+~
RBRB:SRB!B"|U:SlB:LUȯ2LU<7]ɯ2S<7̀+~wAͅ9&ں%*|U6 #ͅ9&Һ%ÌB2T̈́BW9~
º%̈́B#6#"|ǗB5:͕B~o& +5:̈́B̀5:ͷB$%&º%}D̈́B^5̈́Br5:̈́B~wBͷB|&º%*|U6#6 D̈́Bf5:ͷB  B͕B&5:! ͆5:ͷB)
cE0:rE`E+~wBͅ9Ҵ   ~0ڴ 
ڟEҴ ))))o~#E*|U+5:BBBBBC
C=CVC_CCCCC&D/D@DmDDDDD E	EE.E7EDE+F[EEFEͷBW9~
´ ͷBF+5:ͅ9*|U+5:ͣBͅ9Ҵ W9~
´ ͅ9Ҵ ͕F|ʴ Ҵ 	FʇF~vF#fF*|U! ͆5:i`*|U#+5:*T%% \F?F!F#Fw F#ÞF~wFÞF
µFõF~GF3G9G~3G#FI
JJ	GQ:Q*HU*|UI:>U>I:S>I!J:LU>I*|U:SId "TQM2>U*|U#&~I5:+~H#~,#[IHKB*|U6 #͆	6#"|UHͼI6#w#ͼw#ªI6#"|UHw#ͼw#I6#"|UH*FU(9~F."FU*HU(9~F."HU͐@H#:LUJ>2>U*FU~F."FUHҴ ͅ9Ҵ ͊!7̀~Ͳ~#/J*@U*T"DT*T"FT*T*@"HT*DT 	"JT}Ͳ:KTͲ!DT~Ͳ#vJ*DT*@U͠J*HT*T͠J7> <̀~Ͳ#z J>2Sկ̀ÈA>2S͚HҴ ͅ9Ҵ ͊!76͚*T%ͼw#J*T%͐9V%5:9;H&5:*|U6 KB͆	KB͆+~w	#6#"|Uͅ9$ں%*|U#`; ͆>w5:ͅ9$ں%|/g}/o*|U#+5:     'g2{T*T'Һ% Һ%*|U;*T+r+s"Tw#s#r#:{T'º%<2{T*T"tT"nT*nT*T><+V+^~<*nT*tT<"tT"nT;"nT*tT"tTKB*nT͆#^#Vs#r;*tT"TÖ;*|U+~F.~
L<F.#~º%#^#V:?U"=~(ʺ%ʺ%#^#V"<T#^#V">T!  õ<W9~
º%*>T^#V*@TE>ͅ9$ں%*>T^#V#">T)ں%"@T*<T+"<T|<W9#^#V~###s#r~
?!h?R^#V!?+S?I<~F.>@!ER^#V!?~F?:_U>Gm9*|U6#q#p#6#"|U?(9?(9ɐ@u::::::::::	;::E;g;:*WU"|U*TJ@*T3C"BU>2MUͦc@*|U"WU*|U*T'ں%*BU~#@[@/C5y@y@G/C/C2?U8@#~	3@>7*BU~֠!GR^#V? #"BU84*BUå?	@ր!GR^#V!?*T"zU2MU<2Tß+>Rå?͊*BU"zU!@`8Q@#~=y@#Ê?BREAK INͅ92hTW9~ʲ@@A1ʺ%ú%#^#V~@@2G:?U2º%! ͆"dU ͆"dU,A3eA#:̈́B͢#5:W9*|U*T %C!  B!BA#å?*xU"|UQ@ͷB|&º%e."NUNUo& B̈́B5:ͷBW9~
º%͕B~C#xrCD͕BB̈́Bm$5:ͣBͅ9CW9~
º%͕BxqC~C#ýC*|U6 #üC>DͷB C)
CDD0xGxCxD#>0w~wBͷBn& BW9:pU*|Uo& BͷBW9~
º%͕B+~fDy+ZD#rC̈́B~DCʔDQU!D!SSU ͆D!QUr&5:QU!QUQUD̈́B5:̈́B&5:ͷB|D> +D~wBͷB*|U6#6#s#6#"|U   uy   GGFFx:3G03GFx{3GaF[3GAF>:G#N#F
++F?*`U  ~´ #~#fG~sG##~
´ #TG*bUzʍG~F.~
´ #vG(9?QQK7H7H7HKH7H8H`MNNANLO;PJPxQQRJJJ(NLLEHNH7HDR(NO:?Uº%:LUº%!GH
INPUT ERROR|.Ê?#~1H#F:pU=H͊:pU/<=A!6H"H#~"Hɯ2MU*BU"zUß+*BU##N#F##*T  kH~kH#>sH 4"|U͈9&ں%~*BU#>͈9@ں%H|@º%|.|.~ʫHʫHʮHH|.|.> 2T2LUҺ%"DT*|U"JT2>U*DT"FU*JT"|U"HU*FU~nKͼͼ!DTͼw#K*DT*@U"T"DU*FT"T*HT*@"T"T*DT*@U͆K*HT*T͆K*T]T*T"T>7͚ß+ͼͼHGͼxxKJͼw#zK2T2MUҴ ͅ9ڴ W9~
´ ͅ9ڴ  Ҵ (
 Ҵ T~wҴ ͅ9ڴ W9~
´ ͅ9ڴ  Ҵ (
 Ҵ T~w*BU|.tL.EH#####~KL##~	JLF.=L#~	iL*|U6:#"|U>*|U+6:#"|U*|U"WU2fU*|U69#6#s#r#6#69#"|U"WU*|U67#"|U|.*|U6#s#r#6#"|U.#>*dUW96#s#r#6#"|U#L~	LL*|U67#"WU*|U!ZM ͆5:L*|U>#"qUͅ9ں%*|Uº%*|U6# ͆	6#"|U*qU*|U*DU4Һ%W9~;3M73M6#6 +WI    hQ"qU"|U3M:jM74º%*qU~	ʡMº%#^#V*|U ^#V
N*|U#"|U ^#V###C ~M?MMKBH&*|U"WU ^#V3M3M"WU*qU~	####~	
º%#"qUjM3MjM*BU|.tL"BUEH*|U*BU#>ͅ9ں%~5%*|Uº%#zsN~F.~rQ`NYN+"BU:?UEHNҺ%ͥNW9~
º%ͥN}e."NUNUͅ9ں%$%º%Һ%ͥNW9~
º%ͅ9ں%s*WU68#"|U*BU##~	?Oº%(9#N#F##"͆6:	6:#"WU>2fUQPW9~8W9#^#VW9#N#F
+r+sQ#^#V~II:LURQ7Ϳ2T2LU:Sȯ2S<7͚*|U6	7`M|.!S*BU"zU`82MU|.ß+Һ%"qUͥNW9~
´ ͥN*|U*qUQW9~
´ ͥN*|U*qU´ y2Q Q!  Q>2LU2Tկ]ÈA>2LU2TկͿH*DU*T=R~>4R! ͆6R6 	R*T"T!R!T  x0͹>	͹>	͹~
hRxR>X͹}R> ͹> ͹yeR#͊x
OR|.
CHANNELS       LOGICAL DEVICES
(PHYS.)        0 1 2 3 4 5 6 7
SYMBOL                         TYBU*|U
6#s#r#6#6#+r+s6#!O6#"|U*BU~
#N	º%*|U68#"|U"WUҺ%"qU*BU"sU*qU~	
iO#~(9F."qU|O͐@[O*[U}ʜO~
O#~	ʜO(9F."[U*]U}ʧOg>*YU"BU|.*TO~­O#>*|U>]U͏;͆"|U"]U"[U*BU"YU|O*sU"BU6ú%*@U"YU*]U}Pg>!  "]U"[U|..*BU#~EH"YU~+~F."YUҺ%*|U"|U3M:IP3M#"|U͌PңP͌PڄP!IT6! ͆	6!IT͌P͐@ZP~
P#~	:(9F.7:fU3M3M9©P"WUú%P"HU*|U"FU"|U3M7P:P8Q3M"WU##^#V*HU*FUDMbkPE     LOCATIONARRAY   LABEL   VARIABLE:_U<2_U*|U*`Us#r#*bUs#r#"|U+~F.~
LS#"bU++V+^! "`U~F.!  9!UҺ%~6jS>W9W9*|U+V+^+V+^*bU++++"|U"`U"bU(9!_U5STOP IN NI  CONOM	;LOOK AT OUTPUT STATUS BIT.
	JNZ  CONOTL	;WAIT U