 CATALOG 30  E                 BUILD   PLM   	

 BUILD   PLM                  RUN     COM   \     RUN     PLM    !"#$%&'()*+,-./ RUN     PLM  0123456789:;<=>? RUN     PLM  @ABCDEFGHIJKLMNO RUN     PLM  PQRSTUVWXYZ[\]^_ RUN     PLM  `a               BASCOM  LIT   
bc               BASIC   COM   `defghijklmno    VOLUME 30

CP/M BASIC-E VERSION 1.4 PLM SOURCE
(OBTAIN VOL 29 ALSO FOR COMPLETE SET)

NUMBER	SIZE	NAME		COMMENTS

		CATALOG.30	CONTENTS OF CP/M GROUP VOLUME 30
30.1	2K	BASCOM.LIT	LITERAL EQUATES
30.2	39K	BASIC.PLM	VERSION 1.4 BASIC-E COMPILER MODIFIED FOR CP/M
30.3	14K	BASPAR.PLM	PARSER MODULE
30.4	54K	BASSYN.PLM	SYMBOL TABLE AND CODE GENERATOR MODULE
30.5	12K	BASIC.COM	EXECUTABLE COMPILE MODULE
30.6	66K	RUN.PLM		RUN MODULE
30.7	12K	RUN.COM		EXECUTABLE RUN MODULE
30.8	17K	BUILD.PLM	INVOKED WHBASBUILD:
DO; /* ORIGINALLY ORG'ED AT 2D00H ABOVE INTERP */
   /*
         ********************************************************
         *                                                      *
         *               BASIC-E BUILD PROGRAM                  *
         *                                                      *
         *          U. S. NAVY POSTGRADUATE SCHOOL              *
         *               MONTEREY, CALIFORNIA                   *
         *                                       ********************************************************
         *                                                      *
         *      THE BUILD PROGRAM GAINS CONTROL WHEN THE        *
         *      RUN TIME MONITOR IS EXECUTED.  THE INT FILE     *
         *      FOR THE PROGRAM TO BE EXECUTED IS OPENED        *
         *      AND THE BASIC-E MACHINE IS BUILT.               *
         *                                                      *
         *      BUILD PERFORMS THE FOLLOWINGEN RUN CALLED TO BUILD
				INTERNAL TABLES FROM INT FILE
                       *
         *          WRITTEN BY GORDON EUBANKS, JR.              *
         *                                                      *
         *                 CPM VERSION 1.3                      *
         *                                                      *
         *                  DECEMBER 1976                       *
         *                                                      *
         ********************************************************
    */
    /*
  FUNCTIONS:         *
         *                                                      *
         *      (1) THE NUMERIC CONSTANTS ARE READ FROM         *
         *      THE INT FILE, CONVERTED TO INTERNAL REP-        *
         *      RESENTATION, AND STORED IN THE FSA.             *
         *                                                      *
         *      (2) THE SIZE OF THE CODE AREA, DATA AREA        *
         *      AND NUMBER OF PRT ENTRIES ARE READ FROM         *
         *      THE INT FILE. BUILD THEN DETERMINES THE         *
         *      ABSOLUTE ADDRESS OF EACH SECTION OF THE         *
         *      BASIC-E MACHINE. THESE ADDRESSES ARE            *
         *      PASSED TO THE INTERP PROGRAM VIA FIXED          *
         *      ADDRESSES IN THE FLOATING POINT SCRATCH         *
         *      PAD.                                            *
         *                                                      *
         *      (3) FINALLY INSTRUCTIONS ARE READ FROM         E MACHINE HAS BEEN       *
         *      REPOSITIONED BY INTERP. THE END OF THE INT      *
         *      FILE IS INDICATED BY A MACHINE INSTRUCTION      *
         *      7FH.                                            *
         *      REPOSITIONED BY INTERP.                         *
         *                                                      *
         ********************************************************
    */
    /*
         ********************************************************
   /*
         ********************************************************
         *                                                      *
         *            SYSTEM PARAMETERS WHICH MAY               *
         *            REQUIRE MODIFICATION BY USERS             *
         *                                                      *
         ********************************************************
    */
DECLARE
        /* OP CODES FOR BASIC-E MACHINE INSTRUCTIONS */
        DAT         LIT                                                         *
         ********************************************************
    */
DECLARE
        BDOSBEGIN    ADDRESS INITIAL(06H), /* PTR TO BOTTOM CP/M */
        MAX          BASED   BDOSBEGIN   ADDRESS,
        
        /* OFFSET IS THE SIZE OF THIS MODULE */
        OFFSET       ADDRESS EXTERNAL, /* INITIALIZED BELOW */
        /* START IS THE ADDRESS TO START INTERPRETATION */
        START      LABEL EXTERNAL,
        /* BEGIN HOLDS THE VALUE OF                                    *
         ********************************************************
        */
DECLARE
        MCD       LIT       'PARAM1',
        MDA       LIT       'PARAM2',
        MPR       LIT       'PARAM3',
        SB        LIT       'PARAM4',
        MBASE     ADDRESS, /* PTR TO NEXT POSTION IN DATA AREA */
        MF        BASED     MBASE      BYTE,
        BASE      ADDRESS, /* PTR TO NEXT POSITION IN CODE AREA */
        CURCHAR   BYTE, /* HOLDS CHAR BEING ANAL *
         *      THE FILE AND PLACED IN EITHER THE DATA          *
         *      AREA OR THE CODE AREA. IN THE CASE OF BRS       *
         *      BRC, PRO, CON, AND DEF OPERATORS THE            *
         *      ADDRESS FOLLOWING THE INSTRUCTION IS RE-        *
         *      LOCATED TO REFLECT ACTUAL MACHINE ADDRESSES     *
         *      (MINUS 1 BECAUSE PROGRAM COUNTER GETS           *
         *      INCREMENTED PRIOR TO USE (EXCEPT FOR CON)!!)    *
         *      AFTER (REPEAT AFTER) TH
         *                                                      *
         *                    GLOBAL LITERALS                   *
         *                                                      *
         ********************************************************
    */
DECLARE
        LIT       LITERALLY    'LITERALLY',
        TRUE      LIT                  '1',
        FALSE     LIT                  '0',
        CR        LIT                '0DH',
        LF        LIT                '0AH';
 '51',
        ILS         LIT      '28',
        DEF         LIT      '94',
        BRS         LIT      '54',
        BRC         LIT      '55',
        PRO         LIT      '30',
        CON         LIT      '46';
    /*
         ********************************************************
         *                                                      *
         *               EXTERNAL ENTRY POINTS                  *
         *    THESE ENTRY POINTS ALLOW INTERFACEING WITH CP/M   *
         *    .MEMORY FOR INTERP */
        BEGIN     ADDRESS EXTERNAL,
        /* PARAMETER PASSING LOCATIONS */

        PARAM1       ADDRESS EXTERNAL ,
        PARAM2       ADDRESS EXTERNAL ,
        PARAM3       ADDRESS EXTERNAL ,
        PARAM4       ADDRESS EXTERNAL ;
         /*
         ********************************************************
         *                                                      *
         *                GLOBAL VARIABLES                      *
         *                  YZED */
        B         BASED     BASE BYTE,
        BV        BASED     BASE(1) BYTE,  /* VECTOR VERSION OF B */
        A         BASED     BASE ADDRESS,
        AP        BYTE, /* ACCUMULATOR INDEX */
        ACCUM(16) BYTE, /* HOLDS CONSTANTS PRIOR TO CONV */
        TEMP      ADDRESS,
        T         BASED     TEMP BYTE;
    /*
         ********************************************************
         *                                                      *
         *         FLOATING POINT INTERFACE ROUTINES            *
         *                                                      *
         ********************************************************
    */
FLTOP: PROCEDURE(FUNCTION,LOCATION) EXTERNAL;
    DECLARE FUNCTION BYTE, LOCATION ADDRESS;
    END FLTOP;

DECLARE FPN LITERALLY 'FLTOP';

FLTRET: PROCEDURE(FUNCTION,LOCATION) EXTERNAL;
    DECLARE FUNCTION BYTE, LOCATION ADDRESS;
    END FLTRET;

DECLARE FP LITERALLY 'FLTRET';

FLTINP: PROCEDURE(COUNT,LOCATION) EXTERNACBLOC      LIT     '5CH',
        DISKBUFFEND LIT    '100H',
      /* IF OPERATING SYSTEM READS VARIABLE LENGTH RECORDS
         THIS MUST BE ADDRESS OF ACTUAL END OF RECORD */
        BUFF      ADDRESS   INITIAL(DISKBUFFEND), /* INPUT BUFFER */
        CHAR      BASED     BUFF       BYTE,     /* INPUTBUFF POINTER */
        FILENAME  ADDRESS   INITIAL   (FCBLOC),
        FNP       BASED     FILENAME(33)  BYTE; /* FILE CONTROL BLK */


MON1:PROCEDURE(FUNCTION,PARAMETER) EXTERNAL;
    DECLARE
   ER ADDRESS;
END PRINT;

PRINTF: PROCEDURE(BUFFER);
    DECLARE BUFFER ADDRESS;
    CALL PRINT(BUFFER);
    CALL PRINTCHAR(CR); CALL PRINTCHAR(LF);
    END PRINTF;

OPEN$INT$FILE: PROCEDURE;
    FNP(9) = 'I';
    FNP(10) = 'N';
    FNP(11) = 'T';
    IF MON2(15,FILENAME) = 255 THEN
         DO;
              CALL PRINTF(.('NI   $'));
              CALL MON3;
         END;
END OPEN$INT$FILE;


READ$INT$FILE: PROCEDURE BYTE;
     /*
        NEXT RECORD IS READ FROM INT FILE
        DISK*
         ********************************************************
    */


INCBUF: PROCEDURE;
    IF(BUFF := BUFF + 1) >= DISKBUFFEND THEN
         DO;
              BUFF = DISKBUFFLOC;
              IF READ$INT$FILE <> 0 THEN
                   CHAR = 7FH;
         END;
END INCBUF;


STO$CHAR$INC: PROCEDURE;
     /*
        GET NEXT CHAR FROM INT FILE AND
        PLACE IN CODE AREA. THEN INCREMENT
        PTR INTO CODE AREA.
     */
    B=CHAR;
    BASE=BASE+1;
END STO$CHAR$INC;

VERT IT TO AN 8080 ADDRESS QUANTITY
     */
    RETURN SHL(DOUBLE(NEXT$CHAR),8) + NEXT$CHAR;
END GETPARM;

    /*
         ********************************************************
         *                                                      *
         *              EXECUTION BEGINS HERE                   *
         *                                                      *
         ********************************************************
    */
BUILD:
CALL PRINTF(.('BASIC-E INTERPRETER - VER L;
    DECLARE COUNT BYTE, LOCATION ADDRESS;
    END FLTINP;

DECLARE FPINP LITERALLY 'FLTINP';



    /*
         ********************************************************
         *                                                      *
         *                CP/M INTERFACE ROUTINES               *
         *                                                      *
         ********************************************************
    */
DECLARE
        DISKBUFFLOC LIT     '80H',
        F         FUNCTION  BYTE,
            PARAMETER   ADDRESS;
END MON1;

MON2: PROCEDURE(FUNCTION,PARAMETER) BYTE EXTERNAL;
    DECLARE
            FUNCTION    BYTE,
            PARAMETER   ADDRESS;
END MON2;


MON3: PROCEDURE EXTERNAL;
END MON3;


PRINTCHAR: PROCEDURE(CHAR) EXTERNAL;
    DECLARE CHAR BYTE;
END PRINTCHAR;


PRINT: PROCEDURE(BUFFER) EXTERNAL;
     /*
         PRINT A LINE ON CONSOLE FOLLOWED BY A
         CARRIAGE RETURN AND LINEFEED
     */
    DECLARE
            BUFFBUFFEND MUST REFLECT THE ADDRESS
        OF THE END OF THE RECORD PLUS ONE
        FOR FIXED SIZE RECORDS THIS IS A CONSTANT
        RETURNS ZERO IF READ IS SAT, AND 1 IF EOF
     */
    RETURN MON2(20,FILENAME);
END READ$INT$FILE;
    /*
         ********************************************************
         *                                                      *
         *                  GLOBAL PROCEDURES                   *
         *                                                      

NEXT$CHAR: PROCEDURE BYTE;
    CALL INCBUF;
    RETURN CURCHAR := CHAR;
END NEXT$CHAR;


GET$TWO$BYTES: PROCEDURE;
    /*
      GET NEXT TWO BYTES FROM THE INT FILE
      AND PLACE THEM IN THE CODE AREA IN REVERSE ORDER. 
    */
    BV(1) = NEXT$CHAR;
    B = NEXT$CHAR;
    RETURN;
END GET$TWO$BYTES;


INC$BASE$TWO: PROCEDURE;
    BASE = BASE + 1 + 1;
    RETURN;
END INC$BASE$TWO;


GETPARM: PROCEDURE ADDRESS;
     /*
        READ A 16 BIT PARAMETER FROM INT FILE
        AND CON2.2$'));
CALL OPEN$INT$FILE;

BASE = (.MEMORY + 100H) AND 0FF00H; /*  BEGINNING OF MACHINE AND FDA */
OFFSET = BASE - BEGIN; /* SIZE OF THE BUILD MODULE */

CALL FPN(0,0); /* INITIALIZE FLOATING POINT PACKAGE */
      /*
          PROCESS CONSTANTS
          EACH CONSTANT IS SEPARATED BY A $
          LAST CONSTANT FOLLOWED BY A *
      */
DO WHILE(ACCUM(0) := NEXT$CHAR) <> '*'; /* * INDICATES END OF CONST */
    AP = 0;   /* COUNTER FOR LENGTH OF THIS CONSTANT */
    DO WHILE(ACCUM(AP:=AP+1) := NEXT$CHAR) <> '$';
          /* GET CONSTANT INTO THE ACCUM */
         END;
    CALL FPINP(AP,.ACCUM); /* CONVERT IT TO INTERNAL FORM */
    CALL FP(9,BASE);  /* LOAD INTO FDA FROM F/P ACCUM */
    BASE = BASE + 4; /* NEXT LOCATION */
    END;    /* OF LOOKING FOR *  */

      /*
          SETUP MACHINE ADDRESS
          BASE WILL NOW BE NEXT POSITION IN CODE AREA
          MBASE WILL BE NEXT POSTION IN DATA AREA
      
          ACTUAL ADDRESSES OF CODE AREA, DATA AREA
          PRT, AND      AS OPCODES ARE READ THEY MAY BE:
             (1) DAT - WHICH MEANS ALL CHARACTERS
             FOLLOWING DAT GO INTO DATA AREA UNTIL
             A BINARY ZERO IS INCOUNTERED

             (2) GREATER THAN 127 - WHICH IS A LIT
             OR A LIT. TREAT THIS AS 16 BIT OPCODE
             AND PUT IN CODE AREA IN ORDER THEY ARE
             ON INT FILE

             (3) ILS - WHICH MEANS ALL CHARACTERS
             FOLLOWING GO INTO CODE AREA UNTIL A 
             BINARY ZERO IS INCOUNTERE           OR IT COULD BE A CON WHICH IS
             RELOCATED TO THE FDA.
        */

DO WHILE NEXT$CHAR <> 7FH; /* BUILD MACHINE */
    IF CURCHAR = DAT THEN /* PROCESS DATA STATEMENT */
         DO WHILE(MF := NEXT$CHAR) <> 0; /* LOOK FOR END */
              MBASE = MBASE + 1;
              END;
         ELSE
              IF CURCHAR >= 128 THEN /* PROCESS LIT OR LID */
                   DO;
                        CALL STO$CHAR$INC;
                        CALL INCBUF;
                                 T = T + 1;
                                  END;
                         END;
                    ELSE
                         DO;
                             CALL STO$CHAR$INC;
                             IF (CURCHAR = BRS) OR (CURCHAR = BRC) OR
                                (CURCHAR = DEF) OR (CURCHAR = PRO) THEN
                                  DO;
                                      CALL GET$TWO$BYTES;
                                      A = A + MCD - 1;
           TO BASE MODULE FOR FURTHER PROCESSING */
END;
STACK ARE PASSED TO INTERPRETER
          USING FIXED LOCATIONS
      */
MBASE = GETPARM + BASE;

MDA = MBASE - OFFSET; /* ACTUAL DATA AREA ADDR */
MCD = BASE - OFFSET; /* ACTUAL CODE AREA ADDR */
MPR = GETPARM + MDA;  /* ACTUAL BEGINNING OF PRT */
IF MPR >= MAX THEN /* INSURE THERE IS ENOUGH MEMORY */
    DO;
         CALL PRINTF(.('NM  $'));
         CALL MON3;
    END;
SB = SHL(GETPARM,2) + MPR; /* NUMBER OF ENTRIES IN PRT * 4=SIZE PRT */

      /*
          BUILD MACHINE - ATLAST 
     D - BUT FIRST
             PUT A ILS IN CODE AREA AND THE NEXT 
             BYTE IS SET TO ZERO AND INCREMENTED
             FOR EACH CHARACTER IN THE STRING. IE
             A STRING CONSTANT IS A ILS OPCODE,
             A LENGTH AND THE STRING.
     
             (4) A NORMAL OP CODE - PUT IN CODE
             AREA - BUT IF IT IS A BRS OR BRC OR
             DEF OR PRO THEN THE NEXT TWO BYTES
             ARE AN ADDRESS WHICH MUST BE RELOCATED
             TO THE ACTUAL CODE AREA MINUS 1;
         CALL STO$CHAR$INC;
                   END;
              ELSE
                   IF CURCHAR = ILS THEN /* PROCESS INLINE STRING */
                        DO;
                             CALL STO$CHAR$INC;
                             TEMP = BASE;
                             CHAR = 0; /* TO SET LENGTH TO 0 INITIAL */
                             CALL STO$CHAR$INC;
                             DO WHILE NEXT$CHAR <> 0;
                                  CALL STO$CHAR$INC;
                                              CALL INC$BASE$TWO;
                                  END;
                             ELSE
                                IF CURCHAR = CON THEN
                                  DO;
                                    CALL GET$TWO$BYTES;
                                    A = SHL(A,2) + BEGIN;
                                    CALL INC$BASE$TWO;
                                  END;
                        END;
END;   /* LOOKING FOR 7FH */
GO TO START; /* RETURNS)+ï +    `iN#F#^#V#~#fo}+
! y:!$0w#
=>w!$	!$͇
,0u ddvC$0 ʅw#{{6  ͏	
 y	s{Ybw#p#q#r! 		N#F!q#p  2!q !q{ 9	~#F#N#V!Y 	,
<
 
 	
*$ A !6 #
T    I܀1r   l7s,w,p,q,r!w>!w!~{_,~,,N,Vê~{_,~,N,VoG!qG{~{̀x!~wbG{ɯ{O!>w x!Kw!Yw!gw!~,V,^B.Nqkb_HJx}o|gz'}[kb_PH> } o| g{ _>  o| g{ _> +6 * |}   ! ͌!ks͠!k̈́!ks@!os!k͠!o!o!osï!o͠ɯ!ow!"*M"o*O"q!"w կGOy	!ss!k͠!oͽ*w!s!M7!os!M͠!s!o!oszWyO   I܀1r́!Q͌!{s!Q͏	 y	!Qͽ́!{!{s̈́!Q!Q_!|~G{+s{É!{͠!{ͽ́!ksH!o͠!{ͽ!w,w͌͌s	 !o4͠!{ͽ!{s!y~ HPy	!Uͽ!{![N,F-R	!P	o	![q,p6	c	o	c	o	ɗyOxGc	~O,~G-kZQHG}!w,6,xÛ!~ʼ	{Ҽ	.F,N,V.~ >xAJSɯGOW ^P,6!r{			!r\~ #
.

_
!#w!iͽ.s,~ HPy	..~	-Fp	!w	_
\~G_?
xA
,~ 
_
G,~
X
OxG{_
G!N!qx!ʌw!i~
>h
ͽ>h
-P͌!s\6ʶ
_x{
6~!iڿ

!^sè
ͽ!^sæ
̈́!mҨ
!~_
w>,w{!w!iͽ͏
*w**#"*!*p+q*
*|O*
*}O> !%)(=
Q*%)DMm!*p+qQ**DM
!*p+qQ**DM
*)#")*)")>͵(")!)(Ҡ
>)(")*)") ")!)(ھ
*)")!*p+q)*Ϳ(!*p+q**N#FͿ
/
**N#Fa*)**q#p*)DM*)**)DM*)**)DM***)***)DM
*)N#F*)**)~ *)~ *)> (*)> (*)#~*)#~!*q*)##:*w:ҫFO\
*)z*!  "*)DM͎ *)	*)w*)##*)#w!*q*)**M*)͎!*q*)**M*)pip b:_a:*.plm[v]
pip b:_a:*.src[v]
pip b:_a:run.com[v]
PIP B:=RUN.PLM[V]$              PIP     COM   B        SUBMIT  COM                  $$$     SUB                    #r*)^#V"C*|
*)^#V"G**C*N#F!F*q+6:F*!E*X|
͆*)*C*^#VN#F(*G*	"G*!E*4'͆*C*G*(mBSA
*C*##*G*DMa	*)q#p*C*##"C*!I*q*)DM
:I*3 ̀*)^#V"J**J*N#FͿ
*J*N#F`i"L**L*~=w*J*N#Fͦ*)N#F`i"L*Ϳ
3*L*~/*L*#"L >^,G,N,V!~-w{ʌhxG..w.~ʷ<\Ìڷs_!~.w,^pC,^qK,^rS!~.~W-~O-~GҤGyOzW_.~wä_~W-~O-~G 3{bG!{ox{]!~.-qê G,N,V,^!~ȀGxw,~wyد{_zWyOxG .ZQH oxGyOzW{_--~wo_}W}O}G. xSAJS_}o5-{_zWyOxGF} !w!{^rx,t{_w!w!r!s_W!͟.͜.zYPFoOڰJSOҰ}o{_zWyOxGҰ{ _z Wy ê!~w-~w-~wyy!Vw!dwz!Rw!`w{!Nw!\w5!M̈́5!s!Q͠_!~怰G{!{s!{͠!!{s!{ͽ!M͘!M!{̈́!{s!<s!{ͽ́!ks !o͠!ͽ͌!ks!y6 րw!k6͠!kͽ!ks8!y5!o͠!oͽ!4!M!osþ͌͌!{s!y6 ր	w!{6͠!{ͽ!ks*!o͠!{ͽ!{s!{ͽ!M͘!ks!y5~!k͠!{ͽ<!{s!k͠!kͽ!4!M!ksE!{͠͌!^6 !zs̈́ͯ!z^!~s{!M̈́!k̈́ց!yw>!{s!{͠!M!os!{͠!M!o!{s!{ͽ!k	\wy	>
!~6"\6
-H1OW
3>\s!à>GOW<}D Q!s!^s,fkd 
               	!e (  IN LINE $ERROR $WARNING $1)1)ͱ1) ͧv!)q*)& 

!)p+q  /*#)#"#)*)
*)*)*)*)*)*)0*)!)p+q*)	!)p+q*)))!)p+q! *6 >! *!*60* *& f)	)(ڵ* *& f)	)(+s#r!*4Æ**M! *4x!*r+s+p+q+p+q*!*r+s+q+p+q**+"*ͮ(

**:|
͎͡
*)n*ͬ!*p+q*)> w#6 **|*)##w**} *)	w*)DM͞*)*)Dn|
>r{|
>|
>!!*p+q*))""*!  "&*> "*( *"*	~ *"*"*Ϳ(>͵("$**&*"&*>  *( * *$*(*"**"*^#V""*Ó>  *(MNA
*&*!)*p+q> (*( !  *(*DḾ",* *,*	6*(**,* "0**,**0*N#Fq#p*,*N#F`i"2**,**0*s#r*2*s#r *0*	6 *0*##"0**0**,*s#r *,*",**(* *,*!5*p+q>4*(#s#r"4* *4*	6 *4*##"4**4*^#V"4*> ͫ( *4*	~ *4*"6**4*^#**L**L*~<O 
*)q#p*L*~<_ *)N#F`i"L**L*4*)^#V*)DM**))X(++s#r|
NbBe|
|
t
*)^#V")*)##~wҎ*)N#Fͦ!O*p+q> N*(¤> *N*~!P*q:P**)v**)6 X|
e
|
*)N#F͏<2Q*f*)N#F͏2R*:R*!Q*2S*f*)N#F*S*M 
"T*DM*Q*& *)N#F:Q*T*c(DM*R*& ~|
~*)*T*s#r:S*=*T*w̀ɟqLSA
X҂*)"X*Ì*)^#V"X*eҜ*)"V*æ*)^#V"V**V*~2[*!Z*6 :[*!Z**V**X*
>*V**X*~>*V*#"V**X*#"X*!Z*4²>~|
~!\*q!a*6 :\*<rDH/SSA
ͬ*)~2a*|
r*)N#F͏!a*HDHl|
~*)> w#6 ͬ*)*)N#F͏!a*#wҡ:\*:b*<*)wá*):b*w:\* ¶*)^#V"_*:\**):b*d(*)~͵("_**):a*d(+"_**_* O 
"]* _ *)*]*
w|
~*)*]*s#r̀*)~<!c*q*)DM͎> !c*C*)DM͎!d*6 >!d**c*M !		^#V*d*& *)~/w*d*& *)*d*& *)~`iw*d*& *)*d*& *)~`iw*d*& *)*d*& *)~`iwaq!d*4H> !c*|
*)DM͞*)*)")*)#")!)(/> )(!l*q&*)#"))(HVREA
`ͽ/7Hz͖  *)	5*):l*w*)>ҔFMA
*)~ͅO !)		^#V")> ͫ(ºUFA
*)N !)		^#V")& *)") ")$ *)	^#V")" *)	^#V")G0EMA
!o*6 :o*<2o*O !)		> (5 
")*o*& ))	q#p& *)")G*)#"m*  *)^#V"p**p*##~:*p*#>*)w*p*~==2r**p*##"p*å*p*~2r*>!r*ҳ!r*6*p*#"p*!s*6RO *p*	~.!r*:s*Hÿ*p**m*DM*s*& R!r**s"3N!*6:*!*:**~")EQA
**N3N!*4:*J"3~|
**#"*ͽjECA
*)DMͦ!*6 :*<2*O>ڦ**& ))	^#V")> ͫ(ʣVxs@? +):-)ͧ!,)"})*,)& 	6
*,)& ,)	})(|
*)")II\
û*')#"')!)(DOA
*')~*})#"})*})~:) n>P!|)DBDA
͖*|)& ,)	w
f&cERA
k*)~5:)z!:)!|)6 -2* Ì:) ¨!,)"):)¶*})"):)*')"):*"!*6,!*6":) *)#")-2*!*:*+~
!*)r*E!y"!ENA
E!*)  *)*)|
͎Q(OOͩQ(OOͩQ(OOͩQ(O/OͩQ(O/OͩQ(O/OͩQ( &Q(&Q(&Q(.Q( ͏
|
Q(|
Q(͡
Q(Q( ͏|
|
Q(rOͩQ(rOͩQ(rOͩQ(r/OͩQ(r/OͩQ(r/OͩQ(͏|
|
Q(͡
t
*)*)s#r*)n& ") ̀Q(Q(t
͡
*)##*)q#p*)^#V")Q(*)N#F`i")|
Q(BQ(Q(/"wQ(͆|
Q(͆~|
Q(g|Z*D/Oͩ:*%
Q(
Q(Q(Q(͡

|
͡
NT%ZTA
Q(Q(*)>(҃%*)>(+s#rg%*)N#F! 	+s#r)(/>(Hҳ%@*)^#V")|
Q(Q(͡
  ́DM!Q(*#)"[Q(Q(͡
>)(DM!Q(*)NO !Q(*)^#V"*> ͫ(**~H<&CAA
**#~2*~**M !Q(ͬ 
"***6*)**#
w*)**s#r̀Q( Q(*)N#F͏2*~**M !Q(Q(Q():)<O 
*)q#p:)<_ ̀Q(*)N#F͏*)N#FPYO0~*)	)Q!e*6 :e*<2e*O !)	~  	*))q#p`i:e*w! ")  !"f**f*~ Y*f*+"f*F! ")f*)Ϳ(ڂ*)N *)")b0*)^#V"h*> ͫ(!j*6*h*~!j**j*& *h**)
w*)#")ͮ(@!j*4*) ! *)	~!k*q! *)	:k*wOOOOO$ *)	*)s#r> )(_FEA
*)#")*)")*)")))Ϳ(ʈO*)+")<û ¢#7/ҮM#  *)	4  *)	>   *)	5O& WDA
	7*& *p* *m*!s*:r*_  *)$ *)	q#p|
*)" *)	N#Fq#p|
:s*<2s**)")*)")͙!  ")!)6|
&/ҊURA
XrHҞRIA
*)N#F+q#p-ͽ*)}*)#~H_  (*)|l_ & }(! 9g("v**)^ }("t*!v*͑(*t*	"z**)#^ l& }("x**x*}*t*|v*c(͟(H 	!~*s>z*p(*)	+")<!z*͛(#s#r *)	:~*ʄvECA
 *)	:~*w*|*}  *)	w|
ңͽ͖/Ү͖*)~ºM*)~!*q:* :)/,3!)6 *)^#V"***~2*:* !*5H!|)4-2*:*":-2*,:*
H:͡
͇*):|)<O 
"*#DM*|)& *)**s#r ̀**:|)w͇> !|)ҝ*|)M*)0*)	͎ð:)«ð*)6  ) a 0*	)"!)")*)")+"')*
)")*)")` "))")*)") ")*)*)Ϳ(*DM*))))Ϳ( *)"**)>(**q#p**##> w#6  **	w#6 **^#V"***> w#6 **##*)s#r*)~Ҵ ͡
*)#*)
w*)>?*)#w*)~Ү .t
Q(*)N !'		^#VQ(Q(Q(D ZD\
Q(N!DQ(gZQ(#͡
Q(*)*)^N|
|
Q(!)6 wQ(!)6 >Q( ͿQ(ͿQ(Q(͡
t
*)N#F*)*t
Q(*)+"')Q(
Q(/Ҕ#>Q(Q(Q(@Q(!*6 **& )	)Ϳ(#!*4ë#!~:*#@#**& )	^#V")Q(iQ(D#i$*)##")|
Q(UQ(BQ(*)DM͎Q(!)6*)")ʹQ(!)6>Q(!)6wQ(&[$͖
[$P$<Q(&~$*)++)(~$ 3h$
3
3<Q(͙V*)N !)		> w#6 *)N !)		w#6 |
Q(*)#>wQ(*)DM͎*)DM͞Q(͡
*)*͡
*[DM!Q(r/2Q(Q(Q(Q(*)~=w*)~=H4'IOA
|
*)~<wQ(&Q(t
*)ͅO !)		N#Fq#pt
|
Q(*)^#V"%)|
Q(*)!)X(s#rQ(     N!]!l!{!!!!!!!!!!!!!!
""("8"H"X"f""""""""""###2#=#H#P#X#^#w#########$$$"$3$>$I$a$$$$$$%!%)%1%\%d%%%%%% &&S&&&&&&&''''B'J'm'}'t
 N#Fog_ og_ ogDM!  >))Ҍ(	=(^#V)
(^#V|g}o
(_ {ozgO {ozgi`N#Fogo& og_ {_z#W712A0D47
:100D16002A7C4FCDC60B2A0D2 D4FCDC60B3E0031
:100D260021  29CDP728D23D0D01950BCD510C2A71
:100D36002529444DCD6D0CCDD60BC921102A702B1B
:100D460071CD 0B019F0BCD510C2A0F2A444DCDE8
:100D56000E0DCD0E01C921122A702B71CDD60B01B5
:100D6600A60BCD510C2A112A444DCD0E0DC92A17BA
:100D76002923221729C92A1529221329EB3E04CD36
:100D8600B528221529EB211929CDDA28D2A00D3E46
:100D960004111B29CDCC28221529C92A132922156D
:100DA6002911040019221329EB211B29CDDA28DA8F
:100DB600BE0D2A1929221329C921142A702B711153
:100DC6001B2901132ACDBF289FC921162A7.	6N* .	6T* .#- +,* .*-#"-! ͸-R-! "-$- R-*-6*-*-
w*-#"-.-*-~2-e-*-#we-*-w*-##"-e-O `iͲ-e-_ N#Fog{ozg)
²-{ozgi`N#FogC2A712A134B
:100ED60029 0E02CDDF012A1C2A4D2A1329 \ 60
:100EE600D201CD8E0EC9211D2A712A1329EB0E02BD
:100EF600CDDF012A1D2A4D2A1529EBCDD201CD7C45
:100F06000DCD8E0EC9CDA10D2A1329EB016E0BCD89
:100F16002A010E03CDEC0ECDAC0EC9211F2A702B73
:100F2600712A13293E00772336002A1E2A7C2A13AB
:100F3600292323772A1E2A7DBASINT:
DO; /* ORIGINALLY ORG'ED AT 0C00H ABOVE FP PACKAGE */
    /*
         ********************************************************
         *                                                      *
         *                 BASIC-E INTERPRETER                  *
         *                                                      *
         *            U. S. NAVY POSTGRADUATE SCHOOL            *
         *                 MONTEREY, CALIFORNIA                 *
         *                            **
         *                                                      *
         *     THE BASIC-E INTERPRETER IS PASSED CONTROL        *
         *      FROM THE BUILD PROGRAM.  THE FDA, CODE AND      *
         *      DATA AREA ARE MOVED DOWN TO RESIDE AT THE       *
         *      .MEMORY FOR THIS PROGRAM, AND THEN THE STACK    *
         *      PRT AND MACHINE REGISTERS ARE INITIALIZED       *
         *      THE INTERPRETER THEN EXECUTES THE BASIC-E       *
         *      MACHINE CODE.          *
    */
DECLARE
         LIT       LITERALLY 'LITERALLY',
         FOREVER   LIT       'WHILE TRUE',
         TRUE      LIT       '1',
         FALSE     LIT       '0',
         LF        LIT       '10',
         CR        LIT       '13',
         NULLCHAR  LIT       '0H',
         CONTZ     LIT       '1AH',
         QUOTE     LIT       '22H',
         WHAT      LIT       '63';               /*QUESTION MARK*/

    /*
         ********************************************************
        NI   $BASIC-E INTERPRETER - VER 2.2$NM  $1-1-+,, !/ͫ-"--Ϳ-")   e-2-*ʦ+!-6 e-:-<2-O !-	Hqy$ʆ+h+*-M-0*-	 *-"-X+͉-*-	"-)-Ϳ-"))-Ϳ-"	)͉-*)	"
)*-
)-+$+,͉-))*
)	")e-,:-3",e-*-w ,*-#"-	,,:-6,S-.-S-,:-d,S-*-"-*-6 S-e- a,S-*-4O,,S-:-6:-7H:-^H:-HҰ,p-*-	)͠-+s#r̀-,:-.,p-*-^#V))*	+s#r̀-+v!.p+q*.DMQ

	 * .	6I*                           *
         *            WRITTEN BY GORDON EUBANKS, JR.            *
         *                                                      *
         *                   CPM VERSION 2.0                    *
         *                       MAY 1977                       *
         *                                                      *
         ********************************************************
    */

    /*
         ******************************************************                         *
         *                                                      *
         ********************************************************
    */

    /*
         ********************************************************
         *                                                      *
         *                   GLOBAL LITERALS                    *
         *                                                      *
         ******************************************************* *                                                      *
         *               EXTERNAL ENTRY POINTS                  *
         *     THESE ENTRY POINTS ASSUME THE USE OF CP/M        *
         *                                                      *
         ********************************************************
    */
DECLARE
         SYSBEGIN     ADDRESS  INITIAL(6H),
         PARAM1       ADDRESS PUBLIC,     /* SET BY BUILD PROGRAM */
         PARAM2       ADDRESS PUBLIC,
         PARAM3       ADDRESS PUBLIC,
         PARAM4       ADDRESS PUBLIC,
         OFFSET       ADDRESS PUBLIC,     /* AMOUNT TO MOVE IMAGE DOWN */
         SEED         ADDRESS  EXTERNAL,   /* SEED FOR RAND GENERATOR */
         BEGIN        ADDRESS EXTERNAL,   /* START OF BUILD MODULE */
         OVERFLOW     LITERALLY 'OVER',
         OVER         ADDRESS  EXTERNAL;

    /*
         ********************************************************
         *                                                      *
 LIT        '80',
         NUMFILES      LIT         '20',  /* MAX NUMBER USER FILES */
         NRSTACK       LIT        '96';  /* STACK SIZE TIMES 4 */

    /*
         ********************************************************
         *                                                      *
         *                   GLOBAL VARIABLES                   *
         *                                                      *
         ********************************************************
    */

DE,
         BRAZ      BASED     RA        BYTE,
         ARA       BASED     RA        ADDRESS,
         ARB       BASED     RB        ADDRESS,
         BRB       BASED     RB(4)     BYTE,
         BRBZ      BASED     RB        BYTE,
         MPR       ADDRESS,  /* BASE ADDRESS OF PRT */
         MDA       ADDRESS,  /* BASE OF DATA AREA */
         MCD       ADDRESS,  /* BASE OF CODE AREA */
         LOCALSEED ADDRESS,  /* USED TO SET SEED */
         CURRENTLINE ADDRESS INITIAL(0),  /* SOURCE LIN      TABPOS1           LIT      '142', /* ABSOLUTE ADDR REL TO */
         TABPOS2           LIT      '156', /*   PRINTBUFFLOC  */
         TABPOS3           LIT      '170',
         TABPOS4           LIT      '184',
         PRINTBUFFER       ADDRESS  INITIAL(PRINTBUFFERLOC),
         PRINTPOS          BASED    PRINTBUFFER   BYTE,
         PRINTBUFFEND      LIT      '0103H', /* ABSOLUTE ADDRESS */
         PRINTWORKAREA(14) BYTE,  /* FOR CONV FROM FP TO ASCII */
         REREADADDR        ADDRESS,             ADDRESS,
         NEXTDISKCHAR        BASED     RECORD$POINTER BYTE,
         BLOCKSIZE           ADDRESS,
         BYTES$WRITTEN       ADDRESS,
         FIRSTFIELD          BYTE,
         EOFRA               ADDRESS,
         EOFRB               ADDRESS;

DECLARE
         DECIMAL(4) ADDRESS DATA(1000,100,10,1),
         ONEHALF(4) BYTE DATA(80H,0,0,0),
         PLUSONE(4)  BYTE DATA(81H,0,0,0),
         MINUSONE(4) BYTE DATA(81H,80H,0,0),
         MAXNUM(4) BYTE DATA(0FFH,07FH,0FF        *            SYSTEM PARAMETERS WHICH MAY               *
         *            REQUIRE MODIFICATION BY USERS             *
         *                                                      *
         ********************************************************
    */
DECLARE
         EOLCHAR       LIT       '0DH',
         EOFFILLER     LIT       '1AH',
         INTRECSIZE    LIT       '128',
         DISKRECSIZE   LIT       '128',
         STRINGDELIM   LIT       '22H',
         CONBUFFSIZE   ECLARE
         RA        ADDRESS,  /* ADDRESS OF REG A */
         RB        ADDRESS,  /* ADDRESS OF REG B */
         RC        ADDRESS,  /* ADDRESS OF REGISTER C */
         C         BASED     RC BYTE, /* BYTE OF CODE */
         CV        BASED     RC(2) BYTE, /* VERSION OF C WITH SUBSCRIPT */
         TWOBYTEOPRAND BASED RC ADDRESS,  /* TWO BYTES CODE */
         SB        ADDRESS,  /* BOTTOM OF STACK */
         ST        ADDRESS, /* TOP OF STACK */
         BRA       BASED     RA(4)     BYTE BEING EXEC */
         DATAAREAPTR ADDRESS,  /* CURRENT LOCATION IN DATA AREA */
         MBASE     ADDRESS;  /* BEGINNING OF FREE STORAGE AREA */

DECLARE
         INPUTBUFFER       BYTE INITIAL(CONBUFFSIZE), /* USED WITH SPACE */
         SPACE(CONBUFFSIZE) BYTE,  /* INPUT BUFFER FOR CON AND DISK */
         INPUTINDEX        BYTE,
         CONBUFFPTR        ADDRESS,
         INPUTPTR          ADDRESS,
         PRINTBUFFLENGTH   LIT       '132',
         PRINTBUFFERLOC    LIT      '80H',
     /* TO RECOVER FROM READ ERROR */
         INPUTTYPE         BYTE;

DECLARE
         FILEADDR            ADDRESS, /*CURRENT FCB POINTER BASE */
         FCB                 BASED     FILEADDR(33)  BYTE,
         FCBADD              BASED     FILEADDR(33)  ADDRESS,
         EOFADDR             ADDRESS,
         FILES(NUMFILES)     ADDRESS,  /*POINTER ARRAY TO FCBS */
         EOFBRANCH(NUMFILES) ADDRESS,
         BUFFER$END          ADDRESS,
         RECORD$POINTER      ADDRESS,
         BUFFER H,0FFH),
         MAXPOSNUM BYTE DATA (4),
         POSITION(9) ADDRESS DATA(TABPOS1,TABPOS2,TABPOS3,TABPOS4,
               PRINTBUFFEND),
         SCALE(4) BYTE DATA(90H,7FH,0FFH,0);


    /*
         ********************************************************
         *                                                      *
         *       SYSTEM DEPENDENT ROUTINES AND VARIABLES        *
         *           THE FOLLOWING ROUTINES ARE USED            *
         *           BY THE INTERPRETER TO ACCESS DISK          *
         *           FILES AND FOR CONSOLE I/O.                 *
         *           THE ROUTINES ASSUME THE USE OF THE         *
         *           CP/M OPERATING SYSTEM.                     *
         *                                                      *
         ********************************************************
    */


MON1: PROCEDURE(FUNC,PARM) EXTERNAL;
    DECLARE FUNC BYTE,
    PARM ADDRESS;
END MON1;

MON2: PROCEDURE(FUNC,PARM) BYTE EXTERNAL;
   
       FIRST WAIT FOR FIRST CHAR AND SET LOCALSEED
       SO IT CAN BE USED TO SEED RANDOM NUMBER GENERATOR
    */
    DO WHILE NOT MON2(11,0);
         LOCALSEED = LOCALSEED + 1;
         END;
    /* READ INTO BUFFER AT A+2 */
    CALL MON1(10,A);
END READ;


OPEN: PROCEDURE BYTE;
    RETURN MON2(15,FILEADDR);
END OPEN;


CLOSE: PROCEDURE BYTE;
    RETURN MON2(16,FILEADDR);
END CLOSE;


DISKREAD: PROCEDURE BYTE;
    RETURN MON2(20,FILEADDR);
END DISKREAD;


DISKWRITE: PROCEDURE N);
END PRINT;


    /*
         ********************************************************
         *                                                      *
         *        GENERAL PURPOSE INTERPRETER ROUTINES          *
         *                                                      *
         ********************************************************
    */
TIMES4: PROCEDURE(N) ADDRESS;
    DECLARE N ADDRESS;
    RETURN SHL(N,2);
END TIMES4;

PRINT$DEC: PROCEDURE(VALUE);
    DECLARE VALUE NG AT DEST WITH CHAR FOR N BYTES */
    DECLARE
            DEST   ADDRESS,
            N      ADDRESS,
            D      BASED    DEST   BYTE,
            CHAR   BYTE;
    DO WHILE (N:=N-1) <> 0FFFFH;
         D = CHAR;
         DEST = DEST + 1;
    END;
END FILL;



OUTPUT$MSG: PROCEDURE(MSG);
    DECLARE MSG ADDRESS;
    CALL PRINT$CHAR(HIGH(MSG));
    CALL PRINT$CHAR(LOW(MSG));
    IF CURRENTLINE > 0 THEN
         DO;
              CALL PRINT(.(' IN LINE $'));
         CALL PRINT$D
         *            STACK MANIPULATION ROUTINES               *
         *                                                      *
         ********************************************************
    */

STEP$INS$CNT: PROCEDURE;
    RC=RC+1;
END STEP$INS$CNT;

POP$STACK: PROCEDURE;
    RA = RB;
    IF(RB := RB - 4) < SB THEN
         RB = ST - 4;
END POP$STACK;

PUSH$STACK: PROCEDURE;
    RB = RA;
    IF(RA := RA + 4) >= ST THEN
         RA = SB;
END PUSH$STACK;


IN$FSA: PROCEDURE( DECLARE FUNC BYTE,
    PARM ADDRESS;
END MON2;

MON3: PROCEDURE EXTERNAL;
    /* REBOOT SYSTEM */
END MON3;

MOVEA: PROCEDURE(A) EXTERNAL;
    DECLARE A ADDRESS;
    END MOVEA;

MOVE4: PROCEDURE(S,D) EXTERNAL;
    DECLARE (S,D) ADDRESS;
    END MOVE4;

PRINTCHAR: PROCEDURE(CHAR) PUBLIC;
    DECLARE CHAR BYTE;
    CALL MON1(2,CHAR);
END PRINTCHAR;


CRLF: PROCEDURE;
    CALL PRINTCHAR(CR);
    CALL PRINTCHAR(LF);
END CRLF;




READ: PROCEDURE(A);
    DECLARE A ADDRESS;
    /*BYTE;
    RETURN MON2(21,FILEADDR);
END DISKWRITE;


CREATE: PROCEDURE BYTE;
      RETURN MON2(22,FILEADDR);
END CREATE;

MAKE: PROCEDURE BYTE;
    CALL MON1(19,FILEADDR);
    RETURN CREATE;
END MAKE;


SETDMA: PROCEDURE;  /* SET DMA ADDRESS FOR DISK I/O */
    CALL MON1(26,BUFFER);
END SETDMA;


PRINT: PROCEDURE(LOCATION) PUBLIC;
    DECLARE LOCATION ADDRESS;
    /* PRINT THE STRING STARTING AT ADDRESS LOCATION UNTIL THE
    NEXT DOLLAR SIGN IS ENCOUNTERED */
    CALL MON1(9,LOCATIOADDRESS,
            I BYTE,
            COUNT BYTE;
    DO I = 0 TO 3;
         COUNT = 30H;
         DO WHILE VALUE >= DECIMAL(I);
              VALUE = VALUE - DECIMAL(I);
              COUNT = COUNT + 1;
              END;
         CALL PRINTCHAR(COUNT);
    END;
END PRINT$DEC;


MOVE: PROCEDURE(SOURCE,DEST,N);

    /*MOVE N BYTES FROM SOURCE TO DEST */
    DECLARE (SOURCE,DEST,N) ADDRESS;
    CALL MOVEA(.SOURCE);
END MOVE;

FILL: PROCEDURE(DEST,CHAR,N);
    /*FILL LOCATIONS STARTIEC(CURRENTLINE);
         END;
    CALL CRLF;
END OUTPUT$MSG;


ERROR: PROCEDURE(E);
    DECLARE E ADDRESS;
    CALL CRLF;
    CALL PRINT(.('ERROR $'));
    CALL OUTPUTMSG(E);
    CALL MON3;
END ERROR;


WARNING: PROCEDURE(W);
    DECLARE W ADDRESS;
    CALL CRLF;
    CALL PRINT(.('WARNING $'));
    CALL OUTPUTMSG(W);
    RETURN;
END WARNING;


    /*
         ********************************************************
         *                                                      *
LOCATION) BYTE;
     /*
          RETURNS TRUE IF LOCATION IS IN FSA
     */
    DECLARE LOCATION ADDRESS;
    RETURN LOCATION > ST;
END IN$FSA;


SET$DATA$ADDR: PROCEDURE(PTR);
    DECLARE PTR ADDRESS, A BASED PTR ADDRESS;
    IF NOT IN$FSA(A) THEN
         A = MPR + TIMES4(A);
END SET$DATA$ADDR;


MOVE$RA$RB: PROCEDURE;
    CALL MOVE4(RA,RB);
END MOVE$RA$RB;


MOVE$RB$RA:  PROCEDURE;
    CALL MOVE4(RB,RA);
         END MOVERBRA;


FLIP: PROCEDURE;
    DECLARE TEMP(4) BYTE;
    CALL MOVE4(RA,.TEMP);
    CALL MOVE$RB$RA;
    CALL MOVE4(.TEMP,RB);
         END FLIP;


LOAD$RA: PROCEDURE;
    CALL SET$DATA$ADDR(RA);
    CALL MOVE4(ARA,RA);
    END LOADRA;

RA$ZERO: PROCEDURE BYTE;
    RETURN BRAZ = 0;
END RA$ZERO;


RB$ZERO: PROCEDURE BYTE;
    RETURN BRBZ = 0;
END RB$ZERO;


RA$ZERO$ADDRESS: PROCEDURE BYTE;
    RETURN ARA = 0;
END RA$ZERO$ADDRESS;


RB$ZERO$ADDRESS: PROCEDURE BYTE;
    RETURN ARB = 0;
END RB$ZERO$ADDRESS;


RA$NEGATIVE: PROCEDURE BYTE; *       ALL FLOATING POINT OPERATIONS ARE PERFORMED    *
         *       BY CALLING ROUTINES IN THIS SECTION.  THE      *
         *       FLOATING POINT PACKAGE IS ACCESSED BY THE      *
         *       FOLLOWING SIX ROUTINES:                        *
         *           (1)  CONV$TO$BINARY                        *
         *           (2)  CONV$TO$FP                            *
         *           (3)  FP$INPUT                              *
         *           (4)  FP$OUT                   N ADDRESS PLACE THE RESULTS IN       *
         *       THE FIRST TWO BYTES OF THE STACK AS AN 8080    *
         *       ADDRESS QUANTITY WITH LOW ORDER BYTE FIRST     *
         *                                                      *
         *                                                      *
         *                                                      *
         ********************************************************
    */

DECLARE
         FINIT     LIT       '0',                /*  FZRO      LIT       '8',                /* ZERO ACCUM*/
         FTST      LIT       '9',                /* TEST SIGN OF ACCUM*/
         FCHS      LIT       '10',               /* COMPL. ACCUM*/
         SQRT      LIT       '11',               /* SQRT OF ACCUM*/
         COS       LIT       '12',               /* COS ACCUM*/
         SIN       LIT       '13',               /* SIN ACCUM*/
         ATAN      LIT       '14',               /* ARCTAN ACCUM */
         COSH      LIT       '15',         OVERFLOW: PROCEDURE;
    IF OVERFLOW THEN
         DO;
              CALL WARNING('OF');
              CALL MOVE4(.MAXNUM,RA);
              OVERFLOW = 0;
         END;
END CHECK$OVERFLOW;


CONV$TO$BINARY: PROCEDURE(A) EXTERNAL;  /*CONVERTS FP NUM AT A TO BINARY
         AND RETURNS RESULT TO A  */
    DECLARE A ADDRESS;
END CONV$TO$BINARY;

CONV$TO$FP: PROCEDURE(A) EXTERNAL;  /* CONVERTS BINARY NUM AT A TO FP AND
         LEAVES IT AT A  */
    DECLARE A ADDRESS;
END CONV$TO$FP;

FP$IN
    RETURN ROL(BRA(1),1);
END RA$NEGATIVE;


RB$NEGATIVE: PROCEDURE BYTE;
    RETURN ROL(BRB(1),1);
END RB$NEGATIVE;


FLAG$STRING$ADDR: PROCEDURE(X);
    DECLARE X BYTE;
    BRA(2) = X;
END FLAG$STRING$ADDR;


    /*
         ********************************************************
         *                                                      *
         *           FLOATING POINT INTERFACE ROUTINES          *
         *                                                      *
                     *
         *           (5)  FP$OP$RETURN                          *
         *           (6)  FP$OP                                 *
         *       CHECK$OVERFLOW DOES JUST THAT!!                *
         *       THE REMAINING ROUTINES USE THE ABOVE           *
         *       PROCEDURES TO ACCOMPLISH COMMON ROUTINES       *
         *                                                      *
         *       CONV$TO$BIN$ADDR AND OTHER ROUTINES WHICH      *
         *       REFER TO A INITIALIZE*/
         FSTR      LIT       '1',                /* STORE (ACCUM)*/
         FLOD      LIT       '2',                /* LOAD ACCUM */
         FADD      LIT       '3',                /* ADD TO ACCUM */
         FSUB      LIT       '4',                /* SUB FROM ACCUM*/
         FMUL      LIT       '5',                /* MUL BY ACCUM*/
         FDIV      LIT       '6',                /* DIVIDE INTO ACCUM*/
         FABS      LIT       '7',                /* ABS VALUE OF ACCUM*/
             /* COSH ACCUM*/
         SINH      LIT       '16',               /* SINH ACCUM*/
         EXP       LIT       '17',               /* EXPONENTIAL ACCUM*/
         LOG       LIT       '18';               /* LOG ACCUM*/

DECLARE /* EXTERNAL NAMES FOR SUBROUTINES */
         CONV$TO$BINARY LIT 'CBIN',
         CONV$TO$FP     LIT 'CFLT',
         FP$INPUT       LIT 'FLTINP',
         FP$OUT         LIT 'FLTOUT',
         FP$OP$RETURN   LIT 'FLTRET',
         FP$OP          LIT 'FLTOP';

CHECK$PUT: PROCEDURE(LENGTH,A) EXTERNAL;  /* CONVERTS STRING AT A LENGTH LENGTH
         TO FP AND LEAVES RESULT IN FP ACCUM   */
    DECLARE LENGTH BYTE, A ADDRESS;
END FP$INPUT;


FP$OUT: PROCEDURE(A) EXTERNAL;  /* CONVERTS FP ACCUM TO STRING AND PUTS IT
         AT A  */
    DECLARE A ADDRESS;
END FP$OUT;


FP$OP$RETURN: PROCEDURE(FUNC,A) EXTERNAL; /* PERFORMS FUNC AND RETURNS VALUE
         TO A  */
    DECLARE FUNC BYTE, A ADDRESS;
END FP$OP$RETURN;


FP$OP: PROCEDURE(FUNC,A) EXTERNAL;  /* PERFORMS FUNC POSSIBLY USEING
         FP NUM ADDRESSED BY A . NOTHING IS RETURNED TO A */
    DECLARE FUNC BYTE, A ADDRESS;
END FP$OP;

CONV$TO$BIN$ADDR: PROCEDURE;
    CALL CONV$TO$BINARY(RA);
    BRA(0) = BRA(3);
    BRA(1) = BRA(2);
END CONV$TO$BIN$ADDR;

INPUT: PROCEDURE(PORT) BYTE EXTERNAL;
    DECLARE PORT BYTE;
    END INPUT;

OUTPUT: PROCEDURE(PORT,VALUE) EXTERNAL;
    DECLARE (PORT,VALUE) BYTE;
    END OUTPUT;

RANDOM: PROCEDURE EXTERNAL;
    END RANDOM;


ONE$VALUE$OPS: PROAT$ADDR: PROCEDURE(V);
    DECLARE V ADDRESS;
    ARA=0;
    BRA(2)=HIGH(V); BRA(3)=LOW(V);
    CALL CONV$TO$FP(RA);
END FLOAT$ADDR;

COMPARE$FP: PROCEDURE BYTE;
   /* 1=LESS 2=GREATER 3=EQUAL  */
         CALL FP$OP(FLOD,RB);
         CALL FP$OP$RETURN(FSUB,RA);
         IF RA$ZERO THEN
                DO;
                     CALL POP$STACK;
                     RETURN 3;
                END;
         IF RA$NEGATIVE THEN
              DO;
                    CALL POP$STACK;
                     NBYTES   ADDRESS,
            POINT    ADDRESS,
            TEMP     ADDRESS,
            TOTAL    ADDRESS,
            HERE     BASED POINT   ADDRESS,
            SWITCH   BASED POINT(5)   BYTE;
    POINT = MBASE;
    TOTAL = 0;
    DO WHILE POINT <> 0;
         IF SWITCH(4) = 0 THEN
           DO;
              TOTAL = TOTAL + (TEMP := HERE - POINT - 5);
              IF NBYTES <> 0 THEN
                DO;
                   IF NBYTES + 5 <= TEMP THEN
                        RETUR  BASED TEMP2   ADDRESS,
            SWITCH  BASED POINT(5)   BYTE,
            SWITCH2 BASED TEMP1(5)   BYTE;
    IF NBYTES = 0 THEN
         RETURN 0;
    POINT = AVAILABLE(NBYTES);
    /*LINK UP THE SPACE*/
    SWITCH(4)=1;  /* SET SWITCH ON*/
        TEMP1=POINT+NBYTES+5;
         ADR1=HERE;
         TEMP2=HERE + 2;
        HERE,ADR2 = TEMP1;
        SWITCH2(4)=0; /*SET REMAINDER AS AVAIL*/
       TEMP1 = TEMP1 + 2;
       ADR1 = POINT;
    CALL FILL(POINT := POINT + 5,0,NBYTES);
    RETOF FSA */
         DO;
            IF LOOK(4)=0 THEN   /*SPACE ABOVE IS FREE*/
              DO;
                   TEMP=(HERE:=ADRS) + 2;
                   ADRS=SPACE;
              END;
         END;
    END UNLINK;

    HOLD,SPACE=SPACE-5;
    SWITCH(4)=0;    /* RELEASES THE SPACE */
    /* COMBINE WITH SPACE ABOVE AND BELOW IF POSSIBLE*/
    CALL UNLINK;
    SPACE=SPACE+2;  /* LOOK AT PREVIOUS BLOCK*/
    IF (SPACE:=HERE)<>0 THEN
    DO;
        IF SWITCH(4)=0 THEN
        DO;
      CEDURE(A);
         DECLARE A BYTE;
         CALL FP$OP(FLOD,RA);
         CALL FP$OP$RETURN(A,RA);
    CALL CHECK$OVERFLOW;
END ONE$VALUE$OPS;

TWO$VALUE$OPS: PROCEDURE(TYPE);
    DECLARE TYPE BYTE;
         CALL FP$OP(FLOD,RA);
         CALL FP$OP$RETURN(TYPE,RB);
    CALL POP$STACK;
    CALL CHECK$OVERFLOW;
END TWO$VALUE$OPS;

ROUND$CONV$BIN: PROCEDURE;
    CALL PUSH$STACK;
    CALL MOVE4(.ONEHALF,RA);
    CALL TWO$VALUE$OPS(FADD);
    CALL CONV$TO$BIN$ADDR;
END ROUND$CONV$BIN;

FLO        RETURN 1;
              END;
         CALL POP$STACK;
         RETURN 2;
END COMPARE$FP;


    /*
         ********************************************************
         *                                                      *
         *         DYNAMIC STORAGE ALLOCATION PROCEDURES        *
         *                                                      *
         ********************************************************
    */
AVAILABLE: PROCEDURE(NBYTES) ADDRESS;
    DECLARE
   N POINT;
                END;
           END;
           POINT = HERE;
    END;
    IF NBYTES <> 0 THEN
         CALL ERROR('NM');
    RETURN TOTAL;
END AVAILABLE;

GETSPACE: PROCEDURE(NBYTES) ADDRESS;
    DECLARE
            NBYTES  ADDRESS,
            SPACE   ADDRESS,
            POINT   ADDRESS,
            HERE    BASED POINT   ADDRESS,
            TEMP    ADDRESS,
            TEMP1   ADDRESS,
            TEMP2   ADDRESS,
            ADR1    BASED TEMP1   ADDRESS,
            ADR2  URN POINT;
END GETSPACE;

RELEASE: PROCEDURE(SPACE);
    DECLARE
            SPACE      ADDRESS,
            HOLD       ADDRESS,
            NEXT$AREA  BASED     HOLD    ADDRESS,
            SWITCH     BASED     SPACE(5)   BYTE,
            HERE       BASED     SPACE   ADDRESS,
            TEMP       ADDRESS,
            ADRS       BASED     TEMP    ADDRESS,
            LOOK       BASED     TEMP(5)    BYTE;

    UNLINK: PROCEDURE;
        TEMP=HERE;
        IF ADRS<>0 THEN      /*NOT AT TOP       CALL UNLINK;
           HOLD=SPACE;
        END;
    END;
END RELEASE;

    /*
         ********************************************************
         *                                                      *
         *            ARRAY ADDRESSING PROCEDURES               *
         *                                                      *
         *     CALC$ROW SETS UP AN ARRAY IN THE FSA IN ROW      *
         *     MAJOR ORDER.  THE BYTE OF CODE FOLLOWING THE     *
         *     OPERATOR IS THE NUMBER OF DIMENSIONS.  THE       *
         *     STACK CONTAINS THE UPPER BOUND OF EACH DIMENSION *
         *     RA HOLDS DIMENSION N, RB DIMENSION N-1 ETC.      *
         *     THE LOWER BOUND IS ALWAYS ZERO.                  *
         *                                                      *
         *     CALC$SUB PERFORMS A SUBSCRIPT CALCULATION FOR    *
         *     THE ARRAY REFERENCED BY RA.  THE VALUE OF EACH   *
         *     DIMENSION IS ON THE STACK BELOW THE ARRAY     RESS,
            ARRAYADDR   ADDRESS,
            NUMDIM      BASED RC BYTE,
            ARRAYPOS    BASED ARRAYADDR ADDRESS;

    ASIZE = 1;  /* INITIAL VALUE */
    CALL STEP$INS$CNT;  /* POINT RC TO NUMDIM */
    SAVERA = RA;  /* SAVE CURRENT STACK POINTER */
    SAVERB = RB;
    DO I = 1 TO NUMDIM; /* FIRST PASS ON ARRAY DIMENSIONS */
         ARA,ASIZE = ASIZE * (ARA + 1); /* DISPLACEMENT AND TOTAL */
         CALL POP$STACK;  /* NEXT DIMENSION */
         END;
    RA = SAVERA;  /* BACK TBASED ARRAYADDR ADDRESS,
            I         BYTE,
            NUMDIM    BYTE,
            LOCATION  ADDRESS;

    INC$ARRAYADDR: PROCEDURE;
         ARRAYADDR = ARRAYADDR + 1 + 1;
    END INC$ARRAYADDR;

    ARRAYADDR = ARA;
    CALL POP$STACK;
    LOCATION = ARA;
    NUMDIM = ARRAYPOS;
    DO I = 2 TO NUMDIM;
         CALL POP$STACK;
         CALL INC$ARRAYADDR;
         LOCATION = ARA * ARRAYPOS + LOCATION;
         END;
    CALL INC$ARRAYADDR;
    IF LOCATION >= ARRAYPOS THEN
     ORMED:                                       *
         *         (1)  IF THE PRT CELL ALREADY CONTAINS A      *
         *         REFERENCE TO A STRING IN THE FSA THAT        *
         *         STRING'S COUNTER IS DECREMENTED AND IF       *
         *         EQUAL TO 1 THEN THE SPACE IS FREED           *
         *         (2)  THE NEW STRINGS COUNTER IS INCREMENTED  *
         *         IF IT IS ALREADY 255 THEN A COPY IS MADE     *
         *         AND THE NEW COUNTER SET TO 2.              RING OFF */
         PTRADDR = ARB;  /* CAN WE FREE STRING DESTINATION POINTED TO */
              IF IN$FSA(STRINGADDR) THEN   /* IN FSA ? */
                   DO;
                        PTR = STRINGADDR - 1;
                        IF(COUNTER := COUNTER - 1) = 1 THEN
                             CALL RELEASE(STRINGADDR);
                   END;
              IF IN$FSA(PTR := ARA - 1) THEN   /* INC COUNTER */
                   DO;
                   IF COUNTER = 255 THEN  /* ALREADY POINTED TO   *
         *     ADDRESS STARTING WITH THE NTH DIMENSION          *
         *     A CHECK IS MADE TO SEE IF THE SELECTED ELEMENT   *
         *     IS OUTSIDE THE AREA ASIGNED TO THE ARRAY         *
         *                                                      *
         ********************************************************
    */

CALC$ROW: PROCEDURE;
    DECLARE
            ASIZE       ADDRESS,
            I           BYTE,
            SAVERA      ADDRESS,
            SAVERB      ADDO ORIGINAL STACK POSITION */
    RB = SAVERB;
    SAVERA,ARRAYADDR = GETSPACE(TIMES4(ASIZE) + SHL(NUMDIM+1,1));
    ARRAYPOS = NUMDIM;  /* STORE NUMBER OF DIM */
    DO I = 1 TO NUMDIM;  /* STORE DISPLACEMENTS */
         ARRAYADDR = ARRAYADDR + 2;
         ARRAYPOS = ARA;
         CALL POP$STACK;
         END;
    CALL PUSH$STACK;  /* NOW PUT ADDRESS OF ARRAY ON STACK */
    ARA = SAVERA;
END CALC$ROW;


CALC$SUB: PROCEDURE;
    DECLARE
            ARRAYADDR ADDRESS,
            ARRAYPOS      CALL ERROR('SB');
    ARA = ARRAYADDR + 2 + TIMES4(LOCATION);
END CALC$SUB;
    /*
         ********************************************************
         *                                                      *
         *     STORE PLACES RA IN THE PRT LOCATION REFERENCED   *
         *     BY RB.  RA MAY CONTAIN A FLOATING POINT NUMBER   *
         *     OR A REFERENCE TO A STRING.                      *
         *     IN THE CASE OF A STRING THE FOLLOWING IS ALSO    *
         *     PERF  *
         *                                                      *
         ********************************************************
    */

STORE: PROCEDURE(TYPE);
    DECLARE
            TYPE       BYTE,
            PTRADDR    ADDRESS,
            PTR        ADDRESS,
            STRINGADDR BASED PTRADDR  ADDRESS,
            COUNTER    BASED PTR      BYTE;
    CALL SET$DATA$ADDR(RB);
    IF TYPE THEN  /* STORE STRING */
         DO;
              CALL FLAG$STRING$ADDR(0);  /* SET TEMP ST BY
                                             254 VARIABLES */
                        DO;
                             PTR = PTR + 1;
                             CALL MOVE(PTR,ARA := GETSPACE(COUNTER + 1),
                                       COUNTER + 1);
                             PTR = ARA - 1;
                        END;
                   COUNTER = COUNTER + 1;
                   END;
         END;
    CALL MOVE4(RA,ARB);
END STORE;
    /*
         ********************************************************
         *                                                      *
         *                  BRANCHING ROUTINES                  *
         *                                                      *
         ********************************************************
    */

UNCOND$BRANCH: PROCEDURE;
    RC = RC + ARA - 1;
    CALL POP$STACK;
END UNCOND$BRANCH;


COND$BRANCH: PROCEDURE;
    IF RB$ZERO THEN
         CALL UNCOND$BRANCH;
    ELSE
         CALL POP$STACK;HECK$STRING$ADDR: PROCEDURE BYTE;
    RETURN BRA(2);
END CHECK$STRING$ADDR;

STRING$FREE: PROCEDURE;
    IF CHECK$STRING$ADDR THEN
         CALL RELEASE(ARA);
END STRING$FREE;


GET$STRING$LEN: PROCEDURE(STRINGLOC) BYTE;
    DECLARE
            STRINGLOC     ADDRESS,
            A     BASED STRINGLOC    BYTE;
    IF STRINGLOC = 0 THEN
         RETURN 0;
    RETURN A;
END GET$STRING$LEN;

COMP$FIX: PROCEDURE(FLAG);
    DECLARE FLAG     BYTE;
    IF FLAG THEN
         CALL MOVE4(.MINUSON.                                           *
         *                                                      *
         ********************************************************
    */
    DECLARE FIRSTSTRINGLENGTH  BYTE,
            SECONDSTRINGLENGTH BYTE,
            NEWSTRINGLENGTH    BYTE,
            NEWSTRINGADDRESS   ADDRESS,
            LENGTH             BASED NEWSTRINGADDRESS BYTE;
    CHKCARRY: PROCEDURE;
        IF CARRY THEN CALL ERROR('SL');
        END CHKCARRY;

    IF RA$ZERO$ MOVE(ARB,NEWSTRINGADDRESS := GETSPACE(NEWSTRINGLENGTH),
              FIRSTSTRINGLENGTH);
    CALL MOVE(ARA + 1,NEWSTRINGADDRESS + FIRSTSTRINGLENGTH,
              SECONDSTRINGLENGTH);
    CALL STRINGFREE;
    CALL POPSTACK;
    CALL STRINGFREE;
    ARA = NEWSTRINGADDRESS;
    LENGTH = NEWSTRINGLENGTH - 1;
    CALL FLAG$STRING$ADDR(TRUE);
END CONCATENATE;


COMPARE$STRING: PROCEDURE BYTE;
    /*
         ********************************************************
         *                       *    STRINGS HAVE THE SAME LENGTH AND CONTAIN          *
         *    IDENTICAL CHARACTERS. THE ASCII COLLATING         *
         *    SEQUENCE IS USED TO DETERMINE THE RELATIONSHIP    *
         *    BETWEEN EQUAL LENGTH STRINGS. IF TWO STRINGS      *
         *    ARE NOT OF EQUAL LENGTH THE SHORTER IS ALWAYS     *
         *    LESS THEN THE LONGER ONE. ALL NULL STRINGS ARE    *
         *    EQUAL AND LESS THEN ANY OTHER STRING.             *
         *                                       
    CALL POP$STACK;
END COND$BRANCH;


ABSOLUTE$BRANCH: PROCEDURE;
    CALL STEP$INS$CNT;
    RC = TWOBYTEOPRAND;
    RETURN;
END ABSOLUTE$BRANCH;
    /*
         ********************************************************
         *                                                      *
         *             GLOBAL STRING HANDLING ROUTINES          *
         *                                                      *
         ********************************************************
    */

CE,RA);
    ELSE
         BRAZ = 0;
END COMP$FIX;


CONCATENATE: PROCEDURE;
    /*
         ********************************************************
         *                                                      *
         *    THE STRING POINTED TO BY RA IS CONCATENATED       *
         *    TO THE STRING POINTED TO BY RB AND THE POINTER    *
         *    TO THE RESULT IS PLACED IN RB. THE STACK IS POPPED*
         *    AND THE RESULT IS FLAGGED AS A TEMPORARY          *
         *    STRINGADDRESS THEN  /* IT DOESNT MATTER WHAT RB IS */
         DO;
              CALL POP$STACK;
              RETURN;
         END;
    IF RB$ZERO$ADDRESS THEN /* AS ABOVE BUT RESULT IS RA */
         DO;
              CALL MOVE$RA$RB;
              CALL POP$STACK;
              RETURN;
         END;
    FIRSTSTRINGLENGTH = GETSTRINGLEN(ARB) + 1;
    CALL CHKCARRY;
    SECONDSTRINGLENGTH = GETSTRINGLEN(ARA);
    NEWSTRINGLENGTH = FIRSTSTRINGLENGTH + SECONDSTRINGLENGTH;
    CALL CHKCARRY;
    CALL                                  *
         *    THE STRING POINTED TO BY RB IS COMPARED TO        *
         *    THE STRING POINTED TO BY RA.                      *
         *                 RB RELATION RA                       *
         *    IF RB < RA THEN RETURN 1                          *
         *    IF RB > RA THE RETURN 2                           *
         *    IF RB = RA THEN RETURN 3                          *
         *    TWO STRINGS ARE EQUAL IF AND ONLY IF THE TWO      *
                     *
         ********************************************************
    */
    DECLARE FIRSTSTRING ADDRESS,
            SECONDSTRING ADDRESS,
            I            BYTE,
            TEMPLENGTH   BYTE,
            CHARSTRING1  BASED FIRSTSTRING BYTE,
            CHARSTRING2  BASED SECONDSTRING BYTE;

     FIXSTACK: PROCEDURE;
            CALL STRING$FREE;
            CALL POP$STACK;
            CALL STRING$FREE;
       END FIXSTACK;

    /* FIRST HANDLE NULL STRINGS REPRESENTED BY RA AND OR RB
    EQUAL TO ZERO */
    IF RA$ZERO$ADDRESS THEN
         SECONDSTRING= RA;
    ELSE
         SECONDSTRING = ARA;
    IF RB$ZERO$ADDRESS THEN
         FIRSTSTRING = RB;
    ELSE
         FIRSTSTRING = ARB;
    TEMPLENGTH = CHARSTRING1;
    DO I = 0 TO TEMPLENGTH;
         IF CHARSTRING1 < CHARSTRING2 THEN
              DO;
                     CALL FIXSTACK;
                     RETURN 1;
                END;
         IF CHARSTRING1 > CHARSTRING2 THEN
            DO;
   BASED TEMPA BYTE,
            TEMPB1  BYTE,
            LNG2    BYTE;

    INC$BRA: PROCEDURE BYTE;
         RETURN BRAZ + 1;
    END INC$BRA;

    TEMPB1 = 0;
    IF TYPE = MID THEN
         DO;
              CALL FLIP;
              IF RA$NEGATIVE OR RA$ZERO THEN
                   CALL ERROR('SS');
              CALL CONV$TO$BIN$ADDR;
              TEMPB1 = BRAZ;
              CALL POP$STACK;
         END;
     IF RA$NEGATIVE OR (TEMPB1 > GETSTRING$LEN(ARB)) OR RA$ZERO THEN
         E
              TEMPA2 = ARB + TEMPB1 - 1;
    CALL MOVE(TEMPA2,(TEMPA := GETSPACE(INC$BRA)),INC$BRA);
    LNG = BRAZ;
    CALL POP$STACK;
    CALL STRINGFREE;
    ARA = TEMPA;
    CALL FLAG$STRING$ADDR(TRUE);
END STRING$SEGMENT;



LOGICAL: PROCEDURE(TYPE);
    DECLARE
            TYPE   BYTE,
            I      BYTE;
    CALL CONV$TO$BINARY(RA);
    IF TYPE > 0 THEN
         CALL CONV$TO$BINARY(RB);
    DO I = 0 TO 3;
         DO CASE TYPE;
              BRA(I) = NOT BRA(I);
                        *
         ********************************************************
    */
NUMERIC$OUT: PROCEDURE;
    /*
         ********************************************************
         *                                                      *
         *    THE FLOATING POINT NUMBER IN RA IS CONVERTED TO   *
         *    AN ASCII CHARACTER STRING AND THEN PLACED         *
         *    IN THE WORKBUFFER.  THE LENGTH OF THE STRING      *
         *    SET TO THE FIRST BYTE OF THE BUFFER RKAREA(0) = I;
END NUMERIC$OUT;


CLEAR$PRINT$BUFF: PROCEDURE;
    CALL FILL((PRINTBUFFER := PRINTBUFFERLOC),' ',PRINTBUFFLENGTH);
END CLEAR$PRINT$BUFF;


DUMP$PRINT$BUFF: PROCEDURE;
    DECLARE
            TEMP  ADDRESS,
            CHAR  BASED TEMP BYTE;
    TEMP=PRINTBUFFEND;
    DO WHILE CHAR = ' ';
        TEMP=TEMP - 1;
         END;
    CALL CRLF;
    DO PRINTBUFFER = PRINTBUFFERLOC TO TEMP;
        CALL PRINTCHAR(PRINTPOS);
         END;
    CALL CLEAR$PRINT$BUFF;
END DUMP$PRIN                  CALL FIXSTACK;
                   RETURN 2;
              END;
         FIRSTSTRING = FIRSTSTRING + 1;
         SECONDSTRING = SECONDSTRING + 1;
        END;
    CALL FIXSTACK;
    RETURN 3;
END COMPARE$STRING;

STRING$SEGMENT: PROCEDURE(TYPE);
    DECLARE /* POSSIBLE TYPES */
            LEFT  LIT '0',
            RIGHT LIT '1',
            MID   LIT '2';

    DECLARE
            TYPE    BYTE,
            TEMPA   ADDRESS,
            TEMPA2  ADDRESS,
            LNG   DO;
              CALL POP$STACK;
              CALL STRINGFREE;
              ARA = 0;
              RETURN;
         END;
    CALL CONV$TO$BIN$ADDR;
    IF BRAZ > (LNG2 := GETSTRING$LEN(ARB) - TEMPB1) THEN
         DO;
              IF TYPE=MID THEN
                   BRAZ = LNG2 + 1;
              ELSE
                   BRAZ = LNG2;
         END;
    IF TYPE = LEFT THEN
         TEMPA2 = ARB;
    ELSE
         IF TYPE = RIGHT THEN
              TEMPA2 = ARB + LNG2 - BRAZ;
         ELS      BRB(I) = BRA(I) AND BRB(I);
              BRB(I) = BRA(I) OR BRB(I);
              BRB(I) = BRA(I) XOR BRB(I);
         END;
    END; /* OF DO TWICE */
    IF TYPE > 0 THEN
         CALL POP$STACK;
    CALL CONV$TO$FP(RA);
END LOGICAL;


    /*
         ********************************************************
         *                                                      *
         *                CONSOLE OUTPUT ROUTINES               *
         *                                                    *
         *                                                      *
         ********************************************************
    */
    DECLARE
             I      BYTE;  /* INDEX */
    CALL FP$OP(FLOD,RA);  /* LOAD FP ACCUM WITH NUMBER FROM RA */
    CALL FP$OUT(.PRINTWORKAREA(1));  /* CONVERT IT TO ASCII  */
            /* RESULT IN PRINTWORKAREA PLUS 1 */
     I = 0;
     DO WHILE PRINTWORKAREA(I := I + 1) <> ' ';
          END;
     ARA = .PRINTWORKAREA;
     PRINTWOT$BUFF;

WRITE$TO$CONSOLE: PROCEDURE;
     DECLARE
             HOLD     ADDRESS,
             H        BASED     HOLD(1)    BYTE,
             INDEX    BYTE;
     IF (HOLD := ARA) <> 0 THEN  /* MAY BE NULL STRING */
          DO INDEX = 1 TO H(0);
               PRINTPOS = H(INDEX);
               IF (PRINTBUFFER := PRINTBUFFER + 1) >
                              PRINTBUFFEND THEN
                    CALL DUMPPRINTBUFF;
           END;
END WRITE$TO$CONSOLE;


    /*
         ********************************************************
         *                                                      *
         *      FILE PROCESSING ROUTINES FOR USE WITH CP/M      *
         *                                                      *
         ********************************************************
    */
INITIALIZE$DISK$BUFFER: PROCEDURE;
    CALL FILL(BUFFER,EOFFILLER,128);
END INITIALIZE$DISK$BUFFER;


BUFFER$STATUS$BYTE: PROCEDURE BYTE;
    RETURN FCB(33);
END BUFFER$STATUS$BYTE;

END ACTIVE$BUFFER;

SET$BUFFER$INACTIVE: PROCEDURE;
    CALL SET$BUFFER$STATUS$BYTE(BUFFER$STATUS$BYTE AND 0F9H);
END SET$BUFFER$INACTIVE;

SET$BUFFER$ACTIVE: PROCEDURE;
    CALL SET$BUFFER$STATUS$BYTE(BUFFER$STATUS$BYTE OR 02H);
END SET$BUFFER$ACTIVE;


SET$RANDOM$MODE: PROCEDURE;
    CALL SET$BUFFER$STATUS$BYTE(BUFFER$STATUS$BYTE OR 80H);
END SET$RANDOM$MODE;

RANDOM$MODE: PROCEDURE BYTE;
    RETURN ROL(BUFFER$STATUS$BYTE,1);
END RANDOM$MODE;


STORE$REC$PTR: PROCEDURE;
    FCBADD(1AD = 0 THEN
         DO;
              CALL SET$BUFFER$ACTIVE;
              RETURN;
         END;
    IF NOT RANDOM$MODE THEN
         DO;
             CALL DISK$EOF;
             RETURN;
         END;
    CALL INITIALIZE$DISK$BUFFER;
    CALL SET$BUFFER$ACTIVE;
    FCB(32) = FCB(32) + 1;
    RETURN;
END FILL$FILE$BUFFER;


WRITE$DISK$IF$REQ: PROCEDURE;
    IF WRITE$MARK THEN
    DO;
         IF SHR(BUFFER$STATUS$BYTE,2) THEN
              DO;
                   IF FCB(32) > 0 THEN
 ORD$POINTER + 1) >= BUFFER$END;
END AT$END$DISK$BUFFER;

VAR$BLOCK$SIZE: PROCEDURE BYTE;
    RETURN BLOCKSIZE <> 0;
END VAR$BLOCKSIZE;


WRITE$A$BYTE: PROCEDURE(CHAR);
    DECLARE CHAR BYTE;
    IF VAR$BLOCK$SIZE AND (BYTESWRITTEN := BYTESWRITTEN + 1)
               > BLOCKSIZE THEN
         CALL ERROR('ER');
    IF AT$END$DISK$BUFFER THEN
         CALL WRITE$DISK$IF$REQ;
    IF NOT ACTIVE$BUFFER AND RANDOM$MODE THEN
         DO;
              CALL FILL$FILE$BUFFER;
              FCB(32) =UFFER := FILEADDR + 38) + DISKRECSIZE;
    RECORDPOINTER = FCBADD(18);
    BLOCKSIZE = FCBADD(17);
    CALL SETDMA;
END SET$FILE$POINTERS;


SETUP$FILE$EXTENT: PROCEDURE;
    IF OPEN = 255 THEN
         DO;
              IF CREATE = 255 THEN
                   CALL ERROR('ME');
         END;
END SETUP$FILE$EXTENT;


DISK$OPEN: PROCEDURE;
    /*OPENS THE FILE - RA CONTAINS THE ADDRESS OF THE FILE NAME
    AND RB CONTAINS THE BLOCK SIZE.
    THE ARRAY FILES WILL HOLD THE ADDRESS OF THE FILE
SET$BUFFER$STATUS$BYTE: PROCEDURE(STATUS);
    DECLARE STATUS BYTE;
    FCB(33) = STATUS;
END SET$BUFFER$STATUS$BYTE;


WRITE$MARK: PROCEDURE BYTE;
    RETURN BUFFER$STATUS$BYTE;
END WRITE$MARK;


SET$WRITE$MARK: PROCEDURE;
    CALL SET$BUFFER$STATUS$BYTE(BUFFER$STATUS$BYTE OR 01H);
END SET$WRITEMARK;


CLEAR$WRITE$MARK: PROCEDURE;
    CALL SET$BUFFER$STATUS$BYTE(BUFFER$STATUS$BYTE AND 0FEH);
END CLEAR$WRITE$MARK;


ACTIVE$BUFFER: PROCEDURE BYTE;
    RETURN SHR(BUFFER$STATUS$BYTE,1);8) = RECORDPOINTER;
END STORE$REC$PTR;

DISK$EOF: PROCEDURE;
         IF EOFADDR = 0 THEN
              CALL ERROR('EF');
         RC = EOFADDR + 1;
         RA = EOFRA;
         RB = EOFRB;
         IF RECORD$POINTER <> BUFFER THEN
                CALL SET$BUFFER$STATUS$BYTE(BUFFER$STATUS$BYTE OR 04H);
           RECORD$POINTER = RECORD$POINTER - 1;
         CALL STORE$REC$PTR;
         GOTO EOFEXIT;  /* DROP OUT TO OUTER LOOP */;
END DISK$EOF;


FILL$FILE$BUFFER: PROCEDURE;
    IF DISKRE                       FCB(32) = FCB(32) - 1;
                   CALL SET$BUFFER$STATUS$BYTE(BUFFER$STATUS$BYTE AND 0FBH);
              END;
         IF DISKWRITE <> 0 THEN
              CALL ERROR('DW');
         CALL CLEAR$WRITE$MARK;
         IF RANDOM$MODE THEN
              CALL SET$BUFFER$INACTIVE;
         ELSE
              CALL INITIALIZE$DISK$BUFFER;
    END;
    RECORD$POINTER = BUFFER;
END WRITE$DISK$IF$REQ;


AT$END$DISK$BUFFER: PROCEDURE BYTE;
    RETURN (RECORD$POINTER := REC FCB(32) - 1;  /* RESET RECORD NO */
         END;
    NEXTDISKCHAR = CHAR;
    CALL SET$WRITE$MARK;
END WRITE$A$BYTE;


GET$FILE$NUMBER: PROCEDURE BYTE;
    IF BRAZ > NUMFILES THEN
         CALL ERROR('MF');
    RETURN BRAZ;
END GET$FILE$NUMBER;


SET$FILE$ADDR: PROCEDURE;
    IF (FILEADDR := FILES(GET$FILE$NUMBER)) 
                                = 0 THEN
         CALL ERROR('FU');
    EOFADDR = EOFBRANCH(BRAZ);
END SET$FILE$ADDR;


SET$FILE$POINTERS: PROCEDURE;
    BUFFER$END = (B CONTROL BLOCK
    IN THE FSA.  THE FCB IS FOLLOWED BY 3 FLAGS - BLOCKSIZE(ADDR)
    RECORD POINTER(ADDR), WRITE FLAG(BYTE).  THIS IS FOLLOWED BY THE
    128 BYTE BUFFER TO DO FILE I/O.*/

    DECLARE
            FILENAME ADDRESS,
            NEXTFILE BYTE,
            BUFF     ADDRESS,
            CHAR     BASED BUFF(128) BYTE,
            I        BYTE,
            J        BYTE;

    INC$J: PROCEDURE BYTE;
         RETURN (J := J + 1);
    END INC$J;

    NEXTFILE = 0;
    DO WHILE FILES(NEXTFILE := NEXTFILE + 1) <> 0;
         END;
    FILEADDR,FILES(NEXTFILE) = GETSPACE(166);
    BUFFER = FILEADDR + 38;
    CALL SETDMA;
    CALL FILL((FILENAME:=FILEADDR+1),' ',11);
    BUFF=ARA;
    IF CHAR(2) = ':' THEN
         DO;
              FCB(0) = CHAR(1) AND 0FH;
              I = CHAR(0) - 2;
              BUFF = BUFF + 2;
         END;
    ELSE
         I = CHAR(0);
    IF I > 12 THEN
         I = 12;
    BUFF=BUFF+1;
    J = 255;
    DO WHILE(CHAR(INC$J) <> '.') AND (J <  TRUE;
    CALL POP$STACK;
END SETUP$DISK$IO;


RANDOM$SETUP: PROCEDURE;
    DECLARE
            TEMP1     ADDRESS,
            TEMP2   ADDRESS,
            TEMP3     ADDRESS,
            BYTECOUNT ADDRESS,
            RECORD    ADDRESS,
            EXTENT    BYTE;

    IF NOT VAR$BLOCK$SIZE THEN
         CALL ERROR('RU');
    IF RA$ZERO$ADDRESS OR RA$NEGATIVE THEN
         CALL ERROR('IR');
    ARA = ARA - 1;
    CALL SET$RANDOM$MODE;
    CALL SET$BUFFER$INACTIVE;
    CALL WRITE$DISK$ICB(12) = EXTENT;
              CALL SETUP$FILE$EXTENT;
         END;
    FCB(32) = LOW(RECORD) AND 7FH;
    CALL POP$STACK;
END RANDOM$SETUP;


GET$DISK$CHAR: PROCEDURE BYTE;
     IF AT$END$DISK$BUFFER THEN
         DO;
              CALL WRITE$DISK$IF$REQ;
              CALL FILL$FILE$BUFFER;
         END;
    IF NOT ACTIVE$BUFFER THEN
         CALL FILL$FILE$BUFFER;
    IF NEXTDISKCHAR = EOFFILLER THEN
         CALL DISK$EOF;
    RETURN NEXTDISKCHAR;
END GET$DISK$CHAR;


WRITE$TO$FILSEPARATE FIELDS WITH COMMAS */
         CALL WRITE$A$BYTE(',');
    ELSE
         FIRSTFIELD = FALSE;
    POINT = ARA; /* ARA POINTS TO CHAR STRING */
    COUNT = CHAR;
    IF TYPE = NUMERIC THEN /* ELIM TRAILING BLANK */
         COUNT = COUNT - 1;
    ELSE
         CALL WRITE$A$BYTE(QUOTE); /* STRINGS PUT IN QUOTES */
    CALL INC$POINT; /* POINT TO FIRST CHAR */
    DO I = 1 TO COUNT;
         IF CHAR = QUOTE THEN
              CALL ERROR('QE');
         CALL WRITE$A$BYTE(CHAR);
         CI:=I+1) <= NUMFILES;
         IF(FILEADDR := FILES(I)) <> 0 THEN
              CALL DISKCLOSE;
         END;
END CLOSEFILES;

    /*
         ********************************************************
         *                                                      *
         *                 ROUTINE TO EXIT INTERP               *
         *                                                      *
         ********************************************************
    */
EXIT$INTERP: PROCEDURE;
    I);
         END;
    CALL MOVE(BUFF,FILENAME,J);
    IF I > INC$J THEN
         CALL MOVE (.CHAR(J),FILENAME + 8, I - J);
    CALL SETUP$FILE$EXTENT;
    CALL INITIALIZE$DISK$BUFFER;
    FCBADD(18)=FILEADDR+256;
    CALL POP$STACK;
    FCBADD(17) = ARA;
    CALL POP$STACK;
END DISK$OPEN;


SET$EOF$STACK: PROCEDURE;
     EOFRA = RA;
     EOFRB = RB;
END SET$EOF$STACK;

SETUP$DISK$IO: PROCEDURE;

    CALL SET$FILE$ADDR;
    CALL SET$FILE$POINTERS;
    BYTES$WRITTEN=0;
    FIRSTFIELD =F$REQ;
    TEMP2 = LOW(BLOCKSIZE)*HIGH(ARA) + LOW(ARA)*HIGH(BLOCKSIZE);
    TEMP1 = LOW(BLOCKSIZE) * BRAZ;
    BYTECOUNT = SHL(TEMP2,8) + TEMP1;
    TEMP3 = HIGH(BLOCKSIZE) * BRA(1);
    EXTENT = SHL(LOW(TEMP3) ,2) +
               SHR((HIGH(TEMP1) + TEMP2),6);
    RECORDPOINTER = (BYTECOUNT AND 7FH) + BUFFER - 1;
    CALL STORE$REC$PTR;
    RECORD = SHR(BYTECOUNT,7);
    IF EXTENT<>FCB(12) THEN
         DO;
              IF CLOSE = 255 THEN
                   CALL ERROR('CE');
              FE: PROCEDURE(TYPE);
    /* TYPE 0 MEANS WRITE A NUMBER, 1 MEANS A STRING*/
    DECLARE
            I       BYTE,
            POINT   ADDRESS,
            CHAR    BASED     POINT  BYTE,
            COUNT   BYTE,
            TYPE    BYTE,
            NUMERIC LIT       '0',
            STRING  LIT       '1';

    INC$POINT: PROCEDURE;
         POINT = POINT + 1;
    END INC$POINT;

    IF TYPE = NUMERIC THEN /* CONVERT TO ASCII STRING */
         CALL NUMERICOUT;
    IF NOT FIRSTFIELD THEN /* ALL INC$POINT;
         END;
    IF TYPE = STRING THEN
         DO;
              CALL WRITE$A$BYTE(QUOTE); /* ADD TRAILING QUOTE */
              CALL STRING$FREE; /* MAY BE A TEMP STRING */
         END;
    CALL POP$STACK;
END WRITE$TO$FILE;


DISK$CLOSE: PROCEDURE;
    CALL SET$FILE$POINTERS;
    CALL WRITE$DISK$IF$REQ;
    IF CLOSE = 255 THEN
         CALL ERROR('CE');
    CALL RELEASE(FILEADDR);
END DISK$CLOSE;

CLOSEFILES:  PROCEDURE;
    DECLARE I BYTE;
    I = 0;
    DO WHILE(CALL CLOSEFILES;
    CALL DUMP$PRINT$BUFF;
    CALL CRLF;
    CALL MON3;
END EXIT$INTERP;


    /*
         ********************************************************
         *                                                      *
         *               GENERALIZED INPUT ROUTINES             *
         *                                                      *
         ********************************************************
    */

CONSOLE$READ: PROCEDURE;
    CALL PRINTCHAR(WHAT);
    CALL PRINTCHAR(' ');
    CALL READ(.INPUTBUFFER);
    IF SPACE(1) = CONTZ THEN
         CALL EXIT$INTERP;
    CONBUFFPTR = .SPACE;
    SPACE(SPACE(0)+1)=EOLCHAR;
END CONSOLE$READ;

MORE$CON$INPUT: PROCEDURE BYTE;
    RETURN CONBUFFPTR < .SPACE(SPACE(0));
END MORE$CON$INPUT;


CONSOLE$INPUT$ERROR: PROCEDURE;
    CALL POPSTACK;
    RC = REREADADDR;  /* RESET PROGRAM COUNTER */
    CALL WARNING('II');
    GOTO ERROR$EXIT;  /* RETURN TO OUTER LEVEL */
END CONSOLE$INPUT$ERROR;


GET$DATA$CHAR: B');
              IF(SPACE(INPUTINDEX):= GETDISKCHAR) = LF THEN
                   DO;
                        IF VAR$BLOCKSIZE THEN
                             CALL ERROR('RE');
                   END;
              ELSE
                   RETURN NEXTDISKCHAR;
         END;
    IF INPUTTYPE = 1 THEN /* INPUT FROM CONSOLE */
         RETURN GETCONCHAR;
    IF INPUTTYPE = 2 THEN /* READ FROM DATA STATEMENT */
         RETURN GETDATACHAR;
END NEXT$INPUT$CHAR;


COUNT$INPUT: PROCEDURE;
     ';
    ELSE
         DO;
              DELIM = QUOTE;
              IF INPUTTYPE <> 0 THEN
                   INPUTPTR = INPUTPTR + 1;
              HOLD = NEXT$INPUT$CHAR;
         END;
    DO WHILE (HOLD <> DELIM) AND (HOLD <> EOLCHAR);
         INPUTINDEX = INPUTINDEX + 1;
         HOLD = NEXT$INPUT$CHAR;
         END;
    IF DELIM = QUOTE THEN
         DO WHILE((HOLD := NEXT$INPUT$CHAR) <> ',') AND (HOLD <> EOLCHAR);
              END;
    CALL PUSH$STACK;
END COUNT$INPUT;


GET$STRIN END;
      ELSE
           IF INPUTTYPE = 1 THEN
                CALL CONSOLE$INPUT$ERROR;
           ELSE
                BRAZ = 0;
END GET$NUMERIC$FIELD;



    /*
         ********************************************************
         *                                                      *
         *          INTERPRETER INITIALIZATION ROUTINES         *
         *                                                      *
         ********************************************************
E=ST;
        A(0)=TOP-4;
        A(1),A(2) = 0;
        BASE=A(0);
        A(0) = 0;
        A(1) = ST;
    END INITMEM;


    CALL GET$PARAMETERS;
    CALL INITMEM;
    CALL FILL(.FILES,0,TIMES4(NUMFILES));
    CALL CLEAR$PRINT$BUFF;
END INITIALIZE$EXECUTE;


 /* ***** EXECUTIVE ROUTINE STARTS HERE ***** */
    /*
         ********************************************************
         *                                                      *
         *********************************PROCEDURE BYTE;
    DECLARE CHAR BASED DATAAREAPTR BYTE;
    IF(DATAAREAPTR := DATAAREAPTR + 1) >= SB THEN
         CALL ERROR('OD');
    RETURN CHAR;
END GET$DATA$CHAR;


GET$CON$CHAR: PROCEDURE BYTE;
    DECLARE CHAR BASED CONBUFFPTR BYTE;
    CONBUFFPTR = CONBUFFPTR + 1;
    RETURN CHAR;
END GET$CON$CHAR;


NEXT$INPUT$CHAR: PROCEDURE BYTE;
    IF INPUTTYPE = 0 THEN /* READ FROM DISK */
         DO FOREVER;
              IF INPUTINDEX >CONBUFFSIZE THEN
                     CALL ERROR('D/*
        DETERMINE EXTENT OF NEXT FIELD AND COLLECT
        THE FIELD IN THE APPROPRIATE BUFFER
     */
    DECLARE
            HOLD  BYTE,
            DELIM BYTE;
    INPUT$INDEX = 0;
    DO WHILE (HOLD := NEXT$INPUT$CHAR) = ' ';
         END;
    IF INPUTTYPE = 0 THEN
         INPUTPTR = .SPACE;
    IF INPUTTYPE = 1 THEN
         INPUTPTR = CONBUFFPTR;                               

    IF INPUTTYPE =2 THEN
         INPUTPTR = DATAAREAPTR;
    IF HOLD <> QUOTE THEN
         DELIM = ',G$FIELD: PROCEDURE;
    DECLARE
            TEMP ADDRESS,
            LNG  BASED TEMP BYTE;
    CALL COUNT$INPUT;
    CALL MOVE(INPUTPTR,(TEMP:=GETSPACE(INPUTINDEX + 1))+1,INPUTINDEX);
    ARA = TEMP;
    CALL FLAG$STRING$ADDR(0);
    LNG = INPUTINDEX;  /* SET LENGTH IN NEW STRING */
END GET$STRING$FIELD;


GET$NUMERIC$FIELD: PROCEDURE;
    CALL COUNT$INPUT;
    IF INPUTINDEX > 0 THEN
    DO;
    CALL FP$INPUT(INPUTINDEX,INPUTPTR);
    CALL FP$OP$RETURN(9,RA);
    CALL CHECK$OVERFLOW;
   
    */


INITIALIZE$EXECUTE: PROCEDURE;
    GET$PARAMETERS: PROCEDURE;
        MCD,RC = PARAM1;
        DATAAREAPTR = (MDA := PARAM2) - 1;
        MPR=PARAM3;
        MBASE,ST = (SB := PARAM4) + NRSTACK;
        RA = (RB := SB) + 4;
    END GET$PARAMETERS;

    INITMEM: PROCEDURE;
        DECLARE BASE ADDRESS,
                A BASED BASE(2) ADDRESS,
                TOP BASED SYSBEGIN ADDRESS;
        CALL MOVE(BEGIN+OFFSET,BEGIN,MPR-BEGIN);
        CALL FILL(MPR,0,MBASE-MPR);
        BAS***********************
    */
EXECUTE:  PROCEDURE;
     DO FOREVER;
    IF ROL(C,1) THEN    /* MUST BE LIT OR LIT-LOD*/
    DO;
         CALL PUSH$STACK;
        BRA(0)=CV(1);       /* LOAD IN REVERSE ORDER */
        BRA(1)= C AND 3FH;
        IF ROL(C,2) THEN CALL LOAD$RA;   /*LIT-LOD*/
         CALL STEP$INS$CNT;
        END;
    ELSE
         DO CASE C;

 /*0  FAD: RB = RA+ RB  */
        CALL TWO$VALUE$OPS(FADD);

 /*1  FMI  RB = RB-RA; */
         DO;
              CALL FLIP;
        CALL TWO$VALUE$OPS(FSUB);
         END;

 /*2 FMU  RB= RA*RB    */
        CALL TWO$VALUE$OPS(FMUL);

 /*3  FDI  RB = RA/RB  */
         DO;
              IF RA$ZERO THEN
                   CALL WARNING('DZ');
              CALL FLIP;
              CALL TWO$VALUE$OPS(FDIV);
         END;

 /*4  EXP  RA=RB**RA    */
         DO;
              IF RB$ZERO THEN
                 DO;
                   IF RA$ZERO THEN
                       CALL MOVE4(.PLUSONE,RB);
                 END;
     CALL COMP$FIX(COMPARE$FP=1);

 /* 6 GTR, GREATER THEN */
         CALL COMP$FIX(COMPARE$FP=2);

 /* 7  EQU, EQUAL TO */
         CALL COMP$FIX(COMPARE$FP=3);

 /* 8  NEQ, NOT EQUAL TO */
         CALL COMP$FIX(NOT(COMPARE$FP=3));

 /* 9  GEQ, GREATER THEN OR EQUAL TO */
         CALL COMP$FIX(NOT(COMPARE$FP=1));

 /*10  LEQ, LESS THEN OR EQUAL TO */
         CALL COMP$FIX(NOT(COMPARE$FP=2));

 /*11  NOT*/
         CALL LOGICAL(0);

 /*12  AND*/
         CALL LOGICAL(1);

 /*13  BL POP$STACK;
              CALL POP$STACK;
         END;

 /* 21 SLT */
         CALL COMP$FIX(COMPARE$STRING = 1);

 /* 22 SGT */
         CALL COMP$FIX(COMPARE$STRING = 2);

 /* 23 SEQ */
         CALL COMP$FIX(COMPARE$STRING = 3);

 /* 24 SNE */
         CALL COMP$FIX(NOT(COMPARE$STRING = 3));

 /* 25 SGE */
         CALL COMP$FIX(NOT(COMPARE$STRING = 1));
 /* 26 SLE */
         CALL COMP$FIX(NOT(COMPARE$STRING = 2));

 /* 27  STS */
         DO;
              CALL STORE(1);
     DO;
              RC = ARA - 1;
              CALL POP$STACK;
         END;

 /*32 ROW, CALCULATES SPACE REQUIREMENTS FOR ARRAYS*/
         CALL CALC$ROW;

 /* 33, SUB */
 /*   SUB,CALCULATES SUBSCRIPT ADDRESSES */
         CALL CALC$SUB;


 /* RDV  READS A NUMBER FROM THE CONSOLE  */
         DO;
              IF NOT MORE$CON$INPUT THEN
                    CALL CONSOLE$INPUT$ERROR;
              CALL GET$NUMERIC$FIELD;
         END;

 /* 35, WRV : PRINTS THE NUMBER ON THE TOP OF THE STA SET$EOF$STACK;
         END;

 /* 38, RDB */
    /* RDB - READY NEXT SEQUENTIAL BLOCK */
          DO;
              CALL SETUP$DISK$IO;
              CALL SET$EOF$STACK;
          END;

 /* 39, ECR */
          IF MORE$CON$INPUT THEN
               DO;
               CALL PUSHSTACK;
               CALL CONSOLE$INPUT$ERROR;
            END;

 /* 40, OUT */
          DO;
               CALL OUTPUT(BRAZ,BRBZ);
               CALL POP$STACK;
               CALL POP$STACK;
          END;
              ELSE
                   IF RB$NEGATIVE THEN
                        CALL ERROR('NE');
                   ELSE
                        DO;
                             CALL FP$OP(FLOD,RB);
                             CALL FP$OP(LOG,0);
                             CALL FP$OP(FMUL,RA);
                             CALL FP$OP$RETURN(EXP,RB);
                        END;
                CALL POP$STACK;
                CALL CHECK$OVERFLOW;
         END;

 /* 5 LSS, LESS THEN */
    OR */
         CALL LOGICAL(2);

 /* 14 LOD*/
            CALL LOAD$RA;

 /* 15 STO */
         DO;
              CALL STORE(0);
              CALL MOVE$RA$RB;
              CALL POP$STACK;
         END;

 /* 16 XIT */
         RETURN;

 /* 17 DEL */
         CALL POP$STACK;

 /* 18 DUP */
         DO;
              CALL PUSH$STACK;
         CALL MOVE$RB$RA;
      END;

 /* 19 XCH */
         CALL FLIP;

 /* 20 STD */
         DO;
              CALL STORE(0);
              CAL         CALL POP$STACK;
              CALL POP$STACK;
      END;

 /* 28 ILS */
         DO;
              CALL PUSH$STACK;
              CALL STEP$INS$CNT;
              RC = (ARA := RC) + C;
              CALL FLAG$STRING$ADDR(FALSE);
         END;

 /* 29 CAT */
         CALL CONCATENATE;
 /* 30 PRO */
         DO;
              CALL STEP$INS$CNT;
              CALL PUSH$STACK;
              ARA = RC + 1 + 1;
              RC = TWOBYTEOPRAND;
         END;

 /* 31 RTN */
         CK */
         DO;
              CALL NUMERIC$OUT;
              CALL WRITE$TO$CONSOLE;
              CALL POP$STACK;
         END;

 /* 36 WST: PRINTS THE STRING WHOSE ADDRESS IS ON TOPOF THE STACK*/
          DO;
               CALL WRITE$TO$CONSOLE;
              CALL STRING$FREE;
              CALL POP$STACK;
         END;

 /* 37, RDF */
    /* RDF - PROCEDURE TO READY A RANDOM BLOCK */
         DO;
              CALL SETUP$DISK$IO;
              CALL RANDOM$SETUP;
              CALL

    /*41 RDN - READ A NUMBER FROM DISK*/
         DO;
              INPUTTYPE = 0;
              CALL GET$NUMERIC$FIELD;
         END;

    /*42 RDS - READ A STRING FROM DISK*/
         DO;
              INPUTTYPE = 0;
              CALL GET$STRING$FIELD;
         END;

    /*43 WRN WRITE A NUMBER TO DISK*/
         CALL WRITE$TO$FILE(0);

    /*44 WRS - WRITE A STRING TO DISK */
         CALL WRITE$TO$FILE(1);

 /* 45, OPN */
 /*OPN:   PROCEDURE TO CREATE FCBS FOR ALL INPUT FILES */
        CALL DISK$OPEN;

 /* 46 CON */
         DO;
              CALL PUSH$STACK;
              CALL STEP$INS$CNT;
              CALL MOVE4(TWOBYTEOPRAND,RA);
              CALL STEP$INS$CNT;
         END;

 /* 47, RST: PUTS POINTER TO THE BEGINNING OF THE DATA AREA*/
              DATAAREAPTR = MDA - 1;

 /*48  NEG, NEGATIVE */
         CALL ONE$VALUE$OPS(FCHS);

 /* 49 , RES : READ STRING */
         DO;
              IF NOT MORE$CON$INPUT THEN
                   CALL CONSOLE$INPUT$ERR
         CALL ABSOLUTE$BRANCH;

 /* 55 BRC */
         DO;
              IF RA$ZERO THEN
                   CALL ABSOLUTE$BRANCH;
              ELSE
                   RC = RC + 1 + 1;
              CALL POP$STACK;
         END;

 /* 56 BFC */
         CALL COND$BRANCH;

 /* 57 BFN */
         CALL UNCOND$BRANCH;

 /* 58 CBA */
         CALL CONV$TO$BINARY(RA);

 /* 59 RCN */
         DO;
              INPUTTYPE = 1;
               REREADADDR = RC;
              CALL CONSOLE$READ;

              CALL STORE$REC$PTR;
         END;

    /*63 EDW - END OF RECORD FOR WRITE*/
         DO;
              IF VAR$BLOCK$SIZE THEN
                    DO WHILE BYTES$WRITTEN < (BLOCKSIZE - 2);
                         CALL WRITE$A$BYTE(' ');
                         END;
              CALL WRITE$A$BYTE(CR);
              CALL WRITE$A$BYTE(LF);
              CALL STORE$REC$PTR;
         END;
    /*64 CLS - CLOSE A FILE*/
         DO;
              CALL SET$FILE$ADDR;
              
              CALL TWO$VALUE$OPS(FDIV);
         END;

 /* 68 SGN */
         DO;
              DECLARE FLAG BYTE;
              FLAG = NOT RA$NEGATIVE;
              CALL COMP$FIX(NOT RA$ZERO);
              IF FLAG THEN
                   CALL ONE$VALUE$OPS(FCHS);
         END;

 /* 69 SINE */
         CALL ONE$VALUE$OPS(SIN);

 /* 70 COSINE */
         CALL ONE$VALUE$OPS(COS);

 /* 71 ARCTANGENT */
         CALL ONE$VALUE$OPS(ATAN);

 /* 72 TANGENT */
         DO;
              CA = ARA - PRINTBUFFLENGTH;
                   END;
              IF ((ARA := ARA - 1 + PRINTBUFFERLOC) <= PRINTBUFFER)
                     AND (PRINTBUFFER <> PRINTBUFFERLOC) THEN
                   CALL DUMP$PRINT$BUFF;
              PRINTBUFFER = ARA;
         CALL POP$STACK;
         END;

 /* 75 EXPONENTATION */
         CALL ONE$VALUE$OPS(EXP);

 /* 76 FREE AREA IN FSA */
          DO;
               CALL PUSH$STACK;
               CALL FLOAT$ADDR(AVAILABLE(0));
          END;

 /* 7OR;
              CALL GET$STRING$FIELD;
         END;

 /* 50 NOP */
;

 /* 51 DAT */
  ;

 /* 52 DBF */
         CALL DUMPPRINTBUFF;

 /* 53 NSP */
         DO;
              DECLARE I BYTE;
              I=0;
              DO WHILE PRINTBUFFER > POSITION(I);
                   I = I + 1;
                   END;
              IF I = MAXPOSNUM THEN
                   CALL DUMP$PRINT$BUFF;
              ELSE
                   PRINTBUFFER = POSITION(I);
         END;

 /* 54 BRS */
         END;

 /* 60 DRS READ STRING FROM DATA AREA */
         DO;
              INPUTTYPE = 2;
              CALL GET$STRING$FIELD;
         END;

 /* 61 DRF READ F/P NUMBER FROM DATA AREA */
         DO;
              INPUTTYPE = 2;
              CALL GET$NUMERIC$FIELD;
         END;

    /*62 EDR - END OF RECORD FOR READ*/
    /*ADVANCES TO NEXT LINE FEED*/
         DO;
              IF VAR$BLOCK$SIZE THEN
                   DO WHILE GET$DISK$CHAR <> LF;
                        END;CALL DISK$CLOSE;
              FILES(BRAZ),EOFBRANCH(BRAZ) = 0;
              CALL POP$STACK;
         END;

 /* 65 ABSOLUTE */
         BRA(1) = BRA(1) AND 7FH;

 /* 66 INTEGER */
         DO;
              CALL CONV$TO$BINARY(RA);
              CALL CONV$TO$FP(RA);
         END;

 /* 67 RANDOM NUMBER GENERATOR */
         DO;
              CALL RANDOM;
              CALL PUSH$STACK;
              CALL MOVE4(.SCALE,RA);
              CALL PUSH$STACK;
              CALL FLOAT$ADDR(SEED);ALL PUSH$STACK;
              CALL MOVE$RB$RA;
              CALL ONE$VALUE$OPS(SIN);
              CALL POP$STACK;
              CALL ONE$VALUE$OPS(COS);
              CALL PUSH$STACK;
              IF RB$ZERO THEN
                   CALL ERROR('TZ');
              CALL TWO$VALUE$OPS(FDIV);
         END;

 /* 73 SQUAREROOT */
         CALL ONE$VALUE$OPS(SQRT);

 /* 74 TAB */
         DO;
              CALL ROUND$CONV$BIN;
              DO WHILE ARA > PRINTBUFFLENGTH;
                   AR7  IRN  */
         SEED = LOCALSEED;

 /* 78 LOG */
         CALL ONE$VALUE$OPS(LOG);

 /* 79 POSITION OF PRINT BUFFER PTR */
          DO;
               CALL PUSH$STACK;
               CALL FLOAT$ADDR(PRINTBUFFER - (PRINTBUFFERLOC - 1));
          END;

 /* 80 INP */
          DO;
               CALL ROUND$CONV$BIN;
               CALL FLOAT$ADDR(INPUT(BRAZ));
          END;

 /* 81 ASCII CONVERSION */
          DO;
               DECLARE
                       HOLD ADDRESS,
                       TEMP BYTE,
                       H    BASED    HOLD(1)   BYTE;
               IF (HOLD := ARA) = 0 OR H(0) = 0 THEN
                    CALL ERROR('AC');
               TEMP = H(1);
               CALL STRING$FREE;
               CALL FLOAT$ADDR(TEMP);
          END;

 /* 82 CHR CONVERTS TO ASCII */
         DO;
              DECLARE HOLD ADDRESS,
                      LOC BASED HOLD(1) BYTE;
              CALL CONV$TO$BIN$ADDR;
              HOLD = GETSPACE(2);
             NG$SEGMENT(1);

 /* 87 CONVERSION TO STRING */
          DO;
               CALL NUMERIC$OUT;
               CALL MOVE(.PRINTWORKAREA,ARA :=
                     GETSPACE(PRINTWORKAREA(0) + 1),PRINTWORKAREA(0) + 1);
               CALL FLAG$STRING$ADDR(TRUE);
          END;

 /* 88 VALUE  */
       DO;
       CALL FP$INPUT(GET$STRING$LEN(ARA),ARA+1);
       CALL STRING$FREE;
         CALL FP$OP$RETURN(9,RA);
       END;

 /* 89 COSH */
         CALL ONE$VALUE$OPS(COSH);

 /* 90 SINH */
XR  */
         CALL LOGICAL(3);


 /* 94 DEF  */
         DO;
              CALL STEP$INS$CNT;
              EOFBRANCH(GET$FILE$NUMBER) = TWOBYTEOPRAND;
              CALL STEP$INS$CNT;
              CALL POPSTACK;
         END;


 /* 95  BOL */
         DO;
              CURRENTLINE = ARA;
              CALL POP$STACK;
         END;

 /* 96  ADJ */
         ARA = ARA + MCD;

         END;  /* END CASE */
    CALL STEP$INS$CNT;
    END;   /* OF DO FOREVER  */



END EXECUTE;
  DECLARE
        LIT     LITERALLY      'LITERALLY',
        TRUE            LIT    '1',
        FALSE           LIT    '0',
        FOREVER         LIT    'WHILE TRUE',
        INDEXSIZE       LIT    'ADDRESS',
        STATESIZE       LIT    'ADDRESS',
        LF              LIT    '0AH',
        QUESTIONMARK    LIT    '3FH',
        POUNDSIGN       LIT    '23H',
        UPARROW         LIT    '5EH',
        TAB             LIT    '09H',
        COLIN           LIT    '3AH',
        ASTRICK   S MAX SIZE OF SOURCE FILE RECORDS
                              IF SOURCE FILE CONSISTS OF VAR LNG REC */
        INTRECSIZE      LIT   '128',  /* INTERMEDIATE FILE REC SIZE */
        CONBUFFSIZE     LIT    '82',  /* SIZE OF CONSOLE BUFFER */
        HASHTBLSIZE     LIT    '64',  /* SIZE OF HASHTABLE */
        HASHMASK        LIT    '63',  /* HASHTBLSIZE - 1 */
        STRINGDELIM     LIT   '22H',  /* CHAR USED TO DELIM STRINGS */
        CONTCHAR        LIT   '5CH',  /* CONTINUATION CHARACTER */
 LOC(0) = 1;
              LOC(1) = BRA(0);
              ARA = HOLD;
              CALL FLAGSTRINGADDR(TRUE);
         END;

 /* 83 LEFT END OF STRING */
         CALL STRING$SEGMENT(0);

 /* 84 LENGTH OF STRING */
       DO;
            DECLARE LENGTH BYTE;
            LENGTH = GET$STRING$LEN(ARA);
            CALL STRING$FREE;
            CALL FLOAT$ADDR(LENGTH);
       END;

 /* 85 MIDDLE OF STRING */
         CALL STRING$SEGMENT(2);

 /* 86 RIGHT END OF STRING */
         CALL STRI         CALL ONE$VALUE$OPS(SINH);

 /* 91 RON  */
         CALL ROUND$CONV$BIN;

 /* 92 CKO  */
         /* RA CONTAINS MAX NUMBER OF LABELS IN THE ON STATEMENT
            RB CONTAINS SELECTED LABEL.
            CHECK TO INSURE SELECTED LABEL EXISTS. IF NOT AN ERROR
            HAS OCCURED */
         DO;
              IF (BRBZ := BRBZ - 1) > BRAZ - 1 THEN
                   CALL ERROR('OI');
              CALL POP$STACK;
               BRAZ = SHL(BRAZ,1) + BRAZ + 1;
         END;
 /* 93 E  /*
         ********************************************************
         *                                                      *
         ********************************************************
    */

MAINLINE:
    CALL CRLF;
    CALL INITIALIZE$EXECUTE;
EOFEXIT:  /* ON END OF FILE OF CURRENT DISK FILE COME HERE */
ERROR$EXIT:  /* REGROUP ON CONSOLE INPUT ERROR */
    CALL EXECUTE;
    CALL EXIT$INTERP;
END;
      LIT    '2AH',
        PERCENT         LIT    '25H',
        IDENTSIZE       LIT    '32',  /* MAX IDENTIFIER SIZE + 1 */
        VARCSIZE        LIT   '100',  /* SIZE OF VARC STACK */
        PSTACKSIZE      LIT    '32',  /* SIZE OF PARSE STACKS */
        EOLCHAR         LIT   '0DH',  /* END OF SOURCE LINE INDICATOR */
        EOFFILLER       LIT   '1AH', /* PAD CHAR FOR LAST REC ON FILE */
        SOURCERECSIZE   LIT   '128',  /* SIZE OF SOURCE FILE REC */
                     /* NOTE: THIS I        MAXONCOUNT      LIT    '15';  /* MAX NUMBER ON STATEMENTS */
4)d 
  END

<(+*)-,=/;>:#^IFTOGOONOREQLTGTLEGENEFORLETREMDIMDEFNOTANDTANSINCOSSQRTABLOGLENFREATNABSEXPINTENDPOSRNDSGNINPASCVALXORSUBOUTTHENREADGOTOELSENEXTSTOPDATAFILECHR$MID$STEPSTR$COSHSINHPRINTINPUTGOSUBCLOSELEFT$RETURNRIGHT$REMARKRESTORERANDOMIZE 	



 HEFIJNTLGAKBOCDPQX! )&$"%(c#RU'WYZ-,+*S.V 03  %|    7EJMNN    AFGFADE    $BASNS $!c,r+s+q !f,r+s+q > !  "g,!*g,!-s+p+q+p+q:-=2-*-*-
w*-#"-*-#"-!-s+q+p+!{,6 !-q:S-<2S-H!S-6 *S-& ,	:-wT-R !-q*-DM|*-ME E!-6 :-!-s*-& T-	NE!-4Uq,!-6:	:,Hҫ*,DM;!,6 2,:-R:-<2-O !T-	:,w:,
*-#"-:q,!l,:-=O8!-6 :,	!,6 :,*,& *,~:,<2,!,'!,6 .'>2,
5> 	 :,HT9:,\k
h]9!-p+q:-<<2-:j,҆!q,6:|,ʥ:,
ʢU2,Î9:j,*r,#"r,*-|OE*-}OE?E:-=2- E^Eq!q,6 !t,6 :i,m 4E
h	:|, '	:,
$	2,U	h	:|,cd	3V
*,MV

P	U*,MV
;	,V
 V
*u,+"u,h	E
Ë	:,\y	UË		p
/Ҋ	CIlí:,/	:,<2,O !,	:,w:,!,?w:,	!,6͏	9͏	2,:,0O>	/:,a/>z!,/H:,.	!n,
:,_2,	:,AO>/	H	
H	H	D
	7
:, P
9!,6 !-q*u,#"u,:j,o
*-M>	!,|
> *,& O	n& "-!-6*,& Y	~!-


*,& c	:-O !	~2|,O>@:|,cH
:|,AO !m	~2},:|,2~,!|,65>:,-N*-
w_;ͭ*Z.6 *Z.q#p*^.& -)	*-s#r:f.X.0+s#r*-~ͭ*Z.>!g.qͭ*Z.:g.wͭ*Z.~ͭ*Z.^#V!h.qͭ*Z.:h.wͭ*Z.~J
2k.!l.6:k.!l.
o& -"i.*i.-M
*i.N#F`i"i.
*Z.*i.N#Fq#p!l.4¦
J
2p.!o.6:p.!o.H*-#"m.O !-		*m.N#Fq#pO !-		*-s#r!o.4!.0q:i,[*.0M!  "-"u,}202-0! "-!"-:i,!h"\.!^.611I$I  QV
!f"\.!^.600I$I QV
!/0q:j,!k,j̓*/0M |q:*/0M !		^#V!10
NSls
DMT!ͤT9*(0M/J
H@SIl T*-DM919]*A0"?0ͪ9ͪ909]09*'0MҤ*-DM͊*-DM
J
OxêUFl9*~,M:30Ox9͍9,A99	T9	T9
T9
T999T9T9 *V.	^#V"-:005ͤs
DMT ͤ:00Vs
DM?ͤͤ:00ҍͤ  ?ͤ ?8ͤ
ͤ ?9ͤ	ͤ7ͤ*V.N#F(*V.##*-s#r96ͤ*V.##N#F( *V.	*-s#r9!w,6>V.X+s#r"-*-#>w +!-49q:-=2-*-:-w*-#"-!-q:p,9*-& ͕D*-& ͕!-q:-	j:,<2, g  QÂ!,4*-M :-
!,6 !-p+q*-~$ʣ*-NE*-#"-É̓ͯ	 *,DM;  *,	6  *,	6 *,͡̓ͯ,͡ͤ:o,*,	,;,͕,͡(ͤ!,6 *,͡2-O>Dͤ:-:o,P,͕,͡ hͤ ͕
E
E!-p+q!-6 +6 >!-!-60*-& )	-[*-& )	-[+s#r!-6#4Ø:-/!-*-ME E!-4!x,6 #6 #6 !w,6 ,;ͮ!,6 #6 !  "-}2-,!,6!-6:9:,$¬!-6 :-<2-O !,	~2- ʬ:-A2-O>ک*-M !		^#V!k,6é!l,6 é!o,6é!n,6 é!m,6é!p,6ému}7!,6 !,6 !|,6 #6 :,"!,!|,62!,6 ":,
SUl͏	:,9:,"	͏	Ë			HҜ!|,61:,062,%7
	F	7
	:,E	:,+:,-Ho		/}FIl7
:, !,60!,6#60E
Ë	
k	%
Ұ	ã:,$!},62	!},61p
/	:,F:,NH:,H!|,66	!|,6+s#r#4
> !-6 *-& *-:-<2-O !,	
:,!-/HE:,!-_ ogN#Fog01PROD $ ERRORS DETECTED$:i,қ->@_ !l0"X.* ++"V."-*-#6 !_.q*-^ *-*_.& 	"Z.!`.6 *-##"Z.!a.6*-~!a.*a.& *Z.:`.?2`.!a.4:`.*-^ *- "-*-#"Z.*^.& -)	^#V!b.q:b.X.0!V.cP!j,6OTlͯ!d.p+qͭ*Z.*c.s#r*Z.+"Z.*Z.>w"-> -X*-~2e.*\.*e.&  	*-*e.& *\.:e.=2e. >Ù*Z.^#V"-}> *\.>2f.O+*X."-*\.#*X.###*\.99*'0M>h
.s
-[+LDl;*-DMQV
C!-6*i9i9͗99999999999999999999999999ҪY9:10 ½*;0DM?99*20Mͤ9
9]99ͤ99ͤ992:301$*20Mͤ2:20Oͤ1B99T:301O ͤTͤ9cͤ9m9|0ͤ99Ҏͤ9ҝͤ99үͤ9:00 *90DMTͤ999*50MB9*'0M9:w,IFl1*;0"-͑
T9 *V.	^#V"-s
DM? .ͤ  (9 ͎9 ͎9[ͤ^ͤͪs
DM(999͎6ͤͼ9:502~EIl7ͤͼ9ү*;0"-*20MV
͛
ͤͤ ͎96ͤͼ*'0M2c0*30MB*-DM:i,:c0DFl*-DMQ
99 T9 T99999*(0M:4012FIl*90DMT-ͤ99  ?99@9@91*;0"-9*(0M!i,ҁPDlV
:i,ҕ DMQs
DM? T*-DM9199:302FMl[ͤ@ͤ9:302FMl[ͤ@ͤ9:y,>ͤ!y,6 99'ͤ!z,6 9o9o999!y,6 99?ͤ!y,6 99999994ͤ9!y,6[ͤ&ͤ9!y,6[ͤͤ[ͤ%ͤ99:y,/ҧ5ͤ999 ͎99ͮs
DM?`ͤͤ99:10<OT9!{,6!{,6 99999j999j9:501:301HMFMla[ͤͤ[ͤ(ͤ9ͤ9ͤ9:i,ҿ!i,6 :- ʖUFl!-6 *ͤ*-###=DM(*u,DM( DM(:,
2,ÿͤͤH*r,DM|p̓qͯ9/ͤ9s#r!F0p+q*(0& .)	*E0s#r!G0q*'0& s/	:G0w!H0q*'0& /	:H0w!I0q*(0& /	:I0w!J0q*(0& s/	:J0w!K0q*(0& .	:K0w!L0q*'0& .	:L0w!N0p+q*'0& /)	*M0s#r!O0q*-#"-:i,/Ҿ*O0M!P0q*P0& S/	n& /!Q0q*Q0MͿ"\.*Q0& .	~2^.!R0q*R0Mw>> !S0q*S0M>> *-#"-!U0p+q*T0|Oͤ*T0}Oͤ!W0p+q !V0DDM(!Y0p+q !X0DDM(:m,~*-M ?_ͤ!+0"\.:-0?2^.!Z0q:i,ҭ:Z0-0DMQ!-04w2[0ͮs
DM(:401:301HFMl> >!40:30MMl> >Il DMQ V
s
"90DM :w,@!w,6  *V.	*-s#r!`0p+q20ͤ!a06*_0~!a0v*a0& *_0Nͤ!a04V:,҃ͭÉ ͤQ.ͤ10*'0MJ
HҾs
DM(!b06:,!b0*b0& ,	NI!b04$I*-#"-DM(:y,:301
+ͤ,ͤ/:301*:00J'#ͤ/$ͤ:10
\*;0"-*-DM:70=270Ofs
DM?:10
*;0"-͑
!50{PFlY:501!70ҕPFl:70Of:40=240OB:10
:70 NFlͤ*?0"-s
DM(:40 NFl*10Mͤ:402B1B	 
  
 #/7ceij     '                           cj     (      >  J J                  FIK    !         !      *                   !       & O@ 
 G    " H} ~ R& J  QTU E .     
        HJ              %'  <     $   %    =   >?     S  " H} ~ R& J  QTU      " H} ~ R& J  QTU -   | z  	 { 	 	              C0 D6  C                   "  $  
              ! " # $ %  -  /  0 2 < = > ? @  $ B C C C C C E F Y Z Z Z [ \ Y % ] ^ _ ` a a a b c d g l d d d o s v z ~ d   d d d  d  d d     $       $                            # & ) , / 3 5 7 9 ; = ? A C F I L O S V Y \ ^ a d f h k m p t v y { }           2/7! ;2  2                            	 
 
   $ $ % % ' ' ) ) + + + + + - - - 2 2 5 5 5 Mͤ9 IOUX[^adgjmpsvy|58Wfp"PVekqz/7?WZ`pBHQTZ`l %+36CIORX^ai{#&,dlt*'0& s/	~200*)0& 	~220*(0& 	~210*'0& /	~230*)0& 	~250*(0& 	~240*'0& .)	^#V"90*)0& )	^#V"=0*(0& )	^#V";0*(0& .	~270*)0& 	~280*'0& 	~260*'0& /)	^#V"?0*(0& )	^#V"A0!D0p+q*'0& .)	*C0*30MB:301>FMl> :502+FMl[ͤ:10<210OT*00M̀
 ͤ*00Mͤͤ:501iͤnͤ4ͤ!z,6;ͤ:00 *90DM?:z,Ҡ"1͹ø:y,ұ)*͹ø=<͹!]0s+q:302*\0Mͤͤ*]0Mͤͤ[ͤ:0<20O !0	N ?\ͤ9ͤ*0& 0	:00w:-=2-/!-6 UNli6ͤ *-	N#F( !-D*-q#p*-#>i *-"-R*)0M *-	-MHҐÖINl:-ҤLUl!-6 *'0Mh
/!j,!-6ͪ:{,ͤ6ͤs
DM(!^0q*^0MJ
 U:i,/*)0M DMQ*50M̀
 V
:10<OT_ og{ozgogN#Fogo& og{_z#W 1

124561
 124561245664412456411212456		11#$%&(*+,-.01341
4	4		!)!$+	!	!!	!	!	!!'!)!!		#$%&(*+,-.034#$%&(*+,-.0344
"	

	  1 

 
 " 4 4 12 	"   	      "    	 	 	 	 	 ! ! ! ! !' ! ! !  ! ! 	 	 	 4  "   4      	  

  	     7i    /  "$&(bdfgrt  .  ! ?  NM# #  ' '       ( )  +  , L1 1  2 2  3 3  4 4  5 5     7 9  :  ;  B 4D ,E +F -H (L L )M M 5N N  T T 8U U U  W W PX X *Y Y 6[ ] ] 9^ ^ 
_ A` Ba a  c    e :::f h    i j  m  n  o  p q s u  v v v v v v v v  w w  x "     G         b P Z   \  S V  J  K       R O Q I .                   1@ @ 0@ @ 0@ @ 0 r  t  <  ?  = / 
     l k  A    $#g            3d     8 >    5 7 7 B B C C D D E E F F H H H H H H H H H I J K L L M M M N N O P Q R S S T T U V V W X X Y Z Z [ ] ] ^ _ _ ` ` a b b c c c f f g g g h h i i j j l l m n n o p q q s t t v v x x y y z { | } ~   									
						
								#'(+7Uaceiju                                                                               BASIC-E COMPILER  VER 2.1$1a,)̓q͒+:j,!i,Ҁ+!t,6!*06!y "q.!'06!&06 !S/6 :t,}+>x!q.,T*ʹ+*'0& s.)	*q.s#r͜+"d0+ͩ+*d0+"f0*d0"d0f0d0,Q**d0l	:|,1**'0& S/	:&0w!j06 :,!j0)*j0& ,	N+!j04)*'0& .	:,w*'0& /	:},w*d0P!)	^#V"q.!*06*f0"d0D*f0d0,D*PNl *d0"d0Ұ)z+>!q.,+ͩ+:'0+!(0s:(0<2)0>q.,M:t,+:(02'0͜+"d0*'0& S/	~2&0*'0& s.)	^#V"f0*d0 	n& "h0} h0f0,H**d0#"d0ñ**d0$)	^#V"q.> ++!t,00E1D00D62D0909E52A6D2EE34E2346E171237087
:100E2D00CDC70B4F060021D62D0909E52AD42DE90
:100E3D00E1732372216F2E34C2020EC9212E30713F
:100E4D003A692C1FD25B0E2A2E304DCD 60:C921D5
:BB)5D00000022CB2D22752 7D321730 22D302102
:100E6D00010022CF2D21FFFF22CD2DCDF0043A69B7
:100E7D002C1FD2CB0ECDFC0321680B225C2E215EE4
:100E8D002E3631CDDD0C0E31CD490E0E24CD490E51
:100E9D00010000CD510C0E04CD560D21660B225CC8
:100EAD002E215E2E3630CDDD0C0E30CD490E0E24AA
:100EBD00CD490E010100CD510C0E04CD560DC921A9
:100ECD002F30713A6A6 z+>!q.,_+͜+"d0+*d09 	n& "h0} !h0:|,,HM+*d0#"d0+*d0")	^#V"q.z+ʹ+ͩ+*'0& s.)	q#p͜+"q.m)C)!l,6͒+!j,6C)v́\*q.%)	^#V*q.'	n& :'0<2'0 +OSl:*0+ͭ!*06 !k0q*&0& /	:k0w:&0<2&0O>d+OVl_ {ozgi`N#Fogo& og_ {_z#W92E4E234603606922692EC3C10D7B
:100DDD00CD140CDu=)B 92EE3         5
:100DED002370216C2E34C2A60DC9CD4A0D32702E42          \          INT    16F2EBEDA480ECDA0 00E0D00020C2AD42D23226D2ECDC70B4F060021A7
:12C216B2CA61FD2ED0E016AC0
:100EDD000BCD83032A2F304D0600CD7C04CD71043C
:100EED00CD3A182A2F304D060021071709095E2328
:100EFD0056EBE9C33918C339182A27304DCDF019EF
:100F0D001FD23E0FCD680D1FD22E0FCD730D11CBFD
:100F1D002DCD5B1FB5CA2B0F014C44CD6C06C33BC9
:100F2D000F2ACB2D444DCD510C0E08CD560DC3437C
:103D000F21A92D362ACD691AC33918CD691AC3C7
:100F4D003918CD971CC33918C33918C33918C3398B
:100F5D0018C33918C33918C33918C33918C3391808
:100F6D00C33918C33918C33918C33918C33918C34D
:100F7D003918C33918C33918C33918C3391