 DOWHILESLIB t                 NCOMPARELIB  
               SELECTS LIB i                SEQIO   LIB   R	

      SYMSTACKLIB D                 WHENS   LIB ;                 IGADD   MAC                  MON1    MAC S                 MON2    MAC V                 FPCONV  SRC   k !"#$   FPDATA  SRC   %&               FPINT   SRC   ;'()*+,-.         FPPKG   SRC   /0123456789:;<=> FPPKG   SRC  b?@ABCDEFGHIJK    TRAN    SRC   aLMNOPQRSTUVWX    UGFORM        !YZ[\]           ;	MACRO LIBRARY FOR "DOWHILE" CONSTRUCT
;
GENDTST	MACRO	TST,X,Y,NUM
;;	GENERATE A "DOWHILE" TEST
	TST	X,Y,,ENDD&NUM
	ENDM
;
GENDLAB	MACRO	LAB,NUM
;;	PRODUCE THE LABEL LAB & NUM
;;	FOR DOWHILE ENTRY OR EXIT
LAB&NUM:
	ENDM
;
GENDJMP	MACRO	NUM
;;	GENERATE JUMP TO DOWHILE TEST
	JMP	DTEST&NUM
	ENDM
;
DOWHILE	MACRO	XV,REL,YV
;;	INITIALIZE COUNTER
DOCNT	SET	0	;NUMBER OF DOWHILES
;;
DOWHILE	MACRO	X,R,Y
;;	GENERATE THE DOWHILE ENTRY
	GENDLAB	DTEST,%DOCNT
;;	GENERATE THE CONDITIONAL TEST
	GE;	MACRO LIBRARY FOR 8-BIT COMPARISON OPERATION
;
TEST?	MACRO	X,Y
;;	UTILTITY MACRO TO GENERATE CONDITION CODES
	IF	NOT NUL X	;;THEN LOAD X
	LDA	X	;;X ASSUMED TO BE IN MEMORY
	ENDIF
	IRPC	?Y,Y	;;Y MAY BE CONSTANT OPERAND
TDIG?	SET	'&?Y'-'0'	;;FIRST CHAR DIGIT?
	EXITM		;;STOP IRPC AFTER FIRST CHAR
	ENDM
	IF	TDIG? <= 9	;;Y NUMERIC?
	SUI	Y	;;YES, SO SUB IMMEDIATE
	ELSE
	LXI	H,Y	;;Y NOT NUMERIC
	SUB	M	;;SO SUB FROM MEMORY
	ENDM
;
LSS	MACRO	X,Y,TL,FL
;;	X LSS THAN Y TEST,
;;	IF TL IS PRESENT,  OR EQUAL TO Y TEST
	IF	NUL TL
	LSS	X,Y,FL
	ELSE
	TEST?	X,Y
	JNC	TL
	ENDM
;
GTR	MACRO	X,Y,TL,FL
;;	X GREATER THAN Y TEST
	IF	NUL TL
	LEQ	X,Y,FL
	ELSE
	LOCAL	GFL	;;FALSE LABEL
	TEST?	X,Y
	JC	GFL
	DCR	A
	JNC	TL
GFL:	ENDM
NDTST	R,X,Y,%DOCNT
	SYMPSH	DOCNT	;;NEXT ENDDO TO GENERATE (STACKED)
DOCNT	SET	DOCNT+1
	ENDM
	DOWHILE	XV,REL,YV
	ENDM
;
ENDDO	MACRO
;;	GENERATE THE JUMP TO THE TEST
	SYMPOP	DOLEV
	GENDJMP	%DOLEV
;;	GENERATE THE END OF A DOWHILE
	GENDLAB	ENDD,%DOLEV
	ENDM
ASSUME TRUE TEST
;;	IF TL IS ABSENT, THEN INVERT TEST
	IF	NUL TL
	GEQ	X,Y,FL
	ELSE
	TEST?	X,Y	;;SET CONDITION CODES
	JC	TL
	ENDM
;
LEQ	MACRO	X,Y,TL,FL
;;	X LESS THAN OR EQUAL TO Y TEST
	IF	NUL TL
	GTR	X,Y,FL
	ELSE
	LSS	X,Y,TL
	JZ	TL
	ENDM
;
EQL	MACRO	X,Y,TL,FL
;;	X EQUAL TO Y TEST
	IF	NUL TL
	NEQ	X,Y,FL
	ELSE
	TEST?	X,Y
	JZ	TL
	ENDM
;
NEQ	MACRO	X,Y,TL,FL
;;	X NOT EQUAL TO Y TEST
	IF	NUL TL
	EQL	X,Y,FL
	ELSE
	TEST?	X,Y
	JNZ	TL
	ENDM
;
GEQ	MACRO	X,Y,TL,FL
;;	X GREATER THAN;	MACRO LIBRARY FOR "SELECT" CONSTRUCT
;
;	LABEL GENERATORS
GENSLXI	MACRO	NUM
;;	LOAD HL WITH ADDRESS OF CASE LIST
	LXI	H,SELV&NUM
	ENDM
;
GENCASE	MACRO	NUM,ELT
;;	GENERATE JMP TO END OF CASES
	IF	ELT GT 0
	JMP	ENDS&NUM	;;PAST ADDR LIST
	ENDIF
;;	GENERATE LABEL FOR THIS CASE
CASE&NUM&@&ELT:
	ENDM
;
GENELT	MACRO	NUM,ELT
;;	GENERATE ONE ELEMENT OF CASE LIST
	DW	CASE&NUM&@&ELT
	ENDM
;
GENSLAB	MACRO	NUM,ELTS
;;	GENERATE CASE LIST
SELV&NUM:
ECNT	SET	0	;;COUNT ELEMENTS
	REPT	ELTS	;;GENER+1	;;UPDATE SELECT COUNT
;;	SELECT ON V OR ACCUMULATOR CONTENTS
	IF	NOT NUL V
	LDA	V	;;LOAD SELECT VARIABLE
	ENDIF
	GENSLXI	%CCNT	;;GENERATE THE LXI H,SELV#
	MOV	E,A	;;CREATE DOUBLE PRECISION
	MVI	D,0	;;V IN D,E PAIR
	DAD	D	;;SINGLE PREC INDEX
	DAD	D	;;DOUBLE PREC INDEX
	MOV	E,M	;;LOW ORDER BRANCH ADDR
	INX	H	;;TO HIGH ORDER BYTE
	MOV	D,M	;;HIGH ORDER BRANCH INDEX
	XCHG		;;READY BRANCH ADDRESS IN HL
	PCHL		;;GONE TO THE PROPER CASE
ECNT	SET	0	;;ELEMENT COUNTER RESET
	SELNEXT		;;SELECT CASE 0;	SEQUENTIAL FILE I/O LIBRARY
;
FILERR	SET	0000H	;REBOOT AFTER ERROR
@BDOS	EQU	0005H	;BDOS ENTRY POINT
@TFCB	EQU	005CH	;DEFAULT FILE CONTROL BLOCK
@TBUF	EQU	0080H	;DEFAULT BUFFER ADDRESS
;
;	BDOS FUNCTIONS
@MSG	EQU	9	;SEND MESSAGE
@OPN	EQU	15	;FILE OPEN
@CLS	EQU	16	;FILE CLOSE
@DIR	EQU	17	;DIRECTORY SEARCH
@DEL	EQU	19	;FILE DELETE
@FRD	EQU	20	;FILE READ OPERATION
@FWR	EQU	21	;FILE WRITE OPERATION
@MAK	EQU	22	;FILE MAKE
@REN	EQU	23	;FILE RENAME
@DMA	EQU	26	;SET DMA ADDRESS
;
@SECT	EQU	128		SET	C	;;MAX LENGTH
	IRPC	?FC,FC	;;FILL EACH CHARACTER
;;	MAY BE END OF COUNT OR NUL NAME
	IF	@CNT=0 OR NUL ?FC
	EXITM
	ENDIF
	DB	'&?FC'	;;FILL ONE MORE
@CNT	SET	@CNT-1	;;DECREMENT MAX LENGTH
	ENDM		;;OF IRPC ?FC
;;
;;	PAD REMAINDER
	REPT	@CNT	;;@CNT IS REMAINDER
	DB	' '	;;PAD ONE MORE BLANK
	ENDM		;;OF REPT
	ENDM
;
FILLDEF	MACRO	FCB,?FL,?LN
;;	FILL THE FILE NAME FROM THE DEFAULT FCB
;;	FOR LENGTH ?LN (9 OR 12)
	LOCAL	PSUB
	JMP	PSUB	;;JUMP PAST THE SUBROUTINE
@DEF:	;;THIS SUBROUTINE FIL
FILLFCB	MACRO	FID,DN,FN,FT,BS,BA
;;	FILL THE FILE CONTROL BLOCK WITH DISK NAME
;;	FID IS AN INTERNAL NAME FOR THE FILE,
;;	DN IS THE DRIVE NAME (A,B..), OR BLANK
;;	FN IS THE FILE NAME, OR BLANK
;;	FT IS THE FILE TYPE 
;;	BS IS THE BUFFER SIZE
;;	BA IS THE BUFFER ADDRESS
	LOCAL	PFCB
;;
;;	SET UP THE FILE CONTROL BLOCK FOR THE FILE
;;	LOOK FOR FILE NAME = 1 OR 2
@C	SET	1	;;ASSUME TRUE TO BEGIN WITH
	IRPC	?C,FN	;;LOOK THROUGH CHARACTERS OF NAME
	IF	NOT ('&?C' = '1' OR '&?C' = '2')
@C	SET	0	;;ATE DW'S
	GENELT	NUM,%ECNT
ECNT	SET	ECNT+1
	ENDM		;;END OF DW'S
;;	GENERATE END OF CASE LIST LABEL
ENDS&NUM:
	ENDM
;
SELNEXT	MACRO
;;	GENERATE THE NEXT CASE
	GENCASE	%CCNT,%ECNT
;;	INCREMENT THE CASE ELEMENT COUNT
ECNT	SET	ECNT+1
	ENDM
;
SELECT	MACRO	VAR
;;	GENERATE CASE SELECTION CODE
SCNT	SET	0	;;COUNT "SELECTS"
SELECT	MACRO	V	;;REDEFINITION OF SELECT
	SYMPSH	%CCNT	;;SAVE PREVIOUS SELECT NUMBER
	SYMPSH	%ECNT	;;AND ITS CASE COUNT
CCNT	SET	SCNT	;;CREATE NEXT SELECT NUMBER
SCNT	SET	SCNT
	ENDM
;;	INVOKE REDEFINED SELECT THE FIRST TIME
	SELECT	VAR
	ENDM
;
ENDSEL	MACRO
;;	END OF SELECT, GENERATE CASE LIST
	GENCASE	%CCNT,%ECNT	;;LAST CASE
	GENSLAB	%CCNT,%ECNT	;;CASE LIST
;;	GET BACK PREVIOUS SELECT PARAMETERS (IF ANY)
	SYMPOP	ECNT
	SYMPOP	CCNT
	ENDM
;SECTOR SIZE
EOF	EQU	1AH	;END OF FILE
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
TAB	EQU	09H	;HORIZONTAL TAB
;
@KEY	EQU	1	;KEYBOARD
@CON	EQU	2	;CONSOLE DISPLAY
@RDR	EQU	3	;READER
@PUN	EQU	4	;PUNCH
@LST	EQU	5	;LIST DEVICE
;
;	KEYWORDS FOR "FILE" MACRO
INFILE	EQU	1	;INPUT FILE
OUTFILE	EQU	2	;OUTPUTFILE
SETFILE	EQU	3	;SETUP NAME ONLY
;
;	THE FOLLOWING MACROS DEFINE SIMPLE SEQUENTIAL
;	FILE OPERATIONS:
;
FILLNAM	MACRO	FC,C
;;	FILL THE FILE NAME/TYPE GIVEN BY FC FOR C CHARACTERS
@CNTLS FROM THE TFCB (+16)
	MOV	A,M	;;GET NEXT CHARACTER TO A
	STAX	D	;;STORE TO FCB AREA
	INX	H
	INX	D
	DCR	C	;;COUNT LENGTH DOWN TO 0
	JNZ	@DEF
	RET
;;	END OF FILL SUBROUTINE
PSUB:
FILLDEF	MACRO	?FCB,?F,?L
	LXI	H,@TFCB+?F	;;EITHER @TFCB OR @TFCB+16
	LXI	D,?FCB
	MVI	C,?L		;;LENGTH = 9,12
	CALL	@DEF
	ENDM
	FILLDEF	FCB,?FL,?LN
	ENDM
;
FILLNXT	MACRO
;;	INITIALIZE BUFFER AND DEVICE NUMBERS
@NXTB	SET	0	;;NEXT BUFFER LOCATION
@NXTD	SET	@LST+1	;;NEXT DEVICE NUMBER
FILLNXT	MACRO
	ENDM
	ENDM
;CLEAR IF NOT 1 OR 2
	ENDM
;;	@C IS TRUE IF FN = 1 OR 2 AT THIS POINT
	IF	@C	;;THEN FN = 1 OR 2
;;	FILL FROM DEFAULT AREA
	IF	NUL FT	;;TYPE SPECIFIED?
@C	SET	12	;;BOTH NAME AND TYPE
	ELSE
@C	SET	9	;;NAME ONLY
	ENDIF
	FILLDEF	FCB&FID,(FN-1)*16,@C	;;TO SELECT THE FCB
	JMP	PFCB	;;PAST FCB DEFINITION
	DS	@C	;;SPACE FOR DRIVE/FILENAME/TYPE
	FILLNAM	FT,12-@C	;;SERIES OF DB'S
	ELSE
	JMP	PFCB	;;PAST INITIALIZED FCB
	IF	NUL DN
	DB	0	;;USE DEFAULT DRIVE IF NAME IS ZERO
	ELSE
	DB	'&DN'-'A'+1	;;USE SPECIFIED DRIVE
	ENDIF
	FILLNAM	FN,8	;;FILL FILE NAME
;;	NOW GENERATE THE FILE TYPE WITH PADDED BLANKS
	FILLNAM	FT,3	;;AND THREE CHARACTER TYPE
	ENDIF
FCB&FID	EQU	$-12	;;BEGINNING OF THE FCB
	DB	0	;;EXTENT FIELD 00 FOR SETFILE
;;	NOW DEFINE THE 3 BYTE FIELD, AND DISK MAP
	DS	20	;;X,X,RC,DM0...DM15,CR FIELDS
;;
	IF	FID&TYP<=2	;;IN/OUTFILE
;;	GENERATE CONSTANTS FOR INFILE/OUTFILE
	FILLNXT		;;@NXTB=0 ON FIRST CALL
	IF	BS+0<@SECT
;;	BS NOT SUPPLIED, OR TOO SMALL
@BS	SET	@SECT	;;DEFAULT TO ONE SECTF FID&TYP<=2 TEST
PFCB:	ENDM
;
FILE	MACRO	MD,FID,DN,FN,FT,BS,BA
;;	CREATE FILE USING MODE MD:
;;		INFILE = 1	INPUT FILE
;;		OUTFILE = 2	OUTPUT FILE
;;		SETFILE = 3	SETUP FCB
;;	(SEE FILLFCB FOR REMAINING PARAMETERS)
	LOCAL	PSUB,MSG,PMSG
	LOCAL	PND,EOD,EOB,PNC
;;	CONSTRUCT THE FILE CONTROL BLOCK
;;
FID&TYP	EQU	MD	;;SET MODE FOR LATER REF'S
	FILLFCB	FID,DN,FN,FT,BS,BA
	IF	MD=3	;;SETUP FCB ONLY, SO EXIT
	EXITM
	ENDIF
;;	FILE CONTROL BLOCK AND RELATED PARAMETERS
;;	ARE CREATED INLINE, NOW CRE DE
	LHLD	FID&LEN	;;DO NOT EXCEED LENGTH
;;	DE IS NEXT TO FILL/EMPTY, HL IS MAX LEN
	MOV	A,E	;;COMPUTE NEXT-LEN
	SUB	L	;;TO GET CARRY IF MORE
	MOV	A,D
	SBB	H	;;TO FILL
	JNC	EOB
;;	CARRY GEN'ED, HENCE MORE TO FILL/EMPTY
	LHLD	FID&ADR	;;BASE OF BUFFERS
	DAD	D	;;HL IS NEXT BUFFER ADDR
	XCHG
	MVI	C,@DMA	;;SET DMA ADDRESS
	CALL	@BDOS	;;DMA ADDRESS IS SET
	LXI	D,FCB&FID	;;FCB ADDRESS TO DE
	IF	MD=1	;;READ BUFFER FUNCTION
	MVI	C,@FRD	;;FILE READ FUNCTION
	ELSE
	MVI	C,@FWR	;;FILE WRITE FUNCTION
	BDOS	;;ERROR TO CONSOLE
	POP	PSW	;;REMOVE STACKED CHARACTER
	JMP	FILERR	;;USUALLY REBOOTS
EMSG:	DB	CR,LF
	DB	'DISK FULL: &FID'
	DB	'$'
	ENDIF
;;
EOB:
;;	END OF BUFFER, RESET DMA AND POINTER
	LXI	D,@TBUF
	MVI	C,@DMA
	CALL	@BDOS
	LXI	H,0
	SHLD	FID&PTR	;;NEXT TO GET
;;
PNC:
;;	PROCESS THE NEXT CHARACTER
	XCHG		;;INDEX TO GET/PUT IN DE
	LHLD	FID&ADR	;;BASE OF BUFFER
	DAD	D	;;ADDRESS OF CHAR IN HL
	XCHG		;;ADDRESS OF CHAR IN DE
	IF	MD=1	;;INPUT PROCESSING DIFFERS
	LHLD	FID&LEN	;;FOR EOF CHLEN		;;SET BUFF LEN
	IF	MD=1	;;INPUT FILE
	SHLD	FID&PTR	;;CAUSE IMMEDIATE READ
	MVI	C,@OPN	;;OPEN FILE FUNCTION
	ELSE		;;OUTPUT FILE
	LXI	H,0	;;SET NEXT TO FILL
	SHLD	FID&PTR	;;POINTER INITIALIZED
	MVI	C,@DEL
	LXI	D,FCB&FID	;;DELETE FILE
	CALL	@BDOS	;;TO CLEAR EXISTING FILE
	MVI	C,@MAK	;;CREATE A NEW FILE
	ENDIF
;;	NOW OPEN (IF INPUT), OR MAKE (IF OUTPUT)
	LXI	D,FCB&FID
	CALL	@BDOS	;;OPEN/MAKE OK?
	INR	A	;;255 BECOMES 00
	JNZ	PMSG
	MVI	C,@MSG	;;PRINT MESSAGE FUNCTION
	LXI	D,MSG	;;ERROR MESOR
	ELSE
;;	COMPUTE EVEN BUFFER ADDRESS
@BS	SET	(BS/@SECT)*@SECT
	ENDIF
;;
;;	NOW DEFINE BUFFER BASE ADDRESS
	IF	NUL BA
;;	USE NEXT ADDRESS AFTER @NXTB
FID&BUF	SET	BUFFERS+@NXTB
;;	COUNT PAST THIS BUFFER
@NXTB	SET	@NXTB+@BS
	ELSE
FID&BUF	SET	BA
	ENDIF
;;	FID&BUF IS BUFFER ADDRESS
FID&ADR:
	DW	FID&BUF
;;
FID&SIZ	EQU	@BS	;;LITERAL SIZE
FID&LEN:
	DW	@BS	;;BUFFER SIZE
FID&PTR:
	DS	2	;;SET IN INFILE/OUTFILE
;;	SET DEVICE NUMBER
@&FID	SET	@NXTD	;;NEXT DEVICE
@NXTD	SET	@NXTD+1
	ENDIF	;;OATE IO FUNCTION
	JMP	PSUB	;;PAST INLINE SUBROUTINE
	IF	MD=1	;;INPUT FILE
GET&FID:
	ELSE
PUT&FID:
	PUSH	PSW	;;SAVE OUTPUT CHARACTER
	ENDIF
	LHLD	FID&LEN	;;LOAD CURRENT BUFFER LENGTH
	XCHG		;;DE IS LENGTH
	LHLD	FID&PTR	;;LOAD NEXT TO GET/PUT TO HL
	MOV	A,L	;;COMPUTE CUR-LEN
	SUB	E
	MOV	A,H
	SBB	D	;;CARRY IF NEXT<LENGTH
	JC	PNC	;;CARRY IF LEN GTR CURRENT
;;	END OF BUFFER, FILL/EMPTY BUFFERS
	LXI	H,0
	SHLD	FID&PTR	;;CLEAR NEXT TO GET/PUT
PND:
;;	PROCESS NEXT DISK SECTOR:
	XCHG		;;FID&PTR TOENDIF
	CALL	@BDOS	;;RD/WR TO/FROM DMA ADDRESS
	ORA	A	;;CHECK RETURN CODE
	JNZ	EOD	;;END OF FILE/DISK?
;;	NOT END OF FILE/DISK, INCREMENT LENGTH
	LXI	D,@SECT	;;SECTOR SIZE
	LHLD	FID&PTR	;;NEXT TO FILL
	DAD	D
	SHLD	FID&PTR	;;BACK TO MEMORY
	JMP	PND	;;PROCESS ANOTHER SECTOR
;;
EOD:
;;	END OF FILE/DISK ENCOUNTERED
	IF	MD=1	;;INPUT FILE
	LHLD	FID&PTR	;;LENGTH OF BUFFER
	SHLD	FID&LEN	;;RESET LENGTH
	ELSE
;;	FATAL ERROR, END OF DISK
	LOCAL	EMSG
	MVI	C,@MSG	;;WRITE THE ERROR
	LXI	D,EMSG
	CALL	@ECK
	MOV	A,L	;;0000?
	ORA	H
	MVI	A,EOF	;;END OF FILE?
	RZ		;;ZERO FLAG IF SO
	LDAX	D	;;NEXT CHAR IN ACCUM
	ELSE
;;	STORE NEXT CHARACTER FROM ACCUMULATOR
	POP	PSW	;;RECALL SAVED CHAR
	STAX	D	;;CHARACTER IN BUFFER
	ENDIF
	LHLD	FID&PTR	;;INDEX TO GET/PUT
	INX	H
	SHLD	FID&PTR	;;POINTER UPDATED
;;	RETURN WITH NON ZERO FLAG IF GET
	RET
;;
PSUB:	;;PAST INLINE SUBROUTINE
	XRA	A		;;ZERO TO ACC
	STA	FCB&FID+12	;;CLEAR EXTENT
	STA	FCB&FID+32	;;CLEAR CUR REC
	LXI	H,FID&SIZ	;;BUFFER SIZE
	SHLD	FID&SAGE
	CALL	@BDOS	;;PRINTED AT CONSOLE
	JMP	FILERR	;;TO RESTART
MSG:	DB	CR,LF
	IF	MD=1	;;INPUT MESSAGE
	DB	'NO &FID FILE'
	ELSE
	DB	'NO DIR SPACE: &FID'
	ENDIF
	DB	'$'
PMSG:
	ENDM
;
PUT	MACRO	DEV
;;	WRITE CHARACTER FROM ACCUM TO DEVICE
	IF	@&DEV <= @LST
;;	SIMPLE OUTPUT
	PUSH	PSW	;;SAVE CHARACTER
	MVI	C,@&DEV	;;WRITE CHAR FUNCTION
	MOV	E,A	;;READY FOR OUTPUT
	CALL	@BDOS	;;WRITE CHARACTER
	POP	PSW	;;RESTORE FOR TESTING
	ELSE
	CALL	PUT&DEV
	ENDM
;
FINIS	MACRO	FID
;;	CLOSE THE FILE(S) GIVEN BY FID
	IRP	?F,<FID>
;;	SKIP ALL BUT OUTPUT FILES
	IF	?F&TYP=2
	LOCAL	EOB?,PEOF,MSG,PMSG
;;	WRITE ALL PARTIALLY FILLED BUFFERS
EOB?:	;;ARE WE AT THE END OF A BUFFER?
	LHLD	?F&PTR	;;NEXT TO FILL
	MOV	A,L	;;ON BUFFER BOUNDARY?
	ANI	(@SECT-1) AND 0FFH
	JNZ	PEOF	;;PUT EOF IF NOT 00
	IF	@SECT>255
;;	CHECK HIGH ORDER BYTE ALSO
	MOV	A,H
	ANI	(@SECT-1) SHR 8
	JNZ	PEOF	;;PUT EOF IF NOT 00
	ENDIF
;;	ARRIVE HERE IF END OF BUFFER, SET LENGTH
;;	AND WRITE ONE MORE BYTE TO CLEAR BUFFS
	SHLD	?F&L	FID
;;	DELETE THE FILE(S) GIVEN BY FID
	IRP	?F,<FID>
	MVI	C,@DEL
	LXI	D,FCB&?F
	CALL	@BDOS
	ENDM	;;OF THE IRP
	ENDM
;
DIRECT	MACRO	FID
;;	PERFORM DIRECTORY SEARCH FOR FILE
;;	SETS ZERO FLAG IF NOT PRESENT
	LXI	D,FCB&FID
	MVI	C,@DIR
	CALL	@BDOS
	INR	A	;00 IF NOT PRESENT
	ENDM
;
RENAME	MACRO	NEW,OLD
;;	RENAME FILE GIVEN BY "OLD" TO "NEW"
	LOCAL	PSUB,REN0
;;	INCLUDE THE RENAME SUBROUTINE ONCE
	JMP	PSUB
@RENS:	;;RENAME SUBROUTINE, HL IS ADDRESS OF
	;;OLD FCB, DE IS ADDRESS OF NEW FCB
	M
	RENAME	NEW,OLD
	ENDM
;
GET	MACRO	DEV
;;	READ CHARACTER FROM DEVICE
	IF	@&DEV <= @LST
;;	SIMPLE INPUT
	MVI	C,@&DEV
	CALL	@BDOS
	ELSE
	CALL	GET&DEV
	ENDM
;
;	MACRO LIBRARY FOR SYMBOL STACK
;
;	SYMBOL GENERATORS
GENSET	MACRO	SYM,NUM,VAL
;;	GENERATE SYMBOL, SET IT TO VAL
SYM&NUM	SET	VAL
	ENDM
;
GENVAL	MACRO	SYM,NAM,NUM
;;	SET SYMBOL TO GENERATED SYMBOL
SYM	SET	NAM&NUM
	ENDM
;
;	PUSH AND POP MACROS FOR SYMBOLIC VALUES
SYMPSH	MACRO	VAL
SSTKP	SET	0	;; INITIALIZE 'STACK POINTER'
SYMPSH	MACRO	VA	;; REDEFINE
SSTKP	SET	SSTKP+1	;; BUMP POINTER
	GENSET	SSTK,%SSTKP,%VA	;; CREATE STACK ENTRY
	ENDM
	SYMPSH	VAL
	ENDM
;
SYMPOP	MACRO	SYM
	GENVAL	SYM,SST;	MACRO LIBRARY FOR "WHEN" CONSTRUCT
;
;	"WHEN" COUNTERS
;	LABEL GENERATORS
GENWTST	MACRO	TST,X,Y,NUM
;;	GENERATE A "WHEN" TEST (NEGATED FORM),
;;	INVOKE MACRO "TST" WITH PARAMETERS
;;	X,Y WITH JUMP TO ENDW & NUM
	TST	X,Y,,ENDW&NUM
	ENDM
;
GENLAB	MACRO	LAB,NUM
;;	PRODUCE THE LABEL "LAB" & "NUM"
LAB&NUM:
	ENDM
;
;	"WHEN" MACROS FOR START AND END
;
WHEN	MACRO	XV,REL,YV
;;	INITIALIZE COUNTERS FIRST TIME
WCNT	SET	0	;;NUMBER OF WHENS
WHEN	MACRO	X,R,Y
	GENWTST	R,X,Y,%WCNT
	SYMPSH	%WCNT	;;NEEN	;;SET TO SHORTER LENGTH
PEOF:	MVI	A,EOF	;;WRITE ANOTHER EOF
	PUSH	PSW	;;SAVE ZERO FLAG
	CALL	PUT&?F
	POP	PSW	;;RECALL ZERO FLAG
	JNZ	EOB?	;;NON ZERO IF MORE
;;	BUFFERS HAVE BEEN WRITTEN, CLOSE FILE
	MVI	C,@CLS
	LXI	D,FCB&?F	;;READY FOR CALL
	CALL	@BDOS
	INR	A	;;255 IF ERR BECOMES 00
	JNZ	PMSG
;;	FILE CANNOT BE CLOSED
	MVI	C,@MSG
	LXI	D,MSG
	CALL	@BDOS
	JMP	PMSG	;;ERROR MESSAGE PRINTED
MSG:	DB	CR,LF
	DB	'CANNOT CLOSE &?F'
	DB	'$'
PMSG:
	ENDIF
	ENDM	;;OF THE IRP
	ENDM
;
ERASE	MACROPUSH	H	;;SAVE FOR RENAME
	LXI	B,16	;;B=00,C=16
	DAD	B	;;HL = OLD FCB+16
REN0:	LDAX	D	;;NEW FCB NAME
	MOV	M,A	;;TO OLD FCB+16
	INX	D	;;NEXT NEW CHAR
	INX	H	;;NEXT FCB CHAR
	DCR	C	;;COUNT DOWN FROM 16
	JNZ	REN0
;;	OLD NAME IN FIRST HALF, NEW IN SECOND HALF
	POP	D	;;RECALL BASE OF OLD NAME
	MVI	C,@REN	;;RENAME FUNCTION
	CALL	@BDOS
	RET		;;RENAME COMPLETE
PSUB:
RENAME	MACRO	N,O	;;REDEFINE RENAME
	LXI	H,FCB&O	;;OLD FCB ADDRESS
	LXI	D,FCB&N	;;NEW FCB ADDRESS
	CALL	@RENS	;;RENAME SUBROUTINE
	ENDK,%SSTKP	;; GET VALUE FROM STACK
SSTKP	SET	SSTKP-1
	ENDM
XT ENDW TO GENERATE (STACKED)
WCNT	SET	WCNT+1	;;NUMBER OF "WHEN"S
	ENDM
	WHEN	XV,REL,YV
	ENDM
;
ENDW	MACRO
;;	GENERATE THE ENDING CODE FOR A "WHEN"
	SYMPOP	WLEV
	GENLAB	ENDW,%WLEV
	ENDM
	;IGADD(VAR) - RETURN ADDRESS OF ARGUMENT
	ENTRY	IGADD
;
IGADD:	RET		;IT'S ALREADY THERE
	END
	;MON1(FUN,ARG) - CALL CP/M WITH 1-BYTE RESULT
	ENTRY	MON1
;
MON1:	MOV	C,M	;GET FUNCTION CODE FROM FIRST ARG
	XCHG		;GET SECOND ARG (CPM ARGUMENT)
	MOV	E,M
	INX	H
	MOV	D,M	;TWO BYTES WORTH
	CALL	5	;CP/M WILL DO THE REST
	MOV	L,A	;ALLOW BOTH INTEGER AND LOGICAL RETURNS
	MVI	H,0
	RET
	END
	;MON2(FUN,ARG) - CALL CP/M WITH 2-BYTE RESULT
	ENTRY	MON2
;
MON2:	MOV	C,M	;GET FUNCTION CODE FROM FIRST ARG
	XCHG		;GET SECOND ARG (CPM ARGUMENT)
	MOV	E,M
	INX	H
	MOV	D,M	;TWO BYTES WORTH
	CALL	5	;CP/M WILL DO THE REST
	MOV	L,A	;PASS RESULT IN HL
	MOV	H,B
	RET		;BACK TO FORTRAN
	END
	NAME	FPCNV
	CSEG

	PUBLIC	FFLOAT,FFIX,FINP,FOUT
	EXTRN	FSTOR,FZERO,FABS,FTEST,FLOAD,FMUL
	EXTRN	FDIV,FADD,ADD10,LSH,RSH,FCOMP
	EXTRN	OVER,ACCE,ACCS,ACC1,ACC2,ACC3,SF
	EXTRN	FTEN,RND0
	EXTRN	ADRL,ADRH,TMP1,TMP2,TMP3,VALE,VAL1,VAL2,VAL3,TMP4
 ;     8080 BINARY FLOATING POINT SYSTEM
 ;     FORMAT CONVERSION PACKAGE
 ;     PROGRAMMER  CAL OHME
 ;     DATE  26 DECEMBER 1973


 ;     SUBROUTINE TO CONVERT FROM FIXED
 ;     POINT TO FLOATING POINT FORMAT.
 FFLOAT: MOV     L,E;       INPUT EXPONENST FRCTN
        MOV     A,B;       1ST INPUT FRACTION
        ANA     A       ;       SET SIGN BIT
        RAL     ;       INPUT SIGN TO CARRY
        JMP     ADD10; COMPLETE CONVERSION
 ;     SUBROUTINE TO CONVERT FROM FLOATING
 ;     POINT TO FIXED POINT FORMAT.
 FFIX:  LXI     H,ACCE;  TO ADDRESS SCRATCH BANK
        MOV     A,M;       ACCUMULATOR EXPONENT
        ANA     A       ;       SET CONTROL BITS
        JZ      FIX1;  IF ACCUMULATOR IS ZERO
        MOV     A,E;       INPUT EXPONENT
T
        MOV     E,D;       4TH INPUT FRACTION
        MOV     D,C;       3RD INPUT FRACTION
        MOV     C,B;       2ND INPUT FRACTION
        MOV     B,A;       1ST INPUT FRACTION
        MOV     A,L;       INPUT EXPONENT
        XRI     80H;  APPLY EXPONENT BIAS
        LXI     H,ACCE;  TO ADDR ACCUM EXPONENT
        MOV     M,A;       ACCUMULATOR EXPONENT
        INR     L;       TO ADDRESS ACCUM SIGN
        MVI     M,80H;  SET ACCUM SIGN POSITIVE
        INR     L;       TO ADDR ACCUM 1        ADI     7FH;  APPLY BIAS - 1
        SUB     M;       SHIFT COUNT - 1
        RC      ;       RETURN IF ACCUM TOO LARGE
        CPI     1FH;  COMPARE TO LARGE SHIFT
        JNC     FIX1;  IF ACCUMULATOR TOO SMALL
        ADI     1;     SHIFT COUNT
        MVI     L,LOW(ACC1);  TO ADDR ACCUM 1ST FRCTN
        MOV     B,M;       ACCUMULATOR 1ST FRACTION
        INR     L;       TO ADDR ACCUM 2ND FRCTN
        MOV     C,M;       ACCUMULATOR 2ND FRCTN
        INR     L;       TO ADDR ACCUM 3RD FRCTN
        MOV     D,M;       ACCUMULATOR 3RD FRCTN
        CALL    RSH;   POSITION THE FRACTION
        MVI     L,LOW(ACCS);  TO ADDR ACCUM SIGN
        MOV     A,M;       ACCUMULATOR SIGN
        ANA     A       ;       SET CONTROL BITS
        CP      FCOMP;  COMPLEMENT FRCTN IF NEG
        MVI     A,1;     NON-ZERO
        ORA     B;       SET CONTROL BITS FOR EXIT
        MOV     A,B;       1ST RESULT
        MOV     B,C;       2ND RESULT
        MOV     C,D;       3RD RESULT
        MO     MVI     M,80H;  SET VALUE SIGN POSITIVE
        LXI     H,ACCE;  TO ADDR ACCUM EXPONENT
        MOV     M,D;       SET ACCUM TO ZERO
        MOV     A,E;       FIRST CHARACTER
        CPI     0F0H;  COMPARE TO SPACE
        JZ      INP1;  IF SPACE CHARACTER
        CPI     0FBH;  COMPARE CHAR TO PLUS
        JZ      INP1;  IF PLUS SIGN
        CPI     0FDH;  COMPARE TO MINUS
        JNZ     INP2;  IF NOT MINUS SIGN
        LXI     H,TMP3;  TO ADDR VALUE SIGN
        MOV     M,D;       SET VARENT DIGIT
        MOV     M,A;       SAVE CURRENT DIGIT
        LXI     H,FTEN;  TO ADDR FLOATING TEN
        CALL    FMUL;   MULTIPLY BY TEN
        MVI     L,LOW(VALE);  TO ADDR VALUE
        CALL    FSTOR;   STORE OLD VALUE TIMES TEN
        INR     L;       TO ADDR CURRENT DIGIT
        MOV     A,M;       CURRENT DIGIT
        MVI     B,0;     CLEAR 2ND WORD OF DIGIT
        MOV     C,B;       CLEAR 3RD WORD OF DIGIT
        MOV     D,B;       CLEAR 4TH WORD OF DIGIT
        MVI     E,8;  INPONENT
        MOV     M,B;       UPDATE INPUT EXPONENT
        JMP     INP1;  TO GET NEXT CHARACTER
 INP3:  LXI     H,TMP2;  TO ADDR DEC PNT FLAG
        XRA     M;       ZERO IF FLAG SET
        MOV     M,A;       SET DEC PNT FLAG
        JNZ     INP1;  IF FLAG NOT ALREADY SET
        JMP     INP8;  IF 2ND DEC PNT
 ;     PROCESS DECIMAL EXPONENT.
 INP4:  CALL    CHAD;  CALL CHAR ADDR SBRTN
        MOV     A,M;       NEXT CHARACTER OF STRING
        MOV     B,A;       CURRENT CHARACTER
            B,A;       DEC EXP EQUAL DIGIT
        INR     L;       TO ADDRESS NEXT CHAR
        MOV     A,M;       NEXT CHARACTER OF STRING
        CPI     0AH;   SET CARRY IF CHAR IS DIGIT
        JNC     INP7;  IF CHAR IS NOT A DIGIT
 ;     FORM COMPLETE DECIMAL EXPONENT.
        MOV     C,A;       LS DIGIT OF DEC EXP
        MOV     A,B;       MS DIGIT OF DEC EXP
        ADD     A;       2 * MS DIGIT
        ADD     A;       4 * MS DIGIT
        ADD     B;       5 * MS DIGIT
        ADD     A;       V     D,E;       4TH RESULT
        RET     ;       RETURN TO CALLER
 FIX1:  XRA     A;       ZERO
        MOV     B,A;       ZERO
        MOV     C,A;       ZERO
        MOV     D,A;       ZERO
        RET     ;       RETURN TO CALLER
        DB      0;     CHECKSUM WORD
 ;     INP SUBROUTINE ENTRY POINT.
 ;     INITIALIZE TEMPORARY STORAGE.
 FINP:  MOV     E,M;       FIRST CHARACTER OF STRING
        CALL    SVAD;  SET CHAR ADDR, PNT FLG, EXP
        INR     L;       TO ADDRESS VALUE SIGN
   LUE SIGN NEGATIVE
 ;     ANALYZE NEXT CHARACTER IN STRING.
 INP1:  CALL    CHAD;  CALL CHAR ADDR SBRTN
        MOV     A,M;       NEXT CHARACTER
 INP2:  MVI     B,0;     DIGIT 2ND WD OR DEC EXP
        CPI     0FEH;  COMPARE TO DECIMAL POINT
        JZ      INP3;  IF DECIMAL POINT
        CPI     15H;  COMPARE TO EXPONENT SIGN
        JZ      INP4;  IF EXPONENT SIGN
        CPI     0AH;   SET CARRY IF CHAR IS DIGIT
        JNC     INP8;  IF CHAR IS NOT A DIGIT
        LXI     H,TMP4;  TO ADDR CURDICATE DIGIT IS IN REG A
        CALL    FFLOAT;   CONVERT DIGIT TO FLOATING PNT
        MVI     L,LOW(VALE);  TO ADDR VALUE
        CALL    FADD ;   ADD OLD VALUE TIMES TEN
        MVI     L,LOW(TMP2);  TO ADDR DEC PNT FLAG
        MOV     A,M;       DECIMAL POINT FLAG
        ANA     A       ;       SET CONTROL BITS
        JZ      INP1;  IF NO DEC PNT ENCOUNTERED
        DCR     L;       TO ADDR INPUT EXPONENT
        MOV     B,M;       INPUT EXPONENT
        DCR     B;       DECREMENT INPUT EXSUI     0FDH;  COMPARE TO MINUS CHAR
        MOV     E,A;       CHAR - MINUS SIGN
        JZ      INP5;  IF MINUS SIGN
        ADI     2;     COMPARE TO PLUS CHAR
        MOV     A,B;       CURRENT CHARACTER
        JNZ     INP6;  IF NOT PLUS SIGN
 INP5:  INR     L;       TO ADDRESS NEXT CHAR
        MOV     A,M;       NEXT CHARACTER OF STRING
 INP6:  MVI     B,0;     POSSIBLE DEC EXPONENT
        CPI     0AH;   SET CARRY IF CHAR IS DIGIT
        JNC     INP8;  IF CHAR IS NOT A DIGIT
        MOV 10 * MS DIGIT
        ADD     C;       10 * MS + LS DIGIT
        MOV     B,A;       DECIMAL EXPONENT
 INP7:  MOV     A,E;       SIGN OF DEC EXPONENT
        ANA     A       ;       SET CONTROL BITS
        JNZ     INP8;  IF SIGN PLUS
        SUB     B;       COMPLEMENT DEC EXP
        MOV     B,A;       DECIMAL EXPONENT
 INP8:  LXI     H,TMP3;  TO ADDRESS SCRATCH BANK
        MOV     C,M;       INPUT SIGN
        LXI     H,ACCS;  TO ADDRESS ACCUM SIGN
        MOV     M,C;       ACCUMULATOR SIGN
        MOV     A,B;       DECIMAL EXPONENT
 ;     CONVERT DECIMAL EXPONENT TO BINARY.
 INP9:  LXI     H,TMP1;  TO ADDRESS DEC EXPONENT
        ADD     M;       ADJUST DECIMAL EXPONENT
        JZ      FTEST;   IN DEC EXP IS ZERO
        MOV     M,A;       CURRENT DECIMAL EXPONENT
        LXI     H,FTEN;  TO ADDR FLOATING TEN
        JP      INP10; IF MULTIPLY REQUIRED
        CALL    FDIV;   DIVIDE BY TEN
        MVI     A,1;     TO INCREMENT DEC EXP
        JMP     INP9;  TO TEST FOR COMPLETION
SUBROUTINE
 ;     OUTPUT SIGN CHARACTER.
        CALL    CHAD;  CALL CHAR ADDR SBRTN
        MVI     M,0F0H;  STORE SPACE CHARACTER
        ANA     A       ;       SET CONTROL BITS
        JZ      OUT3;  IF ACCUMULATOR IS ZERO
        MOV     E,A;       ACCUMULATOR EXPONENT
        MOV     A,B;       ACCUM SIGN AND 1ST FRCTN
        ANA     A       ;       SET CONTROL BITS
        MOV     A,E;       ACCUMULATOR EXPONENT
        JP      OUT1;  IF ACCUM IS POSITIVE
        MVI     M,0FDH;  CHANGE SPONENT
        JMP     OUT2;  TO TEST FOR SCALING COMPLETE
 OUT4:  CALL    FMUL;   MULTIPLY BY TEN
        LXI     H,TMP2;  TO ADDR DECIMAL EXPONENT
        MOV     E,M;       DECIMAL EXPONENT
        DCR     E;       DECREMENT DECIMAL EXPONENT
        MOV     M,E;       DECIMAL EXPONENT
        JMP     OUT1;  TO TEST FOR SCALING COMPLETE
 ;     ROUND THE VALUE BY ADDING .00000005.
 OUT5:  CALL    FABS;   SET ACCUM POSITIVE
        LXI     H,RND0;  TO ADDRESS ROUNDER
        CALL    FADD;   ADD T A,7;     TOTAL NUMBER OF DIGITS
        SUB     E;       DIGITS AFTER DECIMAL PNT
        INR     L;       TO ADDR 2ND DIGIT CNT
        MOV     M,A;       DIGITS AFTER DECIMAL POINT
        DCR     E;       DECREMENT DIGIT COUNT
        MOV     A,E;       DIGITS BEFORE DEC PNT
 ;     OUTPUT SIGNIFICANT DIGITS.
 OUT7:  LXI     H,TMP1;  TO ADDR DIGIT COUNT
        ADD     M;       ADJUST DIGIT COUNT
        MOV     M,A;       NEW DIGIT COUNT
        JM      OUT8;  IF COUNT RUN OUT
        LXI      H,TMP3;  TO ADDR 2ND DIGIT CNT
        MOV     A,M;       DIGITS AFTER DECIMAL PNT
        MVI     M,0FFH;  SET 2ND COUNT NEG
        ANA     A       ;       SET CONTROL BITS
        JM      OUT9;  IF 2ND COUNT RAN OUT
        CALL    CHAD;  CALL CHAR ADDR SBRTN
        MVI     M,0FEH;  STORE DECIMAL POINT
        JMP     OUT7;  LOOP FOR NEXT DIGIT
 OUT9:  DCR     L;       TO ADDR DECIMAL EXP
        ANA     M       ;       DECIMAL EXPONENT
        JZ      OUT13; IF DECIMAL EXPONENT IS ZERO
 ; 
 INP10: CALL    FMUL;   MULTIPLY BY TEN
        RC      ;       RETURN IF OVERFLOW
        MVI     A,0FFH;  TO DECREMENT DEC EXP
        JMP     INP9;  TO TEST FOR COMPLETION
 ;     OUT SUBROUTINE ENTRY POINT.
 ;     SAVE CHARACTER ADDRESS AND ACCUMULATOR.
 FOUT:  DCR     L;       DECREMENT CHARACTER ADDRESS
        CALL    SVAD;  SET CHAR ADDR, DIG CNT, DEC EXP
        CALL    FTEST;   LOAD ACCUM TO REGISTERS
        LXI     H,VALE;  TO ADDR ACCUM SAVE AREA
        CALL    FSTOR;   CALL REG STR IGN TO MINUS
 ;     SCALE ACCUMULATOR TO .1 - 1. RANGE.
 OUT1:  CPI     7EH;  COMPARE TO SMALL EXPONENT
 OUT2:  LXI     H,FTEN;  TO ADDR FLOATING TEN
        JC      OUT4;  IF EXPONENT TOO SMALL
        CPI     81H;  COMPARE TO LARGE EXP
        JC      OUT5;  IF EXP SMALL ENOUGH
        CALL    FDIV;   DIVIDE BY TEN
 OUT3:  LXI     H,TMP2;  TO ADDRESS SCRATCH BANK
        MOV     E,M;       DECIMAL EXPONENT
        INR     E;       INCREMENT DECIMAL EXPONENT
        MOV     M,E;       DECIMAL EXHE ROUNDER
        CPI     81H;  CHECK FOR OVERFLOW
        JNC     OUT2;  IF EXP TOO LARGE
 ;     SET DIGIT COUNTS.
        LXI     H,TMP2;  TO ADDR DECIMAL EXPONENT
        MOV     A,M;       DECIMAL EXPONENT
        MOV     E,A;       DIGITS BEFORE DEC POINT
        CPI     8;  COMPARE TO LARGE EXP
        JC      OUT6;  IF EXPONENT IN RANGE
        MVI     E,1;     DIGITS BEFORE DEC POINT
 OUT6:  SUB     E;       ADJUST DEC EXPONENT
        MOV     M,A;       DECIMAL EXPONENT
        MVI     H,FTEN;  TO ADDR FLOATING TEN
        CALL    FMUL;   MULTIPLY BY TEN
        MVI     E,8;   TO PLACE DIGIT IN REG A
        CALL    FFIX;   CONVERT TO FIXED FORMAT
        CALL    CHAD;  CALL CHAR ADDR SBRTN
        MOV     M,A;       OUTPUT DECIMAL DIGIT
        XRA     A;       CLEAR CURRENT DIGIT
        MVI     E,8;  BINARY SCALING FACTOR
        CALL    FFLOAT;   RESTORE VALUE MINUS DIGIT
        MVI     A,0FFH;  TO ADJUST DIGIT CNT
        JMP     OUT7;  LOOP FOR NEXT DIGIT
 OUT8:  LXI       OUTPUT DECIMAL EXPONENT.
        MVI     B,0FBH;  PLUS CHARACTER
        JP      OUT10; IF EXPONENT IS POSITIVE
        MVI     B,0FDH;  CHANGE SIGN TO MINUS
        MOV     C,A;       NEGATIVE EXPONENT
        XRA     A;       ZERO
        SUB     C;       COMPLEMENT EXPONENT
 OUT10: MVI     C,0FFH;  EMBRYO TENS DIGIT
 OUT11: MOV     D,A;       UNITS DIGIT
        INR     C;       INCREMENT TENS DIGIT
        SUI     0AH;  REDUCE REMAINDER
        JNC     OUT11; IF MORE TENS
        MVI     A,15H;  EXPONENT SIGN
 OUT12: CALL    CHAD;  CALL CHAR ADDR SBRTN
        CALL    FSTOR;   STORE LAST 4 CHARACTERS
        LXI     H,VALE;  TO ADDRESS ACCUM SAVE AREA
        JMP     FLOAD;   RESTORE ACCUM AND EXIT
 ;     OUTPUT 4 SPACES IF EXPONENT IS ZERO.
 OUT13: MVI     A,0F0H;  SPACE CHARACTER
        MOV     B,A;       SPACE CHARACTER
        MOV     C,A;       SPACE CHARACTER
        MOV     D,A;       SPACE CHARACTER
        JMP     OUT12; TO STORE CHARACTERS
 ;     SUBROUTINE TO SAVE CH
        INR     E;       TO ADDR NEXT CHARACTER
        MOV     M,E;       UPDATE CHAR STRING WORD
        INR     L;       TO ADDR CHAR STRING BANK
        MOV     H,M;       CHARACTER STRING BANK
        MOV     L,E;       CHARACTER STRING WORD
        RET     ;       RETURN TO CALLER
	END
;	DATA SEGMENT
	CSEG	INPAGE
	PUBLIC	IDVT
	PUBLIC	FSQRN,FSQRX
	PUBLIC	FMACX,FMACS,FMACT,FMACG
	PUBLIC	FSINX
	PUBLIC	FATNT,FATNU
	PUBLIC	FCSHD
	PUBLIC	FSNHD,FEXOV,FSNHX
	PUBLIC	FLOGE,FLOGX
	PUBLIC	SEED
	PUBLIC	ACCUM
;
	PUBLIC	FONE,FPIV2,FLN2,FTEN,RND0
;
;	FPPKG VARIABLES
	PUBLIC	OVER,PREX,ACCE,ACCS,ACC1,ACC2,ACC3,SF
;	FPCONV VARIABLES
	PUBLIC	ADRL,ADRH,TMP1,TMP2,TMP3,VALE,VAL1,VAL2,VAL3,TMP4
;
;
IDVT	EQU	T00
FSQRN	EQU	T00
FSQRX	EQU	T04
FMACX	EQU	T00
FMACS	EQU	T04
FMACT	EQU	T08
FMACGL FUNCTIONS, RANDOM NUMBER GEN
T00:	DS	4
T04:	DS	4
T08:	DS	4
T0C:	DS	2
T0E:	DS	1
T0F:	DS	1
T10:	DS	4
T14:	DS	4
SEED:	DS	2	;RANDOM NUMBER SEED
;
FONE:	DB	81H,0,0,0	;1.0
FPIV2:	DB	81H,49H,0FH,0DCH;PI/2
FLN2:	DB	80H,31H,72H,18H	;LN 2
FTEN:	DB	84H,20H,0,0	;10.0
RND0:	DB	68H,56H,0BFH,0ADH	;.00000005
;
	END
	NAME	FPINT	;FLOATING POINT INTERFACE PACKAGE
	CSEG		;CODE SEGMENT
;
;	NOTE: THE JMP 0000 TO BUILD MUST BE PATCHED
;		  JMP 0000 TO INTERP MUST BE PATCHED
;
;
;	EQUATES FOR CP/M SYSTEM
BDOS	EQU	0005H	;PRIMARY ENTRY POINT TO CP/M
BOOT	EQU	0000H	;REBOOT ENTRY POINT
;
;	PUBLIC SYMBOLS FOR MAIN PROGRAM
;
	PUBLIC	BEGIN,START	;BEGINNING OF BUILD, START OF INTERP
	PUBLIC	MON1		;FUNC,PARM INPUT, NO OUTPUT
	PUBLIC	MON2		;FUNC,PARM INPUT, BYTE OUTPUT
	PUBLIC	MON3		;SYSTEM REBOOT
;
	PUBLIC	MOVEA		;.SARACTER STRING ADDR.
 SVAD:  MOV     A,L;       CHARACTER STRING WORD
        MOV     B,H;       CHARACTER STRING BANK
        MVI     C,0;     INPUT EXP OR DIGIT CNT
        MOV     D,C;       DEC PNT FLAG OR DEC EXP
        LXI     H,ADRL;  TO ADDR CHAR STRING WORD
        CALL    FSTOR;   STORE A, B, C, AND D
        RET     ;       RETURN TO CALLER
 ;     SUBROUTINE TO OBTAIN NEXT CHARACTER ADDR.
 CHAD:  LXI     H,ADRL;  TO ADDRESS SCRATCH BANK
        MOV     E,M;       CHARACTER STRING WORD
	EQU	T0C
FSINX	EQU	T10
FATNT	EQU	T10
FATNU	EQU	T14
FCSHD	EQU	T0E
FSNHD	EQU	T0E
FEXOV	EQU	T0F
FSNHX	EQU	T10
FLOGE	EQU	T0E
FLOGX	EQU	T10
;
;	VARIABLES FOR FLOATING POINT PACKAGE
OVER:	DS	1
PREX:	DS	1
ACCE:	DS	1
ACCS:	DS	1
ACC1:	DS	1
ACC2:	DS	1
ACC3:	DS	1
SF:	DS	1
;
;	VARIABLES FOR FLOATING POINT CONVERSION

ADRL:	DS	1
ADRH:	DS	1
TMP1:	DS	1
TMP2:	DS	1
TMP3:	DS	1
VALE:	DS	1
VAL1:	DS	1
VAL2:	DS	1
VAL3:	DS	1
TMP4:	DS	1
ACCUM:	DS	31	;WORKING BUFFER
;
;	VARIABLES FOR TRANSCENDENTAOURCE,DEST,N, MOVES BYTES
	PUBLIC	MOVE4		;SOURCE,DEST, MOVES 4 BYTES
;
	PUBLIC	CBIN		;CONVERT TO BINARY
	PUBLIC	CFLT		;CONVERT TO FLOAT
	PUBLIC	FLTINP		;FLOATING POINT INPUT
	PUBLIC	FLTOUT		;FLOATING POINT OUTPUT
	PUBLIC	FPOUT		;EQUIVALENT TO FLTOUT
	PUBLIC	FLTRET		;FLOATING POINT OPERATOR RETURN
	PUBLIC	FLTOP		;FLOATING POINT OPERATOR
;
;	SPECIAL PURPOSE SUBROUTINES
	PUBLIC	INPUT	;PORT, RETURNS BYTE
	PUBLIC	OUTPUT	;PORT, BYTE
	PUBLIC	RANDOM
;
;	EXTERNAL SYMBOLS
	EXTRN	FSTOR,FLOAD,FADD,FSUB,FMUL,FDIV,FABS,FZERO,FTEST,FCHS
	EXTRN	OVER
	EXTRN	FINP,FOUT,FFLOAT,FFIX
	EXTRN	FSQRT,FCOS,FSIN,FATAN,FCOSH,FSINH,FEXP,FLOG
	EXTRN	RAND
	EXTRN	ACCUM
;
;	SUBROUTINES FOR MONITOR INTERFACE
;	START OF BASIC COMPILER
	JMP	0000	;PATCHED TO BUILD ENTRY POINT
START:
	JMP	0000	;GO TO THE INTERPRETER
BEGIN:	DW	0000	;FILLED IN WHEN WE FIGURE OUT MEMORY MAP
;
MON1:	JMP	BDOS
MON2:	JMP	BDOS
MON3:	JMP	BOOT
;
;	SPECIAL PURPOSE SUBROUTINE ENTRY POINTS
;
;	SUBROUTINES FOR STORAGE MOVE OPERATIONS
MOVEA:	D	;DEST = DEST + 1
	JMP	MOVER	;FOR THE NEXT BYTE
;
MOVE4:	;SOURCE IN B,C  DEST IN D,E
	LXI	H,4
	JMP	MOVER
;
;  FPINT IS AN INTERFACE PROGRAM BETWEEN THE
;  INTERPRETER AND THE FLOATING POINT PACKAGE
;      THE FLOATING POINT PACKAGE IS LOCATED AT
;
;  THERE ARE SIX ENTRY POINTS INTO FPINT:
;
;      (1) FLTINP - CONVERTS ASCII NUMERIC
;      STRING TO FLOATING POINT
;
;      (2) FLTOUT - CONVERTS FLOATING POINT
;      NUMBER TO AN ASCII STRING
;
;      (3) CBIN - CONVERTS FLOATING POINT
RTED
;	TO FLOATING POINT REPRESENTATION. FIRST IT IS
;	MOVED TO ACCUM AND THEN CONVERTED.	THIS IS DONE
;	BECAUSE FP PKG REQUIRES ALL ADDRESSES BE ON ONE PAGE
;
FLTINP:
	MOV	A,C
	ORA	A
	JNZ	FLTI1
	MVI	C,8
	JMP	FLTOP
FLTI1:	LXI	H,ACCUM	;POINTER TO ACCUM
INP1:	LDAX	D	;LOAD A CHAR
	SUI	30H	;CONVERT TO INTERFACE CODE
	MOV	M,A	;STORE CHAR INTO ACCUM
	INX	D	;POINT TO NEXT CHAR
	INX	H	;POINT TO NEXT ACCUM LOC
	DCR	C	;DECREMENT COUNTER
	JNZ	INP1	;LOOP
	MVI	A,011H	;END OF STRING INDICATOR	
	MOV	M,E STRING AS IS
FP1:
;	OTHERWISE REMOVE TRAILING BLANKS, ZEROS
	DCX	D	;NEXT LOCATION
	LDAX	D	;GET CHAR
	CPI	0	;A ZERO?
	JZ	FP1	;YES, SKIP IT
	CPI	0F0H	;A BLANK?
	JZ	FP1	;YES, SKIP IT
;	FOUND NON BLANK, NON ZERO CHAR
	CPI	0FEH	;IS IT TRAILING .
	JNZ	FP3	;IF SO ELIM 
FP2:
	DCX	D	;IT WAS . SO ELIM
FP3:
	POP	H	;ADDRESS TO STORE STRING
	MOV	B,E	;SAVE RIGHT END OF STRING
	LXI	D,ACCUM	;BEGINNING
FP4:
	LDAX	D	;GET CHAR
	ADI	30H	;CONV TO ASCII
	CPI	' '	;IF A BLANK DO NOT PASS 
	JZ	FP5	;TO MAIN P
	MVI	E,32	;SET SCALING FACTOR
	CALL	FFIX	;CALL CONV ROUTINE
	JMP EMPTY	;MOVE BACK AND RETURN
;
;	ENTRY POINT FOR CONVERSION FROM BINARY TO F/P
;	REG B,C CONTAIN ADDRESS OF NUMBER TO CONV
;
CFLT:	PUSH	B
	POP	H	;NOW ADDR IN H,L
	PUSH	H	;ALSO SAVE IT
	CALL	FETCH	;GET NUMBER TO REG A - D
	MVI	E,32
	CALL	FFLOAT	;CALL CONV TO BINARY ROUTINE
	JMP	EMPTY	;MOVE BACK AND RET
;
;	BUILD JUMP TABLE FOR USE BY STORE AND ENTER
;
JUMPT:
	DW	INITP	;FUNC = 0 INITIALIZE
	DW	FSTOR	;FUNC = 1 STORE ACCUM
	DW	;.SOURCE,DESTINATION,COUNT ADDRESSED BY B,C
	MOV	H,B
	MOV	L,C
	MOV	C,M	;LS SOURCE
	INX	H
	MOV	B,M	;MS SOURCE
	INX	H
	MOV	E,M	;LS DEST
	INX	H
	MOV	D,M	;MS DEST
	INX	H
	MOV	A,M	;LS COUNT
	INX	H
	MOV	H,M	;MS COUNT
	MOV	L,A	;LS COUNT
;	SOURCE IN B,C  DEST IN D,E  COUNT IN H,L
MOVER:	MOV	A,L	;CHECK FOR ZERO COUNT
	ORA	H	;BOTH ZERO?
	RZ
;	MOVE NEXT BYTE FROM SOURCE TO DESTINATION
	DCX	H	;COUNT = COUNT - 1
	LDAX	B	;BYTE TO REGISTER A
	STAX	D	;TO DESTINATION
	INX	B	;SOURCE = SOURCE + 1
	INX;      NUMBER TO A BINARY NUMBER
;
;      (4) CFLT - CONVERST BINARY NUMBER
;      TO A FLOATING POINT NUMBER
;
;      (5) FLTRET - PERFORMS FP ARITHMETIC
;      OPERATION AND STORES RESULT BACK INTO
;      AREA SPECIFIED BY THE INTERPRETER
;
;      (6) FLTOP - PERFORMS FP ARITHMETIC
;      OPERATION BUT DOES NOT STORE RESULT
;      BACK INTO INTERPRETER
;
;
;
;
;	ENTRY POINT FOR INP CALL (FUNCTION)
;	REG C CONTAINS NUMBER OF CHARACTERS TO CONVERT
;	REG D,E POINT TO CHAR STRING TO BE CONVEA
	LXI	H,ACCUM	;THIS IS WHERE STRING IS NOW
	CALL	FINP	;CALL FP PKG
	RET		;RETURN TO INTERP
;
;	ENTRY POINT FOR OUT CALL (FUNCTION 12)
;	CONVERT NUMBER IN FP ACCUM TO STRING AND PLACE IT
;	IN THE ADDRESS IN REG B,C. ACCUM USED AS INTERM.
;	STORAGE OF STRING.
;
FPOUT:
FLTOUT:
	PUSH	B
	LXI	H,ACCUM	;TEMP STORE STRING HERE
	CALL	FOUT	;CONVERT TO ASCII
	LXI	D,ACCUM+9	;IS IT IN EXP FORM?
	LDAX	D	;IF SO THIS IS LETTER E
	LXI	D,ACCUM+13	;SETUP REG D,E
	CPI	'E' - 30H	;IS IT AN E?
	JZ	FP2	;YES LEAVROGRAM IE SKIP IT
	MOV	M,A	;NOT BLANK MOVE IT
	INX	H	;NEXT LOCATION
FP5:
	MOV	A,E	;CURRENT POS
	INX	D	;SETUP FOR NEXT CHAR
	CMP	B	;COMPLETE?
	JNZ	FP4	;NO	- CONTINUE
	MVI	M,' '	;LEAVE TRAILING BLANK
	RET
;
;	ENTRY POINT FOR CONVERSION FROM F/P TO BINARY
;	REG B,C CONTAINS ADDRESS OF F/P NUMBER
;	BINARY NUMBER IS MOVED BACK TO REPLACE F/P NUMBER
;
CBIN:	PUSH	B	;SAVE ADDRESS
	POP	D	;NOW ADDRESS IN D,E
	PUSH	D	;SAVE AGAIN
	MVI	C,2	;LOAD FUNCTION NUMBER
	CALL	FLTOP	;GET F/P NUMBER INTO REG A-D	FLOAD	;FUNC = 2 LOAD ACCUM
	DW	FADD	;FUNC = 3 ADD TO ACCUM
	DW	FSUB	;FUNC = 4 SUB FROM ACCUM
	DW	FMUL	;FUNC = 5 MULT ACCUM
	DW	FDIV	;FUNC = 6 DIV ACCUM
	DW	FABS	;FUNC = 7 ABSOLUTE VALUE
	DW	FZERO	;FUNC = 8 ZERO ACCUM
	DW	FTEST	;FUNC = 9 TEST FOR ZERO
	DW	FCHS	;FUNC = 10 COMPLEMENT ACCUM
	DW	FSQRT	;FUNC = 11 SQUARE ROOT
	DW	FCOS	;FUNC = 12 COSINE
	DW	FSIN	;FUNC = 13 SINE
	DW	FATAN	;FUNC = 14 ARCTAN
	DW	FCOSH	;FUNC = 15 COSH
	DW	FSINH	;FUNC = 16
	DW	FEXP	;FUNC = 17
	DW	FLOG	;FUNC = 18
;
;	ENTRY POINT WHEN RESULT IE FP ACCUM IS STORED
;		BACK INTO ADDRESS PASSED IN D,E.
;		REG C IS A FUNCTION
;		REG D,E IS ADDRESS OF PARAMETER
;
FLTRET:	;PERFORM OPERATION AND RETURN RESULT
	PUSH	D	;SAVE RETURN PARAMETER ADDRESS
	CALL	FLTOP	;RETURNS TO THIS ADDRESS
EMPTY:	POP	H	;RETURN PARAMETER ADDRESS
	MOV	M,A
	INX	H
	MOV	M,B
	INX	H
	MOV	M,C
	INX	H
	MOV	M,D
	RET
;
;
;	ENTRY POINT WHEN NO STORE BACK IS DESIRED
;		REG C IS FUNCTION
;		REG D,E IS A PARAMETER
;
;	GET PROPER FUNCTION BY ADDIN	00	;CHANGED ABOVE
	RET
;
OUTPUT:	;PORT NUMBER, VALUE
	LXI	H,OUTP+1
	MOV	M,C	;OUT INSTRUCTION CHANGED
	MOV	A,E	;VALUE TO SEND
OUTP:	OUT	00	;CHANGED ABOVE
	RET
;
RANDOM:	JMP	RAND
;
;	THE FOLLOWING SUBROUTINE MOVES A FOUR BYTE
;	QUANTITY FROM MEMORY TO REG A - D
;
FETCH:
	MOV	A,M
	INX	H
	MOV	B,M
	INX	H
	MOV	C,M
	INX	H
	MOV	D,M
	RET
;
	END
	NAME	FLPT
	CSEG

	PUBLIC	OVERF,FLOAD,FSTOR,FADD,FSUB,FMUL,FDIV,FTEST
	PUBLIC	FCHS,FABS,RSH,LSH,ADD10,FZERO,FCOMP,FSTR0
	EXTRN	OVER,PREX,ACCE,ACCS,ACC1,ACC2,ACC3,SF

 ;     8008 BINARY FLOATING POINT SYSTEM
 ;     ARITHMETIC AND UTILITY PACKAGE
 ;     PROGRAMMER  CAL OHME
 ;     DATE  26 DECEMBER 1973


 ;     FSTOR SUBROUTINE ENTRY POINT.
 FSTR0:  MOV     M,E;       STORE ZEROETH WORD
        INR     L;       TO ADDRESS FIRST WORD
 FSTOR:   MOV     M,A;       STORE FIRST WORD
 STR1:  INR        RETURN TO CALLER
 ;     FLOATING POINT CHS SUBROUTINE ENT. PNT.
 FCHS:   MVI     A,80H;  MASK FOR SIGN BIT
        DB      00EH;  LBI INST TO SKIP NEXT WD
 ;     FLOATING POINT ABS SUBROUTINE ENT. PNT.
 FABS:   XRA     A;       ZERO
        LXI     H,ACCS;  TO ADDRESS ACCUM SIGN
        ANA     M       ;       COMPLEMENT OF SIGN
        XRI     80H;  COMPLEMENT THE SIGN BIT
        MOV     M,A;       ACCUMULATOR SIGN
 ;     FLOATING POINT TEST ENTRY POINT.
 FTEST: LXI    H,ACCE;  TO ADDR AC       INR     L;       TO ADDR ACCUM 3RD FRCTN
        MOV     D,M;       ACCUMULATOR 3RD FRCTN
        JMP     ADD12; TO SET EXIT CONDITIONS
 ;     FLOATING POINT LOAD ENTRY POINT.
 FLOAD:   MOV     A,M;       OPERAND EXPONENT
        ANA     A       ;       SET CONTROL BITS
        JZ      FZERO;   IF OPERAND IS ZERO
        MOV     E,A;       OPERAND EXPONENT
        INR     L;       TO ADDR OP SIGN AND 1ST
        MOV     A,M;       OPERAND SIGN AND 1ST FRCTN
        INR     L;       TO ADDREING FUNCTION NUMBER IN B
;	REGISTER TO THE FIRST FUNCTION ADDRESS SETUP AS A DW
;
FLTOP:
	LXI	 H,JUMPT
	MVI	B,0
	DAD	 B
	DAD	 B
;
	MOV	C,M
	INX	H
	MOV	B,M
	LXI	H,JMPIN+1	;CHANGE ADDRESS FIELD
	MOV	M,C
	INX	H
	MOV	M,B
;	JMP INSTRUCTION CHANGED (CANNOT USE PCHL BECAUSE OF H,L PARAMETER)
	XCHG	;PARM TO H,L READY FOR CALL
JMPIN:	JMP	0000	;ADDRESS FIELD ALTERED ABOVE
;
;
INITP:	XRA	A
	STA	OVER
	RET
;
;
INPUT:	;PORT NUMBER, RETURN VALUE IN A
	LXI	H,INP+1
	MOV	M,C	;IN XX CHANGED
INP:	I   L;       TO ADDRESS SECOND WORD
        MOV     M,B;       STORE SECOND WORD
        INR     L;       TO ADDRESS THIRD WORD
        MOV     M,C;       STORE THIRD WORD
        INR     L;       TO ADDRESS FOURTH WORD
        MOV     M,D;       STORE FOURTH WORD
        RET     ;       RETURN TO CALLER
 ;     FLOATING POINT ZERO SUBROUTINE ENT. PNT.
 FZERO:	LXI	H,ACCE;	TO ADDRESS ACCUM EXPONENT
        XRA     A;       ZERO
        MOV     M,A;       CLEAR ACCUMULATOR EXPONENT
        RET     ; CUM EXPONENT
        MOV     A,M;       ACCUMULATOR EXPONENT
        ANA     A       ;       SET CONTROL BITS
        JZ      FZERO;   IF ACCUMULATOR IS ZERO
        MOV     E,A;       ACCUMULATOR EXPONENT
        INR     L;       TO ADDR ACCUMULATOR SIGN
        MOV     A,M;       ACCUMULATOR SIGN
        INR     L;       TO ADDR ACCUM 1ST FRCTN
        XRA     M;       ACCUM SIGN AND 1ST FRCTN
        INR     L;       TO ADDR ACCUM 2ND FRCTN
        MOV     C,M;       ACCUMULATOR 2ND FRACTION
 SS OPERAND 2ND FRACTION
        MOV     C,M;       OPERAND 2ND FRACTION
        INR     L;       TO ADDRESS OPERAND 3RD FRACTION
        MOV     D,M;       OPERAND 3RD FRACTION
 ;     STORE THE OPERAND IN THE ACCUMULATOR.
        MOV     L,A;       OPERAND SIGN AND 1ST FRCTN
 FLOAD1:  ORI     80H;  ACCUMULATOR 1ST FRACTION
        MOV     B,A;       ACCUMULATOR 1ST FRACTION
        XRA     L;       ACCUMULATOR SIGN
        LXI     H,ACCE;  TO ADDR ACCUM EXPONENT
        CALL    FSTR0;  SET THE ACCUMULATOR
        XRA     B;       ACCUM SIGN AND 1ST FRCTN
 ;     SET CONTROL BITS AND EXIT
        MOV     B,A;       ACCUM SIGN AND 1ST FRACTION
        ORI     1;     SET SIGN BIT FOR EXIT
        MOV     A,E;       ACCUMULATOR EXPONENT
        RET     ;       RETURN TO CALLER
 ;     FLOATING POINT MUL SUBROUTINE ENT. PNT.
 FMUL:   MOV     A,M;       OPERAND EXPONENT
        ANA     A       ;       SET CONTROL BITS
        CNZ     MDEX;  READ OPERAND IF NOT ZERO
        JZ      FZERO;   IF ZERLLER IF UNDERFLOW
        CALL    LSH;   CALL LEFT SHIFT SUBROUTINE
 ;     ROUND IF NECESSARY.
 RNDA:  CALL    ROND;  CALL ROUNDING SUBROUTINE
        JC      OVERF; IF OVERFLOW
        MOV     B,A;       ACCUM SIGN AND 1ST FRACTION
        ORI     1;     SET SIGN BIT
        MOV     A,E;       ACCUMULATOR EXPONENT
        RET     ;       RETURN TO CALLER
 ;     FLOATING POINT DIV SUBROUTINE ENT. PNT.
 FDIV:   XRA     A;       ZERO
        SUB     M;       COMPLEMENT OF DIVISOR EXPONENT
        ARRY BIT FOR EXIT
        RET     ;       RETURN TO CALLER
        DB      0;     CHECK SUM WORD
 ;     FLOATING POINT SUB SUBROUTINE ENT. PNT.
 FSUB:    MVI     A,80H;  MASK TO CHANGE OP SIGN
        DB      0EH;  LBI INST TO SKIP NEXT WD
 ;     FLOATING POINT ADD SUBROUTINE ENT. PNT.
 FADD:    XRA     A;       ZERO
 ;     LOAD THE OPERAND.
        MOV     E,M;       OPERAND EXPONENT
        INR     L;       TO ADDR OP SIGN, 1ST FRCTN
        XRA     M;       OPERAND SIGN AND 1ST FRCTN
           OPERAND EXPONENT
        ANA     A       ;       SET CONTROL BITS
        JZ      FTEST;  IF OPERAND IS ZERO
 ;     GENERATE SUBTRACTION FLAG, RESTORE
 ;     SUPPRESSED FRACTION BIT.
        MOV     L,B;       OPERAND SIGN AND 1ST FRCTN
        MOV     A,B;       OPERAND SIGN AND 1ST FRACTION
        ORI     80H;  OPERAND 1ST FRACTION
        MOV     B,A;       OPERAND 1ST FRACTION
        XRA     L;       OPERAND SIGN
        MVI     L,LOW(ACCS);  TO ADDRESS ACCUMULATOR SIGN
        XRA     M ;     CHECK FOR INSIGNIFICANT OPERAND.
        JM      FTEST;  IF THE OPERAND IS INSIGNIFICANT
        CPI     25;  COMPARE SHIFT COUNT TO 25
        JC      ADD3;  JOIN EXCH PATH IF OP SIGNIF
        JMP     FTEST;  OPERAND IS INSIGNIFICANT
 ;     CHECK FOR INSIGNIFICANT ACCUMULATOR
 ADD2:  JP      ADD17; IF ACCUM IS INSIGNIFICANT
        CPI     0E7H;  COMPARE SHIFT COUNT TO MINUS 25
        JC      ADD17; IF ACCUM IS INSIGNIFICANT
        MOV     M,E;       OPERAND EXPONENT
        MOV     E,AO OR UNDERFLOW
        JC      OVERF; IF OVERFLOW
        CALL    MULX;  CALL FIXED MULT SUBRTN
 ;     NORMALIZE IF NECESSARY.
        MOV     A,B;       1ST PRODUCT
        ANA     A       ;       SET CONTROL BITS
        JM      RNDA;  IF NO NORMALIZATION REQUIRED
        LXI     H,ACCE;  TO ADDR ACCUM EXPONENT
        MOV     A,M;       ACCUMULATOR EXPONENT
        SBI     1;     DECREMENT ACCUMULATOR EXPONENT
        MOV     M,A;       ACCUMULATOR EXPONENT
        RZ      ;       RETURN TO CACPI     1;     SET CARRY IF DIVISION BY ZERO
        CNC     MDEX;  READ OPERAND IF NOT ZERO
        JC      OVERF; IF OVERFLOW OR DIVISION BY ZERO
        JZ      FZERO;  IF UNDERFLOW OR ZERO
        MOV     C,A;       DIVISOR 1ST FRACTION
        CALL    DIVX;  CALL FIXED DIV SUBRTN
        JC      RNDA;  IF NO OVERFLOW
 ;     SET OVERFLOW FLAG.
 OVERF:	LXI	H,OVER;	TO ADDR OVERFLOW FLAG
        MVI     A,0FFH;  OVERFLOW FLAG
        MOV     M,A;       OVERFLOW FLAG
        RLC     ;       SET CMOV     B,A;       OPERAND SIGN AND 1ST FRCTN
        INR     L;       TO ADDR OPERAND 2ND
        MOV     C,M;       OPERAND 2ND FRACTION
        INR     L;       TO ADDR OPERAND 3RD FRCTN
        MOV     D,M;       OPERAND 3RD FRACTION
 ;     SAVE INITIAL EXPONENT.
	LXI	H,ACCE;	TO ADDR ACCUM EXPONENT
        MOV     A,M;       ACCUMULATOR EXPONENT
        DCR     L;       TO ADDR INITIAL EXPONENT
        MOV     M,A;       INITIAL EXPONENT
 ;     CHECK FOR ZERO OPERAND.
        MOV     A,E;    ;       SUBTRACTION FLAG
        MVI     L,LOW(SF);    TO ADDRESS SUBTRACTION FLAG
        MOV     M,A;       SUBTRACTION FLAG
 ;     DETERMINE RELATIVE MAGNITUDES OF
 ;     OPERAND AND ACCUMULATOR.
        MVI     L,LOW(ACCE);  TO ADDRESS ACCUMULATOR EXPONENT
        MOV     A,M;       ACCUMULATOR EXPONENT
        ANA     A       ;       SET CONTROL BITS
        JZ      ADD17; IF ACCUMULATOR IS ZERO
        SUB     E;       DIFFERENCE IN EXPONENTS
        JC      ADD2;  IF ACCUM SMALLER THAN OP
;       SHIFT COUNT
        LXI     H,SF;    TO ADDRESS THE SUBTRACTION FLAG
        MOV     A,M;       SUBTRACTION FLAG
        MVI     L,LOW(ACCS);  TO ADDRESS THE ACCUMULATOR SIGN
        XRA     M;       OPERAND SIGN
        MOV     M,A;       ACCUMULATOR SIGN
        XRA     A;       ZERO
        SUB     E;       COMPLEMENT SHIFT COUNT
 ;     EXCHANGE ACCUMULATOR AND OPERAND.
        INR     L;       TO ADDR ACCUM 1ST FRACTION
        MOV     E,M;       ACCUMULATOR 1ST FRACTION
        MOV     M,B;       OPERAND 1ST FRACTION
        MOV     B,E;       ACCUMULATOR 1ST FRACTION
        INR     L;       TO ADDR ACCUM 2ND FRACTION
        MOV     E,M;       ACCUMULATOR 2ND FRACTION
        MOV     M,C;       OPERAND 2ND FRACTION
        MOV     C,E;       ACCUMULATOR 2ND FRACTION
        INR     L;       TO ADDR ACCUM 3RD FRACTION
        MOV     E,M;       ACCUMULATOR 3RD FRACTION
        MOV     M,D;       OPERAND 3RD FRACTION
        MOV     D,E;       ACCUMULATOR 3RD FRACTION
 ;       TO ADDRESS AUGEND 2ND FRACTION
        MOV     A,M;       AUGEND 2ND FRACTION
        ADC     C;       ADDEND 2ND FRACTION
        MOV     C,A;       SUM 2ND FRACTION
        DCR     L;       TO ADDRESS AUGEND 1ST FRACTION
        MOV     A,M;       AUGEND 1ST FRACTION
        ADC     B;       ADDEND 1ST FRACTION
        MOV     B,A;       SUM 1ST FRACTION
        JNC     ADD11; IF NO CARRY FROM 1ST FRCTN
 ;     RIGHT SHIFT SUM TO NORMALIZED POSITION.
        RAR     ;       RIGHT SHIFT SUM 1ST OV     A,M;       ACCUMULATOR EXPONENT
        ADI     1;     INCREMENT ACCUMULATOR EXPONENT
        JC      OVERF; IF OVERFLOW
        MOV     M,A;       ACCUMULATOR EXPONENT
        JMP     ADD11; TO ROUND FRACTION
 ;     SUBTRACT SUBTRAHEND FROM MINUEND.
 ADD9:  XRA     A;       MINUEND 4TH FRCTN IS ZERO
        SUB     E;       SUBTRAHEND 4TH FRACTION
        MOV     E,A;       DIFFERENCE 4TH FRACTION
        MOV     A,M;       MINUEND 3RD FRACTION
        SBB     D;       SUBTRAHEND 3RD FRACT NEGATIVE
        CP      NORM;  NORMALIZE IF NECESSARY
        JP      FZERO;  IF UNDERFLOW OR ZERO
 ADD11: CALL    ROND;  CALL ROUNDING SUBROUTINE
        JC      OVERF; IF OVERFLOW
 ADD12: MOV     B,A;       ACCUM SIGN AND 1ST FRCTN
        LXI     H,PREX;  TO ADDRESS PREV EXPONENT
        MOV     A,E;       ACCUMULATOR EXPONENT
        SUB     M;       DIFFERENCE IN EXPONENTS
        MOV     L,A;       DIFFERENCE IN EXPONENTS
        MOV     A,B;       ACCUM SIGN AND 1ST FRCTN
        ORI         B;       ACCUM SIGN AND 1ST FRCTN
        JMP     ADD12; JOIN EXIT CODE
        DB      0;     CHECK SUM WORD
 ;     SUBROUTINE TO READ THE OPERAND AND
 ;     CHECK THE ACCUMULATOR EXPONENT.
 MDEX:  MOV     B,A;       EXPONENT MODIFIER
        INR     L;       TO ADDR OP SIGN, 1ST FRCTN
        MOV     C,M;       OPERAND SIGN AND 1ST FRACTION
        INR     L;       TO ADDRESS OPERAND 2ND FRACTION
        MOV     D,M;       OPERAND 2ND FRACTION
        INR     L;       TO ADDRESS OPERAND 3RDPOSITION THE OPERAND.
 ADD3:  CALL    RSH;   POSITION THE OPERAND
        LXI     H,SF;    TO ADDRESS SUBTRACTION FLAG
        MOV     A,M;       SUBTRACTION FLAG
        ANA     A       ;       SET CONTROL BITS
        MVI     L,LOW(ACC3);  TO ADDR ACCUM 3RD FRCTN
        JM      ADD9;  IF SUBTRACTION REQUIRED
 ;     ADD ADDEND TO AUGEND.
        MOV     A,M;       AUGEND 3RD FRACTION
        ADD     D;       ADDEND 3RD FRACTION
        MOV     D,A;       SUM 3RD FRACTION
        DCR     L;     FRACTION
        MOV     B,A;       SUM 1ST FRACTION
        MOV     A,C;       SUM 2ND FRACTION
        RAR     ;       RIGHT SHIFT SUM 2ND FRACTION
        MOV     C,A;       SUM 2ND FRACTION
        MOV     A,D;       SUM 3RD FRACTION
        RAR     ;       RIGHT SHIFT SUM 3RD FRACTION
        MOV     D,A;       SUM 3RD FRACTION
        RAR     ;       4TH FRCTN = LOW BIT OF 3RD
        MOV     E,A;       SUM 4TH FRACTION
        MVI     L,LOW(ACCE);  TO ADDRESS ACCUMULATOR EXPONENT
        MION
        MOV     D,A;       DIFFERENCE 3RD FRACTION
        DCR     L;       TO ADDRESS MINUEND 2ND FRACTION
        MOV     A,M;       MINUEND 2ND FRACTION
        SBB     C;       SUBTRAHEND 2ND FRACTION
        MOV     C,A;       DIFFERENCE 2ND FRACTION
        DCR     L;       TO ADDRESS MINUEND 1ST FRACTION
        MOV     A,M;       MINUEND 1ST FRACTION
        SBB     B;       SUBTRAHEND 1ST FRACTION
        MOV     B,A;       DIFFERENCE 1ST FRACTION
 ADD10: CC      FCOMP;  COMPLEMENT IF 1;     SET SIGN BIT FOR EXIT
        MOV     A,E;       ACCUMULATOR EXPONENT
        MOV     E,L;       SIGNIFICANCE INDEX
        RET     ;       RETURN TO CALLER
 ;     LOAD THE ACCUMULATOR WITH THE OPERAND.
 ADD17: LXI     H,SF;    TO ADDR SUBTRACTION FLAG
        MOV     A,M;       SUBTRACTION FLAG
        MVI     L,LOW(ACCS);  TO ADDR ACCUMULATOR SIGN
        XRA     M;       OPERAND SIGN
        DCR     L;       TO ADDR ACCUM EXPONENT
        CALL    FSTR0;  SET THE ACCUMULATOR
        XRA FRACTION
        MOV     E,M;       OPERAND 3RD FRACTION
        LXI     H,ACCE;  TO ADDRESS ACCUMULATOR EXPONENT
        MOV     A,M;       ACCUMULATOR EXPONENT
        ANA     A       ;       SET CONTROL BITS
        RZ      ;       RETURN IF ACCUM IS ZERO
        ADD     B;       RESULT EXPONENT PLUS BIAS
        MOV     B,A;       RESULT EXPONENT PLUS BIAS
        RAR     ;       CARRY TO SIGN
        XRA     B;       CARRY AND SIGN MUST DIFFER
        MOV     A,B;       RESULT EXPONENT PLUS BIAS
        MVI     B,80H;  EXP BIAS, SIGN MASK, MS BIT
        JP      OVUN;  IF OVERFLOW OR UNDERFLOW
        SUB     B;       REMOVE EXCESS EXP BIAS
        RZ      ;       RETURN IF UNDERFLOW
        MOV     M,A;       RESULT EXPONENT
        INR     L;       TO ADDRESS ACCUMULATOR SIGN
        MOV     A,M;       ACCUMULATOR SIGN
        XRA     C;       RESULT SIGN IN SIGN BIT
        ANA     B       ;       RESULT SIGN
        MOV     M,A;       RESULT SIGN
        MOV     A,C;       OPERASH1:  MOV     A,D;       ORIGINAL CONTENTS OF D REGISTER
        RAL     ;       LEFT SHIFT D
        MOV     D,A;       RESTORE CONTENTS OF D REGISTER
        MOV     A,C;       ORIGINAL CONTENTS OF C REGISTER
        RAL     ;       LEFT SHIFT C
        MOV     C,A;       RESTORE CONTENTS OF C REGISTER
        MOV     A,B;       ORIGINAL CONTENTS OF B REGISTER
        ADC     A;       LEFT SHIFT B
        MOV     B,A;       RESTORE CONTENTS OF B REGISTER
        RET     ;       RETURN TO CALLER
      MVI     B,0;     OPERAND 1ST FRACTION IS ZERO
        SUB     L;       REDUCE SHIFT COUNT BY 1 REG
        JNZ     RSH1;  IF MORE SHIFTS REQUIRED
 ;     SHIFT OPERAND RIGHT BY -SHIFT COUNT-
 ;     BITS.
 RSH2:  ANA     A       ;       SET CONTROL BITS
        RZ      ;       RETURN IF SHIFT COMPLETE
        MOV     L,A;       SHIFT COUNT
 RSH3:  ANA     A       ;       CLEAR CARRY BIT
        MOV     A,B;       OPERAND 1ST FRACTION
        RAR     ;       RIGHT SHIFT OP 1ST FRCTN
        MOEMENT SHIFT COUNT
        JNZ     RSH3;  IF MORE SHIFTS REQUIRED
        RET     ;       RETURN TO CALLER
 ;     COMPLEMENT THE B, C, D, AND E REGISTERS.
 FCOMP:  DCR     L;       TO ADDR ACCUM SIGN
        MOV     A,M;       ACCUMULATOR SIGN
        XRI     80H;  CHANGE SIGN
        MOV     M,A;       ACCUMULATOR SIGN
 COMP1: XRA     A;       ZERO
        MOV     L,A;       ZERO
        SUB     E;       COMPLEMENT 4TH FRCTN
        MOV     E,A;       4TH FRACTION
        MOV     A,L;       ZERO       ;       SET CONTROL BITS
        JNZ     NORM3; IF 1ST FRACTION NONZERO
        MOV     B,C;       1ST FRACTION
        MOV     C,D;       2ND FRACTION
        MOV     D,E;       3RD FRACTION
        MOV     E,A;       ZERO 4TH FRACTION
        MOV     A,L;       NORMALIZING SHIFT COUNT
        SUI     8;  REDUCE SHIFT COUNT
        MOV     L,A;       NORMALIZING SHIFT COUNT
        JNZ     NORM1; IF FRACTION NONZERO
        RET     ;       IF FRACTION IS ZERO
 NORM2: DCR     L;       DECRND SIGN AND 1ST FRCTN
        ORA     B;       OPERAND 1ST FRACTION
        RET     ;       RETURN TO CALLER
 OVUN:  RLC     ;       SET CARRY BIT IF OVERFLOW
        RC      ;       RETURN IF OVERFLOW
        XRA     A;       ZERO
        RET     ;       RETURN IF UNDERFLOW
 ;     SUBROUTINE TO LEFT SHIFT THE B, C,
 ;     D, AND E REGISTERS ONE BIT.
 LSH:   MOV     A,E;       ORIGINAL CONTENTS OF E
        RAL     ;       LEFT SHIFT E
        MOV     E,A;       RESTORE CONTENTS OF E REGISTER
 L ;     RIGHT SHIFT THE B, C, D AND E REGISTERS
 ;     BY THE SHIFT COUNT IN THE A REGISTER
 ;     SHIFT OPERAND TO REGISTER INDICATED BY
 ;     SHIFT COUNT
 RSH:   MVI     E,0;     OPERAND 4TH FRCTN IS ZERO
 RSH0:  MVI     L,8;  EACH REG IS 8 BITS OF SHIFT
 RSH1:  CMP     L;       COMPARE SHIFT COUNT TO 8
        JM      RSH2;  IF REQ SHIFT LESS THAN 8
        MOV     E,D;       OPERAND 4TH FRACTION
        MOV     D,C;       OPERAND 3RD FRACTION
        MOV     C,B;       OPERAND 2ND FRACTION
  V     B,A;       OPERAND 1ST FRACTION
        MOV     A,C;       OPERAND 2ND FRACTION
        RAR     ;       RIGHT SHIFT OP 2ND FRCTN
        MOV     C,A;       OPERAND 2ND FRACTION
        MOV     A,D;       OPERAND 3RD FRACTION
        RAR     ;       RIGHT SHIFT OP 3RD FRCTN
        MOV     D,A;       OPERAND 3RD FRACTION
        MOV     A,E;       OPERAND 4TH FRACTION
        RAR     ;       RIGHT SHIFT OP 4TH FRCTN
        MOV     E,A;       OPERAND 4TH FRACTION
        DCR     L;       DECR
        SBB     D;       COMPLEMENT 3RD FRCTN
        MOV     D,A;       3RD FRACTION
        MOV     A,L;       ZERO
        SBB     C;       COMPLEMENT 2ND FRCTN
        MOV     C,A;       2ND FRACTION
        MOV     A,L;       ZERO
        SBB     B;       COMPLEMENT 1ST FRCTN
        MOV     B,A;       1ST FRACTION
        RET     ;       RETURN TO CALLER
 ;     NORMALIZE THE REGISTERS.
 NORM:  MVI     L,20H;  MAX NORMALIZING SHIFT
 NORM1: MOV     A,B;       1ST FRACTION
        ANA     AEMENT SHIFT COUNT
        MOV     A,E;       ORIGINAL CONTENTS OF E
        RAL     ;       LEFT SHIFT E
        MOV     E,A;       RESTORE CONTENTS OF E REGISTER
        MOV     A,D;       ORIGINAL CONTENTS OF D REGISTER
        RAL     ;       LEFT SHIFT D
        MOV     D,A;       RESTORE CONTENTS OF D REGISTER
        MOV     A,C;       ORIGINAL CONTENTS OF C REGISTER
        RAL     ;       LEFT SHIFT C
        MOV     C,A;       RESTORE CONTENTS OF C REGISTER
        MOV     A,B;       ORIGINAL CONTENTS OF B REGISTER
        ADC     A;       LEFT SHIFT B
        MOV     B,A;       RESTORE CONTENTS OF B REGISTER
 NORM3: JP      NORM2; IF NOT NORMALIZED
        MOV     A,L;       NORMALIZING SHIFT COUNT
        SUI     20H;  REMOVE BIAS
        LXI     H,ACCE;  TO ADDR ACCUM EXPONENT
        ADD     M;       ADJUST ACCUM EXPONENT
        MOV     M,A;       NEW ACCUM EXPONENT
        RZ      ;       RETURN IF ZERO EXP
        RAR     ;       BORROW BIT TO SIGN
        ANA     A        ACCUM SIGN AND 1ST FRCTN
        JMP     STR1;  RETURN THRU STORE SUBR.
 ;     SECOND LEVEL ROUNDING SUBROUTINE.
 RNDR:  INR     D;       ROUND 3RD FRACTION
        RNZ     ;       RETURN IF NO CARRY
        INR     C;       CARRY TO 2ND FRACTION
        RNZ     ;       RETURN IF NO CARRY
        INR     B;       CARRY TO 1ST FRACTION
        RNZ     ;       RETURN IF NO CARRY
        MOV     A,E;       ACCUMULATOR EXPONENT
        ADI     1;     INCREMENT ACCUM EXPONENT
        MOV     E,A;      A;       CLEAR 6TH PRODUCT
        MOV     E,A;       CLEAR 5TH PRODUCT
        MOV     D,A;       CLEAR 4TH PRODUCT
 ;     MULTIPLY BY EACH ACCUMULATOR
 ;     FRACTION IN TURN.
        LXI     H,ACC3;  TO ADDRESS 3RD FRCTN
        CALL    MULX2; MULTIPLY BY ACCUM 3RD FRCTN
        MVI     L,LOW(ACC2);  TO ADDRESS 2ND FRCTN
        CALL    MULX1; MULTIPLY BY ACCUM 2ND FRCTN
        MVI     L,LOW(ACC1);  TO ADDRESS 1ST FRCTN
 ;     MULTIPLY BY ONE ACCUMULATOR WORD.
 MULX1: MOV     A,D;       5THZERO COMPLETE
 ;     COMPLETE ADDITION OF MULTIPLICAND.
 MULX5: MOV     C,A;       2ND PARTIAL PRODUCT
        JNC     MULX3; IF NO CARRY TO 1ST PRODUCT
        INR     B;       ADD CARRY TO 1ST PRODUCT
        ANA     A       ;       CLEAR CARRY BIT
 ;     LOOP FOR EACH BIT OF MULTIPLIER WORD.
 MULX3: MOV     A,L;       5TH PART PRODUCT, EXIT FLAG
        ADC     A;       SHIFT EXIT FLAG OUT IF DONE
        RZ      ;       EXIT IF MULTIPLICATION DONE
        MOV     L,A;       5TH PART PRODUCT, E   RAL     ;       SHIFT 1ST PROD AND MULTIPLIER
        MOV     B,A;       1ST PART PROD AND MULTIPLIER
        JNC     MULX3; IF NO ADDITION REQUIRED
 ;     ADD THE MULTIPLICAND TO THE PRODUCT
 ;     IF THE MULTIPLIER BIT IS ONE.
        MOV     A,E;       4TH PARTIAL PRODUCT

;  THE FOLLOWING CODE WAS MOVED FROM THE BEGINNING
;  OF THE PROGRAM TO THIS LOCATION TO MAKE THINGS
;  A LITTLE EASIER...

MULX4:
MULP3:
	ADI	0;	ADD OPERAND 3RD FRACTION
	MOV	E,A;	4TH PARTIAL PRODUCT
	MOV	A,D;	3RD PA;       SET SIGN TO IND. UNDERFLOW
        RET     ;       RETURN TO CALLER
 ;     SUBROUTINE TO ROUND THE B, C, D REGISTERS.
 ROND:  LXI     H,ACCE;  TO ADDR ACCUM EXPONENT
        MOV     A,E;       4TH FRACTION
        ANA     A       ;       SET CONTROL BITS
        MOV     E,M;       ACCUMULATOR EXPONENT
        CM      RNDR;  CALL 2ND LEVEL ROUNDER
        RC      ;       IF OVERFLOW
        MOV     A,B;       1ST FRACTION
        INR     L;       TO ADDR ACCUM SIGN
        XRA     M;         NEW ACCUM EXPONENT
        MVI     B,80H;  NEW 1ST FRACTION
        MOV     M,A;       NEW ACCUM EXPONENT
        RET     ;       RETURN TO ROND SUBROUTINE
 ;     FIXED POINT MULTIPLY SUBROUTINE.
 MULX:  LXI     H,MULP1+1; TO ADDR 1ST MULTIPLICAND
        MOV     M,A;       1ST MULTIPLICAND
        LXI     H,MULP2+1; TO ADDR 2ND MULTIPLICAND
        MOV     M,D;       2ND MULTIPLICAND
        LXI     H,MULP3+1; TO ADDR 3RD MULTIPLICAND
        MOV     M,E;       3RD MULTIPLICAND
        XRA    PARTIAL PRODUCT
        MOV     E,C;       4TH PARTIAL PRODUCT
        MOV     D,B;       3RD PARTIAL PRODUCT
 MULX2: MOV     B,M;       MULTIPLIER
        MOV     L,A;       5TH PARTIAL PRODUCT
        XRA     A;       ZERO
        MOV     C,A;       2ND PARTIAL PRODUCT
        SUB     B;       SET CARRY BIT FOR EXIT FLAG
        JC      MULX3; IF MULTIPLIER IS NOT ZERO
        MOV     C,D;       2ND PARTIAL PRODUCT
        MOV     D,E;       3RD PARTIAL PRODUCT
        RET     ;       MULT BY XIT FLAG
        MOV     A,E;       4TH PARTIAL PRODUCT
        RAL     ;       SHIFT 4TH PARTIAL PRODUCT
        MOV     E,A;       4TH PARTIAL PRODUCT
        MOV     A,D;       3RD PARTIAL PRODUCT
        RAL     ;       SHIFT 3RD PARTIAL PRODUCT
        MOV     D,A;       3RD PARTIAL PRODUCT
        MOV     A,C;       2ND PARTIAL PRODUCT
        RAL     ;       SHIFT 2ND PARTIAL PRODUCT
        MOV     C,A;       2ND PARTIAL PRODUCT
        MOV     A,B;       1ST PART PROD AND MULTPLIER
     RTIAL PRODUCT
MULP2:
	ACI	0;	ADD OPERAND 2ND FRACTION
	MOV	D,A;	3RD PARTIAL PRODUCT
	MOV	A,C;	2ND PARTIAL PRODUCT
MULP1:
	ACI	0;	ADD OPERAND 1ST FRACTION

	JMP	MULX5
 ;     FIXED POINT DIVIDE SUBROUTINE.
 ;     SUBTRACT DIVISOR FROM ACCUMULATOR TO
 ;     OBTAIN 1ST REMAINDER.
 DIVX:  LXI     H,ACC3;  TO ADDRESS ACCUM 3RD FRCTN
        MOV     A,M;       ACCUMULATOR 3RD FRACTION
        SUB     E;       DIVISOR 3RD FRACTION
        MOV     M,A;       REMAINDER 3RD FRACTION
        DCR     L;       TO ADDRESS ACCUM 2ND FRCTN
        MOV     A,M;       ACCUMULATOR 2ND FRACTION
        SBB     D;       DIVISOR 2ND FRACTION
        MOV     M,A;       REMAINDER 2ND FRACTION
        DCR     L;       TO ADDRESS ACCUM 1ST FRCTN
        MOV     A,M;       ACCUMULATOR 1ST FRACTION
        SBB     C;       DIVISOR 1ST FRACTION
        MOV     M,A;       REMAINDER 1ST FRACTION
 ;     HALVE THE DIVISOR AND STORE FOR
 ;     ADDITION OR SUBTRACTION.
        MOV     A,C;       DIVISOR 1ST FRACTION
 P2S+1;  TO ADDRESS 2ND SUBTRACT DIVISOR
        MOV     M,A;       2ND SUBTRACT DIVISOR
        LXI     H,OP2A+1;  TO ADDRESS 2ND ADD DIVISOR
        MOV     M,A;       2ND ADD DIVISOR
        MOV     A,E;       DIVISOR 3RD FRACTION
        RAR     ;       HALF OF DIVISOR 3RD FRACTION
        LXI     H,OP3S+1;  TO ADDRESS 3RD SUBTRACT DIVISOR
        MOV     M,A;       3RD SUBTRACT DIVISOR
        LXI     H,OP3A+1;  TO ADDRESS 3RD ADD DIVISOR
        MOV     M,A;       3RD ADD DIVISOR
        MVI I     H,ACC1;  TO ADDR REMAINDER 1ST FRCTN
        MOV     A,M;       REMAINDER 1ST FRACTION
        INR     L;       TO ADDR REMAINDER 2ND FRCTN
        MOV     D,M;       REMAINDER 2ND FRACTION
        INR     L;       TO ADDR REMAINDER 3RD FRCTN
        MOV     E,M;       REMAINDER 3RD FRACTION
        ANA     A       ;       SET CONTROL BITS
        JM      DIVX4; IF REMAINDER IS NEGATIVE
 ;     ADJUST EXPONENT,POSITION REMAINDER
 ;     AND INITIALIZE THE QUOTIENT.
        MVI     L,LOW(ACCE);FROM THE REMAINDER
 ;     IF IT IS POSITIVE
 DIVX1: XRA     A;       REMAINDER 4TH FRCTN IS ZERO
        CALL    DIVX5;
 DIVX2: RLC     ;       SHFT REM 4TH FRCTN TO CY
 ;     SHIFT THE REMAINDER LEFT ONE BIT.
        MOV     A,B;       QUOTIENT 1ST FRACTION
        RAL     ;       MS BIT OF QUOTIENT TO CY
        RC      ;       IF DIVISION COMPLETE
        RAR     ;       REMAINDER 4TH FRCTN TO CY
        MOV     A,L;       REMAINDER 3RD FRACTION
        RAL     ;       LEFT SHIFT REM 3RD FRCTN
 DIVX3: MOV     A,L;       REMAINDER 3RD FRACTION
        JMP     DIVX6;
 ;     POSITION THE REMAINDER AND INITIALIZE
 ;     THE QUOTIENT.
 DIVX4: MOV     L,E;       REMAINDER 3RD FRACTION
        MOV     H,D;       REMAINDER 2ND FRACTION
        MOV     E,A;       REMAINDER 1ST FRACTION
        MOV     D,B;       INITIALIZE QUOT 3RD FRCTN
        MOV     C,B;       INITIALIZE QUOT 2ND FRCTN
        JMP     DIVX3; ADD DIVISOR IF REM IS NEG
;  ORIGINALLY, THIS CODE WAS AT THE BEGINNING
;  OF THE        RAL     ;       SET CARRY BIT
        MOV     A,C;       DIVISOR 1ST FRACTION
        RAR     ;       HALF OF DIVISOR 1ST FRCTN
 ;               + 80H TO CORRECT QUOTIENT
        LXI     H,OP1S+1;  TO ADDRESS 1ST SUBTRACT DIVISOR
        MOV     M,A;       1ST SUBTRACT DIVISOR
        LXI     H,OP1A+1;  TO ADDRESS 1ST ADD DIVISOR
        MOV     M,A;       1ST ADD DIVISOR
        MOV     A,D;       DIVISOR 2ND FRACTION
        RAR     ;       HALF OF DIVISOR 2ND FRACTION
        LXI     H,O    B,0;     INIT QUOTIENT 1ST FRCTN
        MOV     A,B;       DIVISOR FOURTH FRACTION IS ZERO
        RAR     ;       LOW BIT OF DIVISOR 3RD FRACTION
        LXI     H,OP4S+1;  TO ADDRESS 4TH SUBTRACT DIVISOR
        MOV     M,A;       4TH SUBTRACT DIVISOR
        LXI     H,OP4A+1;  TO ADDRESS 4TH ADD DIVISOR
        MOV     M,A;       4TH ADD DIVISOR
        LXI     H,OP4X+1;  TO ADDRESS 4TH ADD DIVISOR
        MOV     M,A;       4TH ADD DIVISOR
 ;     LOAD 1ST REMAINDER, CHECK SIGN.
        LX  TO ADDRESS ACCUMULATOR EXPONENT
        MOV     C,M;       QUOTIENT EXPONENT
        INR     C;       INCREMENT QUOTIENT EXPONENT
        RZ      ;       RETURN IF OVERFLOW
        MOV     M,C;       QUOTIENT EXPONENT
        MOV     L,E;       REMAINDER 3RD FRACTION
        MOV     H,D;       REMAINDER 2ND FRACTION
        MOV     E,A;       REMAINDER 1ST FRACTION
        MVI     D,1;     INITIALIZE QUOT 3RD FRCTN
        MOV     C,B;       INITIALIZE QUOT 2ND FRCTN
 ;     SUBTRACT THE DIVISOR 
        MOV     L,A;       REMAINDER 3RD FRACTION
        MOV     A,H;       REMAINDER 2ND FRACTION
        RAL     ;       LEFT SHIFT REM 2ND FRCTN
        MOV     H,A;       REMAINDER 2ND FRACTION
        CALL    LSH;   CALL LEFT SHIFT SUBROUTINE
 ;     BRANCH IF SUBTRACTION IS REQUIRED
        MOV     A,D;       QUOTIENT 3RD FRACTION
        RRC     ;       REM SIGN INDIC TO CARRY BIT
        JC      DIVX1; TO SUB DIVISOR IF REM POS
 ;     ADD THE DIVISOR IF THE REMAINDER
 ;     IS NEGATIVE.
PROGRAM...

DIVX5:
OP4S:
	SUI	0;	SUB DIVISOR 4TH FRACTION
	MOV	A,L;	REM 3RD FRACTION
OP3S:
	SBI	0;	SUB DIVISOR 3RD FRACTION
	MOV	L,A;	REM 3RD FRACTION
	MOV	A,H;	REM 2ND FRACTION
OP2S:
	SBI	0;	SUB DIVISOR 2ND FRACTION
	MOV	H,A;	REM 2ND FRACTION
	MOV	A,E;	REM 1ST FRACTION
OP1S:
	SBI	0;	SUB DIVISOR 1ST FRACTION
	MOV	E,A;	REM 1ST FRACTION
OP4A:
	MVI	A,0;	REM 4TH FRACTION
	RET

DIVX6:
OP3A:
	ADI	0;	ADD DIVISOR 3RD FRACTION
	MOV	L,A;	REM 3RD FRACTION
	MOV	A,H;	REM 2ND FRACTION
OP2A:
	ACI	0;	ADD DIVISOR 2ND FRACTION
	MOV	H,A;	REM 2ND FRACTION
	MOV	A,E;	REM 1ST FRACTION
OP1A:
	ACI	0;	ADD DIVISOR 1ST FRACTION
	MOV	E,A;	REM 1ST FRACTION
OP4X:
	MVI	A,0;	REM 4TH FRACTION

	JMP	DIVX2

        END     
	NAME	FPINT
	CSEG
;
;
;	LINK TO EXTERNAL REFERENCES
;
	EXTRN	FSTOR,FLOAD,FADD,FTEST,FZERO,FABS,FMUL,FDIV
	EXTRN	FFLOAT,FFIX,FCHS,FSUB
	EXTRN	OVER
	EXTRN	OVERF,ACC2,ACCE
	EXTRN	SEED
	PUBLIC	IDV,FCOSH,FSQRT,FSIN,FCOS,FATAN,FSINH,FEXP,FLOG
	PUBLIC	RAND
;
;	ENTRY IDV - INVERSE FDIVIDE
;
;	STORAGE IN SCRATCH PAD
	SCRT:	DS	25
IDVT	EQU	SCRT + 00H
;
IDV:	PUSH	H
	CALL	FTEST	;FLOATING POINT ACCUMULATOR TO REGISTERS
	LXI	H,IDVT
	CALL	FSTOR	;FDIVISOR TO STORAGE
	POP	H
	CALL	FLOAD	;FDIVIDEND TO AR		;HALVE THE EXPONENT
	ADI	40H	;RESTORE THE OFFSET
	LXI	H,FSQRX
	CALL	FSTOR
	MVI	D,5	;ITERATION COUNT
	PUSH	D	;STACKED
FSQRL:	LXI	H,FSQRN
	CALL	FLOAD
	LXI	H,FSQRX
	CALL	FDIV
	LXI	H,FSQRX
	CALL	FADD
	SUI	1	;HALVE THE RESULT
	LXI	H,FSQRX
	CALL	FSTOR
	POP	D	;RESTORE ITERATION COUNT
	DCR	D	;TALLY
	JZ	FSQRE	;EXIT WHEN COUNT EXHAUSTED
	PUSH	D	;SAVE IT OTHERWISE
	JMP	FSQRL	;TO NEXT ITERATION
FSQRE:	LXI	H,FSQRX	;RESULT TO ACCUMULATOR
	CALL	FLOAD
	RET
;
;	EVALUATION OF ELEMENTARY FUNCTION MSCRT+04H
FMACT	EQU	SCRT+08H
FMACG	EQU	SCRT+0CH
;
;	TWO SUBROUTINE LEVELS USED
;
FMACL:	XRA	A	;CLEAR A REGISTER FOR LOG TYPE SERIES
	LXI	H,FMACS	;POINT TO SIGMA
	MOV	M,A	;ZERO STORED
	LXI	H,FMACB	;PRESET BRANCH B
	JMP	FMACC	;JOINT CODE
FMACE:	LHLD	FONE	;MOVE 1.0 TO SIGMA FOR EXP TYPE SERIES
	SHLD	FMACS
	LHLD	FONE+2
	SHLD	FMACS+2
	LXI	H,FMACA	;PRESET BRANCH A
FMACC:	SHLD	FMACG	;STORE PRESET BRANCH
	MVI	E,32	;COUNT FOR THE FLOATING OF A(I)
FMACD:	PUSH	B	;CHAIN RULE LOOP
	PUSH	D	;SAVE A(I), DP	B	;D(A) AND D^2(A)
	MOV	A,D
	SUB	C
	RZ	;DONE IF ZERO
	RC	;OR NEGATIVE
	MOV	D,A	;A(I-1)
	MOV	A,C	;D(A(I-1))
	SUB	B
	MOV	C,A	;D(A(I-2))
	JMP	FMACD	;NEXT ITERATION
FONE:	DB	81H,0,0,0	;CAN BE IN ROM
FPIV2:	DB	81H,49H,0FH,0DCH;PI/2
FLN2:	DB	80H,31H,72H,18H;LN 2
;
;
;	SINE-COSINE ROUTINE USING MACLAURIN SERIES
;
;
;	ENTRY FSIN FOR SIN(X)
;	ENTRY FCOS FOR COS(X)
;	ENTER WITH X IN RADIANS IN FLOATING POINT ACCUMULATOR
;	RETURNS WITH FUNCTION IN FLOATIG POINT ACCUMULATOR
;	(IF FABS(X) >= 2^24FLOATING POINT ACCUMULATOR
	LXI	H,IDVT
	JMP	FDIV	;RETURN THROUGH DIV ROUTINE
;
;
;
;	FLOATING POINT SQUARE ROOT ROUTINE BY NEWTONIAN ITERATION
;
;	THE SQUARE ROOT OF THE FABSOLUTE VALUE OF THE
;	CONTENTS OF THE FLOATING POINT ACCUMULATOR IS
;	RETURNED IN THE FLOATING POINT ACCUMULATOR.
;
;
;	STORAGE IN SCRATCH BANK
FSQRN	EQU	SCRT + 00H
FSQRX	EQU	SCRT + 04H
;
FSQRT:	CALL	FABS	;FORCE ARGUMENT POSITIVE, SET ZERO FLAG
	RZ		;RETURN ON ZERO
	LXI	H,FSQRN
	CALL	FSTOR
	ANA	A	;RESET CARRY BIT
	RACLAURIN SERIES
;
;
;	ENTRY FMACE FOR EXPONENTIAL TYPE SERIES, E.G.
;	SINH(Z) = Z/1 + Z^3/6 + Z^5/120 + ...
;		S(I-1) = (1. + X*S(I)/A(I)), S(N) = 1.
;
;	ENTRY FMACL FOR LOGARITHMIC TYPE SERIES, E.G.
;	ARCTAN(Z) = Z/1 - Z^3/3 + Z^5/5 - ...
;		S(I-1) = (1./A(I) + X*S(I)), S(N) = 0.
;
;	IN BOTH SERIES DEL^2(A(I)) MUST BE CONSTANT.
;	ENTER WITH X IN FMACX, A(N) IN D, D(A(N-1)) IN C,
;		D^2(A(1)) IN B.
;	RESULT IN FMACS, WHEN A(I) <= 0.
;
;	STORAGE IN SCRATCH BANK
FMACX	EQU	SCRT+00H
FMACS	EQU	(A(I)), D^2(A(1))
	XRA	A	;ZERO THE LEAD POSITIONS OF A(I)
	MOV	B,A
	MOV	C,A
	CALL	FFLOAT	;FLOAT A(I)
	LXI	H,FMACT
	CALL	FSTOR
	LXI	H,FMACX
	CALL	FLOAD
	LXI	H,FMACS
	CALL	FMUL
	LHLD	FMACG	;CHOOSE THE BRANCH
	PCHL
FMACA:	LXI	H,FMACT
	CALL	FDIV
	LXI	H,FONE	;POINTS TO 1.0
	JMP	FMACF	;REJOIN COMMON CODE
FMACB:	LXI	H,FMACS
	CALL	FSTOR	;X*SIGMA
	LXI	H,FONE	;LOAD 1.0
	CALL	FLOAD
	LXI	H,FMACT
	CALL	FDIV	;1/A(I)
	LXI	H,FMACS
FMACF:	CALL	FADD
	LXI	H,FMACS
	CALL	FSTOR
	POP	D	;A(I) AND 32
	PO*PI, OVERFLOW FLAG IS SET)
;
;	STORAGE IN SCRATCH BANK
FSINX	EQU	SCRT+10H
;
;	THREE LEVELS OF SUBROUTINES USED
;
FCOS:	CALL	FCHS	;COMPLEMENT THE ANGLE
	LXI	H,FPIV2
	CALL	FADD
FSIN:	CALL	FTEST	;FETCH ARGUMENT
	LXI	H,FSINX
	CALL	FSTOR
	LXI	H,FPIV2	;REDUCE X TO REVOLUTIONS*4
	CALL	FDIV
	MVI	E,26	;REVOLUTIONS AT BINARY SCALE 24
	CALL	FFIX
	JC	OVERF	;QUIT IF ANGLE TO LARGE
	MVI	E,26
	MVI	D,0	;WIPE OUT FRACTIONAL REVOLUTIONS
	CALL	FFLOAT	;INTEGER PART OF REVOLUTIONS
	LXI	H,FPIV2	;TO RADIANS
	CALL	FMUL
	CALL	FCHS
FSINA:	LXI	H,FSINX
	CALL	FADD
	LXI	H,FSINX
	CALL	FSTOR
	CALL	FABS	;FORCE ANGLE INTO REDUCED RANGE
	LXI	H,FPIV2
	CALL	FSUB
	JM	FSINB	;IF NEGATIVE OR ZERO
	JZ	FSINB	;THEN ANDGLE IS REDUCED
	LXI	H,FPIV2	;FABS(X)-PI
	CALL	FSUB
	MOV	E,A	;SAVE A REGISTER
	LXI	H,FSINX+1
	MOV	A,M
	ANI	80H	;SIGN OF X
	XRI	80H	;INVERTED
	XRA	B	;-SIGN(X)*(FABS(X)-PI)
	MOV	B,A
	MOV	A,E	;RESTORE A REGISTER
	DCX	H	;POINT TO FSINX
	CALL	FSTOR	;REDUCED X
	CALL	FZERO	;CLEAR ACCUMULATOR
	JMP	FSIN EXIT
	RET
;
;
;	ARCTAN ROUTINE USING MACLAURIN SERIES
;
;
;
;	ENTRY FATAN FOR ARCTAN(X), WITH X IN FLOATING POINT ACCUMULATOR
;	RESULT RETURNED IN FLOATING POINT ACCUMULATOR
;
;	STORAGE IN SCRATCH BANK
FATNT	EQU	SCRT+10H
FATNU	EQU	SCRT+14H
;
;	FOUR LEVELS OF STACK USED
;
FATAN:	CALL	FTEST	;GET F.P. ACC. INTO REGISTERS
	RZ
	CPI	81H	;TEST EXPONENT
	JC	FATN1	;RETURN TO CALLER FROM FATN1
	LXI	H,FONE	;1.0
	CALL	IDV	;1.0/X
	CALL	FATN1	;ARCTAN(1/X)
	LXI	H,FATNU
	CALL	FSTOR
	LXI	H,FPIV2	;(TAN(T)^2+1.0)
	LXI	H,FATNT
	CALL	IDV	;TAN(T/2)
	LXI	H,FATNT
	CALL	FSTOR
	LXI	H,FATNU
	INR	A	;2*TAN(T/2)
	CALL	FSTOR
	LXI	H,FATNT
	CALL	FMUL
	CALL	FCHS	;-TAN(T/2)^2
	LXI	H,FMACX
	CALL	FSTOR
	MVI	D,11	;TERM 13 DISCARDED, 16 BITS PRECISION IN RANGE
	MVI	C,2	;(11-9)
	MVI	B,0	;(11-9)-(9-7)
	CALL	FMACL
	LXI	H,FMACS
	CALL	FLOAD
	LXI	H,FATNU
	CALL	FMUL
	RET
;
;
;
;	HYPERBOLIC COSINE ROUTINE USING MACLAURIN SERIES
;
;
;
;	ENTRY FCOSH FOR COSH(X), WITH X IN THE FLOATING POINT ACCUMULATOR
	MVI	M,80H
	CALL	FLOAD	;PUT X INTO ACC
FCSHA:	LXI	H,FMACX
	CALL	FMUL	;X^2
	LXI	H,FMACX
	CALL	FSTOR
	MVI	D,56	;8*7, 10 TERM DISCARDED, 21 BITS PRECISION
	MVI	C,26	;(8*7-6*5)
	MVI	B,8	;(8*7-6*5) - (6*5-4*3)
	CALL	FMACE
FCSHB:	LXI	H,FCSHD	;ADDRESS THE DOUBLING COUNT
	DCR	M	;TALLY AT LOOP TOP
	JM	FCSHC	;DONE WHEN COUNT IS NEGATIVE
	LXI	H,FMACS	;FETCH COSH(X/2)
	CALL	FLOAD
	LXI	H,FMACS
	CALL	FMUL	;COSH(X/2)^2
	LXI	H,ACCE
	INR	M	;2*COSH(X/2)^2
	LXI	H,FONE	;-1.0
	CALL	FSUB	;=COSH(X)
	LXI	H,FM
	CALL	FSTOR
	LXI	H,FSNHD	;ADDRESS DOUBLING COUNTER
	MVI	M,0
	SUI	80H	;REMOVE OFFSET FROM A
	JM	FSNHA	;DOUBLING COUNT AND X ARE OK
	CPI	8	;ELIMINATE OVERSIZE DOUBLING COUNT
	JP	OVERF	;RETURN THROUGH OVERFLOW ROUTINE
	MOV	M,A	;SAVE DOUBLING COUNT
	LXI	H,FSNHX	;BRING ARGUMENT INTO RANGE
	MVI	M,80H
	CALL	FLOAD	;PUT X INTO FLOATING ACCUMULATOR
FSNHA:	LXI	H,FSNHX
	CALL	FMUL	;X^2
	LXI	H,FMACX
	CALL	FSTOR
	MVI	D,42	;7*6, 9 TERM DISCARDED, 18 BITS PRECISION
	MVI	C,22	;7*6-5*4
	MVI	B,8	;(7*6-5*4)-(A	;REPEAT UNTIL FABS(X) <= PI/2
;
FSINB:	LXI	H,FSINX
	CALL	FLOAD
	LXI	H,FSINX
	CALL	FMUL
	CALL	FCHS	;-X^2
	LXI	H,FMACX
	CALL	FSTOR	;TO MACLAURIN SERIES
	MVI	D,72	;9*8, 11 TERM DISCARDED, 18 BITS PRECISION
	MVI	C,30	;9*8 - 7*6
	MVI	B,8	;(9*8 - 7*6) - (7*6 - 5*4)
	CALL	FMACE
	LXI	H,FMACS
	CALL	FLOAD
	LXI	H,FSINX
	CALL	FMUL
	CPI	81H	;SEE IF TAIL NEEDS CLEANING
	JC	FSINC	;NO, MAGNITUDE IS < 1.0
	LXI	H,ACC2
	XRA	A
	MOV	M,A
	INR	L
	MOV	M,A
FSINC:	CALL	FTEST	;RESTORE FLAGS AND REGISTERS FORPI/2
	CALL	FLOAD
	MOV	E,A	;SAVE A REGISTER
	LXI	H,FATNU+1	;SIGN(T)
	MOV	A,M	;TO A REGISTER
	ANI	80H
	ORA	B	;ATTACH TO PI/2
	MOV	B,A
	MOV	A,E	;RESTORE A REGISTER
	LXI	H,FATNT
	CALL	FSTOR
	LXI	H,FATNT
	CALL	FLOAD
	LXI	H,FATNU	;-SIGN(T)*(PI/S-FABS(T))
	CALL	FSUB	;=SIGN(T)*FABS(T) = T
	RET
;
;	EVALUATE ARCTAN OF ARGUMENTS < 1.0
FATN1:	LXI	H,FATNT	;POINT TO TEMP
	CALL	FSTOR	;TAN(T)
	LXI	H,FATNT
	CALL	FMUL	;TAN(T)^2
	LXI	H,FONE	;1.0
	CALL	FADD
	CALL	FSQRT
	LXI	H,FONE
	CALL	FADD	;1.0+SQRT
;	THE RESULT IS RETURNED IN THE F.P. ACCUMULATOR.
;	IF FABS(X) > 88.0 THE OVERFLOW FLAG IS SET.
;
;	STORAGE IN SCRATCH BANK
FCSHD	EQU	SCRT+0EH	;DOUBLING COUNTER
;
;	THREE LEVELS OF STACK USED
;
FCOSH:	CALL	FTEST	;GET ARGUMENT INTO REGISTERS
	LXI	H,FMACX
	CALL	FSTOR
	LXI	H,FCSHD
	MVI	M,0
	SUI	80H	;REMOVE EXPONENT OFFSET
	JM	FCSHA	;DOUBLING COUNT AND X ARE OK
	CPI	8	;ELIMINATE OVERSIZE DOUBLING COUNT
	JP	OVERF	;RETURN THROUGH OVERFLOW ROUTINE
	MOV	M,A	;SAVE THE DOUBLING COUNT
	LXI	H,FMACX
ACS
	CALL	FSTOR
	JMP	FCSHB	;TEST DOUBLING COUNT
FCSHC:	CALL	FTEST	;RESTORE REGISTERS AND FLAGS
	RET
;
;
;
;	EXPONENTIAL AND HYPERBOLIC SIN ROUTINE
;
;
;	SCRATCH BANK STORAGE
FSNHD	EQU	SCRT+0EH
FEXOV	EQU	SCRT+0FH
FSNHX	EQU	SCRT+10H
;
;
;	ENTRY FEXP FOR EXP(X)
;	ENTRY SSINH FOR SINH(X)
;		ENTRY WITH X IN FP ACCUMULATOR
;		RETURNS WITH FUNCTION IN FP ACCUMULATOR.
;		IF FUNCTION EXCEEDS 2^127M OVERFLOW FLAG WILL BE SET
;
FSINH:	CALL	FTEST	;FETCH FP ACCUMULATOR
	LXI	H,FSNHX	;SAVE ARGUMENTF*4-3*2)
	CALL	FMACE
	LXI	H,FMACS
	CALL	FLOAD
	LXI	H,FSNHX
	CALL	FMUL
	LXI	H,FSNHX	;SINH(X)
	CALL	FSTOR
	LXI	H,FSNHX	;SINH(X)^2
	CALL	FMUL
	LXI	H,FONE	;+1.0
	CALL	FADD
	CALL	FSQRT	;COSH(X) FOR DOUBLINE AND FOR EXP(X9
	LXI	H,FMACX	;TEMP
	CALL	FSTOR
FSNHB:	LXI	H,FSNHD	;ADDRESS DOUBLING COUNT
	DCR	M	;TALLY AT LOOP TOP
	JM	FSNHC	;DONE WHEN NEGATIVE
	LXI	H,FMACX	;COSH(X/2)
	CALL	FLOAD
	LXI	H,FSNHX	;SINH(X/2)
	CALL	FMUL
	INR	A	;2.*SINH(X/2)*COSH(X/2)
	LXI	H,FSNHX	;SINH(X)
	CALL	FSTOR
	LXI	H,FMACX	;COSH(X/2)
	CALL	FLOAD
	LXI	H,FMACX
	CALL	FMUL
	LXI	H,ACCE	;2.*COSH(X/2)^2
	INR	M
	LXI	H,FONE	;-1
	CALL	FSUB
	LXI	H,FMACX	;=COSH(X)
	CALL	FSTOR
	JMP	FSNHB	;TEST THE DOUBLING COUNT
FSNHC:	LXI	H,FSNHX
	CALL	FLOAD
	RET
FEXP:	CALL	FTEST
	JP	FEXPP
	LXI	H,OVER	;SAVE OVERFLOW FLAG
	MOV	E,M
	MVI	M,0
        LXI	H,FEXOV
	MOV	M,E	;OLD FLAG TO SAVE CELL
	CALL	FABS
	CALL	FEXPP	;EXP(-X) IN ACC
	LXI	H,FEXOV	;GET OLD OVERFLOW FLAG BACK
	MOV	E,M
	LXI	H,OVER	;PICK UP NEW ONE TO TEST
	MOV	A ACCUMULATOR
;	IF X = 0 THE OVERFLOW FLAG IS SET
;
;	3 LEVELS OF SUBROUTINES USED
;
FLOG:	CALL	FABS	;FORCE ARGUMENT POSITIVE, SET ZERO FLAG
	JZ	OVERF	;RETURN THROUGH OVERFLOW ROUTINE
	SUI	81H	;REMOVE EXPONENT OFFSET
	LXI	H,FLOGE
	MOV	M,A
	MVI	A,81H	;NORMALIZE ARGUMENT
	LXI	H,FLOGX
	CALL	FSTOR	;CALL IT X
	LXI	H,FLOGX
	CALL	FLOAD
	LXI	H,FONE
	CALL	FADD
	LXI	H,FMACS
	CALL	FSTOR	;X+1.0
	LXI	H,FLOGX
	CALL	FLOAD
	LXI	H,FONE
	CALL	FSUB	;X-1.0
	LXI	H,FMACS
	CALL	FDIV
	LXI	H,FLOGX
	CALL	FSTFRACTIONAL PART
	CALL	FADD
	RET
;
;	RANDOM NUMBER GENERATOR
;
;
RAND:	;COMPUTE NEXT RANDOM NUMBER, AND LEAVE AT SEED
	LXI	H,SEED
	MOV	C,M	;GET LEAST SIGNIFICANT BYTE
	INR	L
	MOV	B,M	;X(N) IN B,C
	DCR	L	;ADDRESS SEED FOR SBR2
	CALL	AROUT	;CALCUALTE X(N)*2053D
	LXI	H,CNST	;ADDRESS CONSTANT 13849
	CALL	SBR2
	LXI	H,SEED	;ADDRESS SEED AGAIN
	MOV	M,C	;STORE NEW SEED
	INR	L
	MOV	M,B
	RET		;WITH SEED SET TO RANDOM NUMBER
;
CNST:	DW	13849
;
AROUT:	;COMPUTE X(N)*2053D TO B,C
	MVI	D,9	;X(N)*2*L	;RESTORE H,L FOR NEXT OPERATION
	RET
	END
.pl 72
.mb 8
.mt 8
.cw 8
.lh 7
.po 7
.op
                               Nationa CP/ User Grou - Progra Submitta Form

** I yo hav an comment o thi form pleas 
**forwar the t th CP/ User Group.
**
**Pleas fil ou thi for fo al materia sub
**mitte t th CP/ User Group  I wil assis 
**u i preparin you contributio fo circulatio 
**an i helpin peopl selec programs 
**
**Sen th contribution wit th complete form 
**to:
*,M
	MOV	M,E	;RESTORE OLD OVERFLOW FLAG
	ANA	A	;SET FLAGS
	JNZ	FZERO	;RECIPROCAL OF OVERFLOW IS ZERO
	LXI	H,FONE
	CALL	IDV	;1./EXP(-X) = EXP(X)
	RET
FEXPP:	CALL	FSINH	;SINH(X)
	LXI	H,FMACX	;+COSH(X)
	CALL	FADD	;=EXP(X)
	RET
;
;
;
;	NATURAL LOGARITHM ROUTINE USING MACLAURIN SERIES
;
;
;
;
;	ENTRY POINTS IN MACLAURIN SERIES
;	STORAGE IN SCRATCH BANK
FLOGE	EQU	SCRT+0EH
FLOGX	EQU	SCRT+10H
;
;
;	ENTRY FLOG FOR LN(FABS(X)), WITH X IN F.P. ACCUMULATOR
;	RESULT IS RETURNED IN FLOATING POINTOR	;(X-1.0)/(X+1.0)
	LXI	H,FLOGX
	CALL	FMUL
	LXI	H,FMACX
	CALL	FSTOR	;((X-1.0)/(X+1.0))^2
	MVI	D,9	;DISCARD 11 TERM FOR 18 BITS PRECISION
	MVI	C,2	;9-7
	MVI	B,0	;(9-7)-(7-5)
	CALL	FMACL
	LXI	H,FMACS
	INR	M	;DOUBLE THE SUM
	CALL	FLOAD
	LXI	H,FLOGX
	CALL	FMUL	;LOGARITHM OF FRACTIONAL PART
	LXI	H,FLOGX
	CALL	FSTOR
	LXI	H,FLOGE
	MOV	A,M
	MVI	B,0
	MOV	C,B
	MOV	D,B
	MVI	E,8	;BINARY SCALE FACTOR FOR EXPONENT
	CALL	FFLOAT
	LXI	H,FLN2
	CALL	FMUL	;LOGARITHM OF 2^EXPONENT
	LXI	H,FLOGX	;LOG OF *9
	CALL	SBR1
	CALL	SBR2	;X(N)+X(N)*2**9
	MVI	D,2	;2**2*(X(N)+X(N)*2**9)
	CALL	SBR1
	CALL	SBR2	;ADD TO X(N)
	RET
;
SBR1:	;FORMS (B AND C)*2**D
	SUB	A	;CLEAR A AND CARRY
	MOV	A,C	;SHIFT C LEFT
	RAL
	MOV	C,A
	MOV	A,B	;SHIFT B LEFT
	RAL
	MOV	B,A
	DCR	D	;TEST D=0
	RZ		;IF YES, RETURN
	JMP	SBR1	;NO, SHIFT AGAIN
;
SBR2:	;16-BIT ADD OF B,C TO M(H,L), RESULT TO B,C
	SUB	A	;CLEAR A AND CARRY
	MOV	A,M	;LOAD LOW BYTE
	ADD	C	;M(H,L)+C
	MOV	C,A
	INR	L	;M(H,L+1)
	MOV	A,M
	ADC	B
	MOV	B,A
	DCR	*
**CP/ User Group
**165 Thir Avenue
**Ne York N 10028
**
Softwar contribution ar receive fo inclusio 
int th librar wit th understandin tha th 
contributo i authorize t mak th materia a
vailabl t other fo thei individua non-commer
cia use Th User Grou make n representation 
a t th utilit o th materia i th librar fo 
an purpose Contribution shoul b submitte o 8 
singl densit diskette i CP/ fil form Pleas 
cross-referenc an rewrite o bug-fixe t prio 
distributions.
**
**I i intende tha thi for b fille ou wit 
**a editor an lef o th submitte dis fo 
**eac program  (Yo ma grou simila program 
**together) Al line startin * ar comment 
**whic shoul b delete fro th form  Remembe 
**t kee a origina o th for aroun fo sub
**mittin mor tha on program.
**
**(I yo don' mind ther ar stil  lo o u 
**o.
* MORSE.AS   Send Mors cod fro ASCI fil t 
**             port.
**SAMPLE.DA  Sampl dat fil fo MORSE.
.cp 7
.po 67


Author: 
**Pleas includ addres an phon number I ei
**the i no t b published s indicate bu 
**includ the fo th User Grou dis catalogin 
**process i cas ther ar questions.

Submitted by: 
**(i differen tha author)  Als includ addres 
**an phone i different.

This program is public domain because: 
**e.g S**disk Wa anythin publishe i  magazine etc 
**I thi  modificatio o  previou User Grou 
**program an i so wha wa it "name (e.g 
**23.05)

Hardware dependencies: 
**e.g specifi processor dis controller plot
**ter printer modem vide board etc.

Software dependencies: 
**e.g I/Ϡ vi PRO calls o hard-code ports 
**JMPS/CALLӠ t specifi machine-siz BIOS othe 
**softwar require whic i NO o thi disk Tim
**in dependencies "Wel commente .AS 
**file";"Poorl commente .AS file"

**02/22/8 WLC
u her wit 6 wid displays  W woul appre
**ciat you limitin you line t 6 characters  
**<<thanks>>)
**
**Thi for i mos easil fille ou wit  ful 
**scree editor  Yo ma d  "macr nex colon 
**(mn:$v t locat th field whic hav t b 
**fille in.
**
** Sav thi fil a "filename.CPM"
**
**Yo ca the delet al comment line via.. 
**bmn**$0ltk

Date:

File name: 
**(o names) Includ   lin descriptio o each
** Examples ..ubmitte b author author' approval ap
**prova fro magazin i whic i wa published 
**etc.

To whom would this program be useful: 
**e.g "Al CP/ users o "Peopl wit Tarbel 
**flopp controllers o "Peopl wit one-dis sys
**tems etc.

Briefly describe the program function: 
**Includ ru instruction onl i no include i 
**som othe .DO fil o thi disk.

Where is further documentation available: 
**e.g nam th appropriat .DO file o thi 
 "STANDAR CP/M mean i run 
**wit 8 disk (o similarl behavin one lik 
**Northstar) 24 o mor memory CP/ 1.4 D yo 
**think/kno i work with CP/ 2.0?

Source processor: 
**i.e i thi i  sourc program wha d yo 
**"ru i with".. MAC ASM Microsof BASI ver
**sio x.y TD AS etc.

Does the software "drop in": 
**i.e wha typ o modification ar require t 
**mak i run?

How easy is the code to modify: 
**e.g "CO͠ fil only"