 CATALOG 29  ^               ALLOC   ASM x 
               CHASE   ASM  A	

        EDIT    ASM    EDIT    ASM  ; !"#$%&'         NOTATE  ASM I ()*              SAP     ASM  !+,-./            TARGET  ASM R 012              TTT     ASM   3456789:;<=>?@AB TTT     ASMC ACDEFGHIJK        DEFLECT ASM   >LMNOPQRS         MUSIC   ASM   @TUVWXYZ[         MUSICP  COM   
\]               PIRANHA ASM   [^_`abcdefghi     ROBIN   ASM   jklmnopqrstuvwxy ROBIN   ASM  z{|             VOLUME 29

ASSEMBLER GAMES AND UTILITIES AND CP/M BASIC-E VERSION 1.4 FLOATING
POINT SOURCE(OBTAIN VOLUME 30 ALSO FOR COMPLETE SET)


NUMBER	SIZE	NAME		COMMENTS

		CATALOG.29	CONTENTS OF CP/M GROUP VOLUME 29
		VOLUME29.DOC	COMMENTS ON PROGRAMS ON VOLUME 29
29.1	25K	TTT.ASM		3-D TIC TAC TOE GAME
29.2	9K	CHASE.ASM	VDM/SOL GAME.  15.3 WITH CP/M I/O.  SEE
				VOLUME29.DOC.
29.3	3K	TARGET.ASM	VDM/SOL GAME.  
29.4	8K	DEFLECT.ASM	VDM GAME
29.5	8K	MUSIC.ASM	MUSIC PROGRAM
29.6	2K	MUSICP.COM	MUSIC PROUSH/POP LIB FOR MAC.  SEE
				VOLUME29.DOC.
29.15	2K	NCOMPARE.LIB	CORRECTED VERSIONS OF DIGITAL RESEARCH 
				DISTRIBUTION.  SEE VOLUME29.DOC.
29.16	11K	SEQIO.LIB	CORRECTED VERSION OF DIGITAL RESEARCH
				DISTRIBUTION.  SEE VOLUME29.DOC.
29.17	1K	WHENS.LIB	MODIFICATION OF DIGITAL RESEARCH VERSIONS TO 
				ALLOW INFINITE NESTING.  SEE VOLUME29.DOC.
29.18	1K	DOWHILES.LIB	MODIFICATION OF DIGITAL RESEARCH VERSIONS TO
				ALLOW INFINITE NESTING.  SEE VOLUME29.DOC.
29.19	2K	SELECTS.LIB	MODIFICATION OF D				POINT PACKAGE
29.27	29K	FPPKG.SRC	INTERPRETER
29.28	13K	TRAN.SRC	TRANSCENDENTAL FUNCTION PACKAGE
29.29	5K	MOVE.ASM	1 DISK MOVE PROGRAM.  ASSEMBLE USING MAC.
29.30	6K	MOVENMAC.ASM	MOVE.ASM WITH MACROS EXPANDED FOR ASSEMBLY
				USING ASM.
29.31	5K	TIMESQ.ASM	SIGN GENERATOR FOR VDM.
29.32	3K	WSYSGEN.ASM	PROGRAM TO SYSGEN A STACK OF DISKS EASILY.
29.33	1K	VDM.DOC		MODIFY ED TO PAGE 16 LINES INSTEAD OF 24.
 UNLOAD  ASM , }~               ROBOT   ASM                 VOLUME29DOC D               MOVE    ASM   #            MOVENMACASM   /           TIMESQ  ASM   '            WSYSGEN ASM                 VDM     DOC 9                GRAM WITH TABLE FOR "SOUNDS OF
				SILENCE"
29.7	12K	PIRANHA.ASM	VDM GAME
29.8	19K	ROBIN.ASM	USES POLY VTI.  SEE VOLUME29.DOC.
29.9	3K	ROBOT.ASM	VDM GAME
29.10	2K	ALLOC.ASM	DISK ALLOCATION DISPLAY.  SEE VOLUME29.DOC.
29.11	24K	EDIT.ASM	DISASSEMBLY OF 16.5.  SEE VOLUME29.DOC.
29.12	5K	SAP.ASM		SORTS AND PACKS DIRECTORY.  IMPROVED VERSION
				OF 19.8.  SEE VOLUME29.DOC.
29.13	3K	NOTATE.ASM	ADDS COMMENTS TO ASM SOURCE.  ASSEMBLE USING MAC.
				SEE VOLUME29.DOC.
29.14	1K	SYMSTACK.LIB	ASSEMBLER TIME PIGITAL RESEARCH VERSIONS TO
				ALLOW INFINITE NESTING.  SEE VOLUME29.DOC.
29.20	1K	IGADD.MAC	SUBROUTINE CALLABLE FROM FORTRAN-80
29.21	1K	MON1.MAC	SUBROUTINE CALLABLE FROM FORTRAN-80
29.22	1K	MON2.MAC	SUBROUTINE CALLABLE FROM FORTRAN-80
29.23	2K	UNLOAD.ASM	CONVERTS COM FILE TO HEX.  ASSEMBLE USING MAC.
				SEE VOLUME29.DOC.
29.24	14K	FPCONV.SRC	CP/M BASIC-E FLOATING POINT CONVERSION PACKAGE
29.25	2K	FPDATA.SRC	EQUATE TABLES FOR FPCONV
29.26	8K	FPINT.SRC	INTERFACE BETWEEN INTERPRETER AND FLOATING
;ALLOC.ASM - PRINT ALLOCATION VECTOR FOR A DISK
;	AS A BIT MAP
;
;3/77 ORIGINALLY WRITTEN BY WARD CHRISTENSEN
;11/14/77 MODIFY TO ALLOW 'ALLOC B:'
;6/11/78 MODIFY FOR CP/M V1.4 (COMPATIBLE WITH 1.3)
	ORG	100H
	CALL	START	;SKIP ID
	DB	'ALLOC 6/11/78'
	DB	0DH,0AH,'$'
;
;BDOS EQUATES USED IN THIS PROGRAM
;
BDOS	EQU	5
PRINT	EQU	9
SELDK	EQU	14
FCB	EQU	5CH
INQA	EQU	1BH	;INQ ALLOC VECTOR
;
;TYPE ALLOCATION VECTOR
;
START	POP	D	;GET ID MESSAGE
	MVI	C,PRINT	;PRINT IT
	CALL	BDOS
	LDA	FCB	;SELEDBYT	;END OF BYTE?
;CHECK IF AT END
	MOV	A,D	;GET BYTE #
	CPI	2
	JNZ	BIT	;NOT END BYTE
;IS END BYTE, SEE IF END BIT
	MOV	A,E
	CPI	20H
	JNZ	BIT
ENDBYT	INX	B	;POINT TO NEXT BYTE
	DCR	D	;DONE?
	MOV	A,D
	CPI	1
	JZ	CR	;..YES, TYPE CR, EXIT
	MOV	A,D	;GET CHAR COUNT
	ANI	3	;TIME TO C/R?
	CZ	CR	;YES
	JMP	CHAR
;C/R
CR	MVI	A,13	;GET C/R
	CALL	TYPE	;TYPE IT
	MVI	A,10	;GET L/F, TYPE IT
;TYPE CHAR IN A
TYPE	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,2
	MOV	E,A
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
	EN; *************************************
; **  THE GAME OF CHASE              **
; **      --FROM DR. DOBBS JOURN   **
; **             MAY 1977          **
; **      --MODIFIED FOR SOL         **
; **	  --RE-MODIFIED FOR VDM	**
; *************************************
;
;
;
	ORG	100H
;
;*****
; OBTAIN BIOS VECTORS
;*****
VECTRS:	JMP	GETVEC
	DS	42
WBOOTE	EQU	VECTRS+3
CSTS	EQU	VECTRS+6
CI	EQU	VECTRS+9
CO	EQU	VECTRS+12
LO	EQU	VECTRS+15
PO	EQU	VECTRS+18
RI	EQU	VECTRS+21
HOME	EQU	VECTRS+24
TOP:	MVI	B,WIDTH
T1:	CALL	PLOT
	MVI	M,'X'
	INX	D
	CALL	PLOT
	MVI	M,' '
	INX	D
	DCR	B
	JNZ	T1
RSIDE:	MVI	B,HEIGHT
	DCR	E
	DCR	E
R1:	INR	D
	CALL	PLOT
	MVI	M,'X'
	DCR	B
	JNZ	R1
BOTH:	MVI	B,WIDTH-1
B1:	DCR	E
	CALL	PLOT
	MVI	M,' '
	DCR	E
	CALL	PLOT
	MVI	M,'X'
	DCR	B
	JNZ	B1
LSIDE:	MVI	B,HEIGHT
L1:	DCR	D
	CALL	PLOT
	MVI	M,'X'
	DCR	B
	JNZ	L1
;
SEED:	LDA	DFST
	RLC
	MOV	B,A
	MVI	A,1EH
	SUB	B
	MOV	B,A
LOOP1:	CALL	RND
	ANI	0FH
	MOV	D,A
	CALL	RND
	ANI	7FH
	MOV	E,A
	CALL	LI
	LXI	H,RCORN+100H
	MVI	M,'B'
	LXI	H,RCORN+104H
	MVI	M,'N'
	LXI	H,RCORN+108H
	MVI	M,'M'
;
ROBOT:	CALL	SEL
	SHLD	ROB1
	CALL	SEL
	SHLD	ROB2
	CALL	SEL
	SHLD	ROB3
	CALL	SEL
	SHLD	ROB4
	CALL	SEL
	SHLD	ROB5
	CALL	YOU
	JMP	YMOVE
SEL:	CALL	RND
	ANI	0FH
	MOV	D,A
	CALL	RND
	ANI	0FEH
	MOV	E,A
	CALL	LIMIT
	JC	SEL
	CALL	PLOT
	MOV	A,M
	CPI	' '
	JNZ	SEL
	MVI	M,7
	DCR	B
	RNZ
	JMP	YMOVE
;
YOU:	CALL	RND
	ANI	0FH
	MOV	D,A
	CALL	RND
	ANI	0FEH
	MOV	E,A
	CALL	LIMIT
	JC	YOU
	CALL	PLOT
CT DISK?
	ORA	A	;0 ==> LOGGED IN DISK
	JZ	NODK	;NO DISK SELECT
	DCR	A	;MAKE INTO DISK #
	MOV	E,A	;SETUP
	MVI	C,SELDK ;..FOR CALL
	CALL	BDOS	;SELECT DISK
NODK	MVI	C,INQA	;INQUIRE ALLOC
	CALL	BDOS	;GET POINTER TO IT IN B
	MOV	C,A
	MVI	D,32	;SET BYTE COUNT
CHAR	MVI	E,80H	;GET INITIAL BIT MASK
BIT	LDAX	B	;GET BIT MAP VALUE
	ANA	E	;ISOLATE BIT
	MVI	A,'0'	;GET 'NO BIT' VALUE
	JZ	ZERO
	INR	A	;MAKE '0' INTO '1'
ZERO	CALL	TYPE
	MOV	A,E	;GET MASK
	RRC		;SHIFT RIGHT
	MOV	E,A	;MOVE MASK BACK
	JC	END	100H

SELDSK	EQU	VECTRS+27
SETTRK	EQU	VECTRS+30
SETSEC	EQU	VECTRS+33
SETDMA	EQU	VECTRS+36
READ	EQU	VECTRS+39
WRITE	EQU	VECTRS+42
GETVEC:	LXI	D,WBOOTE
	LHLD	1
	MVI	B,42
GETVE1:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	GETVE1
;
BEGIN:	XRA	A
	STA	YSCORE
	STA	RSCORE
ENTER:	LHLD	6
	DCX	H
	SPHL
	CALL	CLEAR
	CALL	SCORE
;
	LXI	H,MS2
	LXI	B,MNAME
	CALL	MSGO
;
DIFF:	LXI	H,MS1
	LXI	B,MDIFF
	CALL	MSGO
	CALL	INP
	ANI	0FH
	STA	DFST
START:	CALL	CLEAR
	CALL	SCORE
	MVI	D,DCORN
	MVI	E,ECORNMIT
	JC	LOOP1
	CALL	PLOT
	MOV	A,L
	ANI	0FEH
	MOV	L,A
	MVI	M,'X'
	DCR	B
	JNZ	LOOP1
;
ROSE:	LXI	H,RCORN
	MVI	M,'T'
	LXI	H,RCORN+4
	MVI	M,'Y'
	LXI	H,RCORN+8
	MVI	M,'U'
	LXI	H,RCORN+42H
	MVI	M,5CH
	LXI	H,RCORN+44H
	MVI	M,5EH
	LXI	H,RCORN+46H
	MVI	M,2FH
	LXI	H,RCORN+80H
	MVI	M,'G'
	LXI	H,RCORN+82H
	MVI	M,0DH
	LXI	H,RCORN+84H
	MVI	M,'H'
	LXI	H,RCORN+86H
	MVI	M,09H
	LXI	H,RCORN+88H
	MVI	M,'J'
	LXI	H,RCORN+0C2H
	MVI	M,2FH
	LXI	H,RCORN+0C4H
	MVI	M,0BH
	LXI	H,RCORN+0C6H
	MVI	M,5CH
	MOV	A,M
	CPI	' '
	JNZ	YOU
	MVI	M,0FH
	SHLD	YOUP
	RET
;
YMOVE:	CALL	NEAR
YMOV1:	CALL	INP
	LHLD	YOUP
	MVI	M,' '
	CPI	'J'
	CZ	RT
	CPI	'U'
	CZ	UR
	CPI	'Y'
	CZ	UP
	CPI	'T'
	CZ	UL
	CPI	'G'
	CZ	LF
	CPI	'B'
	CZ	LL
	CPI	'N'
	CZ	DN
	CPI	'M'
	CZ	LR
	CPI	'P'
	CZ	PANIC
	CPI	'H'
	JZ	Y1
	MOV	A,M
	CPI	' '
	JNZ	DEATH
Y1:	MVI	M,0FH
	SHLD	YOUP
	CALL	RMOVE
	CALL	END0
	JMP	YMOVE
;
INP:	CALL	CI
	ANI	7FH
	CPI	0DH
	JZ	ENTER
	CPI	1BH
	JZ	BEGIN
	RET
;
RMOVE:	LHLD	ROB1
	CALL	RDEAD
	JC	RMOV1
	CALL	SEEK
	SHLD	ROB1
RMOV1:	LHLD	ROB2
	CALL	RDEAD
	JC	RMOV2
	CALL	SEEK
	SHLD	ROB2
RMOV2:	LHLD	ROB3
	CALL	RDEAD
	JC	RMOV3
	CALL	SEEK
	SHLD	ROB3
RMOV3:	LHLD	ROB4
	CALL	RDEAD
	JC	RMOV4
	CALL	SEEK
	SHLD	ROB4
RMOV4:	LHLD	ROB5
	CALL	RDEAD
	RC
	CALL	SEEK
	SHLD	ROB5
	RET
;
RDEAD:	MOV	A,M
	CPI	'X'
	STC
	RZ
	CMC
	RET
;
CHEK:	MOV	A,M
	CPI	0FH
	JZ	DEATH
	CPI	'X'
	JZ	FLASH
	MVI	M,7
	RET
FLASH:	MVI	D,0A0H
FLAS1:	MVI	M,4
	MVI	E,0FFH
FLAS2:	DCR	E
	JNZ	FLAS2
	MVI	E,0FFH

;
DECH:	RZ
	JP	RT
	JMP	LF
;
DEATH:	MVI	M,0CH
	CALL	MSG2
	LDA	RSCORE
	INR	A
	STA	RSCORE
	CALL	SCORE
	CALL	OVER
	CALL	WAIT
	JMP	START
;
PANIC:	PUSH	PSW
	LDA	DFST
	CPI	9
	JNZ	PAN3
	MVI	C,7
	CALL	RND
	ANA	C
	CPI	1
	JZ	PAN5
	JMP	PAN4
;
PAN5:	PUSH	H
	LHLD	ROB1
	MVI	M,7
	LHLD	ROB2
	MVI	M,7
	LHLD	ROB3
	MVI	M,7
	POP	H
	JMP	PANN
PAN3:	LDA	DFST
	SBI	3
	JP	PAN1
	MVI	C,1
	JMP	PANOK
PAN1:	LDA	DFST
	SBI	6
	MVI	C,3
	JP	PAN2
	JMP	PANOK
PAN2:	MVI	C,7
PANOK:	CALL	RND
	ANA	C
	CB3
	CALL	MSGO
END3:	CALL	WAIT
	JMP	BEGIN
;
UP:	LXI	D,0FFC0H
	DAD	D
	RET
DN:	LXI	D,40H
	DAD	D
	RET
LF:	DCX	H
	DCX	H
	RET
RT:	INX	H
	INX	H
	RET
UR:	CALL	UP
	JMP	RT
UL:	CALL	UP
	JMP	LF
LL:	CALL	DN
	JMP	LF
LR:	CALL	DN
	JMP	RT
;
PLOT:	LXI	H,0CC00H
	PUSH	B
VERT:	MOV	A,D
	ANI	0FH
LP1:	MVI	B,40H
LP2:	JZ	HORIZ
	INX	H
	DCR	B
	JNZ	LP2
	DCR	A
	JNZ	LP1
HORIZ:	MOV	A,E
	ANI	7FH
LP3:	JZ	DONE
	INX	H
	DCR	A
	JMP	LP3
DONE:	POP	B
	RET
;
LIMIT:	MOV	A,D
	SBI	LOWD
	STC
	RM
	MOV	A,ROB4
	MOV	A,M
	CPI	7
	RZ
	LHLD	ROB5
	MOV	A,M
	CPI	7
	RZ
	JMP	WIN
;
NEAR:	LHLD	YOUP
	CALL	RT
	CALL	NEAR2
	CALL	UP
	CALL	NEAR2
	CALL	LF
	CALL	NEAR2
	CALL	LF
	CALL	NEAR2
	CALL	LF
	CALL	NEAR2
	CALL	DN
	CALL	NEAR2
	CALL	RT
	CALL	NEAR2
	CALL	RT
	CALL	NEAR2
	CALL	MCLEAR
NEAR3:	RET
;
NEAR2:	MOV	A,M
	CPI	7
	RNZ
	CALL	MSG1
	POP	H
	JMP	NEAR3
;
CLEAR:	LXI	H,0CC00H
	MVI	M,' '
	INX	H
	MOV	A,H
	CPI	0D0H
	JNZ	CLEAR+3
	XRA	A
	OUT	0C8H
	RET
;
MSG1:	PUSH	H
	PUSH	B
	LXI	H,MS1
		INX	H
	DCR	C
	JNZ	MCL1
	POP	B
	POP	H
	RET
;
MSGO:	LDAX	B
	CPI	 0FFH
	RZ
	MOV	M,A
	INX	B
	INX	H
	JMP	MSGO
;
MSGQ:	LDAX	B
	CPI	0FFH
	RZ
	ORI	80H
	MOV	M,A
	INX	B
	INX	H
	JMP	MSGQ
;
;
;
MNAME:	DB	'* * * THE GAME OF CHASE * * *'
	DB	0FFH
M1:	DB	' CAUTION - ROBOT NEAR! '
	DB	0FFH
M2:	DB	' YOU HAVE BEEN DESTROYED! '
	DB	0FFH
MWIN:	DB	' CONGRATULATIONS - YOU HAVE WON! '
	DB	0FFH
MSR:	DB	'--SCORE--'
	DB	0FFH
MSR1:	DB	'YOU:'
	DB	0FFH
MSR2:	DB	'ROBOTS:'
	DB	0FFH
ENDB1:	DB	'THE 
	MVI	M,84H
FLAS3:	DCR	E
	JNZ	FLAS3
	DCR	D
	JNZ	FLAS1
	MVI	M,'X'
	XRA	A
	RET
;
SEEK:	MVI	M,' '
	PUSH	H
	CALL	SUBH
	POP	H
	CALL	DECH
	PUSH	H
	CALL	SUBV
	POP	H
	CALL	DECV
	JMP	CHEK
;
SUBV:	MOV	A,L
	ANI	0C0H
	MOV	L,A
	XCHG
	LHLD	YOUP
	MOV	A,L
	ANI	0C0H
	SUB	E
	MOV	C,A
	MOV	A,H
	SBB	D
	MOV	B,A
	RET
;
DECV:	RLC
	JC	UP
	MOV	A,C
	RRC
	JC	UP
	XRA	A
	ADD	B
	JNZ	DN
	ADD	C
	JNZ	DN
	RET
;
SUBH:	MOV	A,L
	ANI	3FH
	MOV	L,A
	XCHG
	LHLD	YOUP
	MOV	A,L
	ANI	3FH
	SUB	E
	RETPI	1
	JZ	PANN
PAN4:	POP	PSW
	RET
PANN:	CALL	YOU
	POP	PSW
	POP	PSW
	JMP	YMOVE
;
WAIT:	CALL	CI
	RET
;
OVER:	LDA	RSCORE
	CPI	09H
	JZ	END1
OVER1:	LDA	YSCORE
	CPI	09H
	RNZ
ENDGAME:	CALL	WAIT
	CALL	CLEAR
	LXI	H,ENDM1
	LXI	B,ENDB2
	CALL	MSGO
	LDA	YSCORE
	ADI	30H
	STA	0CD27H
	LDA	RSCORE
	ADI	30H
	STA	0CD29H
	JMP	END2
END1:	CALL	WAIT
	CALL	CLEAR
	LXI	H,ENDM1
	LXI	B,ENDB1
	CALL	MSGO
	LDA	RSCORE
	ADI	30H
	STA	0CD27H
	LDA	YSCORE
	ADI	30H
	STA	0CD29H
END2:	LXI	H,ENDM3
	LXI	B,ENDD
	SBI	HID
	STC
	RP
	MOV	A,E
	SBI	LOWE
	STC
	RM
	MOV	A,E
	SBI	HIE
	STC
	RP
	CMC
	RET
;
RND:	PUSH	B
	PUSH	H
	LXI	H,SH+3
	MVI	B,8
	MOV	A,M
RTOP:	RLC
	RLC
	RLC
	XRA	M
	RAL
	RAL
	DCR	L
	DCR	L
	DCR	L
	MOV	A,M
	RAL
	MOV	M,A
	INR	L
	MOV	A,M
	RAL
	MOV	M,A
	INR	L
	MOV	A,M
	RAL
	MOV	M,A
	INR	L
	MOV	M,A
	RAL
	MOV	M,A
	DCR	B
	JNZ	RTOP
	POP	H
	POP	B
	RET
;
END0:	LHLD	ROB1
	MOV	A,M
	CPI	7
	RZ
	LHLD	ROB2
	MOV	A,M
	CPI	7
	RZ
	LHLD	ROB3
	MOV	A,M
	CPI	7
	RZ
	LHLD	LXI	B,M1
	CALL	MSGQ
	POP	B
	POP	H
	RET
;
MSG2:	LXI	H,MS1
	LXI	B,M2
	CALL	MSGQ
	RET
;
WIN:	LXI	H,MS1
	LXI	B,MWIN
	CALL	MSGQ
	LDA	YSCORE
	INR	A
	STA	YSCORE
	CALL	SCORE
	CALL	OVER
	CALL	WAIT
	JMP	START
;
SCORE:	LXI	H,SRE
	LXI	B,MSR
	CALL	MSGO
	LDA	YSCORE
	ADI	30H
	LXI	H,SCR
	MOV	M,A
	LDA	RSCORE
	ADI	30H
	LXI	D,40H
	DAD	D
	MOV	M,A
	LXI	H,MSY
	LXI	B,MSR1
	CALL	MSGO
	LXI	H,MT1
	LXI	B,MSR2
	CALL	MSGO
	RET
;
MCLEAR:	PUSH	H
	PUSH	B
	LXI	H,MS1
	MVI	C,20H
MCL1:	MVI	M,' '
ROBOTS HAVE WON -   :'
	DB	0FFH
ENDB2:	DB	'YOU HAVE BEATEN THEM -  :'
	DB	0FFH
ENDB3:	DB	'HIT ANY KEY TO PLAY AGAIN.....'
	DB	0FFH
MDIFF:	DB	' LEVEL OF DIFFICULTY (0-9)?'
	DB	0FFH
;
;
RDA	EQU	1
RCORN	EQU	0CCF6H
DCORN	EQU	0
ECORN	EQU	2
HEIGHT	EQU	0DH
WIDTH	EQU	19H
LOWD	EQU	DCORN+1
LOWE	EQU	ECORN+1
HID	EQU	DCORN+HEIGHT-1
HIE	EQU	LOWE+WIDTH+WIDTH-4
MS1	EQU	0CFCCH
MS2	EQU	0CD10H
SCR	EQU	0CFBDH
SRE	EQU	0CF77H
MSY	EQU	0CFB8H
MT1	EQU	0CFF5H
ENDM1	EQU	0CD10H
ENDM3	EQU	0CD90H
SH:	DW	1234H
	DW	5678H
DFST:	DB	1
RSCORE	DS	1
YSCORE	DS	1
YOUP	DS	2
ROB1	DS	2
ROB2	DS	2
ROB3	DS	2
ROB4	DS	2
ROB5	DS	2
END
	TITLE	'EDIT - SUPER EDITOR FOR CP/M'
;
        ORG 0100H
;
DFCB1	EQU	5CH	;FIRST DEFAULT FCB
DFCB2	EQU	6CH	;SECOND DEFAULT FCB
;
	XRA	A		;CLEAR FLAGS
	STA	SWFLG
	STA	EOFFLG
	LXI	SP,STACK	;SET UP A STACK
	LHLD	1
	LXI	B,3	;SET UP CONSOLE VECTORS
	DAD	B
	SHLD	CSTS1		;STATUS VECTOR
	INX	H	
	INX	H	
	INX	H	
	SHLD	CONIN1		;CONSOLE INPUT VECTOR
	LXI	H,DFCB1+1	;MAKE SURE THERE'S A FILENAME
	MOV	A,M
	CPI	020H	
	JNZ	HAVNAM	
	MVI	C,9	;OTHERWISE, DIE WITH ERROR
	LXI	D,NSFMSG
	CALL	5
	RST	0	
HANAM		;TO OUR OUTPUT FCB
	LXI	D,OFCB	;CREATE THE OUTPUT FILE
	CALL	MAKFIL	
	JMP	MAIN		;NOW GO EDIT IT
CONIN:
	CALL	0	;CONSOLE INPUT
CONIN1	EQU	$-2	;WHERE TO DROP IN THE ADDRESS
	ANI	07FH		;STRIP PARITY BIT
	RET		
CONOUT:
	PUSH	B		;CONSOLE OUTPUT
	PUSH	D		;SAVE ALL REGS
	PUSH	H	
	MOV	E,C		;THEN CALL CP/M
	MVI	C,2
	CALL	5
	POP	H		;RESTORE REGS
	POP	D	
	POP	B	
	RET		
CSTS:
	JMP	0	;CONSOLE STATUS (BREAK TEST)
CSTS1	EQU	$-2	;WHERE TO DROP IN THE ADDRESS
GETTOP:
	PUSH	H		;DETERMINE TOP OF U  NEXT BYTE
	DAD	B
	MOV	A,M	;FETCH THE BYTE
	CPI	01AH	;MAKE SURE IT'S NOT EOF
	JNZ	L01B6	
L01B3:
	STA	EOFFLG	;WE READ AN EOF, SO SET THE FLAG
L01B6:
	ANI	07FH		;STRIP THE PARITY BIT
	POP	H		;RESTORE REGS
	POP	D	
	POP	B	
	RET			;AND EXIT
READF:
	LXI	H,INFCNT	;COME HERE TO READ NEXT BUFFER
	MVI	M,0FFH	;FIRST RIG THE COUNT SO NEXT INR WILL
	LXI	D,INBUF	;  GIVE US BYTE ZERO
	MVI	C,01AH	;ISSUE 'SET DMA ADDRESS' CALL TO CP/M
	CALL	5
	LXI	D,IFCB	;ISSUE 'READ' CALL TO CP/M
	MVI	C,014H
	CALL	5

	MOV	M,C		;AND STORE IN BUFFER
	MOV	A,C		;WAS IT AN EOF?
	CPI	01AH
	JNZ	L0218	
	MVI	A,RET	;WE WROTE AN EOF, SO DISABLE WRITE ROUTINE
	STA	PUTBYT		;BY MAKING FIRST INSTRUCTION 'RET'
	LXI	H,OUFCNT	;NOW FLUSH LAST OUTPUT BUFFER
	CALL	WRITEF	
	MVI	C,010H	;CLOSE THE OUTPUT FILE
	LXI	D,OFCB
	CALL	5
	LXI	H,IFCB1	;MOVE INPUT NAME TO SECOND HALF OF
	LDA	OFCB		;OUTPUT FCB, IN PREPARATION
	LXI	D,OFCBRN	;FOR RENAME OPERATION
	STAX	D
	INX	D
	LXI	B,0BH
	CALL	MOVE	
L0218:
	POP	B		;RESTORE REGISTERS ANDVNAM:
	LXI	D,IFCB	;MOVE FIRST FILENAME TO OUR INPUT FCB
	LXI	H,DFCB1
	LXI	B,0CH
	CALL	MOVE	
	LXI	D,IFCB	;TRY TO OPEN IT
	CALL	OPENF	
	INR	A	
	LDA	DFCB2
	JNZ	OPNDST	
	LXI	D,NEWMSG	;OPEN FAILED - SAY 'NEW FILE'
	MVI	C,9
	CALL	5
	LXI	H,DFCB1	;AND CREATE THE FILE
	LXI	D,OFCB
	LXI	B,0CH
	CALL	MOVE	
	LXI	H,SWFLG
	MVI	M,0FFH	;SET 'CREATE' FLAG
	INX	H	
	MVI	M,01AH	;SET 'END OF FILE' FLAG
	LDA	DFCB1
OPNDST:
	STA	OFCB		;SET DESTINATION DRIVE #
	LXI	D,OFCB1	;COPY NAME FROM FIRST FILE
	CALL	MOVSEABLE RAM
	LHLD	6	;BY LOOKING AT THE BDOS VECTOR
	DCX	H		;MINUS ONE
	MOV	B,H	
	MOV	A,L
	POP	H	
	RET		
GETBYT:
	LDA	EOFFLG	;READ A BYTE FROM THE INPUT FILE
	ORA	A		;FIRST CHECK END-OF-FILE
	MVI	A,01AH
	RNZ		
	PUSH	B		;NOW WE KNOW WE'VE GOT SOMETHING
	PUSH	D	
	PUSH	H	
GTBYT1:
	LXI	H,INFCNT	;CHECK BYTE COUNT IN BUFFER
	INR	M		;WILL SET MINUS IF AT END
	JM	READF		; WHICH SAYS TO READ SOME MORE
	MOV	C,M		;OTHERWISE, ADD COUNT TO BUFFER
	MVI	B,0	;	  ADDRESS, GIVING ADDRESS OF
	LXI	H,INBUF	;		DCR	A		;A=1 MEANS EOF
	JNZ	GTBYT1		;OTHERWISE, PROCESS BYTE
	MVI	A,01AH	;GOT EOF - SEND BACK EOF CHARACTER
	JMP	L01B3	
PUTBYT:
	PUSH	H		;WRITE A BYTE TO THE OUTPUT FILE
	PUSH	D	
	PUSH	B	
	LXI	H,OUFCNT	;BUMP OUTPUT BUFFER COUNT
	INR	M		;GOES NEGATIVE AFTER 128 BYTES
	CM	WRITEF		;  WHICH SAYS TO FLUSH BUFFER BEFORE CONTINUING
	MOV	C,M	
	MVI	B,0	;ADD BYTE COUNT TO BUFFER BASE ADDRESS
	LXI	H,OUTBUF	;GIVING ADDRESS OF NEXT BYTE
	DAD	B
	POP	B		;CHARACTER WAS IN C AT ENTRY
	PUSH	B		;SO REFRESH IT
 EXIT
	POP	D	
	POP	H	
	RET		
WRITEF:
	MVI	M,0	;COME HERE TO FLUSH OUTPUT BUFFER
	MVI	C,01AH	;  CLEAR BYTE COUNT
	LXI	D,OUTBUF	;ISSUE 'SET DMA ADDRESS' TO CP/M
	CALL	5
	LXI	D,OFCB	;ISSUE 'WRITE' TO CP/M
	MVI	C,015H
	CALL	5
	LXI	H,OUFCNT	;POINT TO BYTE COUNT (PUTBYT NEEDS IT)
	CPI	2	;TEST FOR 'NO SPACE' ERROR (A=2)
	RNZ			;NO ERROR - RETURN
	LXI	D,NSPMSG	;SCREAM ABOUT ERROR
	MVI	C,9
	CALL	5
	LXI	D,OFCB	;CLOSE OUTPUT FILE (SAVE WHAT WE CAN)
	MVI	C,010H
	CALL	5
BYEBYE:
	LDA	SWFLG	;EXIT FROM EDITOR - FIRST CHECK CREATE FLAG
	ORA	A	
	JNZ	0	;NO CREATE
	LXI	D,IFCB	;YES CREATE - WE MUST CLOSE IT
	MVI	C,010H
	CALL	5
	RST	0		;THEN EXIT
MAKFIL:	;PERFORM ALL STEPS OF CREATING A FILE
	PUSH	D		;MAKE AN OUTPUT FILE
	MVI	C,013H	;FIRST DELETE OLD ONE
	CALL	5
	POP	D	
	PUSH	D	
	MVI	C,016H	;THEN CREATE NEW ONE
	CALL	5
	POP	D		;FALL INTO OPEN ROUTINE
OPENF:
	MVI	C,0FH	;OPEN THE FILE WITH FCB AT (DE)
	JMP	5
MOVNAM:
	LXI	H,DFCB1+1	;COPY NAME FIELD ONLY
	LXI	B,8	;FROM FIRST DEFAULT FCB
MOVE0
INBUF:
	DS	128	;INPUT BUFFER (1 SECTOR LONG)
OUFCNT:
	DB	255	;BYTE COUNT IN OUTPUT BUFFER
OFCB:
	DB	0		;OUTPUT FILE CONTROL BLOCK
OFCB1:
	DS	8
	DB	'$$$'
	DB	0,0,0,0
OFCBRN:
	DS	16
	DB	0
OUTBUF:
	DS	128	;OUTPUT BUFFER (1 SECTOR)
SIGNON:
	DB	13,10,'SUPER CP/M EDITOR',13,10
ILGMSG:
	DB	'" ILLEGAL IN THIS CONTEXT',13,10
CNFMSG:
	DB	13,10,'CANNOT FIND "'
ISFMSG:
	DB	13,10,'ITERATION STACK FAULT'
BRKMSG:
	DB	13,10,'*BREAK*',13,10
CRLF:
	MVI	C,0DH	;PRINT CARRIAGE RETURN, LINE FEED
	CA
	MOV	A,C		;LOOK AGAIN AT CHARACTER TO PRINT
	SUI	0DH		;CARRIAGE RETURN?
	JNZ	PCHAR2	
	STA	LINPOS	;IF CARRIAGE RETURN, CLEAR COLUMN COUNT
PCHAR2:
	PUSH	B		;SAVE CHARACTER
	CALL	CONOUT		;PRINT IT
	POP	B		;GET IT BACK
	MOV	A,C	
	CPI	020H		;IF CONTROL CHARACTER, DON'T
	JC	PCHAR3		;  INCREMENT COLUMN COUNTER
	LDA	LINPOS
	INR	A	
	STA	LINPOS
PCHAR3:
	DCR	B	;NOW TEST REPEAT COUNT (0 UNLESS TAB)
	JP	PCHAR2		;PRINT AGAIN IF NECESSARY
	POP	H		;RESTORE REGS
	POP	D	
	RET			;AND EXIT
CPHLDE:
	MOV	A,OINTER -> DE
	LHLD	MAXMEM		;TOP OF RAM -> HL
	DCX	H		;BACK OFF BY 1 BYTE
	SHLD	CMDFPT		;CMDFPT WILL NOW POINT TO SECOND CHAR OF COMMAND
	PUSH	H		;SAVE IT
	LXI	H,CMDPTR	;GET POINTER TO END OF COMMAND
	MOV	A,E		;SUBTRACT FORWARD POINTER TO
	SUB	M	;	   GET LENGTH OF COMMAND STRING
	INX	H	
	MOV	C,A	
	MOV	A,D	
	SBB	M
	MOV	B,A	
	JC	INCCDN		;IF LENGTH GOES NEGATIVE, QUIT
	INX	B	;NOW WE KNOW WE REALLY HAVE SOMETHING LEFT
	XCHG			;OLD FWD PNTR -> HL
	POP	D		;NEW FWD PNTR -> DE
CMDMOV:
	MOV	A,M	;PACLEVE
GETCML:
	CALL	CONIN		;LOOP, FETCHING CMD CHARS
	STA	CURCHR	;SAVE AS CURRENT CHARACTER
	ORA	A		;BREAK?
	JZ	BREAK	
	LHLD	MAXMEM		;TOP OF RAM -> DE
	XCHG		
	LHLD	CMDPTR		;CMD STACK PTR -> HL
	CPI	012H	;CONTROL-R?
	JNZ	RUBOUT	
	CALL	CRLF		;CONTROL-R MEANS RE-ECHO BUFFER
	CALL	CPHLDE		;MAKE SURE THERE'S WHAT TO ECHO
	JZ	GETCMD	
CNTLR:
	CALL	CPHLDE		;DONE YET?
	JZ	GETCML	
	DCX	D	;NO, FETCH NEXT CHARACTER
	LDAX	D
	CPI	01BH	;CHANGE ESCAPE TO DOLLAR SIGN
	JNZ	RNOTES	
	MVI	A,'$'
RNOTES:
	M:
	DCX	B	;MOVE M(HL) TO M(DE) UNTIL BC=0
	INR	C
	INR	B
MOVELP:
	MOV	A,M
	STAX	D
	INX	H	
	INX	D
	DCR	C
	JNZ	MOVELP	
	DCR	B
	JNZ	MOVELP	
	RET		
FILL:
	MOV	M,B		;FILL M(HL) WITH (B)
	INX	H	
	DCR	C	;UNTIL C=0
	JNZ	FILL	
	RET		
NEWMSG:
	DB	13,10,'NEW FILE$'
NSPMSG:
	DB	13,10,'NO MORE DISK SPACE$'
NSFMSG:
	DB	13,10,'NO SOURCE FILE SPECIFIED$'
INFCNT:
	DB	7FH	;BYTE COUNT IN INPUT BUFFER
IFCB:
	DB	0		;INPUT FILE CONTROL BLOCK
IFCB1:
	DS	8
	DB	'ASM'
	DB	0,0,0,0
IFCBRN:
	DS	16
	DB	LL	PCHAR	
	MVI	C,0AH
PCHAR:
	PUSH	D		;PRINT A CHARACTER
	PUSH	H		;WITH FULL FORMATTING
	MOV	A,C		;(EXPAND TABS AND CTRL CHARS)
	SUI	9	
	JNZ	PCHAR1		;IF A TAB, WRITE SPACE INSTEAD
	MVI	C,020H
PCHAR1:
	SUI	1		;GIVES FF & CARRY IF A TAB
	SBB	A	;GIVES FF IF TAB, ZERO OTHERWISE
	MOV	B,A		;SAVE FOR LATER
	LDA	LINPOS	;CHECK CURRENT COLUMN NUMBER
	ANI	7		;LOW 3 BITS ONLY
	CMA			;DERIVE SPACES TO NEXT TAB STOP
	ADI	8	
	ANA	B		;MASK WITH FLAG, (ZERO IF NO TAB)
	MOV	B,A		;SAVE RESULT AS REPEAT COUNT
H		;COMPARE (HL)::(DE)
	SUB	D
	RNZ		
	MOV	A,L
	SUB	E
	RET		
MESSBC:
	MOV	H,B		;PRINT MESSAGE AT M(BC)
	MOV	L,C		; FOR LENGTH (DE)
MESSHL:
	MOV	C,M	
	INX	H	
	CALL	PCHAR	
	CALL	BRKCHK	
	MOV	A,D	
	ORA	E	
	RZ		
	DCX	D
	JMP	MESSHL	
BRKCHK:
	CALL	CSTS		;TEST FOR BREAK CHARACTER
	ORA	A	
	RZ		
	CALL	CONIN	
	ORA	A	
	RNZ		
	JMP	BREAK	
INCCMD:
	LDA	ITRLVL	;MOVE COMMAND POINTER TO NEXT COMMAND
	ORA	A		;ONLY IF NO ITERATIONS ARE
	RNZ			;IN PROGRESS
	LHLD	CMDFPT	
	XCHG			;COMMAND FORWARD PK DOWN USED-UP PARTS OF COMMAND
	STAX	D	; TO MAKE MORE ROOM FOR TEXT
	DCX	H	
	DCX	D
	DCX	B
	MOV	A,B	
	ORA	C	
	JNZ	CMDMOV	
	PUSH	D		;DE IS NOW NEW END POINTER
INCCDN:
	POP	H		;GET END POINTER
	INX	H	
	SHLD	CMDPTR		;AND SAVE IT
	RET		
GETCMD:
	MVI	C,'*'	;PROMPT FOR A COMMAND STRING
	CALL	PCHAR	
	LHLD	MAXMEM		;STORED UPSIDE DOWN
	SHLD	CMDPTR		; SO THAT COMMAND BUFFER
	DCX	H		; GROWS TOWARDS TEXT BUFFER
	SHLD	CMDFPT	
	XRA	A	
	STA	PRVCHR
	STA	ITRLVL	;CLEAR PREVIOUS CHARACTER AND ITERATION OV	C,A		;PRINT CHARACTER
	CALL	PCHAR	
	JMP	CNTLR		;AND GET SOME MORE
RUBOUT:
	CPI	07FH	;WAS A RUBOUT TYPED?
	JNZ	STCMCH	
	CALL	CPHLDE		;TEST FOR EMPTY BUFFER
	JZ	CMDOVR	
	MOV	A,M	;GET LAST COMMAND CHARACTER
	CPI	01BH	;CONVERT ESCAPE TO DOLLAR SIGN
	JNZ	DELNES	
	MVI	A,'$'
DELNES:
	MOV	C,A		;PRINT THE CHARACTER
	CALL	PCHAR	
	XRA	A		;CLEAR 'PREVIOUS CHAR' FLAG
	STA	PRVCHR
	LHLD	CMDPTR		;BACK UP COMMAND POINTER
	INX	H		;  TO ACCOUNT FOR DELETED CHAR
	SHLD	CMDPTR	
	JMP	GETCML		;LOOP BACK FOR NEXT INPUT
CMDOVR:
	CALL	CRLF		;DELETED PAST BEGINNING - SEND CRLF
	JMP	GETCMD		;AND RE-PROMPT
STCMCH:
	LHLD	CMDPTR		;HERE TO STORE COMMAND CHAR
	LXI	D,-20	;MAKE SURE THERE'S ROOM
	DAD	D
	XCHG		
	LHLD	TXTTOP	
	CALL	CPHLDE	
	JC	HVROOM	
	MVI	C,7	;NO RAM LEFT - PRINT A BELL
	CALL	PCHAR	
	JMP	GETCML		;AND HOPE NEXT CHAR IS RUBOUT
HVROOM:
	LDA	CURCHR	;GET CURRENT CHARACTER
	CPI	0DH	;TEST FOR CARRIAGE RETURN
	JNZ	CHKALT	
	LHLD	CMDPTR		;STORE CARRIAGE RETURN
	DCX	H	
	SHLD	CMDPTR	
	MVI	C,0DH
S ESCAPE, WHAT WAS PREVIOUS?
	JNZ	SETPRV	
	LDA	PRVCHR	;IF PREV WAS ALSO ESCAPE, SEND CRLF
	CPI	01BH	;AND RETURN
	JZ	CRLF	
SETPRV:
	MOV	A,M	;MAKE CURRENT CHARACTER PREVIOUS CHAR
	STA	PRVCHR
	JMP	GETCML		;AND GO GET SOME MORE
GETCDC:
	LHLD	CMDPTR		;FETCH NEXT CHARACTER FROM COMMAND STRING
	XCHG			;END OF COMMAND -> DE
	LHLD	CMDFPT		;CURRENT POINTER -> HL
	CALL	CPHLDE		;COMMAND EXHAUSTED?
	CC	GETCMD		;READ ANOTHER COMMAND IF NEEDED
	LXI	H,CHRTYP	;INITIALIZE CHARACTER TYPE TO 'OTHER'
	MVI	M,2
	VI	M,0FFH
	CALL	GETCDC		;AND GET NEXT CHAR
	STA	CURCMC		;INTO 'CURRENT CMD CHAR'
	JMP	CNVNUM	
CKPLUS:
	CPI	'+'		;SWALLOW A PLUS SIGN IF PRESENT
	JNZ	CNVNUM	
	CALL	GETCDC	
	STA	CURCMC	
CNVNUM:
	LXI	H,0
CNVLUP:
	LDA	CHRTYP		;TEST FOR NUMERIC
	CPI	1
	JNZ	CNVDON		;QUIT IF NOT NUMERIC
	MOV	D,H		;MULTIPLY HL BY 10
	MOV	E,L	
	DAD	H	
	DAD	H	
	DAD	D
	DAD	H	
	LDA	CURCMC		;CONVERT DIGIT TO NUMBER
	SUI	'0'	
	MOV	E,A		;AND ADD IT TO HL
	MVI	D,0
	DAD	D
	PUSH	H		;BUMP TO NEXT CMD CHAR
	CALL	GETC		;IF EMPTY, QUIT
	XCHG			;END OF TEXT -> DE
	LHLD	TXTPTR		;CURRENT POSN -> HL
	MOV	A,B		;ITRCNT=0 MEANS BACKWARD SKIP
	ORA	C	
	INX	B	;ANYWAY, WE ALWAYS WANT ITRCNT+1
	JZ	SKPBAK		;TO ACCOUNT FOR CURRENT LINE
	LDA	MINUS		;ITRCNT#0, SO CHECK SIGN FLAG
	RRC	
	JNC	SKPFWD		;TO DECIDE WHICH WAY TO SKIP
SKPBAK:
	INX	B	;BACKWARD SKIP - ITRCNT+2 -> BC
	CALL	CPHLDE		;ARE WE AT END OF TEXT?
	JNZ	SKPBA1	
	LXI	D,TXTBUF	;IS END ALSO BEGINNING?
	CALL	CPHLDE	
	JZ	SKPBA1		;IF SO, BACK OFF SO WE FIND EOF
	DC	MVI	D,0FFH	;HERE TO SKIP FORWARD - SEARCH FOR END OF BUFFER
	MVI	E,0AH	;OR LINEFEED
SKPFW1:
	DCX	B	;DECREMENT ITERATION COUNT
	MOV	A,B		;DONE YET?
	ORA	C	
	RZ		
SKPFW2:
	MOV	A,M	;TEST NEXT CHARACTER
	CMP	D		;END OF BUFFER?
	RZ		
	CMP	E		;LINEFEED
	INX	H		;BUMP POINTER
	JNZ	SKPFW2		;TRY NEXT IF NO MATCH
	JMP	SKPFW1		;CHECK ITERATION COUNT IF MATCH
SEARCH:
	LXI	H,TARGLN	;SEARCH FOR A CHARACTER STRING
	MVI	M,0	;SET TARGET STRING LENGTH TO ZERO
GTARGT:
	LXI	B,TARGST	;COPY STRING FROM COMMAND	MOV	M,C		;IN COMMAND BUFFER
	CALL	PCHAR		;ECHO IT
	MVI	A,0AH	;ECHO AND STORE A LINEFEED BEHIND IT
CHKALT:
	CPI	07DH	;CONVERT ALTMODE TO ESCAPE
	JNZ	NOALT	
	MVI	A,01BH
NOALT:
	STA	CURCHR	;SAVE CURRENT CHAR
	CPI	01BH	;IS IT AN ESCAPE?
	MOV	C,A		;IF ESCAPE, ECHO '$' INSTEAD
	JNZ	ECHOCM	
	MVI	C,'$'
ECHOCM:
	CALL	PCHAR		;ECHO THE COMMAND CHARACTER
	LHLD	CMDPTR		;BUMP COMMAND STACK POINTR
	DCX	H	
	SHLD	CMDPTR	
	LDA	CURCHR	;STORE CURRENT CHAR IN COMMAND BUFFER
	MOV	M,A	
	CPI	01BH	;IF CURRENT ILHLD	CMDFPT	
	MOV	A,M	;GET COMMAND CHARACTER
	CPI	'A'	
	JC	GETCD1		;SET FLAG FOR ALPHA OR NUMERIC
	CPI	'Z'+1		;IF ALPHABETIC, CHRTYP=0
	JNC	GETCDN	
	LXI	H,CHRTYP
	MVI	M,0
GETCD1:
	CPI	'0'		;IF NUMERIC, CHRTYP=1
	JC	GETCDN	
	CPI	'9'+1	
	JNC	GETCDN	
	LXI	H,CHRTYP
	MVI	M,1
GETCDN:
	LHLD	CMDFPT		;ADVANCE COMMAND FORWARD PNTR
	DCX	H	
	SHLD	CMDFPT	
	RET		
GETNUM:
	LDA	CURCMC		;PARSE A NUMBER FROM THE COMMAND
	CPI	'-'		; STRING
	JNZ	CKPLUS		;SET MINUS FLAG IF WE SEE A MINUS
	LXI	H,MINUS
	MDC	
	POP	H	
	STA	CURCMC		;MAKE IT CURRENT
	JMP	CNVLUP		;AND GO CONVERT IT
CNVDON:
	SHLD	ITRCNT		;COMPLETED NUMBER BECOMES ITERATION COUNT
	LDA	MINUS		;MINUS ZERO BECOMES MINUS ONE
	RRC	
	RNC		
	MOV	A,H	
	ORA	L	
	RNZ		
	INX	H	
	SHLD	ITRCNT	
	RET			;DONE
SKPLIN:
	LHLD	ITRCNT		;SKIP FORWARD OR BACKWARD
	MOV	B,H		; (ITRCNT) LINES
	MOV	C,L		;(ITRCNT) -> BC
	LHLD	TXTTOP		;END OF TEXT -> HL
	MVI	A,TXTBUF AND 255	;END=BEG? (BUFF EMPTY)
	SUB	L
	MOV	D,A	
	MVI	A,TXTBUF/256
	SBB	H
	ORA	D	
	RZ	X	H		;  ON FIRST TEST
SKPBA1:
	MVI	D,0FFH	;SEARCH FOR EITHER FF (END OF TEXT)
	MVI	E,0AH	;OR LINEFEED
SKPBA2:
	DCX	B	;DECREMENT ITERATION COUNT
	MOV	A,B		;DONE YET?
	ORA	C	
	JZ	SKPBA4		;YUP
SKPBA3:
	MOV	A,M	;TEST NEXT CHARACTER
	CMP	D		;END OF BUFFER?
	JZ	SKPBDN	
	CMP	E		;LINEFEED?
	DCX	H	
	JNZ	SKPBA3		;BUMP POINTER AND TRY AGAIN
	JMP	SKPBA2		;FOUND ONE, MORE ITERATIONS?
SKPBA4:
	INX	H		;FOUND RIGHT NUMBER OF LF'S - 
SKPBDN:
	INX	H		;CORRECT POINTER TO BE AFTER LAST LF
	RET		
SKPFWD:
 BUFFER
	LHLD	TARGLN		;INTO TARGET BUFFER AND UPDATE
	DAD	B	;	  TARGET LENGTH
	PUSH	H	
	CALL	GETCDC	
	POP	H	
	MOV	M,A	
	SUI	01BH		;END COPY ON AN ESCAPE CHAR
	JZ	DOSEAR		;AND GO DO THE SEARCH
	LXI	H,TARGLN
	MOV	A,M
	SUI	020H		;TARGET BUFFER OVERFLOW?
	JNC	GTARGT		;NO
	INR	M		;IF YES, IGNORE EXTRA CHARS
	JMP	GTARGT	
DOSEAR:
	LHLD	TXTPTR		;ACTUALLY PERFORM THE SEARCH
	XCHG			;TEXT POINTER -> DE
	DCX	D	;BACK OFF ONE TO ACCOUNT FOR ALGORITHM
SEARL1:
	LXI	H,TARGST	;RESET TARGET STRING POINTER
SEARL2:
	INX	D	;FETCH CHARACTER FROM TEXT BUFFER
	LDAX	D
	CPI	0FFH	;END OF BUFFER?
	JZ	SEARER		;IF END, GIVE NOTICE
	CMP	M		;COMPARE BUFFER TO TARGET
	JNZ	SEARL2		;NO MATCH, TRY NEXT
	MOV	B,D		;MATCHED FIRST CHAR, SAVE ITS POSN
	MOV	C,E	
SEARL3:
	INX	H		;SEE IF REST OF STRING MATCHES
	INX	D	;	  BUMP BOTH TARGET AND BUFFER
	LDAX	D	;FETCH NEXT FROM BUFFER
	CMP	M		;MATCH?
	JZ	SEARL3		;YUP, KEEP GOING
	MOV	A,M	;NO MATCH, BUT MAYBE IT'S A 'DONT CARE'
	CPI	07CH		;'OR BAR' IS DONT CARE CHAR
	JZ	GST
	MOV	E,A	
	DCR	E	;DECREMENT LENGTH TO AVOID TERMINATING ESCAPE
	MVI	D,0
	CALL	MESSBC	
ENDQUO:
	MVI	C,022H	;TERMINATING QUOTE AND CRLF
	CALL	CONOUT	
	CALL	CRLF	
	JMP	BREAK	
PACK:
	LHLD	SPLBEG		;PACK DOWN TEXT BUFFER AFTER
	XCHG			; A DELETE-TYPE OPERATION
	LHLD	TXTPTR		;BEG. OF SPLIT -> DE; CURR POS. -> HL
	MOV	A,E		;IF EQUAL, NO PACK REQUIRED
	SUB	L
	MOV	C,A	
	MOV	A,D	
	SBB	H
	ORA	C	
	RZ		
	LXI	H,SPLEND	;OTHERWISE, LENGTH OF SPLIT -> BC
	MOV	A,M
	SUB	E
	INX	H	
	MOV	C,A	
	MOV	A, COVERED ONE CHAR
	DCX	H		;SO JUST RESET END OF BUFFER
	SHLD	TXTTOP	
	MVI	M,0FFH	;AND MARK IT
	JMP	INCCMD		;AND GO PACK COMMAND BUFFER
MAIN:
	LXI	SP,STACK	;MAIN PROGRAM STARTS HERE
	LXI	B,SIGNON	;PRINT SIGNON MESSAGE
	LXI	D,014H
	CALL	MESSBC	
	CALL	GETTOP		;SET TOP OF RAM
	MOV	L,A	
	MOV	H,B	
	SHLD	MAXMEM	
	LXI	H,-1
	SHLD	FENCE	;MARK ENDS OF BUFFER
	LXI	H,TXTBUF
	SHLD	TXTPTR		;INITIALIZE CURRENT POINTER
	SHLD	TXTTOP		;AND END POINTER
CMDLUP:
	CALL	GETCMD		;GET FIRST COMMAND STRING
FOREVR;GET NUMBER INTO ITRCNT
NOTNUM:
	LDA	CURCMC		;GET CURRENT CHARACTER
	CPI	'<'		;START OF ITERATION?
	LXI	H,ITRLVL	;PREPARE TO STACK AN ITERATION
	MVI	B,0
	JNZ	CPOP	
	INR	M		;INCREMENT ITERATION STACK COUNT
	MOV	C,M		;AND FETCH IT
	MVI	A,8	;STACK OVERFLOW? (8 LEVELS MAX.)
	CMP	M	
	JNC	PUSHIT	
	LXI	B,ISFMSG	;GIVE STACK FAULT MESSAGE
	LXI	D,016H
	CALL	MESSBC	
	JMP	BREAK		;AND FAKE A BREAK
PUSHIT:
	LHLD	CMDFPT		;PUT COMMAND FORWARD POINTER ONTO ITS STACK
	XCHG		
	LXI	H,ITRPST
	DAD	B
	DAD	B
NT=0?
	ORA	M	
	JZ	DRPSTK		;IF YES, DROP ITERATION STACKS
	LXI	H,ITRPST	;OTHERWISE, RESTORE COMMAND PTR
	DAD	B	;		FOR THIS LEVEL
	DAD	B
	MOV	E,M	
	INX	H	
	MOV	D,M	
	XCHG		
	SHLD	CMDFPT	
	RET		
DRPSTK:
	LXI	H,ITRLVL	;DECREMENT ITERATION LEVEL
	DCR	M	
	RET		
DISPAT:	;****COMMAND DISPATCHER***
	LDA	CHRTYP		;IF WE GET HERE WITH OTHER
	ORA	A		;THAN A LETTER, IT'S AN ERROR
	JNZ	CMDERR	
	LDA	CURCMC		;CONVERT LETTER TO DISPATCH
	SUI	'A'		;  TABLE INDEX
	MOV	L,A	
	MVI	H,0
	DAD	H	
	LXI	D,DSPTBSEARL3	
	CPI	01BH	;NEITHER MATCH NOR DONT CARE, BUT WE MAY BE DONE
	MOV	D,B		;PREPARE FOR RETRY BY RESTORING
	MOV	E,C		;BUFFER POINTER
	RZ			;LAST TARGET WAS ESCAPE: WE'RE DONE
	LDAX	D	;TEST FOR END OF BUFFER
	CPI	0FFH
	JZ	SEARER		;IF END, ERROR
	JMP	SEARL1		;ELSE RESTORE TARGET PTR AND CONTINUE
SEARER:
	STC			;NOT FOUND - SET CARRY FOR ERROR
	RET		
NOFIND:
	LXI	B,CNFMSG	;SAY 'CAN NOT FIND...'
	LXI	D,0EH
	CALL	MESSBC	
	LDA	TARGLN		;ECHO TARGET STRING AS WELL
	ORA	A	
	JZ	ENDQUO	
	LXI	B,TARM
	SBB	D
	MOV	B,A	
	JC	PACKDN		;IF SPLIT LENGTH=0, QUIT
	INX	B	;ADJUST LENGTH
	LHLD	SPLBEG		;START OF SPLIT -> DE
	XCHG		
	LHLD	TXTPTR		;CURRENT POINTER -> HL
PACKLP:
	LDAX	D	;PACK A CHAR FROM SPLIT
	MOV	M,A		;TOWARDS CURRENT POINTER
	INX	D	;BUMP POINTERS
	INX	H	
	DCX	B	;MORE TO PACK?
	MOV	A,B	
	ORA	C	
	JNZ	PACKLP	
	DCX	H		;SET END OF TEXT MARKER AT NEW END OF BUFFER
	MVI	M,0FFH
	SHLD	TXTTOP		;STORE NEW END VALUE
	JMP	INCCMD		;GO REPACK COMMAND BUFFER
PACKDN:
	LHLD	TXTTOP		;DELETE ONLY:
	CALL	NXTCMD		;PROCESS COMMANDS FOREVER
	JMP	FOREVR	
NXTCMD:
	LHLD	TXTPTR		;MAKE SPLIT POINTERS MATCH
	SHLD	SPLBEG		;ACTUAL BUFFER POINTERS
	LHLD	TXTTOP	
	SHLD	SPLEND	
	LXI	H,MINUS	;CLEAR MINUS FLAG
	MVI	M,0
	LXI	H,1	;DEFAULT TO ONE ITERATION
	SHLD	ITRCNT	
	CALL	GETCDC		;GET NEXT CHAR FROM COMMAND STRING
	STA	CURCMC		;SAVE IT
	CPI	'-'		;IF + OR -,
	JZ	CPUSH		;  THEN GET A NUMBER
	CPI	'+'	
	JZ	CPUSH	
	LDA	CHRTYP		;IF NUMERIC, ALSO GET A NUMBER
	CPI	1
	JNZ	NOTNUM	
CPUSH:
	CALL	GETNUM			MOV	M,E	
	INX	H	
	MOV	M,D	
	LHLD	ITRCNT		;PUT ITERATION COUNT ONTO ITS STACK
	XCHG		
	LXI	H,ITRCST
	DAD	B
	DAD	B
	MOV	M,E	
	INX	H	
	MOV	M,D	
	RET			;GO BACK FOR NEXT COMMAND
CPOP:
	CPI	'>'		;END OF ITERATION?
	JNZ	DISPAT	
	MOV	C,M		;CHECK ITERATION LEVEL
	MOV	A,C	
	ORA	A		;IF ZERO, IGNORE
	JZ	DISPAT	
	LXI	H,ITRCST	;POINT TO ITERATION COUNT ON
	DAD	B	;	   CURRENT LEVEL
	DAD	B
	MOV	A,M
	SUI	1		;DECREMENT IT
	MOV	M,A	
	INX	H	
	MOV	A,M
	SBI	0	
	MOV	M,A	
	DCX	H		;CURRENT LEVEL'S COUL	;INDEX TO RIGHT TABLE ENTRY
	DAD	D
	MOV	E,M	
	INX	H	
	MOV	D,M	
	XCHG		
	PCHL			;AND DISPATCH TO IT
ACMD:	;*****APPEND COMMAND*****
	LHLD	ITRCNT	
	MOV	B,H	
	MOV	C,L	
APPLIM:
	LHLD	CMDPTR	
	LXI	D,-40
	DAD	D
	XCHG		
	LHLD	TXTTOP	
APPEND:
	CALL	CPHLDE	
	JNC	FLGEND	
ACMLUP:
	CALL	GETBYT	
	ORA	A	
	JZ	ACMLUP	
	CPI	07FH
	JZ	ACMLUP	
	CPI	01AH
	JZ	FLGEND	
	MOV	M,A	
	INX	H	
	CPI	0AH
	JNZ	APPEND	
	DCX	B
	MOV	A,B	
	ORA	C	
	JNZ	APPEND	
FLGEND:
	SHLD	TXTTOP	
	MVI	M,0FFH
	RET		
BCMD:
	LXI	H,TXTBUF
	SHLD	TXTPTR	
	RET		
CCMD:
	CALL	MOVPTR	
	SHLD	TXTPTR	
	RET		
MOVPTR:
	LDA	MINUS	
	RRC	
	LHLD	TXTPTR	
	XCHG		
	LHLD	ITRCNT	
	JNC	CPLUS	
	MOV	A,E	
	SUB	L
	MOV	E,A	
	MOV	A,D	
	SBB	H
	MOV	D,A	
	LXI	H,TXTBUF
	CALL	CPHLDE	
	RNC		
	XCHG		
	RET		
CPLUS:
	DAD	D
	XCHG		
	LHLD	TXTTOP	
	CALL	CPHLDE	
	RC		
	XCHG		
	RET		
DCMD:
	CALL	MOVPTR	
	LDA	MINUS	
	RRC	
	XCHG		
	LXI	H,TXTPTR
	JC	DELSET	
	LXI	H,SPLBEG
DELSET:
	MOV	M,E	
	INX	H	
	MOV	M,D	
	JMP	PACK	
ECMDI	C,017H
	CALL	5
	LXI	D,OFCB
	MVI	C,017H
	CALL	5
	RST	0	
FCMD:
	CALL	SEARCH	
	JC	NOFIND	
FCMD1:
	LHLD	TARGLN	
	DAD	D
	SHLD	TXTPTR	
	RET		
ICMD:
	CALL	GETCDC	
	CPI	01BH
	JZ	PACK	
	LHLD	CMDFPT	
	INX	H	
	SHLD	CMDFPT	
ICMD1:
	CALL	INCCMD	
	LXI	B,-20
	LHLD	CMDPTR	
	DAD	B
	XCHG		
	LHLD	SPLEND	
	CALL	CPHLDE	
	JNC	BREAK	
	XCHG		
	PUSH	H	
	LXI	H,SPLBEG
	MOV	A,E	
	SUB	M
	MOV	C,A	
	INX	H	
	MOV	A,D	
	SBB	M
	MOV	B,A	
	POP	H	
	JC	L09CE	
	PUSH	D	
	PUSH	H	
	LHLD	CMDFPT	
	LXI	D,0OV	A,M
	CPI	01BH
	DCX	H	
	JZ	L09F1	
	STAX	D
	INX	D
	DCX	B
	MOV	A,B	
	ORA	C	
	JNZ	L09E1	
	MOV	A,M
L09F1:
	SHLD	CMDFPT	
	XCHG		
	SHLD	TXTPTR	
	CPI	01BH
	JNZ	ICMD1	
	CALL	INCCMD	
	JMP	PACK	
KCMD:
	CALL	SKPLIN	
	SHLD	SPLBEG	
	XCHG		
	LHLD	TXTPTR	
	CALL	CPHLDE	
	JC	PACK	
	SHLD	SPLBEG	
	XCHG		
	SHLD	TXTPTR	
	JMP	PACK	
LCMD:
	CALL	SKPLIN	
	SHLD	TXTPTR	
	RET		
NCMD:
	CALL	SEARCH	
NCMD1:
	JNC	FCMD1	
	LXI	D,-120
	LHLD	CMDPTR	
	DAD	D
	XCHG		
	LHLD	TXTTOP	
	CALL	CPHLDE	
	JC	N	
	XCHG		
	JNC	TCMD1	
	LHLD	TXTPTR	
	MOV	A,D	
	CMA		
	MOV	D,A	
	MOV	A,E	
	CMA		
	MOV	E,A	
	INX	D
TCMD1:
	MOV	B,H	
	MOV	C,L	
	MOV	A,D	
	ORA	E	
	DCX	D
	JNZ	MESSBC	
	RET		
WCMD:
	LXI	H,MINUS
	MVI	M,0
	LXI	H,TXTBUF
	SHLD	TXTPTR	
	CALL	SKPLIN	
	SHLD	SPLBEG	
	XCHG		
	LXI	H,TXTBUF
WCMDL:
	CALL	CPHLDE	
	JNC	PACK	
	MOV	C,M	
	INX	H	
	CALL	PUTBYT	
	JMP	WCMDL	
ZCMD:
	LHLD	TXTTOP	
	SHLD	TXTPTR	
	RET		
DSPTBL:
	DW	ACMD
	DW	BCMD
	DW	CCMD
	DW	DCMD
	DW	ECMD
	DW	FCMD
	DW	CMDERR
0
TXTPTR:
	DW	0
TXTTOP:
	DW	0
SPLBEG:
	DW	0
SPLEND:
	DW	0
CMDFPT:
	DW	0
MAXMEM:
	DW	0
CURCMC:
	DB	0	
CHRTYP:
	DB	0	
ITRCNT:
	DW	0
MINUS:
	DB	0
LINPOS:
	DS	1
SWFLG:
	DS	1
EOFFLG:
	DS	1
ITRLVL:
	DS	1
TARGST:
	DS	31
ITRPST:
	DS	16
ITRCST:
	DS	16
L0BC3:
	DS	2
CURCHR:
	DS	1
PRVCHR:
	DS	1
FENCE:
	DS	1
TXTBUF	EQU	$
        END

:
	LXI	H,TXTBUF
ECMLUP:
	MOV	A,M
	CPI	0FFH
	JZ	CPREST	
	MOV	C,A	
	CALL	PUTBYT	
	INX	H	
	JMP	ECMLUP	
CPREST:
	CALL	GETBYT	
	CPI	01AH
	MOV	C,A	
	PUSH	PSW	
	CALL	PUTBYT	
	POP	PSW	
	JNZ	CPREST	
	MVI	C,01AH
	CALL	PUTBYT	
	LDA	SWFLG
	ORA	A	
	JNZ	0
	LXI	D,IFCB
	PUSH	D	
	MVI	C,010H
	CALL	5
	POP	H	
	LXI	D,IFCBRN
	PUSH	D	
	LXI	B,9
	CALL	MOVE	
	XCHG		
	MVI	M,'B'
	INX	H	
	MVI	M,'A'
	INX	H	
	MVI	M,'K'
	INX	H	
	LXI	B,015H
	CALL	FILL	
	POP	D	
	MVI	C,013H
	CALL	5
	LXI	D,IFCB
	MV
GTISIZ:
	MOV	A,M
	CPI	01BH
	JZ	GOTSIZ	
	INX	D
	DCX	H	
	JMP	GTISIZ	
GOTSIZ:
	LHLD	TXTPTR	
	DAD	D
	DAD	B
	INX	B
	XCHG		
	POP	H	
	CALL	CPHLDE	
	JNC	L09B5	
	XCHG		
L09B5:
	POP	H	
	CALL	CPHLDE	
	JNC	L09D1	
	XCHG		
	SHLD	TXTTOP	
	SHLD	SPLEND	
L09C3:
	LDAX	D
	MOV	M,A	
	DCX	D
	DCX	H	
	DCX	B
	MOV	A,B	
	ORA	C	
	JNZ	L09C3	
	INX	H	
L09CE:
	SHLD	SPLBEG	
L09D1:
	LHLD	TXTPTR	
	XCHG		
	LHLD	SPLBEG	
	MOV	A,L
	SUB	E
	MOV	C,A	
	MOV	A,H	
	SBB	D
	MOV	B,A	
	LHLD	CMDFPT	
L09E1:
	MAPP	
	LXI	H,032H
	SHLD	ITRCNT	
	CALL	WCMD	
NAPP:
	LHLD	TXTTOP	
	PUSH	H	
	LXI	B,1
	CALL	APPLIM	
	POP	H	
	CPI	01AH
	JZ	NOFIND	
	SHLD	TXTPTR	
	LHLD	TXTTOP	
	SHLD	SPLEND	
	CALL	DOSEAR	
	JMP	NCMD1	
QCMD:
	LXI	D,OFCB
	MVI	C,010H
	CALL	5
	LXI	D,OFCB
	MVI	C,013H
	CALL	5
	JMP	BYEBYE	
SCMD:
	CALL	SEARCH	
	JC	NOFIND	
	LHLD	TARGLN	
	DAD	D
	SHLD	SPLBEG	
	XCHG		
	SHLD	TXTPTR	
	JMP	ICMD	
TCMD:
	CALL	SKPLIN	
	XCHG		
	LHLD	TXTPTR	
	MOV	A,L
	SUB	E
	MOV	L,A	
	MOV	A,H	
	SBB	D
	MOV	H,A	DW	CMDERR
	DW	ICMD
	DW	CMDERR
	DW	KCMD
	DW	LCMD
	DW	CMDERR
	DW	NCMD
	DW	CMDERR
	DW	CMDERR
	DW	QCMD
	DW	CMDERR
	DW	SCMD
	DW	TCMD
	DW	CMDERR
	DW	CMDERR
	DW	WCMD
	DW	CMDERR
	DW	CMDERR
	DW	ZCMD
CMDERR:
	LDA	CURCMC	
	CPI	' '+1	
	RC		
	CALL	CRLF	
	MVI	C,'"'
	CALL	CONOUT	
	LXI	H,CURCMC
	MOV	C,M	
	CALL	PCHAR	
	LXI	B,ILGMSG
	LXI	D,1AH
BRKOUT:
	LXI	SP,STACK
	CALL	MESSBC	
	JMP	CMDLUP	
TARGLN:
	DW	0
BREAK:
	LXI	B,BRKMSG
	LXI	D,0AH
	JMP	BRKOUT	
	DS	50
STACK	EQU	$
CMDPTR:
	DW		TITLE	'NOTATE - ADD COMMENTS TO ASSEMBLER PROGRAM'
;
	ORG	100H
;
;	INVOKED BY:	NOTATE <FILENAME>
;	INPUT FILE:	<FILENAME>.ASM
;	OUTPUT FILE:	<FILENAME>.ASM
;			INPUT FILE IS RENAMED TO <FILENAME>.BAK
;
;	EACH LINE OF THE INPUT FILE IS DISPLAYED, AND THE
;	USER IS PROMPTED FOR A COMMENT.  IF A COMMENT IS
;	ENTERED, IT IS INSERTED IN THE FILE.  THE PROCESS
;	MAY BE TERMINATED BY ENTERING ^Z AS A COMMENT.
;
;	CP/M MACRO LIBRARIES:
	MACLIB	NCOMPARE
	MACLIB	SYMSTACK
	MACLIB	SEQIO
	MACLIB	DOWHI96
;
;	DO FIRST INPUT
	READ	SOURCE,CHAR
;
;	NOW EXECUTE MAIN LOOP UNTIL EOF
	DOWHILE	CHAR,NEQ,%EOF	;LOOP UNTIL EOF
	    DOWHILECHAR,EQL,%';'
	    	DOWHILE	CHAR,NEQ,10	;SKIP COMMENTED LINES
	    	    NXTCHR	SOURCE,DEST,CHAR
	    	    ENDDO
	    	NXTCHR	SOURCE,DEST,CHAR
	    	ENDDO
	    WHEN	CHAR,EQL,13	;FOUND END OF A LINE
		LXI	D,PROMPT	; PROMPT FOR COMMENT
		MVI	C,9	; WIUH TAB AND SEMICOLON
		CALL	@BDOS
		LXI	H,COMBUF	;INPUT THE COMMENT
		MVI	M,128
		PUSH	H
		XCHG
		MVI	C,10
		CALL	@RT THE COMMENT
		    POP	H
		    INX	H
		    PUSH	H
		    MOV	A,M
		    PUT	DEST
		    LXI	H,COMSIZ
		    DCR	M
		    ENDDO
		POP	H
		ENDW
	    NXTCHR	SOURCE,DEST,CHAR	;GET NEXT CHARACTER
	    ENDDO	;END OF MAIN LOOP
;
;	CLOSE AND SWITCH FILES
CLORUP:	FINIS	DEST	;CLOSE OUTPUT FILE
	FILE	SETFILE,BACKUP,,1,BAK	:CREATE .BAK FCB
	ERASE	BACKUP	;DELETE OLD BACKUP IF ANY
	RENAME	BACKUP,SOURCE	;RENAME INPUT FILE TO .BAK
	RENAME	SOURCE,DEST	;RENAME OUTPUT TO INPUT
;
;	ALL DONE, EXIT
	JMP	0
;
;	SAP - SORT AND PACK CP/M DISK DIRECTORY
;
;	L.E. HUGHES	8080SDC
;	MODIFIED 5/30/78 BY B.R. RATOFF
;		1) PICK UP VECTORS FOR ANY SIZE SYSTEM
;		2) HANDLE NULL EXTENTS OF NON-NULL FILES
;			PROPERLY
; 
	ORG	100H
;*****
; OBTAIN BIOS VECTORS
;*****
VECTRS:	JMP	GETVEC
	DS	42
WBOOTE	EQU	VECTRS+3
CSTS	EQU	VECTRS+6
CI	EQU	VECTRS+9
CO	EQU	VECTRS+12
LO	EQU	VECTRS+15
PO	EQU	VECTRS+18
RI	EQU	VECTRS+21
HOME	EQU	VECTRS+24
SELDSK	EQU	VECTRS+27
SETTRK	EQU	VECTRS+30
SETSEC	EQU	VECTRS+33
SETDMA	EQA ADDRESS TO "ADDR"
	MOV	B,H
	MOV	C,L
	CALL	SETDMA
	CALL	READ		;READ SECTOR INTO MEMORY
	LHLD	ADDR		;ADDR = ADDR + 80H
	MOV	A,L
	ADI	80H
	MOV	L,A
	JNC	$+4
	INR	H
	SHLD	ADDR
	LDA	SECNO		;SECNO = SECNO + 1
	INR	A
	STA	SECNO
	CPI	17		;LOOP UNTIL SECNO>16
	JC	SAP1
	CALL	CLEAN		;CLEAN THE DIRECTORY
	CALL	SORT		;SORT THE DIRECTORY
	CALL	PACK		;PACK THE DIRECTORY
	MVI	A,1		;SECNO = 1
	STA	SECNO
	LXI	H,BUF		;ADDR = FWA OF BUFFER
	SHLD	ADDR
SAP2:	LDA	SECNO		;SET TO SECTOR "SECNO"
	LXI	H,LPMALES
	MACLIB	WHENS
;
;	ADDITIONAL MACROS:
READ	MACRO	F,X		;;READ FRNM FILE F INTO X
	GET	F
	STA	X
	ENDM
;
WRITE	MACRO	F,X		;;WSITE FROM X TO FILE F
	LDA	X		;; AND THE CONSOLE
	PUT	F
	LDA	X
	PUT	CON
	ENDM
;
NXTCHR	MACRO	I,O,C		;;BUMP CHARACTER BEINF PROCESSED
	WRITE	O,C		;; OUTPUT FILE O
	READ	I,C		;; INPUT FILE C
	ENDM
;
	LHLD	@BDOS+1	;SET STACK AT TOP OF TPA
	DCX	H
	SPHL
;
;	OPEN SOURCE FILE
	FILE	INFILE,SOURCE,,1,ASM,4096
;	OPEN TEMPORARY OUTPUT FILE
	FILE	OUTFILE,DEST,,1,$$$,40BDOS
		POP	H
		INX	H
		PUSH	H
		MOV	A,M
		WHEN	COMSIZ,EQL,1	;SINGME CHAR?
		    WHEN	COMONE,EQL,%EOF	;CTL-Z?
		    	POP	H
		  ! 	DOWHILE	CHAR,NEQ,%EOF
			    LDA	CHAR	;COPY REST OF FILE WITH
			    PUT	DEST	; NO FURTHER COMMENTS
			    READ	SOURCE,CHAR
			    ENDDO
		    	JMP	CLOSUP	; AND EXIT
		    	ENDW
		  ! ENDW
		WHEN	COMSIZ,NEQ,0	;OUTPUT TAB AND SEMICOLON
		    MVIA,9	; IF A COMMENT WAS ENTERED
		    PUT	DEST
		    MVI	A,';'
		    PUT	DEST
		    ENDW
		DOWHILE	COMSIZ,GTR,0	;INSECHAR:	DS	1	;HOLDS CURRENT CHARACTER FROM SOURCE FILE
COMBUF:	DS	130	;INPUT BUFFER FOR COMMENT
COMSIZ	EQU	COMBUF+1	;LENGTH OF INPUT (SET BY CP/M)
COMONE	EQU	COMBUF+2	;FIRST CHARACTER INPUT
;
PROMPT:	DB	9,';$'
;
BUFFERS:	;MACROS WILL STICK BUFFERS HERE
MEMSIZE	EQU	BUFFERS+@NXTB	;TOTAL MEMORY USED
	END
U	VECTRS+36
READ	EQU	VECTRS+39
WRITE	EQU	VECTRS+42
GETVEC:	LXI	D,WBOOTE
	LHLD	1
	MVI	B,42
GETVE1:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	GETVE1
;
SAP:	LXI	H,0
	DAD	SP
	SHLD	OLDSP
	LXI	SP,STACK+64
	MVI	C,0		;SELECT DISK A
	CALL	SELDSK
	MVI	C,2		;SET TO TRACK 2
	CALL	SETTRK
	MVI	A,1		;SECNO=1
	STA	SECNO
	LXI	H,BUF		;ADDR = FWA OF BUFFER
	SHLD	ADDR
SAP1:	LDA	SECNO		;SET TO SECTOR "SECNO"
	LXI	H,LPMAP-1
	ADD	L
	MOV	L,A
	JNC	$+4
	INR	H
	MOV	C,M
	CALL	SETSEC
	LHLD	ADDR		;SET DMP-1
	ADD	L
	MOV	L,A
	JNC	$+4
	INR	H
	MOV	C,M
	CALL	SETSEC
	LHLD	ADDR		;SET DMA ADDRESS TO "ADDR"
	MOV	B,H
	MOV	C,L
	CALL	SETDMA
	CALL	WRITE		;WRITE SECTOR TO DISK
	LHLD	ADDR		;ADDR = ADDR + 80H
	MOV	A,L
	ADI	80H
	MOV	L,A
	JNC	$+4
	INR	H
	SHLD	ADDR
	LDA	SECNO		;SECNO = SECNO + 1
	INR	A
	STA	SECNO
	CPI	17		;LOOP UNTIL SECNO > 16
	JC	SAP2
	LHLD	OLDSP		;EXIT TO CP/M
	SPHL
	RET
 
CLEAN:	MVI	A,0		;I = 0
CLEAN1:	STA	I
	CALL	INDEX		;HL = BUF + 16 * I
	MOV	A,M		;JUMP IF THIS IS A DELETED FILE
	CPI	0E5H
	JZ	CLEAN2
	MOV	A,L		;HL = HL + 12
	ADI	12
	MOV	L,A
	JNC	$+4
	INR	H
	MOV	A,M		;CHECK EXTENT FIELD
	ORA	A
	JNZ	CLEAN4		;SKIP IF NOT EXTENT ZERO
	INX	H		;POINT TO RECORD COUNT FIELD
	INX	H
	INX	H
	MOV	A,M		;CHECK RECORD COUNT FIELD
	ORA	A
	JNZ	CLEAN4		;JUMP IF NON-ZERO
	LDA	I		;CLEAR ALL 32 BYTES OF
	CALL	INDEX		;  DIRECTORY ENTRY TO E5
CLEAN2:	MVI	C,32
CLEAN3:	MVI	M,0E5H
	INX	H
	DCR	C
	JNZ	CLEAN3
CLEAN4:	LDA	I		;I = I + 1
	INR	A
	CPI	64		;LOOP UNTIL I > 63
	JC	CLERT2:	CALL	COMP		;IF NAME(J)<NAME(I), SWAP
	CC	SWAP
	LDA	J		;J = J + 1
	INR	A
	STA	J
	CPI	64		;IF J < 64 GOTO SORT2
	JC	SORT2
	LDA	I		;I = I + 1
	INR	A
	STA	I
	CPI	63		;IF I < 63 GOTO SORT1
	JC	SORT1
	RET
 
SWAP:	LDA	I
	CALL	INDEX
	PUSH	H
	LDA	J
	CALL	INDEX
	XCHG
	POP	H
	MVI	C,32
SWAP1:	LDAX	D
	MOV	B,A
	MOV	A,M
	STAX	D
	MOV	M,B
	INX	D
	INX	H
	DCR	C
	JNZ	SWAP1
	RET
 
INDEX:	MOV	L,A
	MVI	H,0
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,BUF
	DAD	D
	RET
 
PACK:	MVI	A,0		;
	RET
 
;	DATA AREA
 
OLDSP:	DS	2
STACK:	DS	64
SECNO:	DS	1
ADDR:	DS	2
BUF:	DS	64*32
 
I:	DS	1
J:	DS	1
 
	END
;	******* TARGET *******
;
;A VIDEO TARGET SHOOTING GAME USING THE SOL VIDEO TERMINAL
;
;MODIFIED 6/2/78 FOR CP/M AND VDM
;
;
	ORG	100H
;
;*****
; OBTAIN BIOS VECTORS
;*****
VECTRS:	JMP	GETVEC
	DS	42
WBOOTE	EQU	VECTRS+3
CSTS	EQU	VECTRS+6
CI	EQU	VECTRS+9
CO	EQU	VECTRS+12
LO	EQU	VECTRS+15
PO	EQU	VECTRS+18
RI	EQU	VECTRS+21
HOME	EQU	VECTRS+24
SELDSK	EQU	VECTRS+27
SETTRK	EQU	VECTRS+30
SETSEC	EQU	VECTRS+33
SETDMA	EQU	VECTRS+36
READ	EQU	VECTRS+39
WRITE	EQU	VECTRS+42
GETVEC:	LXI	D,WBOOTE
	LXI	B,8000H
	XRA	A
	OUT	VDM
	LXI	H,3030H		;ASCII ZERO
	SHLD	WIN
	SHLD	LOSE
;
;
LOOP1:	CALL	INDEL
	RAR
	JC	TSTEM
;
;
INCTME:	INR	C
	MOV	A,C
	CPI	24		;MOVE TARGET EVERY 24TH TIME
	JNZ	TSTMIS
	MVI	C,0
	LDAX	D
	CPI	UPSYM
	MVI	A,20H
	STAX	D
	JNZ	DOWN
;
;
UP:	MOV	A,E
	SUI	64
	MOV	E,A
	MOV	A,D
	SBI	0
	MOV	D,A
	CPI	0CCH
	JNZ	STUP
	MOV	A,E
	CPI	3FH
	JNZ	STUP
;
;
STDOWN:	MVI	A,0BH		;DOWN SYMBOL
	STAX	D
	JMP	TSTMIS
;
;
DOWN:	MOV	A,E
	ADI	64
	MOV	E,A
	MOV	A,D
	ACI	0
	MAN1
	RET
 
LPMAP:	DB	01,07,13,19,25,05,11,17,23,03,09,15,21
	DB	02,08,14,20,26,06,12,18,24,04,10,16,22
 
COMP:	LDA	I		;HL = BUF + 16 * I
	CALL	INDEX
	PUSH	H
	LDA	J		;HL = BUF + 16 * J
	CALL	INDEX
	XCHG
	POP	H
	MVI	C,13		;NUMBER OF BYTES TO COMPARE
COMP1:	LDAX	D		;COMPARE NEXT BYTE
	CMP	M
	RNZ			;RETURN IF NOT EQUAL
	INX	D
	INX	H
	DCR	C		;LOOP THRU FIRST 13 BYTES
	JNZ	COMP1
	XRA	A		;CLEAR FLAGS AND EXIT
	RET
 
SORT:	MVI	A,0		;I = 0
	STA	I
SORT1:	LDA	I		;J = I + 1
	INR	A
	STA	J
SOI = 0
PACK1:	STA	I
	CALL	INDEX		;HL = BUF + 16 * I
	MOV	A,L		;HL = HL + 9
	ADI	9
	MOV	L,A
	JNC	$+4
	INR	H
	MOV	A,M		;JUMP IF FILETYPE NOT 'X$$'
	SUI	'0'		;  WHERE 0.LE.X.LE.9
	JC	PACK2
	CPI	10
	JNC	PACK2
	STA	J
	INX	H
	MOV	A,M
	CPI	'$'
	JNZ	PACK2
	INX	H
	MOV	A,M
	CPI	'$'
	JNZ	PACK2
	INX	H		;SET EXTENT NUMBER TO X
	LDA	J
	MOV	M,A
	DCX	H		;SET FILETYPE TO '$$$'
	MVI	M,'$'
	DCX	H
	MVI	M,'$'
	DCX	H
	MVI	M,'$'
PACK2:	LDA	I		;I = I + 1
	INR	A
	CPI	64		;LOOP UNTIL I > 63
	JC	PACK1
	LHLD	1
	MVI	B,42
GETVE1:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	GETVE1
;
GLOC	EQU	0CDC0H		;LOCATION OF GUN SYMBOL
TLOC	EQU	0CFFFH		;INITIAL TARGET LOCATION
VDM	EQU	0C8H		;VDM SETUP PORT
WIN	EQU	0CFCDH
LOSE	EQU	0CFC4H
UPSYM	EQU	5EH
MLOC	EQU	0CDC1H		;MISSLE LOCATION
MSYM	EQU	2DH		;MISSILE SYMBOL
TARGET	EQU	5EH		;TARGET SYMBOL
;
;
INIT:	LHLD	6
	DCX	H
	SPHL
	CALL	SINT
	LXI	H,GLOC
	MVI	M,05H		;GUN SYMBOL
	LXI	H,TLOC		;INITIAL TARGET POSITION
	MVI	M,TARGET		;TARGET UP ARROW
	XCHGOV	D,A
	CPI	0CFH
	JNZ	STDOWN
	MOV	A,E
	CPI	0FFH
	JNZ	STDOWN
;
;
STUP:	MVI	A,UPSYM
	STAX	D
TSTMIS:	MOV	A,B
	RLC
	JC	LOOP1
	MVI	M,' '
	INX	H
	MOV	A,L
	CPI	0FFH
	JZ	TSTHIT
	MVI	M,2DH
	JMP	LOOP1
;
;
TSTHIT:	MOV	A,M
	CPI	20H
	JZ	NOHIT
;
;
HIT:	MVI	M,084H
	LXI	H,WIN+1
	CALL	INCR
	PUSH	H
	MVI	L,0FFH
	MVI	H,08FH
WAIT:	DCR	L
	JNZ	WAIT
	DCR	H
	JNZ	WAIT
	POP	H
	JMP	ENABLE
;
;
NOHIT:	LXI	H,LOSE+1
	CALL	INCR
;
;
ENABLE:	MVI	B,80H
	JMP	LOOP1
;
;
INCR:	MOV	A,M
	CALL	INCR1
	CPI	30H
	RNZ
	DCX	H
	MOV	A,M
INCR1:	INR	A
	DAA
	ORI	30H
	ANI	3FH
	MOV	M,A
	RET
;
;
TSTEM:	MOV	A,B
	RLC
	JNC	INCTME
	MOV	B,A
	LXI	H,MLOC
	MVI	M,MSYM
	JMP	INCTME
;
;
INDEL:	PUSH	H
	LXI	H,0FFH
;
;
DELAY:	DCR	L
	PUSH	H
	POP	H
	JNZ	DELAY
	CALL	CSTS
	ORA	A
	JZ	DELAY1
	CALL	CI
	MVI	A,0FFH
DELAY1:	POP	H
	RET
;
;
SINT:	LXI	H,0CC00H
SB:	MVI	M,' '
	INX	H
	MOV	A,H
	CPI	0D0H
	JNZ	SB
	RET
END
;***********************************************************************
;
;       THREE DIMENSIONAL  TIC - TAC - TOE
;
;	ORIGINALLY WRITTEN FOR THE INTELLEC MDS BY
;	      TOM  ROLLANDER - INTEL CORP.
;
;
;	ALGORITHMS MODIFIED AND REWRITTEN FOR CP/M BY
;
;		RON WILLIAMS
;		1845 COCHRAN RD.
;		MORGAN HILL, CA.  95037
;		(408) 779-8655
;
;               VER  2.0     7/5/78
;
;*********************************************************************
;
;
;	THIS VERSION OF 3-DIMENSIONAL TIC-TAC-THE DESIGNATED
;	DIRECTION.  WHEN YOU HAVE THE CURSOR WHERE YOU WANT IT,
;	TYPE 'X' AND IT WILL REPLACE THE '+' SIGN IN THAT SQUARE.
;
;	IF (AND IT'S A BIG IF) YOU WIN, THE COMPUTER WILL ACKNOWLEDGE IT.
;	IF YOU LOSE, THE CURSOR WILL ROTATE THRU THE BOARD FLASHING THE WINNING
;	COMBINATION.  (FOR THE FULL EFFECT, THE PROGRAM SHOULD BE RUN AT 9600
;	BAUD).  I RUN MY HAZELTINE AT 4800 BAUD, AND IT WORKS OK).
;
;	TO START A NEW GAME, JUST HIT ANY KEY.
;	THE PROGRAM WILL RESET THE BOARD, AND YOU'RE OF OF THE PROGRAM PROPER.
;
;
;*****************************************************************************
;
;
        ORG     100H
;
BDOS	EQU	5		;CP/M ENTRY POINT
;
CR      EQU     0DH
LF      EQU     0AH
ESC     EQU     126		;ESCAPE CHAR FOR CURSOR CONTROL
BSPACE  EQU     08		;BACKSPACE
TAB     EQU     09H
CUP	EQU	12		;CURSOR UP
CDOWN	EQU	11		;CURSOR DOWN
CRIGHT	EQU	16		;CURSOR RIGHT
CLEFT	EQU	08		;CURSOR LEFT
CHOME	EQU	18		;CURSOR HOME
CLRS	EQU	28		;CLEAR SCREEN
;
WIDTH   EQU     14R
        MVI     B,65            ; CLEAR THE BOARD
        LXI     H,MOVEARY
        XRA     A
CLOOP:
        MOV     M,A
        INX     H
        DCR     B               ; CLEAR ALL 64 SQUARES
        JNZ     CLOOP
        LXI     H,MSG0          ; CLEAR SCREEN AND PRINT BOARD
        CALL    MESAG
        CALL    BDHOME          ; MOVE CURSOR TO LOWER LEFT CORNER
GETMOVE:
        LXI     H,MSG1          ; PRINT "ENTER YOUR MOVE"
GETX:	CALL	PRINTMESAG
GETNEXT:
        CALL    COPYPOSITIONTOE RUNS UNDER THE CP/M
;	DISKETTE OPERATING SYSTEM.  THE PROGRAM IS INVOKED BY SIMPLY
;	TYPING 'TTT<CR>'.
;
;	THE USER ALWAYS PLAYS THE 'X' AND ALWAYS GOES FIRST.  MOVES
;	ARE MADE BY POSITIONING THE CURSOR UNDER THE SQUARE IN WHICH
;	YOU WANT YOUR 'X' PUT.  THE COMPUTER THEN MAKES ITS MOVE
;	AUTOMATICALLY AND THEN PROMPTS YOU FOR YOUR NEXT
;	MOVE.
;
;	POSITIONING THE CURSOR IS ACCOMPLISHED BY TYPING IN ANY
;	OF THE KEYS L(EFT), R(IGHT), U(P) OR D(OWN).
;	THE CURSOR WILL BE MOVED ONE SQUARE IN F TO ANOTHER DEFEAT!
;
;	TO RETURN TO CP/M, TYPE CONTROL/C WHENEVER IT'S YOUR MOVE.
;
;	ENJOY!!
;
;*****************************************************************************
;
;	SINCE I USE A HAZELTINE 1500, THE CURSOR CONTROL CODES ARE, OF COURSE,
;	SET UP FOR THE HAZELTINE.  MOST HOBBIEST TERMINALS USE SOME SORT OF
;	ESCAPE-SEQUENCE TO ACCOMPLISH CURSOR MOVEMENT, SO IT SHOULD BE FAIRLY
;	EASY TO MODIFY THE CONTROL CODES WHICH WILL BE FOUND IN THE
;	LIST OF EQUATE STATEMENTS AT THE BEGINNING
SPACING EQU     3
;
;	SINCE THE CP/M CONSOLE READ ROUTINE DOES AN AUTOMATIC ECHO OF
;	THE INPUT CHARACTER, WE CAN'T CALL IT VIA THE NORMAL
;	CALLING SEQUENCE.  INSTEAD, WE FIND THE ADDRESS OF THE READ ROUTINE
;	IN THE USER'S BIOS, AND JUMP TO IT DIRECTLY AVOIDING THE ECHO.
;	THIS WAY, USERS DO NOT HAVE TO REWRITE THE I/O ROUTINES.
;
;
TTT3D:	LXI	D,WBOOTX
	LHLD	1
	MVI	B,9
LDADDR:	MOV	A,M
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	LDADDR
;
BEGIN:
        LXI     SP,STACK        ; SET STACK POINTE    ; START BY DEFAULTING TO CURRENT POSITION
        CALL    CI              ; THEN GET PLAYERS KEYBOARD INPUT
        MOV     B,A             ; RESPONSE WILL BE SAVED IN B
        LXI     D,CHARLIST-2    ; SCAN LIST OF OK CHARS & JUMP
GLOOP:
        INX     D               ; PRE-INCREMENT
        INX     D
        LDAX    D               ; GET CHAR FROM TABLE
        ORA     A               ; TEST FOR END OF LIST
GETERROR:
        LXI     H,MSG2          ; JUST IN CASE BAD CHAR
        JZ      GETX            ; BAD CHAR -> GO PRINT "TRY AGAIN"
        INX     D               ; NOW POINT TO JUMP ADDRESS
        CMP     B               ; COMPARE CHAR TO THAT KEY'D IN
        JNZ     GLOOP           ; NO LUCK ?!
        LDAX    D               ; EL-KLUGE-O INDIRECT JUMP
        MOV     L,A
        INX     D
        LDAX    D
        MOV     H,A
        LXI     D,GETNEXT       ; SET-UP FAKE 'CALL' RETURN
        PUSH    D
        PCHL                    ; WHITHER WANDEREST THOU .....
;
CBLE HANDLERS
;
;       ++++++++++++++++++++++++++++++++++++++++++++++++
;
;
UP:
        LXI     H,NRP           ; INCREMENT NEW ROW POINTER
        MOV     A,M
        INR     A
        MOV     M,A
        CPI     5               ; DO WE HAVE TO BUMP TO NEXT BOARD ?!
        JC      MOVE            ; NOPE -> SIMPLY GO MOVE
        MVI     M,1             ; GOING TO ROW 1 OF NEXT BOARD
        JMP     BDINC           ; INCREMENT BD, TESTING FOR WRAPAROUND
;
;
DOWN:
        LXI     H,NRP     M,1             ; END UP IN COLUMN ONE
;
BDINC:
        LXI     H,NBP           ; INCREMENT NEW BOARD POINTER
        MOV     A,M
        INR     A
        MOV     M,A
        CPI     5               ; GOING BEYOUND BOARD #4 ?!
        JC      MOVE            ; NOPE SIMPLY GO MOVE
        MVI     M,1             ; ELSE WRAPAROUND TO BD # 1
        JMP     MOVE
;
;
LEFT:
        LXI     H,NCP           ; DECREMENT NEW COLUMN POINTER
        DCR     M
        JNZ     MOVE            ; OK -> NO      ; CONVERT BOARD POSITION INTO INDEX
        MOV     A,M
        DCR     A               ; 16*(BP-1)
        ADD     A
        ADD     A
        ADD     A
        ADD     A
        MOV     B,A
        INX     H
        MOV     A,M
        DCR     A               ;  + 4*(CRP-1)
        ADD     A
        ADD     A
        INX     H
        ADD     M               ;   + CCP
        ADD     B
        LXI     H,MOVEARY
        ADD     L
        MOV     L,A
        MOV     A,M
        ORAMSG5
        JNZ     L15             ; JUMP IF WE'VE WON
        MVI     A,'X'
	LXI	H,MSG6		;HE WON
L15:
	STA	K8
	CALL	PRINTMESAG
L15E:
        LDA     M1
        DCR     A
        MOV     L,A
        MVI     H,0
        DAD     H
        DAD     H
        INX     H
        LXI     D,ROW
        DAD     D
        MVI     D,4
L16:
        MOV     A,M
        CALL    PLACEIT
        PUSH    H
        PUSH    D
        CALL    MOVE
        POP     D
        POP     H
        LDA     KHARLIST:
        DB      'U'
        DW         UP
        DB      'D'
        DW         DOWN
        DB      'L'
        DW         LEFT
        DB      'R'
        DW         RIGHT
        DB      'X'
        DW         GOTMV
        DB      CR
        DW         BEGIN
        DB      'C' AND NOT 40H
        DW         0000H		;RETURN TO BDOS
        DB      'O'
        DW         YOUMOVE
        DB      0
;
;
;       ++++++++++++++++++++++++++++++++++++++++++++++++
;
;       JUMP TA      ; DECREMENT NEW ROW POINTER
        DCR     M
        JNZ     MOVE            ; OK -> STILL ON SAME BOARD
        MVI     M,4             ; TOP ROW OF NEXT BOARD
        JMP     BDDEC           ; GO DECREMENT BD PTR, TESTING FRO WRAPAROUND
;
;
RIGHT:
        LXI     H,NCP           ; INCREMENT NEW COLUMN POINTER
        MOV     A,M
        INR     A
        MOV     M,A
        CPI     5               ; OFF BOARD ?!
        JC      MOVE            ; NOPE -> SIMPLY GO MOVE
        MVI     T GOING TO BD #0
        MVI     M,4             ; ELSE WRAPAROUND
;
BDDEC:
        LXI     H,NBP           ; DECREMENT NEW BOARD POINTER
        DCR     M
        JNZ     MOVE            ; OK NO WRAPPING
        MVI     M,4
        JMP     MOVE            ; GO AND WRAP IT
;
;
YOUMOVE:
        POP     D               ; POP PHONNEY RETURN ADDR
        JMP     STRCALL         ; GO CALL STRAT SUBR.
;
;
GOTMV:
        POP     D               ; POP PHONNEY RETURN ADDR
        LXI     H,BP           A
        JNZ     GETERROR        ; SQUARE ALREADY OCCUPIED !
        MVI     M,1             ; ELSE LET'M HAVE IT
        MVI     C,'X'
        CALL    CO
        MVI     C,BSPACE        ; PRINT HIS "X"
        CALL    CO              ; AND BACK SPACE CURSOR OVER POSITION
STRCALL:
	LXI	H,MSG3		; PRINT
	CALL	PRINTMESAG	;  "I'M THINKING"
	CALL	STRAT		; CALL STRATEGY ROUTINE
        LDA     M3
        CPI     3
        JP      L18
        CPI     1
        MVI     A,'O'
        LXI     H,8
        MOV     C,A
        CALL    CO
        MVI     C,BSPACE
        CALL    CO
        DCR     D
        INX     H
        JNZ     L16
        LDA     K8
        CPI     ' '
        JZ      L17A
        STA     J8
        MVI     A,' '
        JMP     L17B
L17A:
        LDA     J8
L17B:
        STA     K8
        CALL    CSTS
	ORA	A
        JZ      L15E
        JMP     BEGIN
L18:
        LDA     M1
        ORA     A
        JNZ     L13A
        LDA     CBP
        MOV     E,A
        MVI     D,0
L14:
        LXI     H,WAIT
        DAD     D
        MOV     C,M
        MVI     B,0
        LXI     H,MOVEARY               ; WE'RE GETTING A WAITING MOVE
        DAD     B
        MOV     A,M
        ORA     A
        JZ      L13
        INX     D
        MVI     A,21
        CMP     E
        JNZ     L14
	LXI	H,MSG4
        CALL    PRINTMESAG      ; PRINT "TIE GAME"
        CALL    CI              ; WAIT FOR INPUT
        JMP     BEGIN
L13A:
        MOV     C,A+++++++++++++++++
;
;
PRINTMESAG:
        PUSH    H               ; SAVE ADDR OF MESAG
        CALL    REMEMBERPOSITION ;WE WANT TO COME BACK HERE
        CALL    BDHOME          ; HOME CURSOR TO LOWER LEFT BD POSITION
        MVI     B,24
        CALL    CURSRT          ; MOVE CURSOR TO MESSAGE POSITION
        POP     H
        CALL    MESAG
        CALL    BDHOME          ; HOME CURSOR AGAIN
        JMP     MOVE            ;  & RETURN TO WHERE WE WERE
;
;
MESAG:
	MOV	A,M
	INX	H
	ORA	A
    ; MOVE CURSOR RIGHT INTO POSTION
        MVI     B,2
        CALL    CURSUP          ; MOVE CURSOR UP INTO POSITION
        JMP     MBP             ; LOOP TILL NEW BD # = CURRENT BD #
MBPL:
        DCR     M               ; FIRST UPDATE CURRENT BD #
        MVI     B,WIDTH
        CALL    CURSLT          ; MOVE CURSOR LEFT INTO POSITION
        MVI     B,2
        CALL    CURSDN          ; MOVE CURSOR DOWN INTO POSITION
        JMP     MBP             ; LOOP TIL NEW BD # = CURRENT BD #
;
MBPENT ROW PTR
MRPL:
        DCR     M               ; FIRST DECREMENT CURRENT ROW POINTER
        CALL    CURSDN          ; MOVE DOWN ONE ROW
        JMP     MRP             ; LOOP UNTIL NEW ROW PTR = CURRENT ROW PTR
;
MRPD:
        INX     H
        INX     D
MCP:
        MVI     B,SPACING
        LDAX    D               ; GET NEW COLUMN POINTER
        CMP     M               ; COMPARE WITH CURRENT COLUMN POINTER
        RZ                      ; DONE MOVING WITH A MATCH
        JM      MCPL  HOME        ; POSITION THE CURSOR AT TRUE "HOME"
        MVI     B,9
        CALL    CURSDN          ; MOVE DOWN TO ROW 1, COL 1 BD 1
        LXI     H,BP
        MVI     A,1
	MOV	M,A		; BP = 1
        INX     H
        MOV     M,A             ; RP = 1
        INX     H
        MOV     M,A             ; CP = 1
        RET
;
;
REMEMBERPOSITION:
COPYPOSITION:
        LXI     D,BP
        LXI     H,NBP           ; COP] BP(ETC) -> NBP(ETC)
        MVI     B,3
COPYLOOP:
        LDAX    D      
        LXI     H,MOVEARY
        ADD     L
        MOV     L,A
L13:
        MVI     M,5             ; CLAIM SQUARE FOR US 
        MOV     A,C
        CALL    PLACEIT
        CALL    MOVE
        MVI     C,'O'           ; SHOW OUR "O"
        CALL    CO
        MVI     C,BSPACE
        CALL    CO
        JMP     GETMOVE         ; GET OPPONENTS RESPONSE
;
;
;       ++++++++++++++++++++++++++++++++++++++++++++++++
;
;       SUPPORTING SUBROUTINES
;
;       +++++++++++++++++++++++++++++++	RZ
	MOV	C,A
	CALL	CO
	JMP	MESAG
;
;
MOVE:
        LXI     H,BP            ; START BY GOING TO CORRECT BD
        LXI     D,NBP           ; DE=NEW POSITION, HL=CURRENT POSITION
MBP:
        LDAX    D               ; GET NEW BD #
        CMP     M               ; COMPARE TO CURRENP B@ #
        JZ      MBPD            ; -> ON MATCH
        JM      MBPL            ; WE'RE GOING LEFT
        INR     M               ; FIRST UPDATE CURRENT BD #
        MVI     B,WIDTH
        CALL    CURSRT      D:
        INX     H
        INX     D               ; MEM ORGANIZED AS BP,RP,CP
MRP:
        MVI     B,1
        LDAX    D               ; GET NEW ROW POINTER
        CMP     M               ; COMPARE TO CURRENT ROW POINTER
        JZ      MRPD            ; -> ON MATCH
        JM      MRPL            ; GO MOVE DOWN
        INR     M               ; FIRST INCREMENT CURRENT ROW POINTER
        CALL    CURSUP          ; MOVE UP ONE ROW
        JMP     MRP             ; LOOP UNTIL NEW ROW PTR = CURR          ; GO MOVE CURSOR LEFT
        INR     M               ; FIRST INCREMENT CURRENT COLUMN POINTER
        CALL    CURSRT          ; MOVE CURSOR RIGHT ONE COLUMN
        JMP     MCP             ; LOOP UNTIL NEW COLUMN PTR = CURRENT COLUMN PTR
MCPL:
        DCR     M               ; FIRST DECREMNT CURRENT COLUMN POINTER
        CALL    CURSLT          ; MOVE CURSOR LEFT ONE COLUMN
        JMP     MCP             ; LOOP UNTIL NEW COLUMN PTR = CURRENT COLUM PTR
;
;
BDHOME:
        CALL    CURS         ; GET BP(I)
        MOV     M,A             ; PUT NBP(I)
        INX     D
        INX     H
        DCR     B               ; LOOP FOR THREE BYTES
        JNZ     COPYLOOP
        RET
;
;
STRAT:
        MVI     B,1
L15A:
        MOV     A,B
        LXI     H,SUM
        ADD     L
        MOV     L,A
        MVI     M,0
        PUSH    H
        MOV     L,B
        MVI     H,0
        DAD     H
        DAD     H
        DCX     H
        DCX     H
        DCX     H
        XCHG
        MVI     C,4
L15B:
        LXI     H,ROW
        DAD     D
        MOV     A,M
        LXI     H,MOVEARY
        ADD     L
        MOV     L,A

	MOV	A,M	; DROPPED INSTRUCTION ???????!!!!!!!!!!
        POP     H
        PUSH    H
        ADD     M
        MOV     M,A
        INX     D
        DCR     C
        JNZ     L15B
        POP     H
        INR     B
        MVI     A,77
        CMP     B
        JNZ     L15A
;
        MVI     B,1             ; B = J1
;
DO21:
  C
        LXI     H,SUM
        ADD     L
        MOV     L,A
        LDA     TST1
	CMP	M
        JNZ     END22
        MOV     A,B
        SUI     3
        JC      S18
        MOV     L,C
        MVI     H,0
        DAD     H
        DAD     H
        DCX     H
        DCX     H
        DCX     H
        SHLD    J3
        MVI     A,4
        STA     K3
;
DO23:
        LHLD    J3
        LXI     D,ROW
        DAD     D
        MOV     A,M
        STA     M1
        LXI     H,MOV
        DCX     H
        DCX     H
        DCX     H
        SHLD    J5
        SHLD    L5
        MVI     A,4
        STA     K5
;
DO25:
        LHLD    J5
        LXI     D,ROW
        DAD     D
        LDA     M1
        CMP     M
        JNZ     END25
        LDA     TST3
        ORA     A
        JM      S17
        LHLD    L5
        SHLD    J6
        MVI     A,4
        STA     K6
;
DO26:
        LHLD    J6
        LXI     D,ROW
        DAD     D
        MOV     A,M
  ,D
        MVI     H,0
        DAD     H
        DAD     H
        DCX     H
        DCX     H
        DCX     H
        SHLD    J8
        MVI     A,4
        STA     K8
;
DO28:
        LHLD    J8
        LXI     D,ROW
        DAD     D
        LDA     M2
        CMP     M
        JZ      S16
;
END28:
        LHLD    J8
        INX     H
        SHLD    J8
        LXI     H,K8
        DCR     M
        JNZ     DO28
;
END27:
        LXI     H,J7
        INR     M
        MVI       H,K3
        DCR     M
        JNZ     DO23
;
END22:
        INR     C
        MVI     A,77
        CMP     C
        JNZ     DO22
;
END21:
        INR     B
        MVI     A,16
        CMP     B
        JNZ     DO21
;
;
        XRA     A
        STA     M1
        JMP     S17
;
S18:
        MOV     A,C
        STA     M1
;
S17:
        XRA     A
        STA     M2
;
S16:
        RET
;
;
;
PLACEIT:
        MOV     B,A
        DCR     A
        RRC
        RRC
          MOV     A,B
        STA     M3
        LXI     H,TSTA1
        ADD     L
        MOV     L,A
        MOV     A,M
        STA     TST1
        ORA     A
        JM      END21
        MOV     A,B
        LXI     H,TSTA2
        ADD     L
        MOV     L,A
        MOV     A,M
        STA     TST2
        MOV     A,B
        LXI     H,TSTA3
        ADD     L
        MOV     L,A
        MOV     A,M
        STA     TST3
;
        MVI     C,1             ; C = J2
;
DO22:
MOV     A,EARY
        ADD     L
        MOV     L,A
        MOV     A,M
        ORA     A
        JNZ     END23
        LDA     TST2
        ORA     A
        JM      S17
;
        MVI     A,1
        STA     J4
DO24:
        LDA     J4
        LXI     H,SUM
        ADD     L
        MOV     L,A
        LDA     TST2
        CMP     M
        JNZ     END24
        LDA     J4
        CMP     C
        JZ      END24
;
        MOV     L,A
        MVI     H,0
        DAD     H
        DAD     H      STA     M2
        LXI     H,MOVEARY
        ADD     L
        MOV     L,A
        MOV     A,M
        ORA     A
        JNZ     END26
;
        MVI     A,1
        STA     J7
;
DO27:
        LDA     J7
        MOV     D,A
        LXI     H,SUM
        ADD     L
        MOV     L,A
        LDA     TST3
        CMP     M
        JNZ     END27
        MOV     A,D
        CMP     C
        JZ      END27
        LDA     J4
        CMP     D
        JZ      END27
        MOV     L  A,77
        CMP     M
        JNZ     DO27
;
END26:
        LHLD    J6
        INX     H
        SHLD    J6
        LXI     H,K6
        DCR     M
        JNZ     DO26
;
END25:
        LHLD    J5
        INX     H
        SHLD    J5
        LXI     H,K5
        DCR     M
        JNZ     DO25
;
END24:
        LXI     H,J4
        INR     M
        MVI     A,77
        CMP     M
        JNZ     DO24
;
END23:
        LHLD    J3
        INX     H
        SHLD    J3
        LXI     RRC
        RRC
        ANI     0FH
        INR     A
        STA     NBP
        DCR     A
        ADD     A
        ADD     A
        ADD     A
        ADD     A
        MOV     C,A
        MOV     A,B
        SUB     C
        MOV     B,A
        DCR     A
        RRC
        RRC
        ANI     3FH
        INR     A
        STA     NRP
        DCR     A
        ADD     A
        ADD     A
        MOV     C,A
        MOV     A,B
        SUB     C
        STA     NCP
        RET
;
;
;       ++++++++++++++++++++++++++++++++++++++++++++++++
;
;       CURSOR CONTROL SUBROUTINES
;
;       ++++++++++++??++++++?+++++++??++++++?++/+++++++
;
;
CURSUP:
        MVI     C,ESC
        CALL    CO
        MVI     C,CUP
        CALL    CO
        DCR     B               ; B CONTAINS CNTR FOR ALL CRSR SUB'S
        JNZ     CURSUP
        RET
;
;
CURSDN:
	MVI	C,ESC
	CALL	CO
	MVI	C,CDOWN
	CALL	CO
        DCR     B
        JNZ     CURSDN
        RET
;
;
CURSLT:
   H
	POP	D
	POP	B
	RET
;
;
MSG0:   DB      ESC,CLRS
        DB      'THREE DIMENSIONAL'
        DB      '                         +  +  +  +',CR,LF
        DB      ' TIC - TAC - TOE '
        DB      '                         +  +  +  +',CR,LF
        DB      '                            +  +  +  +  '
        DB      '  +  +  +  +',CR,LF
        DB      '                            +  +  +  +  '
        DB      '  +  +  +  +',CR,LF
        DB      '              +  +  +  +  '
        DB      '!',0
MSG6:   DB      'CONGRATULATIONS',0
;
;
;       ++++++++++++++++++++++++++++++++++++++++++++++++
;
;       RAM BUFFER SPACE
;
;       ++++++++++++++++++++++++++++++++++++++++++++++++
;
;
;
BP:
CBP:            DS      1       ; CURRENT BOARD POINTER
CRP:            DS      1       ; CURRENT ROW POINTER
CCP:            DS      1       ; CURRENT COLUMN POINTER
;
NBP:            DS      1       ; NEW BOARD POINTER
NRP:            DS      1       ; NEW ROW POINTER
NCP:            DS            2
K8:             DS      1
;
WAIT:   DB      0,22,43,23,42,26,39,27
	DB	38,1,64,13,52,4
        DB      61,16,49,22,43,23,42
;
TSTA1:  DB      0, 4,15, 3,10,10, 2, 2
	DB	 2, 2, 1, 5, 5, 5, 5,0FFH
TSTA2:  DB      0,0FFH,0FFH,0FFH,10, 5, 2, 1
	DB	 1, 0, 1, 5, 5, 0, 0,0FFH
TSTA3:  DB      0,0FFH,0FFH,0FFH,0FFH,10,0FFH, 2
	DB	 1, 2, 1,10, 5,10, 5,0FFH
;
ROW:    DB      0
        DB      22,43,64, 1,23,42,61, 4
        DB      26,39,52,13,27,38,49,16
        DB      22,42,62, 2,23,43,63, 9, 4,19,34,61,16,31,46
        DB      49,13,25,37,52,16,28,40
        DB      52, 1,18,35,64,13,30,47
        DB      49, 1,17,33,52, 4,20,36
        DB      61,13,29,45,64,16,32,48
        DB       4, 1, 2, 3,16,13,14,15
        DB      13, 1, 5, 9,16, 4, 8,12
        DB      16, 1, 6,11,13, 4, 7,10
        DB      52,49,50,51,64,61,62,63
        DB      61,49,53,57,64,52,56,60
        DB      64,49,54,59,61,52,55,58
        DB      18,34,50, 2,19,35,51, 3
        DB      21,37,53, 5,24,40,56,     MVI     C,BSPACE
        CALL    CO
        DCR     B
        JNZ     CURSLT
        RET
;
;
CURSRT:
        MVI     C,CRIGHT
        CALL    CO
        DCR     B
        JNZ     CURSRT
        RET
;
;
CURSHOME:
        MVI     C,ESC
        CALL    CO
        MVI     C,CHOME
        JMP     CO
;
CI:	CALL	CIX
	ANI	7FH
	RET
;
CO:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,C
	MVI	C,2
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
;
CSTS:	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,11
	CALL	BDOS
	POP	  +  +  +  +',CR,LF
        DB      '              +  +  +  +  '
        DB      '  +  +  +  +',CR,LF
        DB      '+  +  +  +  '
        DB      '  +  +  +  +',CR,LF
        DB      '+  +  +  +  '
        DB      '  +  +  +  +',CR,LF
        DB      '+  +  +  +',CR,LF
        DB      '+  +  +  +'
        DB      0
;
MSG1:   DB      'ENTER YOUR MOVE',0
MSG2:   DB      'TRY AGAIN      ',0
MSG3:   DB      'I AM THINKING !',0
MSG4:   DB      'TIE GAME !!!!!!',0
MSG5:   DB      'YOU HAVE LOST 1       ; NEW COLUMN POINTER
;
MOVEARY:        DS      65
SUM:            DS      77
TST1:           DS      1
TST2:           DS      1
TST3:           DS      1
M1:             DS      1
M2:             DS      1
M3:             DS      1
J3:             DS      2
K3:             DS      1
J4:             DS      1
J5:             DS      2
K5:             DS      1
L5:             DS      2
J6:             DS      2
K6:             DS      1
J7:             DS      1
J8:             DS3
        DB      23,38,53, 8,27,42,57,12
        DB      26,38,50,14,27,39,51,15
        DB      22,39,56, 5,26,43,60, 9
        DB      22,38,54, 6,23,39,55, 7
        DB      26,42,58,10,27,43,59,11
        DB      22,23,24,21,26,27,28,25
        DB      22,26,30,18,23,27,31,19
        DB      22,27,32,17,23,26,29,20
        DB      38,39,40,37,42,43,44,41
        DB      38,42,46,34,39,43,47,35
        DB      38,43,48,33,39,42,45,36
        DB      61, 1,21,41,64, 4,24,44
        DB      4 8
        DB      25,41,57, 9,28,44,60,12
        DB      30,46,62,14,31,47,63,15
        DB       6, 7, 8, 5,10,11,12, 9
        DB       6,10,14, 2, 7,11,15, 3
        DB      18,19,20,17,30,31,32,29
        DB      21,25,29,17,24,28,32,20
        DB      34,35,36,33,46,47,48,45
        DB      37,41,45,33,40,44,48,36
        DB      54,55,56,53,58,59,60,57
        DB      54,58,62,50,55,59,63,51
;
	DS	128		;64-WORD STACK
STACK:
	; RESERVE 9 BYTES TO HOLD USER'S WBOOT, CSTS AND CI ENTRY POINTS
;
WBOOTX:	DS	3
CSTSX:	DS	3
CIX:	DS	3
;
	END	TTT3D
;	THE GAME OF DEFLECTION     BY ANDREW A. RECUPERO
;	FROM KILOBAUD FEB '78 #14
;
;	TO START TYPE 0,1,2,3
;		0=1 TARGET, CLEAR FIELD
;		1=1 TARGET, SHIFT DEFLECTORS
;		2=3 TARGETS, CLEAR FIELD
;		3=3 TARGETS, SHIFT DEFLECTORS
;
;	THE OBJECT OF THE GAME IS TO HIT TARGET(S) BY
;	DEFLECTING THE RUNNER INTO THE TARGET.
;
;	DEFLECT TARGET BY TYPING A "/" OR A "\".
;
;	ALL TARGETS MUST BE HIT WITHIN A FIXED TIME.
;
;SYSTEM EQUATES:
;
	ORG	100H
STATUS 	EQU	00	;KEYBOARD STATUS PORT
STROBE	EQU	80HUNNER
IDLE	CALL	ACTION		;MOVE RUNNER
	CALL 	DELAY		;TIME DELAY AND CHECK INPUT
	MOV	A,C		;KEYBOARD INPUT TO ACC.
	ORA	A		;TEST FOR NON-ZERO
	JZ	IDLE
	MVI	M,20H		;REMOVE RUNNER
	RRC			;SHIFT DEFLECTORS?
	PUSH	PSW		;SAVE GAME OPTION IN 'A' REG
	JC	SHIFT		;JUMP TO SHIFT IF YES
	CALL	CLSCRN		;DO NOT SHIFT, CLEAR SCREEN
	JMP	INIT
SHIFT	LXI	B,VDMRAM	;SHIFT
	MOV	D,B		;   SCREEN
	MOV	E,C		;      ONE
	INX	D		;        POSITION
SMOR	LDAX	D		;              TO
	STAX	B		;               THE
	INX	B		;		  AME TIMER
	SHLD	TIMER		;SAVE TIMER VALUE
	CALL	DRUNER		;START GAME, DISPLAY RUNNER
;
;
;	THIS IS THE MAIN LOOP FOR THE GAME
;
MAINLP	CALL	DELAY		;WAIT & CHECK KEYBOARD
	CALL	ACTION	
	PUSH	H		;SAVE HL
	LHLD	TIMER		;GET GAME TIMER
	DCX	H		;DECREMENT TIMER
	MOV	A,H		;CHECK IF GAME
	ORA	L		;	TIMER EXPIRED
	SHLD	TIMER		;STORE UPDATED TIMER
	POP	H		;RESTORE HL
	JNZ	MAINLP		;JMP IF TIMER DIDN'T EXPIRE
	LXI	B,LOSE		;DISPLAY NO
	CALL	SHOW		;	TIME MESSAGE
	CALL	WAER		;WAIT & ERASE MESSAGE
	JMP	GSTOM FIELD
;
;	CALCULATE NEW RUNNER POSITION
;
DF010	MOV	A,B
	CPI	RIGHT		;IS MOTION TO RIGHT?
	JNZ	DF012		;JUMP IF NO
	INR 	E		;MOVE 1 POS TO THE RIGHT
DF012	CPI	UP		;IS MOTION UP?
	JNZ	DF014		;JUMP IF NO
	DCR	D		;MOVE 1 POS UP
DF014	CPI	DOWN		;IS MOTION DOWN?
	JNZ	DF016		;JUMP IF NO
	INR 	D		;MOVE 1 POS DOWN
DF016	CPI	LEFT		;IS MOTION TO THE LEFT?
	JNZ	DF018		;JUMP IF NO
	DCR	E		;MOVE 1 POS TO LEFT
;
;	CALCULATE FIELD POSITION FROM HORZ AND VERT VALUES
;	IN DE WITH RESULT IN HL
;
DF018	M	;KEYBOARD STROBE BIT
DATA	EQU	1	;KEYBOARD DATA PORT
VDMRAM	EQU	0CC00H	;VDM STARTING ADDR.
VDMPAGE	EQU	0CCH	;VDM RAM PAGE
VDMPORT	EQU	0C8H	;VDM PORT
TARGET	EQU	05	;TARGET SYMBOL
RUNNER	EQU	07	;RUNNER SYMBOL
USLSH	EQU	2FH	;UP SLASH SYMBOL "/"
DSLSH	EQU	5CH	;DOWN SLASH SYMBOL "\"
LEFT	EQU	80H	;RUNNER
DOWN	EQU	40H	;	DIRECTION
UP	EQU	20H	;		CONTROL
RIGHT	EQU	10H	;			EQUATES
;
;
;	PROGRAM START
;
GSTART	LXI	SP,STACK+8	;INITIALIZE STACK
	CALL	CLSCRN		;CLEAR SCREEN
REIDLE	CALL	DRUNER		;DISPLAY RLEFT
	INX	D	
	MOV	A,D
	CPI	VDMPAGE+4
	JNZ	SMOR		;GO SHIFT MORE IF NOT DONE
INIT	POP	PSW		;RESTORE GAME OPTION TO 'A' REG
	MVI	C,1		;SET FOR ONE TARGET
	RRC			;GAME OPTION BIT 0 TO CARRY FLG
	MVI	A,TARGET	;TARGET SYMBOL TO 'A' REG
	JNC	GAM1		;JUMP FOR 1 TARGET OPTION
	MVI	C,3		;INITIALIZE FOR 3 TARGETS
	STA	VDMRAM+34CH	;PUT TARGET LEFT OF CENTER
	STA	VDMRAM+2F4H	;TARGET TO THE RIGHT
GAM1	STA	VDMRAM+320H	;TARGET IN THE MIDDLE
	MOV	A,C
	STA	TARNUM		;STORE # OF TARGETS
	LXI	H,1C0H		;INITIALIZE GART		;TIMER EXPIRED, RESTART GAME
;
;
;	INITIALIZE AND DISPLAY RUNNER
;		'B' HOLDS MOTION DIRECTION AS:
;		REG BIT 7 6 5 4
;			| | | |
;			| | | RIGHT
;			| | UP
;			| DOWN
;			LEFT
;
DRUNER	LXI	H,VDMRAM+40H	;RUNNER STARTING POS.
	LXI	D,100H		;X,Y RUNNER POS. D=VERT E=HORZ
	MVI	M,RUNNER	;DISPLAY RUNNER
	MVI	B,RIGHT		;INITIALIZE RIGHT MOTION
	RET
;
;
;	ALL RUNNER MOVEMENT DONE HERE
;
ACTION	MOV	A,M		;CHECK IF
	CPI	RUNNER		;	RUNNER
	JNZ	DF010		;		DISPLAYED
	MVI	M,20H		;REMOVE RUNNER FROV	A,D
	RRC
	RRC
	MOV	L,A
	ANI	03
	ORI	VDMPAGE
	MOV	H,A		;SAVE HIGH PART OF ADDR.
	MOV	A,L
	ANI	0C0H
	ADD	E
	MOV	L,A		;SAVE LOW PART OF ADDR.
	MOV	A,M		;CHECK NEXT FIELD POSITION
	CPI	TARGET		;IS IT A TARGET?
	JNZ	DF019		;JUMP IF DIDN'T HIT TARGET
;
;	HIT A TARGET
;
	MVI	M,20H		;REMOVE TARGET
	LDA	TARNUM		;GET # OF TARGETS LEFT
	DCR	A		;REDUCE BY ONE
	STA	TARNUM		;STORE UPDATED TARGET NUMBER
	RNZ			;RETURN IF MORE TARGETS
	POP	D		;ALL TARGETS GONE, FIX STACK
	LXI	B,WIN		;DISPLAY
	CALL	SHOW		;	WIN MESSAGE
	CALL	WAER		;WAIT & ERASE MESSAGE
	JMP	REIDLE		;GO TO IDLE LOOP
;
DF019	MOV	A,C		;PUT KEYBOARD DATA IN 'A' REG
	CPI	USLSH		;IS IT AN UPSLASH "/" ?
	JZ	DF020		;JUMP IF YES
	CPI	DSLSH		;IS IT A DOWNSLASH "\" ?
	JZ	DF020		;JUMP TO ANALYZE DEFLECTOR
;
;	CHECK FOR RUNNER HITTING A DEFLECTOR
;
DELCK	MOV	A,M
	CPI	20H		;IS NEXT POSITION A SPACE?
	JNZ	CHGMOT		;DEFLECTOR IF NO, CHNGE DIR
	CALL	EDGCK		;REVERSE MOTION IF AT EDGE
	MVI	M,RUNNER	;DISPLAY RUNNER AT NEW LOCATION
	RET
ON FLAG TO 'A' REG
	JZ	DF040		;JUMP IF NOT LEFT OR UP
	RRC			;CHANGE DIR TO RIGHT OR DOWN
	JMP	DF050
DF040	RLC			;CHANGE MOTION TO RIGHT OR DOWN
DF050	MOV	B,A		;SAVE NEW DIRECTION
	CALL	EDGCK		;IS RUNNER AT EDGE OF FIELD?
	MOV	A,M		;GET DEFLECTOR IN CASE AT EDGE
	JZ	CHGMOT		;IF AT EDGE, CHANGE DIRECTION
	RET
;
;	THIS ROUTINE CHECKS FOR EDGE OF FIELD, REVERSES MOTION,
;	SETS ZERO FLAG IF AT EDGE
;
EDGCK	MOV	A,B		;LOAD MOTION DETECTOR
	CPI	RIGHT		;TO RIGHT?
	JNZ	DF060		;JUMP IF NO
	MVI	A,3FH		;MUST BE MOTION TO LEFT
	ORA	E		;CHECK FOR LEFT EDGE HORZ=0
	RNZ			;RETURN IF NOT AT LEFT EDGE
	MVI	B,RIGHT		;REVERSE DIRECTION TO RIGHT
	RET
;
;	THIS ROUTINE PERFORMES TIME DELAY WHILE CONTINUOUSLY
;	CHECKING FOR KEYBOARD INPUT. INPUT RETURN IN 'C'
;
DELAY	MVI	C,0		;INITIALIZE INPUT SAVE REG
	PUSH	D		;FREE UP DE REG
	LXI	D,700H		;LOAD DELAY VALUE
DL01	DCX	D		;DECREMENT DELAY COUNTER
	IN	STATUS		;GET KEYBOARD STATUS
	ANI	STROBE		;CHECK STROBE
	JNZ	DL02		;JUMP IF NO INPUT
	IN	DATA		;GET KEYBO BY BC REG
;
SHOW	LXI	D,VDMRAM+31DH	;POINT TO DISPLAY LOCATION
	MVI	H,7		;MESSAGE LENGTH=7
SH01	LDAX	B		;GET BYTE OF MESSAGE
	STAX	D		;DISPLAY IT
	INX	D		;BUMP TO
	INX	B		;	NEXT BYTE
	DCR	H		;DECREMENT COUNT
	JNZ	SH01		;DONE?
	RET
;
;	THIS ROUTINE WAITS AWHILE AND THEN REMOVES MESSAGE
;
WAER	MVI	D,32		;LOAD UNITS OF DELAY
WDLY	CALL	DELAY		;WAIT ONE UNIT OF DELAY
	DCR	D		;CHECK IF
	JNZ	WDLY		;	DONE WAITING
	LXI	B,BLNK		;POINT TO ALL BLANKS
	JMP	SHOW		;DISPLAY BLANKS TO ERASE & RET
;
;	M;	ALPHA-NUMERIC MUSIC WITH AMPLITUDE CONTROL
;
;	COPYRIGHT 1975 BY MALCOLM T. WRIGHT
;
;	AVAILABLE FROM: PEOPLE'S COMPUTER COMPANY
;			BOX 310
;			MENLO PARK, CALIFORNIA 94025
;
PORT	EQU	02H		;PARALLEL OUTPUT PORT
;
	ORG	100H
	LXI	H,TABLE		;START OF MUSIC TABLE
NEXT	INX	H
	MOV	A,M
	ANI	7FH		;ERASE PARITY
	LXI	D,NEXT		;LOAD STACK WITH RETURN ADDR
	PUSH	D		;FOR CHARACTER SEARCH
	NOP
	CPI	'L'		;IS THE CHARACTER AN 'L' ?
	JNZ	CTRLA
LEAVE	INX	SP
	INX	SP
	RET			;RETURN TO SUPERVISOR PROG.
CDF020	MOV	M,A		;INPUT WAS VALID, DISPLAY IT
;
;	CHANGE DIRECTION OF RUNNER MOTION
;
CHGMOT	CPI	DSLSH		;IS IT A DOWNSLASH?
	MOV	A,B		;DIRECTION FLAG TO 'A' REG
	JNZ	UPSLH		;JUMP IF NOT DOWN SLASH
	ANI	0C0H		;IS MOTION LEFT OR DOWN?
	MOV	A,B		;RESTORE DIRECTION FLAG TO 'A'
	JZ	DF030		;JUMP IF NOT LEFT OR DOWN
	RRC			;CHANGE DIRECTION TO
	RRC			;	RIGHT OR UP
	JMP	DF050
DF030	RLC			;CHANGE DIRECTION TO
	RLC			;	LEFT OR DOWN
	JMP	DF050
UPSLH	ANI	0A0H		;IS MOTION TO LEFT OR UP?
	MOV	A,B		;DIRECTI	;3FH=RIGHT EDGE
	CMP	E
	RNZ			;RETURN IF NOT AT RIGHT EDGE
	MVI	B,LEFT		;REVERSE DIRECTION TO LEFT
	RET
DF060	CPI	UP		;CHECK FOR UP MOTION
	JNZ	DF070		;JUMP IF MOTION NOT UP
	XRA	A
	ORA	D		;CHECK FOR TOP VERT=0
	RNZ			;RETURN IF NOT AT TOP
	MVI	B,DOWN		;REVERSE DIRECTION TO DOWN
	RET
DF070	CPI	DOWN		;CHECK FOR DOWN MOTION
	JNZ	DF080		;JUMP IF MOTION NOT DOWN
	MVI	A,0FH		;CHECK FOR BOTTOM VERT=0FH
	CMP	D
	RNZ			;RETURN IF NOT AT BOTTOM
	MVI	B,UP		;REVERSE DIRECTION TO UP
	RET
DF080	XRA	A	OARD DATA
	ANI	7FH		;REMOVE BIT 7
	MOV	C,A		;SAVE INPUT IN 'C' REG
DL02	MOV	A,D		;CHECK FOR
	ORA	E		;	TIMER=0
	JNZ	DL01
	POP	D		;DELAY OVER, RESTORE DE REG
	RET
;
;	THIS ROUTINE INITIALIZES THE VDM PORT & CLEARS SCREEN
;
CLSCRN	XRA	A		;CLEAR VDM PORT
	OUT	VDMPORT		;OUTPUT IT
	LXI	H,VDMRAM	;POINT TO START OF VDM RAM
	MVI	A,VDMPAGE+4	;'A' REG=END OF VDM RAM
CL01	MVI	M,20H		;BLANK LOC GIVEN BY HL
	INX	H
	CMP	H		;DONE?
	JNZ	CL01		;JUMP IF NOT
	RET
;
;	THIS ROUTINE DISPLAYS MESSAGE POINTED TESSAGES
;
WIN	DB	'WINNER '
LOSE	DB	'NO TIME'
BLNK	DB	'       '
;
;	SAVE AREAS AND STACK
;
TIMER	DS	2		;TIMER SAVE AREA
TARNUM	DS	1		;NUMBER OF TARGETS
STACK	DS	8		;STACK AREA (ONLY 4 DEEP)
TRLA	CPI	'A'-40H		;IS IT A CONTROL A ?
	JNZ	CTRLE
	STA	SAVEF		;SAVE CTRL-A AS FLAG
	RET			;RETURN TO NEXT
CTRLE	CPI	'E'-40H		;IS IT A CONTROL-E ?
	JZ	ENVEL		;GO TO ENVELOPE ROUTINE
	CPI	'V'-40H		;IS IT A CONTROL-V ?
	JZ	VOL		;GO TO VOLUME ROUTINE
	CPI	'T'-40H		;IS IT A CONTROL-T ?
	JZ	TEMPO		;GO TO TEMPO ROUTINE
	CPI	'R'-40H		;IS IT A CONTROL-R ?
	JZ	REP		;GO TO REPEAT ROUTINE
	CPI	'J'-40H		;IS IT A CONTROL-J ?
	JZ	JOUT		;GO TO JUMP-OUT ROUTINE
	CPI	'S'-40H		;IS IT A CONTROL-S ?
	JZ	STOP		;GO TO STOP-REPEAT ROUTINE
	CPI	'R'		;IS IT AN 'R' ?
	JZ	REST		;GO TO REST ROUTINE
	MOV	B,A
	IN	01H
	CPI	'S'		;IS IT AN 'S' ?
	MOV	A,B
	JZ	LEAVE		;LEAVE MUSIC PROG
	DI
	CPI	'1'		;IS IT A '1' ? OCTAVE # SEARCH
	JC	DURA
	CPI	'7'		;IS IT A '7' ?
	JNC	DURA
	ANI	07H		;SAVE LS 3 BITS
	STA	SAVEO
	PUSH	H		;SAVE MUSIC TABLE ADDR
	CPI	04H		;IS IT THE 4TH OCTAVE
	JC	CHGLP
	LXI	H,LOOP1
	JMP	INSTR
CHGLP	LXI	H,SLOW
INSTR	SHLD	JUMP		;LOAD IN NEW JUMP ADDR
	POP	H
	RET			;RETURN TO NEXT
DURA	MVI	B,01H		'D'		;IS IT A 'D' ?
	RZ
	INR	B
	INR	B
	CPI	'E'		;IS IT AN 'E' ?
	RZ
	INR	B
	CPI	'F'		;IS IT AN 'F' ?
	RZ
	INR	B
	INR	B
	CPI	'G'		;IS IT A 'G' ?
	RZ
	INR	B
	INR	B
	CPI	'A'		;IS IT AN 'A' ?
	RZ
	INR	B
	INR	B
	CPI	'B'		;IS IT A 'B' ?
	RET			;TO ADDR2
ADDR2	RNZ			;TO NEXT
	INX	H
	MOV	A,M
	CPI	'!'		;IS IT AN EXCLAMATION (FLAT) ?
	JNZ	SNOTE
	DCR	B
	JMP	STONOTE
SNOTE	CPI	'#'		;IS IT A '#' ?
	JNZ	NOTFD
	INR	B
	JMP	STONOTE
NOTFD	DCX	H
STONOTE	MOV	A,B
	STA	SAVEN
	PUSH	H
	LDA	SAVEO	NOPS AND STORE IT
	SHLD	CHGT
OPMET	LDA	SAVET		;START TEMPO LOOK-UP
	MOV	B,A
	LXI	H,TEMPO		;1ST ADDR OF TEMPO TABLE
	LXI	D,1CH		;# OF BYTES IN AN OCTAVE
BAK2	DCR	B
	JZ	GETD
	DAD	D
	JMP	BAK2
GETD	LDA	SAVEN		;NOTE DURATION SEARCH
	RLC			;MULTIPLY BY TWO ACC
	MOV	E,A
	DAD	D
	MOV	E,M		;GET LOWER HALF OF DURATION
	INX	H
	MOV	D,M		;GET UPPER HALF OF DURATION
	LDA	SAVEO
	CMA			;CONVERT 1-6 TO 6-1
	ANI	07H
	MOV	B,A
BAK3	DCR	B
	JZ	CONT1
	CALL	DPSR		;DOUBLE PRECISION SHIFT RIGHT
	JMP	BAK3
DPSRL WITH OUTPUT INSTR
	SHLD	OUT1
	SHLD	OUT2
	POP	H		;RESTORE HL TO MUSIC TABLE
	RET			;TO NEXT
ENVEL	INX	H		;ENVELOPE ROUTINE
	MOV	A,M
	ANI	0FH
	INR	A
	STA	SAVEE
	CALL	SPENV		;CONSTRUCT SPECIAL ENVELOPE
	RET			;TO NEXT
SPENV	PUSH	H
	LXI	D,09H		;LOAD LENGTH OF ENVELOPE
	LXI	H,ENVELO	;1ST ADDR OF ENVELOPE TABLE
	LDA	SAVEE
	MOV	B,A
	BAK5	DCR	B
	JZ	CONT2
	DAD	D
	JMP	BAK5
CONT2	LXI	D,SPEC		;1ST ADDR OF SPECIAL TABLE
	LDA	SAVEV
	MOV	B,A
	MOV	C,B
	MOV	A,M		;GET ENVELOPE VALUE
BAK6	DCR	B
	JH
	JNZ	CONT5
	LHLD	ENDT
CONT5	RET			;TO NEXT
STOP	SHLD	ENDT		;STOP-REPEAT ROUTINE
	LDA	SAVER
	DCR	A
	STA	SAVER		;REPEAT # -1
	CPI	00H
	JZ	CONT6
	LHLD	STAR
CONT6	RET			;TO NEXT
REST	PUSH	H		;REST ROUTINE
	LXI	H,0000H		;CLEAR HL
	SHLD	OUT1
	SHLD	OUT2
	JMP	OPMET
;
;	SAVE TABLE
;
SAVET	DS	1		;TEMPO #
SAVEV	DS	1		;VOLUME #
SAVEE	DS	1		;ENVELOPE #
SAVEO	DS	1		;OCTAVE #
SAVED	DS	1		;DURATION #
SAVEN	DS	1		;HALF-TONE #
SAVEF	DS	1		;CONTROL-A FLAG
SAVER	DS	1		;REPEAT #
STAR	DS	2		;STORE F;DURATION CHARACTER SEARCH
	LXI	D,ADDR1
	PUSH	D
	CPI	'W'		;IS IT A 'W' ?
	RZ
	INR	B
	CPI	'H'		;IS IT AN 'H' ?
	RZ
	INR	B
	CPI	'Q'		;IS IT A 'Q' ?
	RZ
	INR	B
	CPI	'O'		;IS IT AN 'O' ?
	RZ
	INR	B
	CPI	'S'		;IS IT AN 'S' ?
	RZ
	INR	B
	CPI	'T'		;IS IT A 'T' ?
	RET
ADDR1	JNZ	NOTE
	MOV	A,B
	STA	SAVED
	XRA	A		;ZERO ACC
	STA	SAVEF		;ERASE CONTROL-A FLAG
	RET			;RETURN TO NEXT
NOTE	MVI	B,01H		;NOTE CHARACTER SEARCH
	LXI	D,ADDR2
	PUSH	D
	CPI	'C'		;IS IT A 'C' ?
	RZ
	INR	B
	INR	B
	CPI		;START FREQ LOOK-UP
	MOV	B,A
	LXI	H,FREQ		;1ST ADDR OF FREQ TABLE
	LXI	D,0EH		;# OF BYTES IN AN OCTAVE
BAK1	DCR	B
	JZ	GETN
	DAD	D
	JMP	BAK1
GETN	LDA	SAVEN
	MOV	E,A
	DAD	D
	MOV	A,M
	STA	FREQ1		;SAVE FREQ VALUE IN PLAY-NOTE
	MOV	B,A
	LDA	SAVEO
	CPI	04H
	MOV	A,B
	JC	LOW		;JUMP IF OCTAVE 1,2, OR 3
	SUI	04H		;SUBTRACT 4 FROM FREQ VALUE
	DB	21H		;LXI	H,
	DCR	C
	DCR	C
	JMP	STORE		;TO TWO DCR C
LOW	DCR	A
	DB	21H		;LXI	H,
	NOP			;CHANGE PLAY-NOTE INSTRUCTION
	NOP
STORE	STA	FREQ2		;TO TWO 	XRA	A		;RESET CARRY
	MOV	A,D
	RAR
	MOV	D,A
	MOV	A,E
	RAR
	MOV	E,A
	RET
CONT1	LDA	SAVED
	MOV	B,A
BAK4	DCR	B
	JZ	GETF
	CALL	DPSR
	JMP	BAK4
GETF	LDA	SAVEF
	CPI	'A'-40H		;IS IT A CONTROL 'A' ?
	LXI	H,0000H		;CLEAR HL
	JNZ	NOFG
	DAD	D		;SET HL = DE
	CALL	DPSR
NOFG	DAD	D
	XCHG			;SET DE = HL
	XRA	A		;ZERO ACC
	CMP	D		;DON'T LET D AND E = 0
	JNZ	INRD
	CMP	E
	JNZ	INRD
	INR	E
INRD	INR	D
	XCHG			;PUT DE INTO HL
	SHLD	DUR1+1
	SHLD	DUR2+1
	CALL	PLAY
	DB	21H		;LXI	H,
	OUT	PORT		;LOAD HNZ	CONT3
	ORA	A		;CLEAR CARRY
	RAL
	JMP	BAK6
CONT3	STAX	D
	MOV	B,C
	INX	D
	INX	H
	MOV	A,M
	ORA	A		;SET PARITY FLAG
	JPE	CONT4
	JMP	BAK6
CONT4	POP	H
	RET
VOL	INX	H		;VOLUME ROUTINE
	MOV	A,M
	ANI	07H
	STA	SAVEV
	CALL	SPENV
	RET			;TO NEXT
TEM	INX	H		;TEMPO ROUTINE
	MOV	A,M
	ANI	07H
	STA	SAVET
	RET			;TO NEXT
	NOP
REP	INX	H		;REPEAT ROUTINE
	MOV	A,M
	ANI	0FH
	INR	A
	STA	SAVER
	SHLD	STAR
	RET			;TO NEXT
JOUT	LDA	SAVER		;JUMP OUT ROUTINE
	DCR	A
	STA	SAVER		;REPEAT # -1
	CPI	00OR HL
ENDT	DS	2		;STORE FOR HL
	NOP
;
;	PLAY NOTE ROUTINE
;
PLAY	LXI	H,SPEC		;START OF SPECIAL TABLE
	MVI	B,09H		;# OF SEGMENTS
	MOV	A,M
DUR1	LXI	D,016FH		;DURATION OF NOTE
LOOP2	MOV	A,A		;TIME EQUALIZER
	JMP	CYCLE		;TIME EQUALIZER
CYCLE	DB	0EH		;MVI	C,
FREQ1	DB	0A3H
OUT1	OUT	PORT
LOOP1	DCR	C
	DB	0C2H		;JNZ
JUMP	DW	LOOP1
	XRA	M
	DCR	E
	JNZ	LOOP2
	DCR	D
	JNZ	CYCLE
	ORI	00H		;TIME EQUALIZER
OUT2	OUT	PORT
	INX	H
	DCR	B
	JZ	EXIT
DUR2	LXI	D,016FH
	DB	0EH		;MVI	C,
FREQ2	DB	9FH		;TIME EQUALIZER
	CPI	00H		;EVEN-ODD CYCLE TESTER
	MVI	A,00H
	JZ	LOOP1
CHGT	DCR	C		;TIME EQUALIZER
	DCR	C		;TIME EQUALIZER
	NOP			;TIME EQUALIZER
	MOV	A,M
	JMP	LOOP1
EXIT	RET
	NOP
SLOW	PUSH	PSW
	MVI	A,02H
COUNT	DCR	A
	JNZ	COUNT
	POP	PSW
	JMP	LOOP1
;
;	TEMPO TABLE
;
;	100 BEATS PER MINUTE
TEMPO	DB	0FH,02H,2EH,02H,4FH,02H,72H,02H,98H,02H,0BFH
	DB	02H,0E9H,02H,15H,03H,44H,03H,76H,03H,0ABH
	DB	03H,0E2H,03H,1DH,04H,5CH,04H
;	125 BEATS PER MINUTE
	DB	0A5H,01H,0BFH,01H,0D9H,01H,0F5H,01H,13H,02H
3EH,3BH
;	3RD OCTAVE
	DB	3EH,3BH,37H,34H,31H,2EH,2CH,29H,27H,25H
	DB	23H,21H,1FH,1DH
;	4TH OCTAVE
	DB	0ADH,0A3H,99H,9DH,88H,80H
	DB	79H,72H,68H,65H,5FH,5AH,54H,50H
;	5TH OCTAVE
	DB	54H,50H,4BH,46H,42H,3EH,38H
	DB	37H,34H,31H,2EH,2BH,28H,26H
;	6TH OCTAVE
	DB	28H,26H,24H,21H,1FH,1DH,1CH
	DB	1AH,18H,17H,15H,14H,12H,11H
;
;	SPECIAL TABLE
;
SPEC	DB	07H,07H,07H,07H,07H,07H,07H,07H,00H
;
;	ENVELOPE TABLE
;
ENVELO	DB	07H,07H,07H,07H,07H,07H,07H,07H,00H	;^E-0
	DB	07H,07H,07H,07H,80H,80H,80H,80H,!#~ L332ʁd
RGSx1m7m2e!.h!Y"0WHQOSTx22CDEFGAB#~!#+x2:G! :_~2+G:x!

=!  2H"P:G!d  :_^#V:/GB:0zW{_:GP:F:!  _:믺kk"$"E!","=#~<2͍	 !1:GʠØ(:GH~²éA#~é#~2͍#~2 #~<2":=2 *":=2 *ORE/FQDHD/35HC4ODC/3HAQD4OE/OFQFFSFF/5HCOR4E/FODHD/4QRODDFFAA/WG/QROCCEEGG/WF/1QROFFAA5CC/QDOCHC/4QROFFQA5OCC/QDQDDDDQE/OFFFFEQD/HCOCCSDDOC/4HAORE/FQFQOFF/5WCOR4E/FQDHD/D/LkW!Z #

#
#
@zʴ=ʮ;
;
;
	ORG	100H
RESTART	MVI	A,0
	OUT	0C8H
	LXI	SP,JUMPS
	CALL	SETUP
;
;
;
MAINLP	LXI	H,VTABL
	INX	H
	MOV	A,M
	CPI	DEAD
	JZ	MP1
	PUSH	H
	CALL	ADDSCR
	LDA	SCRFLG
	ORA	A
	CP	VMOVE
	POP	H
MP1	CALL	USER
	CALL	BIGCTR
	CALL	NEWFISH
	LXI	H,VTABL
	MVI	B,MAXFISH+1
FISHES	PUSH	B
	PUSH	H
	CALL	FISHY
	POP	H
	CALL	BUMP6
	POP	B
	DCR	B
	JNZ	FISHES
	JMP	MAINLP
;
;
;
SETPHA	LXI	H,ETV-LENL+6
	MOV	C,A
	LXI	D,PHAMSG
	MVI	B,0AH
MOVPHA	LDAX	D
	ORI	BIAS
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	DB	033H,02H,54H,02H,77H,02H,9DH,02H,0C5H,02H,0EFH
	DB	02H,1CH,03H,4BH,03H,7DH,03H
;	150 BEATS PER MINUTE
	DB	5FH,01H,74H,01H,84H,01H,0A2H,01H,0BAH,01H
	DB	0D5H,01H,0F1H,01H,0EH,02H,2EH,02H,4FH,02H,72H
	DB	02H,97H,02H,0BEH,02H,0E8H,02H
;	SPARE TEMPO
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
;	FREQUENCY TABLE
;
;	1ST OCTAVE
FREQ	DB	0FAH,0ECH,0DFH,0D3H,0C7H,0BBH,0B1H,0A7H
	DB	9EH,95H,8CH,84H,7DH,76H
;	2ND OCTAVE
	DB	7DH,76H,6FH,69H
	DB	63H,5DH,58H,53H,4EH,4AH,46H,42H,00H	;^E-1
	DB	07H,07H,80H,07H,07H,80H,07H,07H,00H	;^E-2
	DB	07H,86H,85H,04H,83H,02H,01H,80H,00H	;^E-3
	DB	01H,02H,83H,04H,85H,86H,07H,80H,00H	;^E-4
	DB	01H,02H,85H,07H,07H,85H,02H,01H,00H	;^E-5
	DB	0,0,0,0,0,0,0,0,0			;SPARE
	DB	0,0,0,0,0,0,0,0,0			;SPARE
	DB	0,0,0,0,0,0,0,0,0			;SPARE
	DB	0,0,0,0,0,0,0,0,0			;SPARE
;
;	MUSIC TABLE
;	START OF USER WRITTEN MUSIC
;
TABLE	DS	100
	END
!  ","=  Xm !(	~4*
.&* #W4 > .

 ~. >=\..OrDv\3TwK}_t.Or                            ǻ}v}voic]XSNJFB>;>;741.,)'%#!yrhe_ZTPTPKFB>8741.+(&(&$!                                           22544ODDFFAA/WG/ORCCCEEGG/WF/ORFFFAA5CC/HDC/QR4OFFAA5CC/HDC/4QROFF/5ODQDQDODE/OFQFOEQD/
HCODC/W4A/ORFFF/5HC4
	JNZ	MOVPHA
	MOV	A,C
	ADI	ZERO
	STA	ETV-LENL+16
	SUI	ZERO
	RLC
	RLC
	RLC
	MVI	D,0
	MOV	E,A
	LHLD	CTLPTR
	DAD	D
	LXI	D,LNEWF
	MVI	B,8
TRPHA	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	TRPHA
	MVI	A,0
	STA	BIGTWO
	RET
;
;
;
BMTPHA	LDA	PHASE
	CPI	9
	RZ
	INR	A
	STA	PHASE
	CALL	SETPHA
	RET
;
;
;
STOP	POP	H
GETPHA	CALL	INPUT
	CPI	'0'
	RC
	CPI	'9'
	RNC
	SUI	'0'
	STA	PHASE
	CALL	SETPHA
	RET
;
;
;
ADDSCR	LDA	PHASE
	INR	A
	MOV	B,A
	LXI	H,STV-12
MORSCR	CALL	SCORIT
	DCR	B
	JNZ	MORSCR
	LXI	H,VPOS
	MOV	D,M
	INX	H
	MOV	E,M
	CALL	CONVERT
	LDA	GOODCAL
	CMP	D
	JNZ	CHKBMP
	CPI	ONE
	JNZ	LEFTCOL
	MVI	A,WIDTH-2
	JMP	SETCOL
LEFTCOL	MVI	A,ONE
SETCOL	STA	GOODCAL
	LDA	LBONUS
	MOV	B,A
GIVBON	LXI	H,STV-12
	CALL	ASCBMP
	DCR	B
	JNZ	GIVBON
CHKBMP	LDA	BIGTWO
	CPI	14H
	RNZ
	JMP	BMTPHA
;
;
;
SCORIT	LDA	SCRCTR
	INR	A
	STA	SCRCTR
	CPI	2DH
	RNZ
	MVI	A,0
	STA	SCRCTR
ASCBMP	MOV	A,M
	CPI	BLANK
	JNZ	GOTDIG
	MVI	M,ZERO+1
	RET
GOTDIG	CPI	ZERO+9
	JNZ	NOT9
	MV
	CALL	RANDOM
	CPI	0
	RNZ
	CALL	ALIVE
	MOV	A,H
	ORA	A
	JNZ	GOTFISH
	MOV	A,L
	ORA	A
	RZ
GOTFISH	MVI	M,ONE
	INX	H
	MVI	A,64H
	CALL	RANDOM
	MOV	B,A
	LDA	LTRACK
	CMP	B
	JNC	DOTRACK
	MVI	M,NOTRK
	JMP	NOTRACK
DOTRACK	MVI	M,FTRK
NOTRACK	INX	H
	LDA	LSRNG
	CALL	RANDOM
	MOV	B,A
	LDA	LMINS
	ADD	B
	MOV	M,A
	DCX	H
	DCX	H
	MOV	A,M
	CALL	BUMP3
	PUSH	H
	LDA	LSIDE
	CALL	RANDOM
	CPI	3
	JZ	BRNLFT
	CPI	2
	JZ	BRNRHT
	CPI	ONE
	JZ	BRNTOP
	MVI	B,SUBL
	MVI	A,WIDTH-2
	LXI	H,ETV-3*LENL
	LXA
RAND1	LHLD	RPTR
	MVI	C,8
RAND3	MOV	A,H
	RRC
	XRA	H
	RRC
	RRC
	XRA	H
	RRC
	XRA	L
	RRC
	RRC
	RRC
	XRI	1
	ANI	1
	DAD	H
	ADD	L
	MOV	L,A
	DCR	C
	JNZ	RAND3
RAND	SHLD	RPTR
	MOV	A,H
	ADD	L
	MOV	H,A
	MOV	A,B
RAND2	MOV	L,A
	ADD	B
	CMP	B
	JNC	RAND2
	MOV	A,H
	CMP	L
	JNC	RAND1
TOPS	CMP	B
	JC	GOTNUM
	SUB	B
	JMP	TOPS
GOTNUM	POP	H
	POP	B
	RET
;
;
;
USER	IN	INSTAT
	ANI	RDA
	RNZ
	CALL	INPUT
	DCX	H
	MVI	M,1
	CALL	BUMP3
	PUSH	H
	LXI	H,CHARS
	MVI	B,CHARL
COMP	CMP	M
	JZ	FOU
	DCX	H
	MVI	M,VMAXS
	RET
;
;
;
SDIREC	DCX	H
	MVI	M,VFAST
	RET
;
;
;
HALT	POP	H
	MVI	M,0
	RET
;
;
;
AUTO	POP	H
	LDA	SCRFLG
	CMA
	STA	SCRFLG
	RET
;
;
;
ESC	LXI	B,CHARGO
	LXI	D,STRING
	LXI	H,DTV
ESC1	LDAX	D
	INX	D
	CPI	0FFH
	JZ	RESTART
	ORI	BIAS
	MOV	M,A
	INX	H
	CPI	'-'+BIAS
	JNZ	ESC1
	CALL	GET
	MVI	M,BLANK
	INX	H
	JMP	ESC1
GET	CALL	INPUT
	CPI	1BH
	JZ	RESTART
	STAX	B
	INX	B
	INX	B
	ORI	BIAS
	MOV	M,A
	INX	H
	RET
;
;
;
VMOVE	LXI	H,VTABL
	MOV	A,M
	CPI	ONE
	E,A
	MVI	B,8
WAY1	MOV	A,E
	RRC
	MOV	E,A
	ANA	D
	ORA	A
	JZ	FINDIREC
	DCR	B
	JNZ	WAY1
	MVI	M,0
	RET
GOTWAY	MOV	A,E
	RLC
	MOV	E,A
	RRC
	RRC
	ANA	E
FINDIREC	CALL	NBR2
	MOV	M,A
	MVI	B,7
SUBLOOP	LXI	H,STV-13
	CALL	ASCDEC
	DCR	B
	JNZ	SUBLOOP
	RET
;
;
;
NBR1	PUSH	H
	LXI	H,NBTB2
	MVI	A,0
	STA	COUNT
	MVI	A,8
LOOP1	STA	LCTR
	MOV	A,M
	ORA	A
	MOV	E,A
	MVI	D,0
	JP	FWD
	MVI	D,0FFH
FWD	XCHG
	DAD	B
	MOV	A,M
	XCHG
	INX	H
	CPI	BLANK
	JZ	NONBR
	CPI	BORDER
	JZ	NONBR
	MOV	D,M
	I	M,ZERO
	DCX	H
	JMP	ASCBMP
NOT9	INR	A
	MOV	M,A
	RET
;
;
;
SCRCTR	INX	B
ASCDEC	MOV	A,M
	CPI	BLANK
	JZ	CNTDEC
	CPI	ZERO
	JNZ	NOTZERO
	MVI	M,ZERO+9
	DCX	H
	JMP	ASCDEC
NOTZERO	DCR	A
	MOV	M,A
	CPI	ZERO
	RNZ
	DCX	H
	MVI	A,BLANK
	CMP	M
	RNZ
	INX	H
	MOV	M,A
	RET
;
;
;
CNTDEC	MVI	A,0FFH
	STA	SCRFLG
	RET
;
;
;
BIGCTR	LXI	H,BIGONE
	INR	M
	RNZ
	INX	H
	INR	M
	RNZ
	INX	H
	INR	M
	RNZ
	INX	H
	INR	M
	RET
;
;
;
NEWFISH	LDA	LNEWF
	CALL	RANDOM
	CPI	ONE
	RNZ
	MVI	A,FRATEI	D,1
	JMP	FBORN
BRNTOP	MVI	B,LENL
	MVI	A,WIDTH-2
	LXI	H,DTV+LENL
	LXI	D,1
	JMP	FBORN
BRNRHT	MVI	B,0FFH
	MVI	A,NLINES-3
	LXI	H,DTV+WIDTH-2
	LXI	D,LENL
	JMP	FBORN
BRNLFT	MVI	B,ONE
	MVI	A,NLINES-3
	LXI	H,DTV+1
	LXI	D,LENL
FBORN	CALL	RANDOM
	INR	A
MOVEIT	DAD	D
	DCR	A
	JNZ	MOVEIT
	XCHG
	POP	H
	LDAX	D
	CPI	BLANK
	JZ	SETFISH
	DCX	H
	DCX	H
	MVI	M,DEAD
	RET
;
;
;
SETFISH	MOV	M,B
	INX	H
	MOV	M,D
	INX	H
	MOV	M,E
	MVI	A,FISH
	STAX	D
	RET
;
;
;
RANDOM	PUSH	B
	PUSH	H
	MOV	B,ND
	INX	H
	DCR	B
	JNZ	COMP
RETURN	POP	H
	RET
FOUND	MVI	A,CHARL
	SUB	B
	ANI	0FEH
	MVI	H,JUMPS SHR 8
	MOV	L,A
	MOV	E,M
	INX	H
MOV	D,M
	XCHG
	PCHL
;
;
;
INPUT	IN	INSTAT
	ANI	RDA
	JNZ	INPUT
	IN	INDAT
	ANI	7FH
	RET
;
;
;
UP	MVI	A,SUBL
	JMP	MOVHIM
RIGHT	MVI	A,ONE
	JMP	MOVHIM
DOWN	MVI	A,LENL
	JMP	MOVHIM
LEFT	MVI	A,0FFH
	JMP	MOVHIM
UL	MVI	A,SUBL-1
	JMP	MOVHIM
UR	MVI	A,SUBL+1
	JMP	MOVHIM
LR	MVI	A,LENL+1
	JMP	MOVHIM
LL	MVI	A,LENL-1
MOVHIM	POP	H
	CMP	M
	JZ	SDIREC
	MOV	M,A
	RNZ
	LDA	STV-15
	CPI	BLANK
	RZ
	LXI	H,STV-12
	CALL	ASCDEC
	LXI	H,VPOS
	MOV	B,M
	INX	H
	MOV	C,M
	CALL	NBR1
	MOV	D,A
	DCX	H
	DCX	H
	MOV	A,M
	ORA	A
	JNZ	MOVING
	LDA	GOODCAL
	CPI	ONE
	MVI	A,0FFH
	JZ	EQUAL1
	 MVI	A,ONE
EQUAL1	MOV	M,A
MOVING	CALL	NBR3
	MOV	E,A
	RLC
	ADD	E
	MOV	E,A
	RRC
	ORA	E
	MOV	E,A
	ANA	D
	ORA	A
	RZ
	MVI	B,7
	LDA	ROTATE
	XRI	8
	STA	ROTATE
WAY3	MOV	A,E
ROTATE	RLC
	MOV	E,A
	ANA	D
	ORA	A
	JZ	GOTWAY
	DCR	B
	JNZ	WAY3
	MOV	A,E
	RLC
	RLC
	ANA	E
	MOVLDA	COUNT
	ADD	D
	STA	COUNT
NONBR	INX	H
	INX	H
	LDA	LCTR
	DCR	A
	JNZ	LOOP1
	LDA	COUNT
	POP	H
	RET
;
;
;
NBR2	PUSH	H
	LXI	H,NBTB1
	JMP	NXTENT
NBR3	PUSH	H
	LXI	H,NBTB2
NXTENT	CMP	M
	JZ	FINDENT
	CALL	BUMP3
	JMP	NXTENT
FINDENT	INX	H
	MOV	A,M
	POP	H
	RET
;
;
;
FISHY	DCR	M
	RNZ
	MVI	A,MRATE
	CALL	RANDOM
	CPI	0
	RNZ
	INX	H
	MOV	A,M
	CPI	DEAD
	RZ
	CPI	MARKED
	JZ	DIE
	PUSH	H
	CPI	FTRK
	CZ	TRACK
	POP	H
	INX	H
	MOV	A,M
	DCX	H
	DCX	H
	MOV	M,A
	CALL	BUMP3
	MVI	D,0
	MOV	E,M
	MOV	A,E
	ORA	A
	RZ
	ORA	A
	JP	FRWARD
	MVI	D,0FFH
FRWARD	INX	H
	MOV	B,M
	INX	H
	MOV	C,M
	LDAX	B
	CPI	BLANK
	JNZ	MOVER
	CALL	DEC4
	MVI	M,DEAD
	RET
;
;
;
MOVER	PUSH	H
	MOV	H,B
	MOV	L,C
	DAD	D
	XCHG
	POP	H
	LDAX	D
	CPI	BORDER
	JZ	HITBOR
	CPI	BLANK
	JNZ	BANG4
	DCX	H
	MOV	M,D
	INX	H
	MOV	M,E
	LDAX	B
	STAX	D
	MVI	A,BLANK
	STAX	B
	RET
;
;
;
CONVERT	PUSH	B
	LXI	H,-DTV
	DAD	D
	LXI	D,-LENL
	MVI	B,NLINES
FINEG	DAD	D
	DCR	B
	MOV	A,H
	ORA	A
	JP	FINEG
	MOV	E,B
	ORA	A
	JP	MOVELFT
	MVI	A,ONE
	JMP	SETDIR
MOVELFT	MVI	A,0FFH
SETDIR	POP	H
	DCX	H
	MOV	B,A
	MOV	A,M
	CMP	B
	RZ
	CMA
	CMP	B
	JZ	OPPOS
	MOV	M,B
	RET
;
;
;
OPPOS	CPI	SUBL
	JZ	MOVRHT
	CPI	LENL
	JZ	MOVRHT
	MVI	M,LENL
	RET
;
;
;
MOVRHT	MVI	M,ONE
	RET
;
;
;
HITBOR	CALL	DEC4
	MOV	A,M
	CPI	VICTIM
	JZ	VHIT
	DCX	H
	CALL	KILL
	RET
;
;
;
VHIT	MVI	A,0
	INX	H
	INX	H
	MOV	M,A
	RET
;
;
;
BANG4	CALL	DEC5
	CALL	KILL
	CALL	FIND
	CALL	KILL
	LXI	H,ONE
	DAD	B
	CALL	BANG
	LXI	C,M
	MVI	A,BLANK
	STAX	B
	RET
;
;
;
ALIVE	LXI	H,FTABL+1
	MVI	B,MAXFISH
MORDEAD	MOV	A,M
	CPI	DEAD
	JZ	FNDEAD
	CALL	BUMP6
	DCR	B
	JNZ	MORDEAD
	LXI	H,ONE
FNDEAD	DCX	H
	RET
;
;
;
FIND	LXI	H,VTABL
	MVI	B,MAXFISH+1
LOOK	CALL	BUMP4
	MOV	A,M
	INX	H
	CMP	D
	JNZ	NOFIND
	MOV	A,M
	CMP	E
	JNZ	NOFIND
	CALL	DEC5
	RET
;
;
;
NOFIND	INX	H
	DCR	B
	JNZ	LOOK
	LXI	H,0
	RET
;
;
;
SETUP	LXI	H,DTV
	MVI	B,NLINES
BLKCH	MVI	C,LENL
BLKEH	MVI	M,BLANK
	INX	H
	DCR	C
	JNZ	BLKEH
	DCR	B
	J	MVI	D,MAXFISH
NOFISH	INX	H
	INX	H
	MVI	M,DEAD
	CALL	BUMP4
	DCR	D
	JNZ	NOFISH
	LXI	H,STV-25
	MVI	B,14H
	LXI	D,SCRMSG
PTRSCR	LDAX	D
	ORI	BIAS
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	PTRSCR
	MVI	A,0FFH
	STA	SCRFLG
	MVI	A,0
	STA	PHASE
	CALL	SETPHA
	CALL	GETPHA
	RET
;
;
;
BUMP6	INX	H
	INX	H
BUMP4	INX	H
BUMP3	INX	H
	INX	H
	INX	H
	RET
;
;
;
DEC5	DCX	H
DEC4	DCX	H
DEC3	DCX	H
	DCX	H
	DCX	H
	RET
;
;
;
NBTB1	DB	1
NBTB2	DB	SUBL,1,2
	DB	SUBL+1,2,4
	DB	1,4,8
	DB	LENL+1,8,10H
H,40,10,125
	DB	60H,2,20H,50H,28H,50,13,150
	DB	68H,2,1EH,4CH,28H,60,16,175
	DB	70H,2,1CH,48H,24H,70,19,200
	DB	78H,2,1AH,44H,24H,80,22,225
	DB	80H,4,18H,40H,20H,90,25,250
	DB	88H,4,16H,3CH,20H,100,28,255
;
;
;
MARKED	EQU	58H
FRATE	EQU	4
MRATE	EQU	1
RDA	EQU	80H
INDAT	EQU	1
INSTAT	EQU	0
FTRK	EQU	49H
MONIT	EQU	0
NOTRK	EQU	41H
VMAXS	EQU	17H
VFAST	EQU	7
VICTIM	EQU	50H
LENL	EQU	64
WIDTH	EQU	64
SCORSP	EQU	20H
SUBL	EQU	0C0H
BIAS	EQU	0
BLANK	EQU	' '+BIAS
ZERO	EQU	'0'+BIAS
BIN0	EQU	0
ONMOV	A,L
	ADI	LENL
	MOV	D,A
	POP	B
	RET
;
;
;
TRACK	MVI	A,64H
	CALL	RANDOM
	MOV	B,A
	LDA	LSTRK
	CMP	B
	RC
	CALL	BUMP3
	PUSH	H
	MOV	D,M
	INX	H
	MOV	E,M
	CALL	CONVERT
	MOV	B,D
	MOV	C,E
	LDA	VPOS
	MOV	D,A
	LDA	VPOS+1
	MOV	E,A
	CALL	CONVERT
	MOV	A,B
	SUB	D
	MOV	D,A
	CPI	7FH
	JC	POS1
	CMA
POS1	MOV	B,A
	MOV	A,C
	SUB	E
	MOV	E,A
	ORA	A
	JP	POS2
	CMA
POS2	CMP	B
	JC	TRKLIN
	MOV	A,E
	ORA	A
	JM	MOVEUP
	MVI	A,LENL
	JMP	SETDIR
MOVEUP	MVI	A,SUBL
	JMP	SETDIR
TRKLIN	MOV	A,D
		H,0FFFFH
	DAD	B
	CALL	BANG
	LXI	H,LENL
	DAD	B
	CALL	BANG
	LXI	H,-LENL
	DAD	B
	CALL	BANG
	RET
;
;
;
DIE	DCX	H
	CALL	KILL
	RET
;
;
;
BANG	MOV	A,M
	CPI	BLANK
	JZ	EMPTY
	CPI	BORDER
	RZ
	CPI	BOOM
	RZ
	PUSH	H
	PUSH	B
	XCHG
	CALL	FIND
	CALL	KILL
	POP	B
	POP	H
EMPTY	XCHG
	PUSH	B
	CALL	ALIVE
	POP	B
	LDA	LTIME
	MOV	M,A
	INX	H
	MVI	M,MARKED
	CALL	BUMP3
	MOV	M,D
	INX	H
	MOV	M,E
	MVI	A,BOOM
	STAX	D
	RET
;
;
;
KILL	INX	H
	MVI	M,DEAD
	CALL	BUMP3
	MOV	B,M
	INX	H
	MOVNZ	BLKCH
	LXI	H,DTV
	LXI	D,ETV-2*LENL
	MVI	B,WIDTH
	MVI	A,BORDER
SETBOR	MOV	M,A
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	SETBOR
	MVI	B,NLINES-2
	LXI	D,DTV+LENL
NXTROW	MOV	M,A
	MVI	C,WIDTH-1
SETSIDE	INX	H
	DCR	C
	JNZ	SETSIDE
	MOV	M,A
	MVI	C,LENL+1-WIDTH
PADSIDE	INX	H
	DCR	C
	JNZ	PADSIDE
	DCR	B
	JNZ	NXTROW
	LXI	H,VTABL
	MVI	M,VMAXS
	INX	H
	MVI	M,VICTIM
	INX	H
	MVI	M,VMAXS
	INX	H
	MVI	M,0
	INX	H
	LXI	B,DTV+LENL*NLINES/2-LENL+WIDTH/2
	MOV	M,B
	INX	H
	MOV	M,C
	MVI	A,VSYM
	STAX	B
	DB	LENL,10H,20H
	DB	LENL-1,20H,40H
	DB	0FFH,40H,80H
	DB	SUBL-1,80H
LCTR	DB	8
COUNT	DB	0
RPTR	DB	0,0
BIGONE	DB	0
BIGTWO	DB	0,0,0
SCRMSG	DB	'SCORE '
	DB	'      00      '
PHAMSG	DB	'PHASE      '
SCRFLG	DB	0FFH
GOODCAL	DB	WIDTH-2
PHASE	DB	0
LNEWF	DB	100
LSIDE	DB	1
LMINS	DB	20
LSRNG	DB	80
LTIME	DB	28H
LTRACK	DB	1
LSTRK	DB	1
LBONUS	DB	0
CTLPTR	DW	CONTROL
	DB	22
;
;
;
CONTROL	DB	40H,1,2,60H,30H,10,1,50
	DB	48H,1,26H,5CH,30H,20,4,75
	DB	50H,1,24H,58H,2CH,30,7,100
	DB	58H,1,22H,54H,2CE	EQU	1
VSYM	EQU	7+BIAS
DEAD	EQU	4FH
BOOM	EQU	'+'+BIAS
FISH	EQU	'*'+BIAS
BORDER	EQU	0A0H
DTV	EQU	0CC00H
NLINES	EQU	16
ETV	EQU	DTV+LENL*NLINES
STV	EQU	ETV-LENL+WIDTH
MAXFISH	EQU	(NLINES+WIDTH)/3
;
;
;
	ORG	800H
JUMPS	DW	MONIT
	DW	ESC
	DW	RESTART
	DW	UP
	DW	DOWN
	DW	LEFT
	DW	RIGHT
	DW	UL
	DW	UR
	DW	LL
	DW	LR
	DW	HALT
	DW	STOP
	DW	AUTO
	DW	RETURN
CHARS	DB	0FFH,01H
	DB	1BH,1BH
CHARGO	DB	'S',0DH
	DB	'U','8'
	DB	'J','2'
	DB	'H','4'
	DB	'K','6'
	DB	'Y','7'
	DB	'I','9'
	DB	'N','1'
	DB	',','3'
	DB	' ','5'
	DB	'P','.'
	DB	'A','0'
ENDCH	DB	0FFH
CHARL	EQU	ENDCH-CHARS
STRING	DB	' ENTER NEW VALUES FOR: GO-'
	DB	'U-'
	DB	'D-'
	DB	'L-'
	DB	'R-'
	DB	'UL-'
	DB	'UR-'
	DB	'LL-'
	DB	'LR-'
	DB	'H-'
	DB	'P-'
	DB	'A-'
	DB	0FFH
VTABL	DB	VMAXS
	DB	VICTIM
VSPEED	DB	VMAXS
VDIREC	DB	0
VPOS	DW	DTV+LENL*(NLINES-1)/2
FTABL	DS	MAXFISH*6
	END
;
;THIS PROGRAM APPEARS IN PEOPLE'S COMPUTERS MARCH-APRIL '78
;
;WRITTEN BY:TIM SCULLY
;	    35267-136CH
;	    PO BOX 1000
;	    STEILACOOM, WA 98388
;
;	ENTERED BY:	DAVE JAFFE
;			6913 MADISON
;			NILES, ILLINOIS 60648
;
;	MAIN PROGRAM
;
	ORG	100H
START	MVI	A,0CH
	CALL	WH1		;ERASE SCREEN
	CALL	PATCH
ENTERL	SHLD	CM		;SAVE CURRENT MESSAGE ADDRESS
	NOP
REENTRY	LXI	H,MSG2-1
	CALL	MESSAGE		;OFFER SPELLING
	JZ	SPELL
	LXI	H,MSG3-1
	CALL	MESSAGE		;OFFER PUNCTUATION
	JZ	PUNCT
	LXI	H,BEGIN	D ITEM
ELOP	LHLD	POS		;FETCH CURRENT MESSAGE ADDR
	JMP	ENTERL		;GO BACK TO OFFER SPELLING
;
;THE FOLLOWING SUBROUTINE IS USED BY MENU TO SAVE THE FLAGS
;WHICH START OUT IN DE (THE FLAG IN D IS 0 UNLESS MENU IS
;ASKED TO DISPLAY WORDS OR INDIVIDUAL CHARACTERS, THE FLAG
;IN E IS THE INDICATOR TELLING MENU WHAT TO DISPLAY, EG.
;FEH=GROUPS, FDH=SUBGROUPS,ETC.), IT ALSO SAVES THE DATA
;IN HL AS ITS STARTING ADDRESS AND SAVES THE CURRENT VALUE
;OF POS IN THE 'CURRENT MESSAGE' STORAGE.
;
ENTER	XCHG
	SSMENU AND MENU, WHICH FOLLOW, ARE THE MAJOR SUBROUTINES
;FOR DISPLAYING ITEMS ON THE MENU (THE TOP LINE OF THE VIDEO
;DISPLAY). MENU IS ENTERED WITH FLAGS IN DE AND A STARTING
;ADDRESS IN HL. THE FLAGS TELL MENU TO DISPLAY GROUPS, SUB-
;GROUPS, WORDS OR INDIVIDUAL CHARACTERS. THE STARTING ADDR
;TELLS MENU WHERE TO FIND THE FIRST ITEM TO DISPLAY. AN
;EXIT FROM MENU IS ACCOMPLISHED WHEN AN ITEM IS SELECTED BY
;USE OF THE KNEE SWITCH. UPON EXIT FROM MENU, THE STARTING
;ADDRESS OF THE FIRST CHOSEN ITEM H	INX	H		;LOOK FOR END OF GROUP OR
	MOV	A,M		;SUBGROUP
	CMP	E		;BY LOOKING FOR FLAG LIKE E
	JC	SEARCH		;KEEP LOOKING
BACKUP	DCX	H		;THEN BACKUP
	MOV	A,M		;AND PRINT IT
	ANI	80H
	JZ	BACKUP
	JMP	DISPY
;
;THE NEXT FOUR LOCATIONS STORE THE TIMING CONSTANTS FOR THE 
;TWO TIME DELAYS: T1 AND T2. T1 IS THE TIME EACH ITEM ON THE 
;MENU IS DISPLAYED AND T2 IS THE MINIMUM TIME THE KNEE-
;SWITCH HAS TO BE CLOSED BEFORE IT IS CONSIDERED INTEN-
;TIONAL (SO ACCIDENTIAL TWITCHES WILL BE IGNORED).
;
T1	DW	5	;START OF VOCABULARY
	LXI	D,0FEH		;SET FLAGS
	CALL	MENU		;OFFER GROUPS
	LXI	D,0FDH		;SET UP FLAGS
	LHLD	CI		;FETCH CHOSEN ITEM'S ADDR
	CALL	MENU		;OFFER SUBGROUPS
	LXI	D,1FCH		;SET UP FLAGS
	LHLD	CI		;FETCH CHOSEN ITEM'S ADDR
	CALL	MENU		;OFFER WORDS
	LHLD	CI		;FETCH CHOSEN ITEM'S ADDR
XMIT	MOV	A,M		;FETCH CAHRACTER
	CALL	WH1		;PRINT IT
	INX	H		;NEXT
	MOV	A,M		;FETCH IT
	ANI	80H		;CHECK FOR START OF NEXT ITEM
	JZ	XMIT		;IF NOT NEXT, KEEP PRINTING
	MVI	A,' '
	CALL	WH1		;SPACE AFTER COMPLETEHLD	FLAGS
	XCHG
SENTER	SHLD	CS
	LHLD	POS
	SHLD	CM
	LHLD	CS
	RET
;
;THE FOLLOWING SUBROUTINE ERASES THE TOP TWO LINES OF THE
;VIDEO DISPLAY WITHOUT DISTURBING THE MESSAGE DISPLAYED
;ON THE BOTTOM 14 LINES. IT ENDS WITH THE CURSOR AT HOME.
;
NEW	MVI	A,0BH
	CALL	WH1		;SEND CURSOR HOME
	MVI	A,18H
	CALL	WH1		;ERASE CURRENT LINE
	MVI	A,0DH
	CALL	WH1		;GO TO NEXT LINE
	MVI	A,18H
	CALL	WH1		;ERASE IT TOO
	MVI	A,0BH
	CALL	WH1		;SEND CURSOR HOME
	RET
;
;	MAJOR SUBROUTINES: SMENU AND MENU
;
;WILL BE IN CI.
;
SMENU	LXI	D,1FBH		;SET FLAGS FOR SPELLING
MENU	CALL	ENTER		;SAVE ADDR AND FLAGS
ITEM	CALL	NEW		;ERASE MENU
	SHLD	CI		;SAVE CURRENT ITEM ADDR
DISPY	MOV	A,M		;FETCH CHAR FROM MEMORY
	CALL	WH1		;AND DISPLAY IT
	INX	H		;NEXT
	MOV	A,M
	ANI	80H		;CHECK FOR MSB=1
	JZ	DISPY		;IF NOT KEEP PRINTING
	XRA	A		;ARE WE FINISHED WITH GROUP
	CMP	D		;PRINTING W/ WORDS OR LETTERS
	JNZ	WORD		;YES, GO ON TO WORDS OR END
	INR	D		;OTHERWISE SET FLAG
	MVI	A,'-'
	CALL	WH1		;PRINT '-'
	DCX	H
SEARC050H		;T1 TIME CONSTANT
T2	DW	5050H		;T2 TIME CONSTANT
;
;	SUBROUTINE: SWITCH
;
;THE SUBROUTINE SWITCH LOOKS FOR A SWITCH CLOSURE FOR TIME T1
;AND THEN RETURNS WITH ZERO IN D IF THE SWITCH WAS NEVER
;CLOSED. IF THE SWITCH CLOSES, BUT NOT FOR AT LEAST T2, THE
;ROUTINE JUST STARTS OVER, EXTENDING T1. IF THE SWITCH
;CLOSES FOR AT LEAST T2, THEN AFTER THE SWITCH IS RELEASED
;IT RETURNS WITH ONE IN D.
;
SWITCH	MVI	D,0		;SET UP 'NEVER CLOSED FLAG'
	PUSH	H
	LHLD	T1		;FETCH TIME CONSTANT
	PUSH	H
	POP	B		;PUT IN BC
	POP	H
INP	IN	80H		;LOOK AT SWITCH
	ANI	80H		;ITS ONLY ONE BIT
	JZ	CLOSED
	SHLD	WASTE		;WASTE TIME
	LHLD	WASTE		;TO MAKE TIMING LOOP LONGER
	SHLD	WASTE
	LHLD	WASTE
	DCR	C
	JNZ	INP		;CHECK SWITCH EVERY TIME
	DCR 	B
	JNZ	INP		;KEEP TIMING
	RET			;TIME UP, NO CONTACT
CLOSED	PUSH	H
	LHLD	T2		;FETCH TIME CONSTANT
	PUSH	H
	POP	B		;PUT IT IN BC
	POP	H
WAIT	SHLD	WASTE		;WASTE TIME
	LHLD	WASTE
	DCR	C
	JNZ	WAIT		;KEEP TIMING
	DCR	B
	JNZ	WAIT		;TIME UP?
	IN	80H		;CHECK SWITCH
 UPON EXIT FROM
;MESSAGE, THE ZERO FLAG IN THE PSW WILL BE ONE IF THE
;OFFERED ITEM WAS CHOSEN AND ZERO IF IT WAS NOT CHOSEN.
;
MESSAGE	CALL	NEW		;ERASE MENU
	INX	H
	MOV	A,M
	CALL	WH1		;PRINT
	CPI	'?'		;CHECK FOR END OF MESSAGE
	JNZ	MESSAGE+3
	LHLD	CM
	SHLD	POS		;RESTORE POS
	CALL	SWITCH
	MVI	A,1
	CMP	D
	RET
;
;	SUBROUTINE: COMP
;
;THE SUBROUTINE COMP IS USED BY MENU TO CHECK THE SWITCH.
;
COMP	CALL	SWITCH
	MVI	A,1
	CMP	D
	JNZ	NEXT		;IF NO CONTACT, NEXT CHOICE
	LHLD	CM
	SHLD	POS		;S OR SUBS?
	JNC	CHECK		;IF SO CHECK FOR END
	LHLD	CI
FIN	INX	H		;SKIP CURRENT WORD OR LETTER
	MOV	A,M
	ANI	80H		;KEEP SKIPPING UNTIL THE
	JZ	FIN		;START OF THE NEXT, THEN CHECK
CHECK	INR	E		;THE LAST ITEM WILL BE FOLLOWED
	MOV	A,M		;BY A FLAG=TO E + 1
	CMP	E
	JNC	LAST
	DCR	E		;RESTORE FLAG IN E
	CPI	0FBH		;IF NO CONTROL CODE FOUND,
	JC	ITEM		;KEEP DISPLAYING
	MOV	A,D
	CPI	0FDH
	JC	LAST
	INX	H		;SKIP CONTROL CODE
	JMP	ITEM
LAST	CALL	ESCAPE		;IF LAST ITEM WAS DISPLAYED
	LHLD	FLAGS		;OFFER F THE LINE.
;
WORD	MOV	A,E		;CHECK FLAG
	CPI	0FDH
	JNC	COMP		;AND SPLIT IF GROUPS OR SUBS
	LDA	POS		;CHECK POSITION IN MENU
	CPI	3CH		;NEAR END OF THE LINE
	JNC	COMP		;STOP PRINTING AND
	MOV	A,M		;SPLIT OR IF AT END
	CMP	E		;OF THE SUBGROUP, SPLIT
	JNC	COMP
	MVI	A,' '		;OTHERWISE,
	CALL	WH1		;PRINT TWO SPACES
	CALL	WH1
	JMP	DISPY		;AND ADD MORE TO MENU
;
;	SUBROUTINE: ESCAPE
;
;THE SUBROUTINE ESCAPE OFFERS A RETURN TO THE SPELLING MODE
;AND IS USED OFTEN.
;
ESCAPE	PUSH	B
	LXI	H,MSG1-1	 ALPHABET IS OFFERED. A LOOK-UP TABLE IS USED TO PICK THE 
;RIGHT ALPHABET TO OFFER AFTER THE FIRST LETTER HAS BEEN
;PRINTED.
;
SPELL	LXI	H,ASTART	;ADDR OF 1ST ALPHABET
	CALL	FIRST		;PRINT 1ST LETTER
	CALL	SENTER		;TO RESTORE POS
TALE	CALL	ESCAPE		;OFFER ESCAPE
	LXI	H,STAB		;START OF LOOK-UP TABLE
	MOV	A,B		;FETCH LAST CHAR PRINTED
LOOK	CMP	M		;AND LOOK FOR IT IN TABLE
	JZ	FOUND
	INX	H		;EACH TABLE ENTRY
	INX	H		;IS 3 BYTES
	INX	H
	JMP	LOOK		;KEEP LOOKING, YOU'LL FIND IT
FOUND	INX	H		;WHEN F	ANI	80H		;CHECK MSB
	JNZ	SWITCH		;START OVER, STILL NOT CLOSED
	INR	D		;SET FLAG FOR CONTACT
UP	IN	80H		;CHECK SWITCH AGAIN
	ANI	80H
	RNZ			;WAIT UNTIL IT IS RELEASED
	JMP	UP		;MEANWHILE LOOPING
;
;	SUBROUTINE: MESSAGE
;
;THE SUBROUTINE MESSAGE IS USED TO DISPLAY A NUMBER OF SHORT
;MESSAGES ON THE MENU. MESSAGE IS ENTERED WITH AN ADDRESS
;IN HL EQUAL TO ONE LESS THAN THE STARTING ADDRESS OF THE
;MESSAGE TO BE DISPLAYED. IT WILL DISPLAY THE MESSAGE FOUND
;UP TO AND INCLUDING A TERMINATING '?'.RESTORE MAIN TEXT POS
	RET
;
;
;	MORE ROUTINES USED BY MENU
;
;THE FOLLOWING CHAIN OF ROUTINES ARE USED BY MENU TO FIND
;AND DISPLAY THE NEXT ITEM, CHECK FOR THE LAST ITEM ON THE
;LIST, OFFER ESCAPE?, AND RECYCLE TO THE BEGINNING OF THE LIST
;IF NOTHING IS CHOSEN. THE DETAILS OF THESE OPERATIONS VARY
;DEPENDING ON WHAT ITEMS ARE BEING OFFERED: GROUPS, SUBWORDS,
;OR CHARACTERS.
;
NEXT	XCHG			;SAVE CURRENT ADDRESS
	LHLD	FLAGS		;WHILE RESTORING FLAGS
	XCHG
	MOV	A,E
	CPI	0FDH		;DISPLAYING GROUPESCAPE THEN LOOP BACK
	XCHG
	LHLD	CS
	JMP	ITEM		;AND START DISPLAYING AGAIN
;
;
;	SUBROUTINE: WORD
;
;WORD, THE NEXT SUBROUTINE, IS USED BY MENU. IF GROUPS OR
;SUBGROUPS ARE BEING OFFERED, IT IS ENTERED ONLY AFTER THE
;COMPLETE OFFERING HAS BEEN PRINTED AND IT JUMPS TO COMP TO
;CHECK THE SWITCH. BUT IF INDIVIDUAL WORDS OR CHARACTERS ARE
;BEING OFFERED, WORD KEEPS PRINTING WORDS OR CHARACTERS ACROSS
;THE MENU SPACE, WITH TWO SPACES BETWEEN EACH, UNTIL THE END OF
;THE SUBGROUP OR UNTIL THE END O;SET UP FOR MESSAGE
	CALL	MSG1-1
	POP	B
	RNZ			;RETURN IF NO ESCAPE
	POP	H		;CLEAN UP STACK
	JMP	REENTRY		;AND REENTER SPELLING?
;
;
;	SUBROUTINES USED BY SPELLING MODE
;
;THE SPELLING MODE USES THIS CHAIN OF SUBROUTINES. THE FIRST
;ALPHABET OFFERED IS DIFFERENT FROM THE OTHER 26, AND THE
;ROUTINE DOESN'T
;BACKSPACE BEFORE PRINTING THE FIRST LETTER, SO THERE IS ONE
;ROUTINE FOR THE FIRST LETTER AND ANOTHER FOR ALL THE OTHERS.
;ESCAPE? IS OFFERED AFTER EACH LETTER IS PRINTED AND BEFORE A
;NEWOUND,
	MOV	E,M		;GET ADDR FROM TABLE
	INX	H
	MOV	D,M
	XCHG			;AND PUT IT IN HL
	CALL	SECOND		;OFFER NEW ALPHABET
	CALL	OOP		;PRINT THE CHOSEN LETTER
	JMP	TALE		;AND LOOP BACK TO DO IT AGAIN
FIRST	CALL	SMENU		;OFFER ALPHABET
OOP	LHLD	CI		;FETCH CHOSEN ITEM'S ADDR
	MOV	A,M
	CALL	WH1		;AND PRINT IT
	MOV	B,A		;SAVE IT FOR LOOK-UP LATER
	MVI	A,' '
	CALL	WH1		;AND PRINT A SPACE
	RET
SECOND	CALL	SMENU		;OFFER ALPHABET
SECONDS	LHLD	POS		;GET READY TO BACKSPACE
	DCX	H		;AND
	SHLD	POS		;DO IT
	RET
;
;	SUBROUTINE: PUNCT
;
;THE SUBROUTINE PUNCT HANDLES OFFERING THE CONTROL CODES (BY
;CALLING ANOTHER SUBROUTINE) AND IT OFFERS THE PUNCTUATION
;SYMBOLS. IT USES ONE OF THE SPELLING SUBROUTINES TO HANDLE
;PUNCTUATION.
;
PUNCT	LXI	H,MSG4-1
	CALL	MESSAGE		;OFFER CONTROL?
	JZ	CONTROL
	LXI	H,MSGA-1	;STARTING ADDR OF PUNCTUATION
	CALL	SECOND		;OFFER THEM
	CALL	OOP		;PRINT THE CHOSEN ONE
	JMP	ELOP		;GO BACK TO OFFER SPELLING
;
;	SUBROUTINE: CONTROL
;
;CONTROL OFFERS AND EXECUTES THE CONTROL CO
	MVI	A,0DH
	JMP	DEND
FIVE	LXI	H,MSG9-1
	CALL	MESSAGE
	JZ	START		;START ALL OVER
	CALL	ESCAPE
	JMP	CONTROL
RUB	MVI	M,0A0H		;PUT BLANK ON SCREEN
	JMP	MORE
PATCH	LXI	H,TEXT		;INITIALIZE TEXT ADDR
	SHLD	POS
	RET
;
;	MESSAGES
;
MSG1	DB	'ESCAPE?'
MSG2	DB	'SPELLING?'
MSG3	DB	'PUNCTUATION?'
MSG4	DB	'CONTROL?'
MSG5	DB	'BACKSPACE?'
MSG6	DB	'ERASE LAST WORD?'
MSG7	DB	'SPACE?'
MSG8	DB	'NEXT LINE?'
MSG9	DB	'ERASE SCREEN?'
MSGA	DB	2EH,2CH,3FH,3BH,3AH,21H
	DB	'0123456789#$"%&()*+-'
	DB	0FBH		;E'
	DW	ALW
	DB	'W'
	DW	ALW
	DB	'X'
	DW	ALX
	DB	'Y'
	DW	ALY
	DB	'Z'
	DW	ALZ
;
;	THE ALPHABETS
;
;AND HERE ARE THE ALPHABETS.
;
ASTART	DB	'TAOSWIHCBFPMRELNDUGYJVQKZX',0FBH
ALA	DB	'NTSRLDCIGVMYPBKUFWOJXHZEQA',0FBH
ALB	DB	'EAOUYRISLJTVMBDWCGHNPFK',0FBH
ALC	DB	'OEHATKILURCYSONDZMW',0FBH
ALD	DB	'EIUARSOLMDGYNVJQWHEFTPKBZ',0FBH
ALE	DB	'RSNDALMCETVFPXIGYOWUHQKBJZ',0FBH
ALF	DB	'ORIFEAULTSYWBMGCHNJPD',0FBH
ALG	DB	'EHROAIGSLUTNYMFDBWZJKPC',0FBH
ALH	DB	'EIAOTURYLNWDSMBHQFPCGK',0FBH
ALI	DB	'NSTOCMB	'EAHIONRSLTDYKUPFBCMZWG',0FBH
ALX	DB	'EPTICAHUYOQLNWFSVGBKMRD',0FBH
ALY	DB	'EOSAITPMBLNWCRGDZHUFVXIK',0FBH
ALZ	DB	'EAZOYIUKTVWHJB',0FBH
;
;END OF ALPHABETS
;
;
;	BEGINNING OF VOCABULARY STORAGE
;
BEGIN	DB	'AABLEABOUT'
	DS	1976H
;
;	TEXT AND EDITOR
;
;THE EDITOR AND TEXT PROGRAMS USE SEVERAL SUBROUTINES FROM
;THE POLY 4.0 MONITOR ROM. SEE THE POLY SYSTEM MANUAL VOLUME
;2, PAGES 58-65.
;
TEXT	CALL	WHO		;KEYBOARD INPUT
	CPI	7FH		;IS IT A RUBOUT?
	JZ	RUB1
	CPI	5FH		;IS IT A SHIFT 'O'
	JITOR	SHLD	CS		;SAVE START OF CURRENT LINE
	MVI	A,0DH
	CALL	WH1		;START A NEW LINE
	LHLD	CS		;FETCH START OF CURRENT LINE
	XCHG
	CALL	DEOUT		;PRINT ADDR IN HEX
	XCHG			;RESTORE ADDR
	MVI	A,' '
	CALL	WH1		;PRINT SPACE
LOOP	MOV	A,M		;FETCH CHAR FROM MEMORY
	CALL	LPRINT		;PUT IT ON TV
	MOV	A,M
	INX	H
	CPI	0FBH		;WAS IT THE END OF A LINE?
	JC	LOOP		;IF NOT, KEEP PRINTING
KEY	CALL	WHO		;WAIT UNTIL KEY IS PRESSED
	CPI	' '
	JNZ	M1		;IF NOT KEEP CHECKING
	LHLD	CS		;FETCH STARTING ADDR
	INX	H		;SPAMMANDS.
;
CONTROL	LXI	H,MSG5-1
	CALL	MESSAGE		;OFFER BACKSPACE
	JNZ	TWO
	CALL	SECONDS		;BACKSPACE
	JMP	ENTERL		;BACK TO OFFER SPELLING
TWO	LXI	H,MSG6-1
	CALL	MESSAGE
	JNZ	THREE
	LHLD	POS
	DCR	L		;BACK UP
MORE	DCR	L		;BACK UP
	MVI	A,' '
	CMP	M		;HAVE WE REACHED A SPACE?
	JNZ	RUB
	INX	H		;LEAVE THE SPACE
	JMP	ENTERL		;AND GO OFFER SPELLING?
THREE	LXI	H,MSG7-1
	CALL	MESSAGE
	JNZ	FOUR
	MVI	A,' '
DEND	CALL	WH1
	JMP	ELOP		;BACK TO OFFER SPELLING?
FOUR	LXI	H,MSG8-1
	CALL	MESSAGE
	JNZ	FIVEND FLAG
;
;	ALPHABET LOOK-UP TABLE
;
;HERE IS THE LOOK-UP TABLE FOR THE VARIOUS ALPHABETS, IN 
;NON-STANDARD FORM.
;
STAB	DB	'A'
	DW	ALA
	DB	'B'
	DW	ALB
	DB	'C'
	DW	ALC
	DB	'D'
	DW	ALD
	DB	'E'
	DW	ALE
	DB	'F'
	DW	ALF
	DB	'G'
	DW	ALG
	DB	'H'
	DW	ALH
	DB	'I'
	DW	ALI
	DB	'J'
	DW	ALJ
	DB	'K'
	DW	ALK
	DB	'L'
	DW	ALL
	DB	'M'
	DW	ALM
	DB	'N'
	DW	ALN
	DB	'O'
	DW	ALO
	DB	'P'
	DW	ALP
	DB	'Q'
	DW	ALQ
	DB	'R'
	DW	ALR
	DB	'S'
	DW	ALS
	DB	'T'
	DW	ALT
	DB	'U'
	DW	ALU
	DB	'VLAREDVGPFBKXUZQIJLWY',0FBH
ALJ	DB	'AEOUIJ',0FBH
ALK	DB	'EISANLYOGFWTURDPMKBJCHV',0FBH
ALL	DB	'EIALYODTSUFRMVWKPCBGNHJZXQ',0FBH
ALM	DB	'EAOIPMUYSBLFNTHCDRWGJKVCZ',0FBH
ALN	DB	'DTEGSCIAOYNLFVUKMJRQPHWXBZ',0FBH
ALO	DB	'NFRUMPLTOWSDCVIBEYAKHJGXZQ',0FBH
ALP	DB	'ROAELTSPIHMUYWFGKBNDCJ',0FBH
ALQ	DB	'UIO',0FBH
ALR	DB	'EIOATSYDMNURCLVKGPWBFHXQJZ',0FBH
ALS	DB	'TEIOSHUCAPYKMWNLGQFBDRVJZ',0FBH
ALT	DB	'HEIOARSTUYLWCFMNBPDZGKVJQ',0FBH
ALU	DB	'TSNRLCGPAEMDIFBOYZXUVKQJH',0FBH
ALV	DB	'EIAOYUSRVZKGM',0FBH
ALW	DZ	EDITOR
CTL	CPI	1CH		;IS IT A CONTROL CHAR?
	JC	CONTRO1
	CPI	20H		;IS IT A CONTROL CODE?
	JNC	PRINT		;IF NOT PRINT IT
	ADI	0DFH
PRINT	MOV	M,A		;STORE IT IN MEMORY
	CALL	LPRINT		;PUT IT ON TV
	INX	H		;NEXT MEMORY LOCATION
	JMP	TEXT		;DO IT ALL OVER AGAIN
CONTRO1	ORI	0C0H		;MAKE 8TH BIT HIGH
	JMP	PRINT		;FOR 'CAPITAL' LETTERS
RUB1	CALL	LPRINT		;RUBOUT ON TV
	DCX	H		;BACK UP IN MEMORY
	JMP	TEXT		;GO DO IT OVER
RETEXT	LHLD	CS		;FETCH STARTING ADDR
	MVI	A,0CH		;ERASE TV
	CALL	WH1
	JMP	TEXT
EDCE SKIPS ONE CHAR
	JMP	EDITOR		;AND REPRINTS LINE
M1	CPI	7FH		;IS IT A RUBOUT?
	JNZ	M2
	LHLD	CS		;FETCH STARTING ADDR
	PUSH	H		;COPY HL
	POP	D		;INTO DE
	MVI	A,0FFH		;END OF VOCABULARY FLAG
	LXI	B,0		;START COUNTING AT ZERO.
	DCX	H
M3	INX	H
	DCX	B		;COUNT ONE BYTE
	CMP	M		;CHECK FOR END FLAG
	JNZ	M3		;KEEP COUNTING IF NOT END
	LHLD	CS		;FETCH STARTING ADDR
	INX	H		;MOVE ONE SPACE
	CALL	MOVE
	JMP	EDITOR		;DISPLAY EDITED LINE
M2	CPI	0DH		;IS IT A CARRIAGE RETURN?
	JZ	EDITOR		;THEN DISPLAY NEXT LINE
	CPI	0AH		;IS IT LINE FEED?
	JNZ	M4
	LHLD	CS		;FETCH STARTING ADDR
	DCX	H		;BACK UP
M5	DCX	H		;KEEP BACKING UP
	MOV	A,M
	CPI	0FBH		;LOOK FOR CONTROL FLAG
	JC	M5		;BACK UP UNTIL FOUND
	INX	H		;SKIP THE FLAG
	JMP	EDITOR		;AND DISPLAY PREVIOUS LINE
M4	CPI	5FH		;IS IT SHIFT 'O' ?
	JZ	RETEXT		;IF SO, GO TO TEXT
	CPI	1CH		;IS IT A CONTROL CHAR?
	JC	M6		;IF SO, IT'S UPPER CASE
	CPI	20H		;COULD IT BE CONTROL CODE?
	JNC	INSERT		;IF NOT,INSERT AS IS
	CPI	1EH		;BE SURE IT'S NOT M OR L
	JNC	MT BACK CHAR
	STAX	D		;AND INSERT IT
	INX	H
	INX	H
	JMP	EDITOR
LPRINT	CPI	60H		;IS IT UPPER CASE ?
	JNC	WH1		;PRINT AS IS
	CPI	41H		;IS IT LOWER CASE ?
	JC	WH1		;IF NOT, PRINT AS IS
	ADI	20H		;MAKE IT LOWER CASE
	JMP	WH1		;AND PRINT IT
;
;
;
;THIS PROGRAM (ACTUALLY A SUBROUTINE) DRIVES A POLYMORPHICS
;VTI AND SCROLLS TEXT WHEN THE SCREEN FILLS. IT RECOGNIZES
;ALL IMPORTANT CONTROL CHARACTERS AND USES THE SCRHM,SCEND,
;AND POS LOCATIONS IN SYSTEM RAM TO DESCRIBE THE BEGINNING,
;END AND CURREHE CURSOR
	CPI	7FH		;BACKSPACE AND DELETE CHAR IF
				;IT'S A RUBOUT
	JZ	RBR
	CPI	20H		;IF CHAR >20H, PRINT IT
	JNC	NORM		;TEST FOR VALID CONTROL CHAR
	SUI	'M'-40H		;CR MOVES CURSOR DOWN ONE LINE
				;AND ZEROS IT AT LEFT MARGIN
	JZ	CRR
	INR	A		;FORM FEED CLEARS SCREEN, HOMES
				;CURSOR
	JZ	FFR
	INR	A		;VERTICAL TAB HOMES CURSOR
	JZ	VTR
	INR	A		;TAB MOVES CURSOR RIGHT TO NEXT
	INR	A		;EVEN 8 POSITION
	RNZ			;IF NOT A TAB RETURN
	MOV	A,L		;BACK-UP CURSOR TO EVEN 8
	ANI	0F8H
	MOV	L,A
	LXIH
	SUB	L
	MOV	D,H
	MVI	L,40H
	MVI	E,0
	MOV	C,L
	MOV	B,A
	CALL	MOVE
	DCX	H
;
;CLEAR THE CURRENT LINE
;
CLINE	MVI	A,3FH
	MOV	D,A
	ORA	L
	MOV	L,A
WIPE	MVI	M,' '
	DCX	H
	DCR	D
	JNZ	WIPE
CURP	MVI	M,' '
	SHLD	POS		;STORE CURSOR POINTER
	JMP	IORET
RBR	DCX	H		;RUBOUT ROUTINE
	RET
CRR	LXI	B,64		;CR ROUTINE
	MOV	A,L
	ANI	0C0H
	MOV	L,A
	DAD	B
	RET
FFR	CALL	VTR		;FORM FEED ROUTINE
FF1	MVI	M,' '
	INX	H
	CMP	H
	JNZ	FF1
VTR	LHLD	SCEND		;VERTICAL TAB ROUTINE
	MOV	A,L
	MVI	L,0
	RET
;
F IS
;MASKED WITH ZEROS.
;
HEXO	ANI	15
	ADI	90H
	DAA
	ACI	40H
	DAA
	JMP	DSPLY		;OUTPUT HEX DIGIT & USE RETURN
;
;KEYBOARD INPUT FOR EDITOR
;
KBPORT	EQU	0
KBFLAG	EQU	80H
KB	EQU	1
;
WHO	IN	KBPORT
	ANI	KBFLAG
	JNZ	WHO
	IN	KB
	RET
;
;SCREEN DISPLAY ENTRY POINT
;
WH1	CALL	DSPLY
	RET
;
;STORAGE AREAS
;
CI	DS	2		;CHOSEN ITEM'S ADDR
FLAGS	DS	2		;FLAG STORAGE
CS	DS	2		;STARTING ADDR STORAGE
WASTE	DS	2		;SPACE FOR WASTING TIME
;
	END
7		;IF NOT, THEN CONTROL CODE OK
	ADI	0B0H		;MAKE INTO L OR M
	JMP	INSERT		;AND INSERT IT
M7	ADI	0DFH		;MAKE INTO CONTROL CODE
	JMP	INSERT
M6	ORI	0C0H		;MAKE INTO CAPITAL LETTER
INSERT	LHLD	CS		;FETCH STARTING ADDR
	PUSH	PSW		;SAVE CHAR ON STACK
	MVI	A,0FFH		;END OF VOCABULARY FLAG
	LXI	B,0		;START COUNT AT ZERO
	DCX	H
M8	INX	H
	DCX	B
	CMP	M
	JNZ	M8
M9	MOV	D,H		;MOVE FORWARD
	MOV	E,L
	INX	D
	MOV	A,M
	STAX	D
	DCX	D
	DCX	H
	INR	C		;COUNT ONE SPACE
	JNZ	M9
	INR	B
	JNZ	M9
	POP	PSW		;GENT CURSOR LOCATION. THE BEGINNING ADDR
;IS IN TURN STORED AT WH1.
;
POS	DS	2		;CURSOR POINTER FOR DISPLAY
SCRHM	EQU	0CC00H		;SCREEN HOME
SCEND	EQU	SCRHM+400H	;SCREEN END
;
DSPLY	PUSH	PSW		;SAVE ALL REGISTERS
	PUSH	B
	PUSH	D
	PUSH	H
	LHLD	POS		;GET CURRENT CURSOR POSITION
	CPI	'X'-40H		;CONTROL 'X' CLEARS LINE
	JZ	CLINE
	LXI	D,SCRL		;ALL DSPLY CHAR HANDLING
	PUSH	D		;SUBROUTINES EXCEPT CLINE
				;RETURN TO SCRL TO CHECK
				;SCREEN OVERFLOW AND SCROLL
				;IF NECESSARY
	MVI	M,' '		;BLANK T	B,8		;MOVE ALONG 8 POSITIONS
	DAD	B
	RET
NORM	ORI	80H		;PRINTING CHAR? MAP INTO CHAR
				;AREA OF VTI SPACE
	MOV	M,A		;PUT IT ON SCREEN
	INX	H		;MOVE ALONG ONE POSITION
	RET			;GO TO SCRL
;
;SCRL SCROLLS TEXT UP THE SCREEN IF NECESSARY THEN FALLS INTO
;CURP, WHICH RESTORES THE CURSOR AND RETURNS TO USER THRU IORET
;SUBROUTINE CHECKS FOR THE END OF THE SCREEN AND IF THERE, IT
;SETS UP THE REGISTERS FOR A BLOCK MOVE UP ONE LINE VIA MOVE.
;
SCRL	LDA	SCEND
	CMP	H
	JNZ	CURP
	LHLD	SCEND
	MOV	A,
;MOVE MOVES BC BYTES FROM THE AREA STARTING AT (HL) TO THE
;AREA STARTING AT (DE)
;
MOVE	MOV	A,M
	STAX	D
	INX	D
	INX	H
	INR	C
	JNZ	MOVE
	INR	B
	JNZ	MOVE
	RET
;
;IORET - PUT BACK ALL REGISTERS.
;
IORET	POP	H
	POP	D
	POP	B
	POP	PSW
	RET
;
;DEOUT OUTPUTS DE TO THE SCREEN
;
DEOUT	MOV	A,D
	CALL	BYTE
	MOV	A,E
;
;BYTE OUTPUTS THE ACC AS TWO HEX DIGITS TO THE SCREEN
;
BYTE	PUSH	PSW
	RRC
	RRC
	RRC
	RRC
	CALL	HEXO
	POP	PSW
;
;HEXO OUTPUTS 1 HEX DIGIT TO THE SCREEN - THE UPPER HAL	TITLE	'UNLOAD - CREATE HEX FILE FROM COM FILE'
	ORG	100H
;
;TO USE, TYPE: "UNLOAD <FILENAME> <ADDR>"
;WHERE: <FILENAME>.COM IS THE INPUT FILE
;	<FILENAME>.HEX WILL BE THE OUTPUT FILE
;	<ADDR>	     IS THE START ADDRESS IN HEX (DEF=0)
;
	MACLIB	SEQIO
;
	LHLD	6
	DCX	H
	SPHL
;
	FILE	INFILE,IFILE,,1,COM,1024
	FILE	OUTFILE,OFILE,,1,HEX,1024
	LXI	H,0
	MVI	B,0
	LXI	D,FCB2+1
ADRLUP:	LDAX	D
	INX	D
	SUI	'0'
	JC	ADRDON
	CPI	10
	JC	ADDNIB
	SUI	7
	JC	ADRDON
	CPI	16
	JNC	ADRDON
ADDNIB:	DAD	H
I	'9'+1
	JC	PUTNB1
	ADI	7
PUTNB1:	PUSH	B
	PUT	OFILE
	POP	B
	RET
;
NEXTL:	LDA	CHEKS
	CALL	PUTBYTE
	MVI	A,CR
	PUT	OFILE
	MVI	A,LF
	PUT	OFILE
	LHLD	LODADR
	LXI	D,16
	DAD	D
	JMP	ADRDON
;
GEOF:	MVI	A,':'
	PUT	OFILE
	MVI	B,5
GEOF1:	XRA	A
	PUSH	B
	CALL	PUTBYTE
	POP	B
	DCR	B
	JNZ	GEOF1
	MVI	A,CR
	PUT	OFILE
	MVI	A,LF
	PUT	OFILE
	FINIS	<IFILE,OFILE>
	JMP	0
;
LODADR:	DS	2
CHEKS:	DS	1
CR	EQU	13
LF	EQU	10
FCB2	EQU	6CH
;
BUFFERS:
	END
;	ROBOT, A VDM ROBOT SIMULATION
;
;	FROM BYTE, APRIL 1978
;
VDM	EQU	0CC00H		;VDM START
VDMPT	EQU	0C8H		;VDM PORT
KBD	EQU	01H		;KEYBOARD DATA PORT
SPEED0	EQU	5FFFH
SPEED1	EQU	1FFFH
;
	ORG	100H
START	LXI	SP,STACK	;SET UP STACK POINTER
	XRA	A		;CLEAR ACC
	OUT	VDMPT		;INITIALIZE VDM
	MVI	D,14
	LXI	H,VDM		;SET HL TO VDM START
	LXI	B,0A042H
	CALL	LOAD
SCRN	LXI	B,203CH
	CALL	LOAD
	LXI	B,0A004H
	CALL	LOAD
	DCR	D
	CMP	D
	JNZ	SCRN
	LXI	B,0A03EH
	CALL	LOAD
	LXI	H,VDM+220H
	MVI	M,07H		;PUT R	CPI	03H
	JZ	UP
UR	LXI	D,0FFC2H
	DAD	D
	CALL	BOUNDS
	JMP	NEXT
RT	INX	H
	CALL	BOUNDS
	JMP	NEXT
DR	LXI	D,042H
	DAD	D
	CALL	BOUNDS
	JMP	NEXT
DN	LXI	D,40H
	DAD	D
	CALL	BOUNDS
	JMP	NEXT
DL	LXI	D,3EH
	DAD	D
	CALL	BOUNDS
	JMP	NEXT
LFT	DCX	H
	CALL	BOUNDS
	JMP	NEXT
UL	LXI	D,0FFBEH
	DAD	D
	CALL	BOUNDS
	JMP	NEXT
UP	LXI	D,0FFC0H
	DAD	D
	CALL	BOUNDS
NEXT	IN	KBD
	CPI	'C'-40H
	JZ	0
	MVI	M,07H
	LDA	DSTAT
	DCR	A
	STA	DSTAT
	CPI	0FFH
	JZ	GO
	JMP	WAIT
BOUNDS	MOV	A,M
	ANI	80H
	RZ
	IN	DB	1
DSTAT	DB	1
STACK	EQU	$+20H
	END

	DAD	H
	DAD	H
	DAD	H
	MOV	C,A
	DAD	B
	JMP	ADRLUP
ADRDON:	SHLD	LODADR
UNLOOP:	GET	IFILE
	JZ	GEOF
	PUSH	PSW
	MVI	A,':'
	PUT	OFILE
	XRA	A
	STA	CHEKS
	MVI	A,16
	CALL	PUTBYTE
	LDA	LODADR+1
	CALL	PUTBYTE
	LDA	LODADR
	CALL	PUTBYTE
	XRA	A
	CALL	PUTBYTE
	POP	PSW
	MVI	B,16
LINLUP:	PUSH	B
	CALL	PUTBYTE
	POP	B
	DCR	B
	JZ	NEXTL
	GET	IFILE
	JMP	LINLUP
;
PUTBYTE:MOV	C,A
	LDA	CHEKS
	SUB	C
	STA	CHEKS
	MOV	A,C
	RRC
	RRC
	RRC
	RRC
	CALL	PUTNIB
	MOV	A,C
PUTNIB:	ANI	0FH
	ADI	'0'
	CPOBOT ON SCREEN
GO	CALL	RND
	ANI	02H
	JZ	RC0
	MVI	A,10H
RC0	CALL	REC
DIS	CALL	RND
	STA	DSTAT
DIR	CALL	RND
	MOV	B,A
	LDA	PSTAT
	ANI	10H
	ADD	B
	STA	PSTAT
CHEK	MOV	B,A
	LDA	OSTAT
	XRA	B
	CPI	10H
	JZ	DIR
WAIT	LDA	PSTAT
	ANI	0FH
	CPI	01H
	JZ	SWAIT
LWAIT	LXI	B,SPEED0
	JMP	DEC
SWAIT	LXI	B,SPEED1
DEC	DCX	B
	MOV	A,B
	CPI	00H
	JNZ	DEC
	MVI	M,' '
MOV1	LDA	PSTAT
	CPI	00H
	JZ	UR
	CPI	01H
	JZ	RT
	CPI	02H
	JZ	DR
	CPI	13H
	JZ	DN
	CPI	10H
	JZ	DL
	CPI	11H
	JZ	LFT
	CPI	12H
	JZ	UL
X	SP
	INX	SP
	LDA	PSTAT
	MVI	C,10H
	XRA	C
	STA	PSTAT
	JMP	MOV1
LOAD	MOV	M,B
	INX	H
	DCR	C
	CMP	C
	RZ
	JMP	LOAD
REC	PUSH	H
	LXI	H,PSTAT
	MOV	C,M
	MOV	M,A
	INX	H
	MOV	M,C
	POP	H
	RET
RND	PUSH	H
	LXI	H,SH+3
	MVI	B,08H
	MOV	A,M
RTOP	RLC
	RLC
	RLC
	XRA	M
	RAL
	RAL
	DCR	L
	DCR	L
	DCR	L
	MOV	A,M
	RAL
	MOV	M,A
	INR	L
	MOV	A,M
	RAL
	MOV	M,A
	INR	L
	MOV	A,M
	RAL
	MOV	M,A
	INR	L
	MOV	A,M
	RAL
	MOV	M,A
	DCR	B
	JNZ	RTOP
	ANI	03H
	POP	H
	RET
SH	DS	4
PSTAT	DB	1
OSTAT	THESE PROGRAMS ARE FROM BRUCE RATOFF.

TARGET, CHASE - THESE ARE THE VDM/SOL GAMES WHICH HAVE APPEARED
PREVIOUSLY, BUT NOW INCLUDE CP/M I/O.

SAP - UPDATE OF PROGRAM ON VOLUME 19, WITH MODS TO RUN IN ANY
MEMORY SIZE OR BIOS ADDRESS.  ALSO, NO LONGER DELETES NULL
EXTENTS OF NON-NULL FILES (BUG IN PREVIOUS VERSION).

ALLOC - PREVIOUSLY RELEASED PROGRAM, WITH CORRECTIONS.  SHOULD 
NOW RUN WITH BOTH VERSION 1.3 AND VERSION 1.4 SYSTEMS.

NCOMPARE.LIB, SEQIO.LIB - CORRECTED VERSIONS OF MACRO LIBRARIEM (RECOPIES REST
OF FILE UNMODIFIED).  INVOKED BY "NOTATE PROGNAME".
READS PROGNAME.ASM.  UPON EXITING, LEAVES NEW FILE AS .ASM,
ORIGINAL FILE AS .BAK.  REQUIRES  MAC AND ABOVE LIBRARIES.

UNLOAD - CONVERT A .COM FILE TO A .HEX FILE.  INVOKED BY:
	A>UNLOAD PROGNAME ADDRESS
INPUT EXTENSION DEFAULTS TO .COM, OUTPUT IS .HEX.  'ADDRESS'
IS THE STARTING ADDRESS OF THE HEX FILE (DEFAULT IS 0).

EDIT - DIS-ASSEMBLY OF EDITOR WHICH APPEARED ON A PREVIOUS DISC.
MON1, MON2, IGADD - FORTRAN-80 CALLABLE FUNCE SIMPLE-MINDED IN ITS PLOT.

	MUSIC.ASM	THE SOURCE OF ALPHA-NUMERIC MUSIC
			WITH AMPLITUDE CONTROL. THIS PROGRAM
			IS COPYRIGHTED, BUT FOR $1.50 YOU CAN
			GET THE DIRECTIONS FROM PCC. NO MUSIC
			TABLE IN THIS ONE.

	MUSICP.COM	THE ASSEMBLED VERSION COMPLETE WITH
			MUSIC TABLE. PUT AN AM RADIO NEAR YOUR
			COMPUTER TO RUN THIS. ITS SUPPOSED TO
			BE "SOUNDS OF SILENCE" BY SIMON AND
			GARFUNKEL.

	ROBOT.ASM	LET YOUR VDM MOONMAN BUMP AROUND THE
			BOUNDARIES OF THE SCREEN.

	ROBIN.ASM	T;MOVE.ASM
;V0.4
;
;	ANOTHER VERSION OF THIS PROGRAM,
;	CALLED "MOVENMAC.ASM" EXISTS FOR PEOPLE
;	WANTING TO ASM IT WITHOUT "MAC", AS THAT
;	VERSION HAS THE MACROS EXPANDED.
;
;7/23/78 BY WARD CHRISTENSEN
;USED TO TRANSFER FILES FROM ONE DISK TO ANOTHER
;	ON A 1 DISK SYSTEM, BY READING THE
;	FILE INTO MEMORY
;
;IS NOT ABLE TO MOVE A PROGRAM BIGGER THAN MEMORY
;	(WARNING MESSAGE IS ISSUED)
;
;
;CPM FUNCTION MACRO -
;
;	CPM	FNC,ADDR
; EX:	CPM	OPEN,FCB
;
;IF A NON-NULL THIRD OPERAND IS SUP S: ',0
	CPM	RDCON	;GET THE CHARACTER
	ANI	5FH	;MAKE UPPER CASE
	CPH	'S'
	JNZ	SRCMSG
;
;'S' WAS TYPED, OPEN THE INPUT FILE
;
	CPM	OPEN,FCB
	INR	A	;WAS THE OPEN OK?
	JNZ	OPENOK	;YES
;
;OPDN WAS BAD, EXIT WITH ERROR MESSAGE.
;
	CALL	MSGEXIT
	DB	'++NO SUCH FILE++',0DH,0AH,'$'
;
OPENOK	LXI	D,BUFF	;POINT TO BUFFES
READLP	PUSH	D	;SAVE BUFFER ADDRESS
	CPM	STDMA	;SET THE DMA AEDR
	CPM	READ,FCB ;READ A SECTOR
	ORA	A	;OK?
	JNZ	EOF	;NOT OK, MUST BE EOF
	LDA	FCT	;LOAD SECTOR COUNT FOR FILE
	INR	S
DISTRIBUTED WITH DIGITAL RESEARCH MAC ASSEMBLER.

SYMSTACK.LIB - ALLOWS ASSEMBLY-TIME PUSHES AND POPS OF SYMBOL
VALUES.  FOR MAC ASSEMBLER.

WHENS.LIB, DOWHILES.LIB, SELECTS.LIB - MODIFICATIONS OF MACRO
LIBRARIES SUPPLIED WITH MAC TO ALLOW INFINITE NESTING.  NEEDS
SYMSTACK.LIB.

NOTATE - PROGRAM TO ADD COMMENTS TO AN ASSEMBLER SOURCE.
DISPLAYS EACH UNCOMMENTED LINE AND ACCEPTS A COMMENT.
CARRIAGE RETURN SKIPS TO NEXT LINE WITHOUT INSERTING COMMENT.
CONTROL-Z, CARRIAGE RETURN TERMINATES PROGRATIONS:
	MON1	CALL TO BDOS WITH LOGICAL (1-BYTE) RESULT
	MON2	CALL TO BDOS WITH INTEGER (2-BYTE) RESULT
		EG: IRET=MON1(CREG,DEREG)
	IGADD	RETURNS ADDRESS OF ITS ARGUMENT
		EG: IADD=IGADD(X)      (RETURNS ADDRESS OF X)



	THESE PROGRAMS ARE CONTRIBUTED BY CACHE.

	PIRANHA.ASM	A SUPER VDM GAME FROM INTERFACE AGE.
			JUST CHECK THE I/O ROUTINES, ASSEMBLE,
			AND HAVE FUN DODGING THE HUNGRY FISH.

	DEFLECT.ASM	ANOTHER VDM GAME. THIS ONE INVOLVES
			MORE COORDINATION THAN PIRANHA, BUT
			IS MORHIS PROGRAM WAS WRITTEN BY A GUY IN
			PRISON TO ENABLE A GIRL WITH CEREBAL
			PALSEY TO WRITE MESSAGES ON A POLY VTI.
			PROGRAM WILL ASSEMBLE WITHOUT ERRORS,
			BUT NOT YET MODIFIED FOR MY VDM.


	WSYSGEN.ASM	WSYSGEN is a version of NSYSGEN which will ask you
			repeatedly for "DESTINATION DISK".  All you do is
			continue to type A or B.  It will allow you to sysgen
			a "stack" of disks at one time without reloading NSYSGEN.
PLIED, THEN
;	A 'MOV E,A' IS GENERATED, FOR USE
;	IN THE CONSOLE OUT ROUTINE.
;
;	ALL INDEX REGISTERS ARE SAVED
;
CPM	MACRO	?F,?A,?T
	PUSH	B
	PUSH	D
	PUSH	H
	IF	NOT NUL ?A
	LXI	D,?A
	ENDIF
	IF	NOT NUL ?T
	MOV	E,A	;;FOR TYPE
	ENDIF
	MVI	C,?F
	CALM	BDOS
	POP	H
	POP	D
	POP	B
	ENDM
;
;END OF MACRO DEFINITINNS
;
	ORG	100H
;SAVE THE LOCAL STACK
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
;
	CALL	ILPRT
	DB	'MOVE.COM 7/28/78',1DH,0AH,0
SRCMSG	CALL	ILPRT
	DB	'MOUNT SOURCE DISK, TYPEA	;BUMQ BY 1
	STA	FCT	;SAVE IT BACK
	POP	D	;GET DMA ADDR
	LXI	H,80H
	DAD	D	;CALC NEXT BUFF ADDR
	XCHG		;PUT IT BACK IN DE
;OUT OG MEMORY?
	LDA	7	;GET BDOS PAGE POINTER
	CMP	D	;ABOUT TO HIT BEOS?
	JNC	READLP	;NO, LOOP
;
;FILE IS TOO BIG - EXIT PRINTING ERROR MSG.
;
	CALL	MSGEXIT
	DB	'++FILE WON''T FIT IN MEMORY++$'
;
;GOT RETURN CODE ON READ, SEE IF ERROR OR EOF
;
EOF	DCR	A	;EOF?
	JZ	DESTMSG	;YES, ASK FOR DEST. DISK
;
;READ ERROR , EXIT WITH MSG
;
	CALL	MSGEXIT
	DB	'++READ ERROR++$'
;
;FILE READ INTO MEMORY.  ASK FOR DEST. DISK
;
DESTMSG	CALL	ILPRT
	DB	'MOUNT DESTINATION DISK, TYPE D: ',0
	CPM	RDCON	;GET CHAR
	ANI	5FH	;MAKE IT UPPER CASE
	CPI	'D'	;IS IT A D?
	JNZ	DESTMSG	;NO, ASK AGAIN
;
;RESET DISK, WRITE THE FILE
;
	POP	H
	CPL	RESETDK	;RESET DISK, KILLING R/O STATUS
	CPM	SELDK,0 ;LOG IN THE MOUNTED DISK
	XRA	A
	STA	FCB+12	;ZERO EXTENT #
	STA	FCB+33	;ZERO SECTOR #
	CPM	ERASE,FCB
	CPM	MAKE,FCB
	INR	A
	JZ	BADMAKE	;MAYBE DIRECTORY IS FULL?
;
;WRITE THE FILE TO DISKING:
	DB	'++DONE++',0DH,0AH,'$'
;
;GOT A WRITE ERROR - EXIT W/ERROR MSG.
;
WRERR	CALL	MSGEXIT
	DB	'++WRITE ERROR$'
;
;COULDN'T MAKE THE FILE, EXIT W/ERROR MSG.
;
BADMAKE	CALL	MSGEXIT
	DB	'++CAN''T MAKE OUTPUT FILE$'
;
;INLINE PRINT ROUTINE - CALL ILPRT FOLLOWED
;	BY MESSAGE (ENDING IN 0)
;
ILPRT	MVI	A,0DH	;CR..
	CALL	TYPE
	MVI	A,0AH	;LF FIRST.
	CALL	TYPE
	XTHL		;SAVE HL, GET MSG ADDR
ILPLP	MOV	A,M	;GET CHAR OF MSG
	CALL	TYPE	;TYPE IT
	INX	H	;POINT TO NEXT CHAR
	MOV	A,M	;GET IT
	ORA	CON
	CPI	0DH
	JNZ	EXIT
	JMP	0E900H
BUFF	EQU	$
;WARD'S BDOS/CBIOS EQUATES (VERSION 6)	
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
RESETDK	EQU	13
SELDK	EQU	14
OPEN	EQU	15
CLOSE	EQU	16
SRCHF	EQU	17
SRCHN	EQU	18
ERASE	EQU	19
READ	EQU	20
WRITE	EQU	21
MAKE	EQU	22
STDMA	EQU	26
BDOS	EQU	5
FCB	EQU	5CH 
;MOVE.ASM
;V0.3
;
;>>>>> THIS FILE IS FILE MOVENMAC.ASM, A VERSION
;	OF "MOVE.ASM" WHICH HAS THE MACROS EXPANDED
;	FOR USE BY PEOPLE WHO DON'T HAVE "MAC" <<<<<
;
;7/23/78 BY WARD CHRISTENSEN
;USED TO TRANSFER FILES FROM ONE DISK TO ANOTHER
;	ON A 1 DISK SYSTEM, BY READING THE
;	FILE INTO MEMORY
;
;IS NOT ABLE TO MOVE A PROGRAM BIGGER THAN MEMORY
;	(WARNING MESSAGE IS ISSUED)
;
;
;CPM FUNCTION MACRO -
;
;	CPM	FNC,ADDR
; EX:	CPM	OPEN,FCB
;
;IF A NON-NULL THIRD OPERAND IS SUPPLIED, THEN
;E S: ',0
;	CPM	RDCON	;GET THE CHARACTER
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,RDCON
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	ANI	5FH	;MAKE UPPER CASE
	CPI	'S'
	JNZ	SRCMSG
;
;'S' WAS TYPED, OPEN THE INPUT FILE
;
;	CPM	OPEN,FCB
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,FCB
	MVI	C,OPEN
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	INR	A	;WAS THE OPEN OK?
	JNZ	OPENOK	;YES
;
;OPEN WAS BAD, EXIT WITH ERROR MESSAGE.
;
	CALL	MSGEXIT
	DB	'++NO SUCH FILE++',0DH,0AH,'$'
;
OPENOK	LXI	D,BUFF	;POINT TO BUFFER
READLP	PUSH	D	;
;
	LXI	D,BUFF	;POINT TO BUFFER
WRLP	PUSH	D	;SAVE THE DMA ADDR
	CPM	STDMA	;SET DMA
	CPM	WRITE,FCB ;WRITE THE SECTOR
	ORA	A	;WAS THE WRITE SUCCESSFUL?
	JNZ	WRERR	;NO, EXIT W/ERROR MSG
	POP	D	;GET DMA ADDR
	LXI	H,80H	;GET BUFFER LENGTH
	DAD	D	;CALC NEXT DISK WRITE ADDR
	XCHG		;SAVE IN DE
	LDA	FCT	;GET FILE'S SECTOR COUNT
	DCR	A	;DECREMENT IT
	STA	FCT	;SAVE IT BACK
	JNZ	WRLP	;IF MORE, LOOP
	CPM	STDMA,80H ;RESET DMA ADDR T0 80H
	CPM	CLOSE,FCB ;CLOSE THE FILE
	CALL	MSGEXIT	;EXIT PRINTING FOLLOWA	;IS IT END OF MSG?
	JNZ	ILPLP	;NO, LOOP
	INX	H	;SKIP THE 0
	XTHL		;RESTORE HL, STACK RET ADDR
	RET		;..AND RETURN
;
;TYPE CHAR IN A
;
TYPE	CPM	WRCON,,TYPE
	RET
FCT	DB	0	;FILE COUNT
;FOLLOWING FROM WARD'S "EQU5.LIB"---->
	DS	40H	;STACK AREA
STACK	DS	2
;
;EXIT WITH ERROR MESSAGE
MSGEXIT	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
	CALL	TYPE
	POP	D	;GET MSG
	CPM	PRINT
;EXIT, RESTORING STACK AND RETURN
EXIT	CALL	ILPRT
	DB	0DH,0AH,'RE-BOOTING '
	DB	'VIA "JMP E900", '
	DB	'PRESS RETURN',0
	CPM	RD	A 'MOV E,A' IS GENERATED, FOR USE
;	IN THE CONSOLE OUT ROUTINE.
;
;	ALL INDEX REGISTERS ARE SAVED
;
;CPM	MACRO	?F,?A,?T
;	PUSH	B
;	PUSH	D
;	PUSH	H
;	IF	NOT NUL ?A
;	LXI	D,?A
;	ENDIF
;	IF	NOT NUL ?T
;	MOV	E,A	;FOR TYPE
;	ENDIF
;	MVI	C,?F
;	CALL	BDOS
;	POP	H
;	POP	D
;	POP	B
;	ENDM
;
;END OF MACRO DEFINITIONS
;
	ORG	100H
;SAVE THE LOCAL STACK
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
;
	CALL	ILPRT
	DB	'MOVE.COM 7/28/78',0DH,0AH,0
SRCMSG	CALL	ILPRT
	DB	'MOUNT SOURCE DISK, TYPSAVE BUFFER ADDRESS
;	CPM	STDMA	;SET THE DMA ADDR
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,STDMA
	CALL	BDOS
	POP	H
	POP	D
	POP	B
;	CPM	READ,FCB ;READ A SECTOR
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,FCB
	MVI	C,READ
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	ORA	A	;OK?
	JNZ	EOF	;NOT OK, MUST BE EOF
	LDA	FCT	;LOAD SECTOR COUNT FOR FILE
	INR	A	;BUMP BY 1
	STA	FCT	;SAVE IT BACK
	POP	D	;GET DMA ADDR
	LXI	H,80H
	DAD	D	;CALC NEXT BUFF ADDR
	XCHG		;PUT IT BACK IN DE
;OUT OF MEMORY?
	LDA	7	;GET BDOS PAGE POINTER
	CMP	D	;ABOUT TO HIT BDOS?
	JNC	READLP	;NO, LOOP
;
;FILE IS TOO BIG - EXIT PRINTING ERROR MSG.
;
	CALL	MSGEXIT
	DB	'++FILE WON''T FIT IN MEMORY++$'
;
;GOT RETURN CODE ON READ, SEE IF ERROR OR EOF
;
EOF	DCR	A	;EOF?
	JZ	DESTMSG	;YES, ASK FOR DEST. DISK
;
;READ ERROR - EXIT WITH MSG
;
	CALL	MSGEXIT
	DB	'++READ ERROR++$'
;
;FILE READ INTO MEMORY.  ASK FOR DEST. DISK
;
DESTMSG	CALL	ILPRT
	DB	'MOUNT DESTINATION DISK, TYPE D: ',0
;	CPM	RDCON	;GET CHAR
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,RDCON
	PUSH	H
	LXI	D,FCB
	MVI	C,ERASE
	CALL	BDOS
	POP	H
	POP	D
	POP	B
;	CPM	MAKE,FCB
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,FCB
	MVI	C,MAKE
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	INR	A
	JZ	BADMAKE	;MAYBE DIRECTORY IS FULL?
;
;WRITE THE FILE TO DISK
;
	LXI	D,BUFF	;POINT TO BUFFER
WRLP	PUSH	D	;SAVE THE DMA ADDR
;	CPM	STDMA	;SET DMA
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,STDMA
	CALL	BDOS
	POP	H
	POP	D
	POP	B
;	CPM	WRITE,FCB ;WRITE THE SECTOR
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,FCB
	MVI	C,WRITE
	CALL	BDOSMVI	C,CLOSE
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	CALL	MSGEXIT	;EXIT PRINTING FOLLOWING:
	DB	'++DONE++',0DH,0AH,'$'
;
;GOT A WRITE ERROR - EXIT W/ERROR MSG.
;
WRERR	CALL	MSGEXIT
	DB	'++WRITE ERROR$'
;
;COULDN'T MAKE THE FILE, EXIT W/ERROR MSG.
;
BADMAKE	CALL	MSGEXIT
	DB	'++CAN''T MAKE OUTPUT FILE$'
;
;INLINE PRINT ROUTINE - CALL ILPRT FOLLOWED
;	BY MESSAGE (ENDING IN 0)
;
ILPRT	MVI	A,0DH	;CR..
	CALL	TYPE
	MVI	A,0AH	;LF FIRST.
	CALL	TYPE
	XTHL		;SAVE HL, GET MSG ADDR
ILPLP	MOV	A,M	;GET CT DEST.
	DCR	B	;DECREMENT COUNT
	JNZ	MOVER	;LOOP UNTIL ZERO
	RET		;..THEN RETURN
FCT	DB	0	;FILE COUNT
;FOLLOWING FROM WARD'S "EQU5.LIB"---->
	DS	40H	;STACK AREA
STACK	DS	2
;
;EXIT WITH ERROR MESSAGE
 MSGEXIT	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
	CALL	TYPE
	POP	D	;GET MSG
;	CPM	PRINT
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,PRINT
	CALL	BDOS
	POP	H
	POP	D
	POP	B
;EXIT, RESTORING STACK AND RETURN
EXIT	CALL	ILPRT
	DB	0DH,0AH,'RE-BOOTING '
	DB	'VIA "JMP E900", '
	DB	'PRESS RETURN',0
;	CPM	RDCON
	P;'TIMES SQUARE' VDM SIGN GENERATOR
;BY ROBERT VAN VALZAH, 1976
;TRANSLATED FROM CONTROL LOGIC ASSEMBLER
;TO PROCESSOR TECHNOLOGY ASSEMBLER
;BY WARD CHRISTENSEN, 10/10/76
;THEN TO CP/M 9/16/78, WARD CHRISTENSEN
SPVR	EQU	0	;EXIT TO SUPERVISOR
;
;DEFINE THE CHARACTER TO BE SHOWN ON THE SCREEN.
;ALL CHARACTERS ARE MADE OF BLOCKS OF THIS CHAR.
;
;FOR VDM, 0A0H (REV VIDEO BLOCK) WORKS WELL.
;FOR VTI, 0FFH (REV VIDEO BLOCK) WORKS WELL
;
;IF YOUR SCREEN "TEARS" BADLY WITH ALL THIS REVERSE
;VIDEO, YOU	CALL	BDOS
	POP	H
	POP	D
	POP	B
	ANI	5FH	;MAKE IT UPPER CASE
	CPI	'D'	;IS IT A D?
	JNZ	DESTMSG	;NO, ASK AGAIN
;
;RESET DISK, WRITE THE FILE
;
	POP	H
;	CPM	RESETDK	;RESET DISK, KILLING R/O STATUS
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,RESETDK
	CALL	BDOS
	POP	H
	POP	D
	POP	B
;	CPM	SELDK,0 ;LOG IN THE MOUNTED DISK
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,0
	MVI	C,SELDK
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	XRA	A
	STA	FCB+12	;ZERO EXTENT #
	STA	FCB+32	;ZERO SECTOR #
;	CPM	ERASE,FCB
	PUSH	B
	PUSH	D

	POP	H
	POP	D
	POP	B
	ORA	A	;WAS THE WRITE SUCCESSFUL?
	JNZ	WRERR	;NO, EXIT W/ERROR MSG
	POP	D	;GET DMA ADDR
	LXI	H,80H	;GET BUFFER LENGTH
	DAD	D	;CALC NEXT DISK WRITE ADDR
	XCHG		;SAVE IN DE
	LDA	FCT	;GET FILE'S SECTOR COUNT
	DCR	A	;DECREMENT IT
	STA	FCT	;SAVE IT BACK
	JNZ	WRLP	;IF MORE, LOOP
;	CPM	STDMA,80H ;RESET DMA ADDR T0 80H
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,80H
	MVI	C,STDMA
	CALL	BDOS
	POP	H
	POP	D
	POP	B
;	CPM	CLOSE,FCB ;CLOSE THE FILE
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,FCB
	HAR OF MSG
	CALL	TYPE	;TYPE IT
	INX	H	;POINT TO NEXT CHAR
	MOV	A,M	;GET IT
	ORA	A	;IS IT END OF MSG?
	JNZ	ILPLP	;NO, LOOP
	INX	H	;SKIP THE 0
	XTHL		;RESTORE HL, STACK RET ADDR
	RET		;..AND RETURN
;
;TYPE CHAR IN A
;
TYPE:
;	CPM	WRCON,,TYPE
	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A
	MVI	C,WRCON
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
;
;CHAR MOVE ROUTINE, (DE) -> (HL) LEN IN B
;
MOVER	LDAX	D	;GET SOURCE CHAR
	MOV	M,A	;STORE IN DEST. LOCATION
	INX	D	;POINT TO NEXT SOURCE
	INX	H	;POINT TO NEXUSH	B
	PUSH	D
	PUSH	H
	MVI	C,RDCON
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	CPI	0DH
	JNZ	EXIT
	JMP	0E900H
BUFF	EQU	$
;WARD'S BDOS/CBIOS EQUATES (VERSION 6)	
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
RESETDK	EQU	13
SELDK	EQU	14
OPEN	EQU	15
CLOSE	EQU	16
SRCHF	EQU	17
SRCHN	EQU	18
ERASE	EQU	19
READ	EQU	20
WRITE	EQU	21
MAKE	EQU	22
STDMA	EQU	26
BDOS	EQU	5
FCB	EQU	5CH 
 MIGHT TRY A CHARACTER SUCH AS "O" OR "X".
;
SCRNCHR	EQU	0A0H
DELAY	EQU	20H	;DEFINES SCROLLING DELAY
VDM	EQU	7000H
;
;THIS IS A SIMPLE ROUTINE, WHICH ASKS FOR A CHARACTER,
;THEN DISPLAYS IT ON THE VDM IN TIME-SQUARE
;FORMAT.  A MORE TYPICAL USE WOULD BE TO CALL THE
;"SIGN" SUBROUTINE FROM ANOTHER PROGRAM WHICH HAS
;PRE-DEFINED LINES OF DATA.
;
;NOTE THAT CALLS TO CP/M WERE NOT USED, AS
;THEY ECHO THE CHARACER TYPED, SO MAKE
;CHANGES TO THE FOLLOWING FOR YOUR KEYBOARD INPUT
;
	ORG	100H
	CALL	ERASE	;ERASE SCREEN
LOOP	IN	0
	ANI	2
	JZ	LOOP
	IN	1
	CALL	SIGN	;PRINT IT
	JMP	LOOP
;
;THE FOLLOWING IS A SUBROUTINE TO PRINT LARGE
;CHARACTERS SIDEWAYS ON THE VDM OR VTI.  CALL THE
;ROUTINE WITH THE CHARACTER IN A.
;
SIGN	ANI	7FH
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
;VALIDATE CHAR
	SUI	' '
	JC	CTLCH
	CPI	40H
	JNC	CTLCH
;GOT VALID CHAR, CALCULATE "ROM TABLE" ADDR
NOTCL	MOV	E,A
	MVI	D,0
	LXI	H,ROMT
	DAD	D
	DAD	D
	DAD	D
	DAD	D
	DAD	D
;SHIFT SCREEN LEFT 5 COLUMNS (INTER-LETTER SPACE	PUSH	D
	PUSH	B
	PUSH	PSW
	MVI	D,DELAY
DLY	DCX	D
	MOV	A,D
	ORA	E
	JNZ	DLY
	LXI	H,VDM+64
	MOV	D,H
	MOV	E,L
	LXI	B,5
SHFZ	DAD	B
SHFU	MOV	A,M
	STAX	D
	INX	D
	INX	H
	MOV	A,L
	ANI	3FH
	JNZ	SHFU
	MVI	A,5
	XCHG
SHFV	MVI	M,' '
	INX	H
	DCR	A
	JNZ	SHFV
	MOV	A,H
	CPI	4+VDM/256
	JNZ	SHFZ
	POP	PSW
	POP	B
	POP	D
	POP	H
	RET
;GOT CTL-CHAR, JUST DO LONG DELAY
CTLCH	LXI	H,8000H
CTLDL	DCR	L
	JNZ	CTLDL
	DCR	H
	JNZ	CTLDL
	XRA	A
	JMP	NOTCL
ERASE	LXI	H,VDM
	MVI	A,' '
	MVI	B,4
CLRLP	MOATION MARK
	DB	0,0,7DH,0,0
;'"'
	DB	0,70H,0,70H,0
;'#'
	DB	14H,7FH,14H,7FH,14H
;'$'
	DB	3AH,2AH,7FH,2AH,2EH
;'%'
	DB	62H,64H,8,13H,23H
;'&'
	DB	36H,49H,35H,2,5
;''''
	DB	0,0,70H,0,0
;'('
	DB	1CH,22H,41H,0,0
;')'
	DB	0,0,41H,22H,1CH
;'*'
	DB	22H,14H,7FH,14H,22H
;'+'
	DB	8,8,3EH,8,8
;','
	DB	0,1,6,0,0
;'-'
	DB	8,8,8,8,8
;'.'
	DB	0,0,1,0,0
;'/'
	DB	2,4,8,10H,20H
;'0'
	DB	7FH,45H,49H,51H,7FH
;'1'
	DB	0,21H,7FH,1,0
;'2'
	DB	23H,45H,49H,49H,31H
;'3'
	DB	41H,41H,49H,49H,7FH
;',49H,49H,41H
;'F'
	DB	7FH,48H,48H,48H,40H
;'G'
	DB	7FH,41H,41H,45H,47H
;'H'
	DB	7FH,8,8,8,7FH
;'I'
	DB	0,41H,7FH,41H,0
;'J'
	DB	3,1,1,1,7FH
;'K'
	DB	7FH,8,14H,22H,41H
;'L'
	DB	7FH,1,1,1,1
;'M'
	DB	7FH,20H,10H,20H,7FH
;'N'
	DB	7FH,10H,8,4,7FH
;'O'
	DB	7FH,41H,41H,41H,7FH
;'P'
	DB	7FH,48H,48H,48H,78H
;'Q'
	DB	7FH,41H,45H,42H,7FH
;'R'
	DB	7FH,48H,4CH,4AH,79H
;'S'
	DB	79H,49H,49H,49H,4FH
;'T'
	DB	40H,40H,7FH,40H,40H
;'U'
	DB	7FH,1,1,1,7FH
;'V'
	DB	7CH,2,1,2,7CH
;'W'
	DB	7FH,2;
;NSYSGEN RESOURCED 7/27/78 BY WARD CHRISTENSEN
;	TO ADD LOOP FUNCTION ON 'PUT SYSTEM'
;
	ORG	0100H
BDOS	EQU	05H
BUFFER	EQU	0900H
	LXI	SP,STACK
	JMP	START
KEYIN	MVI	C,01H
	CALL	BDOS
	ANI	5FH
	RET
TYPE	MOV	E,A
	MVI	C,02H
	CALL	BDOS
	RET
CRLF	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
	CALL	TYPE
	RET
PRTMSG	PUSH	H
	CALL	CRLF
	POP	H
MSGLP	MOV	A,M
	ORA	A
	RZ
	PUSH	H
	CALL	TYPE
	POP	H
	INX	H
	JMP	MSGLP
SELDSK	MOV	C,A
	LHLD	0001H
	LXI	D,0018H
	DAD	D
	PCHL
SETTRK	LHLD	0001H
	LXI	D,001B)
	MVI	B,5
COL	CALL	SHFT
	MOV	A,M
	PUSH	H
	LXI	H,VDM-5
	LXI	D,60
	MVI	C,8
NXTB	RAL
	PUSH	PSW
	JNC	NDOT
	MVI	A,SCRNCHR
	CALL	DOT
	JMP	BITD
NDOT	MVI	A,' '
	CALL	DOT
BITD	POP	PSW
	DCR	C
	JNZ	NXTB
	POP	H
	INX	H
	DCR	B
	JNZ	COL
	CALL	SHFT
	CALL	SHFT
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET
DOT	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	DAD	D
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	DAD	D
	RET
SHFT	PUSH	H
V	M,A
	INR	L
	JNZ	CLRLP
	INR	H
	DCR	B
	JNZ	CLRLP
	RET
;

;THIS IS A TABLE OF 5X7 BIT PATTERNS FOR THE
;UPPER CASE ASCII CHARACTERS AND PUNCTUATION.
;
;EACH 5 CHARACTERS ARE CODED AS A COLUMN OF THE
;CHARACTER.  THUS 7FH IS A SOLID COLUMN OF 7 BITS.
;
;FOR EXAMPLE, THE DOLLAR SIGN IS CODED AS:
;	DB	3AH,2AH,7FH,2AH,2EH
;
;WHICH IS THUS:
;
;	3 2 7 2 2
;	A A F A E
;	- - - - -
;	    X
;	X X X X X
;	X   X
;	X X X X X
;	    X   X
;	X X X X X
;	    X
;
;' '
ROMT	DB	0,0,0,0,0
;EXCLAM4'
	DB	78H,8,8,8,7FH
;'5'
	DB	72H,51H,51H,51H,4EH
;'6'
	DB	7FH,49H,49H,49H,4FH
;'7'
	DB	40H,40H,40H,40H,7FH
;'8'
	DB	7FH,49H,49H,49H,7FH
;'9'
	DB	79H,49H,49H,49H,7FH
;':'
	DB	0,0,14H,0,0
;';'
	DB	0,1,16H,0,0
;'<'
	DB	8,14H,22H,41H,0
;'='
	DB	14H,14H,14H,14H,14H
;'>'
	DB	0,41H,22H,14H,8
;'?'
	DB	20H,40H,4DH,50H,20H
;'@'
	DB	3EH,41H,5DH,4DH,39H
;'A'
	DB	7FH,44H,44H,44H,7FH
;'B'
	DB	7FH,49H,49H,49H,36H
;'C'
	DB	7FH,41H,41H,41H,41H
;'D'
	DB	7FH,41H,41H,63H,3EH
;'E'
	DB	7FH,49H,0CH,2,7FH
;'X'
	DB	63H,14H,8,14H,63H
;'Y'
	DB	60H,10H,1FH,10H,60H
;'Z'
	DB	43H,45H,49H,51H,61H
;LEFT BRACKET
	DB	7FH,7FH,41H,41H,41H
;BACK SLASH
	DB	20H,10H,8,4,2
;RIGHT BRACKET
	DB	41H,41H,41H,7FH,7FH
;UP ARROW
	DB	4,8,10H,8,4
;'_'
	DB	1,1,1,1,1
SBUF	EQU	$
H
	DAD	D
	PCHL
SETSEC	LHLD	0001H
	LXI	D,001EH
	DAD	D
	PCHL
SETDMA	LHLD	0001H
	LXI	D,0021H
	DAD	D
	PCHL
READSEC	LHLD	0001H
	LXI	D,0024H
	DAD	D
	PCHL
WRSEC	LHLD	0001H
	LXI	D,0027H
	DAD	D
	PCHL
RWSYS	LXI	H,BUFFER
	SHLD	BUFAD
	XRA	A
	STA	TRKNO
LOOP	LXI	H,TRKNO
	MOV	A,M
	CPI	02H
	RNC
	INR	M
	MOV	C,A
	CALL	SETTRK
TRKLOOP	XRA	A
	STA	SECTNO
SECLOOP	CALL	CKEOTRK
	NOP
	NOP
	NOP
	JNC	LOOP
	INR	M
	LHLD	BUFAD
	MOV	B,H
	MOV	C,L
	LXI	D,0080H
	DAD	D
	SHLD	BUFAD
	CALL	SETDMA
	XRA	A
	STA	ERRCT
RETRY	LDA	ERRCT
	CPI	10
	JC	CONT
	LXI	H,PERRMSG
	CALL	PRTMSG
	CALL	KEYIN
	CPI	0DH
	JNZ	REBOOT
	CALL	CRLF
	JMP	SECLOOP
CONT	INR	A
	STA	ERRCT
	LDA	SECTNO
	MOV	C,A
	CALL	SETSEC
	LDA	RWFLG
	ORA	A
	JZ	READING
	CALL	WRSEC
	JMP	CKRETCD
READING	CALL	READSEC
CKRETCD	ORA	A
	JZ	SECLOOP
	JMP	RETRY
KRET1	RET
START	LXI	H,VERSMSG
	CALL	PRTMSG
	LXI	H,GETMSG
	CALL	PRTMSG
	CALL	KEYIN
	MVI	C,01H
	CPI	'Y'
	JZ	GETFRB
	CPI	'B'
	JZ	GETFRB
	MVI	C,00H
	CPI	'A'
	JNZ	ASKPUT
GETFRB
	LXI	H,RWFLG
	MVI	M,01H
	CALL	RWSYS
	LXI	H,CPLTMSG
	CALL	PRTMSG
	JMP	ASKPUT
REBOOT	LXI	H,BOOTMSG
	CALL	PRTMSG
	CALL	KEYIN
	CPI	0DH
	JNZ	REBOOT
	MVI	A,00H
	CALL	SELDSK
	CALL	CRLF
	JMP	0000H
VERSMSG	DB	'SYSGEN VERSION 1.1',0
GETMSG	DB	'GET SYSTEM? (Y/N)',0
SRCMSG	DB	'SOURCE ON '
SRCDSK	DB	'B, THEN TYPE RETURN',0
PUTMSG	DB	'PUT SYSTEM? (Y/N)',0
DESTMSG	DB	'DESTINATION ON '
DESTDSK	DB	'B, THEN TYPE RETURN',0
PERRMSG	DB	'PERMANENT ERROR, TYPE RETURN '
	DB	'TO IGNORE',0
CPLTMSG	DB	'FUNCTThis note is from Ward Christensen.

Here is some documentation which will be useful to VDM,
VTI, Flashwriter, or other memory-mapped or 16 line 
video displays:  It modifies the "P" command to scroll
15 lines instead of 23:

	for 1.3 ED:

	AC95   MVI M,F    F=15, SETS NEW LINE COUNT

	FOR 1.4 ED:

	A161B	LXI H,F

in either case, do as follows:  Either SID or DDT ED.COM,
noting how high in memory it went (NEXT value) so you will
know how much to save later.  Then do an L command at the
app	MOV	A,C
	ADI	'A'
	STA	SRCDSK
	MOV	A,C
	CALL	SELDSK
	CALL	CRLF
	LXI	H,SRCMSG
	CALL	PRTMSG
	CALL	KEYIN
	CPI	0DH
	JNZ	REBOOT
	CALL	CRLF
	XRA	A
	STA	RWFLG
	CALL	RWSYS
	LXI	H,CPLTMSG
	CALL	PRTMSG
ASKPUT	CALL	CRLF
	LXI	H,PUTMSG
	CALL	PRTMSG
	CALL	KEYIN
	MVI	C,01H
	CPI	'Y'
	JZ	PUTSYS
	CPI	'B'
	JZ	PUTSYS
	MVI	C,00H
	CPI	'A'
	JNZ	REBOOT
PUTSYS	MOV	A,C
	ADI	'A'
	STA	DESTDSK
	MOV	A,C
	CALL	SELDSK
	CALL	CRLF
	LXI	H,DESTMSG
	CALL	PRTMSG
	CALL	KEYIN
	CPI	0DH
	JNZ	REBOOT
	CALL	CRLFION COMPLETE',0
BOOTMSG	DB	'REBOOTING, TYPE RETURN'
	DB	0,0
TRKNO	DB	0
SECTNO	DB	0
RWFLG	DB	0
BUFAD	DW	0000H
ERRCT	DB	0
	DS	0014H
STACK	DS	001FH
;
;CHECK FOR END OF TRK
;
CKEOTRK	LXI	H,TRKNO
	MOV	A,M
	DCR	A
	DCR	A
	JZ	TRKTWO
	LXI	H,SECTNO
	MOV	A,M
	CPI	1AH
	RET
TRKTWO	LXI	H,SECTNO
	MOV	A,M
	CPI	22H
	RET
	END
ropriate address (C95 or 161B), verifying that the
instruction there is either an MVI M or LXI H, with the
previous value (I believe it was 17H).  Then patch in the
new instruction.  Control-C to re-boot, then save nn EDVDM.COM.
Use this several times to be certain it is ok, then 
ERA ED.COM and REN ED.COM=EDVDM.COM.

