 DCHAYES ASM   D	
        DCHDIAG ASM   4
          88-MODEMASM    ! 88-MODEMASM  ~"#$%&'()*+,-./01 88-MODEMDOC   
23               MODEM   ASM   f456789:;<=>?@    MODEM   DOC   ABC              UGFORM        !DEFGH            TTYDRV  MAC T IJK             
  ;MODEM CONTROL PROGRAM BY DALE HEATHERINGTON
;	4/4/77
;	ENTERED BY R.J.S.	01/01/78
;
;	MODIFIED BY DAVE JAFFE
;	FOR:	BDOS CALLS
;		RETURN TO CP/M ON CONTROL C
;
;
;MODEM CONTROL BYTES
ORIG300	EQU	5	;300 BPS ORIGINATE
ANSW300	EQU	1	;300 BPS ANSWER
ORIG110	EQU	4	;100 BPS ORIGINATE
ANSW110	EQU	0	;110 BPS ANSWER
OFFHOOK	EQU	80H	;OFF HOOK MASK
ONHOOK	EQU	7FH	;ON HOOK MASK
TXE	EQU	2	;XMTR ON MASK
TXOFF	EQU	0FDH	;XMTR OFF MASK
WORD	EQU	1FH	;8 BITS, NO PARITY, 2 STOP BITS
;
;PORT ASSIGNMENTS OR
			; '00' IF NOT.
;
;THIS ROUTINE LOOPS UNTIL THE LINE RINGS OR A
;CONTROL B IS TYPED ON THE CONSOLE.
;
SIGNON:	LXI 	SP,STKTOP
	LXI	H,SIGN	;POINT TO SIGNON MESSAGE
	CALL	PRINTM
	MVI	A,0
	OUT	STAT	;CLEAR MODEM REGISTER
RINGCK:	
	CALL	INSTAT	;GET CONSOLE STATUS
	CNZ	INPUT	;GET BYTE IF READY
	CPI	2	;CHECK FOR "STX" OR CONTROL B
	JZ	MAKCALL	;GOTO ORIG ROUTINE
	CPI	3	;CONTROL C?
	JZ	0	;BACK TO CP/M
	IN	STAT	;GET MODEM STATUS
	ANI	80H	;ISOLATE RING DET. BIT
	JNZ	RINGCK	;LOOP UNTIL IT GOES P IF TRUE
	CALL	DELAY	;WAIT 50 MS
	DCX	D	;COUNT IT
	MOV	A,D	;TEST FOR D&E =0
	ORA	E
	JNZ	CARR	;LOOP IF NOT TIMED OUT
	LXI	H,NOASW	;POINT TO STRING "NO ANSWER"
	CALL	PRINTM	;PRINT THE STRING
	JMP	EOT	;DISCONNECT
CONNECT:
	LDA	MDBYTE	;GET MODE
	ORI	TXE	;TURN ON XMTTR
	OUT	MODE
	STA	MDBYTE
	ANI	4	;ISOLATE ORIG/ANSW BIT
	CZ	SAB	;SEND ANSWER/BACK
TTY:	IN	STAT	;GET MODEM STATUS
	ANI	40H	;ISOLATE CARRIER DETECT BIT
	JNZ	OK	;
	LXI	H,LOSTC	;POINT TO STRING "LOST CARRIER"
	CALL	PRINTM	;PRINT THE S
;
DATA	EQU	80H	;MODEM DATA I/O PORT
STAT 	EQU	DATA+1	;STATUS PORT
MODE	EQU	DATA+2	;MODE CONTROL PORT
;
;	SYSTEM EQUATES
BDOS	EQU	5
;
	ORG	100H
;SENSE SWITCH A-15 IS USED FOR SPEED SELECT.UP IS 300 BAUD
;DOWN IS 110 BAUD.
;
;SENSE SWITCH A-8 UP WILL SUPRESS ECHO ON DATA TRANSMISSION
;
START	JMP	SIGNON
OUTPUT	JMP	USEROT	;JUMP TO USER OUT ROUTINE
INPUT	JMP	USERIN	;JUMP TO USER IN ROUTINE
INSTAT	JMP	USERST	;JUMP TO USER CONSOLE STATUS
			;CHECK ROUTINE. RETURNS 'FF'
			;IF A BYTE IS WAITINGLOW
ANCALL:
	CALL	AN110	;SET TO ANSWER MODE
	CALL	OFFHK	;GO OFFHOOK
	LDA	MDBYTE	;GET MODE
	ORI	TXE
	STA	MDBYTE
	OUT 	MODE	;TURN ON XMITTER
	JMP	CARR-3	;JMP TO DATA HANDLING ROUTINE
MAKCALL:
	LXI	SP,STKTOP
	CALL	OR110	;SET TO ORIGINATE MODE
	LXI	H,MNUM	;POINT TO STRING "NUMBER"
	CALL	PRINTM	;PRINT THE STRING
	CALL	DIAL	;GET AND DIAL A PHONE NUMBER
	LXI	D,400	;SETUP FOR A 20 SECOND DELAY
CARR:	CALL	SPEED	;SET SPEED
	IN	STAT	;LOOK FOR A CARRIER
	ANI	40H	;ISOLATE CARRIER BIT
	JNZ	CONNECT	;JUMTRING
	JMP	EOT
OK:	CALL 	SPEED	;SET SPEED
	IN	STAT	;GET MODEM STATUS
	ANI	1	;CHECK FOR A DATA BYTE
	CNZ	GETC	;GET THE BYTE
	CALL	INSTAT	;CHECK THE CONSOL STATUS
	ANA	A	;SET THE FLAGS
	JZ	TTY	;LOOP IF STATUS NOT TRUE
	CALL	INPUT	;GET THE CONSOL CHAR
	MOV	C,A	;SAVE IT
TTY1:	CALL	TRANS	;SEND AND ECHO THE CHAR
	JMP	TTY	;LOOP AGAIN
;
;SPEED SELECT ROUTINE
;USES SENSE SWITCH A-15; UP IS 300 BAUD,DOWN IS 110
;
SPEED:	PUSH	B
	LDA	MDBYTE	;GET PRESENT MODE
	MOV	B,A	
	IN	255	;GET SENSE SWITCH
	ANI	80H	
	MOV	A,B
	JZ	S110
	ORI	1	;SET TO 300 BPS
	DB	01H	;*****TRICK*** LXI B (NOP NEXT 2 BYTES)
S110:	ANI	0FEH	;SET TO 110 BPS
	STA	MDBYTE	
	OUT	MODE	;SET MODEM
	POP	B
	RET
;
;PRINTS CHAR ON CONSOLE.CHECKS FOR EOT CHAR
;AND TERMINATES CALL IF TRUE.
;
PRINT:	MOV	A,C	;GET A BYTE
	CPI	4	;CHECK FOR EOT
	JNZ	OUTPUT	;OUTPUT THE BYTE
EOT1:	LXI	H,MEOT	;POINT TO STRING "EOT"
	CALL	PRINTM	;PRINT IT
	MVI	B,10	;SET FOR .5 SEC DELAY
DLY3:	CALL	DELAY
	DCR	B
	JNZ	DLY3	;LOOP FOR .5 SEC
EOT:	LDA	MDBYTE55
	MOV	C,M	;GET A BYTE
	CMP	C	;TEST FOR FF (END OF STRING)
	RZ		;FINISHED
	CALL	OUTPUT	;PRINT IT
	INX	H	;POINT TO NEXT BYTE
	JMP	PRINTM	;LOOP AGAIN
;
;SETS THE MODEM TO ORIGINATE OR ANSWER MODE
;
OR110:	MVI	A,ORIG110	;GET MODE BYTE
	JMP	AN110+2
AN110:	MVI	A,ANSW110	;GET ANSWER MODE BYTE
	STA	MDBYTE	;SAVE IT
	OUT	MODE	;SETUP MODEM
	MVI	A,WORD	;GET WORD FORMAT
	OUT	STAT	;SETUP MODEM
	RET
;
;THIS ROUTINE GETS DIGITS FROM THE CONLOL
;AND STORES THEM IN MEMORY. IT HTEN TAKES THE LINE
;OFF HOV	C,A	;
	CALL	OUTPUT	;PRINT THE DIGIT TO BE DIALED
	CPI	'*'	;DELAY?
	JNZ	NODLY
	MVI	B,40	;SETUP FOR 2 SECOND DELAY
WAIT2:	CALL	DELAY
	DCR	B
	JNZ	WAIT2
NODLY:	INX	H	;POINT TO NEXT DIGIT
	SUI	30H	;REMOVE ASCII BIAS
	JNZ	NOTZERO	;CHECK FOR A DIGIT "0"
	MVI	A,10	;MAKE A 0 A 10
NOTZERO:
	JC	DIAL2+3	;IF <0 GET NEXT DIGIT
	CPI	11	;CHECK FOR MORE THAN 10
	JNC	DIAL2+3	;IF MORE GET NEXT DIGIT
	CALL	PULSE	;MAKE DIAL PULSES
	JMP	DIAL2+3
;
;THIS SUBROUTINE PULSES THE LINE,
;THE VALUE IN ACC EQUALS TCONTROL D?
	JZ	EOT1	;ABORT
	POP	PSW
	LXI	D,50
	LXI	H,0
DLYLP:	XTHL		;WAIST TIME FOR DELAY
	XTHL
	DAD	D	;ADD D&E TO H&L
	JNC	DLYLP	;LOOP UNTIL CARRY
	POP	D
	POP	H
	RET
;
;GETS BYTES FROM THE CONSOLE AND STORES THEM IN RAM.
;
GETNUM:	LXI	H,NMBR	;POINT TO BUFFER
	CALL	INSTAT	;GET KBD STATUS
	ANA	A	;SET FLAGS
	JZ	GETNUM+3;LOOP UNTIL KBD IS READY
	CALL	INPUT	;GET A DIGIT
	CPI	4	;CONTROL D
	JZ	SIGNON	;ABORT
	CPI	2	;IS IT A CONTROL B?
	JZ	GETNUM+3;IGNORE GARBAGE CHAR
	CPI	3	;IS IT A CONTROL	SETT	
ONHK:	LDA	MDBYTE	;GET CURRENT MODE BYTE
	ANI	ONHOOK	;RESET THE OFF HOOK BIT
SETT:	STA	MDBYTE	;SAVE NEW MODE BYTE
	OUT	MODE	;SET THE MODEM
	RET
;
;THIS SUBROUTINE SENDS THE ANSWER BACK MESSAGE
                ;
SAB:	PUSH	H
	PUSH	B
	LXI	H,ANSBK	;POINT TO ANSWER BACK MESSAGE
GAB:	MOV	A,M	;GET A BYTE
	CPI	255	;END?
	JZ	EXIT
	MOV	C,A
	CALL	TRANS	;SEND THE BYTE
	INX	H
	JMP	GAB	;LOOP AGAIN
EXIT:	POP	B
	POP	H
	RET
;
;THIS SUBROUTINE SENDS A BYTE TO THE MODEM
;AND TO THE CONSOL DISPLAY	;GET CURRENT MODE
	ANI	TXOFF	;TURN OFF XMTTR
	ANI	ONHOOK	;DISCONNECT LINE
	OUT MODE
	STA	MDBYTE
	LXI	H,TERM	;POINT TO STRING "TERMINATED"
	CALL	PRINTM	;PRINT IT
	JMP	SIGNON	;BACK TO THE START
;
;GETS A BYT FROM THE MODEM
;
GETC:	IN	DATA	;GET A MODEM BYTE
	ANI	7FH	;KILL PARITY
	CPI	4	;CHECK FOR EOT
	JZ	EOT1	;
	CPI	5	;CHECK FOR ENQ
	CZ	SAB	;SEND ANSWERBACK IF TRUE
	MOV	C,A
	CALL	OUTPUT	;PRINT THE CHAR
	RET
;
;THIS ROUTINE PRINTS AN ASCII STRING IN MEMORY ON THE CONSOL
;
PRINTM:	MVI	A,2OOK AND DIALS THE DIGITS STORED IN MEMORY.
;IF A '*' APPEARS IN THE DIGIT STRING THE PROGRAM
;PAUSES FOR 2 SECONDS. THIS IS TO WAIT FOR SECOND DIAL
;TONE IN SOME EXCHANGES.
;
DIAL:	CALL	GETNUM	;GET PHONE NUMBER FROM KBD
	CALL	OFFHK	;GO OFFHOOK
	LXI	H,MDIAL	;POINT TO STRING "DIALING--"
	CALL	PRINTM	;PRINT IT
	MVI	B,40	;SETUP FOR 2 SECOND DELAY
WAIT:	CALL	DELAY	;WAIT FOR DIAL TONE
	DCR	B
	JNZ	WAIT
DIAL2	LXI	H,NMBR	;POINT TO PHONE NUMBER
	MOV	A,M	;GET A DIGIT
	CPI	0DH	;CHECK FOR THE END
	RZ
	MHE NUMBER OF
;PULSES OUTPUT.
;
PULSE:	PUSH	PSW
	CALL	ONHK	;GO ONHOOK
	CALL	DELAY	;WAIT 50 MS
	CALL	OFFHK	;GO OFF HOOK
	CALL	DELAY	;WAIT 50 MS
	POP	PSW	;GET DIGIT
	DCR	A	;SUBTRACT 1 FROM DIGIT
	JNZ	PULSE	;ANOTHER PULSE IF NOT ZERO
	MVI	A,10	;SET UP FOR 500 MS DELAY
SPACE:	CALL	DELAY	;WAIT 500 MS
	DCR	A	;
	JNZ	SPACE
	RET		;DIGIT COMPLETE
;
;	THIS ROUTINE WAITS 50 MS BEFORE RETURNING
;
DELAY:	PUSH	H
	PUSH	D
	PUSH	PSW
	CALL	INSTAT
	ORA	A	;SET FLAGS
	CNZ	INPUT	;GET A CONSOL BYTE
	CPI	4	; C?
	JZ	0	;RETURN TO CP/M
	MOV	M,A	;STORE IT
	MOV	C,A	;
	PUSH	PSW	;SAVE ACC FROM VDM ROUTINE
	CALL	OUTPUT	;ECHO THE DIGIT
	POP	PSW	;SAFE AND SOUND
	CPI	0DH	;CHECK FOR ASCII "CR"
	RZ		;DONE IF TRUE
	INX	H	;POINT TO NEXT BUFFER LOC.
	CPI	08H	;BACKSPACE?
	JNZ	GETNUM+3;IF NOT GET NEXT DIGIT
	DCX	H
	DCX	H	;BACKUP POINTER
	JMP	GETNUM+3	;GET NEXT DIGIT
;
;THESE ROUTINES SET THE MODEM FOR "ONHOOK" OR "OFFHOOK"
;
OFFHK:	LDA	MDBYTE	;GET THE CURRENT MODE BYTE
	ORI	OFFHOOK	;SET THE OFF HOOK BIT
	JMP DEVICE.
;
TRANS:	IN	STAT	;SEE IF READY FOR BYTE
	ANI	2
	JZ	TRANS	;LOOP UNTIL READY
	MOV	A,C	;GET THE BYTE
	OUT	DATA	;SEND IT
	IN	0FFH	;INPUT FROM SENSE
	ANI	01	;CHECK ECHO BIT
	RZ		;DO NOT ECHO
	MOV	A,C	;GET BACK CHAR
	CALL	PRINT	;ECHO CHAR
	RET
MNUM:	DB	0DH,0AH
	DB	'NUMBER ?'
	DB	0DH,0AH,255
NOASW:	DB 	0DH,0AH
	DB	'NO ANSWER---'
	DB	255
TERM:	DB	0DH,0AH
	DB	'CALL TERMINATED'
	DB	0DH,0AH,255
MDIAL:	DB	0DH,0AH
	DB	'DIALING-'
	DB	255
LOSTC:	DB	0DH,0AH
	DB	'LOST CARRIER'
	DB	255
MEOT:	DB	0DH,0AH
	DB	'EOT'
	DB	255
SIGN:	DB	0DH,0AH
	DB 	'80/103 CONTROL PROGRAM'
	DB	0DH,0AH
	DB	0DH,0AH
	DB	'WAITING FOR RING OR CONTROL SHIFT B'
	DB	0DH,0AH
	DB	255
ANSBK:	DB	0,0,0DH,0,0,0AH
	DB	'THE CACHE COMPUTER NETWORK'
	DB	0DH,0,0,0,0AH,255
;
;USER ROUTINES
;
USEROT:	CALL	5A0CH
	RET
USERIN:	IN	1
	ANI	7FH
	RET
USERST:	IN	0
	ANI	80H
	MVI	A,0
	RNZ
	DCR	A
	RET
MDBYTE	DS	1		;MODE BYTE STORAGE LOC.
NMBR:	DS	20		;20 SPACES FOR PHONE #
STKTOP	EQU	$+16H		;STACK HERE
	END	START
	TITLE	'D. C. HAYES MODEM BOARD DIAGNOSTIC 1.1'
;
;
;
;PRIMITIVE LOOP AROUND DIAGNOSTIC FOR D. C. HAYES MODEM BOARD
;
;VERSION 1.0 WRITTEN 2/12/78
;VERSION 1.1 COMPLETE 2/18/78
;
;
;
		ORG	100H
;
		JMP	INITIALIZE
;
BASE		EQU	80H	;BASE PORT NUMBER
TRANSMIT$PORT	EQU	BASE	;TRANSMIT OUTPUT PORT
RECEIVE$PORT	EQU	BASE	;RECEIVE INPUT PORT
STATUS$PORT	EQU	BASE+1	;STATUS INPUT PORT
;
;STATUS PORT BIT ASSIGNMENTS
;
RRF:		EQU	01H	;RECEIVE REGISTER FULL
TRE:		EQU	02H	;TRANSMIT REGISTER EMPTY
PE:ABLE
MS:		EQU	04H	;MODE SELECT
ES:		EQU	08H	;ECHO SUPRESS
ST:		EQU	10H	;SELF TEST
RID:		EQU	20H	;RING INDICATOR DISABLE
OH:		EQU	80H	;OFF HOOK
;
;
;
BDOS:		EQU	05H
RDCON:		EQU	01H
PRINT:		EQU	09H
STCON:		EQU	0BH
WRCON:		EQU	02H
;
;ASCII MESSAGES
;
ATC$MSG:	DB	0DH,0AH,'ALL TESTS COMPLETE',0DH,0AH,'$'
CMP$ERR$MSG:	DB	0DH,0AH,'COMPARE ERROR $'
CW1$MSG:	DB	0DH,0AH,'CONTROL WORD 1 = $'
CW2$MSG:	DB	0DH,0AH,'CONTROL WORD 2 = $'
DCH$DIAG$MSG:	DB	0DH,0AH,'D. C. HAYES MODEM DIAGNOSTIC, '
		DB	'V1$MSG:	DB	0DH,0AH,'SET SENSE SWITCHES TO CONTROL'
		DB	' WORD 1,',0DH,0AH
		DB	'THEN TYPE ANY CHARACTER TO CONTINUE$'
SET$SS$CW2$MSG:	DB	0DH,0AH,'SET SENSE SWITCHES TO CONTROL'
		DB	' WORD 2,',0DH,0AH
		DB	'THEN TYPE ANY CHARACTER TO CONTINUE$'
;
;RAM STORAGE
;
CHAR$MASK:	DB	00H
CONTROL$WORD$1:	DB	00H
CONTROL$WORD$2:	DB	00H
MSG$FLAG:	DB	00H
TEST$DATA:	DB	00H
TRANS$DATA:	DB	00H
		DS	32
STACK:		DS	2	;CONTAINS CP/M'S STACK POINTER
;
;INITIALIZE THE MODEM FROM THE SENSE SWITCHES
;
INITIALIZEL$PORT$2
		CALL	SHOWHEX		;PRINT CONTROL WORD 2
		IN	RECEIVE$PORT	;RESET THE RRF BIT
		LXI	D,CRLF$MSG
		CALL	PRINT$MSG
;
;TEST LOOP, SEND, RECEIVE, AND COMPARE TEST DATA
;ANDED WITH CHARACTER MASK
;
TEST$LOOP:	XRA	A
		STA	TEST$DATA	;INITIALIZE TEST DATA
		LXI	D,PRINTING$MSG
		CALL	PRINT$MSG
TEST$LOOP1:	LDA	CHAR$MASK	;
		MOV	B,A
		LDA	TEST$DATA
		ANA	B
		STA	TRANS$DATA
		CALL	TRANSMIT	;SEND THE DATA
		CALL	RECEIVE		;RECEIVE THE DATA
		CALL	SHOWHEX		;PRINT THE RECEIVER DATA
		CALL	COMPARE			EQU	04H	;PARITY ERROR
FE:		EQU	08H	;FRAMING ERROR
OE:		EQU	10H	;OVERFLOW ERROR
CD:		EQU	40H	;CARRIER DETECT
NRI:		EQU	80H	;NO RINGING INDICATOR
;
CONTROL$PORT$1	EQU	BASE+1	;
;
;CONTROL PORT 1 BIT ASSIGNMENTS
;
EPE:		EQU	01H	;EVEN PARITY ENABLE
LS1:		EQU	02H	;LENGTH SELECT 1
LS2:		EQU	04H	;LENGTH SELECT 2
SBS:		EQU	08H	;STOP BIT SELECT
PI:		EQU	10H	;PARITY INHIBIT
;
CONTROL$PORT$2	EQU	BASE+2	;
;
;CONTROL PORT 2 BIT ASSIGNMENTS
;
BRS:		EQU	01H	;BIT RATE SELECT
TXE:		EQU	02H	;TRANSMIT ENERSION 1.1',0DH,0AH,0DH,0AH
		DB	'CONTROL-C RETURNS TO CP/M',0DH,0AH
		DB	'CONTROL-D RESTARTS DIAGNOSTIC',0DH,0AH
		DB	'ANY OTHER CHARACTER CONTINUES TEST'
		DB	0DH,0AH,'$'
PRINTING$MSG:	DB	'PRINTING RECEIVER DATA',0DH,0AH,'$'
RCV$DATA$MSG:	DB	0DH,0AH,'RECEIVER DATA = $'
RCV$ERR$MSG:	DB	0DH,0AH,'RECEIVER ERROR$'
STATUS$MSG:	DB	0DH,0AH,'STATUS REGISTER = $'
TRANS$DATA$MSG:	DB	0DH,0AH,'TRANSMITTER DATA = $'
CRLF$MSG:	DB	0DH,0AH,'$'
WAITING$MSG:	DB	'WAITING FOR CARRIER DETECT',0DH,0AH,'$'
SET$SS$CW:	LXI	H,0
		DAD	SP
		SHLD	STACK
INITIALIZE2:	LXI	SP,STACK
		LXI	D,DCH$DIAG$MSG
		CALL	PRINT$MSG
		LXI	D,SET$SS$CW1$MSG
		CALL	PRINT$MSG
		CALL	CHECK$CTRLS
		IN	0FFH
		STA	CONTROL$WORD$1
		LXI	D,SET$SS$CW2$MSG
		CALL	PRINT$MSG
		CALL	CHECK$CTRLS
		IN	0FFH
		STA	CONTROL$WORD$2
		CALL	SET$CHAR$MASK
INITIALIZE1:	LXI	D,CW1$MSG
		CALL	PRINT$MSG
		LDA	CONTROL$WORD$1
		OUT	CONTROL$PORT$1
		CALL	SHOWHEX		;PRINT CONTROL WORD 1
		LXI	D,CW2$MSG
		CALL	PRINT$MSG
		LDA	CONTROL$WORD$2
		OUT	CONTRO	;COMPARE SENT VERSUS RECEIVED DATA
		LDA	TEST$DATA
		INR	A
		STA	TEST$DATA
		JNZ	TEST$LOOP1
		XRA	A
		OUT	CONTROL$PORT$1	;TURN OFF THE MODEM
		OUT	CONTROL$PORT$2	;
		LXI	D,ATC$MSG
		CALL	PRINT$MSG
		CALL	CHECK$CTRLS
		JMP	INITIALIZE1
;
;TRANSMIT CHARACTER ROUTINE
;
TRANSMIT:	PUSH	PSW
		CALL	CHECK$CD
TRANSMIT1:	IN	STATUS$PORT
		ANI	TRE
		CPI	TRE		;WAIT FOR TRE
		JNZ	TRANSMIT1
		POP	PSW
		OUT	TRANSMIT$PORT	;OUTPUT DATA
		RET
;
;RECEIVE CHARACTER ROUTINE
;
RECEIVE:	CALL	CHECK$CD
		IN	STATUS$PORT
		ANI	RRF
		CPI	RRF		;WAIT FOR RRF
		JNZ	RECEIVE
		IN	STATUS$PORT
		ANI	OE + FE + PE
		CNZ	ERROR$RCV	;CHECK FOR ERRORS
		IN	RECEIVE$PORT	;GET DATA
		RET
;
;RECEIVER ERROR ROUTINE
;
ERROR$RCV:	LXI	D,RCV$ERR$MSG
		CALL	PRINT$MSG
		LXI	D,STATUS$MSG
		CALL	PRINT$MSG
		IN	STATUS$PORT
		CALL	SHOWHEX
		LXI	D,CRLF$MSG
		CALL	PRINT$MSG
		CALL	CHECK$CTRLS
		RET
;
;COMPARE TRANSMITTED TO RECEIVED DATA ROUTINE
;
COMPARE:	MOV	B,A		;RECEIVED DATA > B
		LDA	TRANS$DATA
		CMP	B
		RXI	D,WAITING$MSG
		CALL	PRINT$MSG
		MVI	A,0FFH
		STA	MSG$FLAG	;SET FLAG
CHECK$CD2	MVI	C,STCON		;CHECK FOR CHARACTER FROM CONSOLE
		CALL	BDOS
		ORA	A
		CNZ	CHECK$CTRLS
		JMP	CHECK$CD1
CHECK$CD3:	XRA	A		;RESET FLAG
		STA	MSG$FLAG
		RET
;
;SET CHARACTER MASK DEPENDING ON THE CONTENTS OF CONTROL WORD 1
;
SET$CHAR$MASK:	LDA	CONTROL$WORD$1
		ANI	06H
		JZ	MASK$5$CHAR
		CPI	02H
		JZ	MASK$6$CHAR
		CPI	04H
		JZ	MASK$7$CHAR
MASK$8$CHAR:	MVI	A,0FFH
		STA	CHAR$MASK
		RET
MASK$7$CHAR:	MVI	A,7FH
 POP D! POP B! POP PSW
		RET
;
;CHECK FOR CTRL-C AND CTRL-D
;
CHECK$CTRLS:	MVI	C,RDCON
		CALL	BDOS
		CPI	'D'-40H
		JZ	INITIALIZE2
		CPI	'C'-40H
		RNZ
		XRA	A
		OUT	CONTROL$PORT$1	;TURN OFF MODEM
		OUT	CONTROL$PORT$2
		LHLD	STACK
		SPHL			;GO BACK TO CP/M
		RET
;
;HEX OUTPUT ROUTINE
;
HEXO:		PUSH	PSW
		RAR! RAR! RAR! RAR
		CALL	NIBBL
		POP	PSW
NIBBL:		ANI	0FH
		CPI	10
		JC	ISNUM
		ADI	7
ISNUM:		ADI	'0'
		CALL	TYPE
		RET
;
;
;
		END	100H
;**********************************************************************
;
; TITLE: 88-MODEM DRIVER ROUTINE WITH DISK FILE TRANSFER
;
; VERSION: 1.00			LAST REVISION: 7/7/78
;
; AUTHOR: TIM PUGH
;	  9655-M HOMESTEAD COURT
;	  LAUREL, MD. 20810
;	  (301) 776-5253
;
;****************** SUMMARY OF CONTROL CHARACTERS *********************
;
;CONTROL CHARACTERS ARE INDICATED BY A "^" PRECEEDING THE CHARACTER.
;
; ^A	ASSIGN CONSOLE DEVICE
; ^B	TRANSMIT A "BREAK"
; ^D	DISCONTINUE CURRENT MODE
; ^FHE PROGRAM SIGN ON MESSAGE, THE SYSTEM WAITS FOR OPERATOR
;INPUT.  AT THIS POINT THE OPERATOR CAN INITIATE HANDSHAKING (AS DES-
;CRIBED UNDER "FILE TX MODE" BELOW) BY ENTERING AN "H".  ALTERNATIVELY,
;THE OPERATOR CAN SELECT FROM ONE OF 6 BAUD RATES BY ENTERING A "B".
;FINALLY, HE CAN DEFAULT TO 300 BAUD AND NO HAND-SHAKE BY ENTERING
;A "CR" (CARRIAGE RETURN) AS THE INITIAL ENTRY.
;
;NEXT, THE OPERATOR IS DIRECTED TO SELECT THE MODE OF OPERATION BY ENTERING
;EITHER AN "O" FOR ORIGINATE OR AN "A" FORZ			;NO ERROR
		PUSH	B
		LXI	D,CMP$ERR$MSG
		CALL	PRINT$MSG
		LXI	D,TRANS$DATA$MSG
		CALL	PRINT$MSG
		LDA	TRANS$DATA
		CALL	SHOWHEX
		LXI	D,RCV$DATA$MSG
		CALL	PRINT$MSG
		POP	B
		MOV	A,B
		CALL	SHOWHEX
		LXI	D,CRLF$MSG
		CALL	PRINT$MSG
		CALL	CHECK$CTRLS
		RET
;
;CHECK AND WAIT FOR CARRIER ROUTINE
;
CHECK$CD:	XRA	A
		STA	MSG$FLAG	;RESET FLAG
CHECK$CD1:	IN	STATUS$PORT	;CHECK FOR CARRIER
		ANI	CD
		CPI	CD
		JZ	CHECK$CD3	;CARRIER DETECTED
		LDA	MSG$FLAG
		ORA	A
		JNZ	CHECK$CD2
		L		STA	CHAR$MASK
		RET
MASK$6$CHAR:	MVI	A,3FH
		STA	CHAR$MASK
		RET
MASK$5$CHAR	MVI	A,1FH
		STA	CHAR$MASK
		RET
;
;PRINT HEX CHARACTERS ENCLOSED IN PARENS
;
SHOWHEX:	PUSH	PSW
		PUSH	PSW
		MVI	A,'('
		CALL	TYPE
		POP	PSW
		CALL	HEXO
		MVI	A,')'
		CALL	TYPE
		POP	PSW
		RET
;
;PRINT MESSAGE POINTED TO BY DE REGISTER PAIR
;
PRINT$MSG:	MVI	C,PRINT
		CALL	BDOS
		RET
;
;PRINT CHARACTER ON CONSOLE
;
TYPE:		PUSH PSW! PUSH B! PUSH D! PUSH H
		MOV	E,A
		MVI	C,WRCON
		CALL	BDOS
		POP H!	FILE NAME SPECIFIED FOR SUBSEQUENT RX/TX
; ^R	RECEIVE (RX) A DISK FILE FROM A REMOTE DEVICE
; ^T	TRANSMIT (TX) A DISK FILE TO A REMOTE DEVICE
; ^W	ASCII ETB -- MUST BE THE LAST CHARACTER OF A TX FILE
;
;******************* OPERATING INSTRUCTIONS **************************
;
;THIS PROGRAM IS DESIGNED TO OPERATE UNDER CP/M.  IF A FILE TRANSFER
;IS TO BE PERFORMED, THE FILE NAME SHOULD BE SPECIFIED WHEN THE PROGRAM
;IS CALLED, E.G.
;                   88-MODEM  <FILENAME>.<FILETYPE>
;
;FOLLOWING T ANSWER.  IF ANSWER MODE IS SELECTED,
;THE PROGRAM INITIALIZES THE SYSTEM ACCORDINGLY AND WAITS FOR RING DETECT.
;THE PHONE WILL BE ANSWERED ON THE FIRST RING AND GENERATES THE 2225 HZ
;CARRIER SIGNAL.  UPON DETECTION OF THE RESPONDING 1270 HZ TONE, A SIGN-ON
;MESSAGE IS TRANSMITTED TO THE REMOTE DEVICE AND A LOCAL MESSAGE DIRECTING
;THE COMMENCEMENT OF NORMAL TRANSMISSION IS DISPLAYED ON THE CONSOLE.
;IF THE REMOTE DEVICE IS A TERMINAL IT SHOUD BE IN HALF-DUPLEX MODE.
;OF THE ABOVE MENTIONED CONTROL CHARACTERS, ONLY ^T, ^R, AND ^D ARE
;SUPPORTED AT THE REMOTE DEVICE.  HOWEVER, ALL ARE SUPPORTED AT THE LOCAL
;CONSOLE.  IF THE LOCAL CONSOLE IS UNATTENDED, A FILE TRANSFER CAN BE
;INITIATED REMOTELY PROVIDED THE FILE NAME WAS PREVIOUSLY SPECIFIED.
;COMMUNICATIONS CAN BE TERMINATED REMOTELY SIMPLY BY HANGING UP THE PHONE.
;THIS CAUSES THE SYSTEM TO RETURN TO INITIALIZATION OF ANSWER MODE AND
;AWAIT THE NEXT REMOTE CALL.  ALTERNATIVELY, A "^D" ISSUED REMOTELY WILL
;TERMINATE COMMUNICATIONS AND TAKE TINDICATED BY THE ABSENCE OF A DASH BETWEEN DIGITS.
;
;BOTH AUTODIALING AND ROTARY DIALING ARE SUPPORTED.  AUTODIALING IS INIT-
;IATED BY ENTERING ONE OF 4 ALPHA CHARACTERS AS THE FIRST "DIGIT" DIALED.
;THE CHARACTERS SUPPORTED ARE "H,M,Z,W".  OTHER CHARACTERS MAY BE SELECTED
;PROVIDED THE 2 LSB'S OF THE ASCII CODE FOR THE SET SELECTED COVER THE
;RANGE OF 00,01,10,11.  THE PHONE NUMBERS ASSIGNED TO THESE CHARACTERS
;CAN BE FOUND IN THE LISTING JUST PRIOR THE THE "MESSAGES" SECTION.
;ROTARY DIALING IS^B".  IF
;MORE THAN ONE FILE IS TO BE TRANSFERRED, THE NEW FILE NAME CAN BE
;SPECIFIED BY ENTERING A "^F".  CONSOLE MESSAGES WILL PROMPT THE
;OPERATOR FOR APPROPRIATE ENTRIES.  IT IS POSSIBLE TO REASSIGN THE
;CONSOLE DEVICE BY ENTERING A "^A".  HERE TOO, CONSOLE MESSAGES WILL
;PROMPT THE OPERATOR FOR APPROPRIATE ENTRIES.  THIS FEATURE IS ONLY
;SUPPORTED ON SYSTEMS HAVING A TDL "ZAPPLE" MONITOR.
;
;IN ORDER TO INITIATE THE "FILE TX MODE" THE USER SHOULD ENTER A "^T".
;THE DATA IS DISPLAYED ON THE COON THE FILE.
;
;TO INITIATE THE "FILE RX MODE" THE USER ENTERS A "^R".  OPERATION IS
;SIMILAR TO FILE TX MODE DESCRIBED ABOVE.  SINCE CHARACTER TRANSMISSION
;IS SUPPORTED IN THIS MODE, THE USER SHOULD SET UP FOR FILE TRANSFER
;BY ISSUEING A COMMAND TO THE REMOTE DEVICE EXCEPT FOR THE CARRIAGE
;RETURN.  TYPE "^R" AND AFTER THE READY MESSAGE IS GIVEN, TYPE "CR".
;THE CR WILL GO TO THE REMOTE DEVICE AND INITIATE TRANSMISSION.
;THIS MODE DOES NOT TERMINATE AUTOMATICALLY.  A "^D" MUST BE TYPED
;IN ORDEREM STATUS (IN MODEM0)
;
TBE	EQU	001H	;TRANSMIT BUFFER EMPTY
RDA	EQU	002H	;RECEIVE DATA AVAILABLE
DBY	EQU	004H	;DIALER BUSY
PER	EQU	008H	;PARITY ERROR
OVR	EQU	010H	;DATA OVERRUN
BRK	EQU	020H	;BREAK RECEIVED
CTS	EQU	040H	;CLEAR TO SEND
DTD	EQU	080H	;DIAL TONE DETECT
;
;--UART MODES (OUT MODEM0)
;
ASCII1	EQU	024H	;7 DATA BITS, EVEN PARITY, 1 STOP BIT
ASCII2	EQU	004H	;7 DATA BITS, ODD PARITY, 1 STOP BIT
BIN1	EQU	02CH	;8 DATA BITS, EVEN PARITY, 1 STOP BIT
BIN2	EQU	00CH	;8 DATA BITS, ODD PARITY, 1HE SYSTEM OUT OF ANSWER MODE.  THIS
;MEANS THAT THE NEXT CALLER WON'T BE GREETED BY A PERHAPS UNEXPECTED
;2225HZ TONE.
;
;IF ORIGINATE MODE IS SELECTED, THE SYSTEM WAITS FOR DIAL TONE DETECTION.
;ONCE THE DIAL TONE HAS BEEN DETECTED - ANNOUNCED ON THE CONSOLE - DIALING
;CAN BEGIN.  CONVENTIONAL DIALING IS PERFORMED BY SIMPLY ENTERING THE
;NUMBER TO BE DIALED AT THE CONSOLE KEYBOARD.  AS EACH NUMBER IS DIALED
;A DASH IS DISPLAYED.  IT IS POSSIBLE TO EXCEED THE DIALING SPEED OF THE
;DEVICE.  THIS IS  SUPPORTED FOR THE CHARACTER "M" WHEREBY UP TO 4
;NUMBERS WILL BE DIALED IN SEQUENCE IF EACH PRECEEDING NUMBER IS FOUND
;BUSY.  THE SIZE OF THE ROTARY GROUP IS NOT RESTRICTED TO 4.  ANY NUMBER
;GREATER THAN OR EQUAL TO 2 CAN BE SUPPORTED.
;
;AFTER DIALING IS COMPLETED AND THE REMOTE CARRIER HAS BEEN DETECTED,
;THE SYSTEM IS PLACED IN THE "CHARACTER TX/RX MODE".  THIS IS THE MODE
;USED FOR KEYBOARD COMMUNICATIONS WITH THE REMOTE DEVICE.  WHILE IN
;THIS MODE, A BREAK MAY BE TRANSMITTED BY ENTERING A "NSOLE DEVICE AS IT IS TRANSMITTED.  UPON
;COMPLETION OF FILE TRANSMISSION, THE SYSTEM REVERTS TO THE CHARACTER
;MODE.  RETURN TO CHARACTER MODE PRIOR TO COMPLETION CAN BE FORCED BY
;ENTERING "^D".  "HAND-SHAKING" AS REQUIRED BY SOME UNIVAC 1100 SERIES
;COMPUTERS HAS BEEN INCLUDED.  TO ENABLE THIS, ENTER A "H" AS THE
;DIALING INITIATION CHARACTER (AS THE CONSOLE MESSAGE DIRECTS).
;THE END OF FILE IN THIS MODE IS "^W".  THUS, THE FILE TO BE TRANS-
;MITTED MUST HAVE A "^W" WRITTEN AS THE LAST CHARACTER  TO RETURN TO THE CHARACTER MODE.
;
;ESCAPE FROM THE CHARACTER MODE TO THE INITIAL DIALING SEQUENCE IS
;MADE BY ENTERING A "^D".
;
;RETURN TO CP/M IS EFFECTED BY ENTERING A "^D" WHILE IN THE "INITIAL
;DIALING SEQUENCE MODE".
;
;********************* MODEM CONTROL EQUATES **************************
;
;--I/O ADDRESSES
;
MODEM0	EQU	0C0H	;UART STATUS/CONTROL
MODEM1	EQU	0C1H	;DATA IN/OUT
MODEM2	EQU	0C2H	;FILTER & CONTROL WORD SELECT
MODEM3	EQU	0C3H	;(MODEM,DIALER,BAUD-RATE) CONTROL
;
;--UART/MOD STOP BIT
;
;--FILTER & CONTROL WORD SELECT CODES (OUT MODEM2)
;
MMSELO	EQU	001H	;MODEM MODE CONTROL SELECT - ORIGINATE
MMSELA	EQU	031H	;MODEM MODE CONTROL SELECT - ANSWER
DLSEL	EQU	002H	;DIALER DIGIT CONTROL SELECT 
BDSEL	EQU	004H	;BAUD/DIAL RATE CONTROL SELECT 
INTEN	EQU	008H	;INTERRUPT ENABLE 
;
;--MODEM MODES (OUT MODEM3)
;
MMORIG	EQU	0C0H	;ORIGINATE: OH,DTR
MMLOW	EQU	043H	;DTR,<=300,ESD,ELS
MMLREL	EQU	04BH	;DTR,<=300,BRK-REL,ESD,ELS
MMHIGH	EQU	063H	;DTR,>300,ESD,ELS
MMHREL	EQU	06BH	;DTR,>300,BRK-REL,ESD,ELS
MMTERM	EQU	00EH	;TERMINATE: BRK-REL,TX-BRK,ESD,ESS
MMBRK	EQU	004H	;TX-BREAK
;
;--DIAL & BAUD RATE CONSTANTS (OUT MODEM3)
;
DRATE1	EQU	068H	;DIAL RATE 10 PPS
DRATE2	EQU	034H	;DIAL RATE 20 PPS
BAUD10	EQU	08EH	;110 BAUD
BAUD15	EQU	068H	;150 BAUD
BAUD30	EQU	034H	;300 BAUD
BAUD45	EQU	022H	;450 BAUD
BAUD50	EQU	01FH	;500 BAUD
BAUD60	EQU	01AH	;600 BAUD
;
;********************** CP/M EQUATES ******************************
;
; CP/M FUNCTIONS ARE EXECUTED BY PASSING THE FUNCTION I/O CONFIGURATION BYTE
IOSET	EQU	8	;WRITE I/O CONFIGURATION BYTE
WRCBUF	EQU	9	;WRITE BUFFER CONTENTS TO CONSOLE
RDCBUF	EQU	10	;READ BUFFER CONTENTS FROM CONSOLE
CONST	EQU	11	;CONSOLE (DATA AVAILABLE) STATUS
;
UNLOAD	EQU	12	;UNLOAD DISK R/W HEAD
DSKRES	EQU	13	;DISK SYSTEM RESET
DSKSEL	EQU	14	;DISK SELECT (0,1,2,3)
OPEN	EQU	15	;OPEN DISK FILE (FCB ADDRESS)
CLOSE	EQU	16	;CLOSE DISK FILE  "	"
SRCH	EQU	17	;SEARCH FOR FILE  "     "
SRCHN	EQU	18	;SEARCH FOR NEXT FILE
DELETE	EQU	19	;DELETE DISK FILE (FTFCB
FCBDN	EQU	FCB+0	;DISK NUMBER (0,1,2,3)
FCBFN	EQU	FCB+1	;FILE NAME (8 BYTES)
FCBFT	EQU	FCB+9	;FILE TYPE (3 BYTES)
FCBEX	EQU	FCB+12	;EXTENT (0 TO 15)
FCBRC	EQU	FCB+15	;REC COUNT (0 TO 128) - SIZE OF CURRENT EXTENT
FCBNR	EQU	FCB+32	;NEXT RECORD POINTER (0 TO RC)
;
;****************** MISCELLANEOUS EQUATES **************************
;
;--ASCII CONTROL CODES
;
NHUL	EQU	000H	;(^@) NULL (TIME FILL)
SOH	EQU	001H	;(^A) START OF HEADING
STX	EQU	002H	;(^B) START TEXT
ETX	EQU	003H	;(^C) END TEXT
EO LINK EXCAPE - CHANGE DATA COM CNTRL
DC1	EQU	011H	;(^Q) DEVICE CONTROL 1
DC2	EQU	012H	;(^R)	"       "    2
DC3	EQU	013H	;(^S)	"	"    3
DC4	EQU	014H	;(^T) DEVICE CONTROL 4
NAK	EQU	015H	;(^U) NEGATIVE ACKNOWLEDGE - "NO"
SYN	EQU	016H	;(^V) SYNCHRONOUS IDLE - ENABLES RESYNC
ETB	EQU	017H	;(^W) END TRANSMISSION BLOCK
CAN	EQU	018H	;(^X) CANCEL PREVIOUS DATA
EM	EQU	019H	;(^Y) END MEDIUM
CLR	EQU	01AH	;(^Z) CLEAR SCREEN ON LS-TERMINAL (ASCII: SUB)
ESC	EQU	01BH	;(^[) ESCAPE - FOR CODE EXTENSION
FS	EQU	01CHAKE:	DS	1	;HAND-SHAKE FLAG
AUTOD:	DS	2	;AUTO-DIAL FLAG
ROTFLG:	DS	1	;ROTARY DIALING FLAG
ANSFLG:	DB	1	;ANSWER MODE FLAG
LFDFLG	DB	1	;LINE FEED FLAG
BLANKS:	DB	'                ' ;16 BLANKS
;
;--CONSOLE DATA BUFFER
CBUFF	DB	16	;BUFFER SIZE
CBCNT	DS	1	;COUNT OF CHARACTERS READ
CBTXT	DS	16	;CONSOLE DATA
;
BDTBL:	;BAUD RATE VALUE TABLE
	DB	BAUD10	;110 BAUD
	DB	BAUD15	;150 BAUD
	DB	BAUD30	;300 BAUD
	DB	BAUD45	;450 BAUD
	DB	BAUD50	;500 BAUD
	DB	BAUD60	;600 BAUD
BDVAL:	DS	1	;SELECTED BAUD RATE VNUMBER IN
; REGISTER C AND THE INFORMATION (ADDRESS OR DATA) IN REGISTERS
; D,E (REGISTER E IF SINGLE BYTE DATA).  THE RESULT (IF APPLICABLE)
; IS RETURNED IN REGISTER A.  IF DOUBLE BYTE RESULT, THE MSB IS IN
; REGISTER B.
;
;--FDOS FUNCTIONS
;
RESET	EQU	0	;SYSTEM RESET
RDCON	EQU	1	;READ CONSOLE CHARACTER
WRCON	EQU	2	;WRITE CONSOLE CHARACTER
RDRDR	EQU	3	;READ CHARACTER FROM READER DEVICE
WRPCH	EQU	4	;WRITE CHARACTER TO PUNCH DEVICE
WRLST	EQU	5	;WRITE CHARACTER TO LIST DEVICE
IOCHK	EQU	7	;READ CB ADDRESS)
RDDISK	EQU	20	;READ NEXT RECORD   "	"
WRDISK	EQU	21	;WRITE NEXT RECORD  "	"
CREATE	EQU	22	;CREATE DISK FILE   "	"
RENAME	EQU	23	;RENAME DISK FILE   "	"
LOGALL	EQU	24	;IDENTIFY ALL ON-LINE DISKS
LOGSEL	EQU	25	;IDENTIFY SELECTED DISK
SETDMA	EQU	26	;SET DMA ADDRESS VALUE
;
;--CP/M ADDRESS CONSTANTS
;
BOOT	EQU	0	;WARM START 
FDOS	EQU	0005H	;ENTRY TO FDOS
TFCB	EQU	005CH	;TRANSIENT FILE CONTROL BLOCK
TBUFF	EQU	0080H	;TRANSIENT BUFFER
;
;--FCB (FILE CONTROL BLOCK) CONSTANTS
;
FCB	EQU	T	EQU	004H	;(^D) END OF TRANSMISSION
ENQ	EQU	005H	;(^E) ENQUIRY - "WHO ARE YOU"
ACK	EQU	006H	;(^F) ACKNOWLEDGE - "YES"
BEL	EQU	007H	;(^G) BELL - HUMAN ATTENTION REQUIRED
BS	EQU	008H	;(^H) BACKSPACE
HT	EQU	009H	;(^I) HORIZONTAL TABULATION
LF	EQU	00AH	;(^J) LINE FEED
VT	EQU	00BH	;(^K) VERTICAL TABULATION
FF	EQU	00CH	;(^L) FORM FEED
CR	EQU	00DH	;(^M) CARRIAGE RETURN
SO	EQU	00EH	;(^N) SHIFT OUT - NONSTANDARD CODE FOLLOWS
SI	EQU	00FH	;(^O) SHIFT IN - RETURN TO STANDARD CODE
;
DLE	EQU	010H	;(^P) DATA	;(^\) FILE SEPARATOR
GS	EQU	01DH	;(^]) GROUP	"
RS	EQU	01EH	;(^^) RECORD	"
US	EQU	01FH	;(^_) UNIT	"
;
DEL	EQU	07FH	;DELETE (RUBOUTS)
;
;--ZAPPLE I/O CONFIGURATION
;
ZIOCHK	EQU	0F015H
ZIOSET	EQU	0F018H
;
;################## PROGRAM STATEMENTS ##########################
;
	ORG	100H
	JMP	START
	DS	40	;STACK AREA
STACK:	DS	2	;STACK POINTER
MMSEL:	DS	A	;MODEM MODE SELECT (ORIGINATE OR ANSWER)
MMODE:	DS	1	;MODEM MODE
CHCNT:	DS	1	;CHARACTER POSITION COUNT
BUFPTR:	DS	1	;DATA BUFFER POINTER
HSHALUE
;
;************************ PHONE NUMBERS ******************************
;
ADRTBL:	;PHONE NUMBER ADDRESS TABLE
	DW	PHONEH
	DW	PHONEM
	DW	PHONEZ
	DW	PHONEW
;
PHONEM:	;UNIV. OF MD.
	DB	'4544821$'
	DB	'4545201$'
	DB	'4545401$'
	DB	'4545405$'
	DB	GS	;GROUP SEPERATOR
PHONEH:	DB	'7765253$';HOME PHONE
PHONEZ:	DB	'8441212$';TIME SERVICE
PHONEW:	DB	'9361212$';WEATHER SERVICE
;
;*********************** MESSAGES **********************************
;
MSG1	DB	CLR,'              88-MODEM DRIVER ROUTINE'
	DB	CR,LF,LF,LF
	DB	'TO INITIALIZE THE SYSTEM, TYPE ONE OF THE FOLLOWING '
	DB	'CHARACTERS:',CR,LF,LF
	DB	'H (HAND-SHAKE INIT.), B (BAUD-RATE SEL.), '
	DB	'CR (DEFAULT TO 300 BAUD)',CR,LF,LF,LF,BEL,'$'
MSG1A	DB	'SPECIFY THE MODE BY TYPING THE APPROPRIATE CHARACTER '
	DB	CR,LF,LF,'A --> ANSWER-MODE    O --> ORIGINATE-MODE'
	DB	CR,LF,LF,'$'
MSG1B	DB	CLR,'         ORIGINATE MODE -- WAITING FOR DIALTONE'
	DB	CR,LF,LF,'$'
MSG2	DB	BEL,'DIAL TONE RECEIVED:  COMMENSE DIALING - '
	DB	'TERMINATEDRANSMISSION COMPLETED',CR,LF,LF,LF,'$'
MSG10	DB	CR,LF,LF,LF,'READY TO RECEIVE FILE',CR,LF,LF,LF,'$'
MSG11	DB	BEL,'UNABLE TO CLOSE FILE',CR,LF,'$'
MSG12	DB	BEL,'ERROR IN EXTENDING FILE',CR,LF,'$'
MSG13	DB	BEL,'DISK IS FULL',CR,LF,'$'
MSG14	DB	BEL,'DISK DIRECTORY IS FULL',CR,LF,'$'
MSG15	DB	'  HAND-SHAKE FLAG IS SET',CR,LF,LF,'$'
MSG16	DB	'  BAUD-RATE SELECTION',CR,LF,LF
	DB	'SELECT A BAUD RATE BY ENTERING APPROPRIATE DIGIT '
	DB	'FROM THE FOLLOWING LIST:',CR,LF
	DB	'1 (110 BAUD), 2 (150 BAUD), 3 (3E FROM THE '
	DB	'FOLLOWING LIST:',CR,LF
	DB	'0 (TTY), 1 (CRT), 2 (BATCH), 3 (MODEM)',CR,LF,LF,'$'
;
;************************* SUBROUTINES *******************************
;
;++++++++++++++++++++++ COMMON SUBROUTINES ++++++++++++++++++++++++++
;
EXIT:	;RETURN TO CP/M
	MVI	C,WRCBUF
	LXI	D,MSG5
	CALL	FDOS	;TYPE EXIT MESSAGE
	XRA	A	;CLEAR A & CARRY
	LHLD	STACK
	SPHL		;RESTORE CP/M STACK POINTER
	RET
;
CSTAT:	;READ CONSOLE STATUS
	MVI	C,CONST
	CALL	FDOS
	ORA	A
	RET
;
CRD$ST:	;CONSOLE READ,' '
	CALL	TCHAR
	MVI	A,BS
	CALL	TCHAR
	MVI	A,BEL
	CALL	TCHAR
	JMP	DIAL
;
CRLF:	MVI	A,CR
	CALL	TCHAR
	MVI	A,LF
	CALL	TCHAR
	RET
;
THEX:	;TYPE THE PAIR OF HEX CHARACTERS IN REG A
	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	TNIB
	POP	PSW
TNIB:	ANI	0FH
	CPI	10
	JC	ISNUM
	ADI	7
ISNUM:	ADI	'0'
	JMP	TCHAR
;
DIALIT:	;DIAL THE DIGIT IN REG A
	ANI	00FH
	OUT	MODEM3	;SEND DIGIT TO DIALER
DBUSY:	CALL	CSTAT	;GET CONSOLE STATUS
	JZ	D2	;DATA AVAILABLE?
	CALL	CRD$ST	;  YES, TEST FOR "^D"
D2:	CALLNES +++++++++++++++++++++++
;
BREAK:	;TRANSMIT A BREAK TO REMOTE DEVICE
	LDA	MMSEL
	OUT	MODEM2
	LDA	MMODE
	ORA	MMBRK
	OUT	MODEM3	;TRANSMIT A BREAK
	MVI	A,5
	CALL	DELAY	;INSERT 0.5 SEC DELAY
	LDA	MMODE
	ANI	0F3H
	OUT	MODEM3	;RESET BREAK & BREAK.RLS BITS
	JMP	TRCHAR
;
DELAY:	;INSERT DELAY IN 100MS INCREMENTS (A.REG = INCREMENT.VAL)
	MVI	B,100
DEL1:	MVI	C,182	;1MS = 182*(5.5 MICRO-SEC)
DEL2:	DCR	C
	JNZ	DEL2
	DCR	B
	JNZ	DEL1
	DCR	A
	JNZ	DELAY
	RET
;
MOVE:	;SOURCE.ADDR=H,L   DEST.ADDR=D BY A CR',CR,LF,LF,'$'
MSG2A	DB	LF,'WAITING FOR CARRIER DETECT',CR,LF,'$'
MSG3	DB	LF,LF,'CONNECTION HAS BEEN BROKEN',CR,LF,'$'
MSG4	DB	CLR,BEL,'CONNECTION HAS BEEN ESTABLISHED, BEGIN '
	DB	'NORMAL TRANSMISSION',CR,LF,LF,LF,'$'
MSG5	DB	CLR,BEL,'		RETURN TO CP/M EXECUTION'
	DB	CR,LF,LF,LF,'$'
MSG6	DB	BEL,'UNABLE TO OPEN FILE FOR TRANSMISSION',CR,LF,'$'
MSG7	DB	BEL,'DISK READ ERROR',CR,LF,'$'
MSG8	DB	BEL,'UNABLE TO CREATE FILE DUE TO INSUFFICIENT'
	DB	' DIRECTORY SPACE',CR,LF,'$'
MSG9	DB	BEL,'FILE T00 BAUD)',CR,LF
	DB	'4 (450 BAUD), 5 (500 BAUD), 6 (600 BAUD)',CR,LF,LF,'$'
MSG17	DB	CLR,'                       ANSWER MODE',CR,LF,LF,'$'
MSG18	DB	'WAITING FOR RING-INDICATOR AND CARRIER-DETECT'
	DB	CR,LF,LF,'$'
MSG19	DB	CR,LF,LF,'                    HELLO THERE',CR,LF,LF
	DB	'          PLEASE BEGIN YOUR TRANSMISSION',CR,LF,LF,'$'
MSG20	DB	CR,LF,LF,'ENTER FILE NAME IN 2 PARTS AS FOLLOWS:',CR,LF
	DB	'<FILENAME> CR',CR,LF
	DB	'<FILETYPE> CR',CR,LF,LF,'>$'
MSG21	DB	CR,LF,LF,'SELECT THE CONSOLE DEVIC - GO TO "STOP" IF "^D"
	MVI	C,RDCON
	CALL	FDOS
	CPI	EOT
	RNZ		;"^D" ?
	POP	PSW	;  YES, CORRECT STACK FOR NON-RETURN
	XRA	A
	STA	ROTFLG	;RESET ROTARY FLAG
	JMP	STOP
;
MSTAT:	;READ MODEM STATUS AND DISPLAY ON PORT 0FFH
	IN	MODEM0
	CMA
	OUT	0FFH
	CMA
	RET
;
MTBE:	;MODEM TX BUFFER EMPTY TEST
	CALL	MSTAT
	ANI	TBE
	JZ	MTBE
	RET
;
TCHAR:	;TYPE A CHARACTER ON CONSOLE DEVICE
	MVI	C,WRCON
	MOV	E,A
	CALL	FDOS
	RET
;
DCHAR:	;DELETE A CHARACTER ON THE CONSOLE
	MVI	A,BS
	CALL	TCHAR
	MVI	A	MSTAT
	ANI	DBY
	JNZ	DBUSY	;BUSY?
	MVI	A,'-'	;  NO
	CALL	TCHAR	;PROMPT FOR NEXT DIGIT
	RET
;
UART:	;SET UP UART CONFIGURATION
	MVI	A,ASCII1
	OUT	MODEM0	;SELECT THE NO. OF DATA BITS & PARITY TYPE
	MVI	A,BDSEL
	OUT	MODEM2
	LDA	BDVAL
	OUT	MODEM3	;SET THE BAUD-RATE VALUE
	RET
;
MDM:	;SET UP MODEM CONFIGURATION
	LDA	MMSEL
	OUT	MODEM2
	LDA	MMODE
	OUT	MODEM3
	NOP!	NOP!	NOP
	NOP!	NOP!	NOP
	ANI	0F7H	;RESET THE "BREAK-RLS." BIT
	OUT	MODEM3
	RET
;
;++++++++++++++++++ CHARACTER TX/RX SUBROUTI,E   BYTE.COUNT=A
	ORA	A
	RZ		;BYTE.COUNT=0 ?
	MOV	B,A	;  NO
MLOOP:	MOV	A,M
	XCHG
	MOV	M,A
	XCHG
	INX	D
	INX	H
	DCR	B
	JNZ	MLOOP
	RET
;
FILE:	;SET UP FCB (FILE.CONTROL.BLOCK) AS SPECIFIED BY OPERATOR
	MVI	A,11
	LXI	H,BLANKS
	LXI	D,FCBFN
	CALL	MOVE	;BLANK FILL FCB <FILENAME> <FILETYPE>
	MVI	C,WRCBUF
	LXI	D,MSG20
	CALL	FDOS	;REQUEST <FILENAME> & <FILETYPE> FROM OPERATOR
	MVI	C,RDCBUF
	LXI	D,CBUFF
	CALL	FDOS	;GET <FILENAME> FROM CONSOLE
	LDA	CBCNT
	LXI	H,CBTXT
	LXI	D,FCBFN
	CALL	MOVE	;WRITE FCB <FILENAME>
	CALL	CRLF
	MVI	A,'>'
	CALL	TCHAR	;PROMPT OPERATOR FOR <FILETYPE>
	MVI	C,RDCBUF
	LXI	D,CBUFF
	CALL	FDOS	;GET <FILETYPE> FROM CONSOLE
	LDA	CBCNT
	LXI	H,CBTXT
	LXI	D,FCBFT
	CALL	MOVE	;WRITE FCB <FILETYPE>
	CALL	CRLF
	JMP	TRCHAR
;
ASSIGN:	;MAKE CONSOLE ASSIGNMENT (TEMPORARILY LIMITED TO TTY & CRT)
	MVI	C,WRCBUF
	LXI	D,MSG21
	CALL	FDOS	;PROMPT FOR CONSOLE SELECTION
	MVI	C,RDCON
	CALL	FDOS	;READ SELECTION
	PUSH	PSW
	CALL	CRLF
	POP	PSW
	ANI	01H	;TEMPORARILY ALLOWS FOCTER MODE
OPNOK:	XRA	A
	STA	FCBNR	;NEXT-RECORD = 0
	RET
;
DISKR:	;READ A DISK SECTOR (RECORD)
	MVI	C,RDDISK
	LXI	D,FCB
	CALL	FDOS
	CPI	0
	RZ		;NORMAL READ?
	CPI	1	;  NO
	JNZ	DRERR	;END OF FILE?
	MVI	C,WRCBUF ;  YES
	LXI	D,MSG9
	CALL	FDOS	;TYPE "END FILE" MSG
	JMP 	DRERRX
DRERR:	MVI	C,WRCBUF
	LXI	D,MSG7
	CALL	FDOS	;TYPE "READ ERR" MSG
DRERRX:	POP	PSW	;CORRECT STACK FOR NON-RETURN
	JMP	TRCHAR	;REVERT TO CHARACTER MODE
;
SHOW:	;SHOW CHAR TRANSMITTED OR RECEIVED
	CPI	LF
	JZ	TCHAR
	CPI	LXI	D,MSG8
	CALL	FDOS	;TYPE ERROR MSG.
	POP	PSW	;CORRECT STACK FOR NON-RETURN
	JMP	TRCHAR	;REVERT TO CHARACTER MODE
MAKEOK:	XRA	A
	STA	FCBNR	;NEXT-RECORD = 0
	RET
;
ST$BUF:	;STORE CONTENTS OF REG A IN DISK BUFFER
	PUSH	PSW
	LDA	BUFPTR
	MOV	E,A	;D,E = DATA BYTE ADDRESS
	MVI	D,0
	INR	A
	STA	BUFPTR	;INCREMENTED BUFFER POINTER
;--STORE A BYTE A ADDRESS: TBUFF+(D,E)
	LXI	H,TBUFF
	DAD	D
	POP	PSW
	MOV	M,A
;--TEST FOR BUFFER FULL
	LDA	BUFPTR
	CPI	080H
	RNZ		;IS BUFFER FULL?
	POP	PSW	;YES, CONON-RETURN
	JMP	TRCHAR	;REVERT TO CHARACTER MODE
;
CLOSEF:	;CLOSE DISK FILE (WRITING COMPLETED)
	MVI	C,CLOSE
	LXI	D,FCB
	CALL	FDOS
	CPI	255
	RNZ		;SUCESSFUL CLOSE?
	MVI	C,WRCBUF ;  NO
	LXI	D,MSG11
	CALL	FDOS	;TYPE ERROR MESSAGE
	RET
;
;*********************** MAIN PROGRAM ***************************
;
START:	;INITIALIZE OUR STACK
	LXI	H,0
	DAD	SP	;HL=STACK FROM CP/M
	SHLD	STACK	;SAVE CP/M STACK POINTER
	LXI	SP,STACK ;LOAD OUR STACK PIONTER
RESTRT:	XRA	A
	STA	HSHAKE	;RESET HAND-SHAKE FL,0FFH	;  YES
	STA	HSHAKE	;SET THE HAND-SHAKE FLAG TO ON
	MVI	C,WRCBUF
	LXI	D,MSG15
	CALL	FDOS	;TYPE "HAND-SHAKE" MSG.
	JMP	D0
;--BAUD RATE MODIFICATION
BAUD:	CPI	'B'
	JNZ	D0	;BAUD-RATE CHANGE REQUEST?
	MVI	C,WRCBUF;  YES
	LXI	D,MSG16
	CALL	FDOS	;PROMPT FOR BAUD SELECTION
BA1:	CALL	CSTAT
	JZ	BA1	;HAS OPERATOR RESPONDED?
	MVI	C,RDCON	;  YES, GET THE CHARACTER
	CALL	FDOS
	PUSH	PSW
	CPI	'4'
	JC	BA2	;BAUD-RATE > 300 ?
	MVI	A,MMHREL	;  YES, CHANGE MODEM MODE ACCORDINGLY
	STA	MMODE
BA2:	CALL	CR TTY & CRT ONLY
	PUSH	PSW	;SAVE THE SELECTION
	CALL	ZIOCHK
	ANI	0FCH	;MASK OUT THE 2 LSBS'
	MOV	B,A
	POP	PSW	;GET THE SELECTION
	ORA	B
	MOV	C,A
	CALL	ZIOSET
	JMP	TRCHAR
;
;+++++++++++++++++++++ FILE TX SUBROUTINES +++++++++++++++++++++++++
;
OPENF:	;OPEN DISK FILE FOR READING
	MVI	C,OPEN
	LXI	D,FCB
	CALL	FDOS
	CPI	255
	JNZ	OPNOK	;IS FILE IN DIRECTORY?
	MVI	C,WRCBUF ;  NO
	LXI	D,MSG6
	CALL	FDOS	;TYPE ERROR MESSAGE
	POP	PSW	;CORRECT STACK PTR FOR NON-RETURN
	JMP	TRCHAR	;REVERT TO CHARACR
	JZ	TCHAR
	CPI	' '
	JC	SHEX	;ASCII CONTROL CHARACTER?
	CPI	07FH	;  NO
	JC	TCHAR	;ASCII PRINTABLE CHARACTER?
SHEX:	;SHOW HEX VALUE FOR NON-PRINTABLE CHARACTER
	PUSH	PSW	;  NO
	MVI	A,'('
	CALL	TCHAR
	POP	PSW
	CALL	THEX
	MVI	A,')'
	CALL	TCHAR
	RET
;
;++++++++++++++++++++++ FILE RX SUBROUTINES +++++++++++++++++++++++++
;
MAKEF:	;CREATE A FILE FOR SUBSEQUENT WRITING
	MVI	C,CREATE
	LXI	D,FCB
	CALL	FDOS
	CPI	255
	JNZ	MAKEOK	;IS SUFFICIENT DIRECTORY SPACE AVAILABLE?
	MVI	C,WRCBUF ;  NO
	RRECT STACK FOR NON-RETURN
	JMP	RFULL
;
DISKW:	;WRITE A DISK SECTOR (RECORD)
	MVI	C,WRDISK
	LXI	D,FCB
	CALL	FDOS
	CPI	0
	RZ		;NORMAL WRITE?
	CPI	1	;  NO
	JNZ	DR1	;ERROR IN EXTENDING FILE?
	MVI	C,WRCBUF ;  YES
	LXI	D,MSG12
	CALL	FDOS	;TYPE "EXTEND ERROR" MSG
	JMP	DWERRX
DR1:	CPI	2
	JNZ	DR2	;IS DISK FULL?
	MVI	C,WRCBUF ;  YES
	LXI	D,MSG13
	CALL	FDOS	;TYPE "DISK FULL" MSG
	JMP	DWERRX
DR2:	MVI	C,WRCBUF
	LXI	D,MSG14
	CALL	FDOS	;TYPE "DIRECTORY FULL" MSG
DWERRX:	POP	PSW	;CORRECT STACK FOR AG
	STA	AUTOD	;RESET AUTO-DIAL FLAG
	STA	ROTFLG	;RESET ROTARY DIALING FLAG
	STA	ANSFLG	;RESET ANSWER MODE FLAG
	STA	LFDFLG	;RESET LINE FEED FLAG
	MVI	A,BAUD30
	STA	BDVAL	;DEFAULT BAUD RATE VALUE = 300
	MVI	A,MMLREL
	STA	MMODE	;DEFAULT MODEM MODE = MMLREL
	MVI	C,WRCBUF
	LXI	D,MSG1
	CALL	FDOS	;TYPE SIGN-ON MESSAGE
;--WAIT FOR CONSOLE INPUT
	MVI	C,RDCON
	CALL	FDOS	;READ CONSOLE DATA
	CPI	EOT
	JZ	EXIT	;"^D"?
	ANI	05FH	;  NO, SHIFT LC ALPLH TO UC
	CPI	'H'
	JNZ	BAUD	;HAND-SHAKE REQUEST?
	MVI	ARLF
	POP	PSW
	ANI	07H
	DCR	A
	MOV	E,A
	MVI	D,00H	;D,E = TBL INDEX
	LXI	H,BDTBL
	DAD	D
	MOV	A,M
	STA	BDVAL	;NEW TRANSMISSION BAUD-RATE VALUE
;--DETERMINE MODEM MODE (ORIGINATE/ANSWER)
D0:	MVI	C,WRCBUF
	LXI	D,MSG1A
	CALL	FDOS	;TYPE "MODE" MESSAGE
	MVI	C,RDCON
	CALL	FDOS	;READ CONSOLE DATA
	CPI	EOT
	JZ	RESTRT	;"^D"?
	ANI	05FH	;  NO, SHIFT LC ALPHA TO UC
	CPI	'O'
	JZ	ORIG	;ORIGINATE-MODE SELECTED?
	CPI	'A'	;  NO
	JNZ	D0	;ANSWER-MODE SELEDTED?
	MVI	A,0FFH	;  YES
	STA	ANSFLG
	JMP	ANSWER
;
;++++++++++++++++++++++++ ORIGINATE MODE ++++++++++++++++++++++++++++++
;
;--SET UP DIALER BAUD RATE
ORIG:	MVI	A,BDSEL	;  NO
	OUT	MODEM2
	MVI	A,DRATE2
	OUT	MODEM3
;--GO OFF-HOOK & SET BREAK RELEASE
	MVI	A,MMSELO
	OUT	MODEM2
	MVI	A,MMORIG
	OUT	MODEM3
	MVI	C,WRCBUF
	LXI	D,MSG1B
	CALL	FDOS	;TYPE "WAITING" MESSAGE
;--WAIT FOR DIAL TONE OR "^D"
DTONE:	CALL	CSTAT	;GET CONSOLE STATUS
	JZ	D1	;CONSOLE DATA AVAILABLE?
	CALL	CRD$ST	;  YES, TEST FOR "^D"
D1:	CALL	MSTAT	;GET MODEM STATUS
	ANI	DTD
 AUTO-DIALING
DIGIT:	CALL	DIALIT	;DIAL A DIGIT
	JMP	DIAL
;--AUTOMATIC DIALING ROUTINE
AUTODL:	LXI	H,0FFFFH
	SHLD	AUTOD	;SET AUTO-DIAL FLAG
	PUSH	PSW	;SAVE CHARACTER FOR ROTARY DIALING TEST
	ANI	03H
	RLC
	MOV	E,A
	MVI	D,0
	LXI	H,ADRTBL
	DAD	D	;H,L=INDIRECT ADDRESS OF PHONE NUMBER
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG		;H,L=ADDRESS OF PHONE NUMBER
AU1:	MOV	A,M
	CPI	GS
	JZ	ROTEND	;END OF ROTARY GROUP?
	CPI	'$'	;  NO
	JZ	UARTO-1	;DIALING COMPLETE?
	PUSH	H	;  NO
	PUSH	PSW
	CALL	TCHAR	;TYPE DIGIT STATUS
	JZ	C1	;CONSOLE DATA AVAILABLE?
	CALL	CRD$ST	;  YES, TEST FOR "^D"
C1:	CALL	MSTAT	
	ANI	CTS
	JZ	CTS1	;CLEAR TO SEND?
	JMP	MDMO	;  YES, SET UP MODEM CONFIGURATION
;--ROTARY DIALING SEQUENCE
ROTARY:	LDA	AUTOD
	ORA	A
	JZ	STOP	;AUTO-DIAL MODE?
	POP	H	;  YES, GET PH# ADDRESS
	INX	H
	POP	PSW	;GET CHARACTER WHICH INITIATED AUTO-DIAL
	CPI	'M'
	JNZ	STOP	;ROTARY CHARACTER?
	PUSH	PSW	;  YES, SAVE FOR NEXT ITERATION
	MVI	A,0FFH
	STA	ROTFLG	;SET ROTARY DIALING FLAG
	SHLD	ADRTBL+2;STORE INCREME++++++++++++++
;
ANSWER:	MVI	C,WRCBUF
	LXI	D,MSG17
	CALL	FDOS	;TYPE "ANSWER MODE" MSG
	MVI	A,0FFH
	STA	LFDFLG	;SET LINE.FEED FLAG
	CALL	UART	;SET UP UART CONFIGURATION
	MVI	A,MMSELA
	STA	MMSEL
	CALL	MDM	;SET UP MODEM CONFIGURATION
	MVI	C,WRCBUF
	LXI	D,MSG18
	CALL	FDOS	;TYPE "WAITING" MESSAGE
;--WAIT FOR CTS (RING INDICATOR & CARRIER DETECT)
AN0:	CALL	CSTAT
	JZ	AN1	;CONSOLE DATA AVAILABLE?
	MVI	C,RDCON	;  YES
	CALL	FDOS	;READ CONSOLE DATA
	CPI	EOT
	JNZ	AN1	;"^D"?
	XRA	A	;  YES
	STA	ANSFINE +++++++++++++++++++++++++++
;
;--TEST FOR LOSS OF "CTS"
TRCHAR:	IN	MODEM0
	ANI	CTS
	JZ	STOP	;LOSS OF CTS?
;--TEST FOR "LINE CHARACTER" AVAILABILITY
	IN	MODEM0	;  NO
	ANI	RDA
	JZ	NOCHAR	;RECEIVE DATA AVAILABLE?
	IN	MODEM1	;  YES, READ DATA
	PUSH	PSW
	CALL	TCHAR	;TYPE RECEIVED CHARACTER
	LDA	LFDFLG
	ORA	A
	JZ	TR1	;LINE FEED FLAG SET?
	POP	PSW	;  YES
	CPI	CR
	JNZ	TR1+1	;CHARRIAGE RETURN?
TRLF:	MVI	A,LF	;  YES, SEND A LINE FEED
	CALL	TCHAR
TR0:	IN	MODEM0
	ANI	TBE
	JZ	TR0	;TX BUFFER EM
	JNZ	DTONE	;DIAL TONE PRESENT?
	MVI	C,WRCBUF ;  YES, INFORM OPERATOR
	LXI	D,MSG2
	CALL	FDOS
;--BEGIN DIALING SEQUENCE
	MVI	A,DLSEL
	OUT	MODEM2
	LDA	ROTFLG
	ORA	A
	JZ	DIAL	;ROTARY DIALING IN PROGRESS?
	POP	PSW	;  YES, GET ROTARY CHARACTER
	JMP	AUTODL
DIAL:	CALL	CRD$ST	;CONSOLE READ
	CPI	CR
	JZ	UARTO	;CARRIAGE RETURN?
;--SCREEN OUT NON-DECIMAL "DIALED" CHARACTERS
	CPI	'0'	;  NO
	JC	DCHAR	;CONTROL CHAR. OR SYMBOL?
	CPI	':'	;  NO
	JC	DIGIT	;NON-DECIMAL CHARACTER?
	JMP	AUTODL	;  YES, PERFORM TO BE DIALED
	POP	PSW
	CALL	DIALIT
	POP	H
	INX	H
	JMP	AU1
;--SET UP UART CONFIGURATION
	PUSH	H	;SAVE ADDRESS POINTER FOR ROTARY DIALING
UARTO:	MVI	C,WRCON
	MVI	E,LF
	CALL	FDOS	;SEND "LINE-FEED" TO CONSOLE
	CALL	UART	;ESTABLISH UART CONFIGURATION
;--WAIT FOR CTS (CARRIER DETECT)
	MVI	C,WRCBUF
	LXI	D,MSG2A
	CALL	FDOS	;TYPE "WAITING" MESSAGE
	LXI	B,0FFFFH ;INITIALIZE TIME-OUT
	PUSH	B
CTS1:	POP	B
	DCX	B
	MOV	A,B
	ORA	C
	JZ	ROTARY	;TIME-OUT EXPIRED?
	PUSH	B	;  NO
	CALL	CSTAT	;GET CONSOLENTED POINTER
	JMP	STOP	;TRY THE NEXT PHONE NUMBER
ROTEND:	LXI	H,PHONEM
	SHLD	ADRTBL+2;RESTORE ORIGINAL POINTER
	XRA	A
	STA	ROTFLG	;RESET ROTARY DIALING FLAG
	POP	PSW	;RESTORE STACK TO NORMAL
	JMP	STOP
;--SET UP MODEM CONFIGURATION
MDMO:	MVI	A,MMSELO
	STA	MMSEL
	CALL	MDM
;--PROMPT OPERATOR TO BEGIN COMMUNICATIONS
	MVI	C,WRCBUF 
	LXI	D,MSG4
	CALL	FDOS	;TYPE START TX MESSAGE
	XRA	A
	STA	ROTFLG	;RESET ROTARY DIALING FLAG
	JMP	TRCHAR
;
;++++++++++++++++++++++++ ANSWER MODE +++++++++++++++++++LG	;RESET ANSWER MODE FLAG
	JMP	STOP
AN1:	IN	MODEM0	;  NO
	ANI	CTS
	JZ	AN0	;HAS CONNECTION BEEN ESTABLISHED?
	MVI	C,WRCBUF;  YES, INFORM CONSOLE OPERATOR
	LXI	D,MSG4
	CALL	FDOS
;--TRANSMIT SIGN-ON MESSAGE TO REMOTE DEVICE
	LXI	H,MSG19	;H,L = MESSAGE ADDRESS
SIGNON:	CALL	MSTAT
	ANI	TBE
	JZ	SIGNON	;TX BUFFER EMPTY?
	MOV	A,M	;  YES, GET NEXT CHARACTER
	CPI	'$'
	JZ	TRCHAR	;MESSAGE COMPLETE?
	OUT	MODEM1	;  NO, TRANSMIT THE CHARACTER
	INX	H
	JMP	SIGNON
;
;+++++++++++++++++ CHARACTER TX/RX ROUTPTY?
	MVI	A,LF	;  YES
	OUT	MODEM1	;TRANSMIT LINE FEED TO LINE
	JMP	NOCHAR
TR1:	POP	PSW
	CPI	DC4
	JZ	TXFILE	;"^T"?
	CPI	DC2	;  NO
	JZ	RXFILE	;"^R"?
	CPI	EOT	;  NO
	JNZ	NOCHAR	;"^D"?
	XRA	A	;  YES
	STA	ANSFLG	;RESET THE ANSER.MODE FLAG
	JMP	STOP	;TERMINATE ANSWER MODE
;--TEST FOR "LOCAL CHARACTER" AVAILABILITY
NOCHAR:	CALL	CSTAT	;GET CONSOLE STATUS
	JZ	TRCHAR	;CONSOLE DATA AVAILABLE?
	CALL	CRD$ST	;  YES, READ DATA & TEST FOR "^D"
	CPI	DC4	
	JZ	TXFILE	;"^T"?
	CPI	DC2	;  NO
	JZ	RXFILE	;"^R"?
	CPI	SOH
	JZ	ASSIGN	;IF "^A" THEN CHANGE CONSOLE ASSIGNMENT
	CPI	STX
	JZ	BREAK	;IF "^B" THEN TRANSMIT A "BREAK"
	CPI	ACK
	JZ	FILE	;IF "^F" THEN SET UP NEW FILE NAME
	OUT	MODEM1	;TRANSMIT DATA TO "LINE"
	CPI	CR
	JNZ	TRCHAR	;CARRIAGE RETURN?
	LDA	LFDFLG	;  YES
	ORA	A
	JNZ	TRLF	;LINE FEED FLAG SET?
	JMP	TRCHAR	;  NO
;
;+++++++++++++++++++++ FILE TX ROUTINE ++++++++++++++++++++++++++
;
TXFILE:	CALL	OPENF	;OPEN DISK FILE FOR READING
	MVI	A,80H
	STA	BUFPTR	;INITIALIZE THE BUFFER POINTER
	XRA	BUFPTR	;INCREMENTED BUFFER POINTER
;--READ A BYTE AT ADDRESS: TBUFF+(D,E)
	LXI	H,TBUFF
	DAD	D
	MOV 	A,M
	PUSH	PSW
;--WAIT FOR UART TX BUFFER EMPTY
TF2:	CALL	MSTAT
	ANI	TBE
	JZ	TF2	;UART TX BUFFER EMPTY?
	POP	PSW	;  YES
	CPI	ETB
	JZ	TFEND	;(^W) END TRANSMISSION BLOCK?
	CPI	HT	;  NO
	JNZ	TF3	;HORIZONTAL TAB?
;--TRANSLATE HT INTO APPROPRIATE NUMBER OF SPACES
	LDA	CHCNT	;  YES
SPACES:	MOV	B,A
	CALL	MTBE	;INSURE MODEM TX BUFFER EMPTY
	MVI	A,' '
	OUT	MODEM1
	PUSH	B
	CALL	TCHAR
	POP	B
	INR,5	;  NO, GENERATE 0.5 SEC DELAY
	CALL	DELAY
	JMP	TXBYTE	;BEGIN NEXT LINE
;--PERFORM END OF TEXT LINE "HANDSHAKING"
TF4:	CALL	CSTAT
	JZ	TF4A	;CONSOLE CHAR RECEIVED?
	JMP	TFEND	;  YES, TERMINATE FILE TX
TF4A:	CALL	MSTAT	;
	ANI	RDA
	JZ	TF4	;RECEIVE DATA AVAILABLE?
	IN	MODEM1	;  YES
	CPI	LF
	JNZ	TF4	;"LINE FEED" RECEIVED FROM LINE?
	MVI	A,1	;  YES, INSERT 100MS DELAY
	CALL	DELAY
	JMP	TXBYTE	;BEGIN NEXT LINE
TFEND:	CALL	CRLF
	JMP	TRCHAR	;REVERT TO CHARACTER MODE
;
;+++++++++++++++++++++ FILE LL	FDOS
	CPI	EOT
	JZ	RFEND	;"^D" ?
	OUT	MODEM1	;  NO, TRANSMIT CHARACTER
	JMP	RCV
;--READ CHARACTER FROM EXTERNAL DEVICE
GOTONE:	IN	MODEM1
	CPI	ETB
	JZ	RF0	;"^W"?
	CPI	EOT	;  NO
	JZ	RFEND	;"^D"?
	CPI	CR	;  NO
	JZ	RFCR	;CARRIAGE RETURN?
	CPI	DEL	;  NO
	JZ	RCV	;DO NOT RECORD RUBOUTS
	CPI	' '
	JC	RCV	;ASCII CONTROL CHARACTER?
	PUSH	PSW	;  NO
	CALL	TCHAR	;DISPLAY CHARACTER ON CONSOLE
	POP	PSW
RF0:	CALL	ST$BUF	;STORE CHARACTER IN DISK BUFFER
	JMP	RCV
;--CARRIAGE RETURN PROCESSING
RFCR:	PUSI	D,0
	LXI	H,TBUFF
	DAD	D
	MVI	A,01AH	;"^Z" INDICATES END OF FILE
	MOV	M,A
	CALL	DISKW	;WRITE THE LAST RECORD
	CALL	CLOSEF
	JMP	TRCHAR	;REVERT TO CHARACTER MODE
;
;+++++++++++++++++ TERMINATE COMMUNICATIONS +++++++++++++++++++++++
;
;--SEND A BREAK, HANG UP THE PHONE, INFORM THE OPERATOR
STOP:	MVI	A,MMSELO
	OUT	MODEM2
	MVI	A,MMTERM
	OUT	MODEM3
	MVI	C,WRCBUF
	LXI	D,MSG3
	CALL	FDOS	;TYPE TERMINATION MESSAGE
;--CONTINUE TO LOOP TILL LOSS OF CTS (CARRIER DETECT)
CTS2:	CALL	MSTAT
	ANI	CTS
		A
	STA	CHCNT	;INITIALIZE CHARACTER POSITION COUNT
;--START OF BYTE TRANSMIT LOOP
TXBYTE:	CALL	CSTAT	;GET CONSOLE STATUS
	JZ	TF0	;DATA AVAILABLE?
	MVI	C,RDCON	;  YES
	CALL	FDOS
	CPI	EOT
	JZ	TRCHAR	;"^D" ?
TF0:	IN	MODEM0	;  NO
	ANI	RDA
	JZ	TF1A	;RX DATA AVAILABLE?
	IN	MODEM1	;  YES
	CPI	EOT
	JZ	TRCHAR	;"^D"?
TF1A:	LDA	BUFPTR	;  NO
	CPI	80H
	JNZ	TF1	;BUFFER EMPTY?
;--READ A SECTOR & EXIT IF END OF FILE
	CALL	DISKR	;  YES
	XRA	A
TF1:	MOV	E,A	;D,E = DATA BYTE ADDRESS
	MVI	D,0
	INR	A
	STA	B
	MOV	A,B
	ANI	07H	;MOD 8 COUNT VALUE
	JNZ	SPACES	;FINAL SPACE SENT?
	STA	CHCNT
	JMP	TXBYTE
;--SEND DATA BYTE & UPDATE CHCNT (CHARACTER POSITION COUNT)
TF3:	PUSH	PSW
	CALL	SHOW	;DISPLAY BYTE ON CONSOLE
	POP	PSW
	OUT	MODEM1
	CPI	LF
	JZ	TFEOL	;"LF" SIGNALS END OF TEXT LINE
	LDA	CHCNT
	INR	A
	STA	CHCNT	;INCREMENTED CHAR POSITION COUNT
	JMP	TXBYTE
;--PERFORM END OF LINE PROCESSING
TFEOL:	XRA	A
	STA	CHCNT	;RESET CHAR POSITION COUNT
	LDA	HSHAKE
	ORA	A
	JNZ	TF4	;HAND-SHAKE REQUIRED?
	MVI	ARX ROUTINE +++++++++++++++++++++++++++
;
RXFILE:	MVI	C,DELETE
	LXI	D,FCB
	CALL	FDOS	;DELETE NAMED FILE (IF IT EXISTS)
	CALL	MAKEF	;CREATE FILE FOR RX DATA
	XRA	A
	STA	BUFPTR	;INITIALIZE THE BUFFER POINTER
	MVI	C,WRCBUF
	LXI	D,MSG10
	CALL	FDOS	;TYPE "READY" MSG
;--RECEIVE A CHARACTER FROM THE REMOTE DEVICE
RCV:	IN	MODEM0
	ANI	RDA
	JNZ	GOTONE	;RECEIVED DATA AVAILABLE?
;--SUPPORT CHARACTER TX FROM CONSOLE
	CALL	CSTAT	;  YES, GET CONSOLE STATUS
	JZ	RCV	;DATA AVAILABLE?
	MVI	C,RDCON	;  YES
	CAH	PSW
	CALL	TCHAR	;TYPE "CR"
	POP	PSW
	CALL	ST$BUF	;PUT IT IN BUFFER
	MVI	A,LF
	PUSH	PSW
	CALL	TCHAR	;TYPE "LF"
	POP	PSW
	CALL	ST$BUF	;PUT IT IN BUFFER
	LDA	LFDFLG
	ORA	A
	JZ	RCV	;LINE.FEED FLAG SET?
RF1:	IN	MODEM0	;  YES
	ANI	TBE
	JZ	RF1	;TX BUFFER EMPTY?
	MVI	A,LF	;  YES
	OUT	MODEM1	;SEND LINE.FEED TO REMOTE DEVICE
	JMP	RCV
;--BUFFER IS FULL - WRITE A DISK SECTOR
RFULL:	CALL	DISKW	;  YES
	XRA	A
	STA	BUFPTR
	JMP	RCV
;--WRITE FINAL SECTOR & CLOSE FILE
RFEND:	LDA	BUFPTR
	MOV	E,A
	MVJNZ	CTS2	;HAS CTS BEEN RESET?
	MVI	A,30	;   YES
	CALL	DELAY	;3 SECOND DELAY
	LDA	ROTFLG
	ORA	A
	JNZ	ORIG	;ROTARY DIALING IN PROGRESS?
	LDA	ANSFLG	;  NO
	ORA	A
	JNZ	ANSWER	;ANSWER MODE?
	JMP	RESTRT	;  NO
	END	START
                              88-MODEM OPERATING INSTRUCTIONS:


	Detailed operating instructions for this program are contained
at the beginning of the source listing (88-MODEM.ASM).  Additional
instructions are contained in the publication "DR. DOBBS JOURNAL OF
COMPUTER CALISTHENICS & ORTHODONTIA" VOLUME 3, ISSUE 6 (June/July issue).
	The program has been updated since its publication in
DR. DOBBS. as follows:

	1. The "handshake" character has been changed from
	   "ETX" to "LF".  This should make it almost univer-
	   salonally, data loss may be encountered - even at a low
baud rate - in RX FILE mode if the disk controller does not provide
for DMA.
                                                                                                                          ;MODEM ROUTINE - SEND, RECV, COMPUTER, TERMINAL
; * * * * * * * * * * * * * * * * * * * *
;SENSE SWITCH CONTROLS:			*
;					*
;	A12 UP TO DISPLAY INCOMING DATA *
;	A13 UP TO DISPLAY OUTGOING DATA *
; * * * * * * * * * * * * * * * * * * * *
;
;09/23/77 FIRST WRITTEN BY WARD CHRISTENSEN
;09/25/77 FIRST TESTING COMPLETE
;09/26/77 ADD ERROR$LIMIT EQU
;10/01/77 CHANGE EXIT$CHAR FROM CTL-C TO
;	  CTL-E FOR USE W/TIMESHARING COMPUTERS
;10/10/77 CORRECT TO SEND ANY LENGTH FILE
;12/31/77 ADD RETRY/QUIT FROM T OR C
	ORG	100H
	CALL	START	;GO PRINT ID
	DB	'MODEM PROGRAM AS OF '
	DB	'12/31/77',13,10,'$'
;FLAG FOR GENERATING TEST CODE TO USE KEYBOARD
;TO ECHO ACK/NAK WHILE TESTING:
TEST	EQU	0	;GENERATE TEST CODE
;
;DEFINE ASCII CHARACTERS USED
SOH	EQU	1
EOT	EQU	4
ACK	EQU	6
NAK	EQU	15H
LF	EQU	10
CR	EQU	13
;
START	POP	D	;GET ID MESSAGE
	MVI	C,PRINT
	CALL	BDOS	;PRINT ID MESSAGE
;INIT PRIVATE STACK
	LXI	H,0	;HL=0
	DAD	SP	;HL=STACK FROM CP/M
	SHLD	STACK	;..SAVE IT
	LXI	SP,STACK	;SP=MY STACK'MODEM RECV FILENAME',CR,LF
	DB	'MODEM COMPUTER',CR,LF
	DB	'MODEM TERMINAL',CR,LF
	DB	'  ABBREV. ALLOWED: S R C T$'
;
;****************COMPUTER****************
;
;TERMINAL-TERMINAL W/ECHO SENT BY THIS PROGRAM
;'EXIT$CHAR' TYPED TO RE-BOOT
;IF ONE COMPUTER IS IN COMPUTER MODE,
;THE OTHER SHOULD BE IN TERMINAL MODE.
;AT NO TIME SHOULD BOTH BE IN COMPUTER
;MODE BECAUSE LINE ERRORS WILL BE PING-PONGED
;BACK AND FORTH AD INFINITUM.
COMPUTER:
	IN	MODEM$CTL$PORT
	ANI	MODEM$RECV$MASK
	CPI	RECV$READly applicable.

	2. The DELAY routine has been changed to make it hardware
	   independant.

The only remaining hardware dependant feature of the program is the
"ASSIGN CONSOLE DEVICE" (^A)  which provides for reassigning the console
device.  This function assumes a TDL ZAPPLE MONITOR.

	As mentioned in the DDJ article:  If a printing terminal is
used as the console device, it must be capable of operating at twice
the selected communicationa baud rate when disk transfers are per-
formed.  Additi QUESTION
;
MODEM$CTL$PORT	EQU	4
MODEM$SEND$MASK	EQU	2
SEND$READY	EQU	2	;VALUE WHEN READY
MODEM$RECV$MASK	EQU	1
RECV$READY	EQU	1	;BIT ON WHEN READY
MODEM$DATA$PORT	EQU	5
KEY$CTL$PORT	EQU	0	;KEYBOARD STATUS
KEY$READY$MASK	EQU	2
KEY$READY	EQU	2	;VALUE WHEN KEYBOARD READY
KEY$DATA$PORT	EQU	1
INIT$REQD	EQU	1	;MODEM INIT. REQ'D?
INIT$CHAR$1	EQU	3	;FIRST INIT CHAR TO CTL PORT
INIT$CHAR$2	EQU	15H	;2ND INIT CHAR TO CTL PORT
ERROR$LIMIT	EQU	10	;MAX ALLOWABLE ERRORS
EXIT$CHAR	EQU	'E'-40H ;CHAR TO EXIT
;
	CALL	INIT$PORT
;GOBBLE UP GARBAGE CHARS FROM THE LINE
	MVI	B,1	;TIMEOUT DELAY
	CALL	RECV
	MVI	B,1
	CALL	RECV
;
	LDA	FCB+1	;GET OPTION (S R C T)
	PUSH	PSW	;SAVE OPTION
	CALL	MOVE$FCB ;MOVE FROM 6C TO 5C
	POP	PSW	;GET OPTION
	CPI	'S'
	JZ	SEND$FILE
	CPI	'R'
	JZ	RECV$FILE
	CPI	'C'
	JZ	COMPUTER
	CPI	'T'
	JZ	TERMINAL
;INVALID OPTION
	CALL	ERXIT	;EXIT W/ERROR
	DB	'++INVALID OPTION ON MODEM COMMAND - ',CR,LF
	DB	'MUST BE ONE OF THE FOLLOWING:',CR,LF
	DB	'MODEM SEND FILENAME',CR,LF
	DB	Y
	JZ	LINE$CHAR
;NOTHING FROM LINE, CHECK KEYBOARD
	MVI	C,CONST	;CHECK STATUS
	CALL	BDOS
	ORA	A	;READY?
	JZ	COMPUTER ;..NO
	MVI	C,RDCON
	CALL	BDOS	;GET CHAR
	CPI	EXIT$CHAR ;END?
	JZ	EXIT	;YES, EXIT
	OUT	MODEM$DATA$PORT ;SEND CHAR
	JMP	COMPUTER
;GOT CHAR FROM LINE
LINE$CHAR:
	IN	MODEM$DATA$PORT
	OUT	MODEM$DATA$PORT ;ECHO
	CALL	TYPE	;TYPE IT
	JMP	COMPUTER
;
;**************TERMINAL****************
;
;SEE NOTES UNDER 'COMPUTER'
;
TERMINAL:
	IN	KEY$CTL$PORT
	ANI	KEY$READY$MASK
	CPI	KEY$READY
	JNZ	TRECV	;NOTHING FROM KEYBOARD
	IN	KEY$DATA$PORT
	ANI	7FH
	CPI	EXIT$CHAR ;TIME TO END?
	JZ	EXIT
	OUT	MODEM$DATA$PORT
TRECV	IN	MODEM$CTL$PORT
	ANI	MODEM$RECV$MASK
	CPI	RECV$READY
	JNZ	TERMINAL
	IN	MODEM$DATA$PORT
	CALL	TYPE
	JMP	TERMINAL
;INIT SERIAL PORT
INIT$PORT:
	LXI	D,MSG$BAUD
	CALL	PRINT$MESSAGE
	IF	INIT$REQD
	MVI	A,INIT$CHAR$1
	OUT	MODEM$CTL$PORT
	MVI	A,INIT$CHAR$2
	OUT	MODEM$CTL$PORT
	ENDIF
;GET THE SPEED
	XRA	A	;GET A ZERO
	CALL	SEND	;SEND A CHAR
	XRA	A	;GET ZERO DB 'BAUD RATE IS $'
MSG$110	DB	'110',CR,LF,'$'
MSG$300	DB	'300',CR,LF,'$'
;MOVE FCB (SECOND OPERAND ON COMMAND)
; TO NORMAL FCB LOCATION
MOVE$FCB:
	LXI	H,FCB
	LXI	D,FCB+16
	MVI	B,16
MOVE$LOOP:
	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	MOVE$LOOP
	XRA	A	;GET 0
	STA	FCB+32	;ZERO RECORD #
	RET
;
;*****************SEND FILE***************
;
SEND$FILE:
	CALL	OPEN$FILE	;OPEN THE FILE
	LXI	D,OPENM
	CALL	PRINT$MESSAGE
SENDB	XRA	A	;GET A ZERO
	STA	ERRCT	;ZERO ERROR COUNT
;READ SECTOR, SEIMEOUT
;TIMED OUT WAITING FOR ACK
	CALL	TOUT	;PRINT 'TIMEOUT', ERRCT
DATERR	LDA	ERRCT
	INR	A
	STA	ERRCT
	CPI	ERROR$LIMIT
	JC	REPTB	;REPEAT SECTOR
;SECTOR SEND NO GOOD AFTER 10 TRIES
	CALL	CHECK$FOR$QUIT
	JZ	REPTB	;KEEP ON TRYIN'
	CALL	ERXIT
	DB	'CAN''T SEND SECTOR '
	DB	'- ABORTING',13,10,'$'
SECTMSG	DB	'SENDING SECTOR $'
;NO TIMEOUT SENDING SECTOR
SNTO	CPI	ACK	;ACK RECIEVED?
	JZ	SENDB	;..YES, SEND NEXT SECT
;ACK NOT RECIEVED
	CALL	HEXO	;TYPE CHR IN HEX
	LXI	D,ERR1
	CALL	PRINT$MESSAGE
	MVI	B,1	;1 SEC W/NO CHARS
	CALL	RECV
	JNC	RECV$SECT$ERR ;LOOP UNTIL SENDER DONE
	MVI	A,NAK
	CALL	SEND	;SEND NAK
	LDA	ERRCT
	INR	A
	STA	ERRCT
	CPI	ERROR$LIMIT
	JC	RECV$HDR
	CALL	CHECK$FOR$QUIT
	JZ	RECV$HDR
	CALL	ERXIT
	DB	'++UNABLE TO GET VALID HEADER',0DH,0AH,'$'
RMSG	DB	'WAITING FOR SECTOR #$'
;GOT CHAR - MUST BE SOH
RHNTO	CPI	SOH
	JZ	GOT$SOH
	ORA	A	;00 FROM SPEED CHECK?
	JZ	RECV$HDR
	CPI	EOT
	JZ	GOT$EOT
;DIDN'T GET SOH - 
	CALL	HEXO
	LXI	D,ERRSOH
	CALL	PRINT$MESSAGE
	JMP	RECV$SE
	MVI	B,1	;1 SEC TIMEOUT
	CALL	RECV	;GET CHAR
	JC	RECV$HDR$TIMEOUT
	MOV	M,A	;STORE CHAR
	INR	L	;DONE?
	JNZ	RECV$CHAR
;VERIFY CHECKSUM
	MOV	D,C	;SAVE CHECKSUM
	MVI	B,1	;TIMEOUT
	CALL	RECV	;GET CHECKSUM
	JC	RECV$HDR$TIMEOUT
	CMP	D	;CHECK
	JNZ	RECV$CKSUM$ERR
;
;GOT A SECTOR, WRITE IF = 1+PREV SECTOR
;
	LDA	RECVD$SECT$NO
	MOV	B,A	;SAVE IT
	LDA	SECTNO	;GET PREV
	INR	A	;CALC NEXT SECTOR #
	CMP	B	;MATCH?
	JNZ	DO$ACK
;GOT NEW SECTOR - WRITE IT
	LXI	D,FCB
	MVI	C,WRITE
	CALL	BDOS
	ORA	A
	JN
	CALL	SEND	;SEND AGAIN
;WAIT, TIMING TO DETERMINE BAUD RATE
	LXI	B,0	;INIT COUNT
INIT$WAIT:
	IN	MODEM$CTL$PORT
	ANI	MODEM$SEND$MASK
	CPI	SEND$READY
	JZ	INIT$WAIT$END
	DCR	C
	JNZ	INIT$WAIT
	DCR	B
	JNZ	INIT$WAIT
	CALL	ERXIT
	DB	'++TIME OUT DETERMINING BAUD RATE$'
INIT$WAIT$END:
	MOV	A,B	;GET COUNT
	CPI	0F5H	;110 BAUD = F0,
	JC	BAUD$110 ;300 BAUD = FA
;BAUD RATE 300
	LXI	D,MSG$300
INIT$PRINT:
	CALL	PRINT$MESSAGE
	RET		;FROM INIT$PORT
BAUD$110:
	LXI	D,MSG$110
	JMP	INIT$PRINT
MSG$BAUDND IT
	CALL	READ$SECTOR
	LDA	SECTNO	;INCR SECT NO.
	INR	A
	STA	SECTNO
;SEND OR REPEAT SECTOR
REPTB	LXI	D,SECTMSG
	CALL	PRINT$MESSAGE
	LDA	SECTNO
	CALL	HEXO
	CALL	CRLF
	MVI	A,SOH
	CALL	SEND
	LDA	SECTNO
	CALL	SEND
	LDA	SECTNO
	CMA
	CALL	SEND
	MVI	C,0	;INIT CKSUM
	LXI	H,80H
SENDC	MOV	A,M
	CALL	SEND
	INX	H
	MOV	A,H
	CPI	1	;DONE WITH SECTOR?
	JNZ	SENDC
;SECTOR SENT, SEND CKSUM
	MOV	A,C	;GET CKSUM
	CALL	SEND
;GET ACK ON SECTOR
	MVI	B,4	;WAIT 4 SECONDS MAX
	CALL	RECV
	JNC	SNTO	;NO T	JMP	DATERR	;GO TO DATA ERROR
ERR1	DB	'H RECEIVED, NOT ACK',13,10,'$'
OPENM	DB	'FILE OPEN',13,10,'$'
;
;**************RECEIVE FILE****************
;
RECV$FILE:
	CALL	ERASE$OLD$FILE
	CALL	MAKE$NEW$FILE
RECV$LOOP:
	XRA	A	;GET 0
	STA	ERRCT	;INIT ERROR COUNT
RECV$HDR:
	LXI	D,RMSG
	CALL	PRINT$MESSAGE
	LDA	SECTNO
	INR	A
	CALL	HEXO
	CALL	CRLF
	MVI	B,5	;5 SEC TIMEOUT
	CALL	RECV
	JNC	RHNTO	;NO TIMEOUT
RECV$HDR$TIMEOUT:
	CALL	TOUT	;PRINT TIMEOUT
RECV$SECT$ERR:
;PURGE THE LINE OF INPUT CHARS
CT$ERR
ERRSOH	DB	'H RECEIVED, NOT SOH',0DH,0AH,'$'
GOT$SOH:
	MVI	B,1
	CALL	RECV
	JC	RECV$HDR$TIMEOUT
	MOV	D,A	;D=BLK #
	MVI	B,1
	CALL	RECV	;GET CMA'D SECT #
	JC	RECV$HDR$TIMEOUT
	CMA
	CMP	D	;GOOD SECTOR #?
	IF	TEST
	JMP	RECV$SECTOR
	ENDIF
	JZ	RECV$SECTOR
;GOT BAD SECTOR #
	LXI	D,ERR2
	CALL	PRINT$MESSAGE
	JMP	RECV$SECT$ERR
ERR2	DB	'++BAD SECTOR # IN HDR',0DH,0AH,'$'
;
RECV$SECTOR:
	MOV	A,D	;GET SECTOR #
	STA	RECVD$SECT$NO
	MVI	C,0	;INIT CKSUM
	LXI	H,80H	;POINT TO BUFFER
RECV$CHAR:
Z	WRITE$ERROR
	LDA	RECVD$SECT$NO
	STA	SECTNO	;UPDATE SECTOR #
DO$ACK	MVI	A,ACK
	CALL	SEND
	JMP	RECV$LOOP
;
WRITE$ERROR:
	CALL	ERXIT
	DB	'++ERROR WRITING FILE',0DH,0AH,'$'
;
RECV$CKSUM$ERR:
	LXI	D,ERR3
	CALL	PRINT$MESSAGE
	JMP	RECV$SECT$ERR
ERR3	DB	'++BAD CKSUM ON SECTOR'
	DB	0DH,0AH,'$'
;
GOT$EOT:
	MVI	A,ACK	;ACK THE EOT
	CALL	SEND
	LXI	D,FCB
	MVI	C,CLOSE
	CALL	BDOS
	INR	A
	JNZ	XFER$CPLT
	CALL	ERXIT
	DB	'++ERROR CLOSING FILE$'
;
ERASE$OLD$FILE:
	LXI	D,FCB
	MVI	C,SRCHF	;SEE IF IT EXISTS
	CALL	BDOS
	INR	A	;FOUND?
	RZ		;NO, RETURN
	LXI	D,EXIST
	CALL	PRINT$MESSAGE
	MVI	C,RDCON
	CALL	BDOS
	CPI	'Y'
	JNZ	0	;REBOOT IF NOT ERASE
	CALL	CRLF
;ERASE OLD FILE
	LXI	D,FCB
	MVI	C,ERASE
	CALL	BDOS
	RET
EXIST	DB	'++FILE EXISTS, TYPE Y TO ERASE:$'
;
MAKE$NEW$FILE:
	LXI	D,FCB
	MVI	C,MAKE
	CALL	BDOS
	INR	A	;FF=BAD
	RNZ		;OPEN OK
;DIRECTORY FULL - CAN'T MAKE FILE
	CALL	ERXIT
	DB	'++ERROR - CAN''T MAKE FILE',0DH,0AH
	DB	'++DIRECTORY MUST BE FULL',0DH,0AH,'$'
;
; S U B R O CV	PUSH	D	;SAVE
MSEC	LXI	D,0BBBBH	;1 SEC DCR COUNT
	IF	NOT TEST
MWTI	IN	MODEM$CTL$PORT
	ANI	MODEM$RECV$MASK
	CPI	RECV$READY
	JZ	MCHAR	;GOT CHAR
	ENDIF
	IF	TEST
MWTI	IN	KEY$CTL$PORT	;READ KEYBOARD
	ANI	KEY$READY$MASK
	CPI	KEY$READY
	JZ	MCHAR
	ENDIF
	DCR	E	;COUNT DOWN
	JNZ	MWTI	;FOR TIMEOUT
	DCR	D
	JNZ	MWTI
	DCR	B	;DCR # OF SECONDS
	JNZ	MSEC
;MODEM TIMED OUT RECEIVING
	POP	D	;RESTORE D,E
	STC		;CARRY SHOWS TIMEOUT
	RET
;GOT MODEM CHAR
	IF	NOT TEST
MCHAR	IN	MODEM$DATA$PORT
	ENDIF
	IN$OUTPUT:
	POP	PSW
	PUSH	PSW
	ADD	C	;CALC CKSUM
	MOV	C,A
SENDW	IN	MODEM$CTL$PORT
	ANI	MODEM$SEND$MASK
	CPI	SEND$READY
	JNZ	SENDW
	POP	PSW	;GET CHAR
	OUT	MODEM$DATA$PORT
	RET
; - - - - - - - - - - - - - - -
;SHOW CHAR RECEIVED OR SENT
SHOW	CPI	0AH	;LF?
	JZ	TYPE
	CPI	0DH
	JZ	TYPE
	CPI	09	;TAB
	JZ	TYPE
	CPI	' '
	JC	SHOWHEX
	CPI	7FH
	JC	TYPE
SHOWHEX	PUSH	PSW
	MVI	A,'('
	CALL	TYPE
	POP	PSW
	CALL	HEXO
	MVI	A,')'
	JMP	TYPE
; - - - - - - - - - - - - - - -
;PRINT TIMEOUT MESSAGE
TOUT - - - - - - - - - - - - - - -
;MULTIPLE ERRORS, ASK IF TIME TO QUIT
CHECK$FOR$QUIT:
	XRA	A	;GET 0
	STA	ERRCT	;RESET ERROR COUNT
	LXI	D,QUITM
	CALL	PRINT$MESSAGE
	MVI	C,RDCON
	CALL	BDOS
	PUSH	PSW	;SAVE CHAR
	CALL	CRLF
	POP	PSW
	CPI	'R'
	RZ		;RETURN IF RETRY
	CPI	'Q'	;QUIT?
	JNZ	CHECK$FOR$QUIT
	ORA	A	;TURN OFF ZERO FLAG
	RET
QUITM	DB	0DH,0AH,'++MULTIPLE ERRORS ENCOUNTERED.'
	DB	0DH,0AH,'TYPE Q TO QUIT, R TO RETRY:$'
; - - - - - - - - - - - - - - -
;FILE READ ROUTINE
READ$SECTOR:
	LXI	DTIMEOUT ON EOT
EOTTOT	CALL	TOUT
	JMP	EOTERR
;READ ERROR
RDERR	CALL	ERXIT
	DB	'++FILE READ ERROR$'
; - - - - - - - - - - - - - - -
;DONE - CLOSE UP SHOP
XFER$CPLT:
	CALL	ERXIT
	DB	13,10,'TRANSFER COMPLETE$'
	DS	40	;STACK AREA
STACK	DS	2	;STACK POINTER
RECVD$SECT$NO	DB	0
SECTNO	DB	0	;CURRENT SECTOR NUMBER 
ERRCT	DB	0	;ERROR COUNT
;
; BDOS EQUATES (VERSION 2)
;
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
CONST	EQU	11	;CONSOLE STAT
OPEN	EQU	15	;0FFH=NOT FOUND
CLOSE	EQU	16	;   "	"
SRCHF	EQU	17	;U T I N E S
;
;OPEN FILE
OPEN$FILE	LXI	D,FCB
	MVI	C,OPEN
	CALL	BDOS
	INR	A	;OPEN OK?
	RNZ		;GOOD OPEN
	CALL	ERXIT
	DB	'CAN''T OPEN FILE$'
; - - - - - - - - - - - - - - -
PRINT$MESSAGE:
	MVI	C,PRINT
	JMP	BDOS	;PRINT MESSAGE, RETURN
; - - - - - - - - - - - - - - -
;EXIT PRINTING MESSAGE FOLLOWING 'CALL ERXIT'
ERXIT	POP	D	;GET MESSAGE
	CALL	PRINT$MESSAGE	;PRINT IT
EXIT	LHLD	STACK	;GET ORIGINAL STACK
	SPHL		;RESTORE IT
	RET		;--EXIT-- TO CP/M
; - - - - - - - - - - - - - - -
;MODEM RECV
REF	TEST
MCHAR	IN	KEY$DATA$PORT
	ANI	7FH	;DEL PARITY FROM KEYBOAREAD
	ENDIF
	POP	D	;RESTORE DE
;CALC CHECKSUM
	PUSH	PSW
	ADD	C
	MOV	C,A
;CHECK IF MONITORING INPUT
	IN	0FFH
	ANI	10H
	JZ	NO$MON$INPUT
	POP	PSW
	PUSH	PSW
	CALL	SHOW	;CHAR RECEIVED
NO$MON$INPUT:
	POP	PSW
;TURN OFF CARRY TO SHOW NO TIMEOUT
	ORA	A
	RET
; - - - - - - - - - - - - - - -
;MODEM SEND CHAR ROUTINE
SEND	PUSH	PSW
;CHECK IF MONITORING OUTPUT
	IN	0FFH
	ANI	20H
	JZ	NO$MON$OUTPUT
	POP	PSW
	PUSH	PSW
	CALL	SHOW
NO$MOM	DB	'TIMEOUT $'
TOUT	LXI	D,TOUTM
	CALL	PRINT$MESSAGE
PRINT$ERRCT:
	LDA	ERRCT
	CALL	HEXO	;FALL INTO CR/LF
; - - - - - - - - - - - - - - -
CRLF	MVI	A,13
	CALL	TYPE
	MVI	A,10
; - - - - - - - - - - - - - - -
TYPE	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A
	MVI	C,WRCON
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET
; - - - - - - - - - - - - - - -
;HEX OUTPUT
HEXO	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	NIBBL
	POP	PSW
NIBBL	ANI	0FH
	CPI	10
	JC	ISNUM
	ADI	7
ISNUM	ADI	'0'
	JMP	TYPE
;,FCB
	MVI	C,READ
	CALL	BDOS
	ORA	A
	RZ
	DCR	A	;EOF?
	JNZ	RDERR
;EOF
	XRA	A
	STA	ERRCT
	LXI	D,FSENTM ;FILE SENT MESSAGE
	CALL	PRINT$MESSAGE
SEOT	MVI	A,EOT
	CALL	SEND
	MVI	B,5	;WAIT 5 SEC FOR TIMEOUT
	CALL	RECV
	JC	EOTTOT	;EOT TIMEOUT
	CPI	ACK
	JZ	XFER$CPLT
;ACK NOT RECIEVED
	CALL	HEXO
	LXI	D,ERR1
	CALL	PRINT$MESSAGE
EOTERR	LDA	ERRCT
	INR	A
	STA	ERRCT
	CPI	ERROR$LIMIT
	JC	SEOT
	CALL	ERXIT
	DB	'NO ACK RECIEVED ON EOT$',10,13
FSENTM	DB	13,10,'FILE SENT, SENDING EOT''S',10,13,'$'
;   "	"
SRCHN	EQU	18	;   "	"
ERASE	EQU	19	;NO RET CODE
READ	EQU	20	;0=OK, 1=EOF
WRITE	EQU	21	;0=OK, 1=ERR, 2=?, 0FFH=NO DIR SPC
MAKE	EQU	22	;0FFH=BAD
REN	EQU	23	;0FFH=BAD
STDMA	EQU	26
BDOS	EQU	5
REIPL	EQU	0
FCB	EQU	5CH	;SYSTEM FCB
DOCUMENTATION OF THE CP/M MODEM PROGRAM

		by Ward Christensen

MODEM is a program for transferring files between CP/M systems.
Files are sent a sector at a time.  The program prints mes-
sages showing how things are going.  A hexadecimal sector
number is printed, in a message: "WAITING FOR SECTOR NN" on
one system, and "SENDING SECTOR NN" on the other system.

Users of the program should list it and study it if they
are interested in learning more about it.  At a minimum, it
must be edited and  re-dial the phone to get a better
connection.  If you are further along in the transmission,
you would likely want to retry.  Note that the program does
not close the file if you say quit.

There is one known design error in this program:  After the
file is sent, the sending program sends a single EOT character.
The receiving program, upon receiving an EOT, takes closes
the file, and returns to CP/M.  This is normally not a problem,
but means that if the receiving program gets a glitch when
it isill be sent after
the next data block is sent or received.  The other user
will see the message and can reply. 

				Ward Christensen
				c/o CACHE
				Box 52
				South Holland, Il. 60473
.pl 72
.mb 8
.mt 8
.cw 8
.lh 7
.po 7
.op
                               Nationa CP/ User Grou - Progra Submitta Form

** I yo hav an comment o thi form pleas 
**forwar the t th CP/ User Group.
**
**Pleas fil ou thi for fo al materia sub
**mitte t th CP/ User Group  I wil assis 
**u i preparin you contributio fo circulatio 
**an i helpin peopl selec programs 
**
**Sen th contribution wit th complete form 
**to:
*eas 
cross-referenc an rewrite o bug-fixe t prio 
distributions.
**
**I i intende tha thi for b fille ou wit 
**a editor an lef o th submitte dis fo 
**eac program  (Yo ma grou simila program 
**together) Al line startin * ar comment 
**whic shoul b delete fro th form  Remembe 
**t kee a origina o th for aroun fo sub
**mittin mor tha on program.
**
**(I yo don' mind ther ar stil  lo o u 
**omodified for the particular serial
interface used for the modem.  As it stands, it is for my
MITS dual serial I/O board, ports 4 and 5.

To use the program, one user types:
	MODEM SEND filename.filetype
The other user types:
	MODEM RECEIVE filename.filetype

(SEND and RECEIVE may be abbreviated S and R)

The program has an error counter.  Each block is tried up
to 10 times.  If 10 occur, it asks if you want to retry
or quit.  If you are near the beginning of a file, you
might want to quit, and looking for the start of a block, it will shut down
early.  Also if the valid EOT from the sender is glitched,
the receiving program will wait, eventually timing out.

I have nearly completed a version of the program which does
better handshaking at EOF, which closes the file if you
quit, and which allows a 'second logical channel' allowing
keyboard-to-keyboard communications in parallel with the
file transfer.  Thus, you could type "I'll send you spat.com
when this is done, OK" and this message w*
**CP/ User Group
**165 Thir Avenue
**Ne York N 10028
**
Softwar contribution ar receive fo inclusio 
int th librar wit th understandin tha th 
contributo i authorize t mak th materia a
vailabl t other fo thei individua non-commer
cia use Th User Grou make n representation 
a t th utilit o th materia i th librar fo 
an purpose Contribution shoul b submitte o 8 
singl densit diskette i CP/ fil form Plu her wit 6 wid displays  W woul appre
**ciat you limitin you line t 6 characters  
**<<thanks>>)
**
**Thi for i mos easil fille ou wit  ful 
**scree editor  Yo ma d  "macr nex colon 
**(mn:$v t locat th field whic hav t b 
**fille in.
**
** Sav thi fil a "filename.CPM"
**
**Yo ca the delet al comment line via.. 
**bmn**$0ltk

Date:

File name: 
**(o names) Includ   lin descriptio o each
** Examples ...
* MORSE.AS   Send Mors cod fro ASCI fil t 
**             port.
**SAMPLE.DA  Sampl dat fil fo MORSE.
.cp 7
.po 67


Author: 
**Pleas includ addres an phon number I ei
**the i no t b published s indicate bu 
**includ the fo th User Grou dis catalogin 
**process i cas ther ar questions.

Submitted by: 
**(i differen tha author)  Als includ addres 
**an phone i different.

This program is public domain because: 
**e.g S**disk Wa anythin publishe i  magazine etc 
**I thi  modificatio o  previou User Grou 
**program an i so wha wa it "name (e.g 
**23.05)

Hardware dependencies: 
**e.g specifi processor dis controller plot
**ter printer modem vide board etc.

Software dependencies: 
**e.g I/Ϡ vi PRO calls o hard-code ports 
**JMPS/CALLӠ t specifi machine-siz BIOS othe 
**softwar require whic i NO o thi disk Tim
**in dependencies "Wel commente .AS 
**file";"Poorl commente .AS file"

**02/22/8 WLC
;    ====================
;    :   T T Y D R V    :
;    ====================
;
; DISASSEMBLED AND ANNOTATED TELETYPE DRIVER FROM THE
; MICROSOFT FORTRAN PACKAGE.
;    R.C. Minnick - Box 306  -  Ouray, CO 81427
;
;
; VERSION 1.0    6/22/78
;
	ENTRY	$DRV3
	EXT	$IOERR,$BL,$BF,$ERR,$TTYIN,$TTYOT
;
; INDEX TABLE
;
$DRV3:	DW	FREAD	;FORMATTED READ
	DW	FWRITE	;FORMATTED WRITE
	DW	IOERR	;BINARY READ
	DW	IOERR	;BINARY WRITE
	DW	EOF	;REWIND
	DW	EOF	;BACKSPACE
	DW	EOF	;ENDFILE
;
; EOF DETECTED EW LENGTH
	CPI	X'0D'	;CRET?
	RZ		;YES - BUFFER FULL
	MOV	A,L
	CPI	X'80'	;TOO MANY DATA IN BUF?
	JC	FILL	;NO
	CALL	$ERR	;YES - ERROR & RETURN
	STAX	D
	XRA	A
	RET
;
; FORMATTED WRITE
;
FWRITE:	LDA	$BL	;BUFFER LENGTH
	ORA	A
	RZ		;RETURN IF BUF EMPTY
	LHLD	$BF	;BUFFER BASE POINTER
	DCR	A	;DECREMENT LENGTH
	PUSH	PSW	;SAVE LENGTH
	MVI	A,X'0D'
	CALL	$TTYOT	;SEND CRET TO CON:
	MOV	A,M	;1ST BUF DATUM (CARR CONTROL)
	CPI	"+"	;CONTROL FOR NO LINE FEED
	JZ	CONFW2
	CPI	"1"	;CONTROL FOR FORM FEED
ubmitte b author author' approval ap
**prova fro magazin i whic i wa published 
**etc.

To whom would this program be useful: 
**e.g "Al CP/ users o "Peopl wit Tarbel 
**flopp controllers o "Peopl wit one-dis sys
**tems etc.

Briefly describe the program function: 
**Includ ru instruction onl i no include i 
**som othe .DO fil o thi disk.

Where is further documentation available: 
**e.g nam th appropriat .DO file o thi 
 "STANDAR CP/M mean i run 
**wit 8 disk (o similarl behavin one lik 
**Northstar) 24 o mor memory CP/ 1.4 D yo 
**think/kno i work with CP/ 2.0?

Source processor: 
**i.e i thi i  sourc program wha d yo 
**"ru i with".. MAC ASM Microsof BASI ver
**sio x.y TD AS etc.

Does the software "drop in": 
**i.e wha typ o modification ar require t 
**mak i run?

How easy is the code to modify: 
**e.g "CO͠ fil only"- RETURN CY=0, ZF=0
;
EOF:	XRA	A
	RET
;
; I/O ERROR DETECTED
;
IOERR:	JMP	$IOERR
;
; FORMATTED READ
;
FREAD:	XRA	A
	STA	$BL	;SET BUF LENGTH=0
FILL:	CALL	$TTYIN	;GET DATUM
	ANI	X'7F'	;MASK
	CPI	X'0A'	;BUFFER EMPTY?
	JZ	FILL	;YES, TRY AGAIN
	PUSH	PSW	;SAVE DATUM
	LHLD	$BL	;BUFFER LENGTH
	MVI	H,0	;HL=BUF LENGTH AS 16 BITS
	XCHG
	LHLD	$BF	;BUFFER PTR
	DAD	D	;HL=INDEXED BUF PTR, DE=LENGTH
	POP	PSW	;DATUM
	MOV	M,A	;PUT IT IN BUF
	INX	D
	XCHG		;DE=BUF PTR, HL=NEW LENGTH
	SHLD	$BL	;SAVE N
	JNZ	CONFW1	;1 OR 2 LINE FEEDS
	MVI	A,X'0C'
	CALL	$TTYOT	;DO FORM FEED
	JMP	CONFW2
; 1 OR 2 LINE FEEDS
CONFW1:	MVI	A,X'0A'	;FIRST LINE FEED
	CALL	$TTYOT
	MOV	A,M
	CPI	" "	;CARR CONTROL=SPACE?
	JZ	CONFW2	;YES, SKIP 2ND LINE FEED
	CPI	"0"	;0 IS 2 LINE FEEDS
	JNZ	CONFW2
	MVI	A,X'0A'
	CALL	$TTYOT	;SECOND LINE FEED
; NO LINE FEED
CONFW2:	POP	PSW	;CURRENT BUF LENGTH
	INX	H	;BUF PTR
; LOOP THROUGH BUFFER
CONLOP:	RZ		;IF BUF LENGTH=0
	PUSH	PSW	;SAVE LENGTH
	MOV	A,M	;DATUM
	INX	H
	CALL	$TTYOT
	POP	PSW
	DCR	A
	JMP	CONLOP
;
;
	END
