 CATALOG 25  i               BKSPACE DOC                FRAGMENTDOC ~  	
             LETTER  ASM L #
            LETTER  DOC                MYMAC   LIB ^ 0           NAMES   DAT ` 	               STATPCH ASM I                 CAT     ASM   ( !            CATALOG DOC  A"#$%&'()*        CBIOS24 ASM   +,-./0123456789: CBIOS24 ASM  P;<=>?@ABCD       COPY    ASM   BEFGHIJKLM        FBIOS24 ASM   NOPQRSTUVWXYZ[\] FBIOS24 ASM  P^_`abcdefg       FBOOT24 ASM   hi              VOLUME 25

VARIOUS ASSEMBLER UTILITIES

NUMBER	SIZE	NAME		COMMENTS

		CATALOG.25	CONTENTS OF CP/M GROUP VOL 25
		VOLUME25.DOC	COMMENTS ON VOLUME CONTENTS
25.1	2K	88-MODEM.DOC	NOTES ON 25.2 BELOW
25.2	32K	88-MODEM.ASM	INTELLIGENT TERMINAL PROGRAM FOR THE IDS 88
				MODEM BOARD.  SEE DR. DOBB'S VOL 3, ISSUE 6,
				JUN-JUL 1978.
25.3	3K	BKSPACE.DOC	NOTES ON BACKSPACE HANDLING IN CP/M AND
				MICROSOFT BASIC.
25.4	4K	FRAGMENT.DOC	PAGING AND SCREEN COPY CODE FOR MEMORY MAPPED
				VIDEO BOARD.
25.6K	CBIOS24.ASM	BIOS FOR TARBELL DISK CONTROLLER.  SEE
				TARBELL.DOC
25.14	2K	SBOOT24.ASM	BOOT FOR TARBELL DISK CONTROLLER.  SEE
				TARBELL.DOC
25.15	26K	FBIOS24.ASM	BIOS FOR DUAL PERSCI DISK CONTROLLER.
				SEE TARBELL.DOC
25.16	2K	FBOOT24.ASM 	BOOT FOR DUAL PERSCI DISK CONTROLLER.
				SEE TARBELL.DOC
25.17	9K	COPY.ASM	USERS' GROUP 1.3 MODIFIED FOR TARBELL
				CONTROLLER.
25.18	9K	FORMAT.ASM	DISK INITIALIZE PROGRAM FOR TARBELL
				CONTROLLER.
25.19	3K	TARBELL.DOC	NOTES ON 25.13 THROUGH 25.18.OADING STOIC AS A
				STAND-ALONE SYSTEM.
25.29	1K	STATPCH.ASM	DEVICE NAME PATCHES FOR STAT
25.30	3K	TTYDRV.MAC	TTY DRIVERS FROM MICROSOFT FORTRAN
 FORMAT  ASM   Ejklmnopqr        NOTES   VAN   stu              SBOOT24 ASM   vw               TARBELL DOC   xyz              UCAT    ASM   9{|}~         QCAT    ASM   !            STOIC   COM   d    LOAD    DOC   .           BOOT    ASM   2          BOOT    DOC                  VOLUME25DOC @                5	5K	LETTER.ASM	PERSONALIZED FORM LETTER GENERATOR.  FOR MAC 
				ASSEMBLER.  OUTPUT IN DIGITAL RESEARCH TEX FORMAT.
25.6	3K	LETTER.DOC	DOCUMENTATION FOR LETTER
25.7	6K	MYMAC.LIB	MACRO LIBRARY NEEDED TO ASSEMBLE LETTER.
25.8	2K	NAMES.DAT	SAMPLE NAME FILE FOR LETTER.
25.9	9K	DCHAYES.ASM	PROGRAM IN DCHAYES MODEM MANUAL.
25.10	7K	DCHDIAG.ASM	DIAGNOSTIC FOR DCHAYES MODEM.
25.11	13K	MODEM.ASM	INTELLIGENT TERMINAL PROGRAM FOR CACHE
				COMPUTER NETWORK.
25.12	3K	MODEM.DOC	DOCUMENTATION FOR 25.11
25.13	2
25.20	3K	NOTES.VAN	NOTES ON CP/M OPERATION AND UNDOCUMENTED
				FEATURES.
25.21	5K	CAT.ASM		MASTER DISK CATALOG SYSTEM PROGRAM.
25.22	8K	UCAT.ASM	MASTER DISK CATALOG SYSTEM PROGRAM.
25.23	5K	QCAT.ASM	MASTER DISK CATALOG SYSTEM PROGRAM.
25.24	7K	CATALOG.DOC	DOCUMENTATION FOR MASTER CATALOG SYSTEM.
25.25	13K	STOIC.COM	CP/M STOIC CONSTRUCTED AS DESCRIBED
				IN VOLUME23.DOC.
25.26	7K	BOOT.ASM	STOIC BOOTSTRAP IN 8080 ASSEMBLER.
25.27	2K	BOOT.DOC	BOOT DOCUMENTATION.
25.28	6K	LOAD.DOC	INFORMATION ON L               FLOWCHART FOR BACKSPACE HANDLING
                  IN CP/M AND MICROSOFT BASIC
                         R.C. Minnick
                            Box 306
                        Ouray CO 81427


Unfortunately  for  those  of  us  who  are  able  to  do  real
backspaces,  both CP/M and Microsoft Disk BASIC assume that all
of us are stupid enough to buy ASR33's.    Also,  each  of  the
above  two  processors  handles  backspaces  differently.   The
flowchart below shows how I have bee                  !              IS DATUM='\'? :y___
                   IS SF=1? :n____       n              !
                       y          !      !          SET SF=1
                       !          !   IS DATUM=DEL? y__!
                   SET SF=0       !      n             !
                       !          !      !             !
                       !          !   SET DATUM=DEL    !
                       !          !      !             !
                       !          !______!     



         ======================================
         Code fragment for the above flow chart
         DF is bit 7 & SF is bit 6 of IOCKBD
         ======================================

;
; VDM OUTPUT DRIVER - DATUM IN C - HANDLE
; DELETE FLAG (DF) & BACKSLASH FLAG (SF) 
VDMC:  PUSH    H
       LXI     H,IOCKBD
       MOV     A,M
       RLC             ;CY=1 IF DF=1
       JC      VDMCA
       RLC             ;CY=1 IF SF=1
       MOV     A,C     ;DATUM
       JNC     VDMCB
                           TWO VDM CBIOS FRAGMENTS
                         R.C. Minnick
                            Box 306
                        Ouray, CO 81427
                               



      There are a couple features in my CBIOS which I find very
useful, and which might be of interest to others in the  CPMUG.
Rather than bore you with a complete CBIOS listing (it occupies
5K  of  EPROM plus the standard RAM), the two interesting parts
are shown below as code fragments.  

      The fe.  


; SCROLL SCREEN UP
SCRL:  LXI     H,BOTL  ;BEGINNING OF TEXT LINE
       PUSH    H
       LDA     IOCVDM
       ANI     1       ;0=PAG OFF
       XRI     1       ;0=PAG ON
       ORA     M       ;0= " & BOTL=0
       JNZ     $+6
       CALL    CHAR    ;ANY BUT P RESTARTS
       CPI     'P'
       PUSH    D
       CZ      TOGPG   ;P REMOVES PAGING
       POP     D
       MOV     A,M
       INR     M
       SUB     M
       LXI     B,0
       CALL    CLNA
       LXI     B,2040H ;B=n able to get  rid  of  the
annoying  backslashes  and  echoed  deletions  in both CP/M and
BASIC.  I have chosen to use the DEL key for  backspacing,  but
another can be substituted if desired.  

      This scheme does not make TAB corrections on  backspacing
(an  exercise  for  the  student--and PLEASE tell me if you are
able to add in this feature!) 
                     ENTRY
                       !
                   IS DF=1? :y____________
                       n                 !
             !
                       !                 !             !
                       !              DISPLAY DATUM    !
                       !                 !             !
                       !              SET DF=0         !
                       !                 !             !
                       !_________________!_____________!
                                         !
                                       EXIT

              SF=BACKSLASH FLAG
              DF=DELETE FLAG
MOV     A,M
       ANI     0BFH    ;SF=0
       MOV     M,A
       POP     H
       RET
VDMCA: MOV     A,C
       CPI     5CH     ;BACKSLASH
       JNZ     VDMCC
       MOV     A,M
       ORI     40H     ;SF=1
       MOV     M,A
       POP     H
       RET
VDMCC: CPI     7FH     ;DELETE?
       MVI     A,7FH
       JNZ     VDMCB
       POP     H
       RET
VDMCB: CALL    VDM
       MOV     A,M
       ANI     7FH     ;DF=0
       MOV     M,A
       POP     H
       RET
irst is a VDM paging function which is added to  the
standard  VDM  software  driver.    In the code below, bit 0 of
IOCVDM stores the paging flag.  If  it  is  on,  the  VDM  will
display  16  lines  and  then pause until a CON: input.  If the
input is any character BUT a 'P', the process of stopping every
16 lines continues; if a 'P' is entered,  the  paging  flag  is
turned  off.   The code below does not show the TOGPG function,
since it is certain that you will do the job differently than I
havSPACE, C=CTR=64
SCRL2: MOV     M,B     ;CLEAR BOTTOM LINE
       INR     L
       DCR     C
       JNZ     SCRL2
       POP     H
       MOV     A,M
       ANI     0FH
       MOV     M,A
; SET BOSL & BOTL IN SCROLL REGISTER
VDMOT: LDA     BOSL
       RLC
       RLC
       RLC
       RLC
       LXI     H,BOTL
       ORA     M
       OUT     VDMDEV  ;SCROLL REGISTER PORT
       RET





      In the second code fragment, a hard copy is  produced  of
the  information  on the VDM screen.  That is, the current CON:
display is sent to LST: without  any  disturbance  (except  the
appearance  of  the prompt character--which is later erased) to
CON:.  This fragment is actually an addition to code  published
by  Dan  S.  Parker  in DDJ [V2 N4 P10, April 1977].  The cited
code has been improved by the suppresion of blanks to the right
of non-blank text on each line.  My  code  below  is  not  very
elegant,  but it works.  Furthermore, I find the feature useful
to have.  


;
; HARD C    ;LINE COUNT
       JNZ     HCOPY3  ;NOT DONE
       RET
HCOPY3:MVI     D,40H   ;RESET CHAR COUNT
       MVI     C,3FH   ;LOCAL CTR
       PUSH    H       ;SAVE BEG. OF LINE PTR.
       MOV     A,L
       ADD     C
       MOV     L,A     ;HL POINTS TO END OF LINE
HCOPY5:MOV    A,M
       CPI     20H     ;SPACE?
       JNZ     HCOPY4  ;NO, EXIT THIS CALC.
       DCR     D
       DCX     H
       DCR     C       ;TO KEEP ON THIS LINE
       JNZ     HCOPY5  ;CONTINUE REMOVING SPACES
HCOPY4:P; 	===================================
;	: L E T T E R    V3.3   7/13/78   :
;	:     R.C. Minnick                :
;	:        Box 306                  :
;	:   Ouray, Colorado 81427         :
; 	===================================
;
; CREATES FILES LLXXX.TEX & EEXXX.TEX FROM
; NAMES.DAT ACCORDING TO PARAMETER FIELD #2;
; WHERE LLXXX IS A LETTER FILE & EEXXX IS AN
; ENVELOPE FILE FOR TEXT EDITOR PROCESSING.
;
; EXAMPLE:  LETTER 7,MI5,3    -    GENERATES
; FILES EEMI5.TEX  AND  LLMI5.TEX.
;
; FIRM1		;SAVE IT
;
; GET BODY PARM & SAVE
;
	FINDPAR
	JC	ERROR2		;DID NOT FIND
	MOV	A,C
	CPI	3
	JNZ	ERROR2		;NOT LENGTH 3
	MOVE	,PARM2		;SAVE
;
; GET TAIL PARM & SAVE
;
	FINDPAR
	JC	ERROR3		;DID NOT FIND
	MOV	A,C
	DCR	A
	JNZ	ERROR3		;NOT LENGTH 1
	MOVE	,PARM3
;
; SET UP FILES
;
	FILE	INFILE,NAME,,NAMES,DAT,1000
	FILE	OUTFILE,LTR,,LL,TEX
	FILE	OUTFILE,ENV,,EE,TEX
;
; FIND HEAD IN NAMES & STORE IN LTR & ENV
;
	;FIRST REF TO PUTSTR NEEDS <<>> FOR PARM PASS-THROUGH
	PUTSTR	LTR,<<'.LL63AME
	  STA	X
	  WHEN	X,NEQ,%'['
	    LDA	X
	    PUT	LTR
	    LDA	X
	    PUT	ENV
	    WHEN	X,EQL,%LF
	      LDA	CENTER
	      CPI	0FFH
	      JNZ	PASS1
	      PUTSTR	LTR,<'.BR',CR,LF>
	      PUTSTR	ENV,<'.BR',CR,LF>
PASS1:	      LDA	CENTER
	      CPI	0FFH
	      JZ	PASS2
              PUTSTR	LTR,<'.CE',CR,LF>
	      PUTSTR	ENV,<'.CE',CR,LF>
PASS2:	    ENDW
	  ENDW
	ENDDO
;
; FIND BODY IN NAMES & STORE IN LTR & ENV
;
	PUTSTR	LTR,<'XX',CR,LF,'.QI',CR,LF,'.SP2',CR,LF>
	PUTSTR	ENV,<CR,LFOPY OF VIDEO SCREEN TO DURA
;
HCOPY: LDA     BOTL    ;VDM BEG. OF TEXT LINE
       LXI     H,VDMBASE       ;BOTTOM VDM RAM
       LXI     D,40H   ;CHAR/LINE (16-BIT)
HCOPY1:DAD     D
       DCR     A
       JNZ     HCOPY1  ;HL NOT AT START OF TEXT
       MVI     E,11H   ;E=1+LINES/SCREEN
NXTLN: MVI     C,CR
       CALL    LIST    ;DO CRET
       MOV     A,H
       CPI     0D0H    ;STILL WITHIN VDM RAM?
       JNZ     $+6     ;YES
       LXI     H,VDMBASE       ;WRAP-AROUND
       DCR     E   OP     H       ;RESTORE BEG. OF LINE PTR.
HCOPY2:PUSH    H       ;SAVE BEG. OF LINE
       MOV     C,M     ;DATUM
       CALL    LIST    ;PRINT IT
       INX     H
       DCR     D       ;CHAR COUNT
       JNZ     HCOPY2+1        ;CONTINUE
       POP     H       ;BEG. OF THIS LINE
       LXI     B,40H
       DAD     B       ;HL NOT POINTS TO NEXT LINE
       JMP     NXTLN
RST PARM (0-9) SPECIFIES HEAD (RETURN ADDRESS),
; WHERE 0-4 PUTS HEADING AT RIGHT & 5-9 CENTERS IT.
;
; SECOND PARM (LETTER-LETTER-DIGIT) SPECIFIES NAME
; AND SALUTATION.
;
; THIRD PARAMETER (0-9) SPECIFIES TAIL (CONCLUSION).
;
	ORG	100H
	MACLIB	SEQIO
	MACLIB	MACRO
	MACLIB	MYMAC
	MACLIB	NCOMPARE
	MACLIB	DOWHILE
	MACLIB	WHEN
;
CR	EQU	0DH
LF	EQU	0AH
;
	LXI	SP,STACK
;
; GET HEAD PARM & STORE
;
	FINDPAR
	JC	ERROR1		;DID NOT FIND IT
	MOV	A,C
	DCR	A
	JNZ	ERROR1		;NOT LENGTH 1
	MOVE	,PA',CR,LF,'.PO13',CR,LF,'.PL60',CR,LF>>
	PUTSTR	ENV,<'.MT1',CR,LF,'.HM0',CR,LF,'.PO5',CR,LF,'.PL20',CR,LF>
	PUTSTR	ENV,<'.MB0',CR,LF,'.OP',CR,LF>
	WHEN	PARM1,LSS,35H
	  PUTSTR	LTR,<'.IN39',CR,LF>
	ENDW
	WHEN	PARM1,GEQ,35H
	  PUTSTR	LTR,<'.CE',CR,LF>
	  PUTSTR	ENV,<'.LL24',CR,LF,'.CE',CR,LF>
	  LDA	PARM1
	  SUI	5
	  STA	PARM1
	  STA	CENTER		;CENTERING FLAG (FF=OFF)
	ENDW
	MFILE	NAME,PARM1,2
	JNZ	ERROR1		;FOR EOF
	MFILE	NAME,CRLF,2
	JNZ	ERROR1
	STA	X		;TO ZERO IT
	DOWHILE	X,NEQ,%'['
	  GET	N,'.SP6',CR,LF>
	WHEN	CENTER,NEQ,0FFH
	  PUTSTR	ENV,<'.LL73',CR,LF,'.CE',CR,LF>
	  PUTSTR	LTR,<'.SP3',CR,LF>
	ENDW
	WHEN	CENTER,EQL,0FFH
	  PUTSTR	ENV,<'.IN30',CR,LF>
	ENDW
	MFILE	NAME,PARM2,4
	JNZ	ERROR2		;FOR EOF
	MFILE	NAME,CRLF,2
	JNZ	ERROR2
	STA	X		;TO ZERO IT
	DOWHILE	X,NEQ,%'['	;UNTIL SALUT START
	  GET	NAME
	  STA	X
	  WHEN	X,NEQ,%'['
	    LDA	X
	    PUT	LTR
	    LDA	X
	    PUT	ENV
	  ENDW
	  WHEN	X,EQL,%LF
	    PUTSTR	LTR,<'.BR',CR,LF>
	    LDA		CENTER
	    CPI		0FFH
	    JNZ		PASS3
            PUTSTR	ENV,<'.BR',CR,LF>
PASS3:	    LDA		CENTER
	    CPI		0FFH
	    JZ		PASS4
            PUTSTR	ENV,<'.CE',CR,LF>
PASS4:	  ENDW
	ENDDO
; SALUTATION FOUND
	PUTSTR	LTR,<'.SP2',CR,LF>
	WHEN	CENTER,NEQ,0FFH
	  PUTSTR	ENV,<CR,LF>
	ENDW
	DOWHILE	X,NEQ,%']'
	  GET	NAME
	  STA	X
	  WHEN	X,NEQ,%']'
	    LDA	X
	    PUT	LTR
	  ENDW
	ENDDO
;
; SKIP REST OF BODY FIELDS IN NAMES
; [ZZ9] IS UNUSED DUMMY
;
	MFILE	NAME,'[ZZ9]'
	JNZ	ERROR2		;FOR EOF
;
; FIND TAIL IN NAMES & RROR:	PRINT	<' ERROR',CR,LF>
	JMP	0
;
; PARAMETER STORAGE
;
PARM1:	DS	1
	DB	']'
PARM2:	DS	3
	DB	']'
PARM3:	DS	1
	DB	']'
X:	DB	0		;DOWHILE VARIABLE
CRLF:	DW	0A0DH
CENTER:	DB	0FFH		;CENTERING FLAG - 0FFH=OFF
;
; STACK
;
	DS	64
STACK:
BUFFERS:
MEMSIZE	EQU	BUFFERS+@NXTB	;PROGRAM SIZE
	END
                 Documentation for the files:
                          LETTER.ASM
                          LETTER.COM
                           NAMES.DAT
                           MYMAC.LIB


                       Robert C. Minnick
                            Box 306
                     Ouray, Colorado 81427



      These files are used to create a "null" letter  file  and
an  envelope  file for processing by the TEX program.  Required
for reassembly are the MAC macro-assembler  and  t information includes the to-addresses
and the salutations--the latter are in brackets.    Indices  to
the  bodies  are two letters and a digit.  The tail information
allows the choice of 10 possible terminations, with indices [0]
through [9].  Notice that the last  body  index  is  the  dummy
[ZZ9] and that the last datum in the file is "[".  

      Next, create   the  letter  and  envelope  files  by  the
command:  
     LETTER <parm1>,<parm2>,<parm3> 
where the  three  parameters  are  the  heportion of the letter text.  

      The system is  set  up  for  8.5"  x  11"  paper;  on  my
Selectric I align the typeball with the left edge of the paper,
and  start  with  the top of the paper just under the hold-down
bail.  The envelope is started with the top even with  the  top
of the ribbon.  

      One comment regarding the LETTER.ASM is that there appear
some jumps which could have been avoided by  additional  levels
of WHENs.  These were put in simply because I ran out of symbol
tablSTORE IN LTR
;
	PUTSTR	LTR,<CR,LF,'YY',CR,LF,'.SP2',CR,LF,'.IN39',CR,LF>
	MFILE	NAME,PARM3,2
	JNZ	ERROR3
	MFILE	NAME,CRLF,2
	JNZ	ERROR3
	DOWHILE	X,NEQ,%'['
	  GET	NAME
	  STA	X
	  WHEN	X,NEQ,%'['
	    LDA	X
	    PUT	LTR
	  ENDW
	ENDDO
;
; CLOSE FILES, RENAME & EXIT
;
DONE3:	FINIS	<LTR,ENV>
	ADDNAM	LTR,PARM2,3
	ADDNAM	ENV,PARM2,3
	JMP	0
;
; ERRORS
;
ERROR1:	PRINT
	PRINT	'PARAMETER 1'
	JMP	ERROR
ERROR2:	PRINT
	PRINT	'PARAMETER 2'
	JMP	ERROR
ERROR3:	PRINT
	PRINT	'PARAMETER 3'
Ehe  MACRO.LIB
(User's Group 24.4). If MAC is not available, LETTER.COM should
run (in about 4K).  If MACRO.LIB is not available, the MOVE and
PRINT  macros  used in LETTER.ASM should be obvious, and can be
re-written.  

      First, the NAMES.DAT file should  be  prepared.    Header
data allow several alternative return addresses as shown in the
sample.  Headers [0] through [4] left-justify this information,
while  headers  [5]  through  [9]  use  [n-5]  and  center  the
information.    The  bodyad,  body  and  tail,
respectively.    Files EE<parm2>.TEX  and LL<parm2>.TEX will be
formed.  The EE file can be used to prepare the envelope (legal
sized) directly with TEX EE<parm2> $L.  The LL file  is  to  be
further  processed  using  the EDitor.  Note that "XX" and "YY"
appear in LL for easy ED searching, using for instance the N, F
or S commands.  

      By having certain standard paragraphs ( .LIB)  available,
the  R  command in the EDitor becomes useful for quick assembly
of at least a e  space in my 36K system.  I'd be interested in hearing if
someone with a larger system can eliminate them successfully. 
; ==========================================
; : M Y M A C  -  RCM MACRO LIBRARY        :
; :    VERSION 2.0      7/10/78            :
; :        R. C. Minnick                   :
; :          Box 306                       :
; :      Ouray, Colorado 81427             :
; ==========================================
;
; *********************
; *   F I N D P A R   *   -   FIND NEXT PARAMETER
; *********************
; FIND NEXT PARM IN TBUFF.  IF BEYOND THE PARM
; FIELD, RETURN CY=1.  IF WITHIN, RETU LOCATE FIRST CHAR GEQ 30H.  CALL WITH HL
;; POINTING 1 BELOW FIELD & WITH B=REMAINING LENGTH
;; FOR ENTIRE PARM FIELD.
LOCH:	XRA	A	;;CLEAR CY
	INX	H	;;PTR
	DCR	B	;;LENGTH
	JNZ	$+5	;;STILL IN FIELD
	STC
	RET		;;BEYOND FIELD
	MOV	A,M	;;DATUM
	CPI	30H
	JC	LOCH
	RET		;;HL POINTS TO FIRST DATUM GEQ 30H
;; LOAD 1+REMAINING STRING LENGTH TO B & CURRENT PTR TO HL
;;
PTR:	DW	80H	;;CURRENT PTR
LENG:	DS	1	;;CURRENT STRING LENGTH
;;
@FINDP:	LDA	LENG	;;LOAD REGISTERS
	MOV	B,A
	LHLD	PTR
	CALL	LOCL	;***********
; *   M F I L E   *  -  MATCH FILE
; *****************
;
; COMPARE STRING AGAINST SEQUENTIAL INPUT FILE STARTING AT FILE'S
; PRESENT POSITION.  NOTE: MUST USE FILE MACRO PRIOR TO
; USING MFILE MACRO.
;
; MFILE FILEID,'LITERAL STRING'
; MFILE FILEID,STRINGPOINTER,STRINGLENGTH
; MFILE FILEID
;
; (IN LAST, ASSUME HL=STRINGPOINTER & C=STRINGLENGTH LOADED)
;
; RETURNS ZF=1 FOR MATCH, WITH SEQUENTIAL FILE POSITIONED
; SO NEXT GET FINDS THE NEXT CHARACTER AFTER STRING.
; RETURNS ZF=0 IFUE MATCHING THIS STRING
FAIL:	POP	H
	POP	B
	JMP	@MFILE	;;START MATCHING ALL OVER
GOOD:	XRA	A
	POP	H
	POP	B
	RET
EOFI:	MVI	A,0FFH
	ORA	A
	POP	H
	POP	B
	RET
;;
OVERSUB:
MFILE	MACRO	?INF,?STR,?LEN
	LOCAL	LITSTR,ENDLIT
	LXI	H,GET&?INF
	SHLD	@MFSRX+1	;;SET UP PROPER CALL
	IF	NUL ?STR&?LEN
	CALL	@MFILE
	ELSE
	IF	NUL ?LEN	;;TEST FOR LITERAL
	MVI	C,ENDLIT-LITSTR	;;LIT STR LENGTH
	LXI	H,LITSTR	;;BASE OF LIT STR
	CALL	@MFILE
	JMP	ENDLIT
LITSTR:	DB	?STR
ENDLIT:
	ELSE
	IF	NOT NUL ?STR
	LXCB&FILEID+16,16
;; INSERT FIELD INTO NEW FCB
	MOVE	FIELDAD,FCB&FILEID+19,LEN
;; ERASE POSSIBLE OLD FILE
	LXI	D,FCB&FILEID+16
	MVI	C,19
	CALL	5
;; DO RENAME
	LXI	D,FCB&FILEID
	MVI	C,23
	CALL	5
	ENDM
;
;===============================================================
;
; ***********************
; *   G E T S T R       *  GET STRING FROM SEQUENTIAL FILE
; ***********************
;
; GET STRING FROM SEQUENTIAL FILE NAMED FILEID, AND PUT IT
; IN RAM STARTING AT PTR.  STRING IS OF LENGTH LENG
RN HL POINTING
; TO FIRST CHAR OF PARM, & BC=PARM LENGTH (B=0 ALWAYS).
; (NOTE THAT SCAN CAN BE MADE ONLY ONCE)
;
FINDPAR	MACRO
	LOCAL	OVER,LOCL,LOCH,PTR,LENG
	JMP	OVER
;; LOCATE FIRST CHAR LSS 30H. CALL WITH HL
;; POINTING 1 BELOW FIELD & WITH B=REMAINING LENGTH
;; FOR ENTIRE PARM FIELD.
LOCL:	XRA	A	;; CLEAR CY
	INX	H	;;PTR
	DCR	B	;;LENGTH
	JNZ	$+5	;;STILL IN FIELD
	STC
	RET		;;BEYOND FIELD
	MOV	A,M	;;DATUM
	CPI	30H
	JNC	LOCL
	XRA	A	;;CLEAR CY
	RET		;;HL POINTS TO FIRST CHAR LSS 30H
;;;NEXT LSS 30H
	RC		;;BEYOND PARM FIELD
	CALL	LOCH	;;NEXT GEQ 30H
	RC		;;BEYOND PARM FIELD
	SHLD	PTR	;;SAVE PTR
	MOV	A,B
	STA	LENG	;;SAVE PRESENT STR LENGTH
	PUSH	H	;;SAVE
	CALL	LOCL	;;NOW HL PTS TO END+1, CURRENT PARM
	MOV	A,L
	POP	H
	SUB	L	;;A=LENGTH, CURRENT PARM
	MOV	C,A
	MVI	B,0
	XRA	A	;;CLEAR CY
	RET
;;
OVER:	LDA	80H
	INR	A
	STA	LENG	;;SET UP ORIG LENGTH+1
;;
FINDPAR	MACRO
	CALL	@FINDP
	ENDM
	FINDPAR
	ENDM
;
;======================================================
;
; ****** EOF REACHED WITH NO MATCH.
;
MFILE	MACRO	FILEID,STRING,LENGTH
	LOCAL	MLOOP,FAIL,GOOD,EOFI,OVERSUB
	JMP	OVERSUB
;; FILE MATCH SUBROUTINE.  HL=RUNNING PTR, C=RUNNING LENGTH
@MFILE:	PUSH	B
	PUSH	H	;;SAVES
MLOOP:	INR	C	;;IN CASE C=0
	DCR	C
	JZ	GOOD	;;COMPLETE MATCH FOUND
	PUSH	B
	PUSH	H
@MFSRX:	CALL	GET&FILEID	;;SET UP BY FILE MACRO
	POP	H
	POP	B
	CPI	1AH
	JZ	EOFI	;;EOF DETECTED
	SUB	M
	JNZ	FAIL	;;CURRENT MATCH FAILED
	INX	H	;;THIS CHAR MATCHES
	DCR	C	;;REMAINING COUNT
	JMP	MLOOP	;;CONTINI	H,?STR
	ENDIF
	MVI	C,?LEN
	CALL	@MFILE
	ENDIF
	ENDIF
	ENDM
	MFILE	FILEID,STRING,LENGTH
	ENDM
;
;================================================================
;
; ***********************
; *   A D D N A M       *   ADD TO NAME MACRO
; ***********************
;
; ADD TO NAME.  INTO NAME POSITION 3-8 INSERTS FIELD REFERENCED
; BY POINTER FIELDAD, AND OF LENGTH LEN.
;
; REQUIRES MACRO.LIB 
;
ADDNAM	MACRO	FILEID,FIELDAD,LEN
;; CREATE COPY OF OLD FCB, 16 BYTES HIGHER
	MOVE	FCB&FILEID,F;
; SYNTAX:      GETSTR	FILEID,PTR,LENG
;
GETSTR	MACRO	FILEID,PTR,LENG
	LOCAL	OVER
	JMP	OVER
@GETSR:	INR	C
	DCR	C	;;IN CASE C=0
	RZ		;;DONE
	PUSH	H
	PUSH	B
@GTSRX:	CALL	GET&FILEID
	POP	B
	POP	H
	MOV	M,A	;;STORE
	INX	H
	DCR	C
	JMP	@GETSR
OVER:
GETSTR	MACRO	?FID,?STR,?LEN
	LXI	H,PUT&?FID
	SHLD	@GTSRX+1	;;SET UP PROPER CALL
	LXI	H,?STR
	MVI	C,?LEN
	CALL	@GETSR
	ENDM
	GETSTR	FILEID,PTR,LENG
	ENDM
;
;================================================================
;
; **********************
; *   P U T S T R      *  PUT STRING TO SEQUENTIAL FILE
; **********************
;
; HL=POINTER TO STRING, C=STRING LENGTH
; SYNTAX:
;
; PUTSTR	FILEID,'LITERAL STRING'
; PUTSTR	FILEID,POINTER,LENGTH
; PUTSTR	FILEID
;
PUTSTR	MACRO	FILEID,PTR,LENG
	LOCAL	OVER
	JMP	OVER
@PUTSR:	INR	C
	DCR	C	;;IN CASE C=0
	RZ		;;DONE
	MOV	A,M	;;DATUM
	PUSH	H
	PUSH	B
@PTSRX:	CALL	PUT&FILEID
	POP	B
	POP	H
	INX	H
	DCR	C
	JMP	@PUTSR
OVER:
PUTSTR	MACRO	?FID,?STR,?LEN
	LOCAL	LITSTR,ENDLIT
	LXI	H==============================================
: N A M E S     F I L E    V1.0     7/12/78  :
          Robert C. Minnick
             Box 306
        Ouray, Colorado 81427
==============================================

(NOTE: This is a sample only)

[0]
Box 306
836 Fourth Street
Ouray, Colorado 81427
[1]
Box 306
Ouray, Colorado 81427
[2]
MINNICK ENGINEERING CO.
P.O. Box 306
836 Fourth Street
Ouray, Colorado 81427
[3]
MINNICK ENGINEERING CO.
P.O. Box 306
Ouray, Colorado 81427
[GO1].SP4
.QI
/RCM/Luke I
[9]
[
;                ==========================
;                *     S T A T P C H      *
;                ==========================
;
; VERSION 1.0       4/13/78
; R.C. Minnick - Box 306 - Ouray, CO 81427
;
; CHANGES NAMES OF PHYSICAL DEVICES
; FOR VERSION 1.4 STAT.
; SEE TABLE ON P 15 OF "INTRODUCTION"
; (The names I have chosen here are particular to my system;
; they should be changed appropriate to yours.)
;
; TO MAKE PATCH:
; (1) ASSEMBLE STATPCH
; (2)     DDT STAT.COM
;         -ISTATP;V2.0
;CAT.ASM - PERFORMS DIR FUNCTION ON MAST.CAT
;11/??/77 WRITTEN BY WARD CHRISTENSEN
;01/07/78 MODIFY FOR NON-BASIC MASTER CAT
;01/08/78 MODIFY TO SKIP IGNORE FILENAMES
;TO EXECUTE:
;	CAT FILENAME.FILETYPE DISKNAME.DISKTYPE
;COMMAND MAY BE FOLLOWED BY COMMENTS (TITLE)
;MAST.CAT M-U-S-T HAVE IGNORE FILENAMES FIRST
;EG:	(NAME.TYPE
;	NAME.TYPE
;	LASTNAME.TYPE)
	ORG	100H
	CALL	START
	DB	'CAT.COM 1/8/78'
	DB	0DH,0AH,'$'
;PRINT ID MESSAGE
START	POP	D
	MVI	C,PRINT
	CALL	BDOS
;INIT LOCAL STA,PUT&?FID
	SHLD	@PTSRX+1	;;SETUP PROPER CALL
	IF	NUL ?STR&?LEN	;;EVERYTHING LOADED
	CALL	@PUTSR
	ELSE
	IF	NUL ?LEN	;;LITERAL
	MVI	C,ENDLIT-LITSTR
	LXI	H,LITSTR
	CALL	@PUTSR
	JMP	ENDLIT
LITSTR:	DB	?STR
ENDLIT:
	ELSE
	IF	NOT NUL ?STR
	LXI	H,?STR
	ENDIF
	MVI	C,?LEN
	CALL	@PUTSR
	ENDIF
	ENDIF
	ENDM
	PUTSTR	FILEID,PTR,LENG
	ENDM
;
;===============================================================

Mr. Anthony R. Gold
CP/M User's Group
164 West 83rd. Street
New York, N.Y. 10024
[Dear Tony,]
[MI5]
Dr. Robert C. Minnick
Box 306
Ouray, Colorado 81427
[Dear Bob,]
[ZZ9] (DUMMY)
[0]
.CP7
Yours sincerely,
.SP4
Robert C. Minnick
.QI
/RCM/Luke I
[1]
.CP7
Sincerely,
.SP4
Robert C. Minnick
.QI
/RCM/Luke I
[2]
.CP7
Yours truly,
.SP4
Robert C. Minnick
.QI
/RCM/Luke I
[3]
.CP6
Sincerely,
.SP4
.QI
/RCM/Luke I
[4]
.CP6
Best regards,
.SP4
.QI
/RCM/Luke I
[5]
.CP6
Love,
CH.HEX
;         -R
;         -^C
; (3) SAVE 12 STAT.COM
;
	ORG	142H
;
	DB	'DUR:VDM:BAT:XXX:'
	DB	'DUR:PTR:KCI:TBI:'
	DB	'DUR:PTP:KCO:TBO:'
	DB	'DUR:VDM:POT:YYY:'
;
	END
CK
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
;SAVE THE NAMES
	LXI	D,FCB+1
	LXI	H,FNAME
	MVI	B,8
	CALL	MOVER
	MVI	B,3
	CALL	MOVER
	LXI	D,FCB+17 ;DISK NAME
	LXI	H,DNAME
	MVI	B,8
	CALL	MOVER
	MVI	B,3
	CALL	MOVER
;MOVE 'MAST.CAT' TO FCB
	LXI	D,FCBNAME
	LXI	H,FCB+1
	MVI	B,8+3+1
	CALL	MOVE
;SAVE THE COMMAND LINE AS THE TITLE
;ALLOWS 'CAT *.* *.* MM/DD/YY' TYPE TITLE
;FOR HARD COPY LISTINGS
	LXI	D,80H
	LXI	H,TTL0+6
	LDAX	D	;GET LENGTH
	ORA	A	;NO OPERANDS ON CAT?
	JZ	NOOP
	INX	D
	MOV	B,A	;SET FOR MOVE
	CALL	MOVE
NOOP	MVI	M,'$'	;END OF TITLE
;OPEN MAST.CAT
	LXI	D,FCB
	MVI	C,OPEN
	CALL	BDOS
	INR	A
	JNZ	SKPIGN	;SKIP THE 'TO BE IGNORED' NAMES
;OPEN FAILED
	CALL	ERXIT
	DB	'++UNABLE TO OPEN MAST.CAT$'
;EXIT PRINTING MSG ON TOP OF STACK
ERXIT	POP	D	;GET ERR MSG
	MVI	C,PRINT
	CALL	BDOS
;RESTORE STACK, EXIT
EXIT	LHLD	STACK
	SPHL
	RET
;
;SKIP THE IGNORE FILENAMES AT THE HEAD OF MAST.CAT
;
SKPIGN	CALL	RDCHR
	CPI	')'	;END OF IGNORE?
	JNZ	SKPIGN
	CALL	RDCHR	;GET CR
	CALL
;MATCH FILETYPE
	MVI	B,3	;TYPE
	CALL	MATCH
	JC	SKIP
;SKIP PAST COMMA
;MATCH DISK'S FILENAME
	LXI	D,BUFF+15
	LXI	H,DNAME
	MVI	B,8
	CALL	MATCH
	JC	SKIP
	INX	D	;ALLOW FOR '.'
;MATCH DISK'S FILETYPE (NUMBER)
	MVI	B,3
	CALL	MATCH	;TYPE
	JC	SKIP
;
;GOT MATCHING NAME
;
	LXI	H,BUFF
;PRINT MESSAGE UP TO BINARY 0
PRBUF	MOV	A,M
	ORA	A	;END OF BUFF?
	JZ	EOBUF
	CALL	TYPE
	INX	H
	JMP	PRBUF
EOBUF	LDA	ENTRY
	INR	A
	ANI	1
	STA	ENTRY
	JNZ	SKIP
	CALL	CRLF
	LDA	LINECT
	INR	A
	STA	LINECT
	C
	JZ	MAT100
	MOV	A,M	;MATCHING '?'
	CPI	'?'
	JZ	MAT25
MAT75	MVI	A,' '	;PAD
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	MAT75
	STC		;SHOW BAD
	RET
MAT100	MOV	A,M
	CPI	'?'
	JZ	MAT200
	CPI	' '
	JNZ	MAT75
MAT200	MVI	A,' '
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	MAT100
	ORA	A	;MATCH
	RET
;
;READ CHAR FROM DISK
;
RDCHR	PUSH	B
	PUSH	D
	PUSH	H
	LHLD	BUFAD
	MOV	A,H	;TIME TO READ?
	DCR	A
	JNZ	NOREAD
	LXI	D,FCB
	MVI	C,READ
	CALL	BDOS
	ORA	A
	JZ	RDOK
	CALL	ERXIT
	DB	'++READ ERROR OR EARLY EOF$'
	JNZ	MOVE
	RET
;
;PAD FILENAME OR TYPE WITH ALL '?'
;
QUEST	MVI	M,'?'
	INX	H
	INX	D
	DCR	B
	JNZ	QUEST
	RET
;
EOF	CALL	ERXIT
	DB	0DH,0AH,'L'-40H,'$'
	DS	50	;STACK
STACK	DW	0
FNAME	DS	8
FTYPE	DS	3
DNAME	DS	8
DTYPE	DS	3
FCBNAME	DB	'MAST    CAT',0 ;0 = EXTENT #
ENTRY	DB	0	;0/1 = LEFT, RIGHT
BUFAD	DW	100H	;BUFFER PONTER
TTL	DB	'  NAME           DISK         '
	DB	'  NAME           DISK'
	DB	0DH,0AH,'$'
BUFF	DB	'............   ............   ',0
LINECT	DB	0
TTL0	DB	'FILES:'
;		(COMMA(THIS IS FILE CATALOG.DOC AS OF 3/13/78)

CP/M DISK CATALOGING SYSTEM FOR COMPUTER HOBBYISTS
                BY WARD CHRISTENSEN

                -----OVERVIEW-----

I have always wanted to be able to keep track of
where files are on my CP/M diskettes.  The first
step was to make a 'DIR' listings with the printer on.

Next I wrote a command called 'MAP' which printed the
disk extent information also (but not any extent past
the first).  Then I wrote 'SMAP' which produces a sorted
directory lis	RDCHR	;GET LF
	JMP	NEWPG1
;
NEWPG	MVI	A,'L'-40H ;FORMS FEED
	CALL	TYPE	;EJECT
;PRINT TITLE
NEWPG1	LXI	D,TTL0
	MVI	C,PRINT
	CALL	BDOS
	CALL	CRLF
	CALL	CRLF
	LXI	D,TTL
	MVI	C,PRINT
	CALL	BDOS
	CALL	CRLF
;RESET LINECOUNT
	MVI	A,5
	STA	LINECT
;MATCH A LINE, PRINT IF IT MATCHES
;EXIT IF KEY PRESSED
LOOP	MVI	C,KSTAT
	CALL	BDOS
	DCR	A
	JZ	EXIT
;MATCH FILENAME
	LXI	D,BUFF	;WHERE TO STORE NAME READ
	LXI	H,FNAME
	MVI	B,8
	CALL	MATCH
	JC	SKIP	;NAME/TYPE DIDN'T MATCH
	INX	D	;ALLOW FOR '.'PI	58
	JC	SKIP
	CALL	SKIPLF
	JMP	NEWPG
;
SKIP	CALL	SKIPLF
	JMP	LOOP
;SKIP TO END OF LINE (L/F)
SKIPLF	CALL	RDCHR
	CPI	0AH	;SKIP TO END
	JNZ	SKIPLF	;OF LINE
	RET
;
;MATCH ENTRY BY READING CHARS
;STORE IN BUFFER POINTED TO BY DE
;MATCH NAME POINTED TO BY HL
;
MATCH	CALL	RDCHR
	STAX	D
	CMP	M
	JNZ	MAT50	;CHECK '?'
MAT25	INX	D
	INX	H
	DCR	B	;MORE?
	JNZ	MATCH
	CALL	RDCHR	;DELETE '.' OR '"'
	ORA	A	;CARRY OFF, SHOWS OK
	RET
MAT50	CPI	'.'	;END OF NAME?
	JZ	MAT100
	CPI	','	;END OF NAME?

RDOK	LXI	H,80H
NOREAD	MOV	A,M	;GET CHAR
	INX	H
	SHLD	BUFAD
	POP	H
	POP	D
	POP	B
	CPI	'Z'-40H	;EOF?
	JZ	EOF
	RET
;
CRLF	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
;
TYPE	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A
	MVI	C,WRCON
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
;
;MOVER - MOVE CHARS FROM (DE) TO (HL), LENGTH IN (B)
;	IF FIRST CHAR = ' ', MOVE ALL '?'
;
MOVER	LDAX	D
	CPI	' '
	JZ	QUEST
;
;MOVE CHARS FROM (DE) TO (HL) FOR LENGTH IN (B)
;
MOVE	LDAX	D	;GET A CHAR
	MOV	M,A
	INX	D
	INX	H
	DCR	B
ND TITLE MOVED HERE)
; * * * * * * * * * * * * * * * * * * * * * * * *
;						*
;BDOS/CBIOS EQUATES (VERSION 5)			*
;(WITH UNREFERENCED EQUATES EDITED OUT)		*
;						*
WRCON	EQU	2	;			*
PRINT	EQU	9	;			*
KSTAT	EQU	11	;1=KEY PRESSED		*
OPEN	EQU	15	;0FFH=NOT FOUND		*
READ	EQU	20	;0=OK, 1=EOF		*
BDOS	EQU	5	;			*
FCB	EQU	5CH 	;			*
; * * * * * * * * * * * * * * * * * * * * * * * *
ting.  This made finding files in the listings
easier.  At this time I also adopted the convention of
editing a 'dummy' file on each disk, called '-DISK.nnn'
where nnn is the disk's serial number.  Later I changed
the word 'DISK' to any more meaningful name, such as
'-WORK.023' or '-CBIOS.019', etc.  The important
thing was that each started with a '-' which meant it
would sort to the top of the sorted listing.

Eventually, I wrote 'FMAP' which creates a sorted
directory listing, but also, if 'FMAP *.* F' is typed,
writes 'NAMES.SUB' to disk with the names of all the
files on the disk.

This file of names then got me thinking about having
a master file of names, or a 'master catalog'.

That is what I did.  I now have 1 disk file which
contains the file names and disk names for every
pertinent file I have.  I also wrote a command
which behaves like 'DIR' but scans the master catalog.

                -----PROGRAMS-----

UCAT.ASM/COM  Maintains 'MAST.CAT'

CAT.ASM/COM   Allows 'DIR' seevery disk, I therefore don't want them to take room in the
catalog.  N-O-T-E you don't have to edit the file -
you may type it and decide to take my defaults.
NOTE The format of the 'empty' MAST.CAT is simply
a list of names which you don't want put in the catalog.
This may be 1 or more file names.  It cannot be zero names.
If you want everything cataloged, put a name such as
'DUMMY.FIL' in the catalog.  The format is as follows:
Each name is on a separate line.  The first name is pre-
ceeded by aUB, which has the names of
the files on this disk.  The 'q' means to write the file
to disk 'quietly'.  If you want to see the listing, type:
        FMAP A: F
Which will write the file, but also print the sorted
directory listing.

5)      Type: UCAT
This will merge the file names in 'NAMES.SUB' (created by
FMAP) with the names in MAST.CAT.  It will report the names
of any files which are added to, or deleted from, the
catalog.

        -----USING THE CATALOGING SYSTEM-----

1)      Wheneverhe catalog programs is
on drive a, whenever you want to catalog the disk on
drive b, type:
        FMAP B: Q
 then type:
        UCAT
This results in the disk being added to the catalog. 
This can be done whenever you want, as the entries for the
disk are deleted from MAST.CAT and the new ones added. 
This means the cataloging system properly keeps track of
erased files also (i.e. erases them from the catalog when
it no longer finds them on the disk being cataloged). If
you want to re-catalog th                  lists entire catalog
CAT *.* *.002           lists entries for disk 002
CAT *.asm               lists all asm files
CAT A*.*                lists all files starting with 'A'
CAT *.BAS WORK.*        lists all 'BAS' files on any
                        disk with name 'WORK' (any serial)

Note that what you type following the CAT command appears
as the title of the resultant listing.  This is particularly
useful for keeping hard copy listings of your catalog, such
as by typing:

 arch of 'MAST.CAT'

FMAP.ASM      Creates a file of the names on a diskette
              as input to 'UCAT.COM' along with 'MAST.CAT'
              FMAP is on CP/M library volume 8 as program
              number 8.14


        -----INSTALLING THE CATALOGING SYSTEM-----

1)      Edit 'MAST.CAT' in order to place entries
in it for the file names you don't want to be placed in
the catalog.  I already have ASM.COM, STAT.COM, PIP.COM,
and others in the sample MAST.CAT.  Since these are on nearly
 '('.  The last is followed by ')'. thus:
(ASM.COM
PIP.COM
STAT.COM)

2)      Pick a disk which will contain the master
catalog 'MAST.CAT'.  You m-u-s-t serial number (3 digits)
all your diskettes, placing a file '-anyname.nnn' on
each disk.  The UCAT routine then takes this as the name
of the disk.

3)      Put the following files on this master disk:
        MAST.CAT
        FMAP.COM
        UCAT.COM
        CAT.COM
        -anyname.nnn

4)      Type: FMAP A: Q
This will creates NAMES.S you put a new diskette into service
you must place a '-anyname.nnn' entry in the directory.
nnn should be the disk's unique serial number.  The easiest
way to place an entry in the directory, with 0 data as-
sociated with it is to 'ED -anyname.nnn' then when
'NEW FILE' types, type control-c.  This will leave the
entry in the catalog, but will not take any data space.
Then type:ERA *.$$$ (or ERA B:*.$$$) to erase the temporary
file which was created by the editor.

2)      Assuming the disk with te 'A' disk, type:
        FMAP A: Q
then type:
        UCAT

3)      Use the 'CAT' command to scan the catalog
as you use 'DIR' to scan the directory of the current
disk.  The operands of 'CAT' are just like 'DIR' except
that there is a second filename.type - namely the disk's name
and serial.  N-O-T-E that UCAT deletes the leading '-'
when it places a disk name in the directory.  Therefore
you don't use the '-' when asking for a particular disk.


Examples of 'CAT' command requests:

CAT          CAT *.* *.* AS OF 02/17/78

this will result in the title:

        FILES: *.* *.* AS OF 12/17/77

appearing on each page of the catalog listing.

4)      If you want to erase something from MAST.CAT
you do so by erasing the file from the diskette it is
on, then cataloging that disk.  If you crash a disk and
want to erase all it's entries from the catalog, you have
to edit a dummy 'NAMES.SUB' with just the disk name in it,
then execute 'UCAT' which will be faked into thinking you
are cataloging an empty disk.  This will cause all entries
for the disk to be erased.

                EXAMPLE:
Suppose disk '-WORK.023' crashed, and you want to delete
all references to it from MAST.CAT.  (you might first want
to do 'CAT *.* *.023 to see what was lost).  Edit NAMES.SUB
and place the following single line in it:
-WORK.023
then run UCAT.  This will result in all files referring to
-WORK.023 being erased.

-------------------------------------------------
                N O T E S
--- could
also be modified, to do the erase first.




-------------------------------------------------
-------------------------------------------------


QCAT was submitted subsequently, with the following comments:

QCAT allows cataloging disks on a 1 disk system.
You type QCAT, and the program asks you to mount the
disk to be cataloged, and press a D.  You do so.  It
then tells you to mount the catalog disk, and press return.
You do that.  This causes a "NAMES.SUB" file to be written
to t
You are referred to the previous documentation on the
cataloging system for more details.

------
; BASIC INPUT/OUTPUT OPERATING SYSTEM
; TARBELL ELECTRONICS
; 4-DRIVE VERSION OF 2-15-78
; (NOTE THAT CP/M VERSION 1.3 ONLY SUPPORTS 2 DRIVES,
; WHILE CP/M VERSION 1.4 WILL SUPPORT 4 DRIVES.)
;
; THIS MODULE CONTAINS ALL THE INPUT/OUTPUT
; ROUTINES FOR THE CP/M SYSTEM, INCLUDING
; THE DISK ROUTINES.
;
MSIZE	EQU  24		;MEMORY SIZE.

; THIS SECTION DEFINES THE I/O PORTS AND
; STATUS BITS.  BY SETTING THE PROPER VALUES
; FOR THE EQU STATEMENTS, THE I/O MAY BE
; AUTOMATICALLY RECONFIGURED TO FIT MMSIO2 OR ISIO2 OR TUART
OTHER	EQU  FALSE	;TRUE IF SOMETHING ELSE.

CSTAT	EQU  0		;CONSOLE STATUS PORT.
CCOM	EQU  0		;CONSOLE COMMAND PORT.
CDATA	EQU  1		;CONSOLE DATA PORT.

	IF   STD	;IF STANDARD I/O,
CKBR	EQU  00000001B	;KEYBOARD READY BIT.
CPTR	EQU  10000000B	;CONS OUTPUT RDY BIT.
	ENDIF

	IF   MSIO2	;IF MITS 2SIO,
CKBR	EQU  00000001B	;KEYBOARD READY BIT.
CPTR	EQU  00000010B	;PRINT READY BIT.
	ENDIF

	IF   ISIO2	;IF IMSAI SIO-2,
CKBR	EQU  00000010B	;KEYBOARD READY BIT.
CPTR	EQU  000000----------------------------------------------

The UCAT program creates a file 'NEW.CAT', and ONLY
when the update appears to be successful, does it do
the following functions internally:

        ERA MAST.BAK
        REN MAST.BAK=MAST.CAT
        REN MAST.CAT=NEW.CAT

Thus, there are 3 versions of the catalog on your disk at
one time:  MAST.BAK, MAST.CAT, AND NEW.CAT, so if your disk
is low on space, you may sacrifice this integrity, and manually
ERA MAST.BAK before running UCAT.  The programhe catalog disk.  Type: UCAT which will then execute the
catalog updating program, which alphabetically merges
NAMES.SUB with the file MAST.CAT, then erases the NAMES.SUB
file.

NOTE that each disk to be cataloged must have a file
"-diskname.serial" (such as "-MAC.005").  When the list
of names on the disk is sorted, the leading "-" on this
filename causes it to be sorted first.  It is then taken
as the disk name and serial, and is written to the master
catalog next to each filename on the disk.
OST
; SITUATIONS.  THE TRUE AND FALSE ONES
; CONTROL CONDITIONAL ASSEMBLIES OF DIFFERENT
; SECTIONS OF I/O ROUTINES TO FIT DIFFERENT
; INTERFACE REQUIREMENTS.

TRUE	EQU  0FFFFH	;DEFINE VALUE OF TRUE.
FALSE	EQU  NOT TRUE	;DEFINE VALUE OF FALSE.

INTRP	EQU  FALSE	;TRUE IF INTERRUPTS ALLOWED.

STD	EQU  TRUE	;TRUE IF STANDARD I/O.
MSIO2	EQU  FALSE	;TRUE IF MITS 2SIO.
ISIO2	EQU  FALSE	;TRUE IF IMSAI SIO-2.
TUART	EQU  FALSE	;TRUE IF CROMEMCO TUART.
VDM	EQU  FALSE	;TRUE IF PROC TECH VDM.
SIO2	EQU  01B	;PRINT READY BIT.
	ENDIF

	IF   TUART	;IF CROMEMCO TUART,
CKBR	EQU  01000000B	;KEYBOARD READY BIT.
CPTR	EQU  10000000B	;PRINT READY BIT.
	ENDIF

	IF OTHER	;IF SOMETHING ELSE,
CKBR	EQU  00000010B	;KEYBOARD READY BIT.
CPTR	EQU  10000000B	;PRINTER READY BIT.
	ENDIF

CNULL	EQU  1		;CONSOLE NULL COUNT.

LSTAT	EQU  2		;LIST STATUS PORT.
LCOM	EQU  2		;LIST COMMAND PORT.
LDATA	EQU  3		;LIST DATA PORT.
LRBIT	EQU  CPTR	;LIST READY BIT.
LNULL	EQU  2		;LIST NULL COUNT.

DUAL	EQU  FALSE	;TRUE IF DUAL DRIVE.
FAST	EQU  FALSE	;TRUE IF FAST SEEK.

DISK	EQU  0F8H	;DISK BASE ADDRESS.
DCOM	EQU  DISK	;DISK COMMAND PORT.
DSTAT	EQU  DISK	;DISK STATUS PORT.
TRACK	EQU  DISK+1	;DISK TRACK PORT.
SECTP	EQU  DISK+2	;DISK SECTOR PORT.
DDATA	EQU  DISK+3	;DISK DATA PORT.
WAIT	EQU  DISK+4	;DISK WAIT PORT.
DCONT	EQU  DISK+4	;DISK CONTROL PORT.

RTCNT	EQU  10		;RETRY COUNT.

	ORG  MSIZE*1024-1536	;FIRST ADDRESS.

CBASE	EQU  (MSIZE-17)*1024  ;BIAS FOR LARGER THAN 17K.
CPMB	EQU  CBASE+2900H	;START OF CPMARACTER.
	JMP  CONOT	;WRITE CONSOLE CHARACTER.
	JMP  LIST	;WRITE LISTING CHAR.
	JMP  PUNCH	;WRITE PUNCH CHAR.
	JMP  READER	;READ READER CHAR.
	JMP  HOME	;MOVE DISK TO TRACK ZERO.
	JMP  SELDSK	;SELECT DISK DRIVE.
	JMP  SETTRK	;SEEK TO TRACK IN REG A.
	JMP  SETSEC	;SET SECTOR NUMBER.
	JMP  SETDMA	;SET DISK STARTING ADR.
READN:	JMP  READ	;READ SELECTED SECTOR.
WRITEN:	JMP  WRITE	;WRITE SELECTED SECTOR.
; THESE ENTRY POINTS ADDED BY TARBELL ELECTRONICS.
	JMP  READN	;READ WITH NO HEAD LOAD.
	JMP  WMVI  A,3	;INITIALIZE 2SIO.
	OUT  CCOM
	OUT  LCOM
	MVI  A,11H
	OUT  CCOM
	OUT  LCOM
	ENDIF

	IF   ISIO2	;IF IMSAI SIO2,
	MVI  A,0AAH	;INITIALIZE SIO 2-2.
	OUT  CCOM
	MVI  A,40H
	OUT  CCOM
	MVI  A,0CEH
	OUT  CCOM
	MVI  A,37H
	OUT  CCOM
	ENDIF

	IF   TUART	;IF CROMEMCO TUART,
	MVI  A,1	;SET A = 1.
	OUT  54H	;SELECT DEVICE A.
	OUT  52H	;RESET DEVICE B.
	LXI  H,BAUDRS	;GET ADR OF BAUD RATE TABLE.
	MVI  A,11H	;OCTUPLE THE CLOCK.
IT1:	OUT  02H	;& RESET CURRENT DEV.
	MOV  A,M	;GET BAUD RAT
	SHLD 1
	STA  5
	LXI  H,BDOS	;PUT JUMP TO BDOS
	SHLD 6		;AT ADR 5,6,7.
	LXI  H,80H	;SET DEFAULT DMA ADR.
	SHLD DMAADD
	LDA  DISKNO	;GET DISK NUMBER TO
	MOV  C,A	;PASS TO CCP IN C.
	JMP  CPMB	;JUMP TO CCP.

	IF   TUART	;IF CROMEMCO TUART,
BAUDRS:	DB   94H,0CEH,0A2H,92H,88H,84H,82H,1
	ENDIF

;
; WARM-BOOT:  READ ALL OF CPM BACK IN
; EXCEPT BIOS, THEN JUMP TO CCP.
;
WBOOT:   LXI SP,80H	;SET STACK POINTER.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	EI		;ALLOW THEM HERE.
	ENDIF

	LDA  DISKNO	;AT SECTOR IN C.
         CALL  READ1
RBLK1    JNZ  RDERR	;IF ERROR, PRINT MESSAGE.
         DCR  D		;DECREMENT SECTOR COUNT.
	JZ   ALDON	;ALL DONE WHEN ZERO.
         INR  C		;INCREMENT SECTOR NUMBER.
	 MOV  A,C	;IF SECTOR NUMBER
         CPI  27	;IS NOT 27,
         JC   RBLK2	;HOP OUT OF LOOP.
         MVI  C,1	;OTHERWISE, RESET SECTOR=1
         INR  B		;INCREMENT TRACK NUMBER,
         JMP  RDBLK	;AND READ NEXT TRACK.
ALDON:	LDA  TEMP	;RESTORE DISK NUMBER.

	IF  INTRP	;IF INTERRUPTS ALLOWE.
BDOS	EQU  CBASE+3106H	;START OF BDOS.
CPML	EQU  $-CPMB	;LENGTH OF CPM SYSTEM-BIOS.
NSECTS	EQU  CPML/128	;NUMBER OF SECTORS IN IT.
;
; I/O JUMP VECTOR
; THIS IS WHERE CPM CALLS WHENEVER IT NEEDS
; TO DO ANY INPUT/OUTPUT OPERATION.
; USER PROGRAMS MAY USE THESE ENTRY POINTS
; ALSO, BUT NOTE THAT THE LOCATION OF THIS
; VECTOR CHANGES WITH THE MEMORY SIZE.
;
	JMP  BOOT	;FROM COLD START LOADER.
WBOOTE:	JMP  WBOOT	;FROM WARM BOOT.
	JMP  CONST	;CHECK CONSOLE KB STATUS.
	JMP  CONIN	;READ CONSOLE CHRITEN	;WRITE WITH NO HEAD LOAD.
;
; BOOT
; THIS SECTION IS EXECUTED WHENEVER RESET AND RUN
; IS PUSHED, AFTER THE COLDSTART LOADER READS IN
; THE CPM SYSTEM.
;
BOOT:	LXI  SP,80H	;SET STACK POINTER.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	EI		;ENABLE THEM HERE.
	ENDIF

	IF   VDM	;IF PROC TECH VDM,
	CALL CLR	;CLEAR VDM SCREEN.
	ENDIF

	IF   STD	;IF STANDARD I/O,
	NOP!NOP!NOP!NOP	;LEAVE SPACE FOR INIT.
	NOP!NOP!NOP!NOP
	NOP!NOP!NOP!NOP
	NOP!NOP!NOP!NOP
	ENDIF

	IF   MSIO2	;IF MITS 2SIO,
	E FROM TABLE.
	OUT  0		;SET BAUD RATE.
	CALL CONIN	;READ KEYBOARD.
	CALL CONIN	;READ KEYBOARD AGAIN.
	CPI  0DH	;IF NOT CARRIAGE-RETURN,
	MVI  A,1	;SLOW THE CLOCK.
	JNZ  IT1	;UNTIL A CARRIAGE-RETURN.
	ENDIF

	LXI  H,SMSG	;PRINT OPENING MESSAGE.
	CALL PMSG
	CALL CONIN	;READ # OF DISKS.
	MOV  C,A	;ECHO THE CHAR.
	CALL CONOT
	ANI  7		;LOOK AT 3 LSB'S.
	STA  NODSKS	;SAVE IT.
	XRA  A		;SET DISK NUMBER = 0.
	STA  DISKNO
GOCPM:	MVI  A,0C3H	;PUT JMP TO WBOOT
	STA  0		;ADR AT ZERO.
	LXI  H,WBOOTE
SAVE DISK NUMBER.
	STA  TEMP
	MVI  C,0	;SELECT DISK ZERO.
	CALL SELDSK
	CALL HOME	;MOVE TO TRACK ZERO.
         JNZ  RDERR	;IF ERROR, PRINT MESSAGE.
         MVI  D,NSECTS	;GET # SECTORS FOR CPM READ.
         LXI  B,2	;TRACK (B)=0, SECTOR (C)=2.
         LXI  H,CPMB	;GET STARTING ADDRESS.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	DI		;DISABLE THEM HERE.
	ENDIF

RDBLK:   MOV  A,B	;GO TO TRACK IN B.
         CALL SEEK
         JNZ  RDERR	;IF ERROR, PRINT MESSAGE.
         MOV  A,C	;READ STARTING D,
	EI		;ALLOW THEM AGAIN HERE.
	ENDIF

	STA  DISKNO
	JMP  GOCPM	;GO BACK TO CPM.
;
RBLK2:   CALL READ2	;READ ANOTHER TRACK.
         JMP  RBLK1
;
RDERR:   LXI  H,BTMSG	;GET ADDRESS OF "BOOT ERROR".
         CALL PMSG	;PRINT IT.
         CALL CONIN	;READ A CHAR FROM CONSOLE.
         JMP  WBOOT	;DO A WARM BOOT.
;
; CHECK CONSOLE INPUT STATUS.
;

CONST:	IN   CSTAT	;READ CONSOLE STATUS.
	ANI  CKBR	;LOOK AT KB READY BIT.
	MVI  A,0	;SET A=0 FOR RETURN.

	IF   STD	;IF STANDARD I/O,
	RNZ		;NOT READY WHEN NOT 0.
	ENDIF

	IF SIO2		;IF MITS OR IMSAI,
	RZ		;NOT READY WHEN ZERO.
	ENDIF

	IF OTHER	;IF SOMETHING ELSE,
	RNZ		;IT MIGHT BE THIS.
	ENDIF

	CMA		;IF READY A=FF.
	RET		;RETURN FROM CONST.

;
; READ A CHARACTER FROM CONSOLE.
;
CONIN:   IN   CSTAT		;READ CONSOLE STATUS.
         ANI  CKBR	;IF NOT READY,

	IF   STD	;IF STANDARD I/O,
	JNZ  CONIN	;READY WHEN LOW.
	ENDIF

	IF SIO2		;IF MITS OR IMSAI,
	JZ   CONIN	;READY WHEN HIGH.
	ENDIF

	IF OTHER	;IF SOMETHING ELSE,
 CONOT1	;READY WHEN HIGH.
	ENDIF

	IF NOT VDM	;IF NOT PROC TECH VDM,
	MOV  A,C	;GET CHARACTER.
	OUT  CDATA	;PRINT IT.
	RET		;RETURN.
CONUL:	PUSH B		;SAVE B&C.
	MVI  B,CNULL	;GET NULL COUNT.
CONUL1:	CALL CONOT1	;PRINT CR.
	MVI  C,0	;GET NULL CHAR.
	DCR  B		;DECREMENT COUNTER.
	JNZ  CONUL1	;DO NEXT NULL.
	POP  B		;RESTORE B&C.
	MOV  A,C	;RESTORE A.
	RET		;RETURN.
	ENDIF

	IF   VDM	;IF PROC TECH VDM,
; VDM DRIVER FOR CBIOS.
; 9-24-77 VERSION
;
VDMB   EQU  0CC00H
VDMP   EQU  0CCH
VDMD    RET		;RETURN FROM CONOT.
;
;
SCREEN: MOV  B,A	;GET CHARACTER.
       MOV  A,B
       ANI  7FH		;NOT DELETE.
       CPI  0DH		;IF IT'S CR,
       JZ   CHOT2	;TAKE CARE OF IT.
       CPI  20H		;CTL CHAR?
       RC		;DON'T DISPLAY.
	JMP  CHOUT	;GO TO CHOUT.
;
; CLEAR SCREEN & INIT CURSOR.
;
CLR:   LXI  H,VDMB	;GET VDM MEM ADR.
       MOV  A,H		;FIGURE VDM MEM TOP.
       ADI  4
CLR2:  MVI  M,' '	;PUT SPACE IN MEMORY.
       INX  H		;INCREMENT POINTER.
       CMP  H		;AT TOP YET?
       JNZOUT  VDMD	;OUT TO VDM PORT.
       RET		;RETURN FROM VDMOT.
;
; STORE CHAR IN VDM MEMORY.
;
CHOUT: MOV  C,A		;SAVE CHARACTER.
       LDA  CCP		;GET CURSOR PTR.
       MOV  B,A		;PUT IN B.
       LDA  CLN		;GET LINE NUMBER.
       CALL CLNA	;CONVERT TO ADR.
       MOV  M,C		;PUT CHAR ON SCREEN.
       LDA  CCP		;ADVANCE CURSOR.
       INR  A
       CPI  64		;WRAP AROUND?
       JNZ  CHOT1
CHOT2: LDA  CCP		;GET CURSOR POS.
       MOV  B,A
       LDA  CLN		;GET LINE NUMBER.
       CALL CCUR	;
       JMP  VDMOT
;
; CONVERT LINE NUMBER IN REG A AND CHR
; POSITION IN REG B TO ADDRESS IN H&L.
;
CLNA:  MOV  L,A
       LDA  BOTL
       ADD  L
       RRC
       RRC
       MOV  L,A
       ANI  3
       ADI  VDMP
       MOV  H,A
       MOV  A,L
       ANI  0C0H
       ADD  B
       MOV  L,A
       RET
;
;
SCUR:  ANI  0FH
       STA  CLN
       CALL CLNA
       MOV  A,B
       STA  CCP
       LDA  CURF
       ORA  A
       MOV  A,M
       JZ   CCUR2
       ORI  80H
       	JNZ  CONIN	;IT MIGHT BE THIS.
	ENDIF

         IN   CDATA	;READ A CHARACTER.
         ANI  7FH	;MAKE MOST SIG. BIT = 0.
         RET
;
; WRITE A CHARACTER TO THE CONSOLE DEVICE.
;

	IF NOT VDM	;IF NOT PROC TECH VDM,
CONOT:	MVI  A,0DH	;IF IT'S A CR,
	CMP  C		;THEN HOP OUT
	JZ   CONUL	;TO NULL ROUTINE.
CONOT1:	IN   CSTAT	;READ CONSOLE STATUS.
	ANI  CPTR	;IF NOT READY,
	ENDIF

	IF STD AND NOT VDM  ;IF STANDARD I/O,
	JNZ  CONOT1	;READY WHEN LOW.
	ENDIF

	IF SIO2		;IF MITS OR IMSAI,
	JZ  EQU  0C8H
CONOT: MOV  A,C		;PUT CHAR IN A.
       SHLD HLSAV	;SAVE H&L.
       LXI  H,0		;CLEAR H&L.
       DAD  SP		;HL=SP.
       LXI  SP,VSTACK	;SET STACK PTR.
       PUSH H		;SAVE OLD SP.
       PUSH D		;SAVE D&E.
       PUSH B		;SAVE B&C.
       PUSH PSW		;SAVE A&PSW.
       CALL SCREEN	;WRITE ON SCREEN.
       POP  PSW		;RESTORE A&PSW.
       POP  B		;RESTORE B&C.
       POP  D		;RESTORE D&E.
       POP  H		;RESTORE H&L.
       SPHL		;RESTORE SP.
       LHLD HLSAV	;RESTORE H&L.
        CLR2	;KEEP GOING IF NOT.
       XRA  A		;SET A = 0.
       STA  BOSL	;BEG SCRN LINE = 0.
       STA  BOTL	;BEG TEXT LINE = 0.
       STA  CCP		;CURSOR PTR = 0.
	CMA		;SET A = FF.
	STA CURF	;SET CURSOR ON.
       MVI  A,15	;SET CURSOR AT BOTTOM.
       STA  CLN
       CALL VDMOT	;SET VDM UP.
       RET		;RETURN FROM CLR.
;
; OUTPUT BOSL & BOTL TO VDM.
;
VDMOT: LDA  BOSL	;INITIALIZE VDM.
       RLC		;SHIFT LEFT 4.
       RLC
       RLC
       RLC
       LXI  H,BOTL
       ORA  M
       CLEAR CURSOR.
       CALL SCRL	;SCROLL UP.
       SUB  A		;CURSOR TO LEFT MARGIN.
CHOT1: STA  CCP
       MOV  B,A
       LDA  CLN
       JMP  SCUR	;SET CURSOR ON/OFF.
;
;
SCRL:  LXI  H,BOTL	;SAVE BEG. TEXT LINE.
       PUSH H
       MOV  A,M
       INR  M
       SUB  M
       LXI  B,0
       CALL CLNA	;CONVERT LINE NO.
       LXI  B,2040H
SCRL2: MOV  M,B		;CLEAR BOTTOM LINE.
       INR  L
       DCR  C
       JNZ  SCRL2
       POP  H
       MOV  A,M
       ANI  0FH
       MOV  M,AMOV  M,A
       RET
CCUR2: ANI  7FH
       MOV  M,A
       RET
;
;
CCUR:  CALL CLNA
       MOV  A,M
       ANI  7FH
       MOV  M,A
       RET
;
;
CLN:   DS   1
CCP:   DS   1
CURF:  DS   1
BOSL:  DS   1
BOTL:  DS   1
HLSAV: DS   32
VSTACK: DS   1
	ENDIF		;END OF VDM DRIVER.

;
; MOVE DISK TO TRACK ZERO.
;
HOME:	MVI  A,RTCNT	;GET RETRY COUNT.
HRETRY:	STA  ERCNT	;STORE IN ERROR CTR.
	MVI  A,0D0H	;CLEAR ANY PENDING COMMAND.
	OUT  DCOM
	LDA  DISKNO	;GET DISK NUMBER.
	MOV  E,A	;PUT IN D&E.
	XRA  A	
	MOV  D,A
	LXI  H,TRTAB	;GET ADR OF TRK TABLE.

	IF  NOT DUAL	;IF NOT A DUAL DRIVE.
	DAD  D		;ADD DISK NUMBER.
	ENDIF

	MOV  M,A	;PUT ZERO INTO TABLE.
HOME1:	IN   DSTAT	;READ DISK STATUS.
	RRC		;LOOK AT LSB.
	JC   HOME1	;WAIT FOR NOT BUSY.

	IF   FAST	;IF FAST SEEK,
	LDA  NODSKS	;GET NUMBER OF DISKS.
	DCR  A		;IF ONLY ONE DISK,
	JZ   HOME2	;SKIP OVER NEXT PART.
	LDA  DISKNO	;GET DISK NUMBER.
	RLC!RLC!RLC!RLC	;SHIFT LEFT 4 BITS.
	ANI  10H	;LOOK AT BIT 4.
HOME2:	CMA		;IN	;ERROR IF NOT TRK 0.
	MOV  A,D	;GET STATUS BACK.
	ANI  91H	;MASK NON-ERROR BITS.
	RZ		;RETURN IF NO ERROR.
HERR:	LDA  HECNT	;GET TOTAL ERROR COUNT.
	INR  A		;ADD ONE.
	STA  HECNT	;SAVE IT BACK.
	LDA  ERCNT	;GET THIS ERROR COUNT.
	DCR   A		;DECREMENT COUNT.
	JNZ  HRETRY	;TRY TO HOME AGAIN.
	LXI  H,HEMSG	;PRINT "HOME ".
	MOV  A,D	;MASK NON-ERROR BITS.
	ANI  91H
	MOV  D,A
	JMP  ERMSG	;DO COMMON ERROR MSGS.
;
; SELECT DISK NUMBER ACCORDING TO REGISTER C.
;
SELDSK:	MOV  A,C	;GET NEW DISK NUMBEA		;SET A=0 FOR NO ERRO IND.
	RET		;RETURN FROM SELDSK.
SELMOR:	POP  A		;MAKE STACK RIGHT.
	MOV  A,M	;GET OLD DISK NUMBER.

	IF   DUAL	;IF DUAL DRIVE,
	ANI  0FEH	;CLEAR OUT BIT 0.
	ENDIF

	MOV  E,A	;PUT OLD DISK NO. IN D&E.
	MVI  D,0
	LXI  H,TRTAB	;GET ADDRESS OF TRACK TABLE.
	DAD  D		;ADD DISK NO. TO ADDRESS.
	IN   TRACK	;READ 1771 TRACK REGISTER.
	MOV  M,A	;PUT INTO TABLE.
	MOV  A,C	;GET NEW DISK NUMBER.

	IF   DUAL	;IF A DUAL DRIVE,
	ANI  0FEH	;CLEAR BIT 0.
	ENDIF

	MOV  E,A	;PUT NEWLSO PERFORM MOVE TO THE CORRECT TRACK (SEEK).
;
SETTRK:	MOV  A,C	;GET NEW TRACK NUMBER.
	STA  TRK	;UPDATE OLD WITH NEW.
	CALL SEEK	;MOVE TO NEW TRACK.
	RET		;RETURN FROM SETTRK ROUTINE.
;
; SET DISK SECTOR NUMBER.
;
SETSEC:  MOV  A,C	;GET SECTOR NUMBER.
         STA  SECT	;PUT AT SECT # ADDRESS.
         RET		;RETURN FROM SETSEC.
;
; SET DISK DMA ADDRESS.
;
SETDMA:  MOV  H,B	;MOVE B&C TO H&L.
         MOV  L,C
         SHLD DMAADD	;PUT AT DMA ADR ADDRESS.
         RET		;RETURN FROM SETDMA.
	ENDIF

	IN   DSTAT	;READ STATUS.
	ANI  20H	;LOOK AT HLD BIT.
	LDA  SECT	;GET SECTOR NUMBER.
READ1:	OUT  SECTP	;SET SECTOR INTO 1771.
	MVI  A,8CH	;READ WITH HEAD LOAD
	JZ   READE	;HEAD NOT LOADED.
	MVI  A,88H	;CODE FOR READ W/O HD LD.
READE:	OUT  DCOM	;SEND COMMAND TO 1771.
RLOOP:	IN   WAIT	;WAIT FOR DRQ OR INTRQ.
	ORA  A		;SET FLAGS.
	JP   RDDONE	;DONE IF INTRQ.
	IN   DDATA	;READ A DATA BYTE FROM DISK.
	MOV  M,A	;PUT BYTE INTO MEMORY.
	INX  H		;INCREMENT MEMORY POINTER.
	JMP  RLOOP	;KEEP RVERT.
	MOV  E,A	;SAVE IT.
	ANI  0B2H	;SET PERSCI
	OUT  DCONT	;RESTORE LINE.
HLOOP:	IN   DSTAT	;LOOK AT STATUS
	ANI  4		;BIT 2 (TRACK 0)
	JZ   HLOOP	;AND WAIT TILL 1.
	MOV  A,E	;RESTORE OLD BITS
	ANI  0F2H	;IN LATCH AND CLEAR
	OUT  DCONT	;RESTORE LINE.
	ENDIF

	MVI  A,2	;10 MS STEP RATE.
	OUT  DCOM	;ISSUE HOME COMMAND.
	IN   WAIT	;WAIT FOR INTRQ.
	ORA  A		;SET FLAGS.
	JM   HERR	;ERROR IF DRQ.
	IN   DSTAT	;READ DISK STATUS.
	MOV  D,A	;SAVE IN REGISTER D.
	ANI  4		;LOOK AT BIT 2.
	JZ   HERRR.
	ANI  3		;ONLY LOOK AT 2 LSB'S.
	LXI  H,DISKNO	;GET ADR OF OLD DISK NO.
	CMP  M		;NEW = OLD?
	RZ		;IF SO, RETURN.
	PUSH A		;SAVE DISK NUMBER.
	LDA  NODSKS	;GET NUMBER OF DISKS.
	DCR  A		;IF MORE THAN ONE DISK,
	JNZ  SELMOR	;TAKE CARE OF IT.
	LXI  H,MNTMSG	;GET ADR OF MOUNT MESSAGE.
	CALL PMSG	;PRINT "MOUNT ".
	POP  A		;GET DISK NUMBER.
	STA  DISKNO	;UPDATE OLD WITH NEW.
	ADI  'A'	;ADD ASCII FOR 'A'.
	MOV  C,A	;PUT INTO C.
	CALL CONOT	;PRINT IT.
	CALL CONIN	;READ A CARRIAGE RETURN.
	XRA   DISK NO. IN D&E.
	LXI  H,TRTAB	;GET ADDRESS OF TRACK TABLE.
	DAD  D		;ADD DISK NO. TO ADDRESS.
	MOV  A,M	;GET NEW TRACK NUMBER.
	OUT  TRACK	;PUT INTO 1771 TRACK REG.
	MOV  A,C	;UPDATE OLD DISK NUMBER.
	STA  DISKNO
	CMA		;BITS INVERTED INTO LATCH.
	ADD  A		;PUT BITS 1&2 AT 4&5.
	ADD  A
	ADD  A
	ADD  A
	ORI  2		;MAKE LATCH COMMAND.
DSK1:	OUT  DCONT	;SET THE LATCH WITH CODE.
         XRA  A		;SET A = 0.
         RET		;RETURN FROM SELDSK.
;
; SET TRACK NUMBER TO WHATEVER IS IN REGISTER C.
; A
;
; READ A SECTOR WITHOUT LOADING HEAD FIRST.
;
READ2:	OUT  SECTP	;SET SECTOR NUMBER INTO 1771.
	MVI  A,88H	;GET CODE FOR READ W/O HLD.
	JMP  READE	;READ A SECTOR.
;
; READ THE SECTOR AT SECT, FROM THE PRESENT TRACK.
; USE STARTING ADDRESS AT DMAADD.
;
READ:	MVI  A,RTCNT	;GET RETRY COUNT.
RRETRY:	STA  ERCNT	;STORE IN ERROR CTR.
	LHLD DMAADD	;GET STARTING ADR.
	MVI  A,0D0H	;CAUSE INTERRUPT.
	OUT  DCOM
	XTHL		;SOME DELAY.
	XTHL

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	DI		;DISABLE THEM HERE.
EADING.
RDDONE:	IN   DSTAT	;READ DISK STATUS.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	EI		;ALLOW AGAIN HERE.
	ENDIF

	ANI  9DH	;LOOK AT ERROR BITS.
	RZ		;RETURN IF NONE.
CHECK:	CALL ERCHK	;CHECK FOR SEEK ERROR.
	LXI  H,RECNT	;GET RD ERR COUNT ADDR.
	INR  M		;ONE MORE ERROR.
	LDA  ERCNT	;GET ERROR COUNT.
	DCR  A		;DECREMENT COUNT.
	JNZ  RRETRY	;TRY TO READ AGAIN.
	LXI  H,RDMSG	;PRINT "READ ".
ERMSG:	CALL PMSG	;PRINT ORIGIN MESSAGE.
ERMSG1:

	IF NOT VDM	;IF NOT PROC TECH VDM,
	MOV  A,D	;GET ERROR BITS.
	ANI  80H	;IF BIT 7 HIGH,
	LXI  H,NRMSG	;"NOT READY".
	CNZ PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  10H	;IF BIT 4 IS HIGH,
	LXI  H,RNMSG	;PRINT "RECORD NOT FOUND"
	CNZ PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  8H		;IF BIT 3 IS HIGH,
	LXI  H,CRCMSG	;PRINT "CRC ERROR".
	CNZ PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  4H		;IF BIT 2 IS HIGH,
	LXI  H,LDMSG	;PRINT "LOST DATA".
	CNZ PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  1		;IF BIT 1 IS HIGH,
	LXI  H,BSYMSG	;PRINT "BUSY".
	CNZ  PMSG
	ENDIF

PER.
	IN   DDATA	;READ THE TRACK ADDRESS.
	MOV  B,A	;SAVE IN REGISTER B.
CHKS2:	IN   WAIT	;WAIT FOR INTRQ.
	ORA  A		;SET FLAGS.
	JP   CHKS3	;DONE WITH READ ADR OP.
	IN   DDATA	;READ ANOTHER BYTE.
	JMP  CHKS2	;DO IT AGAIN.
CHKS3:	IN  DSTAT	;READ DISK STATUS.
	ORA  A		;SET FLAGS.
	JZ   CHKS4	;READ ADR OK IF 0.
	CALL HOME	;OTHERWISE, HOME FIRST.
	JMP  CHKS5
CHKS4:	MOV  A,B	;UPDATE TRACK REGISTER.
	OUT  TRACK
CHKS5:	LDA  TRK	;GET REQUIRED TRACK NO.
	CALL SEEK	;MOVE THE HEAD TO IT.
	MOV  A,D	;GET EOR HEAD LOAD.
	LDA  SECT	;GET SECTOR NUMBER.
WRITE1:	OUT  SECTP	;SET THE SECTOR INTO 1771.
	MVI  A,0ACH	;SET UP 1771 FOR WRITE.
	JZ   WRITE2	;HEAD IS NOT LOADED.
	MVI  A,0A8H	;CODE FOR WRITE W/O HD LD.
WRITE2:	OUT  DCOM
WLOOP:	IN   WAIT	;WAIT FOR READY.
	ORA  A		;SET FLAGS.
	JP   WDONE	;HOP OUT WHEN DONE.
	MOV  A,M	;GET BYTE FROM MEM.
	OUT  DDATA	;WRITE ONTO DISK.
	INX  H		;INCREMENT MEM PTR.
	JMP  WLOOP	;KEEP WRITING.
WDONE:	IN   DSTAT	;READ DISK STATUS.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
 ERROR BITS.
	ANI  20H	;LOOK AT BIT 5.
	LXI  H,WFMSG	;PRINT "FAULT ".
	CNZ  PMSG
	JMP  ERMSG1	;DO COMMON MESSAGES.
	ENDIF

	IF   VDM	;IF PROC TECH VDM,
	JMP  ERMSG
	ENDIF

;
; MOVE THE HEAD TO THE TRACK IN REGISTER A.
;
SEEK:	PUSH B		;SAVE B&C.
	MOV  B,A	;SAVE DESTINATION TRACK.
	MVI  A,RTCNT	;GET RETRY COUNT.
SRETRY:	STA  SERCNT	;STORE IN ERROR COUNTER.
	IN   TRACK	;READ PRESENT TRACK NO.
	MOV  C,A	;SAVE IN C.
	MOV  A,C	;DELAY.
	CMP  B		;SAME AS NEW TRACK NO.?
	MOV  A,B	;RESTORE A FRO	MVI  A,40H	;IF CARRY = 1,
	JC  SDIR	;STEP IN.
	MVI  A,60H	;OTHERWISE, OUT.
SDIR:	OUT  DCOM	;ISSUE STEP DIRECTION.
	MVI  A,20	;DELAY LOOP COUNT.
DLOOP:	DCR  A		;DECREMENT COUNTER.
	JNZ  DLOOP
	MOV  A,C	;GET PRESENT TRACK.
	SUB  B		;FIGURE TRACKS TO STEP.
	JP   STEP	;IF NEGATIVE,
	CMA		;FIGURE THE
	INR  A		;TWO'S COMPLEMENT.
STEP:	MOV  C,A	;GET DIFFERENCE.
	MVI  A,1	;PERSCI STEP COMMAND.
STEP1:	OUT  DCONT	;STEP PERSCI (E-14).
	DCR  C		;COUNT THE STEP.
	JNZ  STEP1	;STEP UNTIL C = 0.
	IN   WAMSG:	LXI  H,ERRMSG	;PRINT "ERROR."
	CALL PMSG
	MVI  A,1	;SET FOR PERM ERR MSG.
	ORA  A		;SET FLAGS.
	RET
;
; ERCHK - CHECK FOR RECORD NOT FOUND ERROR.
;
ERCHK:	MOV  D,A	;SAVE ERROR BITS IN D.
	ANI  10H	;IF RECORD NOT FOUND,
	JNZ  CHKSK	;DO A CHECK ON SEEK.
	MOV  A,D	;OTHERWISE RESTORE BITS
	ORA  A		;SET FLAGS,
	RET		;AND RETURN.
;CHECK FOR SEEK TO CORRECT TRACK,
;AND CHANGE IF NECESSARY.
CHKSK:	MVI  A,0C4H	;SEND COMMAND TO 1771
	OUT  DCOM	;TO READ ADDRESS.
	IN   WAIT	;WAIT FOR DRQ OR INTRQRROR BITS.
	ORA  A		;SET FLAGS.
	RET		;RETURN FROM ERCHK.
;
; WRITE THE SECTOR AT SECT, ON THE PRESENT TRACK.
; USE STARTING ADDRESS AT DMAADD.
;
WRITE:	MVI  A,RTCNT	;GET RETRY COUNT.
WRETRY:	STA  ERCNT	;STORE IN ERROR COUNTER.
	LHLD DMAADD	;GET STARTING ADR.
	MVI  A,0D0H	;STATUS INTERUPT FOR 1771.
	OUT  DCOM	;COMMAND 1771.
	XTHL		;WAIT FOR STATUS.
	XTHL		;CHANGE IT BACK.

	IF  INTRP	;IF INTERRPUTS ALLOWED,
	DI		;DISABLE THEM HERE.
	ENDIF

	IN   DSTAT	;GET 1771 STATUS.
	ANI  20H	;CHECK F
	EI		;ENABLE AGAIN HERE.
	ENDIF

	ANI  0FDH	;LOOK AT THESE BITS.
PROCER:	RZ		;RETURN IF NO ERR.
	CALL ERCHK	;CHECK/CORRECT SEEK ERR.
	LXI  H,WECNT	;GET ADR OF WRITE ERR CTR.
	INR  M		;ONE MORE WRITE ERROR.
	LDA  ERCNT	;GET ERROR COUNT.
	DCR  A		;DECREMENT COUNT.
	JNZ  WRETRY	;TRY TO WRITE AGAIN.
WERR0:	LXI  H,WTMSG	;PRINT "WRITE ".

	IF NOT VDM	;IF NOT PROC TECH VDM,
	CALL PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  40H	;LOOK AT BIT 6.
	LXI  H,WPMSG	;PRINT "PROTECT ".
	CNZ  PMSG
	MOV  A,D	;GETM B.
	JNZ  NOTHR	;JUMP IF NOT THERE.
THERE:	POP  B		;RESTORE B&C.
	RET		;RETURN FROM SEEK.
NOTHR:

	IF NOT FAST	;IF NOT FAST SEEK,
	OUT  DDATA	;TRACK TO DATA REGISTER.
BUSY:	IN   DSTAT	;READ DISK STATUS.
	RRC		;LOOK AT BIT 0.
	JC   BUSY	;WAIT TILL NOT BUSY.
	MVI  A,12H	;SET FOR 10 MS STEP.
	ORI  4		;VERIFY ON LAST TRACK.
	OUT  DCOM	;ISSUE SEEK COMMAND.
	IN   WAIT	;WAIT FOR INTRQ.
	IN   DSTAT	;READ STATUS.
	ANI  91H	;LOOK AT BITS.
	JZ  THERE	;OK IF ZERO.
	ENDIF

	IF  FAST	;IF FAST SEEK,
IT	;CLEAR 1771.
	IN   DSTAT
	MOV  A,B	;GET DEST. TRACK.
	OUT  TRACK	;UPDATE TRACK REG.
	LDA  DISKNO	;GET DISK NUMBER.
	RLC!RLC!RLC!RLC	;SHIFT LEFT 4 BITS.
	ANI  10H	;LOOK A BIT 4.
	CMA		;INVERT.
	MOV  B,A	;SAVE IN B.
	ANI  72H	;MAKE COMMAND TO
	OUT  DCONT	;SWITCH WAIT FOR
	IN   WAIT	;SEEK COMPLETE.
	MOV  A,B	;RESTORE ORIG. BITS.
	ANI  0F2H	;SWITCH WAIT BACK.
	OUT  DCONT
	XRA  A		;MAKE GOOD RETURN.
	POP  B		;RESTOREE  B&C.
	RET
	ENDIF

	IF NOT FAST	;IF NOT FAST SEEK,
	PUSH H		;SAVE H&L.
	LXI  H,SECNT	;GET ADR OF SEEK ERR CTR.
	INR  M		;ONE MORE SEEK ERROR.
	POP  H		;RESTORE H&L.
	LDA  ERCNT	;GET ERROR COUNT.
	DCR  A		;DECREMENT COUNT.
	JNZ  SRETRY	;RETRY SEK.
	POP  B		;RESTORE B&C.
	LXI  H,SKMSG	;PRINT "SEEK ".
	IN   DSTAT	;READ DISK STATUS.
	ANI  91H	;LOOK AT ERROR BITS.
	MOV  D,A	;PUT IN REG D.
	JMP  ERMSG	;DO COMMON ERR MESSAGES.
	ENDIF

;
; PRINT THE MESSAGE AT H&L UNTIL A ZERO.
;
PMSG:    MOV  A,M	;GET A CHARACTER.
         ORA  A		;IF IT'S ZERO,
         RZ		;RETU,0
SKMSG:	DB   0DH,0AH,'SEEK ',0
HEMSG:	DB   0DH,0AH,'HOME ',0
MNTMSG:	DB   0DH,0AH,'MOUNT ',0
SMSG:	DB   0DH,0AH,'TARBELL '
	DB   MSIZE/10+'0',MSIZE MOD 10 + '0'
	DB   'K CPM V1.4 OF 2-15-78'
	DB   0DH,0AH

	IF  STD		;IF STANDARD I/O,
	DB   'STANDARD '
	ENDIF

	IF  MSIO2	;IF MITS 2SIO,
	DB   '2SIO '
	ENDIF

	IF  ISIO2	;IF IMSAI SIO-2,
	DB  'SIO-2 '
	ENDIF

	IF  TUART	;IF TUART,
	DB  'TUART '
	ENDIF

	IF   VDM	;IF PROC TECH VDM,
	DB   'VDM '
	ENDIF

	IF  FAST	;IF FAST SEEK,
	DBHEN HIGH.
	ENDIF

	IF  OTHER	;IF ANYTHING ELSE,
	JZ  LIST1	;READY WHEN HIGH.
	ENDIF

	MOV  A,C	;GET DATA BYTE.
	OUT  LDATA	;PRINT IT.
	RET		;RETURN FROM LIST.

	IF NOT VDM	;IF NOT PROC TECH VDM,
LINUL:	PUSH B		;SAVE B&C.
	MVI  B,LNULL	;GET NULL COUNT.
LINUL1:	CALL LIST1	;PRINT (CR FIRST).
	MVI  C,0	;GET NULL CHAR.
	DCR  B		;DECREMENT COUNTER.
	JNZ  LINUL1	;DO NEXT NULL.
	POP  B		;RESTORE B&C.
	MOV  A,C	;RESTORE A.
	RET		;RETURN FROM LIST.
	ENDIF

;
; NORMALLY USED TO PUNCH PAPER TAPERE ARE ONLY NINE SECTORS
;AVAILABLE FOR CBIOS ON THE SECOND SYSTEM TRACK (1),
;THE LAST ADDRESS BEFORE THIS POINT SHOULD BE NO
;GREATER THAN THE CBIOS STARTING ADDRESS + 047F (HEX).
;THIS WILL NORMALLY BE XE7F (HEX).

;
; ERROR COUNTS.  THESE LOCATIONS KEEP TRACK OF THE
; NUMBER OF ERRRS THAT OCCUR DURING READ, WRITE,
; OR SEEK OPERATIONS.  THEY ARE INITIALIZED ONLY
; WHEN A COLD-START IS PERFORMED BY THE BOOOTSTRAP.
;
HECNT:	DB   0		;HOME ERROR COUNT.
RECNT:	DB   0		;READ ERROR COUNT.
WECNT:	;************************************************************
;THIS PROGRAM IS A MODIFICATION OF "COPYATOB.COM" WHICH
;HAS BEEN RE-WRITTEN TO OPERATE BOTH THROUGH CPM BDOS CALLS
;AND DIRECTLY WITH BIOS PRIMITIVES.  THE PROGRAM CAN BE
;USED TO COPY TRACKS 0 AND  1 WITH THE COMMAND "COPY SYSTEM"
;                    2  TO 76 WITH THE COMMAND "COPY DATA" AND
;                    0  TO 76 WITH THE COMMAND "COPY ALL"
;THE PROGRAM WILL OPERATE WITH A STANDARD CPM SYSTEM OF ANY 
;SIZE.  BECAUSE OF THE POTERN.
         MOV  C,A	;OTHERWISE,
         CALL CONOT	;PRINT IT.
         INX  H		;INCREMENT H&L,
         JMP  PMSG	;AND GET ANOTHER.
;
; CBIOS MESSAGES
;

	IF NOT VDM	;IF NOT PROC TECH VDM,
NRMSG:	DB   'NOT READY ',0
RNMSG:	DB   'RECORD NOT FOUND ',0
CRCMSG:	DB   'CRC ',0
LDMSG:	DB   'LOST DATA ',0
BSYMSG:	DB   'BUSY ',0
WPMSG:	DB   'PROTECT ',0
WFMSG:	DB   'FAULT ',0
	ENDIF

ERRMSG:	DB   'ERROR.',0
RDMSG:	DB   0DH,0AH,'READ ',0
WTMSG:	DB   0DH,0AH,'WRITE ',0
BTMSG:	DB   'BOOT ERROR'  'FAST SEEK '
	ENDIF

	IF  DUAL	;IF DUAL DRIVE,
	DB  'DUAL '
	ENDIF

	DB  'VERSION.'
	DB   0DH,0AH,'HOW MANY DISKS? ',0
;
; WRITE A CHARACTER ON LISTING DEVICE.
;
LIST:
	IF NOT VDM	;IF NOT PROC TECH VDM,
	MVI  A,0DH	;IF IT'S A CR,
	CMP  C		;THEN HOP OUT TO
	JZ   LINUL	;NULL ROUTINE.
	ENDIF

LIST1:	IN   LSTAT	;READ LISTER STATUS.
	ANI  LRBIT	;LOOK AT READY BIT.

	IF   STD	;IF STANDARD I/O,
	JNZ  LIST1	;READY WHEN LOW.
	ENDIF

	IF   SIO2	;IF MITS, IMSAI, CROM.,
	JZ   LIST1	;READY W, BUT IS
; NICE FOR AN INFINITE BIT BUCKET TO CHECK FILES.
;
PUNCH:
	IF NOT VDM	;IF NOT PROC TECH VDM,
	NOP		;SPACE FOR YOUR ROUTINE.
	NOP!NOP!NOP!NOP
	NOP!NOP!NOP!NOP
	NOP
	ENDIF

	RET		;RETURN FROM PUNCH.
;
;  NORMALLY USED TO READ PAPER TAPE.
; SET UP TO READ FROM CONSOLE IN STANDARD SYSTEM.
;
READER:
	IF NOT VDM	;IF NOT PROC TECH VDM,
	CALL CONIN	;READ FROM CONSOLE.
	NOP!NOP!NOP!NOP	;MORE SPACE FOR YOUR ROUTINE.
	NOP!NOP!NOP!NOP
	ENDIF

	RET		;RETURN FROM READER.

;NOTE:  AS THEDB   0		;WRITE ERROR COUNT.
SECNT:	DB   0		;SEEK ERROR COUNT.
;
; TRTAB - DISK TRACK TABLE - PRESENT POSITION OF
;	HEADS FOR UP TO 4 DRIVES.
;
TRTAB:	DS   4
;
NODSKS:	DS   1		;NUMBER OF DISKS.
ERCNT:	DS   1		;ERROR COUNT FOR RETRIES.
SERCNT:	DS   1		;SEEK RETRY COUNTER.
TEMP:	DS   1		;TEMPORARY STORAGE.
TRK:	DS   1		;CURRENTLY SELECTED TRACK.
SECT:	DS   1		;CURRENTLY SELECTED SECTOR.
DMAADD:	DS   2		;CURRENT READ/WRITE ADDRESS.
DISKNO:	DS   1		;CURRENT DISK NUMBER.
         END
NTIAL POWER OF THIS PROGRAM
;THE INITIATING COMMAND IS TESTED FOR PRECISE SYNTAX.
;TONY GOLD (212) 722-3416.
;------------------------------------------------------------
;7/23/77
;THIS PROGRAM HAS BEEN REWRITTEN TO REMOVE THE DEPENDENCE
;ON THE LOCATION OF THE SCRATCH AREA, SO THAT IT CAN BE
;USED WITH THE DIGITAL SYSTEMS FDC3 CONTROLLER.
;
;ALSO THE PROGRAM PAUSES AFTER LOADING SO THAT THE DISKS
;CAN BE CHANGED.
;TOM KIRK (609) 921-0321.
;************************************************************
	ORG	100H
;
;
	JMP	VECTOR
;************************************************************
HOME:	JMP	DUMYADR
SELDSK:	JMP	DUMYADR
SETTRK:	JMP	DUMYADR
SETSEC:	JMP	DUMYADR
SETDMA:	JMP	DUMYADR
READ:	JMP	DUMYADR
WRITE:	JMP	DUMYADR
READN:	JMP	DUMYADR
WRITEN:	JMP	DUMYADR
;************************************************************
;EQUATES
EXITCPM	EQU	0
LASTSEC	EQU	26
BDOS	EQU	5
;************************************************************
;
MESGA:	DB	0DH,0AH,'+COMPARE ERROR ON TRACK $'
E,A	;FOR BDOS CALL
	MVI	C,2	;WRITE CONSOLE FUNCTION
	CALL	BDOS
	RET
;
;
COPY:	MVI	C,0
	CALL	SELDSK	;SELECT DISK A
	LDA	TRKSRT	;FIRST TRACK TO MOVE
	STA	TRK	;MAKE CURRENT
	MOV	C,A
	CALL	SETTRK	;AND SELECT IT ON DISK A
	MVI	C,1
	CALL	SELDSK	;ALSO B
	LDA	TRKSRT	;FIRST TRACK TO MOVE
	MOV	C,A
	CALL	SETTRK	;AND SELECT IT ON DISK B
RDLOOP:	MVI	C,0
	XRA	A
	STA	CMPERR
	CALL	SELDSK
	LDA	TRK	;GET TRACK
	MOV	C,A
	CALL	READT	;READ ENTIRE TRACK
RETRYW:
	MVI	C,1
	CALL	SELDSK
	LDA	TRK
	MOV	C,A
ER FUNCTION CALL
	CALL	BDOS
	LDA	TRK
	CALL	PRTHEX
	LXI	D,MESGB
	MVI	C,9	;BDOS PRINT BUFFER FUNCTION CALL
	CALL	BDOS
	POP	H	;PUSHED FROM B
	DAD	H	;COMPUTE SECTOR IN ERROR
	LXI	D,0FF00H
	DAD	D
	MVI	A,27
	SUB	H
	CALL	PRTHEX	;PRINT SECTOR
	LDA	CMPERR
	INR	A
	STA	CMPERR	;INCREMENT ERROR COUNT
	CPI	10
	RNZ
	MVI	C,9	;BDOS PRINT BUFFER FUNCTION CALL
	LXI	D,MESGC
	CALL	BDOS
	XRA	A
	RET
;
DMASET:	PUSH	B
	MOV	C,L
	MOV	B,H
	CALL	SETDMA
	POP	B
	RET
;
;
READT:	LXI	H,BUF0	;TRACK # IN C
RTSET BY DISK ERROR?
	CC	FAILW
	LHLD	DMAAD
	LXI	D,128
	DAD	D
	SHLD	DMAAD
	CALL	DMASET
	POP	B
	MVI	A,LASTSEC
	CMP	C
	RZ
	INR	C
	JMP	WT3
CMPERR:	DB	0	;NUMBER OF COMPARE ERRORS
TRK:	DB	0
DMAAD:	DS	2
STK:	DS	32
STKTOP:	DB	0
;
;
;
;
BUF0:	DS	128*LASTSEC
BUF1:	DS	128*LASTSEC
;************************************************************
VECTOR:
;SET UP JUMP VECTORS FOR  ACCESS TO BIOS PRIMITIVES
BASE	EQU	0	;FIND WBOOT JMP ADDRESS AT RST0
DUMYADR	EQU	0	;WHO CARES?
;
	LHLD	BASE+1	;GET WBOINE SETS UP THE PARAMETERS FOR THE COPY ROUTINE.
;COPY CAN BE USED TO TRANSFER:	SYS	TRACKS  0- 1
;				DAT	TRACKS  2-76
;				ALL	TRACKS	0-76
;THE ROUTINE SEARCHES THE DEFAULT BUFFER AT 80H FOR THE
;RUN PARAMETER TO BE USED
;************************************************************
;ROUTINE EQUATES
TBUFF	EQU	80H
;************************************************************
;DATA TABLES
SYSMSG:	DB	'YSTEM$'	;SYSTEM MESSAGE
DATMSG:	DB	'ATA$'		;DATA MESSAGE
ALLMSG:	DB	'LL$'		;ALL MESSAGE
TRKSRT:	MESGB:	DB	'(HEX) SECTOR $'
MESGC:	DB	'PERMANENT $'
MESGD:	DB	'+PERMANENT SOURCE DISK ERROR EXIT $'
MESGE:	DB	'+PERMANENT DESTINATION DISK ERROR EXIT $'
SIGNON:	DB	13,10,'+SOURCE ON A'
	DB	13,10,'+OBJECT ON B'
SINOFF:	DB	13,10,'+TYPE <RET>$'
CRLF:	DB	13,10,'$'
;
;
PRTHEX:	PUSH	PSW	;SAVE FOR LSN
	RAR		;SHIFT MSNIBLE TO LSN
	RAR
	RAR
	RAR
	CALL	PRTNBL	;PRINT IT
	POP	PSW	;NOW FOR LSN
PRTNBL:	ANI	0FH
	ADI	30H	;SHIFT TO ASCII VALUE
	CPI	3AH	;OVER 9?
	JC	SML
	ADI	7	;SHIFT TO ALPHA
SML:
	MOV		CALL	WRITET	;WRITE TRACK
	LDA	TRK
	MOV	C,A
	CALL	COMPT	;REREAD AND COMPARE
	JNZ	RETRYW	;RETRY IF ERR
	LDA	TRK
	INR	A
	STA	TRK
	LXI	H,TRKSRT+1	;POINT TO LAST TRACK+1 STORAGE
	CMP	M	;ARE WE DONE?
	JNZ	RDLOOP	;LOOP IF NOT
	RET
;
;
COMPT:	LXI	H,BUF1
	CALL	RT2	;REREAD INTO BUF1
	LXI	H,BUF0
	LXI	D,BUF1
	LXI	B,128*LASTSEC
CMPLP:	LDAX	D
	CMP	M
	JNZ	CERR
	INX	H
	INX	D
	DCR	C
	JNZ	CMPLP
	DCR	B	;ARE WE AT END OF BUFFER?
	JNZ	CMPLP
	RET
CERR:	PUSH	B
	LXI	D,MESGA
	MVI	C,9	;BDOS PRINT BUFF2:	SHLD	DMAAD
	CALL	DMASET
	CALL	SETTRK
	MVI	C,1
	PUSH	B
	CALL	SETSEC
	CALL	READ
	JMP	RT4
RT3:	PUSH	B
	CALL	SETSEC
	CALL	READN
RT4:	RAR		;WAS A BIT 0 SET BY DISK ERROR?
	CC	FAILR
	LHLD	DMAAD
	LXI	D,128
	DAD	D
	SHLD	DMAAD
	CALL	DMASET
	POP	B
	MVI	A,LASTSEC
	CMP	C
	RZ
	INR	C
	JMP	RT3
;
;
WRITET:	LXI	H,BUF0	;TRACK # IN C
WT2:	SHLD	DMAAD
	CALL	DMASET
	CALL	SETTRK
	MVI	C,1
	PUSH	B
	CALL	SETSEC
	CALL	WRITE
	JMP	WT4
WT3:	PUSH	B
	CALL	SETSEC
	CALL	WRITEN
WT4:	RAR		;WAS A BIT 0 OT ADDRESS
	SPHL		;SAVE IT IN SP FOR DAD
;
	LXI	H,15H
	DAD	SP
	SHLD	HOME+1
;
	LXI	H,18H
	DAD	SP
	SHLD	SELDSK+1
;
	LXI	H,1BH
	DAD	SP
	SHLD	SETTRK+1
;
	LXI	H,1EH
	DAD	SP
	SHLD	SETSEC+1
;
	LXI	H,21H
	DAD	SP
	SHLD	SETDMA+1
;
	LXI	H,24H
	DAD	SP
	SHLD	READ+1
;
	LXI	H,27H
	DAD	SP
	SHLD	WRITE+1
;
	LXI	H,2AH
	DAD	SP
	SHLD	READN+1
;
	LXI	H,2DH
	DAD	SP
	SHLD	WRITEN+1
;
	LXI	SP,STKTOP
;
;************************************************************
RUNTYP:	JMP	BUFMSR
;THIS ROUTDW	0		;STORAGE FOR FIRST AND LAST+1 TRACK NUMBERS
CMDER1:	DB	'+COMMAND "COPY$'
CMDER2:	DB	'" HAS SYNTAX ERROR',0DH,0AH,'$'
CMDINF:	DB	'+THIS PROGRAM IS INITIATED WITH THE COMMAND',0DH,0AH
	DB	'+"COPY SYSTEM", "COPY DATA" OR "COPY ALL"$'
DONMSG:	DB	'+FUNCTION COMPLETE$'
;************************************************************
;FIRST WE MEASURE THE INPUT BUFFER MESSAGE
;AND DELIMIT IT WITH A $ PER BDOS CALL 9
BUFMSR:	LXI	H,TBUFF
	XRA	A		;CLEAR ACC.
	ADD	M		;GET MESSAGE SIZE
	JZ	NOMSG		;NONE FOUND
	INX	H		;ADD FOR ADDR. PAST MESSAGE
	MVI	B,0		;EMPTY FOR DAD
	MOV	C,A
	DAD	B		;ADD CHARACTER COUNT TO HL
	MVI	M,'$'		;END BUFFER CHARACTER
;************************************************************
;NEXT IS A TEST FOR WHICH MESSAGE IS PRESENT
	LDA	TBUFF+2		;FIRST CHARACTER ADDRESS
	CPI	'S'
	JZ	SYSSET
	CPI	'D'
	JZ	DATSET
	CPI	'A'
	JZ	ALLSET
	JMP	BADMSG		;FIRST CHARACTER NOT ONE OF 3 PERMITTED
;************************************************************
SYSSET:
	LXI	D,SYSMSG
	MVI	CTRKSRT AND TRKSRT+1
;************************************************************
	LXI	D,SIGNON
	MVI	C,9
	CALL	BDOS
AGIN:	MVI	C,1
	CALL	BDOS
	CPI	3
	JZ	EXITCPM
	CPI	13
	JNZ	AGIN
	LXI	D,CRLF
	MVI	C,9
	CALL	BDOS
;************************************************************
	CALL	COPY		;MAIN ROUTINE
	LXI	D,DONMSG	;SAY WE'RE DONE
	MVI	C,9
	CALL	BDOS
	JMP	EXIT		;DONE. NOW GET OUT
;************************************************************
MSGTST:	LXI	H,TBUFF+3
	LDAX	D
	CMP	M		;SAME AS MEMVI	C,9		;BDOS PRINT BUFFER FUNCTION CALL
DIE:	CALL	BDOS
;************************************************************
EXIT:	LXI	D,SINOFF
	MVI	C,9
	CALL	BDOS
	MVI	C,1
	CALL	BDOS
	CPI	'&'
	JZ	AGIN
	CPI	13
	JNZ	EXIT
	JMP	EXITCPM
	END
; BASIC INPUT/OUTPUT OPERATING SYSTEM
; TARBELL ELECTRONICS
; 4-DRIVE VERSION OF 2-15-78
; (NOTE THAT CP/M VERSION 1.3 ONLY SUPPORTS 2 DRIVES,
; WHILE CP/M VERSION 1.4 WILL SUPPORT 4 DRIVES.)
;
; THIS MODULE CONTAINS ALL THE INPUT/OUTPUT
; ROUTINES FOR THE CP/M SYSTEM, INCLUDING
; THE DISK ROUTINES.
;
MSIZE	EQU  24		;MEMORY SIZE.

; THIS SECTION DEFINES THE I/O PORTS AND
; STATUS BITS.  BY SETTING THE PROPER VALUES
; FOR THE EQU STATEMENTS, THE I/O MAY BE
; AUTOMATICALLY RECONFIGURED TO FIT MMSIO2 OR ISIO2 OR TUART
OTHER	EQU  FALSE	;TRUE IF SOMETHING ELSE.

CSTAT	EQU  0		;CONSOLE STATUS PORT.
CCOM	EQU  0		;CONSOLE COMMAND PORT.
CDATA	EQU  1		;CONSOLE DATA PORT.

	IF   STD	;IF STANDARD I/O,
CKBR	EQU  00000001B	;KEYBOARD READY BIT.
CPTR	EQU  10000000B	;CONS OUTPUT RDY BIT.
	ENDIF

	IF   MSIO2	;IF MITS 2SIO,
CKBR	EQU  00000001B	;KEYBOARD READY BIT.
CPTR	EQU  00000010B	;PRINT READY BIT.
	ENDIF

	IF   ISIO2	;IF IMSAI SIO-2,
CKBR	EQU  00000010B	;KEYBOARD READY BIT.
CPTR	EQU  000000,6
	CALL	MSGTST
	MVI	L,0		;FIRST TRACK TO TRANSFER
	MVI	H,2		;LAST TRACK PLUS ONE
	JMP	PUTPAR
;************************************************************
DATSET:
	LXI	D,DATMSG
	MVI	C,4
	CALL	MSGTST
	MVI	L,2		;FIRST TRACK TO TRANSFER
	MVI	H,77		;LAST TRACK PLUS ONE
	JMP	PUTPAR
;************************************************************
ALLSET:
	LXI	D,ALLMSG
	MVI	C,3
	CALL	MSGTST
	MVI	L,0		;FIRST TRACK TO TRANSFER
	MVI	H,77		;LAST TRACK PLUS ONE
PUTPAR:	SHLD	TRKSRT		;PUT PARAMETERS IN SSAGE?
	JNZ	BADMSG
	INX	H
	INX	D
	DCR	C		;REDUCE CHARACTER COUNTER
	RZ			;FINISHED OK
	JMP	MSGTST+3	;CHECK OUT NEXT CHARACTER
;************************************************************
BADMSG:	LXI	D,CMDER1
	MVI	C,9
	CALL	BDOS
	LXI	D,TBUFF+1		;PRINT ERRONEOUS COMMAND
	MVI	C,9
	CALL	BDOS
	LXI	D,CMDER2
	MVI	C,9
	CALL	BDOS
NOMSG:	LXI	D,CMDINF
	MVI	C,9
	CALL	BDOS
	JMP	EXITCPM
;************************************************************
FAILR:	LXI	D,MESGD
	JMP	DIE
FAILW:	LXI	D,MESGE
	OST
; SITUATIONS.  THE TRUE AND FALSE ONES
; CONTROL CONDITIONAL ASSEMBLIES OF DIFFERENT
; SECTIONS OF I/O ROUTINES TO FIT DIFFERENT
; INTERFACE REQUIREMENTS.

TRUE	EQU  0FFFFH	;DEFINE VALUE OF TRUE.
FALSE	EQU  NOT TRUE	;DEFINE VALUE OF FALSE.

INTRP	EQU  FALSE	;TRUE IF INTERRUPTS ALLOWED.

STD	EQU  TRUE	;TRUE IF STANDARD I/O.
MSIO2	EQU  FALSE	;TRUE IF MITS 2SIO.
ISIO2	EQU  FALSE	;TRUE IF IMSAI SIO-2.
TUART	EQU  FALSE	;TRUE IF CROMEMCO TUART.
VDM	EQU  FALSE	;TRUE IF PROC TECH VDM.
SIO2	EQU  01B	;PRINT READY BIT.
	ENDIF

	IF   TUART	;IF CROMEMCO TUART,
CKBR	EQU  01000000B	;KEYBOARD READY BIT.
CPTR	EQU  10000000B	;PRINT READY BIT.
	ENDIF

	IF OTHER	;IF SOMETHING ELSE,
CKBR	EQU  00000010B	;KEYBOARD READY BIT.
CPTR	EQU  10000000B	;PRINTER READY BIT.
	ENDIF

CNULL	EQU  1		;CONSOLE NULL COUNT.

LSTAT	EQU  2		;LIST STATUS PORT.
LCOM	EQU  2		;LIST COMMAND PORT.
LDATA	EQU  3		;LIST DATA PORT.
LRBIT	EQU  CPTR	;LIST READY BIT.
LNULL	EQU  2		;LIST NULL COUNT.

DUAL	EQU  TRUE	;TRUE IF DUAL DRIVE.
FAST	EQU  TRUE	;TRUE IF FAST SEEK.

DISK	EQU  0F8H	;DISK BASE ADDRESS.
DCOM	EQU  DISK	;DISK COMMAND PORT.
DSTAT	EQU  DISK	;DISK STATUS PORT.
TRACK	EQU  DISK+1	;DISK TRACK PORT.
SECTP	EQU  DISK+2	;DISK SECTOR PORT.
DDATA	EQU  DISK+3	;DISK DATA PORT.
WAIT	EQU  DISK+4	;DISK WAIT PORT.
DCONT	EQU  DISK+4	;DISK CONTROL PORT.

RTCNT	EQU  10		;RETRY COUNT.

	ORG  MSIZE*1024-1536	;FIRST ADDRESS.

CBASE	EQU  (MSIZE-17)*1024  ;BIAS FOR LARGER THAN 17K.
CPMB	EQU  CBASE+2900H	;START OF CPM.
ACTER.
	JMP  CONOT	;WRITE CONSOLE CHARACTER.
	JMP  LIST	;WRITE LISTING CHAR.
	JMP  PUNCH	;WRITE PUNCH CHAR.
	JMP  READER	;READ READER CHAR.
	JMP  HOME	;MOVE DISK TO TRACK ZERO.
	JMP  SELDSK	;SELECT DISK DRIVE.
	JMP  SETTRK	;SEEK TO TRACK IN REG A.
	JMP  SETSEC	;SET SECTOR NUMBER.
	JMP  SETDMA	;SET DISK STARTING ADR.
READN:	JMP  READ	;READ SELECTED SECTOR.
WRITEN:	JMP  WRITE	;WRITE SELECTED SECTOR.
; THESE ENTRY POINTS ADDED BY TARBELL ELECTRONICS.
	JMP  READN	;READ WITH NO HEAD LOAD.
	JMP  WRII  A,3	;INITIALIZE 2SIO.
	OUT  CCOM
	OUT  LCOM
	MVI  A,11H
	OUT  CCOM
	OUT  LCOM
	ENDIF

	IF   ISIO2	;IF IMSAI SIO2,
	MVI  A,0AAH	;INITIALIZE SIO 2-2.
	OUT  CCOM
	MVI  A,40H
	OUT  CCOM
	MVI  A,0CEH
	OUT  CCOM
	MVI  A,37H
	OUT  CCOM
	ENDIF

	IF   TUART	;IF CROMEMCO TUART,
	MVI  A,1	;SET A = 1.
	OUT  54H	;SELECT DEVICE A.
	OUT  52H	;RESET DEVICE B.
	LXI  H,BAUDRS	;GET ADR OF BAUD RATE TABLE.
	MVI  A,11H	;OCTUPLE THE CLOCK.
IT1:	OUT  02H	;& RESET CURRENT DEV.
	MOV  A,M	;GET BAUD RATE SHLD 1
	STA  5
	LXI  H,BDOS	;PUT JUMP TO BDOS
	SHLD 6		;AT ADR 5,6,7.
	LXI  H,80H	;SET DEFAULT DMA ADR.
	SHLD DMAADD
	LDA  DISKNO	;GET DISK NUMBER TO
	MOV  C,A	;PASS TO CCP IN C.
	JMP  CPMB	;JUMP TO CCP.

	IF   TUART	;IF CROMEMCO TUART,
BAUDRS:	DB   94H,0CEH,0A2H,92H,88H,84H,82H,1
	ENDIF

;
; WARM-BOOT:  READ ALL OF CPM BACK IN
; EXCEPT BIOS, THEN JUMP TO CCP.
;
WBOOT:   LXI SP,80H	;SET STACK POINTER.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	EI		;ALLOW THEM HERE.
	ENDIF

	LDA  DISKNO	;SA SECTOR IN C.
         CALL  READ1
RBLK1    JNZ  RDERR	;IF ERROR, PRINT MESSAGE.
         DCR  D		;DECREMENT SECTOR COUNT.
	JZ   ALDON	;ALL DONE WHEN ZERO.
         INR  C		;INCREMENT SECTOR NUMBER.
	 MOV  A,C	;IF SECTOR NUMBER
         CPI  27	;IS NOT 27,
         JC   RBLK2	;HOP OUT OF LOOP.
         MVI  C,1	;OTHERWISE, RESET SECTOR=1
         INR  B		;INCREMENT TRACK NUMBER,
         JMP  RDBLK	;AND READ NEXT TRACK.
ALDON:	LDA  TEMP	;RESTORE DISK NUMBER.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
BDOS	EQU  CBASE+3106H	;START OF BDOS.
CPML	EQU  $-CPMB	;LENGTH OF CPM SYSTEM-BIOS.
NSECTS	EQU  CPML/128	;NUMBER OF SECTORS IN IT.
;
; I/O JUMP VECTOR
; THIS IS WHERE CPM CALLS WHENEVER IT NEEDS
; TO DO ANY INPUT/OUTPUT OPERATION.
; USER PROGRAMS MAY USE THESE ENTRY POINTS
; ALSO, BUT NOTE THAT THE LOCATION OF THIS
; VECTOR CHANGES WITH THE MEMORY SIZE.
;
	JMP  BOOT	;FROM COLD START LOADER.
WBOOTE:	JMP  WBOOT	;FROM WARM BOOT.
	JMP  CONST	;CHECK CONSOLE KB STATUS.
	JMP  CONIN	;READ CONSOLE CHARTEN	;WRITE WITH NO HEAD LOAD.
;
; BOOT
; THIS SECTION IS EXECUTED WHENEVER RESET AND RUN
; IS PUSHED, AFTER THE COLDSTART LOADER READS IN
; THE CPM SYSTEM.
;
BOOT:	LXI  SP,80H	;SET STACK POINTER.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	EI		;ENABLE THEM HERE.
	ENDIF

	IF   VDM	;IF PROC TECH VDM,
	CALL CLR	;CLEAR VDM SCREEN.
	ENDIF

	IF   STD	;IF STANDARD I/O,
	NOP!NOP!NOP!NOP	;LEAVE SPACE FOR INIT.
	NOP!NOP!NOP!NOP
	NOP!NOP!NOP!NOP
	NOP!NOP!NOP!NOP
	ENDIF

	IF   MSIO2	;IF MITS 2SIO,
	MVFROM TABLE.
	OUT  0		;SET BAUD RATE.
	CALL CONIN	;READ KEYBOARD.
	CALL CONIN	;READ KEYBOARD AGAIN.
	CPI  0DH	;IF NOT CARRIAGE-RETURN,
	MVI  A,1	;SLOW THE CLOCK.
	JNZ  IT1	;UNTIL A CARRIAGE-RETURN.
	ENDIF

	LXI  H,SMSG	;PRINT OPENING MESSAGE.
	CALL PMSG
	CALL CONIN	;READ # OF DISKS.
	MOV  C,A	;ECHO THE CHAR.
	CALL CONOT
	ANI  7		;LOOK AT 3 LSB'S.
	STA  NODSKS	;SAVE IT.
	XRA  A		;SET DISK NUMBER = 0.
	STA  DISKNO
GOCPM:	MVI  A,0C3H	;PUT JMP TO WBOOT
	STA  0		;ADR AT ZERO.
	LXI  H,WBOOTE
	VE DISK NUMBER.
	STA  TEMP
	MVI  C,0	;SELECT DISK ZERO.
	CALL SELDSK
	CALL HOME	;MOVE TO TRACK ZERO.
         JNZ  RDERR	;IF ERROR, PRINT MESSAGE.
         MVI  D,NSECTS	;GET # SECTORS FOR CPM READ.
         LXI  B,2	;TRACK (B)=0, SECTOR (C)=2.
         LXI  H,CPMB	;GET STARTING ADDRESS.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	DI		;DISABLE THEM HERE.
	ENDIF

RDBLK:   MOV  A,B	;GO TO TRACK IN B.
         CALL SEEK
         JNZ  RDERR	;IF ERROR, PRINT MESSAGE.
         MOV  A,C	;READ STARTING AT
	EI		;ALLOW THEM AGAIN HERE.
	ENDIF

	STA  DISKNO
	JMP  GOCPM	;GO BACK TO CPM.
;
RBLK2:   CALL READ2	;READ ANOTHER TRACK.
         JMP  RBLK1
;
RDERR:   LXI  H,BTMSG	;GET ADDRESS OF "BOOT ERROR".
         CALL PMSG	;PRINT IT.
         CALL CONIN	;READ A CHAR FROM CONSOLE.
         JMP  WBOOT	;DO A WARM BOOT.
;
; CHECK CONSOLE INPUT STATUS.
;

CONST:	IN   CSTAT	;READ CONSOLE STATUS.
	ANI  CKBR	;LOOK AT KB READY BIT.
	MVI  A,0	;SET A=0 FOR RETURN.

	IF   STD	;IF STANDARD I/O,
	RNZ		;NOT READY WHEN NOT 0.
	ENDIF

	IF SIO2		;IF MITS OR IMSAI,
	RZ		;NOT READY WHEN ZERO.
	ENDIF

	IF OTHER	;IF SOMETHING ELSE,
	RNZ		;IT MIGHT BE THIS.
	ENDIF

	CMA		;IF READY A=FF.
	RET		;RETURN FROM CONST.

;
; READ A CHARACTER FROM CONSOLE.
;
CONIN:   IN   CSTAT		;READ CONSOLE STATUS.
         ANI  CKBR	;IF NOT READY,

	IF   STD	;IF STANDARD I/O,
	JNZ  CONIN	;READY WHEN LOW.
	ENDIF

	IF SIO2		;IF MITS OR IMSAI,
	JZ   CONIN	;READY WHEN HIGH.
	ENDIF

	IF OTHER	;IF SOMETHING ELSE,
	JONOT1	;READY WHEN HIGH.
	ENDIF

	IF NOT VDM	;IF NOT PROC TECH VDM,
	MOV  A,C	;GET CHARACTER.
	OUT  CDATA	;PRINT IT.
	RET		;RETURN.
CONUL:	PUSH B		;SAVE B&C.
	MVI  B,CNULL	;GET NULL COUNT.
CONUL1:	CALL CONOT1	;PRINT CR.
	MVI  C,0	;GET NULL CHAR.
	DCR  B		;DECREMENT COUNTER.
	JNZ  CONUL1	;DO NEXT NULL.
	POP  B		;RESTORE B&C.
	MOV  A,C	;RESTORE A.
	RET		;RETURN.
	ENDIF

	IF   VDM	;IF PROC TECH VDM,
; VDM DRIVER FOR CBIOS.
; 9-24-77 VERSION
;
VDMB   EQU  0CC00H
VDMP   EQU  0CCH
VDMD   EQET		;RETURN FROM CONOT.
;
;
SCREEN: MOV  B,A	;GET CHARACTER.
       MOV  A,B
       ANI  7FH		;NOT DELETE.
       CPI  0DH		;IF IT'S CR,
       JZ   CHOT2	;TAKE CARE OF IT.
       CPI  20H		;CTL CHAR?
       RC		;DON'T DISPLAY.
	JMP  CHOUT	;GO TO CHOUT.
;
; CLEAR SCREEN & INIT CURSOR.
;
CLR:   LXI  H,VDMB	;GET VDM MEM ADR.
       MOV  A,H		;FIGURE VDM MEM TOP.
       ADI  4
CLR2:  MVI  M,' '	;PUT SPACE IN MEMORY.
       INX  H		;INCREMENT POINTER.
       CMP  H		;AT TOP YET?
       JNZ  T  VDMD	;OUT TO VDM PORT.
       RET		;RETURN FROM VDMOT.
;
; STORE CHAR IN VDM MEMORY.
;
CHOUT: MOV  C,A		;SAVE CHARACTER.
       LDA  CCP		;GET CURSOR PTR.
       MOV  B,A		;PUT IN B.
       LDA  CLN		;GET LINE NUMBER.
       CALL CLNA	;CONVERT TO ADR.
       MOV  M,C		;PUT CHAR ON SCREEN.
       LDA  CCP		;ADVANCE CURSOR.
       INR  A
       CPI  64		;WRAP AROUND?
       JNZ  CHOT1
CHOT2: LDA  CCP		;GET CURSOR POS.
       MOV  B,A
       LDA  CLN		;GET LINE NUMBER.
       CALL CCUR	;CL       JMP  VDMOT
;
; CONVERT LINE NUMBER IN REG A AND CHR
; POSITION IN REG B TO ADDRESS IN H&L.
;
CLNA:  MOV  L,A
       LDA  BOTL
       ADD  L
       RRC
       RRC
       MOV  L,A
       ANI  3
       ADI  VDMP
       MOV  H,A
       MOV  A,L
       ANI  0C0H
       ADD  B
       MOV  L,A
       RET
;
;
SCUR:  ANI  0FH
       STA  CLN
       CALL CLNA
       MOV  A,B
       STA  CCP
       LDA  CURF
       ORA  A
       MOV  A,M
       JZ   CCUR2
       ORI  80H
       MONZ  CONIN	;IT MIGHT BE THIS.
	ENDIF

         IN   CDATA	;READ A CHARACTER.
         ANI  7FH	;MAKE MOST SIG. BIT = 0.
         RET
;
; WRITE A CHARACTER TO THE CONSOLE DEVICE.
;

	IF NOT VDM	;IF NOT PROC TECH VDM,
CONOT:	MVI  A,0DH	;IF IT'S A CR,
	CMP  C		;THEN HOP OUT
	JZ   CONUL	;TO NULL ROUTINE.
CONOT1:	IN   CSTAT	;READ CONSOLE STATUS.
	ANI  CPTR	;IF NOT READY,
	ENDIF

	IF STD AND NOT VDM  ;IF STANDARD I/O,
	JNZ  CONOT1	;READY WHEN LOW.
	ENDIF

	IF SIO2		;IF MITS OR IMSAI,
	JZ   CU  0C8H
CONOT: MOV  A,C		;PUT CHAR IN A.
       SHLD HLSAV	;SAVE H&L.
       LXI  H,0		;CLEAR H&L.
       DAD  SP		;HL=SP.
       LXI  SP,VSTACK	;SET STACK PTR.
       PUSH H		;SAVE OLD SP.
       PUSH D		;SAVE D&E.
       PUSH B		;SAVE B&C.
       PUSH PSW		;SAVE A&PSW.
       CALL SCREEN	;WRITE ON SCREEN.
       POP  PSW		;RESTORE A&PSW.
       POP  B		;RESTORE B&C.
       POP  D		;RESTORE D&E.
       POP  H		;RESTORE H&L.
       SPHL		;RESTORE SP.
       LHLD HLSAV	;RESTORE H&L.
       RCLR2	;KEEP GOING IF NOT.
       XRA  A		;SET A = 0.
       STA  BOSL	;BEG SCRN LINE = 0.
       STA  BOTL	;BEG TEXT LINE = 0.
       STA  CCP		;CURSOR PTR = 0.
	CMA		;SET A = FF.
	STA CURF	;SET CURSOR ON.
       MVI  A,15	;SET CURSOR AT BOTTOM.
       STA  CLN
       CALL VDMOT	;SET VDM UP.
       RET		;RETURN FROM CLR.
;
; OUTPUT BOSL & BOTL TO VDM.
;
VDMOT: LDA  BOSL	;INITIALIZE VDM.
       RLC		;SHIFT LEFT 4.
       RLC
       RLC
       RLC
       LXI  H,BOTL
       ORA  M
       OUEAR CURSOR.
       CALL SCRL	;SCROLL UP.
       SUB  A		;CURSOR TO LEFT MARGIN.
CHOT1: STA  CCP
       MOV  B,A
       LDA  CLN
       JMP  SCUR	;SET CURSOR ON/OFF.
;
;
SCRL:  LXI  H,BOTL	;SAVE BEG. TEXT LINE.
       PUSH H
       MOV  A,M
       INR  M
       SUB  M
       LXI  B,0
       CALL CLNA	;CONVERT LINE NO.
       LXI  B,2040H
SCRL2: MOV  M,B		;CLEAR BOTTOM LINE.
       INR  L
       DCR  C
       JNZ  SCRL2
       POP  H
       MOV  A,M
       ANI  0FH
       MOV  M,A
V  M,A
       RET
CCUR2: ANI  7FH
       MOV  M,A
       RET
;
;
CCUR:  CALL CLNA
       MOV  A,M
       ANI  7FH
       MOV  M,A
       RET
;
;
CLN:   DS   1
CCP:   DS   1
CURF:  DS   1
BOSL:  DS   1
BOTL:  DS   1
HLSAV: DS   32
VSTACK: DS   1
	ENDIF		;END OF VDM DRIVER.

;
; MOVE DISK TO TRACK ZERO.
;
HOME:	MVI  A,RTCNT	;GET RETRY COUNT.
HRETRY:	STA  ERCNT	;STORE IN ERROR CTR.
	MVI  A,0D0H	;CLEAR ANY PENDING COMMAND.
	OUT  DCOM
	LDA  DISKNO	;GET DISK NUMBER.
	MOV  E,A	;PUT IN D&E.
	XRA  A	
	MOV  D,A
	LXI  H,TRTAB	;GET ADR OF TRK TABLE.

	IF  NOT DUAL	;IF NOT A DUAL DRIVE.
	DAD  D		;ADD DISK NUMBER.
	ENDIF

	MOV  M,A	;PUT ZERO INTO TABLE.
HOME1:	IN   DSTAT	;READ DISK STATUS.
	RRC		;LOOK AT LSB.
	JC   HOME1	;WAIT FOR NOT BUSY.

	IF   FAST	;IF FAST SEEK,
	LDA  NODSKS	;GET NUMBER OF DISKS.
	DCR  A		;IF ONLY ONE DISK,
	JZ   HOME2	;SKIP OVER NEXT PART.
	LDA  DISKNO	;GET DISK NUMBER.
	RLC!RLC!RLC!RLC	;SHIFT LEFT 4 BITS.
	ANI  10H	;LOOK AT BIT 4.
HOME2:	CMA		;INVEERROR IF NOT TRK 0.
	MOV  A,D	;GET STATUS BACK.
	ANI  91H	;MASK NON-ERROR BITS.
	RZ		;RETURN IF NO ERROR.
HERR:	LDA  HECNT	;GET TOTAL ERROR COUNT.
	INR  A		;ADD ONE.
	STA  HECNT	;SAVE IT BACK.
	LDA  ERCNT	;GET THIS ERROR COUNT.
	DCR   A		;DECREMENT COUNT.
	JNZ  HRETRY	;TRY TO HOME AGAIN.
	LXI  H,HEMSG	;PRINT "HOME ".
	MOV  A,D	;MASK NON-ERROR BITS.
	ANI  91H
	MOV  D,A
	JMP  ERMSG	;DO COMMON ERROR MSGS.
;
; SELECT DISK NUMBER ACCORDING TO REGISTER C.
;
SELDSK:	MOV  A,C	;GET NEW DISK NUMBER.	;SET A=0 FOR NO ERRO IND.
	RET		;RETURN FROM SELDSK.
SELMOR:	POP  A		;MAKE STACK RIGHT.
	MOV  A,M	;GET OLD DISK NUMBER.

	IF   DUAL	;IF DUAL DRIVE,
	ANI  0FEH	;CLEAR OUT BIT 0.
	ENDIF

	MOV  E,A	;PUT OLD DISK NO. IN D&E.
	MVI  D,0
	LXI  H,TRTAB	;GET ADDRESS OF TRACK TABLE.
	DAD  D		;ADD DISK NO. TO ADDRESS.
	IN   TRACK	;READ 1771 TRACK REGISTER.
	MOV  M,A	;PUT INTO TABLE.
	MOV  A,C	;GET NEW DISK NUMBER.

	IF   DUAL	;IF A DUAL DRIVE,
	ANI  0FEH	;CLEAR BIT 0.
	ENDIF

	MOV  E,A	;PUT NEW DO PERFORM MOVE TO THE CORRECT TRACK (SEEK).
;
SETTRK:	MOV  A,C	;GET NEW TRACK NUMBER.
	STA  TRK	;UPDATE OLD WITH NEW.
	CALL SEEK	;MOVE TO NEW TRACK.
	RET		;RETURN FROM SETTRK ROUTINE.
;
; SET DISK SECTOR NUMBER.
;
SETSEC:  MOV  A,C	;GET SECTOR NUMBER.
         STA  SECT	;PUT AT SECT # ADDRESS.
         RET		;RETURN FROM SETSEC.
;
; SET DISK DMA ADDRESS.
;
SETDMA:  MOV  H,B	;MOVE B&C TO H&L.
         MOV  L,C
         SHLD DMAADD	;PUT AT DMA ADR ADDRESS.
         RET		;RETURN FROM SETDMA.
ENDIF

	IN   DSTAT	;READ STATUS.
	ANI  20H	;LOOK AT HLD BIT.
	LDA  SECT	;GET SECTOR NUMBER.
READ1:	OUT  SECTP	;SET SECTOR INTO 1771.
	MVI  A,8CH	;READ WITH HEAD LOAD
	JZ   READE	;HEAD NOT LOADED.
	MVI  A,88H	;CODE FOR READ W/O HD LD.
READE:	OUT  DCOM	;SEND COMMAND TO 1771.
RLOOP:	IN   WAIT	;WAIT FOR DRQ OR INTRQ.
	ORA  A		;SET FLAGS.
	JP   RDDONE	;DONE IF INTRQ.
	IN   DDATA	;READ A DATA BYTE FROM DISK.
	MOV  M,A	;PUT BYTE INTO MEMORY.
	INX  H		;INCREMENT MEMORY POINTER.
	JMP  RLOOP	;KEEP REART.
	MOV  E,A	;SAVE IT.
	ANI  0B2H	;SET PERSCI
	OUT  DCONT	;RESTORE LINE.
HLOOP:	IN   DSTAT	;LOOK AT STATUS
	ANI  4		;BIT 2 (TRACK 0)
	JZ   HLOOP	;AND WAIT TILL 1.
	MOV  A,E	;RESTORE OLD BITS
	ANI  0F2H	;IN LATCH AND CLEAR
	OUT  DCONT	;RESTORE LINE.
	ENDIF

	MVI  A,2	;10 MS STEP RATE.
	OUT  DCOM	;ISSUE HOME COMMAND.
	IN   WAIT	;WAIT FOR INTRQ.
	ORA  A		;SET FLAGS.
	JM   HERR	;ERROR IF DRQ.
	IN   DSTAT	;READ DISK STATUS.
	MOV  D,A	;SAVE IN REGISTER D.
	ANI  4		;LOOK AT BIT 2.
	JZ   HERR	;
	ANI  3		;ONLY LOOK AT 2 LSB'S.
	LXI  H,DISKNO	;GET ADR OF OLD DISK NO.
	CMP  M		;NEW = OLD?
	RZ		;IF SO, RETURN.
	PUSH A		;SAVE DISK NUMBER.
	LDA  NODSKS	;GET NUMBER OF DISKS.
	DCR  A		;IF MORE THAN ONE DISK,
	JNZ  SELMOR	;TAKE CARE OF IT.
	LXI  H,MNTMSG	;GET ADR OF MOUNT MESSAGE.
	CALL PMSG	;PRINT "MOUNT ".
	POP  A		;GET DISK NUMBER.
	STA  DISKNO	;UPDATE OLD WITH NEW.
	ADI  'A'	;ADD ASCII FOR 'A'.
	MOV  C,A	;PUT INTO C.
	CALL CONOT	;PRINT IT.
	CALL CONIN	;READ A CARRIAGE RETURN.
	XRA  A	ISK NO. IN D&E.
	LXI  H,TRTAB	;GET ADDRESS OF TRACK TABLE.
	DAD  D		;ADD DISK NO. TO ADDRESS.
	MOV  A,M	;GET NEW TRACK NUMBER.
	OUT  TRACK	;PUT INTO 1771 TRACK REG.
	MOV  A,C	;UPDATE OLD DISK NUMBER.
	STA  DISKNO
	CMA		;BITS INVERTED INTO LATCH.
	ADD  A		;PUT BITS 1&2 AT 4&5.
	ADD  A
	ADD  A
	ADD  A
	ORI  2		;MAKE LATCH COMMAND.
DSK1:	OUT  DCONT	;SET THE LATCH WITH CODE.
         XRA  A		;SET A = 0.
         RET		;RETURN FROM SELDSK.
;
; SET TRACK NUMBER TO WHATEVER IS IN REGISTER C.
; ALS;
; READ A SECTOR WITHOUT LOADING HEAD FIRST.
;
READ2:	OUT  SECTP	;SET SECTOR NUMBER INTO 1771.
	MVI  A,88H	;GET CODE FOR READ W/O HLD.
	JMP  READE	;READ A SECTOR.
;
; READ THE SECTOR AT SECT, FROM THE PRESENT TRACK.
; USE STARTING ADDRESS AT DMAADD.
;
READ:	MVI  A,RTCNT	;GET RETRY COUNT.
RRETRY:	STA  ERCNT	;STORE IN ERROR CTR.
	LHLD DMAADD	;GET STARTING ADR.
	MVI  A,0D0H	;CAUSE INTERRUPT.
	OUT  DCOM
	XTHL		;SOME DELAY.
	XTHL

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	DI		;DISABLE THEM HERE.
	DING.
RDDONE:	IN   DSTAT	;READ DISK STATUS.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	EI		;ALLOW AGAIN HERE.
	ENDIF

	ANI  9DH	;LOOK AT ERROR BITS.
	RZ		;RETURN IF NONE.
CHECK:	CALL ERCHK	;CHECK FOR SEEK ERROR.
	LXI  H,RECNT	;GET RD ERR COUNT ADDR.
	INR  M		;ONE MORE ERROR.
	LDA  ERCNT	;GET ERROR COUNT.
	DCR  A		;DECREMENT COUNT.
	JNZ  RRETRY	;TRY TO READ AGAIN.
	LXI  H,RDMSG	;PRINT "READ ".
ERMSG:	CALL PMSG	;PRINT ORIGIN MESSAGE.
ERMSG1:

	IF NOT VDM	;IF NOT PROC TECH VDM,
	MOV  A,D	;GET ERROR BITS.
	ANI  80H	;IF BIT 7 HIGH,
	LXI  H,NRMSG	;"NOT READY".
	CNZ PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  10H	;IF BIT 4 IS HIGH,
	LXI  H,RNMSG	;PRINT "RECORD NOT FOUND"
	CNZ PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  8H		;IF BIT 3 IS HIGH,
	LXI  H,CRCMSG	;PRINT "CRC ERROR".
	CNZ PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  4H		;IF BIT 2 IS HIGH,
	LXI  H,LDMSG	;PRINT "LOST DATA".
	CNZ PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  1		;IF BIT 1 IS HIGH,
	LXI  H,BSYMSG	;PRINT "BUSY".
	CNZ  PMSG
	ENDIF

PERMS
	IN   DDATA	;READ THE TRACK ADDRESS.
	MOV  B,A	;SAVE IN REGISTER B.
CHKS2:	IN   WAIT	;WAIT FOR INTRQ.
	ORA  A		;SET FLAGS.
	JP   CHKS3	;DONE WITH READ ADR OP.
	IN   DDATA	;READ ANOTHER BYTE.
	JMP  CHKS2	;DO IT AGAIN.
CHKS3:	IN  DSTAT	;READ DISK STATUS.
	ORA  A		;SET FLAGS.
	JZ   CHKS4	;READ ADR OK IF 0.
	CALL HOME	;OTHERWISE, HOME FIRST.
	JMP  CHKS5
CHKS4:	MOV  A,B	;UPDATE TRACK REGISTER.
	OUT  TRACK
CHKS5:	LDA  TRK	;GET REQUIRED TRACK NO.
	CALL SEEK	;MOVE THE HEAD TO IT.
	MOV  A,D	;GET ERR HEAD LOAD.
	LDA  SECT	;GET SECTOR NUMBER.
WRITE1:	OUT  SECTP	;SET THE SECTOR INTO 1771.
	MVI  A,0ACH	;SET UP 1771 FOR WRITE.
	JZ   WRITE2	;HEAD IS NOT LOADED.
	MVI  A,0A8H	;CODE FOR WRITE W/O HD LD.
WRITE2:	OUT  DCOM
WLOOP:	IN   WAIT	;WAIT FOR READY.
	ORA  A		;SET FLAGS.
	JP   WDONE	;HOP OUT WHEN DONE.
	MOV  A,M	;GET BYTE FROM MEM.
	OUT  DDATA	;WRITE ONTO DISK.
	INX  H		;INCREMENT MEM PTR.
	JMP  WLOOP	;KEEP WRITING.
WDONE:	IN   DSTAT	;READ DISK STATUS.

	IF  INTRP	;IF INTERRUPTS ALLOWED,
	RROR BITS.
	ANI  20H	;LOOK AT BIT 5.
	LXI  H,WFMSG	;PRINT "FAULT ".
	CNZ  PMSG
	JMP  ERMSG1	;DO COMMON MESSAGES.
	ENDIF

	IF   VDM	;IF PROC TECH VDM,
	JMP  ERMSG
	ENDIF

;
; MOVE THE HEAD TO THE TRACK IN REGISTER A.
;
SEEK:	PUSH B		;SAVE B&C.
	MOV  B,A	;SAVE DESTINATION TRACK.
	MVI  A,RTCNT	;GET RETRY COUNT.
SRETRY:	STA  SERCNT	;STORE IN ERROR COUNTER.
	IN   TRACK	;READ PRESENT TRACK NO.
	MOV  C,A	;SAVE IN C.
	MOV  A,C	;DELAY.
	CMP  B		;SAME AS NEW TRACK NO.?
	MOV  A,B	;RESTORE A FROM VI  A,40H	;IF CARRY = 1,
	JC  SDIR	;STEP IN.
	MVI  A,60H	;OTHERWISE, OUT.
SDIR:	OUT  DCOM	;ISSUE STEP DIRECTION.
	MVI  A,20	;DELAY LOOP COUNT.
DLOOP:	DCR  A		;DECREMENT COUNTER.
	JNZ  DLOOP
	MOV  A,C	;GET PRESENT TRACK.
	SUB  B		;FIGURE TRACKS TO STEP.
	JP   STEP	;IF NEGATIVE,
	CMA		;FIGURE THE
	INR  A		;TWO'S COMPLEMENT.
STEP:	MOV  C,A	;GET DIFFERENCE.
	MVI  A,1	;PERSCI STEP COMMAND.
STEP1:	OUT  DCONT	;STEP(PERSCI (E-14).
	DCR  C		;COUNT THE STEP.
	JNZ  STEP1	;STEP UNTIL C = 0.
	IN   WAITG:	LXI  H,ERRMSG	;PRINT "ERROR."
	CALL PMSG
	MVI  A,1	;SET FOR PERM ERR MSG.
	ORA  A		;SET FLAGS.
	RET
;
; ERCHK - CHECK FOR RECORD NOT FOUND ERROR.
;
ERCHK:	MOV  D,A	;SAVE ERROR BITS IN D.
	ANI  10H	;IF RECORD NOT FOUND,
	JNZ  CHKSK	;DO A CHECK ON SEEK.
	MOV  A,D	;OTHERWISE RESTORE BITS
	ORA  A		;SET FLAGS,
	RET		;AND RETURN.
;CHECK FOR SEEK TO CORRECT TRACK,
;AND CHANGE IF NECESSARY.
CHKSK:	MVI  A,0C4H	;SEND COMMAND TO 1771
	OUT  DCOM	;TO READ ADDRESS.
	IN   WAIT	;WAIT FOR DRQ OR INTRQ.
OR BITS.
	ORA  A		;SET FLAGS.
	RET		;RETURN FROM ERCHK.
;
; WRITE THE SECTOR AT SECT, ON THE PRESENT TRACK.
; USE STARTING ADDRESS AT DMAADD.
;
WRITE:	MVI  A,RTCNT	;GET RETRY COUNT.
WRETRY:	STA  ERCNT	;STORE IN ERROR COUNTER.
	LHLD DMAADD	;GET STARTING ADR.
	MVI  A,0D0H	;STATUS INTERUPT FOR 1771.
	OUT  DCOM	;COMMAND 1771.
	XTHL		;WAIT FOR STATUS.
	XTHL		;CHANGE IT BACK.

	IF  INTRP	;IF INTERRPUTS ALLOWED,
	DI		;DISABLE THEM HERE.
	ENDIF

	IN   DSTAT	;GET 1771 STATUS.
	ANI  20H	;CHECK FOREI		;ENABLE AGAIN HERE.
	ENDIF

	ANI  0FDH	;LOOK AT THESE BITS.
PROCER:	RZ		;RETURN IF NO ERR.
	CALL ERCHK	;CHECK/CORRECT SEEK ERR.
	LXI  H,WECNT	;GET ADR OF WRITE ERR CTR.
	INR  M		;ONE MORE WRITE ERROR.
	LDA  ERCNT	;GET ERROR COUNT.
	DCR  A		;DECREMENT COUNT.
	JNZ  WRETRY	;TRY TO WRITE AGAIN.
WERR0:	LXI  H,WTMSG	;PRINT "WRITE ".

	IF NOT VDM	;IF NOT PROC TECH VDM,
	CALL PMSG
	MOV  A,D	;GET ERROR BITS.
	ANI  40H	;LOOK AT BIT 6.
	LXI  H,WPMSG	;PRINT "PROTECT ".
	CNZ  PMSG
	MOV  A,D	;GET EB.
	JNZ  NOTHR	;JUMP IF NOT THERE.
THERE:	POP  B		;RESTORE B&C.
	RET		;RETURN FROM SEEK.
NOTHR:

	IF NOT FAST	;IF NOT FAST SEEK,
	OUT  DDATA	;TRACK TO DATA REGISTER.
BUSY:	IN   DSTAT	;READ DISK STATUS.
	RRC		;LOOK AT BIT 0.
JC   BUSY	;WAIT TILL NOT BUSY.
	MVI  A,12H	;SET FOR 10 MS STEP.
	ORI  4		;VERIFY ON LAST TRACK.
	OUT  DCOM	;ISSUE SEEK COMMAND.
	IN   WAIT	;WAIT FOR INTRQ.
	IN   DSTAT	;READ STATUS.
	ANI  91H	;LOOK AT BITS.
	JZ  THERE	;OK IF ZERO.
	ENDIF

	IF  FAST	;IF FAST SEEK,
	M	;CLEAR 1771.
	IN   DSTAT
	MOV  A,B	;GET DEST. TRACK.
	OUT  TRACK	;UPDATE TRACK REG.
	LDA  DISKNO	;GET DISK NUMBER.
	RLC!RLC!RLC!RLC	;SHIFT LEFT 4 BITS.
	ANI  10H	;LOOK A BIT 4.
	CMA		;INVERT.
	MOV  B,A	;SAVE IN B.
	ANI  72H	;MAKE COMMAND TO
	OUT  DCONT	;SWITCH WAIT FOR
	IN   WAIT	;SEEK COMPLETE.
	MOV  A,B	;RESTORE ORIG. BITS.
	ANI  0F2H	;SWITCH WAIT BACK.
	OUT  DCONT
	XRA  A		;MAKE GOOD RETURN.
	POP  B		;RMSTOREE  B&C.
	RET
	ENDIF

	IF NOT FAST	;IF NOT FAST SEEK,
	PUSH H		;SAVE H&L.
	LXI  H,SECNT	;GET ADR OF SEEK ERR CTR.
	INR  M		;ONE MORE SEEK ERROR.
	POP  H		;RESTORE H&L.
	LDA  ERCN\	;GET ERROR COUNT.
	DCR  A		;DECREMENT COUNT.
	JNZ  SRETRY	;RETRY SEK.
	POP  B		;RESTORE B&C.
	LXI  H,SKMSG	;PRINT "SEEK ".
	IN   DSTAT	;READ DISK STATUS.
	ANI  91H	;LOOK AT ERROR BITS.
	MOV  D,A	;PUT IN REG D.
	JMP  ERMSG	;DO COMMON ERR MESSAGES.
	ENDIF

;
; PRINT THE MESSAGE AT H&L UNTIL A ZERO.
;
PMSG:    MOV  A,M	;GET A CHARACTER.
         ORA  A		;IF IT'S ZERO,
         RZ		;RETURN
SKMSG:	DB   0DH,0AH,'SEEK ',0
HEMSG:	DB   0DH,0AH,'HOME ',0
MNTMSG:	DB   0DH,0AH,'MOUNT ',0
SMSG:	DB   0DH,0AH,'TARBELL '
	DB   MSIZE/10+'0',MSIZE MOD 10 + '0'
	DB   'K CPM V1.4 OF 2-15-78'
	DB   0DH,0AH

	IF  STD		;IF STANDARD I/O,
	DB   'STANDARD '
	ENDIF

	IF  MSIO2	;IF MITS 2SIO,
	DB   '2SIO '
	ENDIF

	IF  ISIO2	;IF IMSAI SIO-2,
	DB  'SIO-2 '
	ENDIF

	IF  TUART	;IF TUART,
	DB  'TUART '
	ENDIF

	IF   VDM	;IF PROC TECH VDM,
	DB   'VDM '
	ENDIF

	IF  FAST	;IF FAST SEEK,
	DB  N HIGH.
	ENDIF

	IF  OTHER	;IF ANYTHING ELSE,
	JZ  LIST1	;READY WHEN HIGH.
	ENDIF

	MOV  A,C	;GET DATA BYTE.
	OUT  LDATA	;PRINT IT.
	RET		;RETURN FROM LIST.

	IF NOT VDM	;IF NOT PROC TECH VDM,
LINUL:	PUSH B		;SAVE B&C.
	MVI  B,LNULL	;GET NULL COUNT.
LINUL1:	CALL LIST1	;PRINT (CR FIRST).
	MVI  C,0	;GET NULL CHAR.
	DCR  B		;DECREMENT COUNTER.
	JNZ  LINUL1	;DO NEXT NULL.
	POP  B		;RESTORE B&C.
	MOV  A,C	;RESTORE A.
	RET		;RETURN FROM LIST.
	ENDIF

;
; NORMALLY USED TO PUNCH PAPER TAPE,  ARE ONLY NINE SECTORS
;AVAILABLE FOR CBIOS ON THE SECOND SYSTEM TRACK (1),
;THE LAST ADDRESS BEFORE THIS POINT SHOULD BE NO
;GREATER THAN THE CBIOS STARTING ADDRESS + 047F (HEX).
;THIS WILL NORMALLY BE XE7F (HEX).

;
; ERROR COUNTS.  THESE LOCATIONS KEEP TRACK OF THE
; NUMBER OF ERRRS THAT OCCUR DURING READ, WRITE,
; OR SEEK OPERATIONS.  THEY ARE INITIALIZED ONLY
; WHEN A COLD-START IS PERFORMED BY THE BOOOTSTRAP.
;
HECNT:	DB   0		;HOME ERROR COUNT.
RECNT:	DB   0		;READ ERROR COUNT.
WECNT:	DBMSIZE   EQU  24		;MEMORY SIZE.
DCOM    EQU  0F8H	;DISK CO]MAND PORT.
DSTAT   EQU  DCOM	;DISK STATUS PORT.
TRACK	EQU  DCOM+1	;1771 TRACK REGISTER.
SECT	EQU  DCOM+2	;1771 SECTOR REGISTER.
DDATA	EQU  DCOM+3	;1771 DATA PORT.
WAIT	EQU  DCOM+4	;INPUT = WAIT.
CBASE	EQU  (MSIZE-17)*1024
CPMB    EQU  CBASE+2900H	;WHERE CPM STARTS.
BOOTE   EQU  CBASE+3E00H	;WHERE CBIOS STARTS.
NSECTS  EQU  51		;NUMBER OF SECTORS TO LOAD.
        ORG  0H		;START OF COLDSTART LOADER.
BOOT:   LXI  SP,100H	;SET STACK POINTER..
         MOV  C,A	;OTHERWISE,
         CALL CONOT	;PRINT IT.
         INX  H		;INCREMENT H&L,
         JMP  PMSG	;AND GET ANOTHER.
;
; CBIOS MESSAGES
;

	IF NOT VDM	;IF NOT PROC TECH VDM,
NRMSG:	DB   'NOT READY ',0
RNMSG:	DB   'RECORD NOT FOUND ',0
CRCMSG:	DB   'CRC ',0
LDMSG:	DB   'LOST DATA ',0
BSYMSG:	DB   'BUSY ',0
WPMSG:	DB   'PROTECT ',0
WFMSG:	DB   'FAULT ',0
	ENDIF

ERRMSG:	DB   'ERROR.',0
RDMSG:	DB   0DH,0AH,'READ ',0
WTMSG:	DB   0DH,0AH,'WRITE ',0
BTMSG:	DB   'BOOT ERROR',0'FAST SEEK '
	ENDIF

	IF  DUAL	;IF DUAL DRIVE,
	DB  'DUAL '
	ENDIF

	DB  'VERSION.'
	DB   0DH,0AH,'HOW MANY DISKS? ',0
;
; WRITE A CHARACTER ON LISTING DEVICE.
;
LIST:
	IF NOT VDM	;IF NOT PROC TECH VDM,
	MVI  A,0DH	;IF IT'S A CR,
	CMP  C		;THEN HOP OUT TO
	JZ   LINUL	;NULL ROUTINE.
	ENDIF

LIST1:	IN   LSTAT	;READ LISTER STATUS.
	ANI  LRBIT	;LOOK AT READY BIT.

	IF   STD	;IF STANDARD I/O,
	JNZ  LIST1	;READY WHEN LOW.
	ENDIF

	IF   SIO2	;IF MITS, IMSAI, CROM.,
	JZ   LIST1	;READY WHEBUT IS
; NICE FOR AN INFINITE BIT BUCKET TO CHECK FILES.
;
PUNCH:
	IF NOT VDM	;IF NOT PROC TECH VDM,
	NOP		;SPACE FOR YOUR ROUTINE.
	NOP!NOP!NOP!NOP
	NOP!NOP!NOP!NOP
	NOP
	ENDIF

	RET		;RETURN FROM PUNCH.
;
;  NORMALLY USED TO READ PAPER TAPE.
; SET UP TO READ FROM CONSOLE IN STANDARD SYSTEM.
;
READER:
	IF NOT VDM	;IF NOT PROC TECH VDM,
	CALL CONIN	;READ FROM CONSOLE.
	NOP!NOP!NOP!NOP	;MORE SPACE FOR YOUR ROUTINE.
	NOP!NOP!NOP!NOP
	ENDIF

	RET		;RETURN FROM READER.

;NOTE:  AS THERE   0		;WRITE ERROR COUNT.
SECNT:	DB   0		;SEEK ERROR COUNT.
;
; TRTAB - DISK TRACK TABLE - PRESENT POSITION OF
;	HEADS FOR UP TO 4 DRIVES.
;
TRTAB:	DS   4
;
NODSKS:	DS   1		;NUMBER OF DISKS.
ERCNT:	DS   1		;ERROR COUNT FOR RETRIES.
SERCNT:	DS   1		;SEEK RETRY COUNTER.
TEMP:	DS   1		;TEMPORARY STORAGE.
TRK:	DS   1		;CURRENTLY SELECTED TRACK.
SECT:	DS   1		;CURRENTLY SELECTED SECTOR.
DMAADD:	DS   2		;CURRENT READ/WRITE ADDRESS.
DISKNO:	DS   1		;CURRENT DISK NUMBER.
         END

BOOT1:  LXI  B,2	;SET B=0, C=2.
	MVI  D,NSECTS	;D = NUMBER OF SECTORS TO LOAD.
	LXI  H,CPMB	;H&L = CPM STARTING ADDRESS.
        MOV   A,C	;GET SECTOR NUMBER (2) IN A.
RBLK:   CALL READ	;READ A SECTOR.
RBLK1:  JNZ  ERROR	;HOP OUT IF ERROR.
        DCR  D		;COUNT DOWN NUMBER OF SECTORS.
        JZ   BOOTE	;HOP OUT IF DONE.
        INR  C		;INCREMENT SECTOR NUMBER.
        MOV  A,C	;MOVE IT INTO REGISTER A.
        CPI  27		;IF IT'S LESS THAN 27,
        JC   RBLK2	;KEEP ON READING.
	MVI  C,1	;OTHERWISE SET SECTOR = 1.
        MVI   A,40H
        OUT   DCOM
        IN    WAIT
        MVI   A,1
        OUT   WAIT
        MVI   A,72H
        OUT   WAIT
        IN    WAIT
        MVI   A,0F2H
        OUT   WAIT
        INR  B
        MOV  A,B
        OUT   TRACK
        MOV   A,C
        JMP  RBLK
;
RBLK2:  MOV  A,C
        CALL READ1
        JMP  RBLK1
;
;
READ1:  OUT  SECT
        IN   DSTAT
        RRC
        MVI  A,1
        JC   RERR
        MVI  A,88H
        JMP  R; MODIFIED BY FRED KAHL 3.24.78 FOR DRIVE VERIFICATION
; FORMAT
; FORMATTING PROGRAM FOR TARBELL FLOPPY DISK INTERFACE.
; MOST DISKS THAT COME FROM THE MANUFACTURER ARE
; ALREADY FORMATTED IN THE IBM FORMAT, ESPECIALLY IF
; YOU SPECIFY THIS.  THERE ARE TIMES, HOWEVER, THAT
; YOU MAY WANT TO FORMAT OR REFORMAT A DISK YOURSELF.
; USUALLY THIS IS WHEN THE SYSTEM CRASHED AND
; MESSED UP THE DISK SO BADLY THAT YOU CAN NO LONGER
; WRITE ONTO IT OR READ FROM IT IN THE NORMAL FASHION.
; SOMETIMES SURPLU ROUTINE
; RUN PROPERLY.  IT WAS FOUND THAT THE STEP ONE-SHOT
; WAS NOT ALWAYS LONG ENOUGH TO RELIABLY STEP THE
; HEAD.  THIS IS NOT A PROBLEM DURING NORMAL SEEK
; OPERATIONS, SINCE THE 1771 AUTOMATICALLY STEPS A
; FEW TRACKS AHEAD TO LOOK FOR THE CORRECT TRACK.
;
; ***** CAUTION *****
; DO NOT RUN THIS PROGRAM WITH A DISK THAT HAS DATA
; OR PROGRAMS ON IT THAT YOU WANT TO SAVE.  THIS PROGRAM
; ERASES ALL MATERIAL ON THE DISK THAT IT FORMATS.
; 
BDOS:	  EQU  0005	   ;BDOS ENTRY POINT
DCOM       1
	DB 0DH,0AH,'IS BLANK DISK READY TO FORMAT (Y-N)? $'
DISKTMP DB 0
;
START:	MVI C,25		;INTERROGATE DRIVE NUMBER
	CALL BDOS
	STA DISKTMP		;SAVE COPY CURRENT DRIVE
	MVI C,9			;GET CODE FOR PRINT
	LXI D,MSG1		;GET ADDR OF MSG
	CALL BDOS
	MVI C,1			;GET CONSOLE CHAR
	CALL BDOS
	STA DISKNO		;PUT IN MSG
	SBI 65			;CONVERT TO BINARY
	CALL SELDSK		;SET DRIVE # TO FORMAT
NXTDSK:	MVI C,9			;GET CODE FOR PRINT
	LXI D,MSG2		;GET ADDR OF MSG
	CALL BDOS	
	MVI C,1			;GET CONSOLE CHAR
	CALL BDOS
	CPI  SECTORS -1 
          MVI  B,46        ;GAP 4 PREINDEX 40 BYTES OF FF
          MVI  A,0F4H      ;LOAD TRACK WRITE COMMAND
          OUT  DCOM        ;ISSUE TRACK WRITE
; WRITE PREINDEX FILL
PREIND    IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          XRA  A           ;LOAD PREINDEX FILL
          OUT  DDATA       ;WRITE IT ON DISK
          DCR  B           ;COUNT =COUNT - 1
          JNZ  PREIND      ;GO BACK TILL B =0
;EADE
;
READ:   OUT  SECT
        IN   DSTAT
        RRC
        MVI  A,1
        JC   RERR
        MVI  A,8CH
READE:  OUT  DCOM
RLOOP:  IN   WAIT
        ORA  A
        JP   RDONE
        IN   DDATA
        MOV  M,A
        INX  H
        JMP  RLOOP
;
RDONE:  IN   DSTAT
RERR:   ANI  9DH
        RET
;
;
ERROR:  CMA
        OUT  0FFH
        HLT
;
;
        ORG  07DH
        JMP  0
        END
S DISKS ARE AVAILABLE THAT ARE
; NOT FORMATTED PROPERLY.
;
; THIS PROGRAM FORMATS A BLANK DISK INTO A IBM FORMAT.
; NOTE THAT IT IS COMPLETELY SELF-CONTAINED, SO
; THAT NO OPERATING SYSTEM IS REQUIRED TO RUN IT.  NOTE
; THEREFORE, THAT IF YOUR CONSOLE I/O SET-UP IS
; DIFFERENT THAN THAT OF THIS PROGRAM, YOU WILL NEED
; TO MAKE THE NECESSARY CHANGES.
;
; DURINTG THE DEVELOPMENT OF THIS PROGRAM, IT WAS
; DETERMINED THAT THE 1000 PF CAPACITOR C4 SHOULD BE
; CHANGED TO A VALUE OF .1 MFD TO MAKE THISEQU  0F8H        ;DISK COMMAND PORT
DSTAT     EQU  0F8H        ;DISK STATUS PORT
TRACK     EQU  0F9H        ;DISK TRACK COMMAND
SECTP     EQU  0FAH        ;DISK SECTOR PORT
DDATA     EQU  0FBH        ;DISK DATA PORT
WAIT      EQU  0FCH        ;DISK WAIT CONTROL PORT
          ORG  0100H       ;LOAD & EX HERE
;
	JMP START		;JUMP AROUND MESSAGES
MSG1:	DB 'MICRO-SERVE DISK FORMATTING PROGRAM'
	DB 0DH,0AH,0DH,0AH
	DB 'DRIVE TO BE FORMATTED? $'
MSG2:	DB 0DH,0AH,'READY TO FORMAT IN DRIVE '
DISKNO:	DS'Y'			;WAS IT A YES
	JZ BEGIN		;START FORMATTING
	LDA DISKTMP		;GET COPY OF ORIG LOGGED DISK
SELDSK:	CMA
	ADD A	
	ADD A
	ADD A	
	ADD A
	ORI 2
	OUT WAIT
	RET
;
;
; RESTORE DRIVE TO TRACK 00
;
BEGIN:    MVI A,3          ;LOAD RESTORE CMD
          OUT  DCOM        ;ISSUE HOME CMD
	  IN WAIT    	;WAIT FOR HOME
          MVI  C,0         ;SET TRACK NUMBER TO 0
          MVI  H,77        ;SET TOTAL TRACKS TO 77
NXTTRK    MVI  D,1         ;SECTOR CNT TO 0
          MVI  E,26        ;SET MAX #
; WRITE ADDRESS MARK ON TRACK
;
          IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          MVI  A,0FCH      ;LOAD ADDRESS MARK
          OUT  DDATA       ;WRITE IT ON DISK
;
; POST INDEX GAP
;
          MVI  B,26        ;SET # OF BYTES
POSTID    IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP  ERRMSG       ;JMP OUT IF ERROR
          MVI  A,0FFH      ;LOAD FILL DATA
          OUT  DDATA       ;WRITE IT ON DISK
          DCR  B           ;COUNT = COUNT - 1
          JNZ  POSTID      ;IF NOT 0 GO BACK
;
; PRE ID SECTION
;
ASECT     MVI  B,6         ;GET # OF BYTES
SECTOR    IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          XRA  A           ;MAKE A = 0
          OUT  DDATA       ;WRITE IT ON TRACK
          DCR  B           ;COUNT = COUNT=1
          JNZ  SECTOR      ;JMP BACK IF NOT DONE
;
; WRITE IDOF 00
;
          IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          XRA  A           ;SET A TO 0
          OUT DDATA        ;WRITE IT ON DISK
;
; WRITE SECTOR # ON DISK
;
          IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          MOV  A,D         ;GET SECTOR #
          OUT DDATA        ;WRITE IT ON DISK
;
; ONE MORE BYTE 0
;
          IN   WABYTES 00
;
          MVI  B,17        ;SET COUNT
PREDAT    IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          XRA  A           ;SET A TO 00
          OUT  DDATA       ;WRITE IT ON DISK
          DCR  B           ;REDUCE COUNT BY 1
          JNZ  PREDAT      ;GO BACK IF NOT DONE
;
; DATA ADDRESS MARK
;
          IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERR         IN   WAIT        ;WAIT TILL DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          MVI  A,0F7H      ;GET CRC BYTE
          OUT  DDATA       ;WRITE IT ON DISK
;
; END OF SECTOR FILL
;
	  DCR  E	   ;REDUCE SECTOR COUNT
	  JZ  ENDTRK	   ;IF 0 DO END OF TRACK RTN
DATGAP    IN WAIT          ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS   
          JP   ERRMSG      ;JMP OUT IF ERROR
	  MVI  A,0FFH	   ;GET FILL CHARACTER
          OUT  DDATA RR PRINT RTN
          INR  C           ;BUMP TRACK #
          DCR  H           ;TRK COUNT =COUNT -1
          JNZ  BMPTRK      ;IF NOT 0 THEN DO MORE
	  JMP NXTDSK	   ;GO AGAIN

BMPTRK    MVI  A,43H       ;LOAD STEP IN
          OUT  DCOM        ;STEP IN
	  IN  WAIT         ;WAIT TIL DONE
	  ORA A            ;SET FLAGS
	  IN   WAIT	   ;WAIT FOR DRQ
	  IN   DSTAT       ;CHECK STATUS
	  ANI  0FFH	   ;MASK NON ERR BITS
	  JNZ  ERRMSG
	  JMP  NXTTRK
;
;ERROR ROUTINE
;
ERRMSG	  STA 0000H
	   ADDRESS MARK
;
          IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;IF ERROR JMP OUT
          MVI  A,0FEH      ;GET ADDRESS MARK
          OUT  DDATA       ;WRITE IT ON DISK
;
; WRITE TRACK NUMBER ON DISK
;
          IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          MOV  A,C         ;GET TRACK NUMBER
          OUT  DDATA       ;WRITE IT ON DISK
;
; WRITE ONE BYTE IT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          XRA  A           ;SET A TO 00
          OUT  DDATA       ;WRITE IT ON DISK
          INR  D           ;BUMP SECT. #
;
; WRITE 2 CRC'S ON THIS SECTOR
;
          IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;SET FLAGS
          JP   ERRMSG      ;JMP OUT IF ERROR
          MVI  A,0F7H      ;GET CRC PATTERN
          OUT DDATA        ;WRITE IT ON DISK
;
; PRE DATA 17 OR
          MVI  A,0FBH      ;GET DATA ADDRESS MARK
          OUT  DDATA       ;WRITE IT ON DISK
;
; FILL DATA FIELD WITH E5
;
          MVI  B,128       ;SET FIELD LENGTH
DFILL     IN   WAIT        ;WAIT FOR DRQ
          ORA  A           ;YOU KNOW WHAT
          JP   ERRMSG      ;HAPPENS HERE BY NOW
          MVI  A,0E5H      ;GET FILL BYTE
          OUT  DDATA       ;WRITE IT ON DISK
          DCR  B           ;DROP 1 FROM COUNT
          JNZ  DFILL       ;DO TILL 00
;
; WRITE CRC'S
;
       ;WRITE IT ON DISK
	  JMP  POSTID-2    ;GO BACK FOR MORE
;
; DO TRACK & SECTOR HOUSE KEEPING
;
ENDTRK    IN   WAIT        ;WAIT FOR DRQ OR INTRQ
          ORA  A           ;SET FLAGS
          JP   DONE        ;JMP OUT IF ERROR
	  MVI  A,0FFH	   ;LOAD A WITH FFH
          OUT  DDATA       ;WRITE IT ON DISK
          JMP  ENDTRK      ;DO UNTIL INTRQ
;
; ERROR SORT ROUTINE
;
DONE      IN   DSTAT       ;READ STATUS
          ANI  0FFH        ;TEST FOR FLAG
	  JNZ  ERRMSG	   ;IF ERR GO TO EHLT
          
TITLE		SECRETS OF CP/M VERSION 1.4
FILENAME	SECRET14.DOC
AUTHOR		Robert A. Van Valzah     4/27/78


	M Y S T E R Y   B D O S   F U N C T I O N S

FUNC	ACTION
----	------
 28	MAKE CURRENT DRIVE READ ONLY (R/O)

 29	RETURN R/O VECTOR.  RETURNS A BYTE VALUE (IN REG A)
	WITH A "1" IN BIT POSITIONS OF R/O DISKS, LEAST
	SIGNIFICANT BIT CORRESPONDING TO DRIVE A.

 30	SET DIRECTORY I/O DMA ADDRESS.  INITIALLY SET TO 80H.
	DISK DATA I/O CONTINUES AT THE LAST ADDRESS SET BY
	FUNCTION 26.


	B O O CP simply signs on and
prompts the user for input.  The task at hand, therefore, is to
fill this buffer so its contents will be executed as a CCP
command as the CCP is loaded.  Assuming you have SID and desire
a command length of <=16 characters, this is quite simple:

   1)	Load an image of your operating system into low memory
	(ready for SYSGEN).  EX:  SID CPMnn.COM

   2)	Type "I" followed by the command line as you like CCP
	to execute it.  EX:  ISTAT.COM

   3)	Type	M80,90,987

   4)	Booep 4 above.
; TARBELL CP/M COLD START LOADER
; STANDARD VERSION OF 10-11-77
;
; THIS PROGRAM IS LOADED AT LOCATION
; 0 BY THE BOOTSTRAP PROGRAM, AND RUN.
; IT'S PURPOSE IS TO LOAD AND RUN THE MAIN
; CP/M DISK OPERATING SYSTEM AT THE TOP OF
; THE MEMORY IN USE.
;
MSIZE	EQU  24		;MEMORY SIZE IN DECIMAL KB.
DCOM    EQU  0F8H
DSTAT   EQU  0F8H
TRACK   EQU  0F9H
SECT    EQU  0FAH
DDATA   EQU  0FBH
WAIT    EQU  0FCH
CBASE   EQU  (MSIZE-17)*1024
CPMB    EQU  CBASE+2900H
BOOTE   EQU  CBASE+3E00H
NSECTS  EQU 
        MOV  A,C
        CPI  27
        JC   RBLK2
        MVI  C,1
        INR  B
        JMP  RBLK
;
RBLK2:  MOV  A,C
        CALL READ1
        JMP  RBLK1
;
;
READ1:  OUT  SECT
        IN   DSTAT
        RRC
        MVI  A,1
        JC   RERR
        MVI  A,88H
        JMP  READE
;
READ:   OUT  SECT
        IN   DSTAT
        RRC
        MVI  A,1
        JC   RERR
        MVI  A,8CH
READE:  OUT  DCOM
RLOOP:  IN   WAIT
        ORA  A
        JP   RDONE
        IN   DDATA
T   A N D   G O   M O D   F O R   C C P

	There are some dedicated CP/M applications where it
would be nice if a cold start would load CP/M and then load a
transient and give it control.  This could be used to make a
disk which would always power up in BASIC, for instance.  This
capability has been built into CP/M version 1.4.

THEORY
------
	When the CCP is loaded, it checks its console input
buffer to see if a command is waiting.  As supplied by Digital
Research, this buffer is empty and the Ct and SYSGEN a disk in the normal manner.

	The disk will now boot and execute the command typed
in step 2 above.

	If you don't have SID or desire a command line longer
than 16 characters:

   1)	Perform step 1 above (use DDT if needed).

   2)	Patch the length of your command into location 987H.

   3)	Patch the ASCII of the command into memory starting at
	location 988H, following it with the Digital Research
	copyright message "COPYRIGHT (C) 1978, DIGITAL
	RESEARCH  ".

   4)	Perform st 51		;NUMBER OF SECTORS.
        ORG  0
BOOT:   LXI  SP,100H
BOOT1:  LXI  B,2
        MVI  D,NSECTS
        LXI  H,CPMB
RBLK    MOV  A,B
        OUT  DDATA
        IN   DSTAT
        RRC
        MVI  A,1
        JC   ERROR
        MVI  A,13H
        OUT  DCOM
        IN   WAIT
        ORA  A
        MVI  A,1
        JM   ERROR
        IN   DSTAT
        ANI  91H
        JNZ  ERROR
        MOV  A,C
        CALL READ
RBLK1:  JNZ  ERROR
        DCR  D
        JZ   BOOTE
        INR  C        MOV  M,A
        INX  H
        JMP  RLOOP
;
RDONE:  IN   DSTAT
RERR:   ANI  9DH
        RET
;
;
ERROR:  CMA
        OUT  0FFH
        HLT
;
;
	ORG  7DH
	JMP  0
	END
Dear Customer,

This disk contains useful public-domain (can be copied) CP/M
compatible software.

CBIOS24.ASM - Standard input/output system for Tarbell CP/M
and Tarbell Floppy Disk Interface (FDI).  Notice that there
is now a VDM-1 driver in it, which may be activated by
setting the proper EQU's.

SBOOT24.ASM - Source for the standard Tarbell FDI coldstart
loader program, set up for 24k.

COPY.COM, COPY.ASM - Command and source files for a copy
program from the CP/M user's group, which has b) followed by a carriage-return will
repeat the operation.

TAPELIB.COM, TAPELIB.DOC are the command file and
documentation packages for an extensive Tarbell Cassette
Interface-CP/M tape library system, written by
Sam Singer.  It provides capabilities similar to the
new PIP, only for cassette tape.  For example, you
can dump all the files, or all the .ASM files to cassette.

DSKCAS.ASM, CASDSK.ASM - These are the sources for simple
Tarbell Cassette-CP/M transfers.  They are somewhat
inefficient hen it
comes up with it's opening message.  This program also
needs assembling before use.

FBIOS24.ASM - This is the assembly-language source for the
dual PerSci version of the Basic Input/Output System.  It
is usually the same as the standard version, except for the
DUAL and FAST EQU statements.  Notice that it also contains
a VDM driver.  Follow the procedure in the CP/M
operating system notes entitled "Making Changes in the CP/M
System" in order to integrate this module into your system.

FB;MASTER CATALOG UPDATE - UCAT.ASM
;01/07/78 BY WARD CHRISTENSEN
;01/10/78 ADD:
;		(RUN UCAT)
;		ERA MAST.BAK
;		REN MAST.BAK=MAST.CAT
;		REN MAST.CAT=NEW.CAT
;		ERA NAMES.SUB
	ORG	100H
BSIZE	EQU	4096	;DK BUF SIZE (TIMES 3)
IGNSIZE	EQU	1024	;BUFF FOR IGNORED NAMES
TEST	EQU	0	;TESTING?
	MACLIB	SEQIO
FILERR	SET	EXIT	;EXIT IF ERRORS
MOVE	MACRO	?F,?T,?L
	MVI	B,?L
	LXI	D,?F
	LXI	H,?T
	CALL	MOVER
	ENDM
COMPARE	MACRO	?F1,?F2,?L
	MVI	B,?L
	LXI	D,?F1
	LXI	H,?F2
	CALL	COMPR
	ENDM
;
;SAVE CP/ECTORY$'
;
NAMEOK	MOVE	NADAT+1,DKNAME,7
	MOVE	NADAT+9,DKNAME+9,3
;
;READ IN THE NAMES TO BE IGNORED (I.E. NOT
;CATALOGED).  THEY ARE AT THE FRONT OF MAST CAT.
;THEY ARE SIMPLY A LIST OF FILENAME.FILETYPE (CR/LF)
;WITH THE FIRST HAVING A ( BEFORE IT, AND THE
;LAST HAVING A ) AFTER IT.
;
	GET	MASTIN	;GET THE LEADING '('
	JZ	NOIGN	;IF EOF
	CPI	'('
	JNZ	NOIGN
	PUT	MASTOUT
	LXI	H,IGNORE ;POINT TO BUFFER
	LXI	B,IGNSIZE ;FOR BUFFER OVERFLOW TEST
IGNRD	PUSH	B
	PUSH	H
	GET	MASTIN
	JZ	IGNEOF	;UNEeen
modified to work with the Tarbell FDI.  To use it, type
"COPY ALL", "COPY SYSTEM", or "COPY DATA".
After typing in the command, it will come back and wait
for a carriage-return so you can put your master and
fresh disks in.  The first form copies the whole disk,
track by track, from A to B.  The second form copies
just the first two tracks, and the third copies all
but the first two tracks.  After it comes back with the
ending message, a carriage-return will do a warm boot,
and an ampersand (&compared to those of TAPELIB, since they
use only 128-byte buffers.  They are used by typing:
DSKCAS filename , or CASDSK filename.  Of course they
have to be assembled first.

FORMAT.ASM - This program, written by Dick Culbertson,
allows you to completely format a blank or crashed disk.
It wipes out whatever is on the disk, so be sure you
have all the information off the disk that you need.  Also
be sure to remove the disk you have in drive A and
only have the one you want reformatted in there, wOOT24.ASM - This is the assembly-language source for the
dual PerSci version of the coldstart loader program.

BASIC.COM, RUN.COM - These are the command modules for 
the BASIC-E compiler and run-time interpreter, written by
Gordon Eubanks, Jr.
M'S STACK
;
	POP	H	;GET CP/M RET ADDR
	SHLD	EXIT+1	;SAVE IN EXIT JMP
	LXI	SP,STACK
	FILE	INFILE,MASTIN,,MAST,CAT,BSIZE
	FILE	INFILE,NAMES,,NAMES,SUB,BSIZE
	IF	NOT TEST
	FILE	OUTFILE,MASTOUT,,NEW,CAT,BSIZE
	ENDIF
	FILE	SETFILE,BAK,,MAST,BAK
;
;SETUP THE FILES
;
INITRD	CALL	READNA	;READ NAMES FILE
;
;IF NAME IS $$$.SUB THEN SKIP IT
;
	COMPARE	NADAT,SUBNAME,12
	JZ	INITRD
;
;CHECK FOR '-DISKNAME' HAVING BEEN READ
;
	LDA	NADAT
	CPI	'-'
	JZ	NAMEOK
	CALL	MSGXIT
	DB	'++NO ''-NAME'' IN DIRXPECTED EOF
	PUSH	PSW	;SAVE CHAR
	PUT	MASTOUT
	POP	PSW
	POP	H
	POP	B
	MOV	M,A
	INX	H
	CPI	')'
	JZ	IGNEND	;TABLE IS LOADED
	DCX	B	;MORE ROOM IN TABLE?
	MOV	A,B
	ORA	C
	JNZ	IGNRD
;TABLE OVERFLOW
	CALL	MSGXIT
	DB	'++TOO MANY IGNORE NAMES FOR TABLE$'
NOIGN	CALL	MSGXIT
	DB	'++NO IGNORE NAMES IN MAST.CAT$'
IGNEOF	CALL	MSGXIT
	DB	'++EOF READING FOR IGNORE NAMES.'
	DB	0DH,0AH,'MAY BE MISSING ) AFTER LAST NAME.$'
IGNEND	GET	MASTIN
	JZ	IGNEOF
	PUSH	PSW
	PUT	MASTOUT
	POP	PSW
	CPI	0AH
	JNZ	IGNEND	;DELETE CR/LF
;PRIME THE BUFFERS
;
NAMELP	CALL	READNA	;READ NAME INTO NADAT
MASTLP	CALL	READMI	;READ MASTER INTO MIDAT
;IF EOF ON BOTH FILES, WE ARE ALL DONE
COMPLP	LDA	NAEOFLG	;NAME FILE EOF?
	ORA	A
	JZ	NOTEOF	;..NO
	LDA	MIEOFLG	;MASTER IN EOF?
	ORA	A
	JNZ	ALLDONE	;YES, THAT'S IT.
NOTEOF	COMPARE	NADAT,MIDAT,25
	JZ	EQUAL
	JC	WRITEN
;
;MASTER IS LOWER - WRITE IT IF FOR ANOTHER DISK
;
	COMPARE	MIDSK,DKNAME,12 ;SAME DISK?
	JZ	DELMI	;DELETING MIDAT
	MOVE	MIDAT,MODAT,25
	CALL	WRITEMO
 CHARACTERS
	MVI	M,'.'
	INX	H
	MVI	B,3	;TYPE LENGTH
	CALL	READNAC
	MVI	M,','
;
;IF THIS IS A NAME NOT TO BE CATALOGED,
;READ THE NEXT
;
	LXI	D,IGNORE	;GET IGNORE TABLE
IGNLP	LXI	H,NADAT
	MVI	B,12	;# OF CHARS TO MATCH
IGNCLP	LDAX	D
	CMP	M
	JZ	IGNMAT	;MATCHED
	MOV	A,M	;GET CHAR
	CPI	' '	;SPACE?
	JZ	IGNMAT1
;
;GET NEXT ENTRY
;
IGNEXTE	LDAX	D
	INX	D
	CPI	')'	;END OF TABLE?
	RZ		;..YES, RETURN
	CPI	0AH	;NEXT LINE?
	JNZ	IGNEXTE
	JMP	IGNLP
;
;CHAR MATCHED
;
IGNMAT	INX	D	;SKIP MATCH 'Z'-40H	;EOF?
	RNZ
	STA	NAEOFLG
	RET
NAEND	MVI	M,' '
	INX	H
	DCR	B
	JNZ	NAEND
	RET
NAEOF	MVI	M,0FFH
	INX	H
	DCR	B
	JNZ	NAEOF
	MVI	A,1
	STA	NAEOFLG
	RET
;
;READ MASTER IN NAME
;
READMI	LXI	H,MIDAT
	CALL	MINAME	;GET FILE NAME
	MVI	M,','	;SEPARATOR
	INX	H
	CALL	MINAME	;GET DISK NAME
	RET
;
;READ MASTER IN, 1 FIELD
;
MINAME	MVI	B,8
	CALL	READMIC	;GET CHARS
	MVI	M,'.'
	INX	H
	MVI	B,3
	CALL	READMIC	;GET TYPE
	RET
;
;READ CHARS INTO MASTER NAME
;
READMIC	LDA	MIEOFLG
	ORA	A
	UMP COUNT OF ENTRIES WRITTEN
;
WRITEMO	LXI	H,COUNT+3
BUMP	MOV	A,M	;GET COUNT DIGIT
	CPI	' '
	JNZ	BUMPNB
	MVI	A,'0'
BUMPNB	INR	A
	MOV	M,A
	CPI	'9'+1	;TIME TO CARRY?
	JNZ	BUMPD	;..NO, DONE
	MVI	M,'0'
	DCX	H
	JMP	BUMP
BUMPD	LXI	H,MODAT
	MVI	B,25
WRMOL	MOV	A,M
	CPI	' '	;NULL CHAR?
	JZ	WRSKIP
	PUSH	B
	PUSH	H
	IF	NOT TEST
	PUT	MASTOUT
	ELSE
	PUT	CON
	ENDIF
	POP	H
	POP	B
WRSKIP	INX	H	;POINT TO NEXT CHAR
	DCR	B
	JNZ	WRMOL	;LOOP UNTIL DONE
	MVI	A,0DH
	IF	NOT TEST
	PUT	MASTOUT
	ELSE

;COMPARE ROUTINE (DE)<=>(HL), LENGTH IN B
;
COMPR	LDAX	D
	CMP	M
	RNZ		;RET W/NON ZERO SET
	INX	D
	INX	H
	DCR	B
	JNZ	COMPR
	RET		;ZERO SET, SHOWS =
;
;ALL DONE - WRITE EOF TO OUTPUT, RETURN
;
ALLDONE	EQU	$
	MVI	A,'Z'-40H ;EOF CHAR
	IF	NOT TEST
	PUT	MASTOUT
	FINIS	MASTOUT
	ENDIF
;
;RUN WAS SUCCESSFUL - SET FINAL FILE DISPOSITIONS
;
	ERASE	BAK		;ERA CAT.BAK
	ERASE	NAMES		;ERA NAMES.SUB
	RENAME	BAK,MASTIN	;REN MAST.BAK=MAST.CAT
	RENAME	MASTIN,MASTOUT	;REN MAST.CAT=MAST.NEW
	CALL	MSGX	JMP	MASTLP
;
;DELETE MASTER IN
;
DELMI	LXI	D,DELMSG
	LXI	H,MIDAT
	CALL	MESG
	JMP	MASTLP
DELMSG	DB	'DEL: $'
;
;NAME IS LOWER - WRITE IT
;
WRITEN	MOVE	NADAT,MODAT,25
	CALL	WRITEMO
;
;PRINT THAT NAME WAS ADDED
;
	LXI	D,ADDMSG
	LXI	H,NADAT
	CALL	MESG
	CALL	READNA	;READ NEXT NAME
	JMP	COMPLP
ADDMSG	DB	'ADD: $'
;
;BOTH FILES EQUAL
;
EQUAL	MOVE	MIDAT,MODAT,25
	CALL	WRITEMO	;WRITE OUT MASTER
	JMP	NAMELP	;READ BOTH
;
;READ NAME FILE
;
READNA	LXI	H,NADAT
	MVI	B,8
	CALL	READNAC	;READCHAR
IGNMAT1	INX	H
	DCR	B
	JNZ	IGNCLP	;LOOP UNTIL DONE
;
;NAME IS TO BE DELETED
;
	JMP	READNA	;READ NEXT NAME
;
;READ CHARACTERS INTO NAME BUFFER
;
READNAC	LDA	NAEOFLG	;EOF ON NAMES?
	ORA	A
	JNZ	NAEOF	;YES, PAD W/0FFH
	PUSH	H
	PUSH	B
GETNA	GET	NAMES
	CPI	0AH
	JZ	GETNA	;IGNORE LF
	POP	B
	POP	H
	CPI	'.'	;END?
	JZ	NAEND
	CPI	0DH	;END?
	JZ	NAEND
	CPI	'Z'-40H	;EOF?
	JZ	NAEOF
	MOV	M,A
	INX	H
	DCR	B
	JNZ	READNAC
	PUSH	B
	PUSH	H
	GET	NAMES	;KILL DELIMITER CHAR
	POP	H
	POP	B
	CPI	JNZ	MIEOF
	PUSH	H
	PUSH	B
GETMI	GET	MASTIN
	CPI	0AH	;IGNORE LF
	JZ	GETMI	;L/F'S
	POP	B
	POP	H
	CPI	','
	JZ	MIEND
	CPI	'.'
	JZ	MIEND
	CPI	0DH
	JZ	MIEND
	CPI	'Z'-40H	;EOF?
	JZ	MIEOF
	MOV	M,A
	INX	H
	DCR	B
	JNZ	READMIC
	PUSH	B
	PUSH	H
	GET	MASTIN	;GET DELIMITER
	POP	H
	POP	B
	CPI	'Z'-40H	;EOF?
	RNZ
	STA	MIEOFLG
	RET
MIEND	MVI	M,' '
	INX	H
	DCR	B
	JNZ	MIEND
	RET
MIEOF	MVI	M,0FFH
	INX	H
	DCR	B
	JNZ	MIEOF
	STA	MIEOFLG	;SHOW EOF
	RET
;
;WRITE AN ENTRY TO MASTER OUT
;ALSO B
	PUT	CON
	ENDIF
	MVI	A,0AH
	IF	NOT TEST
	PUT	MASTOUT
	ELSE
	PUT	CON
	ENDIF
	RET
;
;PRINT MESSAGE IN DE, THEN NAME IN HL
;
MESG	PUSH	H
	MVI	C,@MSG
	CALL	@BDOS
	POP	H
	MVI	B,12	;NAME + '.' + TYPE
MESGL	PUSH	H
	PUSH	B
	MOV	A,M	;GET CHAR
	CPI	' '
	JZ	MESGS	;SKIP IF ' '
	PUT	CON
MESGS	POP	B
	POP	H
	INX	H
	DCR	B
	JNZ	MESGL
	MVI	A,0DH
	PUT	CON
	MVI	A,0AH
	PUT	CON
	RET
;
;MOVE SUBROUTINE (DE)=>(HL), LEN IN (B)
;
MOVER	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	MOVER
	RET
;IT
	DB	'MAST.CAT HAS '
COUNT	DB	'     ENTRIES.$'
;
MSGXIT	POP	D	;GET MSG
	MVI	C,@MSG
	CALL	@BDOS
EXIT	JMP	$-$	;TO CP/M RETURN ADDR
	DS	50	;STACK SPACE
STACK	EQU	$
NAEOFLG	DB	0	;NAME FILE EOF FLAG
MIEOFLG	DB	0	;MASTER IN EOF FLAG
NADAT	DB	'XXXXXXXX.YYY,'
DKNAME	DB	'        .   '
MIDAT	DB	'XXXXXXXX.YYY,'
MIDSK	DB	'XXXXXXXX.YYY'
MODAT	DB	'XXXXXXXX.YYY,XXXXXXXX.YYY'
SUBNAME	DB	'$$$     .SUB'
;NAMES TO BE IGNORED READ IN HERE:
IGNORE	DB	')'	;DUMMY END OF TABLE
	DS	IGNSIZE
BUFFERS	EQU	$
MEMSIZE	EQU	BUFFERS+@NXTB
;QCAT.ASM
;V0.6
;6/23/78 QUICK CATALOG ROUTINE
;
;DEFINE MOVE MACRO FOR CONVENIENCE
;
MOVE	MACRO	?F,?T,?L,?I
	IF	NOT NUL ?F
	LXI	D,?F
	ENDIF
	IF	NOT NUL ?T
	LXI	H,?T
	ENDIF
	IF	NOT NUL ?L
	MVI	B,?L
	ENDIF
	IF	NOT NUL ?I
	LOCAL	H,Z
	CALL	Z
H	DB	?I
Z	MVI	B,Z-H
	POP	D
	ENDIF
	CALL	MOVER
	ENDM
;CPM FUNCTION MACRO -
;	CPM FNC,ADDR
CPM	MACRO	?F,?A,?T
	PUSH	B
	PUSH	D
	PUSH	H
	IF	NOT NUL ?A
	LXI	D,?A
	ENDIF
	IF	NOT NUL ?T
	MOV	E,A	;;FOR TYPE
	ENDIF
	MVI	C,?F
	CALL	BDOS
	POP	H
NAME
NONAME	PUSH	H
CATMSG	CALL	ILPRT
	DB	'LOAD DISK TO BE CATALOGED, '
	DB	'THEN PRESS D: ',0
	CPM	RDCON
	ANI	5FH	;MAKE UPPER CASE
	CPI	'D'
	JNZ	CATMSG
;MAKE FCB ALL '?'
	MOVE	,FCB+1,,'???????????'
;READ THE DIRECTORY ENTRIES
;
	POP	H
	MVI	C,SRCHF
	JMP	CALLB
LOOP	MVI	C,SRCHN
CALLB	PUSH	H
	LXI	D,FCB
	CALL	BDOS
	POP	H
	INR	A
	JZ	NOMORE
;
;MOVE THE NAME INTO THE BUFFER
;
	DCR	A	;GET BACK ORIG VALUE
	ANI	3
	PUSH	H
	MOV	L,A
	MVI	H,0
	DAD	H	;X32
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXIPARE LENGTH
CLCLP	LDAX	D
	CMP	M
	JC	NEXTC
	JNZ	DIFF
SAME	INX	D
	INX	H
	DCR	B
	JNZ	CLCLP
NEXTC	POP	H
	POP	D
	XCHG
NEXTC2	DCR	C	;MORE?
	JNZ	COMPR	;CHECK NEXT 2
;
;COMPLETED PASS THRU BUFF
;
	JMP	NEXTS
;
;UNEQUAL COMPARE
;
DIFF	POP	H
	POP	D	;GET POINTERS
;SWAP
	MVI	B,14
	PUSH	B
SWAP	MOV	C,M
	LDAX	D
	MOV	M,A
	MOV	A,C
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	SWAP
	POP	B
	JMP	NEXTC2
;
;SORT ALL DONE - WRITE 'NAMES.SUB'
;
DONE	LDA	BUFF
	CPI	'-'
	JZ	NAMEOK
	CALL	ILPRT
	DB	'++MISENDADDR+1
	INR	A
	CMP	D
	JNC	WRLP
	CPM	STDMA,80H
	CPM	CLOSE,FCB
	CALL	ERXIT
	DB	'++DONE.  NOW ISSUE COMMAND:',0DH,0AH
	DB	'UCAT$'
WRERR	CALL	ERXIT
	DB	'++WRITE ERROR$'
BADMAKE	CALL	ERXIT
	DB	'++CAN''T MAKE NAMES.SUB$'
;
;INLINE PRINT
;
ILPRT	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
	CALL	TYPE
	XTHL
ILPLP	MOV	A,M
	CALL	TYPE
	INX	H
	MOV	A,M
	ORA	A
	JNZ	ILPLP
	INX	H
	XTHL
	RET
;
;TYPE CHAR IN A
;
TYPE	CPM	WRCON,,TYPE
	RET
;
;CHAR MOVE ROUTINE, (DE) -> (HL) LEN IN B
;
MOVER	LDAX	D

	POP	D
	POP	B
	ENDM
;
	ORG	100H
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
;
;SAVE THE INPUT DISK NAME, IF THERE IS ONE
;
	LXI	H,BUFF
	LDA	FCB+1
	CPI	' '
	JZ	NONAME
	CPI	'-'
	JZ	GOTDASH
BADNAME	CALL	ERXIT
	DB	'++MUST USE DISK NAME WITH ''-'' AS '
	DB	'THE FIRST CHARACTER,',0DH,0AH
	DB	'AND NNN AS THE FILETYPE$'
GOTDASH	LDA	FCB+9
	MOV	A,M
	CPI	' '
	JZ	BADNAME
	MOVE	FCB+1,BUFF,8
	MOVE	,,,'.'
	MOVE	FCB+9,,3
	MVI	M,0DH
	INX	H
	MVI	M,0AH
	INX	H
	MVI	A,1
	STA	FCB	;COUNT THE '-' 	D,80H
	DAD	D
;HL NOW POINTS TO ENTRY
	XCHG
	INX	D	;SKIP FIRST BYTE
	POP	H
	MOVE	,,8
	MVI	M,'.'
	INX	H
	MOVE	,,3
	MVI	M,0DH
	INX	H
	MVI	M,0AH
	INX	H
;INCREMENT FILE COUNT
	LDA	FCT
	INR	A
	STA	FCT
	JMP	LOOP	;GET NEXT
;
;NO MORE ENTRIES
;
NOMORE	MVI	M,'Z'-40H
	SHLD	ENDADDR	;SAVE FOR WRITE
NEXTS	LDA	FCT	;GET FILE COUNT
	DCR	A
	STA	FCT
	JZ	DONE	;ALL DONE
;
;PASS THRU THE BUFF, SORTING IT.
;
	MOV	C,A	;SAVE COUNT
	LXI	D,BUFF
COMPR	LXI	H,14
	DAD	D
	PUSH	D
	PUSH	H
	MVI	B,14	;COMSING ''-'' NAME ON DISK OR '
	DB	'QCAT COMMAND',0DH,0AH
	DB	'RELOAD CATALOG DISK, PRESS RETURN',0
	CPM	RDCON
	CALL	ERXIT
	DB	'++RUN QCAT, THIS TIME WITH NAME OPERAND$'
NAMEOK	CALL	ILPRT
	DB	'MOUNT CATALOG DISK, PRESS RETURN',0
	CPM	RDCON
	CPM	RESETDK	;RESET DISK, KILLING R/O STATUS
	CPM	SELDK,0
	MOVE	,FCB+1,,'NAMES   SUB'
	CPM	ERASE,FCB
	CPM	MAKE,FCB
	INR	A
	JZ	BADMAKE
	LXI	D,BUFF
WRLP	PUSH	D
	CPM	STDMA
	CPM	WRITE,FCB
	ORA	A
	JNZ	WRERR
	POP	D
	LXI	H,80H
	DAD	D
	XCHG
	MOV	A,D
	LDA		MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	MOVER
	RET
FCT	DB	0	;FILE COUNT
ENDADDR	DS	2	;END OF FILE
;FOLLOWING FROM 'EQU5.LIB'---->
	DS	40H	;STACK AREA
STACK	DS	2
;
;EXIT WITH ERROR MESSAGE
ERXIT	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
	CALL	TYPE
	POP	D	;GET MSG
	MVI	C,PRINT
	CALL	BDOS
;EXIT, RESTORING STACK AND RETURN
EXIT	LHLD	STACK
	SPHL
	RET		;TO CCP
BUFF	EQU	$
;BDOS/CBIOS EQUATES (VERSION 6)	
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
RESETDK	EQU	13
SELDK	EQU	14
OPEN	EQU	15
CLOSE	EQU	16
SRCHF	EQU	17
SRCHN	EQU	18
ERASE	EQU	19
READ	EQU	20
WRITE	EQU	21
MAKE	EQU	22
STDMA	EQU	26
BDOS	EQU	5
FCB	EQU	5CH 
1* "*  O* 	 > \  ;=! $RETCP  O* 0FCBO\!6 #_/OPFIL\s:T_  </!OPEN FILE ERROR DFTFCs
\ STNAM~G	!!F#~
/FILENAME LENGTH > 8         STC CPMLD\s }!  .'!.!M9P!N9V*r##"r^#Vbk+~+ng!\!hSTACK EMPTY
STACK FULL**}*t^#V+++"t"r/*~^#V*r##s#r}()   *r##"r^#V/S()  *r## ^"r/ABORT1!"t!"v!"!
"r22/2*#|s
ʍYt
zz>2h!K
LINE TOO LONG*|*+">_!G"*w}2F/:/**#" |*#"!  "~
ʚ
}}hҚE!EOF*w#"|/!1!"t!"v*	UNDEFINEDERR  **HERRMS*;
*z
*#|!F
UNIT ;
T o!o"!DISK WRITE PROTECTED
DISK ERRORILLEGAL BLOCK #NEWESm
f>2n*f{#z#^#V*f"j"l*j @zʤ	B	0:	A0*2**X9:o& "	*|*P'SLITE[	#"	'r	"r	\!*|"		&ʘ	*4Â	2	&ʻ	080G:Ù	:Î	'*~#"ERRCH[		.*x!D
!:
*v!:
!
/!"x!%
!<
!R
!c
VOCABULARY STACK EMPTYVOCABULARY STACK FULLLOOP STACK EMPTYLOOP STACK FULLT }$ 


*-
!~H:oH/PROMP	
*#|/:p>>> /
u
)}	
*~^#V!s#r/CODE<E};    
/
T
!}/;CODE/
E
T
!Ú:p=0¶2pP*|s#rCONSTE
EøPUSH   
.NEXT 

/DPUSH

-@PUSH

PUSHD

0PUSH

-1PUS

'MUL  

X-HL  

P(MSG)

(,)  

(B,) 
(BRAN
ERROR
(TTI)+
s(TTO)7
(READC
(WRITO
v(RBLO[
(WBLOg
T1   s
R0   {
/R1   {
L/R2   {
LçR3   {
þR4   {
}/R5   {
L/**P*z!DICTIONARY FULL*|!<COMPILE BUFFER FULL+|/g}/o}!   )g
`o|`)x
qW\eh	҆(ELSE*r##^#V+"r/(IF) |ʒ*r##"r/.    *z.STATE
o:q>
!q4	w
2q>
> w:q>	~=#~LOOKU$"*x"F|.*^#V^#V|ʅ"*u#uj
[*
 '* ^#V|G*+++B,   $}/,    /C,   /}|*zw#"z}|*|w#"|.RDLIN!G""M*j"h"j^#V*l|}*j @*f*j E*j"f*h E*j @s:nf*j @*lͅ*l*js#r*j @z*j^#V*j @s*j   ERBLOC:TWûWBLOC:TWUPDAT*f E/FLUSH*f"js*j @z/EBUF *f"j6#6+   E*j @z/^#V	s#rWORD T:' 	*z#*~#ʪff"~\GO~#ʯʐ"*zP}=*zw:og.>2+ÐLITERT '}[	}ILITE#"!  ""	+	-	!"-HH>2o>02p!F"|!/)::p0'ENTER
E*-ENT0 EU*z>6 #=Z>2
m!5g*~^#V*z##*z*~s#r/^#V*x##"xs#r/
ASSEMUSTOIC<L   +/L>   .LOAD *+*+"!  "/;F   ""/*v^#V+++"v*v##"vs#rDEFINB*x^#V"~/>    BY*x++"x/^    Yn2/%    n>2/:    :p0¶<2p!E!*|!  /!SYNTAX ERROR*r++"r*t##"ts#r/*r##^#V#~#z++"r*R6   {
L/R7   
{
R8   ({
*z!  )))   f     fV   PUSH JMP,  >

% CONVERT NEXT DIGIT
'# : RADIX @ U/MOD #A #PUT ;

% CONVERT DIGITS UNTIL RESULT IS ZERO
'#S : BEGIN # DUP EQZ END ;

% UNSIGNED CONVERT
'U<#> : <# #S #> ;

% UNSIGNED CONVERT AND TYPE
'U= : U<#> TYPE SPACE ;

% TYPE UNSIGNED NUMBER ADDRESSED BY TOP
'U? : @ U= ;

% SIGNED NUMBER CONVERT
'<#> : DUP <L ABS <# #S L> LTZ IF 55 #PUT THEN #> ;

% SIGNED NUMBER CONVERT AND TYPE
'= : <#> TYPE SPACE ;

% TYPE SIGNED NUMBER ADDRESSED BY TOP
'? : @ = ;

% DEFINE ;:
';: : CONSTANT R> , ;CODE<  D PUSH,  XCHG,  H INX,  H INX,  M E MOV,
  H INX,  M D MOV,  .I LHLD,  XCHG,  .I SHLD,  .R LHLD,  H INX,  H INX,
  .R SHLD,  E M MOV,  H INX,  D M MOV,  H POP,  @PUSH JMP,  >

% ROUTINE: SZSTOIC BY WINK SAVILLE
% PURP:	DETERMINE THE # OF 256 BYTE PAGES USED BY STOIC
% ENTRY: NONE
% EXIT: THE MESSAGE
% 	STOIC IS XX DECIMAL PAGES LONG 
% 	WHERE XX IS THE # OF 256 BYTE PAGES

% FIRS !

% NUMBER CONVERSION PACKAGE

0 '#CNT VARIABLE	% STRING LENGTH
0 '#PTR VARIABLE	% POINTER TO STRING

% OUTPUT A BYTE TO NUMBER STRING
'#PUT CODE<  #CNT LHLD,  H INX,  #CNT SHLD,  #PTR LHLD,  H DCX,  #PTR SHLD,
  D POP,  E M MOV,  NEXT JMP,  >

% INITIATE NUMBER CONVERSION
'<# CODE<  .D LHLD,  40 D LXI,  D DAD,  #PTR SHLD,  0 H LXI,  #CNT SHLD,
  NEXT JMP,  >

% TERMINATE NUMBER CONVERSION
'#> CODE<  H POP,  #PTR LHLD,  XCHG,  #CNT LHLD,  DPUSH JMP,  >

% CONVERT A NUMBER AT TOP TO AN AS
Hp1&//w0z'{ͅ>ɯo> g"k!m6  ůO}ZSTOIC E@ -!^-	STOIC IS  $/ u+0 DECIMAL PAGES LONG $/-!}})=â|g}o=î--#zg{ozg{ozg{oÓ::
;,!ɯ22=2l!  "]!~H5_ !m~RETCPM  E OLD RADIX " MSG HE MESSAGE TO DECIMAL Y STOIC P,  > ,  H INX,  D,  >  B    :
  C    
 D    
 E    
 H    
 L    
 M    
 A    
 PSW     RNC,  RC,   RPO,  RPE, * RP,  6 RM,  B JMP, N, CALL,Z, RET, f INX, r JNZ, ~, JZ,  , JNC, , JC,  , JPO, , JPE, , JP,  , JM,  , CNZ, , CZ,  , CNC, , CC,  , CPO, , CPE, , CP,  &, CM,  2, OUT, > IN,  J XTHL,V XCHG,b DI,  n EI,  z PCHL, SPHL, HLT, v RST,  IF,  > IFNZ,> IFZ, > IFNC,> IFC, > IFPO,> .D    
z.C   	!
|CURRE!
~RADIX!!
PROMP-!
ERRMS9!
ENT  E!
MEMORQ!
LIT  ]!
(TTYIi!
(TTYOu!
(ABOR!
.I   "
rT1   !
THEN,!x}ELSE,!x!}EQZ  !!z'NEZ  !!z'LTZ  !!z'GEZ  !"z'LEZ  "!"z'GTZ  !"5"z'EQ   5"I"|}'NE   I"b"|'}'LT   b"{"{z'GE   {""{z'LE   ""{z'GT   ""{z'ULT  ""{z'UGE  ""{z'ULE  ""T CHANGE THE RADIXVTO DECIMAL
DECIMAL

%
'SZSTOIC :
% SAVE PRESENT RADIX AND THEN CHANGE TO DECIMAL
RADIX @ DECIMAL
%
% TYPE OUT FIRST PART OF THE MESSAGE
"STOIC IS " MSG

% COMPUTE THE SIZE
. 256 / 1+ U=

% PRINT THE LAST PART OF THE MESSAGE
" DECIMAL PAGES LONG" MSG

% RESTORE OLD RADIX
RADIX !

;

;F



***EOF***
STA,  NEXT JMP,  >  IMMEDIATE

% GIVE "REDEFINING" ERROR ON ENTER
'ENT0 : DUP LOOKUP IF DROP IFCR "REDEFINING " MSG DUP MSG CR THEN ENT0 ;
() ENT0 ENTCII DIGIT
'#A CODE<  H POP,  -12 D LXI,  D DAD,  IFNC,  7 D LXI,  D DAD,  THEN,
  72 D LXI,  D DAD, ^V^  0
x1H
 
;/W5%81M  x1E          qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq
 {
          \1o1o1$$                                              
 SP   
 NOP,   LXI,  DAD, &	 DCX, 2 STAX,> LDAX,J
 INR, V DCR, b SHLD,n," LHLD,z,* STA, ,2 LDA, ,: RLC,  RRC,  RAL,  RAR,  DAA, ' CMA, / STC, 7 CMC, ? MVI,  MOV, 
@ POP,  PUSH," ADD, . ADC, : SUB, F SBB, R ANA, ^ XRA, j ORA, v CMP,  ADI,  ACI,  SUI,  SBI,  ANI,  XRI,  ORI,  CPI,  RNZ,  RZ,IFPE,> IFP, 
> IFM, > 3DROP{
./DROP .>02DROP>K/DUP  KX.OVER Xg! 9øSWAP gx.@    xø!    s#r/1+   #.1-   +.2+   ##.2-   ++.MINUSP.NOT  Q.+     .-      P.AND   * xgyo.OR   * ? xgyo.XOR  ? T xgyo.B@   T i n& .B!   i z s/EXEC z  bk+~+ng-1    
0     
  1     
 2     
 CHECK 
pCOLUM 
q.R    
t.L    
v.V    
x{z'UGT  "#{z'@@   #+#^#Vø@!   +#=#^#Vs#r/1+!  =#S#4/#4/1-!  S#g#^#Vr+s/MVBYTg#|#|//
+|#/RMVBY|##|//
+|«#/FILL ##x//s#r#x#/0FILL##  #+!   ##^#V	r+s/	IMMED#
$*~^#V!~w/<-   
$($s#r/0<-  ($:$6 #6 /-1<- :$M$6#6/S,   M$`$~<~#=/c$x/Gy/O-BC  !
s$z/W{/_-DE  $
$Q͇$z#-HLDE$
$zz$|PX$SMUL $
$s$>)$)$,	$=$33=$)$,	=$DIV  $
$||$xs$$$PSDIV %
%C.   `$A%*|.+CHECA%Q%!p4/SYNTAX ERROR-CHECQ%o%!p5~0/!X%BEGINo%Q%A%}END  %o%A% }REPEA%o%o%xA% A%g ($}IF   %Q%A% }THEN %o%A%g ($}ELSE %o%Q%A%g ($A% }(()  &3&zʒ*v 	"vs#r*r##"r/(U() 3&_&z9&())  _&n&*v^#Vr+sz*v"v*r##"r/(    n&Q%3&A% }U(   &Q%_&A% })    &o%n&XA%g ($A% }(DO) &&{z*v.J'   ()*v(K'   ) )*v(EXIT  )4)*v#6 +6+6 +6/<R   4)P)*t##"ts#r/R>   P)i)*t^#V+++"tûABS  i))|P.M+   ))	-#-M-   ))s$Ö)2/   ))|)7g}o.U2/  ))|)2*   ))).LSHIF))z..))RSHIF)*z..||g}o*URSHI*/*z..|g}o7*DLSHI/*O*x--))e*#
X*DRSHIO*s*x--||g}ozW{_
|*DURSHs**x--|g}ozW{_
ä*UM*  **X-U*   **XûU/   **!  $ûU/MOD**!  AP,--+ROT ----ROT -(--FLIP (-9--OCTAL9- -!}DECIMJ-
 -!}HEX  ^- -!}VARIAr-{
ûARRAY- x-3&  n&}BRANC-  x{
 ÖADDRE-$ 	UNDEFINED *}FORGE--X
  	!  !!=#}MAX  -," > y,}MIN  .,{" > y,}UMAX ;.,# > y,}UMIN W.," > y,}COUNTs..~#& o.<TTO>..}/<TTI>..so& .OUT  .-.IN   .-.TYO  .. }TYI  .. }TYPE ;:   0{
i)##^#V*r"r*t##"ts#røSZSTO	1-!^-	STOIC IS  $/ u+0 DECIMAL PAGES LONG $/-!}  ETCPM  P50

***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

INITIAL LOADING OF STOIC
J. SACHS 2/15/77

	STOIC REQUIRES A 24K BYTE SYSTEM WITH A MASS STORAGE DEVICE
AND TERMINAL OR TELETYPE.

	TO GENERATE A VERSION OF STOIC FOR A NEW SYSTEM, THE FOLLOWI##s#r#q#p#"vs#r*r##"r/(LOOP&%'*v^#Vr+s+F+N{z*v"v*r##"r/(+LOO%'Y'*v^#V	,'DO   Y'Q%&A% }LOOP p'o%%'XA%g ($A% }+LOOP'o%Y'XA%g ($A% }(UDO)''{zҒ*v##s#r#q#p#"vs#r*r##"r/(ULOO'(*v^#Vr+s+F+N{zڒ*v"v*r##"r/(U+LO(7(*v^#V	
(UDO  7(Q%'A% }ULOOPN(o%(XA%g ($A% }U+LOOh(o%7(XA%g ($A% }I    ((*vøJ    ((*vøK    ((*vøI'   ((*v#V+^+͈$F+N+	F+N	$-UM/MO*+$-UMOD +#+!  $.UM/  #+8+$ûU*/  8+K+X$û*    K+c+Ͳ$û/    c+u+z!  ++%ûMOD  u++z!  ++%.M*   ++Ͳ$-M/   ++%û/MOD ++z!  ++%-M/MOD++%-*/   ++Ͳ$%ûMOVE +,/XCHG ,+,Nwy#Nwy/S@   +,F,!  9.2OVERF,W,! 9ø3OVERW,h,! 9øUNDERh,y,.2UNDEy,,! 9s#r/3UNDE,,! Ë,DDUP ,,-DOVER,,! 9^#V+++øDUNDE,,-DSWAP,,""**-2SW.g x'
 (i .(}MSG  /./}CR   $/
 .}IFCR 4/ i  4/}SPACEF/  .}SPACE\/3& \/n&}TAB  n/ i  n/}//   //:o/2o/ENT0 /X$ >F/REDEFINING  $/X$/4/U}#CNT /- #PTR /-1#PUT //*/#"/*/+"/s/<#   /0*z  "/!  "//#>   0/0*/*/-#A   /0D0P0 : .#    D0-!*D0/}#S   a0a0X!}U<#> w00w0/0}U=   00/\/}U?   00}<#>  0X)0w0! - //0}=    00/\/}?    00}NG
STEPS MUST BE FOLLOWED:

BOOTSTRAP

REWRITE THE BOOTSTRAP AS NECESSARY TO RUN YOUR TERMINAL AND MASS
STORAGE DEVICE.  THE FOLLOWING ROUTINES MUST BE PROVIDED:

	TTYIN	ACCEPT A CHARACTER FROM THE TERMINAL

		CALL TTYIN
		CHARACTER RETURNED IN A, PARITY BIT ZERO

	TTYOU	TYPE A CHARACTER ON THE TERMINAL

		CHARACTER IN A
		CALL TTYOU

	DSKIN	READ BLOCKS FROM THE MASS STORAGE DEVICE

		BC CONTAINS A BLOCK COUNT
		DE CONTAINS THE BUFFER ADDRESS
		   (THE ADDRESS INTO WHICH THE FIRST BYTE MUST BE READ)
		HL CONTAINS THE FIRST BLOCK NUMBER
		CALL DSKIN
		ERROR CODE RETURNED IN A (ZERO IF OK)

	DSKOU	WRITE BLOCKS FROM THE MASS STORAGE DEVICE

		BC CONTAINS A BLOCK COUNT
		DE CONTAINS THE BUFFER ADDRESS
		   (THE ADDRESS FROM WHICH THE FIRST BYTE MUST BE WRITTEN)
		HL CONTAINS THE FIRST BLOCK NUMBER
		CALL DSKOU
		ERROR CODE RETURNED IN A (ZERO IF OK)

	THE PARAMETER "BSIZE" MUST BE SET TO THE BLOCK SIZE (IN
	BYTES) FOR THE MASS STORAGE DEVICE.  IF THE DEVICE USES
	EXCESSIVELY ENTER THE ADDRESS OF TTYIN, TTYOU, DSKIN, AND DSKOU AS PARAMETERS
IN THE KERNEL.

ENTER PARAMETER VALUES FOR BCKSP AND TABS FOR YOUR TERMINAL; IF
YOUR TERMINAL CAN BACKSPACE, BUT DOES NOT USE THE ASCII BACKSPACE
CHARACTER TO DO THIS, MODIFY THE CODE IN "RDLINE" TO BACKSPACE
YOUR TERMINAL.

ADJUST THE ORIGIN OF STOIC FOR YOUR SYSTEM.

CHOOSE STACK SIZES, COMPILE BUFFER SIZE, ETC,.

ENTER THE PARAMETER "BSIZE" THE SAME AS IN THE BOOTSTRAP.
ENTER THE PARAMETER "NBLKS", THE NUMBER OF AVAILABLE DISKARY TO REFLECT
THE BLOCK SIZE (IN BYTES) AND THE TOTAL AVAILABLE NUMBER OF BLOCKS
ON THE MASS STORAGE DEVICE, RESPECTIVELY.  (NBLKS MUST BE LESS THAN
OR EQUAL TO 512 DECIMAL)

REMOVE OR MODIFY THE WORD "DISK-COPY" WHICH COPIES AN ENTIRE DISK
FROM ONE UNIT TO ANOTHER.

MODIFY THE CODE TO SIZE MEMORY IN "(RDCI)", AS IN THE KERNEL AND
BOOTSTRAP.

MODIFY THE CONSTANT "2000" IN "WRITE-BOOT" TO THE 1ST RAM LOCATION
IN YOUR SYSTEM (HEX).


EDITOR

MODIFY THE VALUE OF THE VARIABLE "ESC" TO CORRESPO'H : GX > ;
	'EDIT : GX EDITOR<
	  MEMORY @ DUP LAST ! DUP XLAST ! DUP CP ! DUP P1 ! P2 ! ;


LOADING STOIC

<CR> STANDS FOR THE CARRIAGE RETURN KEY

1) COPY THE BASIC DEFINITIONS AND FILE SYSTEM PROGRAMS ONTO THE
   DISK AS TWO SETS OF CONTIGUOUS BLOCKS.  WRITE DOWN THE STARTING
   BLOCK # FOR EACH PROGRAM.  WHEN COPYING THE TWO PROGRAMS ONTO THE
   DISK, NOTE THAT LINES ARE TERMINATED BY CARRIAGE RETURN ONLY;
   NO LINE FEEDS SHOULD BE INSERTED INTO THE FILES.

2) ASSEMBLE STOIC AND LOAD ITACTER-ORIENTED INPUT DEVICE ONTO
   A DISK FILE, TYPE IN THE FOLLOWING PROGRAM:

'GET : ... ;

'LOAD-FILE : OFILE WOPEN
   BEGIN GET DUP PUTBYTE EOF EQ END
   EOF PUTBYTE SHRINK CLOSE FLUSH ;

WHERE "GET" DEFINES A WORD WHICH RETURNS THE NEXT BYTE OF THE FILE
ON THE STACK.  AT THE END OF THE FILE, "GET" MUST RETURN AN EOF (^D).

'NAME LOAD-FILE<CR>

WILL THEN COPY FROM THE INPUT DEVICE TO THE NAMED DISK FILE.

8) LOAD THE EDITOR AND ANY OTHER PROGRAMS YOU NEED ONTO THE DISK.

9) THE BASIC SMALL BLOCKS, < 512 BYTES, IT MAY BE ADVANTAGEOUS
	TO WRITE DSKIN AND DSKOU TO TRANSFER MULTIPLE PHYSICAL
	RECORDS AS A SINGLE LOGICAL RECORD.

	THE PARAMETER "RAM" SHOULD BE SET TO THE FIRST RAM LOCATION
	OF YOUR SYSTEM.

	CODE TO PROCESS RESTARTS (IF ANY) SHOULD BE INCLUDED IN THE
	BOOTSTRAP.

	THE PROGRAM AT "SIZE" SHOULD BE MODIFIED TO SIZE MEMORY FOR
	YOUR SYSTEM.  THIS PROBABLY MEANS MODIFYING THE CONSTANT
	"0C000H" TO "0".

COMMIT THE BOOTSTRAP TO READ-ONLY MEMORY.


STOIC KERNEL

 BLOCKS.

REPLACE THE CODE AT 2000H WITH CODE TO PROCESS RESTARTS FOR YOUR
SYSTEM.  NOTE THAT THE FIRST RAM LOCATION OF YOUR SYSTEM SHOULD
CONTAIN A "JMP ABORT".

ENTER TEXT FOR THE ERROR CODES FOR THE MASS STORAGE DEVICE IN
"RDERC" AND "WRERC".

MODIFY CODE AT "SIZE" TO SIZE MEMORY ON YOUR SYSTEM AND SET THE
VARIABLE "?MEMO" TO THE ADDRESS OF THE LAST USABLE RAM LOCATION + 1.
THIS IS THE SAME MODIFICATION AS IN THE BOOTSTRAP.


FILE SYSTEM

MODIFY THE CONSTANTS "BSIZE" AND "NBLKS" AS NECESSND TO AN APPROPRIATE
CHARACTER FOR YOUR TERMINAL. (E.G. ALT MODE FOR AN ASR 33)

MODIFY THE EDITOR WORD "DISPLAY-CURSORS" TO DISPLAY REASONABLE
CHARACTERS AS CURSORS.  (FOR A TTY, "[", "]", AND "$" ARE SUGGESTED)

MODIFY THE EDITOR WORD "ERASE" TO ERASE THE SCREEN AND HOME THE CURSOR
ON YOUR TERMINAL.

IF YOU ARE USING A TELETYPE INSTEAD OF A DISPLAY TERMINAL, DELETE THE
FOLLOWING WORDS:

	DISPLAY-CURSORS
	DISPLAY-CHAR
	DISPLAY
	ERASE
	EDIT-PROMPT
	ERRS

REDEFINE THE FOLLOWING WORDS:

	 INTO MEMORY; START AT "SIZE".

3) TYPE "N LOAD<CR>" WHERE N IS THE FIRST BLOCK NUMBER OF THE BASIC
   DEFINITIONS PROGRAM ON THE DISK.

4) TYPE "N LOAD<CR>" WHERE N IS THE FIRST BLOCK NUMBER OF THE FILE
   SYSTEM PROGRAM ON THE DISK.

5) TYPE "ZERO-DIRECTORY<CR>".

6) TYPE "'STOIC WRITE-BOOT<CR>" TO MAKE A BOOTSTRAPPABLE VERSION
   OF STOIC ON THE DISK.  FROM THIS POINT ON, THE BOOTSTRAP SHOULD
   LOAD STOIC BY ANSWERING "STOIC<CR>" TO THE QUESTION "FILENAME ? ".

7) TO LOAD FILES FROM A CHARDEFINITIONS AND FILE SYSTEM PROGRAMS NEED NOT BE SAVED
   ON THE DISK.


THE LINE DRAWER AND INTERRUPT HANDLER ARE HIGHLY SYSTEM DEPENDENT
AND ARE INCLUDED MAINLY AS GUIDELINES FOR WRITING YOUR OWN ROUTINES.



***EOF***






RE HIGHLY SY;STOIC DISK BOOTSTRAP
;J. SACHS 2/4/77
;
;***************************************************************************
;** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
;** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
;***************************************************************************

;DEFINE PARAMETERS
BSIZE	EQU	200H		;BLOCK SIZE (BYTES)
RAM	EQU	2000H		;START OF RAM
OFFSET	EQU	0		;LOAD OFFSET FOR DEBUGGING BOOTSTRAP
MAXRT	EQU	8		;MT	EQU	0DE01H		;DISK STATUS REGISTER
DSKBL	EQU	0DE02H		;DISK BLOCK #
DSKAD	EQU	0DE04H		;DISK BUFFER ADDR

;BOOT FILE FORMAT
;
;1ST BLOCK
;
;	WORD	CONTENTS
;
;	0	LOAD ADDRESS
;	1	STARTING ADDRESS
;	2-256	UNUSED
;
;SUBSEQUENT BLOCKS CONTAIN A CORE IMAGE STARTING
;AT THE LOAD ADDRESS
;THE LENGTH OF THE FILE IS DETERMINED BY THE DIRECTORY

;DEFINE RESTART HANDLERS
	ORG OFFSET
	DI
	STA 0DF00H	;CLEAR POWER LOW INTERRUPT FLAG
	JMP BOOT

	ORG OFFSET+(1*8)
	DI
	JMP RAM+3H

	ORG OFFSET+(2*8L		;YES, SET STACK PTR TO TOP OF MEMORY

	LDA 0DF00H	;CHECK FOR POWER LOW
	ANI 8
	JNZ LOW		;YES, GIVE ERROR

GETN:	LXI H,PROMPT	;TYPE "FILENAME ? "
	CALL MSG
	LXI H,FBUF	;INITIALIZE GET POINTER
	MVI C,6		;INITIALIZE GET COUNT
GETN1:	CALL TTYIN	;GET CHAR FROM KEYBOARD
	CALL TTYOU	;ECHO IT
	CPI 177Q	;RUBOUT
	JZ BOOT
	CPI 15Q		;CR
	JZ GETN2
	MOV M,A		;STORE CHAR IN FILENAME BUFFER
	INX H
	DCR C		;6 CHARS YET ?
	JNZ GETN1	;NO
	MVI A,15Q	;YES, OUTPUT AT CR
	CALL TTYOU
GETN2:	MVI A,12Q	;OUTP
MTCH1:	LDAX D		;COMPARE NEXT CHAR OF NAMES
	CMP M
	INX D
	INX H
	JNZ SRCH2	;MISMATCH, TRY NEXT DIRECTORY ENTRY
	ORA A
	JZ FOUND	;NULL, FOUND A MATCH
	DCR C		;DONE ?
	JZ FOUND	;YES, FOUND A MATCH
	JMP MTCH1	;KEEP CHECKING

SRCH2:	LHLD DIRP	;INCREMENT DIRECTORY POINTER TO NEXT ENTRY
	LXI D,8
	DAD D
	SHLD DIRP
	JMP SRCH1	;CHECK NEXT ENTRY

FOUND:	LHLD DIRP	;POINTER TO DIRECTORY ENTRY
	LXI D,6		;GET FIRST BLOCK #
	DAD D
	MOV E,M
	INX H
	MOV D,M
	XCHG
	SHLD FBLK	;SAVE IT

	LHLD DIRP	;P DSKIN	;READ PROGRAM
	JNZ DERR	;ERROR
	RET		;START PROGRAM

LOW:	LXI H,LOWM
	JMP ERROR

PROMPT:	DB 15Q,12Q,'FILENAME ? ',0
DERM:	DB 15Q,12Q,'DISK ERROR',0
LOWM:	DB 15Q,12Q,'POWER LOW',0

DSKIN:	MOV A,H		;GET UNIT #
	RAR
	ANI 0FH
	STA DSKCR	;SELECT UNIT

DSKI1:	MOV A,B		;DONE ?
	ORA C
	RZ		;YES, RETURN WITH A = 0

	MVI A,MAXRT	;SET RETRY COUNTER
DSKI3:	PUSH PSW

	SHLD DSKBL	;SET BLOCK #
	XCHG
	SHLD DSKAD	;SET BUFFER ADDR
	XCHG
	MOV A,H		;GET UNIT #
	RAR
	ANI 0FH
	ADI 20H		;READ
AXIMUM # OF RETRIES ON DISK

;DEFINE TEMPORARY VARIABLES
DBUF	EQU	RAM		;DIRECTORY BUFFER
FBUF	EQU	DBUF+BSIZE	;FILENAME BUFFER
DIRP	EQU	FBUF+7		;DIRECTORY POINTER
FBLK	EQU	DIRP+2		;FIRST BLOCK OF FILE
NBLKS	EQU	FBLK+2		;# OF BLOCK IN FILE

;DEFINE PERIPHERAL ADDRESSES
TTYISR	EQU	0E001H		;TTY INPUT STATUS REGISTER
TTYOSR	EQU	0E002H		;TTY OUTPUT STATUS REGISTER
TTYIDR	EQU	0E003H		;TTY INPUT DATA REGISTER
TTYODR	EQU	0E004H		;TTY OUTPUT DATA REGISTER

DSKCR	EQU	0DE00H		;DISK CONTROL REGISTER
DSKS)
	DI
	JMP RAM+6H

	ORG OFFSET+(3*8)
	DI
	JMP RAM+9H

	ORG OFFSET+(4*8)
	DI
	JMP RAM+0CH

	ORG OFFSET+(5*8)
	DI
	JMP RAM+0FH

	ORG OFFSET+(6*8)
	DI
	JMP 1400H	;FOR DEBUGGER

	ORG OFFSET+(7*8)
	DI
	JMP RAM+15H

DERR:	LXI H,DERM	;GIVE "DISK ERROR" MESSAGE
ERROR:	CALL MSG
BOOT:
SIZE:	LXI H,0C000H	;FIRST DEVICE ADDRESS
	MVI A,55H	;ALTERNATING 1'S AND 0'S
SIZE1:	DCX H		;DECREMENT TO NEXT LOC
	MOV M,A		;STORE BYTE IN MEMORY
	CMP M		;CAN READ IT BACK ?
	JNZ SIZE1	;NO, CONTINUE
	SPHUT A LF
	CALL TTYOU
	MOV A,C		;ONLY CR TYPED ?
	CPI 6
	JZ RAM		;YES, JMP TO 1ST RAM LOCATION
	MVI M,0		;NO, STORE NULL AT END OF NAME

SEARCH:	LXI H,0		;READ IN DIRECTORY
	LXI D,DBUF
	LXI B,1
	CALL DSKIN
	JNZ DERR	;ERROR

	LXI H,DBUF	;START OF DIRECTORY
SRCH1:	SHLD DIRP	;SET DIRECTORY POINTER
	MOV A,M		;END OF DIRECTORY ?
	INX H
	ORA M
	JZ BOOT		;YES, ASK FOR ANOTHER NAME

MATCH:	MVI C,6		;MATCH 6 CHARS MAX
	LHLD DIRP	;POINTER TO DIRECTORY ENTRY
	LXI D,FBUF	;POINTER TO FILENAME BUFFER
OINTER TO DIRECTORY ENTRY
	LXI D,14	;GET LAST BLOCK #
	DAD D
	MOV E,M
	INX H
	MOV D,M

	LHLD FBLK	;SUBTRACT FIRST BLOCK #
	MOV A,H
	CMA
	MOV H,A
	MOV A,L
	CMA
	MOV L,A
	DAD D
	SHLD NBLKS	;SAVE RESULT

	LHLD FBLK	;READ 1ST BLOCK OF FILE
	LXI D,DBUF
	LXI B,1
	CALL DSKIN
	JNZ DERR	;ERROR

	LHLD NBLKS	;GET LENGTH OF FILE
	MOV C,L		;MOVE IT INTO BC
	MOV B,H
	LHLD DBUF+2	;PUSH START ADDR ON STACK
	PUSH H
	LHLD DBUF	;LOAD ADDR IN DE
	XCHG
	LHLD FBLK	;FIRST BLOCK # IN HL
	INX H
	CALL
	STA DSKCR	;START TRANSFER

DSKI2:	LDA DSKST	;GET STATUS
	ANI 80H		;DONE ?
	JZ DSKI2	;NO

	LDA DSKST	;GET STATUS
	ANI 1		;ERROR ?
	JZ DSKI4	;NO

	POP PSW		;YES, GET RETRY COUNTER
	DCR A
	JNZ DSKI3	;TRY AGAIN
	INR A		;RETURN WITH A = 1
	RET

DSKI4:	POP PSW		;FLUSH RETRY COUNTER
	INX H		;INCREMENT BLOCK #
	PUSH H		;INCREMENT BUFFER ADDR BY BLOCK SIZE
	LXI H,BSIZE
	DAD D
	XCHG
	POP H
	DCX B		;DECREMENT BLOCK COUNT
	JMP DSKI1	;READ SOME MORE

DSKOU:	MOV A,H		;GET UNIT #
	RAR
	ANI 0FH
	STA DSKCR	;SELECT UNIT
	LDA DSKST	;GET STATUS
	ANI 4
	RNZ		;WRITE PROTECTED, RETURN WITH A = 4

DSKO1:	MOV A,B		;DONE ?
	ORA C
	RZ		;YES, RETURN WITH A = 0

	MVI A,MAXRT	;SET RETRY COUNTER
DSKO3:	PUSH PSW

	SHLD DSKBL	;SET BLOCK #
	XCHG
	SHLD DSKAD	;SET BUFFER ADDR
	XCHG
	MOV A,H		;GET UNIT #
	RAR
	ANI 0FH
	ADI 40H		;WRITE
	STA DSKCR	;START TRANSFER

DSKO2:	LDA DSKST	;GET STATUS
	ANI 80H		;DONE ?
	JZ DSKO2	;NO

	LDA DSKST	;GET STATUS
	ANI 1		;ERROR ?
	JZ DSKO4	;NO

	POP PSWE A MESSAGE ON TTY
MSG:	MOV A,M
	INX H
	ORA A
	RZ
	CALL TTYOU
	JMP MSG

;ENTRY POINTS FOR KERNEL
	ORG OFFSET+512-12
	JMP TTYIN	;TTYIN
	JMP TTYOU	;TTYOU
	JMP DSKIN	;DSKIN
	JMP DSKOU	;DSKOU

	END



***EOF***



	ORG OFFSET+512-12
	J

***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

THE STOIC BOOTSTRAP
J. SACHS 2/2/77

THE STOIC BOOTSTRAP IS A PROGRAM WHICH IS USED TO LOAD MEMORY
DIRECTLY FROM THE MASS STORAGE DEVICE.  IT MAY BE USED TO BOOTSTRAP
COPIES OF STOIC OR ANY OTHE INITIAL LOAD ADDRESS AND STARTING ADDRESS FOR
THE PROGRAM BEING LOADED.  FINALLY, THE REMAINDER OF THE FILE IS
LOADED INTO MEMORY STARTING AT THE LOAD ADDRESS AND A BRANCH TO THE
STARTING ADDRESS IS MADE.

IF NOT FOUND, THE MESSAGE "FILENAME ? " IS GIVEN AGAIN AND ANOTHER
NAME MAY BE TYPED IN.

IF NO FILENAME IS GIVEN (BY RESPONDING WITH CARRIAGE RETURN TO THE
PROMPT MESSAGE), THE BOOTSTRAP JUMPS TO THE FIRST LOCATION OF RAM.
THIS FEATURE MAY BE USED TO INTERRUPT A PROGRAM WHICH IS RUNNING
BY P	ALL THESE PROGRAMS ARE CONTRIBUTED BY CACHE.

	THE FOLLOWING PROGRAMS ARE PUBLIC DOMAIN SOFTWARE
WRITTEN BY DON TARBELL & COMPANY IN SUPPORT OF THEIR FLOPPY
INTERFACE. THEY ARE DESCRIBED IN TARBELL.DOC .
	CBIOS24.ASM
	SBOOT24.ASM
	FBIOS24.ASM
	FBOOT24.ASM
	COPY   .ASM
	FORMAT .ASM

	THE NEXT SET OF PROGRAMS WAS WRITTEN BY WARD CHRISTENSON
AND ARE DESCRIBED IN CATALOG.DOC AND MODEM.DOC.
	UCAT   .ASM
	CAT    .ASM
	QCAT   .ASM
	MODEM  .ASM

	THE REMAINDER OF THE PROGRAMS ARE:

	DCHAYES.AS		;YES, GET RETRY COUNTER
	DCR A
	JNZ DSKO3	;TRY AGAIN
	INR A		;RETURN WITH A = 1
	RET

DSKO4:	POP PSW		;FLUSH RETRY COUNTER
	INX H		;INCREMENT BLOCK #
	PUSH H		;INCREMENT BUFFER ADDR BY BLOCK SIZE
	LXI H,BSIZE
	DAD D
	XCHG
	POP H
	DCX B		;DECREMENT BLOCK COUNT
	JMP DSKO1	;READ SOME MORE

;GET CHAR FROM TTY
TTYIN:	LDA TTYISR
	ORA A
	JP TTYIN
	LDA TTYIDR
	ANI 177Q
	RET

;TYPE A CHARACTER ON TTY
TTYOU:	PUSH PSW
TTYO1:	LDA TTYOSR
	ORA A
	JP TTYO1
	POP PSW
	STA TTYODR
	RET

;TYPER PROGRAM INTO MEMORY.  THE ENTIRE
BOOTSTRAP RESIDES IS READ-ONLY MEMORY, BUT SOME RAM IS USED.

THE BOOTSTRAP FIRST SIZES MEMORY AND SETS THE STACK POINTER TO
THE TOP OF MEMORY.  IT THEN TYPES THE MESSAGE "FILENAME ? "; TO
WHICH THE USER REPLIES BY TYPING A 1 TO 6 CHARACTER FILE NAME.
THE BOOTSTRAP THEN  READS IN BLOCK 0 OF THE MASS STORAGE MEDIUM
(UNIT 0), I.E. THE DIRECTORY, AND SEARCHES FOR THE GIVEN FILENAME.

IF FOUND, THE FIRST BLOCK OF THE FILE IS READ INTO MEMORY.  THIS
BLOCK CONTAINS THLACING AN APPROPRIATE JUMP IN THE FIRST LOCATION OF RAM.

IF A DISK ERROR OCCURS, THE MESSAGE "DISK ERROR" IS GIVEN, AND THE
BOOTSTRAP RESTARTS FROM THE BEGINNING.



***EOF***

IF A DISK ERROR OCCURS, THE MESSAGE "DISK ERROR" IS GIVEN, AND THE
M	THE SOURCE OF THE PROGRAM GIVEN IN
			THE DC HAYES MODEM BOARD MANUAL. GET
			IT UP AND CALL THE COMPUTER BULLETIN
			BOARD AT 312/528-7141, HIT RETURN A
			FEW TIMES TO INITIALIZE.

	DCDIAG.ASM	DEBUG YOUR DC HAYES BOARD WITH THIS
			PROGRAM. DOCUMENTATION CONTAINED IN
			SOURCE.

	NOTES.VAN	UNRAVEL THE MYSTERIES OF CP/M VERSION
			1.4 . DESCRIBES ADDED FUNCTION NUMBERS
			AND HOW TO MAKE CP/M EXECUTE A COMMAND
			ON COLD BOOT.
