 CATALOG 24                   XDIR    ASM   T	

      XDIR    COM                  TAPELIB MAC     TAPELIB MAC  !"#$%&'()*+,-./0 TAPELIB MAC  '12345            MACRO   LIB   6789:;<=>?@ABCDE MACRO   LIB  F                TAPELIB COM   #GHIJK            TAPELIB DOC   _LMNOPQRSTUVW     DUMP    COM   XYZ              VOLUME24DOC   [\]              DUMP    ASM   ^_`abcdefghijklm DUMP    ASM  nop              MAC40   LIB   qrs              OPCODE  LIB   tuv             VOLUME 24

CP/M UTILITIES, MACRO LIBRARIES AND RATFOR

NUMBER	SIZE	NAME		COMMENTS

		CATALOG.24	CONTENTS OF CP/M VOL 24
		VOLUME24.DOC	COMMENTS ON CERTAIN PROGRAMS IN VOLUME
24.1	19K	DUMP.ASM	REVISION OF 14.7 TO INCORPORATE MANY
				ENHANCEMENTS, AND ASSEMBLE WITH DIGITAL
				RESEARCH MACRO ASSEMBLER, USING 24.4
24.2	3K	DUMP.COM	ASSEMBLY OF 24.1
24.3	3K	MAC40.LIB	LIBRARY OF MACROS TO CROSS-ASSEMBLE 4004/4040
				CODE USING DIGITAL RESEARCH MACRO ASSEMBLER
24.4	17K	MACRO.LIB	EXTENSIVE MACRO LIBROM
				CP/M DISK TO TARBELL TAPE. PERMITS VIEWING
				ON CONSOLE (IF YOUR HARDWARE IS FAST ENOUGH)
				WRITTEN IN TDL MACRO ASSEMBLER
24.10	11K	XDIR.ASM	DIRECTORY PROGRAM GIVING NEAT 3-WIDE
				DISPLAY, SORTED AND WITH FILES SIZED IN K'S
				AND REPORTING CORRECT NUMBER OF FILES AND
				REMAINING DISK SPACE. USES DIGITAL RESEARCH
				MACRO ASSEMBLER AND MACRO LIBRARY 24.4
24.11	2K	XDIR.COM	OBJECT OF 24.10
;			-  XDIR -
;					BY S J SINGER
;
;	XDIR IS A CPM UTILITY THAT DISPLAYS A DISK DIRECTORY IN A MORE
;READABLE FORM. THE DIRECTORY IS READ FROM THE SPECIFIED DISK, SORTED
;THEN DISPLAYED IN A 3 COLUMN FORMAT. BOTH THE FILE NAMES AND FILE SIZES 
;IN 1 K GROUPS ARE DISPLAYED.
;	THE PRESENT VERSION OF XDIR HAS CERTAIN MINOR LIMITATIONS WHICH
;MAY BE EASILY REMOVED IF THEY CAUSE PROBLEMS.
;
;	1.  ONLY 48 FILES ARE DISPLAYED. THIS LIMIT IS SUFFICIENT FOR
;	    ALMOST ALL DISKS AND LEAVES ROOM ON THE S RATFOR  COM   wxyz{|}~ RATFOR  COM  ~ UGFORM        !           RARY FOR USE WITH
				DIGITAL RESEARCH MACRO ASSEMBLER
24.5	3K	OPCODE.LIB	EXTENDED REGISTER OPERATION MACRO LIBRARY
				FOR DIGITAL RESEARCH MACRO ASSEMBLER
24.6	32K	RATFOR.COM	PRE-PROCESSOR TO TRANSLATE FROM THE STRUCTURED
				LANGUAGE RATFOR, DESCRIBED IN SOFTWARE TOOLS,
				TO STANDARD FORTRAN.  TYPE "RATFOR FILENAME", TO
				CREATE FILENAME.FOR FROM FILENAME.RAT
24.7	5K	TAPELIB.COM	OBJECT OF 24.9
24.8	12K	TAPELIB.DOC	DESCRIPTION OF 24.9
24.9	37K	TAPELIB.MAC	PIP-LIKE PROGRAM TO TRANSFER FILES FCREEN FOR EDITING.
;	    TO CHANGE THE NO OF LINES DISPLAYED, CHANGE THE LINES VARIABLE
;	    IN THE DATA ALLOCATION SECTION OF THE PROGRAM. FOR EXAMPLE
;	    TO DISPLAY A MAXIMUM OF 54 FILES CHANGE LINES TO 18.
;	2.  THE PRESENT VERSION READS GROUPS 0 AND 1 DIRECTLY FOR SPEED.
;	    IF A DISK IS SET UP FOR MORE THAN 64 FILES OR THE BLOCK FORMAT
;	    IS CHANGED THE READ ROUTINE WILL HAVE TO BE MODIFIED.
;
;	OCCASIONALLY THE FILE NAMES WILL BE DISPLAYED WITH THE FORMAT
;SCRAMBLED OR THE SPACE REMAINING ON THE DISK WILL NOT AGREE WITH THAT REPORTED
;BY THE STAT UTILITY. THIS ALMOST ALWAYS MEANS THE DISK DIRECTORY HAS BEEN
;MESSED UP SOMEHOW. USUALLY THE PROBLEM CAN BE CORRECTED BY COPYING ALL THE
;FILES TO ANOTHER DISK USING PIP.
;	XDIR WAS ASSEMBLED USING THE NEW CP/M MACRO ASSEMBLER AND USES A LARGE
;NUMBER OF MACROS. THESE ARE CONTAINED IN A LIBRARY CALLED MACRO.LIB WHICH
;IS REQUIRED IF THE PROGRAM IS TO BE REASSEMBLED.
;
;
;		COMMAND FORMAT
;
;	XDIR			DISPLAY DIRECTORY OF LOGGED DISK
L HAS G*8+S
	LXI	D,-26		;DIVISOR
	MVI	A,1		;CONTAINS DIVIDEND
DIV:	DAD	D		;SUB 26
	INR	A
	JC	DIV		;LOOP TILL MINUS
	LXI	D,TABLE+26	;INDEX INTO TABLE
	DAD	D
	STA	TRACK		;STORE TRACK NO
	MOV	A,M		;GET SECTOR NO
	STA	BSEC		;SAVE IN BEGINNING SECTOR
	STA	ESEC		;SAVE IN END SECTOR TOO
	RET
;
;    START OF DIRECTORY ROUTINE READ IN GROUPS 0 AND 1 AND STORE
;    DIRECTORY FILE NAMES NOT FLAGGED E5.  IF EXTENT NOT ZERO STORE
;    OVER PREVIOUS FILE NAME. TABLE OF POINTERS WILL BE BUILT IN PDIR
;
DCOUNT		;COUNT OF DIRECTORY ENTRIES
	FILL	PDIR,PDIR+130	;ZERO DIRECTORY POINTER TABLE
	LXI	H,DIRBUF	;POINTS TO DIRECTORY BUFFER
	SHLD	OUTB
	LXI	H,PDIR		;POINTER TABLE
	SHLD	IPOINT
	LDA	NEWDRV
	MOV	E,A
	DISKIO	LOGIN		;LOG IN NEW DRIVE NO
DIR4:	LXI	H,80H		;POINTS TO INPUT BUFFER
	SHLD	INB
	CALL	GRPTS		;COMPUTE TRACK AND SECTOR NO FROM G AND S
	SETSEC	BSEC		;SET SECTOR
	SETTRK	TRACK		;SET TRACK
	CALLBIOS DREAD		;READ DIRECT
DIR6:	LHLD	OUTB		;LOAD DESTINATION POINTER
	XCHG			;PUT IT IN DE
	LHLD	 11 CHARAACTERS
	RESTORE	H,D
	JZ	SWITCH		;STORE NEW ENTRY OVER OLD
	INDEX	J,2		;INCR INDEX BY 2
	JMP	DIR9
SWITCH:	INX	H
	MOVE	,,15		;OVERWRITE OLD ENTRY
	RESTORE	H
	JMP	DIR12
DIR10:	RESTORE	D,H
	MOVE	,,15		;MOVE THE DIRECTORY ENTRY
	LDA	COUNT
	INR	A
	STA	COUNT		;INCR COUNT OF DIRECTORY ENTRIES
	LHLD	OUTB
	DSTORE	0,IPOINT	;INDEXED STORE HL
	INDEX	OUTB,16
	INDEX	IPOINT,2
DIR12:	INDEX	INB,32		;INCR POINTERS
	LXI	D,100H
	CPHL			;LIMIT OF 4 ENTRIES
	JNZ	DIR6
	LDA	S
	INR	A
	STA	S		;INCR DIS*2,I	;POINTER COL 2
	DJZ	DIR18		;NO PRINT IF ZERO
	CALL	DIR20		;PRINT IT
	PRINT	'         '
	DLOAD	PDIR+LINES*4,I	;POINTER COL 3
	DJZ	DIR18
	CALL	DIR20		;CALL PRINT ROUTINE
DIR18:	PRINT	CRLF,$
	INDEX	I,2		;INCR INDEX BY 2
	LXI	D,LINES*2	;CHECK INDEX LIMIT
	CPHL
	JZ	ENDFIL		;EXIT WHEN INDEX 32
	JMP	DIR16		;PRINT SOME MORE
;
;    SUBROUTINE TO PRINT A SINGLE DIRECTORY ENTRY
;
DIR20:	MVI	C,11		;NAME LENGTH
DIR22:	SAVE	B,H		;SAVE REGISTERS
	MVI	C,2
	MOV	E,M		;CHAR TO BE PRINTER
	CALL	5		;CA;	XDIR A:			DISPLAY DIRECTORY OF DISK A
;	XDIR B:			DISPLAY DIRECTORY OF DISK B
;
;
	MACLIB	MACRO		;INCLUDE MACRO LIBRARY
	ORG	100H		;SET PROG START
	LXI	H,0
	DAD	SP		;GET OLD STACK POINTER
	SHLD	OLDSTK		;SAVE IT
	LXI	SP,NEWSTK	;LOAD NEW STACK POINTER
	JMP	DIR
;
;   GRPTS  CONVERT CPM GROUP AND SECTOR NUMBER TO TRK AND SEC
;
GRPTS:	MVI	H,0		;ZERO H
	LDA	G		;GROUP NO
	MOV	L,A		;TO L
	MOV	D,H		;ZERO	D
	DAD	H
	DAD	H
	DAD	H		;SHIFT LEFT 3
	LDA	S		;GET SECTOR NO
	MOV	E,A		;TO DE
	DAD	D		;HIR:	DISKIO	?DRIVE
	STA	NEWDRV
	LDA	81H
	ORA	A		;CHECK IF INPUT BUFFER EMPTY
	JZ	DDD
	LDA	82H		;CHECK NEW DRIVE
	CPI	'A'
	JNZ	DX1
	XRA	A
	STA	NEWDRV		;SELECT DRIVE A
	JMP	DDD
DX1:	CPI	'B'
	JNZ	DSKERR
	MVI	A,1
	STA	NEWDRV
DDD:	PRINT	<CR,LF,LF,'                        DIRECTORY DRIVE - '>
	LDA	NEWDRV		;LOGGED DISK
	ORA	A
	JNZ	BDIR
	PRINT	<'A',CR,LF,LF>
	JMP	DIR2
BDIR:	PRINT	<'B',CR,LF,LF>
	CALL	FIXB		;RESTORE DRIVE B
DIR2:	XRA	A
	STA	S		;SECTOR COUNT
	STA	G		;GROUP 0 = DIRECTORY
	STA	INB		;LOAD SOURCE POINTER
	MVI	A,0E5H		;FLAG BYTE
	CMP	M		;TEST FIRST BYTE
	JNZ	DIR8
	INX	H
	CMP	M		;TEST SECOND BYTE
	JZ	SORT		;SORT DIRECTORY
	JMP	DIR12
DIR8:	INX	H
	SAVE	H,D
	LXI	D,11		;EXTENSION OFFSET
	DAD	D
	MOV	A,M
	ORA	A
	JZ	DIR10		;IF EXTENT ZERO CONTINUE
	LXI	H,0		;ELSE, SEARCH FOR SAME NAME AND SWITCH
	SHLD	J		;INITIALIZE INDEX
DIR9:	DLOAD	PDIR,J
	MOV	A,H
	ORA	L
	JZ	DIR10		;ERROR TABLE EMPTY
	XCHG
	LHLD	INB		;POINTER TO NEW DIR ENTRY
	SAVE	D,H
	INX	H
	MATCH	,,11		;COMPARERECTORY SECTOR COUNT
	JMP	DIR4		;READ ANOTHER BLOCK FROM DIRECTORY
;
;    THIS ROUTINE PRINTS THE DIRECTORY IN 3 COLUMNS. NO OF LINES
;    PRINTED IS CONTROLED BY VARIABLE LINES. ALL DIRECTORY NAMES
;    ARE PRESENT IN TABLE BUT ONLY A MAXIMUM OF 3*LINES WILL BE
;    PRINTED.
;
DIR14:	LXI	H,0
	SHLD	W		;INITIALIZE ALLOCATION
	SHLD	I		;INITIALIZE INDEX
DIR16:	DLOAD	PDIR,I		;INDEX LOAD POINTER
	DJZ	ENDFIL		;EXIT IF POINTER ZERO
	CALL	DIR20		;CALL PRINT ROUTINE
	PRINT	'         '
	DLOAD	PDIR+LINELL BDOS
	RESTORE	H,B		;RESTORE THE REGISTERS
	INX	H		;INCR NAME POINTER
	DCR	C		;DECR CHAR COUNT
	JZ	DIR24		;PRINT SIZE
	JMP	DIR22		;LOOP TILL COUNT 0
DIR24:	MOV	A,M		;EXTENSION TO A
	ADD	A
	ADD	A
	ADD	A
	ADD	A		;MULTIPLY BY 16
	MOV	B,A		;SAVE IN B
	INX	H
	INX	H
	INX	H		;ADD 3
	MOV	A,M		;GET RECORD COUNT
	RRC
	RRC
	RRC			;SHIFT RIGHT 3
	PUSH	PSW
	ANI	1FH		;EXTRACT
	LXI	H,0
	MOV	L,A		;NO TO HL TO PRINT
	POP	PSW
	ANI	0E0H		;EXTRACT
	JZ	DIR26
	INX	H
DIR26:	MOV	A,L
	ADD	B
	MOV	L,A
	SAVE	H
	LXI	D,10
	CPHL
	JM	DIR28
	PRINT	'  '
	JMP	DIR30
DIR28:	PRINT	'   '
DIR30:	POP	H
	PUSH	H
	XCHG
	LHLD	W
	DAD	D
	SHLD	W
	POP	H
	DECOUT
	PRINT	'K'
	RET
;
;
;    THIS ROUTINE RESTORES DRIVE B
;
FIXB:	LDA	NEWDRV		;CHECK DRIVE NO
	ORA	A
	RZ			;RETURN IF DRIVE A
	LDA	NEWDRV		;SELECT DRIVE B
	MOV	E,A
	DISKIO	LOGIN
	XRA	A
	STA	TNUM		;SELECT TRACK ZERO
	INR	A		;SELECT SECTOR 1
	STA	SNUM
	SETSEC	SNUM
	SETTRK	TNUM
	CALLBIOS DHOME		;HOME DRIVES
	CALLBIOS DREAD		;READ TRACK ZERO RIVE A OR B'>
	JMP	EF1		;EXIT
;
;    THIS SECTION DOES THE ACTUAL SORTING OF THE DIRECTORY. DURING THE
;    INPUT OF THE DIRECTORY NAMES, A TABLE OF ADDRESS POINTERS PDIR
;    WAS CONSTRUCTED. THE SORT ROUTINE SORTS THE ADDRESS POINTERS
;    RATHER THAN THE ACTUAL DIRECTORY. 
;    THIS IS AN IMPLEMENTATION OF C. A. R. HOARE'S QUICKSORT ALGORITHM.
;    THE ALGORITHM IS VERY FAST AND GENERALLY USEFUL, HOWEVER CAUTION
;    SHOULD BE USED WITH LARGE FILES. THE ALGORITHM IS RECURSIVE AND
;    THE STACKFFH
	JZ	DIR14		;GO TO PRINT ROUTINE
	SHLD	J
	SHLD	LAST
	POP	H
	SHLD	I
	SHLD	FIRST
	CALL	SPLIT
	LHLD	I
	XCHG
	LHLD	FIRST
	CPHL
	JZ	SORT4
	PUSH	H		;I ON STACK
	DCX	D
	DCX	D
	PUSH	D		;J ON STACK
SORT4:	LHLD	J
	XCHG
	LHLD	LAST
	CPHL
	JZ	SORT8
	INX	D
	INX	D
	PUSH	D		;NEW I ON STACK
	PUSH	H		;NEW J ON STACK
SORT8:	JMP	SORT2
;
;    SPLIT SUBROUTINE DOES A SINGLE PARTITION ON AN ARRAY OF POINTERS
;
SPLIT:	HALF	I
	XCHG
	HALF	J
	DAD	D
	MOV	A,L
	ANI	0FEH
	MOV	L,A
	SHLD	K		;K=I+J/2
AD	PDIR,J
	DSTORE	PDIR,I
	RESTORE	H
	DSTORE	PDIR,J
	JMP	SPLIT2
;
;   DATA ALLOCATIONS
;
LINES	EQU	16		;LINES PER PAGE ON DISPLAY
SPACE:	DB	' $'		;ASCII SPACE
CRLF:	DB	0DH,0AH,24H	;ASCII CR LF
I:	DW	0		;PSEUDO INDEX REGISTER
J:	DW	0		;PSEUDO INDEX REGISTER
K:	DW	0		;PSEUDO INDEX REGISTER
FIRST:	DW	0		;START OF ARRAY
LAST:	DW	0		;END OF ARRAY
W:	DW	0		;STORAGE FOR PARTITION INDEX
LINE:	DW	0		;LINE NUMBER FOR LISTING
IPOINT:	DW	00		;VARIABLE BUFFER POINTER
DRVNO:	DB	0		;STORAGE FOR ORIGINALLDIRECTORY BUFFER AREA
TABLE:	DB	01H		;SECTOR LOOK UP TABLE
	DB	07H
	DB	0DH
	DB	13H
	DB	19H
	DB	05H
	DB	0BH
	DB	11H
	DB	17H
	DB	03H
	DB	09H
	DB	0FH
	DB	15H
	DB	02H
	DB	08H
	DB	0EH
	DB	14H
	DB	1AH
	DB	06H
	DB	0CH
	DB	12H
	DB	18H
	DB	04H
	DB	0AH
	DB	10H
	DB	16H
PDIR	DW	0		;POINTER TABLE TO DIRECTORY (64 ENTRIES MAX)
DIRBUF:	EQU	PDIR+130	;START OF AREA USED TO STORE AND SORT DIRECTORY
	END
DIRECT
	RET
;
;    THIS IS THE EXIT POINT FROM THE PROGRAM. PRINT NO OF FILES AND
;    SPACE REMAINING, RELOAD OLD STACK POINTER AND RETURN BACK TO CCP.
;
ENDFIL:	PRINT	<CR,LF,'                '>
	LXI	H,0
	LDA	COUNT
	MOV	L,A
	DECOUT
	PRINT	' FILES    '
	LHLD	W
	MOV	A,L
	CMA
	INR	A		;NEGATE
	ADI	240
	MOV	L,A
	DECOUT
	PRINT	<'K BYTES REMAINING ON DISK',CR,LF>
EF1:	LHLD	OLDSTK
	SPHL			;RELOAD OLD STACK POINTER
	RET			;RETURN TO CCP WITHOUT REBOOT
;
DSKERR:	PRINT	<CR,LF,'ERROR - SELECT D SPACE REQUIRED IS PROPORTIONAL TO THE NO OF ITEMS TO BE
;    SORTED.
;
SORT:	LDA	COUNT		;NO OF ENTRIES IN DIR
	ORA	A
	JZ	ENDFIL		;EXIT IF DIRECTORY EMPTY
	DCR	A
	LXI	H,0		;ZERO HL
	MOV	L,A
	DAD	H
	SHLD	LAST		;END OF ARRAY
	LXI	H,0
	SHLD	FIRST		;START OF ARRAY
	LXI	H,0FFFFH
	PUSH	H		;FLAG FOR STACK EMPTY
	LHLD	FIRST
	PUSH	H
	LHLD	LAST
	PUSH	H		;STACK CONTAINS FIRST AND LAST INDICES
;
;    NOW POP STACK AND KEEP CALLING SPLIT RECURSIVELY TILL STACK EMPTY
;
SORT2:	POP	H
	MOV	A,H
	CPI	0
	DLOAD	PDIR,K
	SHLD	W		;W IS POINTER TO PARTITION ELEMENT OF PDIR
SPLIT2:	DLOAD	PDIR,I		;GET ITEM FROM LEFT
	XCHG
	LHLD	W		;PARTITION ELEMENT
	MATCH	,,11		;CONPARE KEYS
	JP	SPLIT4
	INDEX	I,2		;INCR I
	JMP	SPLIT2
SPLIT4:	DLOAD	PDIR,J		;GET ITEM FROM RIGHT
	XCHG
	LHLD	W		;PARTITION ELEMENT
	XCHG
	MATCH	,,11		;COMPARE KEYS
	JP	SPLIT6
	INDEX	J,-2
	JMP	SPLIT4		;LOOP BACK
SPLIT6:	LHLD	I
	XCHG
	LHLD	J
	CPHL			;COMPARE I AND J
	RZ			;RET IF I = J
	DLOAD	PDIR,I		;SWITCH POINTERS
	SAVE	H
	DLOY LOGGED DRIVE
NEWDRV:	DB	0		;STORAGE FOR NEW DRIVE NO
TRACK:	DB	0		;SELECTED TRACK
BSEC:	DB	0		;SELECTED BEGINNING SECTOR
ESEC:	DB	0		;SELECTED ENDING SECTOR
TNUM:	DB	0		;TRACK NUMBER
SNUM:	DB	0		;SECTOR NUMBER
G:	DB	0		;CPM GROUP NO
S:	DB	0		;SECTOR NO WITHIN GROUP G
COUNT:	DB	0		;COUNT OF DIRECTORY ENTRIES
OLDSTK:	DW	0		;STORAGE FOR OLD STACK POINTER
ENDSTK:	DS	60		;STORAGE FOR NEW STACK
NEWSTK:	DW	0		;NEW STACK
INB:	DW	0		;STORES POINTER TO INPUT BUFFER AREA
OUTB:	DW	0		;STORES POINTER TO !  9"s15& :poT))):q_><!2k~2l2m 2j: ]: AS2j]B>2jÎ

                        DIRECTORY DRIVE - $`	 :j°åA

$	 øB

$	 52q2p2r! s#
!S"!"g:j_ ! "
:l7?O* .!"  :kM?'O* ."%  * .'"0  **>G#3# ~ʮ!  "[*[^#V|ʮ*#~
#tsʕ*[ "[Y#äx~#Ù ͙ ͙:r<2r**g!  s#r* "*g "g*  " |}2:q<2q *s(
ERROR - SELECT DRIVE A OR B$
	 :rʑ=!  o)"a!  "_!*_*a|"["a"Y"_͙*Y*_|z}ʁ*[*a|}ʖUä|g}o*Y͜*[͜}o"]*]^#V"c*Y^#V*cs*Y "Y*[^#V*cs*["[*Y*[|}*Y^#V*[^#V*Y!s#r*[!s#r $
$                            z}ʁ*[*a|}ʖUä|g}o*Y͜*[͜      
	
                                               ;			-- TAPELIB --
;
;					BY:  S. J. SINGER
;						(714) 780-8853
;
;	THIS PROGRAM IS A GENERAL CASSETTE TAPE LIBRARY MANAGER FOR CP/M.
;IT ACCEPTS A FUNCTION FOLLOWED BY A FILE NAME FROM THE CONSOLE AND
;PERFORMS A DISK TO TAPE OR TAPE TO DISK COPY. ANY CP/M FILE MAY BE COPIED.
;THE TAPE FORMAT IS TARBELL COMPATABLE, HOWEVER THE TAPES PRODUCED BY
;TAPELIB ARE NOT EASILY LOADED BY OTHER TARBELL INPUT ROUTINES.
;TAPE FILES ARE NAMED AND SPACE IS PROVIDED FOR EXTENSIVE COMMENTS.
;
;		    -- COMMANE COMMANDS
;GIVEN ABOVE MAY THEN BE ENTERED WITHOUT THE WORD TAPELIB.
;
;   FILES MAY BE RENAMED OR SIMPLY VERIFIED (NO ACTUAL TRANSFER) DURING
;ALL TAPE TO DISK OPERATIONS. A COM FILE MAY ALSO BE RUN FROM TAPE
;WITHOUT FIRST LOADING IT TO DISK. THE SYNC OPTION WRITES 65K OF SYNC
;BYTES ON THE TAPE.
;
;	TAPELIB DISK:=FILENAME.TYP   RENAME NEW.NAM
;	TAPELIB DISK:=FILENAME.TYP    VERIFY
;	TAPELIB DISK:=FILENAME.COM      RUN   NODISPLAY

;  (RENAME,VERIFY,RUN AND THE FILE NAME ARE FREE FORMAT AND MLAYED DURING THE SEARCH. NORMALLY
;FILES ARE NOT BLOCKED ON TAPE BUT READ INTO MEMORY IN THEIR ENTIRETY.
;IF A FILE WILL NOT FIT IN MEMORY IT WILL BE WRITTEN OUT IN 1K BLOCKS.
;
;	FILES ARE DISPLAYED ON THE CONSOLE FOR VERIFICATION DURING
;ALL TRANSFER OPERATIONS. NON DISPLAYABLE CHARACTERS DISPLAY AS PERIODS.
;THE CONSOLE DEVICE MUST BE CAPABLE OF OPERATING AT A MINIMUM OF
;4800 BAUD OR ERRORS WILL OCCUR. THE DISPLAY FEATURE MUST BE DISABLED
;IF SLOW TERMINALS ARE USED.
;
;			-- TAPE FORMAT--
;
!  "c"Y*Y^#V|ʑ͐+         $!	 *Y^#V|n͐S         $I	 *Y^#V|n͐V	 *Y "Y  |}ʑ^ #
ʤÒ~G###~!  oʿ#}o
 |}  $	    $	 *c"c$	
 	|{0__ ,K$*	 :j:j_ 2n<2o:o7e?eO* .!"c  :nM?zO* ."x  * ."  * .'"  ç
                $	 !  :ro FILES    $	 *c}/<oK BYTES REMAINING ON DISK
$	D FORMATS --
;
;		DISK TO TAPE
;	TAPELIB TAPE:=FILENAME.TYP  'OPTIONAL DESCRIPTION OR COMMENTS'
;	TAPELIB TAPE:=A:FILENAME.TYP	BLOCK
;	TAPELIB TAPE:=B:FILENAME.TYP       NODISPLAY
;
;		TAPE TO DISK
;	TAPELIB DISK:=FILENAME.TYP
;	TAPELIB A:=FILENAME.TYP
;	TAPELIB B:=FILENAME.TYP
;
;
;		EXECUTE FILE 
;	TAPELIB RUN:=FILENAME.COM
;
;		WRITE SYNC
;	TAPELIB TAPE:=SYNC
;
;
;	TAPELIB MAY ALSO BE LOADED LIKE PIP, BY SIMPLY TYPING TAPELIB.
;THE PROGRAM WILL LOAD, PRINT A TITLE THEN A * PROMPT. THAY BE  
;ANYWHERE IN THE COMMENT FIELD). A FILE MUST BE TYPE COM TO BE RUN.
;NODISPLAY IN THE COMMENT FIELD TURNS OFF THE DISPLAY OF THE FILE ON
;THE TERMINAL DURING TRANSFER OPERATIONS.
;
;	A TOTAL OF 128 BYTES ARE AVAILABLE FOR THE COMMAND AND COMMENTS.
;WHEN COPYING TAPE TO DISK COMMENTS ARE OMITTED. DURING ALL TAPE TRANSFER
;OPERATIONS THE CONTENTS OF THE FILE ARE DISPLAYED ON THE CONSOLE. NON
;DISPLAYABLE CHARACTERS DISPLAY AS PERIODS. THE NAMES AND COMMENTS OF
;THE FILES SKIPPED OVER ARE DISP
;	1. START BYTES		03CH  (600)
;	2. SYNC BYTE		06EH
;	3. DECODE BYTE		0FFH  CONTROLS DISPLAY
;	4. TYPE BYTE		0 1 OR 2
;	5. LENGTH BYTE		THE NUMBER OF 256 BYTE RECORDS
;	6. NAME			CP/M NAME 11 BYTES  (NAME....TYP)
;	7. COMMENT		110 BYTES PROVIDED, BLANK (20H) IF NOT ENTERED
;	8. DATA			MULTIPLES OF 256 BYTE RECORDS
;	9. CHECKSUM		ONE BYTE TARBELL CHECKSUM
;
;	A STRING OF 600 START BYTES PROVIDES AT LEAST 3 SEC OF 'LEADER'
;BETWEEN RECORDS ON THE TAPE. ALL THE MEMORY BETWEEN THE END OF THE
;PROGRAM AND THE OPERATING SYSTEM, IS USED AS A FILE BUFFER. IF A
;FILE IS TOO LARGE TO FIT IN THE AVAILABLE MEMORY, IT WILL BE
;WRITTEN ON TAPE IN 1K BLOCKS DURING DISK TO TAPE TRANSFERS.
;READING AND WRITING BLOCKED TAPES TAKES ABOUT TWICE AS LONG AS READING
;OR WRITING UNBLOCKED TAPES. PROGRAMS MAY NOT BE RUN DIRECTLY FROM
;BLOCKED TAPES. ENTERING THE WORD 'BLOCK' IN THE DESCRIPTION FIELD
;OF A DISK TO TAPE COMMAND WILL FORCE BLOCKING OF ALL FILES THAT
;WILL NOT FIT IN A 16K CP/M SYSTEM.
;
;
;	THE PROM,A		;;STORE THE CONST
	INX	H		;;INCR H
	DCX	D		;;DECR LENGTH
	MOV	A,D
	ORA	E		;;TEST LENGTH = ZERO
	JNZ	.-7]]		;;REPEAT IF DE AND HL NOT EQUAL
;
;   1.5  FILLI - FILL INDIRECT A BLOCK OF MEMORY WITH A CONSTANT
;
	.DEFINE FILLI [START,END,CONST(0),%FI] = [
	LHLD	START		;;START ADDR
	LXI	D,END+1		;;END ADDR
%FI:	MVI	A,CONST		;;CONSTANT TO A
	MOV	M,A		;;STORE CONST IN MEMORY
	INX	H		;;INCR POINTER
	CPHL			;;COMPARE HL AND DE
	JNZ	%FI]		;;REPEAT TILL ZERO
;
;  2.   CPHL - COMPARE DE AND HL A
;
	.DEFINE	MOVEI [SOURCE,DEST,LEN] = [
	.IFDIF [DE] [SOURCE],[
	LHLD	SOURCE		;SOURCE
	XCHG]
	.IFDIF [HL] [DEST],[
	LHLD	DEST]		;DESTINATION
	.IFDIF [BC] [LEN],[
	LXI	B,LEN]		;LENGTH
	LDAX	D		;GET A BYTE
	MOV	M,A		;STORE IT
	INX	H
	INX	D		;BUMP POINTERS
	DCX	B		;DECR LENGTH COUNT
	MOV	A,B
	ORA	C
	JNZ	.-7]		;TEST DONE
;
;   5.  READTB - READ CHAR STRING INTO INPUT TEXT BUFFER
;
	.DEFINE READTB [TEXT,MAX(127)] = [
	MVI	C,10
	LXI	D,TEXT
	MVI	A,MAX
	STAX	D	;SET MAXIMUM BUFFER LENGTH
	C CARRY
;   8.  OPEN - OPEN DISK FILE
;
	.DEFINE OPEN [NAME] = [
	MVI	C,15
	LXI	D,NAME
	CALL	5
	CPI	0FFH	;TEST FOR ERROR
	CMC		;COMPLIMENT CARRY
	JNZ	.+4
	STC]
;
;
;   8.5 CLOSE - CLOSE A DISK FILE
;
	.DEFINE CLOSE [FCB] = [
	MVI	C,16		;;CLOSE CODE
	LXI	D,FCB
	CALL	5
	CPI	0FFH		;;TEST FOR ERROR
	CMC			;;COMPLIMENT CARRY
	JNZ	.+4
	STC]
;
;
;   9.  READ - READ NEXT DISK FILE
;
	.DEFINE READ [FCB] = [ 
	MVI	C,20
	LXI	D,FCB
	CALL	5
	ORA	A
	JZ	.+4
	STC]			;;SET CARRY ON EOF OR ERR OF FILE TO SEARCH FOR
	MVI	C,18		;;SEARCH NEXT CODE
	CALL	5
	CPI	0FFH		;;0FFH = NO MATCH
	CMC			;;SET CARRY IF NO MATCH
]

;   66.  DELETE - DELETE A DISK FILE
;
	.DEFINE DELETE [FCB] = [
	MVI	C,19
	LXI	D,FCB
	CALL	5]
;

;
;  10.  CONIN [$S] - CONSOLE INPUT TO A
;
	.DEFINE CONIN [$S] = [
	.IFIDN [$S] [SR], [
		PUSH	H
		PUSH	D
		PUSH	B]
	MVI	C,1
	CALL	5
	.IFIDN [$S] [SR],[
		POP	B
		POP	D
		POP	H]
	]		;END MACRO
;
;	
;  11.  CONOUT - CONSOLE OUTPUT FROM A
;
	.DEFINE CONOUT GRAM WAS ASSEMBLED USING A Z-80 MACRO ASSEMBLY PROGRAM,
;HOWEVER ONLY 8080 INSTRUCTIONS WERE USED SO THE PROGRAM WILL
;RUN ON EITHER AN 8080 OR Z-80 BASED PROCESSOR.
;
	.XLIST
;
	;	--------  MACROS   -------
;
;
;   1.   FILL - FILL A BLOCK OF MEMORY WITH A CONSTANT MAX 64K
;
	.DEFINE FILL [START,END,CONST(0)] = [
	LXI	H,START		;;SET START ADDR
	.IFB	[END],[
	XRA	A
	MOV	M,A]		;;STORE ONE BYTE IF NO END
	.IFNB	[END],[
	LXI	D,END-START+1	;;SET LENGTH
	MVI	A,CONST		;;LOAD CONSTANT IN A
	MOV	ND SET FLAGS
;
	.DEFINE CPHL = [
	MOV	A,H
	CMP	D		;;COMPARE HIGH BYTES
	JNZ	.+5
	MOV	A,L
	CMP	E]		;;COMPARE LOW BYTES
;
;
;   3.  MOVE - MOVE A BLOCK OF LENGTH LEN FROM SOURCE TO DEST
;
	.DEFINE MOVE [SOURCE,DEST,LEN] = [
	LXI	D,SOURCE	;SOURCE
	LXI	H,DEST		;DEST
	LXI	B,LEN	;LENGTH
	LDAX	D	;GET A BYTE
	MOV	M,A	;STORE IT
	INX	H
	INX	D	;BUMP POINTERS
	DCX	B	;DECR LENGTH COUNT
	MOV	A,B
	ORA	C
	JNZ	.-7]	;TEST DONE?
;
;
;   4. MOVEI - MOVE INDIRECT BLOCK OF LENGTH LEN FROM SOURCE TO DESTALL	5]
;
;   6.  PRINTL - PRINT A LITERAL CHARACTER STRING ENCLOSED IN ' '
;
	.DEFINE	PRINTL [A$,%OUT] = [
	MVI	C,9
	LXI	D,.+9
	CALL	5
	JMP	%OUT
	.ASCII	'A$'
%OUT:]
;
;   7.  PRINT - PRINT TEXT FROM MEMORY TO CONSOLE
;
	.DEFINE PRINT [B$] = [
	MVI	C,9
	LXI	D,B$
	CALL	5]
;
;
;   7.5 DELMAK - DELETE AND MAKE A DISK FILE
;
	.DEFINE DELMAK [FCB] = [
	MVI	C,19		;;DELETE CODE
	LXI	D,FCB
	CALL	5
	MVI	C,22		;;MAKE CODE
	LXI	D,FCB
	CALL	5
	CPI	0FFH		;;TEST FOR ERROR
	CMC]			;;COMPLIMENTOR
;
;
;
;   9.5 WRITE - WRITE NEXT RECORD TO DISK
;
	.DEFINE WRITE [FCB] = [
	MVI	C,21		;;WRITE CODE
	LXI	D,FCB
	CALL	5
	ORA	A		;;SET FLAGS
	JZ	.+4
	STC]			;;SET CARRY ON ERROR
;
;
;    SEARCH - SEARCH DIRECTORY FOR FIRST FCB THAT MATCHES NAME
;
	.DEFINE SEARCH [FCB] = [
	MVI	C,17		;;SEARCH CODE
	LXI	D,FCB
	CALL	5
	CPI	0FFH		;;FFH = NO MATCH
	CMC			;;SET CARRY IF NO MATCH
]
;
;    SERNXT - SEARCH DIRECTORY FOR NEXT FCB MATCHING NAME
;
	.DEFINE SERNXT [FCB] = [
	LXI	D,FCB		;;NAME[$S] = [
	.IFIDN [$S] [SR],[
	PUSH	H
	PUSH	D
	PUSH	B]
	MOV	E,A
	MVI	C,2
	CALL	5
	.IFIDN [$S] [SR],[
	POP	B
	POP	D
	POP	H]
]		;END MACRO
;
;  12.  INDEX - INDEX AN ADDRESS POINTER BY A CONSTANT
;
	.DEFINE INDEX [POINTER,INDX] = [
	LHLD	POINTER
	LXI	D,INDX
	DAD	D
	SHLD	POINTER]
;  13.  FILFCB - FILL IN ID FIELDS OF FCB (FILE NAME ENDED BY ZERO BYTE)
;		ON EXIT - CARRY SET IF NAME TOO LONG
;			- HL POINTS TO NEXT BYTE AFTER NAME

;
	.DEFINE FILFCB [FCB,IDSTR,%ERROR,%DONE] = [
	LHLD	IDSTR		;;POINTER TO NAME STRING
	XCHG
	LXI	H,FCB		;;ADDR OF FILE CONTROL BLOCK
	.IFN $FCBSW,[
	CALL	FFCB]
	.IFE $FCBSW,[
	CALL	FFCB
$FCBSW	=	1		;;SET CONDITIONAL ASSEMBLY SWITCH
	JMP	ENDFCB
FFCB:	MVI	M,0		;CLEAR FIRST BYTE OF FCB
	INX	H
	PUSH	H		;;SAVE FCB NAME ADDR
	MVI	C,11		;;SIZE OF NAME
	MVI	A,' '		;;SPACE TO A
	MOV	M,A		;;SET NAME FIELD TO SPACES
	INX	H
	DCR	C
	JNZ	.-3
	POP	H		;;RECOVER NAME ADDR
	MVI	C,8		;;MAXIMUM SIZE OF NAME+1
	LDAX	D		;;GET ID BYTE
	CPI	' '		;;LEADING SPACES ?I	C,3		;;SIZE OF TYPE FIELD
	LDAX	D		;;GET ID BYTE	
	CPI	0		;;ZERO BYTE?
	JZ	%DONE		;;YES, DONE
	CPI	' '		;;SPACE?
	JZ	%DONE		;;YES, DONE
	MOV	M,A		;;STORE TYPE BYTE
	INX	D		;;BUMP POINTERS
	INX	H		
	DCR	C		;;DECREMENT MAX COUNT
	JNZ	.-15		;;LOOP
	JMP	%DONE		;;DONE
	
	
%ERROR:	STC			;;SET CARRY
%DONE:	XCHG			;;POINTER TO END OF NAME
	RET
ENDFCB:]]			;;END MACRO

;
;  14.  $INSTR - IN STRING FUNCTION SEARCHES STRING OF LEN LSRT FOR SUBSTRING
;		RETURNS WITH CARRY SET IF MATCH AND HL POIN1:	PUSH	H
	PUSH	D
	PUSH	B
	DCR	C		;;DECR LENGTH COUNT
	JM	.+17		;;EXIT MATCH FOUND
	LDAX	D		;;GET A BYTE FROM FIRST STRING
	CMP	M		;;CONPARE WITH SECOND STRING
	JNZ	.+8		;;EXIT NO MATCH
	INX	H
	INX	D		;;INCR ADDR POINTERS
	JMP	.-11		;;TRY AGAIN
	XRA	A		;;CLEAR CARRY
	JMP	.+4		;;EXIT
	STC			;;SET CARRY
	POP	B
	POP	D
	POP	H
	JC	SSX		;;MATCH FOUND SET POINTER AND RET
	DCR	B		;;DECR STRING LEN

	RM			;;RETURN IF MINUS - NO MATCH
	INX	H		;;INCR STRING POINTER
	JMP	INSTR1		;;GO TRY SOME MORE
H COUNT
	JM	SM3		;;EXIT MATCH FOUND
	LDAX	D		;;GET A BYTE FROM FIRST STRING
	CMP	M		;;COMPARE WITH SECOND STRING
	JNZ	SM2		;;EXIT, NO MATCH
	INX	H
	INX	D		;;INCR ADDR POINTERS
	JMP	SMATCH		;;TRY AGAIN
SM2:	XRA	A		;;CLEAR CARRY
	JMP	.+4		;;EXIT
SM3:	STC			;;SET CARRY
	RET
MATEND:]]
;
;
;   17.  IMATCH - COMPARE INDIRECT STRINGS OF EQUAL LENGTH SET CARRY IF =
;
	.DEFINE IMATCH [STR1,STR2,LEN] = [
	LXI	D,STR1		;;ONE STRING
	.IFDIF	[STR2][HL],[
	LXI	H,STR2]		;;THE OTHER
	MVI	C,LEN		;;LENGTHI	D,X
	CALL	5]
;
;
;   20. RESDRV - RESTORE SAVED DISK DRIVE NUMBER
;
	.DEFINE RESDRV [SAVE] = [
	MVI	C,14
	LDA	SAVE
	MOV	E,A
	CALL	5]
;
;
	.LIST
	.PABS
	.SALL
	.XSYM
	.LOC	100H		;SET ORIGIN AT 100
;
;SET CONDITIONAL ASSEMBLY SWITCHES
;
$FCBSW	=	0
$MATSW	=	0
$STRSW	=	0
	LXI	SP,NEWSTK	;SET UP NEW STACK
	LHLD	6		;TOP OF MEMORY
	LXI	D,-128
	DAD	D		;SUBTRACT 128 FOR LAST BLOCK
	LXI	D,5000H		;MEMORY LIMIT
	CPHL			;COMPARE DE - HL
	JC	STEND
	XCHG
STEND:	SHLD	MEMEND		;SET END OF MEM
	JNZ	.+7		;;CONTINUE IF NOT
	INX	D		;;SKIP LEADING SPACES
	JMP	.-7
	LDAX	D		;;GET ID BYTE
	CPI	0		;;IS IT A ZERO BYTE
	JZ	%DONE		;;YES DONE
	CPI	' '		;;IMBEDDED SPACE?
	JZ	%DONE		;;YES DONE
	CPI	'.'		;;NAME.TYP SEPARATOR?
	JZ	.+13		;;YES, PROCESS TYPE
	MOV	M,A		;;STORE NAME BYTE
	INX	D
	INX	H		;BUMP POINTERS
	DCR	C		;DECREMENT MAX COUNT
	JP	.-20		;LOOP
	JMP	%ERROR		;ERROR, NAME TOO BIG
	INX	D		;SKIP OVER '.'
	MOV	A,C
	ORA	A
	JZ	.+8
	INX	H		;;SKIP TO TYPE FIELD
	DCR	C		
	JNZ	.-2	
	MVTING TO END SUBSTR
;
	.DEFINE $INSTR [STRING,LSTR,SUBSTRING,%STR,%OVER] = [
	LHLD	STRING		;;GET STRING ADDR
	MVI	B,LSTR		;;STRING LENGTH
	.IFN	$STRSW,[
	LXI	D,%STR
	MVI	C,%OVER-%STR
	CALL	FSTR
	JMP	%OVER
%STR:	.ASCII	'SUBSTRING'
%OVER:]
	.IFE	$STRSW,[
	LXI	D,%STR
	MVI	C,%OVER-%STR
	CALL	FSTR
	JMP	%END
%STR:	.ASCII	'SUBSTRING'
%OVER:
	$STRSW = 1
FSTR:	MOV	A,B		;;STRING LEN
	SUB	C		;;SUBSTR LEN
	CMC
	JM	.+21		;;SUBSTR LONGER THAN STRING
	MOV	B,A		;;STRING LENGTH-SUBSTRING LENGTH
INSTR
	RET
SSX:	LXI	D,0
	MOV	E,C
	DAD	D		;;ADD LENGTH TO POINTER
	STC			;;SET CARRY
	RET
%END:]]
;
;
;  15.  $MATCH - COMPARE STRING WITH LITERAL AND SET CARRY IF EQUAL
;
	.DEFINE $MATCH [STR1,STR2,%STR,%OVER] = [
	LXI	H,STR1
	.IFN	$MATSW,[
	LXI	D,%STR
	MVI	C,%OVER-%STR
	CALL	SMATCH
	JMP	%OVER
%STR:	.ASCII	'STR2'
%OVER:]
	.IFE	$MATSW,[
	LXI	D,%STR
	MVI	C,%OVER-%STR
	CALL	SMATCH
	JMP	MATEND
%STR:	.ASCII	'STR2'
%OVER:
$MATSW	=	1		;;CONDITIONAL ASSEMBLY SWITCH
SMATCH:	DCR	C		;;DECR LENGT
	DCR	C		;;DECR LENGTH COUNT
	JM	.+17		;;MATCH FOUND EXIT
	LDAX	D		;;BYTE FROM ONE STRING
	CMP	M		;;COMPARE WITH OTHER STRING
	JNZ	.+8		;;NO MATCH EXIT
	INX	H
	INX	D		;;INCR POINTERS
	JMP	.-11		;;TRY AGAIN
	XRA	A		;;CLEAR CARRY
	JMP	.+4		;;EXIT
	STC]			;;SET CARRY ON MATCH
;
;

;   18. GETDRV - INTERROGATE AND SAVE CURRENTLY LOGGED DISK NO
;
	.DEFINE GETDRV [SAVE] = [
	MVI	C,25
	CALL	5
	STA	SAVE]
;
;
;
;   19. SETDRV - SET DISK DRIVE NUMBER
;
	.DEFINE SETDRV [X] = [
	MVI	C,14
	LXORY
	GETDRV	DRVNO		;SAVE CURRENTLY LOGGED DISK DRIVE NO
	STA	NEWDRV		;SAVE IT IN NEWDRV TOO
	LDA	80H		;BUFFER ALREADY FILLED?
	ORA	A
	JNZ	START
	PRINT	CRLF
	PRINTL	'TAPELIB UTILITY VERS 1.1$'
	PRINT	CRLF
	PRINTL	'COPYRIGHT 1977 BY S. J. SINGER$'
NEWIN:	PRINT	CRLF2
	PRINTL	'*$'
	MVI	A,0FFH		;SET SWITCH TO RETURN HERE AGAIN
	STA	INFLAG
	FILL	80H,0FFH	;ZERO INPUT BUFFER
	READTB	80H		;READ TEXT INTO BUFFER
	LDA	81H		;POINTS TO END OF INPUT
	INR	A
	STA	80H		;MOVE IT TO 80H
	XRA	A
	STA	DISFLG		;TURN OFF DISPLAY
	STA	DFLAG1
	STA	VERFLG		;RESET VERIFY FLAG
	STA	AMBIG		;RESET AMBIGUOUS FILE NAME FLAG
	STA	FAMBIG		;RESET FIRST AMBIGUOUS FILE FLAG
	MVI	A,65
	STA	BCOUNT		;RESET DISPLAY CHAR PER LINE
	MVI	A,88H
	STA	SLOC1		;RESET FILE NAME POINTER
START:	FILL	FCB,FCB+32	;ZERO ALL FIELDS OF FCB
	$INSTR	IPOINT,120,'BLOCK'	;BLOCK TAPE ?
	JNC	NODIS
	LXI	H,3000H
	SHLD	MEMEND		;SET MEMORY LIMIT
NODIS:	$INSTR	IPOINT,120,'NODISPLAY'	;TURN OFF DISPLAY ?
	JNC	MAT1
	MVI	A,0FFH
	STA	DFLAG1		;TURN $MATCH	88H,'B:'	;DRIVE B
	JNC	DTAPE
	MVI	A,1		;1 - DRIVE B
	STA	NEWDRV
DOWN:	MOVE	84H,82H,120	;SHIFT BUFFER DOWN TWO BYTES
	LXI	H,80H		;POINTS TO LENGTH OF COMMENT
	DCR	M
	DCR	M		;DECR LENGTH BY 2
;
;  DTAPE - START OF DISK TO TAPE ROUTINE
;
DTAPE:	FILFCB	FCB,SLOC1	;FILL IN FCB FROM INPUT BUFFER
	JC	NAMERR		;ERROR IN NAME PRINT ERROR MESSAGE
	PUSH	H		;POINTER TO START OF COMMENT
	FILL	FILBUF,FILBUF+128,20H   ;BLANK COMMENT FIELD OF FILE
	LDA	80H		;POINTS TO LENGTH OF COMMENT
	ADI	81H
	LXI	HNT TO FCB
	MVI	C,12		;LENGTH
MNAM:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MNAM		;MOVE NAME
	FILL	FCB+12,FCB+8	;ZERO REST OF FCB
DTAPE1:	MOVE	FCB+1,FILBUF,11	;MOVE NAME TO OUTPUT BUFFER
	RESDRV	NEWDRV		;SELECT NEW DRIVE
	OPEN	FCB
	JNC	LDFIL
OPNERR:	PRINT	CRLF

	LDA	NEWDRV
	ORA	A
	JNZ	OER1
	PRINTL	'NO FILE BY THAT NAME ON DRIVE A$'
	JMP	MOREIN
OER1:	PRINTL	'NO FILE BY THAT NAME ON DRIVE B$'
	JMP	MOREIN
LDFIL:	LXI	H,FILBUF+128	;SET DISK FILE BUFFER POINTER
	SHLD	BPOINT
	LXI	H,80H
	SH TOO LARGE FOR MEMORY$'
	PRINT	CRLF
	PRINTL	'WRITING BLOCKED OUTPUT TAPE$'
	LDA	FAMBIG
	ORA	A
	JNZ	GOBLK		;DISPLAY MESS ONLY FOR FIRST BLK
	MVI	A,-1
	STA	FAMBIG		;START TAPE DISPLAY OFF
	CALL	STARTW		;DISPLAY START MESSAGE
GOBLK:	PRINT	CRLF2
	MOVE	FILBUF,FILBUF+1280,128	;SAVE COMMENT FIELD
	JMP	BLKOUT		;WRITE BLOCKED OUTPUT TAPE
ENDFIL:	CPI	1		;TEST FOR EOF
	JZ	TAPE
RDERR:	PRINT	CRLF
	PRINTL	'DISK READ ERROR$'
	JMP	MOREIN		;EXIT
TAPE:	LHLD	NBLOCKS		;GET NO OF 128 BYTE BLOCKS READ
	INX	H
	
	ORA	A
	JNZ	PMX		;NO START MESSAGE
	CALL	STARTW		;DISPLAY MESSAGE
	MVI	A,0FFH
	STA	FAMBIG		;SET SWITCH FOR DISPLAY OFF
PMX:	CALL	WRID		;WRITE AN ID BLOCK ON TAPE
	POP	B		;NO OF 256 BYTE BLOCKS IN B
	LXI	H,FILBUF
	MVI	C,1		;RECORD TYPE
	CALL	TAPOUT		;WRITE THE RECORD
PMY:	LDA	AMBIG		;AMBIGUOUS NAME FLAG
	ORA	A
	JZ	PM2		;NOT SET THEN EXIT
	CALL	GETNAM		;SEARCH DIR WITH PREVIOUS NAME
	MOVE	AMBNAM,FCB,12	;AMBIG NAME FOR NEXT SEARCH
	CALL	GETNEXT		;SEARCH DIR FOR NEXT NAME
	JC	PM2		;EXIT IF NO OFF DISPLAY FOR SLOW TERMINALS
MAT1:	$MATCH	82H,'TAPE:='
	JC	DT1
	$MATCH	82H,'DISK:='
	JC	TDISK
	$MATCH	82H,'A:='
	JC	ADISK
	$MATCH	82H,'B:='
	JC	BDISK
	$MATCH	82H,'RUN:='
	JC	RUNFIL		;GO TO EXEC FILE IF TYPE COM
INERR:	PRINT	CRLF
	PRINTL	'ERROR - NO SUCH DESTINATION$'
	JMP	MOREIN	;ERROR IN INPUT COMMAND STRING EXIT
;
;    SELECT DISK DRIVE
;
DT1:	$MATCH	88H,'SYNC'	;TEST FOR WRITE SYNC STREAM
	JC	SYNC
	$MATCH	88H,'A:'	;DRIVE A
	JNC	DT2
	XRA	A		;0 - DRIVE A
	STA	NEWDRV
	JMP	DOWN
DT2:	,0		;ZERO HL
	MOV	L,A		;HL POINTS TO END OF COMMENT
	POP	D		;POINTS TO START OF COMMENT
	LXI	B,FILBUF+11	;POINTS TO OUTPUT BUFFER
MOVCOM:	CPHL			;FINISHED MOVE ?
	JZ	ENDMOV
	LDAX	D		;GET BYTE OF COMMENT
	STAX	B		;STORE IT
	INX	D
	INX	B
	JNZ	MOVCOM		;LOOP BACK
ENDMOV:	CALL	SCANFCB		;CHECK FOR AMBIGUOUS FILE NAME
	JNC	DTAPE1
	MOVE	FCB,AMBNAM,12	;SAVE AMBIGUOUS FILE NAME
	MVI	A,0FFH
	STA	AMBIG		;SET AMBIGUOUS NAME FLAG
	RESDRV	NEWDRV		;SELECT NEW DRIVE IF ANY
	CALL	GETNAM
DAM:	LXI	D,FCB		;POILD	IPOINT		;RESET INPUT BUFFER POINTER TO 80H
	LXI	H,0
	SHLD	NBLOCKS		;INITIALIZE BLOCK COUNT TO ZERO
LD1:	READ	FCB		;READ A RECORD FROM DISK
	JC	ENDFIL		;EXIT IF ERROR OR EOF
	MOVEI	IPOINT,BPOINT,128	;MOVE BLOCK TO BUFFER
	INDEX	NBLOCKS,1	;INDEX BLOCK COUNT BY ONE
	INDEX	BPOINT,128	;INDEX BUFFER POINTER BY 128
	XCHG
	LHLD	MEMEND		;TEST FOR MEMORY OVERFLOW
	CPHL			;COMPARE DE AND HL
	JNC	LD1		;BACK TO READ LOOP
MEMFUL:	PRINT	CRLF2
	PRINTL	'BLOCKED TAPE REQUESTED OR$'
	PRINT	CRLF
	PRINTL	'FILEINX	H		;ADD 2 FOR ROUNDING
	MOV	A,H		;SHIFT RIGHT 1 BIT DOUBLE
	RAR
	MOV	A,L
	RAR
	PUSH	PSW		;STACK HAS NO OF 256 BYTE BLOCKS
	JC	PM1		;CARRY SET, PRINT MESSAGE
	LHLD	BPOINT		;NOT SET, FILL LAST 128 BYTES WITH ^Z
	PUSH	H
	INDEX	BPOINT,128
	XCHG			;END OF BLOCK IN D
	LHLD	MEMEND		;TOP OF MEMORY
	CPHL
	JC	MEMFUL		;MEMORY FILLED PRINT ERROR MESSAGE
	POP	H		;BEGINING OF BLOCK IN HL
LF1:	MVI	A,1AH		;CONTROL Z
	MOV	M,A		;STORE IT IN MEMORY
	INX	H
	CPHL			;LIMIT REACHED
	JNZ	LF1
PM1:	LDA	FAMBIGMORE NAMES
	PUSH	H
	PRINT	CRLF2		;SPACE AND RING BELL
	POP	H
	JMP	DAM		;WRITE THE FILE ON TAPE
PM2:	CALL	STOP		;DISPLAY STOP MESSAGE
	JMP	MOREIN		;EXIT
;
;    THIS ROUTINE WRITES BLOCKED OUTPUT TAPES FOR FILES
;    TOO LARGE FOR MEMORY
;
BLKOUT:	CLOSE	FCB
	FILL	FCB+12,FCB+8,0
	FILL	FILBUF+128,FILBUF+1024,1AH
	OPEN	FCB		;POSITION FILE TO FIRST RECORD
	LXI	H,FILBUF+128
	SHLD	BPOINT
	LXI	H,80H
	SHLD	IPOINT		;RESET DATA TRANSFER POINTERS
	MVI	A,0FFH
	STA	FIRST		;INDICATE FIRST RECORD
	MVI	A,15
	STA	BLKBLK		;RESET BLOCK COUNTER
RBEG:	MVI	A,1
	STA	BLOCK		;SET BLOCK COUNT TO 1
RLOOP:	READ	FCB		;READ A RECORD FROM DISK
	JC	FEND		;CARRY SET ON EOF OR ERROR
	MOVEI	IPOINT,BPOINT,128	;MOVE BLOCK
	LDA	BLOCK
	CPI	8
	JZ	TAPWRT		;IF 8 RECORDS WRITE TAPE
	INR	A
	STA	BLOCK		;INCR BLOCK COUNT
	INDEX	BPOINT,128	;INCR  ADDR BY 128
	JMP	RLOOP
FEND:	CPI	1
	JNZ	RDERR		;DISK READ ERROR
	MVI	C,2		;TYPE
	XRA	A		;CLEAR CARRY
	LDA	BLOCK		;BLOCK COUNT
	INR	A
	RAR			;NO OF 256 BYTE BLOCKS
	MOV	B,A	LL	WRID		;WRITE FILE HEADER
	MVI	C,0		;FIRST BLOCK TYPE 0
	MVI	B,5		;5 BLOCKS WITH HEADER
	XRA	A
	STA	FIRST		;NOT FIRST
	JMP	BLKN		;BACK TO OUTPUT
;
;
;    RUN TAPE FILE
;
RUNFIL:	LXI	H,87H
	SHLD	SLOC1		;POINTER TO FILE NAME
	MVI	A,0FFH
	STA	RUNFLG		;SET RUN FLAG TRUE
	JMP	TDISK
;
;    SELECT DISK DRIVE
;
ADISK:	XRA	A		;0 - DRIVE A

	STA	NEWDRV
	JMP	BD1
BDISK:	MVI	A,1		;1 - DRIVE B
	STA	NEWDRV
BD1:	LXI	H,85H
	SHLD	SLOC1		;POINTER TO NAME
;
;  TDISK - START OF TAPE TO DISK ROUTINE
			;WAIT FOR CONSOLE INPUT
	CPI	3		;CONTROL C ?
	JZ	MOREIN		;RETURN TO MONITOR
	JMP	TAPIN		;TO TAPE INPUT ROUTINE
;
;   CASW - CASSETTE OUTPUT ROUTINE  (DATA IN A)
;
CASW:	PUSH	H		;SAVE REGS
	PUSH	D
	PUSH	B
	PUSH	PSW
	CALL	ESCAPE		;CHECK FOR CONTROL C
CAS1:	IN	CASC		;GET STATUS
	ANI	20H
	JNZ	CAS1		;WAIT FOR STATUS READY
	POP	PSW		;DATA BACK TO A
	PUSH	PSW		;SAVE IT AGAIN
	OUT	CASD		;WRITE BYTE TO TAPE
	OUT	0FFH		;OUT TO LIGHTS
	LXI	H,CKSUM		;MEMORY ADDR OF CHECKSUM
	ADD	M		;ADD TO A
	STM		;ADD IT TO DATA
	STA	CKSUM		;STORE IT BACK
	POP	PSW		;GET BACK DATA
	PUSH	PSW		;SAVE IT AGAIN
	CALL	DISPLY		;OUT TO CONSOLE
	POP	PSW		;GET BACK DATA
	POP	B
	POP	D
	POP	H		;RESTORE REGISTERS
	RET
;  ESCAPE - TEST FOR CONTROL C AND RETURN TO MONITOR
;
ESCAPE:	MVI	C,11
	CALL	5
	ANI	1
	RZ			;RETURN IF LOW BIT NOT SET
	CONIN
	CPI	3		;TEST FOR ^C
	JZ	MOREIN		;EXIT TO MONITOR OR BACK TO INPUT
	RET
;
;
;   DISPLY - OUTPUT A TO CONSOLE AND SUBSTITUTE . FOR ^ CHARACTERS
;
DISPLY:	PUSH	PSW		KIP:	MVI	A,2EH		;ASCII PERIOD
XSKIP:	CONOUT			;OUT TO CONSOLE
	RET
YSKIP:	POP	PSW
	RET
;   NAME ERROR IN FILE NAME - PRINT ERROR MESSAGE
;
NAMERR:	PRINT	CRLF
	PRINTL	'ERROR IN FILE NAME$'
	JMP	MOREIN		;EXIT BACK TO MONITOR
;
;
;
;   TAPEOUT - OUTPUT BLOCK OF TAPE IN TARBELL FORMAT
;
TAPOUT:	PUSH	H		;SAVE POINTER
	LXI	H,BLKBLK	;POINT TO BLOCK COUNT
	INR	M		;INCR BY ONE
	MVI	A,16		;BLOCK LIM 1
	CMP	M
	JZ	T0		;WRITE SPACER BLOCK
	INR	A
	CMP	M		;IS COUNT 18
	JNZ	T1		;NO EXTRA SPACE BLOCK
	;STORE IN B
	LXI	H,FILBUF	;BUFFER POINTER
	CALL	WRSPAC		;WRITE SPACER BLOCK
	CALL	TAPOUT
	MOVE	FILBUF+1280,FILBUF,128	;RESTORE COMMENT FIELD
	JMP	PMY		;PRINT MESSAGE AND EXIT
TAPWRT:	LDA	FIRST
	ORA	A		;IS THIS THE FIRST RECORD
	JNZ	BLK1		;YES, WRITE IT WITH HEADER
	MVI	C,1
	MVI	B,4		;BLOCK COUNT
BLKN:	LXI	H,FILBUF	;BUFFER POINTER
	CALL	WRSPAC		;WRITE SPACER BLOCK
	CALL	TAPOUT		;WRITE TAPE
	FILL	FILBUF,FILBUF+1024,1AH
	LXI	H,FILBUF
	SHLD	BPOINT
	JMP	RBEG		;BACK FOR MORE DISK INPUT
BLK1:	CA;
TDISK:	FILFCB	FCB,SLOC1	;FILL IN FCB FROM INPUT BUFFER
	JC	NAMERR		;FILE NAME ERROR PRINT MESS
	CALL	SCANFCB		;CONVERT * TO ? IN AMBIG FILE NAMES
	JNC	TDISK1
	MVI	A,-1
	STA	AMBIG		;SET AMBIGUOUS NAME FLAG
	MOVE	FCB,AMBNAM,12	;SAVE AMBIG NAME
TDISK1:	MOVE	80H,FILBUF,128	;SAVE NAME AND COMMENT, RESDRV MAY USE BUFFER
	RESDRV	NEWDRV		;LOAD NEW DRIVE NO IF SELECTED
	MOVE	FILBUF,80H,128	;RESTORE NAME AND COMMENT
	PRINT	CRLF2
	PRINTL	'START CASSETTE TAPE - TYPE CARRIAGE RETURN$'
	PRINT	CRLF2
	CONINA	CKSUM		;STORE IT BACK
	POP	PSW		;GET BACK DATA
	CALL	DISPLY		;OUTPUT TO CONSOLE
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	RET
CASC	==	6EH		;CASSETTE STATUS PORT
CASD	==	6FH		;CASSETTE DATA   PORT
;
CASR:	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
ETEST:	CALL	ESCAPE		;CHECK FOR CONTROL C
READCT:	IN	CASC		;READ CASSETTE STATUS
	ANI	10H		;CHECK BIT 4
	JNZ	ETEST		;WAIT TILL READY
	IN	CASD		;READ CASSETTE DATA
	PUSH	PSW		;SAVE IT
	OUT	0FFH		;OUT TO LIGHTS
	LXI	H,CKSUM		;POINTER TO CKSUM
	ADD	;SAVE DATA
	LDA	DISFLG		;DISPLAY FLAG
	ORA	A
	JZ	YSKIP		;OUT IF ZERO
	LDA	DFLAG1
	ORA	A		;DISPLAY OFF FOR SLOW TERMINALS
	JNZ	YSKIP		;OUT IF NOT ZERO
	LDA	BCOUNT		;COUNT OF BYTES PER LINE
	DCR	A		;DECR BY ONE
	STA	BCOUNT		;STORE IT BACK
	JNZ	USKIP		;CONTINUE IF NOT END OF LINE
	PRINT	CRLF
	MVI	A,64		;CHAR PER LINE
	STA	BCOUNT		;RESET COUNTER
USKIP:	POP	PSW		;GET BACK DATA
	CPI	7FH		;COMPARE WITH RUBOUT
	JP	VSKIP		;PRINT PERIOD
	CPI	20H		;COMPARE WITH SPACE
	JP	XSKIP		;SKIP SUBSTITUTION
VS
	MVI	M,1		;SET BLOCK COUNT TO ONE
T0:	CALL	WRSPAC		;WRITE SPACE BLOCK
	CALL	WRSPAC		;WRITE SPACE BLOCK
T1:	POP	H		;RESTORE POINTER
	MVI	A,3CH		;START BYTE
	CALL	CASW		;WRITE IT OUT
	MVI	A,0E6H		;SYNC BYTE
	CALL	CASW		;WRITE IT
	XRA	A
	STA	CKSUM		;ZERO CHECKSUM
	MVI	A,0FFH		;DECODE BYTE
	CALL	CASW		;WRITE IT
	MOV	A,C		;TYPE BYTE
	CALL	CASW		;WRITE IT TO TAPE
	MOV	A,B		;NO OF 256 BYTE BLOCKS
	CALL	CASW		;WRITE IT OUT
	MVI	A,0FFH		;SET DISPLAY FLAG
	STA	DISFLG
T2:	MVI	C,0		;BLOCK LENGTH IN BYTES - 1
T3:	MOV	A,M		;GET A BYTE FROM MEMORY
	CALL	CASW		;WRITE IT TO CASSETTE
	INX	H
	DCR	C
	JNZ	T3		;LOOP TILL END OF BLOCK
	DCR	B
	JNZ	T2		;LOOP TILL ALL BLOCKS DONE
T4:	XRA	A
	STA	DISFLG		;TURN OFF DISPLAY
	LDA	CKSUM
	CALL	CASW		;WRITE CHECKSUM
	RET			;BYE
;
;  TAPIN - TAPE INPUT ROUTINE
;
TAPIN:	XRA	A
	STA	DISFLG		;TURN OFF DISPLAY
	CALL	RDID		;SEARCH TAPE FOR ID BLOCK
	XRA	A		;ZERO
	STA	CKSUM		;ZERO CHECKSUM
	MVI	A,10H
	OUT	CASC		;RESET RECEIVER
	CALL	CASR		;READ DECODE BYTE
	EAD A BYTE
	MOV	M,A		;STORE IT
	INX	H
	DCR	C		;DECR LENGTH
	JNZ	RD2		;LOOP BACK
	DCX	D
	MOV	A,D		;DECR BLOCK COUNT FOR NAME CHECK
	ORA	E
	JZ	NAMCHK		;COMPARE NAME FROM TAPE WITH FCB
GOON:	DCR	B		;DECR NO OF BLOCKS
	MVI	C,0		;NO OF BYTES PER BLOCK - 1
	JNZ	RD2		;LOOP BACK
	SHLD	ENDF		;SAVE LOCATION OF LAST BYTE READ
	LDA	CKSUM		;GET CHECKSUM FROM MEMORY
	MOV	B,A		;STORE IT TEMPORARILY IN B
	XRA	A		;ZERO
	STA	DISFLG		;TURN OFF DISPLAY
	CALL	CASR		;READ CHECKSUM FROM TAPE
	SUB	B		;COMPARE IT 
NAMCHK:	PUSH	H
	PUSH	D
	PUSH	B
	PRINT	CRLF
	LXI	H,FILBUF	;SET POINTERS
	LXI	D,FCB+1
	MVI	C,11
NAMC1:	DCR	C
	JM	NAMC3		;MATCH IF MINUS
	LDAX	D		;GET BYTE OF FCB NAME
	CPI	'?'
	JNZ	NAMCY
	MOV	A,M		;CHECK NAME FOR NON PRINTABLE CHAR
	CPI	20H
	JM	NAMC2
	CPI	7FH		;DELETE CODE
	JP	NAMC2
	JMP	NAMCX
NAMCY:	CMP	M		;COMPARE WITH FILE NAME
	JNZ	NAMC2
NAMCX:	INX	H
	INX	D
	JMP	NAMC1
NAMC2:	XRA	A		;CLEAR CARRY
	JMP	ENDCK
NAMC3:	STC
ENDCK:	POP	B
	POP	D
	POP	H
	JC	TYPCHK		;MATCH, CHECK TYPE
	OT FINISHED
	MVI	C,0		;RESET BYTES PER BLOCK (256)
	DCR	B		;DECR BLOCK COUNT
	JNZ	RD5		;READ ANOTHER BLOCK
	SHLD	ENDF		;SAVE LAST LOCATION USED IN BUFFER
	XRA	A
	STA	DISFLG		;TURN OFF DISPLAY
	LDA	CKSUM		;GET CHECKSUM READ FROM TAPE
	MOV	B,A		;SAVE IT IN B
	CALL	CASR		;READ BLOCK CHECKSUM
	SUB	B		;COMPARE
	JNZ	TPERR		;CHECKSUM ERROR
;
;    NOW WRITE THE BLOCK ON DISK OR VERIFY IT
;
	LDA	TYPE		;GET TYPE
	ORA	A
	JNZ	WBLK		;IF NOT ZERO WRITE BLOCK
	LDA	VERFLG		;CHECK VERIFY FLAG (SET IF CKSUMLXI	H,FILBUF	
	SHLD	BPOINT		;SET DMA ADDR
WD4:	MOVEI	BPOINT,IPOINT,128	;MOVE BLOCK
	WRITE	FCB		;WRITE A RECORD ON DISK
	JC	DERR		;DISK WRITE ERROR (FULL)
	INDEX	BPOINT,128	;INCR  ADDR BY 128
	LDA	NBLOCKS		;BLOCK COUNT
	DCR	A
	STA	NBLOCKS		;DECR BY 1
	JNZ	WD4		;WRITE ANOTHER BLOCK
WD4X:	LDA	TYPE
	CPI	2		;IS IT LAST BLOCK
	JZ	WD5		;CLOSE FILE AND EXIT
	XRA	A
	STA	CKSUM		;ZERO CHECKSUB
	STA	DISFLG		;TURN OFF DISPLAY
	MVI	A,10H
	OUT	CASC		;RESET RECEIVER
	CALL	CASR		;READ DECODE BYTE
	CALL	CACPI	0FFH		;CHECK IT
	JNZ	TAPIN
	CALL	CASR		;READ TYPE BYTE
	STA	TYPE		;SAVE IT
	CPI	3		;CHECK TYPE < 3
	JP	TAPIN
	CALL	CASR		;READ LENGTH
	LXI	H,0
	MOV	L,A		;NO OF 256 BYTE BLOCKS ON TAPE
	MOV	B,A		;SAVE IT IN B
	DAD	H		;SHIFT LEFT 1
	DCX	H		;NUMBER OF 128 BYTE BLOCKS (FOR DISK)
	SHLD	NBLOCKS		;STORE TO MEMORY
	MVI	A,0FFH		;.TRUE.
	STA	DISFLG		;TURN ON DISPLAY FLAG
	LXI	H,FILBUF	;BUFFER POINTER
	LXI	D,1		;BLOCK COUNT FOR NAME CHECK
RD1:	MVI	C,128		;NO BYTES PER BLOCK - 1
RD2:	CALL	CASR		;RWITH MEMORY
	JNZ	TPERR		;CHECKSUM ERROR
	LDA	AMBIG		;CHECK AMBIG FLAG
	ORA	A
	JNZ	PCR2		;TO DISK ROUTINE
	CALL	STOP		;DISPLAY STOP MESSAGE
	JMP	WDISK		;TO DISK WRITE ROUTINE
PCR2:	PRINT	CRLF2		;CARRIAGE RET
	JMP	WDISK		;TO DISK WRITE ROUTINE
;
TPERR:	PRINT	BELL
	PRINTL	'CHECKSUM ERROR$'
	PRINT	CRLF
	PRINTL	'TO RESTART - REWIND TAPE AND TYPE CARRIAGE RETURN$'
	PRINT	CRLF
	CONIN			;READ CONSOLE
	CPI	3		;CONTROL C ?
	JZ	MOREIN		;RETURN TO MONITOR
	JMP	TAPIN		;BACK TO TAPE INPUT ROUTINE
;
;
JMP	TAPIN		;NO MATCH SEARCH SOME MORE
TYPCHK:	LDA	TYPE		;GET TYPE
	CPI	1		;IS IT TYPE 1
	JZ	RD1		;YES,UNBLOCKED RECORD
;
;    THIS ROUTINE READS BLOCKED TAPES
;
BLKIN:	PUSH	B		;SAVE BLOCK COUNT
	MOVE	FILBUF,FCB+1,11	;MOVE NAME INTO FCB
	XRA	A
	STA	FCB+32
	POP	B		;RESTORE BLOCK COUNT
	LXI	H,FILBUF	;POINTER TO BUFFER
	MVI	C,128		;BYTES LEFT IN FIRST BLOCK
RD5:	CALL	CASR		;READ A BYTE FROM TAPE
	MOV	M,A		;STORE IN BUFFER
	INX	H		;INCR BUFFER POINTER
	DCR	C		;DECR BYTE COUNT
	JNZ	RD5		;BLOCK N ERROR)
	ORA	A
	JNZ	VERBLK		;VERIFY TAPE
	$INSTR	IPOINT,120,'VERIFY'	;VERIFY FILE ?
	JNC	REN1
	MVI	A,0FFH
	STA	VERFLG		;SET VERIFY FLAG
	JMP	VERBLK
REN1:	CALL	RENFIL		;RENAME FILE ?
	$INSTR	IPOINT,120,'RUN'	;RUN FILE ?
	JC	RUNERR
	CALL	$$$TYP		;SAVE OLD TYPE AND SUB $$$
	DELMAK	FCB		;IF FIRST BLOCK DELETE
WD3X:	OPEN	FCB		;AND OPEN FILE
	LDA	NBLOCKS		;NO OF 128 BYTE BLOCKS
	DCR	A		;SUBTRACT 1 FOR HEADER
	STA	NBLOCKS		;STORE IT BACK
WBLK:	LDA	VERFLG		;CHECK VERIFY ONLY
	ORA	A
	JNZ	VERNXT
	SR		;READ	TYPE
	STA	TYPE		;SAVE IT
	CALL	CASR		;READ	LENGTH
	LXI	H,0
	MOV	L,A
	MOV	B,A		;NO OF 256 BYTE BLOCKS
	DAD	H
	SHLD	NBLOCKS		;SAVE NO OF 128 BYTE BLOCKS
	LXI	H,FILBUF	;BUFFER POINTER
	MVI	C,0		;NO OF BYTES PER BLOCK (256)
	MVI	A,0FFH
	STA	DISFLG		;TURN ON DISPLAY
	JMP	RD5		;READ ANOTHER BLOCK
WD5:	LDA	AMBIG		;CHECK AMBIG FILE NAME FLAG
	ORA	A
	JNZ	WD6		;OMIT STOP MESSAGE
	CALL	STOP		;DISPLAY STOP TAPE MESSAGE
WD6:	LDA	VERFLG		;CHECK VERIFY FLAG
	ORA	A
	JNZ	VOUT
	JMP	DWCLOS
;
;   WDISK - DISK OUTPUT ROUTINE
;
WDISK:	MOVE	FILBUF,FCB+1,11	;MOVE NAME INTO FCB
	LDA	VERFLG
	ORA	A
	JNZ	VERIFY
	$INSTR	IPOINT,120,'VERIFY'	;VERIFY ONLY?
	JC	VERIFY
	$INSTR	IPOINT,120,'RUN'	;LOAD AND EXEC FILE?
	JC	RUN
	LDA	RUNFLG		;GET RUN FLAG, OTHER RUN TEST
	ORA	A
	JNZ	RUN
	CALL	RENFIL		;RENAME ?
WDISK1:	CALL	$$$TYP		;CHANGE TYPE TO $$$ AND SAVE OLDTYP
	DELMAK	FCB		;DELETE AND MAKE FILE
	OPEN	FCB		;OPEN THE FILE
	JC	OPNERR		;ERROR ON OPEN - PRINT MESS AND EXIT
	LXI	H,FILBUF+128	;POINTERCB+25,3
	MVI	C,19		;DELETE
	LXI	D,FCB+16
	CALL	5
	MVI	C,23
	LXI	D,FCB
	CALL	5		;RENAME ROUTINE
	JMP	AMBCHK		;RETURN FOR MORE TAPE INPUT ON AMBIG NAME
;
;
VERIFY:	LXI	H,FILBUF+128	;POINTER TO START OF TAPE FILE
	SHLD	BPOINT
	MVI	A,-1
	STA	VERFLG		;SET VERIFY FLAG
	OPEN	FCB		;OPEN THE DISK FILE
	JC	OPNERR		;PRINT ERROR MESSAGE IF NO FILE
VLOOP:	READ	FCB		;READ A DISK RECORD
	JC	VEND		;EXIT ON EOF OR ERROR
	LHLD	BPOINT		;POINTER FOR COMPARE
	IMATCH	80H,HL,128	;COMPARE (HL POINTS TO ONE STRINK IS
;    MADE TO VERIFY THAT IT IS A COM FILE.
;
RUN:	$MATCH	65H,'COM'	;TYPE IN FCB
	JNC	TYPERR
	MOVE	CODE,80H,40	;FILE OVERLAYS PROG MOVE TO BUFFER
	JMP	80H		;GO EXECUTE MOVE ROUTINE
CODE:	LXI	B,100H
	LXI	D,FILBUF+128	;POINTS TO BEGINNING OF FILE
	LHLD	ENDF		;LAST LOC TO BE MOVED
MLOOP:	LDAX	D		;GET A BYTE
	STAX	B		;STORE IT
	INX	D
	INX	B
	MOV	A,H		;COMPARE DE WITH HL
	CMP	D
	JNZ	89H
	MOV	A,L
	CMP	E
	JNZ	89H
	LXI	H,0
	SHLD	80H		;ZERO START OF INPUT BUFFER
	JMP	100H		;EXECUTE MOVED FI DISK INPUT
	SHLD	BPOINT
	LDA	NBLOCKS
	CPI	9		;SET BLOCKS TO 8 IF > 8
	JM	VER2
	MVI	A,8		;SET BLOCKS TO 8
	STA	NBLOCKS
VER2:	READ	FCB		;READ A RECORD
	JNC	VER3
	CPI	1		;TEST EOF
	JNZ	RDERR		;DISK READ ERROR
	JMP	WD5		;PRINT STOP MESSAGE AND EXIT
VER3:	MOVEI	IPOINT,BPOINT,128
	INDEX	BPOINT,128	;INCR POINTER
	LDA	NBLOCKS		;BLOCK COUNT
	DCR	A
	STA	NBLOCKS		;DECR COUNT BY 1
	JNZ	VER2		;READ SOME MORE
	LHLD	BPOINT		;POINTS TO END OF BLOCK
	DCX	H		;DECR BY 1
	XCHG			;TO DE
	LXI	H,FILBUF+1024	1
SCAN2:	LXI	H,FCB+9		;POINTS TO TYPE
	CMP	M		;IS TYPE A *
	JNZ	SCAN4
	MVI	C,3		;FILL TYPE WITH '?'
SCAN3:	MOV	M,B		;MOVE A BYTE
	INX	H
	DCR	C
	JNZ	SCAN3
SCAN4:	LXI	H,FCB+1		;RESCAN FOR ? AND SET CARRY
	MVI	C,11
	MOV	A,B		;PUT '?' IN A
SCAN5:	CMP	M
	JZ	SCAN6
	INX	H
	DCR	C
	JNZ	SCAN5
	XRA	A		;CARRY OFF NO '?'
	RET
SCAN6:	STC			;CARRY ON
	RET
;
;    THIS ROUTINE SEARCHES DIRECTORY WITH AMBIGUOUS FILE NAME
;
GETNAM:	MVI	A,0
	STA	FCB+12		;SET FILE EXTENT TO ZERO
	SEARCH	FCB
	CPI	0FFH	 TO START OF FILE IN MEMORY
	SHLD	BPOINT		;SET POINTER
DWLOOP:	MOVEI	BPOINT,IPOINT,128	;MOVE INDIRECT BLOCK TO OUT BUFFER
	WRITE	FCB		;WRITE IT OUT
	JC	DERR		;JUMP TO WRITE ERROR
	LHLD	NBLOCKS		;NO OF BLOCKS TO WRITE
	DCX	H		;DECREMENT IT
	MOV	A,H
	ORA	L
	JZ	DWCLOS		;CLOSE FILE AND EXIT
	SHLD	NBLOCKS		;OTHERWISE STORE IT BACK
	INDEX	BPOINT,128	;INCR MEMORY POINTER BY 128
	JMP	DWLOOP		;BACK TO WRITE ANOTHER BLOCK
;
DWCLOS:	CLOSE	FCB		;CLOSE FILE
	MOVE	FCB,FCB+16,12	;RENAME FILE
	MOVE	OLDTYP,FG)
	JNC	VERERR		;EXIT IF NO MATCH
	INDEX	BPOINT,128	;INCR THE POINTER
	JMP	VLOOP		;DO ANOTHER RECORD
VEND:	CPI	1		;CHECK END FILE
	JNZ	RDERR		;READ ERROR IF NOT 1
VOUT:	PRINT	BELL2
	PRINTL	'VERIFIED SUCCESSFULLY$'
	PRINT	CRLF
AMBCHK:	LDA	AMBIG		;CONTINUE IF AMBIGUOUS FILE NAME
	ORA	A
	JZ	MOREIN		;EXIT
	MOVE	AMBNAM,FCB,12	;REPLACE AMBIG NAME IN FCB
	XRA	A
	STA	FCB+12		;ZERO EXTENTS
	STA	FCB+32
	JMP	TAPIN		;BACK TO TAPE INPUT
;
;    THIS SECTION MOVES THE FILE TO 100H AND EXECUTES IT. A CHECLE
;
;    RENAME ROUTINE - RENAME FILE FOR TAPE TO DISK TRANSFER
;
RENFIL:	$INSTR	IPOINT,120,'RENAME'	;RENAME ?
	RNC			;RETURN IF NO 'RENAME'
SKPBLK:	INX	H		;INCR POINTER
	MOV	A,M		;GET A BYTE
	CPI	20H		;IS IT A BLANK
	JZ	SKPBLK		;SKIP OVER BLANKS
	SHLD	SLOC2		;STORE POINTER
	FILFCB	FCB,SLOC2	;FILL IN FCB WITH NEW NAME
	JC	NAMERR		;ERROR IN NAME (TOO LONG)
	RET
;
;    VERIFY BLOCKED TAPE
;
VERBLK:	OPEN	FCB		;OPEN THE FILE
	JC	OPNERR		;EXIT IF NO FILE
VERNXT:	LXI	H,FILBUF+1024	;POINTER FOR;POINTS TO DISK DATA
	LXI	B,FILBUF	;POINTS TO TAPE DATA
VER4:	LDAX	B		;GET A BYTE
	CMP	M		;COMPARE
	JNZ	VERERR		;ERROR, NO MATCH
	INX	H
	INX	B
	CPHL			;COMPARE HL AND DE
	JNZ	VER4
	JMP	WD4X		;BACK INTO TAPE INPUT ROUTINE
;
;    THIS ROUTINE SCANS FCB NAME AND FILLS * TO ?.
;    CARRY SET SET IF * OR ? IN FILE NAME
;
SCANFCB:LXI	H,FCB+1		;POINTS TO FILE NAME
	MVI	B,'?'
	MVI	A,'*'
	CMP	M		;IS NAME *
	JNZ	SCAN2
	MVI	C,8		;FILL IN 8 '?'
SCAN1:	MOV	M,B		;MOVE A BYTE
	INX	H
	DCR	C
	JNZ	SCAN	;CHECK NAME NOT PRESENT
	JZ	OPNERR		;DISPLAY ERROR MESSAGE
	JMP	N1
GETNEXT:SERNXT	FCB		;SEARCH FOR NEXT OCCURRANCE OF NAME
	CPI	0FFH		;NAME NOT FOUND ?
	JNZ	N1		;RETURN ADDR IF FOUND
	STC
	RET			;SET CARRY AND RETURN
N1:	ANI	03		;ADDR MOD 4
	RRC
	RRC
	RRC			;ADDR * 32
	ADI	80H		;ADD BASE ADDR 
	LXI	H,0
	MOV	L,A		;HL NOW POINTS TO FCB FROM DIR
	XRA	A		;CLEAR CARRY
	RET
;
;   WRITE SYNC STREAM ON TAPE (65K BYTES)
;
SYNC:	CALL	STARTW		;PRINT START MESSAGE
	MVI	A,0FFH
	STA	DISFLG		;TURN ON DISPLAY
	LXI	D,0		;SYNC BYTE COUNTER
SYNC1:	MVI	A,0E6H		;LOAD A SYNC BYTE
	CALL	CASW		;WRITE IT OUT
	DCX	D		;DECR COUNT
	MOV	A,D
	ORA	E
	JNZ	SYNC1		;TEST COUNT AND LOOP
	CALL	STOP		;PRINT STOP MESSAGE
	JMP	MOREIN
;
;
;    SWAP FCB TYPE WITH $$$
;
$$$TYP:	MOVE	FCBTYP,OLDTYP,3	;MOVE TYPE TO TEMPORARY STORAGE
	FILL	FCBTYP,FCBTYP+2,'$'
	RET
;
;    WRITE LEADER AND ID BLOCK OF 100 76H BYTES ON TAPE
;
WRID:	LXI	D,1500		;LOAD COUNT
WRHD:	MVI	A,3CH		;START BYTE
	CALL	CASW		;WRITE IT
	DCX	D	  WRITE SPACER BLOCK OF START BYTES FOR BLOCKED TAPES
;
WRSPAC:	PUSH	H
	PUSH	D
	PUSH	B
	LXI	D,160		;COUNT
WRSP1:	MVI	A,3CH		;START BYTE
	CALL	CASW		;WRITE IT
	DCX	D		;DECR COUNT
	MOV	A,D
	ORA	E
	JNZ	WRSP1		;LOOP TILL COUNT IS ZERO
	POP	B
	POP	D
	POP	H
	RET
;
;   CONSOLE MESSAGE ROUTINES
;
STARTW:	PRINT	CRLF2
	PRINTL	'START CASSETTE TAPE <<RECORD>> - TYPE CARRIAGE RETURN$'
	PRINT	CRLF2
	CONIN
	CPI	3		;ESCAPE CHARACTER
	JZ	GETOUT
	RET
GETOUT:	POP	PSW		;RESET STACK POINTER
	JMP	MOREIPRINTL	'DISK WRITE ERROR - DISK OR DIRECTORY FULL$'
	PRINT	CRLF
	PRINTL	'FILE DELETED FROM DISK$'
	DELETE	FCB
;
MOREIN:	LDA	INFLAG
	ORA	A
	JNZ	NEWIN
;
MONITOR: PRINT	CRLF
	RESDRV	DRVNO		;RESTORE ORIGINAL DRIVE NUMBER
	JMP	0		;EXIT BACK TO MONITOR
;
;
;   DATA ALLOCATIONS -
;
FCB	=	5CH	;FILE CONTROL BLOCK
FCBNAM	=	FCB+1	;FILE NAME
FCBTYP	=	FCB+9	;FILE TYPE
BELL:	.ASCII	[07H][0DH][0AH][24H]
BELL2:	.ASCII	[07H][0DH][0AH][0AH][24H]
CRLF:	.ASCII	[0DH][0AH]'$'
CRLF2:	.ASCII	[0DH][0AH][0AH][2OCKED TAPE
LENGTH:	.BYTE	0	;LENGTH OF BLOCKED RECORD 256 BYTE BLOCKS
DFLAG1:	.BYTE	0	;DISPLAY OFF FOR SLOW TERMINALS
VERFLG:	.BYTE	0	;FLAG - SET FOR VERIFICATION
AMBIG:	.BYTE	0	;AMBIGUOUS NAME FLAG
FAMBIG:	.BYTE	0	;FIRST AMBIGUOUS FILE FLAG
BLKBLK:	.BYTE	0	;BLOCK COUNT FOR BLOCKED TAPES
MEMEND:	.WORD	0	;END MEMORY FOR FILE STORAGE
BPOINT:	.WORD	0	;POINTER TO FILE MEMORY BUFFER
SLOC2:	.WORD	0	;STORAGE FOR POINTER TO FCB NAME
SLOC1:	.WORD	88H	;POINTER TO NAME IN INPUT BUFFER
IPOINT:	.WORD	80H	;POIN;		-- NEW MACRO LIBRARY --
;
;	SAVE MACRO	SAVE SPECIFIED REGISTERS
;
;	SAVE	R1,R2,R3,R4
;
;		R1-R4 MAY BE B,D,H OR PSW  SAVED IN ORDER SPECIFIED
;		IF REGS ARE OMITTED SAVE B,D AND H
;
SAVE	MACRO	R1,R2,R3,R4
	IF NOT NUL R1&R2&R3&R4
	IRP	R,<<R1>,<R2>,<R3>,<R4>>
	IF	NUL R
	EXITM
	ENDIF
	PUSH	R
	ENDM
	ELSE
	IRPC	REG,BDH
	PUSH	REG
	ENDM
	ENDIF
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	RESTORE MACRO	RESTORE REGISTERS  (INVERSE OF SAVE)
;
;	RESTORE	R1,R2,R3,	;DECR COUNT
	MOV	A,D
	ORA	E
	JNZ	WRHD		;LOOP TILL ZERO
	MVI	D,100		;LOAD COUNT
	MVI	A,0E6H		;SYNC BYTE
	CALL	CASW		;WRITE IT
WRID1:	MVI	A,76H		;HALT CODE
	CALL	CASW		;WRITE IT
	DCR	D
	JNZ	WRID1		;WRITE ANOTHER BYTE
	RET
;
;    SEARCH FOR BLOCK OF 100 76H BYTES ON TAPE
;
RDID:	MVI	D,100		;LOAD COUNT
	MVI	A,10H
	OUT	CASC		;RESET RECEIVER
RDID1:	CALL	CASR		;READ A BYTE
	CPI	76H		;COMPARE WITH 76H
	JNZ	RDID		;START OVER
	DCR	D		;DECR COUNT
	JNZ	RDID1		;READ ANOTHER BYTE
	RET
;
;
;
; N		;BACK FOR MORE INPUT
STOP:	PRINT	BELL2
	PRINTL	'STOP CASSETTE TAPE$'
	PRINT	CRLF
	RET
;
;
;   EXIT AND ERROR ROUTINES
;
VERERR:	PRINT	BELL2
	PRINTL	'VERIFY ERROR$'
	JMP	MOREIN
;
TYPERR:	PRINT	BELL2
	PRINTL	'ERROR - FILE TYPE NOT <COM> - CANNOT BE RUN$'
	JMP	MOREIN
;
RUNERR:	PRINT	CRLF2
	PRINTL 'ERROR - A PROGRAM CAN NOT BE RUN FROM A BLOCKED TAPE$'
	PRINT	CRLF
	PRINTL	'TO EXECUTE PROGRAM FIRST LOAD TO DISK$'
	CALL	STOP		;DISPLAY STOP TAPE MESSAGE
	JMP	MOREIN
;
DERR:	PRINT	BELL2
	4H]
BCOUNT:	.BYTE	65	;COUNT OF BYTES PER LINE
RUNFLG:	.BYTE	0	;CONTROLS FILE TO BE LOADED AND EXECUTED
DISFLG:	.BYTE	0	;CONTROLS DISPLAY DURING TAPE OPERATIONS
DRVNO:	.BYTE	0	;CURRENTLY LOGGED DISK DRIVE NO
NEWDRV:	.BYTE	0	;STORAGE FOR NEW DRIVE NO IF ONE IS SELECTED
CKSUM:	.BYTE	0	;STORAGE FOR TAPE CHECKSUM
INFLAG:	.BYTE	0	;FLAG - IF SET RETURN FOR MORE CONSOLE INPUT
FIRST:	.BYTE	0	;INDICATES FIRST RECORD OF BLOCKED TAPE
BLOCK:	.BYTE	0	;BLOCK COUNT FOR BLOCKED TAPE
TYPE:	.BYTE	0	;TYPE CODE FOR BLTER TO DISK INPUT BUFFER
NBLOCKS:.WORD	0	;NUMBER OF 256 BYTE BLOCKS IN FILE
ENDF:	.WORD	0	;LAST MEMORY LOC USED TO STORE FILE
OLDTYP:	.BLKB	3	;TEMP STORAGE FOR FILE TYPE (FOR RENAME)
AMBNAM:	.BLKB	12	;STORAGE FOR AMBIGUOUS FILE NAME
ENDSTK:	.BLKW	16	;NEW STACK
NEWSTK:	.WORD	0	;START OF NEW STACK
FILBUF:	.WORD	0	;FILE BUFFER - TO TOP OF MEMORY
	.END
R4
;
;		R1-R4 MAY BE B,D,H OR PSW  RESTORED IN ORDER SPECIFIED
;		IF REGS OMITTED RESTORE H,D AND B
;
RESTORE	MACRO	R1,R2,R3,R4
	IF	NOT NUL R1&R2&R3&R4
	IRP	R,<<R1>,<R2>,<R3>,<R4>>
	IF	NUL R
	EXITM
	ENDIF
	POP	R
	ENDM
	ELSE
	IRPC	REG,HDB
	POP	REG
	ENDM
	ENDIF
	ENDM
;
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	CHARIN MACRO	CONSOLE INPUT TO A
;
;	CHARIN	ADDR
;
CHARIN	MACRO	ADDR
	MVI	C,1		;;CONSOLE INPUT
	CALL	5		;;CALL BDOS
	IF	NOT NUL ADDR
	STA	ADDR
	ENDIF
	ENDM
;
;
;	. . . . . . . . . . . . . . ... ... . .. . . . . . . . .
;
;	CHAROUT MACRO	CONSOLE OUTPUT FROM A
;
;	CHAROUT	ADDR
;
CHAROUT	MACRO	ADDR
	IF	NOT NUL ADDR
	LDA	ADDR
	ENDIF
	MVI	C,2		;;CONOUT
	MOV	E,A		;;CHAR TO E
	CALL	5		;;CALL BDOS
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	CHARSTAT MACRO	CHECK CONSOLE STATUS
;
;			RETURN TRUE (FF) IF CHAR READY FALSE (0) IF NOT
;
CHARSTAT MACRO
	LOCAL	EXIT
	MVI	C,11
	CALL	5
	ORA	A
	JZ	EXIT
	MVI	A,0FFH
E . . . . . . . . . . . . . . . . . . .
;
;	PRINT MACRO	PRINT A STRING ON CONSOLE
;
;	PRINT				(CARRIAGE RETURN, LINE FEED)
;	PRINT	'LITERAL'
;	PRINT	<'LITERAL',CR,LF,'SECOND LITERAL'>
;
;	PRINT	ADDR,$			(ASCII OUTPUT UNTIL $)
;	PRINT	ADDR,L,H		(HEX OUTPUT L CHARACTERS)
;	PRINT	ADDR,L,A		(ASCII OUTPUT L CHARACTERS)
;
;		LITERALS MUST BE IN SINGLE QUOTES  'LIT'
;		IF LITERAL CONTAINS CONTROL CODES ENTIRE STRING IN <> BRACKETS
;		MACRO ALSO ASSEMBLES
;			CR = CARRIAGE RETURN
;			LF = LINE FEED

	CALL	5		;;BDOS ENTRY
	ELSE
	IF	NOT NUL ?STRING
	LXI	H,?STRING	;;POINTER TO STRING
	ENDIF
	MVI	C,LEN		;;LENGTH OF STRING
PLOOP:	PUSH	B
	PUSH	H
	IF	TC=H
	MOV	A,M		;;GET A BYTE
	HEXOUT			;;CONV TO HEX & OUTPUT
	ELSE
	MOV	E,M		;;GET A BYTE
	MVI	C,2		;;OUT FROM E
	CALL	5
	ENDIF
	POP	H
	POP	B
	INX	H
	DCR	C		;;DECR LENGTH
	JNZ	PLOOP		;;CONTINUE TILL LEN 0
	ENDIF
	ENDIF
	ENDIF
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	HEXOUT MACRO	CONVERT BINARY NO AND OUTPR
	ENDM
;
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	HEXIN MACRO	CONVERT A NUMBER IN MEMORY FROM HEX TO BINARY
;
;			IF NO ARGUMENT MACRO ASSUMES ADDR OF HEX STRING IN HL
;			ANSWER LEFT IN HL WITH LEAST SIGNIFICANT 8 BITS IN A
;			CARRY SET ON ERROR. CONVERSION STOPS WHEN ZERO IS
;			FOUND IN HEX STRING.
;
HEXIN	MACRO	ADDR
	LOCAL	IN1,IN2,OVERSUB
	JMP	OVERSUB
@HEXIN	LXI	H,0		;;ZERO NUMBER
IN1:	LDAX	D		;;GET A CHAR
	ORA	A		;;CHECK FOR END OF BUFFER
	RZ
	SUI	'0'		;;CHE
	HEXIN	ADDR
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	DECOUT MACRO	CONVERT A POSITIVE INTEGER TO DECIMAL AND OUTPUT 
;			TO THE CONSOLE.
;
;	DECOUT	ADDR
;
;		IF ADDR OMITTED, NUMBER ASSUMED TO BE IN HL, ELSE LOADED TO HL
;		LEADING ZEROS SUPRESSED. MAXIMUM NUMBER 65,767
;
DECOUT	MACRO	ADDR
	LOCAL	ENDDEC,DX
	JMP	ENDDEC
@DECOUT:SAVE			;;PUSH STACK
	LXI	B,-10		;;RADIX FOR CONVERSION
	LXI	D,-1		;;THIS BECOMES NO DIVIDED BY RADIX
DX	DAD	B		;;SUBTRACT 10
	INX	D
	JXIT:	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	INPUT MACRO	INPUT CHARACTER STRING FROM CONSOLE
;
;	INPUT	ADDR,BUFLEN
;
;		ADDR	START OF TEXT BUFFER
;		BUFLEN	LENGTH OF BUFFER  (DEFAULT IS 127)
;
INPUT	MACRO	ADDR,BUFLEN
	MVI	C,10
	IF	NOT NUL ADDR
	LXI	D,ADDR		;;SET BUFFER ADDRESS
	ENDIF
	IF	NOT NUL BUFLEN
	MVI	A,BUFLEN	;;SET BUFFER LENGTH
	STAX	D
	ELSE
	MVI	A,127
	STAX	D		;;SET BUFFER DEFAULT MAXIMUM
	ENDIF
	CALL	5		;;BDOS ENTRY
	ENDM
;
;	. . . . . . . . .
;			BEL = BELL CODE
;
;		MACRO ASSUMES ADDR ALREADY LOADED TO HL IF ARGUMENT OMITTED
;
PRINT	MACRO	?STRING,LEN,TC
	LOCAL	@OVER,@MESS,PLOOP,PASTCR,@CRLF
CR	SET	0DH
LF	SET	0AH
BEL	SET	07H
	IF	NUL ?STRING&LEN&TC
	JMP	PASTCR
@CRLF:	DB	CR
	DB	LF
	DB	'$'
PASTCR:	LXI	D,@CRLF
	MVI	C,9
	CALL	5
	ELSE
	IF	NUL LEN&TC
	JMP	@OVER
@MESS:	DB	?STRING
	DB	'$'
@OVER:	LXI	D,@MESS
	MVI	C,9
	CALL	5		;;BDOS ENTRY
	ELSE
	IF	NUL TC
	IF	NOT NUL ?STRING
	LXI	D,?STRING	;;POINTER TO STRING
	ENDIF
	MVI	C,9UT TO CONSOLE
;
;	HEXOUT	ADDR
;
;		NUMBER ASSUMED IN A IF NO ARGUMENT
;
HEXOUT	MACRO	ADDR
	LOCAL	OUTCHR,HEXEND
	JMP	HEXEND
HEXPRN:	SAVE	PSW
	RRC
	RRC
	RRC
	RRC			;;SHIFT RIGHT 4
	CALL	OUTCHR
	RESTORE	PSW
OUTCHR: ANI	0FH		;;MASK 4 BITS
	ADI	90H		;;ADD OFFSET
	DAA			;;DEC ADJUST
	ACI	40H		;;ADD OFFSET
	DAA			;;DEC ADJUST
	MOV	E,A		;;TO E FOR OUTPUT
	MVI	C,2		;;CONOUT
	JMP	5		;;CALL BDOS
HEXEND:
HEXOUT	MACRO	?ADDR
	IF	NOT NUL ?ADDR
	LDA	?ADDR
	ENDIF
	CALL	HEXPRN
	ENDM
	HEXOUT	ADDCK < 0 AND CONVERT TO HEX
	RC
	ADI	'0'-'G'		;;CHECK > F
	RC
	ADI	6
	JP	IN2		;;NO BETWEEN A AND F
	ADI	7
	RC
IN2:	ADI	10
	ORA	A		;;CLEAR CARRY
	MOV	C,A		;;HEX DIGIT TO C
	MVI	B,0		;;ZERO TO B
	DAD	H
	DAD	H
	DAD	H
	DAD	H		;;SHIFT LEFT 4
	DAD	B		;;ADD IN NEW DIGIT
	INX	D		;;INCR BUFFER POINTER
	JMP	IN1		;;RETURN FOR MORE INPUT
OVERSUB:
HEXIN	MACRO	?ADDR
	IF NOT NUL ?ADDR
	LXI	D,?ADDR		;;LOAD BUFFER ADDR
	ELSE
	XCHG
	ENDIF
	CALL	@HEXIN
	MOV	A,L		;;LEAST SIGNIFICANT 8 BITS TO A
	ENDM
C	DX
	LXI	B,10
	DAD	B		;;ADD RADIX BACK IN ONCE
	XCHG
	MOV	A,H
	ORA	L		;;TEST FOR ZERO
	CNZ	@DECOUT		;;RECURSIVE CALL
	MOV	A,E
	ADI	'0'		;;CONVERT FROM BCD TO HEX
	MOV	E,A		;;TO E FOR OUTPUT
	CHAROUT			;;CONSOLE OUTPUT
	RESTORE			;;POP STACK
	RET
ENDDEC:
DECOUT	MACRO	?ADDR
	IF	NOT NUL ?ADDR
	LHLD	?ADDR
	ENDIF
	CALL	@DECOUT		;;CALL THE SUBROUTINE
	ENDM
	DECOUT	ADDR
	ENDM
;
;
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	DECIN MACRO	CONVERT A NUMBER IN MEMORY FROM ASCII TO BINARY
;
;	DECIN	ADDR
;
;		ADDR POINTS TO MEMORY LOCATION OF START OF NO, IF
;		ARG OMITTED POINTER ASSUMED LOADED TO HL
;		MACRO RETURNS WITH CARRY SET IF ALPHABETIC CHAR FOUND
;		CONVERSION STOPS WHEN CHAR LESS THAN ZERO IS FOUND.
;		BINARY NUMBER IS LEFT IN HL, MAXIMUM 65,767
;		LEAST SIGNIFICANT 8 BITS OF NUMBER IN A.
;
DECIN	MACRO	ADDR
	LOCAL	DLOOP,OVERSUB
	JMP	OVERSUB
@DECIN:	LXI	D,0		;;ZERO DE
	XCHG			;;ADDR POINTER TO DE, ZERO TO HL
DLOOP:	LDAX	D		;;GET A ASCII DIGIT
	SUI	'DR
	ENDIF
	CALL	@DECIN		;;CALL THE SUBROUTINE
	MOV	A,L		;;LEAST SIGNIFICANT HALF OF NO TO A
	ENDM
	DECIN	ADDR
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	MOVE MACRO	MOVE A BLOCK FROM SOURCE TO DEST
;
;	MOVE	SOURCE,DEST,COUNT
;
;		SOURCE TO HL	MACRO ASSUMES REGISTERS ALREADY
;		DEST TO DE	LOADED IF ARG OMITTED
;		COUNT TO BC
;
MOVE	MACRO	SOURCE,DEST,COUNT
	LOCAL	OVERSUB
	JMP	OVERSUB
@MOVE:	MOV	A,B
	ORA	C
	RZ			;;EXIT COUNT ZERO
	MOV	A,M		;;GET A BYTE
	STAX	DFILL	MACRO	START,STOP,CONST
	LOCAL	@FILL,BLKLEN
BLKLEN	SET	STOP-START+1
	LXI	H,START		;;LOAD START ADDR
	IF	NOT NUL STOP
	IF	BLKLEN > 255
	LXI	B,BLKLEN	;;LOAD BLOCK LENGTH
	ELSE
	MVI	C,BLKLEN
	ENDIF
	IF	NOT NUL CONST
	MVI	E,CONST		;;LOAD CONST IF NOT NULL
	ELSE
	MVI	E,0
	ENDIF
@FILL:	MOV	M,E		;;STORE A BYTE
	INX	H		;;INCR MEMORY POINTER
	IF	BLKLEN > 255
	DCX	B		;;DECR COUNT
	MOV	A,C		;;TEST LIMIT
	ORA	B
	JNZ	@FILL		;;CONTINUE
	ELSE
	DCR	C
	JNZ	@FILL
	ENDIF
	ELSE
	IF	NUL CONST
	MVND THE LENGTH
;		IS OMITTED. IF THE LEN ARG IS PRESENT THE SECOND STRING
;		ARG IS ASSUMED TO BE A MEMORY ADDR. IF ALL ARGUMENTS OMITTED
;		REGISTERS ASSUMED ALREADY LOADED.
;
MATCH	MACRO	STR1,STR2,LEN
	LOCAL	OVERSUB,M1
	JMP	OVERSUB
@MATCH:	INR	C		;;PRE INCREMENT COUNT (IT MIGHT BE ZERO)
M1:	DCR	C		;;DECR LENGTH COUNT
	RZ			;;RETURN IF MATCH FOUND
	LDAX	D		;;GET A BYTE FROM ONE STRING
	SUB	M		;;COMPARE WITH OTHER
	RNZ			;;RETURN
	INX	H
	INX	D		;;INCR STRING POINTERS
	JMP	M1		;;TRY SOME MORE
LL MATCH SUBROUTINE
	ENDIF
	ENDIF
	ENDM
	MATCH	STR1,STR2,LEN
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	INSTR MACRO	SEARCH STRING FOR SUBSTRING AND SET CARRY IF FOUND
;
;	INSTR	STRING,LENGTH,SUBSTR
;
;		HL	POINTS TO STRING
;		DE	POINTS TO SUBSTRING
;		B	CONTAINS STRING LENGTH
;		C	CONTAINS SUBSTRING LENGTH
;
;		MACRO RETURNS POINTER TO END OF SUBSTRING IN HL
;
INSTR	MACRO	STRING,LENGTH,SUBSTR
	LOCAL	OVERSUB,S1,SSX
	JMP	OVERSUB
@INSTR:	MOV	A,B		;;STRING LENGT0'		;;CONVERT TO BCD AND TEST
	ANA	A		;;RESET CARRY
	RM			;;TERMINATE CONVERSION IF < ZERO
	CPI	10		;;CHECK LEGITIMATE DIGIT (0-9)
	CMC			;;COMPLEMENT CARRY
	RC			;;RET WITH CARRY SET IF ERROR
	INX	D		;;INCR ADDR POINTER
	DAD	H		;;SHIFT LEFT 1
	PUSH	H		;;SAVE RESULT
	DAD	H
	DAD	H		;;SHIFT LEFT 2
	POP	B		;;NO * 2 TO B
	DAD	B		;;HL NOW CONTAINS 10*NO
	MOV	C,A		;;ADD PRODUCT TO DIGIT
	MVI	B,0
	DAD	B
	JMP	DLOOP		;;BACK FOR ANOTHER DIGIT
OVERSUB:
DECIN	MACRO	?ADDR
	IF	NOT NUL	?ADDR
	LXI	H,?AD		;;STORE IT
	INX	H
	INX	D
	DCX	B
	JMP	@MOVE		;;BACK TO MOVE LOOP
OVERSUB:
MOVE	MACRO	SRC,?D,?C
	IF	NOT NUL SRC
	LXI	H,SRC
	ENDIF
	IF	NOT NUL ?D
	LXI	D,?D
	ENDIF
	IF	NOT NUL ?C
	LXI	B,?C
	ENDIF
	CALL	@MOVE		;;CALL THE MOVE SUBROUTINE
	ENDM
	MOVE	SOURCE,DEST,COUNT
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	FILL MACRO - FILL A BLOCK OF MEMORY WITH A CONSTANT
;
;	FILL	START,STOP,CONSTANT
;
;		CONSTANT OMITTED, FILL WITH 0
;		END OMITTED, FILL ONE BYTE
;
I	M,0		;;STORE A ZERO
	ELSE
	MVI	M,CONST		;;STORE SINGLE BYTE
	ENDIF
	ENDIF
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;
;	MATCH MACRO	COMPARE 2 STRINGS OF SAME LENGTH SET CARRY IF EQUAL
;
;	MATCH	STR1,'LITERAL STRING'
;	MATCH	STR1,STR2,LENGTH
;	MATCH
;
;		DE POINTS TO STR1	MACRO WILL LOAD REG IF ARG
;		HL POINTS TO STR2	PRESENT
;		C CONTAINS LENGTH
;
;		SUBTRACT STR2 FROM STR1 AND SET FLAGS, ZERO INDICATES MATCH.
;		NORMALLY THE SECOND ARG IS A LITERAL STRING A
OVERSUB:
MATCH	MACRO	?STR1,?STR2,?LEN
	LOCAL	LITSTR,ENDLIT
	IF	NUL ?STR1&?STR2&?LEN
	CALL	@MATCH
	ELSE
	IF	NOT NUL ?STR1
	LXI	D,?STR1		;;LOAD STRING1 POINTER
	ENDIF
	IF	NUL ?LEN	;;TEST FOR LITERAL
	MVI	C,ENDLIT-LITSTR	;;LENGTH OF LITERAL STRING
	LXI	H,LITSTR	;;POINTER TO LITERAL
	CALL	@MATCH
	JMP	ENDLIT
LITSTR:	DB	?STR2		;;LITERAL STRING
ENDLIT:				;;END OF STRING
	ELSE
	IF	NOT NUL ?STR2
	LXI	H,?STR2		;;LOAD POINTER TO STRING2
	ENDIF
	MVI	C,?LEN		;;LOAD STRING LENGTH
	CALL	@MATCH		;;CAH
	SUB	C		;;SUBTRACT SUBSTR LENGTH
	CMC			;;COMP CARRY
	RNC			;;ERROR RETURN SUBSTR > STRING
	MOV	B,A		;;NEW STRING LIMIT TO B
S1:	SAVE
	MATCH
	RESTORE
	JZ	SSX		;;MATCH IF ZERO ON RET
	ANA	A		;;RESET CARRY
	DCR	B		;;BYTES LEFT
	RM			;;FINISHED IF MINUS, NO MATCH
	INX	H		;;INCR STRING POINTER
	JMP	S1		;;TRY AGAIN
SSX:	MVI	B,0		;;SET D TO 0
	DAD	B
	STC			;;SET CARRY
	RET
OVERSUB:
INSTR	MACRO	?STR,?LEN,?SUBSTR
	LOCAL	LITSTR,ENDLIT
	IF	NOT NUL ?STR
	LXI	H,?STR
	ENDIF
	MVI	B,?LEN
	MVI	C,ENDLIT-LITSTR
	LXI	D,LITSTR
	CALL	@INSTR
	JMP	ENDLIT
LITSTR:	DB	?SUBSTR
ENDLIT:
	ENDM
	INSTR	STRING,LENGTH,SUBSTR
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	SCAN MACRO	SCAN A STRING UNTIL A CHAR IS FOUND, SKIP BLANKS
;			AND CONTROL CHARACTERS
;
;			CARRY SET IF NUMERIC, CARRY OFF IF ALPHABETIC
;
;
SCAN	MACRO	ADDR
	LOCAL	OVERSUB
	JMP	OVERSUB
@SCAN:	MOV	A,M		;;GET A BYTE
	CPI	21H		;;SPACE OR LESS?
	RP
	INX	H		;;INCR POINTER
	JMP	@SCAN		;;KEEP SEARCHING
OVEITE		FCB
;		22	MAKE		FCB
;		23	RENAME		FCB
;		24	?LOGIN
;		25	?DRIVE
;		26	SETDMA		BUFFER
;		27	?ALLOC
;		SEE CP/M INTERFACE GUIDE FOR DETAILED INFORMATION ON THE
;		DISK ACCESS PRIMITIVES
;
;	DISKIO	READ,FCB	(TYPICAL MACRO CALL)
;
DISKIO	MACRO	FUNCTION,PARAMETER
LIFTHEAD	SET	12
INITIAL		SET	13
LOGIN		SET	14
OPEN		SET	15
CLOSE		SET	16
SEARCH		SET	17
SERNXT		SET	18
DELETE		SET	19
READ		SET	20
WRITE		SET	21
MAKE		SET	22
RENAME		SET	23
?LOGIN		SET	24
?DRIVE		SET	25
SETDMA		SET	26
?AH
DSETSEC	SET	21H		;;SECTOR NO IN C
DSETDMA	SET	24H		;;DMA ADDR IN BC
DREAD	SET	27H
DWRITE	SET	2AH
;
?F	SET	FUNCT
	IF	NOT NUL PARAM
	MVI	C,PARAM
	ENDIF
	LHLD	1		;;ADDR OF BIOS
	MVI	L,?F		;;JUMP OFFSET
	SHLD	@CALL+1		;;MODIFY CALL ADDR
@CALL:	CALL	0
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	DLOAD MACRO	DOUBLE PRECISION INDEXED LOAD HL
;
;		LOAD (ADDR + INDX) TO HL
;
DLOAD	MACRO	ADDR,INDX
	IF	NUL INDX
	LHLD	ADDR
	ELSE
	LHLD	INDX
	LXI	D,ADDR
	DAD	D
	MOV	 . .
;
;	DSTORE MACRO	DOUBLE PRECISION INDEXED STORE HL
;
;		STORE (HL) IN (ADDR + INDX)
;
DSTORE	MACRO	ADDR,INDX
	IF	NUL INDX
	SHLD	ADDR
	ELSE
	SAVE	H
	LHLD	INDX
	XCHG
	LXI	H,ADDR
	DAD	D
	RESTORE	D
	MOV	M,E
	INX	H
	MOV	M,D
	ENDIF
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	INDEX MACRO	INDEX AN ADDRESS POINTER BY A CONSTANT
;
;	INDEX	POINTER,INCR
;
INDEX	MACRO	POINTER,INCR
	LHLD	POINTER
	LXI	D,INCR
	DAD	D		;;DOUBLE ADD
	SHLD	POINTER
	ENDM
;
;	. . 		;;RESTORE NAME POINTER
	MVI	C,8		;;MAXIMUM SIZE OF NAME
F2:	LDAX	D		;;GET BYTE FROM ID FIELD
	CPI	' '		;;LEADING SPACES?
	JNZ	F3
	INX	D		;;SKIP LEADING SPACES
	JMP	F2
F3:	LDAX	D		;;GET ID BYTE
	CPI	0		;;ZERO END OF FIELD
	RZ
	CPI	' '		;;SPACE END OF FIELD
	RZ
	CPI	'.'		;;PERIOD TYPE SEPARATOR
	JZ	F4		;;DO TYPE
	MOV	M,A		;;STORE NAME BYTE
	INX	H
	INX	D		;;INCR POINTERS
	DCR	C		;;DECR MAXIMUM COUNT
	JP	F3		;;LOOP BACK
	STC			;;SET CARRY NAME TOO LARGE
	RET
F4:	INX	D		;;SKIP THE PERIOD
RSUB:
SCAN	MACRO	?ADDR
	IF	NOT NUL ?ADDR
	LXI	H,?ADDR
	ENDIF
	CALL	@SCAN		;;CALL SUBROUTINE
	CPI	3AH		;;NUMBER OR ALPHA
	ENDM
	SCAN	ADDR
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	DISKIO MACRO	EXECUTE BDOS DISK ACCESS PRIMITIVES
;
;	DISKIO	FUNCTION,PARAMETER
;
;		NO	FUNCTION	ENTRY PARAM
;
;		12	LIFTHEAD
;		13	INITIAL
;		14	LOGIN		DISK NO 0 - 1
;		15	OPEN		FCB
;		16	CLOSE		FCB
;		17	SEARCH		FCB
;		18	SERNXT		FCB
;		19	DELETE		FCB
;		20	READ		FCB
;		21	WRLLOC		SET	27
;
?C	SET	FUNCTION
	IF	NOT NUL PARAMETER
	LXI	D,PARAMETER
	ENDIF
	MVI	C,?C
	CALL	5		;;BDOS ENTRY
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	CALLBIOS MACRO	CALL BIOS ROUTINES DIRECTLY
;
;	CALLBIOS	FUNCTION,PARAM
;
CALLBIOS	MACRO	FUNCT,PARAM
	LOCAL	@CALL
;
DCOLD	SET	00H
DWBOOT	SET	03H
DSTAT	SET	06H
DCONIN	SET	09H
DCONOUT	SET	0CH		;;CHAR IN C
DLIST	SET	0FH		;;CHAR IN C
DPUNCH	SET	12H
DREADER	SET	15H
DHOME	SET	18H
DSELDSK	SET	1BH
DSETTRK	SET	1EE,M
	INX	H
	MOV	D,M
	XCHG
	ENDIF
	ENDM
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	CPHL MACRO	SUBTRACT DE FROM HL AND SET FLAGS
;
CPHL	MACRO
	LOCAL	@END
	MOV	A,H
	CMP	D		;;COMPARE HIGH BYTES
	JNZ	@END
	MOV	A,L
	CMP	E		;;COMPARE LOW BYTES
@END:	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	DJZ MACRO	DOUBLE PRECISION TEST HL AND JUMP ON ZERO
;
DJZ	MACRO	ADDR
	MOV	A,H
	ORA	L
	JZ	ADDR
	ENDM
;	. . . . . . . . . . . . . . . . . . . . . . . . . .. . . . . . . . . . . . . . . . . . . . . . . . .
;
;	FILFCB	MACRO	FILL IN THE ID FIELDS OF FCB
;
;	FILFCB	FCB,IDSTRING
;
;		IDSTRING CONTAINS FILE NAME AND TYPE  (FILNAM.TYP)
;		CARRY SET IF ERROR  (NAME TOO LONG)
;
FILFCB	MACRO	FCB,IDSTRING
	LOCAL	OVERSUB,F1,F2,F3,F4,F5,F6
	JMP	OVERSUB
@FLFCB: MVI	M,0		;;CLEAR FIRST BYTE OF FCB
	INX	H
	PUSH	H		;;SAVE POINTER TO NAME
	MVI	C,11		;;SIZE OF ID FIELD
	MVI	A,' '		;;SPACE TO A
F1:	MOV	M,A		;;FILL NAME WITH SPACES
	INX	H
	DCR	C
	JNZ	F1
	POP	H	MOV	A,C
	ORA	A
	JZ	F6		;;TEST C FOR ZERO
F5:	INX	H
	DCR	C
	JNZ	F5		;;INDEX TO TYPE FIELD
F6:	MVI	C,3		;;SIZE OF TYPE FIELD
F7:	LDAX	D		;;GET ID BYTE
	CPI	0		;;ZERO?
	RZ			;;FINISHED
	CPI	' '		;;SPACE?
	RZ
	MOV	M,A		;;STORE TYPE BYTE
	INX	H
	INX	D		;INCR POINTERS
	DCR	C		;;DECR MAX COUNT
	JNZ	F7		;;LOOP BACK
	RET
OVERSUB:
FILFCB	MACRO	?FCB,?ID
	IF	NOT NUL	?ID
	LXI	D,?ID
	ENDIF
	IF	NOT NUL ?FCB
	LXI	H,?FCB
	ENDIF
	CALL	@FLFCB
	XCHG
	ENDM
	FILFCB	FCB,IDSTRING
	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	SETTRK MACRO	SET AND TEST TRACK NUMBER
;
;			CARRY SET IF > 76
;
SETTRK	MACRO	TRKNO
	LOCAL	ENDTRK
	IF	NOT NUL TRKNO
	LDA	TRKNO
	ENDIF
	CPI	77
	CMC
	JC	ENDTRK
	MOV	C,A		;;TRACK NO TO C
	CALLBIOS DSETTRK
ENDTRK:	ENDM
;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	SETSEC MACRO	SET AND TEST SECTOR NUMBER
;
;		RETURN WITH CARRY SET < 1 OR > 26
;
SETSEC	MACRO	SECNO
	LOCAL	ENDSEC
	IF	NOT NUL SECNO
	LDA	SECNO
	ENDIF
	O1*  P|}" 22: 	 	@ YTAPELIB UTILITY VERS 1.1$	 	l ËCOPYRIGHT 1977 BY S. J. SINGER$	 	 à*$>2!  > w#z«
 > : <2 22222>A2>2!\ ! > w#z*x7BLOCKx?G
"##70#
  Y7@! 0"*xP	YNODISPLAYa>2! ouÉTAPE:=
#uÈ7! uàDISK:=! uôA:=ڹ! uB:=! uRUN:=ګ	 	 ERROR - NO S\  
7** w#x* "* "*|@}	 	V pBLOCKED TAPE REQUESTED OR$	 	 ÝFILE TOO LARGE FOR MEMORY$	 	 WRITING BLOCKED OUTPUT TAPE$:>2ͳ	 ! w#xí$	 	 !DISK READ ERROR$Ý*##|}\** "*|J}C>w#|Y}N:kͳ>2l!6	:ʧ!\  w#x
ڧ	 5Ý\  ?¼7!h  > w#z!>w#z\  ?7!"! ">2>2	>._ 	 	 	 3	ERROR IN FILE NAME$Ý!4>H	<N	6͞͞><x>x2>xyxxx>2 ~x#
q	o	2:xɯ2͋2>n͛	͛2	͛!  oG)+">2! ͛w#
	zʀ
 	":G2͛
:		 	 	
 &
CHECKSUM ERROR$	 	9
 k
TO RESTART - REWIND TAPE AND TYPE CARRIAGE RETURN$	  ʝÉ		 !] 
?«
~ 

ï
´
#Ó
ù
7
É	:	!]  w#x
2| !͛w#
 
"2:l  \  ß
!">2\  ?+
7ڀ\  ;
7i
* 
X
T
#F
Y
7B* ".
	 	
 ×
VERIFIED SUCCESSFULLY$	 :ʝ!\  w#x¯
2h 2| É	!e 
u
COMe
! ( w#x
À  *| } !  "  *x#RENAME#~ $"*!\ 
	\  ?K7ڀ!":	a>2\  n7y** w#x* ":=2a*+!
B#|º}¬!] ?>*p#
!e p#
!] x#
7> 2h \ RA	A		;CHECK ZERO
	STC
	JZ	ENDSEC
	CPI	27		;CHECK > 26
	CMC
	JC	ENDSEC
	MOV	C,A		;MOVE TO C
	CALLBIOS DSETSEC
ENDSEC:	ENDM
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;	HALF MACRO	DIVIDES A 16 BIT NUMBER BY 2
;
HALF	MACRO	I
	LOCAL	OVER
	JMP	OVER
@HALF:	XRA	A		;;CLEAR CARRY
	MOV	A,H
	RAR			;;SHIFT UPPER HALF
	MOV	H,A
	MOV	A,L
	RAR			;;SHIFT LOWER HALF
	MOV	L,A
	RET
OVER:
HALF	MACRO	?I
	IF	NOT NUL ?I
	LHLD	?I
	ENDIF
	CALL	@HALF
	ENDM
	HALF	I
	ENDM
UCH DESTINATION$Ý! !u%SYNC,! 6u8A:B2Z! PuRB:r>2 ! x w#xc! 55*!\ 6 #> w#
 Ð  .ʴw#
yʿ#
º  w#
7
	! > w#z: Ɓ!  o"|}R\ ! w#x>2:_ \ ~#
:!h  > w#zH] ! w#x[:_ \  ?}7	 :½	 úNO FILE BY THAT NAME ON DRIVE A$Ý	 NO FILE BY THAT NAME ON DRIVE B$Ý!"! "!  ">2\  7C** w#x :p<2* ":<G!͞6	! w#xcw:!͞6	!>w#z!"l 2{! ">22>2! "*!\ 
	>2\ ! w#x ! w#x:_ !  w#x	 	8 cSTART CASSETTE TAPE - TYPE CARRIAGE RETURN$	  ʝÉ	;n o!2;no!2  ʝ:	:	:=2	 >@2	 G͛
:}:<*x'-VERIFY8>2<
*xKNRUNڧH\  \  ?\  ?v7:=2:N!"** w#x\  ʫ7.* ":=2:22>n͛͛2͛!  oG)"! >2
::n
!]  w#x:
*x5;VERIFY
*xNQRUN
:

H\  \  ?\  ?7ڀ!"** w#x\  ʭ7.*+|"* "Ì\  ?7\ !l  w#x!u  w#x ?ʀ\  ?7ƀ!  oͳ>2  >xz7Ýe ! w#xQ!e  >$w#za><xzod>x>vxd>n͛v ><xz¤	 	 START CASSETTE TAPE <<RECORD>> - TYPE CARRIAGE RETURN$	  Ý	 	& 9STOP CASSETTE TAPE$	 	 	U bVERIFY ERROR$Ý	 	x äERROR - FILE TYPE NOT <COM> - CANNOT BE RUN$Ý	 	 ERROR - A PROGRAM CAN NOT BE RUN FROM A BLOCKED TAPE$	 	 (TO EXECUTE PROGRAM FIRST LOAD TO DISK$Ý	 	A kDISK WRITE ERROR - DISK OR DIRECTORY FULL$	 	~ ÕFILE DELETED FROM DISK$\  :	 :_   
$

$
$

$A                           KED TAPE$	 	 (TO EXECUTE PROGRAM                                                                                                            			--  TAPELIB --

				BY  SAM J. SINGER
				    (714) 780-8853

I.  INTRODUCTION

	TAPELIB IS A GENERAL CASSETTE TAPE LIBRARY MANAGER FOR
CP/M. IT INCORPORATES MOST OF THE FEATURES OF THE CP/M PIP UTILITY.
ANY CP/M FILE OR GROUP OF FILES MAY BE COPIED FROM TAPE TO DISK
OR FROM DISK TO TAPE.
	IN ADDITION TO THE USUAL PIP COPY OPERATIONS, TAPELIB
PERMITS VERIFICATION OF TAPE FILES AGAINST DISK FILES AND DIRECT
EXECUTION OF BINARY PROGRAMS FROM TAPE.  TAPE FILES ARE NAMED AND
SPACE IS PROVIDED IR SYSTEM
RUNNING THE CP/M OPERATING SYSTEM, AT LEAST ONE FLOPPY DISK DRIVE,
A CASSETTE RECORDER AND TARBELL CASSETTE INTERFACE AND A CONSOLE
DEVICE.  THE DISPLAY DURING COPY OPERATIONS REQUIRES THE TERMINAL
TO OPERATE AT A MINIMUM OF 4800 BAUD IF THIS FEATURE IS TO BE USED.

III.  PROGRAM OPERATION

	TAPELIB OPERATES AS A TRANSIENT FILE UNDER CP/M, AND 
REQUIRES SLIGHTLY MORE THAN 4K OF MEMORY FOR CODE. THE REMAINDER
OF THE AVAILABLE MEMORY WILL BE USED FOR FILE BUFFERS.
	DURING DISK TO TAPE COPITAPES REQUIRE ABOUT 25 PER CENT MORE TIME TO WRITE.
	EACH TAPE FILE IS HEADED BY A 128 BYTE RECORD CONTAINING
THE FILE NAME. MOST OF THE REMAINDER OF THE 128 BYTES IS AVAILABLE
FOR COMMENTS. THE COMMENTS ARE DELETED DURING TAPE TO DISK COPIES.
	FILES ARE DISPLAYED ON THE TERMINAL DURING ALL COPY 
OPERATIONS UNLESS THE NODISPLAY OPTION IS USED. CHARACTERS ARE
DISPLAYED IN ASCII IN 64 CHARACTER LINES WITH NONDISPLAYABLE
CHARACTERS CONVERTED TO PERIODS.
	DURING TAPE TO DISK COPY OPERATIONS A SEARCH IS ETURN. IF THE FIRST METHOD IS
USED THE PROGRAM RESPONDS WITH A TITLE AND AN * PROMPT. THE COMMAND STRING
MAY THEN BE ENTERED. THE SECOND FORM EXECUTES THE COMMAND STRING
IMMEDIATELY.
	IF THE FIRST FORM OF THE CALL IS USED THE PROGRAM WILL RETURN TO
THE INPUT SECTION AFTER COMPLETION OF THE COMMAND. THE PROMPT WILL BE
DISPLAYED AND ANOTHER COMMAND EXECUTED WITHOUT RELOADING THE PROGRAM.
THE OTHER FORM WILL RETURN TO CP/M AFTER COMPLETION OF THE COMMAND.
ANY COMMAND MAY BE TERMINATED BY TYPING CONTROLN THE TAPE COPY FOR EXTENSIVE COMMENTS.
	FILES MAY BE DISPLAYED ON THE CONSOLE DURING COPY OPERATIONS
FOR VISUAL VERIFICATION .  THE PROGRAM CONTAINS EXTENSIVE ERROR 
CHECKS, AND CONSOLE MESSAGES ARE UNABBREVIATED AND QUITE SPECIFIC.
EVERY EFFORT HAS BEEN MADE TO MAKE THE PROGRAM GENERAL AND EASY TO
USE. THE PROGRAM HAS BEEN OPTIMIZED TO PROVIDE THE FASTEST POSSIBLE
DATA TRANSFER RATES YET STILL MAINTAIN GOOD RELIABILITY.

II.  HARDWARE REQUIREMENTS

	TAPELIB REQUIRES AN 8080 OR Z-80 BASED COMPUTEES THE PROGRAM WILL FIRST ATTEMPT
TO READ THE ENTIRE FILE INTO MEMORY AND WRITE IT ON TAPE AS A
SINGLE RECORD. IF THERE IS INSUFFICIENT ROOM FOR THE ENTIRE FILE,
OR IF THE FILE CONTAINS MORE THAN ABOUT 14000 BYTES THE PROGRAM
WILL WRITE THE FILE ON TAPE IN 1K BLOCKS. A BLOCKED TAPE WILL ALSO
BE PRODUCED IF THE BLOCK OPTION IS USED. THIS OPTION IS USEFUL IF
TAPES ARE TO BE TRANSFERED FROM ONE SYSTEM TO ANOTHER OF A DIFFERENT
SIZE. A MESSAGE WILL BE DISPLAYED BEFORE A BLOCKED TAPE IS WRITTEN.
BLOCKED MADE FOR
THE FILE NAME OR GROUP OF NAMES AND ONLY THE REQUESTED FILES
ARE COPIED. HOWEVER, THE HEADER RECORD CONTAINING THE FILE NAME
WILL BE DISPLAYED FOR EACH FILE ON THE TAPE. THIS PERMITS SCANNING
THE TAPE TO DETERMINE ITS CONTENTS, SINCE TAPES HAVE NO DIRECTORIES.
WHEN REQUESTED FILES ARE FOUND, THE ENTIRE CONTENTS WILL BE DISPLAYED.

IV.  TAPELIB COMMANDS

	TAPELIB MAY BE RUN BY ONE OF TWO METHODS. TYPE:

		TAPELIB		
		TAPELIB <COMMAND STRING>

ALL COMMANDS ARE TERMINATED BY A CARRIAGE R C. THE FIRST CONTROL C
RETURNS TO THE INPUT SECTION OF THE PROGRAM. A SECOND CONTROL C RETURNS
BACK TO CP/M.
	THE COMMAND STRING HAS THE FOLLOWING FORM:

	    DESTINATION:=SOURCE  <OPTIONS> <COMMENT>

	THE SOURCE AND DESTINATION MAY BE EITHER A FILE NAME AND TYPE, A
DEVICE NAME OR SPECIAL FUNCTION. DEVICE NAMES AND FUNCTIONS MUST BE FOLLOWED
BY A COLON. THE FOLLOWING TABLE GIVES ACCEPTABLE NAMES AND THEIR 
INTERPRETATION.

		DEVICE/FUNCTION TABLE

	TAPE:		THE CASSETTE TAPE
	DISK:		THE CURRENTLY LOGGED DISK
	A:		DISK A
	B:		DISK B
	RUN:		LOAD TAPE TO MEMORY AND EXECUTE
	SYNC:		WRITE SYNC STREAM ON TAPE

	ANY CP/M LEGAL FILE NAME INCLUDING AMBIGUOUS FILE NAMES MAY BE
USED WITH TAPELIB. THE FOLLOWING ARE EXAMPLES OF ACCEPTABLE NAMES

		XXXX.YYY	FILENAME.TYP
		*.COM		TAPELIB.???
		*.*		A:MYPROG.COM
		B:NEWNAME.ASM	B:????????.ASM

NOTE THAT THE DISK NAME MAY BE SPECIFIED AS PART OF A FILE NAME.

	THE OPTIONS AVAILABLE AND THEIR FUNCTIONS ARE LISTED IN THE
OPTION TABLE WHICH FOLLOWS MEANINGFUL, THEY WILL BE IGNORED.

V.  EXAMPLES OF COMMANDS

			DISK TO TAPE

	TAPE:=FILENAME.TYP	'OPTIONAL COMMENTS'
	TAPE:=B:*.COM      RECORDED DEC 26 1977
	TAPE:=A:MYPROG.ASM    NODISPLAY

			TAPE TO DISK

	DISK:=*.COM
	A:=GAME.BAS   RENAME NEWGAME.BAS
	B:=TESTPROG.ASM     VERIFY

			OTHER COMMANDS

	TAPE:=SYNC:		(WRITE 6 MIN OF SYNC CODE)
	RUN:=ANYPROG.COM	(LOAD FROM TAPE AND EXECUTE)


	THE FORMAT OF COMMAND STRINGS IS FREE EXCEPT FOR THE SOURCE
AND DESTINATION. THE EQUAL SIGN THE WORD VERIFY ANYWHERE FOLLOWING THE SOURCE. THE COPY
OPERATION WILL NOT ACTUALLY TAKE PLACE. INSTEAD THE FILE WILL BE READ
FROM TAPE AND COMPARED BYTE BY BYTE WITH THE FILE OF THE SAME NAME ON
THE DISK SPECIFIED. IF THE FILES ARE NOT THE SAME THE PROGRAM DISPLAYS

	VERIFY ERROR

IF THE FILES ARE THE SAME THE PROGRAM WILL DISPLAY:

	VERIFIED SUCCESSFULLY

	TO RUN A PROGRAM FROM TAPE TYPE RUN: AS THE DESTINATION. THE
PROGRAM CHECKS THE FILE TYPE BEFORE EXECUTION BEGINS AND WILL DISPLAY
AN ERROSAGE WILL BE:

	START CASSETTE TAPE - TYPE CARRIAGE RETURN

THE TAPE SHOULD BE STARTED IN THE PROPER MODE BEFOR TYPING THE CARRIAGE
RETURN.
	TAPELIB IS EXTENSIVELY TRAPPED FOR ERRORS. IF AN ERROR OCCURS
THE PROGRAM WILL DISPLAY AN ERROR MESSAGE AND PAUSE TO ALLOW THE ERROR
TO BE CORRECTED IF POSSIBLE. THE FOLLOWING TABLE CONTAINS ERROR MESSAGES,
THEIR PROBABLE CAUSE AND POSSIBLE CORRECTION.

			ERROR TABLE

1.  ERROR IN FILE NAME		INCORRECT FILE NAME - REENTER NAME

2.  NO SUCH DESTINATION		IOT <COM>	ONLY COM TYPE FILES CAN BE EXECUTED - LOAD
    - CANNOT BE RUN		FILE TO DISK AND RENAME

7.  DISK READ ERROR 		CP/M SYSTEM ERROR IN DISK READ

8.  DISK WRITE ERROR - DISK	DISK FILLED - CHANGE DISKS
    OR DIRECTORY FULL

VII.  TAPE FORMAT

	THE FORMAT FOR EACH RECORD ON THE TAPE IS AS FOLLOWS:


	1.  START BYTES		03CH  (100)
	2.  SYNC  BYTE		06EH
	3.  DECODE BYTE		0FFH   (CONTROLS DISPLAY)
	4.  TYPE  BYTE		0,1 OR 2
	5.  LENGTH BYTE		NO OF 256 BYTE RECORDS
	6.  NAME		CP/M FILE NAME.

			OPTION TABLE

	NODISPLAY		TURN OFF DISPLAY FEATURE (FOR SLOW TERMINALS)
	BLOCK			BLOCK FILES ON TAPE IF FILE WILL NOT FIT
				    IN 16K CP/M SYSTEM
	VERIFY			COMPARE TAPE FILE WITH DISK FILE OF SAME NAME
	RENAME			RENAME FILE ON DISK AFTER COPY FROM TAPE

	COMMAND STRINGS CAN BE CONSTRUCTED FROM VARIOUS COMBINATIONS OF
THE NAMES AND OPTIONS LISTED ABOVE. IN GENERAL MORE THAN ONE OPTION CAN
BE INCLUDED IN ANY COMMAND STRING. IF COMMENTS OR OPTIONS ARE INCLUDED
IN A CASE WHERE THEY ARE NOTAND COLONS ARE REQUIRED AND NO SPACES
ARE PERMITTED IN THE SOURCE OR DESTINATION. THE OPTIONS AND COMMENTS
MAY BE TYPED ANYWHERE ON THE INPUT LINE. INTERVENING SPACES WILL BE
SKIPPED OVER.
	TO RENAME A FILE DURING A TAPE TO DISK COPY ENTER THE WORD
RENAME FOLLOWED BY THE NEW FILE NAME AND TYPE ANYWHERE ON THE INPUT
LINE FOLLOWING THE SOURCE. THIS FEATURE IS USEFUL IF A FILE WITH THE
SAME NAME ALREADY EXISTS ON THE DISK.
	TO VERIFY A FILE OR GROUP OF FILES EXECUTE A TAPE TO DISK COPY
OPERATION WITH R MESSAGE IF THE FILE IS NOT TYPE 'COM'. COM FILES ARE MOVED TO
STARTING LOCATION 100H BEFORE BEING EXECUTED.

VII.  PROMPTS AND ERROR MESSAGES

	TAPELIB ASSUMES THAT ONLY AN INEXPENSIVE NON CONTROLED CASSETTE
TAPE RECORDER IS BEING USED. THE PROGRAM HALTS AT THE PROPER TIMES AND
DISPLAYS INSTRUCTIONS FOR STARTING AND STOPPING THE TAPE. FOR EXAMPLE
TO COPY DISK TO TAPE THE PROGRAM WILL PAUSE AND DISPLAY:

	START CASSETTE TAPE <<RECORD>> - TYPE CARRIAGE RETURN

FOR TAPE TO DISK OPREATIONS THE MESNCORRECT DESTINATION, MUST BE TAPE:
				DISK:, A:, B:, OR RUN: - REENTER

3.  NO FILE BY THAT NAME	INCORRECT NAME OR DRIVE - REENTER
    ON DRIVE A

4.  CHECKSUM ERROR		CHECK SUM ON TAPE DOES NOT AGREE WITH
				COMPUTED SUM. - VARIETY OF CAUSES
				CHECK TERMINAL SPEED 4800 BAUD OR GREATER
				REWIND TAPE TO BEGINNING OF FILE AND
				TYPE CARRIAGE RETURN

5.  VERIFY ERROR		A BYTE IN THE TAPE FILE DOES NOT MATCH
				THE DISK COPY - CHECK FOR INCORRECT TAPE
				OR DISK

6.  ERROR - FILE TYPE N  (11 BYTES)
	7.  COMMENT		110 BYTES AVAILABLE BLANK IF NOT USED
	8.  DATA		MULTIPLES OF 256 BYTE RECORDS
	9.  CHECKSUM		ONE BYTE TARBELL CHECKSUM

	IF A FILE IS UNBLOCKED IT WILL CONTAIN ONLY ONE CONTINUOUS
RECORD IN THE FORMAT GIVEN ABOVE. IF A FILE IS BLOCKED ONLY THE
FIRST RECORD OF THE FILE CONTAINS THE NAME AND COMMENT, THE REMAINING
FIELDS HOWEVER ARE THE SAME.
	EACH FILE IS PRECEEDED BY A BLOCK OF 1500 START BYTES
FOLLOWED BY 100 HALT BYTES (76H). THE START BYTE BLOCK PROVIDES TIME
FOR DISK OPERATIONS TO COMPLETE AND THE HALT BYTES SERVE TO INDENTIFY
THE BEGINNING OF A FILE. THE NUMBER OF BYTES IN A TAPE RECORD IS
ALWAYS A MULTIPLE OF 256 NOT COUNTING THE START,SYNC,TYPE,LENGTH
AND DECODE BYTES. IF DATA DOES NOT EXACTLY FILL A RECORD, THE
REMAINDER OF THE RECORD IS FILLED WITH 1AH BYTES (THE CP/M END OF FILE
CODE).
	THE BLOCKS OF A BLOCKED RECORD ARE SEPARATED BY APPROX 1 SECOND
BLOCKS OF START BYTES. TWO OF THE BLOCKS ARE APPROX 3 SECONDS LONG TO
ALLOW FOR THE EXTRA TIME REQUIRED IE HAVE
BEEN FOUND. IT IS UP TO THE USER TO STOP THE TAPE AT THE PROPER
TIME WITHOUT PROMPTING FROM THE PROGRAM.
	TAPE RECORDS ARE LABLED AND THEREFORE TAPE POSITIONING IS
NOT AT ALL CRITICAL. AS LONG AS THE TAPE STARTS BEFORE THE RECORD
REQUESTED THE PROGRAM WILL FIND THE FILE. THE PROGRAM MAY EVEN BE
STARTED WHILE READING LEADER.  HOWEVER IF TAPES ARE NOT ERASED
BEFORE USE, OLD FILES AT THE END OF THE TAPE MAY BE FOUND AND READ
DURING BLOCK COPY OPERATIONS. THE COPY-ALL OPERATION:

	DISK:=*.*

S THE TIME MAY NOT BE SUFFICIENT IN ALL CASES.
IF THE TAPE DENSITY IS NOT TARBELL STANDARD OR DISK ERRORS OCCUR 
REQUIRING MULTIPLE READS FOR ERROR CORRECTION ERRORS MAY OCCUR.
THE TYPE OF ERRORS WILL BE MISSED FILES DURING BLOCK COPIES OR MISSED
BLOCKS WHILE COPYING BLOCKED TAPES. SIMPLE INSPECTION WILL DETECT MISSING
FILES. SCAN THE TAPE AND COUNT THE RECORDS. MISSING BLOCKS ARE MORE
DIFFICULT BUT CAN USUALLY BE DETECTED BY REVERIFICATION OF THE TAPE.

IX.  TIMING DATA AND SPACE CONSIDERATIONS

!  9"1 2: ): og,ʸw!K
CP/M DUMP UTILITY VERS 1.3
$,	 wCOPYRIGHT 1978 BY S. J. SINGER
$V	 Æ
*$	 >212!  "!  s#
§
 > !\ ! s#
¿
# !A: !B:"2>2x~#!  @ Bx?G=#* 	7! @R%ZVALIDATEڐ! @m%rGROUP! @%ÇG ! @%ÝMAP+	! @%óDIRڇ
! @%TRACK! @%T 1~!#:  0͊
:7 ? O* .!"  :M?8O* ."6  *:_ * .'"M  :t
               DRIVE A -$Y	 Ç TRACK $	 !  :oÿ	ڢ
 	|ę{0__ ͙  SECTOR $	 !  :o͙	 !:4
               DRIVE B -$	 |>2>2À6 #> w#
< OE  .dw#
O7yo#
j  w#
q !\ 4e !ÞCOM§! ":_ \  ʋ\  ý:! "*:\:\  $	F THE FILE HAS MORE THAN ONE EXTENT.

VIII.  COMMENTS 

	SEVERAL POINTS SHOULD BE KEPT IN MIND WHEN USING TAPELIB
TAPE IS NOT NEARLY AS RELIABLE AS DISK FOR DATA STORAGE. ALWAYS
VERIFY TAPE COPIES OF DISK FILES BEFORE DESTROYING THE ORIGINALS.
USE REASONABLE QUALITY TAPE AND KEEP CASSETTE RECORDER HEADS CLEAN.
	BECAUSE THERE IS NO DIRECTORY ON TAPES, BLOCK COPY OPERATIONS
FROM TAPE TO DISK DO NOT WORK AS RELIABLY AS DISK TO DISK COPIES.
THE PROGRAM HAS NO WAY OF TELLING WHEN ALL THE FILES ON A TAPIS THE WORST OFFENDER IN THIS RESPECT. IT IS RECOMMENDED THAT TAPES
BE COMPLETELY ERASED BEFORE BEING USED AS BACK UP FOR ALL THE
FILES ON A DISK.
	CASSETTE RECORDERS ARE NOT CONTROLABLE DEVICES. IN GENERAL 
THE PROGRAM HAS TO ACCEPT DATA AT THE FIXED SPEED COMING TO IT
FROM THE TAPE, 187 BYTES PER SECOND FOR TARBELL STANDARD. SUFFICIENT
SPACE MUST BE LEFT ON THE TAPE BETWEEN RECORDS TO ALLOW COPY TIME TO
DISK IF BLOCK COPIES ARE TO BE PERFORMED. ALTHOUGH LARGE GAPS ARE LEFT
ON THE TAPE BETWEEN FILE	DATA TRANSFER RATES (APPROX)
		UNBLOCKED RECORDS		187 BYTES/SEC
		BLOCKED RECORDS			140 BYTES/SEC
	TIME BETWEEN FILES			8 SECONDS
	TIME BETWEEN BLOCKS			0.85 SECONDS

	LOAD TIME FROM TAPE FOR 10K BYTES
		UNBLOCKED RECORD		72 SECONDS
		BLOCKED RECORDS			83 SECONDS

	ONE SIDE OF A C-60 TAPE WILL USUALLY STORE THE CONTENTS OF ONE
FLOPPY DISK.

?)))	O 	}
2! @+%1SECTORI! @D%FS !:}
22"@l%m-Ғ:}
2!G~2p*@%æEDITҌù
EDIT - $	 !
 s#

> !%WRITE!%STOP.!  0
O ))))	}A.5 |K}5"	 seƐ'@'_ :\:\	 * ~\	 ! s#
¡
> }.T:}* w	 :<2Y!  "Oì* .*"   ~\	 #y	'	 
	 *~G I>._ #y	f	 
:	 * "* ">22:_ :M?ڷO* ."  *:7?O* .!"  * .'"  m:2<2º:<M2â:0
SUCCESSFUL VALIDATION$	 :VK DRIVE A$B	 b DRIVE B$Y	 Á
ERROR - TRACK $p	 :!  o͙à  SECTOR $	 !  :o͙	 >2  :}
2
Q2͊
	:<2& :oT))):_><	2~22:_  `o"!  "t	

             GROUP ALLOCATION MAP DRIVE -$G		 :	Ì	 A

$		 è	à	 B

$		 *	            $		 ~		0$		 :<2		1$		 x
y
z
3
	
#		 í	D


          $6
	 *͙|
 GROUPS REMAINING ON DISK OUT OF 243
$U
	 ::_ 2<2:7ʺ
?ں
O* .!"
  :M?
O* ."
  * ."
  * .'"
  

INPUT ERROR$
	 	1. DUMP.ASM

	THIS IS A SLIGHTLY REVISED AND SOMEWHAT IMPROVED VERSION OF THE
DUMP PROGRAM I SENT BEFORE. IT IS REWRITTEN FOR THE NEW CP/M MACRO
ASSEMBLER. THIS ASSEMBLER IS QUITE A BIT BETTER THAN THE TDL ASSEMBLER,
BUT STILL SEEMS TO HAVE A FEW BUGS.
	THE NEW DUMP HAS THE MODIFICATIONS YOU (AND EVERYBODY ELSE)
SUGGESTED. IF YOU CAN DISPLAY THE SECTORS WHY CAN'T YOU CHANGE THEM?
NOW YOU CAN. I LIKED THE LITTLE DISK ALLOCATION MAP PROGRAM ALLOC
SO I INCLUDED A SIMILAR FEATURE IN DUMP. MY COMPLIMENS A DIRECTORY DUMP. IT SORTS THE FILE NAMES ALPHABETICALLY
AND PRINTS THEM IN COLUMNS ALONG WITH THE SIZE OF THE FILES. FINALLY IT
GIVES YOU A COUNT OF THE NO OF FILES AND THE AMOUNT OF ROOM LEFT ON THE DISK

	3. MACRO.LIB

	THIS IS THE MACRO LIBRARY USED BY THE ABOVE 2 PROGRAMS AND IS OF
COURSE NECESSARY IF YOU WANT TO REASSEMBLE THE SOURCE. THE MACROS ARE QUITE
USEFUL BY THEMSELVES. THEY ARE BY NOW FAIRLY WELL OPTIMIZED FOR SIZE AND
SPEED. ALL THE LARGER ONES PRODUCE IN LINE SUBROUTINES WHICH SIMAND ALLOWS BLOCK COPY OPERATIONS.  TAPE:=*.COM ETC.
	MANY PEOPLE ARE NOW USING IT TO BACK UP DISK FILES ON INEXPENSIVE
TAPE AND IT IS ESPECIALLY USEFUL IF YOU HAVE ONLY ONE DISK DRIVE.
TAPELIB WAS WRITTEN USING THE TDL ASSEMBLER AND THE MACROS ARE INCLUDED IN
THE SOURCE. THE FILE TAPELIB.DOC GIVES FAIRLY COMPLETE DESCRIPTION
AND OPERATING INSTRUCTIONS.

		SUMMARY OF FILES INCLUDED

	DUMP.ASM		(IMPROVED DUMP.MAC)
	DUMP.COM
	XDIR.ASM		(DISPLAY FILE DIRECTORY)
	XDIR.COM
	MACRO.LIB		(MACROS FOR DUM;			--- DUMP ---
;
;					BY: S. J. SINGER
;
;	THIS PROGRAM IS AN IMPROVED DUMP UTILITY FOR CP/M. ANY CPM FILE
;MAY BE DUMPED TO THE CONSOLE IN A FORMAT SIMILAR TO THAT USED BY THE
;DDT DUMP COMMAND. IN ADDITION, ANY SECTOR OR GROUP OF SECTORS MAY
;BE DUMPED IN THE SAME FORMAT.
;
;			-- OPERATION --
;
;	THE PROGRAM MAY BE RUN EITHER BY TYPING DUMP, OR DUMP FOLLOWED
;BY THE FILE NAME OR TRACK AND SECTOR. IF DUMP  IS TYPED THE PROGRAM
;RESPONDS WITH A HEADING FOLLOWED BY A '*' AND WAITS FOR MORE I
INCORRECT SECTOR NUMBER$	 F
INCORRECT TRACK NUMBER$-	 À
INCORRECT GROUP NUMBER (GREATER THAN 242)$T	 :÷
NO FILE BY THAT NAME ON DRIVE A$	 
NO FILE BY THAT NAME ON DRIVE B$	 
DISK DEAD ERROR$	 *
ERROR IN FILE NAME$	 I

ADDRESS ERROR$8	 ìt
  ERROR - HEX INPUT ONLY
$W	 Y	 :_ * $
$      Y THAT NAM               	 
NO FILE BY      
	
               TS TO THE AUTHOR.
I ALSO LIKED THE IDEAS OF THE OTHER DIRECTORY DISPLAY PROGRAMS
XDIR AND WDIR. THEY PUT ALL THE DIRECTORY ON THE SCREEN AT ONCE, BUT THEIR
FORMAT IS OTHERWISE LOUSY! I TRIED TO INCLUDE THIS FUNCTION IN DUMP BUT
THE ASSEMBLER BLEW UP ON ME. THE SOURCE GOT TOO LARGE AND I AM GETTING
SOME KIND OF TABLE OVERFLOW. CAN ANYBODY GIVE ME ANY HELP. DIGITAL RESEARCH
SAYS IT SHOULDN'T HAPPEN.
	ANYWAY I JUST PULLED THE LOGIC BACK OUT AND MADE IT A SEPARATE 
PROGRAM.

	2. XDIR.ASM

	XDIR GIVEPLY GET
CALLED IF THE MACRO IS USED MORE THAN ONCE. THEY INCLUDE CONSOLE I/O,
DISK PRIMITIVES, A FEW GENERAL PURPOSE ROUTINES I ADAPTED FROM THE LIOS
LIBRARY AND SOME STRING HANDLING ROUTINES. I'M BEGINNING TO DEVELOPE SOME
DOUBLE PRECISION INDEXED ARITHMETIC ROUTINES. DLOAD AND DSTORE ARE IN THIS
MACRO LIBRARY. I'M STILL WORKING ON OTHERS.

	3. TAPELIB.MAC

	THIS IS A CASSETTE TAPE LIBRARY MANAGER FOR TARBELL FORMAT TAPES.
IT IS ESSENTIALLY PIP WRITTEN FOR CASSETTE TAPE. IT SUPPORTS NAMED FILES
P AND XDIR)
	TAPELIB.MAC		(PIP FOR TARBELL CASSETTE TAPE)
	TAPELIB.COM
	TAPELIB.DOC		(DOCUMENTATION FOR TAPELIB)
NPUT. 
;OPERATION IN THIS MODE IS SIMILAR TO OTHER UTILITIES LIKE PIP OR DDT.
;	THE OPERATION DESIRED MAY THEN BE TYPED IN AS FOLLOWS:
;
;		DUMP FILE.NAM
;		DUMP A:FILE.NAM
;		DUMP B:FILE.NAM
;
;	OR DUMP MAY BE TYPED SEPARATELY AS:
;
;		DUMP
;
;		*FILE.NAM
;		*B:FILE.NAM	(THE * IS A PROGRAM PROMPT)
;
;	THE PROGRAM MAY ALSO BE USED TO DUMP DISK SECTORS DIRECTLY,
;DUMP ANY CP/M EIGHT SECTOR GROUP, A MAP OF THE GROUP ALLOCATIONS FOR THE
;ENTIRE DISK OR THE DIRECTORY SORTED ALPHABETICALLY.
;
;		DUMP TRACK 3 SECTOR 7
;		DUMP TRACK 5   SECTOR  3 - 9
;		DUMP TRACK   6   (DUMPS ALL 26 SECTORS)
;		DUMP GROUP  19
;		DUMP MAP
;		DUMP DIR	(DUMPS DIRECTORY)
;
;	THE WORDS TRACK, SECTOR AND GROUP MAY BE ABREVIATED AS FOLLOWS
;
;		DUMP G 4
;		DUMP T 7 S 3-4
;		*TRACK 5 S 6
;		*SECTOR 2- 9  T 14
;
;
;		DUMP B:  TRACK 3
;		DUMP A: T 9   S 4-6
;		DUMP B:   G  5
;		DUMP B:MAP
;
;	NOTE THAT THE FORMAT IS QUITE FREE. SPACES ARE USUALLY IGNORED
;THEY ARE ONLY REQUIRED AFTER THE WORDS TRACK AN BACK THE ADDR ENTERED AND THE PRESENT CONTENTS OF THAT
;ADDRESS. TO CHANGE THE CONTENTS OF THE ADDRESS ENTER THE NEW BYTE FOLLOWED
;BY A CARRIAGE RETURN. THE PROGRAM WILL DISPLAY THE NEXT ADDRESS AND ITS
;CONTENTS. TO STOP ENTERING DATA TYPE A PERIOD. THE PROGRAM WILL REDISPLAY
;THE SECTOR SHOWING THE CHANGES MADE. THE EDIT FEATURE WORKS ALMOST EXACTLY
;LIKE THE S ENTRY FEATURE IN DDT. TYPING ONLY A CARRIAGE RETURN OMITS ENTRY.
;	TYPING A PERIOD MERELY REDISPLAYS THE SECTOR FROM MEMORY, IT DOES
;NOT0000.
;	THE EDIT FEATURE SHOULD BE USED WITH CAUTION SINCE IT IS POSSIBLE
;TO EDIT CP/M TO "DEATH" BY CHANGING A SINGLE BYTE. ONE OCCASIONAL VALUABLE
;USE IS TO RESTORE FILES THAT HAVE BEEN ACCIDENTALLY ERASED. ERASING A FILE
;USING THE ERA COMMAND DOES NOT ERASE THE DATA FROM THE DISK, BUT ONLY ENTERS
;AN E5 INTO THE FIRST BYTE OF THE DIRECTORY. TO RESTORE A FILE, DISPLAY
;THE DIRECTORY BY DISPLAYING GROUPS 0 AND 1. FIND THE SECTOR CONTAINING THE
;NAME OF THE FILE TO BE RESTORED AND DISPLAY IT USINGWHEN VALIDATING THE PROGRAM READS EVERY FIFTH SECTOR FOR SPEED.
;
;	AS WITH OTHER CP/M UTILITIES ^S "FREEZES" THE DISPLAY, AND ^C
;RETURNS TO THE MONITOR. DUMP CONTAINS MANY ERROR AND CONSISTANCY
;CHECKS. THE RESULTING MESSAGES SHOULD BE SELF EXPLANATORY.
;
;	DUMP WAS ASSEMBLED USING THE CP/M MACRO ASSEMBLER, AND USES A LARGE
;NUMBER OF MACROS INCLUDED IN A LIBRARY CALLED MACRO.LIB
;
$-PRINT
	MACLIB	MACRO		;INCLUDE MACRO LIBRARY
	ORG	100H		;SET PROG START
	LXI	H,0
	DAD	SP		;GET STACK POINTER
	OPYRIGHT 1978 BY S. J. SINGER',CR,LF>
NEWIN:	PRINT	<CR,LF,'*'>
	MVI	A,0FFH		;SET SWITCH TO RETURN HERE AGAIN
	STA	INFLAG
	LXI	SP,NEWSTK	;RESET STACK POINTER
	XRA	A
	STA	VALFLG		;RESET VALIDATION ERROR FLAG
	LXI	H,0
	SHLD	LINE		;SET LINE COUNT TO ZERO
	FILL	80H,0FFH	;ZERO INPUT BUFFER
	INPUT	80H		;READ FILE NAME
;
;  SELECT DISK DRIVE AND SET UP FILE CONTROL BLOCK
;
START:	FILL	FCB,FCB+32	;ZERO FILE CONTROL BLOCK
	MATCH	82H,'A:'	;DRIVE A
	JZ	ADISK
	MATCH	82H,'B:'	;DRIVE B
	JZ	BDISK
	JMP	GED SECTOR OR T AND S,
;AND AFTER THE WORD DUMP.
;	A LIMITED EDITING FEATURE IS INCLUDED IN THE DUMP UTILITY TO
;ALLOW CHANGING DATA ON THE DISK. THE EDIT FEATURE WORKS AS FOLLOWS.
;ANY SINGLE SECTOR ON EITHER DRIVE MAY BE EDITED BY REQUESTING DISPLAY
;OF THE SECTOR FOLLOWED BY THE WORD EDIT.
;
;		DUMP B:TRACK 4 SECTOR 2  EDIT
;
;	THE REQUESTED SECTOR WILL BE DISPLAYED FOLLOWED BY AN EDIT PROMPT
;
;	EDIT -
;
;	ENTER THE ADDRESS OF THE FIRST BYTE TO BE CHANGED. THE PROGRAM WILL
;RESPOND BY TYPING CAUSE IT TO BE WRITTEN BACK ON THE DISK. WHEN EDITING IS COMPLETE,
;REDISPLAY THE SECTOR BY TYPING A PERIOD AND TYPE EITHER
;
;		WRITE		(WRITE SECTOR BACK ON DISK)
;		STOP		(STOP EDITING WITHOUT WRITING ON DISK)
;
;	ALL EDIT ENTRIES MUST BE MADE IN HEX. ENTERING NON HEX CHARACTERS
;RESULTS IN AN ERROR MESSAGE. THE PERMISSABLE ADDRESS RANGE IS 0000 TO 007F.
;LARGER ADDRESSES GIVE AN ERROR MESSAGE. WHEN ENTERING A GROUP OF BYTES THE
;ADDRESSES ARE COMPUTED MODULO 128, THE NEXT ADDRESS AFTER 007F IS  THE EDIT FEATURE
;CHANGE THE BYTE PRECEEDING THE FILE NAME FROM E5 TO 00 AND WRITE THE SECTOR
;BACK ON THE DISK. THIS WILL RESTORE THE FILE PROVIDED NONE OF THE SECTORS
;IN THE FILE WERE CHANGED AFTER THE FILE WAS "ERASED".
;
;	AN ADDITIONAL FEATURE OF DUMP IS THE ABILITY TO VALIDATE A DISK.
;
;		DUMP VALIDATE
;		DUMP A:VALIDATE
;		DUMP B:VALIDATE
;
;	THIS CAUSES THE ENTIRE DISK SELECTED TO BE READ ONE SECTOR AT A
;TIME. THE SECTOR NUMBER OF ANY SECTOR CAUSING A READ ERROR WILL BE DISPLAYED.
;SHLD	OLDSTK
	LXI	SP,NEWSTK	;SET UP NEW STACK
	DISKIO	?DRIVE		;GET CURRENTLY LOGGED DRIVE NO
	STA	NEWDRV		;ALSO SAVE IN NEW DRIVE NO
	LDA	81H		;CONSOLE INPUT ALREADY HERE ?
	ORA	A
	JZ	SIGNON		;BUFFER EMPTY, INPUT FROM CONSOLE
	LDA	80H		;GET NO OF CHAR INPUT
	ORI	80H		;ADD 128
	MOV	L,A		;TO L
	XRA	A		;ZERO
	MOV	H,A		;HL CONTAINS ADDR OF END OF BUFFER
ZBFF:	INR	L
	JZ	START		;REMAINDER OF BUFFER ZEROED
	MOV	M,A
	JMP	ZBFF		;LOOP
SIGNON:	PRINT	<CR,LF,'CP/M DUMP UTILITY VERS 1.3',CR,LF>
	PRINT	<'CTNAM		;NO DRIVE SPECIFIED
ADISK:	XRA	A
	STA	NEWDRV		;SELECT DRIVE A
	JMP	DOWN
BDISK:	MVI	A,1
	STA	NEWDRV		;SELECT DRIVE B
DOWN:	MOVE	82H,80H,40H	;SHIFT BUFFER DOWN TWO BYTES
;
;  SEARCH FOR DIRECT READ OF TRACK AND SECTOR OR VALIDATE
;
GETNAM:	INSTR	82H,40H,'VALIDATE'
	JC	VALID		;VALIDATE DISK
	INSTR	82H,40H,'GROUP'
	JC	GROUP		;DISPLAY CPM 8 SECTOR GROUP
	INSTR	82H,40H,'G '	;SEARCH FOR 'G'
	JC	GROUP		;DISPLAY GROUP
	INSTR	82H,40H,'MAP'	;ALLOCATION MAP
	JC	MAP		;DISPLAY GROUP ALLOCATION MAP
	INSTR	82H,40H,'DIR'	;DIRECTORY REQUEST
	JC	DIR		;DISPLAY DIRECTORY
	INSTR	82H,40H,'TRACK'	;SEARCH FOR TRACK
	JC	TRK1
	INSTR	82H,40H,'T '	;SEARCH FOR 'T'
	JNC	FILNAM		;NO TRACK GO TO READ FILE
TRK1:	SCAN			;FIND AND CONVERT NUMBER
	DECIN
	JC	INERR		;INPUT ERROR ON CARRY
	STA	TRACK		;SAVE TRACK NO
	INSTR	82H,40H,'SECTOR'	;SEARCH FOR SECTOR
	JC	SEC1
	INSTR	82H,40H,'S '	;TRY 'S'
	JNC	WHLTRK		;DUMP ENTIRE TRACK
SEC1:	SCAN	
	DECIN
	JC	INERR		;INPUT ERROR ON CARRY
	STA	BSEC		;BEGINNING SECTOR
	BACK FOR MORE INPUT
EDIT:	LHLD	IPOINT		;RESET BUFFER POINTER
	INSTR	,40H,'EDIT'	;CHECK EDIT FUNCTION
	JNC	DOREAD		;GO TO DISPLAY SECTOR
	CALL	RDISK0		;DISPLAY SECTOR
EDIT1:	PRINT	<CR,LF,'EDIT - '>
	FILL	INBUF,INBUF+9
	INPUT	INBUF,6		;INPUT MAXIMUM 6 CHAR
	INSTR	INBUF,8,'WRITE'	;WRITE EDITED SECTOR ON DISK?
	JC	WRTDSK		;WRITE BUFFER BACK ON DISK
	INSTR	INBUF,8,'STOP'	;STOP EDITING WITHOUT WRITING?
	JC	ENDFIL		;EXIT
	HEXIN	INBUF+2		;CONV ASCII TO HEX
	JNC	CKLIM		;IF NO ERROR, CHECK ADDR
	LDAX	D	 MAX
	HEXIN	INBUF+2		;CONVERT
	JNC	EDIT2		;HEX CHAR
	LDAX	D		;GET ASCII CHAR
	CPI	'.'		;PERIOD ENDS INPUT
	JZ	EDIT3		;BACK FOR MORE EDITING
	JMP	HEXERR		;ERROR NOT HEX CHAR
EDIT2:	LDA	INBUF+1		;LOAD NO OF CHAR TYPED
	ORA	A
	JZ	EDITX		;NO REPLACEMENT IF JUST CR
	MOV	A,L		;CONVERTED CHAR BACK TO A
	LHLD	IPOINT		;LOAD MEMORY BUFFER POINTER
	LXI	D,0080H		;OFFSET
	DAD	D		;CALC MEMORY ADDR
	MOV	M,A		;STORE NEW INPUT TO MEMORY
EDITX:	PRINT	CRLF,$
	LDA	IPOINT		;LEAST SIGNIFICANT HALF OF ADDR
	INR	A	;SELECT NEW DEIVE IF SPECIFIED
	CALLBIOS DREAD		;READ TRACK AND SECTOR
;
;  PRINT DRIVE, TRACK AND SECTOR HEADING
;
PRTSEC:	LDA	NEWDRV		;NEW DRIVE NO
	ORA	A
	JNZ	PRNB		;PRINT DRIVE B
	PRINT	<CR,LF,'               DRIVE A -'>
PRNTRK:	PRINT	' TRACK '
	LXI	H,0
	LDA	TRACK
	MOV	L,A
	DECOUT
	PRINT	'  SECTOR '
	LXI	H,0
	LDA	BSEC
	MOV	L,A
	DECOUT
	PRINT	CRLF,$
	CALL	PRTBUF		;PRINT IT
	LXI	H,BSEC		;ADDR OF SECTOR NUMBER
	LDA	ESEC		;END SECTOR NUMBER
	CMP	M		;COMPARE THEM
	RZ			;EXIT IF THEY 
	SHLD	LINE		;SET LINE NO. TO 100
SELDR:	LDA	NEWDRV		;SELECT NEW DRIVE
	MOV	E,A
	DISKIO	LOGIN
	DISKIO	OPEN,FCB	;0PEN FILE
	CPI	255		;CHECK FILE PRESENT
	JZ	OPNERR		;EXIT IF ERROR
RDFILE:	DISKIO	READ,FCB	;READ A BLOCK
	ORA	A		;ZERO INDICATES SUCESSFUL READ
	JNZ	ENDFIL		;1 INDICATES EOF
	CALL	PRTBUF		;DO PRINT SUBROUTINE
	JMP	RDFILE		;BACK FOR NEXT BLOCK
ENDFIL:	LDA	INFLAG		;SEE WHERE TO GO
	ORA	A
	JZ	MONITOR
	JMP	NEWIN
;
;
;  PRTBUF - PRINT BUFFER IN HEX AND ASCII
;
PRTBUF:	MVI	B,8		;8 LISTA	ESEC		;SAVE IN END SECTOR ALSO
	XCHG			;SET BUFFER POINTER FOR SCAN
	SHLD	IPOINT		;SAVE BUFFER POINTER FOR EDIT
	INSTR	,40H,'-'	;SEARCH FOR '-'
	JNC	EDIT		;CHECK FOR EDITION OF SECTOR
	SCAN
	DECIN			;SCAN AND CONVERT ANOTHER NO
	JC	INERR		;ERROR IF CARRY SET
	STA	ESEC		;SAVE IN END SECTOR
	LXI	H,BSEC		;POINTS TO BSEC
	CMP	M		;COMPARE BEGIN AND END
	JP	DOREAD		;OK IF END>=BEGIN
	MOV	B,A		;OTHERWISE
	MOV	A,M		;SWITCH THEM
	STA	ESEC
	MOV	M,B
DOREAD:	CALL	RDISK0		;READ DIRECT
	JMP	ENDFIL		;	;GET ASCII CHAR
	CPI	'.'		;CHECK FOR EXIT CHAR
	JZ	EDIT3		;BACK FOR MORE EDITING
	JMP	ADERR		;ADDRESS ERROR
CKLIM:	LXI	D,0080H		;CHECK ADDR LIMIT
	CPHL
	JP	ADERR		;ADDRESS ERROR
	SHLD	IPOINT		;SAVE ADDRESS
	PRINT	CRLF,$
PTX:	HEXOUT	IPOINT+1
	HEXOUT	IPOINT		;ECHO THE ADDRESS
	PRINT	SPACE,$
	LHLD	IPOINT		;ECHO PRESENT CONTENTS
	LXI	D,0080H
	DAD	D		;COMPUTE MEMORY ADDR
	MOV	A,M		;GET BYTE FROM MEMORY
	HEXOUT
	PRINT	SPACE,$
	FILL	INBUF,INBUF+5	;ZERO INPUT BUFFER
	INPUT	INBUF,4		;INPUT 4 CHAR		;INCR BY ONE
	ANI	7FH		;COUNT MOD 128
	STA	IPOINT
	JMP	PTX		;INPUT MORE DATA
EDIT3:	LXI	H,0
	SHLD	LINE		;RESET LINE NO TO ZERO
	CALL	PRTSEC		;PRINT BUFFER WITH HEADING
	JMP	EDIT1		;BACK FOR ADDITIONAL EDITING
WRTDSK:	CALLBIOS DWRITE		;WRITE BUFFER BACK ON DISK
	JMP ENDFIL		;EXIT
;
;  READ TRACK AND SECTOR DIRECT
;
RDISK0:	CALL	FIXB
RDISK:	SETSEC	BSEC		;SET SECTOR
	JC	BADSEC		;WRONG SECTOR NO
TRK2:	SETTRK	TRACK		;SET TRACK
	JC	BADTRK		;WRONG TRACK NO
	LDA	NEWDRV
	MOV	E,A
	DISKIO	LOGIN		ARE EQUAL
	INR	M		;INCR BSEC
	JMP	RDISK
PRNB:	PRINT	<CR,LF,'               DRIVE B -'>
	JMP	PRNTRK		;PRINT TRACK AND SECTOR
;
;  DUMP ENTIRE TRACK IF NO SECTOR INPUT
;
WHLTRK:	MVI	A,1		;BEGIN SECTOR
	STA	BSEC
	MVI	A,26		;END SECTOR
	STA	ESEC
	CALL	RDISK0		;TO READ DISK
	JMP	ENDFIL		;BACK FOR MORE INPUT
;
;  FILL IN FCB FOR NAMED FILE
;
FILNAM:	FILFCB	FCB,82H	;FILL IN FCB NAME FROM INPUT BUFFER
	JC	NAMERR		;ERROR IN FILE NAME
	MATCH	FCB+9,'COM'	;TEST FOR COM FILE
	JNZ	SELDR
	LXI	H,100H	
NES
	LXI	H,80H		;INITIAL BUFFER POINTER
	SHLD	IPOINT		;STORAGE FOR POINTER
BPRN:	LHLD	IPOINT		;LOAD POINTER
	MVI	C,16		;CHAR PER LINE
	LDA	LINE+1		;LINE NUMBER
	SAVE	B,H
	HEXOUT
	LDA	LINE		;SECOND TWO DIGITS
	HEXOUT
	PRINT	'  '
	RESTORE	H,B
PLOOP:	MOV	A,M		;GET A BYTE
	SAVE	B,H
	HEXOUT
	PRINT	SPACE,$
	RESTORE	H,B
	INX	H		;INCR MEMORY POINTER
	MOV	A,C
	CPI	9		;CHECK 8 CHAR
	JNZ	DECC		;SKIP IF NOT
	SAVE	B,H
	PRINT	SPACE,$
	RESTORE	H,B
DECC:	DCR	C		;DECR CHAR COUNT
	JNZ	PLOOP		;PRINT SOME MORE
	SAVE	B
	PRINT	SPACE,$
	RESTORE	B
	LHLD	IPOINT		;RESET POINTER FOR ASCII
	MVI	C,10H		;RESET CHAR COUNT
PLOOP1:	MOV	A,M		;GET A BYTE
	ANI	7FH		;MASK OFF HIGH BIT
	CPI	7FH		;DELETE CODE
	JZ	PERIOD		;PRINT PERIOD FOR DELETE
	CPI	20H		;TEST FOR CONTROL CHAR
	JP	SKIPX		;SKIP SUBSTITUTION
PERIOD:	MVI	A,2EH		;ASCII PERIOD
SKIPX:	SAVE	B,H
	CHAROUT			;PRINT IT SAVE REGS
	RESTORE	H,B
	INX	H		;INCR MEMORY POINTER
	MOV	A,C
	CPI	9		;CHECK 8 CHAR
	JNZ	DECC2
	SAVE	B,H
	PRINT	SPACE,$
	RESTORE
	JC	BADTRK
RS1:	SETSEC	SNUM
	JC	BADSEC
	CALLBIOS DREAD
	ORA	A
	CNZ	VALERR		;ERROR IF NOT ZERO
	CALL	PRNCON		;ESCAPE ON CONTROL C
	LDA	SNUM		;SECTOR NO
	ADI	5		;INCR BY 5
	STA	SNUM		;STORE IT BACK
	SBI	27		;CALC SECTOR MOD 26
	JM	RS1		;SECTOR OK IF MINUS
	INR	A		;SECTOR MOD 26
	STA	SNUM		;STORE IT BACK
	CPI	1		;ARE WE BACK TO ONE YET
	JNZ	RS1		;READ SOME MORE
	LDA	TNUM		;TRACK NUMBER
	INR	A		;INCR BY ONE
	CPI	77		;CHECK LIMIT
	JZ	VALOUT		;TO EXIT
	STA	TNUM		;STORE BACK TRACK NO
	JMP	RS
	CHARIN			;READ CONSOLE
	CPI	3		;TEST FOR CONTROL C
	JZ	ENDFIL		;EXIT IF CONTROL C
	RET
;
;    THIS SECTION DISPLAYS A CPM GROUP OF 8 SECTORS
;
GROUP:	SCAN			;GET THE GROUP NO
	DECIN			;CONVERT TO BINARY
	JC	INERR		;INPUT ERROR IF CARRY SET
	STA	G		;SAVE GROUP NO
	ADI	13		;CHECK LEGAL RANGE
	JC	BADGRP
	XRA	A
	STA	S		;SET SECTOR COUNT TO 0
	CALL	FIXB		;RESTORE DRIVE B IF SELECTED
GRP1:	CALL	GRPTS		;CONVERT TO TRACK AND SECTOR
	CALL	RDISK		;PRINT THE SECTOR
	LDA	S		;CHECK SECTOR COUNT
	IN
	DAD	D
	STA	TRACK		;STORE TRACK NO
	MOV	A,M		;GET SECTOR NO
	STA	BSEC		;SAVE IN BEGINNING SECTOR
	STA	ESEC		;SAVE IN END SECTOR TOO
	RET
$+PRINT
;
;    THIS ROUTINE DISPLAYS THE DISK SECTOR ALLOCATION MAP
;
MAP:	LDA	NEWDRV
	MOV	E,A
	DISKIO	LOGIN		;LOG IN SELECTED DRIVE
	DISKIO	?ALLOC		;GET POINTER TO ALLOCATION MAP
	MOV	H,B
	MOV	L,A		;TO HL
	SHLD	IPOINT		;SAVE MAP POINTER
	LXI	H,0		;ZERO HL
	SHLD	G		;ZERO COUNT OF UNUSED GROUPS
	PRINT	<CR,LF,LF,'             GROUP ALLOCATION MAP DRIVE -
	JMP	MAP6
MAP5:	PRINT	'1'		;PRINT A ONE
MAP6:	RESTORE	PSW,H,D,B
	SAVE	PSW		;SAVE BIT MAP BYTE
	MOV	A,B		;BIT COUNT
	CPI	7
	JNZ	MAPY
	MOV	A,C		;WORD COUNT
	CPI	2
	JNZ	MAPY
	MOV	A,D		;LINE COUNT
	CPI	1
	JNZ	MAPY
	RESTORE	PSW
	JMP	MAP7		;TO PRINT UNUSED GROUPS
MAPY:	RESTORE	PSW
	DCR	B		;DCR BIT COUNT
	JNZ	MAP4		;PRINT MORE BITS
	DCR	C		;DECR WORD COUNT
	INX	H		;INCR ALLOC MAP POINTER
	JNZ	MAP3
	SAVE
	PRINT	CRLF,$
	RESTORE
	DCR	D		;DECR LINE COUNT
	JMP	MAP2
MAP7:	PRINT	<CR,LF,LF,'    	H,B
DECC2:	DCR	C		;DECR CHAR COUNT
	JNZ	PLOOP1		;PRINT SOME MORE
	SAVE	B
	PRINT	CRLF,$		;CARRIAGE RETURN
	CALL	PRNCON		;PRINT CONTROL?
	POP	B
	INDEX	LINE,16		;INCR LINE NO BY 16
	DCR	B		;DECR	LINE COUNT
	RZ			;RETURN IF LINE COUNT ZERO
	INDEX	IPOINT,16	;INCR POINTER BY 16
	JMP	BPRN		;LOOP BACK
;
;    THIS SECTION VALIDATES A DISK
;
VALID:	MVI	A,1		;START WITH SECTOR 1
	STA	SNUM
	XRA	A		;START WITH TRACK 0
	STA	TNUM
	LDA	NEWDRV		;SELECT NEW DRIVE
	MOV	E,A
	DISKIO	LOGIN
RS0:	SETTRK	TNUM0		;BACK TO READ ROUTINE
VALOUT:	LDA	VALFLG		;CHECK ERROR FLAG
	ORA	A
	JNZ	ENDFIL
	PRINT	<CR,LF,'SUCCESSFUL VALIDATION'>
	LDA	NEWDRV
	ORA	A
	JNZ	VAL2
	PRINT	' DRIVE A'
	JMP	ENDFIL
VAL2:	PRINT	' DRIVE B'
	JMP	ENDFIL
VALERR:	PRINT	<CR,LF,'ERROR - TRACK '>
	LDA	TNUM
	LXI	H,0
	MOV	L,A
	DECOUT
	PRINT	'  SECTOR '
	LXI	H,0
	LDA	SNUM
	MOV	L,A
	DECOUT
	PRINT	CRLF,$
	MVI	A,-1
	STA	VALFLG		;SET ERROR FLAG
	RET
;
;  PRINT CONTROL AND ESCAPE
;
PRNCON:	MVI	C,11
	CALL	5
	ANI	1
	RZ			;RETURNR	A
	STA	S		;INCR S BY 1
	CPI	8		;CHECK LIMIT
	JNZ	GRP1		;PRINT ANOTHER SECTOR
	JMP	ENDFIL		;BACK FOR MORE INPUT
;
;   GRPTS  CONVERT CPM GROUP AND SECTOR NUMBER TO TRK AND SEC
;
GRPTS:	MVI	H,0		;ZERO H
	LDA	G		;GROUP NO
	MOV	L,A		;TO L
	MOV	D,H		;ZERO	D
	DAD	H
	DAD	H
	DAD	H		;SHIFT LEFT 3
	LDA	S		;GET SECTOR NO
	MOV	E,A		;TO DE
	DAD	D		;HL HAS G*8+S
	LXI	D,-26		;DIVISOR
	MVI	A,1		;CONTAINS DIVIDEND
DIV:	DAD	D		;SUB 26
	INR	A
	JC	DIV		;LOOP TILL MINUS
	LXI	D,TABLE+26	;INDEX INTO TABLE'>
	LDA	NEWDRV		;LOGGED DRIVE
	ORA	A
	JNZ	DRB		;DRIVE B
	PRINT	<' A',CR,LF,LF>
	JMP	MAP1
DRB:	PRINT	<' B',CR,LF,LF>
MAP1:	LHLD	IPOINT		;POINTER TO DISK ALLOCATION MAP
	MVI	D,8		;NO OF LINES
MAP2:	MVI	C,4		;WORDS PER LINE
MAPX:	SAVE
	PRINT	'            '
	RESTORE
MAP3:	MVI	B,8		;BITS PER WORD
	MOV	A,M		;GET A BYTE FROM ALLOC MAP
MAP4:	RAL			;SHIFT LEFT THRU CARRY
	SAVE	B,D,H,PSW
	JC	MAP5		;PRINT A ONE
	PRINT	'0'		;PRINT A ZERO
	LDA	G		;UNUSED GROUPS
	INR	A		;ADD 1
	STA	G		;STORE IT BACK
      '>
	DECOUT	G		;PRINT NO OF UNUSED SECTORS
	PRINT	<' GROUPS REMAINING ON DISK OUT OF 243',CR,LF>
	JMP	ENDFIL		;EXIT
;
;    THIS ROUTINE SORTS AND DISPLAYS THE DIRECTORY
;	(NOT IMPLEMENTED IN THIS VERSION)
;
DIR:	JMP	ENDFIL		;EXIT
;
;    THIS ROUTINE RESTORES DRIVE B
;
FIXB:	LDA	NEWDRV		;CHECK DRIVE NO
	ORA	A
	RZ			;RETURN IF DRIVE A
	LDA	NEWDRV		;SELECT DRIVE B
	MOV	E,A
	DISKIO	LOGIN
	XRA	A
	STA	TNUM		;SELECT TRACK ZERO
	INR	A		;SELECT SECTOR 1
	STA	SNUM
	SETSEC	SNUM
	SETTRK	TNUM
	CALLBIOS DHOME		;HOME DRIVES
	CALLBIOS DREAD		;READ TRACK ZERO DIRECT
	RET
;
;  ERROR AND EXIT ROUTINES
;
;
INERR:	PRINT	<CR,LF,'INPUT ERROR'>
	JMP	ENDFIL
;
BADSEC:	PRINT	<CR,LF,'INCORRECT SECTOR NUMBER'>
	JMP	ENDFIL
;
BADTRK:	PRINT	<CR,LF,'INCORRECT TRACK NUMBER'>
	JMP	ENDFIL
;
BADGRP:	PRINT	<CR,LF,'INCORRECT GROUP NUMBER (GREATER THAN 242)'>
	JMP	ENDFIL
;
OPNERR:	LDA	NEWDRV		;CURRENT DRIVE NO
	ORA	A
	JNZ	OPNER1
	PRINT	<CR,LF,'NO FILE BY THAT NAME ON DRIVE A'>
	JMP	ENDFIL
OPNER1:	;FILE CONTROL BLOCK
SPACE:	DB	' $'		;ASCII SPACE
CRLF:	DB	0DH,0AH,24H	;ASCII CR LF
I:	DW	0		;PSEUDO INDEX REGISTER
LINE:	DW	0		;LINE NUMBER FOR LISTING
IPOINT:	DW	00		;VARIABLE BUFFER POINTER
INBUF:	DS	10		;USED AS CONSOLE INPUT BUFFER
LASTIN:	DB	0		;LAST CONSOLE INPUT CHAR
INFLAG:	DB	0		;FLAG, RET FOR MORE CONSOLE INPUT
DRVNO:	DB	0		;STORAGE FOR ORIGINALLY LOGGED DRIVE
NEWDRV:	DB	0		;STORAGE FOR NEW DRIVE NO
TRACK:	DB	0		;SELECTED TRACK
BSEC:	DB	0		;SELECTED BEGINNING SECTOR
ESEC:	DB	0		;SELE	DB	19H
	DB	05H
	DB	0BH
	DB	11H
	DB	17H
	DB	03H
	DB	09H
	DB	0FH
	DB	15H
	DB	02H
	DB	08H
	DB	0EH
	DB	14H
	DB	1AH
	DB	06H
	DB	0CH
	DB	12H
	DB	18H
	DB	04H
	DB	0AH
	DB	10H
	DB	16H
PDIR	DW	0		;POINTER TABLE TO DIRECTORY (64 ENTRIES MAX)
DIRBUF:	EQU	PDIR+130	;START OF AREA USED TO STORE AND SORT DIRECTORY
	END
;
;	4004/4040 MACRO'S FOR CP/M MAC ASSEMBLER
;
;	   JAN 15,1977		   J.L.CLAWAY
;
;  THE FOLLOWING CHANGES NEED TO BE MADE TO THE SOURCE CODE
; TO PROPERLY ASSEMBLY;
;
;	4004/4040	MACRO CODE
;
;	  ADD		  ADD4
;	  SUB		  SUB4
;	  CMC		  CMC4
;	  CMA		  CMA4
;	  RAL		  RAL4
;	  RAR		  RAR4
;	  STC		  STC4
;	  DAA		  DAA4
;
;  IN ADDITION, THE "*" MUST BE REPLACED BY "%$".
;
;
;	(REF: INTEL 4004 AND 4040 MICROCOMPUTER
;	SYSTEM ASSEMBLY LANGUAGE PROGRAMING MANUAL)
;
STP:	MACRO
	DB 001H
A
	DB 020H+(REG*2), DATA
	ENDM
;
SRC:	MACRO REG
	DB 21H+(REG*2)
	ENDM
;
FIN:	MACRO REG
	DB 030H+(REG*2)
	ENDM
;
JIN:	MACRO REG
	DB 031H+(REG*2)
	ENDM
;
JUN:	MACRO ADDR
	DB 040H+((ADDR) SHR 8 AND 00FH), (ADDR) AND 0FFH
	ENDM
;
JMS:	MACRO ADDR
	DB 050H+((ADDR) SHR 8 AND 00FH), (ADDR) AND 0FFH
	ENDM
;
INC:	MACRO REG
	DB 060H+REG
	ENDM
;
ISZ:	MACRO REG, ADDR
	DB 070H+REG, (ADDR) AND 0FFH
	ENDM
;
ADD4:	MACRO REG
	DB 080H+REG
	ENDM
;
SUB4:	MACRO REG
	DB 090H+REG
	ENDM
;
LD:	PRINT	<CR,LF,'NO FILE BY THAT NAME ON DRIVE B'>
	JMP	ENDFIL
;
RDERR:	PRINT	<CR,LF,'DISK DEAD ERROR'>
	JMP	MONITOR
NAMERR:	PRINT	<CR,LF,'ERROR IN FILE NAME'>
	JMP	ENDFIL
;
ADERR:	PRINT	<CR,LF,LF,'ADDRESS ERROR'>
	JMP	EDIT1		;ADDRESS ERROR ON EDIT
;
HEXERR:	PRINT	<CR,LF,'  ERROR - HEX INPUT ONLY',CR,LF>
	JMP	PTX
;
MONITOR: PRINT	CRLF,$
	LDA	DRVNO		;RESTORE LOGGED DRIVE NO
	MOV	E,A
	DISKIO	LOGIN
	LHLD	OLDSTK
	SPHL			;RESET OLD STACK POINTER
	RET
;
;
;   DATA ALLOCATIONS
;
FCB	EQU	5CH	CTED ENDING SECTOR
TNUM:	DB	0		;TRACK NO FOR VALIDATE
SNUM:	DB	0		;SECTOR NO FOR VALIDATE
VALFLG:	DB	0		;VALIDATION ERROR FLAG
G:	DB	0		;CPM GROUP NO
S:	DB	0		;SECTOR NO WITHIN GROUP G
COUNT:	DB	0		;COUNT OF DIRECTORY ENTRIES
OLDSTK:	DW	0		;STORAGE FOR OLD STACK POINTER
ENDSTK:	DS	24		;STORAGE FOR NEW STACK
NEWSTK:	DW	0		;NEW STACK
INB:	DW	0		;STORES POINTER TO INPUT BUFFER AREA
OUTB:	DW	0		;STORES POINTER TO DIRECTORY BUFFER AREA
TABLE:	DB	01H		;SECTOR LOOK UP TABLE
	DB	07H
	DB	0DH
	DB	13H

	ENDM
;
BBS:	MACRO
	DB 002H
	ENDM
;
LCR:	MACRO
	DB 003H
	ENDM
;
OR4:	MACRO
	DB 004H
	ENDM
;
OR5:	MACRO
	DB 005H
	ENDM
;
AN6:	MACRO
	DB 006H
	ENDM
;
AN7:	MACRO
	DB 007H
	ENDM
;
DB0:	MACRO
	DB 008H
	ENDM
;
DB1:	MACRO
	DB 009H
	ENDM
;
SB0:	MACRO
	DB 00AH
	ENDM
;
SB1:	MACRO
	DB 00BH
	ENDM
;
EIN:	MACRO
	DB 00CH
	ENDM
;
DIN:	MACRO
	DB 00DH
	ENDM
;
RPM:	MACRO
	DB 00EH
	ENDM
;
JCN:	MACRO CCODE, ADDR
	DB 10H+CCODE, (ADDR) AND 0FFH
	ENDM
;
FIM:	MACRO REG, DAT	MACRO REG
	DB 0A0H+REG
	ENDM
;
XCH:	MACRO REG
	DB 0B0H+REG
	ENDM
;
BBL:	MACRO DATA
	DB 0C0H+DATA
	ENDM
;
LDM:	MACRO DATA
	DB 0D0H+DATA
	ENDM
;
WRM:	MACRO
	DB 0E0H
	ENDM
;
WMP:	MACRO
	DB 0E1H
	ENDM
;
WRR:	MACRO
	DB 0E2H
	ENDM
;
WPM:	MACRO
	DB 0E3H
	ENDM
;
WR0:	MACRO
	DB 0E4H
	ENDM
;
WR1:	MACRO
	DB 0E5H
	ENDM
;
WR2:	MACRO
	DB 0E6H
	ENDM
;
WR3:	MACRO
	DB 0E7H
	ENDM
;
SBM:	MACRO
	DB 0E8H
	ENDM
;
RDM:	MACRO
	DB 0E9H
	ENDM
;
RDR:	MACRO
	DB 0EAH
	ENDM
;
ADM:	MACRO
	DB 0EBH
	ENDM
;
RD0:	MACRO
	DB 0ECH
	ENDM
;
RD1:	MACRO
	DB 0EDH
	ENDM
;
RD2:	MACRO
	DB 0EEH
	ENDM
;
RD3:	MACRO
	DB 0EFH
	ENDM
;
CLB:	MACRO
	DB 0F0H
	ENDM
;
CLC:	MACRO
	DB 0F1H
	ENDM
;
IAC:	MACRO
	DB 0F2H
	ENDM
;
CMC4:	MACRO
	DB 0F3H
	ENDM
;
CMA4:	MACRO
	DB 0F4H
	ENDM
;
RAL4:	MACRO
	DB 0F5H
	ENDM
;
RAR4:	MACRO
	DB 0F6H
	ENDM
;
TCC:	MACRO
	DB 0F7H
	ENDM
;
DAC:	MACRO
	DB 0F8H
	ENDM
;
TCS:	MACRO
	DB 0F9H
	ENDM
;
STC4:	MACRO
	DB 0FAH
	ENDM;
;		EXTENDED OPCODE LIBRARY
;
;
;REGISTER INDEXED ADDRESS
RXAD	MACRO	REGPR,BSADD	;(HL)<-REGPR+BSADD
	LXI	H,BSADD
	DAD	REGPR
	ENDM
;
;REGISTER INDEXED LOAD
RXLD	MACRO	REG,REGPR,BSADD	;REG<-(REGPR+BSADD)
	RXAD	REGPR,BSADD
	MOV	REG,M
	ENDM
;
;REGISTER INDEXED STORE
RXST	MACRO	REG,REGPR,BSADD	;(REGPR+BSADD)<-REG
	RXAD	REGPR,BSADD
	MOV	M,REG
	ENDM
;
;REGISTER DIRECT LOAD
RDLD	MACRO	REG,ADDR	;REG<-(ADDR)
	LXI	H,ADDR
	MOV	REG,M
	ENDM
;
;REGISTER DIRECT STORE
RDST	MACRO	REG,ADDR
	LXI	 REG 0, THEN JUMP TO LABEL
JZR	MACRO	REG,LABEL
	CMP	REG
	JZ	LABEL
	ENDM
;
;(DE) STORED AT ADDRESS IN (HL)
STDM	MACRO
	MOV	M,E
	INX	H
	MOV	M,D
	ENDM
;
;SAVE ALL REGISTERS
SAVE	MACRO
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	ENDM
;
;RESTORE ALL REGISTERS
UNSAVE	MACRO
	POP	H
	POP	D
	POP	B
	POP	PSW
	ENDM
;
;MOVE 'C' BYTES FROM (HL) TO (DE)
MOVE	MACRO	FROM,TO,NBYTES
	LOCAL	MO1
	MVI	C,NBYTES
	LXI	H,FROM
	LXI	D,TO
MO1:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MO1
	ENDM
;
;FILL T AMT BITS INDEXED IN REG
SHLV	MACRO	REG,AMT
	LOCAL	SH1
	MVI	REG,AMT
SH1:	RLC
	ANI	0FEH
	DCR	REG
	JNZ	SH1
	ENDM
;
* +e$"H"J "@go"22! "{?No Start Addres ?Loading Erro ?Fatal Table Collisio !@o!Ou!͔2 *
͸2r,
/r͞MªG@R SUE *͑  O2 Hr2G:2͞Ì"z2Č2 V!~w:~w*:

**yȷ*J~@*P"J***~
::}G@ex xn?Command Erro ~	#Ô~# ʞ
ʞ`ڳ 
+! ~G#~ ;x+#~0>*	
: >
	:;!<o> 
;
DAA4:	MACRO
	DB 0FBH
	ENDM
;
KBP:	MACRO
	DB 0FCH
	ENDM
;
DCL:	MACRO
	DB 0FDH
	ENDM
;
H,ADDR
	MOV	M,REG
	ENDM
;
;REGISTER INDIRECT LOAD
LIND	MACRO	REG,ADDR	;REG<-((ADDR))
	LHLD	ADDR
	MOV	REG,M
	ENDM
;
;REGISTER STORE INDIRECT
SIND	MACRO	REG,ADDR	;((ADDR))<-REG
	LHLD	ADDR
	MOV	M,REG
	ENDM
;
;ADD TO ACCUMULATOR INDIRECT
ADDI	MACRO	ADDR	;A<-A+((ADDR))
	LHLD	ADDR
	ADD	M
	ENDM
;
;SUBTRACT FROM ACCUMULATOR INDIRECT
SUBI	MACRO	ADDR	;A<-A-((ADDR))
	LHLD	ADDR
	SUB	M
	ENDM
;
;IF REG NOT 0, THEN JUMP TO LABEL
JNZR	MACRO	REG,LABEL
	XRA	A
	CMP	REG
	JNZ	LABEL
	ENDM
;
;IFREGION FROM (HL) TO (DE) WITH CHAR
FILL	MACRO	FROM,TO,CHAR
	LOCAL	FI1
	LXI	H,FROM
	LXI	D,TO
FI1:	MVI	A,CHAR
	MOV	M,A
	INX	H
	MOV	A,L
	CMP	E
	JNZ	FI1
	MOV	A,H
	CMP	D
	JNZ	FI1
	ENDM
;
;SHIFT ACCUMULATOR 1 BIT TO RIGHT
SHRT	MACRO
	RRC
	ANI	7FH
	ENDM
;
;SHIFT ACCUMULATOR 1 BIT TO LEFT
SHLT	MACRO
	RLC
	ANI	0FEH
	ENDM
;
;SHIFT ACCUMULATOR RIGHT AMT BITS INDEXED IN REG
SHRV	MACRO	REG,AMT
	LOCAL	SH1
	MVI	REG,AMT
SH1:	RRC
	ANI	7FH
	DCR	REG
	JNZ	SH1
	ENDM
;
;SHIFT ACCUMULATOR LEFg6
>	_ ! o?File Not Foun >
	>
	P/E
LIB/S
                                                                       >2!w#!2w! <>2
:_ <2!~  <f	o p                                                                                                                  *|!.u͑!͔0[BEGIN EXECUTION :ʸ!~#¡͌*2>[	">2͡*"͡ | >]	0FORLIB  REL	
x:	7*H*J͛ʩ
~G;~@/2:`~> H>/	+^+V+~	M/	~@k>*2	͡~+^+V͡0~<</O	|}:)0	)
µ0	²|}Gx0:	go":2":*@">*"
"
"<{_zW{_#"B"D>2729"


9Q-B- !
		~#foBK:7ʒ#:9=ʕ*<|r|w}|"<*B|}3

p#p#*D|ʣҭ¨}ҭ"D*>|ʻ҉}҉*BDMÉ:7:8=>͎

w+p+q#BX++ssobal ů~++6	#N+F@L	:7^	PYOG#	|})|):7^	#q+p):7ʷ̓	ͮ	)̓	>͎
:8=q	>w+r+s+6+r+s):8=	26	|ʧ	͐^#Vͬқ		:8=26	͐~s#_~rWͬҼ	:9=*B	DM*>"F!
~#4	ʹ6+w 	xG
	ɯ28	
	7	'
z
	@
i
	z

i
	!
wV
4#6 _h
	w#Z
! u
"
O<28	X	P̝
O !
	N#F	:7ʩ
)
)ff	ff

:7
͔*")>f+^+V"
):829=)
*D͛"B 
z
{
`i"D*<*B͛l*D*<DM*Bʹ
͛{OzG*<	"Da
DM*Br
`i"B*D*>͛l||
}r
*B͛3
/O*>	">*D͛ڰ
*B	DM:9=yoxg"::9=
*:!  ":

*B{OzGDM7   2~2~2~$DTBF7 e$>             REL   ulmnopqrstuvwxyz t        2~oo2~2~co                                                   
Ñ[=*6<D:R*{6<2>@*y6<=>>>:)?>>>>>:)?>>>>D:
>>>{>>>>z>>>>% & ' ( ) * + , - . / : ; < = > ? @ [ \ ] _ { | } \ 	 ^ ^ ! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \ ] _ { | }  	 ! !       *
j*`i
jd*W~7++V+^6<:*ʰ:a*]J\+DM*p:a=ȯgoɯ!6<:7:a*]:Ko& *":ʱ*
Ҙ:N9<=J:=!+~w2*"*fX±~xX~xX++++:G~xX~xX++V+^*
xX###*W":2!Q"*" *W"_ã::=2:tt**""t:*6<*"
`ir+s*1*p"1"p>2aP"p"11¹~#d<2͵P>?N>%͇P!:g*[H,m!d o 'i f 'e l s e 'w h i l e 'b r e a k 'n e x t 'f o r 'r e p e a t 'u n t i l '('('('('('('('('('  !Q?~#͇   	 
     #|+*
89<G:C*w:+w*+r+s+"W+~2G+~*####
ʹ2oɷ222Dgo"6ͯ=::*JX:Wʰ6?ä!:H"*#"@A	">2=22X
*"*GXL>0L*"L>2Ҩ S:#r#͌:7> ͞C?@2Ԍx)<͞0>
M6 #=Ey .̌xer͞fʇ!~ 6R#6E#6Ly ͞[Ҫ0ڪAҦ:ҪÏO:7|)~_q#Vp¼)̓	:9=>͎
:8=><w+r+s+
<w+p+q)ͫ	)>/o/g	L)~@wq+p*
}|	"
"*<	"<͛DMr
́
&!r͔a>/	0)~W+++~	+h%2nd COMMON Larger  *
	""<͔&Vz"ɯ~@~@w+:7~_q+:8=½>͎
6+p+q+6+r+s)!͔a0)%Mult. Def. Gl:7)*B	)*H*J|G}`~OM
MA+++L+;~Ty/O	
Ow+w+w+w+
pw+w+"J7.m:7ȯ27*B*<"
͛ʳ3
*@*>|}~_ +!^#V+++÷V+^+*
N#F	r+sV+^++F+N+"F*
	26͐~s#_~rWͬV+^++F+N+"F՟26͐U͐r+s^#VͬMFr#Nsp+qF+N++V+^+*
	DM~_q+Vp~_q#Ä:6DM*B	*
{OzG*@*Fù##|}#y·#x¸#~¹:6~@w"F26}7>26*<DM*Bʹ*"]>2a=2!ͫE*w*WDM!"w*"xHw#x="!  "*y6<:=*{6<>2>@>>*y6<:<)?>:=ʴ>@>G>*y6<>2D>>>x>:=*y6<͠E>>*{6<>2=@>*]|:4>2P>
L*0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 a b c d e f g h i j k l m n o p q r s t u v w x y z a b c d e f g h i j k l m n o p q r s t u v w x y z A B C D E F G H I J K L M N O P Q R S T U V W X Y Z A B C D E F G H I J K L M N O P Q R S T U V W X Y Z ! " # $ *6<:=.=9=]=j=w*>"2"**$!  "*DM*>"*+"|'?**W$**s
$*"|*"! "N*|!  $4$:NS2ʹ?\!  "i!!  "):3$:!  4Ϳ<͹	")*"*]*)W"+*|0*
<*+|4::,ʸO:
ì*":a2-:a=*+*]"]:-ʿ2aP1*++++F+N*ps#r`i"pP*)*]"/*p"1**
:-=«4>2-*"6<!  "+*]*/W"]|4*+*/W"/J\*]*1+~+DM~+ng::
ʘ4vB`42D	~~2D~:F\<2-*|\͠S6go"-4w*+"|:ʑ=2O͠:O\NS*|\NS4f::(,)4:͜L2>2!4M::(!D454:=~!  "S:~~4x*"#"S2D~͙

*p6<*W|*|6<V4h!  "]*"]Pʹ?\*JX::6?^|::::HXP(OEFAIGL*GX4~͆-',/)â=^P͆>.A\͆>U>26:</>'6?<2o6?:<x'6?<4Ggoʹ6?OT])))0_ by^4*"*GXʹ>$^!  "
H\!:*"""$G2
:>Ĳ@$
H>>>2::,:$

H2go9"1ʹ>(A\\!:6͆Z*$
 	:\ͼ$D:^
2GC͐	:s0zͯP*,!)?*1+V+^+6<:s0¦ͯP*,!͢,E=g*1:
2;<$4~	D	DB2OA2 !:T"!>	~4Ag:<Ao">2>222,'y:=!L'y *ʹѯ4{(       u     )!S!~w2Ao7:>'A\ô$:=4m>!S6 #=ɯ2;<$ͣ4iͯ2:ɯ222og""
2ʹOG:2<2>2y.k:y'2=2>2:¢:y+ʜ-ʜxڑyZ-XZʹ'W0*|*"2<2<2Ñ2o!6yIkOk5>2!yʘw+ʹv$v>2L>:4u2:2:2oÑ!6!4:8!-
::02!!>2x? ::E>2.:W4h
X!~w+
!!w#!!~w#/!$>)!)!!)!!~w+O!
I!̓$:4͙w!:a4o$ͮE*O"'"%"!  ::,!^!̓$!ͯ::=!2$>goͮE!:ͦ$*ͮE::,">a!x"!|{"̓$"%!̓$"'!*'ͫE*%ͫE*DMyE+"
͐	2!|2'"""%O::,P"ʹE"
"|r"4
r"*%#|o"4t
HDN͐	
4s>2oͣ">(A\**Wxʰ"~w++++Ü"*%"**W"%>Ä""="4s::=ʉ# #::,ʄ"*%#|#b"::(%j*$!%>͏jyq! "$*$)++"$*$"$*$F*$s#r*$*$~#fo}2$p%*$)++*$"$!'*$s#r*$#>> %! *$"$!'*$s#r! "$*$~#fo}2$ʹ%!'"$*$  	  ncorrect Num"%!  "%*%~#fo}/2%%*%! "%*%)++*%~#fo}2%U&*%)++*%"%*%c++}2%K&*%*%#"%%! "%ral String is too largInvalid Data List Element in I/Unbalanced DO NesIdentifier Too LonIllegal OperatoMismatched ParenthesiConsecutive OperatorImproper Subs')*'#"'.)*_&}/2'.)*'+"'!a&gS*'}=2'](*'}2'a)!(Oc MMON Base LowereILLEGAL BREAK.$ILLEGAL NEXT.$"e)"g)>!i)ͫx*e)~#fo"m)*m)}=/2o)**m))++*g)"p)~#fo}2o)*p)~#fo}2r)*p)~#fo}2s)*p)~#fo}!s)!r)!o)/2t)**k)~#fo}/2o)p**m))++*i)~#fo#"p)!p)?QÄ**m))++*i)"p)*p)?Q*m)+"m)ë)*k)~#fo}/2o)´*!u)Ocú*!)Oceme"***~#fo#qNo Path to0 1 2 3 4 5 6 7 8 9 ' Do "*"***~#fo)>2aP!N#F͐	+
!ʹ
1w+ʹ:s0	͇P!+~)?KPʑ$!+
ʹw+i::
?\ *"7͙"]##>2aP::,ʉ"O25:o:: ʾa{ 2:A[0:<7=::G!o~6 x!L!^4! ~
2::>/OC!!6
C:P4*3$>2>2:2a2*"*"*"*""P6<>2P9<>eʹ!5:ʸ4<2[5
H]Q\!*":\\!*":\\!*"$:=%!L
 - + 2o:ʹQʹ.>	22
YU      |":-*>":ʑ2o>Ôʹ? >2:<2o::Ne>a!h!m>22>2=2<2ʹÑʹ.ʵx.yH2>2=2*}*|":-4mÔ!4ʹ!~w::0wʹ :!~H /<!2!~###ʑ>2:x !5!)!d !~  5!$>!!!!>wd 4!$>!!$>>G!!=² !!!d -
>2! >2!4*":-?:o:g"X~#:ax#Ϳ<:G:x#O!p#*:*"b#>2*M#yD#"mb  my*D#A#*"2'#!'6"J\"͜L!'6"*%#|#4t
*"DM*%*W++Vp+^q"%>O!'6":'#:2'*""$2'>6<>!#*"
##:'RATFOR TRANSLATOR - VER 1.0$ $INPUT FILENAME: $RATOUTPUT FILENAME: $FOR** END OF INPUT **$!
$5a!&$5a!($5a!#$}29$q$:$#!$N"#!=$5a!#$}29$$O$#!$N"#+X!R$5a~  =4%%(9A1)2;2"$$$!cript SyntaIllegal Integer QuantitIllegal Hollerith ConstuctioBackwards DO referencIllegal Statement Function NamIllegal Character for SyntaStatement is out of SequencMissing Integer QuantitInvalid Logical OperatoIllegal Item in Type DMISSING LEFT PAREN.$EndMISSING PARENTHESIS IN CONDITION.$b)!a&@?}2'Q(!'Oc!a&gS! "'b)!a&@?"_&}2'*_&}2(*_&}2	(*_&}!	(!(!'/2
((!a&r[H)*_&}/2'(!'"a&.)*_&}/2++**"*~#fo}2***~#fo}!*/2*P+**~#fo#**s#r*!  "***~#fo)++**~#fo}2*+**~#fo)++**"***!*vE"*}/2*°++**!
 tj+**"***~#fo#**s#rV+**,|+}+G:r0",x+x+0:ڇPÇP,)))+
,`,*+>'͇P*+>"5,,>N#F#	d,<33Y,O=w,w,yR,7y+Q,+> ͇P>(͇PH,>)ÇPͅP:*,**]*6<+-*]W|>+,>-͇P>+6<:>/̇P=->[͇P:O/_!ͅP~+#
 ->]͇P-+->/̇P>L̇P:O!~͇P+
2-
 *W?*w!\
W-4:bm-*|%.4%.*||-:;+b."+"+`i"+*+DM*+*+@"t-*t-}2x-=.*t-}2x--=.+*+@M}/2x--=.*+}/2x-".*+"}-y-*+*+(=+*+G(.!+r[*+DM*+*+@"t-Ý-*t-"+}/2x-^.*+m.*+ ͵P\L."e.! "g.*g.)++*e.~#fo}2i./*g.)++*e."j.~#fo}=Ɓ2i.*j.~#fo}?!i./2l..*g.)++*e."j.~#fo  *j.s#r*g.#"g.cdef        NEWRAT  BAK   FORLIB  REL   ulmnopqrstuvwxyz NEWRAT  BAK  @	   
 Ɉ(Hѐp ꪉʩ52  etT9  STetU1 `h  * #`0 f @(d#F 2zztl                                                                                                                                                      UNEXPECTED BRACE OR EOF.$UNBALANCED PARENTHESES.$!  "~2:4!0@?"0}22*0}!2/222 4*0}5ai        RETURN
       END
C
C WHILES - GENERATE CODE FOR END OF WHILE
C
       SUBROUTINE WHILES(LAB)
       INTEGER LAB
       CALL OUTGO(LAB)
       CALL OUTCON(LAB+1)
       RETURN
       END
PB:RF.REL,=B:NEWRAT
                                                            6?COMMAND ERRO ?FILE NOT FOUN ?CAN'T ENTER FIL ~w9#u6!D6Ð6!S6Ð6!c6u6ñ6"0* +++"i0*0:q0 i f ( . n o t . '6MISSING LEFT PAREN.$6INVALID FOR CLAUSE.$ 6"
5!9J*
5s#r6®99!5@?"5}/2609*6#"6O9*5}/26O9*6+"6*5}26*5}26*6}?!6!6/26«969!5a!5J*6"68*
5~#fo#*
5s#r     ( ) n090"9*9S! "9! "9*9*{ozg}/29,:*9)"9*9J#*9"9*9#"99*9)"9*9J}=/29f:}T*9)"9*9gSP*9~#fo+"9!9?Q*9~#fo#"9!9ͼP*+";>;*110:1 0e::p0ʬ7:u0q:>r;*00u0:0 u0e:|}:ƀ)`iF;>
NITION TOO LONG.$MISSING RIGHT PAREN.$"<"<>!<ͫx*<!<`N}2<[=!<5a*<DM*<*<@}2<=!<5aë=*<!<`N}2<«=!<5a!  "<! "<*<}2<>*<*<~#fo{ozg}=/2<=!<4Ä>*<)++*<"=*<*=`N}/2<+>!=4Ä>*<)++*<~#fo}/2<Y>*<#"<Ä>*<)++*<~#fo}/2<>*<+"<*<#"<÷=*<)*<"=!'*=s#rW4>_::.o>ʹ.o>à>ʹ* o>2oo>!  >))>	=>ɯogG:i n c l u v.\.>d o   '"/}T!	/gS!7/J*/s#r*/Sͳ2P !0":/*:/ͼP*:/~#fo#"</!</ͼPm/*
6<  W?   W?*Y|?Gw/
Program Unit Length Bytes
Data Area Length Bytes

Subroutines Referenced:


Variables:


COMMON	Length


LABELS:

 Warning(s) Issued
 Fatal Error(s) Detected
:a=*]b0<2+**p6<͢,6<>+͇P+ͅP?,@       RF      REL  =_`abcdef        = NEWRAT  PRN                     NEWRAT  FOR               DEWRAT  FORREPR  RF      REL  =_`ab/223!0r[ 4*0}22*0}!2/22S3!2Oc!0r[ 4*0}22*0}!2/223:4!\/@?}22¥3!\/r[*0}/223!'"04*0}/223*~2#"~24*0}/224*~2+"~2!0gS*~2}/22¹2*~2}2294!2Oc    "=4*=4~#fo#"?4!?4?Q*=4ͼP           "_4"a4! "c4*c4)++"e4*_4"g4*e4*a4"i4*g4~#fo*i4~#fo{ozg}/2k44*c4)++*_4~#fo}/2k44! "]4*c4#"c4y4!  "]4LL "4*4!9ͼP9!5@?}26*7!6Oc9!5@?}26V7!5r[}Tͳ2P9!5@?}/26}7*
5ͼPÄ8!5r[*
5S}T!6gS!9$P!  "6*6}26M89!5@?"5}/267M8*5}/267*6#"68*5}/268*6+"6*5}26*5}!6/26J8!5gSÞ7!9$P!9$P*
5~#fo##"6!6?Q*6}/268!6Oc*#"! "6! "6*6*{ozg}/268*6)"6*6J#*6"6*6#"6×8*6)"6!'*6s#r!  "6*6}2;>
;>;:n0ʬ7:0<v9;*1|>;#"11
 Q 1!<<(80A1)":":*=;):"?;*=;}?2A;*?;~#fo}!A;/2B;n<C;G;*:j! ";;*;;):"?;*?;!<>͏j*;;#>P> ;yq! ";;*;;}=2A;<*;;):"?;*?;F*?;s#r*;;#";;;!P ";;*;;}=/2A;S<*;;):~#fo}2A;I<S<*;;+";;<*;;):"?;!
 *?;s#r!  "=;*=;#"=;):~#fo*:s#r":͐i!'*:s#r!'":   2+V+^"]:<<2MISSING LEFT PAREN.$NON-ALPHANUMERIC NAME.$MISSING COMMA IN DEFINE.$DEFId e 'x#INCLUDES NESTED TOO DEEPLY.$RAT?G:sCAN'T OPEN INCLUDE.$">">*}=/2?@*)"?*?DM*>*>-">*>}2?b@>*>l4}/2?®?*>*)"?*?DM@!>-">*}2??!	?OcB@*)"?"(?%?>*(?N">*?"*?! **?s#r*>}/2?;@!,?OcB@*#"*)"?*?DM*>*>-">y?*+}=/2?@*)"?*?;**+"G?!'"> O	~)?=#¢@>TOKEN TOO LONG.$MISSING QUOTE.$>>"@"@`i"@*@!@`N}2@5A*@}2@*@}!@/2@2A5A@!@[! "@*@~#fo+"@*@*@{ozg}/2@A*@)++*@"@*@*@`N"@!@c"@++}2@*@+}!@/2@·AA*@#"@AA*@~#fo+"@*@*@{ozg}2@A!@Oc*@+}=/2@9B*@)++*@"@*@[*@)++*@"@!'*@s#r!t'"@D*@~#fo}/2@B! *@"@*@*@`N}/2@B!{ *@s#r!{ "@B! *@~#fo}/2@B!} *@s#r!} "@B! *@"@*@[D*@~#fo}2@*@~#fo}*)"@~#fo#*@s#r*@
 1E͠E"E!9EJ*Es#r*EPE :ai f ( . n o t . '"<E}T!>EgS-(!lE$P*<E?Q) ʆE:"qE"sE! "oE*oE)++*qE~#fo}2uEE*oE)++*qE~#fo*sE~#fo{ozg}/2uEE*oE*oE#"oEÃE!  "oEd e f i n e '''E!EGF*|"	F*	F~#fo*|{ozg}/2
F<F*~"F! "F*F)"F*	F~#fo*F~#fo{ozg}/2
FF*F)~#fo"F*F#>
> ?F! "F*F)&"F*	F~#fo*F~#fo{ozg}/2
FF*F)Z~#fo"F*F#>> F! "F*F)"F*	F~#fo*F)H~#fo*Hs#r*H!
 %j"H*H*H~#fo{ozg}?2H*H}!H/2HH*H*H~#fo{ozg}2H*H~#fo}!H/2H¥I*H#"H)++*H"H!- *Hs#r*H+"H! "H*H*H{ozg}/2H#J*H)++*H"H~#fo"H*H)++"H*H~#fo*Hs#r*H*H"H*H*Hs#r*H+"H*H#"HòI*H
 :a|WARNING: POSSIBLE LABEL CONFLICT.$"*J**JJ}/2.J²J! **J~#fo}2.J**J~#fo}!.J/2/J²J!0JOc**JgS}T*Y"J*J"J*J*J~#fo"J*JxX"J!  "J*J)*J~#fo}l4+}/2(KM*"K#M!("K*K ry!7<M:\úLRN",M".M* "0M*0M}=/26MKN*0M)~#fo"2M! "4M*4M)++*,M"7M*2M)"9M*7M~#fo}26M*7M~#fo*9M~#fo{ozg}!6M/2;MM*2M#"2M*4M#"4MwM*4M)++*,M"7M*2M)"9M*7M~#fo*9M~#fo{ozg}/26MAN*2M#"7M*.M"<M<M7M!a! "*M*0M+"0MMM!  "*M *p22"WN"YN*}=/2]NN*)~#fo*WNs#rñN! ")"^N*YN*WNM;*^Ns#r*+"*WN~#fo"UN">2͈O*" >'͈O"N"N`i"N>2N:NNog"N:!
 *Ps#r*PP#"P!'*Ps#r.Q!N#]!  "L# wg o t o   '"1Q}T!3QgS*1QSP++r+s:"XQ*XQ~#fo*~{ozg}/2\QQ*|"VQ! "ZQ*ZQ)"]Q*XQ~#fo*]Q~#fo{ozg}/2\QQ*ZQ)~#fo"VQ*ZQ#>
> Q! "ZQ*ZQ)Z"]Q*XQ~#fo*]Q~#fo{ozg}/2\Q&R*ZQ)&~#fo"VQ*ZQ#>> Q! "ZQ*ZQ)"]Q*XQ~#fo*]Q~#fo{ozg}/2\QzR*ZQ)~#fo"VQ*ZQ#>> 6R! "ZQ*ZQ)8"]Q*XQ~#fo*]Q~#fo{ozg}/2\QR*ZQ)~#fo"VQ*ZQ#>!> R*XQ~#fo"VQ"/J\W:9S*-W!@/2@C! "@*@)++*@"@*@*@`N*@~#fo{ozg}2@C*@)++*@"@*@~#fo+"@*@*@{ozg}?2@*@~#fo}!@/2@C!@Oc*@)++*@"@*@~#fo*@s#r!E[C*@#"@CD*@~#fo}/2@D*@*@`N}2@DC!
 "@D*@~#fo}2@*@~#fo}2@*@~#fo}2@*@~#fo}2@*@~#fo}2@*@~#fo}!@!@!@!@!@/2@D*@DM@*@Ͳ^*@)*@"@!'*@s#r*@~#fo}/2@E~#fo{ozg}/2
F+G*F)~#fo"F*F#>> F! "F*F)"F*	F~#fo*F~#fo{ozg}/2
FG*F)8~#fo"F*F#>!> ;G*	F~#fo"F>>i>G>"ͫ: TOO MANY DEFINITIONS.$TA͐GG"G"G*GJ#"G*GJ#"G* 8}?2G**G*G$}=!G/2G,HH*G]!G5a* #" )"G*#"G*Gs#rG~H*Ga*#*G"GG~H*Ga**G*G"  9J]QH
H>>0 1 2 3 4 5 6 7 8 9 ')?=¿H>"H"H`i"H*HLj"H!'*Hs#r! "H*H#"H'J!H͓i"H*H)++*H"H*H2JK*J#"JJ*J2>2aPK" K'M* K@?}/2(KPK/K* K~#fo"K}2(K*K}2)K*K}2*K*K}!*K!)K!(K/2+K¸K*K* K%+}/2(KK!("K#Mr* Kl4+}/2(KK*"K#Mx* Kl4+}/2(K!L*"K#M* Kl4+}/2(KEL*"K#Ml* Kl4+}/2(KiL*"K#M* Kl4+}/2(KL*"K#M* Kl4+}/2(K±L*"K#M* Kl4+}/2(KL*"K#M* Kl4+}/2(KL*"K#M* KN*Nw:N<	N>2N:Nog)++*N"N:N=2N*N~#fo*N{ozg}!N2N¼O:NNog"N:Nog)++*N~#fo}*Nw*N~a2N*N~z=!N2N²O:NNog"N~ *Nw:N<2NO>2N:N2NNog"N:Nog!*N~*Nw:N<OPN*N,|!  "N  ;)"P}T*PgSͳ2PͅP0P"P*L#}2!PPP! "P*P}/2!P|P*P)L#""P!  *"Ps#r*P#"PFP!* "X#! "L#*L##"L#)L#""P*P~#fo*"Ps#r«Pc o n t i n u e '
"P*P~#fo}=/2PP*PS}T!PgSPɡ
*L#)"PN#"P|S"RXSR*RͷH"S! "R*R*S{ozg}=2SWS*R)R"S*S$P*R#"RS
 2y *"[S! "_S*_S)++*[S~#fo}2cSxT*_S)++*[S~#fo"]S}2cS*]S}!cS/2dSS!]S$PnT*_S#"_S"aS*aS)++*[S~#fo*]S{ozg}2cST*aS#"aSS*aS*_S{ozg"eS!eSS!yT$P*_S*aS{ozg}/2cSnT*_S)++*[S"eS*eS$P*_S#"_S3T*_S#"_SpSh *L#}/2|TT!T$P}T  ++"*kb####\	*
ҩTWWxS!~wÑS*":U*":W*"V2*"*kb 	\	*
U*:G*~w#:w#s#rýT:CU>2:ʒT!>w=ʒT**
ڒT2tU!:wÒT(WÒT**WڦU~
ڦUҦU!O 	F~wÛT(W:2:V*">22:=ÒT*####~wÛT:2*"2:=V:KV:VWͯW!4*####"*++++
1VͣV:!U*":DVͣV8T2$V***
^V>V
VUWWx2y2*~22##^#V*"
6<=:<2*####"kV!
$  !&$ !($
 !#  }29$ :$#!    "#!=$ !# }W}/2W Y!TRJsY*W}/2WsY*W)V~#fo}/2WmY*W)3V"W*WA4sY!WOc*W}2W*W}2W*W}2W*W}2W*W}2W*W}2W*W}2W*W}!W!W!W!W!W!W!W/2W~Z*W#"W}=/2WOZ!W4*W)"WV"W*W*Ws#r*W3V"W*3V*Ws#rA[*W}/2WZ*W)V~#fo}/2WZ*W+"WZ!WOc&[*W}/2WZ!T	P&[*W}2W*}?!\/2\}]*\}=2\;]\\*\jyqw]\\*\j! "\*\)\"\*\!]>͏j*\#*\{zJ]yq!  "\*\~#fo}2\´]*\#"\)\"\*\_Q*\s#r   !0  *~2}"]"]*]! ^\! "]*])++*]~#fo}2]^*])++*]"]*]*]\*]#"]]  TP
       . g e . '. g t . '. l t . '. l e . '. n e . '. n o t . '. e q . '. a n d . '. o r . 'G(26)aINaIGa6)aEXaHRa3)aINaHRa"#^"%^`i"'^! *#^"^*'^*^`N}2^^! *#^"^*^[*#^~#fo"^!'*^s#r*#^J*%^s#r 6#"6$aa)(1X,100A1)"a>2"a:"a2!a:"aog!*a~!#a2$ala:"a<e:a:!a=2!a%a+a!aj>2"a:"aog!*a")a*)a!a>͛j:"a!!a<ځayq    {oz"a!aͼP!aJ*as#r*aͼP*a~#fo#*as#r   9 *9)"9"a"a>!aͫx*a~#fo"a*a~#fo"a*a)++*a~#fo}2ayb*a)++*a"a*a)++*a~#fo*as#r*a#"a*a#"a!b*a)++*a"a!'*as#r2A;  *;;):"?;*?;  *?;s#r*;;#";;Ä !P ";;*;;}=/2A;  *;;):~#fo}2A;   *;;+/2de1g*d~#fo)++*d"d*d~#fo}2d*d~#fo}!d/2d]e1g*d~#fo)++*d~#fo}/2d e*d~#fo)++*d"d*dͼPg*d~#fo)++*d~#fo}/2df*d~#fo++}=/2de*d~#fo+*ds#r*d~#fo)++*d~#fo#"d!dͼPg*d~#fo)++*d~#fo}/2dUf*d~#fo)++*d"d*d>/g*d~#fo)++*d~#fo}/2df*d~#fo)++*d"d*duig*d~#fo)++*d~#fo}/2df*d~#fo)++*d"d*d9g*d~#fo)++*d~#fo}/2d29$  O$#!  6 "#  !R$? 2"$$$!    *$!  >    ! "$*$)++"$*$"$*$  *$s#r*$*$~#fo}2$  *$)++*$"$!"%!  "%*%~#fo}/2%  *%! "%*%ILLEGAL ELSE.$}STACK OVERFLOW IN PARSER.2ILLEGAL RIGHT BRACE.$5VW5VWUNEXPECTED EOF.$E! "W!'"V!T,K"W*W}2WM[*W}/2W{X!3V"EsY*W}/2WX!3V/sY*W}/2W½X!3V>isY*W}/2WX!3V6sY*W}/2WX!3V;asY*W}!W/2W&[XV!W͒)!T,K"W!Tr[XV!Wͽd!T,K"WCX*W+}2Wg[!XOc+}"i[*i[J"m[*m[}=/2o[±[*m[)++*i["p[*p[[*m[+"m[~[ɺ[TOO MANY CHARACTERS PUSHED BACK.$"[*#"}=/2[[![4*)"[*[~#fo*[s#r)++*e."j.~#fo}=Ɓ2i.*"/  !	/  !    */s#r*":/*:/  *:/~#fo!  "~2  !0  "0}22*0}!2/22    *0}/22  !0     *]](/)]](80A1)"\"\*\~#fo}2\*\}/2^__! *#^~#fo}/2^J_*#^"^^a!-^a\_*#^"^^a!7^aa*#^~#fo}/2^_! *#^~#fo}/2^±_*#^"^^a!K^a_*#^"^^a!A^aa*#^~#fo}/2^-`! *#^~#fo}/2^`*#^"^^a!U^a*`*#^"^^a!_^aa*#^~#fo}/2^`! *#^~#fo}/2^`*#^"^^a!k^aÔ`! *#^"^!'*^s#ra*#^~#fo}/2^`*#^"^^a!u^aa*#^~#fo}/2^`*#^"^^a!^aa! *#^";; *;;"<"<>!<  *<!<  }2<  !<  *ERROR AT LINE.$"b!=c5a! "9c*9c*{ozg}=2Lc²cc!c\*9c)"Mccb*McͷH";cc!b]*9c#"9c^cc!c\c!c\*b5aQ  
   :  *<)++"c*c~#fo}=Ɓ2c*c~#fo}?!c/2c d! "cìd*c~#fo}=Ɓ2c*c~#fo}?!c/2cad! "cìd*c~#fo}=Ɓ2c*c~#fo}?!c/2c¢d! "cìd*c~#fo"c*c    *)"?"d"d>!dͫx*d~#fo+}=/2d1g*d~#fo)++*d~#fo}g*d~#fo)++*d"d*d*dh*d~#fo+*ds#rd!@/2@  ! "@"E!    *Es#"<E  !>E    !    *<E"qE"sE! "oE*oE)++*qE~#fo}2uE  *oE)++*qE~#fE!E  ɕoz"	F*	F~#fo*|{ozg}/2
F  *~"F! "F*F)"F*	F~#fo*F~#fo{ozg}/2
F  *F)~#fo"F*F#>
> / ! "F*F)&"F*	F~#fo*F~#fo{ozg}/2
F  *F)Z~#fo"F*"G"G*G  #"G*G #"G* 8}?2G**G*G$}=!"3g"5g*3gS*5g~#fo}/2hi!7g,K"h*3g~#fo+"h!hPE%i*3g~#fo+"h!h?Q*3g~#fo#"h!hͼP*H""8i!niͼP!liJ*8is#r*8iS*8i~#fo#"<i!<iPE   }"qi*qi?Q*qi~#fo#"si!siͼPVwz||%jXji> 2S~!PA"T~!US"V~!E "X~>
2?~>2!S~"=~vs:S~T~Z~~#ii> 2S~!ST"T~!OP"V~!  "X~>
2?~>2!S~"=~v~zHjzBXj|G||XjSxXj[v~#fo|XjɯO_yW!~/woG}_}W}O||DM!  >))Ҋj	=j>Þj>Þj>2~ͽxx~#fo"~x"6~*~":~:jkïj͗sïj[v>2~~#fo"~#+j!  "~!~>ͫx*~~#~|/W}/_*~"~:~otu:L~G:(mxx2K~͉l:7m2O~r:Xm0Sr!K~5im<Fm:K~imimqYmESr:M~!2M~m+Çm-/<2M~Sr:M~_ !
 Sx{0GSr}0GSr:~otu:L~G!M~:wm͉l2O~:L~2K~:M~m2O~!K~wr:M~/n*~"~!"~q!M~4m*~"~qn:~otu:M~m!L~/<mw!~~w2~!~w<2~ʹm22~>2~ SrSn*~*~DM*ͩn+|hn""~ot*~*~FSr*~#"~*+"|#not!~:@~O5n:?~n*=~ 	~2
!@~q>n> n:~Io:L~n[v*~|n[v:Tu*~|u!~~q>T>Fw> #w#w#wôk}2>
5q}2>5q}2>5qO!Aw:jj=_ ^#V 	^#V[qkq*~|wq[v*~|wq[v:!<~w8s:~>5q*~*~ |q©q²q»qejSXq  qch  |q{_zW}o|gq"~"~x!K~5q:~*Sr!~50Sr*P~F#"P~Sr!~~!!K~2~#rDr2K~/?r:-Sr!O~59r.Srq,r[v Sr!~5Dr#r:?~!@~nr^4 *=~p!~5rr[v:~:ot{s!~~4ʐr[v
*~"~*"~ot!x "~*~*~:~r~'rͩnw#ôr#~'ʺr"~ot~'rGSr*~#"~#r*~#"~#~'rot~yu:
.#us*~}2R~*~+"~{s[vXH(AILEFGv[nrckopooo7vnrkoqmmn:~G*6~~w#^u"6~*|ot{s!~~vx2<~w:~=ʝu=ʝu+>2>wóu++~u/W+~/_s#r>27԰w͎q!<~~wuuv÷uu*~*~vҷu"~"~!M~4/G[t"~"~+³u2<~go"~"~!M~4>5q*@~|,v,vot[v:?~ot Sr*+"|8vot:~G:~2M~~#O *=~::?~!~+"=~>2>2?~!v	^#V"~v2?~2"=~:~<2~~~IDF0MPIRFWITPRDOMLDZLGSQIBTLOBDEISBEINOVCNGLGSSNA2IODTBIRCEF!<~>w!M~5[t[t:5~<25~W:2~yd~#fo)++*d"d*d    *d~#          ~#fo}/2FORT DAT  j {zzhz[z[y=z!2y: _~!;y:_ ^#Vlyy@~:_ !(y6 !|"~xy! w#®yf| <y <[yly>w*!y: O	s#r! xyr+s6 #Qyw#y:G
1wx
z0#w> #w#Uyw# z ">wT]	6 ly[y6Nz{xyf| ly@=z͇y͇y[y {6*=~*?~& zw#Åz xy 7͇y[y6*=~ xy>2?~ ͇y[y {2Zy:?~*=~~6:?~>
̧{~+{1z>ͧ{{k!  "~*~~#k!  "~2~2	222~go"~":~*~|!S~"=~Oks*~"~(Zs[v2@~2?~<2:~>5qMv*~*~ͩnk
~k> ZUlgmk:M~/<kʙkZUl& =k2M~:~ʪk=ªkZ"~"~TuMv:M~kk Sr=k2M~:~GSr*~*~ZUl& "~"~k:~l:@~O:?~2
 *=~	*6~1ly2@~"6~:?~O >2
*6~*=~	1ly2?~l:~G:
=ql:~[l:
2?~>5q *=~1l>5q:?~2
*=~ 1lw#5l*:~+":~|1l<	ڑl>G>02A~!A~#v!M~4:~0w*~))))"~*~))))o"~l"~~:l
w+lw!A~|l}l!M~4#"P/g}/o#"~Tu>2<~!L~:N~&o:~&o:R~w~/<G:~x6o!2M~͎q:~Tu!<~~w:M~o*~*~{z _}W|o:<~ko<g}o:{o}o"~o!9oovͰw:~=ʠo=ʫo[v:~og"~2~>2~tu:M~͉l:M~2K~2O~ rͩn o>00o:o02
>ɯ2L~2N~p- p>2p+ppTu!@~5!~4͖p:
.-p>2N~2M~͖p:
nE =pp+Lp-Qp>2<~py2~!@~5!~4 opOx
tp[v>	G_p:<~xʉp/<2M~G!L~~wno*~O|pGT])))*~DM))	 )	"~& o"~!L~:M~wÖpͩn p:~2~poFpTo>2~ͩnpT:~=s!	4*~"~Ès2~ot*~+"~|ot*~"~!~4ot!<~6:~Rs:@~Ls<*=~6 2?~v:<~2@~:~qs>2?~ !S~p#=kss2@~ot!	~ʈsw×s*:~+":~|×s:	3s*|ot+":R~2L~22M~2<~go"~"~:~!~w:~s4*:~G*6~~~#s"6~s5q2<~go"~*~*~~# t-t<~
t"~2
G0;t
;t*~T])))_ s*~|Ft#x:<~Wto> g"~|x*~*~xLCZU͉xajSXs"t,ot/3s) s'ʟrPt:~2ot|t[v! "2~  !'ut#	´t[vyO!Bu:~t!0u	^#V"yt*~"~>x2~st[v}2~2R"~{ozg"~*w[vJ!qx!4wF#~怩Oyw4w|||||^y^y^y^y^y~#fo~#fo͇ws#r#q#pÙw͑w|w͙w"`i"**DM^#V#N#F#xyèw::7*~*~"OGgo""~>2
1xx:
=2
w1xx1x1xw*)oy g"~ x*~#"~!M~4**}o|g"> G> O*~> o> g"~)*}o|g"xGyO*~}o|g"~|/G}/O!  >nx	mx7>{_zW}o|g=dx|g}o ږxCZQ Éx	o-yOzW{_xGÙx`iN#F#q#p#=®x22~"~"~`i"3~25~:5~x!~_ x:2~*3~x_ ~#fo0>
̧{>
ͧ{#={~ͧ{{:Zy7͇y[y62?~2Zyk{f{
1{i{*?~& *=~w"?~
f{}1{[v:Zy!(y: _~̎{5!y/Ɓ_#> Wf|xy 2Zy>w7!(y: _~{4!y_#> Wɇ>
ͧ{>
ͧ{>ͧ{!(y: _~f|xy 2Zywxyf| ly6͇y !2y~{2=z{|~[y2lyyxy
wT|#wH|: _!Aw^yp+q:_ !y^#V  |||||||:~|ʡ|>||2~|j:~||:?~*=~=>
|~+|1|>||>
|~0|>
|#~#|=|_ >2~|}?}
}
}}}}j2?~͓}
}*?~& *=~w"?~
}}[v:?~*=~=>
̈́}~+v}1a}>̈́}v}>
̈́}~ v}0v}>
̈́}#~#̈́}=x}_ *~~
̤}#~"~
} !}^ #6
#>
̈́}wP 
 IF(.NOT.(EQUAL(LEXSTR, SUNTIL) .EQ. 1))	 GOTO 23251
       LEX = VUNTIL(1)
   }1~!$~*~>
̈́}>
̈́}  TINUE
       LEX = 10267
23252  CONTINUE
23250  CONTINUE
23248  CONTINUE
23246  CONTINUE
23244  CONTINUE
23242  CONTINUE
23240  CONTINUE
23238  CONTINUE
23236   **TI**E
23234  CONTINUE
       RE.pl 72
.mb 8
.mt 8
.cw 8
.lh 7
.po 7
.op
                               Nationa CP/ User Grou - Progra Submitta Form

** I yo hav an comment o thi form pleas 
**forwar the t th CP/ User Group.
**
**Pleas fil ou thi for fo al materia sub
**mitte t th CP/ User Group  I wil assis 
**u i preparin you contributio fo circulatio 
**an i helpin peopl selec programs 
**
**Sen th contribution wit th complete form 
**to:
*eas 
cross-referenc an rewrite o bug-fixe t prio 
distributions.
**
**I i intende tha thi for b fille ou wit 
**a editor an lef o th submitte dis fo 
**eac program  (Yo ma grou simila program 
**together) Al line startin * ar comment 
**whic shoul b delete fro th form  Remembe 
**t kee a origina o th for aroun fo sub
**mittin mor tha on program.
**
**(I yo don' mind ther ar stil  lo o u 
**o.
* MORSE.AS   Send Mors cod fro ASCI fil t 
**             port.
**SAMPLE.DA  Sampl dat fil fo MORSE.
.cp 7
.po 67


Author: 
**Pleas includ addres an phon number I ei
**the i no t b published s indicate bu 
**includ the fo th User Grou dis catalogin 
**process i cas ther ar questions.

Submitted by: 
**(i differen tha author)  Als includ addres 
**an phone i different.

This program is public domain because: 
**e.g S**disk Wa anythin publishe i  magazine etc 
**I thi  modificatio o  previou User Grou 
**program an i so wha wa it "name (e.g 
**23.05)

Hardware dependencies: 
**e.g specifi processor dis controller plot
**ter printer modem vide board etc.

Software dependencies: 
**e.g I/Ϡ vi PRO calls o hard-code ports 
**JMPS/CALLӠ t specifi machine-siz BIOS othe 
**softwar require whic i NO o thi disk Tim
**in dependenciesTURN
       END
C
C LOOKUP - LOCATE NAME, EXTRACT DEFINITION FROM TABLE
C
       INTEGER FUNCTION LOOKUP(NAME, DEFN)
       INTEGER DEFN(200), NAME(200)
       INTEGER I, J, K
       INTEGER EXTDIG
       INTEGER INTDIG
       INTEGER EXTLET
   *
**CP/ User Group
**165 Thir Avenue
**Ne York N 10028
**
Softwar contribution ar receive fo inclusio 
int th librar wit th understandin tha th 
contributo i authorize t mak th materia a
vailabl t other fo thei individua non-commer
cia use Th User Grou make n representation 
a t th utilit o th materia i th librar fo 
an purpose Contribution shoul b submitte o 8 
singl densit diskette i CP/ fil form Plu her wit 6 wid displays  W woul appre
**ciat you limitin you line t 6 characters  
**<<thanks>>)
**
**Thi for i mos easil fille ou wit  ful 
**scree editor  Yo ma d  "macr nex colon 
**(mn:$v t locat th field whic hav t b 
**fille in.
**
** Sav thi fil a "filename.CPM"
**
**Yo ca the delet al comment line via.. 
**bmn**$0ltk

Date:

File name: 
**(o names) Includ   lin descriptio o each
** Examples ..ubmitte b author author' approval ap
**prova fro magazin i whic i wa published 
**etc.

To whom would this program be useful: 
**e.g "Al CP/ users o "Peopl wit Tarbel 
**flopp controllers o "Peopl wit one-dis sys
**tems etc.

Briefly describe the program function: 
**Includ ru instruction onl i no include i 
**som othe .DO fil o thi disk.

Where is further documentation available: 
**e.g nam th appropriat .DO file o thi 
 "STANDAR CP/M mean i run 
**wit 8 disk (o similarl behavin one lik 
**Northstar) 24 o mor memory CP/ 1.4 D yo 
**think/kno i work with CP/ 2.0?

Source processor: 
**i.e i thi i  sourc program wha d yo 
**"ru i with".. MAC ASM Microsof BASI ver
**sio x.y TD AS etc.

Does the software "drop in": 
**i.e wha typ o modification ar require t 
**mak i run?

How easy is the code to modify: 
**e.g "CO͠ fil only" "Wel commente .AS 
**file";"Poorl commente .AS file"

**02/22/8 WLC
