 KERNEL  DOC   	

 KERNEL  DOC  =         DICT    DOC   > !         ASSEMBL DOC   c"#$%&'()*+,-.    FILES   DOC   H/01234567        STOICCPMDOC   89:              EDIT    DOC   ?;<=>?@AB         FLOATPNTDOC   !CDEFG            INTRRUPTDOC   HI               LOAD    DOC   .JKLMNO           STOIC   DOC   PQRSTUVWXYZ[\]^_ STOIC   DOC  `abcdefghijklmno STOIC   DOC  jpqrstuvwxyz{|}   VOLUME23DOC   ~               CATALOG 23                 KERNEL  $$$  




***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

THE STOIC KERNEL
J. SACHS
3/3/77

	THE KERNEL IS A COLLECTION OF WORDS WHICH DEFINE
STOIC ITSELF AND WHICH MAKE FURTHER DEFINITIONS POSSIBLE.
THE FOLLOWING IS A COMPLETE LIST OF THE WORDERSION RADIX

CHECK	NESTING DEPTH COUNTER (BYTE VARIABLE)

IN	CURRENT INPUT ROUTINE

OUT	CURRENT OUTPUT ROUTINE

PROMPT	ADDRESS OF PROMPT WORD

ERRMSG	ADDRESS OF ERROR MESSAGE HANDLER

COLUMN	OUTPUT COLUMN # (BYTE VARIABLE)

FCT	FILE CONTROL TABLE POINTER

MEMORY	TOP OF RAM

LIT	ADDRESS OF LITERAL HANDLER

(TTYIN)	ADDRESS OF TTY INPUT ROUTINE

(TTYOU)	ADDRESS OF TTY OUTPUT ROUTINE

(ABORT)	ADDRESS OF ROUTINE CALLED EVERY TIME "ABORT" IS INVOKED


THE KERNEL CONTAINS THE FOLLOWING  THE ADDRESS OF THE STRING LITERAL
		IMMEDIATELY FOLLOWING.  IT GETS THE NEXT
		WORD, EXTRACTS THE LENGTH, AND INCREMENTS
		".I" TO POINT TO THE FIRST WORD FOLLOWING
		THE STRING.  THE ADDRESS OF THE FIRST WORD
		OF THE STRING IS LEFT ON THE STACK.


ERROR HANDLING WORDS
NAME	ARGS	DESCRIPTION

ABORT	N/0	THIS IS A GENERAL GARBAGE COLLECTION ROUTINE
		WHICH ABORTS WHATEVER ACTION IS
		CURRENTLY BEING TAKEN AND RETURNS
		CONTROL TO THE KEYBOARD.

ERR	1/0	EXECUTES THE CONTENTS OF THE WORD "ERRMSKERNEL  $$$                   S IN THE
KERNEL ALONG WITH DESCRIPTIONS OF THEIR ACTION.  ANY OF
THESE WORDS MAY BE CALLED BY THE USER ALTHOUGH SOME
OF THEM ARE HIGHLY SPECIALIZED.

VARIABLES

NAME	DESCRIPTION

STATE	ZERO FOR EXECUTE (BYTE VARIABLE)
	NONZERO FOR COMPILE

CURRENT	DICTIONARY HEAD FOR NEW DEFINITIONS

.C	COMPILE BUFFER POINTER

.D	CURRENT POINTER TO END OF DICTIONARY

.I	PSEUDO-INSTRUCTION POINTER

.R	RETURN STACK POINTER

.L	LOOP STACK POINTER

.V	VOCABULARY STACK POINTER

RADIX	CURRENT NUMBER CONVCONSTANTS:

NAME	VALUE

-1	-1

0	0

1	1

2	2


	NEXT FOLLOWS A LIST OF THE BASIC STOIC
VOCABULARY.  THE COLUMN LABELLED "ARGS" GIVES THE
NUMBER OF ARGUMENTS EXPECTED ON THE STACK FOLLOWED
BY THE NUMBER OF RESULTS RETURNED ON THE STACK.  AN
ASTERISK IN THIS COLUMN INDICATES THAT THE PRECEDENCE
BIT FOR THE CORRESPONDING DICTIONARY ENTRY IS SET.


LITERAL HANDLING WORDS
NAME	ARGS	DESCRIPTION

()	0/1	PUSH THE CONTENTS OF THE LOCATION
		POINTED TO BY ".I".  INCREMENT ".I"

S()	0/1	PUSHG".

ERRCH	0/0	CHECKS FOR THE ERROR CONDITIONS:

		LOOP STACK EMPTY/FULL
		VOCABULARY STACK EMPTY/FULL
		DICTIONARY FULL
		COMPILE BUFFER FULL

		IF AN ERROR CONDITION EXISTS, EXECUTE
		"ERR" WITH THE APPROPRIATE MESSAGE.
		OTHERWISE RETURN.


STACK MANIPULATION WORDS
NAME	ARGS	DESCRIPTION

S@	0/1	PUSH THE CONTENTS OF THE STACK POINTER

<R	1/0	PUSH TOP ON RETURN STACK

R>	0/1	POP TOP FROM RETURN STACK

<L	1/0	PUSH TOP ON LOOP STACK

L>	0/1	POP TOP FROM LOOP STACK


NAME	ARGS	BEFORE	AFTER

DUP	1/2	A	A
			A

OVER	2/3	A	B
		B	A
			B

2OVER	3/4	A	C
		B	A
		C	B
			C

3OVER	4/5	A	D
		B	A
		C	B
		D	C
			D

UNDER	2/1	A	A
		B

2UNDER	3/2	A	B
		B	A
		C

3UNDER	4/3	A	B
		B	C
		C	A
		D

SWAP	2/2	A	B
		B	A

2SWAP	3/3	A	A
		B	C
		C	B

FLIP	3/3	A	C
		B	B
		C	A

DROP	1/0	A	B
		B

2DROP	2/0	A	C
		B
		C

3DROP	3/0	A	D
		B
		C
		D

DDUP	2/4	A	A
		B	B
			A
			B

DOVER	4/6	A	C
		B	D
		C	A
		D	B
			C
			D

DUNDER	4/2	A	A
		B	B
		C
		D
1-!	1/0	DECREMENT LOCATION ADDRESSED BY TOP

0<-	1/0	ZERO LOCATION ADDRESSED BY TOP

-1<-	1/0	SET TO -1 LOCATION ADDRESSED BY TOP

MOVE	2/0	THE CONTENTS OF THE LOCATION ADDRESSED
		BY TOP - 1 IS STORED A THE LOCATION
		GIVEN BY TOP.

XCHG	2/0	THE CONTENTS OF TWO WORDS ADDRESSED BY
		TOP AND TOP - 1 ARE INTERCHANGED.

B@	1/1	LOAD BYTE ADDRESSED BY BYTE POINTER ON
		TOP OF STACK

B!	2/0	STORE BYTE AT TOP - 1 AT BYTE ADDRESS
		ON TOP OF STACK

FILL	3/0	STORE N COPIES OF DATA AT TOP AT ADDRATES TOP

NOT	1/1	COMPLEMENTS TOP

2*	1/1	SHIFT TOP LEFT 1

2/	1/1	SHIFT TOP RIGHT 1 (SIGNED)

U2/	1/1	SHIFT TOP RIGHT 1 (UNSIGNED)

EXEC	1/0	EXECUTE WORD WHOSE ADDRESS IS AT TOP

1+	1/1	INCREMENT TOP

1-	1/1	DECREMENT TOP

2+	1/1	INCREMENT TOP BY 2

2-	1/1	DECREMENT TOP BY 2

ABS	1/1	TAKE ABSOLUTE VALUE OF TOP

EQZ	1/1	IF TOP EQUALS 0, PUSH -1
		OTHERWISE PUSH 0

LTZ	1/1	IF TOP LESS THAN 0, PUSH -1
		OTHERWISE PUSH 0

GTZ	1/1	IF TOP GREATER THAN 0, PUSH -1
		OTHERWISE PUSH 0

M OF TOP AND TOP - 1 (UNSIGNED)

UMIN	2/1	MINIMUM OF TOP AND TOP - 1 (UNSIGNED)

LSHIFT	2/1	SHIFT WORD AT TOP - 1 LEFT A NUMBER
		OF BIT POSITIONS ON TOP OF STACK

RSHIFT	2/1	SHIFT WORD AT TOP - 1 RIGHT A NUMBER
		OF BIT POSITIONS ON TOP OF STACK
		(SIGNED)

URSHIFT	2/1	SHIFT WORD AT TOP - 1 RIGHT A NUMBER
		OF BIT POSITIONS ON TOP OF STACK
		(UNSIGNED)

DLSHIFT	3/2	32-BIT LEFT SHIFT THE NUMBER AT TOP - 1
		AND TOP - 2 A NUMBER OF PLACES GIVEN BY
		TOP.

DRSHIFT	3/2	32-BIT RIGHT SHIFT THE TOP - 1,
		PUSH -1, OTHERWISE PUSH 0 (SIGNED)

GE	2/1	IF TOP GREATER OR EQUAL THAN TOP - 1,
		PUSH -1, OTHERWISE PUSH 0 (SIGNED)

ULT	2/1	IF TOP LESS THAN TOP - 1, PUSH -1
		OTHERWISE PUSH 0 (UNSIGNED)

UGT	2/1	IF TOP GREATER THAN TOP - 1, PUSH -1
		OTHERWISE PUSH 0 (UNSIGNED)

ULE	2/1	IF TOP LESS OR EQUAL THAN TOP - 1,
		PUSH -1, OTHERWISE PUSH 0 (UNSIGNED)

UGE	2/1	IF TOP GREATER OR EQUAL THAN TOP - 1,
		PUSH -1, OTHERWISE PUSH 0 (UNSIGNED)


MIXED PRECISION OPERATORS

M+	3/2	ADD THE

DSWAP	4/4	A	C
		B	D
		C	A
		D	B

-ROT	3/3	A	C
		B	A
		C	B

+ROT	3/3	A	B
		B	C
		C	A


LOAD AND STORE WORDS
NAME	ARGS	DESCRIPTION

@	1/1	REPLACES ADDRESS AT TOP WITH ITS
		CONTENTS

!	2/0	STORES NUMBER AT TOP - 1 IN ADDRESS AT
		TOP.

<-	2/0	STORE WORD ON TOP IN LOCATION
		ADDRESSED BY TOP - 1

@@	1/1	LOAD INDIRECT TOP

@!	2/0	STORE TOP - 1 INDIRECT ADDRESS AT TOP

+!	2/0	ADD TOP - 1 TO CONTENTS OF LOCATION
		ADDRESSED BY TOP

1+!	1/0	INCREMENT LOCATION ADDRESSED BY TOP
ESS
		AT TOP-2 WHERE N IS AT TOP-1.

0FILL	2/0	STORE N ZEROS AT ADDRESS AT TOP-1 WHERE N
		IS AT TOP.
		
MVBYTES	3/0	COPY N BYTES FROM LOCATION A TO LOCATION
		B.  N IS TOP OF STACK, B IS TOP - 1, AND
		A IS TOP - 2.  (A AND B ARE BYTE POINTERS)
		A AND B RUN FORWARDS.

RMVBYTES 3/0	COPY N BYTES FROM LOCATION A TO LOCATION
		B.  N IS TOP OF STACK, B IS TOP - 1, AND
		A IS TOP - 2.  (A AND B ARE BYTE POINTERS)
		A AND B RUN BACKWARDS.


UNARY OPERATORS
NAME	ARGS	DESCRIPTION

MINUS	1/1	NEG
NEZ	1/1	IF TOP NOT EQUAL TO 0, PUSH -1
		OTHERWISE PUSH 0

LEZ	1/1	IF TOP LESS OR EQUAL TO 0, PUSH -1
		OTHERWISE PUSH 0

GEZ	1/1	IF TOP GREATER OR EQUAL TO 0, PUSH -1
		OTHERWISE PUSH 0


BINARY OPERATORS
NAME	ARGS	DESCRIPTION

+	2/1	ADDS TOP AND TOP - 1

-	2/1	SUBTRACTS TOP FROM TOP - 1

AND	2/1	ANDS TOP AND TOP - 1

OR	2/1	ORS TOP AND TOP - 1

XOR	2/1	XORS TOP AND TOP - 1

MAX	2/1	MAXIMUM OF TOP AND TOP - 1 (SIGNED)

MIN	2/1	MINIMUM OF TOP AND TOP - 1 (SIGNED)

UMAX	2/1	MAXIMU NUMBER AT TOP - 1
		AND TOP - 2 A NUMBER OF PLACES GIVEN BY
		TOP.  (SIGNED)

DURSHIFT 3/2	32-BIT RIGHT SHIFT THE NUMBER AT TOP - 1
		AND TOP - 2 A NUMBER OF PLACES GIVEN BY
		TOP.  (UNSIGNED)

EQ	2/1	IF TOP EQUALS TOP - 1, PUSH -1
		OTHERWISE PUSH 0

NE	2/1	IF TOP NOT EQUAL TO TOP - 1, PUSH -1
		OTHERWISE PUSH 0

LT	2/1	IF TOP LESS THAN TOP - 1, PUSH -1
		OTHERWISE PUSH 0 (SIGNED)

GT	2/1	IF TOP GREATER THAN TOP - 1, PUSH -1
		OTHERWISE PUSH 0 (SIGNED)

LE	2/1	IF TOP LESS OR EQUAL THAN SINGLE PRECISION NUMBER AT TOP
		TO THE DOUBLE PRECISION NUMBER
		(TOP-1,TOP-2) GIVING A DOUBLE PRECISION
		RESULT.

M-	3/2	SUBTRACT THE SINGLE PRECISION NUMBER AT
		TOP FROM THE DOUBLE PRECISION NUMBER
		(TOP-1,TOP-2) GIVING A DOUBLE PRECISION
		RESULT.


MULTIPLY AND DIVIDE WORDS
OVERFLOW DOES NOT GENERATE ERROR MESSAGE

UNSIGNED OPERATIONS
NAME	ARGS	DESCRIPTION

UM*	2/2	UNSIGNED MULTIPLY WITH 32-BIT RESULT

U/MOD	2/2	UNSIGNED INTEGER DIVIDE, (TOP-1)/TOP
		REMAINDER ON TOP, QUOTIENT AT TOP - 1

UM/MOD	3/2	UNSIGNED DIVIDE, (TOP-1,TOP-2)/TOP
		REMAINDER ON TOP, QUOTIENT AT TOP - 1

U*	2/1	UNSIGNED MULTIPLY

U/	2/1	UNSIGNED INTEGER DIVIDE

UMOD	2/1	UNSIGNED REMAINDER

UM/	3/1	UNSIGNED DIVIDE

U*/MOD	3/2	UNSIGNED (TOP-2)*(TOP-1)/TOP (32 BIT
		INTERMEDIATE PRODUCT) REMAINDER AT TOP,
		QUOTIENT AT TOP - 1

U*/	3/1	UNSIGNED (TOP-2)*(TOP-1)/TOP (32 BIT
		INTERMEDIATE PRODUCT)

SIGNED OPERATIONS
NAME	ARGS	DESCRIPTION

M*	2/2	SIGNED MULTIPLY TOP - 1 BY TOP
		WITH 32-BIT RE
NAME	ARGS	DESCRIPTION

.	0/1	PUSH VALUE OF DICTIONARY POINTER (".D")

C.	0/1	PUSH VALUE OF COMPILE BUFFER POINTER (".C")

,	1/0	STORE TOP AT END OF DICTIONARY,
		INCREMENT ".D".

C,	1/0	STORE TOP AT END OF COMPILE BUFFER,
		INCREMENT ".C".

B,	1/0	STORES A BYTE AT END OF DICTIONARY

CB,	1/0	STORES A BYTE AT END OF COMPILE BUFFER

IMMEDIATE 0/0	SET PRECEDENCE BIT OF MOST RECENTLY
		DEFINED WORD (FOUND VIA "CURRENT").

ENTER	1/0	STRING ARGUMENT ON STACK.  FIRST
		VERIFIES THAT THE NAMED FROM
		DICTIONARY.  GET VOCABULARY NAME FROM
		STRING ARGUMENT.

FORGET	1/0	LOOK UP STRING ARGUMENT IN DICTIONARY
		AND DISCARD IT AND ALL MORE RECENT
		DICTIONARY ENTRIES.

//	0/0*	COMPLEMENT "STATE"

(:)	0/0	ANONYMOUS DICTIONARY ENTRY WHICH
		PUSHES ".I" ON THE RETURN STACK AND
		SETS ".I" TO 2 LESS THAN THE ADDRESS
		OF THE FIRST WORD OF THE PARAMETER
		FIELD OF THE CURRENTLY EXECUTING WORD.

((:))	0,0	ANONYMOUS DICTIONARY ENTRY WHICH
		GETS NEXT WORD VIA ".I" AND COPIES
		THAT MANY BYTOFF THE RETURN STACK.

;	0/0*	DECREMENT CHECK, GIVE "SYNTAX ERROR" IF
		NOT ZERO, TERMINATE ":", OUTPUT ADDRESS
		OF (;) TO COMPILE BUFFER.

(;CODE<) 0/0	ANONYMOUS DICTIONARY ENTRY WHICH
		STORES (CONTENTS OF ".I")+1 IN THE CODE
		ADDRESS WORD OF THE MOST RECENTLY
		DEFINED WORD.

;CODE<	0/0*	DECREMENT CHECK, GIVE "SYNTAX ERROR" IF
		NOT ZERO, TERMINATE ":", OUTPUT ADDRESS OF
		(;CODE<) TO COMPILE BUFFER, PUSH ADDRESS OF
		"ASSEMBLER<" ON VOCABULARY STACK.

(CONSTANT) 0/1	PUSH CONTENTS OF PAD, DECREMENT ".I" BY 2.

;:	0/0	EXECUTE "CONSTANT", POP RETURN STACK
		AND OUTPUT TOP OF RETURN STACK TO
		DICTIONARY, SET UP (;:) AS CODE ADDRESS.


HIGHER LEVEL COMPILER WORDS
NAME	ARGS	DESCRIPTION

+CHECK	0/0	INCREMENTS "CHECK"

-CHECK	0/0	DECREMENTS "CHECK"; IF RESULT IS MINUS,
		THE ERROR "SYNTAX ERROR" IS GIVEN.

(IF)	1/0	TESTS TOP.  IF ZERO, ".I" IS INCREMENTED.
		OTHERWISE, ".I" IS INCREMENTED BY THE CONTENTS
		OF THE NEXT SEQUENTIAL WORD AND
		INCREMENTS ".I".

(ELSE)	1/0	INCREMSULT

/MOD	2/2	SIGNED DIVIDE TOP - 1 BY TOP
		LEAVING REMAINDER AT TOP,
		QUOTIENT AT TOP - 1.

M/MOD	3/2	SIGNED DIVIDE, (TOP-1,TOP-2)/TOP
		REMAINDER ON TOP, QUOTIENT AT TOP - 1

*	2/1	SIGNED MULTIPLY

/	2/1	SIGNED INTEGER DIVIDE

MOD	2/1	SIGNED REMAINDER

M/	3/1	SIGNED DIVIDE

*/	3/1	SIGNED (TOP-2)*(TOP-1)/TOP (32 BIT
		INTERMEDIATE PRODUCT)

*/MOD	3/2	SIGNED (TOP-2)*(TOP-1)/TOP (32 BIT
		INTERMEDIATE PRODUCT) REMAINDER AT TOP,
		QUOTIENT AT TOP - 1


DICTIONARY MANIPULATING WORDSWORD IS UNDEFINED.
		IF DEFINED TYPES WARNING "REDEFINING"
		FOLLOWED BY STRING.  THE NAME IS COPIED
		ONTO THE END OF THE DICTIONARY, THE NEW
		ENTRY IS LINKED IN, AND A ($+2) IS
		STORED AS THE CODE ADDRESS.

ASSEMBLER< 0/0	PUSH ADDRESS OF "ASSEMBLER<" ON VOCABULARY STACK.

STOIC<	0/0	PUSH ADDRESS OF "STOIC<" ON VOCABULARY STACK.

>	0/0	DISCARDS THE TOP OF THE VOCABULARY STACK

DEFINITIONS 1/0	COPIES THE TOP OF THE VOCABULARY STACK INTO "CURRENT".

BRANCH	1/0	CREATE NEW VOCABULARY DISJOINT ES FROM THE PSEUDO-
		INSTRUCTION STREAM INTO THE DICTIONARY.
		BOTH ".I" AND ".D" ARE UPDATED.

:	0/0*	GIVES "SYNTAX ERROR" IF CHECK IS NOT
		ZERO, INCREMENTS CHECK, OUTPUT ADDRESS
		OF ENTER TO COMPILE BUFFER, OUTPUT
		ADDRESS OF ((:)) TO COMPILE BUFFER,
		PUSH THE CONTENTS OF .C, OUTPUT A ZERO
		TO THE COMPILE BUFFER.

CODE<	0/0*	OUTPUT ADDRESS OF "ENTER" TO COMPILE
		BUFFER, PUSH THE ADDRESS OF "ASSEMBLER<"
		ON THE VOCABULARY STACK.

(;)	0/0	ANONYMOUS DICTIONARY ENTRY WHICH POPS
		".I" RAMETER FIELD.

CONSTANT 2/0	EXECUTE "ENTER", OUTPUT TOP - 1
		DICTIONARY, SET UP (CONSTANT) AS CODE
		ADDRESS.

(VARIABLE) 0/1	PUSH ADDRESS OF PARAMETER FIELD.

VARIABLE 2/0	EXECUTE "CONSTANT", SET UP (VARIABLE)
		AS CODE ADDRESS.

ARRAY	2/0	2ND ARGUMENT IS NAME OF ARRAY.  AN INITIALLY
		ZERO VARIABLE IS CREATED AND N-1 ZEROS
		ARE OUTPUT TO THE DICTIONARY WHERE N IS
		THE 1ST ARGUMENT.

(;:)	0/1	PUSH ".I" ON RETURN STACK, SET ".I"
		TO THE CONTENTS OF THE 2ND WORD OF THE
		PARAMETER FIELENTS ".I" BY THE CONTENTS OF THE NEXT
		SEQUENTIAL WORD.

(()	1/0	DECREMENTS THE TOP OF THE STACK.  IF NEGATIVE
		OR ZERO, ".I" IS INCREMENTED BY THE CONTENTS OF THE
		NEXT SEQUENTIAL WORD.  OTHERWISE, THE
		LOOP STACK POINTER IS INCREMENTED TWICE,
		THE TOP OF THE STACK IS PUSHED ON THE LOOP
		STACK, AND ".I" IS INCREMENTED.

(U()	1/0	DECREMENTS THE TOP OF THE STACK.  IF ZERO,
		".I" IS INCREMENTED BY THE CONTENTS OF THE
		NEXT SEQUENTIAL WORD.  OTHERWISE, THE
		LOOP STACK POINTER IS INCREMENTED TWICE,
		THE TOP OF THE STACK IS PUSHED ON THE LOOP
		STACK, AND ".I" IS INCREMENTED.

())	0/0	DECREMENTS THE WORD ON THE TOP OF
		THE LOOP STACK.  IF THE RESULT IS
		ZERO, THE LOOP STACK IS POPPED 3 TIMES
		AND ".I" IS INCREMENTED.  OTHERWISE, ".I"
		IS INCREMENTED BY THE CONTENTS OF THE NEXT
		SEQUENTIAL WORD.

(DO)	2/0	TESTS IF TOP IS GREATER OR EQUAL TOP-1
		IF GREATER OR EQUAL, ".I" IS INCREMENTED
		BY THE CONTENTS OF THE NEXT SEQUENTIAL WORD.
		IF NOT, TOP-1 IS PUSHED ON THE LOOP
		SUAL TOP-1
		IF GREATER OR EQUAL, ".I" IS INCREMENTED
		BY THE CONTENTS OF THE NEXT SEQUENTIAL WORD.
		IF NOT, TOP-1 IS PUSHED ON THE LOOP
		STACK FOLLOWED BY TWO COPIES OF TOP,
		AND ".I" IS INCREMENTED.  (UNSIGNED)

(ULOOP)	0/0	INCREMENTS THE TOP OF THE LOOP STACK
		AND COMPARES THE RESULT WITH TOP-2
		OF THE LOOP STACK.  IF GREATER OR EQUAL,
		POP THE LOOP STACK 3 TIMES AND INCREMENT
		".I".  OTHERWISE ".I" IS INCREMENTED BY THE
		CONTENTS OF THE NEXT SEQUENTIAL WORD.
		(UNSIGNED)

(U+LOOP)N	1/0*	EXECUTE -CHECK, TERMINATE "IF".

ELSE	1/1*	EXECUTE -CHECK, EXECUTE +CHECK, OUTPUT ADDRESS
		OF (ELSE) TO COMPILE BUFFER,  TERMINATE "IF",
		PUSH CONTENTS OF .C, OUTPUT A ZERO TO THE
		COMPILE BUFFER.

(	0/1*	EXECUTE +CHECK, OUTPUT ADDRESS OF (() TO
		THE COMPILE BUFFER.  PUSH CONTENTS OF ".C",
		OUTPUT A ZERO TO THE COMPILE BUFFER.

U(	0/1*	EXECUTE +CHECK, OUTPUT ADDRESS OF (U() TO
		THE COMPILE BUFFER.  PUSH CONTENTS OF ".C",
		OUTPUT A ZERO TO THE COMPILE BUFFER.

)	1/0*	EXECUTE -CHETPUT A ZERO TO THE COMPILE BUFFER.

ULOOP	1/0*	EXECUTE -CHECK, OUTPUT ADDRESS OF (ULOOP) TO
		THE COMPILE BUFFER, TERMINATE "DO".
		
U+LOOP	1/0*	EXECUTE -CHECK, OUTPUT ADDRESS OF (U+LOOP) TO
		THE COMPILE BUFFER, TERMINATE "DO".
		
I	0/1	PUSH COPY OF TOP OF LOOP STACK

J	0/1	PUSH COPY OF TOP - 3 OF LOOP STACK

K	0/1	PUSH COPY OF TOP - 6 OF LOOP STACK
		
I'	0/1	PUSH (TOP-2)+(TOP-1)-(TOP)-1 OF LOOP STACK

J'	0/1	PUSH (TOP-5)+(TOP-4)-(TOP-3)-1 OF LOOP STACK

K'	0/1	PUSH (TOP-8)+(TOP-7)-(TOP-6YO	1/0	EXECUTE CONTENTS OF "OUT".

TYI	0/1	EXECUTE CONTENTS OF "IN".

SPACE	0/0	OUTPUT A SPACE.

SPACES	1/0	OUTPUT N SPACES.

CR	0/0	OUTPUT A CARRIAGE RETURN

TAB	1/0	TAB TO COLUMN N.  NO ACTION TAKEN IF COLUMN
		GREATER OR EQUAL N.

COUNT	1/2	GIVEN A POINTER AT TOP, RETURNS CONTENTS OF
		BYTE ADDRESSED BY POINTER AT TOP, VALUE OF
		POINTER + 1 AT TOP - 1.

TYPE	2/0	OUTPUT A STRING; BYTE COUNT ON TOP AND
		BYTE POINTER AT TOP - 1.  (USES TYO)

RDLINE	0/0	READS AN INPUT LINE INTO THE KEYBTACK FOLLOWED BY TWO COPIES OF TOP,
		AND ".I" IS INCREMENTED.  (SIGNED)

(LOOP)	0/0	INCREMENTS THE TOP OF THE LOOP STACK
		AND COMPARES THE RESULT WITH TOP-2
		OF THE LOOP STACK.  IF GREATER OR EQUAL,
		POP THE LOOP STACK 3 TIMES AND INCREMENT
		".I".  OTHERWISE ".I" IS INCREMENTED BY THE
		CONTENTS OF THE NEXT SEQUENTIAL WORD.
		(SIGNED)

(+LOOP)	 1/0	ADDS THE TOP OF THE STACK TO THE TOP
		OF THE LOOP STACK.  OTHERWISE THE SAME
		AS "LOOP".  (SIGNED)

(UDO)	2/0	TESTS IF TOP IS GREATER OR EQ 1/0	ADDS THE TOP OF THE STACK TO THE TOP
		OF THE LOOP STACK.  OTHERWISE THE SAME
		AS "ULOOP".  (UNSIGNED)

BEGIN	0/1*	EXECUTE +CHECK, PUSH (CONTENTS OF .C) - 2

END	1/0*	EXECUTE -CHECK, OUTPUT ADDRESS OF (IF) TO
		COMPILE BUFFER, TERMINATE "BEGIN".

REPEAT	2/0*	EXECUTE -CHECK TWICE, OUTPUT ADDRESS OF (ELSE)
		TO COMPILE BUFFER, TERMINATE "BEGIN" AND "IF".

IF	0/1*	EXECUTE +CHECK, OUTPUT ADDRESS OF (IF) TO
		COMPILE BUFFER, PUSH CONTENTS OF ".C", OUTPUT
		A ZERO TO THE COMPILE BUFFER.

THECK, OUTPUT ADDRESS OF ()) TO
		THE COMPILE BUFFER, TERMINATE "(".

DO	0/1*	EXECUTE +CHECK, OUTPUT ADDRESS OF (DO) TO
		THE COMPILE BUFFER.  PUSH CONTENTS OF ".C",
		OUTPUT A ZERO TO THE COMPILE BUFFER.

LOOP	1/0*	EXECUTE -CHECK, OUTPUT ADDRESS OF (LOOP) TO
		THE COMPILE BUFFER, TERMINATE "DO".
		
+LOOP	1/0*	EXECUTE -CHECK, OUTPUT ADDRESS OF (+LOOP) TO
		THE COMPILE BUFFER, TERMINATE "DO".
		
UDO	0/1*	EXECUTE +CHECK, OUTPUT ADDRESS OF (UDO) TO
		THE COMPILE BUFFER.  PUSH CONTENTS OF ".C",
		OU)-1 OF LOOP STACK

EXIT	0/0	SET TOP AND TOP - 2 OF LOOP STACK TO 1.


CHARACTER ORIENTED I/O WORDS
NAME	ARGS	DESCRIPTION

IN	0/1	VARIABLE CONTAINING ADDRESS OF INPUT WORD

OUT	0/1	VARIABLE CONTAINING ADDRESS OF OUTPUT WORD

<TTI>	0/1	READS A BYTE FROM THE TTY KEYBOARD.
		THE BYTE IS NOT ECHOED.

<TTO>	1/0	OUTPUT A BYTE TO THE TTY PRINTER.
		COLUMN IS INCREMENTED.
		IF THE CHAR IS A CR, A LF IS OUTPUT AND COLUMN IS ZEROED
		IF THE CHAR IS A TAB, SPACES ARE OUTPUT UNTIL COLUMN = 0 MOD 8

TOARD BUFFER.
		IF INBLK IS -1, THE LINE IS ACCEPTED FROM THE
		KEYBOARD; OTHERWISE INBLK,INBYTE POINTS TO THE
		BLOCK AND BYTE ON THE MASS STORAGE DEVICE FROM
		WHICH INPUT IS TAKEN.  INBLK AND INBYTE ARE
		UPDATED.  THE LINE IS NULL TERMINATED AND
		PRECEDED BY A BYTE COUNT.  IF EXECUTING FROM THE
		KEYBOARD, RUBOUT, NULL, AND LINE FEED ARE PROCESSED.
		LINE IS TERMINATED BY CR OR FF.  IF KEYBOARD BUFFER
		OVERFLOWS, THE ERROR "KEYBOARD BUFFER FULL" IS GIVEN.


NUMBER OUTPUT CONVERSION WORDS
NAME	ARGS	DESCRIPTION

#CNT	0/1	VARIABLE CONTAINING LENGTH OF CONVERTED STRING

#PTR	0/1	VARIABLE CONTAINING POINTER TO CONVERTED STRING

<#	0/0	INITIALIZE #CNT TO 0, INITIALIZE #PTR TO
		POINT 40 (OCTAL) BYTES PAST THE CURRENT END OF
		THE DICTIONARY.

#PUT	1/0	DECREMENT #PTR, STORE BYTE INDIRECT #PTR
		INCREMENT #CNT.

#A	1/1	CONVERT TO NUMBER AT TOP TO AN ASCII
		DIGIT.

#	1/1	DIVIDE THE NUMBER ON THE TOP OF THE STACK
		BY RADIX, LEAVING THE QUOTIENT ON THE TOP
		OF THE STACK.  CONVERT T COUNT ON THE TOP
		OF THE STACK, THE BYTE POINTER AT TOP - 1.
		(UNSIGNED)

U=	1/0	CONVERT THE NUMBER ON THE TOP OF THE
		STACK TO A STRING AND TYPE IT.
		(UNSIGNED)

U?	1/0	TYPE THE CONTENTS OF THE LOCATION
		ADDRESSED BY THE TOP OF THE STACK.
		(UNSIGNED)

=	1/0	CONVERT THE NUMBER ON THE TOP OF THE
		STACK TO A STRING AND TYPE IT.

?	1/0	TYPE THE CONTENTS OF THE LOCATION
		ADDRESSED BY THE TOP OF THE STACK.

OCTAL	0/0	SET RADIX TO OCTAL

DECIMAL	0/0	SET RADIX TO DECIMAL

HEX	0/0	SET (I.E.
	WRITTEN OUT IF MODIFIED), AND THE BLOCK IS READ IN.

WBLOCK	1/1
	RETURNS THE ADDRESS OF A BUFFER CONTAINING THE BLOCK
	WHOSE NUMBER IS AT TOP.  THE BUFFER IS FLAGGED AS
	MODIFIED.  IF THE BLOCK IS NOT ALREADY IN MEMORY, IT
	IS NOT READ IN.

FLUSH	0/0
	WRITES OUT ALL MODIFIED BUFFERS.  THIS WORD MUST BE
	EXECUTED BEFORE SHUTTING DOWN THE SYSTEM OR CHANGING
	MEDIA TO ENSURE THAT THE INFORMATION ON THE STORAGE
	MEDIUM IS CURRENT.

EBUF	0/0
	FLAGS ALL BUFFERS AS EMPTY.  THIS WORD MUST BEFROM THE LOOP STACK.


STRING HANDLING WORDS
NAME	ARGS	DESCRIPTION

WORD	0/1	GET NEXT STRING FROM THE INPUT STREAM
		DELIMITED BY SPACE OR TAB.  LEADING DELIMITERS
		ARE IGNORED.  DELIMITER SEARCH IS TERMINATED
		BY NULL.  THE STRING IS	STORED ON THE END OF
		THE DICTIONARY.  THE FIRST BYTE OF THE STRING
		IS A CHARACTER COUNT. A NULL IS STORED AT THE
		END OF THE STRING BUT IS NOT INCLUDED IN THE
		CHARACTER COUNT.  END-OF-LINE FLAG IS SET TO -1
		IF END OF LINE IS ENCOUNTERED.  THE VALUE OF
AT THE TOP OF
		THE VOCABULARY STACK, AND IF MISSING, THE
		BRANCH WHOSE ADDRESS IS AT TOP - 1 IS SEARCHED
		ETC., UNTIL THE BOTTOM OF THE VOCABULARY
		STACK IS REACHED.  AT THIS POINT THE SEARCH
		FAILS.  IF SUCCESSFUL, A -1 IS STORED AT TOP
		AND A POINTER TO THE PARAMETER FIELD OF THE
		MATCHING DICTIONARY ENTRY AT TOP - 1.  OTHERWISE
		A 0 IS LEFT AT TOP.

ADDRESS	1/1	EXECUTE "LOOKUP".  TEST THE TOP OF THE
		STACK.  IF ZERO, EXECUTE "ERR" WITH THE
		MESSAGE "UNDEFINED".  OTHERWISE RETURN.

HE REMAINDER TO
		AN ASCII DIGIT AND OUTPUT IT VIA #PUT.

#S	1/1	EXECUTE # REPEATEDLY UNTIL THE TOP OF THE
		STACK IS ZERO.  # IS ALWAYS EXECUTED AT
		LEAST ONCE.

#>	1/2	DISCARD THE TOP OF THE STACK, PUSH THE CONTENTS
		OF #PTR, PUSH THE CONTENTS OF #CNT.

<#>	1/2	CONVERT THE NUMBER ON THE TOP OF THE STACK
		TO A STRING.  LEAVE THE BYTE COUNT ON THE TOP
		OF THE STACK, THE BYTE POINTER AT TOP - 1.
		(SIGNED)

U<#>	1/2	CONVERT THE NUMBER ON THE TOP OF THE STACK
		TO A STRING.  LEAVE THE BYTE RADIX TO HEXADECIMAL


BUFFER HANDLING WORDS

	STOIC MAINTAINS A POOL OF SYSTEM BUFFERS WHICH ARE
USED TO HOLD BLOCKS FROM THE STORAGE MEDIUM IN MEMORY.  THEY
ARE ALLOCATED USING A "LEAST RECENTLY USED" ALGORITHM.

RBLOCK	1/1
	RETURNS THE ADDRESS OF A BUFFER CONTAINING THE BLOCK
	WHOSE NUMBER IS AT TOP.  WHEN A BLOCK IS REQUESTED USING
	"RBLOCK", IF THE SPECIFIED BLOCK IS ALREADY IN MEMORY,
	ITS ADDRESS IS IMMEDIATELY RETURNED.  IF IT IS NOT IN
	MEMORY, THE LEAST RECENTLY USED BUFFER IS FREED USED
	WHEN CHANGING MEDIA.

UPDATE	0/0
	FLAGS THE MOST RECENTLY ACCESSED BUFFER AS MODIFIED.
	WHENEVER THE VALUE OF ANY WORD WITHIN AN I/O BUFFER
	IS MODIFIED, THIS WORD MUST BE CALLED, OTHERWISE THE
	MODIFIED VERSION WILL NOT BE WRITTEN BACK ON THE
	STORAGE MEDIUM.

LOAD AND ;F

N LOAD	EXECUTES OFF THE DISK STARTING AT BLOCK N.
	INBLK AND INBYTE ARE PUSHED ON THE LOOP STACK
	INBLK IS SET TO N; INBYTE IS SET TO 0.

;F	REVERTS TO EXECUTION FROM CALLING PROGRAM.
	INBYTE AND INBLK ARE POPPED 
		THE END-OF-LINE FLAG IS RETURNED ON THE STACK.
		IF A " OR \ IS THE FIRST CHARACTER OF A WORD,
		THE DELIMITER IS CHANGED TO " OR \.

S,	1/0	STORE STRING POINTED TO BY TOP OF STACK AT
		THE END OF THE DICTIONARY, ".D" IS UPDATED.

%	0/0*	SET THE END-OF-LINE FLAG TO -1.


DICTIONARY SEARCH WORDS
NAME	ARGS	DESCRIPTION

LOOKUP	1/(1,2)	TOP OF STACK IS POINTER TO STRING TO BE
		LOOKED UP IN THE DICTIONARY.  A DICTIONARY
		SEARCH IS PERFORMED FOR THE BRANCH OF THE
		DICTIONARY WHOSE ADDRESS IS 

LITERAL HANDLING WORDS
NAME	ARGS	DESCRIPTION

LITERAL	1/0	PROCESS THE LITERAL STRING WHOSE ADDRESS IS AT TOP

ILITERAL
	1/(1,2)	A POINTER TO A STRING IS AT TOP.  IF THE STRING
		REPRESENTS A LEGAL INTEGER LITERAL, A -1 IS LEFT AT
		TOP, AND THE LITERAL VALUE IS LEFT AT TOP - 1.
		OTHERWISE, A 0 IS LEFT AT TOP.

SLITERAL
	1/1	A POINTER TO A STRING IS AT TOP.  IF THE STRING
		REPRESENTS A LEGAL STRING LITERAL, THE LITERAL
		IS OUTPUT TO THE COMPILE BUFFER PRECEDED BY THE
		ADDRESS OF "S()" AND A -1 IS LEFT ON THE STACK.
		OTHERWISE A 0 IS LEFT AT TOP.


COMPILER WORDS
NAME	ARGS	DESCRIPTION

^	0/0*	ZEROS THE END-OF-COMMAND FLAG, FORCING COMPILATION
		TO CONTINUE ON TO THE NEXT LINE.

PROMPT0	0/0	TYPES THE INITIAL PROMPT MESSAGE, I.E. A CARRIAGE
		RETURN, THE CURRENT VALUE OF "CHECK", AND
		A ">".

ERRMSG0	1/0	THE DEFAULT ERROR MESSAGE PRINTER; PRINTS THE ERROR
		MESSAGE AT TOP, THE CURRENT CONTENTS OF THE
		TOKEN BUFFER, AND EXITS VIA "ABORT".

UNDEFINED0 0/0	THE DEFAULT UNDEF


***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

DICTIONARY FORMAT

	THE STOIC DICTIONARY CONSISTS OF MULTIPLE LINKED
LISTS OF ENTRIES, CALLED BRANCHES.  EACH BRANCH IS LINKED
ONLY IN THE BACKWARD DIRECTION, NAMELY FROM MORE RECENT TO
LESS RE WORDS LONG.  FOR A VARIABLE OR
CONSTANT, IT IS A SINGLE WORD CONTAINING THE VALUE OF
THE VARIABLE OR CONSTANT.  FOR A COLON DEFINITION, IT IS A
LIST OF ADDRESSES OF THE PARAMETER FIELDS OF OTHER WORDS
TO BE EXECUTED.  FOR A CODE DEFINITION, IT IS THE ACTUAL
MACHINE INSTRUCTIONS TO BE EXECUTED.

DICTIONARY ENTRY FORMAT

WORD	BIT	CONTENTS

0	0	PRECEDENCE (0 = LOW, 1 = HIGH)
	1-7	NUMBER OF CHARACTERS IN NAME
	8-15	FIRST ASCII CHARACTER OF NAME

1		SECOND AND THIRD CHARACTERS OF NAME

2		FOUEXT:	LHLD .I		;GET ".I"
	INX H		;INCREMENT BY 2
	INX H
	SHLD .I		;STORE UPDATED VALUE
	MOV E,M		;GET WORD ADDRESSED BY ".I" IN (D,E)
	INX H		;(ADDR OF PARAMETER FIELD OF NEXT WORD)
	MOV D,M
	MOV H,D		;COPY (D,E) TO (H,L)
	MOV L,E
	DCX H		;LOAD (H,L) WITH CODE ADDRESS FIELD
	MOV A,M
	DCX H
	MOV L,M
	MOV H,A
	PCHL		;JUMP TO CODE ADDRESS

WHAT THIS DOES IS TO INCREMENT ".I", LOAD (D,E) WITH THE
ADDRESS OF THE PARAMETER FIELD OF THE NEXT WORD TO BE
EXECUTED, AND JUMP TO THE LOCATION ADDRESSED R A VARIABLE POINTS TO CODE
WHICH PUSHES THE ADDRESS OF THE VARIABLE ON THE STACK:

	PUSH D		;PUSH ADDR OF PARAMETER FIELD
	JMP NEXT	;EXECUTE NEXT WORD

	THE CODE ADDRESS FOR A COLON DEFINITION POINTS TO
CODE WHICH PUSHES ".I" ON THE RETURN STACK, AND SETS ".I"
TO POINT TO THE WORD PRECEDING THE FIRST WORD OF THE
PARAMETER FIELD OF THE CURRENT WORD:

(:):	LHLD .I		;MOVE .I TO (D,E)
	XCHG
	DCX H		;SET .I TO W-2
	DCX H
	SHLD .I
	LHLD .R		;INCREMENT RETURN STACK PTR BY 2
	INX H
	INX H
	SHLD INED SYMBOL HANDLER; TYPES THE
		MESSAGE "UNDEFINED" AND ABORTS.



***EOF***

ORT".

UNDEFINED0 0/0	THE DEFAULT UNDEFRECENT DEFINITIONS.  EACH LIST IS TERMINATED BY AN
ENTRY WITH A ZERO LINK WORD.  THE DICTIONARY MAY HAVE ANY
NUMBER 1OF BRANCHES.

	EACH ENTRY CONTAINS A NAME FIELD WHICH CONSISTS
OF THE NUMBER OF CHARACTERS IN THE NAME FOLLOWED BY
THE FIRST FIVE CHARACTERS.  THE NAME IS FILLED OUT IF
NECESSARY WITH NULLS (ASCII 0).  IN ADDITION, THERE IS
A ONE BIT PRECEDENCE FIELD AND A CODE ADDRESS WORD WHOSE
FUNCTIONS WILL BE DISCUSSED LATER.

	THE PARAMETER FIELD IS THE BODY OF THE ENTRY AND
MAY BE ONE OR MORTH AND FIFTH CHARACTERS OF NAME

3		ADDRESS OF PREVIOUS ENTRY
		0 IF END OF DICTIONARY CHAIN

4		CODE ADDRESS

5		FIRST WORD OF PARAMETER FIELD


EXECUTION OF WORDS

	THE HEART OF STOIC IS A COMPACT SECTION OF CODE
WHICH EXECUTES THE NEXT WORD.  IT MAKES USE OF AN INSTRUCTION
POINTER CALLED ".I" WHICH IS HELD A MEMORY LOCATION.  AT ALL
TIMES, IT POINTS TO THE LOCATION PRECEDING THE ONE ABOUT TO
BE EXECUTED NEXT.

	ON THE 8080,  THE INTERPRETER CONSISTS OF THE
FOLLOWING INSTRUCTIONS:

NBY
THE CODE ADDRESS FIELD OF THAT WORD.

	SP IS USED TO HOLD THE PARAMETER STACK POINTER
AND MUST NOT BE DESTROYED BY ANY WORD I.E., IF USED,
ITS VALUE MUST BE SAVED AND RESTORED.


THE CODE ADDRESS WORD

	THE CODE ADDRESS FOR A CONSTANT POINTS TO CODE
WHICH PUSHES THE VALUE OF THE CONSTANT ON THE STACK:

	XCHG		;MOVE ADDR OF PARAMETER FIELD TO (H,L)
	MOV E,M		;LOAD (D,E) WITH CONTENTS OF PARAMETER FIELD
	INX H
	MOV D,M
	PUSH D		;PUSH IT
	JMP NEXT	;EXECUTE NEXT WORD

	THE CODE ADDRESS FO.R
	MOV M,E		;STORE .I ON END OF RETURN STACK
	INX H
	MOV M,D
	JMP NEXT	;EXECUTE NEXT WORD

	THE RETURN STACK POINTER IS KEPT IN THE LOCATION
	LABELLED ".R".

	AT THE END OF EVERY COLON DEFINITION IS THE ADDRESS
OF A NAMELESS DICTIONARY ENTRY WHICH POPS ".I" FROM THE
RETURN STACK:

(;):	LHLD .R		;RETURN STACK POINTER
	MOV E,M		;LOAD (D,E) WITH TOP OF RETURN STACK
	INX H
	MOV D,M
	DCX H
	DCX H		;DECREMENT RETURN STACK POINTER BY 2
	DCX H
	SHLD .R		;STORE UPDATED VALUE
	XCHG		;SET ".I" TO TOP OF RETURN STACK
	SHLD .I
	JMP NEXT	;EXECUTE NEXT WORD

	THE CODE ADDRESS FOR A CODE DEFINITION POINTS
TO THE FOLLOWING WORD, I.E. THE FIRST WORD OF THE
DEFINITION.


THE PRECEDENCE BIT

	THE PRECEDENCE BIT IS USED DURING COMPILATION TO CAUSE
CERTAIN WORDS TO BE EXECUTED IMMEDIATELY INSTEAD OF BEING
COMPILED.  THIS FACILITY MAKES POSSIBLE COMPILATION OF THE
FORWARD AND BACKWARD REFERENCES WHICH ARE NECESSARY FOR
CONDITIONALS AND ITERATION.

	WHEN STOIC IS COMPILING A WORD INTO THE COMPI.

	"BEGIN" AND "END" HAVE THE PRECEDENCE BIT
	SET IN THEIR DICTIONARY ENTRIES.

	"BEGIN", IS EXECUTED SINCE ITS PRECEDENCE BIT IS
	SET, AND CAUSES THE CURRENT COMPILE BUFFER OUTPUT
	POINTER (WHOSE VALUE IS NOW "LOOP") - 2 TO BE SAVED
	ON THE PARAMETER STACK.

	THE ADDRESSES OF "X", "@", AND "EQZ" ARE COMPILED
	DIRECTLY INTO THE COMPILE BUFFER SINCE THEIR PRECEDENCE
	IS ZERO.

	"END" IS EXECUTED, CAUSING THE ADDRESS OF "(IF)"
	TO BE OUTPUT TO THE COMPILE BUFFER, FOLLOWED BY THE
	SAVED DICTIOEDIATE

	THIS DEFINES A WORD CALLED "ZERO" WHICH TYPES
	A "0" WHEN COMPILED.  IT GENERATED NO CODE AT COMPILE
	TIME.  THUS,

	'TEST : ZERO ;

	CAUSES A "0" TO BE TYPED WHILE LEAVING THE
	DEFINITION OF TEST EMPTY.

	THE FOLLOWING WORD PERMITS MORE COMPLICATED
	SEQUENCES OF WORDS TO BE EXECUTED WHILE
	COMPILING A DEFINITION:

	//	COMPLEMENT STATE (HAS PRECEDENCE BIT SET)

	THUS:

	'TEST : // 0 = // ;

	IS EQUIVALENT TO THE ABOVE EXAMPLE.


COLON DEFINITIONS

	THE COMPILATION OF A COL OF BYTES COMPILED SINCE THE START OF THE COLON
DEFINITION.  ";" ALSO CHECKS FOR ZERO NESTING DEPTH.

	WHEN EXECUTED, THE WORD "((:))" CREATES THE FIRST FIVE
WORDS FOR THE NEW DICTIONARY ENTRY USING THE STRING WHOSE
ADDRESS IS AT THE TOP OF THE STACK AND THEN COPIES THE FOLLOWING
N BYTES FROM THE COMPILE BUFFER INTO THE DICTIONARY WHERE N IS
THE CONTENTS OF THE FOLLOWING WORD IN THE COMPILE BUFFER.  SINCE
ALL ADDRESS CONTAINED IN THE COMPILED CODE ARE EITHER ABSOLUTE
ADDRESSES OF WORDS IN THE DICTI


***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

THE STOIC ASSEMBLER FOR THE INTEL 8080
J. SACHS 2/2/77

CODE DEFINITIONS

	STOIC PROVIDES THE USER WITH A MEANS OF DEFINING
A NEW WORD IN TERMS OF THE ASSEMBLY LANGUAGE FOR THE
PARTICULAR MLE BUFFER,
IF ITS PRECEDENCE BIT IS ZERO, THE ADDRESS OF THE PARAMETER FIELD
OF THE WORD IS STORED IN THE COMPILE BUFFER.  IF ITS PRECEDENCE
BIT IS NON-ZERO, THE WORD IS EXECUTED DIRECTLY.

EXAMPLE:

	BEGIN X @ EQZ END ;

	THIS GENERATES THE FOLLOWING CODE IN THE COMPILE BUFFER:

	LOOP:	ADDRESS OF X
		ADDRESS OF @
		ADDRESS OF EQZ
		ADDRESS OF (IF)
		LOOP-2-.

	(IF) TESTS THE TOP OF THE STACK AND, IF ZERO,
	ADDS TO ".I" THE CONTENTS OF THE NEXT WORD; IF
	NON-ZERO, ".I" IS INCREMENTED BY 2NARY POINTER MINUS THE CURRENT VALUE OF
	THE COMPILE BUFFER OUTPUT POINTER ("LOOP"-2-.).

	WHEN THE ABOVE COMPILED CODE IS EXECUTED, THE WORDS
	"X", "@", AND "EQZ" ARE EXECUTED.  "(IF)" THEN
	CAUSES A CONDITIONAL BRANCH BACK TO "LOOP" IF
	THE TOP OF THE STACK IS ZERO, OTHERWISE CONTROL
	PASSES ON TO THE NEXT WORD.


	THE USER MAY SET THE PRECEDENCE BIT HIMSELF, USING
	THE FOLLOWING WORD:

	IMMEDIATE	SET THE PRECEDENCE BIT OF THE
			MOST RECENTLY DEFINED WORD.

	EXAMPLE:

	'ZERO : 0 = ; IMMON DEFINITION IS ONLY SLIGHTLY
DIFFERENT FROM NORMAL COMPILATION OUTSIDE A COLON DEFINITION.
THE WORD ":" HAS NON-ZERO PRECEDENCE AND CAUSES THE ADDRESS OF
"((:))" TO BE OUTPUT TO THE COMPILE BUFFER FOLLOWED BY A ZERO WORD.
":" ALSO CHECKS TO MAKE SURE THAT THE NESTING DEPTH IS ZERO
AND THEN INCREMENTS THE NESTING DEPTH BY ONE.

	THE WORD ";" ALSO HAS NON-ZERO PRECEDENCE AND CAUSES
THE ADDRESS OF "(;)" TO BE OUTPUT TO THE COMPILE BUFFER.
IT THEN STORES IN THE ZERO WORD FOLLOWING "((:))" THE
NUMBERONARY OR OFFSETS RELATIVE TO
".I", THE CODE IS POSITION INDEPENDENT AND WILL EXECUTE
PROPERLY EITHER IN THE COMPILE BUFFER OR WHEN RELOCATED TO
THE END OF THE DICTIONARY.



***EOF***

T AND WILL EXECUTE
PROPERLY EITHER IN THE COMPILE BUFFER OR ACHINE ON WHICH IT IS EXECUTING.  THIS IS
PROVIDED BY THE ASSEMBLER AND THE CODE DEFINITION.

'NAME CODE< A1 A2 ... >

	HERE A1, A2, ... ARE WORDS DEFINED WITHIN THE
ASSEMBLER AND "NAME" IS THE NAME OF THE WORD BEING
DEFINED.  AS WITH EVERYTHING ELSE IN STOIC, THE
ASSEMBLER USES REVERSE POLISH NOTATION, GIVING THE
ADDRESSES AND ACCUMULATOR SPECIFIERS BEFORE THE
OPCODE.

	THE ASSEMBLER WORDS DO NOT EXECUTE MACHINE
INSTRUCTIONS DIRECTLY; THEY MERELY CAUSE INSTRUCTIONS
TO BE ASSEMBLED ONTO THE END OF THE DICTIONARY.  THUS
BEFORE MACHINE LANGUAGE INSTRUCTIONS CAN BE EXECUTED
FROM THE KEYBOARD THEY MUST FIRST BE ASSEMBLED INTO A
CODE DEFINITION.

ADDRESSES

	AN ADDRESS IS NORMALLY THE NAME OF A WORD, OR AN
ABSOLUTE LOCATION.  AN ADDRESS MAY HOWEVER BE ANY EXPRESSION
WHICH EVALUATES TO AN INTEGER.

ACCUMULATORS

	WITHIN THE ASSEMBLER, THE NORMAL INTEL ACCUMULATOR
NAMES (A,B,C,D,E,H,L,M,SP,PSW) ARE USED TO SPECIFY 8080
REGISTERS.

INSTRUCTIONS WITHOUT ADDRESS OR ACCUMULATOR

	INTEL		 POP,
	PUSH ACC	ACC PUSH,
	INX ACC		ACC INX,


INSTRUCTIONS WITH AN ACCUMULATOR AND A 16-BIT VALUE

	INTEL		STOIC

	LXI ACC,VALUE	VALUE ACC LXI,


INSTRUCTIONS WITH TWO ACCUMULATORS

	INTEL		STOIC

	MOV AC1,AC2	AC2 AC1 MOV,

INSTRUCTIONS WITH AN ADDRESS

	INTEL		STOIC

	SHLD ADR	ADR SHLD,
	LHLD ADR	ADR LHLD,
	STA ADR		ADR STA,
	LDA ADR		ADR LDA,
	JMP ADR		ADR JMP,
	CALL ADR	ADR CALL,
	JNZ ADR		ADR JNZ,
	JZ ADR		ADR JZ,
	JNC ADR		ADR JNC,
	JC ADR		ADR JC,
	JPO ADR		ADR JPO,
	,
	CMP ACC		ACC CMP,

INSTRUCTIONS WITH ONE 8-BIT VALUE

	INTEL		STOIC

	ADI VALUE	VALUE ADI,	
	ACI VALUE	VALUE ACI,
	SUI VALUE	VALUE SUI,
	SBI VALUE	VALUE SBI,
	ANI VALUE	VALUE ANI,
	XRI VALUE	VALUE XRI,
	ORI VALUE	VALUE ORI,
	CPI VALUE	VALUE CPI,
	OUT N		N OUT,
	IN N		N IN,

EXAMPLES:

STOIC ASSEMBLER		INTEL ASSEMBLER

HLT,			HLT
0 H LXI,		LXI H,0
A B MOV,		MOV B,A
M CPI,			CPI M
H DCX,			DCX H
. JMP,			JMP $

FORWARD AND BACKWARD JUMPS

	SINCE THE STOIC ASSEMBLER HAS NO LABOWING WORDS:

IF,	UNCONDITIONAL FORWARD JUMP
IFNZ,	FORWARD JUMP IF NON-ZERO
IFZ,	FORWARD JUMP IF ZERO
IFNC,	FORWARD JUMP IF NO CARRY
IFC,	FORWARD JUMP IF CARRY
IFPO,	FORWARD JUMP IF PARITY ODD
IFPE,	FORWARD JUMP IF PARITY EVEN
IFP,	FORWARD JUMP IF PLUS
IFM,	FORWARD JUMP IF MINUS

THEN,	SUPPLY TARGET FOR FORWARD JUMP

ELSE,	GENERATE AN UNCOUNDITIONAL FORWARD JUMP
	AND SUPPLY TARGET FOR PRECEDING FORWARD
	JUMP.

THE NORMAL CONSTRUCTION FOR A FORWARD JUMP IS:

	IF,  ...  THEN,

THE "IF," O BE ASSEMBLED TO THE
INSTRUCTION FOLLOWING THE "THEN,".  THE "IF," COULD, OF
COURSE, BE A CONDITIONAL JUMP.


EXAMPLES:

	'TEST CODE<  H POP,  H A MOV,  IFP,  -1 H LXI,  ELSE,
	  0 H LXI,  THEN,  PUSH JMP,  >

	THIS DEFINES A WORD CALLED "TEST" WHICH, IF
	THE TOP OF THE STACK IS POSITIVE, PUSHES A 0,
	OTHERWISE PUSHES A -1.  THE GENERATED CODE IS:

	POP H
	MOV A,H
	JP L1
	LXI H,-1
	JMP L2
L1:	LXI H,0
L2:	JMP PUSH


	'WAIT CODE<  H POP,  .  H DCX,  H A MOV,  L ORA,  JNZ,
	  NEXT JMP,STOIC

	NOP		NOP,
	HLT		HLT,
	RLC		RLC,
	RRC		RRC,
	RAL		RAL,
	RAR		RAR,
	DAA		DAA,
	CMA		CMA,
	STC		STC,
	CMC		CMC,
	RET		RET,
	RNZ		RNZ,
	RZ		RZ,
	RNC		RNC,
	RC		RC,
	RPO		RPO,
	RPE		RPE,
	RP		RP,
	RM		RM,
	XTHL		XTHL,
	PCHL		PCHL,
	SPHL		SPHL,
	XCHG		XCHG,
	DI		DI,
	EI		EI,


INSTRUCTIONS WITH ACCUMULATOR

	INTEL		STOIC

	RST N		N   RST,
	DAD ACC		ACC DAD,
	DCX ACC		ACC DCX,
	STAX ACC	ACC STAX,
	LDAX ACC	ACC LDAX,
	INR ACC		ACC INR,
	DCR ACC		ACC DCR,
	POP ACC		ACCJPE ADR		ADR JPE,
	JP ADR		ADR JP,
	JM ADR		ADR JM,
	CNZ ADR		ADR CNZ,
	CZ ADR		ADR CZ,
	CNC ADR		ADR CNC,
	CC ADR		ADR CC,
	CPO ADR		ADR CPO,
	CPE ADR		ADR CPE,
	CP ADR		ADR CP,
	CM ADR		ADR CM,
	

INSTRUCTIONS WITH ONE ACCUMULATOR AND ONE 8-BIT VALUE

	INTEL		STOIC

	MVI ACC,VALUE	VALUE ACC MVI,


INSTRUCTIONS WITH ONE ACCUMULATOR

	INTEL		STOIC

	ADD ACC		ACC ADD,
	ADC ACC		ACC ADC,
	SUB ACC		ACC SUB,
	SBB ACC		ACC SBB,
	ANA ACC		ACC ANA,
	XRA ACC		ACC XRA,
	ORA ACC		ACC ORAELS, SPECIAL
ASSEMBLER WORDS ARE USED TO CONTROL FORWARD AND BACKWARD
JUMPS.

BACKWARD JUMPS ARE ACCOMPLISHED USING THE FOLLOWING CONSTRUCTION:

	.  ...  JMP,

	"." IS USED TO SAVE THE CURRENT LOCATION ON THE
	STACK; THE FOLLOWING INSTRUCTIONS ARE ASSEMBLED
	NORMALLY, AND THE "JMP," ASSEMBLES A JUMP BACK
	TO THE SAVED LOCATION COUNTER VALUE.  A CONDITIONAL
	JUMP COULD JUST AS EASILY BE USED.  SUCH BACKWARD
	JUMPS MAY BE NESTED FOR MULTI-LEVEL LOOPS.

FORWARD JUMPS ARE ASSEMBLED USING THE FOLLASSEMBLES A "0 JMP," AND SAVES ON THE STACK THE
ADDRESS OF THE 0.  "THEN," STORES THE VALUE OF THE CURRENT
LOCATION COUNTER (.) AT THE ADDRESS ON THE TOP OF THE
STACK, THUS COMPLETING THE ASSEMBLY OF THE JMP INSTRUCTION.
FORWARD JUMPS MAY BE NESTED IN EXACTLY THE SAME WAY AS
BACKWARD JUMPS.

"ELSE," IS USED AS FOLLOWS:

	IF,  ...  ELSE,  ...  THEN,

	HERE, THE "IF," GENERATES A FORWARD JUMP TO THE
INSTRUCTION IMMEDIATELY FOLLOWING THE "ELSE,".  THE "ELSE,"
IN TURN CAUSES AN UNCONDITIONAL JUMP T  >

	THE WORD "WAIT" IS DEFINED WHICH COUNTS DOWN ITS
	ARGUMENT AND RETURNS WHEN THE RESULT IS 0.  THE
	GENERATED CODE IS:

	POP H
L1:	DCX H
	MOV A,H
	ORA L
	JNZ L1
	JMP NEXT


DEFINING SUBROUTINES

	SOMETIMES A BLOCK OF INSTRUCTIONS MUST BE EXECUTED FROM
SEVERAL DIFFERENT CODE DEFINITIONS; IN THIS CASE IT IS FREQUENTLY
EFFICIENT TO DEFINE A SUBROUTINE.  THIS IS DONE AS FOLLOWS:

	. ASSEMBLER<
	BODY OF SUBROUTINE
	>
	'SUBROUTINE-NAME CONSTANT

THE "." PUSHES ON THE STACK THE ADDRESS OF THE BEGINNING OF THE
SUBROUTINE, SUPPLYING THE VALUE FOR "CONSTANT".  "ASSEMBLER<"
ACTIVATES THE ASSEMBLER VOCABULARY; NOTE THAT IT MUST BE FOLLOWED
BY A CARRAIGE RETURN.  THE BODY OF THE SUBROUTINE FOLLOWS, WITH
RETURN INSTRUCTIONS INCLUDED.  FINALLY, ">" DE-ACTIVATES THE
ASSEMBLER VOCABULARY AND THE CONSTANT IS DEFINED.  SUBSEQUENTLY,
THE SUBROUTINE MAY BE INVOKED DIRECTLY BY:

	SUBROUTINE-NAME CALL,


ASSEMBLING STRINGS

	TO ASSEMBLE A STRING ONTO THE END OF THE DICTIONARY, THE
FOLLOWIF
A TABLE OF NUMBERS FROM 0 TO RADIX - 1.


CONDITIONAL ASSEMBLY

	CONDITIONAL ASSEMBLY IS OBTAINED BY USING THE NORMAL STOIC
"IF", "ELSE", AND "THEN".  FOR EXAMPLE, SUPPOSE WE HAVE A VARIABLE
"TEST" WHICH THE USER WILL SET TO EITHER 0 OR -1:

	'PARAM CODE<  TEST @ IF 100 ELSE 200 THEN H LXI,  PUSH JMP,  >

HERE, THE CODE DEFINITION, "PARAM" IS DEFINED TO PUSH A 100 IF TEST
IS NON-ZERO, A 200 OTHERWISE.


MACROS

	ASSEMBLER MACROS ARE PROVIDED BY USING COLON DEFINITIONS
AS FOLLOWS:

	ASA CHARACTER FORM THE KEYBOARD;
		CHARACTER RETURNED IN A REGISTER.

(TTO) CALL,	TYPE A CHARACTER ON THE TERMINAL;
		CHARACTER PASSED IN A REGISTER.
		RETURN AUTOMATICALLY FOLLOWED BY LINE FEED.

(MSG) CALL,	TYPES A MESSAGE ON THE TERMINAL;
		POINTER TO STRING PASSED IN (H,L).

MUL CALL,	UNSIGNED MULTIPLY
SMUL CALL,	SIGNED MULTIPLY
		(H,L)*(D,E) -> (H,L,D,E)

DIV CALL,	UNSIGNED DIVIDE
SDIV CALL,	SIGNED DIVIDE
		(H,L,D,E)/(B,C) -> (H,L) REMAINDER; (D,E) QUOTIENT

(B,) CALL,	OUTPUT A REGISTER OWN, THE USER
SHOULD BE AWARE OF THE FOLLOWING FACTS:

1) THE PARAMETER STACK POINTER IS PASSED IN SP.  SP
   MUST CONTAIN THE STACK POINTER ON EXIT.

2) PARAMETERS ON THE STACK ARE AVAILABLE BY INDEXING OFF
   SP.  THE TOP OF THE STACK IS AT OFFSET 0, NEXT TO TOP
   AT OFFSET +2, ETC.

3) TEN TEMPORARIES, STARTING AT "T1" ARE AVAILABLE IF
   NECESSARY.

4) ALL CODE DEFINITIONS MUST EXIT BY JUMPING TO ONE OF
   THE FOLLOWING ADDRESSES IN THE STOIC INTERPRETER:

	NEXT	NORMAL TERMINATION

	  H POP,  H A MOV,  A ORA,  IFP,
	  -HL CALL,  THEN,  PUSH JMP,  >

	THE WORD "ABS" REPLACES THE TOP OF THE STACK
	WITH ITS ABSOLUTE VALUE.


;CODE<

	THE WORD ";CODE<" IS USED TO DEFINE NEW CLASSES
OF WORDS.  "VARIABLE", "CONSTANT", AND "USER", FOR
EXAMPLE ARE DEFINED USING ";CODE<".  THE FORMAT FOR ITS
USE IS AS FOLLOWS:

	'NAME : ... ;CODE< ... >

	THE WORDS BETWEEN "NAME" AND ";CODE<" ARE IN
HIGHER LEVEL STOIC; THE WORDS BETWEEN ";CODE< AND ">"
ARE ASSEMBLER WORDS.

	WHEN EXECUTED, "NG TECHNIQUE IS USED:

	. "STRING" S,

THIS PUSHES A POINTER TO THE BEGINNING OF THE STRING ON THE STACK,
AND COPIES THE GIVEN STRING FROM THE COMPILE BUFFER ONTO THE END
OF THE DICTIONARY.


REPEATING INSTRUCTIONS

	INTERATION BRACKETS AND/OR DO LOOPS MAY BE USED WITHIN
THE ASSEMBLER TO PERFORM REPETITIVE ASSEMBLY:

	'DELAY CODE<  100 ( NOP, ) >

THIS ASSEMBLES A WORD "DELAY" WHICH EXECUTES 100 NOP'S.

	.  10 0 DO I , LOOP

THIS EXAMPLE LEAVES ON THE STACK THE ADDRESS OF THE BEGINNING OSEMBLER< DEFINITIONS
	'-HL, : H A MOV,  CMA,  A H MOV,  L A MOV,  CMA,  A L MOV,
		H INX,  ;
	> DEFINITIONS

THUS,

	'MINUS CODE<  H POP,  -HL,  PUSH JMP,  >

	DEFINES A WORD WHICH NEGATES THE TOP OF THE STACK.


LOCATIONS INTERNAL TO STOIC WHICH ARE AVAILABLE TO THE USER:

-HL CALL,	NEGATES (H,L)
HL 1+ CALL,	COMPLEMENTS (H,L)

-DE CALL,	NEGATES (D,E)
DE 1+ CALL,	COMPLEMENTS (D,E)

-BC CALL,	NEGATES (B,C)
BC 1+ CALL,	COMPLEMENTS (B,C)

-HLDE CALL,	NEGATES (H,L,D,E)

(TTI) CALL,	GET  TO END OF DICTIONARY
(,) CALL,	OUTPUT (H,L) TO END OF DICTIONARY

ERROR JMP,	SIMULATES "STRING" ERR
		ADDRESS OF STRING IN (H,L).

(READ) CALL,	READ A BLOCK FROM MASS STORAGE DEVICE
(WRITE)	CALL,	WRITE A BLOCK TO MASS STORAGE DEVICE
		(H,L) = BLOCK #
		(D,E) = BUFFER ADDRESS
		ON RETURN, A = ERROR CODE (0 = OK)

(RBLOCK) CALL,	BLOCK # IN (D,E), BUFFER
(WBLOCK) CALL,	ADDRESS RETURNED IN (D,E).

T1		TEMPORARY #1
		9 ADDITIONAL 16-BIT TEMPORARIES FOLLOW


	IN MAKING A CODE DEFINITION OF HISPUSH	PUSH (H,L), JUMP TO NEXT

	DPUSH	PUSH (D,E), PUSH (H,L), JUMP TO NEXT

	PUSHD	PUSH (D,E), JUMP TO NEXT

	@PUSH	PUSH @(H,L), JUMP TO  NEXT

	0PUSH	PUSH 0, JUMP TO NEXT

	-1PUSH	PUSH -1, JUMP TO NEXT

5) A POINTER TO THE PARAMETER FIELD OF THE CURRENT WORD
   IS PASSED IN (D,E).  (D,E) NEED NOT BE PRESERVED.


EXAMPLES OF CODE DEFINITIONS:

	'+ CODE<  H POP,  D POP,  D DAD,  PUSH JMP,  >

	THE WORD "+" ADDS THE TOP TWO STACK ENTRIES
	AND LEAVES THE RESULT ON THE STACK.

	'ABS CODE<;CODE<" OUTPUTS THE ADDRESS OF
"(;CODE<)" TO THE COMPILE BUFFER, TERMINATES THE CURRENT
COLON DEFINITION, AND PUSHES THE ADDRESS OF "ASSEMBLER<" ON
THE VOCABULARY STACK.

	THE NAMELESS DICTIONARY ENTRY "(;CODE<)"
SETS THE CODE ADDRESS WORD OF THE MOST RECENTLY
DEFINED WORD TO THE CONTENTS OF "I" + 2, AND POPS
"I" FROM THE RETURN STACK.

EXAMPLE:

	'VARIABLE : CONSTANT ;CODE< PUSHD JMP, >

	THIS IS THE DEFINITION OF "VARIABLE".  THE
	DICTIONARY ENTRY FOR "VARIABLE" THEN LOOKS
	AS FOLLOWS:

		<8>V
		AR
		IA
		LINK TO PREVIOUS ENTRY
		ADDRESS OF (:)
	VAR:	ADDRESS OF CONSTANT
		ADDRESS OF (;CODE<)
	(VAR):	JMP PUSHD

	NOW, SUPPOSE THAT X IS DEFINED AS FOLLOWS:

	20 'X VARAIBLE

	"VARIABLE" INVOKES "CONSTANT" WHICH BUILDS A
	DICTIONARY ENTRY CALLED "X", STORES THE
	VALUE "20" IN THE PARAMETER FIELD, AND SETS
	THE CODE ADDRESS WORD TO POINT TO MACHINE
	INSTRUCTIONS WHICH PUSH THE VALUE OF THE
	PARAMETER FIELD ON THE STACK.  ";CODE<" THEN
	OVERWRITES THE CODE ADDRESS WORD WITH THE;: ... ;

	HERE, BOTH SETS OF WORDS ARE IN HIGHER LEVEL
STOIC.

EXAMPLE:

	0> 'SQPRINT : ;: DUP * = ;
	0> 5 'X SQPRINT
	0> X
	25

	";:" IS MAINLY USEFUL IN DEFINING A NUMBER OF WORDS WHICH
DIFFER ONLY IN A SINGLE CONSTANT VALUE, E.G. ASSEMBLER WORDS WITH
DIFFERENT OPCODES.



***EOF***


ER OF WORDS WHICH
DIFFER ONLY IN A SINGLE CONSTANT VALUE, E.G. ASSEMBLER



***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

STOIC FILE SYSTEM
J. SACHS 2/9/77

	THE STOIC FILE SYSTEM SUPPORTS CONTIGUOUS FILES WHICH
ARE REFERENCED BY SIX-LETTER NAMES.  THESE NAMES AND THE LOCATIONS
OF THE FILES ON THE STORAGE MEDIUMRECTORY LISTING IN TWO COLUMNS.

LEFT		RETURNS ON THE STACK THE NUMBER OF UNUSED BLOCKS
		ON THE STORAGE MEDIUM.

CCONT		CREATES A CONTIGUOUS FILE WHOSE LENGTH (IN BLOCKS)
		IS AT THE TOP OF THE STACK, THE NAME IS AT TOP - 1.

DELETE		DELETES THE FILE WHOSE NAME IS AT TOP OF STACK.

RENAME		RENAMES FILE WHOSE NAME IS AT TOP - 1 TO NAME AT TOP.

FILE		CREATES A 3-WORD FILE CONTROL TABLE WHOSE NAME IS AT
		TOP.  WHEN REFERENCED, THE ADDRESS OF THE FILE CONTROL
		TABLE IS STORED IN THE VARIABLE "LE NAME AT TOP OF STACK.
		ANY PREVIOUS VERSION OF THE FILE IS DELETED, A NEW
		VERSION IS CREATED WHOSE LENGTH IS EQUAL TO THE ENTIRE
		REMAINING FREE SPACE, AND THE FILE IS OPENED USING
		THE CURRENT FILE CONTROL TABLE.  IF MORE THAN ONE
		OUTPUT FILE IS ACTIVE AT A TIME, ALL BUT ONE OF THEM
		MUST BE CREATED WITH "CCONT" AND OPENED WITH "OPEN",
		GIVING THE FILE LENGTH IN ADVANCE.  THE LAST ONE MAY
		BE VARIABLE LENGTH AND OPENED WITH "WOPEN".

SHRINK		USING THE CURRENT FILE CONTROL TABLE, THE 
	ADDRESS OF (VAR).  THUS, THE RESULTANT
	DICTIONARY ENTRY FOR "X" IS:

		<1>X
		0
		0
		LINK TO PREVIOUS ENTRY
		(VAR)
	X:	20

	WHEN "X" IS IN TURN EXECUTED, CONTROL PASSES
	TO (VAR) VIA THE CODE ADDRESS WORD, WITH THE
	ADDRESS OF "X" IN (D,E), THE ADDRESS OF "X" IS
	PUSHED, AND CONTROL PASSES TO "NEXT".


;:

	";:" IS ANALOGOUS TO ";CODE<" EXCEPT THAT IT
USES HIGHER LEVEL STOIC TO DEFINE THE ACTION TAKEN
BY THE CLASS OF WORDS BEING DEFINED.  THE SYNTAX IS
AS FOLLOWS:

	'NAME : ...  ARE STORED IN A DIRECTORY
WHICH OCCUPIES BLOCK ZERO.  NEW FILES ARE ALWAYS ADDED AT THE
END OF THE MEDIUM.  THE BLOCKS TAKEN UP BY A FILE WHICH HAS BEEN
DELETED ARE NOT AVAILABLE UNTIL THE WORD "SQUASH" HAS BEEN EXECUTED.
"SQUASH" SLIDES ALL THE FILES DOWN AND RESTRUCTURES THE DIRECTORY
TO ELIMINATE ALL GAPS.  THE FOLLOWING WORDS CONTROL DIRECTORY
MAINTENANCE AND FILE ACCESS:

ZERO-DIRECTORY	INITIALIZES THE DIRECTORY.  THE PREVIOUS CONTENTS
		OF THE DIRECTORY ARE LOST.

LIST-DIRECTORY	TYPES A DIFCT".  THIS CAUSES
		THE FILE CONTROL TABLE TO BECOME THE CURRENT FILE
		CONTROL TABLE.

IFILE		A 3-WORD FCT AVAILABLE TO THE USER (NORMALLY USED FOR
		INPUT FILE)

OFILE		A 3-WORD FCT AVAILABLE TO THE USER (NORMALLY USED FOR
		OUTPUT FILE)

OPEN		OPENS THE FILE WHOSE NAME IS AT TOP USING THE CURRENT
		FILE CONTROL TABLE.  THE NUMBER OF THE FIRST BLOCK OF
		THE FILE IS STORED IN THE FIRST WORD OF THE FILE CONTROL
		TABLE AND THE OTHER TWO WORDS ARE ZEROED.

WOPEN		OPENS A FILE FOR WRITING; FIEND OF
		THE DIRECTORY IS MOVED DOWN TO THE FIRST FREE BLOCK
		FOLLOWING THE CURRENT FILE.  THIS WORD IS USED ONLY
		WITH FILES WHICH HAVE BEEN OPENED USING "WOPEN" TO
		RELEASE WHATEVER STORAGE IS NOT USED BY THE OUTPUT
		FILE.

CLOSE		ZEROES THE FIRST WORD OF THE CURRENT FILE CONTROL
		TABLE, SIGNALLING IT AS INACTIVE.

GETBYTE		USING THE CURRENT FILE CONTROL TABLE,
		RETURNS THE NEXT BYTE FROM THE FILE.

GETBYTES	USING THE CURRENT FILE CONTROL TABLE, AND TAKING
		A BYTE COUNT AT TOP AND A BUFFER ADDRESS AT TOP - 1,
		THE SPECIFIED NUMBER OF BYTES ARE READ FROM THE FILE
		INTO THE BUFFER.

PUTBYTE		USING THE CURRENT FILE CONTROL TABLE,
		STORES BYTE AT TOP IN NEXT BYTE OF FILE.

PUTBYTES	USING THE CURRENT FILE CONTROL TABLE, AND TAKING
		A BYTE COUNT AT TOP AND A BUFFER ADDRESS AT TOP - 1,
		THE SPECIFIED NUMBER OF BYTES ARE WRITTEN INTO THE FILE
		FROM THE BUFFER.

GPOS		USING THE CURRENT FILE CONTROL TABLE,
		RETURNS A DOUBLE PRECISION INTEGER FILE POSITION
		AT TOP AND TOP - 1HE
		CURRENT FILE CONTROL TABLE IS NOT OPEN.

FSQUASH		REMOVES DELETED ENTRIES FROM THE END OF THE
		DIRECTORY.  DELETED ENTRIES BEFORE THE LAST
		ACTIVE FILE ARE NOT AFFECTED.  FSQUASH IS
		CALLED AUTOMATICALLY AFTER A "DELETE".

MVBLOCKS	TAKES A SOURCE BLOCK NUMBER AT TOP-2, A DESTINATION
		BLOCK NUMBER AT TOP-1, AND A BLOCK COUNT AT TOP.
		A SEQUENTIAL SET OF BLOCKS ARE COPIED FROM THE SOURCE
		BLOCK TO THE DESTINATION BLOCK.

SQUASH		REMOVES ALL DELETED ENTRIES FROM THE DIRECTORY.
		THE RERNS
		THE STARTING BLOCK NUMBER FOR THE FILE.

PRINT		TYPES OUT ON THE SYSTEM CONSOLE THE CONTENTS OF THE
		FILE WHOSE NAME IS AT TOP.

XFER		COPIES THE FILE WHOSE NAME IS AT TOP - 1 TO A FILE
		WHOSE NAME IS AT TOP.  THE DESTINATION FILE IS CREATED
		AT THE END OF THE DIRECTORY; ANY PREVIOUS VERSION IS
		DELETED.


EXAMPLES:

'PRINT : IFILE OPEN BEGIN GETBYTE DUP EOF NE IF TYO REPEAT
  DROP CLOSE ;

THIS EXAMPLE GIVES THE DEFINITIONS OF THE WORD "PRINT" DESCRIBED
ABOVE.  IT IS CALLED WITHBLOCK OF FILE (IN LEAST SIGNIFICANT 9 BITS)
	 (NUMBER OF FIRST FREE BLOCK IF 1ST WORD = 0)

	THE MOST SIGNIFICANT 7 BITS OF THIS WORD
	ARE RESERVED FOR FUTURE USE AS ATTRIBUTE
	BITS.


FILE CONTROL TABLE FORMAT:

WORD	CONTENTS

0	NUMBER OF FIRST BLOCK OF FILE
	(= 0 IF NOT OPEN)

1	CURRENT RELATIVE BLOCK NUMBER

2	CURRENT RELATIVE BYTE NUMBER WITHIN CURRENT BLOCK



SAVING AND RESTORING CORE IMAGES

	TWO WORDS ARE PROVIDED WITHIN THE KERNEL WHICH
ENABLE THE USER TO SAVE A "SNAPSHOT" OF IMAGE FILES MUST BE REGENERATED WHENEVER A NEW VERSION
OF THE KERNEL IS USED SINCE THE NEW USER DEFINITIONS REFERENCE
ABSOLUTE LOCATIONS WITHIN THE KERNEL.

	"RDCI" SIZES MEMORY AFTER READING IN ITS CORE IMAGE AND THEN
RESETS THE WORD "MEMORY" TO THE TOP OF MEMORY.  THIS PERMITS CORE
IMAGES WRITTEN ON ONE MACHINE TO BE USED ON A MACHINE WITH A DIFFERENT
AMOUNT OF MEMORY.

	CORE IMAGE FILES SAVE THE STATE OF THE COMPILE BUFFER AND
PSEUDO-INSTRUCTION POINTER.  THUS, ANY CODE WHICH FOLLOWS THE CALL .  (MOST SIGNIFICANT WORD AT TOP).

SPOS		USING THE CURRENT FILE CONTROL TABLE
		SETS THE FILE POSITION TO THE DOUBLE PRECISION
		INTEGER VALUE AND TOP AND TOP - 1.

EXIST		SEARCHES THE DIRECTORY FOR THE NAME AT TOP.  IF
		FOUND, THE ADDRESS OF THE DIRECTORY ENTRY IS LEFT AT
		TOP.  IF NOT FOUND, THE ERROR "FILE DOES NOT EXIST"
		IS GIVEN.

NOT-EXIST	SEARCHES THE DIRECTORY FOR THE NAME AT TOP.  IF
		FOUND, THE ERROR "FILE ALREADY EXISTS" IS GIVEN.

OPEN?		GIVES THE MESSAGE "FILE NOT OPEN" IF TMAINING FILES ARE MOVED DOWN TO FILL UP
		THE EMPTY SPACE.

SEARCH		SEARCHES THE DIRECTORY FOR THE NAME AT TOP.  IF
		FOUND, A -1 IS RETURNED AT TOP AND A POINTER TO
		THE DIRECTORY ENTRY AT TOP - 1.  IF NOT FOUND,
		A ZERO IS LEFT AT TOP.

DIRECTORY	RETURNS ON THE TOP OF THE STACK THE ADDRESS OF
		THE FIRST BYTE OF A BUFFER CONTAINING THE
		DIRECTORY.

SLOT		RETURNS THE ADDRESS OF THE END-OF DIRECTORY ENTRY
		IN THE DIRECTORY BUFFER.

SBLK		GIVEN THE ADDRESS OF A DIRECTORY ENTRY AT TOP, RETU THE ADDRESS OF A STRING ON THE STACK
WHICH SUPPLIES AN ARGUMENT TO THE WORD "OPEN".  "IFILE" MAKES
THE FILE CONTROL TABLE "IFILE" THE CURRENT FILE CONTROL TABLE.
A LOOP IS THEN ENTERED WHICH GETS THE NEXT BYTE FROM THE FILE
("GETBYTE") AND TYPES IT ("TYO") UNTIL AN EOF IS ENCOUNTERED.
AT THIS POINT, THE FILE IS CLOSED.



DIRECTORY ENTRY FORMAT:

WORD	CONTENTS

0	1ST WORD OF NAME
	 (= -1 IF DELETED)
	 (=  0 IF END OF DIRECTORY)

1	2ND WORD OF NAME

2	3RD WORD OF NAME

3	NUMBER OF FIRST  THE DICTIONARY AND
ALL STOIC VARIABLES IN A FILE AND, AT A LATER TIME, TO
RESTORE THE SAVED STATE OF THE MACHINE AND RESUME EXECUTION.
THEIR USE IS OUTLINED BELOW:

	'FILE WRCI	WRITE A CORE IMAGE INTO THE NAMED FILE

	'FILE RDCI	READ A CORE IMAGE FROM THE NAMED FILE

	THE CONTENTS OF THE I/O BUFFERS ARE NOT SAVED AS PART
OF THE CORE IMAGE FILE, BUT ALL OTHER VARIABLES USED BY THE KERNEL,
THE CONTENTS OF ALL STACKS, THE INTERRUPT DISPATCH TABLE, AND ALL
USER DEFINITIONS ARE TRANSFERRED.

	CORETO
"WRCI" WILL BE EXECUTED UPON LOADING THE CORE IMAGE BY "RDCI".  FOR
EXAMPLE:

	'INITIAL WRCI LIST-DIRECTORY

THIS COMMAND LINE WILL WRITE OUT A CORE IMAGE WITH THE NAME "INITIAL",
AND THEN TYPE OUT A DIRECTORY LISTING.  WHEN THE CORE IMAGE IS READ IN:

	'INITIAL RDCI

THE STATE OF MEMORY WILL BE RESTORED TO THAT AT THE TIME OF THE "WRCI"
AND EXECUTION WILL RESUME AT THE WORD FOLLOWING "WRCI", CAUSING A DIRECTORY
LISTING TO BE GENERATED.

	TO GENERATE A BOOTSTRAPPABLE FILE CONTAINING THE STOIC KERNEL
PLUS ALL CURRENT USER DEFINITIONS, THE FOLLOWING COMMAND IS USED:

	'FILE WRITE-BOOT	WRITES A BOOTSTRAP FILE.

THE BOOTSTRAP FILE CAN THEN BE LOADED DIRECTLY BY THE BOOTSTRAP BY
RESPONDING WITH THE FILENAME TO THE INITIAL PROMPT.  "WRITE-BOOT", LIKE
"WRCI" SAVES THE COMPILE BUFFER AND THUS CODE ENTERED FOLLOWING
"WRITE-BOOT" WILL BE EXECUTED BY THE PROGRAM UPON BEING RELOADED.
THUS, TO SET UP A PROGRAM TO EXECUTE IMMEDIATELY UPON BEING LOADED:

	'PROG WRITE-BOOT GO

THIS GENERATES A ;	FILE	STIOICCPM.DOC	DATE	2/20/78
;
;**********************************************************************
;
;IMPLEMENTED BY WINK SAVILLE OF THE SORRENTO VALLEY ASSOCIATES
;
;THIS DISK CONTAINS THE STOIC SOURCE AND COM FILES. MOST OF THE
;FILES WILL HAVE CORRESPONDING DOC FILES ON ANOTHER DISK. IT IS
;A MUST THAT THEY BE READ PRIOR TO WORKING WITH
;THIS DISK.
;
;THE SUPPLIED STOIC.COM FILE CONTAINS THE KERNEL AND THE STOICBAS.STC FILE.
;THIS COMPRISES THE MINIUM STOIC MACHINE, AND NEEDS ABOUT 1 YY  PAGES LONG
0>

;NOW RETURN TO CPM 

0> RETCPM

;HERE STOIC WILL REBOOT CPM AND RETURN CONTROL

A>

;NOW "SAVE" THIS NEW STOIC

A>SAVE YY STOIC.COM

;IF YOU'VE GOTTEN THIS FAR STOIC SHOULD BE WORKING
;
;*******************************************************
;
;SUPPLIED FILES
;
KERNEL.ASM	=KERNEL SOURCE
STOIC.COM	=STOICBAS+KERNEL+CPMWORDS
STOICFLT.STC	=FLOATING POINT PACKAGE
STOICMIS.STC	=MISCELLANEOUS WORDS
STOICBAS.STC	=BASIC DIFINITIONS
STOICSRT.STC	=SORT ROUTINE
STOICSIN.S;		WINK SAVILLE
;WORK:
;		C/O SORRENTO VALLEY ASSOCIATES
;		11722 SORRENTO VALLEY RD
;		SUITE D
;		SAN DIEGO,CA 92121
;		714-452-0101
;
;
;HOME:
;		PO BOX 458
;		SOLANA BCH,CA. 92075
;		714-753-8905
;
;************************************************************************


***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

STOIC DISPLAY EDITOR
J. SACHS
2/8/77

	THE STOIC DISPLAY EDITOR IS SIMILAR TO THE NOVA DISPLAY
EDITOR.  WHEN INVOKED, IT MODIFIES THE STOIC PROMPT MESSAGE TO
INCLUDE TYPING OUT A SECTION OF TEBOOTSTRAP FILE "PROG" WHICH, WHEN LOADED, WILL
EXECUTE THDFILE, "GET" MUST RETURN AN EOF (^D).

'NAME LOAD-FILE<CR>

WILL THEN COPY FROM THE INPUT DEVICE TO THE NAMED DISK FILE.

8) LOAD THE EDITOR AND ANY OTHER PROGRAMS YOU NEED ONTO THE DISK.

9) THE BASIC DEFINITIONS AND FILE SYSTEM PROGRAMS NEED NOT BE SAVED
   ON THE DISK.


THE LINE DRAWER AND INTERRUPT HANDLER ARE HIGHLY SYSTEM DEPENDENT
AND ARE INCLUDED MAINLY AS GUIDELINES FOR WRITING YOUR OWN ROUTINES.





***EOF***
3000 BYTES
;IN THE TPA TO RUN. I HAVE IMPLEMENTED A "CPMLD" COMMAND WHICH CAN BE
;USED TO LOAD OTHER STC FILES IF DESIRED.
; TO USE BRING UP STOIC WHICH WILL PROMPT WITH

0>

;TO LOAD A STC FILE TYPE

0> 'STOICXXX CPMLD

;WHERE XXX IS ONE OF THE STOIC.STC FILES
; UPON COMPLEMENTION STOIC WILL AGIAN PROMPT WITH

0>

;YOU SHOULD NOW SAVE THIS NEW STOIC USING THE CPM "SAVE" COMMAND
; PRIOR TO THIS COMPUTE THE PRESENT SIZE OF STOIC 

0> SZSTOIC

;THE SZSTOIC COMMAND WILL RESPOND

STOIC ISTC	=INTEGER SIN AND COS
STOICITP.STC	=INTERRUPT PACKAGE
STOICINT.STC	=4 BYTE INTEGER ADDITION AND SUBSTRACTION
STOICFFT.STC	=FAST FOUIER TRANSFORM
STOICEDT.STC	=EDITOR
STOICFLE.STC	=FILE SYSTEM
STOICI/O.STC	=ORGINAL I/O ROUTINES
STOICD/A.STC	=D/A PACKAGE
;
;NOTE THE FILE AND EDITOR ROUTINES REQUIRE MORE EXTENSIVE I/O
;THEN I'VE PRESENTLY IMPLEMENTED 
;
;REFER TO THE KERNEL.ASM FILE FOR MORE DETAILS ON THE
;PRESENT I/O 
;
;GOOD LUCK 
;	FOR ANY ASSISTANCE FEEL FREE TO CALL OR WRITE TO ME 
;
XT ON EITHER SIDE OF THE
CURSOR.  THE CURSOR ITSELF IS DISPLAYED AS A "~".  THE TWO
AUXILLIARY CURSORS (P1 AND P2) ARE DISPLAYED AS "{" AND "}"
RESPECTIVELY.  THE FIRST LINE OF THE DISPLAY GIVES THE INPUT
FILE NAME ("*" IF NONE) FOLLOWED BY THE OUTPUT FILE NAME
("*" IF NONE).  THE EDITOR ALSO MODIFIES THE ERROR MESSAGE HANDLER
TO ERASE THE SCREEN, DISPLAY THE ERROR MESSAGE, AND WAIT FOR A
CARRIAGE RETURN TO RESTORE THE NORMAL TEXT DISPLAY.  A LIST OF EDITOR
COMMANDS FOLLOWS:

COMMAND	DESCRIPTION

EDIT	ENTER EDITOR

H	EXIT EDITOR

B	MOVE CURSOR TO BEGINNING OF TEXT BUFFER
Z	MOVE CURSOR TO END OF TEXT BUFFER

N M	MOVE CURSOR N CHARACTERS (N MAY BE NEGATIVE)
N L	MOVE CURSOR N LINES (N MAY BE NEGATIVE)

N <M>	SET P1 AT CURRENT CURSOR LOCATION, MOVE N
	CHARACTERS, SET P2 AT CURRENT CURSOR LOCATION,
	SWAP P1 AND P2 IF P1 > P2.

N <L>	SET P1 AT CURRENT CURSOR LOCATION, MOVE N
	LINES, SET P2 AT CURRENT CURSOR LOCATION,
	SWAP P1 AND P2 IF P1 > P2.

<ALL>	SET P1 TO BEGINNING OF TEXT BUFFER FLAG IS ZERO,
	 SEARCH BACKWARDS, STARTING AT THE CURRENT CURSOR LOCATION FOR
	 THE SPECIFIED STRING.  IF FOUND, P1 AND THE CURSOR POINT TO
	 THE BEGINNING OF THE STRING, P2 POINTS TO THE END AND
	 A -1 IS RETURNED ON THE STACK.  IF NOT FOUND, A ZERO
	 IS RETURNED ON THE STACK.

'STR S	SEARCH FOR THE GIVEN STRING.  IF NOT FOUND, THE ERROR
	"MISSING" IS GIVEN.

'STR BS	BACKWARDS SEARCH FOR THE GIVEN STRING.  IF NOT FOUND,
	THE ERROR "MISSING" IS GIVEN.

<N>	SIMILAR TO <S>, EXECPT THAN IF THE STHE INSERT WILL NOT FIT, THE ERROR "CORE FULL" IS
	GIVEN.

<IL>	GIVEN BYTE COUNT AT TOP AND BYTE POINTER AT TOP - 1,
	INSERT THE SPECIFIED STRING FOLLOWED BY A RETURN.

<IP>	GIVEN BYTE COUNT AT TOP AND BYTE POINTER AT TOP - 1,
	INSERT THE SPECIFIED STRING FOLLOWED BY A FORM FEED.

'STR IS	INSERT STRING.
'STR IL	INSERT STRING FOLLOWED BY RETURN.
'STR IP	INSERT STRING FOLLOWED BY FORM FEED.
ICR	INSERT A RETURN.
IFF	INSERT A FORM FEED.
N I#	CONVERT N TO A STRING AND INSERT IT.

I/	CAUSES THE EDISTRING 1 TO STRING 2.
'STR1 'STR2 BC	BACKWARDS CHANGE STRING 1 TO STRING 2.
'STR1 'STR2 V	CHANGE STRING 1 TO STRING 2; A GLOBAL SEARCH ("N") FOR
		STRING 1 IS PERFORMED.

'STR SD		SEARCH FOR AND DELETE STRING.

'STR1 'STR2 CC	CONDITIONAL CHANGE STRING 1 TO STRING 2.
'STR1 'STR2 BCC	BACKWARDS CONDITIONAL CHANGE STRING 1 TO STRING 2.
'STR1 'STR2 CV	CONDITIONAL CHANGE STRING 1 TO STRING 2
		A GLOBAL SEARCH ("N") FOR STRING 1 IS PERFORMED.

		CONDITIONAL CHANGES FIRST SEARCH FOR STRING 1

		IF NOTCOPY N LINES INTO THE "X" BUFFER.

N XM	MOVE N CHARACTERS INTO THE "X" BUFFER.
N XML	MOVE N LINES INTO THE "X" BUFFER.

XG	INSERT THE CONTENTS OF THE "X" BUFFER AT THE CURRENT
	CURSOR LOCATION.

'FILE GR	OPEN THE SPECIFIED FILE FOR INPUT
'FILE GW	OPEN THE SPECIFIED FILE FOR OUTPUT

GX		FLUSH INPUT AND OUTPUT FILES
		OUTPUT FILE IS DELETED.

'FILE O	OPEN THE SPECIFIED FILE FOR INPUT,
	OPEN "<EDSC>" FOR OUTPUT,
	DO A "1 YP" TO READ THE FIRST PAGE
	OF THE INPUT FILE.

W	IF THERE IS AN INPUT , SET P2 TO
	END OF TEXT BUFFER.

LINE#	PUSH THE LINE NUMBER OF THE LINE CONTAINING THE CURSOR.  LINE
	NUMBERS START AT ZERO.

<S>	GIVEN A FLAG AT TOP-2, A POINTER AT TOP-1 AND A BYTE COUNT AT TOP;

	IF THE FLAG IS NON-ZERO,
	 SEARCH FORWARDS, STARTING AT THE CURRENT CURSOR LOCATION FOR
	 THE SPECIFIED STRING.  IF FOUND, P1 POINTS TO THE BEGINNING
	 OF THE STRING, P2 AND THE CURSOR POINT TO THE END AND
	 A -1 IS RETURNED ON THE STACK.  IF NOT FOUND, A ZERO
	 IS RETURNED ON THE STACK.

	IF THERING IS NOT FOUND,
	A "1 R" IS EXECUTED AND THE SEARCH IS CONTINUED ON THE
	NEXT PAGE.  THE SEARCH FAILS IF EOF IS ENCOUNTERED.

'STR N	GLOBAL SEARCH FOR THE GIVEN STRING.  IF NOT FOUND, THE
	ERROR "MISSING" IS GIVEN.

<D>	DELETE THE TEXT BETWEEN P1 AND P2.

D	DELETE N CHARACTERS STARTING AT THE CURSOR.
DL	DELETE N LINES STARTING AT THE CURSOR.
DA	DELETE THE ENTIRE TEXT BUFFER.

<I>	GIVEN BYTE COUNT AT TOP AND BYTE POINTER AT TOP - 1,
	INSERT THE SPECIFIED STRING AT THE CURSOR LOCATION.
	IF TTOR TO ENTER INSERT MODE; THE DISPLAY IS REDRAWN
	MINUS THE TEXT FOLLOWING THE CURSOR.  ALL CHARACTERS TYPED IN
	AT THE KEYBOARD ARE INSERTED INTO THE TEXT BUFFER UP TO THE
	THE FIRST ESCAPE CHARACTER.  AT THIS POINT, NORMAL DISPLAY IS
	RESUMED.  RUBOUT OR NULL MAY BE USED TO DELETE THE LAST CHARACTER
	OR THE ENTIRE INSERT RESPECTIVELY.  THE ASCII CODE FOR THE ESCAPE
	CHARACTER MAY BE RESET BY MODIFYING THE VARIABLE "ESC".

'STR U		DELETE TEXT BETWEEN P1 AND P2, INSERT STRING.
'STR1 'STR2 C	CHANGE  FOUND, THE ERROR "MISSING" IS GIVEN

		IF FOUND, THE COMMAND WAITS FOR THE OPERATOR
		TO TYPE A KEY

		IF A LINE FEED IS TYPED, STRING 1 IS REPLACED BY
		STRING 2 AND ANOTHER SEARCH FOR STRING 1 IS
		PERFORMED.

		IF A CARRIAGE RETURN IS TYPED, STRING 1 IS NOT
		REPLACED BY STRING 2 AND ANOTHER SEARCH FOR
		STRING 1 IS PERFORMED.

		IF ANY OTHER KEY IS TYPED, THE COMMAND RETURNS.

<XC>	COPY THE TEXT BETWEEN P1 AND P2 INTO THE "X" BUFFER.

N XC	COPY N CHARACTERS INTO THE "X" BUFFER.
N XCL	FILE, ANY REMAINING PAGES
	ARE COPIED INTO THE OUTPUT FILE, TWO EOF'S ARE
	OUTPUT, THE OUTPUT FILE IS CLOSED, THE INPUT FILE
	IS DELETED AND THE OUTPUT FILE IS RENAMED TO THE
	INPUT FILE.

	IF THERE IS NO INPUT FILE, THE TEXT BUFFER IS
	WRITTEN OUT, FOLLOWED BY TWO EOF'S AND THE
	OUTPUT FILE IS CLOSED.

'FILE WR
	IF THERE IS AN INPUT FILE, ANY REMAINING PAGES
	ARE COPIED INTO THE OUTPUT FILE, TWO EOF'S ARE
	OUTPUT, THE OUTPUT FILE IS CLOSED, THE OUTPUT
	FILE IS RENAMED TO THE THE GIVEN FILE NAME.

	IF THERE IS NO INPUT FILE, THE TEXT BUFFER IS
	WRITTEN OUT, FOLLOWED BY TWO EOF'S AND THE
	OUTPUT FILE IS RENAMED TO THE GIVEN FILE NAME.

WO	WRITE OUT THE CURRENT FILE AND REOPEN IT; I.E. START
	A NEW EDIT PASS.

'FILE WRO
	WRITE OUT THE CURRENT FILE AND RENAME IT.  OPEN THE
	NEW FILE.  THE ORIGINAL INPUT FILE REMAINS INTACT.

<P>	OUTPUT TEXT BETWEEN P1 AND P2
PEOF	OUTPUT AN EOF.
N P	OUTPUT N CHARACTERS STARTING AT CURSOR.
N PL	OUTPUT N LINES STARTING AT CURSOR.
PA	OUTPUT ENTIRE TEXT EOF.

N YP	DELETE TEXT BUFFER AND APPEND N PAGES.
	GIVE ERROR ON EOF.

N <R>	OUTPUT TEXT BUFFER AND READ NEXT N PAGES
	LEAVE EOF FLAG ON STACK.

N R	OUTPUT TEXT BUFFER AND READ NEXT N PAGES.
	GIVE ERROR ON EOF.

FL	DISPLAYS THE DIRECTORY.  NORMAL DISPLAY IS
	RESTORED BY TYPING RETURN.

<T>	TYPE TEXT BETWEEN P1 AND P2.

N T	TYPE N CHARACTERS STARTING AT CURSOR.

N TL	TYPE N LINES STARTING AT CURSOR.

TA	TYPE ENTIRE TEXT BUFFER.


NOTE:

	WHEN GENERATING A CORE IMAGE OF THE EDITOR, T

***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

FLOATING POINT
J. SACHS 2/2/77

FLOATING POINT IN ADDED TO STOIC BY LOADING THE FILE "FP".
SUBSEQUENT TO LOADING "FP", FLOATING POINT LITERALS ARE
RECOGNIZED BY STOIC, AND A SET OF FLOATING POIADDRESS), THE FRACTION IS AT (ADDRESS+2).

FLOATING POINT LITERALS ARE THE SAME AS INTEGER LITERALS EXCEPT THAT THEY
MAY INCLUDE A DECIMAL POINT AND MAY OPTIONALLY BE FOLLOWED BY AN "E"
FOLLOWED BY AN EXPONENT.  EMBEDDED SPACES WITHIN THE LITERAL ARE NOT ALLOWED.
FLOATING POINT LITERALS ARE ALWAYS DECIMAL.

EXAMPLES:

1.
2.0E-1
+12.345
-5.0E-3

THE FOLLOWING WORDS MAKE UP THE FLOATING POINT PACKAGE:

FCONSTANT	DEFINES A FLOATING POINT CONSTANT
FVARAIBLE	DEFINES A FLOATING POINT VARIABLE

T ADD

F-	FLOATING POINT SUBTRACT

F*	FLOATING POINT MULTIPLY

F/	FLOATING POINT DIVIDE

F+!	FLOATING POINT ADD TO MEMORY

FLOAT	CONVERT THE INTEGER AT TOP TO FLOATING POINT

INTEGER	TRUNCATE THE FLOATING POINT NUMBER AT TOP-1,TOP TO
	AN INTEGER.

FRAC	PUSH THE FRACTION PART OF THE FLOATING POINT NUMBER
	ON THE TOP OF THE STACK

FMOD	FLOATING POINT MOD FUNCTION.
	COMPUTED AT ARG2*FRAC(ARG1/ARG2)

FLTZ	FLOATING POINT LESS THAN ZERO
FLEZ	FLOATING POINT LESS THAN OR EQUAL TO ZERO
FGTZ	FL BUFFER.

M N <A>	APPEND M LINES USING CHARACTER N AS A LINE TERMINATOR.
	LEAVE EOF FLAG ON STACK.

N <AL>	APPEND N LINES.
	LEAVE EOF FLAG ON STACK.

N <AP>	APPEND N PAGES.
	LEAVE EOF FLAG ON STACK.

N AL	APPEND N LINES.
	GIVE ERROR ON EOF.

N AP	APPEND N PAGES.
	GIVE ERROR ON EOF.

N <YL>	DELETE TEXT BUFFER AND APPEND N LINES.
	LEAVE EOF FLAG ON STACK.

N <YP>	DELETE TEXT BUFFER AND APPEND N PAGES.
	LEAVE EOF FLAG ON STACK.

N YL	DELETE TEXT BUFFER AND APPEND N LINES.
	GIVE ERROR ONHE FOLLOWING
PROCEDURE SHOULD BE USED:

'ED LOAD
'EDCI WRCI EDIT

THIS WILL WRITE OUT AN EDITOR CORE IMAGE "EDCI" WHICH MAY BE USED
ON MACHINES WITH DIFFERENT AMOUNTS OF MEMORY, SINCE ALL THE EDITOR
POINTERS ARE RE-INITIALIZED EVERY TIME IT IS READ IN.



***EOF***
ITH DIFFERENT AMOUNTS OF MEMORY, SINCE ALL THE EDITOR
POINTERS ARE RE-INITIALIZED EVERY TIME IT IS READNT WORDS ARE
DEFINED.  THE FORMAT OF FLOATING POINT NUMBERS IS AS
FOLLOWS:

	BYTE	CONTENTS	FORMAT

	0	SIGN		=0 FOR POSITIVE
				=80 HEX FOR NEGATIVE

	1	EXPONENT 	8-BIT 2'S COMPLEMENT

	2,3	FRACTION	UNSIGNED BINARY
				BINARY POINT IS JUST LEFT OF THE MSB

	WHEN A FLOATING POINT NUMBER IS ON THE STACK, THE SIGN/EXPONENT
WORD IS ON TOP, THE FRACTION IS AT TOP - 1.  PRECISION IS BETTER THAN 4 1/2
DECIMAL PLACES.  WHEN A FLOATING POINT NUMBER IS STORED IN MEMORY, THE
SIGN/EXPONENT WORD IS AT (EXAMPLES:

	2.71828 'E FCONSTANT
	0.0 'X FVARAIBLE

PI	A FLOATING POINT CONSTANT EQUAL TO 3.1416

F@	PUSHES THE FLOATING POINT NUMBER ADDRESSED BY THE TOP
	OF THE STACK.

F!	STORES THE FLOATING POINT NUMBER AT TOP - 1 AND TOP - 2
	AT THE ADDRESS AT TOP.

D2OVER	PUSH A COPY OF TOP-3,TOP-2

D3OVER	PUSH A COPY OF TOP-5,TOP-4

D2UNDER	STORE TOP-1,TOP AT TOP-5,TOP-4

D3UNDER	STORE TOP-1,TOP AT TOP-7,TOP-6

FMINUS	FLOATING POINT NEGATE

FABS	FLOATING POINT ABSOLUTE VALUE

F+	FLOATING POINOATING POINT GREATER THAN ZERO
FGEZ	FLOATING POINT GREATER THAN OR EQUAL TO ZERO
FEQZ	FLOATING POINT EQUAL TO ZERO
FNEZ	FLOATING POINT NOT EQUAL TO ZERO

FLT	FLOATING POINT LESS THAN
FLE	FLOATING POINT LESS THAN OR EQUAL TO
FGT	FLOATING POINT GREATER THAN
FGE	FLOATING POINT GREATER THAN OR EQUAL TO
FEQ	FLOATING POINT EQUAL TO
FNE	FLOATING POINT NOT EQUAL TO

FSQRT	FLOATING POINT SQUARE ROOT
FSIN	FLOATING POINT SINE (ARGUMENT IN RADIANS)
FCOS	FLOATING POINT COSINE (ARGUMENT IN RADIANS)
FATAN	FLOATING POINT ARCTANGENT (SINGLE ARGUMENT, RESULT IN RADIANS)
FLN	FLOATING POINT LOG BASE E
FLOG2	FLOATING POINT LOG BASE 2
FLOG10	FLOATING POINT LOG BASE 10
FEXP	FLOATING POINT EXPONENTIAL BASE E
2.0**	FLOATING POINT EXPONENTIAL BASE 2
10.0**	FLOATING POINT EXPONENTIAL BASE 10

F=	FLOATING POINT E-FORMAT PRINT
F?	PRINT FLOATING POINT NUMBER ADDRESSED BY TOP OF STACK

FLITERAL
	ACCEPTS A STRING ARGUMENT AT TOP AND ATTEMPTS
	TO CONVERT THE STRING TO A FLOATING POINT NUMBER.
	IF SUCCESSFUL, A -1RAND	RETURNS A RANDOM FLOATING POINT NUMBER UNIFORMLY DISTRIBUTED
	BETWEEN 0.0 AND 1.0.



***EOF***

T AT TOP - 1)

F


***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

THE STOIC INTERRUPT HANDLER
J. SACHS 2/2/77

	INTERRUPT SERVICE ROUTINES MUST BE WRITTEN IN
ASSEMBLER.  THE FOLLOWING PROCEDURE MAY BE USED TO DEFINE
AN INTERRUPT SERVICE ROUTINE:

FOR DEVIER, REMOVE DATA FROM A CIRCULAR
BUFFER OR MODIFY FLAGS.

	TO SERVICE AN INTERRUPT HAVING ITS OWN RESTART,
THE FOLLOWING SEQUENCE IS USED:

. ASSEMBLER<
PSW PUSH,  B PUSH,  D PUSH,  H PUSH,
	.
	.
	.
DISMISS JMP, >
2001 RESTART# 3 * + !

WHERE RESTART# IS THE RESTART NUMBER.

WHEN THE INTERRUPT HANDLER IS LOADED, "RDCI" AND "WRCI"
WILL SAVE AND RESTORE THE RESTART LOCATIONS (2000 TO 2018 HEX).
IN ADDITION, THE TTY KEYBOARD IS RUN UNDER INTERRUPTS, WITH
A CIRCULAR BUFFER (SIZE GIVEN BY "TTIS

***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

INITIAL LOADING OF STOIC
J. SACHS 2/15/77

	STOIC REQUIRES A 24K BYTE SYSTEM WITH A MASS STORAGE DEVICE
AND TERMINAL OR TELETYPE.

	TO GENERATE A VERSION OF STOIC FOR A NEW SYSTEM, THE FOLLOWI IS LEFT AT TOP, AND THE VALUE IS
	RETURNED AT TOP - 1 AND TOP - 2.  IF NOT SUCCESSFUL,
	A ZERO IS RETURNED AT TOP.

<LSQ	INITIATE A LINEAR LEAST SQUARES FIT.

LSQ	ACCEPTS TWO FLOATING POINT NUMBERS, A Y COORDINATE AT TOP
	AND AN X COORDINATE BENEATH.  THIS POINT (X,Y) IS PROCESSED.

LSQ>	WHEN "LSQ" HAS BEEN CALLED FOR ALL INPUT POINTS, "LSQ>" IS
	CALLED, RETURNING THE SLOPE AND INTERCEPT OF THE LINEAR LEAST
	SQUARES FIT TO THE GIVEN POINTS.  (SLOPE RETURNED AT TOP,
	Y-INTERCEPT AT TOP - 1)

FCES INTERRUPTING VIA RST 7:

. ASSEMBLER<
	.
	.
	.

DISMISS JMP, >
DEVC INTERRPUT

	THIS LEAVES A POINTER ON THE STACK TO AN
INTERRUPT ROUTINE WHICH TERMINATES IN A JMP DISMISS.
THE ADDRESS AND DEVICE CODE ("DEVC") ARE THEN USED
AS ARGUMENTS TO "INTERRUPT" WHICH STORES THE INTERRUPT
SERVICE ROUTINE ADDRESS IN THE INTERRUPT DISPATCH TABLE.
THE STOIC INTERRUPT HANDLER SAVES AND RESTORES ALL ACTIVE
REGISTERS.

NORMALLY, AN INTERRUPT SERVICE ROUTINE WILL EITHER PLACE
DATA INTO A CIRCULAR BUFFZ").  TYPING (CONTROL A)
WILL CAUSE AN UNCONDITIONAL JUMP TO "ABORT".  "ABORT" IS
MODIFIED TO ENABLE INTERRUPTS AND KEYBOARD INTERRUPTS AND TO
RESET THE KEYBOARD CIRCULAR BUFFER.



***EOF***

ORT" IS
MODIFIED TO ENABLE INTERRUPTS AND KEYBOARD ING
STEPS MUST BE FOLLOWED:

BOOTSTRAP

REWRITE THE BOOTSTRAP AS NECESSARY TO RUN YOUR TERMINAL AND MASS
STORAGE DEVICE.  THE FOLLOWING ROUTINES MUST BE PROVIDED:

	TTYIN	ACCEPT A CHARACTER FROM THE TERMINAL

		CALL TTYIN
		CHARACTER RETURNED IN A, PARITY BIT ZERO

	TTYOU	TYPE A CHARACTER ON THE TERMINAL

		CHARACTER IN A
		CALL TTYOU

	DSKIN	READ BLOCKS FROM THE MASS STORAGE DEVICE

		BC CONTAINS A BLOCK COUNT
		DE CONTAINS THE BUFFER ADDRESS
		   (THE ADDRESS INTO WHICH THE FIRST BYTE MUST BE READ)
		HL CONTAINS THE FIRST BLOCK NUMBER
		CALL DSKIN
		ERROR CODE RETURNED IN A (ZERO IF OK)

	DSKOU	WRITE BLOCKS FROM THE MASS STORAGE DEVICE

		BC CONTAINS A BLOCK COUNT
		DE CONTAINS THE BUFFER ADDRESS
		   (THE ADDRESS FROM WHICH THE FIRST BYTE MUST BE WRITTEN)
		HL CONTAINS THE FIRST BLOCK NUMBER
		CALL DSKOU
		ERROR CODE RETURNED IN A (ZERO IF OK)

	THE PARAMETER "BSIZE" MUST BE SET TO THE BLOCK SIZE (IN
	BYTES) FOR THE MASS STORAGE DEVICE.  IF THE DEVICE USES
	EXCESSIVELY ENTER THE ADDRESS OF TTYIN, TTYOU, DSKIN, AND DSKOU AS PARAMETERS
IN THE KERNEL.

ENTER PARAMETER VALUES FOR BCKSP AND TABS FOR YOUR TERMINAL; IF
YOUR TERMINAL CAN BACKSPACE, BUT DOES NOT USE THE ASCII BACKSPACE
CHARACTER TO DO THIS, MODIFY THE CODE IN "RDLINE" TO BACKSPACE
YOUR TERMINAL.

ADJUST THE ORIGIN OF STOIC FOR YOUR SYSTEM.

CHOOSE STACK SIZES, COMPILE BUFFER SIZE, ETC,.

ENTER THE PARAMETER "BSIZE" THE SAME AS IN THE BOOTSTRAP.
ENTER THE PARAMETER "NBLKS", THE NUMBER OF AVAILABLE DISKARY TO REFLECT
THE BLOCK SIZE (IN BYTES) AND THE TOTAL AVAILABLE NUMBER OF BLOCKS
ON THE MASS STORAGE DEVICE, RESPECTIVELY.  (NBLKS MUST BE LESS THAN
OR EQUAL TO 512 DECIMAL)

REMOVE OR MODIFY THE WORD "DISK-COPY" WHICH COPIES AN ENTIRE DISK
FROM ONE UNIT TO ANOTHER.

MODIFY THE CODE TO SIZE MEMORY IN "(RDCI)", AS IN THE KERNEL AND
BOOTSTRAP.

MODIFY THE CONSTANT "2000" IN "WRITE-BOOT" TO THE 1ST RAM LOCATION
IN YOUR SYSTEM (HEX).


EDITOR

MODIFY THE VALUE OF THE VARIABLE "ESC" TO CORRESPO'H : GX > ;
	'EDIT : GX EDITOR<
	  MEMORY @ DUP LAST ! DUP XLAST ! DUP CP ! DUP P1 ! P2 ! ;


LOADING STOIC

<CR> STANDS FOR THE CARRIAGE RETURN KEY

1) COPY THE BASIC DEFINITIONS AND FILE SYSTEM PROGRAMS ONTO THE
   DISK AS TWO SETS OF CONTIGUOUS BLOCKS.  WRITE DOWN THE STARTING
   BLOCK # FOR EACH PROGRAM.  WHEN COPYING THE TWO PROGRAMS ONTO THE
   DISK, NOTE THAT LINES ARE TERMINATED BY CARRIAGE RETURN ONLY;
   NO LINE FEEDS SHOULD BE INSERTED INTO THE FILES.

2) ASSEMBLE STOIC AND LOAD ITACTER-ORIENTED INPUT DEVICE ONTO
   A DISK FILE, TYPE IN THE FOLLOWING PROGRAM:

'GET : ... ;

'LOAD-FILE : OFILE WOPEN
   BEGIN GET DUP PUTBYTE EOF EQ END
   EOF PUTBYTE SHRINK CLOSE FLUSH ;

WHERE "GET" DEFINES A WORD WHICH RETURNS THE NEXT BYTE OF THE FILE
ON THE STACK.  AT THE END OF THE FILE, "GET" MUST RETURN AN EOF (^D).

'NAME LOAD-FILE<CR>

WILL THEN COPY FROM THE INPUT DEVICE TO THE NAMED DISK FILE.

8) LOAD THE EDITOR AND ANY OTHER PROGRAMS YOU NEED ONTO THE DISK.

9) THE BASIC SMALL BLOCKS, < 512 BYTES, IT MAY BE ADVANTAGEOUS
	TO WRITE DSKIN AND DSKOU TO TRANSFER MULTIPLE PHYSICAL
	RECORDS AS A SINGLE LOGICAL RECORD.

	THE PARAMETER "RAM" SHOULD BE SET TO THE FIRST RAM LOCATION
	OF YOUR SYSTEM.

	CODE TO PROCESS RESTARTS (IF ANY) SHOULD BE INCLUDED IN THE
	BOOTSTRAP.

	THE PROGRAM AT "SIZE" SHOULD BE MODIFIED TO SIZE MEMORY FOR
	YOUR SYSTEM.  THIS PROBABLY MEANS MODIFYING THE CONSTANT
	"0C000H" TO "0".

COMMIT THE BOOTSTRAP TO READ-ONLY MEMORY.


STOIC KERNEL

 BLOCKS.

REPLACE THE CODE AT 2000H WITH CODE TO PROCESS RESTARTS FOR YOUR
SYSTEM.  NOTE THAT THE FIRST RAM LOCATION OF YOUR SYSTEM SHOULD
CONTAIN A "JMP ABORT".

ENTER TEXT FOR THE ERROR CODES FOR THE MASS STORAGE DEVICE IN
"RDERC" AND "WRERC".

MODIFY CODE AT "SIZE" TO SIZE MEMORY ON YOUR SYSTEM AND SET THE
VARIABLE "?MEMO" TO THE ADDRESS OF THE LAST USABLE RAM LOCATION + 1.
THIS IS THE SAME MODIFICATION AS IN THE BOOTSTRAP.


FILE SYSTEM

MODIFY THE CONSTANTS "BSIZE" AND "NBLKS" AS NECESSND TO AN APPROPRIATE
CHARACTER FOR YOUR TERMINAL. (E.G. ALT MODE FOR AN ASR 33)

MODIFY THE EDITOR WORD "DISPLAY-CURSORS" TO DISPLAY REASONABLE
CHARACTERS AS CURSORS.  (FOR A TTY, "[", "]", AND "$" ARE SUGGESTED)

MODIFY THE EDITOR WORD "ERASE" TO ERASE THE SCREEN AND HOME THE CURSOR
ON YOUR TERMINAL.

IF YOU ARE USING A TELETYPE INSTEAD OF A DISPLAY TERMINAL, DELETE THE
FOLLOWING WORDS:

	DISPLAY-CURSORS
	DISPLAY-CHAR
	DISPLAY
	ERASE
	EDIT-PROMPT
	ERRS

REDEFINE THE FOLLOWING WORDS:

	 INTO MEMORY; START AT "SIZE".

3) TYPE "N LOAD<CR>" WHERE N IS THE FIRST BLOCK NUMBER OF THE BASIC
   DEFINITIONS PROGRAM ON THE DISK.

4) TYPE "N LOAD<CR>" WHERE N IS THE FIRST BLOCK NUMBER OF THE FILE
   SYSTEM PROGRAM ON THE DISK.

5) TYPE "ZERO-DIRECTORY<CR>".

6) TYPE "'STOIC WRITE-BOOT<CR>" TO MAKE A BOOTSTRAPPABLE VERSION
   OF STOIC ON THE DISK.  FROM THIS POINT ON, THE BOOTSTRAP SHOULD
   LOAD STOIC BY ANSWERING "STOIC<CR>" TO THE QUESTION "FILENAME ? ".

7) TO LOAD FILES FROM A CHARDEFINITIONS AND FILE SYSTEM PROGRAMS NEED NOT BE SAVED
   ON THE DISK.


THE LINE DRAWER AND INTERRUPT HANDLER ARE HIGHLY SYSTEM DEPENDENT
AND ARE INCLUDED MAINLY AS GUIDELINES FOR WRITING YOUR OWN ROUTINES.



***EOF***






RE HIGHLY SY

***************************************************************************
** COPYRIGHT (C) MASSACHUSETTS INSTITUTE OF TECHNOLOGY AND HARVARD       **
** UNIVERSITY, BIOMEDICAL ENGINEERING CENTER 1977.  ALL RIGHTS RESERVED. **
***************************************************************************

STOIC  (STACK ORIENTED INTERACTIVE COMPILER)
J. SACHS
2/14/77

	STOIC IS A GENERAL PURPOSE INTERACTIVE PROGRAM
WHICH INCORPORATES THE CAPABILITIES OF A COMPILER, EDITOR
ASSEMBLER, DEBUGGER, LOAME; A LEGAL NAME FOR A WORD IS ANY STRING OF UP TO 127
ASCII CHARACTERS.  PUNCTUATION, NUMERICS, AND MOST OTHER
SPECIAL CHARACTERS MAY BE FREELY USED WITHIN A NAME.  TWO
NAMES ARE EQUIVALENT IF AND ONLY IF THEIR FIRST FIVE CHARACTERS
ARE THE SAME AND THEY HAVE EXACTLY THE SAME LENGTH.  ILLEGAL
CHARACTERS WITHIN A NAME ARE:

	SPACE
	TAB
	CARRIAGE RETURN
	FORM FEED
	LINE FEED
	RUBOUT
	NULL

EXAMPLES:

ABCDE   IS NOT EQUIVALENT TO  ABCDEF
(HEAD1) IS EQUIVALENT TO      (HEAD2)

	A LITERAL I5535 IF
UNSIGNED.

EXAMPLES:

-1234	IS A LEGAL LITERAL
+-100	IS NOT A LEGAL LITERAL
-AFC0	IS A LEGAL LITERAL IF RADIX IS HEXADECIMAL


	STRING LITERALS MAY TAKE ONE OF THREE FORMS:
1) A STRING ENCLOSED IN DOUBLE QUOTES:

 "STRING"

2) A STRING ENCLOSED IN BACKSLASHES:

 \STRING\

3) A STRING PRECEDED BY SINGLE QUOTE AND TERMINATED BY SPACE OR TAB:

 'STRING

IN ANY OF THE ABOVE TYPES OF STRING LITERAL, THE END OF THE
LINE (RETURN OR FORM FEED) MAY SERVE AS A TERMINATOR.  SPECIAL
CHARDS BASED ON WORDS WHICH HAVE
ALREADY BEEN DEFINED.  AN INITIAL VOCABULARY OF ABOUT ONE
HUNDRED WORDS CALLED THE KERNEL ENABLES THE USER TO GET
STARTED.

	THE PRINCIPAL VEHICLE FOR COMMUNICATION BETWEEN
WORDS IS THE PARAMETER STACK, FREQUENTLY CALLED "THE
STACK".   TYPICALLY, THE PARAMETERS UPON WHICH A WORD WILL
OPERATE ARE PUSHED ON THE STACK, THE WORD POPS ITS
PARAMETERS FROM THE STACK AND PUSHES ITS RESULTS ON THE
STACK.  COMMUNICATION THROUGH VARIABLES IN FIXED
LOCATIONS IS ALSO USED.

	STOF WORDS WHICH PUSH
NUMBERS ON THE STACK; LITERALS, CONSTANTS, AND VARIABLES.
A REFERENCE TO A LITERAL OR A CONSTANT CAUSES ITS VALUE
TO BE PUSHED ON THE STACK.  A REFERENCE TO A VARIABLE
CAUSES ITS ADDRESS TO BE PUSHED ON THE STACK.  THE TWO
OPERATORS "@" AND "!" ARE USED TO OBTAIN AND MODIFY THE
VALUE OF A VARIABLE.  THEY ARE DEFINED AS FOLLOWS:

	@	REPLACE THE ADDRESS ON THE TOP OF THE
		STACK BY THE CONTENTS OF THAT ADDRESS.
		THIS WORD IS USED TO LOAD THE CONTENTS
		OF A MEMORY LOCATION ONTOADER, AND OPERATING SYSTEM WITHIN
A SINGLE CONSISTENT ARCHITECTURE.  IT IS CORE-EFFICIENT
WHILE RETAINING HIGH RUNNING SPEEDS.  IN ADDITION, THE
LANGUAGE IS EXTREMELY FLEXIBLE, PERMITTING THE USER TO
DEVELOP A WORKING VOCABULARY OF SUBROUTINES TAILORED TO
HIS SPECIFIC APPLICATION.

	THE SINGLE MOST PROMINENT FEATURE OF STOIC IS ITS
PRINCIPAL DATA STRUCTURE, CALLED THE DICTIONARY.  THE
DICTIONARY IS AN ORDERED LIST OF ENTRIES CALLED WORDS.
ASSOSCIATED WITH THE DICTIONARY ENTRY FOR EACH WORD IS A
NS A SEQUENCE OF CHARACTERS WHICH DESCRIBES
A CONSTANT.  THE BASIC STOIC SUPPORTS TWO TYPES OF LITERAL;
16-BIT INTEGER AND STRING.  THE LANGUAGE MAY BE EXTENDED TO
INCLUDE OTHER DATA TYPES SUCH AS FLOATING POINT OR DOUBLE
PRECISION INTEGER.

	AN INTEGER LITERAL IS A SEQUENCE OF DIGITS
OPTIONALLY PRECEDED BY A PLUS OR MINUS SIGN.  ALL DIGITS
MUST BE LESS THAN THE CURRENT RADIX.  NO SPACES MAY BE
EMBEDDED WITHIN THE LITERAL.  INTEGER LITERAL MUST BE IN
THE RANGE OF -32768 TO 32767 IS SIGNED OR 0 TO 6RACTERS SUCH AS RETURN, RUBOUT, ETC. MAY BE INCLUDED IN A
STRING LITERAL BY ENCLOSING THE CORRESPONDING OCTAL ASCII CODE
BETWEEN TWO AMPERSANDS (&).

EXAMPLES:

"THIS IS A STRING LITERAL"
\THIS LITERAL CONTAINS A RETURN &15&\
'&177&&15&


	STOIC SYNTAX IS QUITE SIMPLE.  A LEGAL COMMAND
LINE CONSISTS OF A SEQUENCE OF LITERALS AND/OR NAMES OF WORDS
SEPARATED BY SPACES OR TABS, AND TERMINATED BY CARRIAGE
RETURN OR FORM FEED.

	PROGRAMMING IN STOIC CONSISTS PRIMARILY OF
DEFINING A SET OF NEW WOOIC USES REVERSE POLISH NOTATION FOR ALL
OPERATIONS.  THIS MEANS THAT ALL OPERANDS PRECEDE THEIR
OPERATORS;  PARENTHESES ARE NEVER NECESSARY.

EXAMPLES:

1 1 + 2 *   IN ALGEBRAIC NOTATION IS   (1+1)*2
1 2 3 * -   IN ALGEBRAIC NOTATION IS   1-(2*3)

	UNLIKE MOST OTHER HIGER LEVEL LANGUAGES, STOIC
ENABLES THE USER TO MANIPULATE ADDRESSES AS WELL AS DATA.
IT IS VERY IMPORTANT HOWEVER FOR THE USER TO REMAIN AWARE
OF THE DISTINCTION BETWEEN AN ADDRESS AND ITS CONTENTS.
	THERE ARE THREE COMMON TYPES  THE STACK.

	!	STORE AT THE ADDRESS ON THE TOP OF THE
		STACK THE NUMBER NEXT TO TOP OF THE
		STACK.  BOTH NUMBERS ARE REMOVED FROM
		THE STACK.

EXAMPLES:

IN THE FOLLOWING EXAMPLES, X, Y, AND Z ARE VARIABLES,
WHILE A, B, AND C ARE CONSTANTS.

100 X !		SET VALUE OF X TO 100.

X 100 !		STORE THE ADDRESS OF X IN LOCATION 100
		(UNDER NORMAL CIRCUMSTANCES, THIS WOULD
		BE A VERY SERIOUS ERROR).

X @ Y !		SET THE VALUE OF Y TO THE VALUE OF X

X Y !		SET THE VALUE OF Y TO THE ADDRESS OF X

X @ Y @ + Z !	ADD THE VALUES OF X AND Y AND STORE THE
		RESULT IN Z.

X A + Y !	STORE (ADDRESS OF X)+A IN Y.

X A B + + @ Y !	SET VALUE OF Y TO THE CONTENTS OF
		LOCATION X+A+B.


	STOIC PROVIDES THE USER WITH AN UNUSUALLY LARGE
NUMBER OF FIXED POINT OPERATORS FROM WHICH THE FOLLOWING
MORE COMMON EXAMLES HAVE BEEN EXTRACTED.  UNLESS OTHERWISE
SPECIFIED, ALL NUMBERS ARE 16-BIT INTEGERS.

UNARY OPERATORS

THE FOLLOWING OPERATORS REPLACE THE TOP OF THE STACK
WITH THEIR RESULT.  THE NUMBER ONERATORS REPLACE THE TOP TWO NUMBERS ON
THE STACK WITH THEIR RESULT.  THE NUMBER ON THE TOP OF
THE STACK IS CALLED "A", THE NEXT TO TOP IS CALLED "B".

	+	B+A

	-	B-A

	*	B*A

	/	B/A

	MAX	MAXIMUM (B,A) (SIGNED)

	MIN	MINIMUM (B,A) (SIGNED)

	AND	LOGICAL AND OF B,A

	OR	LOGICAL OR OF B,A

	XOR	LOGICAL EXCLUSIVE OR OF B,A

	EQ	-1 IF B EQUAL TO A
		 0 OTHERWISE

	NE	-1 IF B NOT EQUAL TO A
		 0 OTHERWISE

	LT	-1 IF B LESS THAN A
		 0 OTHERWISE

	LE	-1 IF B LESS OR EQUAL TO A
		 0
	2UNDER	A	B	STORES TOP AT TOP - 2
		B	A
		C

	3UNDER	A	B	STORES TOP AT TOP - 3
		B	C
		C	A
		D

	DROP	A	B	DISCARDS TOP
		B

	2DROP	A	C	DISCARDS TOP 2 STACK ENTRIES
		B
		C

	3DROP	A	D	DISCARDS TOP 3 STACK ENTRIES
		B
		C
		D

	SWAP	A	B	EXCHANGES TOP AND TOP - 1
		B	A

	2SWAP	A	A	EXCHANGES TOP - 1 AND TOP - 2
		B	C
		C	B

	FLIP	A	C	EXCHANGES TOP AND TOP - 2
		B	B
		C	A

	+ROT	A	B	ROLL TOP 3 STACK ENTRIES UP
		B	C
		C	A

	-ROT	A	C	ROLL TOP 3 STACK ENTRIES DOWN
		B	A
		CS	OUTPUT N SPACES.

	TAB	TAB TO COLUMN N.  IF ALREADY AT OR BEYOND COLUMN
		N, NOTHING IS OUTPUT.

	TYI	INPUT A CHARACTER.

	=	OUTPUT N IN THE CURRENT RADIX FOLLOWED BY SPACE.

	?	OUTPUT THE CONTENTS OF THE LOCATION
		ADDRESSED BY N FOLLOWED BY SPACE.

	TYPE	OUTPUT N CHARACTERS STARTING AT BYTE
		POINTER AT TOP - 1.


WORDS WHICH CHANGE THE CURRENT RADIX

	OCTAL	SET CURRENT RADIX TO OCTAL

	DECIMAL	SET CURRENT RADIX TO DECIMAL

	HEX	SET CURRENT RADIX TO HEXADECIMAL


WORDS USED TO RTIALLY FROM ONE AREA TO ANOTHER
		BYTE COUNT AT TOP, SOURCE BYTE ADDRESS AT TOP - 2,
		DESTINATION BYTE ADDRESS AT TOP - 1.

EXAMPLES:

0> 1 MINUS =
-1

0> -1 ABS =
1

0> -1 EQZ =
0

0> 0 EQZ =
-1

0> 1 1 + =
2

0> 1 1 1 + + =
3

0> 1 2 3 = = =
3 2 1

0> 1 2 SWAP = =
1 2

0> 1 2 DUP = = =
2 2 1

0> 1 2 1 - EQ =
-1

0> 100 X ! X ?
100

0> -1 5 MAX =
5

0> -1 5 MIN =
-1


COLON DEFINITIONS

	STOIC PROVIDES THE CAPABILITY OF DEFINING A NEW
WORD IN TERMS OF PREVI THE TOP OF THE
STACK IS CALLED "A".

	MINUS	-A

	ABS	ABSOLUTE VALUE OF A

	NOT	LOGICAL COMPLEMENT OF A

	2*	A*2

	2/	A/2 (SIGNED)

	U2/	A/2 (UNSIGNED)

	1+	A+1

	1-	A-1

	EQZ	-1 IF A EQUAL TO 0
		 0 OTHERWISE

	NEZ	-1 IF A NOT EQUAL TO 0
		 0 OTHERWISE

	LTZ	-1 IF A LESS THAN 0
		 0 OTHERWISE

	LEZ	-1 IF A LESS OR EQUAL TO 0
		 0 OTHERWISE

	GEZ	-1 IF A GREATER OR EQUAL TO 0
		 0 OTHERWISE

	GTZ	-1 IF A GREATER THAN 0
		 0 OTHERWISE

BINARY OPERATORS

THE FOLLOWING OP OTHERWISE

	GE	-1 IF B GREATER OR EQUAL TO A
		 0 OTHERWISE

	GT	-1 IF B GREATER THAN A
		 0 OTHERWISE


	A NUMBER OF OPERATORS ARE ALSO PROVIDED WHOSE
SOLE FUNCTION IS TO REORGANIZE THE ELEMENTS OF THE STACK:

		STACK	STACK
	NAME	BEFORE	AFTER	DESCRIPTION

	DUP	A	A	DUPLICATES TOP OF STACK
			A

	OVER	A	B	DUPLICATES TOP - 1
		B	A
			B

	2OVER	A	C	DUPLICATES TOP - 2
		B	A
		C	B
			C

	3OVER	A	D	DUPLICATES TOP - 3
		B	A
		C	B
		D	C
			D

	UNDER	A	A	STORES TOP AT TOP - 1
		B
	B

	DDUP	A	A	DUPLICATE THE TOP 2 STACK ENTRIES
		B	B
			A
			B

I/O WORDS
"N" IS THE NUMBER ON THE TOP OF THE STACK.

	COLUMN	VARIABLE CONTAINING THE CURRENT COLUMN NUMBER

	TYO	OUTPUT THE ASCII CHARACTER IN THE RIGHTMOST
		8 BITS OF N.  COLUMN IS INCREMENTED UNLESS THE
		CHARACTER OUTPUT IS A RETURN IN WHICH CASE IT
		IS ZEROED.

	CR	OUTPUT A RETURN FOLLOWED BY A LINE FEED.
		COLUMN IS ZEROED.

	IFCR	OUTPUTS A RETURN, LINE FEED IF COLUMN IS NON-ZERO.

	SPACE	OUTPUT A SPACE.

	SPACEEFERENCE MEMORY LOCATIONS

A REPRESENTS THE TOP OF THE STACK, B REPRESENTS
THE NEXT TO TOP.

	<-	STORE A AT LOCATION B (SAME AS "!" EXCEPT
		ARGUMENTS ARE REVERSED).

	0<-	STORE 0 AT LOCATION A

	-1<-	STORE -1 AT LOCATION A

	+!	ADD B TO THE CONTENTS OF LOCATION A

	1+!	INCREMENT LOCATION A

	1-!	DECREMENT LOCATION A

	MOVE	COPY THE CONTENTS OF THE LOCATION ADDRESSED
		BY B TO THE LOCATION ADDRESSED BY A.

	XCHG	EXCHANGE THE CONTENTS OF LOCATIONS A AND B.

	MVBYTES	COPIES BYTES SEQUENOUSLY DEFINED WORDS BY MEANS OF
THE COLON DEFINITION.  ITS SYNTAX IS AS FOLLOWS:

'NEWWORD : WORD1 WORD2 ... WORDN ;

	THIS CREATES A NEW DICTIONARY ENTRY CALLED NEWWORD
WHICH, WHEN EXECUTED, WILL IN TURN EXECUTE WORD1, WORD2,
... IN SEQUENCE.  AFTER EXECUTING WORDN, IT WILL RETURN.
EACH OF THE WORDS WORD1, WORD2, ... MUST ALREADY EXIST
AS ENTRIES IN THE DICTIONARY.  IF NOT, A FATAL ERROR
MESSAGE OF THE FOLLOWING FORM WILL BE GENERATED:

UNDEFINED
(NAME OF UNDEFINED WORD)

	A WORD MAY BE REDEFINED AT ANY TIME.  IN THIS
CASE, ALL PRIOR DEFINITIONS WHICH REFERENCED THAT WORD
WILL STILL EXECUTE THE OLD VERSION.  ALL SUBSEQUENT
DEFINITIONS HOWEVER WILL EXECUTE THE MOST RECENTLY
DEFINED VERSION. REDEFINING A WORD WILL GENERATE THE
FOLLOWING WARNING MESSAGE:

REDEFINING (NAME OF WORD)

EXAMPLES:

'AVERAGE : + 2/ ;

	THIS DEFINES THE WORD AVERAGE WHICH COMPUTES
	THE AVERAGE OF THE TOP 2 NUMBERS ON THE STACK.

	0> 2 4 AVERAGE =
	3

'SPACE : 40 TYO ;

	THIS DEFINES THE WORD "SPACE" IED.

BEGIN ... IF ... REPEAT

	SIMILAR TO BEGIN ... END EXCEPT THE CONDITION
	IS TESTED AT THE BEGINNING OF THE LOOP.

DO ... LOOP

	EXECUTE THE WORDS BETWEEN "DO" AND "LOOP", RUNNING
	AN INDEX FROM A LOWER TO AN UPPER LIMIT, INCREMENTING
	BY 1 EACH TIME.

DO ... N +LOOP

	EXECUTE THE WORDS BETWEEN "DO" AND "+LOOP", RUNNING
	AN INDEX FROM A LOWER TO AN UPPER LIMIT, INCREMENTING
	BY N EACH TIME.

	ITERATIONS MAY BE NESTED SUBJECT TO THE NORMAL
RESTRICTIONS ON OVERLAPPING RANGES, I.E. ANY DING ) ;

	THIS DEFINITION IS FUNCTIONALLY EQUIVALENT TO:

	'DINGDING : DING DING ;

	IN EITHER CASE, EXECUTING "DINGDING" CAUSES THE
	WORD "DING" TO BE EXECUTED TWICE.

'SPACES : ( SPACE ) ;

	THIS IS A DEFINITION OF THE WORD "SPACES".
	THUS "20 SPACES" CAUSES "SPACE" TO BE EXECUTED
	20 TIMES.

	AN UNSIGNED VERSION OF PARENTHESIS ITERATION IS USED
WHERE THE ITERATION COUNT IS BETWEEN 32767 AND 65535:

	N U( ... )


BEGIN ... END

	THE BEGIN ... END SYNTAX PERMITS THE USER TO EXECUTEMPLE" WHICH MIGHT BE
	CALLED AS FOLLOWS:

	0> 5 EXAMPLE
	4 3 2 1 0

	EACH TIME THROGH THE LOOP, THE TOP OF THE STACK
	(INITIALLY THE NUMBER 5) IS DECREMENTED, PRINTED,
	AND COMPARED TO ZERO.  IF IT IS NOT ZERO, THE
	LOOP IS REPEATED,  WHEN IT BECOMES ZERO, THE LOOP
	TERMINATES.


BEGIN ... IF ... REPEAT

	BEGIN ... IF ... REPEAT IS SIMILAR TO BEGIN ...
END EXCEPT THAT THE TEST IS MADE AT THE BEGINNING OF THE
LOOP RATHER THAN AT THE END.  THE WORDS FROM "BEGIN" TO
"IF" ARE EXECUTED.  IF THEGINNING OF THE LOOP, THE
	CASE OF A ZERO-LENGTH FILE IS PROPERLY
	HANDLED.


DO LOOPS

	A DO LOOP FACILITY IS PROVIDED BY STOIC FOR
INDEXING THROUGH A SEQUENCE OF WORDS.  THERE ARE TWO
FORMS OF DO LOOP:

HIGH LOW DO WORD1 WORD2 ... WORDN LOOP

HIGH LOW DO WORD1 WORD2 ... WORDN INCR +LOOP

	THE LIMITS "HIGH" AND "LOW" (THE TOP TWO STACK
ENTRIES) ARE COMPARED.  IF "HIGH" IS LESS THAN OR EQUAL TO
"LOW", CONTROL PASSES TO THE WORD FOLLOWING "LOOP" OR
"+LOOP".  OTHERWISE, THE SEQUENCE WORD1, WOWHICH TYPES A SPACE.
	(THE ASCII CODE FOR SPACE IS 40 OCTAL).

	IF THE NAME OF A WORD BEING REDEFINED APPEARS
WITHIN THE NEW DEFINITION, ITS OLD MEANING WILL BE USED.
THE PROCEDURE FOR MAKING RECURSIVE CALLS IS DESCRIBED
BELOW UNDER "RECURSION".


ITERATION

	STOIC PROVIDES FIVE MEANS FOR ITERATIVE
EXECUTION OF A SEQUENCE OF WORDS, NAMELY:

N ( ... )

	EXECUTE THE WORDS INCLUDED IN PARENTHESES N TIMES.

BEGIN ... END

	EXECUTE WORDS BETWEEN "BEGIN" AND "END" UNTIL A CONDITION
	IS SATISF ITERATION
WHICH IS INITIATED WITHIN THE RANGE OF ANOTHER ITERATION
MUST BE TERMINATED WITHIN THAT SAME RANGE.


( ... )

	A SEQUENCE OF WORDS MAY BE EXECUTED REPETITIVELY
USING THE FOLLOWING SYNTAX:

N ( WORD1 WORD2 ... WORDN )

	THIS CAUSES THE SEQUENCE WORD1, WORD2, ... TO BE
EXECUTED N TIMES WHERE N IS THE NUMBER ON THE TOP OF THE
STACK.  IF N IS ZERO OR NEGATIVE, THE SEQUENCE OF WORDS
IS NOT EXECUTED AT ALL AND CONTROL PASSES TO THE WORD
FOLLOWING THE ")".

EXAMPLE:

'DINGDING : 2 (
A SEQUENCE OF WORDS AND THEN, DEPENDING ON A COMPUTED
LOGICAL VARIABLE, EITHER LOOP BACK OR CONTINUE ON:

BEGIN WORD1 WORD2 ... WORDN END

	THE SEQUENCE WORD1, WORD2, ... IS EXECUTED ONCE.
WHEN THE "END" IS REACHED, THE TOP OF THE STACK IS
POPPED AND  TESTED.  IF IT IS TRUE (NON-ZERO) THEN
CONTROL PASSES TO THE WORD FOLLOWING "END".  IF IT IS
FALSE (ZERO) CONTROL PASSES BACK TO THE WORD FOLLOWING
"BEGIN".

EXAMPLE:

	'EXAMPLE : BEGIN 1- DUP DUP = EQZ END DROP ;

	THIS DEFINES THE WORD "EXA TOP OF THE STACK IS TRUE
(NON-ZERO) THE WORDS BETWEEN "IF" AND "REPEAT" ARE
EXECUTED AND CONTROL THEN PASSES BACK TO THE WORD
FOLLOWING "BEGIN".  IF THE TOP OF THE STACK IS FALSE
(ZERO), CONTROL PASSES TO THE WORD FOLLOWING "REPEAT".

EXAMPLE:

	BEGIN EOF NOT IF READ-RECORD REPEAT

	THIS EXAMPLE MIGHT BE USED TO READ THE CONTENTS
	OF A FILE.  "EOF" RETURNS A -1 IF END OF FILE
	HAS BEEN ENCOUNTERED; A 0 OTHERWISE.  "READ-RECORD"
	READS THE NEXT ENTRY IN THE FILE.  BY TESTING
	FOR EOF AT THE BERD2, ... IS
EXECUTED.  "LOOP" CAUSES THE LOWER LIMIT ("LOW") TO BE
INCREMENTED BY 1 AND COMPARED TO THE UPPER LIMIT ("HIGH").
IF "LOW" IS EQUAL TO OR GREATER THAN "HIGH", THE LOOP IS
TERMINATED.  OTHERWISE ANOTHER ITERATION IS PERFORMED.
"+LOOP" IS IDENTICAL TO "LOOP" WITH THE EXCEPTION THAT
"LOW" IS INCREMENTED BY THE WORD ON THE TOP OF THE STACK
("INCR").  "INCR" IS NORMALLY A POSITIVE NUMBER.

	WITHIN THE RANGE OF THE LOOP, THE CURRENT VALUE
OF THE LOOP INDEX IS AVAILABLE BY USING THE WORD "I".
IF DO LOOPS ARE NESTED, "I" ALWAYS CONTAINS THE VALUE
OF THE INNERMOST INDEX.  THE NEXT OUTER INDICES ARE
AVAILABLE USING THE WORDS "J" AND "K".  THE WORD "I'"
IS USED TO OBTAIN THE VALUE OF "HIGH"+"LOW"-I-1.  THIS IS
USED TO RUN AN INDEX BACKWARDS FROM "HIGH"-1 TO "LOW".
THE WORDS "J'" AND "K'" ARE SIMILARLY DEFINED.  WHEN
PARENTHESES ARE NESTED WITH "DO" LOOPS, THEY COUNT AS
ONE LEVEL OF INDEXING.  "I" USED WITHIN THE RANGE
OF A PARENTHESIS ITERATION WILL RETURN THE CURRENT VALUE
OF THE ITERATIM 4 TO 0
	INCLUSIVE.

	0 21 1 DO I + DUP = 2 +LOOP DROP

	THIS TYPES OUT THE FIRST 10 PERFECT SQUARES
	STARTING WITH 1.

	WHEN USING "I'" (OR "J'" OR "K'") IN CONJUNCTION WITH
"+LOOP", "HIGH" SHOULD BE REPLACED BY "HIGH"-"INCR"+1, IF IT
IS DESIRED TO PRODUCE THE SAME SET OF INDICES AS WITH "I".
FOR EXAMPLE:

	0> 24 0 DO I = 4 +LOOP
	0 4 8 12 16 20

	0> 24 0 DO I' = 4 +LOOP
	23 19 15 11 7 3 1

	0> 24 4 - 1 + 0 DO I' = 4 +LOOP
	20 16 12 8 4 0

	AN UNSIGNED DO LOOP IS USED WHERE THE LIMITN IF T1 T2 ... TN THEN

	THE TOP OF THE STACK, "N" IS TESTED.

	IF TRUE (NON-ZERO) THE WORDS T1, T2, ... TN ARE
	EXECUTED.

	IF FALSE (ZERO) CONTROL PASSES TO THE WORD
	FOLLOWING "THEN".

N IF T1 T2 ... TN ELSE F1 F2 ... FN THEN

	THE TOP OF THE STACK, "N" IS TESTED.

	IF TRUE (NON-ZERO) THE WORDS T1, T2, ... TN
	ARE EXECUTED; CONTROL THEN PASSES TO THE WORD
	FOLLOWING "THEN".

	IF FALSE (ZERO) CONTROL PASSES TO THE WORD
	FOLLOWING "ELSE".  THE WORDS F1, F2, ... FN ARE
	EXECUTED.

EXAM !		% THIS IS A COMMENT
	%THIS IS NOT A COMMENT


USING STOIC FROM THE KEYBOARD

	WHEN TYPING IN A COMMAND FROM THE KEYBOARD,
THE RUBOUT KEY MAY BE USED TO DELETE THE LAST CHARACTER;
TYPING A NULL DELETES THE ENTIRE COMMAND LINE.

	WHEN ACTIVATED, STOIC TYPES A PROMPT MESSAGE
CONSISTING OF THE CURRENT NESTING DEPTH (SEE BELOW)
FOLLOWED BY "> " TO INDICATE THAT IT IS AWAITING KEYBOARD
INPUT.  AT THIS POINT THE OPERATOR TYPES IN A COMMAND LINE.
AS SOON AS RETURN OR FORM FEED IS TYPED, STOIC COMPENTED
WHENEVER ANY OF THE FOLLOWING WORDS ARE ENCOUNTERED DURING
COMPILATION:

IF	ELSE	(	U(	BEGIN	DO	:
UDO

THE NESTING DEPTH IS DECREMENTED BY THE FOLLOWING WORDS:

THEN	ELSE	)	END	LOOP	+LOOP	;
ULOOP	U+LOOP
REPEAT (DECREMENTS NESTING DEPTH BY 2)

IF THE NESTING DEPTH EVER BECOMES NEGATIVE, THE FATAL
ERROR "SYNTAX ERROR" IS GIVEN.  A "SYNTAX ERROR" IS ALSO
GENERATED IF THE NESTING DEPTH IS NON-ZERO EITHER AT THE
BEGINNING OR AT THE END OF A COLON DEFINITION.

	AFTER COMPILING A LINE, STOICON COUNT (WHICH RUNS FROM ITS INITIAL VALUE
DOWNWARDS TO ONE).

	THE WORD "EXIT", CAUSES THE INNERMOST LOOP IN
WHICH IT IS EMBEDDED TO UNCONDITIONALLY TERMINATE ON THE
NEXT CYCLE, WHETHER A DO LOOP OR A PARENTHESIS LOOP.

EXAMPLES:

	5 0 DO I = LOOP

	THIS CUASES THE NUMBERS FROM 0 TO 4 INCLUSIVE
	TO BE TYPED OUT.

	5 0 DO 5 0 DO J 5 * I + = LOOP CR LOOP

	THIS TYPES OUT THE NUMBERS FROM 0 TO 24
	INCLUSIVE AS 5 LINES OF 5 NUMBERS EACH.

	5 0 DO I' = LOOP

	THIS TYPES OUT THE NUMBERS FROS MUST BE
CONSIDERED AS UNSIGNED NUMBERS; E.G. WHERE THE LIMITS ARE BYTE
ADDRESSES IN THE UPPER 32K BYTES OF MEMORY:

	HIGH LOW UDO ... ULOOP
	HIGH LOW UDO ... INCR U+LOOP


CONDITIONALS

	STOIC HAS A POWERFUL IF ... ELSE ... THEN CONSTRUCTION
WHICH ALLOWS COMPLICATED LOGICAL TESTS TO BE PERFORMED.
CONDITIONALS MAY BE NESTED, WITH THE SAME RESTRICTIONS
THAT APPLY TO ITERATIONS.

FOR THE PURPOSES OF THE CONDITIONAL, "TRUE" IS CONSIDERED
TO BE ANY NON-ZERO VALUE; "FALSE" IS ANY ZERO VALUE.

PLES:

	'ABS : DUP LTZ IF MINUS THEN ;

	THIS DEFINES THE WORD "ABS" WHICH REPLACES THE
	TOP OF THE STACK WITH ITS ABSOLUTE VALUE.

	'MAX : DDUP GT IF DROP ELSE UNDER THEN ;

	THIS DEFINES THE WORD "MAX" WHICH COMPARES THE
	TOP TWO STACK ENTRIES AND LEAVES THE LARGER OF
	THE TWO.


COMMENTS

	THE WORD "%" APPEARING ON A LINE CAUSES THE
REMAINDER OF THAT LINE TO BE IGNORED.  NOTE THAT THE "%",
TO BE RECOGNIZED AS A WORD, MUST BE PRECEDED AND FOLLOWED
BY SPACE OR TAB.

EXAMPLES:

	X @ YILES
THE COMMAND LINE AND, IN THE ABSENCE OF COMPILATION ERRORS,
EXECUTES IT.  UPON COMPLETION OF COMMAND EXECUTION, THE
COMPILED CODE FROM THE LAST COMMAND IS DISCARDED AND STOIC
AGAIN TYPES ITS PROMPT MESSAGE AND WAITS FOR THE NEXT COMMAND
LINE.


NESTING DEPTH AND CONTINUATION LINES

	STOIC MAINTAINS A NESTING DEPTH WHICH IS USED
FOR SYNTAX CHECKING AND TO DETERMINE WHEN A MULTI-LINE
COMMAND HAS BEEN COMPLETED AND IS READY TO EXECUTE.
INITIALLY, THE NESTING DEPTH IS SET TO ZERO; IT IS INCREM CHECKS THE NESTING
DEPTH; IF IT IS ZERO, THE LINE IS EXECUTED, IF NON-ZERO,
IT CONTINUES COMPILATION ON THE NEXT LINE.  FOR EXAMPLE:

	0> 3 0 DO
	1> 2 0 DO
	2> I =
	2> LOOP
	1> CR
	1> LOOP
	0 1
	0 1
	0 1
	0>

THUS, THE EXECUTION OF THE DO LOOP IS AUTOMATICALLY
POSTPONED UNTIL THE NESTING DEPTH RETURNS TO ZERO,
I.E. WHEN THE "LOOP" MATCHING THE FIRST "DO" IS ENCOUNTERED.
SIMILARLY, A MULTI-LINE COLON DEFINITION IS EXTENDED TO
INCLUDE ALL WORDS UP TO THE MATCHING ";".

	EXECUTION OF COMPILED CODE MAY BE POSTPONED
EVEN IF THE NESTING DEPTH IS ZERO BY USING THE WORD
"^".  IF "^" IS USED ANYWHERE ON A LINE, COMPILATION
WILL UNCONDITIONALLY CONTINUE ON TO THE NEXT LINE.
THIS FEATURE MAY BE USED AS FOLLOWS:

	0> 5 0 DO I = LOOP ^
	0> 5 0 DO I = LOOP
	0 1 2 3 4 0 1 2 3 4
	0>

	A MORE REASONABLE APPLICATION OF "^" INVOLVES
THE USE OF STRING LITERALS.  SINCE COMPILED CODE OUTSIDE
OF A COLON DEFINITION IS DISCARDED AFTER EXECUTION,
STRING LITERALS TYPED IN ON ONE LINE ARE NOT ACCESIBLATAL
ERRORS IN STOIC:

	ABORT	CLEARS THE PARAMETER, RETURN, AND LOOP
		STACKS, RESETS THE NESTING DEPTH TO ZERO,
		AND FORCES CONTROL TO RETURN TO THE
		KEYBOARD.  "ABORT" IS INVOKED BY CONTROL A.

	ERR	TYPES THE STRING AT THE TOP OF THE STACK
		FOLLOWED BY THE NAME OF THE WORD LAST
		SCANNED FROM THE INPUT STREAM, AND, IF
		INPUT IS NOT COMING FROM THE KEYBOARD,
		THE LINE LAST COMPILED FROM THE INPUT FILE.
		"ABORT" IS THEN INVOKED TO RESET STOIC.


DEFINING CONSTANTS, VARIABLES, AND ARRAYY ENTRY WHICH CONTAINS
A 16-BIT INTEGER AS ITS VALUE.  WHEN EXECUTED, IT CAUSES
THE ADDRESS OF ITS VALUE TO BE PUSHED ON THE PARAMETER
STACK.  VARIABLES ARE DEFINED AS FOLLOWS:

VALUE 'NAME VARIABLE

	"VALUE" IS THE NUMBER ON THE TOP OF THE STACK
AND "NAME" IS THE NAME TO BE ASSIGNED TO THE VARIABLE.
"VALUE" IS USED TO SET THE INITIAL VALUE OF THE VARIABLE.

EXAMPLE:

	100 'X VARIABLE

	THIS DEFINES A VARIABLE "X" WITH AN INITIAL
	VALUE OF 100.


ARRAYS

	WHILE STOIC DOES NOT HAVE A BUIFFER ARRAY

	THIS DEFINES AND ZEROES A 100-WORD ARRAY NAMED
	"BUFFER".

	AN EXAMPLE OF A CONVENIENT TECHNIQUE FOR
	DEFINING SMALL ARRAYS IS :

	0 '3VEC VARIABLE 1 , 2 ,

	THIS DEFINITION SETS UP A 3-VECTOR CALLED "3VEC"
	WHOSE INITIAL VALUE IS (0,1,2).  THE WORD ","
	TAKES A NUMBER FROM THE TOP OF THE STACK AND
	APPENDS IT TO THE END OF THE DICTIONARY,
	AUTOMATICALLY EXTENDING THE LENGTH OF THE
	MOST RECENT DEFINITION.  THIS SERVES THE
	DUAL FUNCTIONS OF RESERVING SPACE IN THE
	DICTIONARY AD BY:

	-1 'X VARIABLE 99 ( -1 , )


REFERENCING ARRAY ELEMENTS

	TO REFERENCE AN ELEMENT OF AN ARRAY, ALL THAT IS
NECESSARY IS TO ADD AN APPROPRIATE OFFSET TO THE ADDRESS
OF THE ZEROTH ELEMENT.  NOTE THAT SINCE THE FIRST ELEMENT
HAS OFFSET ZERO, THE NTH ELEMENT HAS OFFSET N-1.

EXAMPLE:

	10 'X ARRAY
	10 0 DO I X I 2* + ! LOOP

	THE ABOVE CODE DEFINES A 10 ELEMENT ARRAY "X"
	AND FILLS IT WITH THE NUMBERS 0 TO 9.

	NOTE THAT SINCE ADDRESSES ARE IN BYTES, THE
	INDEX MUST BE MULTIPLIED BYE TO
SUBSEQUENT LINES UNLESS "^" IS USED TO FORCE THE
COMPILED STRING LITERAL TO BE SAVED.  FOR EXAMPLE:

0> \THIS IS A LONG MESSAGE WHICH USES THE ENTIRE LINE\ ^
0> MSG
THIS IS A LONG MESSAGE WHICH USES THE ENTIRE LINE
0>

REPEATING THE LAST COMMAND LINE

	TYPING A LINE FEED CAUSES STOIC TO RECOMPILE AND RE-EXECUTE
THE LAST COMMAND LINE EXECUTED. FOR EXAMPLE:

0> 2 2 + =
4
0>		(LINE FEED TYPED)
4
0>		(LINE FEED TYPED)
4


ERROR HANDLING

	THE FOLLOWING TWO WORDS ARE USED TO HANDLE FS

CONSTANTS

	A CONSTANT IS A DICTIONARY ENTRY WHICH CAUSES A
16-BIT INTEGER TO BE PUSHED ON THE PARAMETER STACK.  TO
DEFINE A CONSTANT, THE WORD "CONSTANT" IS USED:

VALUE 'NAME CONSTANT

	HERE, "VALUE" IS THE NUMBER ON THE TOP OF THE
STACK AND "NAME" IS THE NAME TO BE ASSIGNED TO THE
CONSTANT.

EXAMPLE:

	5 'NPTS CONSTANT

	THIS SETS UP A DICTIONARY ENTRY WITH NAME
	"NPTS".  EXECUTING THE WORD "NPTS" WILL CAUSE
	A 5 TO BE PUSHED ON THE STACK.

VARIABLES

	A VARIABLE IS A DICTIONARLT-IN ARRAY
HANDLING FACILITY, ITS ABILITY TO PERFORM ADDRESS
ARITHMETIC MAKES SUBSCRIPTING POSSIBLE.  THERE
ARE SEVERAL METHODS FOR SETTING ASIDE STORAGE FOR
AN ARRAY.  THE SIMPLEST IS TO USE THE WORD "ARRAY":

	LENGTH 'NAME ARRAY

	THIS DEFINES AND ZEROS AN ARRAY WHOSE LENGTH (IN
	16-BIT WORDS) AND NAME ARE SPECIFIED.  THE ARRAY IS
	JUST A VARIABLE WITH EXTRA STORAGE LOCATIONS
	RESERVED.  REFERENCING AN ARRAY THUS CAUSES
	THE ADDRESS OF THE ZEROTH ELEMENT TO BE PUSHED.

	EXAMPLE:

	100 'BUND INITIALIZING THE ARRAY.


THE CONTENTS OF AN ARRAY MAY BE INITIALIZED TO ZERO OR
ANY CONSTANT VALUE USING THE FOLLOWING WORDS:

	FILL	FILLS AN ARRAY WHOSE ADDRESS IS AT TOP-2
		AND HAS LENGTH (IN WORDS) AT TOP-1 WITH THE
		CONSTANT VALUE AT TOP.

	0FILL	ZERO FILLS AN ARRAY WHOSE ADDRESS IS AT
		TOP-1 AND HAS LENGTH (IN WORDS) AT TOP.

	EXAMPLE:

	100 'X ARRAY
	X 100 -1 FILL

	THIS DEFINES A 100-WORD ARRAY "X" WHICH IS THEN
	FILLED WITH -1'S.  EQUIVALENTLY, THE SAME ACTION
	IS PERFORME 2.

	MULTIDIMENSIONAL SUBSCRIPTING IS HANDLED IN A
SIMILAR FASHION.

EXAMPLE:

	100 'X ARRAY
	10 0 DO 10 0 DO I J + J 10 * I + 2* X + ! LOOP LOOP

	THIS EXAMPLE SETS UP A 100 ELEMENT ARRAY "X"
	WHICH IS TREATED AS A 10 BY 10 MATRIX AND
	THEN STORES I+J IN THE ELEMENT (I,J).


THE DICTIONARY

	THE DICTIONARY STARTS IN LOW CORE AND GROWS
UPWARD TOWARD THE TOP OF MEMORY.  EACH DEFINITION, AS
IT IS MADE, IS APPENDED TO THE END OF THE DICTIONARY.
THE VARIABLE ".D" IS A POINTER TO THE FIRST FREE WORD
FOLLOWING THE END OF THE DICTIONARY.

THE WORD "." PUSHES THE VALUE OF THE DICTIONARY
POINTER (".D") AND IS EQUIVALENT TO TYPING ".D @".

	THE ADDRESS OF A DICTIONARY ENTRY MAY BE
OBTAINED BY INVOKING THE FOLLOWING WORD:

	() NAME

		PUSHES ON THE STACK THE ADDRESS OF
		THE PARAMETER FIELD OF THE NAMED
		WORD.

	THIS WORD MAKES IT POSSIBLE TO MODIFY THE
	VALUE OF A CONSTANT.  FOR EXAMPLE:

	100 'N CONSTANT
	200 () N !

	THE FIRST LINE DEFINES A CONSTANT "N" WHOSE
	VALUE IS 100
	'NEWVAL : ADDRESS 200 SWAP ! ;

	THIS DEFINES A WORD "NEWVAL" WHICH SETS THE
	PARAMETER FIELD OF ITS ARGUMENT TO 200.
	THUS,

	'N NEWVAL

	IS EQUIVALENT TO THE PREVIOUS EXAMPLE.


EXECUTING PROGRAMS

	STOIC PROGRAMS ARE STORED AS ASCII SOURCE
FILES.  EXECUTING A FILE CAUSES STOIC TO ACCEPT ITS
COMMANDS FROM THE FILE INSTEAD OF THE KEYBOARD.
FILE EXECUTION IS CONTROLLED BY THE FOLLOWING WORDS:

	LOAD	EXECUTE A PROGRAM; ADDRESS OF NAME IS
		ON TOP OF STACK.

	;F	TERMINATES EXECUTION OFRENT
LINE HAS BEEN EXECUTED.

EXAMPLES:

	'DEFS LOAD

	THIS EXECUTES A FILE CALLED "DEFS"

	'LDDEFS : . = 'DEFS LOAD ;

	THIS DEFINES "LDDEFS" WHICH TYPES OUT THE
	CURRENT VALUE OF THE DICTIONARY POINTER AND
	EXECUTES "DEFS".

	'A LOAD 'B LOAD 'C LOAD

	THIS COMMAND LINE CAUSES ONLY THE CONTENTS OF FILE
	"C" TO BE EXECUTED AND LEAVES SEVERAL EXTRANEOUS
	NUMBERS ON THE LOOP STACK.  MULTIPLE LOADS MAY NOT
	BE EXECUTED FROM THE SAME COMMAND LINE; THEY MUST
	BE SEPARATED BY CARRIAGE RETURNSS ALL THE FILES DOWN AND RESTRUCTURES THE DIRECTORY
TO ELIMINATE ALL GAPS.  THE FOLLOWING WORDS CONTROL DIRECTORY
MAINTENANCE AND FILE ACCESS:

ZERO-DIRECTORY	INITIALIZES THE DIRECTORY.  THE PREVIOUS CONTENTS
		OF THE DIRECTORY ARE LOST.

LIST-DIRECTORY	TYPES A DIRECTORY LISTING IN TWO COLUMNS.

LEFT		RETURNS ON THE STACK THE NUMBER OF UNUSED BLOCKS
		ON THE STORAGE MEDIUM.

CCONT		CREATES A CONTIGUOUS FILE WHOSE LENGTH (IN BLOCKS)
		IS AT THE TOP OF THE STACK, THE NAME IS AT TOP - 1.

DELETERST WORD OF THE FILE CONTROL
		TABLE AND THE OTHER TWO WORDS ARE ZEROED.

WOPEN		OPENS A FILE FOR WRITING; FILE NAME AT TOP OF STACK.
		ANY PREVIOUS VERSION OF THE FILE IS DELETED, A NEW
		VERSION IS CREATED WHOSE LENGTH IS EQUAL TO THE ENTIRE
		REMAINING FREE SPACE, AND THE FILE IS OPENED USING
		THE CURRENT FILE CONTROL TABLE.  IF MORE THAN ONE
		OUTPUT FILE IS ACTIVE AT A TIME, ALL BUT ONE OF THEM
		MUST BE CREATED WITH "CCONT" AND OPENED WITH "OPEN",
		GIVING THE FILE LENGTH IN ADVANCE.  THE L.  THE NEXT LINE RESETS THE VALUE
	TO 200.

	THIS FEATURE SHOULD NOT BE USED IN ANY PROGRAM
	WHICH WILL SUBSEQUENTLY BE COMMITTED TO READ-
	ONLY MEMORY.

	THE FOLLOWING WORD IS USED TO OBTAIN THE
	ADDRESS OF A WORD IN THE DICTIONARY GIVEN
	ITS NAME:

	ADDRESS		TAKES A STRING ARGUMENT ON
			THE STACK WHICH IS LOOKED
			UP IN THE DICTIONARY.  IF
			NOT FOUND, AN ERROR MESSSAGE
			IS TYPED.  IF FOUND, THE ADDRESS
			OF THE PARAMETER FIELD OF THE
			WORD IS RETURNED ON THE STACK.

	EXAMPLE:
 THE CURRENT FILE
		AND RETURNS CONTROL TO THE CALLING INPUT
		FILE OR TO THE SYSTEM KEYBOARD.

SINCE STOIC USES THE LOOP STACK TO SAVE CERTAIN INTERPRETER
VARIABLES WHEN EXECUTING "LOAD", NO EXECUTED FILE MAY
PUSH ANYTHING ON THE LOOP STACK THAT IS NOT REMOVED WITHIN
THAT SAME FILE.  "LOAD" WORKS BY MODIFYING THE STOIC READ-
NEXT-LINE ROUTINE SO THAT IT ACCEPTS INPUT FROM THE SPECIFIED
FILE INSTEAD OF THE KEYBOARD.  THUS, "LOAD" DOES NOT CAUSE
THE CONTENTS OF THE FILE TO BE EXECUTED UNTIL THE CUR.  THUS, THE CORRECT
	WAY TO LOAD THE THREE FILES IS:

	'A LOAD
	'B LOAD
	'C LOAD


STOIC FILE SYSTEM

	THE STOIC FILE SYSTEM SUPPORTS CONTIGUOUS FILES WHICH
ARE REFERENCED BY SIX-LETTER NAMES.  THESE NAMES AND THE LOCATIONS
OF THE FILES ON THE STORAGE MEDIUM ARE STORED IN A DIRECTORY
WHICH OCCUPIES BLOCK ZERO.  NEW FILES ARE ALWAYS ADDED AT THE
END OF THE MEDIUM.  THE BLOCKS TAKEN UP BY A FILE WHICH HAS BEEN
DELETED ARE NOT AVAILABLE UNTIL THE WORD "SQUASH" HAS BEEN EXECUTED.
"SQUASH" SLIDE		DELETES THE FILE WHOSE NAME IS AT TOP OF STACK.

RENAME		RENAMES FILE WHOSE NAME IS AT TOP - 1 TO NAME AT TOP.

FILE		CREATES A 3-WORD FILE CONTROL TABLE WHOSE NAME IS AT
		TOP.  WHEN REFERENCED, THE ADDRESS OF THE FILE CONTROL
		TABLE IS STORED IN THE VARIABLE "FCT".  THIS CAUSES
		THE FILE CONTROL TABLE TO BECOME THE CURRENT FILE
		CONTROL TABLE.

OPEN		OPENS THE FILE WHOSE NAME IS AT TOP USING THE CURRENT
		FILE CONTROL TABLE.  THE NUMBER OF THE FIRST BLOCK OF
		THE FILE IS STORED IN THE FIAST ONE MAY
		BE VARIABLE LENGTH AND OPENED WITH "WOPEN".

SHRINK		USING THE CURRENT FILE CONTROL TABLE, THE END OF
		THE DIRECTORY IS MOVED DOWN TO THE FIRST FREE BLOCK
		FOLLOWING THE CURRENT FILE.  THIS WORD IS USED ONLY
		WITH FILES WHICH HAVE BEEN OPENED USING "WOPEN" TO
		RELEASE WHATEVER STORAGE IS NOT USED BY THE OUTPUT
		FILE.

CLOSE		ZEROES THE FIRST WORD OF THE CURRENT FILE CONTROL
		TABLE, SIGNALLING IT AS INACTIVE.

GETBYTE		USING THE CURRENT FILE CONTROL TABLE,
		RETURNS THE NEXT BYTE FROM THE FILE.

GETBYTES	USING THE CURRENT FILE CONTROL TABLE, AND TAKING
		A BYTE COUNT AT TOP AND A BUFFER ADDRESS AT TOP - 1,
		THE SPECIFIED NUMBER OF BYTES ARE READ FROM THE FILE
		INTO THE BUFFER.

PUTBYTE		USING THE CURRENT FILE CONTROL TABLE,
		STORES BYTE AT TOP IN NEXT BYTE OF FILE.

PUTBYTES	USING THE CURRENT FILE CONTROL TABLE, AND TAKING
		A BYTE COUNT AT TOP AND A BUFFER ADDRESS AT TOP - 1,
		THE SPECIFIED NUMBER OF BYTES ARE WRITTEN INTO THE FILE
		FROM THE BUFFER.

GPOS	AT TOP.  IF
		FOUND, THE ERROR "FILE ALREADY EXISTS" IS GIVEN.

OPEN?		GIVES THE MESSAGE "FILE NOT OPEN" IF THE
		CURRENT FILE CONTROL TABLE IS NOT OPEN.

FSQUASH		REMOVES DELETED ENTRIES FROM THE END OF THE
		DIRECTORY.  DELETED ENTRIES WITHIN THE
		DIRECTORY ARE NOT AFFECTED.  FSQUASH IS
		CALLED AUTOMATICALLY AFTER A "DELETE".

SQUASH		REMOVES ALL DELETED ENTRIES FROM THE DIRECTORY.
		THE REMAINING FILES ARE MOVED DOWN TO FILL UP
		THE EMPTY SPACE.

SEARCH		SEARCHES THE DIRECTORY FOR THE NF THE
		FILE WHOSE NAME IS AT TOP.

COPY		COPIES THE FILE WHOSE NAME IS AT TOP - 1 TO A FILE
		WHOSE NAME IS AT TOP.  THE DESTINATION FILE IS CREATED
		AT THE END OF THE DIRECTORY; ANY PREVIOUS VERSION IS
		DELETED.


DIRECTORY ENTRY FORMAT:

WORD	CONTENTS

0	1ST WORD OF NAME
	 (= -1 IF DELETED)
	 (=  0 IF END OF DIRECTORY)

1	2ND WORD OF NAME

2	3RD WORD OF NAME

3	NUMBER OF FIRST BLOCK OF FILE
	 (NUMBER OF FIRST FREE BLOCK IF 1ST WORD = 0)


FILE CONTROL TABLE FORMAT:

WORD	CONTHANDLING WOWRS

	STOIC MAINTAINS A POOL OF SYSTEM BUFFERS WHICH ARE
USED TO HOLD BLOCKS FROM THE STORAGE MEDIUM IN MEMORY.  THEY
ARE ALLOCATED USING A "LEAST RECENTLY USED" ALGORITHM.

RBLOCK	RETURNS THE ADDRESS OF A BUFFER CONTAINING THE BLOCK
	WHOSE NUMBER IS AT TOP.  WHEN A BLOCK IS REQUESTED USING
	"RBLOCK", IF THE SPECIFIED BLOCK IS ALREADY IN MEMORY,
	ITS ADDRESS IS IMMEDIATELY RETURNED.  IF IT IS NOT IN
	MEMORY, THE LEAST RECENTLY USED BUFFER IS FREED (I.E.
	WRITTEN OUT IF MODIFIED), AND TNTLY ACCESSED BUFFER AS MODIFIED.
	WHENEVER THE VALUE OF ANY WORD WITHIN AN I/O BUFFER
	IS MODIFIED, THIS WORD MUST BE CALLED, OTHERWISE THE
	MODIFIED VERSION WILL NOT BE WRITTEN BACK ON THE
	STORAGE MEDIUM.


SAVING AND RESTORING CORE IMAGES

	TWO WORDS ARE PROVIDED WITHIN THE KERNEL WHICH
ENABLE THE USER TO SAVE A "SNAPSHOT" OF THE DICTIONARY AND
ALL STOIC VARIABLES IN A FILE AND, AT A LATER TIME, TO
RESTORE THE SAVED STATE OF MACHINE AND RESUME EXECUTION.
THEIR USE IS OUTLINED BELOW:

	'FI	USING THE CURRENT FILE CONTROL TABLE,
		RETURNS A DOUBLE PRECISION INTEGER FILE POSITION
		AT TOP AND TOP - 1.  (MOST SIGNIFICANT WORD AT TOP).

SPOS		USING THE CURRENT FILE CONTROL TABLE
		SETS THE FILE POSITION TO THE DOUBLE PRECISION
		INTEGER VALUE AND TOP AND TOP - 1.

EXIST		SEARCHES THE DIRECTORY FOR THE NAME AT TOP.  IF
		FOUND, THE ADDRESS OF THE DIRECTORY ENTRY IS LEFT AT
		TOP.  IF NOT FOUND, THE ERROR "FILE DOES NOT EXIST"
		IS GIVEN.

NOT-EXIST	SEARCHES THE DIRECTORY FOR THE NAME AME AT TOP.  IF
		FOUND, A -1 IS RETURNED AT TOP AND A POINTER TO
		THE DIRECTORY ENTRY AT TOP - 1.  IF NOT FOUND,
		A ZERO IS LEFT AT TOP.

DIRECTORY	RETURNS ON THE TOP OF THE STACK THE ADDRESS OF
		THE FIRST BYTE OF A BUFFER CONTAINING THE
		DIRECTORY.

SLOT		RETURNS THE ADDRESS OF THE END-OF DIRECOTRY ENTRY
		IN THE DIRECTORY BUFFER.

SBLK		GIVEN THE ADDRESS OF A DIRECTORY ENTRY AT TOP, RETURNS
		THE STARTING BLOCK NUMBER FOR THE FILE.

PRINT		TYPES OUT ON THE SYSTEM CONSOLE THE CONTENTS OENTS

0	NUMBER OF FIRST BLOCK OF FILE
	(= 0 IF NOT OPEN)

1	CURRENT RELATIVE BLOCK NUMBER

2	CURRENT RELATIVE BYTE NUMBER WITHIN CURRENT BLOCK


BASIC BLOCK I/O WORDS

	THE FILE SYSTEM IS BUILT ON A SET OF LOWER LEVEL WORDS
WHICH MAY BE USED DIRECTLY BY THE USER TO PERFORM OPERATIONS
ON BLOCKS OF STORAGE:

L M N RDBLKS	READS N BLOCKS STARTING AT BLOCK M INTO MEMORY
		STARTING AT LOCATION L.

L M N WRBLKS	WRITES N BLOCKS STARTING AT BLOCK M FROM MEMORY
		STARTING AT LOCATION L.

BUFFER HE BLOCK IS READ IN.

WBLOCK	RETURNS THE ADDRESS OF A BUFFER CONTAINING THE BLOCK
	WHOSE NUMBER IS AT TOP.  THE BUFFER IS FLAGGED AS
	MODIFIED.  IF THE BLOCK IS NOT ALREADY IN MEMORY, IT
	IS NOT READ IN.

FLUSH	WRITES OUT ALL MODIFIED BUFFERS.  THIS WORD MUST BE
	EXECUTED BEFORE SHUTTING DOWN THE SYSTEM OR CHANGING
	MEDIA TO ENSURE THAT THE INFORMATION ON THE STORAGE
	MEDIUM IS CURRENT.

EBUF	FLAGS ALL BUFFERS AS EMPTY.  THIS WORD MUST BE USED
	WHEN CHANGING MEDIA.

UPDATE	FLAGS THE MOST RECELE WRCI	WRITE A CORE IMAGE INTO THE NAMED FILE

	'FILE RDCI	READ A CORE IMAGE FROM THE NAMED FILE

	THE CONTENTS OF THE I/O BUFFERS ARE NOT SAVED AS PART
OF THE CORE IMAGE FILE, BUT ALL OTHER VARIABLES USED BY THE KERNEL,
THE CONTENTS OF ALL STACKS, THE INTERRUPT DISPATCH TABLE, AND ALL
USER DEFINITIONS ARE TRANSFERRED.

	CORE IMAGE FILES MUST BE REGENERATED WHENEVER A NEW VERSION
OF THE KERNEL IS USED SINCE THE NEW USER DEFINITIONS REFERENCE
ABSOLUTE LOCATIONS WITHIN THE KERNEL.

	TO GENERATE A BOOTSTRAPPABLE FILE CONTAINING THE STOIC KERNEL
PLUS ALL CURRENT USER DEFINITIONS, THE FOLLOWING COMMAND IS USED:

	'FILE WRITE-BOOT	WRITES A BOOTSTRAP FILE.

THE BOOTSTRAP FILE CAN THEN BE LOADED DIRECTLY BY THE BOOTSTRAP BY
RESPONDING WITH THE FILENAME TO THE INITIAL PROMPT.


STRING HANDLING

	STOIC STRINGS ARE STORED IN MEMORY IN THE
	FOLLOWING FORMAT:

	<LENGTH>STRING<0>

	THE LENGTH BYTE DOES NOT INCLUDE THE TERMINATING
	NULL.  THE STRING MAY INCLUDE NULLS BEFORE THE
	FINAL ONE.  T TO THE FIRST CHARACTER
FOLLOWING THE LENGTH BYTE AT TOP - 1.

MSG

	THE WORD "MSG" IS EQUIVALENT TO "COUNT TYPE".
	GIVEN A POINTER TO A STRING AT TOP, IT CAUSES
	THE STRING TO BE TYPED.

S,

	"S," TAKES A STRING ARGUMENT ON THE TOP OF THE STACK
	AND COPIES THE STRING ONTO THE END OF THE DICTIONARY.
	THE END OF THE DICTIONARY IS EXTENDED TO PERMANENTLY
	INCLUDE THE STRING.


EXAMPLES:

	'LARK : 'NONSENSE MSG ;

	EXECUTING "LARK" CAUSES "NONSENSE" TO BE TYPED.


NUMBER OUTPUT CONVERSI#A	CONVERT THE NUMBER ON THE TOP OF THE STACK
	TO AN ASCII DIGIT.

#	COMPUTE THE NEXT DIGIT AND OUTPUT IT.
	AN INTEGER IS INPUT FROM THE TOP OF THE STACK
	AND DIVIDED BY "RADIX".  THE REMAINDER IS
	CONVERTED TO A DIGIT AND OUTPUT; THE
	QUOTIENT REMAINS ON THE STACK.

#S	COMPUTE DIGITS AND OUTPUT THEM UNTIL THE
	REMAINING NUMBER IS ZERO.  "#S" ALWAYS OUTPUTS
	AT LEAST ONE DIGIT.

#>	TERMINATE THE NUMBER CONVERSION, LEAVING A
	BYTE COUNT ON TOP OF STACK, A BYTE POINTER AT
	TOP - 1.

HIGHER LE THE NUMBER ON THE TOP OF THE
	STACK. (SIGNED)

U?	CONVERT AND OUTPUT THE NUMBER ADDRESSED BY THE
	TOP OF THE STACK.  (UNSIGNED)

?	CONVERT AND OUTPUT THE NUMBER ADDRESSED BY THE
	TOP OF THE STACK.  (SIGNED)


EXAMPLE:

	'$= : <# # # 56 #PUT #S 44 #PUT #> TYPE ;
	(RADIX IS ASSUMED TO BE OCTAL)

	0> 100 $=
	$1.00
	0> 1000 $=
	$10.00

	"$=" TYPES THE TOP OF THE STACK IN AN UNSIGNED
	DOLLAR AND CENTS FORMAT.  NUMBER CONVERSION IS
	INITIATED BY "<#", THE CENTS ARE OUTPUT BY THE
	TWO "#"'SPACES PRECEDING THE
	NUMBER.


TYI AND TYO

	"TYI" AND "TYO" PROVIDE A GENERALIZED CHARACTER
ORIENTED INPUT AND OUTPUT FACILITY.  "TYI" INPUTS A
CHARACTER BY EXECUTING THE WORD WHOSE ADDRESS IS
CONTAINED IN THE VARIABLE "IN".  "TYO", SIMILARLY
EXECUTES THE CONTENTS OF "OUT".  "IN" AND "OUT" ARE
INITIALIZED TO POINT TO "<TTI>", AND "<TTO>", WHICH ARE
TELETYPE INPUT AND OUTPUT WORDS.  ANY WORD WHICH USES
"TYO" FOR OUTPUT MAY BE MODIFIED TO OUTPUT ON ANOTHER
DEVICE OR PERHAPS INTO A CORE BUFFER BHE LENGTH FIELD MUST BE LESS THAN
	128 DECIMAL.

	EXAMPLE:

	<4>ABCD<0>

	THIS IS THE INTERNAL REPRESENTATION OF THE
	STRING "ABCD".

	EXECUTING A STRING LITERAL CAUSES A POINTER TO
THE FIRST BYTE OF THE STRING TO BE PUSHED ON THE STACK.
THIS POINTER MAY BE CONVERTED INTO BYTE-POINTER,
BYTE-COUNT FORM BY USING THE WORD "COUNT" DESCRIBED
BELOW.

COUNT

	"COUNT" TAKES A POINTER TO A STRING AS INPUT ON
THE STACK AND LEAVES THE LENGTH OF THE STRING ON THE TOP
OF THE STACK, AND A BYTE POINTERON

	STOIC PREFORMS NUMBER CONVERSION USING A SMALL
BUT POWERFUL SET OF WORDS WHICH PERMIT A WIDE VARIETY OF
OUTPUT FORMATS TO BE GENERATED.  NUMBER CONVERSION
PROCEEDS FROM RIGHT TO LEFT, CONVERTING ONE DIGIT AT A TIME.
THE CONVERSION TAKES PLACE IN THE CURRENT RADIX.  DIGITS
ARE STORED IN A TEMPORARY AREA AT THE END OF THE DICTIONARY
SET UP BY "<#".

RADIX	VARIABLE WHICH CONTAINS CURRENT INPUT AND
	OUTPUT RADIX.

<#	INITIATE NUMBER CONVERSION.

#PUT	OUTPUT A CHARACTER FROM TOP OF STACK.

VEL WORDS ARE USED TO PROVIDE NUMBER OUTPUT
IN A DEFAULT FORMAT:

U<#>	CONVERT THE UNSIGNED NUMBER ON THE TOP OF THE STACK
	AND LEAVE BYTE COUNT AND BYTE POINTER ON THE STACK.
	"U<#>" IS DEFINED  AS:

	'U<#> : <# #S #> ;

<#>	CONVERT THE SIGNED NUMBER ON THE TOP OF THE STACK
	AND LEAVE BYTE COUNT AND BYTE POINTER ON THE STACK.
	"<#>" IS DEFINED AS:

	'<#> : DUP <L <# #S  L> LTZ IF 55 #PUT THEN #> ;

U=	CONVERT AND OUTPUT THE NUMBER ON THE TOP OF THE
	STACK. (UNSIGNED)

=	CONVERT AND OUTPUT, A PERIOD IS OUTPUT BY "56 #PUT", THE
	REMAINING DOLLARS ARE OUTPUT BY "#S", AND THE
	DOLLAR SIGN IS OUTPUT BY "44 #PUT".  "<# TERMINATES
	THE CONVERSION PROCESS AND LEAVES A BYTE POINTER
	AND BYTE COUNT FOR THE RESULTANT STRING ON THE STACK
	AS INPUT TO "TYPE" WHICH OUTPUTS THE STRING.

	JUSTIFICATION OF NUMERIC OUTPUT MAY BE ACHIEVED
	AS FOLLOWS:

	'4= : <#> 4 OVER - SPACES TYPE ;

	THE WORD "4=" WILL TYPE OUT NUMBERS RIGHT
	JUSTIFIED IN A FOUR COLUMN FIELD BY TYPING
	A VARIABLE NUMBER OF SY CHANGING "OUT".
SIMILARLY, CHANGING "IN" WILL MODIFY THE INPUT OF ANY
WORD USING "TYI".  "TYPE", "MSG" AND ALL THE NUMBER
CONVERSION ROUTINES USE "TYO" TO PERFORM OUTPUT.


RECURSION

	SINCE STOIC IS A STACK ORIENTED LANGUAGE,
RECURSION IS HANDLED QUITE EASILY.  THE WORD "EXEC"
TAKES AS AN ARGUMENT ON THE STACK THE ADDRESS OF A WORD
TO BE EXECUTED AND CALLS IT.  BY PLACING THE ADDRESS OF
THE CALLING ROUTINE ITSELF ON THE STACK, A RECURSIVE
CALL IS GENERATED.

EXAMPLE:

0 'SELF VARIABLE
'FACTORIAL :  DUP 1 NE IF DUP 1- SELF @ EXEC * THEN ;
() FACTORIAL SELF !

THIS DEFINES A RECURSIVE FACTORIAL ROUTINE.


VOCABULARIES

	IN ADDITION TO THE PARAMETER STACK, STOIC USES
ANOTHER STACK CALLED THE VOCABULARY STACK.  THIS STACK
IS USED TO CONTROL DICTIONARY LOOKUP OPERATIONS.

	WHEN STOIC LOOKS UP A WORD IN THE DICTIONARY, IT
STARTS ITS SEARCH AT A LOCATION WHOSE ADDRESS IN STORED
ON THE TOP OF THE VOCABULARY STACK.  IF THE SEARCH
FAILS, IT SEARCHES AGAIN USING THE NEXT TO TOP OF THECALLED "STOIC<",
AND "ASSEMBLER<".  INITIALLY, THE VOCABULARY STACK
CONTAINS ONLY THE ADDRESS OF "STOIC<".  "ASSEMBLER<" IS
USED WHEN MAKING CODE DEFINITIONS AND CONTAINS SPECIAL
WORDS USED ONLY BY THE STOIC ASSEMBLER.  "STOIC<" IS THE
MAIN BRANCH OF THE DICTIONARY, AND "ASSEMBLER<" IS A
SIDE-BRANCH.

	A NEW BRANCH OF THE DICTIONARY IS CREATED AS
	FOLLOWS:

	'NAME BRANCH

	REFERENCING A VOCABULARY CAUSES ITS ADDRESS TO
	BE PUSHED ON THE VOCABULARY STACK.  THE NEW
	BRANCH IS ATTACHED AT THE ENW
VOCABULARY IS AS FOLLOWS:

	1) DEFINE THE VOCABULARY USING "BRANCH"

	2) PUSH THE ADDRESS OF THE VOCABULARY ON THE
	   VOCABULARY STACK BY REFERENCING THE VOCABULARY.

	3) SET "CURRENT" USING "DEFINITIONS".

	4) DEFINE ALL THE WORDS IN THE VOCABULARY.

	5) POP THE VOCABULARY STACK USING ">".

	6) RESET "CURRENT"

EXAMPLE:

	'VOCAB< BRANCH
	VOCAB< DEFINITIONS
	.
	.
	.
	> DEFINITIONS

	THIS DEFINES A NEW BRANCH OF THE DICTIONARY
	CALLED "VOCAB".

ENTIRE SECTIONS OF THE DICTIONARYMAY BE
	PLACED AT THE BEGINNING OF THE PROGRAM.

	"FORGET" MAY ALSO BE USED TO PROVIDE AN OVERLAY
	FACILITY.  SAY THAT A PROGRAM HAS BEEN LOADED.
	IT MAY THEN BE DELETED BY FORGETTING THE
	FIRST DEFINITION OF THE PROGRAM AND THE DICTIONARY
	SPACE IS THEN FREE TO LOAD ANOTHER PROGRAM.


DEBUGGING TECHNIQUES

	THE FOLLOWING ARE TECHNIQUES WHICH MAY PROVE
USEFUL IN DEBUGGING NEW DEFINITIONS:

1) IT IS USUALLY MORE EFFICIENT TO MAKE A NEW
   DEFINITION IN A FILE USING THE EDITOR RATHER THAN
   THE RESULTS ON
   THE STACK, TYPE AN EXTRA "=" TO MAKE SURE THE STACK
   IS EMPTY.  YOU SHOULD GET THE MESSAGE "STACK EMPTY".
   SIMILARLY, THE LOOP STACK SHOULD BE CHECKED BY TYPING
   "L>"; THIS SHOULD GENERATE THE MESSAGE "LOOP STACK
   EMPTY".

5) KEEP TRACK OF THE RADIX YOU ARE USING.  THIS IS THE
   SOURCE OF FREQUENT ERRORS.  WITHIN A FILE BEING
   EXECUTED, SAVE THE RADIX, SET IT TO THE VALUE THE
   PROGRAM EXPECTS, AND WHEN DONE, RESTORE THE SAVED
   VALUE.  FOR EXAMPLE:

	RADIX @ DECI
VOCABULARY STACK, ETC. UNTIL THE BOTTOM OF THE
VOCABULARY STACK IS REACHED.  IF THE NAME IS STILL
NOT FOUND, THE SEARCH FAILS.

	THE DICTIONARY MAY HAVE ANY NUMBER OF BRANCHES.
DIFFERENT WORDS HAVING EXACTLY THE SAME NAMES MAY BE
RESOLVED IF THEY ARE ON SEPARATE BRANCHES OF THE
DICTIONARY.  A BRANCH OF THE DICTIONARY IS CALLED A
VOCABULARY.

	WHEN STOIC DEFINES A NEW WORD, THE DICTIONARY
ENTRY IS APPENDED TO THE BRANCH POINTED TO BY THE
VARIABLE "CURRENT".

	THE KERNEL HAS TWO VOCABULARIES, D OF THE EXISTING
	BRANCH POINTED TO BY "CURRENT".

	>	DISCARDS THE TOP OF THE VOCABULARY STACK

	ATTEMPTING TO POP THE LAST ENTRY OFF THE BOTTOM
	OF THE VOCABULARY STACK CAUSES THE ERROR:

	"VOCABULARY STACK EMPTY".

	TO SET "CURRENT" TO  POINT TO A NEW VOCABULARY,
	THE FOLLOWING WORD IS USED:

	DEFINITIONS	SETS "CURRENT" TO LINK NEW DEFINITIONS
			ONTO THE SAME BRANCH OF THE DICTIONARY
			AS IS POINTED TO BY THE TOP OF THE
			VOCABULARY STACK.


THE NORMAL PROCEDURE WHEN SETTING UP A NE MAY BE DELETED
BY USING THE FOLLOWING WORD:

	'NAME FORGET DISCARDS THE NAMED DICTIONARY
		     ENTRY AND ALL SUBSEQUENT
		     ENTRIES.

	FORGET IS USEFUL WHEN TRYING OUT DEFINITIONS
	FROM THE KEYBOARD.  THE USUAL PROCEDURE IS TO
	FIRST MAKE A DUMMY DEFINITION:

	'TEST : ;

	NEXT, TEST DEFINITIONS ARE MADE (TYPICALLY BY
	LOADING A PROGRAM).  IF THEY ARE UNSUCCESSFUL,
	"'TEST FORGET" WILL DELETE THEM FROM THE
	DICTIONARY, AND THE PROCESS IS REPEATED.
	FOR CONVENIENCE, THE DUMMY DEFINITION FROM THE KEYBOARD IF IT IS MORE THAN ONE LINE LONG.
   "FORGET" IS THEN USED TO REMOVE THE LAST VERSION OF
   THE DEFINITION BEFORE TRYING AGAIN.

2) TO TEST A WORD, MERELY FEED IN ARGUMENTS ON THE
   STACK, EXECUTE THE WORD, AND EXAMINE THE RESULTS
   USING "=" AND "?".

3) IF A WORD FAILS, TYPE IN THE WORDS WHICH MAKE IT UP,
   ONE AT A TIME, EXAMINING THE STACK AS YOU GO ALONG AND
   RESTORING IT BY TYPING THE PARAMETERS BACK IN, IN
   REVERSE ORDER.

4) AFTER EXECUTING A WORD AND EXAMINING MAL
	.
	.
	.
	RADIX !
	;F

	THIS SAVES THE CURRENT RADIX ON THE STACK, AND
	SETS THE RADIX TO DECIMAL.  UPON TERMINATION,
	THE OLD RADIX IS RESTORED (ASSUMING THE STACK
	HAS NOT BEEN DISTURBED).

6) THE PROPER SELECTION OF LOWER LEVEL WORDS HAS AN
   ENORMOUS EFFECT ON ALL SUBSEQUENT HIGHER LEVEL
   DEFINITIONS.  THUS IT PAYS TO DESIGN THE LOWER LEVEL
   WORDS VERY CAREFULLY.

7) WHEN DEBUGGING A PROGRAM, TEST ALL LOWER LEVEL WORDS
   THOROUGHLY BEFORE TESTING THE WORDS WHICH CALL THEM.

8) BE ESPECIALLY CAREFUL WITH ANY WORD WHICH MODIFIES
   MEMORY; MAKE SURE THE WORD IS MODIFYING ONLY THOSE
   LOCATIONS YOU INTEND, AND NOT PART OF THE PROGRAM.



***EOF***
   MEMORY; MAKE SURE THE WORD IS MODIFYING ONLY THOSE
   LOCATIONS YOU BECAUSE OF SPACE LIMITS, THE FILE STOIC.COM WAS NOT PLACED ON
THIS DISKETTE, AS SUGGESTED IN STOICCPM.DOC.  ALSO THE BOOTSTRAP
AND DOCUMENTATION ON THE BOOT AND SYSTEM LOADING WERE OMITTED.  THEY
CAN BE OBTAINED A VOLUME 23B, BUT IN ANY EVENT WILL APPEAR AS PART
OF A REGULARLY SCHEDULED FUTURE RELEASE.

;**************************************************

TO CONSTRUCT THE STOIC.COM, IT IS NECESSARY TO ASSEMBLE THE KERNEL
AND THEN HAVE IT LOAD THE BASIC DEFINITIONS.  AS EXPLAINED BELOW, THE
LOADINGT" IS DEFAULTED TO 0 IN
THE KERNEL.  THIS DEFINES THE DISK DRIVE FOR LOADING.  THE WORD
TO CHANGE THE DEFINITION IS "!" (THE "'S ARE NOT INCLUDED), WHICH
IS DEFINED IN STOICBAS.  TO CHANGE THE VALUE TYPE

		0 UNIT !

WHICH WILL ALLOW THE FUNCTION 

		STOICXXX CPMLD

TO LOAD THE STOICXXX.STC FILE FROM DISK DRIVE B
VOLUME 23

STOIC (STACK ORIENTED INTERACTIVE COMPILER)

STOIC HAS THE CAPABILITIES OF A COMPILER, EDITOR, ASSEMBLER,
DEBUGGER, LOADER AND OPERATING SYSTEM.  IT APPEARS TO BE
CONCEPTUALLY SIMILAR TO FORTH IN THE USE OF AN EXTENSIBLE
VOCABULARY OF WORDS, WITH THE ABILITY TO "FORGET" DEFINITIONS
AND RE-DEFINE OR CREATE NEW WORDS IN TERMS OF PREVIOUSLY LEARNED
WORDS.

THE FIRST TWO MODULES, THE BOOTSTRAP AND KERNEL, WERE WRITTEN
IN ASSEMBLER MNEMONICS.  THEREAFTER THE MODULES WERE WRITTEN IN
STOIC OLUMES WILL
ALSO BE ADDED TO A FUTURE REGULAR VOLUME, AND WERE SELECTED AS THE
LEAST NECESSARY FOR A CP/M USER.

FILES OF TYPE .STC ARE WRITTEN IN STOIC AND CAN BE LOADED AS DESCRIBED
IN THE VOLUME23.DOC

NUMBER	SIZE	NAME		COMMENTS

		CATALOG.23	CONTENTS OF CP/M GROUP VOL 23
		VOLUME23.DOC	COMMENTS ON THIS VOLUME, ADDITIONAL
				TO STOICCPM.DOC
		STOICCPM.DOC	COMMENTS ON CP/M STOIC. READ TOGETHER
				WITH THE VOLUME23.DOC
23A.1	13K	ASSEMBL.DOC	STOIC 8080 ASSEMBLER
23A.2	8K	DICT.DOC	STOIC DICT OF STOICBAS SHOULD BE PERFORMED FROM DRIVE A

MACHINE				YOU

A>				ASM KERNEL.AAZ
CP/M ASSEMBLER - VER 1.0

1A98
015H USE FACTOR
END OF ASSEMBLEY

A>
				LOAD KERNEL
SOURCE IS DISK

FIRST ADDRESS  0100
LAST  ADDRESS  18BD
BYTES READ     0EB6
RECORDS WRITTEN  30

A>
				KERNEL
0>
				'STOICBAS CPMLD
0>
				SZSTOIC
STOIC IS  50 DECIMAL PAGES LONG
				RETCPM
A>
				SAVE 50 STOIC.COM
A>

;**************************************************

NOTE THAT THE VALUE OF THE WORD "UNIWORDS.

THIS PACKAGE IS A STAND-ALONE SYSTEM AND DOES NOT REQUIRE A
RESIDENT FDOS, SUCH AS CP/M OR ISIS.

THE MATERIAL HAS BEEN SIGNIFICANTLY RE-ARRANGED AND REVISED SINCE THE
CATALOGS WERE FIRST PUBLISHED.  IN PARTICULAR THE KERNEL NOW INCORPORATES
WORD DEFINITIONS WHICH PERMIT DIRECT OPERATION THROUGH CP/M.
STOICCPM.DOC EXPLAINS THE PROCEDURE FOR BRINGING THE SYSTEM UP.  IT
WAS NECESSARY TO LEAVE CERTAIN FILES OFF BECAUSE OF LACK OF SPACE,
AND THESE CAN BE OBTAINED AS VOLUME 23B.  THE OVERFLOW VIONARY DEFINITIONS
23A.3	8K	EDIT.DOC	STOIC DISPLAY EDITOR DOC
23A.4	9K	FILES.DOC	STOIC FILE SYSTEM DOC
23A.5	5K	FLOATPNT.DOC	FLOATING POINT DOC
23A.6	2K	INTRRUPT.DOC	INTERRUPT HANDLER DOC
23A.7	38K	KERNEL.ASM	STOIC KERNEL WITH CP/M WORDS IN 8080
				ASSEMBLER
23A.8	24K	KERNEL.DOC	STOIC KERNEL DOC
23A.9	46K	STOIC.DOC	OVERVIEW OF STOIC CONCEPTS AND STRUCTURE
23A.10	23K	STOICBAS.STC	BASIC DEFINTIONS
23A.11	4K	STOICD/A.STC	GRAPHICS FOR D/A HARDWARE
23A.12	9K	STOICEDT.STC	EDITOR
23A.13	3K	STOICFFT.STC	FAST FOURIER TRANSFORM
23A.14	8K	STOICFLE.STC	FILE SYSTEM
23A.15	11K	STOICFLT.STC	FLOATING POINT PACKAGE
23A.16	5K	STOICINT.STC	4 BYTE INTEGER ADDITION
23A.17	3K	STOICITP.STC	INTERRUPT PACKAGE
23A.18	3K	STOICMIS.STC	MISCELLANEOUS WORDS
23A.19	2K	STOICSIN.STC	INTEGER SINE AND COSINE
23A.20	2K	STOICSRT.STC	SORT ROUTINE

OVERFLOW AVAILABLE AS VOLUME 23B. THIS MATERIAL IS NOT ESSENTIAL
FOR CP/M USE, AND WILL BE AVAILABLE ON A REGULAR VOLUME AT SOME
FUTURE DATE.

23B.1	7K	BOOT.ASM	STOIC BOOTSTRAP FOR SAVING STOIC
;	10)CHANGES TO THE ORGINAL KERNEL SO THE KERNEL WILL
;		ASSEMBLE USING "ASM"
;		A) ALL ? CHANGED TO Q$
;		B) ALL MVI A,-1 CHANGED TO MVI A,0FFH
;		C) ALL MVI M,-1 CHANGED TO MVI M,OFFH
;
;
;/////////////////////////////////////////////////////////////////
;
;
	IF CPM
;
;BLOCK DEFINITIONS
;
BSIZE	EQU	400H	;SIZE OF DISK BLOCK
NBLKS	EQU	77*26*128/BSIZE ;77 TRACKS
				;26 SECTORS PER TRACK
				;128 BYTES PER SECTOR
				;NUMBER OF BLOCKS
;
;
;PARAMETER DEFINITIONS

SSIZEROUTINE
CONI	EQU	6	;INDEX INTO CONSOLE CBIOS ROUTINE
BASEIOS	EQU	1	;LOCATION 1 HAS BASE OF IOS
SELDSK	EQU	14	;SELECT THE DISK
OPENCPM EQU	15	;OPEN A CPM FILE
RDNXTREC EQU	20	;READ NEXT SECTOR
CPMFCB	EQU	5CH	;DEFUALT FILE CONTROL BLOCK
SETDMA	EQU	26	;SET DMA ADDRESS
;
;
;
;TTYIN
Q$TTYI:	LHLD	BASEIOS	;GET ADDRESS OF IOS
	LXI	D,CONI
	DAD	D
	PCHL	;JMP TO ROUTINE
;
;
;TTY OUT
Q$TTYO:	ANI	7FH	;CLEAR MSB
	MOV	C,A	;PLACE IN REG C
	LHLD	BASEIOS	;GET BASE OF IOS TABLE
	LXI	D,CONO
	DAD	D	;HL=ADDC,SETDMA
	CALL	BDOS	;SET THE DMA ADDRESS
	LXI	D,CPMFCB
	MVI	C,RDNXTREC  ;READ THE NEXT RECORD
	CALL	BDOS	;READ THE SECTOR
	POP	D
	POP	B	;RETRIEVE POINTERS
	ORA	A	;SET FLAGS RETURNED FROM THE READ OPERATION
	JZ	NXTSECCONT
	DCR	A	;IF ERROR WAS END OF FILE IGNORE
	RET		;IF ERROR WAS A 2 RET WITH ERROR 1
;
NXTSECCONT:
	LXI	H,128	;
	DAD	D
	XCHG		;DE=NEXT DMA LOCATION
	DCR	B
	JNZ	NXTSEC
	RET
;
;
;/////////////////////////////////////////////////
;
;
;ROUTINE: RET TO CPM
;PRUP: RETURN TO C,0
	INX	H
	DCR	B
	JNZ	Q$0FCB1	;JIF NOT DONE
	JMP	Q$NEXT
;
;///////////////////////////////////////////////////////////
;
;
;
;OPFILE
;PURP:	OPEN A CPM FILE
;ENTRY:	TOS=FCB ADDRESS
;EXIT:	TOS=0 IF OK
;	TOS=-1 IF ERROR
;PROCEDURE
	DB	6,'OPFIL'
	DW	Q$0FCB
	DW	$+2
Q$OPFILE: LDA	Q$UNIT	;GET THE UNIT
	MOV	E,A
	MVI	C,SELDSK
	CALL	BDOS
	POP	D	;GET FCB ADDRESS
	MVI	C,OPENCPM
	CALL	BDOS	;OPEN FILE
	INR	A
	JNZ	Q$NEXT	;JIF NO ERRORS
	LXI	H,OPENERR
	JMP	ERROR
;
;OPEN ERROR MESSAGE
OPENERRIN 8080 ASSEMBLER
23B.2	2K	BOOT.DOC	BOOT DOC
23B.3	6K	LOAD.DOC	INFORMATION ON LOADING STOIC AS A
				STAND-ALONE SYSTEM
23B.4	13K	STOIC.COM	CP/M STOIC CONSTRUCTED AS DESCRIBED
				IN VOLUME23.DOC
SSUMED TO BE "STC"
;	7) RETCPM COMMAND WHICH WILL REBOOT CPM
;	8) ALSO THE MEMORY WILL BE SET EACH TIME STOIC IS BROUGHT UP
;		TO THE VALUE @ LOCATION 6 = ADDRESS OF THE BASE OF BDOS
;	9) SZSTOIC COMPUTES THE # OF 256 BYTE PAGES USED BY STOIC
;		USED 	EQU	256	;MAIN STACK SIZE
RSIZE	EQU	64	;RETURN STACK SIZE
LSIZE	EQU	64	;LOOP STACK SIZE
VSIZE	EQU	8	;VOCABULARY STACK SIZE
KSIZE	EQU	82	;KEYBOARD BUFFER SIZE
CSIZE	EQU	256	;COMPILE BUFFER SIZE

	ORG	100H
;
;ENTER STOIC
TPA:	LXI	SP,SSTACK  ;SET NEW STACK POINTER
;
; PICK UP SIZE OF AVAIL MEMORY
	LHLD	BDOS+1	;GET BEGINING OF BDOS
	SHLD	Q$MEMO	;STORE IN MEMORY LOCATION
	JMP	ABORT	;ENTER STOIC
;
;
; BDOS AND IO EQUATES
;
BDOS	EQU	5	;ADDRESS OF JMP TO BDOS
CONO	EQU	9	;DISPLACEMENT TO CONOUT RESS OF CONSOLE OUT ROUTINE
	PCHL		;JMP TO CONO
;
;
;DISK OUTPUT ROUTINE PRESENTLY CAUSES A ERROR

DSKOU:	MVI	A,1
	RET
;
;DISK INPUT ROUTINE
;PURP:	INPUT A BLOCK OF DATA [8 SECTORS ] FROM A CPM FILE
;ENTRY:	HL=BLOCK# IN LOWER 9 BITS [DISCARDED]
;	THE 10,AND 11 BITS [BIT 1,2 OF HL] = THE UNIT
;EXIT:	A=0 IF GOOD READ ELSE A=1
;
;PROCEDURE
;
;
;SET THE DMA ADDRESS TO POINT TO THE BUFFER
;	AND READ 8 SECTORS
DSKIN:	MVI	B,BSIZE/128
NXTSEC:	PUSH	B	;SAVE COUNT
	PUSH	D	;SAVE DMA ADDRESS
	MVI	PM
;ENTRY:	NONE
;EXIT:	NONE
;PROCEDURE
;
	DB	6,'RETCP'
	DW	0
	DW	$+2
Q$RETCPM: LHLD 	BASEIOS
	PCHL		;DO A WARM BOOT
;
;
;//////////////////////////////////////////////////
;
;
;
;ADDITIONAL WORDS TO IMPLEMENT FILE READING
;
;
;//////////////////////////////////////////////////
;
;ROUTINE: 0FCB
;PURP:	FILL A CPM FCB WITH ZERO'S
;ENTRY:	TOS=FCB ADDRESS
;EXIT:	TOS=DELETED
;PROCEDURE
;
	DB	4,'0FCB'
	DW	Q$RETCPM
	DW	$+2
Q$0FCB:	POP	H	;FETCH FCB ADDRESS
	MVI	B,33

Q$0FCB1:
	MVI	M: DB	15,'OPEN FILE ERROR',0
;
;
;
;////////////////////////////////////////
;
;ROUTINE DFTFCB
;PURP:	PUSH THE ADDRESS OF THE DEFUALT ON TO THE TOS
;ENTRY:	NONE
;EXIT:	TOS=DEFUALT FCB
;PROCEDURE
;
	DB	6,'DFTFC'	;DEFUALT FCB
	DW	Q$OPFILE
	DW	Q$CONS
Q$DFTFCB: DW	CPMFCB
;
;//////////////////////////////////////////////
;
;ROUTINE: STORE A FILE NAME IN THE FCB
;PURP:
;ENTRY: TOS=FCB,NAME
;EXIT:	TOS=DELETED
;PROCEDURE
;
	DB	6,'STNAM'	;STORENAME
	DW	Q$DFTFCB
	DW	$+2
Q$STNAME: POP	D	;GET DESTINATION
	POP	H	;GET SOURCE
	MOV	A,M	;GET LENGTH OF SOURCE
	MOV	B,A	;PLACE IN B
	CPI	9	;TEST FOR PROPER LENGTH
	JC	STN1	;JIF OK
	LXI	H,BADNAME  ;ELSE ERROR EXIT
	JMP	ERROR
;
;FIRST MOVE THE DEFUALT EXTENSION ".STC" AND CLEAR THE NAME
;  THE MOVE IN THE NAME
STN1:	PUSH	H
	PUSH	D
	MVI	C,2	;C=COUNTER TO DETERMINE WHEN THE NAME IS MOVED
	LXI	H,DFEXT	;HL=DEFUALT CLEARED NAME AND .EXT
STN2:	MOV	B,M	;FETCH COUNT
STN3:	INX	D	;NEXT FCB
	INX	H	;NEXT SOURCE
	MOV	A,M
	STAX	D
	DCR	B	;DEC COUNT
	N
Q$CPMLD:	DW	Q$DFTFCB
	DW	Q$0FCB	;0 THE FILE CONTROL BLOCK
	DW	Q$DFTFCB
	DW	Q$STNAME	;STORE NAME IN DFTFCB
	DW	Q$DFTFCB ;GET ADDRESS OF DEFUALT FCB
	DW	Q$OPFILE	;OPEN THE FILE
	DW	EBUF	;EMPTY THE BUFFERS
	DW	LIT
	DW	1	;DUMMY BLOCK 1
	DW	LOAD	;LOAD THE FILE
	DW	Q$SEMI	;RETURN
;
;
	ENDIF
;
;
;/////////////////////////////////////////////////////////////
;
;
;INTERPRETER
;
	DW $+2
PUSH0:	LXI H,0		;0PUSH
	JMP Q$Q$PUSH

	DW $+2
PUSH1:	LXI H,-1	;-1PUSH
	JMP Q$Q$PUSH

Q$DPUSH:	PUSH DR RETURNED IN A

TTYIN:	LHLD Q$TYI
	PCHL

;TTY OUTPUT ROUTINE (JUMPS TO ADDRESS IN Q$TYO)
;
;	CHARACTER IN A
;	CALL TTYOU

TTYOU:	LHLD Q$TYO
	PCHL

	DW $+2
Q$SEMI:	LHLD Q$R		;RETURN STACK PTR
	MOV E,M		;GET TOP OR STACK INTO DE
	INX H
	MOV D,M
	DCX H
	DCX H		;DECREMENT RETURN STACK PTR BY 2
	DCX H
	SHLD Q$R
	XCHG		;MOVE RESULT TO HL
	SHLD Q$I		;SET .I
	JMP Q$NEXT

	DW $+2
Q$SCOD:	LHLD Q$CURR	;(;CODE<)
	MOV E,M
	INX H
	MOV D,M
	DCX D
	DCX D
	LHLD Q$I
	INX H
	INX H
	XCHG
	
	DW SLIT
	DW $+2
ABORT:	LXI SP,SSTACK	;RESET STACK PTR
	LXI H,RSTACK	;RESET RETURN STACK PTR
	SHLD Q$R
	LXI H,LSTACK	;RESET LOOP STACK PTR
	SHLD Q$Q$L
	LXI H,-1	;SET INBLK TO -1 (READ FROM KEYBOARD)
	SHLD Q$INBLK
	CALL Q$Q$AB	;CALL USER ABORT ROUTINE
	LXI H,GO-2	;SET .I TO GO-2
	SHLD Q$I
	JMP Q$NEXT	;START IT UP

Q$Q$AB:	LHLD Q$ABORT	;JMP TO ABORT ROUTINE ADDRESS
	PCHL

	IF DEBUG
;TEST FOR DICTIONARY FULL
DICTF:	LHLD Q$MEMO	;END OF MEMORY
	LXI D,-100	;-100 FOR SAFETY
	DAD D
	CALL Q$MBY (DE)
;RESULT RETURNED IN (HLDE)

Q$MUL:	PUSH H		;MUL
	MOV A,L		
	LXI H,0		
	LXI B,8	
MULT1:	DAD H		
	RAL		
	JNC MULT2	
	DAD D		
	ADC B
MULT2:	DCR C		
	JNZ MULT1	
	XTHL		
	MOV L,A		
	MOV A,H		
	MOV H,B		
	MVI C,8	
MULT3:	DAD H		
	RAL
	JNC MULT4
	DAD D
	ADC B
MULT4:	DCR C
	JNZ MULT3
	MOV D,A	
	MOV E,H		
	MOV H,L	
	MOV L,B		
	POP B		
	DAD B		
	JNC MULT5		
	INX D
MULT5:	XCHG		
	RET
;
;
	DB 6,'(ELSE'		;(ELSE)
	DW ABORT
	DW $+2
Q$ELSE:	LHLD Q$I
	INX H
	INX H
	MOV E,MJNZ	STN3	;JIF NOT DONE
	DCR	C	;DEC C TO CHECK IF WE HAVE MOVED THE NAME
	JZ	Q$NEXT	;JIF WE HAVE
	POP	D
	POP	H
	JMP	STN2	;ELSE MOVE THE NAME NOW
			;SINCE THE EXTENION IS IN
;
;
;BADNAME MESSAGE
BADNAME: DB	19,'FILENAME LENGTH > 8',0
;DEFUALT EXTENSION WITH BLANK FILE NAME
DFEXT:	DB	11,'        STC',0
;
;
;/////////////////////////////////////////////////////
;
;ROUTINE: CPMLD
;PRUP: LOAD A CPM FILE
;ENTRY: TOS=NAME
;EXIT:	TOS=DELETED
;PROCEDURE
;
	DB	5,'CPMLD'
	DW	Q$STNAME
	DW	Q$COL		;DPUSH
Q$Q$PUSH:	PUSH H		;PUSH
Q$NEXT:
	IF DEBUG
	LXI H,-(SSTACK+1)
	DAD SP
	JC STKE1
	LXI H,-SSTKE
	DAD SP
	JNC STKE2
	ENDIF
	LHLD Q$I		;NEXT
	INX H
	INX H
	SHLD Q$I
	MOV E,M
	INX H
	MOV D,M
NEXT1:	MOV H,D
	MOV L,E
	DCX H
	MOV A,M
	DCX H
	MOV L,M
	MOV H,A
	PCHL

	IF DEBUG
STKE1:	LXI H,SERM1
	JMP ERROR
STKE2:	LXI H,SERM2
	JMP ERROR
SERM1:	DB 11,'STACK EMPTY'
SERM2:	DB 10,'STACK FULL'
	ENDIF
;
;
;TTY INPUT ROUTINE (JUMPS TO ADDRESS IN Q$TYI)
;
;	CALL TTYIN
;	CHARACTEMOV M,E
	INX H
	MOV M,D
	JMP Q$SEMI

	DB 2,'()',0,0,0		;()
;LINK TO CPM WORDS IF CPM=-1
	IF CPM
	DW Q$CPMLD
	ENDIF
;
;ELSE THIS WILL BE THE END OF THE DICTIONARY
	IF NOT CPM
	DW 0
	ENDIF
;
	DW $+2
LIT:	LHLD Q$I		;INCREMENT .I BY 2
	INX H
	INX H
	SHLD Q$I
ATPUS:	MOV E,M		;@PUSH
	INX H
	MOV D,M
PUSHD:	PUSH D		;PUSHD
	JMP Q$NEXT

	DB 3,'S()',0,0		;S()
	DW LIT
	DW $+2
SLIT:	LHLD Q$I
	INX H
	INX H
	MVI D,0
	MOV E,M
	PUSH H
	DAD D
	SHLD Q$I
	JMP Q$NEXT

	DB 5,'ABORT'	;ABORTHL
	XCHG
	LHLD Q$Q$D	;DICTIONARY POINTER
	DAD D
	RNC
	LXI H,DER2	;DICTIONARY FULL
	JMP ERROR

DER2:	DB 15,'DICTIONARY FULL'

;TEST FOR COMPILE BUFFER FULL
CBF:	LHLD Q$C		;COMPILE BUFFER PTR
	LXI D,-KBUF	;START OF LINE BUFFER
	DAD D
	RNC
	LXI H,CER2	;COMPILE BUFFER FULL
	JMP ERROR

CER2:	DB 19,'COMPILE BUFFER FULL'

	ENDIF
;
;
;
Q$MHL:	DCX H	;-HL
Q$NHL:	MOV A,H		;NOTHL
	CMA
	MOV H,A
	MOV A,L
	CMA
	MOV L,A
Q$AB:	RET		;DEFAULT ABORT ROUTINE

;MULTIPLY ROUTINE
;MULTIPLIES (HL) 
	INX H
	MOV D,M
	DCX H
	DAD D
	SHLD Q$I
	JMP Q$NEXT

	DB 4,'(IF)',0		;(IF)
	DW Q$ELSE
	DW $+2
Q$IF:	POP H
	MOV A,H
	ORA L
	JZ Q$ELSE
	LHLD Q$I
	INX H
	INX H
	SHLD Q$I
	JMP Q$NEXT

	DB 1,'.',0,0,0,0	;.
	DW Q$IF
	DW $+2
PERIO:	LHLD Q$Q$D
	JMP Q$Q$PUSH

	DB 5,'STATE'		;STATE
	DW PERIO
	DW Q$CONS
STATE:	DW Q$STATE
;
;
;OUTPUT A CHARACTER TO TTY
;
;	A	ASCII CHARACTER CODE
;	CALL Q$TTO
;
;OUTPUT A CR TO TTY
;
;	CALL Q$CR
;
;OUTPUT A CR IF COLUMN NON-ZERO
;
;	CALL Q$IFCR

Q$IFCR:	LDA Q$COLU
	ORA A
	RZ
Q$CR:	MVI A,15Q
Q$TTO:	LXI H,Q$COLU	;INCREMENT COLUMN
	INR M

	IF NOT TABS
	CPI 11Q		;TAB Q$
	JZ TTO2
	ENDIF

TTO1:	PUSH PSW	;SAVE CHARACTER
	CALL TTYOU	;OUTPUT IT
	POP PSW		;RESTORE CHARACTER
	CPI 15Q		;RETURN Q$
	RNZ		;NO, DONE
	SUB A		;RESET COLUMN TO 0
	STA Q$COLU
	MVI A,12Q	;OUTPUT A LINE FEED
	JMP TTO1

	IF NOT TABS
TTO2:	MVI A,40Q	;OUTPUT A SPACE
	CALL TTYOU
	LDA Q$COLU	;GET COLUMN #
	ANI 7		;0 MOD 8 Q$
	RZ		;YES, DONE
	MVI A,11Q	;NO, INC
	SHLD Q$T1
	LHLD Q$V		;VOCABULARY STACK PTR
LOOK0:	SHLD Q$T3
	LXI D,-(VSTACK)
	DAD D
	MOV A,H
	ORA L
	JZ Q$Q$PUSH	;YES, LOSE
	LHLD Q$T3
	MOV E,M
	INX H
	MOV D,M
	XCHG
	MOV E,M
	INX H
	MOV D,M
	XCHG
	MOV A,H
	ORA L
	JZ LOOK4	;EMPTY BRANCH
LOOK1:	LXI D,-10	;BACK UP TO FIRST BYTE OF NAME
	DAD D
	SHLD Q$T2
	XCHG

	LHLD Q$T1	;CHECK LENGTH BYTE
	LDAX D
	ANI 177Q	;AND OFF PRECEDENCE
	CMP M
	JNZ LOOK3	;LENGTH BYTE DIFFERENT

	MVI C,5		;CHECK NEXT 5 CHARACTERS
LOOK5:	INX D		;INCREMELL Q$BCOM
	JMP Q$NEXT

	DB 1,',',0,0,0,0	;,
	DW BCOMA
	DW $+2
COMMA:	POP H
	CALL Q$COMM
	JMP Q$NEXT

	DB 2,'C,',0,0,0		;C,
	DW COMMA
	DW $+2
CCOMM:	POP H
	CALL Q$CCOM
	JMP Q$NEXT

Q$COMM:	PUSH H
	MOV A,L
	CALL Q$BCOM
	POP H
	MOV A,H
	CALL Q$BCOM
	RET

Q$BCOM:	LHLD Q$Q$D
	MOV M,A
	INX H
	SHLD Q$Q$D
	IF DEBUG
	CALL DICTF
	ENDIF
	RET

Q$CCOM:	PUSH H
	MOV A,L
	CALL Q$CBCO
	POP H
	MOV A,H
	CALL Q$CBCO
	RET

Q$CBCO:	LHLD Q$C
	MOV M,A
	INX H
	SHLD Q$C
	IF DEBUG
	CALL RDL10
	CPI 14Q		;FF
	JZ RDL10
RDL4:	PUSH PSW	;ECHO CHARACTER
	CALL Q$TTO
	MVI A,0FFH	;SET BUFFER MODIFIED FLAG TO -1
	STA Q$T1
	POP PSW
	CALL OCH	;STORE CHAR IN BUFFER
	LXI D,-(KBUF+KSIZE)
	DAD D
	JNC RDL1
RDL5:	LXI H,RDL6	;BUFFER FULL
	JMP ERROR
RDL6:	DB 13,'LINE TOO LONG'

;PROCESS RUBOUT
RDL2:	LHLD Q$T2	;OUTPUT PTR
	LXI D,-(KBUF+1)	;START OF BUFFER
	DAD D
	MOV A,H
	ORA L
	JZ RDL1		;BUFFER EMPTY, IGNORE RUBOUT
	LHLD Q$T2	;BACK UP OUTPUT PTR
	DCX H
	SHLD Q$T2

	IF BCKSP
	MVI A,11		;BUFFER MODIFIED Q$
	ORA A
	JNZ RDL1	;YES, IGNORE LINE FEED
	CALL Q$CR	;ECHO A CR
	JMP Q$NEXT	;AND RE-EXECUTE LINE

RDL9:	LHLD Q$INBLK	;GET INBLK
	XCHG
	CALL RBLK	;GET ADDR OF BUFFER CONTAINING BLOCK
	PUSH D		;SAVE IT
	LHLD Q$INBYT	;GET INBYTE
	PUSH H		;SAVE IT
	INX H		;INCREMENT IT
	SHLD Q$INBYT
	LXI D,-BSIZE
	DAD D
	MOV A,H
	ORA L
	JNZ RDL15
	LHLD Q$INBLK	;INCREMENT INBLK
	INX H
	SHLD Q$INBLK
	LXI H,0		;RESET INBYTE
	SHLD Q$INBYT
RDL15:	POP D
	POP H
	DAD D
	MOV A,M		;GET CHARREMENT COLUMN AND DO ANOTHER SPACE
	JMP Q$TTO
	ENDIF

;TYPE A MESSAGE ON TTY
;
;	H	PTR TO STRING
;	CALL Q$MSG

Q$MSG:	MOV A,M		;GET BYTE COUNT IN A REGISTER
MSG1:	ORA A		;LENGTH = 0 Q$
	RZ		;YES, RETURN
	DCR A		;DECREMENT COUNT
	PUSH PSW	;SAVE IT
	INX H		;INCREMENT PTR
	PUSH H		;SAVE IT
	MOV A,M		;GET NEXT BYTE
	CALL Q$TTO	;TYPE IT
	POP H		;RESTORE PTR AND COUNT
	POP PSW
	JMP MSG1	;CONTINUE
;
;
;DICTIONARY LOOKUP
	DB 6,'LOOKU'	;LOOKUP
	DW STATE
	DW $+2
LOOKU:	POP H		;PTR TO STRINGNT POINTERS
	INX H
	LDAX D		;COMPARE BYTES
	CMP M
	JNZ LOOK3	;NO MATCH
	ORA A
	JZ LOOK2	;BYTES EQUAL AND ZERO
	DCR C
	JNZ LOOK5

LOOK2:	LHLD Q$T2	;MATCH
	LXI D,10
	DAD D
	PUSH H		;PUSH PTR TO ENTRY
	JMP PUSH1	;PUSH -1

LOOK3:	LHLD Q$T2	;LINK TO NEXT ENTRY
	LXI D,6
	DAD D
	MOV E,M
	INX H
	MOV D,M
	XCHG
	MOV A,H
	ORA L
	JNZ LOOK1
LOOK4:	LHLD Q$T3	;LINK IS ZERO
	DCX H		;GO TO NEXT BRANCH
	DCX H
	JMP LOOK0
;
;
	DB 2,'B,',0,0,0		;B,
	DW LOOKU
	DW $+2
BCOMA:	POP H
	MOV A,L
	CACBF
	ENDIF
	RET
;
;
	DB 6,'RDLIN'	;RDLINE
	DW CCOMM
	DW $+2
RDLIN:	LXI H,KBUF+1	;KEYBOARD BUFFER ADDRESS + 1
	SHLD Q$T2	;CURRENT OUTPUT PTR
	SHLD Q$INP	;SET INP

	SUB A		;ZERO EOL,BUFFER MODIFIED FLAG
	STA Q$EOL
	STA Q$T1
	CMA		;SET EOC TO -1
	STA Q$EOC

	LHLD Q$INBLK	;READING FROM FILE Q$
	INX H
	MOV A,H
	ORA L
	JNZ RDL9	;YES

;READING FROM TTY
RDL1:	CALL TTYIN	;GET NEXT CHAR
	CPI 12Q		;LINE FEED
	JZ RDL8
	CPI 177Q
	JZ RDL2		;RUBOUT
	ORA A
	JZ RDL3		;NULL
	CPI 15Q		;CR
	JZ 0Q	;ECHO BACKSPACE, SPACE, BACKSPACE
	CALL Q$TTO
	MVI A,40Q
	CALL Q$TTO
	MVI A,10Q
	CALL Q$TTO
	ENDIF

	IF NOT BCKSP
	MVI A,137Q	;ECHO _
	CALL Q$TTO
	ENDIF

	JMP RDL1

;PROCESS NULL
RDL3:	LXI H,KBUF+1	;RESET OUTPUT PTR
	SHLD Q$T2
;PROCESS CR OR FF
RDL10:	CALL Q$CR	;ECHO A CR
RDL11:	SUB A		;OUTPUT A NULL TO LINE BUFFER
	LHLD Q$T2
	MOV M,A
	LXI D,-(KBUF+1)	;COMPUTE BYTE COUNT
	DAD D
	MOV A,L
	STA KBUF	;STORE IN 1ST BYTE OF LINE BUFFER
	JMP Q$NEXT

;PROCESS LINE FEED
RDL8:	LDA Q$T FROM FILE
;
;**********************************
;
; THIS CHECK FOR LF IS ADDED BY WINK SAVILLE SO 
;   FILES MADE UNDER CPM WHICH WILL HAVE LF IN THEM WILL WORK
;
;
	IF CPM
;
	CPI 0AH		;CHECK FOR A LINE FEED
	JZ RDL9		;JIF LF
			  ;IGNORE LINE FEED
	ENDIF
;
;
;***********************************
;
	CPI 15Q		;CR
	JZ RDL11
	CPI 14Q		;FF
	JZ RDL11
	CPI 4		;EOF Q$
	JZ RDL12	;YES, ERROR
	CALL OCH	;STORE CHAR IN BUFFER
	LXI D,-(KBUF+KSIZE)
	DAD D
	JNC RDL9
	JMP RDL5	;LINE TOO LONG

RDL12:	LXI H,RDL13	;END OF FILE
	JMP ERROR
RDL13:	DB 3,'EOF'

;OUTPUT A CHARACTER TO LINE BUFFER
OCH:	LHLD Q$T2
	MOV M,A
	INX H
	SHLD Q$T2
	RET

;
;
	DW $+2
UNDEF:	POP H	;WAS IF A LITERAL Q$
	MOV A,H
	ORA L
	JNZ Q$NEXT	;YES, OK
	LXI H,UND1
ERROR:	LXI SP,SSTACK	;RESET PARAMETER STACK POINTER
	PUSH H		;PUSH PTR TO STRING
	LXI H,RSTACK	;RESET RETURN STACK POINTER
	SHLD Q$R
	LXI H,LSTACK	;RESET LOOP STACK POINTER
	SHLD Q$Q$L
	JMP ERR		;EXECUTE ERROR HANDLER

UND1:	DB 9,'UNDEFINED'

	JMP ABORT	;ABORT
;
;
	DB 4,'UNIT',0		;UNIT
	DW ERRM0
	DW Q$CONS
UNIT:	DW Q$UNIT

	IF DISK
SETUP:
;	MOV A,L		;TEST FOR ILLEGAL BLOCK #
;	SUI NBLKS AND 0FFH
;	MOV A,H
;	SBI NBLKS/100H
;	JNC IBN		;ILLEGAL BLOCK #
	LXI B,1		;SET BLOCK COUNT TO 1
	RET

;IBN:	LXI H,IBNM
;	JMP ERROR

WRERC:	CALL SETUP
Q$WRERC:	CALL DSKOU
	RZ		;NO ERRORS
	CPI 4		;WRITE PROTECTED Q$
	JNZ RDER1	;NO, CHECK FOR OTHER ERRORS
	LXI H,WRER1	;WRITE PROTECTED
	JMP ERROR

RDERC:	CALL SETUP
Q$RDERC:	CALL DSKIN
	 TERR2
	DW TERR3
	DW TERR4
	DW TERR5
	DW TERR6
	DW TERR7
	DW TERR8
	DW TERR9
	DW TERRA
	DW TERRB

TERR1:	DB 14,'TAPE NOT READY'
TERR2:	DB 20,'TAPE WRITE PROTECTED'
TERR3:	DB 22,'READ AFTER WRITE ERROR'
TERR4:	DB 13,'READ OVERFLOW'
TERR5:	DB 15,'POSTAMBLE ERROR'
TERR6:	DB 11,'SHORT BLOCK'
TERR7:	DB 10,'LONG BLOCK'
TERR8:	DB 3,'EOT'
TERR9:	DB 3,'BOT'
TERRA:	DB 14,'CHECKSUM ERROR'
TERRB:	DB 12,'NO SUCH TAPE'
	ENDIF
;
;
	DB 6,'NEWES'	;NEWEST
	DW UNIT
	DW Q$CONS
NEWQ$:	DW NEWEST

;	 READ IN BLOCK
	LHLD BUFP
	SHLD PREV
	XCHG
	SHLD BUFP
	MOV E,M		;GET BLOCK #
	INX H
	MOV D,M
	LHLD BLKN	;COMPARE WITH REQUESTED BLOCK #
	MOV A,H
	CMP D
	JNZ BLK2	;NO
	MOV A,L
	CMP E
	JNZ BLK2	;NO
BLK6:	LHLD BUFP	;RELINK BCT'S
	LXI D,4
	CALL LDX
	PUSH D		;SAVE LINK OF CURRENT BCT
	LHLD NEWEST	;RESET LINK OF CURRENT BCT TO NEWEST
	XCHG
	LHLD BUFP
	LXI B,4
	CALL STX
	LHLD BUFP	;SET NEWEST TO CURRENT BCT
	SHLD NEWEST
	LHLD PREV	;STORE SAVED LINK IN LINK OF PREVIOUS BCT
	POP D
	LXI B,
	PUSH D
	LHLD BUFP	;GET BUFFER ADDR
	LXI D,2
	CALL LDX
	POP H
	CALL WRERC	;WRITE IT BACK OUT
	LHLD BUFP	;CLEAR THE MODIFIED FLAG
	LXI D,0
	LXI B,6
	CALL STX
	RET		;RETURN

	DB 6,'RBLOC'	;RBLOCK
	DW NEWQ$
	DW $+2
RBLOC:	POP D		;GET BLOCK #
	LDA Q$UNIT	;ADD IN UNIT NUMBER
	ORA A
	RAL
	ORA D
	MOV D,A
	CALL RBLK
	JMP PUSHD

	DB 6,'WBLOC'	;WBLOCK
	DW RBLOC
	DW $+2
WBLOC:	POP D
	LDA Q$UNIT	;ADD IN UNIT NUMBER
	ORA A
	RAL
	ORA D
	MOV D,A
	CALL WBLK
	PUSH D
	JMP UPDAT

	DB 6,'U	DB 3,'ERR',0,0	;ERR
	DW RDLIN
	DW $+2
ERR:	LHLD Q$ERRM	;ERRMSG @ EXEC
EXEC:	XCHG
	JMP NEXT1

	DB 7,'ERRMS'	;ERRMSG0
	DW ERR
	DW $+2
ERRM0:	CALL Q$IFCR	;TYPE A CR IF COLUMN NON-ZERO
	POP H		;TYPE THE MESSAGE
	CALL Q$MSG
	CALL Q$CR	;TYPE A CR
	LHLD Q$Q$D	;TYPE THE LAST TOKEN
	CALL Q$MSG
	CALL Q$IFCR	;TYPE A CR IF COLUMN NON-ZERO
	LHLD Q$INBLK	;INBLK = -1 Q$
	INX H
	MOV A,H
	ORA L
	JZ ABORT	;YES, EXECUTING FROM KEYBD
	LXI H,KBUF	;NO, TYPE LINE BUFFER
	CALL Q$MSG
	CALL Q$CR	;TYPE A CR
RZ		;NO ERRORS
RDER1:	LXI H,RDER2	;CRC ERROR
	JMP ERROR

WRER1:	DB 20,'DISK WRITE PROTECTED'
RDER2:	DB 10,'DISK ERROR'
IBNM:	DB 15,'ILLEGAL BLOCK #'
	ENDIF

	IF NOT DISK
WRERC:	LXI B,1		;WRITE 1 BLOCK
Q$WRERC:	CALL DSKOU	;WRITE WITH ERROR CHECKING
	RZ
	JMP RDER1

RDERC:	LXI B,1		;READ 1 BLOCK
Q$RDERC:	CALL DSKIN	;READ WITH ERROR CHECKING
	RZ		;IF 0, NO ERROR
RDER1:	DCR A
	MOV E,A
	MVI D,0
	LXI H,TERRT
	DAD D
	DAD D
	MOV E,M
	INX H
	MOV D,M
	XCHG
	JMP ERROR

TERRT:	DW TERR1
	DW(D,E) BLOCK #
;	CALL RBLK (WBLK)
;	(D,E) BUFFER ADDRESS

WBLK:	MVI A,0FFH	;WBLK
	JMP BLK
RBLK:	SUB A		;RBLK
BLK:	STA FLAG
	LHLD NEWEST	;IS BLOCK THE MOST RECENTLY ACCESSED BLOCK Q$
	MOV A,E
	CMP M
	JNZ BLK1	;NO
	INX H
	MOV A,D
	CMP M
	JNZ BLK1	;NO
	INX H		;YES, RETURN BUFFER ADDR
	MOV E,M
	INX H
	MOV D,M
	RET

BLK1:	LHLD NEWEST	;SEARCH BUFFER LIST
	SHLD BUFP
	XCHG
	SHLD BLKN

BLK2:	LHLD BUFP	;GET LINK TO NEXT BCT
	LXI D,4
	CALL LDX
	MOV A,D
	ORA E
	JZ BLK3		;END OF LIST, MUST4
	CALL STX
	LHLD BUFP	;RETURN BUFFER ADDRESS
	LXI D,2
	CALL LDX
	RET

BLK3:	CALL FBUF	;FREE A BUFFER
	LDA FLAG	;RBLOCK Q$
	ORA A
	JNZ BLK7	;NO
	LHLD BUFP	;READ IN BLOCK
	LXI D,2
	CALL LDX
	LHLD BLKN
	CALL RDERC
BLK7:	LHLD BLKN	;STORE BLOCK # IN BCT
	XCHG
	LHLD BUFP
	MOV M,E
	INX H
	MOV M,D
	JMP BLK6	;RELINK BCT'S

FBUF:	LHLD BUFP	;REEE A BUFFER
	LXI D,6		;GET MODIFIED FLAG
	CALL LDX
	MOV A,D
	ORA E
	RZ		;NOT MODIFIED, RETURN
	LHLD BUFP	;GET BLOCK #
	MOV E,M
	INX H
	MOV D,M
PDAT'	;UPDATE
	DW WBLOC
	DW $+2
UPDAT:	LHLD NEWEST	;SET MODIFIED FLAG ON CURRENT BCT
	LXI D,-1
	LXI B,6
	CALL STX
	JMP Q$NEXT

	DB 5,'FLUSH'	;FLUSH
	DW UPDAT
	DW $+2
FLUSH:	LHLD NEWEST	;FREE ALL BUFFERS
FLSH1:	SHLD BUFP
	CALL FBUF	;FREE A BUFFER
	LHLD BUFP	;LINK TO NEXT BCT
	LXI D,4
	CALL LDX
	MOV A,D
	ORA E
	JZ Q$NEXT	;DONE
	XCHG		;DO ANOTHER ONE
	JMP FLSH1

	DB 4,'EBUF',0	;EBUF
	DW FLUSH
	DW $+2
EBUF:	LHLD NEWEST	;SET ALL BLOCK NUMBERS TO -1
EBUF1:	SHLD BUFP
	MVI M,0FFH
	INX H
	MVI M,0FFH
	DCX H
	LXI D,0
	LXI B,6
	CALL STX
	LHLD BUFP	;LINK TO NEXT BCT
	LXI D,4
	CALL LDX
	MOV A,D
	ORA E
	JZ Q$NEXT	;DONE
	XCHG		;DO ANOTHER ONE
	JMP EBUF1

;INDEXED LOAD
;	(DE) OFFSET
;	(HL) BASE ADDRESS
;	CALL LDX
;	(DE) DATA

LDX:	DAD D
	MOV E,M
	INX H
	MOV D,M
	RET

;INDEXED STORE
;	(BC) OFFSET
;	(DE) DATA
;	(HL) BASE ADDRESS
;	CALL STX

STX:	DAD B
	MOV M,E
	INX H
	MOV M,D
	RET
;
;
;GET NEXT WORD FROM INPUT STREAM
;
;ON ENTRY,
;Q$INP CONTAINS INPUT POIN EBUF
	DW $+2
WORD:	LDA Q$EOL	;ALREADY AT END OF LINE Q$
	ORA A
	JNZ PUSH1	;YES, RETURN -1
	LXI B,0920H	;SET TAB,SPACE AS DELIMITERS (IN (B,C))
	LHLD Q$Q$D	;(D,E) IS OUTPUT PTR
	INX H		;SKIP LENGTH BYTE
	XCHG
	LHLD Q$INP	;(H,L) IS INPUT PTR
WORD3:	MOV A,M		;GET NEXT INPUT CHAR
	INX H
	ORA A
	JZ WORD6	;NULL, END OF LINE
	CMP B		;DELIMITER Q$
	JZ WORD3	;YES, IGNORE
	CMP C
	JZ WORD3	;YES, IGNORE
	CPI 42Q		;" Q$
	JZ WORD9
	CPI 134Q	;\ Q$
	JNZ WORD4
WORD9:	MOV B,A		;RESET DELIMITERS
	MOV C$Q$PUSH

WORD6:	MVI A,0FFH	;SET EOL TO -1
	STA Q$EOL
WORD7:	DCX H		;DECREMENT INPUT PTR
	JMP WORD8
;
;
;LITERAL PROCESSOR

	DB 7,'LITER'	;LITERAL
	DW WORD
	DW Q$COLN
LITER:	DW PERIO
	DW ILITE
	DW Q$IF
	DW LIT1-2-$
	DW LIT
	DW LIT
	DW CCOMM
	DW CCOMM
	DW PUSH1
	DW Q$SEMI

LIT1:	DW PERIO
	DW SLITE
	DW Q$SEMI

	DB 8,'ILITE'	;ILITERAL
	DW LITER
	DW $+2
ILITE:	POP H		;POP INPUT POINTER
	INX H
	SHLD Q$T3	;SET INPUT PTR
	LXI H,0		;ZERO SIGN,VALUE
	SHLD Q$T4
	SHLD Q$T5

	CALL L PUSH0	;OVERFLOW
	LDA Q$T1
	MOV L,A
	MVI H,0
	DAD D
	SHLD Q$T5	;SET NEW VALUE
	JMP ILIT1

ILIT4:	LHLD Q$T4	;GET SIGN
	MOV A,H
	ORA L
	LHLD Q$T5	;GET VALUE
	CM Q$MHL		;NEGATE IF SIGN NON-ZERO
	PUSH H		;PUSH RESULT
	JMP PUSH1	;PUSH -1

	DB 8,'SLITE'	;SLITERAL
	DW ILITE
	DW $+2
SLITE:	POP H		;POP INPUT POINTER
	INX H
	SHLD Q$T3	;SET INPUT PTR
	CALL LITG	;GET 1ST CHAR
	CPI 47Q		;'
	JZ SLIT1	;STRING LITERAL
	CPI 42Q		;"
	JZ SLIT1	;STRING LITERAL
	CPI 134Q	;\
	JNZ PUSH0	;ILLEGAL STRINGH0	;ILLEGAL DIGIT
	CPI 70Q		;8
	JP PUSH0	;ILLEGAL DIGIT
	SUI 60Q		;CONVERT TO VALUE
	MOV B,A
	LDA Q$T2		;MULTIPLY VALUE BY 8 AND ADD DIGIT
	RLC
	RLC
	RLC
	ADD B
	JMP SLIT5

SLIT6:	LDA Q$T2		;RETURN OCTAL VALUE
	JMP SLIT3

SLIT7:	CALL Q$CBCO	;OUTPUT FINAL NULL
	JMP PUSH1	;EXIT

LITG:	LHLD Q$T3	;GET NEXT INPUT CHAR
	MOV A,M
	INX H
	SHLD Q$T3
	RET

;
	IF DEBUG
	DB 6,'ERRCH'	;ERRCHK
	DW SLITE
	DW $+2
ERRCH:	CALL DICTF
	CALL CBF

	LHLD Q$V		;VOCABULARY STACK PTR
	XCHG
	LXI H,-VSTER
;
;ON EXIT,
;Q$INP IS UPDATED
;TOKEN IS AT END OF DICTIONARY (NULL TERMINATED)
;END-OF-LINE FLAG IS ON STACK
;
;DELIMITER IS SPACE OR TAB UNLESS FIRST CHARACTER IS " OR \
;IN WHICH CASE SCANNING CONTINUES UNTIL NEXT " OR \
;
;IF END-OF-LINE FLAG IS SET ON ENTRY, WORD RETURNS IMMEDIATELY
;SCANNING STOPS UNCONDITIONALLY ON A NULL IN THE INPUT STREAM
;AND THE END-OF-LINE FLAG IS SET IF THE NULL OCCURED INBETWEEN WORDS;
;OTHERWISE IT IS SET ON THE NEXT CALL TO WORD.

	DB 4,'WORD',0	;WORD
	DW,A
WORD4:	STAX D		;OUTPUT CHARACTER
	INX D
	MOV A,M		;GET NEXT INPUT CHARACTER
	INX H
	ORA A		;NULL Q$
	JZ WORD7	;YES, END OF LINE
	CMP B		;DELIMITER Q$
	JZ WORD8	;YES, STOP
	CMP C		;DELIMITER Q$
	JNZ WORD4	;NO, GET MORE CHARACTERS
WORD8:	SHLD Q$INP	;UPDATE INPUT PTR
	SUB A		;OUTPUT A NULL AT END OF STRING
	STAX D
	LHLD Q$Q$D	;COMPUTE LENGTH OF WORD
	CALL Q$MHL
	DAD D
	MOV A,L
	DCR A
	LHLD Q$Q$D	;STORE IN LENGTH BYTE
	MOV M,A
	LDA Q$EOL	;PUSH END OF LINE FLAG
	MOV L,A
	MOV H,A
	JMP QITG	;GET NEXT CHAR
	CPI 53Q		;"+" Q$
	JZ ILIT1	;IGNORE
	CPI 55Q		;"-" Q$
	JNZ ILIT2	;NO
	LXI H,-1	;SET SIGN FLAG
	SHLD Q$T4
ILIT1:	CALL LITG	;GET NEXT CHAR
ILIT2:	ORA A		;END OF LITERAL Q$
	JZ ILIT4	;YES, DONE
	CPI 60Q		;TEST FOR LEGAL DIGIT
	JC PUSH0	;ILLEGAL
	CPI 72Q
	JC ILIT3
	CPI 101Q
	JC PUSH0	;ILLEGAL
	SUI 7
ILIT3:	SUI 60Q
	LHLD Q$RADIX
	CMP L
	JNC PUSH0	;ILLEGAL
	STA Q$T1
	LHLD Q$RADIX	;MULTIPLY VALUE BY RADIX AND ADD DIGIT
	XCHG
	LHLD Q$T5
	CALL Q$MUL
	MOV A,H
	ORA L
	JNZ LITERAL
SLIT1:	LXI H,SLIT	;OUTPUT S()
	CALL Q$CCOM
	LHLD Q$C		;SAVE PTR TO START OF LITERAL
	SHLD Q$T1
	SUB A		;ZERO LENGTH BYTE
	CALL Q$CBCO
SLIT2:	CALL LITG	;GET NEXT CHAR
	ORA A
	JZ SLIT7	;END OF STRING LITERAL
	CPI 46Q		;&
	JZ SLIT4	;START OF OCTAL INSERT
SLIT3:	CALL Q$CBCO	;OUTPUT CHARACTER
	LHLD Q$T1	;INCREMENT LENGTH
	INR M
	JMP SLIT2

SLIT4:	SUB A		;INITIALIZE VALUE TO 0
SLIT5:	STA Q$T2
	CALL LITG	;GET NEXT CHAR
	CPI 46Q		;&
	JZ SLIT6	;END OF OCTAL NUMBER
	CPI 60Q		;0
	JM PUSTACK-2	;START OF VOCABULARY STACK + 2
	DAD D
	JNC ERRC1
	LXI H,-LSTACK
	DAD D
	JC ERRC2

	LHLD Q$Q$L	;LOOP STACK PTR
	XCHG
	LXI H,-LSTACK	;START OF LOOP STACK
	DAD D
	JNC ERRC3
	LXI H,-RSTACK	;START OF RETURN STACK
	DAD D
	JC ERRC4
	JMP Q$NEXT

ERRC1:	LXI H,VSTACK+2	;RESET VOCABULARY STACK PTR
	SHLD Q$V
	LXI H,VER1	;VOCABULARY STACK EMPTY
	JMP ERROR
ERRC2:	LXI H,VER2	;VOCABULARY STACK FULL
	JMP ERROR
ERRC3:	LXI H,LER1	;LOOP STACK EMPTY
	JMP ERROR
ERRC4:	LXI H,LER2	;LOOP STACK FULL
	JMP ERROR

VER1:	DB 22,'VOCABULARY STACK EMPTY'
VER2:	DB 21,'VOCABULARY STACK FULL'
LER1:	DB 16,'LOOP STACK EMPTY'
LER2:	DB 15,'LOOP STACK FULL'
	ENDIF

	DW Q$COLN
COMPI:	DW WORD		;GET NEXT WORD FROM INPUT STREAM
	DW Q$IF
	DW COMP1-2-$
	DW Q$SEMI	;END OF LINE, RETURN

COMP1:	DW PERIO	;DO A DICTIONARY LOOKUP
	DW LOOKU
	DW Q$IF
	DW COMP2-2-$
	DW Q$COMP	;FOUND, COMPILE OR EXECUTE IT
	DW Q$ELSE
	DW COMPI-2-$

COMP2:	DW EXLIT	;NOT FOUND, MAYBE A LITERAL
	DW UNDEF
	DW Q$ELSE
	DW COMPI-2-M0:	LHLD Q$INBLK	;EXECUTING A FILE Q$
	INX H
	MOV A,H
	ORA L
	JNZ Q$NEXT	;YES, NO PROMPT
	CALL Q$IFCR	;TYPE A CR IF COLUMN NON-ZERO
	LDA Q$CHECK	;TYPE CHECK
	CALL Q$TTO
	MVI A,76Q	;TYPE > 
	CALL Q$TTO
	MVI A,40Q	;TYPE SPACE
	CALL Q$TTO
	JMP Q$NEXT	;RETURN

	DW Q$COLN
GO:	DW Q$GO1
GO1:	DW EXPRO
GO8:	DW RDLIN
	DW COMPI
	DW Q$GO2
	DW Q$IF
	DW GO1-2-$
	DW LIT
	DW Q$SEMI
	DW CCOMM
	DW EXCBUF
	IF DEBUG
	DW ERRCH
	ENDIF
	DW Q$ELSE
	DW GO-2-$

	DW $+2
EXPRO:	LHLD Q$PROM	;EXECUTE @ P 5,'ENTER'	;ENTER
	DW PROM0
	DW $+2
ENTER:	LHLD Q$ENT
	JMP EXEC

	DB 4,'ENT0',0	;ENT0
	DW ENTER
	DW $+2
ENT0:	LHLD Q$Q$D	;ZERO 6 BYTES AT END OF DICTIONARY
	MVI A,6
ENT1:	MVI M,0
	INX H
	DCR A
	JNZ ENT1

	POP B		;COPY NAME ONTO END OF DICTIONARY
	MVI A,6		;6 BYTES
	STA Q$T1
ENT2:	LDAX B		;MOVE NAME AND LENGTH
	ORA A
	JZ ENT3		;FILL WITH NULLS
	INX B
ENT3:	CALL Q$BCOM
	LXI H,Q$T1	;DONE Q$
	DCR M
	JNZ ENT2	;NO

			;LINK NEW ENTRY INTO DICTIONARY
	LHLD Q$CURR	;GET PTR TO PREVIOUS E'	;STOIC<
	DW ASSEM
	DW Q$BRAN
STOIC:	DW Q$STOI

	DB 2,'<L',0,0,0	;<L
	DW STOIC
	DW $+2
LPUSH:	POP H
	CALL Q$LPUSH
	JMP Q$NEXT

	DB 2,'L>',0,0,0	;L>
	DW LPUSH
	DW $+2
LPOP:	CALL Q$LPOP
	JMP Q$Q$PUSH

	DB 4,'LOAD',0	;LOAD
	DW LPOP
	DW $+2
LOAD:	LHLD Q$INBLK
	CALL Q$LPUSH
	LHLD Q$INBYT
	CALL Q$LPUSH
	POP H
	SHLD Q$INBLK
	LXI H,0
	SHLD Q$INBYT
	JMP Q$NEXT

	DB 2,';F',0,0,0	;;F
	DW LOAD
	DW $+2
Q$SCLF:	CALL Q$LPOP
	SHLD Q$INBYT
	CALL Q$LPOP
	SHLD Q$INBLK
	JMP Q$NEXT

;POPX H
	MOV M,D
	RET		;RETURN

	DB 11,'DEFIN'	;DEFINTIONS
	DW Q$SCLF
	DW $+2
DEFIN:	LHLD Q$V
	MOV E,M
	INX H
	MOV D,M
	XCHG
	SHLD Q$CURR
	JMP Q$NEXT

	DB 1,'>',0,0,0,0	;>
	DW DEFIN
	DW $+2
REVER:	LHLD Q$V
	DCX H
	DCX H
	SHLD Q$V
	JMP Q$NEXT

	DB 201Q,'^',0,0,0,0	;^
	DW REVER
	DW $+2
UPARR:	SUB A
	STA Q$EOC
	JMP Q$NEXT

	DB 201Q,'%',0,0,0,0	;%
	DW UPARR
	DW $+2
PERC:	MVI A,0FFH
	STA Q$EOL
	JMP Q$NEXT
;
;
	DB 201Q,':',0,0,0,0	;:
	DW PERC
	DW $+2
COLON:	LDA Q$CHECK
	CPI $

	DW $+2
EXLIT:	LHLD Q$LIT
	JMP EXEC

	DW $+2
Q$COMP:	POP D		;PTR TO PARAMETER FIELD OF WORD
	LXI H,-10	;BACK UP TO PRECEDENCE FIELD
	DAD D
	MOV A,M		;GET 1ST BYTE OF ENTRY
	ORA A
	JM NEXT1	;PRECEDENCE BIT SET, EXECUTE IT
	LDA Q$STATE	;PRECEDENCE BIT ZERO, CHECK STATE
	ORA A
	JP NEXT1	;STATE ZERO, EXECUTE IT
	XCHG		;STORE ADDR OF PARAMETER FIELD IN COMPLILE BUFFER
	CALL Q$CCOM
	JMP Q$NEXT

	DB 7,'PROMP'	;PROMPT0
	IF DEBUG
	DW ERRCH
	ENDIF
	IF NOT DEBUG
	SLITE
	ENDIF
	DW $+2
PROROMPT
	JMP EXEC

	DW $+2
EXCBUF:	LXI D,CBUF+2	;EXECUTE COMPILE BUFFER
	JMP NEXT1

	DW $+2
Q$GO1:	MVI A,80H	;SET STATE TO 80 HEX
	STA Q$STATE
	MVI A,60Q	;SET CHECK TO "0"
	STA Q$CHECK
	LXI H,CBUF	;RESET .C TO START OF COMPILE BUFFER
	SHLD Q$C
	LXI H,Q$COLN	;OUTPUT (:) TO COMPILE BUFFER
	CALL Q$CCOM
	JMP Q$NEXT

	DW $+2
Q$GO2:	LDA Q$EOC	;END OF COMMAND Q$
	ORA A
	JZ PUSH0	;NO, RETURN 0
	LDA Q$CHECK	;CHECK = "0" Q$
	CPI 60Q
	JNZ PUSH0	;NO, RETURN 0
	JMP PUSH1	;YES, RETURN -1
;
;
	DBNTRY
	MOV E,M
	INX H
	MOV D,M
	XCHG
	CALL Q$COMM	;STORE IT IN LINK FIELD

	LHLD Q$Q$D	;STORE $+2 IN CODE ADDRESS FIELD
	INX H
	INX H
	CALL Q$COMM

	LHLD Q$Q$D	;RESET CURRENT TO .
	XCHG
	LHLD Q$CURR
	MOV M,E
	INX H
	MOV M,D
	JMP Q$NEXT	;RETURN
;
;
Q$BRAN:	XCHG		;PUSH @(DE) ON VOCABULARY STACK
	MOV E,M
	INX H
	MOV D,M
BRAN1:	LHLD Q$V
	INX H
	INX H
	SHLD Q$V
	MOV M,E
	INX H
	MOV M,D
	JMP Q$NEXT

	DB 10,'ASSEM'	;ASSEMBLER<
	DW ENT0
	DW Q$BRAN
ASSEM:	DW Q$ASSE

	DB 6,'STOIC A NUMBER OFF THE LOOP STACK
;
;	CALL Q$LPOP
;	HL CONTAINS NUMBER

Q$LPOP:	LHLD Q$Q$L	;LOOP STACK PTR
	MOV E,M		;GET TOP OR STACK INTO DE
	INX H
	MOV D,M
	DCX H
	DCX H		;DECREMENT LOOP STACK PTR BY 2
	DCX H
	SHLD Q$Q$L
	XCHG		;MOVE RESULT TO HL
	RET		;RETURN

;PUSH A NUMBER ON THE LOOP STACK
;
;	HL CONTAINS NUMBER
;	CALL Q$LPUSH

Q$LPUSH:	XCHG		;MOVE NUMBER TO DE
	LHLD Q$Q$L	;INCREMENT LOOP STACK PTR BY 2
	INX H
	INX H
	SHLD Q$Q$L
	MOV M,E		;STORE NUMBER ON END OF RETURN STACK
	IN60Q
	JNZ CHERR
	INR A
	STA Q$CHECK
	LXI H,ENTER
	CALL Q$CCOM
	LXI H,COLN1
	CALL Q$CCOM
	LHLD Q$C
	PUSH H
	LXI H,0
	CALL Q$CCOM
	JMP Q$NEXT

CHERR:	LXI H,CHERM
	JMP ERROR
CHERM:	DB 12,'SYNTAX ERROR'

Q$COLN:	LHLD Q$I		;(;)
	XCHG
	DCX H		;SET .I TO W-2
	DCX H
	SHLD Q$I
	LHLD Q$R		;INCREMENT RETURN STACK PTR BY 2
	INX H
	INX H
	SHLD Q$R
	MOV M,E		;STORE .I ON END OF RETURN STACK
	INX H
	MOV M,D
	JMP Q$NEXT

	DW $+2
COLN1:	LHLD Q$I
	INX H
	INX H
	MOV E,M
	INX H
	MOV D,M
	INX H
COLN2:	PUSH H
	PUSH D
	MOV A,M
	CALL Q$BCOM
	POP D
	POP H
	INX H
	DCX D
	MOV A,D
	ORA E
	JNZ COLN2
	DCX H
	DCX H
	SHLD Q$I
	LHLD Q$CURR
	MOV E,M
	INX H
	MOV D,M
	DCX D
	DCX D
	LXI H,Q$COLN
	XCHG
	MOV M,E
	INX H
	MOV M,D
	JMP Q$NEXT

	DB 205Q,'CODE<'		;CODE<
	DW COLON
	DW Q$COLN
CODE:	DW LIT
	DW ENTER
	DW CCOMM
	DW ASSEM
	DW Q$SEMI

	DB 201Q,';',0,0,0,0	;;
	DW CODE
	DW $+2
SCOL:	CALL Q$SCOL	;TERMINATE COLON DEFINITION
	LXI H,Q$SEMI	;OUTPUT (;) TO COMPILE BUFFER

	DB 8,'CONST'	;CONSTANT
	DW SCLCD
	DW Q$COLN
CONST:	DW ENTER
	DW COMMA
	DW Q$SCOD
Q$CONS:	XCHG		;(CONSTANT)
	JMP ATPUS
;
;
	DB 4,'PUSH',0		;PUSH
	DW 0
	DW Q$CONS
PUSHQ$:	DW Q$Q$PUSH

	DB 4,'NEXT',0		;NEXT
	DW PUSHQ$
	DW Q$CONS
NEXTQ$:	DW Q$NEXT

	DB 5,'DPUSH'		;DPUSH
	DW NEXTQ$
	DW Q$CONS
DPSHQ$:	DW Q$DPUSH

	DB 5,'@PUSH'		;@PUSH
	DW DPSHQ$
	DW Q$CONS
ATPSQ$:	DW ATPUS

	DB 5,'PUSHD'		;PUSHD
	DW ATPSQ$
	DW Q$CONS
PUSDQ$:	DW PUSHD

	DB 5,'0PUSH'		;0PUSH
	DW PUSDQ$
	DW Q$ERROR
	DW BRANQ$
	DW Q$CONS
ERRQ$:	DW ERROR

	DB 5,'(TTI)'		;(TTI)
	DW ERRQ$
	DW Q$CONS
TTIQ$:	DW TTYIN

	DB 5,'(TTO)'		;(TTO)
	DW TTIQ$
	DW Q$CONS
TTOQ$:	DW Q$TTO

	DB 6,'(READ'		;(READ)
	DW TTOQ$
	DW Q$CONS
READQ$:	DW Q$RDERC

	DB 7,'(WRIT'		;(WRITE)
	DW READQ$
	DW Q$CONS
WRITQ$:	DW Q$WRERC

	DB 8,'(RBLO'		;(RBLOCK)
	DW WRITQ$
	DW Q$CONS
RBLKQ$:	DW RBLK

	DB 8,'(WBLO'		;(WBLOCK)
	DW RBLKQ$
	DW Q$CONS
WBLKQ$:	DW WBLK

	DB 2,'T1',0,0,0		;T1
	DW WBLKQ$
	DW Q$CONS
T1Q$:	D CONST
	DW Q$SCOD
	LDAX D
R41:	CALL Q$BCOM
	POP H
	MOV A,L
	CALL Q$BCOM
	JMP Q$NEXT

	DB 2,'R5',0,0,0		;R5
	DW R4
	DW Q$COLN
R5:	DW CONST
	DW Q$SCOD
	CALL SH3
	JMP R41

	DB 2,'R6',0,0,0		;R6
	DW R5
	DW Q$COLN
R6:	DW CONST
	DW Q$SCOD
	CALL SH3
R61:	CALL Q$BCOM
	POP H
R62:	CALL Q$COMM
	JMP Q$NEXT

	DB 2,'R7',0,0,0		;R7
	DW R6
	DW Q$COLN
R7:	DW CONST
	DW Q$SCOD
	LDAX D
	JMP R61

	DB 2,'R8',0,0,0		;R8
	DW R7
	DW Q$COLN
R8:	DW CONST
	DW Q$SCOD
	LDAX D
	CALL Q$BCOM
	LHLD TEMPORARIES
BUFP:	DW 0
BLKN:	DW 0
FLAG:	DB 0

;START OF USER MEMORY

;VARIABLES
;
;***************
;*** WARNING ***
;***************
;
;DO NOT ADD, DELETE, OR REARRANGE THE FOLLOWING
;VARIABLES WITHOUT MAKING CORRESPONDING CHANGES
;TO THE BASIC DEFINITIONS FILE WHICH DEFINES THE
;ADDRESSES OF THESE VARIABLES.

;BYTE VARIABLES
Q$STATE:	DB 0		;STATE
Q$CHECK:	DB 0		;CHECK
Q$COLU:	DB 0		;COLUMN

;WORD VARIABLES
Q$I:	DW 0		;.I
Q$R:	DW 0		;.R
Q$Q$L:	DW 0		;.L
Q$V:	DW VSTACK+2	;.V
Q$Q$	CALL Q$CCOM
	JMP Q$NEXT

	DB 206Q,';CODE'		;;CODE<
	DW SCOL
	DW $+2
SCLCD:	CALL Q$SCOL	;TERMINATE COLON DEFINITION
	LXI H,Q$SCOD	;OUTPUT (;CODE) TO COMPILE BUFFER
	CALL Q$CCOM
	LXI D,Q$ASSE	;ASSEMBLER<
	JMP BRAN1

Q$SCOL:	LDA Q$CHECK	;DECREMENT CHECK
	DCR A
	CPI 60Q
	JNZ CHERR	;ERROR IF NOT ZERO
	STA Q$CHECK
	POP H		;OLD C.
	XTHL
	PUSH H
	CALL Q$MHL	;COMPUTE DIFFERENCE
	XCHG
	LHLD Q$C		;C.
	DAD D
	XCHG
	POP H		;OLD C.
	MOV M,E		;STORE DIFFERENCE AT OLD C.
	INX H
	MOV M,D
	RET
CONS
PUS0Q$:	DW PUSH0

	DB 6,'-1PUS'		;-1PUSH
	DW PUS0Q$
	DW Q$CONS
PUS1Q$:	DW PUSH1

	DB 3,'MUL',0,0		;MUL
	DW PUS1Q$
	DW Q$CONS
MULQ$:	DW Q$MUL

	DB 3,'-HL',0,0		;-HL
	DW MULQ$
	DW Q$CONS
MHLQ$:	DW Q$MHL

	DB 5,'(MSG)'		;(MSG)
	DW MHLQ$
	DW Q$CONS
MSGQ$:	DW Q$MSG

	DB 3,'(,)',0,0		;(,)
	DW MSGQ$
	DW Q$CONS
COMMQ$:	DW Q$COMM

	DB 4,'(B,)',0		;(B,)
	DW COMMQ$
	DW Q$CONS
BCOMQ$:	DW Q$BCOM

	DB 8,'(BRAN'		;(BRANCH)
	DW BCOMQ$
	DW Q$CONS
BRANQ$:	DW Q$BRAN

	DB 5,'ERROR'		;W Q$T1

;8080 INSTRUCTION CLASSES
	DB 2,'R0',0,0,0		;R0
	DW T1Q$
	DW Q$COLN
XR0:	DW CONST
	DW Q$SCOD
	LDAX D
	CALL Q$BCOM
	JMP Q$NEXT

	DB 2,'R1',0,0,0		;R1
	DW XR0
	DW Q$COLN
R1:	DW CONST
	DW Q$SCOD
	CALL SH3
R11:	CALL Q$BCOM
	JMP Q$NEXT

	DB 2,'R2',0,0,0		;R2
	DW R1
	DW Q$COLN
R2:	DW CONST
	DW Q$SCOD
	CALL SH3
R21:	POP H
	ADD L
	JMP R11

	DB 2,'R3',0,0,0		;R3
	DW R2
	DW Q$COLN
R3:	DW CONST
	DW Q$SCOD
	LDAX D
	JMP R21

	DB 2,'R4',0,0,0		;R4
	DW R3
	DW Q$COLN
R4:	DW Q$Q$D
	PUSH H
	LXI H,0
	JMP R62

;SHIFT TOP OF STACK 3 LEFT AND ADD BYTE ADDRESSED BY DE
;LEAVING RESULT IN A

SH3:	POP H
	XTHL
	DAD H
	DAD H
	DAD H
	LDAX D
	ADD L
	RET

;
;UNIT NUMBER
Q$UNIT:	DW 0

;BUFFER CONTROL TABLES
BCT1:	DW -1		;BLOCK #
	DW BUF1		;BUFFER ADDR
	DW BCT2		;LINK
	DW 0		;MODIFIED FLAG

BCT2:	DW -1
	DW BUF2
	DW 0
	DW 0

;I/O BUFFERS
BUF1:	DS BSIZE
BUF2:	DS BSIZE

;BUFFER HANDLER VARIABLES
NEWEST:	DW BCT1		;HEAD OF BCT LIST
PREV:	DW 0		;BUFFER STRATEGYD:	DW LASTW	;.D
Q$C:	DW 0		;.C
Q$CURR:	DW Q$STOI	;CURRENT
Q$RADIX:	DW 8		;RADIX
Q$PROM:	DW PROM0	;PROMPT
Q$ERRM:	DW ERRM0	;ERRMSG
Q$ENT:	DW ENT0		;ENT
Q$MEMO:	DW 0		;MEMORY
Q$LIT:	DW LITER	;LIT
Q$TYI:	DW Q$TTYI	;(TTYIN)
Q$TYO:	DW Q$TTYO	;(TTYOU)
Q$ABORT:	DW Q$AB		;(ABORT)

;INTERNAL VARIABLES
Q$EOC:	DB 0		;EOC
Q$EOL:	DB 0		;EOL
Q$ASSE:	DW R8		;ASSEMBLER<
Q$STOI:	DW CONST	;STOIC<
Q$INP:	DW 0		;INP
Q$INBYT:	DW 0		;INBYTE
Q$INBLK:	DW 0		;INBLK

Q$T1:	DW 0		;TEMPORARIES
Q$T2:	DW 0
Q$T3:	